% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/live.R
\name{read_html_live}
\alias{read_html_live}
\title{Live web scraping (with chromote)}
\usage{
read_html_live(url)
}
\arguments{
\item{url}{Website url to read from.}
}
\value{
\code{read_html_live()} returns an R6 \link{LiveHTML} object. You can interact
with this object using the usual rvest functions, or call its methods,
like \verb{$click()}, \verb{$scroll_to()}, and \verb{$type()} to interact with the live
page like a human would.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{\link[=read_html]{read_html()}} operates on the HTML source code downloaded from the server.
This works for most websites but can fail if the site uses javascript to
generate the HTML. \code{read_html_live()} provides an alternative interface
that runs a live web browser (Chrome) in the background. This allows you to
access elements of the HTML page that are generated dynamically by javascript
and to interact with the live page by clicking on buttons or typing in
forms.

Behind the scenes, this function uses the
\href{https://rstudio.github.io/chromote/}{chromote} package, which requires that
you have a copy of \href{https://www.google.com/chrome/}{Google Chrome} installed
on your machine.
}
\examples{
\dontrun{
# When we retrieve the raw HTML for this site, it doesn't contain the
# data we're interested in:
static <- read_html("https://www.forbes.com/top-colleges/")
static |> html_element("table")

# Instead, we need to run the site in a real web browser, causing it to
# download a JSON file and then dynamically generate the html:
dynamic <- read_html_live("https://www.forbes.com/top-colleges/")
# You may need to click the cookie consent banner if it appears
dynamic$view()

# Now we can find the table
dynamic |> html_element("table")

# And extract data from it
dynamic |> 
  html_element("table") |> 
  html_table()
}
}
