% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{graph_attr<-}
\alias{graph_attr<-}
\alias{graph.attributes<-}
\title{Set all or some graph attributes}
\usage{
graph_attr(graph, name) <- value
}
\arguments{
\item{graph}{The graph.}

\item{name}{The name of the attribute to set. If missing, then
\code{value} should be a named list, and all list members
are set as attributes.}

\item{value}{The value of the attribute to set}
}
\value{
The graph, with the attribute(s) added.
}
\description{
Set all or some graph attributes
}
\examples{
g <- make_graph(~ A - B:C:D)
graph_attr(g, "name") <- "4-star"
g

graph_attr(g) <- list(
  layout = layout_with_fr(g),
  name = "4-star layed out"
)
plot(g)
}
\seealso{
Vertex, edge and graph attributes
\code{\link{delete_edge_attr}()},
\code{\link{delete_graph_attr}()},
\code{\link{delete_vertex_attr}()},
\code{\link{edge_attr}()},
\code{\link{edge_attr<-}()},
\code{\link{edge_attr_names}()},
\code{\link{graph_attr}()},
\code{\link{graph_attr_names}()},
\code{\link{igraph-attribute-combination}},
\code{\link{igraph-dollar}},
\code{\link{igraph-vs-attributes}},
\code{\link{set_edge_attr}()},
\code{\link{set_graph_attr}()},
\code{\link{set_vertex_attr}()},
\code{\link{vertex_attr}()},
\code{\link{vertex_attr<-}()},
\code{\link{vertex_attr_names}()}
}
\concept{attributes}
