% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colourInput.R
\name{updateColourInput}
\alias{updateColourInput}
\title{Change the value of a colour input}
\usage{
updateColourInput(
  session,
  inputId,
  label = NULL,
  value = NULL,
  showColour = NULL,
  palette = NULL,
  allowedCols = NULL,
  allowTransparent = NULL,
  returnName = NULL,
  closeOnClick = NULL
)
}
\arguments{
\item{session}{The \code{session} object passed to function given to \code{shinyServer}.}

\item{inputId}{The id of the colour input object.}

\item{label}{The label to set for the input object.}

\item{value}{The value to set for the input object.}

\item{showColour}{Whether to show the chosen colour as text inside the input,
as the background colour of the input, or both (default).}

\item{palette}{The type of colour palette to allow the user to select colours
from. \code{square} (default) shows a square colour palette that allows the
user to choose any colour, while \code{limited} only gives the user a
predefined list of colours to choose from.}

\item{allowedCols}{A list of colours that the user can choose from. Only
applicable when \code{palette == "limited"}. The \code{limited} palette
uses a default list of 40 colours if \code{allowedCols} is not defined. If
the colour specified in \code{value} is not in the list, the default colour
will revert to black.}

\item{allowTransparent}{If \code{TRUE}, enables a slider to choose an alpha
(transparency) value for the colour. When a colour with opacity is
chosen, the return value is an 8-digit HEX code.}

\item{returnName}{If \code{TRUE}, then return the name of an R colour instead
of a HEX value when possible.}

\item{closeOnClick}{If \code{TRUE}, then the colour selection panel will close
immediately after selecting a colour.}
}
\description{
Change the value of a colour input on the client.
}
\details{
The update function sends a message to the client, telling it to change
the settings of a colour input object.\cr
This function works similarly to the update functions provided by shiny.\cr
Any argument with \code{NULL} values will be ignored.
}
\note{
See \href{https://daattali.com/shiny/colourInput/}{https://daattali.com/shiny/colourInput/}
for a live demo.
}
\examples{
if (interactive()) {
  library(shiny)
  shinyApp(
    ui = fluidPage(
      div("Selected colour:", textOutput("value", inline = TRUE)),
      colourInput("col", "Choose colour", "red"),
      h3("Update colour input"),
      textInput("text", "New colour: (colour name or HEX value)"),
      selectInput("showColour", "Show colour",
        c("both", "text", "background")),
      checkboxInput("allowTransparent", "Allow transparent", FALSE),
      checkboxInput("returnName", "Return R colour name", FALSE),
      actionButton("btn", "Update")
    ),
    server = function(input, output, session) {
      observeEvent(input$btn, {
        updateColourInput(session, "col",
          value = input$text, showColour = input$showColour,
          allowTransparent = input$allowTransparent,
          returnName = input$returnName)
      })
      output$value <- renderText(input$col)
    }
  )
}
}
\seealso{
\code{\link[colourpicker]{colourInput}}
}
