% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{definition}
\alias{definition}
\alias{properties}
\alias{calendar}
\alias{unit}
\alias{origin}
\alias{timezone}
\alias{offsets}
\alias{resolution}
\title{Properties of a CFTime object}
\usage{
definition(t)

calendar(t)

unit(t)

origin(t)

timezone(t)

offsets(t)

resolution(t)
}
\arguments{
\item{t}{An instance of \code{CFTime}.}
}
\value{
\code{calendar()} and \code{unit()} return a character string.
\code{origin()} returns a data frame of timestamp elements with a single row
of data. \code{timezone()} returns the calendar time zone as a character
string. \code{offsets()} returns a vector of offsets or \code{NULL} if no offsets
have been set.
}
\description{
These functions return the properties of an instance of the
\link{CFTime} class. The properties are all read-only, but offsets can be added
using the \code{+} operator.
}
\section{Functions}{
\itemize{
\item \code{definition()}: The definition string of the \code{CFTime} instance.

\item \code{calendar()}: The calendar of the \code{CFTime} instance.

\item \code{unit()}: The unit of the \code{CFTime} instance.

\item \code{origin()}: The origin of the \code{CFTime} instance in timestamp elements.

\item \code{timezone()}: The time zone of the calendar of the \code{CFTime} instance as a character string.

\item \code{offsets()}: The offsets of the \code{CFTime} instance as a numeric vector.

\item \code{resolution()}: The average separation between the offsets in the \code{CFTime} instance.

}}
\examples{
t <- CFtime("days since 1850-01-01", "julian", 0:364)
definition(t)
calendar(t)
unit(t)
timezone(t)
origin(t)
offsets(t)
resolution(t)
}
