% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{mcesApply}
\alias{mcesApply}
\title{Multicore apply-like function for CellDataSet}
\usage{
mcesApply(
  X,
  MARGIN,
  FUN,
  required_packages,
  cores = 1,
  convert_to_dense = TRUE,
  ...
)
}
\arguments{
\item{X}{a CellDataSet object}

\item{MARGIN}{The margin to apply to, either 1 for rows (samples) or 2 for columns (features)}

\item{FUN}{Any function}

\item{required_packages}{A list of packages FUN will need. Failing to provide packages needed by FUN will generate errors in worker threads.}

\item{cores}{The number of cores to use for evaluation}

\item{convert_to_dense}{Whether to force conversion a sparse matrix to a dense one before calling FUN}

\item{...}{Additional parameters for FUN}
}
\value{
The result of with(pData(X) apply(exprs(X)), MARGIN, FUN, ...))
}
\description{
mcesApply computes the row-wise or column-wise results of FUN, just like esApply.
Variables in pData from X are available in FUN.
}
