% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mefisto.R
\name{get_covariates}
\alias{get_covariates}
\title{Get sample covariates}
\usage{
get_covariates(
  object,
  covariates = "all",
  as.data.frame = FALSE,
  warped = FALSE
)
}
\arguments{
\item{object}{a \code{\link{MOFA}} object.}

\item{covariates}{character vector with the covariate name(s), or numeric vector with the covariate index(es).}

\item{as.data.frame}{logical indicating whether to output the result as a long data frame, default is \code{FALSE}.}

\item{warped}{logical indicating whether to extract the aligned covariates}
}
\value{
a matrix with dimensions (samples,covariates). If \code{as.data.frame} is \code{TRUE}, a long-formatted data frame with columns (sample,factor,value)
}
\description{
Function to extract the covariates from a \code{\link{MOFA}} object using MEFISTO.
}
\examples{
# Using an existing trained model
file <- system.file("extdata", "MEFISTO_model.hdf5", package = "MOFA2")
model <- load_model(file)
covariates <- get_covariates(model)
}
