% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\name{initializeCpp}
\alias{initializeCpp}
\alias{initializeCpp,ANY-method}
\alias{initializeCpp,matrix-method}
\alias{initializeCpp,externalptr-method}
\alias{initializeCpp,dgeMatrix-method}
\alias{initializeCpp,lgeMatrix-method}
\alias{initializeCpp,dgCMatrix-method}
\alias{initializeCpp,dgRMatrix-method}
\alias{initializeCpp,lgCMatrix-method}
\alias{initializeCpp,lgRMatrix-method}
\alias{initializeCpp,SVT_SparseMatrix-method}
\alias{initializeCpp,DelayedMatrix-method}
\alias{initializeCpp,DelayedAbind-method}
\alias{initializeCpp,DelayedAperm-method}
\alias{initializeCpp,DelayedSubset-method}
\alias{initializeCpp,DelayedSetDimnames-method}
\alias{initializeCpp,DelayedUnaryIsoOpWithArgs-method}
\alias{initializeCpp,DelayedUnaryIsoOpStack-method}
\alias{initializeCpp,DelayedNaryIsoOp-method}
\title{Initialize matrix in C++ memory space}
\usage{
initializeCpp(x, ...)
}
\arguments{
\item{x}{A matrix-like object, typically from the \pkg{Matrix} or \pkg{DelayedArray} packages.
Alternatively, an external pointer from a previous call to \code{initializeCpp}, which is returned without modification.}

\item{...}{Further arguments used by specific methods.
Common arguments include:
\itemize{
\item \code{memorize}, a logical scalar indicating whether to load the representation into memory - see \code{\link{checkMemoryCache}} for details.
}}
}
\value{
An external pointer to a C++ object containing a tatami matrix.
}
\description{
Initialize a \pkg{tatami} matrix object in C++ memory space from an abstract numeric R matrix.
This object simply references the R memory space and avoids making any copies of its own, so it can be cheaply re-created when needed inside each function.
}
\details{
Do not attempt to serialize the return value; it contains a pointer to external memory, and will not be valid after a save/load cycle.
Users should not be exposed to the returned pointers; rather, developers should call \code{initialize} at the start to obtain a C++ object for further processing.
As mentioned before, this initialization process is very cheap so there is no downside from just recreating the object within each function body.
}
\examples{
# Mocking up a count matrix:
x <- Matrix::rsparsematrix(1000, 100, 0.1)
y <- round(abs(x))

stuff <- initializeCpp(y)
stuff

}
