# A description of the file, used in verbose mode
$layout_description = "Brazilian Portuguese (ABNT2) keyboard layout"

$layout = {
				"'" => { 0 => "\"", 1 => "!1¹"},
				"!" => {0 => "1¹", 1 => "2@²\"'q/"},
				"1" => { 0 => "!¹", 1 => "2@²\"'q/"},
				"q" => { 0 => "/", 1 => "12wa!@¹²?"},
				"a" => { 1 => "qwz\\|/?"},
				"z" => { 1 => "asx|\\"},
				"|" => { 0 => "\\", 1 => "az"},
				"\\" => { 0 => "|", 1 => "az"},
				"2" => { 0 => '@²', 1 => "3wq1#!³?/¹"},
				'@' => { 0 => '2²', 1 => "3wq1#!³?/¹"},
				"w" => { 0 => "?", 1 => "2@²3#³esaq/€"},
				"s" => { 1 => "w?edxza€"},
				"x" => { 1 => "zsdc"},
				"3" => { 0 => "#³", 1 => "2@²w?er4$£€"},
				"#" => { 0 => "3³", 1 => "2@²w?er4$£€"},
				"e" => { 0 => "€", 1 => "34rdsw#$³£?"},
				"€" => { 0 => "e", 1 => "34rdsw#$³£?"},
				"d" => { 1 => "erfcxs"},
				"c" => { 1 => "xdfv"},
				"4" => { 0 => "$£", 1 => "5re3%#¢€³"},
				"$" => { 0 => "4£", 1 => "%3#³er5%¢"},
				"r" => { 1 => "45tfde$%£¢€"},
				"f" => { 1 => "rtgvcd"},
				"v" => { 1 => "cfgb"},
				"5" => { 0 => "%¢", 1 => "46rt$£¬"},
				"%" => { 0 => "5¢", 1 => "46rt$£¬"},
				"¢" => { 0 => "5%", 1 => "46rt$£¬"},
				"t" => { 1 => "5%6¬ygfr"},
				"g" => { 1 => "vbhfty"},
				"b" => { 1 => "vghn"},
				"6" => { 0 => "¬", 1 => "5%ty7&"},
				"¬" => { 0 => "6", 1 => "5%ty7&"},
				"y" => { 1 => "67¬&uhgt" },
				"h" => { 1 => "yujnbg" },
				"n" => { 1 => "bhjm" },
				"7" => { 0 => "&", 1 => "6¬yu8*"},
				"&" => { 0 => "7", 1 => "6¬yu8*"},
				"u" => { 1 => "78&*ijhy"},
				"j" => { 1 => "uikmnh"},
				"m" => { 1 => "njk,<"},
				"8" => { 0 => "*", 1 => "7ui9&("},
				"*" => { 0 => "8", 1 => "7ui9&("},
				"i" => { 1 => "89*(okju"},
				"k" => { 1 => "iol,<mj"},
				"," => { 0 => "<", 1 => "mkl.>"},
				"9" => { 0 => "(", 1 => "80*)io"},
				"(" => { 0 => "9", 1 => "80*)io"},
				"o" => { 1 => "90()plki"},
				"l" => { 1 => "opç.>,<k"},
				"." => { 0 => ">", 1 => "lç;:,<"},
				">" => { 0 => ".", 1 => "lç;:,<"},
				"0" => { 0 => ")", 1 => "-_po9("},
				")" => { 0 => "0", 1 => "-_po9("},
				"p" => { 1 => "0)-_`çlo"},
				"ç" => { 1 => "p`^~:;.>l"},
				";" => { 0 => ":", 1 => "ç~^?/.>"},
				":" => { 0 => ";", 1 => "ç~^?/.>"},
				"/" => { 0 => "?", 1 => ":;^~]}º"},
				"?" => { 0 => "/", 1 => ":;^~]}º"},
				"~" => { 0 => "^", 1 => "`{[]}ªº?/:;ç"},
				"^" => { 0 => "~", 1 => "`{[]}ªº?/:;ç"},
				"`" => { 1 => "-_=+§{[~^çp"},
				"-" => { 0 => "_", 1 => "0)p`=+§"},
				"_" => { 0 => "-", 1 => "0)p`=+§"},
				"[" => { 0 => "{", 1 => "+=§`~^}]"},
				"{" => { 0 => "[", 1 => "+=§`~^}]"},
				"'" => { 0 => "\"", 1 => "!1"},
				"=" => { 0 => "+§", 1 => "-_[{`ª"},
				"+" => { 0 => "=§", 1 => "-_[{`ª"},
				"]" => { 0 => "}º", 1 => "~^[{ª?/"},
				"}" => { 0 => "]º", 1 => "~^[{ª?/"},
			}

# This is the furthest distance we are looking for as a jump + 1
# This could be calculated by the app when it starts up but that
# seems like unnecessary work as you already know it when creating
# this file.
#
# You could also chose to penalise keys further away more by giving
# them a higher score.
MAX_SCORE = 2
