register_checker("US_Area_Code_Checker")

US_area_codes = {}

US_area_codes[201] = ["NJ","N New Jersey: Jersey City, Hackensack"]
US_area_codes[202] = ["DC","Washington, D.C."]
US_area_codes[203] = ["CT","Connecticut: Fairfield County and New Haven County; Bridgeport, New Haven"]
US_area_codes[204] = ["MB","Canada: Manitoba"]
US_area_codes[205] = ["AL","Central Alabama (including Birmingham)"]
US_area_codes[206] = ["WA","W Washington state: Seattle and Bainbridge Island"]
US_area_codes[207] = ["ME","Maine"]
US_area_codes[208] = ["ID","Idaho"]
US_area_codes[209] = ["CA","Cent. California: Stockton"]
US_area_codes[210] = ["TX","S Texas: San Antonio"]
US_area_codes[211] = ["--","Local community info / referral services"]
US_area_codes[212] = ["NY","New York City, New York"]
US_area_codes[213] = ["CA","S California: Los Angeles"]
US_area_codes[214] = ["TX","Texas: Dallas Metro"]
US_area_codes[215] = ["PA","SE Pennsylvania: Philadelphia"]
US_area_codes[216] = ["OH","Cleveland"]
US_area_codes[217] = ["IL","Cent. Illinois: Springfield"]
US_area_codes[218] = ["MN","N Minnesota: Duluth"]
US_area_codes[219] = ["IN","NW Indiana: Gary"]
US_area_codes[224] = ["IL","Northern NE Illinois:  Evanston, Waukegan, Northbrook"]
US_area_codes[225] = ["LA","Louisiana: Baton Rouge, New Roads, Donaldsonville, Albany, Gonzales, Greensburg, Plaquemine, Vacherie"]
US_area_codes[226] = ["ON","Canada: SW Ontario: Windsor"]
US_area_codes[228] = ["MS","S Mississippi"]
US_area_codes[229] = ["GA","SW Georgia: Albany"]
US_area_codes[231] = ["MI","W Michigan: Northwestern portion of lower Peninsula; Traverse City, Muskegon, Cheboygan, Alanson"]
US_area_codes[234] = ["OH","NE Ohio: Canton, Akron"]
US_area_codes[236] = ["VA","Virginia (region unknown) / Unassigned?"]
US_area_codes[239] = ["FL","Florida"]
US_area_codes[240] = ["MD","W Maryland: Silver Spring, Frederick, Gaithersburg"]
US_area_codes[242] = ["--","Bahamas"]
US_area_codes[246] = ["--","Barbados"]
US_area_codes[248] = ["MI","Michigan: Oakland County, Pontiac"]
US_area_codes[250] = ["BC","Canada: British Columbia"]
US_area_codes[251] = ["AL","S Alabama: Mobile and coastal areas, Jackson, Evergreen, Monroeville"]
US_area_codes[252] = ["NC","E North Carolina"]
US_area_codes[253] = ["WA","Washington: South Tier - Tacoma, Federal Way"]
US_area_codes[254] = ["TX","Central Texas"]
US_area_codes[256] = ["AL","E and N Alabama"]
US_area_codes[260] = ["IN","NE Indiana: Fort Wayne"]
US_area_codes[262] = ["WI","SE Wisconsin: counties of Kenosha, Ozaukee, Racine, Walworth, Washington, Waukesha"]
US_area_codes[264] = ["--","Anguilla"]
US_area_codes[267] = ["PA","SE Pennsylvania: Philadelphia"]
US_area_codes[268] = ["--","Antigua and Barbuda"]
US_area_codes[269] = ["MI","SW Michigan: Kalamazoo, Saugatuck, Hastings, Battle Creek, Sturgis to Lake Michigan"]
US_area_codes[270] = ["KY","W Kentucky: Bowling Green, Paducah"]
US_area_codes[276] = ["VA","S and SW Virginia: Bristol, Stuart, Martinsville"]
US_area_codes[278] = ["MI","Michigan"]
US_area_codes[281] = ["TX","Texas: Houston Metro"]
US_area_codes[283] = ["OH","SW Ohio: Cincinnati"]
US_area_codes[284] = ["--","British Virgin Islands"]
US_area_codes[289] = ["ON","Canada: S Cent. Ontario: Greater Toronto Area -- Durham, Halton, Hamilton-Wentworth, Niagara, Peel, York, and southern Simcoe County"]
US_area_codes[301] = ["MD","W Maryland: Silver Spring, Frederick, Camp Springs, Prince George's County"]
US_area_codes[302] = ["DE","Delaware"]
US_area_codes[303] = ["CO","Central Colorado: Denver"]
US_area_codes[304] = ["WV","West Virginia"]
US_area_codes[305] = ["FL","SE Florida: Miami, the Keys"]
US_area_codes[306] = ["SK","Canada: Saskatchewan"]
US_area_codes[307] = ["WY","Wyoming"]
US_area_codes[308] = ["NE","W Nebraska: North Platte"]
US_area_codes[309] = ["IL","W Cent. Illinois: Peoria"]
US_area_codes[310] = ["CA","S California: Beverly Hills, West Hollywood, West Los Angeles"]
US_area_codes[311] = ["--","Reserved for special applications"]
US_area_codes[312] = ["IL","Illinois: Chicago"]
US_area_codes[313] = ["MI","Michigan: Detroit and suburbs"]
US_area_codes[314] = ["MO","SE Missouri: St Louis city and parts of the metro area only"]
US_area_codes[315] = ["NY","N Cent. New York: Syracuse"]
US_area_codes[316] = ["KS","S Kansas: Wichita"]
US_area_codes[317] = ["IN","Cent. Indiana: Indianapolis"]
US_area_codes[318] = ["LA","N Louisiana: Shreveport, Ruston, Monroe, Alexandria"]
US_area_codes[319] = ["IA","E Iowa: Cedar Rapids"]
US_area_codes[320] = ["MN","Cent. Minnesota: Saint Cloud"]
US_area_codes[321] = ["FL","Florida: Brevard County, Cape Canaveral area; Metro Orlando"]
US_area_codes[323] = ["CA","S California: Los Angeles"]
US_area_codes[325] = ["TX","Central Texas: Abilene, Sweetwater, Snyder, San Angelo"]
US_area_codes[330] = ["OH","NE Ohio: Akron, Canton, Youngstown; Mahoning County, parts of Trumbull/Warren counties"]
US_area_codes[331] = ["IL","W NE Illinois, western suburbs of Chicago"]
US_area_codes[334] = ["AL","S Alabama: Auburn/Opelika, Montgomery and coastal areas"]
US_area_codes[336] = ["NC","Cent. North Carolina: Greensboro, Winston-Salem, High Point"]
US_area_codes[337] = ["LA","SW Louisiana: Lake Charles, Lafayette"]
US_area_codes[339] = ["MA","Massachusetts: Boston suburbs, to the south and west"]
US_area_codes[340] = ["VI","US Virgin Islands"]
US_area_codes[341] = ["CA","(overlay on 510; SUSPENDED)"]
US_area_codes[345] = ["--","Cayman Islands"]
US_area_codes[347] = ["NY","New York"]
US_area_codes[351] = ["MA","Massachusetts: north of Boston to NH, 508, and 781"]
US_area_codes[352] = ["FL","Florida: Gainesville area, Ocala, Crystal River"]
US_area_codes[360] = ["WA","W Washington State: Olympia, Bellingham"]
US_area_codes[361] = ["TX","S Texas: Corpus Christi"]
US_area_codes[369] = ["CA","Solano County"]
US_area_codes[380] = ["OH","Ohio: Columbus"]
US_area_codes[385] = ["UT","Utah: Salt Lake City Metro"]
US_area_codes[386] = ["FL","N central Florida: Lake City"]
US_area_codes[401] = ["RI","Rhode Island"]
US_area_codes[402] = ["NE","E Nebraska: Omaha, Lincoln"]
US_area_codes[403] = ["AB","Canada: Southern Alberta"]
US_area_codes[404] = ["GA","N Georgia: Atlanta and suburbs"]
US_area_codes[405] = ["OK","W Oklahoma: Oklahoma City"]
US_area_codes[406] = ["MT","Montana"]
US_area_codes[407] = ["FL","Central Florida: Metro Orlando"]
US_area_codes[408] = ["CA","Cent. Coastal California: San Jose"]
US_area_codes[409] = ["TX","SE Texas: Galveston, Port Arthur, Beaumont"]
US_area_codes[410] = ["MD","E Maryland: Baltimore, Annapolis, Chesapeake Bay area, Ocean City"]
US_area_codes[411] = ["--","Reserved for special applications"]
US_area_codes[412] = ["PA","W Pennsylvania: Pittsburgh"]
US_area_codes[413] = ["MA","W Massachusetts: Springfield"]
US_area_codes[414] = ["WI","SE Wisconsin: Milwaukee County"]
US_area_codes[415] = ["CA","California: San Francisco County and Marin County on the north side of the Golden Gate Bridge, extending north to Sonoma County"]
US_area_codes[416] = ["ON","Canada: S Cent. Ontario: Toronto"]
US_area_codes[417] = ["MO","SW Missouri: Springfield"]
US_area_codes[418] = ["QC","Canada: NE Quebec: Quebec"]
US_area_codes[419] = ["OH","NW Ohio: Toledo"]
US_area_codes[423] = ["TN","E Tennessee, except Knoxville metro area: Chattanooga, Bristol, Johnson City, Kingsport, Greeneville"]
US_area_codes[424] = ["CA","S California: Los Angeles"]
US_area_codes[425] = ["WA","Washington: North Tier - Everett, Bellevue"]
US_area_codes[430] = ["TX","NE Texas: Tyler"]
US_area_codes[432] = ["TX","W Texas: Big Spring, Midland, Odessa"]
US_area_codes[434] = ["VA","E Virginia: Charlottesville, Lynchburg, Danville, South Boston, and Emporia"]
US_area_codes[435] = ["UT","Rural Utah outside Salt Lake City metro"]
US_area_codes[438] = ["QC","Canada: SW Quebec: Montreal city"]
US_area_codes[440] = ["OH","Ohio: Cleveland metro area, excluding Cleveland"]
US_area_codes[441] = ["--","Bermuda"]
US_area_codes[442] = ["CA","Far north suburbs of San Diego"]
US_area_codes[443] = ["MD","E Maryland: Baltimore, Annapolis, Chesapeake Bay area, Ocean City"]
US_area_codes[450] = ["QC","Canada: Southeastern Quebec; suburbs outside metro Montreal"]
US_area_codes[456] = ["--","Inbound International"]
US_area_codes[464] = ["IL","Illinois: south suburbs of Chicago"]
US_area_codes[469] = ["TX","Texas: Dallas Metro"]
US_area_codes[470] = ["GA","Georgia: Greater Atlanta Metropolitan Area"]
US_area_codes[473] = ["--","Grenada"]
US_area_codes[475] = ["CT","Connecticut: New Haven, Greenwich, southwestern"]
US_area_codes[478] = ["GA","Central Georgia: Macon"]
US_area_codes[479] = ["AR","NW Arkansas:  Fort Smith, Fayetteville, Springdale, Bentonville"]
US_area_codes[480] = ["AZ","Arizona: East Phoenix"]
US_area_codes[484] = ["PA","SE Pennsylvania: Allentown, Bethlehem, Reading, West Chester, Norristown"]
US_area_codes[500] = ["--","Personal Communication Service"]
US_area_codes[501] = ["AR","Central Arkansas: Little Rock, Hot Springs, Conway"]
US_area_codes[502] = ["KY","N Central Kentucky: Louisville"]
US_area_codes[503] = ["OR","Oregon"]
US_area_codes[504] = ["LA","E Louisiana: New Orleans metro area"]
US_area_codes[505] = ["NM","North central and northwestern New Mexico"]
US_area_codes[506] = ["NB","Canada: New Brunswick"]
US_area_codes[507] = ["MN","S Minnesota: Rochester, Mankato, Worthington"]
US_area_codes[508] = ["MA","Cent. Massachusetts: Framingham; Cape Cod"]
US_area_codes[509] = ["WA","E and Central Washington state: Spokane, Yakima, Walla Walla, Ellensburg"]
US_area_codes[510] = ["CA","California: Oakland, East Bay"]
US_area_codes[511] = ["--","Nationwide travel information"]
US_area_codes[512] = ["TX","S Texas: Austin"]
US_area_codes[513] = ["OH","SW Ohio: Cincinnati"]
US_area_codes[514] = ["QC","Canada: SW Quebec: Montreal city"]
US_area_codes[515] = ["IA","Cent. Iowa: Des Moines"]
US_area_codes[516] = ["NY","New York: Nassau County, Long Island; Hempstead"]
US_area_codes[517] = ["MI","Cent. Michigan: Lansing"]
US_area_codes[518] = ["NY","NE New York: Albany"]
US_area_codes[519] = ["ON","Canada: SW Ontario: Windsor"]
US_area_codes[520] = ["AZ","SE Arizona: Tucson area"]
US_area_codes[530] = ["CA","NE California: Eldorado County area, excluding Eldorado Hills itself: incl cities of Auburn, Chico, Redding, So. Lake Tahoe, Marysville, Nevada City/Grass Valley"]
US_area_codes[539] = ["OK","E Oklahoma: Tulsa area"]
US_area_codes[540] = ["VA","Western and Southwest Virginia: Shenandoah and Roanoke valleys: Fredericksburg, Harrisonburg, Roanoke, Salem, Lexington and nearby areas"]
US_area_codes[541] = ["OR","Oregon: Eugene, Medford"]
US_area_codes[551] = ["NJ","N New Jersey: Jersey City, Hackensack"]
US_area_codes[555] = ["--","Reserved for directory assistance applications"]
US_area_codes[557] = ["MO","SE Missouri: St Louis metro area only"]
US_area_codes[559] = ["CA","Central California: Fresno"]
US_area_codes[561] = ["FL","S. Central Florida: Palm Beach County"]
US_area_codes[562] = ["CA","California: Long Beach"]
US_area_codes[563] = ["IA","E Iowa: Davenport, Dubuque"]
US_area_codes[564] = ["WA","W Washington State: Olympia, Bellingham"]
US_area_codes[567] = ["OH","NW Ohio: Toledo"]
US_area_codes[570] = ["PA","NE and N Central Pennsylvania: Wilkes-Barre, Scranton"]
US_area_codes[571] = ["VA","Northern Virginia: Arlington, McLean, Tysons Corner"]
US_area_codes[573] = ["MO","SE Missouri: excluding St Louis metro area, includes Central/East Missouri, area between St. Louis and Kansas City"]
US_area_codes[574] = ["IN","N Indiana: Elkhart, South Bend"]
US_area_codes[575] = ["NM","New Mexico"]
US_area_codes[580] = ["OK","W Oklahoma"]
US_area_codes[585] = ["NY","NW New York: Rochester"]
US_area_codes[586] = ["MI","Michigan: Macomb County"]
US_area_codes[600] = ["--","Canadian Services"]
US_area_codes[601] = ["MS","Mississippi: Meridian, Jackson area"]
US_area_codes[602] = ["AZ","Arizona: Phoenix"]
US_area_codes[603] = ["NH","New Hampshire"]
US_area_codes[604] = ["BC","Canada: British Columbia: Greater Vancouver"]
US_area_codes[605] = ["SD","South Dakota"]
US_area_codes[606] = ["KY","E Kentucky: area east of Frankfort: Ashland"]
US_area_codes[607] = ["NY","S Cent. New York: Ithaca, Binghamton; Catskills"]
US_area_codes[608] = ["WI","SW Wisconsin: Madison"]
US_area_codes[609] = ["NJ","S New Jersey: Trenton"]
US_area_codes[610] = ["PA","SE Pennsylvania: Allentown, Bethlehem, Reading, West Chester, Norristown"]
US_area_codes[611] = ["--","Reserved for special applications"]
US_area_codes[612] = ["MN","Cent. Minnesota: Minneapolis"]
US_area_codes[613] = ["ON","Canada: SE Ontario: Ottawa"]
US_area_codes[614] = ["OH","SE Ohio: Columbus"]
US_area_codes[615] = ["TN","Northern Middle Tennessee: Nashville metro area"]
US_area_codes[616] = ["MI","W Michigan: Holland, Grand Haven, Greenville, Grand Rapids, Ionia"]
US_area_codes[617] = ["MA","Massachusetts: greater Boston"]
US_area_codes[618] = ["IL","S Illinois: Centralia"]
US_area_codes[619] = ["CA","S California: San Diego"]
US_area_codes[620] = ["KS","S Kansas: Wichita"]
US_area_codes[623] = ["AZ","Arizona: West Phoenix"]
US_area_codes[626] = ["CA","E S California: Pasadena"]
US_area_codes[627] = ["CA","No longer in use [was Napa, Sonoma counties"]
US_area_codes[628] = ["CA","(Region unknown; perm 10/21/00)21/00)00)"]
US_area_codes[630] = ["IL","W NE Illinois, western suburbs of Chicago"]
US_area_codes[631] = ["NY","New York: Suffolk County, Long Island; Huntington, Riverhead"]
US_area_codes[636] = ["MO","Missouri: W St. Louis metro area of St. Louis county, St. Charles County, Jefferson County area south"]
US_area_codes[641] = ["IA","Iowa: Mason City, Marshalltown, Creston, Ottumwa"]
US_area_codes[646] = ["NY","New York"]
US_area_codes[647] = ["ON","Canada: S Cent. Ontario: Toronto"]
US_area_codes[649] = ["--","Turks & Caicos Islands"]
US_area_codes[650] = ["CA","California: Peninsula south of San Francisco -- San Mateo County, parts of Santa Clara County"]
US_area_codes[651] = ["MN","Cent. Minnesota: St. Paul"]
US_area_codes[660] = ["MO","N Missouri"]
US_area_codes[661] = ["CA","California: N Los Angeles, Mckittrick, Mojave, Newhall, Oildale, Palmdale, Taft, Tehachapi, Bakersfield, Earlimart, Lancaster"]
US_area_codes[662] = ["MS","N Mississippi: Tupelo, Grenada"]
US_area_codes[664] = ["--","Montserrat"]
US_area_codes[669] = ["CA","Cent. Coastal California: San Jose"]
US_area_codes[670] = ["MP","Commonwealth of the Northern Mariana Islands (CNMI, US Commonwealth)"]
US_area_codes[671] = ["GU","Guam"]
US_area_codes[678] = ["GA","N Georgia: metropolitan Atlanta"]
US_area_codes[679] = ["MI","Michigan: Dearborn area"]
US_area_codes[682] = ["TX","Texas: Fort Worth areas"]
US_area_codes[684] = ["--","American Samoa"]
US_area_codes[689] = ["FL","Central Florida: Metro Orlando"]
US_area_codes[700] = ["--","Interexchange Carrier Services"]
US_area_codes[701] = ["ND","North Dakota"]
US_area_codes[702] = ["NV","S. Nevada: Clark County, incl Las Vegas"]
US_area_codes[703] = ["VA","Northern Virginia: Arlington, McLean, Tysons Corner"]
US_area_codes[704] = ["NC","W North Carolina: Charlotte"]
US_area_codes[705] = ["ON","Canada: NE Ontario: Sault Ste. Marie/N Ontario: N Bay, Sudbury"]
US_area_codes[706] = ["GA","N Georgia: Columbus, Augusta"]
US_area_codes[707] = ["CA","NW California: Santa Rosa, Napa, Vallejo, American Canyon, Fairfield"]
US_area_codes[708] = ["IL","Illinois: southern and western suburbs of Chicago"]
US_area_codes[709] = ["NL","Canada: Newfoundland and Labrador"]
US_area_codes[710] = ["--","US Government"]
US_area_codes[711] = ["--","Telecommunications Relay Services"]
US_area_codes[712] = ["IA","W Iowa: Council Bluffs"]
US_area_codes[713] = ["TX","Mid SE Texas: central Houston"]
US_area_codes[714] = ["CA","North and Central Orange County"]
US_area_codes[715] = ["WI","N Wisconsin: Eau Claire, Wausau, Superior"]
US_area_codes[716] = ["NY","NW New York: Buffalo"]
US_area_codes[717] = ["PA","E Pennsylvania: Harrisburg"]
US_area_codes[718] = ["NY","New York City, New York"]
US_area_codes[719] = ["CO","SE Colorado: Pueblo, Colorado Springs"]
US_area_codes[720] = ["CO","Central Colorado: Denver"]
US_area_codes[724] = ["PA","SW Pennsylvania"]
US_area_codes[727] = ["FL","Florida Tampa Metro: Saint Petersburg, Clearwater"]
US_area_codes[731] = ["TN","W Tennessee: outside Memphis metro area"]
US_area_codes[732] = ["NJ","Cent. New Jersey: Toms River, New Brunswick, Bound Brook"]
US_area_codes[734] = ["MI","SE Michigan: west and south of Detroit -- Ann Arbor, Monroe"]
US_area_codes[737] = ["TX","S Texas: Austin"]
US_area_codes[740] = ["OH","SE Ohio"]
US_area_codes[747] = ["CA","S California: Los Angeles, Agoura Hills, Calabasas, Hidden Hills, and Westlake Village"]
US_area_codes[754] = ["FL","Florida: Broward County area, incl Ft. Lauderdale"]
US_area_codes[757] = ["VA","E Virginia: Tidewater / Hampton Roads area -- Norfolk, Virginia Beach, Chesapeake, Portsmouth, Hampton, Newport News, Suffolk"]
US_area_codes[758] = ["--","St. Lucia"]
US_area_codes[760] = ["CA","California: San Diego North County to Sierra Nevada"]
US_area_codes[762] = ["GA","N Georgia: Columbus, Augusta"]
US_area_codes[763] = ["MN","Minnesota: Minneapolis NW"]
US_area_codes[764] = ["CA","SUSPENDED"]
US_area_codes[765] = ["IN","Indiana: outside Indianapolis"]
US_area_codes[767] = ["--","Dominica"]
US_area_codes[769] = ["MS","Mississippi: Meridian, Jackson area"]
US_area_codes[770] = ["GA","Georgia: Atlanta suburbs: outside of I-285 ring road"]
US_area_codes[772] = ["FL","S. Central Florida: St. Lucie, Martin, and Indian River counties"]
US_area_codes[773] = ["IL","Illinois: city of Chicago, outside the loop"]
US_area_codes[774] = ["MA","Cent. Massachusetts: Framingham; Cape Cod"]
US_area_codes[775] = ["NV","N. Nevada: Reno"]
US_area_codes[778] = ["BC","Canada: British Columbia: Greater Vancouver"]
US_area_codes[779] = ["IL","NW Illinois: Rockford, Kankakee"]
US_area_codes[780] = ["AB","Canada: Northern Alberta, north of Lacombe"]
US_area_codes[781] = ["MA","Massachusetts: Boston surburbs, to the north and west"]
US_area_codes[784] = ["--","St. Vincent & Grenadines"]
US_area_codes[785] = ["KS","N & W Kansas: Topeka"]
US_area_codes[786] = ["FL","SE Florida, Monroe County"]
US_area_codes[787] = ["PR","Puerto Rico"]
US_area_codes[800] = ["--","US/Canada toll free"]
US_area_codes[801] = ["UT","Utah: Salt Lake City Metro"]
US_area_codes[802] = ["VT","Vermont"]
US_area_codes[803] = ["SC","South Carolina: Columbia, Aiken, Sumter"]
US_area_codes[804] = ["VA","E Virginia: Richmond"]
US_area_codes[805] = ["CA","S Cent. and Cent. Coastal California: Ventura County, Santa Barbara County: San Luis Obispo, Thousand Oaks, Carpinteria, Santa Barbara, Santa Maria, Lompoc, Santa Ynez Valley / Solvang"]
US_area_codes[806] = ["TX","Panhandle Texas: Amarillo, Lubbock"]
US_area_codes[807] = ["ON","Canada: W Ontario: Thunder Bay region to Manitoba border"]
US_area_codes[808] = ["HI","Hawaii"]
US_area_codes[809] = ["--","Dominican Republic"]
US_area_codes[810] = ["MI","E Michigan: Flint, Pontiac"]
US_area_codes[811] = ["--","Reserved for special applications"]
US_area_codes[812] = ["IN","S Indiana: Evansville, Cincinnati outskirts in IN, Columbus, Bloomington"]
US_area_codes[813] = ["FL","SW Florida: Tampa Metro"]
US_area_codes[814] = ["PA","Cent. Pennsylvania: Erie"]
US_area_codes[815] = ["IL","NW Illinois: Rockford, Kankakee"]
US_area_codes[816] = ["MO","N Missouri: Kansas City"]
US_area_codes[817] = ["TX","N Cent. Texas: Fort Worth area"]
US_area_codes[818] = ["CA","S California: Los Angeles: San Fernando Valley"]
US_area_codes[819] = ["QC","NW Quebec: Trois Rivieres, Sherbrooke, Outaouais"]
US_area_codes[822] = ["--","US/Canada toll free"]
US_area_codes[828] = ["NC","W North Carolina: Asheville"]
US_area_codes[829] = ["--","Dominican Republic"]
US_area_codes[830] = ["TX","Texas: region surrounding San Antonio"]
US_area_codes[831] = ["CA","California: central coast area from Santa Cruz through Monterey County"]
US_area_codes[832] = ["TX","Texas: Houston"]
US_area_codes[833] = ["--","US/Canada toll free"]
US_area_codes[835] = ["PA","SE Pennsylvania: Allentown, Bethlehem, Reading, West Chester, Norristown"]
US_area_codes[843] = ["SC","South Carolina, coastal area: Charleston, Beaufort, Myrtle Beach"]
US_area_codes[844] = ["--","US/Canada toll free"]
US_area_codes[845] = ["NY","New York: Poughkeepsie; Nyack, Nanuet, Valley Cottage, New City, Putnam, Dutchess, Rockland, Orange, Ulster and parts of Sullivan counties in New York's lower Hudson Valley and Delaware County in the Catskills"]
US_area_codes[847] = ["IL","Northern NE Illinois: northwestern suburbs of chicago"]
US_area_codes[848] = ["NJ","Cent. New Jersey: Toms River, New Brunswick, Bound Brook"]
US_area_codes[850] = ["FL","Florida panhandle, from east of Tallahassee to Pensacola"]
US_area_codes[855] = ["--","US/Canada toll free"]
US_area_codes[856] = ["NJ","SW New Jersey: greater Camden area, Mt Laurel"]
US_area_codes[857] = ["MA","Massachusetts: greater Boston"]
US_area_codes[858] = ["CA","S California: San Diego"]
US_area_codes[859] = ["KY","N and Central Kentucky: Lexington; suburban KY counties of Cincinnati OH metro area; Covington, Newport, Ft. Thomas, Ft. Wright, Florence"]
US_area_codes[860] = ["CT","Connecticut: areas outside of Fairfield and New Haven Counties"]
US_area_codes[862] = ["NJ","N New Jersey: Newark Paterson Morristown"]
US_area_codes[863] = ["FL","Florida: Lakeland, Polk County"]
US_area_codes[864] = ["SC","South Carolina, upstate area: Greenville, Spartanburg"]
US_area_codes[865] = ["TN","E Tennessee: Knoxville, Knox and adjacent counties"]
US_area_codes[866] = ["--","US/Canada toll free"]
US_area_codes[867] = ["YT","Canada: Yukon, Northwest Territories, Nunavut"]
US_area_codes[868] = ["--","Trinidad and Tobago"]
US_area_codes[869] = ["--","St. Kitts & Nevis"]
US_area_codes[870] = ["AR","Arkansas: areas outside of west/central AR: Jonesboro, etc"]
US_area_codes[872] = ["IL","Illinois: Chicago"]
US_area_codes[876] = ["--","Jamaica"]
US_area_codes[877] = ["--","US/Canada toll free"]
US_area_codes[878] = ["PA","Pittsburgh, New Castle"]
US_area_codes[880] = ["--","Paid Toll-Free Service"]
US_area_codes[881] = ["--","Paid Toll-Free Service"]
US_area_codes[882] = ["--","Paid Toll-Free Service"]
US_area_codes[888] = ["--","US/Canada toll free"]
US_area_codes[898] = ["--","VoIP service"]
US_area_codes[900] = ["--","US toll calls -- prices vary with the number called"]
US_area_codes[901] = ["TN","W Tennessee: Memphis metro area"]
US_area_codes[902] = ["NS","Canada: Nova Scotia, Prince Edward Island"]
US_area_codes[903] = ["TX","NE Texas: Tyler"]
US_area_codes[904] = ["FL","N Florida: Jacksonville"]
US_area_codes[905] = ["ON","Canada: S Cent. Ontario: Greater Toronto Area -- Durham, Halton, Hamilton-Wentworth, Niagara, Peel, York, and southern Simcoe County"]
US_area_codes[906] = ["MI","Upper Peninsula Michigan: Sault Ste. Marie, Escanaba, Marquette"]
US_area_codes[907] = ["AK","Alaska"]
US_area_codes[908] = ["NJ","Cent. New Jersey: Elizabeth, Basking Ridge, Somerville, Bridgewater, Bound Brook"]
US_area_codes[909] = ["CA","California: Inland empire: San Bernardino"]
US_area_codes[910] = ["NC","S Cent. North Carolina: Fayetteville, Wilmington"]
US_area_codes[911] = ["--","Emergency"]
US_area_codes[912] = ["GA","SE Georgia: Savannah"]
US_area_codes[913] = ["KS","Kansas: Kansas City area"]
US_area_codes[914] = ["NY","S New York: Westchester County"]
US_area_codes[915] = ["TX","W Texas: El Paso"]
US_area_codes[916] = ["CA","NE California: Sacramento, Walnut Grove, Lincoln, Newcastle and El Dorado Hills"]
US_area_codes[917] = ["NY","New York: New York City"]
US_area_codes[918] = ["OK","E Oklahoma: Tulsa"]
US_area_codes[919] = ["NC","E North Carolina: Raleigh"]
US_area_codes[920] = ["WI","NE Wisconsin: Appleton, Green Bay, Sheboygan, Fond du Lac"]
US_area_codes[925] = ["CA","California: Contra Costa area: Antioch, Concord, Pleasanton, Walnut Creek"]
US_area_codes[927] = ["FL","Florida: Cellular coverage in Orlando area"]
US_area_codes[928] = ["AZ","Central and Northern Arizona: Prescott, Flagstaff, Yuma"]
US_area_codes[931] = ["TN","Middle Tennessee: semi-circular ring around Nashville"]
US_area_codes[935] = ["CA","S California: San Diego"]
US_area_codes[936] = ["TX","SE Texas: Conroe, Lufkin, Nacogdoches, Crockett"]
US_area_codes[937] = ["OH","SW Ohio: Dayton"]
US_area_codes[939] = ["PR","Puerto Rico"]
US_area_codes[940] = ["TX","N Cent. Texas: Denton, Wichita Falls"]
US_area_codes[941] = ["FL","SW Florida: Sarasota and Manatee counties"]
US_area_codes[947] = ["MI","Michigan: Oakland County"]
US_area_codes[949] = ["CA","California: S Coastal Orange County"]
US_area_codes[951] = ["CA","California: W Riverside County"]
US_area_codes[952] = ["MN","Minnesota: Minneapolis SW, Bloomington"]
US_area_codes[954] = ["FL","Florida: Broward County area, incl Ft. Lauderdale"]
US_area_codes[956] = ["TX","Texas: Valley of Texas area; Harlingen, Laredo"]
US_area_codes[957] = ["NM","New Mexico"]
US_area_codes[959] = ["CT","Connecticut: Hartford, New London"]
US_area_codes[970] = ["CO","N and W Colorado"]
US_area_codes[971] = ["OR","Oregon:  Metropolitan Portland, Salem/Keizer area, incl Cricket Wireless"]
US_area_codes[972] = ["TX","Texas: Dallas Metro"]
US_area_codes[973] = ["NJ","N New Jersey: Newark, Paterson, Morristown"]
US_area_codes[975] = ["MO","N Missouri: Kansas City"]
US_area_codes[976] = ["--","Unassigned"]
US_area_codes[978] = ["MA","Massachusetts: north of Boston to NH"]
US_area_codes[979] = ["TX","SE Texas: Bryan, College Station, Bay City"]
US_area_codes[980] = ["NC","North Carolina:"]
US_area_codes[984] = ["NC","E North Carolina: Raleigh"]
US_area_codes[985] = ["LA","E Louisiana: SE/N shore of Lake Pontchartrain: Hammond, Slidell, Covington, Amite, Kentwood, area SW of New Orleans, Houma, Thibodaux, Morgan City"]
US_area_codes[989] = ["MI","Upper central Michigan: Mt Pleasant, Saginaw"]
US_area_codes[999] = ["--","Often used by carriers to indicate that the area code information is unavailable for CNID, even though the rest of the number is present"]

class US_Area_Code_Checker < Checker

	def initialize
		super
		@description = "List of US area codes"
		@areas = {}
	end

	def process_word (word, extras = nil)
		if /([0-9]{3})$/.match(word)
			area_code = $1.to_i
			if US_area_codes.has_key?(area_code)
				if !@areas.has_key?(area_code)
					@areas[area_code] = 1
				else
					@areas[area_code] += 1
				end
			end
		end
		@total_words_processed += 1
	end

	def get_results()
		ret_str = "US Area Codes\n"

		if @areas.length > 0
			# The sort changes the hash:
			# { [200] => 3, [201] => 4}
			#
			# into an array of pairs:
			# [ [201, 4], [200, 3] ]
			#
			# the -1 in the sort makes it to sort highest first
			(@areas.sort do |x,y| (x[1] <=> y[1]) * -1 end).each do |area_code_data|
				ret_str << "#{area_code_data[0].to_s} #{US_area_codes[area_code_data[0]][1]} (#{US_area_codes[area_code_data[0]][0]}) = #{area_code_data[1].to_s} (#{((area_code_data[1].to_f/@total_words_processed) * 100).round(2).to_s}%)\n"
			end
		else
			ret_str << "None found\n"
		end

		return ret_str
	end
end

