Minutes from 92nd OpenVDB TSC meeting, May 25th, 2021, (EDT)

Attendees: *Nick* A., *Ken* M., *Jeff* L., *Dan* B., *Andre* P.

Additional Attendees: Richard Jones (DNeg), JT Nelson (Blender), 
Bruce Cherniak (Intel), Sergio Rojas, Johannes Meng (Intel).
Jeff Budsberg (DreamWorks)


Regrets: None

Agenda:

1) Confirm Quorum
2) Secretary
3) TSC Updates
4) OpenVDB 8.1
5) Siggraph Course
6) Vectorization
7) Intel's OpenCL and TBB 2021
8) Support for LLVM 6 in AX
9) Github Pages
10) PR-1050 (Blind Data)
11) PR-1024 (DynamicNodeManager Grain Size)
12) PR-1070
13) Next meeting

1) Confirm Quorum

Quorum is present.

2) Secretary

Secretary is Andre Pradhana.

3) TSC Updates

Nick is changing employers. This is going to happen at the end of June 2021.
He intends to still be part of the TSC. Nick nominates Richard Jones to be a member
of the TSC. Ken mentions that members of the TSC need to be active developers and
that it is of interest to have somebody from DNEG as part of ASWF. Dan vouches that
Richard is a good and competent developer and it will be good to have him
as a member of the TSC.


4) OpenVDB 8.1

We have one more week before the release of OpenVDB 8.1. Dan mentions that there is not
going to be too much testing from ILM because the major release is done on a quarterly
basis. Jeff was waiting for a branch for the 8.1 version. Dan will create a branch for 8.1
today. Andre has a test map for OpenVDB 8.1 in DWA, he is working with Ibrahim on
the in-house build system. 

5) Siggraph Course

Ken will not change Nick's affiliation for the course.

The deadline of getting the recording to JT is this Friday, May 28, 2021. Everybody
will email a video to JT. However if you need more time, JT will accommodate until
Wednesday June 2nd, 2021.

Jeff mentions that he did a zoom-recording test-run with screen-sharing for Houdini
session versus presentation. He discovers that screen sharing puts his icon besides
the window. JT believes that you can change this setting and he is going to look into it.
Ken may need more time because he may need to serve in a jury duty, but he will finish
the course by the weekend at the latest.

Everyone is fine with the order of the course. 

Nick brings up comparison between AX and OpenVDB C++ API. Dan does not have any plans
on vectorization. He wants to talk about how to write parallel-algorithm with VDB.
For the course, Nick and Richard want to bring up the point that AX will be able
to exploit the underlying host's architecture for optimization. To highlight this
they want to compare AX with existing parallel method in OpenVDB such as the
LeafManager's foreach and tools::foreach. Richard has examples for setting the values
and decrement the values by 1. Dan and Ken mentions that tools::foreach is using the
nested iterator and is expected to be slower than the LeafManager's foreach. Later,
Nick mentions that tools::foreach is the easiest way to execute across all levels
of a VDB tree.

Ken mentions that somebody in the course should talk about the road map for OpenVDB.
He will get an email rolling.

6) Vectorization

Ken wants to push for vectorization (e.g. AVX) in OpenVDB. There are many places where
we can benefit by using vectorization in the tools. Ken and Nick mentions the need to use
a wrapper library to implement vectorization correctly. There is pitfall if you blindly
puts AVX everywhere because there are cases where you slow it down because populating
the SSE registers can be expensive. Jeff mentions the issue with downclocking with
AVX-512 and processor compatibility.

Nick uses Agner's Fog VCL vectorization library. Dan mentions that since we already have
a way to introduce half into the library, we also needs to consider embedding the library
into OpenVDB especially because it is header only. Nick says that there are two versions
of the library for C++14 and C++17. The former version is completely locked. 

Jeff mentions processor compatibility issues that may rise up. There is also a problem
with getting two different results of fused multiply-add from a code compiled with and
without AVX2. Dan also had an experience of getting different results from a GPU code
and a code running on the CPU, where he needed to turn off fused multiply-add on the CPU
to get the same results.

Nick mentions that Windows does not have flags for anything before AVX that makes it
impossible to detect the host architecture at compile time through MS build.


7) Intel's OpenCL and TBB 2021

Dan asks if anyone from Intel (Bruce or Johannes) has a direct contact with the OpenCL
team because the new OpenCL driver with the latest tbb does not work in CentOS 7. Johannes
suggests Dan to send an email to him and Bruce.

Johannes and Nick talk about the tbb 2021 fix. Some fixes will get into 8.1, but not
it is still incomplete and Nick asks for people to contribute. It is not a priority for
8.1.

8) Support for LLVM 6 in AX

Nick wants to drop support for LLVM 6 in AX. Nick asks Dan if he can change
OPENVDB_FUTURE_DEPRECATION to be ON. Dan has no objection.

9) Github Pages

Nick asks for what lives in the OpenVDB repository, including the website and
documentation. Dan says that the documentation is part of the code. Dan thinks
that ideally the documentation should live on the OpenVDB website repo. Nick
wants to take a look at an ideal solution for this. Nick has been playing
around with getting Read the Docs to work with OpenVDB.

10) PR-1071 (Code Coverage)

Nick has a code coverage pull request based on gcov. The Fast Sweeping test in
debug build takes very long to complete. Ken will take a look into this. Nick
says that the Levelset Filter is not tested. Nick also is experimenting with
clang instead of gcov.

Dan sees that this test coverage only covers one ABI. It will be nice to have
a coverage test more frequently, even with every PR. It is very cool to have this
coverage test.

10) PR-1050 (Blind Data)

Dan thinks that this PR is ready to go. This is ABI 9 feature. Ken will look
at this PR.

11) PR-1024 (DynamicNodeManager Grain Size)

There is grain size for leaf nodes and another for non-leaf nodes. Jeff wants a good
way to know the size of the tree and decide on whether an algorithm should be threaded
based on that. This is related to having 8 root nodes problem.

In the end, Jeff and Ken have no objections. Ken mentions that we should revisit the
positioning of the origin, but we should start with some benchmarks.

12) PR-1070

The CI is currently broken, since brew has updated to tbb 2020. This PR fixes it.

13) Next meeting

Next meeting is June 1st, 2021. 12pm-1pm EST (GMT-5).

