/******************************************************************************
 * Author:   Laurent Kneip                                                    *
 * Contact:  kneip.laurent@gmail.com                                          *
 * License:  Copyright (c) 2013 Laurent Kneip, ANU. All rights reserved.      *
 *                                                                            *
 * Redistribution and use in source and binary forms, with or without         *
 * modification, are permitted provided that the following conditions         *
 * are met:                                                                   *
 * * Redistributions of source code must retain the above copyright           *
 *   notice, this list of conditions and the following disclaimer.            *
 * * Redistributions in binary form must reproduce the above copyright        *
 *   notice, this list of conditions and the following disclaimer in the      *
 *   documentation and/or other materials provided with the distribution.     *
 * * Neither the name of ANU nor the names of its contributors may be         *
 *   used to endorse or promote products derived from this software without   *
 *   specific prior written permission.                                       *
 *                                                                            *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"*
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE  *
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE *
 * ARE DISCLAIMED. IN NO EVENT SHALL ANU OR THE CONTRIBUTORS BE LIABLE        *
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR *
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER *
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT         *
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY  *
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF     *
 * SUCH DAMAGE.                                                               *
 ******************************************************************************/


#include <opengv/relative_pose/modules/fivept_kneip/modules.hpp>


Eigen::Matrix<double,1,197>
opengv::relative_pose::modules::fivept_kneip::initEpncpRowR(
    std::vector<Eigen::Matrix3d,Eigen::aligned_allocator<Eigen::Matrix3d> > & c123_1,
    std::vector<Eigen::Matrix3d,Eigen::aligned_allocator<Eigen::Matrix3d> > & c123_2 )
{
  Eigen::Matrix<double,1,197> row = Eigen::Matrix<double,1,197>::Zero();
  row(0,0) = -c123_1[1](0,0)*c123_2[2](1,2)+c123_1[1](0,0)*c123_2[2](2,1)+c123_1[0](0,1)*c123_2[2](1,2)-c123_1[0](0,1)*c123_2[1](2,2)-c123_1[0](1,0)*c123_2[2](2,1)+c123_1[0](1,0)*c123_2[1](2,2);
  row(0,1) = -c123_1[1](0,0)*c123_2[1](1,2)+c123_1[1](0,0)*c123_2[1](2,1)+c123_1[0](0,1)*c123_2[2](1,1)-c123_1[0](0,1)*c123_2[1](2,1)-c123_1[0](1,0)*c123_2[2](1,1)+c123_1[0](1,0)*c123_2[1](1,2);
  row(0,2) = -c123_1[1](0,0)*c123_2[2](0,2)+c123_1[1](0,0)*c123_2[2](2,0)+c123_1[0](0,1)*c123_2[2](0,2)-c123_1[0](0,1)*c123_2[0](2,2)-c123_1[0](1,0)*c123_2[2](2,0)+c123_1[0](1,0)*c123_2[0](2,2);
  row(0,3) = -c123_1[1](0,0)*c123_2[1](0,2)-c123_1[1](0,0)*c123_2[0](1,2)+c123_1[1](0,0)*c123_2[1](2,0)+c123_1[1](0,0)*c123_2[0](2,1)+c123_1[0](0,1)*c123_2[2](0,1)+c123_1[0](0,1)*c123_2[2](1,0)-c123_1[0](0,1)*c123_2[1](2,0)-c123_1[0](0,1)*c123_2[0](2,1)-c123_1[0](1,0)*c123_2[2](0,1)+c123_1[0](1,0)*c123_2[1](0,2)-c123_1[0](1,0)*c123_2[2](1,0)+c123_1[0](1,0)*c123_2[0](1,2);
  row(0,4) = -c123_1[1](0,0)*c123_2[0](0,2)+c123_1[1](0,0)*c123_2[0](2,0)+c123_1[0](0,1)*c123_2[2](0,0)-c123_1[0](0,1)*c123_2[0](2,0)-c123_1[0](1,0)*c123_2[2](0,0)+c123_1[0](1,0)*c123_2[0](0,2);
  row(0,5) = c123_1[2](0,0)*c123_2[2](1,2)-c123_1[2](0,0)*c123_2[2](2,1)-c123_1[0](0,2)*c123_2[2](1,2)+c123_1[0](0,2)*c123_2[1](2,2)+c123_1[0](2,0)*c123_2[2](2,1)-c123_1[0](2,0)*c123_2[1](2,2);
  row(0,6) = c123_1[2](0,0)*c123_2[2](0,2)-c123_1[2](0,0)*c123_2[2](2,0)-c123_1[0](0,2)*c123_2[2](0,2)+c123_1[0](0,2)*c123_2[0](2,2)+c123_1[0](2,0)*c123_2[2](2,0)-c123_1[0](2,0)*c123_2[0](2,2);
  row(0,7) = c123_1[1](0,0)*c123_2[2](1,2)-c123_1[1](0,0)*c123_2[2](2,1)-c123_1[0](0,1)*c123_2[2](1,2)+c123_1[0](0,1)*c123_2[1](2,2)+c123_1[0](1,0)*c123_2[2](2,1)-c123_1[0](1,0)*c123_2[1](2,2);
  row(0,8) = c123_1[1](0,0)*c123_2[1](1,2)-c123_1[1](0,0)*c123_2[1](2,1)-c123_1[0](0,1)*c123_2[2](1,1)+c123_1[0](0,1)*c123_2[1](2,1)+c123_1[0](1,0)*c123_2[2](1,1)-c123_1[0](1,0)*c123_2[1](1,2);
  row(0,10) = -c123_1[1](0,0)*c123_2[2](0,1)+c123_1[1](0,0)*c123_2[2](1,0)+c123_1[1](0,0)*c123_2[0](1,2)-c123_1[1](0,0)*c123_2[0](2,1)+c123_1[0](0,1)*c123_2[1](0,2)-c123_1[0](0,1)*c123_2[2](1,0)-c123_1[0](0,1)*c123_2[0](1,2)+c123_1[0](0,1)*c123_2[1](2,0)+c123_1[0](1,0)*c123_2[2](0,1)-c123_1[0](1,0)*c123_2[1](0,2)-c123_1[0](1,0)*c123_2[1](2,0)+c123_1[0](1,0)*c123_2[0](2,1);
  row(0,11) = -c123_1[1](0,0)*c123_2[1](0,1)+c123_1[1](0,0)*c123_2[1](1,0)+c123_1[0](0,1)*c123_2[1](0,1)-c123_1[0](0,1)*c123_2[0](1,1)-c123_1[0](1,0)*c123_2[1](1,0)+c123_1[0](1,0)*c123_2[0](1,1);
  row(0,12) = -c123_1[1](0,0)*c123_2[0](0,1)+c123_1[1](0,0)*c123_2[0](1,0)+c123_1[0](0,1)*c123_2[1](0,0)-c123_1[0](0,1)*c123_2[0](1,0)-c123_1[0](1,0)*c123_2[1](0,0)+c123_1[0](1,0)*c123_2[0](0,1);
  row(0,13) = -c123_1[2](0,0)*c123_2[2](1,2)+c123_1[2](0,0)*c123_2[2](2,1)+c123_1[0](0,2)*c123_2[2](1,2)-c123_1[0](0,2)*c123_2[1](2,2)-c123_1[0](2,0)*c123_2[2](2,1)+c123_1[0](2,0)*c123_2[1](2,2);
  row(0,14) = c123_1[2](0,0)*c123_2[1](1,2)-c123_1[2](0,0)*c123_2[1](2,1)-c123_1[0](0,2)*c123_2[2](1,1)+c123_1[0](0,2)*c123_2[1](2,1)+c123_1[0](2,0)*c123_2[2](1,1)-c123_1[0](2,0)*c123_2[1](1,2);
  row(0,15) = c123_1[2](0,0)*c123_2[2](0,1)+c123_1[2](0,0)*c123_2[1](0,2)-c123_1[2](0,0)*c123_2[2](1,0)-c123_1[2](0,0)*c123_2[1](2,0)-c123_1[0](0,2)*c123_2[2](0,1)-c123_1[0](0,2)*c123_2[1](0,2)+c123_1[0](0,2)*c123_2[0](1,2)+c123_1[0](0,2)*c123_2[0](2,1)+c123_1[0](2,0)*c123_2[2](1,0)-c123_1[0](2,0)*c123_2[0](1,2)+c123_1[0](2,0)*c123_2[1](2,0)-c123_1[0](2,0)*c123_2[0](2,1);
  row(0,16) = -c123_1[2](0,0)*c123_2[1](1,2)+c123_1[2](0,0)*c123_2[1](2,1)+c123_1[0](0,2)*c123_2[2](1,1)-c123_1[0](0,2)*c123_2[1](2,1)-c123_1[0](2,0)*c123_2[2](1,1)+c123_1[0](2,0)*c123_2[1](1,2);
  row(0,18) = c123_1[2](0,0)*c123_2[1](0,1)-c123_1[2](0,0)*c123_2[1](1,0)-c123_1[0](0,2)*c123_2[1](0,1)+c123_1[0](0,2)*c123_2[0](1,1)+c123_1[0](2,0)*c123_2[1](1,0)-c123_1[0](2,0)*c123_2[0](1,1);
  row(0,19) = c123_1[1](0,0)*c123_2[2](0,2)-c123_1[1](0,0)*c123_2[2](2,0)-c123_1[0](0,1)*c123_2[2](0,2)+c123_1[0](0,1)*c123_2[0](2,2)+c123_1[0](1,0)*c123_2[2](2,0)-c123_1[0](1,0)*c123_2[0](2,2);
  row(0,20) = c123_1[1](0,0)*c123_2[2](0,1)+c123_1[1](0,0)*c123_2[1](0,2)-c123_1[1](0,0)*c123_2[2](1,0)-c123_1[1](0,0)*c123_2[1](2,0)-c123_1[0](0,1)*c123_2[2](0,1)-c123_1[0](0,1)*c123_2[1](0,2)+c123_1[0](0,1)*c123_2[0](1,2)+c123_1[0](0,1)*c123_2[0](2,1)+c123_1[0](1,0)*c123_2[2](1,0)-c123_1[0](1,0)*c123_2[0](1,2)+c123_1[0](1,0)*c123_2[1](2,0)-c123_1[0](1,0)*c123_2[0](2,1);
  row(0,21) = c123_1[1](0,0)*c123_2[1](0,1)-c123_1[1](0,0)*c123_2[1](1,0)-c123_1[0](0,1)*c123_2[1](0,1)+c123_1[0](0,1)*c123_2[0](1,1)+c123_1[0](1,0)*c123_2[1](1,0)-c123_1[0](1,0)*c123_2[0](1,1);
  row(0,22) = c123_1[1](0,0)*c123_2[0](0,2)-c123_1[1](0,0)*c123_2[0](2,0)-c123_1[0](0,1)*c123_2[2](0,0)+c123_1[0](0,1)*c123_2[0](2,0)+c123_1[0](1,0)*c123_2[2](0,0)-c123_1[0](1,0)*c123_2[0](0,2);
  row(0,23) = c123_1[1](0,0)*c123_2[0](0,1)-c123_1[1](0,0)*c123_2[0](1,0)-c123_1[0](0,1)*c123_2[1](0,0)+c123_1[0](0,1)*c123_2[0](1,0)+c123_1[0](1,0)*c123_2[1](0,0)-c123_1[0](1,0)*c123_2[0](0,1);
  row(0,25) = -c123_1[2](0,0)*c123_2[2](0,2)+c123_1[2](0,0)*c123_2[2](2,0)+c123_1[0](0,2)*c123_2[2](0,2)-c123_1[0](0,2)*c123_2[0](2,2)-c123_1[0](2,0)*c123_2[2](2,0)+c123_1[0](2,0)*c123_2[0](2,2);
  row(0,26) = -c123_1[2](0,0)*c123_2[2](0,1)+c123_1[2](0,0)*c123_2[2](1,0)+c123_1[2](0,0)*c123_2[0](1,2)-c123_1[2](0,0)*c123_2[0](2,1)+c123_1[0](0,2)*c123_2[1](0,2)-c123_1[0](0,2)*c123_2[2](1,0)-c123_1[0](0,2)*c123_2[0](1,2)+c123_1[0](0,2)*c123_2[1](2,0)+c123_1[0](2,0)*c123_2[2](0,1)-c123_1[0](2,0)*c123_2[1](0,2)-c123_1[0](2,0)*c123_2[1](2,0)+c123_1[0](2,0)*c123_2[0](2,1);
  row(0,27) = c123_1[2](0,0)*c123_2[0](0,2)-c123_1[2](0,0)*c123_2[0](2,0)-c123_1[0](0,2)*c123_2[2](0,0)+c123_1[0](0,2)*c123_2[0](2,0)+c123_1[0](2,0)*c123_2[2](0,0)-c123_1[0](2,0)*c123_2[0](0,2);
  row(0,28) = -c123_1[2](0,0)*c123_2[1](0,2)-c123_1[2](0,0)*c123_2[0](1,2)+c123_1[2](0,0)*c123_2[1](2,0)+c123_1[2](0,0)*c123_2[0](2,1)+c123_1[0](0,2)*c123_2[2](0,1)+c123_1[0](0,2)*c123_2[2](1,0)-c123_1[0](0,2)*c123_2[1](2,0)-c123_1[0](0,2)*c123_2[0](2,1)-c123_1[0](2,0)*c123_2[2](0,1)+c123_1[0](2,0)*c123_2[1](0,2)-c123_1[0](2,0)*c123_2[2](1,0)+c123_1[0](2,0)*c123_2[0](1,2);
  row(0,29) = -c123_1[2](0,0)*c123_2[1](0,1)+c123_1[2](0,0)*c123_2[1](1,0)+c123_1[0](0,2)*c123_2[1](0,1)-c123_1[0](0,2)*c123_2[0](1,1)-c123_1[0](2,0)*c123_2[1](1,0)+c123_1[0](2,0)*c123_2[0](1,1);
  row(0,30) = c123_1[2](0,0)*c123_2[0](0,1)-c123_1[2](0,0)*c123_2[0](1,0)-c123_1[0](0,2)*c123_2[1](0,0)+c123_1[0](0,2)*c123_2[0](1,0)+c123_1[0](2,0)*c123_2[1](0,0)-c123_1[0](2,0)*c123_2[0](0,1);
  row(0,33) = -c123_1[2](0,0)*c123_2[0](0,2)+c123_1[2](0,0)*c123_2[0](2,0)+c123_1[0](0,2)*c123_2[2](0,0)-c123_1[0](0,2)*c123_2[0](2,0)-c123_1[0](2,0)*c123_2[2](0,0)+c123_1[0](2,0)*c123_2[0](0,2);
  row(0,34) = -c123_1[2](0,0)*c123_2[0](0,1)+c123_1[2](0,0)*c123_2[0](1,0)+c123_1[0](0,2)*c123_2[1](0,0)-c123_1[0](0,2)*c123_2[0](1,0)-c123_1[0](2,0)*c123_2[1](0,0)+c123_1[0](2,0)*c123_2[0](0,1);
  row(0,39) = -c123_1[1](0,1)*c123_2[2](2,1)+c123_1[1](0,1)*c123_2[1](2,2)+c123_1[1](1,0)*c123_2[2](1,2)-c123_1[1](1,0)*c123_2[1](2,2)-c123_1[0](1,1)*c123_2[2](1,2)+c123_1[0](1,1)*c123_2[2](2,1);
  row(0,40) = -c123_1[1](0,1)*c123_2[2](1,1)+c123_1[1](0,1)*c123_2[1](1,2)+c123_1[1](1,0)*c123_2[2](1,1)-c123_1[1](1,0)*c123_2[1](2,1)-c123_1[0](1,1)*c123_2[1](1,2)+c123_1[0](1,1)*c123_2[1](2,1);
  row(0,41) = -c123_1[1](0,1)*c123_2[2](2,0)+c123_1[1](0,1)*c123_2[0](2,2)+c123_1[1](1,0)*c123_2[2](0,2)-c123_1[1](1,0)*c123_2[0](2,2)-c123_1[0](1,1)*c123_2[2](0,2)+c123_1[0](1,1)*c123_2[2](2,0);
  row(0,42) = -c123_1[1](0,1)*c123_2[2](0,1)+c123_1[1](0,1)*c123_2[1](0,2)-c123_1[1](0,1)*c123_2[2](1,0)+c123_1[1](0,1)*c123_2[0](1,2)+c123_1[1](1,0)*c123_2[2](0,1)+c123_1[1](1,0)*c123_2[2](1,0)-c123_1[1](1,0)*c123_2[1](2,0)-c123_1[1](1,0)*c123_2[0](2,1)-c123_1[0](1,1)*c123_2[1](0,2)-c123_1[0](1,1)*c123_2[0](1,2)+c123_1[0](1,1)*c123_2[1](2,0)+c123_1[0](1,1)*c123_2[0](2,1);
  row(0,43) = -c123_1[1](0,1)*c123_2[2](0,0)+c123_1[1](0,1)*c123_2[0](0,2)+c123_1[1](1,0)*c123_2[2](0,0)-c123_1[1](1,0)*c123_2[0](2,0)-c123_1[0](1,1)*c123_2[0](0,2)+c123_1[0](1,1)*c123_2[0](2,0);
  row(0,44) = -c123_1[2](0,1)*c123_2[2](1,2)+c123_1[2](0,1)*c123_2[2](2,1)+c123_1[1](0,2)*c123_2[2](1,2)-c123_1[1](0,2)*c123_2[1](2,2)-c123_1[2](1,0)*c123_2[2](1,2)+c123_1[2](1,0)*c123_2[2](2,1)+c123_1[0](1,2)*c123_2[2](1,2)-c123_1[0](1,2)*c123_2[1](2,2)-c123_1[1](2,0)*c123_2[2](2,1)+c123_1[1](2,0)*c123_2[1](2,2)-c123_1[0](2,1)*c123_2[2](2,1)+c123_1[0](2,1)*c123_2[1](2,2);
  row(0,45) = -c123_1[2](0,1)*c123_2[2](0,2)+c123_1[2](0,1)*c123_2[2](2,0)+c123_1[1](0,2)*c123_2[2](0,2)-c123_1[1](0,2)*c123_2[0](2,2)-c123_1[2](1,0)*c123_2[2](0,2)+c123_1[2](1,0)*c123_2[2](2,0)+c123_1[0](1,2)*c123_2[2](0,2)-c123_1[0](1,2)*c123_2[0](2,2)-c123_1[1](2,0)*c123_2[2](2,0)+c123_1[1](2,0)*c123_2[0](2,2)-c123_1[0](2,1)*c123_2[2](2,0)+c123_1[0](2,1)*c123_2[0](2,2);
  row(0,46) = c123_1[2](0,1)*c123_2[2](1,2)-c123_1[2](0,1)*c123_2[1](2,2)-c123_1[1](0,2)*c123_2[2](1,2)+c123_1[1](0,2)*c123_2[2](2,1)-c123_1[2](1,0)*c123_2[2](2,1)+c123_1[2](1,0)*c123_2[1](2,2)-c123_1[0](1,2)*c123_2[2](2,1)+c123_1[0](1,2)*c123_2[1](2,2)-c123_1[1](2,0)*c123_2[2](1,2)+c123_1[1](2,0)*c123_2[2](2,1)+c123_1[0](2,1)*c123_2[2](1,2)-c123_1[0](2,1)*c123_2[1](2,2);
  row(0,47) = c123_1[2](0,1)*c123_2[2](1,1)-c123_1[2](0,1)*c123_2[1](1,2)+c123_1[1](0,2)*c123_2[2](1,1)-c123_1[1](0,2)*c123_2[1](1,2)-c123_1[2](1,0)*c123_2[2](1,1)+c123_1[2](1,0)*c123_2[1](2,1)+c123_1[0](1,2)*c123_2[1](1,2)-c123_1[0](1,2)*c123_2[1](2,1)-c123_1[1](2,0)*c123_2[2](1,1)+c123_1[1](2,0)*c123_2[1](2,1)+c123_1[0](2,1)*c123_2[1](1,2)-c123_1[0](2,1)*c123_2[1](2,1);
  row(0,48) = -c123_1[2](0,1)*c123_2[1](0,2)+c123_1[2](0,1)*c123_2[2](1,0)+c123_1[1](0,2)*c123_2[2](0,1)-c123_1[1](0,2)*c123_2[0](1,2)-c123_1[2](1,0)*c123_2[2](0,1)+c123_1[2](1,0)*c123_2[1](2,0)+c123_1[0](1,2)*c123_2[1](0,2)-c123_1[0](1,2)*c123_2[0](2,1)-c123_1[1](2,0)*c123_2[2](1,0)+c123_1[1](2,0)*c123_2[0](2,1)+c123_1[0](2,1)*c123_2[0](1,2)-c123_1[0](2,1)*c123_2[1](2,0);
  row(0,49) = -c123_1[2](0,2)*c123_2[2](2,1)+c123_1[2](0,2)*c123_2[1](2,2)+c123_1[2](2,0)*c123_2[2](1,2)-c123_1[2](2,0)*c123_2[1](2,2)-c123_1[0](2,2)*c123_2[2](1,2)+c123_1[0](2,2)*c123_2[2](2,1);
  row(0,50) = -c123_1[2](0,2)*c123_2[2](1,1)+c123_1[2](0,2)*c123_2[1](1,2)+c123_1[2](2,0)*c123_2[2](1,1)-c123_1[2](2,0)*c123_2[1](2,1)-c123_1[0](2,2)*c123_2[1](1,2)+c123_1[0](2,2)*c123_2[1](2,1);
  row(0,51) = c123_1[2](0,1)*c123_2[2](0,2)-c123_1[2](0,1)*c123_2[0](2,2)-c123_1[1](0,2)*c123_2[2](0,2)+c123_1[1](0,2)*c123_2[2](2,0)-c123_1[2](1,0)*c123_2[2](2,0)+c123_1[2](1,0)*c123_2[0](2,2)-c123_1[0](1,2)*c123_2[2](2,0)+c123_1[0](1,2)*c123_2[0](2,2)-c123_1[1](2,0)*c123_2[2](0,2)+c123_1[1](2,0)*c123_2[2](2,0)+c123_1[0](2,1)*c123_2[2](0,2)-c123_1[0](2,1)*c123_2[0](2,2);
  row(0,52) = c123_1[2](0,1)*c123_2[2](0,1)-c123_1[2](0,1)*c123_2[0](1,2)-c123_1[1](0,2)*c123_2[1](0,2)+c123_1[1](0,2)*c123_2[2](1,0)-c123_1[2](1,0)*c123_2[2](1,0)+c123_1[2](1,0)*c123_2[0](2,1)+c123_1[0](1,2)*c123_2[0](1,2)-c123_1[0](1,2)*c123_2[1](2,0)-c123_1[1](2,0)*c123_2[2](0,1)+c123_1[1](2,0)*c123_2[1](2,0)+c123_1[0](2,1)*c123_2[1](0,2)-c123_1[0](2,1)*c123_2[0](2,1);
  row(0,53) = c123_1[2](0,1)*c123_2[2](0,0)-c123_1[2](0,1)*c123_2[0](0,2)+c123_1[1](0,2)*c123_2[2](0,0)-c123_1[1](0,2)*c123_2[0](0,2)-c123_1[2](1,0)*c123_2[2](0,0)+c123_1[2](1,0)*c123_2[0](2,0)+c123_1[0](1,2)*c123_2[0](0,2)-c123_1[0](1,2)*c123_2[0](2,0)-c123_1[1](2,0)*c123_2[2](0,0)+c123_1[1](2,0)*c123_2[0](2,0)+c123_1[0](2,1)*c123_2[0](0,2)-c123_1[0](2,1)*c123_2[0](2,0);
  row(0,54) = -c123_1[2](0,2)*c123_2[2](2,0)+c123_1[2](0,2)*c123_2[0](2,2)+c123_1[2](2,0)*c123_2[2](0,2)-c123_1[2](2,0)*c123_2[0](2,2)-c123_1[0](2,2)*c123_2[2](0,2)+c123_1[0](2,2)*c123_2[2](2,0);
  row(0,55) = -c123_1[2](0,2)*c123_2[2](0,1)+c123_1[2](0,2)*c123_2[1](0,2)-c123_1[2](0,2)*c123_2[2](1,0)+c123_1[2](0,2)*c123_2[0](1,2)+c123_1[2](2,0)*c123_2[2](0,1)+c123_1[2](2,0)*c123_2[2](1,0)-c123_1[2](2,0)*c123_2[1](2,0)-c123_1[2](2,0)*c123_2[0](2,1)-c123_1[0](2,2)*c123_2[1](0,2)-c123_1[0](2,2)*c123_2[0](1,2)+c123_1[0](2,2)*c123_2[1](2,0)+c123_1[0](2,2)*c123_2[0](2,1);
  row(0,56) = -c123_1[2](0,2)*c123_2[2](0,0)+c123_1[2](0,2)*c123_2[0](0,2)+c123_1[2](2,0)*c123_2[2](0,0)-c123_1[2](2,0)*c123_2[0](2,0)-c123_1[0](2,2)*c123_2[0](0,2)+c123_1[0](2,2)*c123_2[0](2,0);
  row(0,57) = c123_1[2](1,1)*c123_2[2](1,2)-c123_1[2](1,1)*c123_2[2](2,1)-c123_1[1](1,2)*c123_2[2](1,2)+c123_1[1](1,2)*c123_2[1](2,2)+c123_1[1](2,1)*c123_2[2](2,1)-c123_1[1](2,1)*c123_2[1](2,2);
  row(0,58) = c123_1[2](1,1)*c123_2[2](0,2)-c123_1[2](1,1)*c123_2[2](2,0)-c123_1[1](1,2)*c123_2[2](0,2)+c123_1[1](1,2)*c123_2[0](2,2)+c123_1[1](2,1)*c123_2[2](2,0)-c123_1[1](2,1)*c123_2[0](2,2);
  row(0,59) = c123_1[2](1,2)*c123_2[2](2,1)-c123_1[2](1,2)*c123_2[1](2,2)-c123_1[2](2,1)*c123_2[2](1,2)+c123_1[2](2,1)*c123_2[1](2,2)+c123_1[1](2,2)*c123_2[2](1,2)-c123_1[1](2,2)*c123_2[2](2,1);
  row(0,60) = c123_1[2](1,2)*c123_2[2](2,0)-c123_1[2](1,2)*c123_2[0](2,2)-c123_1[2](2,1)*c123_2[2](0,2)+c123_1[2](2,1)*c123_2[0](2,2)+c123_1[1](2,2)*c123_2[2](0,2)-c123_1[1](2,2)*c123_2[2](2,0);
  row(0,61) = c123_1[1](0,1)*c123_2[2](2,1)-c123_1[1](0,1)*c123_2[1](2,2)-c123_1[1](1,0)*c123_2[2](1,2)+c123_1[1](1,0)*c123_2[1](2,2)+c123_1[0](1,1)*c123_2[2](1,2)-c123_1[0](1,1)*c123_2[2](2,1);
  row(0,62) = c123_1[1](0,1)*c123_2[2](1,1)-c123_1[1](0,1)*c123_2[1](1,2)-c123_1[1](1,0)*c123_2[2](1,1)+c123_1[1](1,0)*c123_2[1](2,1)+c123_1[0](1,1)*c123_2[1](1,2)-c123_1[0](1,1)*c123_2[1](2,1);
  row(0,64) = c123_1[1](0,1)*c123_2[2](0,1)-c123_1[1](0,1)*c123_2[1](0,2)-c123_1[1](0,1)*c123_2[1](2,0)+c123_1[1](0,1)*c123_2[0](2,1)+c123_1[1](1,0)*c123_2[1](0,2)-c123_1[1](1,0)*c123_2[2](1,0)-c123_1[1](1,0)*c123_2[0](1,2)+c123_1[1](1,0)*c123_2[1](2,0)-c123_1[0](1,1)*c123_2[2](0,1)+c123_1[0](1,1)*c123_2[2](1,0)+c123_1[0](1,1)*c123_2[0](1,2)-c123_1[0](1,1)*c123_2[0](2,1);
  row(0,65) = -c123_1[1](0,1)*c123_2[1](1,0)+c123_1[1](0,1)*c123_2[0](1,1)+c123_1[1](1,0)*c123_2[1](0,1)-c123_1[1](1,0)*c123_2[0](1,1)-c123_1[0](1,1)*c123_2[1](0,1)+c123_1[0](1,1)*c123_2[1](1,0);
  row(0,66) = -c123_1[1](0,1)*c123_2[1](0,0)+c123_1[1](0,1)*c123_2[0](0,1)+c123_1[1](1,0)*c123_2[1](0,0)-c123_1[1](1,0)*c123_2[0](1,0)-c123_1[0](1,1)*c123_2[0](0,1)+c123_1[0](1,1)*c123_2[0](1,0);
  row(0,67) = -c123_1[2](0,1)*c123_2[2](2,1)+c123_1[2](0,1)*c123_2[1](2,2)-c123_1[1](0,2)*c123_2[2](2,1)+c123_1[1](0,2)*c123_2[1](2,2)+c123_1[2](1,0)*c123_2[2](1,2)-c123_1[2](1,0)*c123_2[1](2,2)-c123_1[0](1,2)*c123_2[2](1,2)+c123_1[0](1,2)*c123_2[2](2,1)+c123_1[1](2,0)*c123_2[2](1,2)-c123_1[1](2,0)*c123_2[1](2,2)-c123_1[0](2,1)*c123_2[2](1,2)+c123_1[0](2,1)*c123_2[2](2,1);
  row(0,68) = -c123_1[2](0,1)*c123_2[2](1,1)+c123_1[2](0,1)*c123_2[1](2,1)+c123_1[1](0,2)*c123_2[1](1,2)-c123_1[1](0,2)*c123_2[1](2,1)+c123_1[2](1,0)*c123_2[2](1,1)-c123_1[2](1,0)*c123_2[1](1,2)+c123_1[0](1,2)*c123_2[2](1,1)-c123_1[0](1,2)*c123_2[1](1,2)+c123_1[1](2,0)*c123_2[1](1,2)-c123_1[1](2,0)*c123_2[1](2,1)-c123_1[0](2,1)*c123_2[2](1,1)+c123_1[0](2,1)*c123_2[1](2,1);
  row(0,69) = -c123_1[2](0,1)*c123_2[2](0,1)+c123_1[2](0,1)*c123_2[1](2,0)+c123_1[1](0,2)*c123_2[1](0,2)-c123_1[1](0,2)*c123_2[0](2,1)-c123_1[2](1,0)*c123_2[1](0,2)+c123_1[2](1,0)*c123_2[2](1,0)+c123_1[0](1,2)*c123_2[2](0,1)-c123_1[0](1,2)*c123_2[0](1,2)+c123_1[1](2,0)*c123_2[0](1,2)-c123_1[1](2,0)*c123_2[1](2,0)-c123_1[0](2,1)*c123_2[2](1,0)+c123_1[0](2,1)*c123_2[0](2,1);
  row(0,70) = c123_1[2](0,2)*c123_2[2](2,1)-c123_1[2](0,2)*c123_2[1](2,2)-c123_1[2](2,0)*c123_2[2](1,2)+c123_1[2](2,0)*c123_2[1](2,2)+c123_1[0](2,2)*c123_2[2](1,2)-c123_1[0](2,2)*c123_2[2](2,1);
  row(0,71) = c123_1[2](0,1)*c123_2[1](1,2)-c123_1[2](0,1)*c123_2[1](2,1)-c123_1[1](0,2)*c123_2[2](1,1)+c123_1[1](0,2)*c123_2[1](2,1)+c123_1[2](1,0)*c123_2[1](1,2)-c123_1[2](1,0)*c123_2[1](2,1)-c123_1[0](1,2)*c123_2[2](1,1)+c123_1[0](1,2)*c123_2[1](2,1)+c123_1[1](2,0)*c123_2[2](1,1)-c123_1[1](2,0)*c123_2[1](1,2)+c123_1[0](2,1)*c123_2[2](1,1)-c123_1[0](2,1)*c123_2[1](1,2);
  row(0,73) = -c123_1[2](0,1)*c123_2[1](0,1)+c123_1[2](0,1)*c123_2[1](1,0)+c123_1[1](0,2)*c123_2[1](0,1)-c123_1[1](0,2)*c123_2[0](1,1)-c123_1[2](1,0)*c123_2[1](0,1)+c123_1[2](1,0)*c123_2[1](1,0)+c123_1[0](1,2)*c123_2[1](0,1)-c123_1[0](1,2)*c123_2[0](1,1)-c123_1[1](2,0)*c123_2[1](1,0)+c123_1[1](2,0)*c123_2[0](1,1)-c123_1[0](2,1)*c123_2[1](1,0)+c123_1[0](2,1)*c123_2[0](1,1);
  row(0,74) = c123_1[2](0,2)*c123_2[2](1,1)-c123_1[2](0,2)*c123_2[1](1,2)-c123_1[2](2,0)*c123_2[2](1,1)+c123_1[2](2,0)*c123_2[1](2,1)+c123_1[0](2,2)*c123_2[1](1,2)-c123_1[0](2,2)*c123_2[1](2,1);
  row(0,76) = c123_1[2](0,1)*c123_2[1](0,2)-c123_1[2](0,1)*c123_2[0](2,1)-c123_1[1](0,2)*c123_2[2](0,1)+c123_1[1](0,2)*c123_2[1](2,0)+c123_1[2](1,0)*c123_2[0](1,2)-c123_1[2](1,0)*c123_2[1](2,0)-c123_1[0](1,2)*c123_2[2](1,0)+c123_1[0](1,2)*c123_2[0](2,1)-c123_1[1](2,0)*c123_2[1](0,2)+c123_1[1](2,0)*c123_2[2](1,0)+c123_1[0](2,1)*c123_2[2](0,1)-c123_1[0](2,1)*c123_2[0](1,2);
  row(0,77) = c123_1[2](0,1)*c123_2[1](0,1)-c123_1[2](0,1)*c123_2[0](1,1)-c123_1[1](0,2)*c123_2[1](0,1)+c123_1[1](0,2)*c123_2[1](1,0)-c123_1[2](1,0)*c123_2[1](1,0)+c123_1[2](1,0)*c123_2[0](1,1)-c123_1[0](1,2)*c123_2[1](1,0)+c123_1[0](1,2)*c123_2[0](1,1)-c123_1[1](2,0)*c123_2[1](0,1)+c123_1[1](2,0)*c123_2[1](1,0)+c123_1[0](2,1)*c123_2[1](0,1)-c123_1[0](2,1)*c123_2[0](1,1);
  row(0,78) = c123_1[2](0,1)*c123_2[1](0,0)-c123_1[2](0,1)*c123_2[0](0,1)+c123_1[1](0,2)*c123_2[1](0,0)-c123_1[1](0,2)*c123_2[0](0,1)-c123_1[2](1,0)*c123_2[1](0,0)+c123_1[2](1,0)*c123_2[0](1,0)+c123_1[0](1,2)*c123_2[0](0,1)-c123_1[0](1,2)*c123_2[0](1,0)-c123_1[1](2,0)*c123_2[1](0,0)+c123_1[1](2,0)*c123_2[0](1,0)+c123_1[0](2,1)*c123_2[0](0,1)-c123_1[0](2,1)*c123_2[0](1,0);
  row(0,79) = c123_1[2](0,2)*c123_2[2](0,1)-c123_1[2](0,2)*c123_2[1](0,2)-c123_1[2](0,2)*c123_2[1](2,0)+c123_1[2](0,2)*c123_2[0](2,1)+c123_1[2](2,0)*c123_2[1](0,2)-c123_1[2](2,0)*c123_2[2](1,0)-c123_1[2](2,0)*c123_2[0](1,2)+c123_1[2](2,0)*c123_2[1](2,0)-c123_1[0](2,2)*c123_2[2](0,1)+c123_1[0](2,2)*c123_2[2](1,0)+c123_1[0](2,2)*c123_2[0](1,2)-c123_1[0](2,2)*c123_2[0](2,1);
  row(0,80) = -c123_1[2](0,2)*c123_2[1](1,0)+c123_1[2](0,2)*c123_2[0](1,1)+c123_1[2](2,0)*c123_2[1](0,1)-c123_1[2](2,0)*c123_2[0](1,1)-c123_1[0](2,2)*c123_2[1](0,1)+c123_1[0](2,2)*c123_2[1](1,0);
  row(0,81) = c123_1[2](0,2)*c123_2[0](0,1)-c123_1[2](0,2)*c123_2[1](0,0)+c123_1[2](2,0)*c123_2[1](0,0)-c123_1[2](2,0)*c123_2[0](1,0)-c123_1[0](2,2)*c123_2[0](0,1)+c123_1[0](2,2)*c123_2[0](1,0);
  row(0,82) = -c123_1[2](1,1)*c123_2[2](1,2)+c123_1[2](1,1)*c123_2[2](2,1)+c123_1[1](1,2)*c123_2[2](1,2)-c123_1[1](1,2)*c123_2[1](2,2)-c123_1[1](2,1)*c123_2[2](2,1)+c123_1[1](2,1)*c123_2[1](2,2);
  row(0,83) = c123_1[2](1,1)*c123_2[1](1,2)-c123_1[2](1,1)*c123_2[1](2,1)-c123_1[1](1,2)*c123_2[2](1,1)+c123_1[1](1,2)*c123_2[1](2,1)+c123_1[1](2,1)*c123_2[2](1,1)-c123_1[1](2,1)*c123_2[1](1,2);
  row(0,84) = c123_1[2](1,1)*c123_2[2](0,1)+c123_1[2](1,1)*c123_2[1](0,2)-c123_1[2](1,1)*c123_2[2](1,0)-c123_1[2](1,1)*c123_2[1](2,0)-c123_1[1](1,2)*c123_2[2](0,1)-c123_1[1](1,2)*c123_2[1](0,2)+c123_1[1](1,2)*c123_2[0](1,2)+c123_1[1](1,2)*c123_2[0](2,1)+c123_1[1](2,1)*c123_2[2](1,0)-c123_1[1](2,1)*c123_2[0](1,2)+c123_1[1](2,1)*c123_2[1](2,0)-c123_1[1](2,1)*c123_2[0](2,1);
  row(0,85) = -c123_1[2](1,2)*c123_2[2](2,1)+c123_1[2](1,2)*c123_2[1](2,2)+c123_1[2](2,1)*c123_2[2](1,2)-c123_1[2](2,1)*c123_2[1](2,2)-c123_1[1](2,2)*c123_2[2](1,2)+c123_1[1](2,2)*c123_2[2](2,1);
  row(0,86) = c123_1[2](1,2)*c123_2[2](1,1)-c123_1[2](1,2)*c123_2[1](1,2)-c123_1[2](2,1)*c123_2[2](1,1)+c123_1[2](2,1)*c123_2[1](2,1)+c123_1[1](2,2)*c123_2[1](1,2)-c123_1[1](2,2)*c123_2[1](2,1);
  row(0,87) = c123_1[2](1,2)*c123_2[2](1,0)-c123_1[2](1,2)*c123_2[0](1,2)+c123_1[2](1,2)*c123_2[1](2,0)-c123_1[2](1,2)*c123_2[0](2,1)-c123_1[2](2,1)*c123_2[2](0,1)-c123_1[2](2,1)*c123_2[1](0,2)+c123_1[2](2,1)*c123_2[0](1,2)+c123_1[2](2,1)*c123_2[0](2,1)+c123_1[1](2,2)*c123_2[2](0,1)+c123_1[1](2,2)*c123_2[1](0,2)-c123_1[1](2,2)*c123_2[2](1,0)-c123_1[1](2,2)*c123_2[1](2,0);
  row(0,89) = -c123_1[2](1,1)*c123_2[1](1,2)+c123_1[2](1,1)*c123_2[1](2,1)+c123_1[1](1,2)*c123_2[2](1,1)-c123_1[1](1,2)*c123_2[1](2,1)-c123_1[1](2,1)*c123_2[2](1,1)+c123_1[1](2,1)*c123_2[1](1,2);
  row(0,91) = c123_1[2](1,1)*c123_2[1](0,1)-c123_1[2](1,1)*c123_2[1](1,0)-c123_1[1](1,2)*c123_2[1](0,1)+c123_1[1](1,2)*c123_2[0](1,1)+c123_1[1](2,1)*c123_2[1](1,0)-c123_1[1](2,1)*c123_2[0](1,1);
  row(0,92) = -c123_1[2](1,2)*c123_2[2](1,1)+c123_1[2](1,2)*c123_2[1](1,2)+c123_1[2](2,1)*c123_2[2](1,1)-c123_1[2](2,1)*c123_2[1](2,1)-c123_1[1](2,2)*c123_2[1](1,2)+c123_1[1](2,2)*c123_2[1](2,1);
  row(0,94) = c123_1[2](1,2)*c123_2[1](1,0)-c123_1[2](1,2)*c123_2[0](1,1)-c123_1[2](2,1)*c123_2[1](0,1)+c123_1[2](2,1)*c123_2[0](1,1)+c123_1[1](2,2)*c123_2[1](0,1)-c123_1[1](2,2)*c123_2[1](1,0);
  row(0,97) = c123_1[1](0,1)*c123_2[2](2,0)-c123_1[1](0,1)*c123_2[0](2,2)-c123_1[1](1,0)*c123_2[2](0,2)+c123_1[1](1,0)*c123_2[0](2,2)+c123_1[0](1,1)*c123_2[2](0,2)-c123_1[0](1,1)*c123_2[2](2,0);
  row(0,98) = c123_1[1](0,1)*c123_2[2](1,0)-c123_1[1](0,1)*c123_2[0](1,2)+c123_1[1](0,1)*c123_2[1](2,0)-c123_1[1](0,1)*c123_2[0](2,1)-c123_1[1](1,0)*c123_2[2](0,1)-c123_1[1](1,0)*c123_2[1](0,2)+c123_1[1](1,0)*c123_2[0](1,2)+c123_1[1](1,0)*c123_2[0](2,1)+c123_1[0](1,1)*c123_2[2](0,1)+c123_1[0](1,1)*c123_2[1](0,2)-c123_1[0](1,1)*c123_2[2](1,0)-c123_1[0](1,1)*c123_2[1](2,0);
  row(0,99) = c123_1[1](0,1)*c123_2[1](1,0)-c123_1[1](0,1)*c123_2[0](1,1)-c123_1[1](1,0)*c123_2[1](0,1)+c123_1[1](1,0)*c123_2[0](1,1)+c123_1[0](1,1)*c123_2[1](0,1)-c123_1[0](1,1)*c123_2[1](1,0);
  row(0,100) = c123_1[1](0,1)*c123_2[2](0,0)-c123_1[1](0,1)*c123_2[0](0,2)-c123_1[1](1,0)*c123_2[2](0,0)+c123_1[1](1,0)*c123_2[0](2,0)+c123_1[0](1,1)*c123_2[0](0,2)-c123_1[0](1,1)*c123_2[0](2,0);
  row(0,101) = c123_1[1](0,1)*c123_2[1](0,0)-c123_1[1](0,1)*c123_2[0](0,1)-c123_1[1](1,0)*c123_2[1](0,0)+c123_1[1](1,0)*c123_2[0](1,0)+c123_1[0](1,1)*c123_2[0](0,1)-c123_1[0](1,1)*c123_2[0](1,0);
  row(0,103) = -c123_1[2](0,1)*c123_2[2](2,0)+c123_1[2](0,1)*c123_2[0](2,2)-c123_1[1](0,2)*c123_2[2](2,0)+c123_1[1](0,2)*c123_2[0](2,2)+c123_1[2](1,0)*c123_2[2](0,2)-c123_1[2](1,0)*c123_2[0](2,2)-c123_1[0](1,2)*c123_2[2](0,2)+c123_1[0](1,2)*c123_2[2](2,0)+c123_1[1](2,0)*c123_2[2](0,2)-c123_1[1](2,0)*c123_2[0](2,2)-c123_1[0](2,1)*c123_2[2](0,2)+c123_1[0](2,1)*c123_2[2](2,0);
  row(0,104) = -c123_1[2](0,1)*c123_2[2](1,0)+c123_1[2](0,1)*c123_2[0](2,1)+c123_1[1](0,2)*c123_2[0](1,2)-c123_1[1](0,2)*c123_2[1](2,0)+c123_1[2](1,0)*c123_2[2](0,1)-c123_1[2](1,0)*c123_2[0](1,2)-c123_1[0](1,2)*c123_2[1](0,2)+c123_1[0](1,2)*c123_2[2](1,0)+c123_1[1](2,0)*c123_2[1](0,2)-c123_1[1](2,0)*c123_2[0](2,1)-c123_1[0](2,1)*c123_2[2](0,1)+c123_1[0](2,1)*c123_2[1](2,0);
  row(0,105) = -c123_1[2](0,1)*c123_2[2](0,0)+c123_1[2](0,1)*c123_2[0](2,0)+c123_1[1](0,2)*c123_2[0](0,2)-c123_1[1](0,2)*c123_2[0](2,0)+c123_1[2](1,0)*c123_2[2](0,0)-c123_1[2](1,0)*c123_2[0](0,2)+c123_1[0](1,2)*c123_2[2](0,0)-c123_1[0](1,2)*c123_2[0](0,2)+c123_1[1](2,0)*c123_2[0](0,2)-c123_1[1](2,0)*c123_2[0](2,0)-c123_1[0](2,1)*c123_2[2](0,0)+c123_1[0](2,1)*c123_2[0](2,0);
  row(0,106) = c123_1[2](0,2)*c123_2[2](2,0)-c123_1[2](0,2)*c123_2[0](2,2)-c123_1[2](2,0)*c123_2[2](0,2)+c123_1[2](2,0)*c123_2[0](2,2)+c123_1[0](2,2)*c123_2[2](0,2)-c123_1[0](2,2)*c123_2[2](2,0);
  row(0,107) = c123_1[2](0,1)*c123_2[0](1,2)-c123_1[2](0,1)*c123_2[1](2,0)-c123_1[1](0,2)*c123_2[2](1,0)+c123_1[1](0,2)*c123_2[0](2,1)+c123_1[2](1,0)*c123_2[1](0,2)-c123_1[2](1,0)*c123_2[0](2,1)-c123_1[0](1,2)*c123_2[2](0,1)+c123_1[0](1,2)*c123_2[1](2,0)+c123_1[1](2,0)*c123_2[2](0,1)-c123_1[1](2,0)*c123_2[0](1,2)-c123_1[0](2,1)*c123_2[1](0,2)+c123_1[0](2,1)*c123_2[2](1,0);
  row(0,108) = -c123_1[2](0,1)*c123_2[1](1,0)+c123_1[2](0,1)*c123_2[0](1,1)-c123_1[1](0,2)*c123_2[1](1,0)+c123_1[1](0,2)*c123_2[0](1,1)+c123_1[2](1,0)*c123_2[1](0,1)-c123_1[2](1,0)*c123_2[0](1,1)-c123_1[0](1,2)*c123_2[1](0,1)+c123_1[0](1,2)*c123_2[1](1,0)+c123_1[1](2,0)*c123_2[1](0,1)-c123_1[1](2,0)*c123_2[0](1,1)-c123_1[0](2,1)*c123_2[1](0,1)+c123_1[0](2,1)*c123_2[1](1,0);
  row(0,109) = -c123_1[2](0,1)*c123_2[1](0,0)+c123_1[2](0,1)*c123_2[0](1,0)+c123_1[1](0,2)*c123_2[0](0,1)-c123_1[1](0,2)*c123_2[0](1,0)+c123_1[2](1,0)*c123_2[1](0,0)-c123_1[2](1,0)*c123_2[0](0,1)+c123_1[0](1,2)*c123_2[1](0,0)-c123_1[0](1,2)*c123_2[0](0,1)+c123_1[1](2,0)*c123_2[0](0,1)-c123_1[1](2,0)*c123_2[0](1,0)-c123_1[0](2,1)*c123_2[1](0,0)+c123_1[0](2,1)*c123_2[0](1,0);
  row(0,110) = c123_1[2](0,2)*c123_2[2](1,0)-c123_1[2](0,2)*c123_2[0](1,2)+c123_1[2](0,2)*c123_2[1](2,0)-c123_1[2](0,2)*c123_2[0](2,1)-c123_1[2](2,0)*c123_2[2](0,1)-c123_1[2](2,0)*c123_2[1](0,2)+c123_1[2](2,0)*c123_2[0](1,2)+c123_1[2](2,0)*c123_2[0](2,1)+c123_1[0](2,2)*c123_2[2](0,1)+c123_1[0](2,2)*c123_2[1](0,2)-c123_1[0](2,2)*c123_2[2](1,0)-c123_1[0](2,2)*c123_2[1](2,0);
  row(0,111) = c123_1[2](0,2)*c123_2[1](1,0)-c123_1[2](0,2)*c123_2[0](1,1)-c123_1[2](2,0)*c123_2[1](0,1)+c123_1[2](2,0)*c123_2[0](1,1)+c123_1[0](2,2)*c123_2[1](0,1)-c123_1[0](2,2)*c123_2[1](1,0);
  row(0,112) = c123_1[2](0,1)*c123_2[0](0,2)-c123_1[2](0,1)*c123_2[0](2,0)-c123_1[1](0,2)*c123_2[2](0,0)+c123_1[1](0,2)*c123_2[0](2,0)+c123_1[2](1,0)*c123_2[0](0,2)-c123_1[2](1,0)*c123_2[0](2,0)-c123_1[0](1,2)*c123_2[2](0,0)+c123_1[0](1,2)*c123_2[0](2,0)+c123_1[1](2,0)*c123_2[2](0,0)-c123_1[1](2,0)*c123_2[0](0,2)+c123_1[0](2,1)*c123_2[2](0,0)-c123_1[0](2,1)*c123_2[0](0,2);
  row(0,113) = c123_1[2](0,1)*c123_2[0](0,1)-c123_1[2](0,1)*c123_2[0](1,0)-c123_1[1](0,2)*c123_2[1](0,0)+c123_1[1](0,2)*c123_2[0](1,0)+c123_1[2](1,0)*c123_2[0](0,1)-c123_1[2](1,0)*c123_2[0](1,0)-c123_1[0](1,2)*c123_2[1](0,0)+c123_1[0](1,2)*c123_2[0](1,0)+c123_1[1](2,0)*c123_2[1](0,0)-c123_1[1](2,0)*c123_2[0](0,1)+c123_1[0](2,1)*c123_2[1](0,0)-c123_1[0](2,1)*c123_2[0](0,1);
  row(0,115) = c123_1[2](0,2)*c123_2[2](0,0)-c123_1[2](0,2)*c123_2[0](0,2)-c123_1[2](2,0)*c123_2[2](0,0)+c123_1[2](2,0)*c123_2[0](2,0)+c123_1[0](2,2)*c123_2[0](0,2)-c123_1[0](2,2)*c123_2[0](2,0);
  row(0,116) = c123_1[2](0,2)*c123_2[1](0,0)-c123_1[2](0,2)*c123_2[0](0,1)-c123_1[2](2,0)*c123_2[1](0,0)+c123_1[2](2,0)*c123_2[0](1,0)+c123_1[0](2,2)*c123_2[0](0,1)-c123_1[0](2,2)*c123_2[0](1,0);
  row(0,118) = -c123_1[2](1,1)*c123_2[2](0,2)+c123_1[2](1,1)*c123_2[2](2,0)+c123_1[1](1,2)*c123_2[2](0,2)-c123_1[1](1,2)*c123_2[0](2,2)-c123_1[1](2,1)*c123_2[2](2,0)+c123_1[1](2,1)*c123_2[0](2,2);
  row(0,119) = -c123_1[2](1,1)*c123_2[2](0,1)+c123_1[2](1,1)*c123_2[2](1,0)+c123_1[2](1,1)*c123_2[0](1,2)-c123_1[2](1,1)*c123_2[0](2,1)+c123_1[1](1,2)*c123_2[1](0,2)-c123_1[1](1,2)*c123_2[2](1,0)-c123_1[1](1,2)*c123_2[0](1,2)+c123_1[1](1,2)*c123_2[1](2,0)+c123_1[1](2,1)*c123_2[2](0,1)-c123_1[1](2,1)*c123_2[1](0,2)-c123_1[1](2,1)*c123_2[1](2,0)+c123_1[1](2,1)*c123_2[0](2,1);
  row(0,120) = c123_1[2](1,1)*c123_2[0](0,2)-c123_1[2](1,1)*c123_2[0](2,0)-c123_1[1](1,2)*c123_2[2](0,0)+c123_1[1](1,2)*c123_2[0](2,0)+c123_1[1](2,1)*c123_2[2](0,0)-c123_1[1](2,1)*c123_2[0](0,2);
  row(0,121) = -c123_1[2](1,2)*c123_2[2](2,0)+c123_1[2](1,2)*c123_2[0](2,2)+c123_1[2](2,1)*c123_2[2](0,2)-c123_1[2](2,1)*c123_2[0](2,2)-c123_1[1](2,2)*c123_2[2](0,2)+c123_1[1](2,2)*c123_2[2](2,0);
  row(0,122) = c123_1[2](1,2)*c123_2[2](0,1)-c123_1[2](1,2)*c123_2[1](0,2)-c123_1[2](1,2)*c123_2[1](2,0)+c123_1[2](1,2)*c123_2[0](2,1)+c123_1[2](2,1)*c123_2[1](0,2)-c123_1[2](2,1)*c123_2[2](1,0)-c123_1[2](2,1)*c123_2[0](1,2)+c123_1[2](2,1)*c123_2[1](2,0)-c123_1[1](2,2)*c123_2[2](0,1)+c123_1[1](2,2)*c123_2[2](1,0)+c123_1[1](2,2)*c123_2[0](1,2)-c123_1[1](2,2)*c123_2[0](2,1);
  row(0,123) = c123_1[2](1,2)*c123_2[2](0,0)-c123_1[2](1,2)*c123_2[0](0,2)-c123_1[2](2,1)*c123_2[2](0,0)+c123_1[2](2,1)*c123_2[0](2,0)+c123_1[1](2,2)*c123_2[0](0,2)-c123_1[1](2,2)*c123_2[0](2,0);
  row(0,125) = -c123_1[2](1,1)*c123_2[1](0,2)-c123_1[2](1,1)*c123_2[0](1,2)+c123_1[2](1,1)*c123_2[1](2,0)+c123_1[2](1,1)*c123_2[0](2,1)+c123_1[1](1,2)*c123_2[2](0,1)+c123_1[1](1,2)*c123_2[2](1,0)-c123_1[1](1,2)*c123_2[1](2,0)-c123_1[1](1,2)*c123_2[0](2,1)-c123_1[1](2,1)*c123_2[2](0,1)+c123_1[1](2,1)*c123_2[1](0,2)-c123_1[1](2,1)*c123_2[2](1,0)+c123_1[1](2,1)*c123_2[0](1,2);
  row(0,126) = -c123_1[2](1,1)*c123_2[1](0,1)+c123_1[2](1,1)*c123_2[1](1,0)+c123_1[1](1,2)*c123_2[1](0,1)-c123_1[1](1,2)*c123_2[0](1,1)-c123_1[1](2,1)*c123_2[1](1,0)+c123_1[1](2,1)*c123_2[0](1,1);
  row(0,127) = c123_1[2](1,1)*c123_2[0](0,1)-c123_1[2](1,1)*c123_2[0](1,0)-c123_1[1](1,2)*c123_2[1](0,0)+c123_1[1](1,2)*c123_2[0](1,0)+c123_1[1](2,1)*c123_2[1](0,0)-c123_1[1](2,1)*c123_2[0](0,1);
  row(0,128) = -c123_1[2](1,2)*c123_2[2](0,1)+c123_1[2](1,2)*c123_2[1](0,2)-c123_1[2](1,2)*c123_2[2](1,0)+c123_1[2](1,2)*c123_2[0](1,2)+c123_1[2](2,1)*c123_2[2](0,1)+c123_1[2](2,1)*c123_2[2](1,0)-c123_1[2](2,1)*c123_2[1](2,0)-c123_1[2](2,1)*c123_2[0](2,1)-c123_1[1](2,2)*c123_2[1](0,2)-c123_1[1](2,2)*c123_2[0](1,2)+c123_1[1](2,2)*c123_2[1](2,0)+c123_1[1](2,2)*c123_2[0](2,1);
  row(0,129) = -c123_1[2](1,2)*c123_2[1](1,0)+c123_1[2](1,2)*c123_2[0](1,1)+c123_1[2](2,1)*c123_2[1](0,1)-c123_1[2](2,1)*c123_2[0](1,1)-c123_1[1](2,2)*c123_2[1](0,1)+c123_1[1](2,2)*c123_2[1](1,0);
  row(0,130) = c123_1[2](1,2)*c123_2[1](0,0)-c123_1[2](1,2)*c123_2[0](0,1)-c123_1[2](2,1)*c123_2[1](0,0)+c123_1[2](2,1)*c123_2[0](1,0)+c123_1[1](2,2)*c123_2[0](0,1)-c123_1[1](2,2)*c123_2[0](1,0);
  row(0,133) = -c123_1[2](1,1)*c123_2[0](0,2)+c123_1[2](1,1)*c123_2[0](2,0)+c123_1[1](1,2)*c123_2[2](0,0)-c123_1[1](1,2)*c123_2[0](2,0)-c123_1[1](2,1)*c123_2[2](0,0)+c123_1[1](2,1)*c123_2[0](0,2);
  row(0,134) = -c123_1[2](1,1)*c123_2[0](0,1)+c123_1[2](1,1)*c123_2[0](1,0)+c123_1[1](1,2)*c123_2[1](0,0)-c123_1[1](1,2)*c123_2[0](1,0)-c123_1[1](2,1)*c123_2[1](0,0)+c123_1[1](2,1)*c123_2[0](0,1);
  row(0,136) = -c123_1[2](1,2)*c123_2[2](0,0)+c123_1[2](1,2)*c123_2[0](0,2)+c123_1[2](2,1)*c123_2[2](0,0)-c123_1[2](2,1)*c123_2[0](2,0)-c123_1[1](2,2)*c123_2[0](0,2)+c123_1[1](2,2)*c123_2[0](2,0);
  row(0,137) = -c123_1[2](1,2)*c123_2[1](0,0)+c123_1[2](1,2)*c123_2[0](0,1)+c123_1[2](2,1)*c123_2[1](0,0)-c123_1[2](2,1)*c123_2[0](1,0)-c123_1[1](2,2)*c123_2[0](0,1)+c123_1[1](2,2)*c123_2[0](1,0);
  return row;
};

void
opengv::relative_pose::modules::fivept_kneip::initMatrix(
    Eigen::Matrix<double,66,197> & groebnerMatrix)
{
  groebnerMatrix(10,169) = 1;
  groebnerMatrix(10,177) = 1;
  groebnerMatrix(10,186) = 1;
  groebnerMatrix(10,196) = -1;
  groebnerMatrix(11,166) = 1;
  groebnerMatrix(11,174) = 1;
  groebnerMatrix(11,183) = 1;
  groebnerMatrix(12,163) = 1;
  groebnerMatrix(12,171) = 1;
  groebnerMatrix(12,180) = 1;
  groebnerMatrix(13,151) = 1;
  groebnerMatrix(13,156) = 1;
  groebnerMatrix(13,162) = 1;
  groebnerMatrix(13,196) = -1;
  groebnerMatrix(14,148) = 1;
  groebnerMatrix(14,153) = 1;
  groebnerMatrix(14,159) = 1;
  groebnerMatrix(15,142) = 1;
  groebnerMatrix(15,144) = 1;
  groebnerMatrix(15,147) = 1;
  groebnerMatrix(15,196) = -1;
  groebnerMatrix(16,154) = -1;
  groebnerMatrix(16,158) = 1;
  groebnerMatrix(16,193) = -1;
  groebnerMatrix(17,172) = 1;
  groebnerMatrix(17,179) = -1;
  groebnerMatrix(17,190) = -1;
  groebnerMatrix(18,175) = -1;
  groebnerMatrix(18,182) = 1;
  groebnerMatrix(18,187) = -1;
  groebnerMatrix(19,149) = -1;
  groebnerMatrix(19,152) = 1;
  groebnerMatrix(19,195) = -1;
  groebnerMatrix(20,164) = 1;
  groebnerMatrix(20,170) = -1;
  groebnerMatrix(20,192) = -1;
  groebnerMatrix(21,167) = -1;
  groebnerMatrix(21,173) = 1;
  groebnerMatrix(21,189) = -1;
  groebnerMatrix(22,147) = 1;
  groebnerMatrix(22,162) = 1;
  groebnerMatrix(22,186) = 1;
  groebnerMatrix(22,196) = -1;
  groebnerMatrix(23,146) = 1;
  groebnerMatrix(23,161) = 1;
  groebnerMatrix(23,185) = 1;
  groebnerMatrix(24,145) = 1;
  groebnerMatrix(24,160) = 1;
  groebnerMatrix(24,184) = 1;
  groebnerMatrix(25,144) = 1;
  groebnerMatrix(25,156) = 1;
  groebnerMatrix(25,177) = 1;
  groebnerMatrix(25,196) = -1;
  groebnerMatrix(26,143) = 1;
  groebnerMatrix(26,155) = 1;
  groebnerMatrix(26,176) = 1;
  groebnerMatrix(27,168) = 1;
  groebnerMatrix(27,181) = -1;
  groebnerMatrix(27,188) = -1;
  groebnerMatrix(28,150) = 1;
  groebnerMatrix(28,157) = -1;
  groebnerMatrix(28,194) = -1;
  groebnerMatrix(29,165) = -1;
  groebnerMatrix(29,178) = 1;
  groebnerMatrix(29,191) = -1;
}
