/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/*
* This script compiles modules for evaluating polynomial functions. If any polynomial coefficients change, this script should be rerun to update the compiled files.
*/
'use strict';

// MODULES //

var resolve = require( 'path' ).resolve;
var writeFileSync = require( '@stdlib/fs/write-file' ).sync;
var licenseHeader = require( '@stdlib/_tools/licenses/header' );
var compile = require( './../../../../base/tools/evalrational-compile' );


// VARIABLES //

// Polynomial coefficients ordered in ascending degree...

// S(x) for small x:
var PS = [
	3.18016297876567817986E11,
	-4.42979518059697779103E10,
	2.54890880573376359104E9,
	-6.29741486205862506537E7,
	7.08840045257738576863E5,
	-2.99181919401019853726E3,
	0.0
];

var QS = [
	6.07366389490084639049E11,
	2.24411795645340920940E10,
	4.19320245898111231129E8,
	5.17343888770096400730E6,
	4.55847810806532581675E4,
	2.81376268889994315696E2,
	1.00000000000000000000E0
];

// Auxiliary function f(x):
var PF = [
	3.76329711269987889006E-20,
	1.34283276233062758925E-16,
	1.72010743268161828879E-13,
	1.02304514164907233465E-10,
	3.05568983790257605827E-8,
	4.63613749287867322088E-6,
	3.45017939782574027900E-4,
	1.15220955073585758835E-2,
	1.43407919780758885261E-1,
	4.21543555043677546506E-1,
	0.0
];

var QF = [
	1.25443237090011264384E-20,
	4.52001434074129701496E-17,
	5.88754533621578410010E-14,
	3.60140029589371370404E-11,
	1.12699224763999035261E-8,
	1.84627567348930545870E-6,
	1.55934409164153020873E-4,
	6.44051526508858611005E-3,
	1.16888925859191382142E-1,
	7.51586398353378947175E-1,
	1.00000000000000000000E0
];

// Auxiliary function g(x):
var PG = [
	1.86958710162783235106E-22,
	8.36354435630677421531E-19,
	1.37555460633261799868E-15,
	1.08268041139020870318E-12,
	4.45344415861750144738E-10,
	9.82852443688422223854E-8,
	1.15138826111884280931E-5,
	6.84079380915393090172E-4,
	1.87648584092575249293E-2,
	1.97102833525523411709E-1,
	5.04442073643383265887E-1,
	0.0
];

var QG = [
	1.86958710162783236342E-22,
	8.39158816283118707363E-19,
	1.38796531259578871258E-15,
	1.10273215066240270757E-12,
	4.60680728146520428211E-10,
	1.04314589657571990585E-7,
	1.27545075667729118702E-5,
	8.14679107184306179049E-4,
	2.53603741420338795122E-2,
	3.37748989120019970451E-1,
	1.47495759925128324529E0,
	1.00000000000000000000E0
];

// Header to add to output files:
var header = licenseHeader( 'Apache-2.0', 'js', {
	'year': ( new Date() ).getFullYear(),
	'copyright': 'The Stdlib Authors'
});
header += '\n/* This is a generated file. Do not edit directly. */\n';


// MAIN //

/**
* Main execution sequence.
*
* @private
*/
function main() {
	var fpath;
	var opts;
	var str;

	opts = {
		'encoding': 'utf8'
	};

	fpath = resolve( __dirname, '..', 'lib', 'rational_psqs.js' );
	str = header + compile( PS, QS );
	writeFileSync( fpath, str, opts );

	fpath = resolve( __dirname, '..', 'lib', 'rational_pfqf.js' );
	str = header + compile( PF, QF );
	writeFileSync( fpath, str, opts );

	fpath = resolve( __dirname, '..', 'lib', 'rational_pgqg.js' );
	str = header + compile( PG, QG );
	writeFileSync( fpath, str, opts );
}

main();
