
template = """\
/*
 * Copyright (c) 2018 Valve Corporation
 *
 * SPDX-License-Identifier: MIT
 *
 * This file was generated by aco_opcodes_cpp.py
 */

#include "aco_ir.h"

namespace aco {

<%
opcode_names = sorted(instructions.keys())
is_atomic = "".join([instructions[name].is_atomic for name in reversed(opcode_names)])
# Record which operand of each instruction can use modifiers.
operand_mods = dict();
for name in opcode_names:
    op_mods = 0
    for operand in reversed(instructions[name].operands):
        op_mods <<= 1
        op_mods |= int(operand.mods)
    operand_mods[name] = op_mods
%>

extern const aco::Info instr_info = {
   {
      % for name in opcode_names:
      ${instructions[name].op.gfx7},
      % endfor
   },
   {
      % for name in opcode_names:
      ${instructions[name].op.gfx9},
      % endfor
   },
   {
      % for name in opcode_names:
      ${instructions[name].op.gfx10},
      % endfor
   },
   {
      % for name in opcode_names:
      ${instructions[name].op.gfx11},
      % endfor
   },
   {
      % for name in opcode_names:
      ${instructions[name].op.gfx12},
      % endfor
   },
   std::bitset<${len(opcode_names)}>("${is_atomic}"),
   {
      % for name in opcode_names:
      "${name}",
      % endfor
   },
   {
      % for name in opcode_names:
      aco::Format::${str(instructions[name].format.name)},
      % endfor
   },
   {
      % for name in opcode_names:
      instr_class::${instructions[name].cls.value},
      % endfor
   },
   {
      % for name in opcode_names:
      { // ${name}
         ${len(instructions[name].operands)},
         ${len(instructions[name].definitions)},
         ${operand_mods[name]},
         ${int(instructions[name].definitions[0].mods) if len(instructions[name].definitions) > 0 else 0},
         {
            % for operand in instructions[name].operands:
            {
               ${operand.base_type.name},
               ${operand.num_components},
               ${operand.bit_size},
            },
            % endfor
         },
         {
            % for definition in instructions[name].definitions:
            {
               ${definition.base_type.name},
               ${definition.num_components},
               ${definition.bit_size},
            },
            % endfor
         },
         {
            % for operand in instructions[name].operands:
               ${operand.fixed_reg.name},
            % endfor
         },
         {
            % for definition in instructions[name].definitions:
               ${definition.fixed_reg.name},
            % endfor
         },
      },
      % endfor
   },
};

}
"""

from aco_opcodes import instructions
from mako.template import Template

print(Template(template).render(instructions=instructions))
