/* ----- encode/1013x2393, derived from supercop/crypto_encode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *encode_1013x2393_checksums[] = {
  "7bd429942f70bf35593f20e0a981927eea259a8517f2c7c8da975da324e6a762",
  "3e1a3c979172f41df76417f9ca1a180968aae86857b6e9194f885622e33ac44c",
} ;

static void (*crypto_encode)(unsigned char *,const void *);
#define crypto_encode_STRBYTES ntruprime_encode_1013x2393_STRBYTES
#define crypto_encode_ITEMS ntruprime_encode_1013x2393_ITEMS
#define crypto_encode_ITEMBYTES ntruprime_encode_1013x2393_ITEMBYTES

static void *storage_encode_1013x2393_s;
static unsigned char *test_encode_1013x2393_s;
static void *storage_encode_1013x2393_x;
static unsigned char *test_encode_1013x2393_x;
static void *storage_encode_1013x2393_s2;
static unsigned char *test_encode_1013x2393_s2;
static void *storage_encode_1013x2393_x2;
static unsigned char *test_encode_1013x2393_x2;

#define precomputed_encode_1013x2393_NUM 4

static const unsigned char precomputed_encode_1013x2393_s[precomputed_encode_1013x2393_NUM][crypto_encode_STRBYTES] = {
  {197,185,15,210,99,100,49,138,107,58,58,117,197,208,201,61,132,190,165,172,85,240,58,133,165,149,52,31,2,149,65,147,59,103,45,126,159,146,134,34,189,46,219,209,178,6,109,191,132,251,19,71,107,109,246,242,22,76,129,56,139,124,106,148,103,242,140,162,179,173,218,240,23,244,208,113,158,21,68,130,24,197,129,186,37,145,103,202,184,193,120,39,47,113,117,117,185,254,43,46,60,148,232,26,124,227,30,158,30,30,99,242,79,145,122,223,247,143,190,79,170,175,109,161,73,253,129,215,80,132,14,14,166,207,81,18,251,136,192,224,161,169,139,149,211,236,152,24,157,69,173,71,191,224,188,118,239,37,202,4,192,80,94,42,146,226,98,205,27,205,131,149,10,0,241,35,55,199,43,65,169,40,142,201,112,234,171,142,98,226,204,97,34,33,40,225,187,91,117,249,104,222,100,152,214,46,249,215,30,152,188,220,177,26,167,46,213,128,148,7,178,93,147,80,207,196,114,57,88,30,255,148,232,109,147,212,79,180,118,159,180,82,96,161,221,170,242,231,163,216,30,232,150,24,90,105,72,172,203,159,253,119,28,245,43,30,184,64,18,223,170,249,139,204,26,24,14,186,76,68,131,87,22,224,60,248,71,49,121,126,125,120,103,141,161,112,155,128,158,220,223,180,60,148,7,233,74,182,10,114,230,235,60,196,111,124,178,44,216,224,117,230,76,86,97,118,29,71,203,250,79,117,231,4,85,152,248,201,18,114,10,19,52,86,238,172,85,138,159,105,52,37,138,222,204,23,207,50,173,164,206,52,34,180,207,123,153,33,162,90,91,218,200,227,83,26,29,83,127,190,129,249,35,203,181,102,49,115,111,1,231,11,145,119,6,121,111,224,97,219,23,197,31,30,75,245,203,207,209,108,48,178,236,154,170,222,145,88,165,82,128,65,251,36,143,119,242,158,248,31,232,175,136,236,158,121,201,124,136,9,177,232,234,75,175,97,212,151,144,16,34,191,114,25,22,149,136,139,125,234,199,183,7,27,229,52,237,157,206,201,168,214,29,62,135,10,233,115,140,207,173,141,175,214,214,7,217,226,71,107,233,213,87,131,188,32,107,4,197,54,242,82,128,49,142,2,157,95,243,125,105,217,196,177,246,92,221,81,10,111,212,191,238,41,147,250,98,6,25,34,215,248,71,157,132,50,26,11,105,200,231,110,57,46,113,191,20,249,35,238,255,248,202,38,113,37,165,181,125,182,220,42,110,230,179,233,126,12,86,12,74,185,229,10,181,28,51,119,30,76,207,124,115,197,211,54,249,134,124,4,175,102,142,132,56,138,164,37,89,71,254,137,31,160,67,15,106,208,59,42,143,97,88,73,227,55,221,114,231,19,181,219,203,230,253,167,122,114,87,37,244,48,141,222,119,62,47,183,56,140,118,49,229,35,246,91,149,233,115,188,105,68,116,5,2,232,231,216,103,229,147,235,195,98,6,175,151,64,46,252,61,72,1,81,91,210,207,137,108,90,56,255,147,27,191,235,31,0,40,233,159,133,130,28,58,28,156,152,73,96,6,95,13,112,181,52,163,111,137,222,194,166,254,168,107,103,184,251,147,52,2,150,112,155,43,235,189,195,98,207,88,4,95,211,239,189,246,7,15,156,52,222,203,145,16,118,182,228,62,159,14,25,36,62,169,220,2,166,172,59,92,152,48,15,84,127,89,44,106,98,139,105,55,238,37,103,175,147,56,127,73,166,195,4,231,102,195,92,122,38,11,126,160,23,149,144,26,121,11,69,220,11,29,142,49,104,16,178,104,21,89,66,49,45,6,211,65,172,187,85,53,241,28,217,123,153,97,47,125,132,207,155,92,24,108,61,212,254,242,98,142,250,244,188,253,215,88,229,227,13,117,233,231,60,97,29,0,52,83,161,94,207,222,54,177,230,47,13,5,182,248,168,115,156,135,75,224,197,248,83,50,223,210,212,74,55,64,68,114,173,239,8,213,93,113,221,153,212,110,117,35,202,20,235,140,29,182,108,238,99,172,175,81,233,121,191,155,248,47,206,105,129,164,42,13,132,95,124,155,230,155,55,225,48,105,250,126,100,147,132,192,31,81,240,102,200,109,14,184,94,98,22,21,239,133,132,48,173,222,157,56,194,12,255,16,3,38,66,27,212,89,248,81,35,148,101,143,186,21,32,85,95,135,154,25,14,88,109,47,77,186,41,224,63,20,241,174,160,134,52,14,86,142,163,4,98,249,201,223,193,118,163,255,121,232,222,135,4,177,6,231,181,246,136,60,81,6,149,224,185,133,226,91,240,2,230,118,45,216,179,49,214,202,112,64,208,17,149,98,142,44,56,7,126,205,162,123,147,141,165,198,78,85,109,19,218,187,231,163,196,242,147,121,7,112,93,203,180,205,18,76,179,162,40,197,108,13,29,213,133,47,202,67,126,174,234,78,218,249,33,3,3,103,195,22,23,66,252,174,221,29,197,127,222,198,247,115,35,53,99,27,202,149,35,161,138,253,105,18,84,169,71,166,159,4,227,49,109,185,166,252,126,195,30,224,206,137,91,211,159,62,156,191,167,74,100,143,251,86,190,245,243,168,149,14,215,210,203,136,146,247,217,139,176,255,177,139,212,12,169,193,180,116,105,31,33,60,56,191,230,193,155,90,50,163,208,126,214,75,104,14,193,163,125,141,246,252,173,70,33,65,231,233,244,121,219,147,254,87,212,128,22,32,159,18,207,231,147,149,72,170,184,99,186,211,118,252,84,134,47,140,181,79,21,116,135,242,21,11,120,232,58,222,159,219,247,84,6,205,47,144,236,238,164,30,196,182,251,136,116,197,155,218,65,4,74,190,29,86,17,222,198,216,63,123,180,206,190,41,202,68,226,234,127,161,1,7,117,231,168,243,224,141,120,76,225,32,43,182,217,196,27,138,92,177,96,76,134,143,105,212,72,240,216,59,37,123,199,162,20,104,115,39,80,104,114,76,90,210,136,186,253,133,119,61,6,79,12,219,24,32,29,236,142,224,15,182,251,107,82,148,114,75,10,83,124,51,160,124,254,181,155,230,153,102,146,37,232,101,4,111,145,115,255,160,166,176,185,230,10,87,85,152,88,133,144,83,94,120,45,172,127,103,10,87,68,201,157,184,229,129,146,142,134,7,17,229,209,54,77,170,55,2},
  {47,136,70,163,212,40,70,189,119,110,248,216,171,51,181,61,152,239,80,16,244,201,221,140,129,207,11,220,244,237,74,72,193,67,42,249,67,44,247,180,127,22,222,223,210,94,20,35,159,194,26,22,29,191,89,140,222,250,133,251,67,165,68,1,10,181,87,139,21,255,249,7,167,95,169,152,208,115,59,251,11,15,37,27,48,177,217,224,134,108,67,40,104,122,170,252,55,75,68,31,179,136,234,238,72,191,115,8,140,250,8,5,208,58,123,108,204,230,53,157,45,211,32,191,54,28,14,223,23,213,209,130,90,249,129,215,109,135,24,102,211,130,255,55,225,218,187,254,174,202,216,144,137,107,6,84,63,95,136,182,214,62,219,95,198,199,194,123,242,8,5,26,185,21,23,87,63,50,61,123,116,101,13,70,183,109,46,108,79,1,148,173,46,181,5,74,107,208,150,143,73,25,65,154,176,191,105,179,51,51,220,246,122,28,166,33,133,196,192,10,61,125,147,47,161,10,140,18,200,50,92,134,254,13,156,165,230,103,224,124,209,105,206,7,246,162,202,41,78,204,251,19,79,137,62,22,227,16,232,246,40,58,250,216,120,233,5,38,61,207,94,58,32,196,161,128,56,88,216,234,210,136,138,173,156,207,150,167,217,165,116,229,192,148,206,105,176,54,84,254,77,194,232,172,140,204,77,102,225,243,97,255,157,231,150,92,193,234,199,5,249,46,178,80,85,145,96,95,46,132,240,69,53,83,58,129,107,199,239,1,131,249,25,238,228,228,24,68,1,175,181,155,12,13,44,247,193,6,2,223,15,229,89,50,165,61,185,88,231,52,113,208,115,198,135,154,154,89,132,245,217,135,143,217,151,215,174,29,243,226,132,33,95,141,18,166,192,177,28,46,215,126,118,48,8,142,47,143,175,4,233,218,248,126,248,207,206,158,45,13,23,124,213,225,142,241,19,179,157,41,123,144,248,53,151,88,238,4,215,231,45,99,196,86,86,193,247,227,95,115,135,48,38,22,72,177,17,235,243,99,2,2,31,111,236,37,163,198,210,176,198,239,161,173,142,204,108,14,193,168,145,176,122,38,29,80,216,77,147,85,84,139,203,24,218,228,82,175,167,251,186,88,143,236,10,203,228,170,239,185,160,131,199,109,206,46,103,12,82,162,223,235,111,197,155,214,141,3,84,92,220,20,90,169,65,43,39,37,203,71,241,214,60,147,197,52,56,75,8,60,13,118,244,106,205,76,229,70,166,145,235,10,72,92,102,141,253,119,250,33,100,141,156,224,221,173,90,15,191,132,17,107,94,21,124,254,132,42,25,251,63,154,189,80,213,222,5,49,47,134,244,180,171,233,164,133,69,184,217,123,18,169,217,17,248,215,120,2,116,150,24,139,6,237,18,54,27,15,67,38,20,163,172,114,170,133,7,42,214,221,136,209,230,134,120,228,201,161,184,202,22,238,58,225,61,19,211,112,120,207,100,249,144,181,142,240,89,113,89,138,64,245,24,41,230,17,248,46,151,115,47,85,74,38,128,37,223,63,93,61,170,50,158,119,91,156,0,206,193,119,200,162,245,81,237,62,67,150,214,223,142,165,1,62,81,53,165,235,130,234,59,126,41,217,165,163,159,17,168,1,20,15,96,252,14,226,153,174,224,127,23,178,134,219,74,166,77,93,41,75,216,54,109,73,144,10,169,139,73,1,155,75,39,17,204,50,248,60,142,169,135,124,33,215,119,50,167,80,189,113,49,93,232,243,206,109,108,213,123,210,45,123,3,252,1,248,23,220,133,194,227,165,92,181,173,17,67,183,98,31,186,209,231,198,136,185,231,86,98,17,223,55,244,188,243,34,191,65,169,195,26,156,40,142,211,92,95,84,110,14,185,108,160,151,2,37,6,6,29,46,179,177,212,101,137,120,92,207,228,207,180,108,139,219,219,140,200,90,41,187,196,62,182,143,189,88,218,136,188,210,4,135,94,43,207,115,27,238,185,244,126,251,115,19,247,180,221,135,199,229,181,194,9,238,27,235,216,210,166,24,136,251,248,238,113,158,219,185,111,124,121,0,48,59,49,193,199,152,163,117,112,22,179,17,145,28,24,252,42,36,125,149,251,153,250,6,9,18,82,125,65,31,97,157,80,190,215,173,227,154,76,197,104,0,53,214,89,139,48,138,190,14,158,16,55,22,186,208,251,24,33,78,55,217,191,223,82,235,137,220,2,50,90,193,32,162,218,32,147,27,104,251,165,12,102,64,106,117,119,204,5,217,27,137,5,110,122,47,3,160,23,88,55,125,219,249,10,1,158,241,36,23,164,209,147,22,39,232,149,211,214,152,119,253,41,138,243,26,127,247,147,104,49,46,246,26,209,96,67,209,146,84,104,24,195,102,166,192,71,244,247,183,145,97,35,153,54,118,122,55,69,92,64,158,13,21,206,228,124,101,102,245,173,99,128,198,230,96,133,162,140,48,210,218,6,131,188,154,249,241,77,178,16,189,136,184,120,161,227,125,245,28,68,233,236,245,91,166,207,210,237,132,132,102,97,169,181,114,178,88,147,252,104,174,240,193,215,142,93,179,109,51,160,51,179,4,200,222,246,237,162,106,150,156,193,223,59,230,169,30,229,162,8,28,18,95,119,146,67,153,59,238,146,0,101,92,220,147,213,195,174,227,156,139,81,172,143,151,235,241,179,238,105,231,107,86,34,186,21,99,100,175,173,100,171,102,139,29,26,82,191,210,225,59,150,207,19,78,113,115,11,68,82,10,154,5,157,250,72,49,74,108,186,255,101,122,68,171,194,245,190,50,121,121,225,238,150,19,17,248,70,97,149,41,11,243,150,46,29,226,29,224,198,242,82,70,183,178,136,36,219,52,39,103,87,123,60,129,213,58,56,247,169,227,169,161,218,147,34,54,66,162,241,245,45,202,12,3,200,163,215,214,215,84,75,100,55,38,112,241,98,42,185,71,74,204,57,148,139,196,189,222,236,133,163,6,167,29,81,110,142,240,117,26,4,5,234,53,199,135,68,62,115,34,219,192,34,153,253,146,184,178,73,105,151,197,88,100,214,194,80,49,229,28,78,29,44,23,221,10,193,18,69,0,252,199,226,78,141,162,149,159,99,16,97,237,49,115,23,159,138,93,190,85,37,244,29,228,180,28,24,83,210,110,77,128,95,86,215,120,51,54,0},
  {57,52,190,196,49,58,159,252,232,73,87,3,169,205,203,136,109,77,70,179,1,120,236,223,107,225,27,234,45,163,179,175,216,96,14,140,144,17,72,1,64,82,163,133,66,19,150,169,125,161,162,39,146,60,136,157,170,106,106,113,245,102,236,173,131,229,219,168,146,218,47,8,172,224,66,198,75,186,46,114,191,195,4,170,172,37,35,21,18,229,164,71,198,244,22,252,243,92,47,237,29,211,62,123,170,131,102,103,172,177,89,18,105,200,47,218,123,234,107,21,151,206,186,24,138,255,61,0,69,5,177,137,221,243,248,4,254,147,212,1,122,126,49,187,241,219,119,153,114,247,242,148,61,66,34,127,188,57,215,241,38,77,111,144,248,107,252,196,87,205,160,99,178,48,215,219,0,5,34,254,158,41,165,206,96,81,0,176,157,74,197,55,38,151,167,168,220,10,162,116,202,249,172,40,174,37,184,147,240,33,231,42,3,197,39,182,97,195,253,171,83,71,88,250,215,169,163,62,53,214,231,56,137,75,52,170,214,170,134,145,0,57,93,55,12,217,114,124,0,59,25,213,187,98,74,108,13,21,179,187,38,28,48,69,2,126,114,48,182,178,174,178,230,41,116,72,106,245,63,213,132,148,45,128,87,49,20,149,232,133,197,248,240,0,197,208,119,51,12,18,131,132,98,181,215,187,193,118,104,6,213,1,172,227,14,150,254,83,138,102,67,187,39,204,22,174,159,39,209,56,151,65,245,119,82,33,61,14,40,105,248,98,196,141,150,75,128,94,16,3,131,157,229,66,52,59,16,177,30,95,24,122,164,230,105,174,108,167,113,138,150,93,230,27,77,64,144,248,87,7,102,53,49,74,203,187,230,200,14,73,228,203,48,218,60,17,108,141,142,123,84,33,229,54,250,180,138,84,221,2,100,143,102,206,1,10,166,235,217,9,78,44,128,148,236,24,251,77,38,165,199,119,123,10,112,73,247,244,93,99,176,226,173,147,213,221,246,8,16,210,12,12,120,33,79,6,119,175,223,19,224,190,226,148,65,66,189,206,133,209,153,222,108,236,46,29,53,176,220,16,255,230,103,157,255,48,212,34,251,40,37,173,54,140,109,19,34,32,52,197,127,253,224,176,124,108,182,174,240,225,73,121,90,42,21,15,245,154,114,48,88,160,203,150,30,225,89,140,46,148,93,45,11,228,178,0,205,176,113,165,62,146,145,126,250,87,243,44,133,200,107,43,212,103,9,102,147,226,37,202,34,5,63,229,230,113,209,196,231,17,226,110,221,189,254,236,88,140,121,49,245,6,156,73,231,227,197,255,54,5,89,214,112,209,27,83,237,128,245,57,134,148,166,118,149,60,78,69,33,202,49,93,103,228,168,114,8,82,216,33,247,62,140,105,230,115,221,109,58,79,238,111,141,32,25,155,253,63,235,217,53,53,115,127,60,254,249,228,205,130,144,231,176,48,51,19,198,233,89,246,116,108,17,152,193,107,103,80,38,6,65,166,110,213,49,26,196,72,10,199,198,207,102,119,190,5,71,246,164,167,73,11,3,220,223,147,149,47,165,156,204,251,45,62,10,198,204,35,173,6,52,148,213,15,34,122,193,14,125,134,121,240,148,157,219,234,133,68,51,94,224,21,7,44,193,233,0,99,221,89,56,193,0,118,130,101,40,52,7,16,80,174,169,86,65,73,34,84,195,133,11,13,255,63,220,23,123,87,238,150,8,254,74,130,113,153,50,177,11,247,100,30,28,220,218,45,180,140,135,101,112,155,101,20,240,28,186,3,18,201,117,154,167,170,128,82,234,166,191,203,104,122,241,41,18,75,74,60,99,197,83,59,89,60,32,20,218,162,156,59,195,127,165,159,85,69,179,121,163,109,208,7,211,58,238,138,139,225,129,206,13,251,90,234,242,92,83,221,221,108,216,218,66,163,160,126,239,72,54,64,15,35,150,194,89,223,192,96,252,132,241,87,55,192,22,8,189,243,183,15,55,35,233,74,249,58,190,198,27,114,113,117,254,232,15,121,64,90,77,172,71,95,116,38,119,122,104,79,42,179,110,139,250,130,124,198,177,230,60,52,102,179,26,172,101,52,109,71,158,37,157,196,80,234,244,45,197,103,59,34,39,137,146,10,52,201,88,156,28,244,254,115,49,160,1,14,54,134,230,246,96,168,238,58,69,2,185,240,134,234,144,203,20,216,154,160,76,190,69,167,151,21,230,180,74,200,106,247,51,18,203,39,72,108,155,5,56,52,32,86,98,198,174,227,38,229,93,103,123,253,165,237,3,129,130,74,254,228,136,250,174,120,45,103,49,248,85,130,210,10,1,241,130,87,48,34,15,194,72,33,71,188,79,229,208,20,173,237,148,89,159,8,113,185,47,107,8,99,208,39,179,229,143,185,18,165,32,27,228,239,29,125,48,133,72,144,183,184,51,230,230,83,124,65,124,222,40,225,235,45,250,38,143,40,58,215,10,36,136,38,21,178,158,219,94,165,122,197,82,83,53,106,185,21,76,7,201,28,187,245,44,190,86,83,142,160,29,127,46,226,192,16,85,183,239,91,246,209,127,137,185,53,196,151,167,37,210,196,124,69,255,188,112,112,254,52,244,54,194,253,109,53,97,57,101,117,120,173,194,100,103,214,222,179,131,203,147,122,170,77,2,228,102,92,124,251,163,199,82,228,120,1,171,68,192,181,102,42,235,118,78,63,100,92,241,189,92,162,165,193,34,122,160,246,228,24,16,139,120,209,54,211,32,93,53,167,118,227,218,202,99,116,252,136,96,245,48,92,167,23,72,163,60,27,20,9,165,156,6,91,43,218,144,55,156,107,121,165,243,175,14,35,98,92,38,44,38,172,253,165,226,171,44,225,130,224,31,123,242,4,173,129,119,238,102,189,19,180,146,205,38,229,228,235,131,210,9,222,34,40,7,3,63,148,211,70,188,46,14,177,164,188,92,226,69,41,243,169,147,104,65,237,54,186,16,180,116,198,234,13,31,98,50,57,27,164,49,35,99,42,51,82,70,164,87,142,72,217,116,18,146,170,63,178,6,245,67,91,12,140,50,134,109,237,13,79,16,5,65,92,28,173,61,235,28,153,153,197,225,208,97,56,133,22,170,216,94,144,126,3,197,194,250,158,35,152,71,71,23,169,167,154,85,200,119,23,65,210,228,233,224,11,2},
  {5,132,67,92,49,54,42,125,165,71,196,96,125,35,217,131,66,35,165,85,200,9,47,156,192,194,189,84,232,98,136,102,191,50,151,21,78,183,223,148,76,107,203,252,9,31,21,54,184,72,99,108,243,212,52,0,246,91,224,128,255,171,181,52,45,240,253,47,230,222,20,163,130,93,115,187,77,224,157,176,25,197,253,10,102,246,97,182,25,126,36,167,26,147,228,175,95,122,227,142,204,44,18,212,44,239,238,80,115,58,98,222,177,227,42,108,224,205,187,29,234,72,112,134,244,186,10,58,79,250,82,118,111,209,120,50,135,104,17,239,50,42,92,252,166,37,89,84,165,138,93,189,231,138,102,31,218,52,172,255,250,58,121,170,31,163,172,154,71,190,133,109,255,97,81,195,219,215,221,189,142,168,242,231,113,128,129,119,131,62,176,55,155,21,45,176,126,121,96,210,52,31,221,211,125,96,82,218,196,135,220,118,41,97,65,138,224,75,181,160,139,136,126,102,65,58,11,66,14,166,34,213,97,4,115,226,173,56,176,91,227,110,207,241,74,22,122,100,26,213,164,106,191,41,117,224,66,219,182,66,103,155,167,9,69,112,190,199,130,210,3,4,70,170,217,247,65,180,192,243,240,212,248,121,77,135,184,19,233,234,127,108,234,228,217,166,237,97,28,51,25,76,43,7,13,129,96,96,112,166,61,135,4,171,144,224,20,73,158,196,190,18,139,167,158,49,191,101,191,208,38,247,81,219,158,86,214,254,78,55,87,141,237,183,226,95,90,102,127,165,239,153,12,75,60,162,97,37,238,142,45,118,244,45,77,236,226,3,38,131,144,128,241,90,104,199,76,50,86,231,73,75,194,174,5,151,57,191,48,117,149,71,39,73,126,116,12,168,116,188,14,187,92,95,50,200,41,202,41,80,87,175,96,121,45,238,130,73,197,160,17,182,253,44,234,234,114,24,188,8,128,230,238,78,208,145,36,98,238,230,76,232,33,4,97,101,190,48,99,50,5,167,77,149,77,108,113,227,57,230,91,81,107,149,200,59,253,168,77,208,159,193,113,85,232,68,162,181,162,253,61,72,131,33,57,206,138,146,209,228,114,201,159,93,154,47,124,158,94,197,57,35,4,82,106,199,184,222,10,34,111,71,15,232,32,140,120,229,255,34,233,15,71,204,20,93,170,0,223,243,65,73,15,67,240,84,30,20,20,13,180,61,19,185,41,227,24,141,101,255,220,241,165,83,117,181,220,196,47,42,22,41,29,204,250,185,207,33,210,56,22,73,217,92,51,108,245,111,74,188,123,168,226,184,13,58,67,132,175,108,136,58,13,238,80,234,231,53,60,105,25,134,195,8,55,124,35,32,216,112,84,23,47,57,139,187,170,102,48,178,90,194,49,53,32,178,140,43,121,229,194,117,131,183,154,235,143,246,158,196,204,134,195,171,121,64,124,160,116,7,187,40,104,136,171,245,122,198,64,95,168,8,127,116,173,117,67,170,225,65,8,126,151,10,170,231,47,95,8,4,244,167,89,219,171,163,153,115,148,29,95,166,149,82,181,65,37,94,170,138,18,12,186,108,142,170,108,122,131,243,161,144,201,104,74,146,211,162,112,160,133,238,136,135,166,249,55,165,66,101,59,4,24,234,178,180,182,212,36,163,186,80,52,240,26,237,200,57,30,250,235,72,93,95,34,4,253,136,11,236,27,21,89,64,145,240,139,120,24,77,218,203,4,61,50,142,147,237,69,131,233,128,214,230,106,60,139,38,25,136,115,141,198,251,136,154,194,236,52,243,109,113,72,78,73,121,103,235,31,223,179,92,248,117,152,168,9,73,65,114,111,52,96,54,108,250,63,210,124,207,38,249,44,218,43,196,102,51,159,117,11,195,250,34,67,144,16,95,105,73,191,115,82,48,170,234,121,245,21,181,215,151,19,107,174,92,237,128,80,251,227,135,222,160,126,82,255,51,154,152,100,249,6,89,3,121,48,177,110,241,247,16,24,111,55,248,194,120,111,220,134,53,15,44,153,208,82,73,71,110,113,199,94,40,150,10,94,5,240,144,233,176,206,197,191,123,156,6,123,32,223,32,240,62,97,179,52,97,32,141,226,108,155,205,250,110,83,64,95,95,130,172,12,193,31,42,54,92,115,131,226,37,107,124,192,127,104,211,2,37,153,151,32,116,104,49,66,28,242,114,203,127,165,121,152,27,26,85,138,123,130,228,111,66,148,19,20,79,224,155,161,116,18,20,63,17,41,74,98,171,147,58,34,231,135,109,25,162,119,148,25,74,33,221,51,190,131,44,92,122,43,236,59,253,103,246,247,129,18,184,115,115,241,152,120,3,98,165,135,177,74,250,35,231,12,106,188,170,158,252,63,108,19,109,135,196,50,219,217,176,116,44,70,59,102,205,238,53,34,90,76,58,76,4,113,110,93,59,176,211,124,106,209,239,59,7,150,220,142,137,207,187,156,232,225,171,242,173,110,136,106,255,186,122,231,62,217,237,121,75,225,104,103,178,248,224,9,135,46,126,150,65,191,250,189,49,75,87,198,237,34,125,143,204,35,14,48,246,53,91,133,20,134,59,60,98,191,230,224,205,207,147,31,179,44,244,189,244,53,216,149,108,29,30,215,128,178,217,102,18,180,107,82,249,130,144,118,67,69,166,171,95,105,67,34,25,179,240,230,99,175,95,96,181,165,56,203,64,106,73,10,200,182,3,166,172,47,51,223,235,170,180,14,196,177,127,232,141,10,54,57,165,131,216,177,168,209,178,215,159,178,150,75,190,30,252,58,159,36,148,228,189,152,129,187,233,35,241,145,216,23,149,108,104,43,4,66,240,51,11,80,221,68,205,216,243,94,145,207,184,112,42,92,85,253,109,188,69,31,56,202,162,93,199,113,245,208,245,42,227,118,188,243,69,19,211,84,130,23,235,112,17,182,169,56,210,11,135,207,201,13,180,46,148,65,138,158,210,214,238,14,83,32,38,195,185,253,138,252,214,214,172,164,117,36,86,84,27,83,149,48,163,225,195,0,159,73,210,221,222,124,55,22,74,99,198,111,45,37,31,225,92,37,31,108,173,12,29,209,96,132,110,106,178,159,88,34,7,90,1,23,53,220,2,43,183,219,122,157,150,230,86,42,252,168,210,192,225,138,8,71,39,231,93,100,137,155,73,19,19,156,71,2},
} ;

static const int16_t precomputed_encode_1013x2393_x[precomputed_encode_1013x2393_NUM][crypto_encode_ITEMS] = {
  {-10510,-30465,-12975,8062,15746,2113,-13635,-5879,-8899,-27140,-24336,5400,13261,-18260,20962,25465,28555,4929,-46,7313,13191,-18332,14781,-25469,-18231,9689,-1956,8088,2797,-12286,32107,4675,-7413,-19368,-19424,-21525,-21605,15467,-9027,2335,-12261,-6977,3858,-11281,17512,439,-8703,6904,-9540,-3183,-4850,-8369,18457,-13118,-7729,17059,-21242,-14860,1859,-15766,11512,10002,23490,-10233,14961,-882,29436,1065,6141,29397,-7302,-26506,7895,-15543,8585,5482,29797,-19801,-11701,-20542,-22666,-24220,22766,31456,30902,26811,13070,-10046,6062,26164,-6498,4635,-31430,-5148,-18269,-30650,-26188,-6255,27134,-30596,11674,4587,-19034,-19060,-25873,-21170,10997,-24808,28806,30,-32216,-31679,27553,28038,-26347,-31932,-4313,26393,-14419,3502,26801,22872,2625,-1072,-26383,5692,3195,-18016,-9579,-10731,12850,-1776,-15661,-19823,24204,19945,-10946,-4075,-21930,-31194,-20888,16459,74,-14503,-16542,-17103,20094,22660,15400,15775,-13982,-22696,13277,7331,31012,-6214,9551,-26408,19176,-20336,29891,-6882,12046,27181,-3724,13932,-28659,-32020,-4524,-1145,-20350,-96,31550,26680,3616,22829,-18348,25594,4772,-31409,25262,-3496,-11180,24690,-9388,-16204,27883,22366,23834,-19409,-2864,13814,-10454,199,30041,17552,12952,8601,-5694,-16856,-17851,8067,-10573,-6534,3052,-7223,1008,-20019,14807,9854,28835,26171,12262,17975,-8765,7597,24862,18337,32757,9313,8154,-10251,23328,-23188,4578,-13093,18786,-16832,-4764,27015,12563,3110,12158,24822,-29539,8637,13907,-2709,14367,29478,2070,-15922,-18144,-30141,26257,15310,-3120,30160,6291,-27744,-6111,26915,17559,17485,-19004,23429,-16946,-13756,-12548,10263,8318,-24245,-31752,1256,16049,-10349,-19505,9005,27379,341,9571,27988,23049,-3197,25937,30088,11825,3531,-18198,16843,28124,29366,14646,-14313,-16464,-3097,-23371,19297,-23204,-513,-23280,-9749,-24171,-25142,-11777,29872,-10919,24418,-25957,9625,29568,6822,32074,-9819,11105,-1792,673,29896,-6775,30198,-25434,-14313,-12967,15404,1058,4175,575,-2342,-15740,-20018,-23220,-28809,25496,-13457,-7314,10495,-12000,-24750,-15474,-8883,10065,1621,26204,-8638,8723,-5385,24196,8798,25705,-24083,27229,-11262,-3792,10894,22476,-167,25464,-31223,-16801,15622,-31139,21680,-21574,-2618,-12444,24386,-11845,-13222,5302,-16390,6367,27844,7883,16958,-30979,14642,6153,12523,30616,14633,-27146,-29717,29700,-9545,-19244,-14376,12453,-24996,-9664,28381,2751,11197,4618,30392,56,5483,-10360,-29093,-12183,-26171,-28917,12518,-27731,-9009,-10832,-6051,-31949,-30205,1579,-25606,2315,27893,11089,-7891,-21846,-6342,21320,-18430,-23495,2850,-27222,-17535,-14112,3527,2171,25189,-23732,-20969,-20306,-16253,-32696,-8368,3268,-10185,18100,4089,32098,3776,-8099,26030,-23007,-28005,3719,675,21918,-15416,-16081,1381,22219,5615,-5973,-4374,2823,-10008,20187,1452,-27567,-7601,866,-216,-25010,-27343,-29125,2005,7015,9108,30825,15880,28781,9051,9175,30961,16648,27183,951,-27630,-8253,-21274,1787,13107,4535,-32429,26945,-6073,32739,15427,22848,29214,28423,5181,-11138,25821,-22304,2637,-11120,110,10572,-25936,3318,-5807,1121,22805,21049,-22268,22669,17240,-7059,26679,-8566,-8538,-20984,-11816,6254,16013,7893,10294,30028,-24658,17157,5406,-11734,24530,-16363,-5783,-9457,21859,-21389,16926,4161,-27778,-32562,26250,-8587,-32074,-29667,-14552,-7046,30902,-22424,-10763,24241,-11188,31357,23363,32622,-16753,32205,9644,-11084,-2293,-22433,32414,29989,-32478,-25681,26246,-32021,14354,-15175,17800,3024,-4531,-9427,-3086,11880,-20164,27529,-22993,21606,-9564,-18982,-6236,-12407,-28971,-8997,-7247,28482,-222,1056,522,-7865,-9319,-24020,-22637,1262,18883,30706,9515,-13944,-13211,19899,7212,6766,29734,15560,5467,19919,26558,881,-17177,-2142,-4165,2644,-7032,-23842,7709,-9825,-3496,30096,-11979,25563,-29085,21436,-23327,27226,19040,4259,23871,-22940,11373,6301,-32302,-10941,30352,-9451,-15603,3596,26797,26861,28491,20146,-27251,5335,-22564,13917,14164,-4327,13239,19986,-22955,-6932,-14949,-32002,30484,-18283,10152,-10136,-3367,2138,-8918,-17169,10477,-30154,7268,2238,21533,2541,30074,-11767,15401,6050,-9107,10793,-15210,-363,20019,16848,21655,27895,4040,-7009,2563,-24103,-7374,-7538,-16306,-25902,29525,15159,-21322,19701,26045,12701,12290,3342,32531,-23607,-15249,-22477,955,3836,14518,12456,2002,-32010,6347,-7755,32297,-5370,23301,15632,-15658,-26783,11782,28311,-7398,-28105,15144,15011,16441,13379,15784,-31635,-20875,25101,-371,2754,-32295,24981,-18016,18570,27718,-4148,-30967,-5592,26626,-4261,-31761,24392,18971,27423,-20375,-23651,25411,-17339,-24122,-24304,18114,19368,7896,-15620,-23786,-28778,-4296,-31906,-7094,16014,-17504,134,-1237,-21831,30149,-1179,1718,21781,32748,1928,-7082,26672,-4645,23706,5948,-2270,12701,-9057,25597,20409,-23488,-27159,-4673,26699,23603,12813,19046,23831,-16978,31806,16343,-5504,-15590,1275,-19857,32219,26676,3099,-4660,3645,8618,-14391,-32455,-13235,12649,25972,10295,-22070,25147,-18834,16277,16405,12889,-12217,-17469,14168,14858,-15962,-25875,-18550,3517,30675,-7873,-18467,16827,-3746,11979,31435,-32462,-14193,15564,21084,-9370,61,-9023,-30184,-2506,-3720,32364,628,13096,9767,-444,-14994,-8229,-24910,-23883,29644,27223,13280,-10180,14752,-5879,20482,3773,-1113,-14705,17559,29855,17079,-28552,22243,30851,-12209,-17922,-21853,-15070,-21187,26253,2961,-30040,17306,31978,9852,-21004,30949,14459,31354,13051,11488,19299,-21780,6399,22074,4363,3253,-29522,-8948,3467,6653,20028,4443,-15316,-18403,-740,735,13667,-6309,31501,-23382,13841,-20376,19884,22230,31466,1856,-30127,27681,-26321,20500,22757,1108,-5867,-2703,-32491,-547,-10083,209,-10370,32150,-20841,-29550,-26460,14020,-3195,-25410,28888,24976,12684,-14672,20717,16966,31101,-8187,-16552,16658,-21492,-13497,-5371,23153,26018,31582,-17934,1251,-4238,12681,-9613,-24771,-15579,-30612,-28349,-3249,-13653,7192,10148,-5419,30424,-30636,107,-3030,-15831,14221,-12700,15397,-14867,4571,21252,-23444,21646,23383,6601,22426,8600,25573,-10109,-32650,10290,19371,-14672,-4128,-27022,27670,-25220,22772,-10217,27313,-21244,30796,11695,19549,-25738,1968,3298,12943,-26826,-24803,2336,6793,1452,1584,-3809,-10484,-8297,-32343,-11152,4319,-25135,-25349,-18904,-21402,22685,13012,12986,-4394,-19388,-693,-25161,-13701,-29462,23742,20567,-5165,12035,27839,8101,-28089,-28089,127,10903,11615,28054,23830,7481,4673,-1484,27616},
  {4408,-26209,-15124,-24146,-21470,-19389,-12402,-31450,-28205,-9669,-15757,28887,22909,-11906,-8786,7685,-31896,12428,26946,6026,-21822,1237,-12598,30701,-3591,-13092,-676,-19080,-28318,14925,31303,-28775,-15659,-31159,-15692,16901,-9447,-1935,-12096,11502,13055,3569,23645,-12346,-12678,27037,-8791,27427,-13372,10522,11873,20193,24734,-30300,-29745,-10810,-2405,-32168,22084,-3427,-28352,-7926,23600,31807,-16255,-29889,-7858,-16151,-22824,-17431,17831,-218,19281,-20880,28863,-10808,25547,12911,15158,5940,15466,-3863,-20526,-23536,-12934,-2466,-2604,-29463,19761,5237,-21790,-28544,-28626,-7610,-29152,-27567,8558,-5575,10889,18471,-14837,-25880,9885,6753,-23682,32278,9343,-4693,19095,-6911,-27679,28241,-24562,-21387,-20247,-18958,10651,-27085,-20483,26315,-12420,9541,27509,-4060,8058,18882,-18497,24206,8882,-15882,-12424,11980,-6562,-14966,-18435,-19656,25286,-2646,16092,2936,-7757,-2976,32237,-7958,16432,-9468,-10879,20104,-16349,-24213,11001,19329,-30700,-20958,12368,26045,-21605,13643,-28659,-26194,-21218,12894,-23559,9092,-1288,-12268,20730,-2729,-19750,-23370,10230,-7397,-20229,29148,11103,24240,5859,-32317,-8648,-22845,28441,-6059,27615,7604,-28476,-27532,29780,-21121,-26666,15177,14649,-410,181,32030,-20783,23496,-24407,8882,-21947,1054,25929,-4852,-13242,-7930,-6086,21233,-6708,-28086,985,-19709,-8305,12263,13840,26855,29622,-291,-27265,3539,-24917,-4361,3968,-28103,-13846,2751,-7176,27172,400,30581,-24090,-24594,28020,5322,-5919,-6908,-13149,9690,-14390,-24494,-13055,-13853,-24539,-6058,6377,-22637,-24872,26482,-19804,10147,-3473,-19660,-15064,29513,-12380,25245,1790,15431,-24845,23806,7584,15665,-22282,-14701,-13270,20669,-2735,32048,-17262,3080,-14354,-26597,11736,-18070,17483,2142,-25476,8938,28184,29779,2905,265,-14507,11571,19987,31451,-14136,-20434,-5777,24758,-16886,-23403,-9058,5191,10146,12838,5446,10245,-27181,21192,8388,25937,11215,24602,-4639,-18935,-25438,13843,27226,-26963,28038,17552,-24840,28239,7055,-25933,19284,-26550,-31448,-8725,-1696,-21977,19237,27024,21432,23993,13876,-4067,-28693,7039,24300,16122,11267,-11327,-28984,-30991,-13520,-6950,-17045,-23310,-26318,11115,-5899,-28148,1236,21417,-30032,180,19604,-17899,17855,-985,4448,-255,7817,1341,-26133,-23957,-26043,601,-12803,-23717,-21880,-30864,-5077,-16839,-30228,10725,234,-28030,20486,30346,23078,-10952,11625,-24631,20048,29967,17833,-8442,7958,-8560,21746,-15740,-5102,23870,-29033,-25034,-22142,27425,-18945,-25683,-12880,-29036,-20152,-27360,7273,-27434,31330,11834,5514,20531,-18308,-24483,-25086,-10101,11133,-12947,-10454,16454,8080,27910,7128,25843,26566,4171,971,12943,-2891,20734,12886,-4109,-8119,-20299,-29604,-16122,-18525,5280,-20027,-1812,9724,-12652,-9469,9846,-23878,-5088,10333,-16662,672,5778,-27160,-19160,-19286,26960,-23484,28019,14556,4032,24073,7573,-29314,30202,-14448,-5170,20089,17402,15077,-31124,-22883,7902,-27653,-27290,15001,29839,-32227,25730,7856,2910,-25941,-27751,-2817,-5207,-2610,27005,-31273,-10962,213,-15306,6570,27012,-21617,12846,-18724,-14329,24903,-8789,19846,13970,-12202,25307,-22524,-10009,21161,17358,10378,5616,16135,-17351,-14252,-11618,-11499,-21981,1631,16275,32159,20759,-14435,-1387,9053,-2798,-17572,-20685,13312,19002,2465,-5890,12687,-31829,6657,684,-22939,31034,21651,12869,-4753,22632,-4720,-22655,11130,28238,-13010,13482,20304,4880,-19320,-27592,-788,-3856,-25503,19294,-19566,-20312,5407,-5609,27052,-94,27441,-32647,-6793,-12559,-205,-8040,26415,-28190,-31014,-16898,-7991,-26886,-3966,27190,-14954,-1818,16770,22659,22364,-6881,-28343,-3989,-23058,20059,-26011,17652,-26654,22452,24945,14919,-20060,-4476,18186,-12082,-2815,21958,-19564,12303,-29007,-21317,-22506,-9544,-1895,25710,-18442,-21323,-27216,-26369,-22252,-32228,17848,-19080,7504,25625,16841,-24153,2831,-3649,-1862,-29216,19690,31275,9249,16056,12133,471,5959,19913,11675,12186,-2244,3302,-19466,-15122,22099,-27767,7610,-10648,-27109,-9711,-6924,-15275,15819,-5344,16298,-32648,-11351,25333,-2037,-12295,-6845,-17058,-22488,24799,-28762,-22402,6689,-29062,645,-26290,-18251,30486,8925,-24314,10984,-8574,-12020,23634,11202,-14812,-13406,-29368,17268,-6215,7944,-2374,-23464,-8395,19748,6573,-26624,-32750,-3697,-7372,-26273,-30235,18048,4458,-13329,-700,23578,-11344,7860,-8786,-16625,720,-2852,-4004,6803,-5011,-22831,10633,32623,17417,760,4728,19903,-8783,-22501,-10983,-27464,18266,-18205,8638,-19289,11816,-7110,-13680,-28021,-22858,2074,-20809,-8704,20811,10921,16067,-784,5750,6565,207,-2400,-16668,-9311,-24536,12988,-22477,-1124,22367,-25647,997,32506,-8663,-1702,19047,20823,436,-19376,3320,676,25117,-1743,-6918,5252,10186,-10571,-12786,-25319,10596,-27450,15575,7203,-32117,9718,-5732,-3760,-30340,-2979,2429,32601,-16416,31375,-28876,13876,15225,-13746,-8553,22835,-29680,-20843,-6087,-16020,-8454,-18939,-16419,17042,-26853,-13503,17847,-9317,19763,-31635,-22046,-29382,-8611,24182,10986,5959,5230,-7428,21087,8699,-5069,30680,-13658,-25114,24774,-6094,-17227,-11584,25035,19017,-28556,4000,-30864,-14775,25593,28167,-32611,-12446,1069,-19248,31569,-24414,18601,30355,1270,-1193,-4622,-9108,16307,-26177,-25125,-84,-21622,-4282,26681,13893,-12476,9588,16385,-7563,-20410,-7125,31907,-31544,-14653,-4103,11655,3200,11491,13442,29456,-13213,-606,14939,25290,18890,2443,-6880,12312,27818,-11009,10263,18380,16162,-3691,20580,9447,24325,-22359,8622,17679,18022,-9801,-2290,-15879,28403,-26222,10267,-20680,-30985,5741,424,-23183,-19697,20087,5757,21440,-8733,11162,30968,15536,574,-6126,13796,-24045,13806,19577,27218,31819,-28750,11894,-32132,7991,13900,21584,-14444,13696,-3566,-20000,-21774,2134,26758,-25390,17207,-15216,5379,-15147,15280,-11843,4793,20100,27093,24853,15314,-32157,8183,-18253,-14896,32050,7865,10836,-3538,27973,573,4584,-15271,2492,-17114,-26970,15949,22798,16289,-17131,-30539,-10324,-24503,23480,24145,25697,-22694,25946,18597,22406,3845,-22708,-14185,4921,25594,3111,-12149,-25019,8568,2740,20176,-16400,22794,24715,-5710,2867,678,-16460,-22237,15477,-28476,-7271,27608,7727,17561,-6662,-12991,-20760,-14858,27464,7576,-9989,-117,-27233,-10288,-2189,10395,14196,28725,24525,-24964,25536,19885,3583,-31213,-2780,19755,1164,-9202,-6016,-1446,29826,-12164,11462,-32235,8139,18098,16543,12768,-30026,-7129,5946,10197,13941,-23395,22243,2363,-22533,-829,-1251,11235,-5205,-19505,32618,30599},
  {31273,-25988,18685,-3363,30722,12369,-20803,25442,29589,-29923,14936,-15946,19437,-29718,2291,30537,14460,-12305,15404,-2216,31086,-27936,14330,-5603,-20026,-19659,22577,23139,23064,-11213,31392,-14493,24182,6052,-17082,1223,15421,-15612,8014,29917,-28032,5228,28308,-9335,-31708,5043,32549,-32193,2845,-22997,6698,1350,24925,-1189,-5838,7959,11486,-438,25145,5072,-12755,-30163,13815,-20032,25385,-27743,-3771,-31378,8744,-12182,27578,23886,31953,27820,10030,-23398,-21840,-19261,-17538,-4817,4785,6086,6449,15230,-2773,-13140,-16589,31569,-19304,5112,20035,-2005,-1185,29059,-32068,-29127,-30613,-12960,-31021,-17268,-5771,26333,-26289,-13937,814,-7278,-3514,-12297,-11177,-30303,-22821,29148,9088,10357,-14520,-5362,-16958,4210,-23164,29511,26362,-12516,1700,-25914,21487,928,-11293,23884,24800,-12088,-23404,9433,30894,2898,-16,17890,-28403,8207,31912,14112,-6333,31845,-28462,25835,-29790,6339,-17768,24511,28000,-31682,-21096,-21608,-14836,3581,26086,7130,5265,28339,-7205,21990,5286,15366,4767,-22345,30528,-25558,13986,-19252,15213,31876,8126,-11236,-20921,16831,31150,-17191,11590,-14963,29671,-11837,21772,-18728,9234,-27009,18582,-15676,-8549,12567,-2391,-18633,-11890,29441,23060,-15408,9189,11498,-2559,8740,7131,20061,32727,-9950,-25814,30915,3027,31080,726,30458,-18767,-29853,19190,25624,-3525,-19496,-24063,22464,7639,24687,-16812,21150,30382,-29843,-28878,17394,-12675,-23157,-1283,-23026,-9003,-26596,29325,29610,9959,17664,-11117,30300,27867,31530,10141,-18369,27071,-1685,-4663,-17578,-16654,19930,28977,473,-3679,-2095,27250,-4133,18330,-7781,-14874,18170,-17386,-12077,29981,10932,-6506,-25752,-24191,22017,28783,21703,15615,-17575,30446,-14163,-17043,-27098,-24870,30914,10792,30101,-6148,-14230,-5582,27566,-9505,-25138,19776,-31798,-3473,27847,-710,22292,23750,21381,10038,18459,-6522,29339,22185,-27582,-20915,-21967,6229,15018,12744,-22270,3168,-29810,-4997,-30138,-18789,-6869,25968,12596,-2673,6600,-28855,32374,27534,12840,-25425,2926,15525,-25395,-8633,-3202,31526,-31935,-4157,-31294,20239,30422,-22590,-10428,-22607,1933,12979,-15002,-17129,2338,6914,26599,857,15458,15558,7454,-11600,-19930,-23982,7196,32609,25233,17441,13290,-21328,19907,-2539,12373,10808,18478,-29783,-11209,4910,-32714,2150,27869,25713,1823,8186,8788,31363,-22829,24827,-19111,29190,-4002,-31352,-5997,12997,-3765,31244,-29540,-27772,-9046,-30578,13469,-25234,-26641,4464,-5454,29634,14257,-15216,9581,-31682,22390,-28970,25763,25779,-21484,14682,21798,29467,-7853,4318,12688,24488,31905,23645,2874,4079,-9101,4333,7420,-19283,-829,21632,-29885,-1273,-2682,-26535,6507,21687,-18656,-31955,-31906,-132,-7683,-6988,15593,-6660,1855,-31091,-26937,2121,8773,-17480,-26739,26237,-12722,13482,8159,-16360,-15505,22126,-24374,22495,-22592,-997,20015,18885,-8303,26188,26333,-4212,-10853,12910,24804,-29406,21998,-468,14905,-21945,-11919,-16239,17129,-9099,5082,16563,-17733,1172,13190,-8805,9046,1703,-13329,-13725,-5109,13414,-21474,30939,-16217,-10592,24383,15670,32375,13326,16299,-16978,3903,-5061,-5014,-16020,-22704,-16228,22628,14841,-30723,-11274,5372,-3466,-14948,-18443,24363,22201,27581,1763,31535,24078,-14847,3719,574,-20839,19024,3944,9430,-18585,24642,-18295,9728,-19880,8458,-18488,-25495,12714,30952,24235,-256,24303,5519,-8172,-29167,-19052,-8176,-58,-18972,22333,-3107,32368,-17344,18563,8133,6061,27225,14405,1470,30632,8284,22146,-18057,30999,18643,18746,-30050,20316,-12647,6702,-6056,-17393,-20714,24218,-31110,10117,-20932,-15971,-32741,-28262,-20428,-4769,-3145,15362,-484,25212,4877,-18858,-27118,16291,20334,-17142,21169,-12768,-3989,30486,-24674,-26855,-31345,23347,8674,12935,30240,-12372,-13156,-26093,27007,16448,27654,1853,-14729,-5509,-21217,-5911,-6298,-11904,19384,24483,18097,-32120,11730,15276,7031,-26155,-22945,2631,-12844,-13019,6217,-20763,-21252,-10409,-10571,-4514,2676,196,21926,-7034,-26974,-23163,-3230,-18510,27458,1574,-31228,-3497,2930,15083,-1990,-16100,28335,360,30709,-17407,-30913,-19667,-8482,-19407,-3488,20722,-29417,20428,-2688,19183,-32586,-18517,15220,14961,-17021,-17518,5383,23848,10547,-32199,-8725,-11653,27496,10558,-23920,-17878,23689,6527,20878,-24802,48,-8987,-22145,-13914,2216,-19309,-31768,-8436,-5342,-10192,11221,23937,-5617,8407,12084,20506,-7119,18401,-6334,12709,-13325,5154,11826,-2165,2579,19472,-22814,10364,-4813,-10997,29440,-22658,2866,-1398,25283,1148,47,-30681,2555,-30230,23652,18588,13453,6157,-24726,-3323,-25012,-10152,-16896,-32156,-22961,-27190,-24648,7342,7496,23650,-28092,-15344,-27243,-1889,21937,20703,-25483,28679,10626,5356,29075,-12867,15417,25477,-12467,10696,-3926,18508,-30956,14308,-27690,-18520,-24986,-27732,32727,-4291,19698,9626,-31374,29251,18082,22299,-15596,18276,-20227,26301,14230,-21213,16986,24470,-6400,31264,11455,-26128,5804,23129,-27108,23097,10786,364,22531,23012,-16310,26707,8788,-10627,-31844,-6717,-24110,28240,-13826,-5148,29435,1968,-28506,-4384,3094,11722,31031,-15710,-2432,-4262,-19310,-2790,10382,18136,26086,-18029,-11048,11577,19830,-19300,20958,23397,-6612,-17330,30641,-6202,-17638,18517,-29688,4525,-5901,15418,-16995,-21645,13266,9205,8422,11619,8256,-13389,-30024,23903,1802,26168,-5826,-19532,9927,17812,-6611,13366,24650,-11878,4335,1209,26634,-7342,2983,26361,15276,-5938,-19275,-22525,14095,14175,-32017,6356,25526,-9092,-30452,-11647,-20553,31618,-8071,23516,25973,-13171,12747,-6621,-32612,-30330,22036,2770,3253,27238,15606,-24999,2336,24929,-15477,23188,-15959,-7152,24818,-25514,11815,5421,25967,-6648,22055,11905,5610,-10275,-24531,19856,-16928,14857,-10923,23022,7361,29287,13390,-3283,16641,28689,9834,24865,14555,-9238,-8727,3599,-1414,-25025,19394,11632,-7023,2257,32743,8205,32064,24018,16118,31331,27445,1882,-7675,20755,-31383,-10718,-1576,5630,14992,-6959,21820,20333,-288,-16311,23124,6894,24761,-20796,3982,24577,29199,9430,-12569,4239,28384,14656,17802,5631,-7555,4071,1536,-29075,-31170,-22360,-1576,13736,12800,31004,7897,9218,2208,-31925,-24693,-7698,-7121,19256,12565,19869,-31998,-3841,-8268,-18824,21750,26024,12154,-27599,15771,-20679,433,23019,-14228,-240,2731,30582,-21749,-20996,-25448,-19580,900,-3140,-9559,-1827,-4964,4121,2743,7268,-3287,-28110,-28490,-23411,4211,28395,22408,24472,15433,-12768,-31558,-17238,-16192,16759,-31246,-26922,710,-13192,-12105,26437},
  {29990,-20373,7472,11884,-14370,-1025,18060,-24978,30741,26539,27864,-27456,31574,-29853,-15419,-17056,-4475,29268,-13379,15533,-9325,15013,16907,23444,26505,32441,-16983,-4993,20823,19317,6795,-25811,19427,-28371,19840,18469,31020,-15313,9445,24505,9368,10328,-6997,-29953,25040,6277,-24331,8091,-22206,-21630,-12269,-25808,29352,19931,-13127,6599,-19325,-2655,31923,-24074,-1200,-19507,22619,7846,21925,-21492,-7313,-12814,2360,15413,15269,-30799,14857,11807,29486,-20357,16676,6588,16014,-32355,21186,-29475,32420,24549,8815,25278,-21230,-1070,-21028,-5559,-18661,-16877,-665,-20864,-18589,28874,2363,11484,-20380,-22514,-22295,26445,31452,-29141,-22504,-8562,-11336,-9844,-4716,10638,1347,28147,-15362,11848,-519,-29337,-13527,17297,5418,9400,16128,31256,-30062,-11960,17193,6166,-11719,-32313,-7095,20103,4508,-13035,-14062,27404,-14644,-8618,15243,-26299,-31024,-16036,-24227,-28869,-9080,-10857,23480,25868,-19263,-356,24378,-16153,3323,-25946,-31699,20233,-20820,11042,-2937,31415,23523,32053,-12627,-32149,21373,14327,18616,21637,-32621,21553,27776,14495,-7469,13896,18561,-19448,25188,2387,10824,32202,-18826,-157,25318,26812,-30942,16894,28362,21212,-24463,-22108,-14987,-6562,-24661,2094,27941,30413,-2337,16962,3742,7294,15811,-23555,24876,-18406,-13096,22064,15036,28765,-26747,31795,15110,14071,6485,-23423,23164,14959,-754,2536,4906,-26969,-17265,-2221,27168,16531,-1321,27781,13488,23413,15492,19471,-278,-29566,31597,-3635,-1492,-1287,-23231,28721,180,-283,-26458,7611,11527,-29260,21379,595,-8830,16661,2926,22849,-2635,4203,16874,-19691,-32234,4311,22470,4203,-23383,27814,-3788,-1847,9516,5001,27807,18545,-28740,-17801,14162,24938,26114,4198,-10564,-11921,-2532,23040,-8019,2895,15666,7971,26906,-8231,-7022,23704,-27685,13078,-16633,2618,-13757,15512,28441,24780,-11466,-5151,-14472,-17929,-13999,-17373,31679,-5727,-21481,2502,27798,20456,-25907,-468,7500,-31061,24551,-32220,6410,5090,-13309,-23250,-31528,2709,11413,22229,12171,19058,22928,19100,-9982,29264,-25443,-1073,2241,-1766,-17124,18250,8009,28223,-25243,-12008,9201,29740,-30351,-25157,-28866,-32497,14064,-15436,29099,19245,7168,-7840,-21058,873,31593,29295,-16732,-27430,-21717,30622,-13260,-10829,27227,21060,-19924,-16344,-24317,-3465,6272,-18294,-13460,-30181,-10854,2647,-29575,15671,-25958,10993,25082,30696,-29078,2025,32702,6498,-20116,4475,24438,919,30287,17092,-19270,-28987,-14570,15307,-18813,-25941,15494,5980,-27599,-12394,13233,-113,-7485,-1583,16557,-3207,-10569,-3730,24391,2547,13505,28110,-5350,9780,-13908,18856,-11985,2927,-8991,6407,4863,17762,9981,-8973,-32569,14872,12314,3688,13987,15976,-5584,-5255,-16030,-5356,6068,-24932,-8451,11856,21371,29136,31940,-15922,-15976,14322,-3661,-19783,-16664,-802,14254,-14722,-538,31728,-20816,29699,8929,32068,22228,-29769,-4035,-31133,-29207,-9081,-11190,7206,21379,-9302,8154,-6510,17107,-4666,1908,-16147,8722,13303,-8263,-6201,16756,20995,29596,30803,-835,3505,2509,-25819,18059,-490,21169,-31594,-23411,32404,3615,-21804,-13800,-2292,-13616,-7766,-20805,-23388,-28917,10607,10883,-3564,28832,-23775,7177,-9820,-8240,-27258,-14399,-32730,-31282,13231,16930,-12844,-23982,-4622,-29459,-3086,18903,8594,24386,-12507,-13477,-23579,19917,28477,29048,5455,12600,10131,12361,25261,28839,-1592,7238,-1372,2177,678,-29325,31994,12955,-198,16062,8845,21845,20686,12726,17231,17518,-20809,20040,-1148,-25507,-17520,19563,-16560,29560,-1861,31591,-16608,28404,-26721,16834,2878,-29664,10686,-29189,26939,2207,-2426,20302,-1141,10551,9449,-15968,16833,-23914,-11741,-26263,-11325,14958,-23921,15950,-9338,18363,-18706,-28452,-2051,-24666,-30225,-9921,-32766,-5201,25954,18624,-8101,17289,-10160,-9892,-778,29055,-18669,10700,19440,-16220,31908,7916,-1998,-30020,2945,-9509,5449,3294,11895,25461,26686,2404,-3833,-19075,-29199,11369,-31248,6081,-20936,-32205,25069,2156,-4881,-21875,-10302,17686,-30179,29874,4767,-9636,203,-28437,426,7144,28111,30146,8057,-4211,19029,-21709,31308,24492,8714,7018,-20787,-19875,-2546,8337,-13629,-8154,6975,23816,-21321,-30304,26939,2163,8613,19401,-2525,3633,13021,-18135,-26958,12704,7747,-7180,29707,-15212,-6953,-20409,-6530,-10471,-8206,11339,31679,-8467,-29455,2205,23713,-10817,13480,-13199,1833,18775,-19097,-1524,-7824,30894,-8499,-17462,15379,5244,5786,-17688,5502,22888,-18551,19695,6619,-16939,27780,25415,3025,-11732,3397,-25381,-4660,-31095,821,-31815,-3666,-26824,-1542,827,32020,7797,12464,-15316,6236,-24844,14158,-10244,11168,-19891,4460,-11264,-15742,-26335,32378,8189,17940,-12196,-9262,27809,13779,-21763,-3962,-11688,31535,-26357,23624,-11057,20239,10990,16515,32308,1747,-32656,19279,15662,-30341,-29782,22897,8791,19388,10107,-19372,-5763,19282,-7730,31355,9972,-25521,7546,22000,14974,-31571,3740,2074,23148,-3225,10853,-13627,6426,21484,-22501,-29028,16308,-17956,1204,-2610,-27426,4996,-22780,-32048,10075,25026,-10984,20208,-5637,857,-27337,3191,-8842,27380,19201,-2031,24862,-3740,-1659,515,30511,351,-8646,-20714,13240,-7047,-15566,-18947,26529,7904,10364,25843,-25199,-9183,26475,2031,23122,20158,-25885,10809,-434,-20545,-11260,18890,23236,-25578,-13097,352,13602,26175,-4751,-13337,-14502,20761,21014,-5281,-12052,30965,18847,30756,25118,-27368,32609,-26600,28852,-11998,14267,-26368,10899,16191,26454,24727,-2774,14477,-3346,-25740,20052,5604,9552,24044,24029,-14989,2623,-9,21781,-8931,-26776,-31563,-5246,10745,20706,-20503,19844,-30482,23157,9689,12288,-19868,-32742,453,20312,4264,-19801,14437,19683,24819,-20160,19484,-2828,-13505,56,-10611,-15995,1676,25353,-9341,-23343,-21985,9760,471,17693,753,-5772,13712,19775,27105,-11748,28553,-25533,-17899,-11120,-7943,28477,-16544,20747,3817,-22684,-26415,5773,-24938,39,-3542,-27123,21642,11319,-16957,-6687,-10243,-32378,9558,18063,-5667,14440,10390,4385,2674,-23712,30629,14807,-11890,1214,-2148,-8630,6632,7358,-649,7258,30198,2427,-25082,-28876,-10413,14848,-30386,-16446,-10379,405,-1439,-15941,-29591,-7950,-26624,-8322,7594,-168,-6293,9267,11567,-20784,10194,23480,32065,14049,-8666,29376,-13854,-2505,13633,24053,22907,8251,18005,14356,-19603,29061,13734,-19965,-24432,-26439,-17976,-2709,-10812,9490,-20266,25375,27191,-12673,12767,-19757,-25155,17940,-28010,-5998,-13038,-24567,20767,-17173,6523,-11100,-527,-31255,-3896,-2348,-27216,-4715},
} ;

static void test_encode_1013x2393_impl(long long impl)
{
  unsigned char *s = test_encode_1013x2393_s;
  unsigned char *x = test_encode_1013x2393_x;
  unsigned char *s2 = test_encode_1013x2393_s2;
  unsigned char *x2 = test_encode_1013x2393_x2;
  long long slen = crypto_encode_STRBYTES;
  long long xwords = crypto_encode_ITEMS;
  long long xlen;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_encode_1013x2393_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_encode = ntruprime_dispatch_encode_1013x2393(impl);
    printf("encode_1013x2393 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_1013x2393_implementation(impl),ntruprime_dispatch_encode_1013x2393_compiler(impl));
  } else {
    crypto_encode = ntruprime_encode_1013x2393;
    printf("encode_1013x2393 selected implementation %s compiler %s\n",ntruprime_encode_1013x2393_implementation(),ntruprime_encode_1013x2393_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_encode_ITEMBYTES;

      output_prepare(s2,s,slen);
      input_prepare(x2,x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      secret(x,xlen);
      crypto_encode(s,x);
      public(x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      public(s,slen);
      checksum(s,slen);
      output_compare(s2,s,slen,"crypto_encode");
      input_compare(x2,x,xlen,"crypto_encode");

      double_canary(s2,s,slen);
      double_canary(x2,x,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      secret(x2,xlen);
      crypto_encode(s2,x2);
      public(x2,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      public(s2,slen);
      if (memcmp(s2,s,slen) != 0) fail("failure: crypto_encode is nondeterministic\n");
    }
    checksum_expected(encode_1013x2393_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_encode_1013x2393_NUM;++precomp) {
    output_prepare(s2,s,crypto_encode_STRBYTES);
    input_prepare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x,precomputed_encode_1013x2393_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x2,precomputed_encode_1013x2393_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    crypto_encode(s,x);
    if (memcmp(s,precomputed_encode_1013x2393_s[precomp],crypto_encode_STRBYTES)) {
      fail("failure: crypto_encode fails precomputed test vectors\n");
      printf("expected s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",((unsigned char *) precomputed_encode_1013x2393_s[precomp])[pos]);
      printf("\n");
      printf("received s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",s[pos]);
      printf("\n");
    }
    output_compare(s2,s,crypto_encode_STRBYTES,"crypto_encode");
    input_compare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES,"crypto_encode");
  }
}

void test_encode_1013x2393(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"1013x2393")) return;
  storage_encode_1013x2393_s = callocplus(crypto_encode_STRBYTES);
  test_encode_1013x2393_s = aligned(storage_encode_1013x2393_s,crypto_encode_STRBYTES);
  if (crypto_encode_STRBYTES > maxalloc) maxalloc = crypto_encode_STRBYTES;
  storage_encode_1013x2393_x = callocplus(crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  test_encode_1013x2393_x = aligned(storage_encode_1013x2393_x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  if (crypto_encode_ITEMS*crypto_encode_ITEMBYTES > maxalloc) maxalloc = crypto_encode_ITEMS*crypto_encode_ITEMBYTES;
  storage_encode_1013x2393_s2 = callocplus(maxalloc);
  test_encode_1013x2393_s2 = aligned(storage_encode_1013x2393_s2,crypto_encode_STRBYTES);
  storage_encode_1013x2393_x2 = callocplus(maxalloc);
  test_encode_1013x2393_x2 = aligned(storage_encode_1013x2393_x2,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("encode_1013x2393 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_encode_1013x2393();++impl)
      forked(test_encode_1013x2393_impl,impl);
    ++test_encode_1013x2393_s;
    ++test_encode_1013x2393_x;
    ++test_encode_1013x2393_s2;
    ++test_encode_1013x2393_x2;
  }
  free(storage_encode_1013x2393_x2);
  free(storage_encode_1013x2393_s2);
  free(storage_encode_1013x2393_x);
  free(storage_encode_1013x2393_s);
}
#undef crypto_encode_STRBYTES
#undef crypto_encode_ITEMS
#undef crypto_encode_ITEMBYTES

