package Locales::DB::Territory::to;

use strict;
use warnings;

# Auto generated from CLDR
use if $Locales::_UNICODE_STRINGS, 'utf8';

$Locales::DB::Territory::to::VERSION = '0.09';

$Locales::DB::Territory::to::cldr_version = '2.0';

%Locales::DB::Territory::to::code_to_name = (
    '001' => 'Māmani',
    '002' => 'ʻAfilika',
    '003' => "ʻAmelika\ tokelau",
    '005' => "ʻAmelika\ tonga",
    '009' => 'ʻOsenia',
    '011' => "ʻAfilika\ hihifo",
    '013' => "ʻAmelika\ lotoloto",
    '014' => "ʻAfilika\ hahake",
    '015' => "ʻAfilika\ tokelau",
    '017' => "ʻAfilika\ lotoloto",
    '018' => "ʻAfilika\ fakatonga",
    '019' => "Ongo\ ʻAmelika",
    '021' => "ʻAmelika\ fakatokelau",
    '029' => 'Kalipiane',
    '030' => "ʻĒsia\ hahake",
    '034' => "ʻĒsia\ fakatonga",
    '035' => "ʻĒsia\ tongahahake",
    '039' => "ʻIulope\ fakatonga",
    '053' => "ʻAositelēlia\ mo\ Nuʻusila",
    '054' => 'Melanisia',
    '057' => "Potu\ fonua\ Mikolonisia",
    '061' => 'Polinīsia',
    '062' => "ʻĒsia\ tongalotoloto",
    142   => 'ʻĒsia',
    143   => "ʻĒsia\ lotoloto",
    145   => "ʻĒsia\ hihifo",
    150   => 'ʻIulope',
    151   => "ʻIulope\ hahake",
    154   => "ʻIulope\ tokelau",
    155   => "ʻIulope\ hihifo",
    172   => 'Kominiueli',
    200   => 'Czechoslovakia',
    419   => "ʻAmelika\ fakalatina\ mo\ Kalipeane",
    830   => "Channel\ Islands",
    'ac'  => "Motu\ ʻAsenisini",
    'ad'  => 'ʻEnitola',
    'ae'  => "ʻAlepea\ Fakatahataha",
    'af'  => 'ʻAfikānisitani',
    'ag'  => "Anitikua\ mo\ Palaputa",
    'ai'  => 'Anikuila',
    'al'  => 'ʻAlipania',
    'am'  => 'ʻĀminia',
    'an'  => "Netaleni\ ʻEnitilisi",
    'ao'  => 'ʻEnikola',
    'aq'  => 'ʻAnitātika',
    'ar'  => 'ʻAsenitina',
    'as'  => "Haʻamoa\ ʻAmelika",
    'at'  => 'ʻAositulia',
    'au'  => 'ʻAositelēlia',
    'aw'  => 'ʻAlupa',
    'ax'  => "ʻOtumotu\ ʻAlani",
    'az'  => 'ʻAsapaisani',
    'ba'  => "Posinia\ mo\ Hesikōvinia",
    'bb'  => 'Pāpeitosi',
    'bd'  => 'Pengilātesi',
    'be'  => 'Pelesiume',
    'bf'  => "Pekano\ Faso",
    'bg'  => 'Pokalia',
    'bh'  => 'Paleini',
    'bi'  => 'Pelaniti',
    'bj'  => 'Penini',
    'bl'  => "Seini\ Pafelemi",
    'bm'  => 'Pēmuta',
    'bn'  => 'Pulunei',
    'bo'  => 'Polīvia',
    'bq'  => "British\ Antarctic\ Territory",
    'br'  => 'Palāsili',
    'bs'  => 'Pahama',
    'bt'  => 'Pūtani',
    'bv'  => "Motu\ Puveti",
    'bw'  => 'Potisiuana',
    'by'  => 'Pelelusi',
    'bz'  => 'Pelise',
    'ca'  => 'Kānata',
    'cc'  => "ʻOtumotu\ Koko",
    'cd'  => "Kongo\ \[DRC\]",
    'cf'  => "Lipapilika\ ʻAfilika\ Lotoloto",
    'cg'  => "Lipapilika\ Kongo",
    'ch'  => 'Suisilani',
    'ci'  => "Matafonua\ ʻAivili",
    'ck'  => "ʻOtumotu\ Kuki",
    'cl'  => 'Sili',
    'cm'  => 'Kemaluni',
    'cn'  => 'Siaina',
    'co'  => 'Kolomipia',
    'cp'  => "Motu\ Kilipatoni",
    'cr'  => "Kosita\ Lika",
    'cs'  => "Serbia\ and\ Montenegro",
    'ct'  => "Canton\ and\ Enderbury\ Islands",
    'cu'  => 'Kiupa',
    'cv'  => "Muiʻi\ Veti",
    'cx'  => "Motu\ Kilisimasi",
    'cy'  => 'Saipalesi',
    'cz'  => "Lipapilika\ Seki",
    'dd'  => "East\ Germany",
    'de'  => 'Siamane',
    'dg'  => "Tieko\ Kāsia",
    'dj'  => 'Siputi',
    'dk'  => 'Tenimaʻake',
    'dm'  => 'Tominika',
    'do'  => "Lipapilika\ Tominika",
    'dz'  => 'ʻAisilia',
    'ea'  => "Siuta\ mo\ Melila",
    'ec'  => 'ʻEkuetoa',
    'ee'  => 'ʻEsitōnia',
    'eg'  => 'ʻIsipite',
    'eh'  => "Sahala\ fakahihifo",
    'er'  => 'ʻElitulia',
    'es'  => 'Sipeini',
    'et'  => 'ʻItiōpea',
    'eu'  => "ʻIulope\ fakatahataha",
    'fi'  => 'Finilani',
    'fj'  => 'Fisi',
    'fk'  => "ʻOtumotu\ Fokuleni",
    'fm'  => 'Mikolonisia',
    'fo'  => "ʻOtumotu\ Felou",
    'fq'  => "French\ Southern\ and\ Antarctic\ Territories",
    'fr'  => 'Falanisē',
    'fx'  => "Metropolitan\ France",
    'ga'  => 'Kaponi',
    'gb'  => 'Pilitānia',
    'gd'  => 'Kelenatā',
    'ge'  => 'Sōsia',
    'gf'  => "Falanise\ Kuiana",
    'gg'  => 'Kuenisī',
    'gh'  => 'Kana',
    'gi'  => 'Sipalālitā',
    'gl'  => 'Kulinileni',
    'gm'  => 'Kamipia',
    'gn'  => 'Kini',
    'gp'  => 'Kuatalupe',
    'gq'  => "ʻEkueta\ Kini",
    'gr'  => 'Kalisi',
    'gs'  => "ʻOtumotu\ Siosia\-tonga\ mo\ Saniuisi\-tonga",
    'gt'  => 'Kuatamala',
    'gu'  => 'Kuamu',
    'gw'  => "Kini\-Pisau",
    'gy'  => 'Kuiana',
    'hk'  => "Hongi\ Kongi",
    'hm'  => "ʻOtumotu\ Heati\ mo\ Makitonali",
    'hn'  => 'Honitulasi',
    'hr'  => 'Kuloisia',
    'ht'  => 'Haiti',
    'hu'  => 'Hangakalia',
    'ic'  => "ʻOtumotu\ Kaneli",
    'id'  => 'ʻInitonēsia',
    'ie'  => 'ʻAealani',
    'il'  => 'ʻIsileli',
    'im'  => "Motu\ Mani",
    'in'  => 'ʻInitia',
    'io'  => "Potu\ fonua\ moana\ ʻInitia\ fakapilitānia",
    'iq'  => 'ʻIulaaki',
    'ir'  => 'ʻIulaani',
    'is'  => 'ʻAisilani',
    'it'  => 'ʻĪtali',
    'je'  => 'Selusī',
    'jm'  => 'Samaika',
    'jo'  => 'Soatane',
    'jp'  => 'Siapani',
    'jt'  => "Johnston\ Island",
    'ke'  => 'Kenia',
    'kg'  => 'Kekisiteni',
    'kh'  => 'Kemipōtia',
    'ki'  => 'Kilipasi',
    'km'  => 'Komolosi',
    'kn'  => "Seini\ Kitisi\ mo\ Nevisi",
    'kp'  => "Kōlea\ tokelau",
    'kr'  => "Kōlea\ tonga",
    'kw'  => 'Kueiti',
    'ky'  => "ʻOtumotu\ Keimeni",
    'kz'  => 'Kasakiteni',
    'la'  => 'Lau',
    'lb'  => 'Lepanoni',
    'lc'  => "Seini\ Lusia",
    'li'  => 'Lekitenisaini',
    'lk'  => 'Silangikā',
    'lr'  => 'Laipelia',
    'ls'  => 'Lesoto',
    'lt'  => 'Lifiuenia',
    'lu'  => 'Lakisimipeki',
    'lv'  => 'Lativia',
    'ly'  => 'Lipia',
    'ma'  => 'Molako',
    'mc'  => 'Manako',
    'md'  => 'Molotova',
    'me'  => 'Monitenikalo',
    'mf'  => "Seini\ Matini",
    'mg'  => 'Matakasika',
    'mh'  => "ʻOtumotu\ Māsolo",
    'mi'  => "Midway\ Islands",
    'mk'  => "Masitōnia\ \[FYROM\]",
    'ml'  => 'Māli',
    'mm'  => 'Pema',
    'mn'  => 'Mongokōlia',
    'mo'  => 'Makau',
    'mp'  => "ʻOtumotu\ Maliana\ tokelau",
    'mq'  => 'Mateniki',
    'mr'  => 'Maulitenia',
    'ms'  => 'Moʻungaselati',
    'mt'  => 'Malita',
    'mu'  => 'Maulitiusi',
    'mv'  => 'Malativisi',
    'mw'  => 'Malaui',
    'mx'  => 'Mekisikou',
    'my'  => 'Malēsia',
    'mz'  => 'Mosenipiki',
    'na'  => 'Namipia',
    'nc'  => "Niu\ Kaletōnia",
    'ne'  => 'Naisia',
    'nf'  => "Motu\ Nōfoliki",
    'ng'  => 'Naisilia',
    'ni'  => 'Nikalakua',
    'nl'  => 'Hōlani',
    'no'  => 'Noauē',
    'np'  => 'Nepali',
    'nq'  => "Dronning\ Maud\ Land",
    'nr'  => 'Naulu',
    'nt'  => "Neutral\ Zone",
    'nu'  => 'Niuē',
    'nz'  => 'Nuʻusila',
    'om'  => 'ʻOmani',
    'pa'  => 'Panamā',
    'pc'  => "Pacific\ Islands\ Trust\ Territory",
    'pe'  => 'Pelū',
    'pf'  => "Polinisia\ fakafalanisē",
    'pg'  => 'Papuaniukini',
    'ph'  => 'Filipaini',
    'pk'  => 'Pākisitani',
    'pl'  => 'Poleni',
    'pm'  => "Seini\ Piea\ mo\ Mikaloni",
    'pn'  => "ʻOtumotu\ Pitikeni",
    'pr'  => "Pueto\ Liko",
    'ps'  => "Potu\ Palesitaine",
    'pt'  => 'Potukali',
    'pu'  => "U\.S\.\ Miscellaneous\ Pacific\ Islands",
    'pw'  => 'Palau',
    'py'  => 'Palakuei',
    'pz'  => "Panama\ Canal\ Zone",
    'qa'  => 'Katā',
    'qo'  => "ʻOsenia\ Mamaʻo",
    're'  => 'Liʻiunioni',
    'ro'  => 'Lomēnia',
    'rs'  => 'Sēpia',
    'ru'  => 'Lūsia',
    'rw'  => 'Luanitā',
    'sa'  => "Saute\ ʻAlepea",
    'sb'  => "ʻOtumotu\ Solomone",
    'sc'  => "ʻOtumotu\ Seiseli",
    'sd'  => 'Sūteni',
    'se'  => 'Suēteni',
    'sg'  => 'Singapoa',
    'sh'  => "Seini\ Helena",
    'si'  => 'Silōvenia',
    'sj'  => "Sivolopaati\ mo\ Seni\ Meini",
    'sk'  => 'Silōvakia',
    'sl'  => "Siela\ Lione",
    'sm'  => "Seni\ Malino",
    'sn'  => 'Senikalo',
    'so'  => 'Sōmalia',
    'sr'  => 'Sulinami',
    'st'  => "Sao\ Tome\ mo\ Pilinisipe",
    'su'  => "Union\ of\ Soviet\ Socialist\ Republics",
    'sv'  => "ʻEle\ Salavatoa",
    'sy'  => 'Sīlia',
    'sz'  => 'Suasileni',
    'ta'  => "Tulisiteni\ ta\ Kunuha",
    'tc'  => "ʻOtumotu\ Teki\ mo\ Keikosi",
    'td'  => 'Seti',
    'tf'  => "Potu\ fonua\ tonga\ fakafalanisē",
    'tg'  => 'Toko',
    'th'  => 'Taileni',
    'tj'  => 'Tasikitani',
    'tk'  => 'Tokelau',
    'tl'  => "Timoa\ Hahake",
    'tm'  => 'Tekimenisiteni',
    'tn'  => 'Tunīsia',
    'to'  => 'Tonga',
    'tr'  => 'Toake',
    'tt'  => "Tilinitati\ mo\ Topako",
    'tv'  => 'Tūvalu',
    'tw'  => 'Taiuani',
    'tz'  => 'Tenisania',
    'ua'  => 'ʻIukuleini',
    'ug'  => 'ʻIukanitā',
    'um'  => "ʻOtumotu\ siʻi\ ʻo\ ʻAmelika",
    'us'  => "Puleʻanga\ fakatahataha\ ʻAmelika",
    'uy'  => 'ʻUlukuei',
    'uz'  => 'ʻUsipekitēni',
    'va'  => 'Vatikani',
    'vc'  => "Seini\ Viniseni\ mo\ Kulenatini",
    'vd'  => "North\ Vietnam",
    've'  => 'Venisuela',
    'vg'  => "ʻOtumotu\ Vilikini\ fakapilitānia",
    'vi'  => "ʻOtumotu\ Vilikini\ fakaʻamelika",
    'vn'  => 'Vietinemi',
    'vu'  => 'Vanuatu',
    'wf'  => "ʻUvea\ mo\ Futuna",
    'wk'  => "Wake\ Island",
    'ws'  => 'Haʻamoa',
    'yd'  => "People\â\\s\ Democratic\ Republic\ of\ Yemen",
    'ye'  => 'Iemeni',
    'yt'  => 'Meioti',
    'za'  => "ʻAfilika\ tonga",
    'zm'  => 'Semipia',
    'zw'  => 'Simipapuei',
    'zz'  => "Potu\ fonua\ taʻeʻiloa\ pe\ hala",
);

%Locales::DB::Territory::to::name_to_code = (
    'anikuila'                                  => 'ai',
    'anitikuamopalaputa'                        => 'ag',
    'britishantarcticterritory'                 => 'bq',
    'cantonandenderburyislands'                 => 'ct',
    'channelislands'                            => 830,
    'czechoslovakia'                            => 200,
    'dronningmaudland'                          => 'nq',
    'eastgermany'                               => 'dd',
    'falanisekuiana'                            => 'gf',
    'falanisē'                                 => 'fr',
    'filipaini'                                 => 'ph',
    'finilani'                                  => 'fi',
    'fisi'                                      => 'fj',
    'frenchsouthernandantarcticterritories'     => 'fq',
    'haiti'                                     => 'ht',
    'hangakalia'                                => 'hu',
    'haʻamoa'                                  => 'ws',
    'haʻamoaʻamelika'                         => 'as',
    'hongikongi'                                => 'hk',
    'honitulasi'                                => 'hn',
    'hōlani'                                   => 'nl',
    'iemeni'                                    => 'ye',
    'johnstonisland'                            => 'jt',
    'kalipiane'                                 => '029',
    'kalisi'                                    => 'gr',
    'kamipia'                                   => 'gm',
    'kana'                                      => 'gh',
    'kaponi'                                    => 'ga',
    'kasakiteni'                                => 'kz',
    'katā'                                     => 'qa',
    'kekisiteni'                                => 'kg',
    'kelenatā'                                 => 'gd',
    'kemaluni'                                  => 'cm',
    'kemipōtia'                                => 'kh',
    'kenia'                                     => 'ke',
    'kilipasi'                                  => 'ki',
    'kini'                                      => 'gn',
    'kinipisau'                                 => 'gw',
    'kiupa'                                     => 'cu',
    'kolomipia'                                 => 'co',
    'kominiueli'                                => 172,
    'komolosi'                                  => 'km',
    'kongodrc'                                  => 'cd',
    'kositalika'                                => 'cr',
    'kuamu'                                     => 'gu',
    'kuatalupe'                                 => 'gp',
    'kuatamala'                                 => 'gt',
    'kueiti'                                    => 'kw',
    'kuenisī'                                  => 'gg',
    'kuiana'                                    => 'gy',
    'kulinileni'                                => 'gl',
    'kuloisia'                                  => 'hr',
    'kānata'                                   => 'ca',
    'kōleatokelau'                             => 'kp',
    'kōleatonga'                               => 'kr',
    'laipelia'                                  => 'lr',
    'lakisimipeki'                              => 'lu',
    'lativia'                                   => 'lv',
    'lau'                                       => 'la',
    'lekitenisaini'                             => 'li',
    'lepanoni'                                  => 'lb',
    'lesoto'                                    => 'ls',
    'lifiuenia'                                 => 'lt',
    'lipapilikakongo'                           => 'cg',
    'lipapilikaseki'                            => 'cz',
    'lipapilikatominika'                        => 'do',
    'lipapilikaʻafilikalotoloto'               => 'cf',
    'lipia'                                     => 'ly',
    'liʻiunioni'                               => 're',
    'lomēnia'                                  => 'ro',
    'luanitā'                                  => 'rw',
    'lūsia'                                    => 'ru',
    'makau'                                     => 'mo',
    'malativisi'                                => 'mv',
    'malaui'                                    => 'mw',
    'malita'                                    => 'mt',
    'malēsia'                                  => 'my',
    'manako'                                    => 'mc',
    'masitōniafyrom'                           => 'mk',
    'matafonuaʻaivili'                         => 'ci',
    'matakasika'                                => 'mg',
    'mateniki'                                  => 'mq',
    'maulitenia'                                => 'mr',
    'maulitiusi'                                => 'mu',
    'meioti'                                    => 'yt',
    'mekisikou'                                 => 'mx',
    'melanisia'                                 => '054',
    'metropolitanfrance'                        => 'fx',
    'midwayislands'                             => 'mi',
    'mikolonisia'                               => 'fm',
    'molako'                                    => 'ma',
    'molotova'                                  => 'md',
    'mongokōlia'                               => 'mn',
    'monitenikalo'                              => 'me',
    'mosenipiki'                                => 'mz',
    'motukilipatoni'                            => 'cp',
    'motukilisimasi'                            => 'cx',
    'motumani'                                  => 'im',
    'motunōfoliki'                             => 'nf',
    'motupuveti'                                => 'bv',
    'motuʻasenisini'                           => 'ac',
    'moʻungaselati'                            => 'ms',
    'muiʻiveti'                                => 'cv',
    'māli'                                     => 'ml',
    'māmani'                                   => '001',
    'naisia'                                    => 'ne',
    'naisilia'                                  => 'ng',
    'namipia'                                   => 'na',
    'naulu'                                     => 'nr',
    'nepali'                                    => 'np',
    'netaleniʻenitilisi'                       => 'an',
    'neutralzone'                               => 'nt',
    'nikalakua'                                 => 'ni',
    'niukaletōnia'                             => 'nc',
    'niuē'                                     => 'nu',
    'noauē'                                    => 'no',
    'northvietnam'                              => 'vd',
    'nuʻusila'                                 => 'nz',
    'ongoʻamelika'                             => '019',
    'pacificislandstrustterritory'              => 'pc',
    'pahama'                                    => 'bs',
    'palakuei'                                  => 'py',
    'palau'                                     => 'pw',
    'paleini'                                   => 'bh',
    'palāsili'                                 => 'br',
    'panamacanalzone'                           => 'pz',
    'panamā'                                   => 'pa',
    'papuaniukini'                              => 'pg',
    'pekanofaso'                                => 'bf',
    'pelaniti'                                  => 'bi',
    'pelelusi'                                  => 'by',
    'pelesiume'                                 => 'be',
    'pelise'                                    => 'bz',
    'pelū'                                     => 'pe',
    'pema'                                      => 'mm',
    'pengilātesi'                              => 'bd',
    'penini'                                    => 'bj',
    "people\â\\sdemocraticrepublicofyemen" => 'yd',
    'pilitānia'                                => 'gb',
    'pokalia'                                   => 'bg',
    'poleni'                                    => 'pl',
    'polinisiafakafalanisē'                    => 'pf',
    'polinīsia'                                => '061',
    'polīvia'                                  => 'bo',
    'posiniamohesikōvinia'                     => 'ba',
    'potisiuana'                                => 'bw',
    'potufonuamikolonisia'                      => '057',
    'potufonuamoanaʻinitiafakapilitānia'      => 'io',
    'potufonuataʻeʻiloapehala'                => 'zz',
    'potufonuatongafakafalanisē'               => 'tf',
    'potukali'                                  => 'pt',
    'potupalesitaine'                           => 'ps',
    'puetoliko'                                 => 'pr',
    'puleʻangafakatahatahaʻamelika'           => 'us',
    'pulunei'                                   => 'bn',
    'pākisitani'                               => 'pk',
    'pāpeitosi'                                => 'bb',
    'pēmuta'                                   => 'bm',
    'pūtani'                                   => 'bt',
    'sahalafakahihifo'                          => 'eh',
    'saipalesi'                                 => 'cy',
    'samaika'                                   => 'jm',
    'saotomemopilinisipe'                       => 'st',
    'sauteʻalepea'                             => 'sa',
    'seinihelena'                               => 'sh',
    'seinikitisimonevisi'                       => 'kn',
    'seinilusia'                                => 'lc',
    'seinimatini'                               => 'mf',
    'seinipafelemi'                             => 'bl',
    'seinipieamomikaloni'                       => 'pm',
    'seinivinisenimokulenatini'                 => 'vc',
    'selusī'                                   => 'je',
    'semipia'                                   => 'zm',
    'senikalo'                                  => 'sn',
    'senimalino'                                => 'sm',
    'serbiaandmontenegro'                       => 'cs',
    'seti'                                      => 'td',
    'siaina'                                    => 'cn',
    'siamane'                                   => 'de',
    'siapani'                                   => 'jp',
    'sielalione'                                => 'sl',
    'silangikā'                                => 'lk',
    'sili'                                      => 'cl',
    'silōvakia'                                => 'sk',
    'silōvenia'                                => 'si',
    'simipapuei'                                => 'zw',
    'singapoa'                                  => 'sg',
    'sipalālitā'                              => 'gi',
    'sipeini'                                   => 'es',
    'siputi'                                    => 'dj',
    'siutamomelila'                             => 'ea',
    'sivolopaatimosenimeini'                    => 'sj',
    'soatane'                                   => 'jo',
    'suasileni'                                 => 'sz',
    'suisilani'                                 => 'ch',
    'sulinami'                                  => 'sr',
    'suēteni'                                  => 'se',
    'sēpia'                                    => 'rs',
    'sīlia'                                    => 'sy',
    'sōmalia'                                  => 'so',
    'sōsia'                                    => 'ge',
    'sūteni'                                   => 'sd',
    'taileni'                                   => 'th',
    'taiuani'                                   => 'tw',
    'tasikitani'                                => 'tj',
    'tekimenisiteni'                            => 'tm',
    'tenimaʻake'                               => 'dk',
    'tenisania'                                 => 'tz',
    'tiekokāsia'                               => 'dg',
    'tilinitatimotopako'                        => 'tt',
    'timoahahake'                               => 'tl',
    'toake'                                     => 'tr',
    'tokelau'                                   => 'tk',
    'toko'                                      => 'tg',
    'tominika'                                  => 'dm',
    'tonga'                                     => 'to',
    'tulisitenitakunuha'                        => 'ta',
    'tunīsia'                                  => 'tn',
    'tūvalu'                                   => 'tv',
    "u\.s\.miscellaneouspacificislands"         => 'pu',
    'unionofsovietsocialistrepublics'           => 'su',
    'vanuatu'                                   => 'vu',
    'vatikani'                                  => 'va',
    'venisuela'                                 => 've',
    'vietinemi'                                 => 'vn',
    'wakeisland'                                => 'wk',
    'ʻaealani'                                 => 'ie',
    'ʻafikānisitani'                          => 'af',
    'ʻafilika'                                 => '002',
    'ʻafilikafakatonga'                        => '018',
    'ʻafilikahahake'                           => '014',
    'ʻafilikahihifo'                           => '011',
    'ʻafilikalotoloto'                         => '017',
    'ʻafilikatokelau'                          => '015',
    'ʻafilikatonga'                            => 'za',
    'ʻaisilani'                                => 'is',
    'ʻaisilia'                                 => 'dz',
    'ʻalepeafakatahataha'                      => 'ae',
    'ʻalipania'                                => 'al',
    'ʻalupa'                                   => 'aw',
    'ʻamelikafakalatinamokalipeane'            => 419,
    'ʻamelikafakatokelau'                      => '021',
    'ʻamelikalotoloto'                         => '013',
    'ʻamelikatokelau'                          => '003',
    'ʻamelikatonga'                            => '005',
    'ʻanitātika'                              => 'aq',
    'ʻaositelēlia'                            => 'au',
    'ʻaositelēliamonuʻusila'                 => '053',
    'ʻaositulia'                               => 'at',
    'ʻasapaisani'                              => 'az',
    'ʻasenitina'                               => 'ar',
    'ʻekuetakini'                              => 'gq',
    'ʻekuetoa'                                 => 'ec',
    'ʻelesalavatoa'                            => 'sv',
    'ʻelitulia'                                => 'er',
    'ʻenikola'                                 => 'ao',
    'ʻenitola'                                 => 'ad',
    'ʻesitōnia'                               => 'ee',
    'ʻinitia'                                  => 'in',
    'ʻinitonēsia'                             => 'id',
    'ʻisileli'                                 => 'il',
    'ʻisipite'                                 => 'eg',
    'ʻitiōpea'                                => 'et',
    'ʻiukanitā'                               => 'ug',
    'ʻiukuleini'                               => 'ua',
    'ʻiulaaki'                                 => 'iq',
    'ʻiulaani'                                 => 'ir',
    'ʻiulope'                                  => 150,
    'ʻiulopefakatahataha'                      => 'eu',
    'ʻiulopefakatonga'                         => '039',
    'ʻiulopehahake'                            => 151,
    'ʻiulopehihifo'                            => 155,
    'ʻiulopetokelau'                           => 154,
    'ʻomani'                                   => 'om',
    'ʻosenia'                                  => '009',
    'ʻoseniamamaʻo'                           => 'qo',
    'ʻotumotufelou'                            => 'fo',
    'ʻotumotufokuleni'                         => 'fk',
    'ʻotumotuheatimomakitonali'                => 'hm',
    'ʻotumotukaneli'                           => 'ic',
    'ʻotumotukeimeni'                          => 'ky',
    'ʻotumotukoko'                             => 'cc',
    'ʻotumotukuki'                             => 'ck',
    'ʻotumotumalianatokelau'                   => 'mp',
    'ʻotumotumāsolo'                          => 'mh',
    'ʻotumotupitikeni'                         => 'pn',
    'ʻotumotuseiseli'                          => 'sc',
    'ʻotumotusiosiatongamosaniuisitonga'       => 'gs',
    'ʻotumotusiʻiʻoʻamelika'                => 'um',
    'ʻotumotusolomone'                         => 'sb',
    'ʻotumotutekimokeikosi'                    => 'tc',
    'ʻotumotuvilikinifakapilitānia'           => 'vg',
    'ʻotumotuvilikinifakaʻamelika'            => 'vi',
    'ʻotumotuʻalani'                          => 'ax',
    'ʻulukuei'                                 => 'uy',
    'ʻusipekitēni'                            => 'uz',
    'ʻuveamofutuna'                            => 'wf',
    'ʻĀminia'                                 => 'am',
    'ʻĒsia'                                   => 142,
    'ʻĒsiafakatonga'                          => '034',
    'ʻĒsiahahake'                             => '030',
    'ʻĒsiahihifo'                             => 145,
    'ʻĒsialotoloto'                           => 143,
    'ʻĒsiatongahahake'                        => '035',
    'ʻĒsiatongalotoloto'                      => '062',
    'ʻĪtali'                                  => 'it',
);

1;

