/*
 * This file is part of lomiri-online-accounts-service
 *
 * Copyright (C) 2011 Canonical Ltd.
 *
 * Contact: Alberto Mardegan <alberto.mardegan@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef SIGNON_UI_SERVICE_H
#define SIGNON_UI_SERVICE_H

#include <QDBusContext>
#include <QObject>
#include <QVariantMap>

class QByteArray;

namespace SignOnUi {

typedef QList<QByteArray> RawCookies;

class ServicePrivate;

class Service: public QObject, protected QDBusContext
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "com.nokia.singlesignonui")

public:
    explicit Service(QObject *parent = 0);
    ~Service();

public Q_SLOTS:
    QVariantMap queryDialog(const QVariantMap &parameters);
    QVariantMap refreshDialog(const QVariantMap &newParameters);
    Q_NOREPLY void cancelUiRequest(const QString &requestId);
    void removeIdentityData(quint32 id);

    /*
     * This is not officially part of the interface; it's an Ubuntu-specific
     * experimental method, and we reserve the right to remove or change it in
     * future releases.
     */
    void cookiesForIdentity(quint32 id,
                            // Output parameters
                            RawCookies &cookies, qint64 &timestamp);

private:
    ServicePrivate *d_ptr;
    Q_DECLARE_PRIVATE(Service)
};

} // namespace

Q_DECLARE_METATYPE(SignOnUi::RawCookies)

#endif // SIGNON_UI_SERVICE_H

