#[allow(non_camel_case_types)]
#[derive(Debug, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
pub enum Opcode {
  PHI,
  INLINEASM,
  INLINEASM_BR,
  CFI_INSTRUCTION,
  EH_LABEL,
  GC_LABEL,
  ANNOTATION_LABEL,
  KILL,
  EXTRACT_SUBREG,
  INSERT_SUBREG,
  IMPLICIT_DEF,
  SUBREG_TO_REG,
  COPY_TO_REGCLASS,
  DBG_VALUE,
  DBG_VALUE_LIST,
  DBG_INSTR_REF,
  DBG_PHI,
  DBG_LABEL,
  REG_SEQUENCE,
  COPY,
  BUNDLE,
  LIFETIME_START,
  LIFETIME_END,
  PSEUDO_PROBE,
  ARITH_FENCE,
  STACKMAP,
  FENTRY_CALL,
  PATCHPOINT,
  LOAD_STACK_GUARD,
  PREALLOCATED_SETUP,
  PREALLOCATED_ARG,
  STATEPOINT,
  LOCAL_ESCAPE,
  FAULTING_OP,
  PATCHABLE_OP,
  PATCHABLE_FUNCTION_ENTER,
  PATCHABLE_RET,
  PATCHABLE_FUNCTION_EXIT,
  PATCHABLE_TAIL_CALL,
  PATCHABLE_EVENT_CALL,
  PATCHABLE_TYPED_EVENT_CALL,
  ICALL_BRANCH_FUNNEL,
  MEMBARRIER,
  JUMP_TABLE_DEBUG_INFO,
  CONVERGENCECTRL_ENTRY,
  CONVERGENCECTRL_ANCHOR,
  CONVERGENCECTRL_LOOP,
  CONVERGENCECTRL_GLUE,
  G_ASSERT_SEXT,
  G_ASSERT_ZEXT,
  G_ASSERT_ALIGN,
  G_ADD,
  G_SUB,
  G_MUL,
  G_SDIV,
  G_UDIV,
  G_SREM,
  G_UREM,
  G_SDIVREM,
  G_UDIVREM,
  G_AND,
  G_OR,
  G_XOR,
  G_IMPLICIT_DEF,
  G_PHI,
  G_FRAME_INDEX,
  G_GLOBAL_VALUE,
  G_PTRAUTH_GLOBAL_VALUE,
  G_CONSTANT_POOL,
  G_EXTRACT,
  G_UNMERGE_VALUES,
  G_INSERT,
  G_MERGE_VALUES,
  G_BUILD_VECTOR,
  G_BUILD_VECTOR_TRUNC,
  G_CONCAT_VECTORS,
  G_PTRTOINT,
  G_INTTOPTR,
  G_BITCAST,
  G_FREEZE,
  G_CONSTANT_FOLD_BARRIER,
  G_INTRINSIC_FPTRUNC_ROUND,
  G_INTRINSIC_TRUNC,
  G_INTRINSIC_ROUND,
  G_INTRINSIC_LRINT,
  G_INTRINSIC_LLRINT,
  G_INTRINSIC_ROUNDEVEN,
  G_READCYCLECOUNTER,
  G_READSTEADYCOUNTER,
  G_LOAD,
  G_SEXTLOAD,
  G_ZEXTLOAD,
  G_INDEXED_LOAD,
  G_INDEXED_SEXTLOAD,
  G_INDEXED_ZEXTLOAD,
  G_STORE,
  G_INDEXED_STORE,
  G_ATOMIC_CMPXCHG_WITH_SUCCESS,
  G_ATOMIC_CMPXCHG,
  G_ATOMICRMW_XCHG,
  G_ATOMICRMW_ADD,
  G_ATOMICRMW_SUB,
  G_ATOMICRMW_AND,
  G_ATOMICRMW_NAND,
  G_ATOMICRMW_OR,
  G_ATOMICRMW_XOR,
  G_ATOMICRMW_MAX,
  G_ATOMICRMW_MIN,
  G_ATOMICRMW_UMAX,
  G_ATOMICRMW_UMIN,
  G_ATOMICRMW_FADD,
  G_ATOMICRMW_FSUB,
  G_ATOMICRMW_FMAX,
  G_ATOMICRMW_FMIN,
  G_ATOMICRMW_UINC_WRAP,
  G_ATOMICRMW_UDEC_WRAP,
  G_FENCE,
  G_PREFETCH,
  G_BRCOND,
  G_BRINDIRECT,
  G_INVOKE_REGION_START,
  G_INTRINSIC,
  G_INTRINSIC_W_SIDE_EFFECTS,
  G_INTRINSIC_CONVERGENT,
  G_INTRINSIC_CONVERGENT_W_SIDE_EFFECTS,
  G_ANYEXT,
  G_TRUNC,
  G_CONSTANT,
  G_FCONSTANT,
  G_VASTART,
  G_VAARG,
  G_SEXT,
  G_SEXT_INREG,
  G_ZEXT,
  G_SHL,
  G_LSHR,
  G_ASHR,
  G_FSHL,
  G_FSHR,
  G_ROTR,
  G_ROTL,
  G_ICMP,
  G_FCMP,
  G_SCMP,
  G_UCMP,
  G_SELECT,
  G_UADDO,
  G_UADDE,
  G_USUBO,
  G_USUBE,
  G_SADDO,
  G_SADDE,
  G_SSUBO,
  G_SSUBE,
  G_UMULO,
  G_SMULO,
  G_UMULH,
  G_SMULH,
  G_UADDSAT,
  G_SADDSAT,
  G_USUBSAT,
  G_SSUBSAT,
  G_USHLSAT,
  G_SSHLSAT,
  G_SMULFIX,
  G_UMULFIX,
  G_SMULFIXSAT,
  G_UMULFIXSAT,
  G_SDIVFIX,
  G_UDIVFIX,
  G_SDIVFIXSAT,
  G_UDIVFIXSAT,
  G_FADD,
  G_FSUB,
  G_FMUL,
  G_FMA,
  G_FMAD,
  G_FDIV,
  G_FREM,
  G_FPOW,
  G_FPOWI,
  G_FEXP,
  G_FEXP2,
  G_FEXP10,
  G_FLOG,
  G_FLOG2,
  G_FLOG10,
  G_FLDEXP,
  G_FFREXP,
  G_FNEG,
  G_FPEXT,
  G_FPTRUNC,
  G_FPTOSI,
  G_FPTOUI,
  G_SITOFP,
  G_UITOFP,
  G_FABS,
  G_FCOPYSIGN,
  G_IS_FPCLASS,
  G_FCANONICALIZE,
  G_FMINNUM,
  G_FMAXNUM,
  G_FMINNUM_IEEE,
  G_FMAXNUM_IEEE,
  G_FMINIMUM,
  G_FMAXIMUM,
  G_GET_FPENV,
  G_SET_FPENV,
  G_RESET_FPENV,
  G_GET_FPMODE,
  G_SET_FPMODE,
  G_RESET_FPMODE,
  G_PTR_ADD,
  G_PTRMASK,
  G_SMIN,
  G_SMAX,
  G_UMIN,
  G_UMAX,
  G_ABS,
  G_LROUND,
  G_LLROUND,
  G_BR,
  G_BRJT,
  G_VSCALE,
  G_INSERT_SUBVECTOR,
  G_EXTRACT_SUBVECTOR,
  G_INSERT_VECTOR_ELT,
  G_EXTRACT_VECTOR_ELT,
  G_SHUFFLE_VECTOR,
  G_SPLAT_VECTOR,
  G_VECTOR_COMPRESS,
  G_CTTZ,
  G_CTTZ_ZERO_UNDEF,
  G_CTLZ,
  G_CTLZ_ZERO_UNDEF,
  G_CTPOP,
  G_BSWAP,
  G_BITREVERSE,
  G_FCEIL,
  G_FCOS,
  G_FSIN,
  G_FTAN,
  G_FACOS,
  G_FASIN,
  G_FATAN,
  G_FCOSH,
  G_FSINH,
  G_FTANH,
  G_FSQRT,
  G_FFLOOR,
  G_FRINT,
  G_FNEARBYINT,
  G_ADDRSPACE_CAST,
  G_BLOCK_ADDR,
  G_JUMP_TABLE,
  G_DYN_STACKALLOC,
  G_STACKSAVE,
  G_STACKRESTORE,
  G_STRICT_FADD,
  G_STRICT_FSUB,
  G_STRICT_FMUL,
  G_STRICT_FDIV,
  G_STRICT_FREM,
  G_STRICT_FMA,
  G_STRICT_FSQRT,
  G_STRICT_FLDEXP,
  G_READ_REGISTER,
  G_WRITE_REGISTER,
  G_MEMCPY,
  G_MEMCPY_INLINE,
  G_MEMMOVE,
  G_MEMSET,
  G_BZERO,
  G_TRAP,
  G_DEBUGTRAP,
  G_UBSANTRAP,
  G_VECREDUCE_SEQ_FADD,
  G_VECREDUCE_SEQ_FMUL,
  G_VECREDUCE_FADD,
  G_VECREDUCE_FMUL,
  G_VECREDUCE_FMAX,
  G_VECREDUCE_FMIN,
  G_VECREDUCE_FMAXIMUM,
  G_VECREDUCE_FMINIMUM,
  G_VECREDUCE_ADD,
  G_VECREDUCE_MUL,
  G_VECREDUCE_AND,
  G_VECREDUCE_OR,
  G_VECREDUCE_XOR,
  G_VECREDUCE_SMAX,
  G_VECREDUCE_SMIN,
  G_VECREDUCE_UMAX,
  G_VECREDUCE_UMIN,
  G_SBFX,
  G_UBFX,
  ADJCALLSTACKDOWN,
  ADJCALLSTACKUP,
  BuildPairF64Pseudo,
  G_FCLASS,
  G_READ_VLENB,
  G_SPLAT_VECTOR_SPLIT_I64_VL,
  G_VMCLR_VL,
  G_VMSET_VL,
  HWASAN_CHECK_MEMACCESS_SHORTGRANULES,
  KCFI_CHECK,
  PseudoAddTPRel,
  PseudoAtomicLoadNand32,
  PseudoAtomicLoadNand64,
  PseudoBR,
  PseudoBRIND,
  PseudoBRINDNonX7,
  PseudoBRINDX7,
  PseudoCALL,
  PseudoCALLIndirect,
  PseudoCALLIndirectNonX7,
  PseudoCALLReg,
  PseudoCCADD,
  PseudoCCADDI,
  PseudoCCADDIW,
  PseudoCCADDW,
  PseudoCCAND,
  PseudoCCANDI,
  PseudoCCANDN,
  PseudoCCMOVGPR,
  PseudoCCMOVGPRNoX0,
  PseudoCCOR,
  PseudoCCORI,
  PseudoCCORN,
  PseudoCCSLL,
  PseudoCCSLLI,
  PseudoCCSLLIW,
  PseudoCCSLLW,
  PseudoCCSRA,
  PseudoCCSRAI,
  PseudoCCSRAIW,
  PseudoCCSRAW,
  PseudoCCSRL,
  PseudoCCSRLI,
  PseudoCCSRLIW,
  PseudoCCSRLW,
  PseudoCCSUB,
  PseudoCCSUBW,
  PseudoCCXNOR,
  PseudoCCXOR,
  PseudoCCXORI,
  PseudoCmpXchg32,
  PseudoCmpXchg64,
  PseudoFLD,
  PseudoFLH,
  PseudoFLW,
  PseudoFROUND_D,
  PseudoFROUND_D_IN32X,
  PseudoFROUND_D_INX,
  PseudoFROUND_H,
  PseudoFROUND_H_INX,
  PseudoFROUND_S,
  PseudoFROUND_S_INX,
  PseudoFSD,
  PseudoFSH,
  PseudoFSW,
  PseudoJump,
  PseudoLA,
  PseudoLAImm,
  PseudoLA_TLSDESC,
  PseudoLA_TLS_GD,
  PseudoLA_TLS_IE,
  PseudoLB,
  PseudoLBU,
  PseudoLD,
  PseudoLGA,
  PseudoLH,
  PseudoLHU,
  PseudoLI,
  PseudoLLA,
  PseudoLLAImm,
  PseudoLW,
  PseudoLWU,
  PseudoLongBEQ,
  PseudoLongBGE,
  PseudoLongBGEU,
  PseudoLongBLT,
  PseudoLongBLTU,
  PseudoLongBNE,
  PseudoMaskedAtomicLoadAdd32,
  PseudoMaskedAtomicLoadMax32,
  PseudoMaskedAtomicLoadMin32,
  PseudoMaskedAtomicLoadNand32,
  PseudoMaskedAtomicLoadSub32,
  PseudoMaskedAtomicLoadUMax32,
  PseudoMaskedAtomicLoadUMin32,
  PseudoMaskedAtomicSwap32,
  PseudoMaskedCmpXchg32,
  PseudoMovAddr,
  PseudoMovImm,
  PseudoQuietFLE_D,
  PseudoQuietFLE_D_IN32X,
  PseudoQuietFLE_D_INX,
  PseudoQuietFLE_H,
  PseudoQuietFLE_H_INX,
  PseudoQuietFLE_S,
  PseudoQuietFLE_S_INX,
  PseudoQuietFLT_D,
  PseudoQuietFLT_D_IN32X,
  PseudoQuietFLT_D_INX,
  PseudoQuietFLT_H,
  PseudoQuietFLT_H_INX,
  PseudoQuietFLT_S,
  PseudoQuietFLT_S_INX,
  PseudoRET,
  PseudoRV32ZdinxLD,
  PseudoRV32ZdinxSD,
  PseudoRVVInitUndefM1,
  PseudoRVVInitUndefM2,
  PseudoRVVInitUndefM4,
  PseudoRVVInitUndefM8,
  PseudoReadVL,
  PseudoReadVLENB,
  PseudoSB,
  PseudoSD,
  PseudoSEXT_B,
  PseudoSEXT_H,
  PseudoSH,
  PseudoSW,
  PseudoTAIL,
  PseudoTAILIndirect,
  PseudoTAILIndirectNonX7,
  PseudoTHVdotVMAQASU_VV_M1,
  PseudoTHVdotVMAQASU_VV_M1_MASK,
  PseudoTHVdotVMAQASU_VV_M2,
  PseudoTHVdotVMAQASU_VV_M2_MASK,
  PseudoTHVdotVMAQASU_VV_M4,
  PseudoTHVdotVMAQASU_VV_M4_MASK,
  PseudoTHVdotVMAQASU_VV_M8,
  PseudoTHVdotVMAQASU_VV_M8_MASK,
  PseudoTHVdotVMAQASU_VV_MF2,
  PseudoTHVdotVMAQASU_VV_MF2_MASK,
  PseudoTHVdotVMAQASU_VX_M1,
  PseudoTHVdotVMAQASU_VX_M1_MASK,
  PseudoTHVdotVMAQASU_VX_M2,
  PseudoTHVdotVMAQASU_VX_M2_MASK,
  PseudoTHVdotVMAQASU_VX_M4,
  PseudoTHVdotVMAQASU_VX_M4_MASK,
  PseudoTHVdotVMAQASU_VX_M8,
  PseudoTHVdotVMAQASU_VX_M8_MASK,
  PseudoTHVdotVMAQASU_VX_MF2,
  PseudoTHVdotVMAQASU_VX_MF2_MASK,
  PseudoTHVdotVMAQAUS_VX_M1,
  PseudoTHVdotVMAQAUS_VX_M1_MASK,
  PseudoTHVdotVMAQAUS_VX_M2,
  PseudoTHVdotVMAQAUS_VX_M2_MASK,
  PseudoTHVdotVMAQAUS_VX_M4,
  PseudoTHVdotVMAQAUS_VX_M4_MASK,
  PseudoTHVdotVMAQAUS_VX_M8,
  PseudoTHVdotVMAQAUS_VX_M8_MASK,
  PseudoTHVdotVMAQAUS_VX_MF2,
  PseudoTHVdotVMAQAUS_VX_MF2_MASK,
  PseudoTHVdotVMAQAU_VV_M1,
  PseudoTHVdotVMAQAU_VV_M1_MASK,
  PseudoTHVdotVMAQAU_VV_M2,
  PseudoTHVdotVMAQAU_VV_M2_MASK,
  PseudoTHVdotVMAQAU_VV_M4,
  PseudoTHVdotVMAQAU_VV_M4_MASK,
  PseudoTHVdotVMAQAU_VV_M8,
  PseudoTHVdotVMAQAU_VV_M8_MASK,
  PseudoTHVdotVMAQAU_VV_MF2,
  PseudoTHVdotVMAQAU_VV_MF2_MASK,
  PseudoTHVdotVMAQAU_VX_M1,
  PseudoTHVdotVMAQAU_VX_M1_MASK,
  PseudoTHVdotVMAQAU_VX_M2,
  PseudoTHVdotVMAQAU_VX_M2_MASK,
  PseudoTHVdotVMAQAU_VX_M4,
  PseudoTHVdotVMAQAU_VX_M4_MASK,
  PseudoTHVdotVMAQAU_VX_M8,
  PseudoTHVdotVMAQAU_VX_M8_MASK,
  PseudoTHVdotVMAQAU_VX_MF2,
  PseudoTHVdotVMAQAU_VX_MF2_MASK,
  PseudoTHVdotVMAQA_VV_M1,
  PseudoTHVdotVMAQA_VV_M1_MASK,
  PseudoTHVdotVMAQA_VV_M2,
  PseudoTHVdotVMAQA_VV_M2_MASK,
  PseudoTHVdotVMAQA_VV_M4,
  PseudoTHVdotVMAQA_VV_M4_MASK,
  PseudoTHVdotVMAQA_VV_M8,
  PseudoTHVdotVMAQA_VV_M8_MASK,
  PseudoTHVdotVMAQA_VV_MF2,
  PseudoTHVdotVMAQA_VV_MF2_MASK,
  PseudoTHVdotVMAQA_VX_M1,
  PseudoTHVdotVMAQA_VX_M1_MASK,
  PseudoTHVdotVMAQA_VX_M2,
  PseudoTHVdotVMAQA_VX_M2_MASK,
  PseudoTHVdotVMAQA_VX_M4,
  PseudoTHVdotVMAQA_VX_M4_MASK,
  PseudoTHVdotVMAQA_VX_M8,
  PseudoTHVdotVMAQA_VX_M8_MASK,
  PseudoTHVdotVMAQA_VX_MF2,
  PseudoTHVdotVMAQA_VX_MF2_MASK,
  PseudoTLSDESCCall,
  PseudoVAADDU_VV_M1,
  PseudoVAADDU_VV_M1_MASK,
  PseudoVAADDU_VV_M2,
  PseudoVAADDU_VV_M2_MASK,
  PseudoVAADDU_VV_M4,
  PseudoVAADDU_VV_M4_MASK,
  PseudoVAADDU_VV_M8,
  PseudoVAADDU_VV_M8_MASK,
  PseudoVAADDU_VV_MF2,
  PseudoVAADDU_VV_MF2_MASK,
  PseudoVAADDU_VV_MF4,
  PseudoVAADDU_VV_MF4_MASK,
  PseudoVAADDU_VV_MF8,
  PseudoVAADDU_VV_MF8_MASK,
  PseudoVAADDU_VX_M1,
  PseudoVAADDU_VX_M1_MASK,
  PseudoVAADDU_VX_M2,
  PseudoVAADDU_VX_M2_MASK,
  PseudoVAADDU_VX_M4,
  PseudoVAADDU_VX_M4_MASK,
  PseudoVAADDU_VX_M8,
  PseudoVAADDU_VX_M8_MASK,
  PseudoVAADDU_VX_MF2,
  PseudoVAADDU_VX_MF2_MASK,
  PseudoVAADDU_VX_MF4,
  PseudoVAADDU_VX_MF4_MASK,
  PseudoVAADDU_VX_MF8,
  PseudoVAADDU_VX_MF8_MASK,
  PseudoVAADD_VV_M1,
  PseudoVAADD_VV_M1_MASK,
  PseudoVAADD_VV_M2,
  PseudoVAADD_VV_M2_MASK,
  PseudoVAADD_VV_M4,
  PseudoVAADD_VV_M4_MASK,
  PseudoVAADD_VV_M8,
  PseudoVAADD_VV_M8_MASK,
  PseudoVAADD_VV_MF2,
  PseudoVAADD_VV_MF2_MASK,
  PseudoVAADD_VV_MF4,
  PseudoVAADD_VV_MF4_MASK,
  PseudoVAADD_VV_MF8,
  PseudoVAADD_VV_MF8_MASK,
  PseudoVAADD_VX_M1,
  PseudoVAADD_VX_M1_MASK,
  PseudoVAADD_VX_M2,
  PseudoVAADD_VX_M2_MASK,
  PseudoVAADD_VX_M4,
  PseudoVAADD_VX_M4_MASK,
  PseudoVAADD_VX_M8,
  PseudoVAADD_VX_M8_MASK,
  PseudoVAADD_VX_MF2,
  PseudoVAADD_VX_MF2_MASK,
  PseudoVAADD_VX_MF4,
  PseudoVAADD_VX_MF4_MASK,
  PseudoVAADD_VX_MF8,
  PseudoVAADD_VX_MF8_MASK,
  PseudoVADC_VIM_M1,
  PseudoVADC_VIM_M2,
  PseudoVADC_VIM_M4,
  PseudoVADC_VIM_M8,
  PseudoVADC_VIM_MF2,
  PseudoVADC_VIM_MF4,
  PseudoVADC_VIM_MF8,
  PseudoVADC_VVM_M1,
  PseudoVADC_VVM_M2,
  PseudoVADC_VVM_M4,
  PseudoVADC_VVM_M8,
  PseudoVADC_VVM_MF2,
  PseudoVADC_VVM_MF4,
  PseudoVADC_VVM_MF8,
  PseudoVADC_VXM_M1,
  PseudoVADC_VXM_M2,
  PseudoVADC_VXM_M4,
  PseudoVADC_VXM_M8,
  PseudoVADC_VXM_MF2,
  PseudoVADC_VXM_MF4,
  PseudoVADC_VXM_MF8,
  PseudoVADD_VI_M1,
  PseudoVADD_VI_M1_MASK,
  PseudoVADD_VI_M2,
  PseudoVADD_VI_M2_MASK,
  PseudoVADD_VI_M4,
  PseudoVADD_VI_M4_MASK,
  PseudoVADD_VI_M8,
  PseudoVADD_VI_M8_MASK,
  PseudoVADD_VI_MF2,
  PseudoVADD_VI_MF2_MASK,
  PseudoVADD_VI_MF4,
  PseudoVADD_VI_MF4_MASK,
  PseudoVADD_VI_MF8,
  PseudoVADD_VI_MF8_MASK,
  PseudoVADD_VV_M1,
  PseudoVADD_VV_M1_MASK,
  PseudoVADD_VV_M2,
  PseudoVADD_VV_M2_MASK,
  PseudoVADD_VV_M4,
  PseudoVADD_VV_M4_MASK,
  PseudoVADD_VV_M8,
  PseudoVADD_VV_M8_MASK,
  PseudoVADD_VV_MF2,
  PseudoVADD_VV_MF2_MASK,
  PseudoVADD_VV_MF4,
  PseudoVADD_VV_MF4_MASK,
  PseudoVADD_VV_MF8,
  PseudoVADD_VV_MF8_MASK,
  PseudoVADD_VX_M1,
  PseudoVADD_VX_M1_MASK,
  PseudoVADD_VX_M2,
  PseudoVADD_VX_M2_MASK,
  PseudoVADD_VX_M4,
  PseudoVADD_VX_M4_MASK,
  PseudoVADD_VX_M8,
  PseudoVADD_VX_M8_MASK,
  PseudoVADD_VX_MF2,
  PseudoVADD_VX_MF2_MASK,
  PseudoVADD_VX_MF4,
  PseudoVADD_VX_MF4_MASK,
  PseudoVADD_VX_MF8,
  PseudoVADD_VX_MF8_MASK,
  PseudoVAESDF_VS_M1_M1,
  PseudoVAESDF_VS_M1_MF2,
  PseudoVAESDF_VS_M1_MF4,
  PseudoVAESDF_VS_M1_MF8,
  PseudoVAESDF_VS_M2_M1,
  PseudoVAESDF_VS_M2_M2,
  PseudoVAESDF_VS_M2_MF2,
  PseudoVAESDF_VS_M2_MF4,
  PseudoVAESDF_VS_M2_MF8,
  PseudoVAESDF_VS_M4_M1,
  PseudoVAESDF_VS_M4_M2,
  PseudoVAESDF_VS_M4_M4,
  PseudoVAESDF_VS_M4_MF2,
  PseudoVAESDF_VS_M4_MF4,
  PseudoVAESDF_VS_M4_MF8,
  PseudoVAESDF_VS_M8_M1,
  PseudoVAESDF_VS_M8_M2,
  PseudoVAESDF_VS_M8_M4,
  PseudoVAESDF_VS_M8_MF2,
  PseudoVAESDF_VS_M8_MF4,
  PseudoVAESDF_VS_M8_MF8,
  PseudoVAESDF_VS_MF2_MF2,
  PseudoVAESDF_VS_MF2_MF4,
  PseudoVAESDF_VS_MF2_MF8,
  PseudoVAESDF_VV_M1,
  PseudoVAESDF_VV_M2,
  PseudoVAESDF_VV_M4,
  PseudoVAESDF_VV_M8,
  PseudoVAESDF_VV_MF2,
  PseudoVAESDM_VS_M1_M1,
  PseudoVAESDM_VS_M1_MF2,
  PseudoVAESDM_VS_M1_MF4,
  PseudoVAESDM_VS_M1_MF8,
  PseudoVAESDM_VS_M2_M1,
  PseudoVAESDM_VS_M2_M2,
  PseudoVAESDM_VS_M2_MF2,
  PseudoVAESDM_VS_M2_MF4,
  PseudoVAESDM_VS_M2_MF8,
  PseudoVAESDM_VS_M4_M1,
  PseudoVAESDM_VS_M4_M2,
  PseudoVAESDM_VS_M4_M4,
  PseudoVAESDM_VS_M4_MF2,
  PseudoVAESDM_VS_M4_MF4,
  PseudoVAESDM_VS_M4_MF8,
  PseudoVAESDM_VS_M8_M1,
  PseudoVAESDM_VS_M8_M2,
  PseudoVAESDM_VS_M8_M4,
  PseudoVAESDM_VS_M8_MF2,
  PseudoVAESDM_VS_M8_MF4,
  PseudoVAESDM_VS_M8_MF8,
  PseudoVAESDM_VS_MF2_MF2,
  PseudoVAESDM_VS_MF2_MF4,
  PseudoVAESDM_VS_MF2_MF8,
  PseudoVAESDM_VV_M1,
  PseudoVAESDM_VV_M2,
  PseudoVAESDM_VV_M4,
  PseudoVAESDM_VV_M8,
  PseudoVAESDM_VV_MF2,
  PseudoVAESEF_VS_M1_M1,
  PseudoVAESEF_VS_M1_MF2,
  PseudoVAESEF_VS_M1_MF4,
  PseudoVAESEF_VS_M1_MF8,
  PseudoVAESEF_VS_M2_M1,
  PseudoVAESEF_VS_M2_M2,
  PseudoVAESEF_VS_M2_MF2,
  PseudoVAESEF_VS_M2_MF4,
  PseudoVAESEF_VS_M2_MF8,
  PseudoVAESEF_VS_M4_M1,
  PseudoVAESEF_VS_M4_M2,
  PseudoVAESEF_VS_M4_M4,
  PseudoVAESEF_VS_M4_MF2,
  PseudoVAESEF_VS_M4_MF4,
  PseudoVAESEF_VS_M4_MF8,
  PseudoVAESEF_VS_M8_M1,
  PseudoVAESEF_VS_M8_M2,
  PseudoVAESEF_VS_M8_M4,
  PseudoVAESEF_VS_M8_MF2,
  PseudoVAESEF_VS_M8_MF4,
  PseudoVAESEF_VS_M8_MF8,
  PseudoVAESEF_VS_MF2_MF2,
  PseudoVAESEF_VS_MF2_MF4,
  PseudoVAESEF_VS_MF2_MF8,
  PseudoVAESEF_VV_M1,
  PseudoVAESEF_VV_M2,
  PseudoVAESEF_VV_M4,
  PseudoVAESEF_VV_M8,
  PseudoVAESEF_VV_MF2,
  PseudoVAESEM_VS_M1_M1,
  PseudoVAESEM_VS_M1_MF2,
  PseudoVAESEM_VS_M1_MF4,
  PseudoVAESEM_VS_M1_MF8,
  PseudoVAESEM_VS_M2_M1,
  PseudoVAESEM_VS_M2_M2,
  PseudoVAESEM_VS_M2_MF2,
  PseudoVAESEM_VS_M2_MF4,
  PseudoVAESEM_VS_M2_MF8,
  PseudoVAESEM_VS_M4_M1,
  PseudoVAESEM_VS_M4_M2,
  PseudoVAESEM_VS_M4_M4,
  PseudoVAESEM_VS_M4_MF2,
  PseudoVAESEM_VS_M4_MF4,
  PseudoVAESEM_VS_M4_MF8,
  PseudoVAESEM_VS_M8_M1,
  PseudoVAESEM_VS_M8_M2,
  PseudoVAESEM_VS_M8_M4,
  PseudoVAESEM_VS_M8_MF2,
  PseudoVAESEM_VS_M8_MF4,
  PseudoVAESEM_VS_M8_MF8,
  PseudoVAESEM_VS_MF2_MF2,
  PseudoVAESEM_VS_MF2_MF4,
  PseudoVAESEM_VS_MF2_MF8,
  PseudoVAESEM_VV_M1,
  PseudoVAESEM_VV_M2,
  PseudoVAESEM_VV_M4,
  PseudoVAESEM_VV_M8,
  PseudoVAESEM_VV_MF2,
  PseudoVAESKF1_VI_M1,
  PseudoVAESKF1_VI_M2,
  PseudoVAESKF1_VI_M4,
  PseudoVAESKF1_VI_M8,
  PseudoVAESKF1_VI_MF2,
  PseudoVAESKF2_VI_M1,
  PseudoVAESKF2_VI_M2,
  PseudoVAESKF2_VI_M4,
  PseudoVAESKF2_VI_M8,
  PseudoVAESKF2_VI_MF2,
  PseudoVAESZ_VS_M1_M1,
  PseudoVAESZ_VS_M1_MF2,
  PseudoVAESZ_VS_M1_MF4,
  PseudoVAESZ_VS_M1_MF8,
  PseudoVAESZ_VS_M2_M1,
  PseudoVAESZ_VS_M2_M2,
  PseudoVAESZ_VS_M2_MF2,
  PseudoVAESZ_VS_M2_MF4,
  PseudoVAESZ_VS_M2_MF8,
  PseudoVAESZ_VS_M4_M1,
  PseudoVAESZ_VS_M4_M2,
  PseudoVAESZ_VS_M4_M4,
  PseudoVAESZ_VS_M4_MF2,
  PseudoVAESZ_VS_M4_MF4,
  PseudoVAESZ_VS_M4_MF8,
  PseudoVAESZ_VS_M8_M1,
  PseudoVAESZ_VS_M8_M2,
  PseudoVAESZ_VS_M8_M4,
  PseudoVAESZ_VS_M8_MF2,
  PseudoVAESZ_VS_M8_MF4,
  PseudoVAESZ_VS_M8_MF8,
  PseudoVAESZ_VS_MF2_MF2,
  PseudoVAESZ_VS_MF2_MF4,
  PseudoVAESZ_VS_MF2_MF8,
  PseudoVANDN_VV_M1,
  PseudoVANDN_VV_M1_MASK,
  PseudoVANDN_VV_M2,
  PseudoVANDN_VV_M2_MASK,
  PseudoVANDN_VV_M4,
  PseudoVANDN_VV_M4_MASK,
  PseudoVANDN_VV_M8,
  PseudoVANDN_VV_M8_MASK,
  PseudoVANDN_VV_MF2,
  PseudoVANDN_VV_MF2_MASK,
  PseudoVANDN_VV_MF4,
  PseudoVANDN_VV_MF4_MASK,
  PseudoVANDN_VV_MF8,
  PseudoVANDN_VV_MF8_MASK,
  PseudoVANDN_VX_M1,
  PseudoVANDN_VX_M1_MASK,
  PseudoVANDN_VX_M2,
  PseudoVANDN_VX_M2_MASK,
  PseudoVANDN_VX_M4,
  PseudoVANDN_VX_M4_MASK,
  PseudoVANDN_VX_M8,
  PseudoVANDN_VX_M8_MASK,
  PseudoVANDN_VX_MF2,
  PseudoVANDN_VX_MF2_MASK,
  PseudoVANDN_VX_MF4,
  PseudoVANDN_VX_MF4_MASK,
  PseudoVANDN_VX_MF8,
  PseudoVANDN_VX_MF8_MASK,
  PseudoVAND_VI_M1,
  PseudoVAND_VI_M1_MASK,
  PseudoVAND_VI_M2,
  PseudoVAND_VI_M2_MASK,
  PseudoVAND_VI_M4,
  PseudoVAND_VI_M4_MASK,
  PseudoVAND_VI_M8,
  PseudoVAND_VI_M8_MASK,
  PseudoVAND_VI_MF2,
  PseudoVAND_VI_MF2_MASK,
  PseudoVAND_VI_MF4,
  PseudoVAND_VI_MF4_MASK,
  PseudoVAND_VI_MF8,
  PseudoVAND_VI_MF8_MASK,
  PseudoVAND_VV_M1,
  PseudoVAND_VV_M1_MASK,
  PseudoVAND_VV_M2,
  PseudoVAND_VV_M2_MASK,
  PseudoVAND_VV_M4,
  PseudoVAND_VV_M4_MASK,
  PseudoVAND_VV_M8,
  PseudoVAND_VV_M8_MASK,
  PseudoVAND_VV_MF2,
  PseudoVAND_VV_MF2_MASK,
  PseudoVAND_VV_MF4,
  PseudoVAND_VV_MF4_MASK,
  PseudoVAND_VV_MF8,
  PseudoVAND_VV_MF8_MASK,
  PseudoVAND_VX_M1,
  PseudoVAND_VX_M1_MASK,
  PseudoVAND_VX_M2,
  PseudoVAND_VX_M2_MASK,
  PseudoVAND_VX_M4,
  PseudoVAND_VX_M4_MASK,
  PseudoVAND_VX_M8,
  PseudoVAND_VX_M8_MASK,
  PseudoVAND_VX_MF2,
  PseudoVAND_VX_MF2_MASK,
  PseudoVAND_VX_MF4,
  PseudoVAND_VX_MF4_MASK,
  PseudoVAND_VX_MF8,
  PseudoVAND_VX_MF8_MASK,
  PseudoVASUBU_VV_M1,
  PseudoVASUBU_VV_M1_MASK,
  PseudoVASUBU_VV_M2,
  PseudoVASUBU_VV_M2_MASK,
  PseudoVASUBU_VV_M4,
  PseudoVASUBU_VV_M4_MASK,
  PseudoVASUBU_VV_M8,
  PseudoVASUBU_VV_M8_MASK,
  PseudoVASUBU_VV_MF2,
  PseudoVASUBU_VV_MF2_MASK,
  PseudoVASUBU_VV_MF4,
  PseudoVASUBU_VV_MF4_MASK,
  PseudoVASUBU_VV_MF8,
  PseudoVASUBU_VV_MF8_MASK,
  PseudoVASUBU_VX_M1,
  PseudoVASUBU_VX_M1_MASK,
  PseudoVASUBU_VX_M2,
  PseudoVASUBU_VX_M2_MASK,
  PseudoVASUBU_VX_M4,
  PseudoVASUBU_VX_M4_MASK,
  PseudoVASUBU_VX_M8,
  PseudoVASUBU_VX_M8_MASK,
  PseudoVASUBU_VX_MF2,
  PseudoVASUBU_VX_MF2_MASK,
  PseudoVASUBU_VX_MF4,
  PseudoVASUBU_VX_MF4_MASK,
  PseudoVASUBU_VX_MF8,
  PseudoVASUBU_VX_MF8_MASK,
  PseudoVASUB_VV_M1,
  PseudoVASUB_VV_M1_MASK,
  PseudoVASUB_VV_M2,
  PseudoVASUB_VV_M2_MASK,
  PseudoVASUB_VV_M4,
  PseudoVASUB_VV_M4_MASK,
  PseudoVASUB_VV_M8,
  PseudoVASUB_VV_M8_MASK,
  PseudoVASUB_VV_MF2,
  PseudoVASUB_VV_MF2_MASK,
  PseudoVASUB_VV_MF4,
  PseudoVASUB_VV_MF4_MASK,
  PseudoVASUB_VV_MF8,
  PseudoVASUB_VV_MF8_MASK,
  PseudoVASUB_VX_M1,
  PseudoVASUB_VX_M1_MASK,
  PseudoVASUB_VX_M2,
  PseudoVASUB_VX_M2_MASK,
  PseudoVASUB_VX_M4,
  PseudoVASUB_VX_M4_MASK,
  PseudoVASUB_VX_M8,
  PseudoVASUB_VX_M8_MASK,
  PseudoVASUB_VX_MF2,
  PseudoVASUB_VX_MF2_MASK,
  PseudoVASUB_VX_MF4,
  PseudoVASUB_VX_MF4_MASK,
  PseudoVASUB_VX_MF8,
  PseudoVASUB_VX_MF8_MASK,
  PseudoVBREV8_V_M1,
  PseudoVBREV8_V_M1_MASK,
  PseudoVBREV8_V_M2,
  PseudoVBREV8_V_M2_MASK,
  PseudoVBREV8_V_M4,
  PseudoVBREV8_V_M4_MASK,
  PseudoVBREV8_V_M8,
  PseudoVBREV8_V_M8_MASK,
  PseudoVBREV8_V_MF2,
  PseudoVBREV8_V_MF2_MASK,
  PseudoVBREV8_V_MF4,
  PseudoVBREV8_V_MF4_MASK,
  PseudoVBREV8_V_MF8,
  PseudoVBREV8_V_MF8_MASK,
  PseudoVBREV_V_M1,
  PseudoVBREV_V_M1_MASK,
  PseudoVBREV_V_M2,
  PseudoVBREV_V_M2_MASK,
  PseudoVBREV_V_M4,
  PseudoVBREV_V_M4_MASK,
  PseudoVBREV_V_M8,
  PseudoVBREV_V_M8_MASK,
  PseudoVBREV_V_MF2,
  PseudoVBREV_V_MF2_MASK,
  PseudoVBREV_V_MF4,
  PseudoVBREV_V_MF4_MASK,
  PseudoVBREV_V_MF8,
  PseudoVBREV_V_MF8_MASK,
  PseudoVCLMULH_VV_M1,
  PseudoVCLMULH_VV_M1_MASK,
  PseudoVCLMULH_VV_M2,
  PseudoVCLMULH_VV_M2_MASK,
  PseudoVCLMULH_VV_M4,
  PseudoVCLMULH_VV_M4_MASK,
  PseudoVCLMULH_VV_M8,
  PseudoVCLMULH_VV_M8_MASK,
  PseudoVCLMULH_VV_MF2,
  PseudoVCLMULH_VV_MF2_MASK,
  PseudoVCLMULH_VV_MF4,
  PseudoVCLMULH_VV_MF4_MASK,
  PseudoVCLMULH_VV_MF8,
  PseudoVCLMULH_VV_MF8_MASK,
  PseudoVCLMULH_VX_M1,
  PseudoVCLMULH_VX_M1_MASK,
  PseudoVCLMULH_VX_M2,
  PseudoVCLMULH_VX_M2_MASK,
  PseudoVCLMULH_VX_M4,
  PseudoVCLMULH_VX_M4_MASK,
  PseudoVCLMULH_VX_M8,
  PseudoVCLMULH_VX_M8_MASK,
  PseudoVCLMULH_VX_MF2,
  PseudoVCLMULH_VX_MF2_MASK,
  PseudoVCLMULH_VX_MF4,
  PseudoVCLMULH_VX_MF4_MASK,
  PseudoVCLMULH_VX_MF8,
  PseudoVCLMULH_VX_MF8_MASK,
  PseudoVCLMUL_VV_M1,
  PseudoVCLMUL_VV_M1_MASK,
  PseudoVCLMUL_VV_M2,
  PseudoVCLMUL_VV_M2_MASK,
  PseudoVCLMUL_VV_M4,
  PseudoVCLMUL_VV_M4_MASK,
  PseudoVCLMUL_VV_M8,
  PseudoVCLMUL_VV_M8_MASK,
  PseudoVCLMUL_VV_MF2,
  PseudoVCLMUL_VV_MF2_MASK,
  PseudoVCLMUL_VV_MF4,
  PseudoVCLMUL_VV_MF4_MASK,
  PseudoVCLMUL_VV_MF8,
  PseudoVCLMUL_VV_MF8_MASK,
  PseudoVCLMUL_VX_M1,
  PseudoVCLMUL_VX_M1_MASK,
  PseudoVCLMUL_VX_M2,
  PseudoVCLMUL_VX_M2_MASK,
  PseudoVCLMUL_VX_M4,
  PseudoVCLMUL_VX_M4_MASK,
  PseudoVCLMUL_VX_M8,
  PseudoVCLMUL_VX_M8_MASK,
  PseudoVCLMUL_VX_MF2,
  PseudoVCLMUL_VX_MF2_MASK,
  PseudoVCLMUL_VX_MF4,
  PseudoVCLMUL_VX_MF4_MASK,
  PseudoVCLMUL_VX_MF8,
  PseudoVCLMUL_VX_MF8_MASK,
  PseudoVCLZ_V_M1,
  PseudoVCLZ_V_M1_MASK,
  PseudoVCLZ_V_M2,
  PseudoVCLZ_V_M2_MASK,
  PseudoVCLZ_V_M4,
  PseudoVCLZ_V_M4_MASK,
  PseudoVCLZ_V_M8,
  PseudoVCLZ_V_M8_MASK,
  PseudoVCLZ_V_MF2,
  PseudoVCLZ_V_MF2_MASK,
  PseudoVCLZ_V_MF4,
  PseudoVCLZ_V_MF4_MASK,
  PseudoVCLZ_V_MF8,
  PseudoVCLZ_V_MF8_MASK,
  PseudoVCOMPRESS_VM_M1_E16,
  PseudoVCOMPRESS_VM_M1_E32,
  PseudoVCOMPRESS_VM_M1_E64,
  PseudoVCOMPRESS_VM_M1_E8,
  PseudoVCOMPRESS_VM_M2_E16,
  PseudoVCOMPRESS_VM_M2_E32,
  PseudoVCOMPRESS_VM_M2_E64,
  PseudoVCOMPRESS_VM_M2_E8,
  PseudoVCOMPRESS_VM_M4_E16,
  PseudoVCOMPRESS_VM_M4_E32,
  PseudoVCOMPRESS_VM_M4_E64,
  PseudoVCOMPRESS_VM_M4_E8,
  PseudoVCOMPRESS_VM_M8_E16,
  PseudoVCOMPRESS_VM_M8_E32,
  PseudoVCOMPRESS_VM_M8_E64,
  PseudoVCOMPRESS_VM_M8_E8,
  PseudoVCOMPRESS_VM_MF2_E16,
  PseudoVCOMPRESS_VM_MF2_E32,
  PseudoVCOMPRESS_VM_MF2_E8,
  PseudoVCOMPRESS_VM_MF4_E16,
  PseudoVCOMPRESS_VM_MF4_E8,
  PseudoVCOMPRESS_VM_MF8_E8,
  PseudoVCPOP_M_B1,
  PseudoVCPOP_M_B16,
  PseudoVCPOP_M_B16_MASK,
  PseudoVCPOP_M_B1_MASK,
  PseudoVCPOP_M_B2,
  PseudoVCPOP_M_B2_MASK,
  PseudoVCPOP_M_B32,
  PseudoVCPOP_M_B32_MASK,
  PseudoVCPOP_M_B4,
  PseudoVCPOP_M_B4_MASK,
  PseudoVCPOP_M_B64,
  PseudoVCPOP_M_B64_MASK,
  PseudoVCPOP_M_B8,
  PseudoVCPOP_M_B8_MASK,
  PseudoVCPOP_V_M1,
  PseudoVCPOP_V_M1_MASK,
  PseudoVCPOP_V_M2,
  PseudoVCPOP_V_M2_MASK,
  PseudoVCPOP_V_M4,
  PseudoVCPOP_V_M4_MASK,
  PseudoVCPOP_V_M8,
  PseudoVCPOP_V_M8_MASK,
  PseudoVCPOP_V_MF2,
  PseudoVCPOP_V_MF2_MASK,
  PseudoVCPOP_V_MF4,
  PseudoVCPOP_V_MF4_MASK,
  PseudoVCPOP_V_MF8,
  PseudoVCPOP_V_MF8_MASK,
  PseudoVCTZ_V_M1,
  PseudoVCTZ_V_M1_MASK,
  PseudoVCTZ_V_M2,
  PseudoVCTZ_V_M2_MASK,
  PseudoVCTZ_V_M4,
  PseudoVCTZ_V_M4_MASK,
  PseudoVCTZ_V_M8,
  PseudoVCTZ_V_M8_MASK,
  PseudoVCTZ_V_MF2,
  PseudoVCTZ_V_MF2_MASK,
  PseudoVCTZ_V_MF4,
  PseudoVCTZ_V_MF4_MASK,
  PseudoVCTZ_V_MF8,
  PseudoVCTZ_V_MF8_MASK,
  PseudoVC_FPR16VV_SE_M1,
  PseudoVC_FPR16VV_SE_M2,
  PseudoVC_FPR16VV_SE_M4,
  PseudoVC_FPR16VV_SE_M8,
  PseudoVC_FPR16VV_SE_MF2,
  PseudoVC_FPR16VV_SE_MF4,
  PseudoVC_FPR16VW_SE_M1,
  PseudoVC_FPR16VW_SE_M2,
  PseudoVC_FPR16VW_SE_M4,
  PseudoVC_FPR16VW_SE_M8,
  PseudoVC_FPR16VW_SE_MF2,
  PseudoVC_FPR16VW_SE_MF4,
  PseudoVC_FPR16V_SE_M1,
  PseudoVC_FPR16V_SE_M2,
  PseudoVC_FPR16V_SE_M4,
  PseudoVC_FPR16V_SE_M8,
  PseudoVC_FPR16V_SE_MF2,
  PseudoVC_FPR16V_SE_MF4,
  PseudoVC_FPR32VV_SE_M1,
  PseudoVC_FPR32VV_SE_M2,
  PseudoVC_FPR32VV_SE_M4,
  PseudoVC_FPR32VV_SE_M8,
  PseudoVC_FPR32VV_SE_MF2,
  PseudoVC_FPR32VW_SE_M1,
  PseudoVC_FPR32VW_SE_M2,
  PseudoVC_FPR32VW_SE_M4,
  PseudoVC_FPR32VW_SE_M8,
  PseudoVC_FPR32VW_SE_MF2,
  PseudoVC_FPR32V_SE_M1,
  PseudoVC_FPR32V_SE_M2,
  PseudoVC_FPR32V_SE_M4,
  PseudoVC_FPR32V_SE_M8,
  PseudoVC_FPR32V_SE_MF2,
  PseudoVC_FPR64VV_SE_M1,
  PseudoVC_FPR64VV_SE_M2,
  PseudoVC_FPR64VV_SE_M4,
  PseudoVC_FPR64VV_SE_M8,
  PseudoVC_FPR64V_SE_M1,
  PseudoVC_FPR64V_SE_M2,
  PseudoVC_FPR64V_SE_M4,
  PseudoVC_FPR64V_SE_M8,
  PseudoVC_IVV_SE_M1,
  PseudoVC_IVV_SE_M2,
  PseudoVC_IVV_SE_M4,
  PseudoVC_IVV_SE_M8,
  PseudoVC_IVV_SE_MF2,
  PseudoVC_IVV_SE_MF4,
  PseudoVC_IVV_SE_MF8,
  PseudoVC_IVW_SE_M1,
  PseudoVC_IVW_SE_M2,
  PseudoVC_IVW_SE_M4,
  PseudoVC_IVW_SE_MF2,
  PseudoVC_IVW_SE_MF4,
  PseudoVC_IVW_SE_MF8,
  PseudoVC_IV_SE_M1,
  PseudoVC_IV_SE_M2,
  PseudoVC_IV_SE_M4,
  PseudoVC_IV_SE_M8,
  PseudoVC_IV_SE_MF2,
  PseudoVC_IV_SE_MF4,
  PseudoVC_IV_SE_MF8,
  PseudoVC_I_SE_M1,
  PseudoVC_I_SE_M2,
  PseudoVC_I_SE_M4,
  PseudoVC_I_SE_M8,
  PseudoVC_I_SE_MF2,
  PseudoVC_I_SE_MF4,
  PseudoVC_I_SE_MF8,
  PseudoVC_VVV_SE_M1,
  PseudoVC_VVV_SE_M2,
  PseudoVC_VVV_SE_M4,
  PseudoVC_VVV_SE_M8,
  PseudoVC_VVV_SE_MF2,
  PseudoVC_VVV_SE_MF4,
  PseudoVC_VVV_SE_MF8,
  PseudoVC_VVW_SE_M1,
  PseudoVC_VVW_SE_M2,
  PseudoVC_VVW_SE_M4,
  PseudoVC_VVW_SE_MF2,
  PseudoVC_VVW_SE_MF4,
  PseudoVC_VVW_SE_MF8,
  PseudoVC_VV_SE_M1,
  PseudoVC_VV_SE_M2,
  PseudoVC_VV_SE_M4,
  PseudoVC_VV_SE_M8,
  PseudoVC_VV_SE_MF2,
  PseudoVC_VV_SE_MF4,
  PseudoVC_VV_SE_MF8,
  PseudoVC_V_FPR16VV_M1,
  PseudoVC_V_FPR16VV_M2,
  PseudoVC_V_FPR16VV_M4,
  PseudoVC_V_FPR16VV_M8,
  PseudoVC_V_FPR16VV_MF2,
  PseudoVC_V_FPR16VV_MF4,
  PseudoVC_V_FPR16VV_SE_M1,
  PseudoVC_V_FPR16VV_SE_M2,
  PseudoVC_V_FPR16VV_SE_M4,
  PseudoVC_V_FPR16VV_SE_M8,
  PseudoVC_V_FPR16VV_SE_MF2,
  PseudoVC_V_FPR16VV_SE_MF4,
  PseudoVC_V_FPR16VW_M1,
  PseudoVC_V_FPR16VW_M2,
  PseudoVC_V_FPR16VW_M4,
  PseudoVC_V_FPR16VW_M8,
  PseudoVC_V_FPR16VW_MF2,
  PseudoVC_V_FPR16VW_MF4,
  PseudoVC_V_FPR16VW_SE_M1,
  PseudoVC_V_FPR16VW_SE_M2,
  PseudoVC_V_FPR16VW_SE_M4,
  PseudoVC_V_FPR16VW_SE_M8,
  PseudoVC_V_FPR16VW_SE_MF2,
  PseudoVC_V_FPR16VW_SE_MF4,
  PseudoVC_V_FPR16V_M1,
  PseudoVC_V_FPR16V_M2,
  PseudoVC_V_FPR16V_M4,
  PseudoVC_V_FPR16V_M8,
  PseudoVC_V_FPR16V_MF2,
  PseudoVC_V_FPR16V_MF4,
  PseudoVC_V_FPR16V_SE_M1,
  PseudoVC_V_FPR16V_SE_M2,
  PseudoVC_V_FPR16V_SE_M4,
  PseudoVC_V_FPR16V_SE_M8,
  PseudoVC_V_FPR16V_SE_MF2,
  PseudoVC_V_FPR16V_SE_MF4,
  PseudoVC_V_FPR32VV_M1,
  PseudoVC_V_FPR32VV_M2,
  PseudoVC_V_FPR32VV_M4,
  PseudoVC_V_FPR32VV_M8,
  PseudoVC_V_FPR32VV_MF2,
  PseudoVC_V_FPR32VV_SE_M1,
  PseudoVC_V_FPR32VV_SE_M2,
  PseudoVC_V_FPR32VV_SE_M4,
  PseudoVC_V_FPR32VV_SE_M8,
  PseudoVC_V_FPR32VV_SE_MF2,
  PseudoVC_V_FPR32VW_M1,
  PseudoVC_V_FPR32VW_M2,
  PseudoVC_V_FPR32VW_M4,
  PseudoVC_V_FPR32VW_M8,
  PseudoVC_V_FPR32VW_MF2,
  PseudoVC_V_FPR32VW_SE_M1,
  PseudoVC_V_FPR32VW_SE_M2,
  PseudoVC_V_FPR32VW_SE_M4,
  PseudoVC_V_FPR32VW_SE_M8,
  PseudoVC_V_FPR32VW_SE_MF2,
  PseudoVC_V_FPR32V_M1,
  PseudoVC_V_FPR32V_M2,
  PseudoVC_V_FPR32V_M4,
  PseudoVC_V_FPR32V_M8,
  PseudoVC_V_FPR32V_MF2,
  PseudoVC_V_FPR32V_SE_M1,
  PseudoVC_V_FPR32V_SE_M2,
  PseudoVC_V_FPR32V_SE_M4,
  PseudoVC_V_FPR32V_SE_M8,
  PseudoVC_V_FPR32V_SE_MF2,
  PseudoVC_V_FPR64VV_M1,
  PseudoVC_V_FPR64VV_M2,
  PseudoVC_V_FPR64VV_M4,
  PseudoVC_V_FPR64VV_M8,
  PseudoVC_V_FPR64VV_SE_M1,
  PseudoVC_V_FPR64VV_SE_M2,
  PseudoVC_V_FPR64VV_SE_M4,
  PseudoVC_V_FPR64VV_SE_M8,
  PseudoVC_V_FPR64V_M1,
  PseudoVC_V_FPR64V_M2,
  PseudoVC_V_FPR64V_M4,
  PseudoVC_V_FPR64V_M8,
  PseudoVC_V_FPR64V_SE_M1,
  PseudoVC_V_FPR64V_SE_M2,
  PseudoVC_V_FPR64V_SE_M4,
  PseudoVC_V_FPR64V_SE_M8,
  PseudoVC_V_IVV_M1,
  PseudoVC_V_IVV_M2,
  PseudoVC_V_IVV_M4,
  PseudoVC_V_IVV_M8,
  PseudoVC_V_IVV_MF2,
  PseudoVC_V_IVV_MF4,
  PseudoVC_V_IVV_MF8,
  PseudoVC_V_IVV_SE_M1,
  PseudoVC_V_IVV_SE_M2,
  PseudoVC_V_IVV_SE_M4,
  PseudoVC_V_IVV_SE_M8,
  PseudoVC_V_IVV_SE_MF2,
  PseudoVC_V_IVV_SE_MF4,
  PseudoVC_V_IVV_SE_MF8,
  PseudoVC_V_IVW_M1,
  PseudoVC_V_IVW_M2,
  PseudoVC_V_IVW_M4,
  PseudoVC_V_IVW_MF2,
  PseudoVC_V_IVW_MF4,
  PseudoVC_V_IVW_MF8,
  PseudoVC_V_IVW_SE_M1,
  PseudoVC_V_IVW_SE_M2,
  PseudoVC_V_IVW_SE_M4,
  PseudoVC_V_IVW_SE_MF2,
  PseudoVC_V_IVW_SE_MF4,
  PseudoVC_V_IVW_SE_MF8,
  PseudoVC_V_IV_M1,
  PseudoVC_V_IV_M2,
  PseudoVC_V_IV_M4,
  PseudoVC_V_IV_M8,
  PseudoVC_V_IV_MF2,
  PseudoVC_V_IV_MF4,
  PseudoVC_V_IV_MF8,
  PseudoVC_V_IV_SE_M1,
  PseudoVC_V_IV_SE_M2,
  PseudoVC_V_IV_SE_M4,
  PseudoVC_V_IV_SE_M8,
  PseudoVC_V_IV_SE_MF2,
  PseudoVC_V_IV_SE_MF4,
  PseudoVC_V_IV_SE_MF8,
  PseudoVC_V_I_M1,
  PseudoVC_V_I_M2,
  PseudoVC_V_I_M4,
  PseudoVC_V_I_M8,
  PseudoVC_V_I_MF2,
  PseudoVC_V_I_MF4,
  PseudoVC_V_I_MF8,
  PseudoVC_V_I_SE_M1,
  PseudoVC_V_I_SE_M2,
  PseudoVC_V_I_SE_M4,
  PseudoVC_V_I_SE_M8,
  PseudoVC_V_I_SE_MF2,
  PseudoVC_V_I_SE_MF4,
  PseudoVC_V_I_SE_MF8,
  PseudoVC_V_VVV_M1,
  PseudoVC_V_VVV_M2,
  PseudoVC_V_VVV_M4,
  PseudoVC_V_VVV_M8,
  PseudoVC_V_VVV_MF2,
  PseudoVC_V_VVV_MF4,
  PseudoVC_V_VVV_MF8,
  PseudoVC_V_VVV_SE_M1,
  PseudoVC_V_VVV_SE_M2,
  PseudoVC_V_VVV_SE_M4,
  PseudoVC_V_VVV_SE_M8,
  PseudoVC_V_VVV_SE_MF2,
  PseudoVC_V_VVV_SE_MF4,
  PseudoVC_V_VVV_SE_MF8,
  PseudoVC_V_VVW_M1,
  PseudoVC_V_VVW_M2,
  PseudoVC_V_VVW_M4,
  PseudoVC_V_VVW_MF2,
  PseudoVC_V_VVW_MF4,
  PseudoVC_V_VVW_MF8,
  PseudoVC_V_VVW_SE_M1,
  PseudoVC_V_VVW_SE_M2,
  PseudoVC_V_VVW_SE_M4,
  PseudoVC_V_VVW_SE_MF2,
  PseudoVC_V_VVW_SE_MF4,
  PseudoVC_V_VVW_SE_MF8,
  PseudoVC_V_VV_M1,
  PseudoVC_V_VV_M2,
  PseudoVC_V_VV_M4,
  PseudoVC_V_VV_M8,
  PseudoVC_V_VV_MF2,
  PseudoVC_V_VV_MF4,
  PseudoVC_V_VV_MF8,
  PseudoVC_V_VV_SE_M1,
  PseudoVC_V_VV_SE_M2,
  PseudoVC_V_VV_SE_M4,
  PseudoVC_V_VV_SE_M8,
  PseudoVC_V_VV_SE_MF2,
  PseudoVC_V_VV_SE_MF4,
  PseudoVC_V_VV_SE_MF8,
  PseudoVC_V_XVV_M1,
  PseudoVC_V_XVV_M2,
  PseudoVC_V_XVV_M4,
  PseudoVC_V_XVV_M8,
  PseudoVC_V_XVV_MF2,
  PseudoVC_V_XVV_MF4,
  PseudoVC_V_XVV_MF8,
  PseudoVC_V_XVV_SE_M1,
  PseudoVC_V_XVV_SE_M2,
  PseudoVC_V_XVV_SE_M4,
  PseudoVC_V_XVV_SE_M8,
  PseudoVC_V_XVV_SE_MF2,
  PseudoVC_V_XVV_SE_MF4,
  PseudoVC_V_XVV_SE_MF8,
  PseudoVC_V_XVW_M1,
  PseudoVC_V_XVW_M2,
  PseudoVC_V_XVW_M4,
  PseudoVC_V_XVW_MF2,
  PseudoVC_V_XVW_MF4,
  PseudoVC_V_XVW_MF8,
  PseudoVC_V_XVW_SE_M1,
  PseudoVC_V_XVW_SE_M2,
  PseudoVC_V_XVW_SE_M4,
  PseudoVC_V_XVW_SE_MF2,
  PseudoVC_V_XVW_SE_MF4,
  PseudoVC_V_XVW_SE_MF8,
  PseudoVC_V_XV_M1,
  PseudoVC_V_XV_M2,
  PseudoVC_V_XV_M4,
  PseudoVC_V_XV_M8,
  PseudoVC_V_XV_MF2,
  PseudoVC_V_XV_MF4,
  PseudoVC_V_XV_MF8,
  PseudoVC_V_XV_SE_M1,
  PseudoVC_V_XV_SE_M2,
  PseudoVC_V_XV_SE_M4,
  PseudoVC_V_XV_SE_M8,
  PseudoVC_V_XV_SE_MF2,
  PseudoVC_V_XV_SE_MF4,
  PseudoVC_V_XV_SE_MF8,
  PseudoVC_V_X_M1,
  PseudoVC_V_X_M2,
  PseudoVC_V_X_M4,
  PseudoVC_V_X_M8,
  PseudoVC_V_X_MF2,
  PseudoVC_V_X_MF4,
  PseudoVC_V_X_MF8,
  PseudoVC_V_X_SE_M1,
  PseudoVC_V_X_SE_M2,
  PseudoVC_V_X_SE_M4,
  PseudoVC_V_X_SE_M8,
  PseudoVC_V_X_SE_MF2,
  PseudoVC_V_X_SE_MF4,
  PseudoVC_V_X_SE_MF8,
  PseudoVC_XVV_SE_M1,
  PseudoVC_XVV_SE_M2,
  PseudoVC_XVV_SE_M4,
  PseudoVC_XVV_SE_M8,
  PseudoVC_XVV_SE_MF2,
  PseudoVC_XVV_SE_MF4,
  PseudoVC_XVV_SE_MF8,
  PseudoVC_XVW_SE_M1,
  PseudoVC_XVW_SE_M2,
  PseudoVC_XVW_SE_M4,
  PseudoVC_XVW_SE_MF2,
  PseudoVC_XVW_SE_MF4,
  PseudoVC_XVW_SE_MF8,
  PseudoVC_XV_SE_M1,
  PseudoVC_XV_SE_M2,
  PseudoVC_XV_SE_M4,
  PseudoVC_XV_SE_M8,
  PseudoVC_XV_SE_MF2,
  PseudoVC_XV_SE_MF4,
  PseudoVC_XV_SE_MF8,
  PseudoVC_X_SE_M1,
  PseudoVC_X_SE_M2,
  PseudoVC_X_SE_M4,
  PseudoVC_X_SE_M8,
  PseudoVC_X_SE_MF2,
  PseudoVC_X_SE_MF4,
  PseudoVC_X_SE_MF8,
  PseudoVDIVU_VV_M1_E16,
  PseudoVDIVU_VV_M1_E16_MASK,
  PseudoVDIVU_VV_M1_E32,
  PseudoVDIVU_VV_M1_E32_MASK,
  PseudoVDIVU_VV_M1_E64,
  PseudoVDIVU_VV_M1_E64_MASK,
  PseudoVDIVU_VV_M1_E8,
  PseudoVDIVU_VV_M1_E8_MASK,
  PseudoVDIVU_VV_M2_E16,
  PseudoVDIVU_VV_M2_E16_MASK,
  PseudoVDIVU_VV_M2_E32,
  PseudoVDIVU_VV_M2_E32_MASK,
  PseudoVDIVU_VV_M2_E64,
  PseudoVDIVU_VV_M2_E64_MASK,
  PseudoVDIVU_VV_M2_E8,
  PseudoVDIVU_VV_M2_E8_MASK,
  PseudoVDIVU_VV_M4_E16,
  PseudoVDIVU_VV_M4_E16_MASK,
  PseudoVDIVU_VV_M4_E32,
  PseudoVDIVU_VV_M4_E32_MASK,
  PseudoVDIVU_VV_M4_E64,
  PseudoVDIVU_VV_M4_E64_MASK,
  PseudoVDIVU_VV_M4_E8,
  PseudoVDIVU_VV_M4_E8_MASK,
  PseudoVDIVU_VV_M8_E16,
  PseudoVDIVU_VV_M8_E16_MASK,
  PseudoVDIVU_VV_M8_E32,
  PseudoVDIVU_VV_M8_E32_MASK,
  PseudoVDIVU_VV_M8_E64,
  PseudoVDIVU_VV_M8_E64_MASK,
  PseudoVDIVU_VV_M8_E8,
  PseudoVDIVU_VV_M8_E8_MASK,
  PseudoVDIVU_VV_MF2_E16,
  PseudoVDIVU_VV_MF2_E16_MASK,
  PseudoVDIVU_VV_MF2_E32,
  PseudoVDIVU_VV_MF2_E32_MASK,
  PseudoVDIVU_VV_MF2_E8,
  PseudoVDIVU_VV_MF2_E8_MASK,
  PseudoVDIVU_VV_MF4_E16,
  PseudoVDIVU_VV_MF4_E16_MASK,
  PseudoVDIVU_VV_MF4_E8,
  PseudoVDIVU_VV_MF4_E8_MASK,
  PseudoVDIVU_VV_MF8_E8,
  PseudoVDIVU_VV_MF8_E8_MASK,
  PseudoVDIVU_VX_M1_E16,
  PseudoVDIVU_VX_M1_E16_MASK,
  PseudoVDIVU_VX_M1_E32,
  PseudoVDIVU_VX_M1_E32_MASK,
  PseudoVDIVU_VX_M1_E64,
  PseudoVDIVU_VX_M1_E64_MASK,
  PseudoVDIVU_VX_M1_E8,
  PseudoVDIVU_VX_M1_E8_MASK,
  PseudoVDIVU_VX_M2_E16,
  PseudoVDIVU_VX_M2_E16_MASK,
  PseudoVDIVU_VX_M2_E32,
  PseudoVDIVU_VX_M2_E32_MASK,
  PseudoVDIVU_VX_M2_E64,
  PseudoVDIVU_VX_M2_E64_MASK,
  PseudoVDIVU_VX_M2_E8,
  PseudoVDIVU_VX_M2_E8_MASK,
  PseudoVDIVU_VX_M4_E16,
  PseudoVDIVU_VX_M4_E16_MASK,
  PseudoVDIVU_VX_M4_E32,
  PseudoVDIVU_VX_M4_E32_MASK,
  PseudoVDIVU_VX_M4_E64,
  PseudoVDIVU_VX_M4_E64_MASK,
  PseudoVDIVU_VX_M4_E8,
  PseudoVDIVU_VX_M4_E8_MASK,
  PseudoVDIVU_VX_M8_E16,
  PseudoVDIVU_VX_M8_E16_MASK,
  PseudoVDIVU_VX_M8_E32,
  PseudoVDIVU_VX_M8_E32_MASK,
  PseudoVDIVU_VX_M8_E64,
  PseudoVDIVU_VX_M8_E64_MASK,
  PseudoVDIVU_VX_M8_E8,
  PseudoVDIVU_VX_M8_E8_MASK,
  PseudoVDIVU_VX_MF2_E16,
  PseudoVDIVU_VX_MF2_E16_MASK,
  PseudoVDIVU_VX_MF2_E32,
  PseudoVDIVU_VX_MF2_E32_MASK,
  PseudoVDIVU_VX_MF2_E8,
  PseudoVDIVU_VX_MF2_E8_MASK,
  PseudoVDIVU_VX_MF4_E16,
  PseudoVDIVU_VX_MF4_E16_MASK,
  PseudoVDIVU_VX_MF4_E8,
  PseudoVDIVU_VX_MF4_E8_MASK,
  PseudoVDIVU_VX_MF8_E8,
  PseudoVDIVU_VX_MF8_E8_MASK,
  PseudoVDIV_VV_M1_E16,
  PseudoVDIV_VV_M1_E16_MASK,
  PseudoVDIV_VV_M1_E32,
  PseudoVDIV_VV_M1_E32_MASK,
  PseudoVDIV_VV_M1_E64,
  PseudoVDIV_VV_M1_E64_MASK,
  PseudoVDIV_VV_M1_E8,
  PseudoVDIV_VV_M1_E8_MASK,
  PseudoVDIV_VV_M2_E16,
  PseudoVDIV_VV_M2_E16_MASK,
  PseudoVDIV_VV_M2_E32,
  PseudoVDIV_VV_M2_E32_MASK,
  PseudoVDIV_VV_M2_E64,
  PseudoVDIV_VV_M2_E64_MASK,
  PseudoVDIV_VV_M2_E8,
  PseudoVDIV_VV_M2_E8_MASK,
  PseudoVDIV_VV_M4_E16,
  PseudoVDIV_VV_M4_E16_MASK,
  PseudoVDIV_VV_M4_E32,
  PseudoVDIV_VV_M4_E32_MASK,
  PseudoVDIV_VV_M4_E64,
  PseudoVDIV_VV_M4_E64_MASK,
  PseudoVDIV_VV_M4_E8,
  PseudoVDIV_VV_M4_E8_MASK,
  PseudoVDIV_VV_M8_E16,
  PseudoVDIV_VV_M8_E16_MASK,
  PseudoVDIV_VV_M8_E32,
  PseudoVDIV_VV_M8_E32_MASK,
  PseudoVDIV_VV_M8_E64,
  PseudoVDIV_VV_M8_E64_MASK,
  PseudoVDIV_VV_M8_E8,
  PseudoVDIV_VV_M8_E8_MASK,
  PseudoVDIV_VV_MF2_E16,
  PseudoVDIV_VV_MF2_E16_MASK,
  PseudoVDIV_VV_MF2_E32,
  PseudoVDIV_VV_MF2_E32_MASK,
  PseudoVDIV_VV_MF2_E8,
  PseudoVDIV_VV_MF2_E8_MASK,
  PseudoVDIV_VV_MF4_E16,
  PseudoVDIV_VV_MF4_E16_MASK,
  PseudoVDIV_VV_MF4_E8,
  PseudoVDIV_VV_MF4_E8_MASK,
  PseudoVDIV_VV_MF8_E8,
  PseudoVDIV_VV_MF8_E8_MASK,
  PseudoVDIV_VX_M1_E16,
  PseudoVDIV_VX_M1_E16_MASK,
  PseudoVDIV_VX_M1_E32,
  PseudoVDIV_VX_M1_E32_MASK,
  PseudoVDIV_VX_M1_E64,
  PseudoVDIV_VX_M1_E64_MASK,
  PseudoVDIV_VX_M1_E8,
  PseudoVDIV_VX_M1_E8_MASK,
  PseudoVDIV_VX_M2_E16,
  PseudoVDIV_VX_M2_E16_MASK,
  PseudoVDIV_VX_M2_E32,
  PseudoVDIV_VX_M2_E32_MASK,
  PseudoVDIV_VX_M2_E64,
  PseudoVDIV_VX_M2_E64_MASK,
  PseudoVDIV_VX_M2_E8,
  PseudoVDIV_VX_M2_E8_MASK,
  PseudoVDIV_VX_M4_E16,
  PseudoVDIV_VX_M4_E16_MASK,
  PseudoVDIV_VX_M4_E32,
  PseudoVDIV_VX_M4_E32_MASK,
  PseudoVDIV_VX_M4_E64,
  PseudoVDIV_VX_M4_E64_MASK,
  PseudoVDIV_VX_M4_E8,
  PseudoVDIV_VX_M4_E8_MASK,
  PseudoVDIV_VX_M8_E16,
  PseudoVDIV_VX_M8_E16_MASK,
  PseudoVDIV_VX_M8_E32,
  PseudoVDIV_VX_M8_E32_MASK,
  PseudoVDIV_VX_M8_E64,
  PseudoVDIV_VX_M8_E64_MASK,
  PseudoVDIV_VX_M8_E8,
  PseudoVDIV_VX_M8_E8_MASK,
  PseudoVDIV_VX_MF2_E16,
  PseudoVDIV_VX_MF2_E16_MASK,
  PseudoVDIV_VX_MF2_E32,
  PseudoVDIV_VX_MF2_E32_MASK,
  PseudoVDIV_VX_MF2_E8,
  PseudoVDIV_VX_MF2_E8_MASK,
  PseudoVDIV_VX_MF4_E16,
  PseudoVDIV_VX_MF4_E16_MASK,
  PseudoVDIV_VX_MF4_E8,
  PseudoVDIV_VX_MF4_E8_MASK,
  PseudoVDIV_VX_MF8_E8,
  PseudoVDIV_VX_MF8_E8_MASK,
  PseudoVFADD_VFPR16_M1_E16,
  PseudoVFADD_VFPR16_M1_E16_MASK,
  PseudoVFADD_VFPR16_M2_E16,
  PseudoVFADD_VFPR16_M2_E16_MASK,
  PseudoVFADD_VFPR16_M4_E16,
  PseudoVFADD_VFPR16_M4_E16_MASK,
  PseudoVFADD_VFPR16_M8_E16,
  PseudoVFADD_VFPR16_M8_E16_MASK,
  PseudoVFADD_VFPR16_MF2_E16,
  PseudoVFADD_VFPR16_MF2_E16_MASK,
  PseudoVFADD_VFPR16_MF4_E16,
  PseudoVFADD_VFPR16_MF4_E16_MASK,
  PseudoVFADD_VFPR32_M1_E32,
  PseudoVFADD_VFPR32_M1_E32_MASK,
  PseudoVFADD_VFPR32_M2_E32,
  PseudoVFADD_VFPR32_M2_E32_MASK,
  PseudoVFADD_VFPR32_M4_E32,
  PseudoVFADD_VFPR32_M4_E32_MASK,
  PseudoVFADD_VFPR32_M8_E32,
  PseudoVFADD_VFPR32_M8_E32_MASK,
  PseudoVFADD_VFPR32_MF2_E32,
  PseudoVFADD_VFPR32_MF2_E32_MASK,
  PseudoVFADD_VFPR64_M1_E64,
  PseudoVFADD_VFPR64_M1_E64_MASK,
  PseudoVFADD_VFPR64_M2_E64,
  PseudoVFADD_VFPR64_M2_E64_MASK,
  PseudoVFADD_VFPR64_M4_E64,
  PseudoVFADD_VFPR64_M4_E64_MASK,
  PseudoVFADD_VFPR64_M8_E64,
  PseudoVFADD_VFPR64_M8_E64_MASK,
  PseudoVFADD_VV_M1_E16,
  PseudoVFADD_VV_M1_E16_MASK,
  PseudoVFADD_VV_M1_E32,
  PseudoVFADD_VV_M1_E32_MASK,
  PseudoVFADD_VV_M1_E64,
  PseudoVFADD_VV_M1_E64_MASK,
  PseudoVFADD_VV_M2_E16,
  PseudoVFADD_VV_M2_E16_MASK,
  PseudoVFADD_VV_M2_E32,
  PseudoVFADD_VV_M2_E32_MASK,
  PseudoVFADD_VV_M2_E64,
  PseudoVFADD_VV_M2_E64_MASK,
  PseudoVFADD_VV_M4_E16,
  PseudoVFADD_VV_M4_E16_MASK,
  PseudoVFADD_VV_M4_E32,
  PseudoVFADD_VV_M4_E32_MASK,
  PseudoVFADD_VV_M4_E64,
  PseudoVFADD_VV_M4_E64_MASK,
  PseudoVFADD_VV_M8_E16,
  PseudoVFADD_VV_M8_E16_MASK,
  PseudoVFADD_VV_M8_E32,
  PseudoVFADD_VV_M8_E32_MASK,
  PseudoVFADD_VV_M8_E64,
  PseudoVFADD_VV_M8_E64_MASK,
  PseudoVFADD_VV_MF2_E16,
  PseudoVFADD_VV_MF2_E16_MASK,
  PseudoVFADD_VV_MF2_E32,
  PseudoVFADD_VV_MF2_E32_MASK,
  PseudoVFADD_VV_MF4_E16,
  PseudoVFADD_VV_MF4_E16_MASK,
  PseudoVFCLASS_V_M1,
  PseudoVFCLASS_V_M1_MASK,
  PseudoVFCLASS_V_M2,
  PseudoVFCLASS_V_M2_MASK,
  PseudoVFCLASS_V_M4,
  PseudoVFCLASS_V_M4_MASK,
  PseudoVFCLASS_V_M8,
  PseudoVFCLASS_V_M8_MASK,
  PseudoVFCLASS_V_MF2,
  PseudoVFCLASS_V_MF2_MASK,
  PseudoVFCLASS_V_MF4,
  PseudoVFCLASS_V_MF4_MASK,
  PseudoVFCVT_F_XU_V_M1_E16,
  PseudoVFCVT_F_XU_V_M1_E16_MASK,
  PseudoVFCVT_F_XU_V_M1_E32,
  PseudoVFCVT_F_XU_V_M1_E32_MASK,
  PseudoVFCVT_F_XU_V_M1_E64,
  PseudoVFCVT_F_XU_V_M1_E64_MASK,
  PseudoVFCVT_F_XU_V_M2_E16,
  PseudoVFCVT_F_XU_V_M2_E16_MASK,
  PseudoVFCVT_F_XU_V_M2_E32,
  PseudoVFCVT_F_XU_V_M2_E32_MASK,
  PseudoVFCVT_F_XU_V_M2_E64,
  PseudoVFCVT_F_XU_V_M2_E64_MASK,
  PseudoVFCVT_F_XU_V_M4_E16,
  PseudoVFCVT_F_XU_V_M4_E16_MASK,
  PseudoVFCVT_F_XU_V_M4_E32,
  PseudoVFCVT_F_XU_V_M4_E32_MASK,
  PseudoVFCVT_F_XU_V_M4_E64,
  PseudoVFCVT_F_XU_V_M4_E64_MASK,
  PseudoVFCVT_F_XU_V_M8_E16,
  PseudoVFCVT_F_XU_V_M8_E16_MASK,
  PseudoVFCVT_F_XU_V_M8_E32,
  PseudoVFCVT_F_XU_V_M8_E32_MASK,
  PseudoVFCVT_F_XU_V_M8_E64,
  PseudoVFCVT_F_XU_V_M8_E64_MASK,
  PseudoVFCVT_F_XU_V_MF2_E16,
  PseudoVFCVT_F_XU_V_MF2_E16_MASK,
  PseudoVFCVT_F_XU_V_MF2_E32,
  PseudoVFCVT_F_XU_V_MF2_E32_MASK,
  PseudoVFCVT_F_XU_V_MF4_E16,
  PseudoVFCVT_F_XU_V_MF4_E16_MASK,
  PseudoVFCVT_F_X_V_M1_E16,
  PseudoVFCVT_F_X_V_M1_E16_MASK,
  PseudoVFCVT_F_X_V_M1_E32,
  PseudoVFCVT_F_X_V_M1_E32_MASK,
  PseudoVFCVT_F_X_V_M1_E64,
  PseudoVFCVT_F_X_V_M1_E64_MASK,
  PseudoVFCVT_F_X_V_M2_E16,
  PseudoVFCVT_F_X_V_M2_E16_MASK,
  PseudoVFCVT_F_X_V_M2_E32,
  PseudoVFCVT_F_X_V_M2_E32_MASK,
  PseudoVFCVT_F_X_V_M2_E64,
  PseudoVFCVT_F_X_V_M2_E64_MASK,
  PseudoVFCVT_F_X_V_M4_E16,
  PseudoVFCVT_F_X_V_M4_E16_MASK,
  PseudoVFCVT_F_X_V_M4_E32,
  PseudoVFCVT_F_X_V_M4_E32_MASK,
  PseudoVFCVT_F_X_V_M4_E64,
  PseudoVFCVT_F_X_V_M4_E64_MASK,
  PseudoVFCVT_F_X_V_M8_E16,
  PseudoVFCVT_F_X_V_M8_E16_MASK,
  PseudoVFCVT_F_X_V_M8_E32,
  PseudoVFCVT_F_X_V_M8_E32_MASK,
  PseudoVFCVT_F_X_V_M8_E64,
  PseudoVFCVT_F_X_V_M8_E64_MASK,
  PseudoVFCVT_F_X_V_MF2_E16,
  PseudoVFCVT_F_X_V_MF2_E16_MASK,
  PseudoVFCVT_F_X_V_MF2_E32,
  PseudoVFCVT_F_X_V_MF2_E32_MASK,
  PseudoVFCVT_F_X_V_MF4_E16,
  PseudoVFCVT_F_X_V_MF4_E16_MASK,
  PseudoVFCVT_RM_F_XU_V_M1_E16,
  PseudoVFCVT_RM_F_XU_V_M1_E16_MASK,
  PseudoVFCVT_RM_F_XU_V_M1_E32,
  PseudoVFCVT_RM_F_XU_V_M1_E32_MASK,
  PseudoVFCVT_RM_F_XU_V_M1_E64,
  PseudoVFCVT_RM_F_XU_V_M1_E64_MASK,
  PseudoVFCVT_RM_F_XU_V_M2_E16,
  PseudoVFCVT_RM_F_XU_V_M2_E16_MASK,
  PseudoVFCVT_RM_F_XU_V_M2_E32,
  PseudoVFCVT_RM_F_XU_V_M2_E32_MASK,
  PseudoVFCVT_RM_F_XU_V_M2_E64,
  PseudoVFCVT_RM_F_XU_V_M2_E64_MASK,
  PseudoVFCVT_RM_F_XU_V_M4_E16,
  PseudoVFCVT_RM_F_XU_V_M4_E16_MASK,
  PseudoVFCVT_RM_F_XU_V_M4_E32,
  PseudoVFCVT_RM_F_XU_V_M4_E32_MASK,
  PseudoVFCVT_RM_F_XU_V_M4_E64,
  PseudoVFCVT_RM_F_XU_V_M4_E64_MASK,
  PseudoVFCVT_RM_F_XU_V_M8_E16,
  PseudoVFCVT_RM_F_XU_V_M8_E16_MASK,
  PseudoVFCVT_RM_F_XU_V_M8_E32,
  PseudoVFCVT_RM_F_XU_V_M8_E32_MASK,
  PseudoVFCVT_RM_F_XU_V_M8_E64,
  PseudoVFCVT_RM_F_XU_V_M8_E64_MASK,
  PseudoVFCVT_RM_F_XU_V_MF2_E16,
  PseudoVFCVT_RM_F_XU_V_MF2_E16_MASK,
  PseudoVFCVT_RM_F_XU_V_MF2_E32,
  PseudoVFCVT_RM_F_XU_V_MF2_E32_MASK,
  PseudoVFCVT_RM_F_XU_V_MF4_E16,
  PseudoVFCVT_RM_F_XU_V_MF4_E16_MASK,
  PseudoVFCVT_RM_F_X_V_M1_E16,
  PseudoVFCVT_RM_F_X_V_M1_E16_MASK,
  PseudoVFCVT_RM_F_X_V_M1_E32,
  PseudoVFCVT_RM_F_X_V_M1_E32_MASK,
  PseudoVFCVT_RM_F_X_V_M1_E64,
  PseudoVFCVT_RM_F_X_V_M1_E64_MASK,
  PseudoVFCVT_RM_F_X_V_M2_E16,
  PseudoVFCVT_RM_F_X_V_M2_E16_MASK,
  PseudoVFCVT_RM_F_X_V_M2_E32,
  PseudoVFCVT_RM_F_X_V_M2_E32_MASK,
  PseudoVFCVT_RM_F_X_V_M2_E64,
  PseudoVFCVT_RM_F_X_V_M2_E64_MASK,
  PseudoVFCVT_RM_F_X_V_M4_E16,
  PseudoVFCVT_RM_F_X_V_M4_E16_MASK,
  PseudoVFCVT_RM_F_X_V_M4_E32,
  PseudoVFCVT_RM_F_X_V_M4_E32_MASK,
  PseudoVFCVT_RM_F_X_V_M4_E64,
  PseudoVFCVT_RM_F_X_V_M4_E64_MASK,
  PseudoVFCVT_RM_F_X_V_M8_E16,
  PseudoVFCVT_RM_F_X_V_M8_E16_MASK,
  PseudoVFCVT_RM_F_X_V_M8_E32,
  PseudoVFCVT_RM_F_X_V_M8_E32_MASK,
  PseudoVFCVT_RM_F_X_V_M8_E64,
  PseudoVFCVT_RM_F_X_V_M8_E64_MASK,
  PseudoVFCVT_RM_F_X_V_MF2_E16,
  PseudoVFCVT_RM_F_X_V_MF2_E16_MASK,
  PseudoVFCVT_RM_F_X_V_MF2_E32,
  PseudoVFCVT_RM_F_X_V_MF2_E32_MASK,
  PseudoVFCVT_RM_F_X_V_MF4_E16,
  PseudoVFCVT_RM_F_X_V_MF4_E16_MASK,
  PseudoVFCVT_RM_XU_F_V_M1,
  PseudoVFCVT_RM_XU_F_V_M1_MASK,
  PseudoVFCVT_RM_XU_F_V_M2,
  PseudoVFCVT_RM_XU_F_V_M2_MASK,
  PseudoVFCVT_RM_XU_F_V_M4,
  PseudoVFCVT_RM_XU_F_V_M4_MASK,
  PseudoVFCVT_RM_XU_F_V_M8,
  PseudoVFCVT_RM_XU_F_V_M8_MASK,
  PseudoVFCVT_RM_XU_F_V_MF2,
  PseudoVFCVT_RM_XU_F_V_MF2_MASK,
  PseudoVFCVT_RM_XU_F_V_MF4,
  PseudoVFCVT_RM_XU_F_V_MF4_MASK,
  PseudoVFCVT_RM_X_F_V_M1,
  PseudoVFCVT_RM_X_F_V_M1_MASK,
  PseudoVFCVT_RM_X_F_V_M2,
  PseudoVFCVT_RM_X_F_V_M2_MASK,
  PseudoVFCVT_RM_X_F_V_M4,
  PseudoVFCVT_RM_X_F_V_M4_MASK,
  PseudoVFCVT_RM_X_F_V_M8,
  PseudoVFCVT_RM_X_F_V_M8_MASK,
  PseudoVFCVT_RM_X_F_V_MF2,
  PseudoVFCVT_RM_X_F_V_MF2_MASK,
  PseudoVFCVT_RM_X_F_V_MF4,
  PseudoVFCVT_RM_X_F_V_MF4_MASK,
  PseudoVFCVT_RTZ_XU_F_V_M1,
  PseudoVFCVT_RTZ_XU_F_V_M1_MASK,
  PseudoVFCVT_RTZ_XU_F_V_M2,
  PseudoVFCVT_RTZ_XU_F_V_M2_MASK,
  PseudoVFCVT_RTZ_XU_F_V_M4,
  PseudoVFCVT_RTZ_XU_F_V_M4_MASK,
  PseudoVFCVT_RTZ_XU_F_V_M8,
  PseudoVFCVT_RTZ_XU_F_V_M8_MASK,
  PseudoVFCVT_RTZ_XU_F_V_MF2,
  PseudoVFCVT_RTZ_XU_F_V_MF2_MASK,
  PseudoVFCVT_RTZ_XU_F_V_MF4,
  PseudoVFCVT_RTZ_XU_F_V_MF4_MASK,
  PseudoVFCVT_RTZ_X_F_V_M1,
  PseudoVFCVT_RTZ_X_F_V_M1_MASK,
  PseudoVFCVT_RTZ_X_F_V_M2,
  PseudoVFCVT_RTZ_X_F_V_M2_MASK,
  PseudoVFCVT_RTZ_X_F_V_M4,
  PseudoVFCVT_RTZ_X_F_V_M4_MASK,
  PseudoVFCVT_RTZ_X_F_V_M8,
  PseudoVFCVT_RTZ_X_F_V_M8_MASK,
  PseudoVFCVT_RTZ_X_F_V_MF2,
  PseudoVFCVT_RTZ_X_F_V_MF2_MASK,
  PseudoVFCVT_RTZ_X_F_V_MF4,
  PseudoVFCVT_RTZ_X_F_V_MF4_MASK,
  PseudoVFCVT_XU_F_V_M1,
  PseudoVFCVT_XU_F_V_M1_MASK,
  PseudoVFCVT_XU_F_V_M2,
  PseudoVFCVT_XU_F_V_M2_MASK,
  PseudoVFCVT_XU_F_V_M4,
  PseudoVFCVT_XU_F_V_M4_MASK,
  PseudoVFCVT_XU_F_V_M8,
  PseudoVFCVT_XU_F_V_M8_MASK,
  PseudoVFCVT_XU_F_V_MF2,
  PseudoVFCVT_XU_F_V_MF2_MASK,
  PseudoVFCVT_XU_F_V_MF4,
  PseudoVFCVT_XU_F_V_MF4_MASK,
  PseudoVFCVT_X_F_V_M1,
  PseudoVFCVT_X_F_V_M1_MASK,
  PseudoVFCVT_X_F_V_M2,
  PseudoVFCVT_X_F_V_M2_MASK,
  PseudoVFCVT_X_F_V_M4,
  PseudoVFCVT_X_F_V_M4_MASK,
  PseudoVFCVT_X_F_V_M8,
  PseudoVFCVT_X_F_V_M8_MASK,
  PseudoVFCVT_X_F_V_MF2,
  PseudoVFCVT_X_F_V_MF2_MASK,
  PseudoVFCVT_X_F_V_MF4,
  PseudoVFCVT_X_F_V_MF4_MASK,
  PseudoVFDIV_VFPR16_M1_E16,
  PseudoVFDIV_VFPR16_M1_E16_MASK,
  PseudoVFDIV_VFPR16_M2_E16,
  PseudoVFDIV_VFPR16_M2_E16_MASK,
  PseudoVFDIV_VFPR16_M4_E16,
  PseudoVFDIV_VFPR16_M4_E16_MASK,
  PseudoVFDIV_VFPR16_M8_E16,
  PseudoVFDIV_VFPR16_M8_E16_MASK,
  PseudoVFDIV_VFPR16_MF2_E16,
  PseudoVFDIV_VFPR16_MF2_E16_MASK,
  PseudoVFDIV_VFPR16_MF4_E16,
  PseudoVFDIV_VFPR16_MF4_E16_MASK,
  PseudoVFDIV_VFPR32_M1_E32,
  PseudoVFDIV_VFPR32_M1_E32_MASK,
  PseudoVFDIV_VFPR32_M2_E32,
  PseudoVFDIV_VFPR32_M2_E32_MASK,
  PseudoVFDIV_VFPR32_M4_E32,
  PseudoVFDIV_VFPR32_M4_E32_MASK,
  PseudoVFDIV_VFPR32_M8_E32,
  PseudoVFDIV_VFPR32_M8_E32_MASK,
  PseudoVFDIV_VFPR32_MF2_E32,
  PseudoVFDIV_VFPR32_MF2_E32_MASK,
  PseudoVFDIV_VFPR64_M1_E64,
  PseudoVFDIV_VFPR64_M1_E64_MASK,
  PseudoVFDIV_VFPR64_M2_E64,
  PseudoVFDIV_VFPR64_M2_E64_MASK,
  PseudoVFDIV_VFPR64_M4_E64,
  PseudoVFDIV_VFPR64_M4_E64_MASK,
  PseudoVFDIV_VFPR64_M8_E64,
  PseudoVFDIV_VFPR64_M8_E64_MASK,
  PseudoVFDIV_VV_M1_E16,
  PseudoVFDIV_VV_M1_E16_MASK,
  PseudoVFDIV_VV_M1_E32,
  PseudoVFDIV_VV_M1_E32_MASK,
  PseudoVFDIV_VV_M1_E64,
  PseudoVFDIV_VV_M1_E64_MASK,
  PseudoVFDIV_VV_M2_E16,
  PseudoVFDIV_VV_M2_E16_MASK,
  PseudoVFDIV_VV_M2_E32,
  PseudoVFDIV_VV_M2_E32_MASK,
  PseudoVFDIV_VV_M2_E64,
  PseudoVFDIV_VV_M2_E64_MASK,
  PseudoVFDIV_VV_M4_E16,
  PseudoVFDIV_VV_M4_E16_MASK,
  PseudoVFDIV_VV_M4_E32,
  PseudoVFDIV_VV_M4_E32_MASK,
  PseudoVFDIV_VV_M4_E64,
  PseudoVFDIV_VV_M4_E64_MASK,
  PseudoVFDIV_VV_M8_E16,
  PseudoVFDIV_VV_M8_E16_MASK,
  PseudoVFDIV_VV_M8_E32,
  PseudoVFDIV_VV_M8_E32_MASK,
  PseudoVFDIV_VV_M8_E64,
  PseudoVFDIV_VV_M8_E64_MASK,
  PseudoVFDIV_VV_MF2_E16,
  PseudoVFDIV_VV_MF2_E16_MASK,
  PseudoVFDIV_VV_MF2_E32,
  PseudoVFDIV_VV_MF2_E32_MASK,
  PseudoVFDIV_VV_MF4_E16,
  PseudoVFDIV_VV_MF4_E16_MASK,
  PseudoVFIRST_M_B1,
  PseudoVFIRST_M_B16,
  PseudoVFIRST_M_B16_MASK,
  PseudoVFIRST_M_B1_MASK,
  PseudoVFIRST_M_B2,
  PseudoVFIRST_M_B2_MASK,
  PseudoVFIRST_M_B32,
  PseudoVFIRST_M_B32_MASK,
  PseudoVFIRST_M_B4,
  PseudoVFIRST_M_B4_MASK,
  PseudoVFIRST_M_B64,
  PseudoVFIRST_M_B64_MASK,
  PseudoVFIRST_M_B8,
  PseudoVFIRST_M_B8_MASK,
  PseudoVFMACC_VFPR16_M1_E16,
  PseudoVFMACC_VFPR16_M1_E16_MASK,
  PseudoVFMACC_VFPR16_M2_E16,
  PseudoVFMACC_VFPR16_M2_E16_MASK,
  PseudoVFMACC_VFPR16_M4_E16,
  PseudoVFMACC_VFPR16_M4_E16_MASK,
  PseudoVFMACC_VFPR16_M8_E16,
  PseudoVFMACC_VFPR16_M8_E16_MASK,
  PseudoVFMACC_VFPR16_MF2_E16,
  PseudoVFMACC_VFPR16_MF2_E16_MASK,
  PseudoVFMACC_VFPR16_MF4_E16,
  PseudoVFMACC_VFPR16_MF4_E16_MASK,
  PseudoVFMACC_VFPR32_M1_E32,
  PseudoVFMACC_VFPR32_M1_E32_MASK,
  PseudoVFMACC_VFPR32_M2_E32,
  PseudoVFMACC_VFPR32_M2_E32_MASK,
  PseudoVFMACC_VFPR32_M4_E32,
  PseudoVFMACC_VFPR32_M4_E32_MASK,
  PseudoVFMACC_VFPR32_M8_E32,
  PseudoVFMACC_VFPR32_M8_E32_MASK,
  PseudoVFMACC_VFPR32_MF2_E32,
  PseudoVFMACC_VFPR32_MF2_E32_MASK,
  PseudoVFMACC_VFPR64_M1_E64,
  PseudoVFMACC_VFPR64_M1_E64_MASK,
  PseudoVFMACC_VFPR64_M2_E64,
  PseudoVFMACC_VFPR64_M2_E64_MASK,
  PseudoVFMACC_VFPR64_M4_E64,
  PseudoVFMACC_VFPR64_M4_E64_MASK,
  PseudoVFMACC_VFPR64_M8_E64,
  PseudoVFMACC_VFPR64_M8_E64_MASK,
  PseudoVFMACC_VV_M1_E16,
  PseudoVFMACC_VV_M1_E16_MASK,
  PseudoVFMACC_VV_M1_E32,
  PseudoVFMACC_VV_M1_E32_MASK,
  PseudoVFMACC_VV_M1_E64,
  PseudoVFMACC_VV_M1_E64_MASK,
  PseudoVFMACC_VV_M2_E16,
  PseudoVFMACC_VV_M2_E16_MASK,
  PseudoVFMACC_VV_M2_E32,
  PseudoVFMACC_VV_M2_E32_MASK,
  PseudoVFMACC_VV_M2_E64,
  PseudoVFMACC_VV_M2_E64_MASK,
  PseudoVFMACC_VV_M4_E16,
  PseudoVFMACC_VV_M4_E16_MASK,
  PseudoVFMACC_VV_M4_E32,
  PseudoVFMACC_VV_M4_E32_MASK,
  PseudoVFMACC_VV_M4_E64,
  PseudoVFMACC_VV_M4_E64_MASK,
  PseudoVFMACC_VV_M8_E16,
  PseudoVFMACC_VV_M8_E16_MASK,
  PseudoVFMACC_VV_M8_E32,
  PseudoVFMACC_VV_M8_E32_MASK,
  PseudoVFMACC_VV_M8_E64,
  PseudoVFMACC_VV_M8_E64_MASK,
  PseudoVFMACC_VV_MF2_E16,
  PseudoVFMACC_VV_MF2_E16_MASK,
  PseudoVFMACC_VV_MF2_E32,
  PseudoVFMACC_VV_MF2_E32_MASK,
  PseudoVFMACC_VV_MF4_E16,
  PseudoVFMACC_VV_MF4_E16_MASK,
  PseudoVFMADD_VFPR16_M1_E16,
  PseudoVFMADD_VFPR16_M1_E16_MASK,
  PseudoVFMADD_VFPR16_M2_E16,
  PseudoVFMADD_VFPR16_M2_E16_MASK,
  PseudoVFMADD_VFPR16_M4_E16,
  PseudoVFMADD_VFPR16_M4_E16_MASK,
  PseudoVFMADD_VFPR16_M8_E16,
  PseudoVFMADD_VFPR16_M8_E16_MASK,
  PseudoVFMADD_VFPR16_MF2_E16,
  PseudoVFMADD_VFPR16_MF2_E16_MASK,
  PseudoVFMADD_VFPR16_MF4_E16,
  PseudoVFMADD_VFPR16_MF4_E16_MASK,
  PseudoVFMADD_VFPR32_M1_E32,
  PseudoVFMADD_VFPR32_M1_E32_MASK,
  PseudoVFMADD_VFPR32_M2_E32,
  PseudoVFMADD_VFPR32_M2_E32_MASK,
  PseudoVFMADD_VFPR32_M4_E32,
  PseudoVFMADD_VFPR32_M4_E32_MASK,
  PseudoVFMADD_VFPR32_M8_E32,
  PseudoVFMADD_VFPR32_M8_E32_MASK,
  PseudoVFMADD_VFPR32_MF2_E32,
  PseudoVFMADD_VFPR32_MF2_E32_MASK,
  PseudoVFMADD_VFPR64_M1_E64,
  PseudoVFMADD_VFPR64_M1_E64_MASK,
  PseudoVFMADD_VFPR64_M2_E64,
  PseudoVFMADD_VFPR64_M2_E64_MASK,
  PseudoVFMADD_VFPR64_M4_E64,
  PseudoVFMADD_VFPR64_M4_E64_MASK,
  PseudoVFMADD_VFPR64_M8_E64,
  PseudoVFMADD_VFPR64_M8_E64_MASK,
  PseudoVFMADD_VV_M1_E16,
  PseudoVFMADD_VV_M1_E16_MASK,
  PseudoVFMADD_VV_M1_E32,
  PseudoVFMADD_VV_M1_E32_MASK,
  PseudoVFMADD_VV_M1_E64,
  PseudoVFMADD_VV_M1_E64_MASK,
  PseudoVFMADD_VV_M2_E16,
  PseudoVFMADD_VV_M2_E16_MASK,
  PseudoVFMADD_VV_M2_E32,
  PseudoVFMADD_VV_M2_E32_MASK,
  PseudoVFMADD_VV_M2_E64,
  PseudoVFMADD_VV_M2_E64_MASK,
  PseudoVFMADD_VV_M4_E16,
  PseudoVFMADD_VV_M4_E16_MASK,
  PseudoVFMADD_VV_M4_E32,
  PseudoVFMADD_VV_M4_E32_MASK,
  PseudoVFMADD_VV_M4_E64,
  PseudoVFMADD_VV_M4_E64_MASK,
  PseudoVFMADD_VV_M8_E16,
  PseudoVFMADD_VV_M8_E16_MASK,
  PseudoVFMADD_VV_M8_E32,
  PseudoVFMADD_VV_M8_E32_MASK,
  PseudoVFMADD_VV_M8_E64,
  PseudoVFMADD_VV_M8_E64_MASK,
  PseudoVFMADD_VV_MF2_E16,
  PseudoVFMADD_VV_MF2_E16_MASK,
  PseudoVFMADD_VV_MF2_E32,
  PseudoVFMADD_VV_MF2_E32_MASK,
  PseudoVFMADD_VV_MF4_E16,
  PseudoVFMADD_VV_MF4_E16_MASK,
  PseudoVFMAX_VFPR16_M1_E16,
  PseudoVFMAX_VFPR16_M1_E16_MASK,
  PseudoVFMAX_VFPR16_M2_E16,
  PseudoVFMAX_VFPR16_M2_E16_MASK,
  PseudoVFMAX_VFPR16_M4_E16,
  PseudoVFMAX_VFPR16_M4_E16_MASK,
  PseudoVFMAX_VFPR16_M8_E16,
  PseudoVFMAX_VFPR16_M8_E16_MASK,
  PseudoVFMAX_VFPR16_MF2_E16,
  PseudoVFMAX_VFPR16_MF2_E16_MASK,
  PseudoVFMAX_VFPR16_MF4_E16,
  PseudoVFMAX_VFPR16_MF4_E16_MASK,
  PseudoVFMAX_VFPR32_M1_E32,
  PseudoVFMAX_VFPR32_M1_E32_MASK,
  PseudoVFMAX_VFPR32_M2_E32,
  PseudoVFMAX_VFPR32_M2_E32_MASK,
  PseudoVFMAX_VFPR32_M4_E32,
  PseudoVFMAX_VFPR32_M4_E32_MASK,
  PseudoVFMAX_VFPR32_M8_E32,
  PseudoVFMAX_VFPR32_M8_E32_MASK,
  PseudoVFMAX_VFPR32_MF2_E32,
  PseudoVFMAX_VFPR32_MF2_E32_MASK,
  PseudoVFMAX_VFPR64_M1_E64,
  PseudoVFMAX_VFPR64_M1_E64_MASK,
  PseudoVFMAX_VFPR64_M2_E64,
  PseudoVFMAX_VFPR64_M2_E64_MASK,
  PseudoVFMAX_VFPR64_M4_E64,
  PseudoVFMAX_VFPR64_M4_E64_MASK,
  PseudoVFMAX_VFPR64_M8_E64,
  PseudoVFMAX_VFPR64_M8_E64_MASK,
  PseudoVFMAX_VV_M1_E16,
  PseudoVFMAX_VV_M1_E16_MASK,
  PseudoVFMAX_VV_M1_E32,
  PseudoVFMAX_VV_M1_E32_MASK,
  PseudoVFMAX_VV_M1_E64,
  PseudoVFMAX_VV_M1_E64_MASK,
  PseudoVFMAX_VV_M2_E16,
  PseudoVFMAX_VV_M2_E16_MASK,
  PseudoVFMAX_VV_M2_E32,
  PseudoVFMAX_VV_M2_E32_MASK,
  PseudoVFMAX_VV_M2_E64,
  PseudoVFMAX_VV_M2_E64_MASK,
  PseudoVFMAX_VV_M4_E16,
  PseudoVFMAX_VV_M4_E16_MASK,
  PseudoVFMAX_VV_M4_E32,
  PseudoVFMAX_VV_M4_E32_MASK,
  PseudoVFMAX_VV_M4_E64,
  PseudoVFMAX_VV_M4_E64_MASK,
  PseudoVFMAX_VV_M8_E16,
  PseudoVFMAX_VV_M8_E16_MASK,
  PseudoVFMAX_VV_M8_E32,
  PseudoVFMAX_VV_M8_E32_MASK,
  PseudoVFMAX_VV_M8_E64,
  PseudoVFMAX_VV_M8_E64_MASK,
  PseudoVFMAX_VV_MF2_E16,
  PseudoVFMAX_VV_MF2_E16_MASK,
  PseudoVFMAX_VV_MF2_E32,
  PseudoVFMAX_VV_MF2_E32_MASK,
  PseudoVFMAX_VV_MF4_E16,
  PseudoVFMAX_VV_MF4_E16_MASK,
  PseudoVFMERGE_VFPR16M_M1,
  PseudoVFMERGE_VFPR16M_M2,
  PseudoVFMERGE_VFPR16M_M4,
  PseudoVFMERGE_VFPR16M_M8,
  PseudoVFMERGE_VFPR16M_MF2,
  PseudoVFMERGE_VFPR16M_MF4,
  PseudoVFMERGE_VFPR32M_M1,
  PseudoVFMERGE_VFPR32M_M2,
  PseudoVFMERGE_VFPR32M_M4,
  PseudoVFMERGE_VFPR32M_M8,
  PseudoVFMERGE_VFPR32M_MF2,
  PseudoVFMERGE_VFPR64M_M1,
  PseudoVFMERGE_VFPR64M_M2,
  PseudoVFMERGE_VFPR64M_M4,
  PseudoVFMERGE_VFPR64M_M8,
  PseudoVFMIN_VFPR16_M1_E16,
  PseudoVFMIN_VFPR16_M1_E16_MASK,
  PseudoVFMIN_VFPR16_M2_E16,
  PseudoVFMIN_VFPR16_M2_E16_MASK,
  PseudoVFMIN_VFPR16_M4_E16,
  PseudoVFMIN_VFPR16_M4_E16_MASK,
  PseudoVFMIN_VFPR16_M8_E16,
  PseudoVFMIN_VFPR16_M8_E16_MASK,
  PseudoVFMIN_VFPR16_MF2_E16,
  PseudoVFMIN_VFPR16_MF2_E16_MASK,
  PseudoVFMIN_VFPR16_MF4_E16,
  PseudoVFMIN_VFPR16_MF4_E16_MASK,
  PseudoVFMIN_VFPR32_M1_E32,
  PseudoVFMIN_VFPR32_M1_E32_MASK,
  PseudoVFMIN_VFPR32_M2_E32,
  PseudoVFMIN_VFPR32_M2_E32_MASK,
  PseudoVFMIN_VFPR32_M4_E32,
  PseudoVFMIN_VFPR32_M4_E32_MASK,
  PseudoVFMIN_VFPR32_M8_E32,
  PseudoVFMIN_VFPR32_M8_E32_MASK,
  PseudoVFMIN_VFPR32_MF2_E32,
  PseudoVFMIN_VFPR32_MF2_E32_MASK,
  PseudoVFMIN_VFPR64_M1_E64,
  PseudoVFMIN_VFPR64_M1_E64_MASK,
  PseudoVFMIN_VFPR64_M2_E64,
  PseudoVFMIN_VFPR64_M2_E64_MASK,
  PseudoVFMIN_VFPR64_M4_E64,
  PseudoVFMIN_VFPR64_M4_E64_MASK,
  PseudoVFMIN_VFPR64_M8_E64,
  PseudoVFMIN_VFPR64_M8_E64_MASK,
  PseudoVFMIN_VV_M1_E16,
  PseudoVFMIN_VV_M1_E16_MASK,
  PseudoVFMIN_VV_M1_E32,
  PseudoVFMIN_VV_M1_E32_MASK,
  PseudoVFMIN_VV_M1_E64,
  PseudoVFMIN_VV_M1_E64_MASK,
  PseudoVFMIN_VV_M2_E16,
  PseudoVFMIN_VV_M2_E16_MASK,
  PseudoVFMIN_VV_M2_E32,
  PseudoVFMIN_VV_M2_E32_MASK,
  PseudoVFMIN_VV_M2_E64,
  PseudoVFMIN_VV_M2_E64_MASK,
  PseudoVFMIN_VV_M4_E16,
  PseudoVFMIN_VV_M4_E16_MASK,
  PseudoVFMIN_VV_M4_E32,
  PseudoVFMIN_VV_M4_E32_MASK,
  PseudoVFMIN_VV_M4_E64,
  PseudoVFMIN_VV_M4_E64_MASK,
  PseudoVFMIN_VV_M8_E16,
  PseudoVFMIN_VV_M8_E16_MASK,
  PseudoVFMIN_VV_M8_E32,
  PseudoVFMIN_VV_M8_E32_MASK,
  PseudoVFMIN_VV_M8_E64,
  PseudoVFMIN_VV_M8_E64_MASK,
  PseudoVFMIN_VV_MF2_E16,
  PseudoVFMIN_VV_MF2_E16_MASK,
  PseudoVFMIN_VV_MF2_E32,
  PseudoVFMIN_VV_MF2_E32_MASK,
  PseudoVFMIN_VV_MF4_E16,
  PseudoVFMIN_VV_MF4_E16_MASK,
  PseudoVFMSAC_VFPR16_M1_E16,
  PseudoVFMSAC_VFPR16_M1_E16_MASK,
  PseudoVFMSAC_VFPR16_M2_E16,
  PseudoVFMSAC_VFPR16_M2_E16_MASK,
  PseudoVFMSAC_VFPR16_M4_E16,
  PseudoVFMSAC_VFPR16_M4_E16_MASK,
  PseudoVFMSAC_VFPR16_M8_E16,
  PseudoVFMSAC_VFPR16_M8_E16_MASK,
  PseudoVFMSAC_VFPR16_MF2_E16,
  PseudoVFMSAC_VFPR16_MF2_E16_MASK,
  PseudoVFMSAC_VFPR16_MF4_E16,
  PseudoVFMSAC_VFPR16_MF4_E16_MASK,
  PseudoVFMSAC_VFPR32_M1_E32,
  PseudoVFMSAC_VFPR32_M1_E32_MASK,
  PseudoVFMSAC_VFPR32_M2_E32,
  PseudoVFMSAC_VFPR32_M2_E32_MASK,
  PseudoVFMSAC_VFPR32_M4_E32,
  PseudoVFMSAC_VFPR32_M4_E32_MASK,
  PseudoVFMSAC_VFPR32_M8_E32,
  PseudoVFMSAC_VFPR32_M8_E32_MASK,
  PseudoVFMSAC_VFPR32_MF2_E32,
  PseudoVFMSAC_VFPR32_MF2_E32_MASK,
  PseudoVFMSAC_VFPR64_M1_E64,
  PseudoVFMSAC_VFPR64_M1_E64_MASK,
  PseudoVFMSAC_VFPR64_M2_E64,
  PseudoVFMSAC_VFPR64_M2_E64_MASK,
  PseudoVFMSAC_VFPR64_M4_E64,
  PseudoVFMSAC_VFPR64_M4_E64_MASK,
  PseudoVFMSAC_VFPR64_M8_E64,
  PseudoVFMSAC_VFPR64_M8_E64_MASK,
  PseudoVFMSAC_VV_M1_E16,
  PseudoVFMSAC_VV_M1_E16_MASK,
  PseudoVFMSAC_VV_M1_E32,
  PseudoVFMSAC_VV_M1_E32_MASK,
  PseudoVFMSAC_VV_M1_E64,
  PseudoVFMSAC_VV_M1_E64_MASK,
  PseudoVFMSAC_VV_M2_E16,
  PseudoVFMSAC_VV_M2_E16_MASK,
  PseudoVFMSAC_VV_M2_E32,
  PseudoVFMSAC_VV_M2_E32_MASK,
  PseudoVFMSAC_VV_M2_E64,
  PseudoVFMSAC_VV_M2_E64_MASK,
  PseudoVFMSAC_VV_M4_E16,
  PseudoVFMSAC_VV_M4_E16_MASK,
  PseudoVFMSAC_VV_M4_E32,
  PseudoVFMSAC_VV_M4_E32_MASK,
  PseudoVFMSAC_VV_M4_E64,
  PseudoVFMSAC_VV_M4_E64_MASK,
  PseudoVFMSAC_VV_M8_E16,
  PseudoVFMSAC_VV_M8_E16_MASK,
  PseudoVFMSAC_VV_M8_E32,
  PseudoVFMSAC_VV_M8_E32_MASK,
  PseudoVFMSAC_VV_M8_E64,
  PseudoVFMSAC_VV_M8_E64_MASK,
  PseudoVFMSAC_VV_MF2_E16,
  PseudoVFMSAC_VV_MF2_E16_MASK,
  PseudoVFMSAC_VV_MF2_E32,
  PseudoVFMSAC_VV_MF2_E32_MASK,
  PseudoVFMSAC_VV_MF4_E16,
  PseudoVFMSAC_VV_MF4_E16_MASK,
  PseudoVFMSUB_VFPR16_M1_E16,
  PseudoVFMSUB_VFPR16_M1_E16_MASK,
  PseudoVFMSUB_VFPR16_M2_E16,
  PseudoVFMSUB_VFPR16_M2_E16_MASK,
  PseudoVFMSUB_VFPR16_M4_E16,
  PseudoVFMSUB_VFPR16_M4_E16_MASK,
  PseudoVFMSUB_VFPR16_M8_E16,
  PseudoVFMSUB_VFPR16_M8_E16_MASK,
  PseudoVFMSUB_VFPR16_MF2_E16,
  PseudoVFMSUB_VFPR16_MF2_E16_MASK,
  PseudoVFMSUB_VFPR16_MF4_E16,
  PseudoVFMSUB_VFPR16_MF4_E16_MASK,
  PseudoVFMSUB_VFPR32_M1_E32,
  PseudoVFMSUB_VFPR32_M1_E32_MASK,
  PseudoVFMSUB_VFPR32_M2_E32,
  PseudoVFMSUB_VFPR32_M2_E32_MASK,
  PseudoVFMSUB_VFPR32_M4_E32,
  PseudoVFMSUB_VFPR32_M4_E32_MASK,
  PseudoVFMSUB_VFPR32_M8_E32,
  PseudoVFMSUB_VFPR32_M8_E32_MASK,
  PseudoVFMSUB_VFPR32_MF2_E32,
  PseudoVFMSUB_VFPR32_MF2_E32_MASK,
  PseudoVFMSUB_VFPR64_M1_E64,
  PseudoVFMSUB_VFPR64_M1_E64_MASK,
  PseudoVFMSUB_VFPR64_M2_E64,
  PseudoVFMSUB_VFPR64_M2_E64_MASK,
  PseudoVFMSUB_VFPR64_M4_E64,
  PseudoVFMSUB_VFPR64_M4_E64_MASK,
  PseudoVFMSUB_VFPR64_M8_E64,
  PseudoVFMSUB_VFPR64_M8_E64_MASK,
  PseudoVFMSUB_VV_M1_E16,
  PseudoVFMSUB_VV_M1_E16_MASK,
  PseudoVFMSUB_VV_M1_E32,
  PseudoVFMSUB_VV_M1_E32_MASK,
  PseudoVFMSUB_VV_M1_E64,
  PseudoVFMSUB_VV_M1_E64_MASK,
  PseudoVFMSUB_VV_M2_E16,
  PseudoVFMSUB_VV_M2_E16_MASK,
  PseudoVFMSUB_VV_M2_E32,
  PseudoVFMSUB_VV_M2_E32_MASK,
  PseudoVFMSUB_VV_M2_E64,
  PseudoVFMSUB_VV_M2_E64_MASK,
  PseudoVFMSUB_VV_M4_E16,
  PseudoVFMSUB_VV_M4_E16_MASK,
  PseudoVFMSUB_VV_M4_E32,
  PseudoVFMSUB_VV_M4_E32_MASK,
  PseudoVFMSUB_VV_M4_E64,
  PseudoVFMSUB_VV_M4_E64_MASK,
  PseudoVFMSUB_VV_M8_E16,
  PseudoVFMSUB_VV_M8_E16_MASK,
  PseudoVFMSUB_VV_M8_E32,
  PseudoVFMSUB_VV_M8_E32_MASK,
  PseudoVFMSUB_VV_M8_E64,
  PseudoVFMSUB_VV_M8_E64_MASK,
  PseudoVFMSUB_VV_MF2_E16,
  PseudoVFMSUB_VV_MF2_E16_MASK,
  PseudoVFMSUB_VV_MF2_E32,
  PseudoVFMSUB_VV_MF2_E32_MASK,
  PseudoVFMSUB_VV_MF4_E16,
  PseudoVFMSUB_VV_MF4_E16_MASK,
  PseudoVFMUL_VFPR16_M1_E16,
  PseudoVFMUL_VFPR16_M1_E16_MASK,
  PseudoVFMUL_VFPR16_M2_E16,
  PseudoVFMUL_VFPR16_M2_E16_MASK,
  PseudoVFMUL_VFPR16_M4_E16,
  PseudoVFMUL_VFPR16_M4_E16_MASK,
  PseudoVFMUL_VFPR16_M8_E16,
  PseudoVFMUL_VFPR16_M8_E16_MASK,
  PseudoVFMUL_VFPR16_MF2_E16,
  PseudoVFMUL_VFPR16_MF2_E16_MASK,
  PseudoVFMUL_VFPR16_MF4_E16,
  PseudoVFMUL_VFPR16_MF4_E16_MASK,
  PseudoVFMUL_VFPR32_M1_E32,
  PseudoVFMUL_VFPR32_M1_E32_MASK,
  PseudoVFMUL_VFPR32_M2_E32,
  PseudoVFMUL_VFPR32_M2_E32_MASK,
  PseudoVFMUL_VFPR32_M4_E32,
  PseudoVFMUL_VFPR32_M4_E32_MASK,
  PseudoVFMUL_VFPR32_M8_E32,
  PseudoVFMUL_VFPR32_M8_E32_MASK,
  PseudoVFMUL_VFPR32_MF2_E32,
  PseudoVFMUL_VFPR32_MF2_E32_MASK,
  PseudoVFMUL_VFPR64_M1_E64,
  PseudoVFMUL_VFPR64_M1_E64_MASK,
  PseudoVFMUL_VFPR64_M2_E64,
  PseudoVFMUL_VFPR64_M2_E64_MASK,
  PseudoVFMUL_VFPR64_M4_E64,
  PseudoVFMUL_VFPR64_M4_E64_MASK,
  PseudoVFMUL_VFPR64_M8_E64,
  PseudoVFMUL_VFPR64_M8_E64_MASK,
  PseudoVFMUL_VV_M1_E16,
  PseudoVFMUL_VV_M1_E16_MASK,
  PseudoVFMUL_VV_M1_E32,
  PseudoVFMUL_VV_M1_E32_MASK,
  PseudoVFMUL_VV_M1_E64,
  PseudoVFMUL_VV_M1_E64_MASK,
  PseudoVFMUL_VV_M2_E16,
  PseudoVFMUL_VV_M2_E16_MASK,
  PseudoVFMUL_VV_M2_E32,
  PseudoVFMUL_VV_M2_E32_MASK,
  PseudoVFMUL_VV_M2_E64,
  PseudoVFMUL_VV_M2_E64_MASK,
  PseudoVFMUL_VV_M4_E16,
  PseudoVFMUL_VV_M4_E16_MASK,
  PseudoVFMUL_VV_M4_E32,
  PseudoVFMUL_VV_M4_E32_MASK,
  PseudoVFMUL_VV_M4_E64,
  PseudoVFMUL_VV_M4_E64_MASK,
  PseudoVFMUL_VV_M8_E16,
  PseudoVFMUL_VV_M8_E16_MASK,
  PseudoVFMUL_VV_M8_E32,
  PseudoVFMUL_VV_M8_E32_MASK,
  PseudoVFMUL_VV_M8_E64,
  PseudoVFMUL_VV_M8_E64_MASK,
  PseudoVFMUL_VV_MF2_E16,
  PseudoVFMUL_VV_MF2_E16_MASK,
  PseudoVFMUL_VV_MF2_E32,
  PseudoVFMUL_VV_MF2_E32_MASK,
  PseudoVFMUL_VV_MF4_E16,
  PseudoVFMUL_VV_MF4_E16_MASK,
  PseudoVFMV_FPR16_S_M1,
  PseudoVFMV_FPR16_S_M2,
  PseudoVFMV_FPR16_S_M4,
  PseudoVFMV_FPR16_S_M8,
  PseudoVFMV_FPR16_S_MF2,
  PseudoVFMV_FPR16_S_MF4,
  PseudoVFMV_FPR32_S_M1,
  PseudoVFMV_FPR32_S_M2,
  PseudoVFMV_FPR32_S_M4,
  PseudoVFMV_FPR32_S_M8,
  PseudoVFMV_FPR32_S_MF2,
  PseudoVFMV_FPR64_S_M1,
  PseudoVFMV_FPR64_S_M2,
  PseudoVFMV_FPR64_S_M4,
  PseudoVFMV_FPR64_S_M8,
  PseudoVFMV_S_FPR16_M1,
  PseudoVFMV_S_FPR16_M2,
  PseudoVFMV_S_FPR16_M4,
  PseudoVFMV_S_FPR16_M8,
  PseudoVFMV_S_FPR16_MF2,
  PseudoVFMV_S_FPR16_MF4,
  PseudoVFMV_S_FPR32_M1,
  PseudoVFMV_S_FPR32_M2,
  PseudoVFMV_S_FPR32_M4,
  PseudoVFMV_S_FPR32_M8,
  PseudoVFMV_S_FPR32_MF2,
  PseudoVFMV_S_FPR64_M1,
  PseudoVFMV_S_FPR64_M2,
  PseudoVFMV_S_FPR64_M4,
  PseudoVFMV_S_FPR64_M8,
  PseudoVFMV_V_FPR16_M1,
  PseudoVFMV_V_FPR16_M2,
  PseudoVFMV_V_FPR16_M4,
  PseudoVFMV_V_FPR16_M8,
  PseudoVFMV_V_FPR16_MF2,
  PseudoVFMV_V_FPR16_MF4,
  PseudoVFMV_V_FPR32_M1,
  PseudoVFMV_V_FPR32_M2,
  PseudoVFMV_V_FPR32_M4,
  PseudoVFMV_V_FPR32_M8,
  PseudoVFMV_V_FPR32_MF2,
  PseudoVFMV_V_FPR64_M1,
  PseudoVFMV_V_FPR64_M2,
  PseudoVFMV_V_FPR64_M4,
  PseudoVFMV_V_FPR64_M8,
  PseudoVFNCVTBF16_F_F_W_M1_E16,
  PseudoVFNCVTBF16_F_F_W_M1_E16_MASK,
  PseudoVFNCVTBF16_F_F_W_M1_E32,
  PseudoVFNCVTBF16_F_F_W_M1_E32_MASK,
  PseudoVFNCVTBF16_F_F_W_M2_E16,
  PseudoVFNCVTBF16_F_F_W_M2_E16_MASK,
  PseudoVFNCVTBF16_F_F_W_M2_E32,
  PseudoVFNCVTBF16_F_F_W_M2_E32_MASK,
  PseudoVFNCVTBF16_F_F_W_M4_E16,
  PseudoVFNCVTBF16_F_F_W_M4_E16_MASK,
  PseudoVFNCVTBF16_F_F_W_M4_E32,
  PseudoVFNCVTBF16_F_F_W_M4_E32_MASK,
  PseudoVFNCVTBF16_F_F_W_MF2_E16,
  PseudoVFNCVTBF16_F_F_W_MF2_E16_MASK,
  PseudoVFNCVTBF16_F_F_W_MF2_E32,
  PseudoVFNCVTBF16_F_F_W_MF2_E32_MASK,
  PseudoVFNCVTBF16_F_F_W_MF4_E16,
  PseudoVFNCVTBF16_F_F_W_MF4_E16_MASK,
  PseudoVFNCVT_F_F_W_M1_E16,
  PseudoVFNCVT_F_F_W_M1_E16_MASK,
  PseudoVFNCVT_F_F_W_M1_E32,
  PseudoVFNCVT_F_F_W_M1_E32_MASK,
  PseudoVFNCVT_F_F_W_M2_E16,
  PseudoVFNCVT_F_F_W_M2_E16_MASK,
  PseudoVFNCVT_F_F_W_M2_E32,
  PseudoVFNCVT_F_F_W_M2_E32_MASK,
  PseudoVFNCVT_F_F_W_M4_E16,
  PseudoVFNCVT_F_F_W_M4_E16_MASK,
  PseudoVFNCVT_F_F_W_M4_E32,
  PseudoVFNCVT_F_F_W_M4_E32_MASK,
  PseudoVFNCVT_F_F_W_MF2_E16,
  PseudoVFNCVT_F_F_W_MF2_E16_MASK,
  PseudoVFNCVT_F_F_W_MF2_E32,
  PseudoVFNCVT_F_F_W_MF2_E32_MASK,
  PseudoVFNCVT_F_F_W_MF4_E16,
  PseudoVFNCVT_F_F_W_MF4_E16_MASK,
  PseudoVFNCVT_F_XU_W_M1_E16,
  PseudoVFNCVT_F_XU_W_M1_E16_MASK,
  PseudoVFNCVT_F_XU_W_M1_E32,
  PseudoVFNCVT_F_XU_W_M1_E32_MASK,
  PseudoVFNCVT_F_XU_W_M2_E16,
  PseudoVFNCVT_F_XU_W_M2_E16_MASK,
  PseudoVFNCVT_F_XU_W_M2_E32,
  PseudoVFNCVT_F_XU_W_M2_E32_MASK,
  PseudoVFNCVT_F_XU_W_M4_E16,
  PseudoVFNCVT_F_XU_W_M4_E16_MASK,
  PseudoVFNCVT_F_XU_W_M4_E32,
  PseudoVFNCVT_F_XU_W_M4_E32_MASK,
  PseudoVFNCVT_F_XU_W_MF2_E16,
  PseudoVFNCVT_F_XU_W_MF2_E16_MASK,
  PseudoVFNCVT_F_XU_W_MF2_E32,
  PseudoVFNCVT_F_XU_W_MF2_E32_MASK,
  PseudoVFNCVT_F_XU_W_MF4_E16,
  PseudoVFNCVT_F_XU_W_MF4_E16_MASK,
  PseudoVFNCVT_F_X_W_M1_E16,
  PseudoVFNCVT_F_X_W_M1_E16_MASK,
  PseudoVFNCVT_F_X_W_M1_E32,
  PseudoVFNCVT_F_X_W_M1_E32_MASK,
  PseudoVFNCVT_F_X_W_M2_E16,
  PseudoVFNCVT_F_X_W_M2_E16_MASK,
  PseudoVFNCVT_F_X_W_M2_E32,
  PseudoVFNCVT_F_X_W_M2_E32_MASK,
  PseudoVFNCVT_F_X_W_M4_E16,
  PseudoVFNCVT_F_X_W_M4_E16_MASK,
  PseudoVFNCVT_F_X_W_M4_E32,
  PseudoVFNCVT_F_X_W_M4_E32_MASK,
  PseudoVFNCVT_F_X_W_MF2_E16,
  PseudoVFNCVT_F_X_W_MF2_E16_MASK,
  PseudoVFNCVT_F_X_W_MF2_E32,
  PseudoVFNCVT_F_X_W_MF2_E32_MASK,
  PseudoVFNCVT_F_X_W_MF4_E16,
  PseudoVFNCVT_F_X_W_MF4_E16_MASK,
  PseudoVFNCVT_RM_F_XU_W_M1_E16,
  PseudoVFNCVT_RM_F_XU_W_M1_E16_MASK,
  PseudoVFNCVT_RM_F_XU_W_M1_E32,
  PseudoVFNCVT_RM_F_XU_W_M1_E32_MASK,
  PseudoVFNCVT_RM_F_XU_W_M2_E16,
  PseudoVFNCVT_RM_F_XU_W_M2_E16_MASK,
  PseudoVFNCVT_RM_F_XU_W_M2_E32,
  PseudoVFNCVT_RM_F_XU_W_M2_E32_MASK,
  PseudoVFNCVT_RM_F_XU_W_M4_E16,
  PseudoVFNCVT_RM_F_XU_W_M4_E16_MASK,
  PseudoVFNCVT_RM_F_XU_W_M4_E32,
  PseudoVFNCVT_RM_F_XU_W_M4_E32_MASK,
  PseudoVFNCVT_RM_F_XU_W_MF2_E16,
  PseudoVFNCVT_RM_F_XU_W_MF2_E16_MASK,
  PseudoVFNCVT_RM_F_XU_W_MF2_E32,
  PseudoVFNCVT_RM_F_XU_W_MF2_E32_MASK,
  PseudoVFNCVT_RM_F_XU_W_MF4_E16,
  PseudoVFNCVT_RM_F_XU_W_MF4_E16_MASK,
  PseudoVFNCVT_RM_F_X_W_M1_E16,
  PseudoVFNCVT_RM_F_X_W_M1_E16_MASK,
  PseudoVFNCVT_RM_F_X_W_M1_E32,
  PseudoVFNCVT_RM_F_X_W_M1_E32_MASK,
  PseudoVFNCVT_RM_F_X_W_M2_E16,
  PseudoVFNCVT_RM_F_X_W_M2_E16_MASK,
  PseudoVFNCVT_RM_F_X_W_M2_E32,
  PseudoVFNCVT_RM_F_X_W_M2_E32_MASK,
  PseudoVFNCVT_RM_F_X_W_M4_E16,
  PseudoVFNCVT_RM_F_X_W_M4_E16_MASK,
  PseudoVFNCVT_RM_F_X_W_M4_E32,
  PseudoVFNCVT_RM_F_X_W_M4_E32_MASK,
  PseudoVFNCVT_RM_F_X_W_MF2_E16,
  PseudoVFNCVT_RM_F_X_W_MF2_E16_MASK,
  PseudoVFNCVT_RM_F_X_W_MF2_E32,
  PseudoVFNCVT_RM_F_X_W_MF2_E32_MASK,
  PseudoVFNCVT_RM_F_X_W_MF4_E16,
  PseudoVFNCVT_RM_F_X_W_MF4_E16_MASK,
  PseudoVFNCVT_RM_XU_F_W_M1,
  PseudoVFNCVT_RM_XU_F_W_M1_MASK,
  PseudoVFNCVT_RM_XU_F_W_M2,
  PseudoVFNCVT_RM_XU_F_W_M2_MASK,
  PseudoVFNCVT_RM_XU_F_W_M4,
  PseudoVFNCVT_RM_XU_F_W_M4_MASK,
  PseudoVFNCVT_RM_XU_F_W_MF2,
  PseudoVFNCVT_RM_XU_F_W_MF2_MASK,
  PseudoVFNCVT_RM_XU_F_W_MF4,
  PseudoVFNCVT_RM_XU_F_W_MF4_MASK,
  PseudoVFNCVT_RM_XU_F_W_MF8,
  PseudoVFNCVT_RM_XU_F_W_MF8_MASK,
  PseudoVFNCVT_RM_X_F_W_M1,
  PseudoVFNCVT_RM_X_F_W_M1_MASK,
  PseudoVFNCVT_RM_X_F_W_M2,
  PseudoVFNCVT_RM_X_F_W_M2_MASK,
  PseudoVFNCVT_RM_X_F_W_M4,
  PseudoVFNCVT_RM_X_F_W_M4_MASK,
  PseudoVFNCVT_RM_X_F_W_MF2,
  PseudoVFNCVT_RM_X_F_W_MF2_MASK,
  PseudoVFNCVT_RM_X_F_W_MF4,
  PseudoVFNCVT_RM_X_F_W_MF4_MASK,
  PseudoVFNCVT_RM_X_F_W_MF8,
  PseudoVFNCVT_RM_X_F_W_MF8_MASK,
  PseudoVFNCVT_ROD_F_F_W_M1_E16,
  PseudoVFNCVT_ROD_F_F_W_M1_E16_MASK,
  PseudoVFNCVT_ROD_F_F_W_M1_E32,
  PseudoVFNCVT_ROD_F_F_W_M1_E32_MASK,
  PseudoVFNCVT_ROD_F_F_W_M2_E16,
  PseudoVFNCVT_ROD_F_F_W_M2_E16_MASK,
  PseudoVFNCVT_ROD_F_F_W_M2_E32,
  PseudoVFNCVT_ROD_F_F_W_M2_E32_MASK,
  PseudoVFNCVT_ROD_F_F_W_M4_E16,
  PseudoVFNCVT_ROD_F_F_W_M4_E16_MASK,
  PseudoVFNCVT_ROD_F_F_W_M4_E32,
  PseudoVFNCVT_ROD_F_F_W_M4_E32_MASK,
  PseudoVFNCVT_ROD_F_F_W_MF2_E16,
  PseudoVFNCVT_ROD_F_F_W_MF2_E16_MASK,
  PseudoVFNCVT_ROD_F_F_W_MF2_E32,
  PseudoVFNCVT_ROD_F_F_W_MF2_E32_MASK,
  PseudoVFNCVT_ROD_F_F_W_MF4_E16,
  PseudoVFNCVT_ROD_F_F_W_MF4_E16_MASK,
  PseudoVFNCVT_RTZ_XU_F_W_M1,
  PseudoVFNCVT_RTZ_XU_F_W_M1_MASK,
  PseudoVFNCVT_RTZ_XU_F_W_M2,
  PseudoVFNCVT_RTZ_XU_F_W_M2_MASK,
  PseudoVFNCVT_RTZ_XU_F_W_M4,
  PseudoVFNCVT_RTZ_XU_F_W_M4_MASK,
  PseudoVFNCVT_RTZ_XU_F_W_MF2,
  PseudoVFNCVT_RTZ_XU_F_W_MF2_MASK,
  PseudoVFNCVT_RTZ_XU_F_W_MF4,
  PseudoVFNCVT_RTZ_XU_F_W_MF4_MASK,
  PseudoVFNCVT_RTZ_XU_F_W_MF8,
  PseudoVFNCVT_RTZ_XU_F_W_MF8_MASK,
  PseudoVFNCVT_RTZ_X_F_W_M1,
  PseudoVFNCVT_RTZ_X_F_W_M1_MASK,
  PseudoVFNCVT_RTZ_X_F_W_M2,
  PseudoVFNCVT_RTZ_X_F_W_M2_MASK,
  PseudoVFNCVT_RTZ_X_F_W_M4,
  PseudoVFNCVT_RTZ_X_F_W_M4_MASK,
  PseudoVFNCVT_RTZ_X_F_W_MF2,
  PseudoVFNCVT_RTZ_X_F_W_MF2_MASK,
  PseudoVFNCVT_RTZ_X_F_W_MF4,
  PseudoVFNCVT_RTZ_X_F_W_MF4_MASK,
  PseudoVFNCVT_RTZ_X_F_W_MF8,
  PseudoVFNCVT_RTZ_X_F_W_MF8_MASK,
  PseudoVFNCVT_XU_F_W_M1,
  PseudoVFNCVT_XU_F_W_M1_MASK,
  PseudoVFNCVT_XU_F_W_M2,
  PseudoVFNCVT_XU_F_W_M2_MASK,
  PseudoVFNCVT_XU_F_W_M4,
  PseudoVFNCVT_XU_F_W_M4_MASK,
  PseudoVFNCVT_XU_F_W_MF2,
  PseudoVFNCVT_XU_F_W_MF2_MASK,
  PseudoVFNCVT_XU_F_W_MF4,
  PseudoVFNCVT_XU_F_W_MF4_MASK,
  PseudoVFNCVT_XU_F_W_MF8,
  PseudoVFNCVT_XU_F_W_MF8_MASK,
  PseudoVFNCVT_X_F_W_M1,
  PseudoVFNCVT_X_F_W_M1_MASK,
  PseudoVFNCVT_X_F_W_M2,
  PseudoVFNCVT_X_F_W_M2_MASK,
  PseudoVFNCVT_X_F_W_M4,
  PseudoVFNCVT_X_F_W_M4_MASK,
  PseudoVFNCVT_X_F_W_MF2,
  PseudoVFNCVT_X_F_W_MF2_MASK,
  PseudoVFNCVT_X_F_W_MF4,
  PseudoVFNCVT_X_F_W_MF4_MASK,
  PseudoVFNCVT_X_F_W_MF8,
  PseudoVFNCVT_X_F_W_MF8_MASK,
  PseudoVFNMACC_VFPR16_M1_E16,
  PseudoVFNMACC_VFPR16_M1_E16_MASK,
  PseudoVFNMACC_VFPR16_M2_E16,
  PseudoVFNMACC_VFPR16_M2_E16_MASK,
  PseudoVFNMACC_VFPR16_M4_E16,
  PseudoVFNMACC_VFPR16_M4_E16_MASK,
  PseudoVFNMACC_VFPR16_M8_E16,
  PseudoVFNMACC_VFPR16_M8_E16_MASK,
  PseudoVFNMACC_VFPR16_MF2_E16,
  PseudoVFNMACC_VFPR16_MF2_E16_MASK,
  PseudoVFNMACC_VFPR16_MF4_E16,
  PseudoVFNMACC_VFPR16_MF4_E16_MASK,
  PseudoVFNMACC_VFPR32_M1_E32,
  PseudoVFNMACC_VFPR32_M1_E32_MASK,
  PseudoVFNMACC_VFPR32_M2_E32,
  PseudoVFNMACC_VFPR32_M2_E32_MASK,
  PseudoVFNMACC_VFPR32_M4_E32,
  PseudoVFNMACC_VFPR32_M4_E32_MASK,
  PseudoVFNMACC_VFPR32_M8_E32,
  PseudoVFNMACC_VFPR32_M8_E32_MASK,
  PseudoVFNMACC_VFPR32_MF2_E32,
  PseudoVFNMACC_VFPR32_MF2_E32_MASK,
  PseudoVFNMACC_VFPR64_M1_E64,
  PseudoVFNMACC_VFPR64_M1_E64_MASK,
  PseudoVFNMACC_VFPR64_M2_E64,
  PseudoVFNMACC_VFPR64_M2_E64_MASK,
  PseudoVFNMACC_VFPR64_M4_E64,
  PseudoVFNMACC_VFPR64_M4_E64_MASK,
  PseudoVFNMACC_VFPR64_M8_E64,
  PseudoVFNMACC_VFPR64_M8_E64_MASK,
  PseudoVFNMACC_VV_M1_E16,
  PseudoVFNMACC_VV_M1_E16_MASK,
  PseudoVFNMACC_VV_M1_E32,
  PseudoVFNMACC_VV_M1_E32_MASK,
  PseudoVFNMACC_VV_M1_E64,
  PseudoVFNMACC_VV_M1_E64_MASK,
  PseudoVFNMACC_VV_M2_E16,
  PseudoVFNMACC_VV_M2_E16_MASK,
  PseudoVFNMACC_VV_M2_E32,
  PseudoVFNMACC_VV_M2_E32_MASK,
  PseudoVFNMACC_VV_M2_E64,
  PseudoVFNMACC_VV_M2_E64_MASK,
  PseudoVFNMACC_VV_M4_E16,
  PseudoVFNMACC_VV_M4_E16_MASK,
  PseudoVFNMACC_VV_M4_E32,
  PseudoVFNMACC_VV_M4_E32_MASK,
  PseudoVFNMACC_VV_M4_E64,
  PseudoVFNMACC_VV_M4_E64_MASK,
  PseudoVFNMACC_VV_M8_E16,
  PseudoVFNMACC_VV_M8_E16_MASK,
  PseudoVFNMACC_VV_M8_E32,
  PseudoVFNMACC_VV_M8_E32_MASK,
  PseudoVFNMACC_VV_M8_E64,
  PseudoVFNMACC_VV_M8_E64_MASK,
  PseudoVFNMACC_VV_MF2_E16,
  PseudoVFNMACC_VV_MF2_E16_MASK,
  PseudoVFNMACC_VV_MF2_E32,
  PseudoVFNMACC_VV_MF2_E32_MASK,
  PseudoVFNMACC_VV_MF4_E16,
  PseudoVFNMACC_VV_MF4_E16_MASK,
  PseudoVFNMADD_VFPR16_M1_E16,
  PseudoVFNMADD_VFPR16_M1_E16_MASK,
  PseudoVFNMADD_VFPR16_M2_E16,
  PseudoVFNMADD_VFPR16_M2_E16_MASK,
  PseudoVFNMADD_VFPR16_M4_E16,
  PseudoVFNMADD_VFPR16_M4_E16_MASK,
  PseudoVFNMADD_VFPR16_M8_E16,
  PseudoVFNMADD_VFPR16_M8_E16_MASK,
  PseudoVFNMADD_VFPR16_MF2_E16,
  PseudoVFNMADD_VFPR16_MF2_E16_MASK,
  PseudoVFNMADD_VFPR16_MF4_E16,
  PseudoVFNMADD_VFPR16_MF4_E16_MASK,
  PseudoVFNMADD_VFPR32_M1_E32,
  PseudoVFNMADD_VFPR32_M1_E32_MASK,
  PseudoVFNMADD_VFPR32_M2_E32,
  PseudoVFNMADD_VFPR32_M2_E32_MASK,
  PseudoVFNMADD_VFPR32_M4_E32,
  PseudoVFNMADD_VFPR32_M4_E32_MASK,
  PseudoVFNMADD_VFPR32_M8_E32,
  PseudoVFNMADD_VFPR32_M8_E32_MASK,
  PseudoVFNMADD_VFPR32_MF2_E32,
  PseudoVFNMADD_VFPR32_MF2_E32_MASK,
  PseudoVFNMADD_VFPR64_M1_E64,
  PseudoVFNMADD_VFPR64_M1_E64_MASK,
  PseudoVFNMADD_VFPR64_M2_E64,
  PseudoVFNMADD_VFPR64_M2_E64_MASK,
  PseudoVFNMADD_VFPR64_M4_E64,
  PseudoVFNMADD_VFPR64_M4_E64_MASK,
  PseudoVFNMADD_VFPR64_M8_E64,
  PseudoVFNMADD_VFPR64_M8_E64_MASK,
  PseudoVFNMADD_VV_M1_E16,
  PseudoVFNMADD_VV_M1_E16_MASK,
  PseudoVFNMADD_VV_M1_E32,
  PseudoVFNMADD_VV_M1_E32_MASK,
  PseudoVFNMADD_VV_M1_E64,
  PseudoVFNMADD_VV_M1_E64_MASK,
  PseudoVFNMADD_VV_M2_E16,
  PseudoVFNMADD_VV_M2_E16_MASK,
  PseudoVFNMADD_VV_M2_E32,
  PseudoVFNMADD_VV_M2_E32_MASK,
  PseudoVFNMADD_VV_M2_E64,
  PseudoVFNMADD_VV_M2_E64_MASK,
  PseudoVFNMADD_VV_M4_E16,
  PseudoVFNMADD_VV_M4_E16_MASK,
  PseudoVFNMADD_VV_M4_E32,
  PseudoVFNMADD_VV_M4_E32_MASK,
  PseudoVFNMADD_VV_M4_E64,
  PseudoVFNMADD_VV_M4_E64_MASK,
  PseudoVFNMADD_VV_M8_E16,
  PseudoVFNMADD_VV_M8_E16_MASK,
  PseudoVFNMADD_VV_M8_E32,
  PseudoVFNMADD_VV_M8_E32_MASK,
  PseudoVFNMADD_VV_M8_E64,
  PseudoVFNMADD_VV_M8_E64_MASK,
  PseudoVFNMADD_VV_MF2_E16,
  PseudoVFNMADD_VV_MF2_E16_MASK,
  PseudoVFNMADD_VV_MF2_E32,
  PseudoVFNMADD_VV_MF2_E32_MASK,
  PseudoVFNMADD_VV_MF4_E16,
  PseudoVFNMADD_VV_MF4_E16_MASK,
  PseudoVFNMSAC_VFPR16_M1_E16,
  PseudoVFNMSAC_VFPR16_M1_E16_MASK,
  PseudoVFNMSAC_VFPR16_M2_E16,
  PseudoVFNMSAC_VFPR16_M2_E16_MASK,
  PseudoVFNMSAC_VFPR16_M4_E16,
  PseudoVFNMSAC_VFPR16_M4_E16_MASK,
  PseudoVFNMSAC_VFPR16_M8_E16,
  PseudoVFNMSAC_VFPR16_M8_E16_MASK,
  PseudoVFNMSAC_VFPR16_MF2_E16,
  PseudoVFNMSAC_VFPR16_MF2_E16_MASK,
  PseudoVFNMSAC_VFPR16_MF4_E16,
  PseudoVFNMSAC_VFPR16_MF4_E16_MASK,
  PseudoVFNMSAC_VFPR32_M1_E32,
  PseudoVFNMSAC_VFPR32_M1_E32_MASK,
  PseudoVFNMSAC_VFPR32_M2_E32,
  PseudoVFNMSAC_VFPR32_M2_E32_MASK,
  PseudoVFNMSAC_VFPR32_M4_E32,
  PseudoVFNMSAC_VFPR32_M4_E32_MASK,
  PseudoVFNMSAC_VFPR32_M8_E32,
  PseudoVFNMSAC_VFPR32_M8_E32_MASK,
  PseudoVFNMSAC_VFPR32_MF2_E32,
  PseudoVFNMSAC_VFPR32_MF2_E32_MASK,
  PseudoVFNMSAC_VFPR64_M1_E64,
  PseudoVFNMSAC_VFPR64_M1_E64_MASK,
  PseudoVFNMSAC_VFPR64_M2_E64,
  PseudoVFNMSAC_VFPR64_M2_E64_MASK,
  PseudoVFNMSAC_VFPR64_M4_E64,
  PseudoVFNMSAC_VFPR64_M4_E64_MASK,
  PseudoVFNMSAC_VFPR64_M8_E64,
  PseudoVFNMSAC_VFPR64_M8_E64_MASK,
  PseudoVFNMSAC_VV_M1_E16,
  PseudoVFNMSAC_VV_M1_E16_MASK,
  PseudoVFNMSAC_VV_M1_E32,
  PseudoVFNMSAC_VV_M1_E32_MASK,
  PseudoVFNMSAC_VV_M1_E64,
  PseudoVFNMSAC_VV_M1_E64_MASK,
  PseudoVFNMSAC_VV_M2_E16,
  PseudoVFNMSAC_VV_M2_E16_MASK,
  PseudoVFNMSAC_VV_M2_E32,
  PseudoVFNMSAC_VV_M2_E32_MASK,
  PseudoVFNMSAC_VV_M2_E64,
  PseudoVFNMSAC_VV_M2_E64_MASK,
  PseudoVFNMSAC_VV_M4_E16,
  PseudoVFNMSAC_VV_M4_E16_MASK,
  PseudoVFNMSAC_VV_M4_E32,
  PseudoVFNMSAC_VV_M4_E32_MASK,
  PseudoVFNMSAC_VV_M4_E64,
  PseudoVFNMSAC_VV_M4_E64_MASK,
  PseudoVFNMSAC_VV_M8_E16,
  PseudoVFNMSAC_VV_M8_E16_MASK,
  PseudoVFNMSAC_VV_M8_E32,
  PseudoVFNMSAC_VV_M8_E32_MASK,
  PseudoVFNMSAC_VV_M8_E64,
  PseudoVFNMSAC_VV_M8_E64_MASK,
  PseudoVFNMSAC_VV_MF2_E16,
  PseudoVFNMSAC_VV_MF2_E16_MASK,
  PseudoVFNMSAC_VV_MF2_E32,
  PseudoVFNMSAC_VV_MF2_E32_MASK,
  PseudoVFNMSAC_VV_MF4_E16,
  PseudoVFNMSAC_VV_MF4_E16_MASK,
  PseudoVFNMSUB_VFPR16_M1_E16,
  PseudoVFNMSUB_VFPR16_M1_E16_MASK,
  PseudoVFNMSUB_VFPR16_M2_E16,
  PseudoVFNMSUB_VFPR16_M2_E16_MASK,
  PseudoVFNMSUB_VFPR16_M4_E16,
  PseudoVFNMSUB_VFPR16_M4_E16_MASK,
  PseudoVFNMSUB_VFPR16_M8_E16,
  PseudoVFNMSUB_VFPR16_M8_E16_MASK,
  PseudoVFNMSUB_VFPR16_MF2_E16,
  PseudoVFNMSUB_VFPR16_MF2_E16_MASK,
  PseudoVFNMSUB_VFPR16_MF4_E16,
  PseudoVFNMSUB_VFPR16_MF4_E16_MASK,
  PseudoVFNMSUB_VFPR32_M1_E32,
  PseudoVFNMSUB_VFPR32_M1_E32_MASK,
  PseudoVFNMSUB_VFPR32_M2_E32,
  PseudoVFNMSUB_VFPR32_M2_E32_MASK,
  PseudoVFNMSUB_VFPR32_M4_E32,
  PseudoVFNMSUB_VFPR32_M4_E32_MASK,
  PseudoVFNMSUB_VFPR32_M8_E32,
  PseudoVFNMSUB_VFPR32_M8_E32_MASK,
  PseudoVFNMSUB_VFPR32_MF2_E32,
  PseudoVFNMSUB_VFPR32_MF2_E32_MASK,
  PseudoVFNMSUB_VFPR64_M1_E64,
  PseudoVFNMSUB_VFPR64_M1_E64_MASK,
  PseudoVFNMSUB_VFPR64_M2_E64,
  PseudoVFNMSUB_VFPR64_M2_E64_MASK,
  PseudoVFNMSUB_VFPR64_M4_E64,
  PseudoVFNMSUB_VFPR64_M4_E64_MASK,
  PseudoVFNMSUB_VFPR64_M8_E64,
  PseudoVFNMSUB_VFPR64_M8_E64_MASK,
  PseudoVFNMSUB_VV_M1_E16,
  PseudoVFNMSUB_VV_M1_E16_MASK,
  PseudoVFNMSUB_VV_M1_E32,
  PseudoVFNMSUB_VV_M1_E32_MASK,
  PseudoVFNMSUB_VV_M1_E64,
  PseudoVFNMSUB_VV_M1_E64_MASK,
  PseudoVFNMSUB_VV_M2_E16,
  PseudoVFNMSUB_VV_M2_E16_MASK,
  PseudoVFNMSUB_VV_M2_E32,
  PseudoVFNMSUB_VV_M2_E32_MASK,
  PseudoVFNMSUB_VV_M2_E64,
  PseudoVFNMSUB_VV_M2_E64_MASK,
  PseudoVFNMSUB_VV_M4_E16,
  PseudoVFNMSUB_VV_M4_E16_MASK,
  PseudoVFNMSUB_VV_M4_E32,
  PseudoVFNMSUB_VV_M4_E32_MASK,
  PseudoVFNMSUB_VV_M4_E64,
  PseudoVFNMSUB_VV_M4_E64_MASK,
  PseudoVFNMSUB_VV_M8_E16,
  PseudoVFNMSUB_VV_M8_E16_MASK,
  PseudoVFNMSUB_VV_M8_E32,
  PseudoVFNMSUB_VV_M8_E32_MASK,
  PseudoVFNMSUB_VV_M8_E64,
  PseudoVFNMSUB_VV_M8_E64_MASK,
  PseudoVFNMSUB_VV_MF2_E16,
  PseudoVFNMSUB_VV_MF2_E16_MASK,
  PseudoVFNMSUB_VV_MF2_E32,
  PseudoVFNMSUB_VV_MF2_E32_MASK,
  PseudoVFNMSUB_VV_MF4_E16,
  PseudoVFNMSUB_VV_MF4_E16_MASK,
  PseudoVFNRCLIP_XU_F_QF_M1,
  PseudoVFNRCLIP_XU_F_QF_M1_MASK,
  PseudoVFNRCLIP_XU_F_QF_M2,
  PseudoVFNRCLIP_XU_F_QF_M2_MASK,
  PseudoVFNRCLIP_XU_F_QF_MF2,
  PseudoVFNRCLIP_XU_F_QF_MF2_MASK,
  PseudoVFNRCLIP_XU_F_QF_MF4,
  PseudoVFNRCLIP_XU_F_QF_MF4_MASK,
  PseudoVFNRCLIP_XU_F_QF_MF8,
  PseudoVFNRCLIP_XU_F_QF_MF8_MASK,
  PseudoVFNRCLIP_X_F_QF_M1,
  PseudoVFNRCLIP_X_F_QF_M1_MASK,
  PseudoVFNRCLIP_X_F_QF_M2,
  PseudoVFNRCLIP_X_F_QF_M2_MASK,
  PseudoVFNRCLIP_X_F_QF_MF2,
  PseudoVFNRCLIP_X_F_QF_MF2_MASK,
  PseudoVFNRCLIP_X_F_QF_MF4,
  PseudoVFNRCLIP_X_F_QF_MF4_MASK,
  PseudoVFNRCLIP_X_F_QF_MF8,
  PseudoVFNRCLIP_X_F_QF_MF8_MASK,
  PseudoVFRDIV_VFPR16_M1_E16,
  PseudoVFRDIV_VFPR16_M1_E16_MASK,
  PseudoVFRDIV_VFPR16_M2_E16,
  PseudoVFRDIV_VFPR16_M2_E16_MASK,
  PseudoVFRDIV_VFPR16_M4_E16,
  PseudoVFRDIV_VFPR16_M4_E16_MASK,
  PseudoVFRDIV_VFPR16_M8_E16,
  PseudoVFRDIV_VFPR16_M8_E16_MASK,
  PseudoVFRDIV_VFPR16_MF2_E16,
  PseudoVFRDIV_VFPR16_MF2_E16_MASK,
  PseudoVFRDIV_VFPR16_MF4_E16,
  PseudoVFRDIV_VFPR16_MF4_E16_MASK,
  PseudoVFRDIV_VFPR32_M1_E32,
  PseudoVFRDIV_VFPR32_M1_E32_MASK,
  PseudoVFRDIV_VFPR32_M2_E32,
  PseudoVFRDIV_VFPR32_M2_E32_MASK,
  PseudoVFRDIV_VFPR32_M4_E32,
  PseudoVFRDIV_VFPR32_M4_E32_MASK,
  PseudoVFRDIV_VFPR32_M8_E32,
  PseudoVFRDIV_VFPR32_M8_E32_MASK,
  PseudoVFRDIV_VFPR32_MF2_E32,
  PseudoVFRDIV_VFPR32_MF2_E32_MASK,
  PseudoVFRDIV_VFPR64_M1_E64,
  PseudoVFRDIV_VFPR64_M1_E64_MASK,
  PseudoVFRDIV_VFPR64_M2_E64,
  PseudoVFRDIV_VFPR64_M2_E64_MASK,
  PseudoVFRDIV_VFPR64_M4_E64,
  PseudoVFRDIV_VFPR64_M4_E64_MASK,
  PseudoVFRDIV_VFPR64_M8_E64,
  PseudoVFRDIV_VFPR64_M8_E64_MASK,
  PseudoVFREC7_V_M1_E16,
  PseudoVFREC7_V_M1_E16_MASK,
  PseudoVFREC7_V_M1_E32,
  PseudoVFREC7_V_M1_E32_MASK,
  PseudoVFREC7_V_M1_E64,
  PseudoVFREC7_V_M1_E64_MASK,
  PseudoVFREC7_V_M2_E16,
  PseudoVFREC7_V_M2_E16_MASK,
  PseudoVFREC7_V_M2_E32,
  PseudoVFREC7_V_M2_E32_MASK,
  PseudoVFREC7_V_M2_E64,
  PseudoVFREC7_V_M2_E64_MASK,
  PseudoVFREC7_V_M4_E16,
  PseudoVFREC7_V_M4_E16_MASK,
  PseudoVFREC7_V_M4_E32,
  PseudoVFREC7_V_M4_E32_MASK,
  PseudoVFREC7_V_M4_E64,
  PseudoVFREC7_V_M4_E64_MASK,
  PseudoVFREC7_V_M8_E16,
  PseudoVFREC7_V_M8_E16_MASK,
  PseudoVFREC7_V_M8_E32,
  PseudoVFREC7_V_M8_E32_MASK,
  PseudoVFREC7_V_M8_E64,
  PseudoVFREC7_V_M8_E64_MASK,
  PseudoVFREC7_V_MF2_E16,
  PseudoVFREC7_V_MF2_E16_MASK,
  PseudoVFREC7_V_MF2_E32,
  PseudoVFREC7_V_MF2_E32_MASK,
  PseudoVFREC7_V_MF4_E16,
  PseudoVFREC7_V_MF4_E16_MASK,
  PseudoVFREDMAX_VS_M1_E16,
  PseudoVFREDMAX_VS_M1_E16_MASK,
  PseudoVFREDMAX_VS_M1_E32,
  PseudoVFREDMAX_VS_M1_E32_MASK,
  PseudoVFREDMAX_VS_M1_E64,
  PseudoVFREDMAX_VS_M1_E64_MASK,
  PseudoVFREDMAX_VS_M2_E16,
  PseudoVFREDMAX_VS_M2_E16_MASK,
  PseudoVFREDMAX_VS_M2_E32,
  PseudoVFREDMAX_VS_M2_E32_MASK,
  PseudoVFREDMAX_VS_M2_E64,
  PseudoVFREDMAX_VS_M2_E64_MASK,
  PseudoVFREDMAX_VS_M4_E16,
  PseudoVFREDMAX_VS_M4_E16_MASK,
  PseudoVFREDMAX_VS_M4_E32,
  PseudoVFREDMAX_VS_M4_E32_MASK,
  PseudoVFREDMAX_VS_M4_E64,
  PseudoVFREDMAX_VS_M4_E64_MASK,
  PseudoVFREDMAX_VS_M8_E16,
  PseudoVFREDMAX_VS_M8_E16_MASK,
  PseudoVFREDMAX_VS_M8_E32,
  PseudoVFREDMAX_VS_M8_E32_MASK,
  PseudoVFREDMAX_VS_M8_E64,
  PseudoVFREDMAX_VS_M8_E64_MASK,
  PseudoVFREDMAX_VS_MF2_E16,
  PseudoVFREDMAX_VS_MF2_E16_MASK,
  PseudoVFREDMAX_VS_MF2_E32,
  PseudoVFREDMAX_VS_MF2_E32_MASK,
  PseudoVFREDMAX_VS_MF4_E16,
  PseudoVFREDMAX_VS_MF4_E16_MASK,
  PseudoVFREDMIN_VS_M1_E16,
  PseudoVFREDMIN_VS_M1_E16_MASK,
  PseudoVFREDMIN_VS_M1_E32,
  PseudoVFREDMIN_VS_M1_E32_MASK,
  PseudoVFREDMIN_VS_M1_E64,
  PseudoVFREDMIN_VS_M1_E64_MASK,
  PseudoVFREDMIN_VS_M2_E16,
  PseudoVFREDMIN_VS_M2_E16_MASK,
  PseudoVFREDMIN_VS_M2_E32,
  PseudoVFREDMIN_VS_M2_E32_MASK,
  PseudoVFREDMIN_VS_M2_E64,
  PseudoVFREDMIN_VS_M2_E64_MASK,
  PseudoVFREDMIN_VS_M4_E16,
  PseudoVFREDMIN_VS_M4_E16_MASK,
  PseudoVFREDMIN_VS_M4_E32,
  PseudoVFREDMIN_VS_M4_E32_MASK,
  PseudoVFREDMIN_VS_M4_E64,
  PseudoVFREDMIN_VS_M4_E64_MASK,
  PseudoVFREDMIN_VS_M8_E16,
  PseudoVFREDMIN_VS_M8_E16_MASK,
  PseudoVFREDMIN_VS_M8_E32,
  PseudoVFREDMIN_VS_M8_E32_MASK,
  PseudoVFREDMIN_VS_M8_E64,
  PseudoVFREDMIN_VS_M8_E64_MASK,
  PseudoVFREDMIN_VS_MF2_E16,
  PseudoVFREDMIN_VS_MF2_E16_MASK,
  PseudoVFREDMIN_VS_MF2_E32,
  PseudoVFREDMIN_VS_MF2_E32_MASK,
  PseudoVFREDMIN_VS_MF4_E16,
  PseudoVFREDMIN_VS_MF4_E16_MASK,
  PseudoVFREDOSUM_VS_M1_E16,
  PseudoVFREDOSUM_VS_M1_E16_MASK,
  PseudoVFREDOSUM_VS_M1_E32,
  PseudoVFREDOSUM_VS_M1_E32_MASK,
  PseudoVFREDOSUM_VS_M1_E64,
  PseudoVFREDOSUM_VS_M1_E64_MASK,
  PseudoVFREDOSUM_VS_M2_E16,
  PseudoVFREDOSUM_VS_M2_E16_MASK,
  PseudoVFREDOSUM_VS_M2_E32,
  PseudoVFREDOSUM_VS_M2_E32_MASK,
  PseudoVFREDOSUM_VS_M2_E64,
  PseudoVFREDOSUM_VS_M2_E64_MASK,
  PseudoVFREDOSUM_VS_M4_E16,
  PseudoVFREDOSUM_VS_M4_E16_MASK,
  PseudoVFREDOSUM_VS_M4_E32,
  PseudoVFREDOSUM_VS_M4_E32_MASK,
  PseudoVFREDOSUM_VS_M4_E64,
  PseudoVFREDOSUM_VS_M4_E64_MASK,
  PseudoVFREDOSUM_VS_M8_E16,
  PseudoVFREDOSUM_VS_M8_E16_MASK,
  PseudoVFREDOSUM_VS_M8_E32,
  PseudoVFREDOSUM_VS_M8_E32_MASK,
  PseudoVFREDOSUM_VS_M8_E64,
  PseudoVFREDOSUM_VS_M8_E64_MASK,
  PseudoVFREDOSUM_VS_MF2_E16,
  PseudoVFREDOSUM_VS_MF2_E16_MASK,
  PseudoVFREDOSUM_VS_MF2_E32,
  PseudoVFREDOSUM_VS_MF2_E32_MASK,
  PseudoVFREDOSUM_VS_MF4_E16,
  PseudoVFREDOSUM_VS_MF4_E16_MASK,
  PseudoVFREDUSUM_VS_M1_E16,
  PseudoVFREDUSUM_VS_M1_E16_MASK,
  PseudoVFREDUSUM_VS_M1_E32,
  PseudoVFREDUSUM_VS_M1_E32_MASK,
  PseudoVFREDUSUM_VS_M1_E64,
  PseudoVFREDUSUM_VS_M1_E64_MASK,
  PseudoVFREDUSUM_VS_M2_E16,
  PseudoVFREDUSUM_VS_M2_E16_MASK,
  PseudoVFREDUSUM_VS_M2_E32,
  PseudoVFREDUSUM_VS_M2_E32_MASK,
  PseudoVFREDUSUM_VS_M2_E64,
  PseudoVFREDUSUM_VS_M2_E64_MASK,
  PseudoVFREDUSUM_VS_M4_E16,
  PseudoVFREDUSUM_VS_M4_E16_MASK,
  PseudoVFREDUSUM_VS_M4_E32,
  PseudoVFREDUSUM_VS_M4_E32_MASK,
  PseudoVFREDUSUM_VS_M4_E64,
  PseudoVFREDUSUM_VS_M4_E64_MASK,
  PseudoVFREDUSUM_VS_M8_E16,
  PseudoVFREDUSUM_VS_M8_E16_MASK,
  PseudoVFREDUSUM_VS_M8_E32,
  PseudoVFREDUSUM_VS_M8_E32_MASK,
  PseudoVFREDUSUM_VS_M8_E64,
  PseudoVFREDUSUM_VS_M8_E64_MASK,
  PseudoVFREDUSUM_VS_MF2_E16,
  PseudoVFREDUSUM_VS_MF2_E16_MASK,
  PseudoVFREDUSUM_VS_MF2_E32,
  PseudoVFREDUSUM_VS_MF2_E32_MASK,
  PseudoVFREDUSUM_VS_MF4_E16,
  PseudoVFREDUSUM_VS_MF4_E16_MASK,
  PseudoVFROUND_NOEXCEPT_V_M1_MASK,
  PseudoVFROUND_NOEXCEPT_V_M2_MASK,
  PseudoVFROUND_NOEXCEPT_V_M4_MASK,
  PseudoVFROUND_NOEXCEPT_V_M8_MASK,
  PseudoVFROUND_NOEXCEPT_V_MF2_MASK,
  PseudoVFROUND_NOEXCEPT_V_MF4_MASK,
  PseudoVFRSQRT7_V_M1_E16,
  PseudoVFRSQRT7_V_M1_E16_MASK,
  PseudoVFRSQRT7_V_M1_E32,
  PseudoVFRSQRT7_V_M1_E32_MASK,
  PseudoVFRSQRT7_V_M1_E64,
  PseudoVFRSQRT7_V_M1_E64_MASK,
  PseudoVFRSQRT7_V_M2_E16,
  PseudoVFRSQRT7_V_M2_E16_MASK,
  PseudoVFRSQRT7_V_M2_E32,
  PseudoVFRSQRT7_V_M2_E32_MASK,
  PseudoVFRSQRT7_V_M2_E64,
  PseudoVFRSQRT7_V_M2_E64_MASK,
  PseudoVFRSQRT7_V_M4_E16,
  PseudoVFRSQRT7_V_M4_E16_MASK,
  PseudoVFRSQRT7_V_M4_E32,
  PseudoVFRSQRT7_V_M4_E32_MASK,
  PseudoVFRSQRT7_V_M4_E64,
  PseudoVFRSQRT7_V_M4_E64_MASK,
  PseudoVFRSQRT7_V_M8_E16,
  PseudoVFRSQRT7_V_M8_E16_MASK,
  PseudoVFRSQRT7_V_M8_E32,
  PseudoVFRSQRT7_V_M8_E32_MASK,
  PseudoVFRSQRT7_V_M8_E64,
  PseudoVFRSQRT7_V_M8_E64_MASK,
  PseudoVFRSQRT7_V_MF2_E16,
  PseudoVFRSQRT7_V_MF2_E16_MASK,
  PseudoVFRSQRT7_V_MF2_E32,
  PseudoVFRSQRT7_V_MF2_E32_MASK,
  PseudoVFRSQRT7_V_MF4_E16,
  PseudoVFRSQRT7_V_MF4_E16_MASK,
  PseudoVFRSUB_VFPR16_M1_E16,
  PseudoVFRSUB_VFPR16_M1_E16_MASK,
  PseudoVFRSUB_VFPR16_M2_E16,
  PseudoVFRSUB_VFPR16_M2_E16_MASK,
  PseudoVFRSUB_VFPR16_M4_E16,
  PseudoVFRSUB_VFPR16_M4_E16_MASK,
  PseudoVFRSUB_VFPR16_M8_E16,
  PseudoVFRSUB_VFPR16_M8_E16_MASK,
  PseudoVFRSUB_VFPR16_MF2_E16,
  PseudoVFRSUB_VFPR16_MF2_E16_MASK,
  PseudoVFRSUB_VFPR16_MF4_E16,
  PseudoVFRSUB_VFPR16_MF4_E16_MASK,
  PseudoVFRSUB_VFPR32_M1_E32,
  PseudoVFRSUB_VFPR32_M1_E32_MASK,
  PseudoVFRSUB_VFPR32_M2_E32,
  PseudoVFRSUB_VFPR32_M2_E32_MASK,
  PseudoVFRSUB_VFPR32_M4_E32,
  PseudoVFRSUB_VFPR32_M4_E32_MASK,
  PseudoVFRSUB_VFPR32_M8_E32,
  PseudoVFRSUB_VFPR32_M8_E32_MASK,
  PseudoVFRSUB_VFPR32_MF2_E32,
  PseudoVFRSUB_VFPR32_MF2_E32_MASK,
  PseudoVFRSUB_VFPR64_M1_E64,
  PseudoVFRSUB_VFPR64_M1_E64_MASK,
  PseudoVFRSUB_VFPR64_M2_E64,
  PseudoVFRSUB_VFPR64_M2_E64_MASK,
  PseudoVFRSUB_VFPR64_M4_E64,
  PseudoVFRSUB_VFPR64_M4_E64_MASK,
  PseudoVFRSUB_VFPR64_M8_E64,
  PseudoVFRSUB_VFPR64_M8_E64_MASK,
  PseudoVFSGNJN_VFPR16_M1_E16,
  PseudoVFSGNJN_VFPR16_M1_E16_MASK,
  PseudoVFSGNJN_VFPR16_M2_E16,
  PseudoVFSGNJN_VFPR16_M2_E16_MASK,
  PseudoVFSGNJN_VFPR16_M4_E16,
  PseudoVFSGNJN_VFPR16_M4_E16_MASK,
  PseudoVFSGNJN_VFPR16_M8_E16,
  PseudoVFSGNJN_VFPR16_M8_E16_MASK,
  PseudoVFSGNJN_VFPR16_MF2_E16,
  PseudoVFSGNJN_VFPR16_MF2_E16_MASK,
  PseudoVFSGNJN_VFPR16_MF4_E16,
  PseudoVFSGNJN_VFPR16_MF4_E16_MASK,
  PseudoVFSGNJN_VFPR32_M1_E32,
  PseudoVFSGNJN_VFPR32_M1_E32_MASK,
  PseudoVFSGNJN_VFPR32_M2_E32,
  PseudoVFSGNJN_VFPR32_M2_E32_MASK,
  PseudoVFSGNJN_VFPR32_M4_E32,
  PseudoVFSGNJN_VFPR32_M4_E32_MASK,
  PseudoVFSGNJN_VFPR32_M8_E32,
  PseudoVFSGNJN_VFPR32_M8_E32_MASK,
  PseudoVFSGNJN_VFPR32_MF2_E32,
  PseudoVFSGNJN_VFPR32_MF2_E32_MASK,
  PseudoVFSGNJN_VFPR64_M1_E64,
  PseudoVFSGNJN_VFPR64_M1_E64_MASK,
  PseudoVFSGNJN_VFPR64_M2_E64,
  PseudoVFSGNJN_VFPR64_M2_E64_MASK,
  PseudoVFSGNJN_VFPR64_M4_E64,
  PseudoVFSGNJN_VFPR64_M4_E64_MASK,
  PseudoVFSGNJN_VFPR64_M8_E64,
  PseudoVFSGNJN_VFPR64_M8_E64_MASK,
  PseudoVFSGNJN_VV_M1_E16,
  PseudoVFSGNJN_VV_M1_E16_MASK,
  PseudoVFSGNJN_VV_M1_E32,
  PseudoVFSGNJN_VV_M1_E32_MASK,
  PseudoVFSGNJN_VV_M1_E64,
  PseudoVFSGNJN_VV_M1_E64_MASK,
  PseudoVFSGNJN_VV_M2_E16,
  PseudoVFSGNJN_VV_M2_E16_MASK,
  PseudoVFSGNJN_VV_M2_E32,
  PseudoVFSGNJN_VV_M2_E32_MASK,
  PseudoVFSGNJN_VV_M2_E64,
  PseudoVFSGNJN_VV_M2_E64_MASK,
  PseudoVFSGNJN_VV_M4_E16,
  PseudoVFSGNJN_VV_M4_E16_MASK,
  PseudoVFSGNJN_VV_M4_E32,
  PseudoVFSGNJN_VV_M4_E32_MASK,
  PseudoVFSGNJN_VV_M4_E64,
  PseudoVFSGNJN_VV_M4_E64_MASK,
  PseudoVFSGNJN_VV_M8_E16,
  PseudoVFSGNJN_VV_M8_E16_MASK,
  PseudoVFSGNJN_VV_M8_E32,
  PseudoVFSGNJN_VV_M8_E32_MASK,
  PseudoVFSGNJN_VV_M8_E64,
  PseudoVFSGNJN_VV_M8_E64_MASK,
  PseudoVFSGNJN_VV_MF2_E16,
  PseudoVFSGNJN_VV_MF2_E16_MASK,
  PseudoVFSGNJN_VV_MF2_E32,
  PseudoVFSGNJN_VV_MF2_E32_MASK,
  PseudoVFSGNJN_VV_MF4_E16,
  PseudoVFSGNJN_VV_MF4_E16_MASK,
  PseudoVFSGNJX_VFPR16_M1_E16,
  PseudoVFSGNJX_VFPR16_M1_E16_MASK,
  PseudoVFSGNJX_VFPR16_M2_E16,
  PseudoVFSGNJX_VFPR16_M2_E16_MASK,
  PseudoVFSGNJX_VFPR16_M4_E16,
  PseudoVFSGNJX_VFPR16_M4_E16_MASK,
  PseudoVFSGNJX_VFPR16_M8_E16,
  PseudoVFSGNJX_VFPR16_M8_E16_MASK,
  PseudoVFSGNJX_VFPR16_MF2_E16,
  PseudoVFSGNJX_VFPR16_MF2_E16_MASK,
  PseudoVFSGNJX_VFPR16_MF4_E16,
  PseudoVFSGNJX_VFPR16_MF4_E16_MASK,
  PseudoVFSGNJX_VFPR32_M1_E32,
  PseudoVFSGNJX_VFPR32_M1_E32_MASK,
  PseudoVFSGNJX_VFPR32_M2_E32,
  PseudoVFSGNJX_VFPR32_M2_E32_MASK,
  PseudoVFSGNJX_VFPR32_M4_E32,
  PseudoVFSGNJX_VFPR32_M4_E32_MASK,
  PseudoVFSGNJX_VFPR32_M8_E32,
  PseudoVFSGNJX_VFPR32_M8_E32_MASK,
  PseudoVFSGNJX_VFPR32_MF2_E32,
  PseudoVFSGNJX_VFPR32_MF2_E32_MASK,
  PseudoVFSGNJX_VFPR64_M1_E64,
  PseudoVFSGNJX_VFPR64_M1_E64_MASK,
  PseudoVFSGNJX_VFPR64_M2_E64,
  PseudoVFSGNJX_VFPR64_M2_E64_MASK,
  PseudoVFSGNJX_VFPR64_M4_E64,
  PseudoVFSGNJX_VFPR64_M4_E64_MASK,
  PseudoVFSGNJX_VFPR64_M8_E64,
  PseudoVFSGNJX_VFPR64_M8_E64_MASK,
  PseudoVFSGNJX_VV_M1_E16,
  PseudoVFSGNJX_VV_M1_E16_MASK,
  PseudoVFSGNJX_VV_M1_E32,
  PseudoVFSGNJX_VV_M1_E32_MASK,
  PseudoVFSGNJX_VV_M1_E64,
  PseudoVFSGNJX_VV_M1_E64_MASK,
  PseudoVFSGNJX_VV_M2_E16,
  PseudoVFSGNJX_VV_M2_E16_MASK,
  PseudoVFSGNJX_VV_M2_E32,
  PseudoVFSGNJX_VV_M2_E32_MASK,
  PseudoVFSGNJX_VV_M2_E64,
  PseudoVFSGNJX_VV_M2_E64_MASK,
  PseudoVFSGNJX_VV_M4_E16,
  PseudoVFSGNJX_VV_M4_E16_MASK,
  PseudoVFSGNJX_VV_M4_E32,
  PseudoVFSGNJX_VV_M4_E32_MASK,
  PseudoVFSGNJX_VV_M4_E64,
  PseudoVFSGNJX_VV_M4_E64_MASK,
  PseudoVFSGNJX_VV_M8_E16,
  PseudoVFSGNJX_VV_M8_E16_MASK,
  PseudoVFSGNJX_VV_M8_E32,
  PseudoVFSGNJX_VV_M8_E32_MASK,
  PseudoVFSGNJX_VV_M8_E64,
  PseudoVFSGNJX_VV_M8_E64_MASK,
  PseudoVFSGNJX_VV_MF2_E16,
  PseudoVFSGNJX_VV_MF2_E16_MASK,
  PseudoVFSGNJX_VV_MF2_E32,
  PseudoVFSGNJX_VV_MF2_E32_MASK,
  PseudoVFSGNJX_VV_MF4_E16,
  PseudoVFSGNJX_VV_MF4_E16_MASK,
  PseudoVFSGNJ_VFPR16_M1_E16,
  PseudoVFSGNJ_VFPR16_M1_E16_MASK,
  PseudoVFSGNJ_VFPR16_M2_E16,
  PseudoVFSGNJ_VFPR16_M2_E16_MASK,
  PseudoVFSGNJ_VFPR16_M4_E16,
  PseudoVFSGNJ_VFPR16_M4_E16_MASK,
  PseudoVFSGNJ_VFPR16_M8_E16,
  PseudoVFSGNJ_VFPR16_M8_E16_MASK,
  PseudoVFSGNJ_VFPR16_MF2_E16,
  PseudoVFSGNJ_VFPR16_MF2_E16_MASK,
  PseudoVFSGNJ_VFPR16_MF4_E16,
  PseudoVFSGNJ_VFPR16_MF4_E16_MASK,
  PseudoVFSGNJ_VFPR32_M1_E32,
  PseudoVFSGNJ_VFPR32_M1_E32_MASK,
  PseudoVFSGNJ_VFPR32_M2_E32,
  PseudoVFSGNJ_VFPR32_M2_E32_MASK,
  PseudoVFSGNJ_VFPR32_M4_E32,
  PseudoVFSGNJ_VFPR32_M4_E32_MASK,
  PseudoVFSGNJ_VFPR32_M8_E32,
  PseudoVFSGNJ_VFPR32_M8_E32_MASK,
  PseudoVFSGNJ_VFPR32_MF2_E32,
  PseudoVFSGNJ_VFPR32_MF2_E32_MASK,
  PseudoVFSGNJ_VFPR64_M1_E64,
  PseudoVFSGNJ_VFPR64_M1_E64_MASK,
  PseudoVFSGNJ_VFPR64_M2_E64,
  PseudoVFSGNJ_VFPR64_M2_E64_MASK,
  PseudoVFSGNJ_VFPR64_M4_E64,
  PseudoVFSGNJ_VFPR64_M4_E64_MASK,
  PseudoVFSGNJ_VFPR64_M8_E64,
  PseudoVFSGNJ_VFPR64_M8_E64_MASK,
  PseudoVFSGNJ_VV_M1_E16,
  PseudoVFSGNJ_VV_M1_E16_MASK,
  PseudoVFSGNJ_VV_M1_E32,
  PseudoVFSGNJ_VV_M1_E32_MASK,
  PseudoVFSGNJ_VV_M1_E64,
  PseudoVFSGNJ_VV_M1_E64_MASK,
  PseudoVFSGNJ_VV_M2_E16,
  PseudoVFSGNJ_VV_M2_E16_MASK,
  PseudoVFSGNJ_VV_M2_E32,
  PseudoVFSGNJ_VV_M2_E32_MASK,
  PseudoVFSGNJ_VV_M2_E64,
  PseudoVFSGNJ_VV_M2_E64_MASK,
  PseudoVFSGNJ_VV_M4_E16,
  PseudoVFSGNJ_VV_M4_E16_MASK,
  PseudoVFSGNJ_VV_M4_E32,
  PseudoVFSGNJ_VV_M4_E32_MASK,
  PseudoVFSGNJ_VV_M4_E64,
  PseudoVFSGNJ_VV_M4_E64_MASK,
  PseudoVFSGNJ_VV_M8_E16,
  PseudoVFSGNJ_VV_M8_E16_MASK,
  PseudoVFSGNJ_VV_M8_E32,
  PseudoVFSGNJ_VV_M8_E32_MASK,
  PseudoVFSGNJ_VV_M8_E64,
  PseudoVFSGNJ_VV_M8_E64_MASK,
  PseudoVFSGNJ_VV_MF2_E16,
  PseudoVFSGNJ_VV_MF2_E16_MASK,
  PseudoVFSGNJ_VV_MF2_E32,
  PseudoVFSGNJ_VV_MF2_E32_MASK,
  PseudoVFSGNJ_VV_MF4_E16,
  PseudoVFSGNJ_VV_MF4_E16_MASK,
  PseudoVFSLIDE1DOWN_VFPR16_M1,
  PseudoVFSLIDE1DOWN_VFPR16_M1_MASK,
  PseudoVFSLIDE1DOWN_VFPR16_M2,
  PseudoVFSLIDE1DOWN_VFPR16_M2_MASK,
  PseudoVFSLIDE1DOWN_VFPR16_M4,
  PseudoVFSLIDE1DOWN_VFPR16_M4_MASK,
  PseudoVFSLIDE1DOWN_VFPR16_M8,
  PseudoVFSLIDE1DOWN_VFPR16_M8_MASK,
  PseudoVFSLIDE1DOWN_VFPR16_MF2,
  PseudoVFSLIDE1DOWN_VFPR16_MF2_MASK,
  PseudoVFSLIDE1DOWN_VFPR16_MF4,
  PseudoVFSLIDE1DOWN_VFPR16_MF4_MASK,
  PseudoVFSLIDE1DOWN_VFPR32_M1,
  PseudoVFSLIDE1DOWN_VFPR32_M1_MASK,
  PseudoVFSLIDE1DOWN_VFPR32_M2,
  PseudoVFSLIDE1DOWN_VFPR32_M2_MASK,
  PseudoVFSLIDE1DOWN_VFPR32_M4,
  PseudoVFSLIDE1DOWN_VFPR32_M4_MASK,
  PseudoVFSLIDE1DOWN_VFPR32_M8,
  PseudoVFSLIDE1DOWN_VFPR32_M8_MASK,
  PseudoVFSLIDE1DOWN_VFPR32_MF2,
  PseudoVFSLIDE1DOWN_VFPR32_MF2_MASK,
  PseudoVFSLIDE1DOWN_VFPR64_M1,
  PseudoVFSLIDE1DOWN_VFPR64_M1_MASK,
  PseudoVFSLIDE1DOWN_VFPR64_M2,
  PseudoVFSLIDE1DOWN_VFPR64_M2_MASK,
  PseudoVFSLIDE1DOWN_VFPR64_M4,
  PseudoVFSLIDE1DOWN_VFPR64_M4_MASK,
  PseudoVFSLIDE1DOWN_VFPR64_M8,
  PseudoVFSLIDE1DOWN_VFPR64_M8_MASK,
  PseudoVFSLIDE1UP_VFPR16_M1,
  PseudoVFSLIDE1UP_VFPR16_M1_MASK,
  PseudoVFSLIDE1UP_VFPR16_M2,
  PseudoVFSLIDE1UP_VFPR16_M2_MASK,
  PseudoVFSLIDE1UP_VFPR16_M4,
  PseudoVFSLIDE1UP_VFPR16_M4_MASK,
  PseudoVFSLIDE1UP_VFPR16_M8,
  PseudoVFSLIDE1UP_VFPR16_M8_MASK,
  PseudoVFSLIDE1UP_VFPR16_MF2,
  PseudoVFSLIDE1UP_VFPR16_MF2_MASK,
  PseudoVFSLIDE1UP_VFPR16_MF4,
  PseudoVFSLIDE1UP_VFPR16_MF4_MASK,
  PseudoVFSLIDE1UP_VFPR32_M1,
  PseudoVFSLIDE1UP_VFPR32_M1_MASK,
  PseudoVFSLIDE1UP_VFPR32_M2,
  PseudoVFSLIDE1UP_VFPR32_M2_MASK,
  PseudoVFSLIDE1UP_VFPR32_M4,
  PseudoVFSLIDE1UP_VFPR32_M4_MASK,
  PseudoVFSLIDE1UP_VFPR32_M8,
  PseudoVFSLIDE1UP_VFPR32_M8_MASK,
  PseudoVFSLIDE1UP_VFPR32_MF2,
  PseudoVFSLIDE1UP_VFPR32_MF2_MASK,
  PseudoVFSLIDE1UP_VFPR64_M1,
  PseudoVFSLIDE1UP_VFPR64_M1_MASK,
  PseudoVFSLIDE1UP_VFPR64_M2,
  PseudoVFSLIDE1UP_VFPR64_M2_MASK,
  PseudoVFSLIDE1UP_VFPR64_M4,
  PseudoVFSLIDE1UP_VFPR64_M4_MASK,
  PseudoVFSLIDE1UP_VFPR64_M8,
  PseudoVFSLIDE1UP_VFPR64_M8_MASK,
  PseudoVFSQRT_V_M1_E16,
  PseudoVFSQRT_V_M1_E16_MASK,
  PseudoVFSQRT_V_M1_E32,
  PseudoVFSQRT_V_M1_E32_MASK,
  PseudoVFSQRT_V_M1_E64,
  PseudoVFSQRT_V_M1_E64_MASK,
  PseudoVFSQRT_V_M2_E16,
  PseudoVFSQRT_V_M2_E16_MASK,
  PseudoVFSQRT_V_M2_E32,
  PseudoVFSQRT_V_M2_E32_MASK,
  PseudoVFSQRT_V_M2_E64,
  PseudoVFSQRT_V_M2_E64_MASK,
  PseudoVFSQRT_V_M4_E16,
  PseudoVFSQRT_V_M4_E16_MASK,
  PseudoVFSQRT_V_M4_E32,
  PseudoVFSQRT_V_M4_E32_MASK,
  PseudoVFSQRT_V_M4_E64,
  PseudoVFSQRT_V_M4_E64_MASK,
  PseudoVFSQRT_V_M8_E16,
  PseudoVFSQRT_V_M8_E16_MASK,
  PseudoVFSQRT_V_M8_E32,
  PseudoVFSQRT_V_M8_E32_MASK,
  PseudoVFSQRT_V_M8_E64,
  PseudoVFSQRT_V_M8_E64_MASK,
  PseudoVFSQRT_V_MF2_E16,
  PseudoVFSQRT_V_MF2_E16_MASK,
  PseudoVFSQRT_V_MF2_E32,
  PseudoVFSQRT_V_MF2_E32_MASK,
  PseudoVFSQRT_V_MF4_E16,
  PseudoVFSQRT_V_MF4_E16_MASK,
  PseudoVFSUB_VFPR16_M1_E16,
  PseudoVFSUB_VFPR16_M1_E16_MASK,
  PseudoVFSUB_VFPR16_M2_E16,
  PseudoVFSUB_VFPR16_M2_E16_MASK,
  PseudoVFSUB_VFPR16_M4_E16,
  PseudoVFSUB_VFPR16_M4_E16_MASK,
  PseudoVFSUB_VFPR16_M8_E16,
  PseudoVFSUB_VFPR16_M8_E16_MASK,
  PseudoVFSUB_VFPR16_MF2_E16,
  PseudoVFSUB_VFPR16_MF2_E16_MASK,
  PseudoVFSUB_VFPR16_MF4_E16,
  PseudoVFSUB_VFPR16_MF4_E16_MASK,
  PseudoVFSUB_VFPR32_M1_E32,
  PseudoVFSUB_VFPR32_M1_E32_MASK,
  PseudoVFSUB_VFPR32_M2_E32,
  PseudoVFSUB_VFPR32_M2_E32_MASK,
  PseudoVFSUB_VFPR32_M4_E32,
  PseudoVFSUB_VFPR32_M4_E32_MASK,
  PseudoVFSUB_VFPR32_M8_E32,
  PseudoVFSUB_VFPR32_M8_E32_MASK,
  PseudoVFSUB_VFPR32_MF2_E32,
  PseudoVFSUB_VFPR32_MF2_E32_MASK,
  PseudoVFSUB_VFPR64_M1_E64,
  PseudoVFSUB_VFPR64_M1_E64_MASK,
  PseudoVFSUB_VFPR64_M2_E64,
  PseudoVFSUB_VFPR64_M2_E64_MASK,
  PseudoVFSUB_VFPR64_M4_E64,
  PseudoVFSUB_VFPR64_M4_E64_MASK,
  PseudoVFSUB_VFPR64_M8_E64,
  PseudoVFSUB_VFPR64_M8_E64_MASK,
  PseudoVFSUB_VV_M1_E16,
  PseudoVFSUB_VV_M1_E16_MASK,
  PseudoVFSUB_VV_M1_E32,
  PseudoVFSUB_VV_M1_E32_MASK,
  PseudoVFSUB_VV_M1_E64,
  PseudoVFSUB_VV_M1_E64_MASK,
  PseudoVFSUB_VV_M2_E16,
  PseudoVFSUB_VV_M2_E16_MASK,
  PseudoVFSUB_VV_M2_E32,
  PseudoVFSUB_VV_M2_E32_MASK,
  PseudoVFSUB_VV_M2_E64,
  PseudoVFSUB_VV_M2_E64_MASK,
  PseudoVFSUB_VV_M4_E16,
  PseudoVFSUB_VV_M4_E16_MASK,
  PseudoVFSUB_VV_M4_E32,
  PseudoVFSUB_VV_M4_E32_MASK,
  PseudoVFSUB_VV_M4_E64,
  PseudoVFSUB_VV_M4_E64_MASK,
  PseudoVFSUB_VV_M8_E16,
  PseudoVFSUB_VV_M8_E16_MASK,
  PseudoVFSUB_VV_M8_E32,
  PseudoVFSUB_VV_M8_E32_MASK,
  PseudoVFSUB_VV_M8_E64,
  PseudoVFSUB_VV_M8_E64_MASK,
  PseudoVFSUB_VV_MF2_E16,
  PseudoVFSUB_VV_MF2_E16_MASK,
  PseudoVFSUB_VV_MF2_E32,
  PseudoVFSUB_VV_MF2_E32_MASK,
  PseudoVFSUB_VV_MF4_E16,
  PseudoVFSUB_VV_MF4_E16_MASK,
  PseudoVFWADD_VFPR16_M1_E16,
  PseudoVFWADD_VFPR16_M1_E16_MASK,
  PseudoVFWADD_VFPR16_M2_E16,
  PseudoVFWADD_VFPR16_M2_E16_MASK,
  PseudoVFWADD_VFPR16_M4_E16,
  PseudoVFWADD_VFPR16_M4_E16_MASK,
  PseudoVFWADD_VFPR16_MF2_E16,
  PseudoVFWADD_VFPR16_MF2_E16_MASK,
  PseudoVFWADD_VFPR16_MF4_E16,
  PseudoVFWADD_VFPR16_MF4_E16_MASK,
  PseudoVFWADD_VFPR32_M1_E32,
  PseudoVFWADD_VFPR32_M1_E32_MASK,
  PseudoVFWADD_VFPR32_M2_E32,
  PseudoVFWADD_VFPR32_M2_E32_MASK,
  PseudoVFWADD_VFPR32_M4_E32,
  PseudoVFWADD_VFPR32_M4_E32_MASK,
  PseudoVFWADD_VFPR32_MF2_E32,
  PseudoVFWADD_VFPR32_MF2_E32_MASK,
  PseudoVFWADD_VV_M1_E16,
  PseudoVFWADD_VV_M1_E16_MASK,
  PseudoVFWADD_VV_M1_E32,
  PseudoVFWADD_VV_M1_E32_MASK,
  PseudoVFWADD_VV_M2_E16,
  PseudoVFWADD_VV_M2_E16_MASK,
  PseudoVFWADD_VV_M2_E32,
  PseudoVFWADD_VV_M2_E32_MASK,
  PseudoVFWADD_VV_M4_E16,
  PseudoVFWADD_VV_M4_E16_MASK,
  PseudoVFWADD_VV_M4_E32,
  PseudoVFWADD_VV_M4_E32_MASK,
  PseudoVFWADD_VV_MF2_E16,
  PseudoVFWADD_VV_MF2_E16_MASK,
  PseudoVFWADD_VV_MF2_E32,
  PseudoVFWADD_VV_MF2_E32_MASK,
  PseudoVFWADD_VV_MF4_E16,
  PseudoVFWADD_VV_MF4_E16_MASK,
  PseudoVFWADD_WFPR16_M1_E16,
  PseudoVFWADD_WFPR16_M1_E16_MASK,
  PseudoVFWADD_WFPR16_M2_E16,
  PseudoVFWADD_WFPR16_M2_E16_MASK,
  PseudoVFWADD_WFPR16_M4_E16,
  PseudoVFWADD_WFPR16_M4_E16_MASK,
  PseudoVFWADD_WFPR16_MF2_E16,
  PseudoVFWADD_WFPR16_MF2_E16_MASK,
  PseudoVFWADD_WFPR16_MF4_E16,
  PseudoVFWADD_WFPR16_MF4_E16_MASK,
  PseudoVFWADD_WFPR32_M1_E32,
  PseudoVFWADD_WFPR32_M1_E32_MASK,
  PseudoVFWADD_WFPR32_M2_E32,
  PseudoVFWADD_WFPR32_M2_E32_MASK,
  PseudoVFWADD_WFPR32_M4_E32,
  PseudoVFWADD_WFPR32_M4_E32_MASK,
  PseudoVFWADD_WFPR32_MF2_E32,
  PseudoVFWADD_WFPR32_MF2_E32_MASK,
  PseudoVFWADD_WV_M1_E16,
  PseudoVFWADD_WV_M1_E16_MASK,
  PseudoVFWADD_WV_M1_E16_MASK_TIED,
  PseudoVFWADD_WV_M1_E16_TIED,
  PseudoVFWADD_WV_M1_E32,
  PseudoVFWADD_WV_M1_E32_MASK,
  PseudoVFWADD_WV_M1_E32_MASK_TIED,
  PseudoVFWADD_WV_M1_E32_TIED,
  PseudoVFWADD_WV_M2_E16,
  PseudoVFWADD_WV_M2_E16_MASK,
  PseudoVFWADD_WV_M2_E16_MASK_TIED,
  PseudoVFWADD_WV_M2_E16_TIED,
  PseudoVFWADD_WV_M2_E32,
  PseudoVFWADD_WV_M2_E32_MASK,
  PseudoVFWADD_WV_M2_E32_MASK_TIED,
  PseudoVFWADD_WV_M2_E32_TIED,
  PseudoVFWADD_WV_M4_E16,
  PseudoVFWADD_WV_M4_E16_MASK,
  PseudoVFWADD_WV_M4_E16_MASK_TIED,
  PseudoVFWADD_WV_M4_E16_TIED,
  PseudoVFWADD_WV_M4_E32,
  PseudoVFWADD_WV_M4_E32_MASK,
  PseudoVFWADD_WV_M4_E32_MASK_TIED,
  PseudoVFWADD_WV_M4_E32_TIED,
  PseudoVFWADD_WV_MF2_E16,
  PseudoVFWADD_WV_MF2_E16_MASK,
  PseudoVFWADD_WV_MF2_E16_MASK_TIED,
  PseudoVFWADD_WV_MF2_E16_TIED,
  PseudoVFWADD_WV_MF2_E32,
  PseudoVFWADD_WV_MF2_E32_MASK,
  PseudoVFWADD_WV_MF2_E32_MASK_TIED,
  PseudoVFWADD_WV_MF2_E32_TIED,
  PseudoVFWADD_WV_MF4_E16,
  PseudoVFWADD_WV_MF4_E16_MASK,
  PseudoVFWADD_WV_MF4_E16_MASK_TIED,
  PseudoVFWADD_WV_MF4_E16_TIED,
  PseudoVFWCVTBF16_F_F_V_M1_E16,
  PseudoVFWCVTBF16_F_F_V_M1_E16_MASK,
  PseudoVFWCVTBF16_F_F_V_M1_E32,
  PseudoVFWCVTBF16_F_F_V_M1_E32_MASK,
  PseudoVFWCVTBF16_F_F_V_M2_E16,
  PseudoVFWCVTBF16_F_F_V_M2_E16_MASK,
  PseudoVFWCVTBF16_F_F_V_M2_E32,
  PseudoVFWCVTBF16_F_F_V_M2_E32_MASK,
  PseudoVFWCVTBF16_F_F_V_M4_E16,
  PseudoVFWCVTBF16_F_F_V_M4_E16_MASK,
  PseudoVFWCVTBF16_F_F_V_M4_E32,
  PseudoVFWCVTBF16_F_F_V_M4_E32_MASK,
  PseudoVFWCVTBF16_F_F_V_MF2_E16,
  PseudoVFWCVTBF16_F_F_V_MF2_E16_MASK,
  PseudoVFWCVTBF16_F_F_V_MF2_E32,
  PseudoVFWCVTBF16_F_F_V_MF2_E32_MASK,
  PseudoVFWCVTBF16_F_F_V_MF4_E16,
  PseudoVFWCVTBF16_F_F_V_MF4_E16_MASK,
  PseudoVFWCVT_F_F_V_M1_E16,
  PseudoVFWCVT_F_F_V_M1_E16_MASK,
  PseudoVFWCVT_F_F_V_M1_E32,
  PseudoVFWCVT_F_F_V_M1_E32_MASK,
  PseudoVFWCVT_F_F_V_M2_E16,
  PseudoVFWCVT_F_F_V_M2_E16_MASK,
  PseudoVFWCVT_F_F_V_M2_E32,
  PseudoVFWCVT_F_F_V_M2_E32_MASK,
  PseudoVFWCVT_F_F_V_M4_E16,
  PseudoVFWCVT_F_F_V_M4_E16_MASK,
  PseudoVFWCVT_F_F_V_M4_E32,
  PseudoVFWCVT_F_F_V_M4_E32_MASK,
  PseudoVFWCVT_F_F_V_MF2_E16,
  PseudoVFWCVT_F_F_V_MF2_E16_MASK,
  PseudoVFWCVT_F_F_V_MF2_E32,
  PseudoVFWCVT_F_F_V_MF2_E32_MASK,
  PseudoVFWCVT_F_F_V_MF4_E16,
  PseudoVFWCVT_F_F_V_MF4_E16_MASK,
  PseudoVFWCVT_F_XU_V_M1_E16,
  PseudoVFWCVT_F_XU_V_M1_E16_MASK,
  PseudoVFWCVT_F_XU_V_M1_E32,
  PseudoVFWCVT_F_XU_V_M1_E32_MASK,
  PseudoVFWCVT_F_XU_V_M1_E8,
  PseudoVFWCVT_F_XU_V_M1_E8_MASK,
  PseudoVFWCVT_F_XU_V_M2_E16,
  PseudoVFWCVT_F_XU_V_M2_E16_MASK,
  PseudoVFWCVT_F_XU_V_M2_E32,
  PseudoVFWCVT_F_XU_V_M2_E32_MASK,
  PseudoVFWCVT_F_XU_V_M2_E8,
  PseudoVFWCVT_F_XU_V_M2_E8_MASK,
  PseudoVFWCVT_F_XU_V_M4_E16,
  PseudoVFWCVT_F_XU_V_M4_E16_MASK,
  PseudoVFWCVT_F_XU_V_M4_E32,
  PseudoVFWCVT_F_XU_V_M4_E32_MASK,
  PseudoVFWCVT_F_XU_V_M4_E8,
  PseudoVFWCVT_F_XU_V_M4_E8_MASK,
  PseudoVFWCVT_F_XU_V_MF2_E16,
  PseudoVFWCVT_F_XU_V_MF2_E16_MASK,
  PseudoVFWCVT_F_XU_V_MF2_E32,
  PseudoVFWCVT_F_XU_V_MF2_E32_MASK,
  PseudoVFWCVT_F_XU_V_MF2_E8,
  PseudoVFWCVT_F_XU_V_MF2_E8_MASK,
  PseudoVFWCVT_F_XU_V_MF4_E16,
  PseudoVFWCVT_F_XU_V_MF4_E16_MASK,
  PseudoVFWCVT_F_XU_V_MF4_E8,
  PseudoVFWCVT_F_XU_V_MF4_E8_MASK,
  PseudoVFWCVT_F_XU_V_MF8_E8,
  PseudoVFWCVT_F_XU_V_MF8_E8_MASK,
  PseudoVFWCVT_F_X_V_M1_E16,
  PseudoVFWCVT_F_X_V_M1_E16_MASK,
  PseudoVFWCVT_F_X_V_M1_E32,
  PseudoVFWCVT_F_X_V_M1_E32_MASK,
  PseudoVFWCVT_F_X_V_M1_E8,
  PseudoVFWCVT_F_X_V_M1_E8_MASK,
  PseudoVFWCVT_F_X_V_M2_E16,
  PseudoVFWCVT_F_X_V_M2_E16_MASK,
  PseudoVFWCVT_F_X_V_M2_E32,
  PseudoVFWCVT_F_X_V_M2_E32_MASK,
  PseudoVFWCVT_F_X_V_M2_E8,
  PseudoVFWCVT_F_X_V_M2_E8_MASK,
  PseudoVFWCVT_F_X_V_M4_E16,
  PseudoVFWCVT_F_X_V_M4_E16_MASK,
  PseudoVFWCVT_F_X_V_M4_E32,
  PseudoVFWCVT_F_X_V_M4_E32_MASK,
  PseudoVFWCVT_F_X_V_M4_E8,
  PseudoVFWCVT_F_X_V_M4_E8_MASK,
  PseudoVFWCVT_F_X_V_MF2_E16,
  PseudoVFWCVT_F_X_V_MF2_E16_MASK,
  PseudoVFWCVT_F_X_V_MF2_E32,
  PseudoVFWCVT_F_X_V_MF2_E32_MASK,
  PseudoVFWCVT_F_X_V_MF2_E8,
  PseudoVFWCVT_F_X_V_MF2_E8_MASK,
  PseudoVFWCVT_F_X_V_MF4_E16,
  PseudoVFWCVT_F_X_V_MF4_E16_MASK,
  PseudoVFWCVT_F_X_V_MF4_E8,
  PseudoVFWCVT_F_X_V_MF4_E8_MASK,
  PseudoVFWCVT_F_X_V_MF8_E8,
  PseudoVFWCVT_F_X_V_MF8_E8_MASK,
  PseudoVFWCVT_RM_XU_F_V_M1,
  PseudoVFWCVT_RM_XU_F_V_M1_MASK,
  PseudoVFWCVT_RM_XU_F_V_M2,
  PseudoVFWCVT_RM_XU_F_V_M2_MASK,
  PseudoVFWCVT_RM_XU_F_V_M4,
  PseudoVFWCVT_RM_XU_F_V_M4_MASK,
  PseudoVFWCVT_RM_XU_F_V_MF2,
  PseudoVFWCVT_RM_XU_F_V_MF2_MASK,
  PseudoVFWCVT_RM_XU_F_V_MF4,
  PseudoVFWCVT_RM_XU_F_V_MF4_MASK,
  PseudoVFWCVT_RM_X_F_V_M1,
  PseudoVFWCVT_RM_X_F_V_M1_MASK,
  PseudoVFWCVT_RM_X_F_V_M2,
  PseudoVFWCVT_RM_X_F_V_M2_MASK,
  PseudoVFWCVT_RM_X_F_V_M4,
  PseudoVFWCVT_RM_X_F_V_M4_MASK,
  PseudoVFWCVT_RM_X_F_V_MF2,
  PseudoVFWCVT_RM_X_F_V_MF2_MASK,
  PseudoVFWCVT_RM_X_F_V_MF4,
  PseudoVFWCVT_RM_X_F_V_MF4_MASK,
  PseudoVFWCVT_RTZ_XU_F_V_M1,
  PseudoVFWCVT_RTZ_XU_F_V_M1_MASK,
  PseudoVFWCVT_RTZ_XU_F_V_M2,
  PseudoVFWCVT_RTZ_XU_F_V_M2_MASK,
  PseudoVFWCVT_RTZ_XU_F_V_M4,
  PseudoVFWCVT_RTZ_XU_F_V_M4_MASK,
  PseudoVFWCVT_RTZ_XU_F_V_MF2,
  PseudoVFWCVT_RTZ_XU_F_V_MF2_MASK,
  PseudoVFWCVT_RTZ_XU_F_V_MF4,
  PseudoVFWCVT_RTZ_XU_F_V_MF4_MASK,
  PseudoVFWCVT_RTZ_X_F_V_M1,
  PseudoVFWCVT_RTZ_X_F_V_M1_MASK,
  PseudoVFWCVT_RTZ_X_F_V_M2,
  PseudoVFWCVT_RTZ_X_F_V_M2_MASK,
  PseudoVFWCVT_RTZ_X_F_V_M4,
  PseudoVFWCVT_RTZ_X_F_V_M4_MASK,
  PseudoVFWCVT_RTZ_X_F_V_MF2,
  PseudoVFWCVT_RTZ_X_F_V_MF2_MASK,
  PseudoVFWCVT_RTZ_X_F_V_MF4,
  PseudoVFWCVT_RTZ_X_F_V_MF4_MASK,
  PseudoVFWCVT_XU_F_V_M1,
  PseudoVFWCVT_XU_F_V_M1_MASK,
  PseudoVFWCVT_XU_F_V_M2,
  PseudoVFWCVT_XU_F_V_M2_MASK,
  PseudoVFWCVT_XU_F_V_M4,
  PseudoVFWCVT_XU_F_V_M4_MASK,
  PseudoVFWCVT_XU_F_V_MF2,
  PseudoVFWCVT_XU_F_V_MF2_MASK,
  PseudoVFWCVT_XU_F_V_MF4,
  PseudoVFWCVT_XU_F_V_MF4_MASK,
  PseudoVFWCVT_X_F_V_M1,
  PseudoVFWCVT_X_F_V_M1_MASK,
  PseudoVFWCVT_X_F_V_M2,
  PseudoVFWCVT_X_F_V_M2_MASK,
  PseudoVFWCVT_X_F_V_M4,
  PseudoVFWCVT_X_F_V_M4_MASK,
  PseudoVFWCVT_X_F_V_MF2,
  PseudoVFWCVT_X_F_V_MF2_MASK,
  PseudoVFWCVT_X_F_V_MF4,
  PseudoVFWCVT_X_F_V_MF4_MASK,
  PseudoVFWMACCBF16_VFPR16_M1_E16,
  PseudoVFWMACCBF16_VFPR16_M1_E16_MASK,
  PseudoVFWMACCBF16_VFPR16_M2_E16,
  PseudoVFWMACCBF16_VFPR16_M2_E16_MASK,
  PseudoVFWMACCBF16_VFPR16_M4_E16,
  PseudoVFWMACCBF16_VFPR16_M4_E16_MASK,
  PseudoVFWMACCBF16_VFPR16_MF2_E16,
  PseudoVFWMACCBF16_VFPR16_MF2_E16_MASK,
  PseudoVFWMACCBF16_VFPR16_MF4_E16,
  PseudoVFWMACCBF16_VFPR16_MF4_E16_MASK,
  PseudoVFWMACCBF16_VV_M1_E16,
  PseudoVFWMACCBF16_VV_M1_E16_MASK,
  PseudoVFWMACCBF16_VV_M1_E32,
  PseudoVFWMACCBF16_VV_M1_E32_MASK,
  PseudoVFWMACCBF16_VV_M2_E16,
  PseudoVFWMACCBF16_VV_M2_E16_MASK,
  PseudoVFWMACCBF16_VV_M2_E32,
  PseudoVFWMACCBF16_VV_M2_E32_MASK,
  PseudoVFWMACCBF16_VV_M4_E16,
  PseudoVFWMACCBF16_VV_M4_E16_MASK,
  PseudoVFWMACCBF16_VV_M4_E32,
  PseudoVFWMACCBF16_VV_M4_E32_MASK,
  PseudoVFWMACCBF16_VV_MF2_E16,
  PseudoVFWMACCBF16_VV_MF2_E16_MASK,
  PseudoVFWMACCBF16_VV_MF2_E32,
  PseudoVFWMACCBF16_VV_MF2_E32_MASK,
  PseudoVFWMACCBF16_VV_MF4_E16,
  PseudoVFWMACCBF16_VV_MF4_E16_MASK,
  PseudoVFWMACC_4x4x4_M1,
  PseudoVFWMACC_4x4x4_M2,
  PseudoVFWMACC_4x4x4_M4,
  PseudoVFWMACC_4x4x4_M8,
  PseudoVFWMACC_4x4x4_MF2,
  PseudoVFWMACC_4x4x4_MF4,
  PseudoVFWMACC_VFPR16_M1_E16,
  PseudoVFWMACC_VFPR16_M1_E16_MASK,
  PseudoVFWMACC_VFPR16_M2_E16,
  PseudoVFWMACC_VFPR16_M2_E16_MASK,
  PseudoVFWMACC_VFPR16_M4_E16,
  PseudoVFWMACC_VFPR16_M4_E16_MASK,
  PseudoVFWMACC_VFPR16_MF2_E16,
  PseudoVFWMACC_VFPR16_MF2_E16_MASK,
  PseudoVFWMACC_VFPR16_MF4_E16,
  PseudoVFWMACC_VFPR16_MF4_E16_MASK,
  PseudoVFWMACC_VFPR32_M1_E32,
  PseudoVFWMACC_VFPR32_M1_E32_MASK,
  PseudoVFWMACC_VFPR32_M2_E32,
  PseudoVFWMACC_VFPR32_M2_E32_MASK,
  PseudoVFWMACC_VFPR32_M4_E32,
  PseudoVFWMACC_VFPR32_M4_E32_MASK,
  PseudoVFWMACC_VFPR32_MF2_E32,
  PseudoVFWMACC_VFPR32_MF2_E32_MASK,
  PseudoVFWMACC_VV_M1_E16,
  PseudoVFWMACC_VV_M1_E16_MASK,
  PseudoVFWMACC_VV_M1_E32,
  PseudoVFWMACC_VV_M1_E32_MASK,
  PseudoVFWMACC_VV_M2_E16,
  PseudoVFWMACC_VV_M2_E16_MASK,
  PseudoVFWMACC_VV_M2_E32,
  PseudoVFWMACC_VV_M2_E32_MASK,
  PseudoVFWMACC_VV_M4_E16,
  PseudoVFWMACC_VV_M4_E16_MASK,
  PseudoVFWMACC_VV_M4_E32,
  PseudoVFWMACC_VV_M4_E32_MASK,
  PseudoVFWMACC_VV_MF2_E16,
  PseudoVFWMACC_VV_MF2_E16_MASK,
  PseudoVFWMACC_VV_MF2_E32,
  PseudoVFWMACC_VV_MF2_E32_MASK,
  PseudoVFWMACC_VV_MF4_E16,
  PseudoVFWMACC_VV_MF4_E16_MASK,
  PseudoVFWMSAC_VFPR16_M1_E16,
  PseudoVFWMSAC_VFPR16_M1_E16_MASK,
  PseudoVFWMSAC_VFPR16_M2_E16,
  PseudoVFWMSAC_VFPR16_M2_E16_MASK,
  PseudoVFWMSAC_VFPR16_M4_E16,
  PseudoVFWMSAC_VFPR16_M4_E16_MASK,
  PseudoVFWMSAC_VFPR16_MF2_E16,
  PseudoVFWMSAC_VFPR16_MF2_E16_MASK,
  PseudoVFWMSAC_VFPR16_MF4_E16,
  PseudoVFWMSAC_VFPR16_MF4_E16_MASK,
  PseudoVFWMSAC_VFPR32_M1_E32,
  PseudoVFWMSAC_VFPR32_M1_E32_MASK,
  PseudoVFWMSAC_VFPR32_M2_E32,
  PseudoVFWMSAC_VFPR32_M2_E32_MASK,
  PseudoVFWMSAC_VFPR32_M4_E32,
  PseudoVFWMSAC_VFPR32_M4_E32_MASK,
  PseudoVFWMSAC_VFPR32_MF2_E32,
  PseudoVFWMSAC_VFPR32_MF2_E32_MASK,
  PseudoVFWMSAC_VV_M1_E16,
  PseudoVFWMSAC_VV_M1_E16_MASK,
  PseudoVFWMSAC_VV_M1_E32,
  PseudoVFWMSAC_VV_M1_E32_MASK,
  PseudoVFWMSAC_VV_M2_E16,
  PseudoVFWMSAC_VV_M2_E16_MASK,
  PseudoVFWMSAC_VV_M2_E32,
  PseudoVFWMSAC_VV_M2_E32_MASK,
  PseudoVFWMSAC_VV_M4_E16,
  PseudoVFWMSAC_VV_M4_E16_MASK,
  PseudoVFWMSAC_VV_M4_E32,
  PseudoVFWMSAC_VV_M4_E32_MASK,
  PseudoVFWMSAC_VV_MF2_E16,
  PseudoVFWMSAC_VV_MF2_E16_MASK,
  PseudoVFWMSAC_VV_MF2_E32,
  PseudoVFWMSAC_VV_MF2_E32_MASK,
  PseudoVFWMSAC_VV_MF4_E16,
  PseudoVFWMSAC_VV_MF4_E16_MASK,
  PseudoVFWMUL_VFPR16_M1_E16,
  PseudoVFWMUL_VFPR16_M1_E16_MASK,
  PseudoVFWMUL_VFPR16_M2_E16,
  PseudoVFWMUL_VFPR16_M2_E16_MASK,
  PseudoVFWMUL_VFPR16_M4_E16,
  PseudoVFWMUL_VFPR16_M4_E16_MASK,
  PseudoVFWMUL_VFPR16_MF2_E16,
  PseudoVFWMUL_VFPR16_MF2_E16_MASK,
  PseudoVFWMUL_VFPR16_MF4_E16,
  PseudoVFWMUL_VFPR16_MF4_E16_MASK,
  PseudoVFWMUL_VFPR32_M1_E32,
  PseudoVFWMUL_VFPR32_M1_E32_MASK,
  PseudoVFWMUL_VFPR32_M2_E32,
  PseudoVFWMUL_VFPR32_M2_E32_MASK,
  PseudoVFWMUL_VFPR32_M4_E32,
  PseudoVFWMUL_VFPR32_M4_E32_MASK,
  PseudoVFWMUL_VFPR32_MF2_E32,
  PseudoVFWMUL_VFPR32_MF2_E32_MASK,
  PseudoVFWMUL_VV_M1_E16,
  PseudoVFWMUL_VV_M1_E16_MASK,
  PseudoVFWMUL_VV_M1_E32,
  PseudoVFWMUL_VV_M1_E32_MASK,
  PseudoVFWMUL_VV_M2_E16,
  PseudoVFWMUL_VV_M2_E16_MASK,
  PseudoVFWMUL_VV_M2_E32,
  PseudoVFWMUL_VV_M2_E32_MASK,
  PseudoVFWMUL_VV_M4_E16,
  PseudoVFWMUL_VV_M4_E16_MASK,
  PseudoVFWMUL_VV_M4_E32,
  PseudoVFWMUL_VV_M4_E32_MASK,
  PseudoVFWMUL_VV_MF2_E16,
  PseudoVFWMUL_VV_MF2_E16_MASK,
  PseudoVFWMUL_VV_MF2_E32,
  PseudoVFWMUL_VV_MF2_E32_MASK,
  PseudoVFWMUL_VV_MF4_E16,
  PseudoVFWMUL_VV_MF4_E16_MASK,
  PseudoVFWNMACC_VFPR16_M1_E16,
  PseudoVFWNMACC_VFPR16_M1_E16_MASK,
  PseudoVFWNMACC_VFPR16_M2_E16,
  PseudoVFWNMACC_VFPR16_M2_E16_MASK,
  PseudoVFWNMACC_VFPR16_M4_E16,
  PseudoVFWNMACC_VFPR16_M4_E16_MASK,
  PseudoVFWNMACC_VFPR16_MF2_E16,
  PseudoVFWNMACC_VFPR16_MF2_E16_MASK,
  PseudoVFWNMACC_VFPR16_MF4_E16,
  PseudoVFWNMACC_VFPR16_MF4_E16_MASK,
  PseudoVFWNMACC_VFPR32_M1_E32,
  PseudoVFWNMACC_VFPR32_M1_E32_MASK,
  PseudoVFWNMACC_VFPR32_M2_E32,
  PseudoVFWNMACC_VFPR32_M2_E32_MASK,
  PseudoVFWNMACC_VFPR32_M4_E32,
  PseudoVFWNMACC_VFPR32_M4_E32_MASK,
  PseudoVFWNMACC_VFPR32_MF2_E32,
  PseudoVFWNMACC_VFPR32_MF2_E32_MASK,
  PseudoVFWNMACC_VV_M1_E16,
  PseudoVFWNMACC_VV_M1_E16_MASK,
  PseudoVFWNMACC_VV_M1_E32,
  PseudoVFWNMACC_VV_M1_E32_MASK,
  PseudoVFWNMACC_VV_M2_E16,
  PseudoVFWNMACC_VV_M2_E16_MASK,
  PseudoVFWNMACC_VV_M2_E32,
  PseudoVFWNMACC_VV_M2_E32_MASK,
  PseudoVFWNMACC_VV_M4_E16,
  PseudoVFWNMACC_VV_M4_E16_MASK,
  PseudoVFWNMACC_VV_M4_E32,
  PseudoVFWNMACC_VV_M4_E32_MASK,
  PseudoVFWNMACC_VV_MF2_E16,
  PseudoVFWNMACC_VV_MF2_E16_MASK,
  PseudoVFWNMACC_VV_MF2_E32,
  PseudoVFWNMACC_VV_MF2_E32_MASK,
  PseudoVFWNMACC_VV_MF4_E16,
  PseudoVFWNMACC_VV_MF4_E16_MASK,
  PseudoVFWNMSAC_VFPR16_M1_E16,
  PseudoVFWNMSAC_VFPR16_M1_E16_MASK,
  PseudoVFWNMSAC_VFPR16_M2_E16,
  PseudoVFWNMSAC_VFPR16_M2_E16_MASK,
  PseudoVFWNMSAC_VFPR16_M4_E16,
  PseudoVFWNMSAC_VFPR16_M4_E16_MASK,
  PseudoVFWNMSAC_VFPR16_MF2_E16,
  PseudoVFWNMSAC_VFPR16_MF2_E16_MASK,
  PseudoVFWNMSAC_VFPR16_MF4_E16,
  PseudoVFWNMSAC_VFPR16_MF4_E16_MASK,
  PseudoVFWNMSAC_VFPR32_M1_E32,
  PseudoVFWNMSAC_VFPR32_M1_E32_MASK,
  PseudoVFWNMSAC_VFPR32_M2_E32,
  PseudoVFWNMSAC_VFPR32_M2_E32_MASK,
  PseudoVFWNMSAC_VFPR32_M4_E32,
  PseudoVFWNMSAC_VFPR32_M4_E32_MASK,
  PseudoVFWNMSAC_VFPR32_MF2_E32,
  PseudoVFWNMSAC_VFPR32_MF2_E32_MASK,
  PseudoVFWNMSAC_VV_M1_E16,
  PseudoVFWNMSAC_VV_M1_E16_MASK,
  PseudoVFWNMSAC_VV_M1_E32,
  PseudoVFWNMSAC_VV_M1_E32_MASK,
  PseudoVFWNMSAC_VV_M2_E16,
  PseudoVFWNMSAC_VV_M2_E16_MASK,
  PseudoVFWNMSAC_VV_M2_E32,
  PseudoVFWNMSAC_VV_M2_E32_MASK,
  PseudoVFWNMSAC_VV_M4_E16,
  PseudoVFWNMSAC_VV_M4_E16_MASK,
  PseudoVFWNMSAC_VV_M4_E32,
  PseudoVFWNMSAC_VV_M4_E32_MASK,
  PseudoVFWNMSAC_VV_MF2_E16,
  PseudoVFWNMSAC_VV_MF2_E16_MASK,
  PseudoVFWNMSAC_VV_MF2_E32,
  PseudoVFWNMSAC_VV_MF2_E32_MASK,
  PseudoVFWNMSAC_VV_MF4_E16,
  PseudoVFWNMSAC_VV_MF4_E16_MASK,
  PseudoVFWREDOSUM_VS_M1_E16,
  PseudoVFWREDOSUM_VS_M1_E16_MASK,
  PseudoVFWREDOSUM_VS_M1_E32,
  PseudoVFWREDOSUM_VS_M1_E32_MASK,
  PseudoVFWREDOSUM_VS_M2_E16,
  PseudoVFWREDOSUM_VS_M2_E16_MASK,
  PseudoVFWREDOSUM_VS_M2_E32,
  PseudoVFWREDOSUM_VS_M2_E32_MASK,
  PseudoVFWREDOSUM_VS_M4_E16,
  PseudoVFWREDOSUM_VS_M4_E16_MASK,
  PseudoVFWREDOSUM_VS_M4_E32,
  PseudoVFWREDOSUM_VS_M4_E32_MASK,
  PseudoVFWREDOSUM_VS_M8_E16,
  PseudoVFWREDOSUM_VS_M8_E16_MASK,
  PseudoVFWREDOSUM_VS_M8_E32,
  PseudoVFWREDOSUM_VS_M8_E32_MASK,
  PseudoVFWREDOSUM_VS_MF2_E16,
  PseudoVFWREDOSUM_VS_MF2_E16_MASK,
  PseudoVFWREDOSUM_VS_MF2_E32,
  PseudoVFWREDOSUM_VS_MF2_E32_MASK,
  PseudoVFWREDOSUM_VS_MF4_E16,
  PseudoVFWREDOSUM_VS_MF4_E16_MASK,
  PseudoVFWREDUSUM_VS_M1_E16,
  PseudoVFWREDUSUM_VS_M1_E16_MASK,
  PseudoVFWREDUSUM_VS_M1_E32,
  PseudoVFWREDUSUM_VS_M1_E32_MASK,
  PseudoVFWREDUSUM_VS_M2_E16,
  PseudoVFWREDUSUM_VS_M2_E16_MASK,
  PseudoVFWREDUSUM_VS_M2_E32,
  PseudoVFWREDUSUM_VS_M2_E32_MASK,
  PseudoVFWREDUSUM_VS_M4_E16,
  PseudoVFWREDUSUM_VS_M4_E16_MASK,
  PseudoVFWREDUSUM_VS_M4_E32,
  PseudoVFWREDUSUM_VS_M4_E32_MASK,
  PseudoVFWREDUSUM_VS_M8_E16,
  PseudoVFWREDUSUM_VS_M8_E16_MASK,
  PseudoVFWREDUSUM_VS_M8_E32,
  PseudoVFWREDUSUM_VS_M8_E32_MASK,
  PseudoVFWREDUSUM_VS_MF2_E16,
  PseudoVFWREDUSUM_VS_MF2_E16_MASK,
  PseudoVFWREDUSUM_VS_MF2_E32,
  PseudoVFWREDUSUM_VS_MF2_E32_MASK,
  PseudoVFWREDUSUM_VS_MF4_E16,
  PseudoVFWREDUSUM_VS_MF4_E16_MASK,
  PseudoVFWSUB_VFPR16_M1_E16,
  PseudoVFWSUB_VFPR16_M1_E16_MASK,
  PseudoVFWSUB_VFPR16_M2_E16,
  PseudoVFWSUB_VFPR16_M2_E16_MASK,
  PseudoVFWSUB_VFPR16_M4_E16,
  PseudoVFWSUB_VFPR16_M4_E16_MASK,
  PseudoVFWSUB_VFPR16_MF2_E16,
  PseudoVFWSUB_VFPR16_MF2_E16_MASK,
  PseudoVFWSUB_VFPR16_MF4_E16,
  PseudoVFWSUB_VFPR16_MF4_E16_MASK,
  PseudoVFWSUB_VFPR32_M1_E32,
  PseudoVFWSUB_VFPR32_M1_E32_MASK,
  PseudoVFWSUB_VFPR32_M2_E32,
  PseudoVFWSUB_VFPR32_M2_E32_MASK,
  PseudoVFWSUB_VFPR32_M4_E32,
  PseudoVFWSUB_VFPR32_M4_E32_MASK,
  PseudoVFWSUB_VFPR32_MF2_E32,
  PseudoVFWSUB_VFPR32_MF2_E32_MASK,
  PseudoVFWSUB_VV_M1_E16,
  PseudoVFWSUB_VV_M1_E16_MASK,
  PseudoVFWSUB_VV_M1_E32,
  PseudoVFWSUB_VV_M1_E32_MASK,
  PseudoVFWSUB_VV_M2_E16,
  PseudoVFWSUB_VV_M2_E16_MASK,
  PseudoVFWSUB_VV_M2_E32,
  PseudoVFWSUB_VV_M2_E32_MASK,
  PseudoVFWSUB_VV_M4_E16,
  PseudoVFWSUB_VV_M4_E16_MASK,
  PseudoVFWSUB_VV_M4_E32,
  PseudoVFWSUB_VV_M4_E32_MASK,
  PseudoVFWSUB_VV_MF2_E16,
  PseudoVFWSUB_VV_MF2_E16_MASK,
  PseudoVFWSUB_VV_MF2_E32,
  PseudoVFWSUB_VV_MF2_E32_MASK,
  PseudoVFWSUB_VV_MF4_E16,
  PseudoVFWSUB_VV_MF4_E16_MASK,
  PseudoVFWSUB_WFPR16_M1_E16,
  PseudoVFWSUB_WFPR16_M1_E16_MASK,
  PseudoVFWSUB_WFPR16_M2_E16,
  PseudoVFWSUB_WFPR16_M2_E16_MASK,
  PseudoVFWSUB_WFPR16_M4_E16,
  PseudoVFWSUB_WFPR16_M4_E16_MASK,
  PseudoVFWSUB_WFPR16_MF2_E16,
  PseudoVFWSUB_WFPR16_MF2_E16_MASK,
  PseudoVFWSUB_WFPR16_MF4_E16,
  PseudoVFWSUB_WFPR16_MF4_E16_MASK,
  PseudoVFWSUB_WFPR32_M1_E32,
  PseudoVFWSUB_WFPR32_M1_E32_MASK,
  PseudoVFWSUB_WFPR32_M2_E32,
  PseudoVFWSUB_WFPR32_M2_E32_MASK,
  PseudoVFWSUB_WFPR32_M4_E32,
  PseudoVFWSUB_WFPR32_M4_E32_MASK,
  PseudoVFWSUB_WFPR32_MF2_E32,
  PseudoVFWSUB_WFPR32_MF2_E32_MASK,
  PseudoVFWSUB_WV_M1_E16,
  PseudoVFWSUB_WV_M1_E16_MASK,
  PseudoVFWSUB_WV_M1_E16_MASK_TIED,
  PseudoVFWSUB_WV_M1_E16_TIED,
  PseudoVFWSUB_WV_M1_E32,
  PseudoVFWSUB_WV_M1_E32_MASK,
  PseudoVFWSUB_WV_M1_E32_MASK_TIED,
  PseudoVFWSUB_WV_M1_E32_TIED,
  PseudoVFWSUB_WV_M2_E16,
  PseudoVFWSUB_WV_M2_E16_MASK,
  PseudoVFWSUB_WV_M2_E16_MASK_TIED,
  PseudoVFWSUB_WV_M2_E16_TIED,
  PseudoVFWSUB_WV_M2_E32,
  PseudoVFWSUB_WV_M2_E32_MASK,
  PseudoVFWSUB_WV_M2_E32_MASK_TIED,
  PseudoVFWSUB_WV_M2_E32_TIED,
  PseudoVFWSUB_WV_M4_E16,
  PseudoVFWSUB_WV_M4_E16_MASK,
  PseudoVFWSUB_WV_M4_E16_MASK_TIED,
  PseudoVFWSUB_WV_M4_E16_TIED,
  PseudoVFWSUB_WV_M4_E32,
  PseudoVFWSUB_WV_M4_E32_MASK,
  PseudoVFWSUB_WV_M4_E32_MASK_TIED,
  PseudoVFWSUB_WV_M4_E32_TIED,
  PseudoVFWSUB_WV_MF2_E16,
  PseudoVFWSUB_WV_MF2_E16_MASK,
  PseudoVFWSUB_WV_MF2_E16_MASK_TIED,
  PseudoVFWSUB_WV_MF2_E16_TIED,
  PseudoVFWSUB_WV_MF2_E32,
  PseudoVFWSUB_WV_MF2_E32_MASK,
  PseudoVFWSUB_WV_MF2_E32_MASK_TIED,
  PseudoVFWSUB_WV_MF2_E32_TIED,
  PseudoVFWSUB_WV_MF4_E16,
  PseudoVFWSUB_WV_MF4_E16_MASK,
  PseudoVFWSUB_WV_MF4_E16_MASK_TIED,
  PseudoVFWSUB_WV_MF4_E16_TIED,
  PseudoVGHSH_VV_M1,
  PseudoVGHSH_VV_M2,
  PseudoVGHSH_VV_M4,
  PseudoVGHSH_VV_M8,
  PseudoVGHSH_VV_MF2,
  PseudoVGMUL_VV_M1,
  PseudoVGMUL_VV_M2,
  PseudoVGMUL_VV_M4,
  PseudoVGMUL_VV_M8,
  PseudoVGMUL_VV_MF2,
  PseudoVID_V_M1,
  PseudoVID_V_M1_MASK,
  PseudoVID_V_M2,
  PseudoVID_V_M2_MASK,
  PseudoVID_V_M4,
  PseudoVID_V_M4_MASK,
  PseudoVID_V_M8,
  PseudoVID_V_M8_MASK,
  PseudoVID_V_MF2,
  PseudoVID_V_MF2_MASK,
  PseudoVID_V_MF4,
  PseudoVID_V_MF4_MASK,
  PseudoVID_V_MF8,
  PseudoVID_V_MF8_MASK,
  PseudoVIOTA_M_M1,
  PseudoVIOTA_M_M1_MASK,
  PseudoVIOTA_M_M2,
  PseudoVIOTA_M_M2_MASK,
  PseudoVIOTA_M_M4,
  PseudoVIOTA_M_M4_MASK,
  PseudoVIOTA_M_M8,
  PseudoVIOTA_M_M8_MASK,
  PseudoVIOTA_M_MF2,
  PseudoVIOTA_M_MF2_MASK,
  PseudoVIOTA_M_MF4,
  PseudoVIOTA_M_MF4_MASK,
  PseudoVIOTA_M_MF8,
  PseudoVIOTA_M_MF8_MASK,
  PseudoVLE16FF_V_M1,
  PseudoVLE16FF_V_M1_MASK,
  PseudoVLE16FF_V_M2,
  PseudoVLE16FF_V_M2_MASK,
  PseudoVLE16FF_V_M4,
  PseudoVLE16FF_V_M4_MASK,
  PseudoVLE16FF_V_M8,
  PseudoVLE16FF_V_M8_MASK,
  PseudoVLE16FF_V_MF2,
  PseudoVLE16FF_V_MF2_MASK,
  PseudoVLE16FF_V_MF4,
  PseudoVLE16FF_V_MF4_MASK,
  PseudoVLE16_V_M1,
  PseudoVLE16_V_M1_MASK,
  PseudoVLE16_V_M2,
  PseudoVLE16_V_M2_MASK,
  PseudoVLE16_V_M4,
  PseudoVLE16_V_M4_MASK,
  PseudoVLE16_V_M8,
  PseudoVLE16_V_M8_MASK,
  PseudoVLE16_V_MF2,
  PseudoVLE16_V_MF2_MASK,
  PseudoVLE16_V_MF4,
  PseudoVLE16_V_MF4_MASK,
  PseudoVLE32FF_V_M1,
  PseudoVLE32FF_V_M1_MASK,
  PseudoVLE32FF_V_M2,
  PseudoVLE32FF_V_M2_MASK,
  PseudoVLE32FF_V_M4,
  PseudoVLE32FF_V_M4_MASK,
  PseudoVLE32FF_V_M8,
  PseudoVLE32FF_V_M8_MASK,
  PseudoVLE32FF_V_MF2,
  PseudoVLE32FF_V_MF2_MASK,
  PseudoVLE32_V_M1,
  PseudoVLE32_V_M1_MASK,
  PseudoVLE32_V_M2,
  PseudoVLE32_V_M2_MASK,
  PseudoVLE32_V_M4,
  PseudoVLE32_V_M4_MASK,
  PseudoVLE32_V_M8,
  PseudoVLE32_V_M8_MASK,
  PseudoVLE32_V_MF2,
  PseudoVLE32_V_MF2_MASK,
  PseudoVLE64FF_V_M1,
  PseudoVLE64FF_V_M1_MASK,
  PseudoVLE64FF_V_M2,
  PseudoVLE64FF_V_M2_MASK,
  PseudoVLE64FF_V_M4,
  PseudoVLE64FF_V_M4_MASK,
  PseudoVLE64FF_V_M8,
  PseudoVLE64FF_V_M8_MASK,
  PseudoVLE64_V_M1,
  PseudoVLE64_V_M1_MASK,
  PseudoVLE64_V_M2,
  PseudoVLE64_V_M2_MASK,
  PseudoVLE64_V_M4,
  PseudoVLE64_V_M4_MASK,
  PseudoVLE64_V_M8,
  PseudoVLE64_V_M8_MASK,
  PseudoVLE8FF_V_M1,
  PseudoVLE8FF_V_M1_MASK,
  PseudoVLE8FF_V_M2,
  PseudoVLE8FF_V_M2_MASK,
  PseudoVLE8FF_V_M4,
  PseudoVLE8FF_V_M4_MASK,
  PseudoVLE8FF_V_M8,
  PseudoVLE8FF_V_M8_MASK,
  PseudoVLE8FF_V_MF2,
  PseudoVLE8FF_V_MF2_MASK,
  PseudoVLE8FF_V_MF4,
  PseudoVLE8FF_V_MF4_MASK,
  PseudoVLE8FF_V_MF8,
  PseudoVLE8FF_V_MF8_MASK,
  PseudoVLE8_V_M1,
  PseudoVLE8_V_M1_MASK,
  PseudoVLE8_V_M2,
  PseudoVLE8_V_M2_MASK,
  PseudoVLE8_V_M4,
  PseudoVLE8_V_M4_MASK,
  PseudoVLE8_V_M8,
  PseudoVLE8_V_M8_MASK,
  PseudoVLE8_V_MF2,
  PseudoVLE8_V_MF2_MASK,
  PseudoVLE8_V_MF4,
  PseudoVLE8_V_MF4_MASK,
  PseudoVLE8_V_MF8,
  PseudoVLE8_V_MF8_MASK,
  PseudoVLM_V_B1,
  PseudoVLM_V_B16,
  PseudoVLM_V_B2,
  PseudoVLM_V_B32,
  PseudoVLM_V_B4,
  PseudoVLM_V_B64,
  PseudoVLM_V_B8,
  PseudoVLOXEI16_V_M1_M1,
  PseudoVLOXEI16_V_M1_M1_MASK,
  PseudoVLOXEI16_V_M1_M2,
  PseudoVLOXEI16_V_M1_M2_MASK,
  PseudoVLOXEI16_V_M1_M4,
  PseudoVLOXEI16_V_M1_M4_MASK,
  PseudoVLOXEI16_V_M1_MF2,
  PseudoVLOXEI16_V_M1_MF2_MASK,
  PseudoVLOXEI16_V_M2_M1,
  PseudoVLOXEI16_V_M2_M1_MASK,
  PseudoVLOXEI16_V_M2_M2,
  PseudoVLOXEI16_V_M2_M2_MASK,
  PseudoVLOXEI16_V_M2_M4,
  PseudoVLOXEI16_V_M2_M4_MASK,
  PseudoVLOXEI16_V_M2_M8,
  PseudoVLOXEI16_V_M2_M8_MASK,
  PseudoVLOXEI16_V_M4_M2,
  PseudoVLOXEI16_V_M4_M2_MASK,
  PseudoVLOXEI16_V_M4_M4,
  PseudoVLOXEI16_V_M4_M4_MASK,
  PseudoVLOXEI16_V_M4_M8,
  PseudoVLOXEI16_V_M4_M8_MASK,
  PseudoVLOXEI16_V_M8_M4,
  PseudoVLOXEI16_V_M8_M4_MASK,
  PseudoVLOXEI16_V_M8_M8,
  PseudoVLOXEI16_V_M8_M8_MASK,
  PseudoVLOXEI16_V_MF2_M1,
  PseudoVLOXEI16_V_MF2_M1_MASK,
  PseudoVLOXEI16_V_MF2_M2,
  PseudoVLOXEI16_V_MF2_M2_MASK,
  PseudoVLOXEI16_V_MF2_MF2,
  PseudoVLOXEI16_V_MF2_MF2_MASK,
  PseudoVLOXEI16_V_MF2_MF4,
  PseudoVLOXEI16_V_MF2_MF4_MASK,
  PseudoVLOXEI16_V_MF4_M1,
  PseudoVLOXEI16_V_MF4_M1_MASK,
  PseudoVLOXEI16_V_MF4_MF2,
  PseudoVLOXEI16_V_MF4_MF2_MASK,
  PseudoVLOXEI16_V_MF4_MF4,
  PseudoVLOXEI16_V_MF4_MF4_MASK,
  PseudoVLOXEI16_V_MF4_MF8,
  PseudoVLOXEI16_V_MF4_MF8_MASK,
  PseudoVLOXEI32_V_M1_M1,
  PseudoVLOXEI32_V_M1_M1_MASK,
  PseudoVLOXEI32_V_M1_M2,
  PseudoVLOXEI32_V_M1_M2_MASK,
  PseudoVLOXEI32_V_M1_MF2,
  PseudoVLOXEI32_V_M1_MF2_MASK,
  PseudoVLOXEI32_V_M1_MF4,
  PseudoVLOXEI32_V_M1_MF4_MASK,
  PseudoVLOXEI32_V_M2_M1,
  PseudoVLOXEI32_V_M2_M1_MASK,
  PseudoVLOXEI32_V_M2_M2,
  PseudoVLOXEI32_V_M2_M2_MASK,
  PseudoVLOXEI32_V_M2_M4,
  PseudoVLOXEI32_V_M2_M4_MASK,
  PseudoVLOXEI32_V_M2_MF2,
  PseudoVLOXEI32_V_M2_MF2_MASK,
  PseudoVLOXEI32_V_M4_M1,
  PseudoVLOXEI32_V_M4_M1_MASK,
  PseudoVLOXEI32_V_M4_M2,
  PseudoVLOXEI32_V_M4_M2_MASK,
  PseudoVLOXEI32_V_M4_M4,
  PseudoVLOXEI32_V_M4_M4_MASK,
  PseudoVLOXEI32_V_M4_M8,
  PseudoVLOXEI32_V_M4_M8_MASK,
  PseudoVLOXEI32_V_M8_M2,
  PseudoVLOXEI32_V_M8_M2_MASK,
  PseudoVLOXEI32_V_M8_M4,
  PseudoVLOXEI32_V_M8_M4_MASK,
  PseudoVLOXEI32_V_M8_M8,
  PseudoVLOXEI32_V_M8_M8_MASK,
  PseudoVLOXEI32_V_MF2_M1,
  PseudoVLOXEI32_V_MF2_M1_MASK,
  PseudoVLOXEI32_V_MF2_MF2,
  PseudoVLOXEI32_V_MF2_MF2_MASK,
  PseudoVLOXEI32_V_MF2_MF4,
  PseudoVLOXEI32_V_MF2_MF4_MASK,
  PseudoVLOXEI32_V_MF2_MF8,
  PseudoVLOXEI32_V_MF2_MF8_MASK,
  PseudoVLOXEI64_V_M1_M1,
  PseudoVLOXEI64_V_M1_M1_MASK,
  PseudoVLOXEI64_V_M1_MF2,
  PseudoVLOXEI64_V_M1_MF2_MASK,
  PseudoVLOXEI64_V_M1_MF4,
  PseudoVLOXEI64_V_M1_MF4_MASK,
  PseudoVLOXEI64_V_M1_MF8,
  PseudoVLOXEI64_V_M1_MF8_MASK,
  PseudoVLOXEI64_V_M2_M1,
  PseudoVLOXEI64_V_M2_M1_MASK,
  PseudoVLOXEI64_V_M2_M2,
  PseudoVLOXEI64_V_M2_M2_MASK,
  PseudoVLOXEI64_V_M2_MF2,
  PseudoVLOXEI64_V_M2_MF2_MASK,
  PseudoVLOXEI64_V_M2_MF4,
  PseudoVLOXEI64_V_M2_MF4_MASK,
  PseudoVLOXEI64_V_M4_M1,
  PseudoVLOXEI64_V_M4_M1_MASK,
  PseudoVLOXEI64_V_M4_M2,
  PseudoVLOXEI64_V_M4_M2_MASK,
  PseudoVLOXEI64_V_M4_M4,
  PseudoVLOXEI64_V_M4_M4_MASK,
  PseudoVLOXEI64_V_M4_MF2,
  PseudoVLOXEI64_V_M4_MF2_MASK,
  PseudoVLOXEI64_V_M8_M1,
  PseudoVLOXEI64_V_M8_M1_MASK,
  PseudoVLOXEI64_V_M8_M2,
  PseudoVLOXEI64_V_M8_M2_MASK,
  PseudoVLOXEI64_V_M8_M4,
  PseudoVLOXEI64_V_M8_M4_MASK,
  PseudoVLOXEI64_V_M8_M8,
  PseudoVLOXEI64_V_M8_M8_MASK,
  PseudoVLOXEI8_V_M1_M1,
  PseudoVLOXEI8_V_M1_M1_MASK,
  PseudoVLOXEI8_V_M1_M2,
  PseudoVLOXEI8_V_M1_M2_MASK,
  PseudoVLOXEI8_V_M1_M4,
  PseudoVLOXEI8_V_M1_M4_MASK,
  PseudoVLOXEI8_V_M1_M8,
  PseudoVLOXEI8_V_M1_M8_MASK,
  PseudoVLOXEI8_V_M2_M2,
  PseudoVLOXEI8_V_M2_M2_MASK,
  PseudoVLOXEI8_V_M2_M4,
  PseudoVLOXEI8_V_M2_M4_MASK,
  PseudoVLOXEI8_V_M2_M8,
  PseudoVLOXEI8_V_M2_M8_MASK,
  PseudoVLOXEI8_V_M4_M4,
  PseudoVLOXEI8_V_M4_M4_MASK,
  PseudoVLOXEI8_V_M4_M8,
  PseudoVLOXEI8_V_M4_M8_MASK,
  PseudoVLOXEI8_V_M8_M8,
  PseudoVLOXEI8_V_M8_M8_MASK,
  PseudoVLOXEI8_V_MF2_M1,
  PseudoVLOXEI8_V_MF2_M1_MASK,
  PseudoVLOXEI8_V_MF2_M2,
  PseudoVLOXEI8_V_MF2_M2_MASK,
  PseudoVLOXEI8_V_MF2_M4,
  PseudoVLOXEI8_V_MF2_M4_MASK,
  PseudoVLOXEI8_V_MF2_MF2,
  PseudoVLOXEI8_V_MF2_MF2_MASK,
  PseudoVLOXEI8_V_MF4_M1,
  PseudoVLOXEI8_V_MF4_M1_MASK,
  PseudoVLOXEI8_V_MF4_M2,
  PseudoVLOXEI8_V_MF4_M2_MASK,
  PseudoVLOXEI8_V_MF4_MF2,
  PseudoVLOXEI8_V_MF4_MF2_MASK,
  PseudoVLOXEI8_V_MF4_MF4,
  PseudoVLOXEI8_V_MF4_MF4_MASK,
  PseudoVLOXEI8_V_MF8_M1,
  PseudoVLOXEI8_V_MF8_M1_MASK,
  PseudoVLOXEI8_V_MF8_MF2,
  PseudoVLOXEI8_V_MF8_MF2_MASK,
  PseudoVLOXEI8_V_MF8_MF4,
  PseudoVLOXEI8_V_MF8_MF4_MASK,
  PseudoVLOXEI8_V_MF8_MF8,
  PseudoVLOXEI8_V_MF8_MF8_MASK,
  PseudoVLOXSEG2EI16_V_M1_M1,
  PseudoVLOXSEG2EI16_V_M1_M1_MASK,
  PseudoVLOXSEG2EI16_V_M1_M2,
  PseudoVLOXSEG2EI16_V_M1_M2_MASK,
  PseudoVLOXSEG2EI16_V_M1_M4,
  PseudoVLOXSEG2EI16_V_M1_M4_MASK,
  PseudoVLOXSEG2EI16_V_M1_MF2,
  PseudoVLOXSEG2EI16_V_M1_MF2_MASK,
  PseudoVLOXSEG2EI16_V_M2_M1,
  PseudoVLOXSEG2EI16_V_M2_M1_MASK,
  PseudoVLOXSEG2EI16_V_M2_M2,
  PseudoVLOXSEG2EI16_V_M2_M2_MASK,
  PseudoVLOXSEG2EI16_V_M2_M4,
  PseudoVLOXSEG2EI16_V_M2_M4_MASK,
  PseudoVLOXSEG2EI16_V_M4_M2,
  PseudoVLOXSEG2EI16_V_M4_M2_MASK,
  PseudoVLOXSEG2EI16_V_M4_M4,
  PseudoVLOXSEG2EI16_V_M4_M4_MASK,
  PseudoVLOXSEG2EI16_V_M8_M4,
  PseudoVLOXSEG2EI16_V_M8_M4_MASK,
  PseudoVLOXSEG2EI16_V_MF2_M1,
  PseudoVLOXSEG2EI16_V_MF2_M1_MASK,
  PseudoVLOXSEG2EI16_V_MF2_M2,
  PseudoVLOXSEG2EI16_V_MF2_M2_MASK,
  PseudoVLOXSEG2EI16_V_MF2_MF2,
  PseudoVLOXSEG2EI16_V_MF2_MF2_MASK,
  PseudoVLOXSEG2EI16_V_MF2_MF4,
  PseudoVLOXSEG2EI16_V_MF2_MF4_MASK,
  PseudoVLOXSEG2EI16_V_MF4_M1,
  PseudoVLOXSEG2EI16_V_MF4_M1_MASK,
  PseudoVLOXSEG2EI16_V_MF4_MF2,
  PseudoVLOXSEG2EI16_V_MF4_MF2_MASK,
  PseudoVLOXSEG2EI16_V_MF4_MF4,
  PseudoVLOXSEG2EI16_V_MF4_MF4_MASK,
  PseudoVLOXSEG2EI16_V_MF4_MF8,
  PseudoVLOXSEG2EI16_V_MF4_MF8_MASK,
  PseudoVLOXSEG2EI32_V_M1_M1,
  PseudoVLOXSEG2EI32_V_M1_M1_MASK,
  PseudoVLOXSEG2EI32_V_M1_M2,
  PseudoVLOXSEG2EI32_V_M1_M2_MASK,
  PseudoVLOXSEG2EI32_V_M1_MF2,
  PseudoVLOXSEG2EI32_V_M1_MF2_MASK,
  PseudoVLOXSEG2EI32_V_M1_MF4,
  PseudoVLOXSEG2EI32_V_M1_MF4_MASK,
  PseudoVLOXSEG2EI32_V_M2_M1,
  PseudoVLOXSEG2EI32_V_M2_M1_MASK,
  PseudoVLOXSEG2EI32_V_M2_M2,
  PseudoVLOXSEG2EI32_V_M2_M2_MASK,
  PseudoVLOXSEG2EI32_V_M2_M4,
  PseudoVLOXSEG2EI32_V_M2_M4_MASK,
  PseudoVLOXSEG2EI32_V_M2_MF2,
  PseudoVLOXSEG2EI32_V_M2_MF2_MASK,
  PseudoVLOXSEG2EI32_V_M4_M1,
  PseudoVLOXSEG2EI32_V_M4_M1_MASK,
  PseudoVLOXSEG2EI32_V_M4_M2,
  PseudoVLOXSEG2EI32_V_M4_M2_MASK,
  PseudoVLOXSEG2EI32_V_M4_M4,
  PseudoVLOXSEG2EI32_V_M4_M4_MASK,
  PseudoVLOXSEG2EI32_V_M8_M2,
  PseudoVLOXSEG2EI32_V_M8_M2_MASK,
  PseudoVLOXSEG2EI32_V_M8_M4,
  PseudoVLOXSEG2EI32_V_M8_M4_MASK,
  PseudoVLOXSEG2EI32_V_MF2_M1,
  PseudoVLOXSEG2EI32_V_MF2_M1_MASK,
  PseudoVLOXSEG2EI32_V_MF2_MF2,
  PseudoVLOXSEG2EI32_V_MF2_MF2_MASK,
  PseudoVLOXSEG2EI32_V_MF2_MF4,
  PseudoVLOXSEG2EI32_V_MF2_MF4_MASK,
  PseudoVLOXSEG2EI32_V_MF2_MF8,
  PseudoVLOXSEG2EI32_V_MF2_MF8_MASK,
  PseudoVLOXSEG2EI64_V_M1_M1,
  PseudoVLOXSEG2EI64_V_M1_M1_MASK,
  PseudoVLOXSEG2EI64_V_M1_MF2,
  PseudoVLOXSEG2EI64_V_M1_MF2_MASK,
  PseudoVLOXSEG2EI64_V_M1_MF4,
  PseudoVLOXSEG2EI64_V_M1_MF4_MASK,
  PseudoVLOXSEG2EI64_V_M1_MF8,
  PseudoVLOXSEG2EI64_V_M1_MF8_MASK,
  PseudoVLOXSEG2EI64_V_M2_M1,
  PseudoVLOXSEG2EI64_V_M2_M1_MASK,
  PseudoVLOXSEG2EI64_V_M2_M2,
  PseudoVLOXSEG2EI64_V_M2_M2_MASK,
  PseudoVLOXSEG2EI64_V_M2_MF2,
  PseudoVLOXSEG2EI64_V_M2_MF2_MASK,
  PseudoVLOXSEG2EI64_V_M2_MF4,
  PseudoVLOXSEG2EI64_V_M2_MF4_MASK,
  PseudoVLOXSEG2EI64_V_M4_M1,
  PseudoVLOXSEG2EI64_V_M4_M1_MASK,
  PseudoVLOXSEG2EI64_V_M4_M2,
  PseudoVLOXSEG2EI64_V_M4_M2_MASK,
  PseudoVLOXSEG2EI64_V_M4_M4,
  PseudoVLOXSEG2EI64_V_M4_M4_MASK,
  PseudoVLOXSEG2EI64_V_M4_MF2,
  PseudoVLOXSEG2EI64_V_M4_MF2_MASK,
  PseudoVLOXSEG2EI64_V_M8_M1,
  PseudoVLOXSEG2EI64_V_M8_M1_MASK,
  PseudoVLOXSEG2EI64_V_M8_M2,
  PseudoVLOXSEG2EI64_V_M8_M2_MASK,
  PseudoVLOXSEG2EI64_V_M8_M4,
  PseudoVLOXSEG2EI64_V_M8_M4_MASK,
  PseudoVLOXSEG2EI8_V_M1_M1,
  PseudoVLOXSEG2EI8_V_M1_M1_MASK,
  PseudoVLOXSEG2EI8_V_M1_M2,
  PseudoVLOXSEG2EI8_V_M1_M2_MASK,
  PseudoVLOXSEG2EI8_V_M1_M4,
  PseudoVLOXSEG2EI8_V_M1_M4_MASK,
  PseudoVLOXSEG2EI8_V_M2_M2,
  PseudoVLOXSEG2EI8_V_M2_M2_MASK,
  PseudoVLOXSEG2EI8_V_M2_M4,
  PseudoVLOXSEG2EI8_V_M2_M4_MASK,
  PseudoVLOXSEG2EI8_V_M4_M4,
  PseudoVLOXSEG2EI8_V_M4_M4_MASK,
  PseudoVLOXSEG2EI8_V_MF2_M1,
  PseudoVLOXSEG2EI8_V_MF2_M1_MASK,
  PseudoVLOXSEG2EI8_V_MF2_M2,
  PseudoVLOXSEG2EI8_V_MF2_M2_MASK,
  PseudoVLOXSEG2EI8_V_MF2_M4,
  PseudoVLOXSEG2EI8_V_MF2_M4_MASK,
  PseudoVLOXSEG2EI8_V_MF2_MF2,
  PseudoVLOXSEG2EI8_V_MF2_MF2_MASK,
  PseudoVLOXSEG2EI8_V_MF4_M1,
  PseudoVLOXSEG2EI8_V_MF4_M1_MASK,
  PseudoVLOXSEG2EI8_V_MF4_M2,
  PseudoVLOXSEG2EI8_V_MF4_M2_MASK,
  PseudoVLOXSEG2EI8_V_MF4_MF2,
  PseudoVLOXSEG2EI8_V_MF4_MF2_MASK,
  PseudoVLOXSEG2EI8_V_MF4_MF4,
  PseudoVLOXSEG2EI8_V_MF4_MF4_MASK,
  PseudoVLOXSEG2EI8_V_MF8_M1,
  PseudoVLOXSEG2EI8_V_MF8_M1_MASK,
  PseudoVLOXSEG2EI8_V_MF8_MF2,
  PseudoVLOXSEG2EI8_V_MF8_MF2_MASK,
  PseudoVLOXSEG2EI8_V_MF8_MF4,
  PseudoVLOXSEG2EI8_V_MF8_MF4_MASK,
  PseudoVLOXSEG2EI8_V_MF8_MF8,
  PseudoVLOXSEG2EI8_V_MF8_MF8_MASK,
  PseudoVLOXSEG3EI16_V_M1_M1,
  PseudoVLOXSEG3EI16_V_M1_M1_MASK,
  PseudoVLOXSEG3EI16_V_M1_M2,
  PseudoVLOXSEG3EI16_V_M1_M2_MASK,
  PseudoVLOXSEG3EI16_V_M1_MF2,
  PseudoVLOXSEG3EI16_V_M1_MF2_MASK,
  PseudoVLOXSEG3EI16_V_M2_M1,
  PseudoVLOXSEG3EI16_V_M2_M1_MASK,
  PseudoVLOXSEG3EI16_V_M2_M2,
  PseudoVLOXSEG3EI16_V_M2_M2_MASK,
  PseudoVLOXSEG3EI16_V_M4_M2,
  PseudoVLOXSEG3EI16_V_M4_M2_MASK,
  PseudoVLOXSEG3EI16_V_MF2_M1,
  PseudoVLOXSEG3EI16_V_MF2_M1_MASK,
  PseudoVLOXSEG3EI16_V_MF2_M2,
  PseudoVLOXSEG3EI16_V_MF2_M2_MASK,
  PseudoVLOXSEG3EI16_V_MF2_MF2,
  PseudoVLOXSEG3EI16_V_MF2_MF2_MASK,
  PseudoVLOXSEG3EI16_V_MF2_MF4,
  PseudoVLOXSEG3EI16_V_MF2_MF4_MASK,
  PseudoVLOXSEG3EI16_V_MF4_M1,
  PseudoVLOXSEG3EI16_V_MF4_M1_MASK,
  PseudoVLOXSEG3EI16_V_MF4_MF2,
  PseudoVLOXSEG3EI16_V_MF4_MF2_MASK,
  PseudoVLOXSEG3EI16_V_MF4_MF4,
  PseudoVLOXSEG3EI16_V_MF4_MF4_MASK,
  PseudoVLOXSEG3EI16_V_MF4_MF8,
  PseudoVLOXSEG3EI16_V_MF4_MF8_MASK,
  PseudoVLOXSEG3EI32_V_M1_M1,
  PseudoVLOXSEG3EI32_V_M1_M1_MASK,
  PseudoVLOXSEG3EI32_V_M1_M2,
  PseudoVLOXSEG3EI32_V_M1_M2_MASK,
  PseudoVLOXSEG3EI32_V_M1_MF2,
  PseudoVLOXSEG3EI32_V_M1_MF2_MASK,
  PseudoVLOXSEG3EI32_V_M1_MF4,
  PseudoVLOXSEG3EI32_V_M1_MF4_MASK,
  PseudoVLOXSEG3EI32_V_M2_M1,
  PseudoVLOXSEG3EI32_V_M2_M1_MASK,
  PseudoVLOXSEG3EI32_V_M2_M2,
  PseudoVLOXSEG3EI32_V_M2_M2_MASK,
  PseudoVLOXSEG3EI32_V_M2_MF2,
  PseudoVLOXSEG3EI32_V_M2_MF2_MASK,
  PseudoVLOXSEG3EI32_V_M4_M1,
  PseudoVLOXSEG3EI32_V_M4_M1_MASK,
  PseudoVLOXSEG3EI32_V_M4_M2,
  PseudoVLOXSEG3EI32_V_M4_M2_MASK,
  PseudoVLOXSEG3EI32_V_M8_M2,
  PseudoVLOXSEG3EI32_V_M8_M2_MASK,
  PseudoVLOXSEG3EI32_V_MF2_M1,
  PseudoVLOXSEG3EI32_V_MF2_M1_MASK,
  PseudoVLOXSEG3EI32_V_MF2_MF2,
  PseudoVLOXSEG3EI32_V_MF2_MF2_MASK,
  PseudoVLOXSEG3EI32_V_MF2_MF4,
  PseudoVLOXSEG3EI32_V_MF2_MF4_MASK,
  PseudoVLOXSEG3EI32_V_MF2_MF8,
  PseudoVLOXSEG3EI32_V_MF2_MF8_MASK,
  PseudoVLOXSEG3EI64_V_M1_M1,
  PseudoVLOXSEG3EI64_V_M1_M1_MASK,
  PseudoVLOXSEG3EI64_V_M1_MF2,
  PseudoVLOXSEG3EI64_V_M1_MF2_MASK,
  PseudoVLOXSEG3EI64_V_M1_MF4,
  PseudoVLOXSEG3EI64_V_M1_MF4_MASK,
  PseudoVLOXSEG3EI64_V_M1_MF8,
  PseudoVLOXSEG3EI64_V_M1_MF8_MASK,
  PseudoVLOXSEG3EI64_V_M2_M1,
  PseudoVLOXSEG3EI64_V_M2_M1_MASK,
  PseudoVLOXSEG3EI64_V_M2_M2,
  PseudoVLOXSEG3EI64_V_M2_M2_MASK,
  PseudoVLOXSEG3EI64_V_M2_MF2,
  PseudoVLOXSEG3EI64_V_M2_MF2_MASK,
  PseudoVLOXSEG3EI64_V_M2_MF4,
  PseudoVLOXSEG3EI64_V_M2_MF4_MASK,
  PseudoVLOXSEG3EI64_V_M4_M1,
  PseudoVLOXSEG3EI64_V_M4_M1_MASK,
  PseudoVLOXSEG3EI64_V_M4_M2,
  PseudoVLOXSEG3EI64_V_M4_M2_MASK,
  PseudoVLOXSEG3EI64_V_M4_MF2,
  PseudoVLOXSEG3EI64_V_M4_MF2_MASK,
  PseudoVLOXSEG3EI64_V_M8_M1,
  PseudoVLOXSEG3EI64_V_M8_M1_MASK,
  PseudoVLOXSEG3EI64_V_M8_M2,
  PseudoVLOXSEG3EI64_V_M8_M2_MASK,
  PseudoVLOXSEG3EI8_V_M1_M1,
  PseudoVLOXSEG3EI8_V_M1_M1_MASK,
  PseudoVLOXSEG3EI8_V_M1_M2,
  PseudoVLOXSEG3EI8_V_M1_M2_MASK,
  PseudoVLOXSEG3EI8_V_M2_M2,
  PseudoVLOXSEG3EI8_V_M2_M2_MASK,
  PseudoVLOXSEG3EI8_V_MF2_M1,
  PseudoVLOXSEG3EI8_V_MF2_M1_MASK,
  PseudoVLOXSEG3EI8_V_MF2_M2,
  PseudoVLOXSEG3EI8_V_MF2_M2_MASK,
  PseudoVLOXSEG3EI8_V_MF2_MF2,
  PseudoVLOXSEG3EI8_V_MF2_MF2_MASK,
  PseudoVLOXSEG3EI8_V_MF4_M1,
  PseudoVLOXSEG3EI8_V_MF4_M1_MASK,
  PseudoVLOXSEG3EI8_V_MF4_M2,
  PseudoVLOXSEG3EI8_V_MF4_M2_MASK,
  PseudoVLOXSEG3EI8_V_MF4_MF2,
  PseudoVLOXSEG3EI8_V_MF4_MF2_MASK,
  PseudoVLOXSEG3EI8_V_MF4_MF4,
  PseudoVLOXSEG3EI8_V_MF4_MF4_MASK,
  PseudoVLOXSEG3EI8_V_MF8_M1,
  PseudoVLOXSEG3EI8_V_MF8_M1_MASK,
  PseudoVLOXSEG3EI8_V_MF8_MF2,
  PseudoVLOXSEG3EI8_V_MF8_MF2_MASK,
  PseudoVLOXSEG3EI8_V_MF8_MF4,
  PseudoVLOXSEG3EI8_V_MF8_MF4_MASK,
  PseudoVLOXSEG3EI8_V_MF8_MF8,
  PseudoVLOXSEG3EI8_V_MF8_MF8_MASK,
  PseudoVLOXSEG4EI16_V_M1_M1,
  PseudoVLOXSEG4EI16_V_M1_M1_MASK,
  PseudoVLOXSEG4EI16_V_M1_M2,
  PseudoVLOXSEG4EI16_V_M1_M2_MASK,
  PseudoVLOXSEG4EI16_V_M1_MF2,
  PseudoVLOXSEG4EI16_V_M1_MF2_MASK,
  PseudoVLOXSEG4EI16_V_M2_M1,
  PseudoVLOXSEG4EI16_V_M2_M1_MASK,
  PseudoVLOXSEG4EI16_V_M2_M2,
  PseudoVLOXSEG4EI16_V_M2_M2_MASK,
  PseudoVLOXSEG4EI16_V_M4_M2,
  PseudoVLOXSEG4EI16_V_M4_M2_MASK,
  PseudoVLOXSEG4EI16_V_MF2_M1,
  PseudoVLOXSEG4EI16_V_MF2_M1_MASK,
  PseudoVLOXSEG4EI16_V_MF2_M2,
  PseudoVLOXSEG4EI16_V_MF2_M2_MASK,
  PseudoVLOXSEG4EI16_V_MF2_MF2,
  PseudoVLOXSEG4EI16_V_MF2_MF2_MASK,
  PseudoVLOXSEG4EI16_V_MF2_MF4,
  PseudoVLOXSEG4EI16_V_MF2_MF4_MASK,
  PseudoVLOXSEG4EI16_V_MF4_M1,
  PseudoVLOXSEG4EI16_V_MF4_M1_MASK,
  PseudoVLOXSEG4EI16_V_MF4_MF2,
  PseudoVLOXSEG4EI16_V_MF4_MF2_MASK,
  PseudoVLOXSEG4EI16_V_MF4_MF4,
  PseudoVLOXSEG4EI16_V_MF4_MF4_MASK,
  PseudoVLOXSEG4EI16_V_MF4_MF8,
  PseudoVLOXSEG4EI16_V_MF4_MF8_MASK,
  PseudoVLOXSEG4EI32_V_M1_M1,
  PseudoVLOXSEG4EI32_V_M1_M1_MASK,
  PseudoVLOXSEG4EI32_V_M1_M2,
  PseudoVLOXSEG4EI32_V_M1_M2_MASK,
  PseudoVLOXSEG4EI32_V_M1_MF2,
  PseudoVLOXSEG4EI32_V_M1_MF2_MASK,
  PseudoVLOXSEG4EI32_V_M1_MF4,
  PseudoVLOXSEG4EI32_V_M1_MF4_MASK,
  PseudoVLOXSEG4EI32_V_M2_M1,
  PseudoVLOXSEG4EI32_V_M2_M1_MASK,
  PseudoVLOXSEG4EI32_V_M2_M2,
  PseudoVLOXSEG4EI32_V_M2_M2_MASK,
  PseudoVLOXSEG4EI32_V_M2_MF2,
  PseudoVLOXSEG4EI32_V_M2_MF2_MASK,
  PseudoVLOXSEG4EI32_V_M4_M1,
  PseudoVLOXSEG4EI32_V_M4_M1_MASK,
  PseudoVLOXSEG4EI32_V_M4_M2,
  PseudoVLOXSEG4EI32_V_M4_M2_MASK,
  PseudoVLOXSEG4EI32_V_M8_M2,
  PseudoVLOXSEG4EI32_V_M8_M2_MASK,
  PseudoVLOXSEG4EI32_V_MF2_M1,
  PseudoVLOXSEG4EI32_V_MF2_M1_MASK,
  PseudoVLOXSEG4EI32_V_MF2_MF2,
  PseudoVLOXSEG4EI32_V_MF2_MF2_MASK,
  PseudoVLOXSEG4EI32_V_MF2_MF4,
  PseudoVLOXSEG4EI32_V_MF2_MF4_MASK,
  PseudoVLOXSEG4EI32_V_MF2_MF8,
  PseudoVLOXSEG4EI32_V_MF2_MF8_MASK,
  PseudoVLOXSEG4EI64_V_M1_M1,
  PseudoVLOXSEG4EI64_V_M1_M1_MASK,
  PseudoVLOXSEG4EI64_V_M1_MF2,
  PseudoVLOXSEG4EI64_V_M1_MF2_MASK,
  PseudoVLOXSEG4EI64_V_M1_MF4,
  PseudoVLOXSEG4EI64_V_M1_MF4_MASK,
  PseudoVLOXSEG4EI64_V_M1_MF8,
  PseudoVLOXSEG4EI64_V_M1_MF8_MASK,
  PseudoVLOXSEG4EI64_V_M2_M1,
  PseudoVLOXSEG4EI64_V_M2_M1_MASK,
  PseudoVLOXSEG4EI64_V_M2_M2,
  PseudoVLOXSEG4EI64_V_M2_M2_MASK,
  PseudoVLOXSEG4EI64_V_M2_MF2,
  PseudoVLOXSEG4EI64_V_M2_MF2_MASK,
  PseudoVLOXSEG4EI64_V_M2_MF4,
  PseudoVLOXSEG4EI64_V_M2_MF4_MASK,
  PseudoVLOXSEG4EI64_V_M4_M1,
  PseudoVLOXSEG4EI64_V_M4_M1_MASK,
  PseudoVLOXSEG4EI64_V_M4_M2,
  PseudoVLOXSEG4EI64_V_M4_M2_MASK,
  PseudoVLOXSEG4EI64_V_M4_MF2,
  PseudoVLOXSEG4EI64_V_M4_MF2_MASK,
  PseudoVLOXSEG4EI64_V_M8_M1,
  PseudoVLOXSEG4EI64_V_M8_M1_MASK,
  PseudoVLOXSEG4EI64_V_M8_M2,
  PseudoVLOXSEG4EI64_V_M8_M2_MASK,
  PseudoVLOXSEG4EI8_V_M1_M1,
  PseudoVLOXSEG4EI8_V_M1_M1_MASK,
  PseudoVLOXSEG4EI8_V_M1_M2,
  PseudoVLOXSEG4EI8_V_M1_M2_MASK,
  PseudoVLOXSEG4EI8_V_M2_M2,
  PseudoVLOXSEG4EI8_V_M2_M2_MASK,
  PseudoVLOXSEG4EI8_V_MF2_M1,
  PseudoVLOXSEG4EI8_V_MF2_M1_MASK,
  PseudoVLOXSEG4EI8_V_MF2_M2,
  PseudoVLOXSEG4EI8_V_MF2_M2_MASK,
  PseudoVLOXSEG4EI8_V_MF2_MF2,
  PseudoVLOXSEG4EI8_V_MF2_MF2_MASK,
  PseudoVLOXSEG4EI8_V_MF4_M1,
  PseudoVLOXSEG4EI8_V_MF4_M1_MASK,
  PseudoVLOXSEG4EI8_V_MF4_M2,
  PseudoVLOXSEG4EI8_V_MF4_M2_MASK,
  PseudoVLOXSEG4EI8_V_MF4_MF2,
  PseudoVLOXSEG4EI8_V_MF4_MF2_MASK,
  PseudoVLOXSEG4EI8_V_MF4_MF4,
  PseudoVLOXSEG4EI8_V_MF4_MF4_MASK,
  PseudoVLOXSEG4EI8_V_MF8_M1,
  PseudoVLOXSEG4EI8_V_MF8_M1_MASK,
  PseudoVLOXSEG4EI8_V_MF8_MF2,
  PseudoVLOXSEG4EI8_V_MF8_MF2_MASK,
  PseudoVLOXSEG4EI8_V_MF8_MF4,
  PseudoVLOXSEG4EI8_V_MF8_MF4_MASK,
  PseudoVLOXSEG4EI8_V_MF8_MF8,
  PseudoVLOXSEG4EI8_V_MF8_MF8_MASK,
  PseudoVLOXSEG5EI16_V_M1_M1,
  PseudoVLOXSEG5EI16_V_M1_M1_MASK,
  PseudoVLOXSEG5EI16_V_M1_MF2,
  PseudoVLOXSEG5EI16_V_M1_MF2_MASK,
  PseudoVLOXSEG5EI16_V_M2_M1,
  PseudoVLOXSEG5EI16_V_M2_M1_MASK,
  PseudoVLOXSEG5EI16_V_MF2_M1,
  PseudoVLOXSEG5EI16_V_MF2_M1_MASK,
  PseudoVLOXSEG5EI16_V_MF2_MF2,
  PseudoVLOXSEG5EI16_V_MF2_MF2_MASK,
  PseudoVLOXSEG5EI16_V_MF2_MF4,
  PseudoVLOXSEG5EI16_V_MF2_MF4_MASK,
  PseudoVLOXSEG5EI16_V_MF4_M1,
  PseudoVLOXSEG5EI16_V_MF4_M1_MASK,
  PseudoVLOXSEG5EI16_V_MF4_MF2,
  PseudoVLOXSEG5EI16_V_MF4_MF2_MASK,
  PseudoVLOXSEG5EI16_V_MF4_MF4,
  PseudoVLOXSEG5EI16_V_MF4_MF4_MASK,
  PseudoVLOXSEG5EI16_V_MF4_MF8,
  PseudoVLOXSEG5EI16_V_MF4_MF8_MASK,
  PseudoVLOXSEG5EI32_V_M1_M1,
  PseudoVLOXSEG5EI32_V_M1_M1_MASK,
  PseudoVLOXSEG5EI32_V_M1_MF2,
  PseudoVLOXSEG5EI32_V_M1_MF2_MASK,
  PseudoVLOXSEG5EI32_V_M1_MF4,
  PseudoVLOXSEG5EI32_V_M1_MF4_MASK,
  PseudoVLOXSEG5EI32_V_M2_M1,
  PseudoVLOXSEG5EI32_V_M2_M1_MASK,
  PseudoVLOXSEG5EI32_V_M2_MF2,
  PseudoVLOXSEG5EI32_V_M2_MF2_MASK,
  PseudoVLOXSEG5EI32_V_M4_M1,
  PseudoVLOXSEG5EI32_V_M4_M1_MASK,
  PseudoVLOXSEG5EI32_V_MF2_M1,
  PseudoVLOXSEG5EI32_V_MF2_M1_MASK,
  PseudoVLOXSEG5EI32_V_MF2_MF2,
  PseudoVLOXSEG5EI32_V_MF2_MF2_MASK,
  PseudoVLOXSEG5EI32_V_MF2_MF4,
  PseudoVLOXSEG5EI32_V_MF2_MF4_MASK,
  PseudoVLOXSEG5EI32_V_MF2_MF8,
  PseudoVLOXSEG5EI32_V_MF2_MF8_MASK,
  PseudoVLOXSEG5EI64_V_M1_M1,
  PseudoVLOXSEG5EI64_V_M1_M1_MASK,
  PseudoVLOXSEG5EI64_V_M1_MF2,
  PseudoVLOXSEG5EI64_V_M1_MF2_MASK,
  PseudoVLOXSEG5EI64_V_M1_MF4,
  PseudoVLOXSEG5EI64_V_M1_MF4_MASK,
  PseudoVLOXSEG5EI64_V_M1_MF8,
  PseudoVLOXSEG5EI64_V_M1_MF8_MASK,
  PseudoVLOXSEG5EI64_V_M2_M1,
  PseudoVLOXSEG5EI64_V_M2_M1_MASK,
  PseudoVLOXSEG5EI64_V_M2_MF2,
  PseudoVLOXSEG5EI64_V_M2_MF2_MASK,
  PseudoVLOXSEG5EI64_V_M2_MF4,
  PseudoVLOXSEG5EI64_V_M2_MF4_MASK,
  PseudoVLOXSEG5EI64_V_M4_M1,
  PseudoVLOXSEG5EI64_V_M4_M1_MASK,
  PseudoVLOXSEG5EI64_V_M4_MF2,
  PseudoVLOXSEG5EI64_V_M4_MF2_MASK,
  PseudoVLOXSEG5EI64_V_M8_M1,
  PseudoVLOXSEG5EI64_V_M8_M1_MASK,
  PseudoVLOXSEG5EI8_V_M1_M1,
  PseudoVLOXSEG5EI8_V_M1_M1_MASK,
  PseudoVLOXSEG5EI8_V_MF2_M1,
  PseudoVLOXSEG5EI8_V_MF2_M1_MASK,
  PseudoVLOXSEG5EI8_V_MF2_MF2,
  PseudoVLOXSEG5EI8_V_MF2_MF2_MASK,
  PseudoVLOXSEG5EI8_V_MF4_M1,
  PseudoVLOXSEG5EI8_V_MF4_M1_MASK,
  PseudoVLOXSEG5EI8_V_MF4_MF2,
  PseudoVLOXSEG5EI8_V_MF4_MF2_MASK,
  PseudoVLOXSEG5EI8_V_MF4_MF4,
  PseudoVLOXSEG5EI8_V_MF4_MF4_MASK,
  PseudoVLOXSEG5EI8_V_MF8_M1,
  PseudoVLOXSEG5EI8_V_MF8_M1_MASK,
  PseudoVLOXSEG5EI8_V_MF8_MF2,
  PseudoVLOXSEG5EI8_V_MF8_MF2_MASK,
  PseudoVLOXSEG5EI8_V_MF8_MF4,
  PseudoVLOXSEG5EI8_V_MF8_MF4_MASK,
  PseudoVLOXSEG5EI8_V_MF8_MF8,
  PseudoVLOXSEG5EI8_V_MF8_MF8_MASK,
  PseudoVLOXSEG6EI16_V_M1_M1,
  PseudoVLOXSEG6EI16_V_M1_M1_MASK,
  PseudoVLOXSEG6EI16_V_M1_MF2,
  PseudoVLOXSEG6EI16_V_M1_MF2_MASK,
  PseudoVLOXSEG6EI16_V_M2_M1,
  PseudoVLOXSEG6EI16_V_M2_M1_MASK,
  PseudoVLOXSEG6EI16_V_MF2_M1,
  PseudoVLOXSEG6EI16_V_MF2_M1_MASK,
  PseudoVLOXSEG6EI16_V_MF2_MF2,
  PseudoVLOXSEG6EI16_V_MF2_MF2_MASK,
  PseudoVLOXSEG6EI16_V_MF2_MF4,
  PseudoVLOXSEG6EI16_V_MF2_MF4_MASK,
  PseudoVLOXSEG6EI16_V_MF4_M1,
  PseudoVLOXSEG6EI16_V_MF4_M1_MASK,
  PseudoVLOXSEG6EI16_V_MF4_MF2,
  PseudoVLOXSEG6EI16_V_MF4_MF2_MASK,
  PseudoVLOXSEG6EI16_V_MF4_MF4,
  PseudoVLOXSEG6EI16_V_MF4_MF4_MASK,
  PseudoVLOXSEG6EI16_V_MF4_MF8,
  PseudoVLOXSEG6EI16_V_MF4_MF8_MASK,
  PseudoVLOXSEG6EI32_V_M1_M1,
  PseudoVLOXSEG6EI32_V_M1_M1_MASK,
  PseudoVLOXSEG6EI32_V_M1_MF2,
  PseudoVLOXSEG6EI32_V_M1_MF2_MASK,
  PseudoVLOXSEG6EI32_V_M1_MF4,
  PseudoVLOXSEG6EI32_V_M1_MF4_MASK,
  PseudoVLOXSEG6EI32_V_M2_M1,
  PseudoVLOXSEG6EI32_V_M2_M1_MASK,
  PseudoVLOXSEG6EI32_V_M2_MF2,
  PseudoVLOXSEG6EI32_V_M2_MF2_MASK,
  PseudoVLOXSEG6EI32_V_M4_M1,
  PseudoVLOXSEG6EI32_V_M4_M1_MASK,
  PseudoVLOXSEG6EI32_V_MF2_M1,
  PseudoVLOXSEG6EI32_V_MF2_M1_MASK,
  PseudoVLOXSEG6EI32_V_MF2_MF2,
  PseudoVLOXSEG6EI32_V_MF2_MF2_MASK,
  PseudoVLOXSEG6EI32_V_MF2_MF4,
  PseudoVLOXSEG6EI32_V_MF2_MF4_MASK,
  PseudoVLOXSEG6EI32_V_MF2_MF8,
  PseudoVLOXSEG6EI32_V_MF2_MF8_MASK,
  PseudoVLOXSEG6EI64_V_M1_M1,
  PseudoVLOXSEG6EI64_V_M1_M1_MASK,
  PseudoVLOXSEG6EI64_V_M1_MF2,
  PseudoVLOXSEG6EI64_V_M1_MF2_MASK,
  PseudoVLOXSEG6EI64_V_M1_MF4,
  PseudoVLOXSEG6EI64_V_M1_MF4_MASK,
  PseudoVLOXSEG6EI64_V_M1_MF8,
  PseudoVLOXSEG6EI64_V_M1_MF8_MASK,
  PseudoVLOXSEG6EI64_V_M2_M1,
  PseudoVLOXSEG6EI64_V_M2_M1_MASK,
  PseudoVLOXSEG6EI64_V_M2_MF2,
  PseudoVLOXSEG6EI64_V_M2_MF2_MASK,
  PseudoVLOXSEG6EI64_V_M2_MF4,
  PseudoVLOXSEG6EI64_V_M2_MF4_MASK,
  PseudoVLOXSEG6EI64_V_M4_M1,
  PseudoVLOXSEG6EI64_V_M4_M1_MASK,
  PseudoVLOXSEG6EI64_V_M4_MF2,
  PseudoVLOXSEG6EI64_V_M4_MF2_MASK,
  PseudoVLOXSEG6EI64_V_M8_M1,
  PseudoVLOXSEG6EI64_V_M8_M1_MASK,
  PseudoVLOXSEG6EI8_V_M1_M1,
  PseudoVLOXSEG6EI8_V_M1_M1_MASK,
  PseudoVLOXSEG6EI8_V_MF2_M1,
  PseudoVLOXSEG6EI8_V_MF2_M1_MASK,
  PseudoVLOXSEG6EI8_V_MF2_MF2,
  PseudoVLOXSEG6EI8_V_MF2_MF2_MASK,
  PseudoVLOXSEG6EI8_V_MF4_M1,
  PseudoVLOXSEG6EI8_V_MF4_M1_MASK,
  PseudoVLOXSEG6EI8_V_MF4_MF2,
  PseudoVLOXSEG6EI8_V_MF4_MF2_MASK,
  PseudoVLOXSEG6EI8_V_MF4_MF4,
  PseudoVLOXSEG6EI8_V_MF4_MF4_MASK,
  PseudoVLOXSEG6EI8_V_MF8_M1,
  PseudoVLOXSEG6EI8_V_MF8_M1_MASK,
  PseudoVLOXSEG6EI8_V_MF8_MF2,
  PseudoVLOXSEG6EI8_V_MF8_MF2_MASK,
  PseudoVLOXSEG6EI8_V_MF8_MF4,
  PseudoVLOXSEG6EI8_V_MF8_MF4_MASK,
  PseudoVLOXSEG6EI8_V_MF8_MF8,
  PseudoVLOXSEG6EI8_V_MF8_MF8_MASK,
  PseudoVLOXSEG7EI16_V_M1_M1,
  PseudoVLOXSEG7EI16_V_M1_M1_MASK,
  PseudoVLOXSEG7EI16_V_M1_MF2,
  PseudoVLOXSEG7EI16_V_M1_MF2_MASK,
  PseudoVLOXSEG7EI16_V_M2_M1,
  PseudoVLOXSEG7EI16_V_M2_M1_MASK,
  PseudoVLOXSEG7EI16_V_MF2_M1,
  PseudoVLOXSEG7EI16_V_MF2_M1_MASK,
  PseudoVLOXSEG7EI16_V_MF2_MF2,
  PseudoVLOXSEG7EI16_V_MF2_MF2_MASK,
  PseudoVLOXSEG7EI16_V_MF2_MF4,
  PseudoVLOXSEG7EI16_V_MF2_MF4_MASK,
  PseudoVLOXSEG7EI16_V_MF4_M1,
  PseudoVLOXSEG7EI16_V_MF4_M1_MASK,
  PseudoVLOXSEG7EI16_V_MF4_MF2,
  PseudoVLOXSEG7EI16_V_MF4_MF2_MASK,
  PseudoVLOXSEG7EI16_V_MF4_MF4,
  PseudoVLOXSEG7EI16_V_MF4_MF4_MASK,
  PseudoVLOXSEG7EI16_V_MF4_MF8,
  PseudoVLOXSEG7EI16_V_MF4_MF8_MASK,
  PseudoVLOXSEG7EI32_V_M1_M1,
  PseudoVLOXSEG7EI32_V_M1_M1_MASK,
  PseudoVLOXSEG7EI32_V_M1_MF2,
  PseudoVLOXSEG7EI32_V_M1_MF2_MASK,
  PseudoVLOXSEG7EI32_V_M1_MF4,
  PseudoVLOXSEG7EI32_V_M1_MF4_MASK,
  PseudoVLOXSEG7EI32_V_M2_M1,
  PseudoVLOXSEG7EI32_V_M2_M1_MASK,
  PseudoVLOXSEG7EI32_V_M2_MF2,
  PseudoVLOXSEG7EI32_V_M2_MF2_MASK,
  PseudoVLOXSEG7EI32_V_M4_M1,
  PseudoVLOXSEG7EI32_V_M4_M1_MASK,
  PseudoVLOXSEG7EI32_V_MF2_M1,
  PseudoVLOXSEG7EI32_V_MF2_M1_MASK,
  PseudoVLOXSEG7EI32_V_MF2_MF2,
  PseudoVLOXSEG7EI32_V_MF2_MF2_MASK,
  PseudoVLOXSEG7EI32_V_MF2_MF4,
  PseudoVLOXSEG7EI32_V_MF2_MF4_MASK,
  PseudoVLOXSEG7EI32_V_MF2_MF8,
  PseudoVLOXSEG7EI32_V_MF2_MF8_MASK,
  PseudoVLOXSEG7EI64_V_M1_M1,
  PseudoVLOXSEG7EI64_V_M1_M1_MASK,
  PseudoVLOXSEG7EI64_V_M1_MF2,
  PseudoVLOXSEG7EI64_V_M1_MF2_MASK,
  PseudoVLOXSEG7EI64_V_M1_MF4,
  PseudoVLOXSEG7EI64_V_M1_MF4_MASK,
  PseudoVLOXSEG7EI64_V_M1_MF8,
  PseudoVLOXSEG7EI64_V_M1_MF8_MASK,
  PseudoVLOXSEG7EI64_V_M2_M1,
  PseudoVLOXSEG7EI64_V_M2_M1_MASK,
  PseudoVLOXSEG7EI64_V_M2_MF2,
  PseudoVLOXSEG7EI64_V_M2_MF2_MASK,
  PseudoVLOXSEG7EI64_V_M2_MF4,
  PseudoVLOXSEG7EI64_V_M2_MF4_MASK,
  PseudoVLOXSEG7EI64_V_M4_M1,
  PseudoVLOXSEG7EI64_V_M4_M1_MASK,
  PseudoVLOXSEG7EI64_V_M4_MF2,
  PseudoVLOXSEG7EI64_V_M4_MF2_MASK,
  PseudoVLOXSEG7EI64_V_M8_M1,
  PseudoVLOXSEG7EI64_V_M8_M1_MASK,
  PseudoVLOXSEG7EI8_V_M1_M1,
  PseudoVLOXSEG7EI8_V_M1_M1_MASK,
  PseudoVLOXSEG7EI8_V_MF2_M1,
  PseudoVLOXSEG7EI8_V_MF2_M1_MASK,
  PseudoVLOXSEG7EI8_V_MF2_MF2,
  PseudoVLOXSEG7EI8_V_MF2_MF2_MASK,
  PseudoVLOXSEG7EI8_V_MF4_M1,
  PseudoVLOXSEG7EI8_V_MF4_M1_MASK,
  PseudoVLOXSEG7EI8_V_MF4_MF2,
  PseudoVLOXSEG7EI8_V_MF4_MF2_MASK,
  PseudoVLOXSEG7EI8_V_MF4_MF4,
  PseudoVLOXSEG7EI8_V_MF4_MF4_MASK,
  PseudoVLOXSEG7EI8_V_MF8_M1,
  PseudoVLOXSEG7EI8_V_MF8_M1_MASK,
  PseudoVLOXSEG7EI8_V_MF8_MF2,
  PseudoVLOXSEG7EI8_V_MF8_MF2_MASK,
  PseudoVLOXSEG7EI8_V_MF8_MF4,
  PseudoVLOXSEG7EI8_V_MF8_MF4_MASK,
  PseudoVLOXSEG7EI8_V_MF8_MF8,
  PseudoVLOXSEG7EI8_V_MF8_MF8_MASK,
  PseudoVLOXSEG8EI16_V_M1_M1,
  PseudoVLOXSEG8EI16_V_M1_M1_MASK,
  PseudoVLOXSEG8EI16_V_M1_MF2,
  PseudoVLOXSEG8EI16_V_M1_MF2_MASK,
  PseudoVLOXSEG8EI16_V_M2_M1,
  PseudoVLOXSEG8EI16_V_M2_M1_MASK,
  PseudoVLOXSEG8EI16_V_MF2_M1,
  PseudoVLOXSEG8EI16_V_MF2_M1_MASK,
  PseudoVLOXSEG8EI16_V_MF2_MF2,
  PseudoVLOXSEG8EI16_V_MF2_MF2_MASK,
  PseudoVLOXSEG8EI16_V_MF2_MF4,
  PseudoVLOXSEG8EI16_V_MF2_MF4_MASK,
  PseudoVLOXSEG8EI16_V_MF4_M1,
  PseudoVLOXSEG8EI16_V_MF4_M1_MASK,
  PseudoVLOXSEG8EI16_V_MF4_MF2,
  PseudoVLOXSEG8EI16_V_MF4_MF2_MASK,
  PseudoVLOXSEG8EI16_V_MF4_MF4,
  PseudoVLOXSEG8EI16_V_MF4_MF4_MASK,
  PseudoVLOXSEG8EI16_V_MF4_MF8,
  PseudoVLOXSEG8EI16_V_MF4_MF8_MASK,
  PseudoVLOXSEG8EI32_V_M1_M1,
  PseudoVLOXSEG8EI32_V_M1_M1_MASK,
  PseudoVLOXSEG8EI32_V_M1_MF2,
  PseudoVLOXSEG8EI32_V_M1_MF2_MASK,
  PseudoVLOXSEG8EI32_V_M1_MF4,
  PseudoVLOXSEG8EI32_V_M1_MF4_MASK,
  PseudoVLOXSEG8EI32_V_M2_M1,
  PseudoVLOXSEG8EI32_V_M2_M1_MASK,
  PseudoVLOXSEG8EI32_V_M2_MF2,
  PseudoVLOXSEG8EI32_V_M2_MF2_MASK,
  PseudoVLOXSEG8EI32_V_M4_M1,
  PseudoVLOXSEG8EI32_V_M4_M1_MASK,
  PseudoVLOXSEG8EI32_V_MF2_M1,
  PseudoVLOXSEG8EI32_V_MF2_M1_MASK,
  PseudoVLOXSEG8EI32_V_MF2_MF2,
  PseudoVLOXSEG8EI32_V_MF2_MF2_MASK,
  PseudoVLOXSEG8EI32_V_MF2_MF4,
  PseudoVLOXSEG8EI32_V_MF2_MF4_MASK,
  PseudoVLOXSEG8EI32_V_MF2_MF8,
  PseudoVLOXSEG8EI32_V_MF2_MF8_MASK,
  PseudoVLOXSEG8EI64_V_M1_M1,
  PseudoVLOXSEG8EI64_V_M1_M1_MASK,
  PseudoVLOXSEG8EI64_V_M1_MF2,
  PseudoVLOXSEG8EI64_V_M1_MF2_MASK,
  PseudoVLOXSEG8EI64_V_M1_MF4,
  PseudoVLOXSEG8EI64_V_M1_MF4_MASK,
  PseudoVLOXSEG8EI64_V_M1_MF8,
  PseudoVLOXSEG8EI64_V_M1_MF8_MASK,
  PseudoVLOXSEG8EI64_V_M2_M1,
  PseudoVLOXSEG8EI64_V_M2_M1_MASK,
  PseudoVLOXSEG8EI64_V_M2_MF2,
  PseudoVLOXSEG8EI64_V_M2_MF2_MASK,
  PseudoVLOXSEG8EI64_V_M2_MF4,
  PseudoVLOXSEG8EI64_V_M2_MF4_MASK,
  PseudoVLOXSEG8EI64_V_M4_M1,
  PseudoVLOXSEG8EI64_V_M4_M1_MASK,
  PseudoVLOXSEG8EI64_V_M4_MF2,
  PseudoVLOXSEG8EI64_V_M4_MF2_MASK,
  PseudoVLOXSEG8EI64_V_M8_M1,
  PseudoVLOXSEG8EI64_V_M8_M1_MASK,
  PseudoVLOXSEG8EI8_V_M1_M1,
  PseudoVLOXSEG8EI8_V_M1_M1_MASK,
  PseudoVLOXSEG8EI8_V_MF2_M1,
  PseudoVLOXSEG8EI8_V_MF2_M1_MASK,
  PseudoVLOXSEG8EI8_V_MF2_MF2,
  PseudoVLOXSEG8EI8_V_MF2_MF2_MASK,
  PseudoVLOXSEG8EI8_V_MF4_M1,
  PseudoVLOXSEG8EI8_V_MF4_M1_MASK,
  PseudoVLOXSEG8EI8_V_MF4_MF2,
  PseudoVLOXSEG8EI8_V_MF4_MF2_MASK,
  PseudoVLOXSEG8EI8_V_MF4_MF4,
  PseudoVLOXSEG8EI8_V_MF4_MF4_MASK,
  PseudoVLOXSEG8EI8_V_MF8_M1,
  PseudoVLOXSEG8EI8_V_MF8_M1_MASK,
  PseudoVLOXSEG8EI8_V_MF8_MF2,
  PseudoVLOXSEG8EI8_V_MF8_MF2_MASK,
  PseudoVLOXSEG8EI8_V_MF8_MF4,
  PseudoVLOXSEG8EI8_V_MF8_MF4_MASK,
  PseudoVLOXSEG8EI8_V_MF8_MF8,
  PseudoVLOXSEG8EI8_V_MF8_MF8_MASK,
  PseudoVLSE16_V_M1,
  PseudoVLSE16_V_M1_MASK,
  PseudoVLSE16_V_M2,
  PseudoVLSE16_V_M2_MASK,
  PseudoVLSE16_V_M4,
  PseudoVLSE16_V_M4_MASK,
  PseudoVLSE16_V_M8,
  PseudoVLSE16_V_M8_MASK,
  PseudoVLSE16_V_MF2,
  PseudoVLSE16_V_MF2_MASK,
  PseudoVLSE16_V_MF4,
  PseudoVLSE16_V_MF4_MASK,
  PseudoVLSE32_V_M1,
  PseudoVLSE32_V_M1_MASK,
  PseudoVLSE32_V_M2,
  PseudoVLSE32_V_M2_MASK,
  PseudoVLSE32_V_M4,
  PseudoVLSE32_V_M4_MASK,
  PseudoVLSE32_V_M8,
  PseudoVLSE32_V_M8_MASK,
  PseudoVLSE32_V_MF2,
  PseudoVLSE32_V_MF2_MASK,
  PseudoVLSE64_V_M1,
  PseudoVLSE64_V_M1_MASK,
  PseudoVLSE64_V_M2,
  PseudoVLSE64_V_M2_MASK,
  PseudoVLSE64_V_M4,
  PseudoVLSE64_V_M4_MASK,
  PseudoVLSE64_V_M8,
  PseudoVLSE64_V_M8_MASK,
  PseudoVLSE8_V_M1,
  PseudoVLSE8_V_M1_MASK,
  PseudoVLSE8_V_M2,
  PseudoVLSE8_V_M2_MASK,
  PseudoVLSE8_V_M4,
  PseudoVLSE8_V_M4_MASK,
  PseudoVLSE8_V_M8,
  PseudoVLSE8_V_M8_MASK,
  PseudoVLSE8_V_MF2,
  PseudoVLSE8_V_MF2_MASK,
  PseudoVLSE8_V_MF4,
  PseudoVLSE8_V_MF4_MASK,
  PseudoVLSE8_V_MF8,
  PseudoVLSE8_V_MF8_MASK,
  PseudoVLSEG2E16FF_V_M1,
  PseudoVLSEG2E16FF_V_M1_MASK,
  PseudoVLSEG2E16FF_V_M2,
  PseudoVLSEG2E16FF_V_M2_MASK,
  PseudoVLSEG2E16FF_V_M4,
  PseudoVLSEG2E16FF_V_M4_MASK,
  PseudoVLSEG2E16FF_V_MF2,
  PseudoVLSEG2E16FF_V_MF2_MASK,
  PseudoVLSEG2E16FF_V_MF4,
  PseudoVLSEG2E16FF_V_MF4_MASK,
  PseudoVLSEG2E16_V_M1,
  PseudoVLSEG2E16_V_M1_MASK,
  PseudoVLSEG2E16_V_M2,
  PseudoVLSEG2E16_V_M2_MASK,
  PseudoVLSEG2E16_V_M4,
  PseudoVLSEG2E16_V_M4_MASK,
  PseudoVLSEG2E16_V_MF2,
  PseudoVLSEG2E16_V_MF2_MASK,
  PseudoVLSEG2E16_V_MF4,
  PseudoVLSEG2E16_V_MF4_MASK,
  PseudoVLSEG2E32FF_V_M1,
  PseudoVLSEG2E32FF_V_M1_MASK,
  PseudoVLSEG2E32FF_V_M2,
  PseudoVLSEG2E32FF_V_M2_MASK,
  PseudoVLSEG2E32FF_V_M4,
  PseudoVLSEG2E32FF_V_M4_MASK,
  PseudoVLSEG2E32FF_V_MF2,
  PseudoVLSEG2E32FF_V_MF2_MASK,
  PseudoVLSEG2E32_V_M1,
  PseudoVLSEG2E32_V_M1_MASK,
  PseudoVLSEG2E32_V_M2,
  PseudoVLSEG2E32_V_M2_MASK,
  PseudoVLSEG2E32_V_M4,
  PseudoVLSEG2E32_V_M4_MASK,
  PseudoVLSEG2E32_V_MF2,
  PseudoVLSEG2E32_V_MF2_MASK,
  PseudoVLSEG2E64FF_V_M1,
  PseudoVLSEG2E64FF_V_M1_MASK,
  PseudoVLSEG2E64FF_V_M2,
  PseudoVLSEG2E64FF_V_M2_MASK,
  PseudoVLSEG2E64FF_V_M4,
  PseudoVLSEG2E64FF_V_M4_MASK,
  PseudoVLSEG2E64_V_M1,
  PseudoVLSEG2E64_V_M1_MASK,
  PseudoVLSEG2E64_V_M2,
  PseudoVLSEG2E64_V_M2_MASK,
  PseudoVLSEG2E64_V_M4,
  PseudoVLSEG2E64_V_M4_MASK,
  PseudoVLSEG2E8FF_V_M1,
  PseudoVLSEG2E8FF_V_M1_MASK,
  PseudoVLSEG2E8FF_V_M2,
  PseudoVLSEG2E8FF_V_M2_MASK,
  PseudoVLSEG2E8FF_V_M4,
  PseudoVLSEG2E8FF_V_M4_MASK,
  PseudoVLSEG2E8FF_V_MF2,
  PseudoVLSEG2E8FF_V_MF2_MASK,
  PseudoVLSEG2E8FF_V_MF4,
  PseudoVLSEG2E8FF_V_MF4_MASK,
  PseudoVLSEG2E8FF_V_MF8,
  PseudoVLSEG2E8FF_V_MF8_MASK,
  PseudoVLSEG2E8_V_M1,
  PseudoVLSEG2E8_V_M1_MASK,
  PseudoVLSEG2E8_V_M2,
  PseudoVLSEG2E8_V_M2_MASK,
  PseudoVLSEG2E8_V_M4,
  PseudoVLSEG2E8_V_M4_MASK,
  PseudoVLSEG2E8_V_MF2,
  PseudoVLSEG2E8_V_MF2_MASK,
  PseudoVLSEG2E8_V_MF4,
  PseudoVLSEG2E8_V_MF4_MASK,
  PseudoVLSEG2E8_V_MF8,
  PseudoVLSEG2E8_V_MF8_MASK,
  PseudoVLSEG3E16FF_V_M1,
  PseudoVLSEG3E16FF_V_M1_MASK,
  PseudoVLSEG3E16FF_V_M2,
  PseudoVLSEG3E16FF_V_M2_MASK,
  PseudoVLSEG3E16FF_V_MF2,
  PseudoVLSEG3E16FF_V_MF2_MASK,
  PseudoVLSEG3E16FF_V_MF4,
  PseudoVLSEG3E16FF_V_MF4_MASK,
  PseudoVLSEG3E16_V_M1,
  PseudoVLSEG3E16_V_M1_MASK,
  PseudoVLSEG3E16_V_M2,
  PseudoVLSEG3E16_V_M2_MASK,
  PseudoVLSEG3E16_V_MF2,
  PseudoVLSEG3E16_V_MF2_MASK,
  PseudoVLSEG3E16_V_MF4,
  PseudoVLSEG3E16_V_MF4_MASK,
  PseudoVLSEG3E32FF_V_M1,
  PseudoVLSEG3E32FF_V_M1_MASK,
  PseudoVLSEG3E32FF_V_M2,
  PseudoVLSEG3E32FF_V_M2_MASK,
  PseudoVLSEG3E32FF_V_MF2,
  PseudoVLSEG3E32FF_V_MF2_MASK,
  PseudoVLSEG3E32_V_M1,
  PseudoVLSEG3E32_V_M1_MASK,
  PseudoVLSEG3E32_V_M2,
  PseudoVLSEG3E32_V_M2_MASK,
  PseudoVLSEG3E32_V_MF2,
  PseudoVLSEG3E32_V_MF2_MASK,
  PseudoVLSEG3E64FF_V_M1,
  PseudoVLSEG3E64FF_V_M1_MASK,
  PseudoVLSEG3E64FF_V_M2,
  PseudoVLSEG3E64FF_V_M2_MASK,
  PseudoVLSEG3E64_V_M1,
  PseudoVLSEG3E64_V_M1_MASK,
  PseudoVLSEG3E64_V_M2,
  PseudoVLSEG3E64_V_M2_MASK,
  PseudoVLSEG3E8FF_V_M1,
  PseudoVLSEG3E8FF_V_M1_MASK,
  PseudoVLSEG3E8FF_V_M2,
  PseudoVLSEG3E8FF_V_M2_MASK,
  PseudoVLSEG3E8FF_V_MF2,
  PseudoVLSEG3E8FF_V_MF2_MASK,
  PseudoVLSEG3E8FF_V_MF4,
  PseudoVLSEG3E8FF_V_MF4_MASK,
  PseudoVLSEG3E8FF_V_MF8,
  PseudoVLSEG3E8FF_V_MF8_MASK,
  PseudoVLSEG3E8_V_M1,
  PseudoVLSEG3E8_V_M1_MASK,
  PseudoVLSEG3E8_V_M2,
  PseudoVLSEG3E8_V_M2_MASK,
  PseudoVLSEG3E8_V_MF2,
  PseudoVLSEG3E8_V_MF2_MASK,
  PseudoVLSEG3E8_V_MF4,
  PseudoVLSEG3E8_V_MF4_MASK,
  PseudoVLSEG3E8_V_MF8,
  PseudoVLSEG3E8_V_MF8_MASK,
  PseudoVLSEG4E16FF_V_M1,
  PseudoVLSEG4E16FF_V_M1_MASK,
  PseudoVLSEG4E16FF_V_M2,
  PseudoVLSEG4E16FF_V_M2_MASK,
  PseudoVLSEG4E16FF_V_MF2,
  PseudoVLSEG4E16FF_V_MF2_MASK,
  PseudoVLSEG4E16FF_V_MF4,
  PseudoVLSEG4E16FF_V_MF4_MASK,
  PseudoVLSEG4E16_V_M1,
  PseudoVLSEG4E16_V_M1_MASK,
  PseudoVLSEG4E16_V_M2,
  PseudoVLSEG4E16_V_M2_MASK,
  PseudoVLSEG4E16_V_MF2,
  PseudoVLSEG4E16_V_MF2_MASK,
  PseudoVLSEG4E16_V_MF4,
  PseudoVLSEG4E16_V_MF4_MASK,
  PseudoVLSEG4E32FF_V_M1,
  PseudoVLSEG4E32FF_V_M1_MASK,
  PseudoVLSEG4E32FF_V_M2,
  PseudoVLSEG4E32FF_V_M2_MASK,
  PseudoVLSEG4E32FF_V_MF2,
  PseudoVLSEG4E32FF_V_MF2_MASK,
  PseudoVLSEG4E32_V_M1,
  PseudoVLSEG4E32_V_M1_MASK,
  PseudoVLSEG4E32_V_M2,
  PseudoVLSEG4E32_V_M2_MASK,
  PseudoVLSEG4E32_V_MF2,
  PseudoVLSEG4E32_V_MF2_MASK,
  PseudoVLSEG4E64FF_V_M1,
  PseudoVLSEG4E64FF_V_M1_MASK,
  PseudoVLSEG4E64FF_V_M2,
  PseudoVLSEG4E64FF_V_M2_MASK,
  PseudoVLSEG4E64_V_M1,
  PseudoVLSEG4E64_V_M1_MASK,
  PseudoVLSEG4E64_V_M2,
  PseudoVLSEG4E64_V_M2_MASK,
  PseudoVLSEG4E8FF_V_M1,
  PseudoVLSEG4E8FF_V_M1_MASK,
  PseudoVLSEG4E8FF_V_M2,
  PseudoVLSEG4E8FF_V_M2_MASK,
  PseudoVLSEG4E8FF_V_MF2,
  PseudoVLSEG4E8FF_V_MF2_MASK,
  PseudoVLSEG4E8FF_V_MF4,
  PseudoVLSEG4E8FF_V_MF4_MASK,
  PseudoVLSEG4E8FF_V_MF8,
  PseudoVLSEG4E8FF_V_MF8_MASK,
  PseudoVLSEG4E8_V_M1,
  PseudoVLSEG4E8_V_M1_MASK,
  PseudoVLSEG4E8_V_M2,
  PseudoVLSEG4E8_V_M2_MASK,
  PseudoVLSEG4E8_V_MF2,
  PseudoVLSEG4E8_V_MF2_MASK,
  PseudoVLSEG4E8_V_MF4,
  PseudoVLSEG4E8_V_MF4_MASK,
  PseudoVLSEG4E8_V_MF8,
  PseudoVLSEG4E8_V_MF8_MASK,
  PseudoVLSEG5E16FF_V_M1,
  PseudoVLSEG5E16FF_V_M1_MASK,
  PseudoVLSEG5E16FF_V_MF2,
  PseudoVLSEG5E16FF_V_MF2_MASK,
  PseudoVLSEG5E16FF_V_MF4,
  PseudoVLSEG5E16FF_V_MF4_MASK,
  PseudoVLSEG5E16_V_M1,
  PseudoVLSEG5E16_V_M1_MASK,
  PseudoVLSEG5E16_V_MF2,
  PseudoVLSEG5E16_V_MF2_MASK,
  PseudoVLSEG5E16_V_MF4,
  PseudoVLSEG5E16_V_MF4_MASK,
  PseudoVLSEG5E32FF_V_M1,
  PseudoVLSEG5E32FF_V_M1_MASK,
  PseudoVLSEG5E32FF_V_MF2,
  PseudoVLSEG5E32FF_V_MF2_MASK,
  PseudoVLSEG5E32_V_M1,
  PseudoVLSEG5E32_V_M1_MASK,
  PseudoVLSEG5E32_V_MF2,
  PseudoVLSEG5E32_V_MF2_MASK,
  PseudoVLSEG5E64FF_V_M1,
  PseudoVLSEG5E64FF_V_M1_MASK,
  PseudoVLSEG5E64_V_M1,
  PseudoVLSEG5E64_V_M1_MASK,
  PseudoVLSEG5E8FF_V_M1,
  PseudoVLSEG5E8FF_V_M1_MASK,
  PseudoVLSEG5E8FF_V_MF2,
  PseudoVLSEG5E8FF_V_MF2_MASK,
  PseudoVLSEG5E8FF_V_MF4,
  PseudoVLSEG5E8FF_V_MF4_MASK,
  PseudoVLSEG5E8FF_V_MF8,
  PseudoVLSEG5E8FF_V_MF8_MASK,
  PseudoVLSEG5E8_V_M1,
  PseudoVLSEG5E8_V_M1_MASK,
  PseudoVLSEG5E8_V_MF2,
  PseudoVLSEG5E8_V_MF2_MASK,
  PseudoVLSEG5E8_V_MF4,
  PseudoVLSEG5E8_V_MF4_MASK,
  PseudoVLSEG5E8_V_MF8,
  PseudoVLSEG5E8_V_MF8_MASK,
  PseudoVLSEG6E16FF_V_M1,
  PseudoVLSEG6E16FF_V_M1_MASK,
  PseudoVLSEG6E16FF_V_MF2,
  PseudoVLSEG6E16FF_V_MF2_MASK,
  PseudoVLSEG6E16FF_V_MF4,
  PseudoVLSEG6E16FF_V_MF4_MASK,
  PseudoVLSEG6E16_V_M1,
  PseudoVLSEG6E16_V_M1_MASK,
  PseudoVLSEG6E16_V_MF2,
  PseudoVLSEG6E16_V_MF2_MASK,
  PseudoVLSEG6E16_V_MF4,
  PseudoVLSEG6E16_V_MF4_MASK,
  PseudoVLSEG6E32FF_V_M1,
  PseudoVLSEG6E32FF_V_M1_MASK,
  PseudoVLSEG6E32FF_V_MF2,
  PseudoVLSEG6E32FF_V_MF2_MASK,
  PseudoVLSEG6E32_V_M1,
  PseudoVLSEG6E32_V_M1_MASK,
  PseudoVLSEG6E32_V_MF2,
  PseudoVLSEG6E32_V_MF2_MASK,
  PseudoVLSEG6E64FF_V_M1,
  PseudoVLSEG6E64FF_V_M1_MASK,
  PseudoVLSEG6E64_V_M1,
  PseudoVLSEG6E64_V_M1_MASK,
  PseudoVLSEG6E8FF_V_M1,
  PseudoVLSEG6E8FF_V_M1_MASK,
  PseudoVLSEG6E8FF_V_MF2,
  PseudoVLSEG6E8FF_V_MF2_MASK,
  PseudoVLSEG6E8FF_V_MF4,
  PseudoVLSEG6E8FF_V_MF4_MASK,
  PseudoVLSEG6E8FF_V_MF8,
  PseudoVLSEG6E8FF_V_MF8_MASK,
  PseudoVLSEG6E8_V_M1,
  PseudoVLSEG6E8_V_M1_MASK,
  PseudoVLSEG6E8_V_MF2,
  PseudoVLSEG6E8_V_MF2_MASK,
  PseudoVLSEG6E8_V_MF4,
  PseudoVLSEG6E8_V_MF4_MASK,
  PseudoVLSEG6E8_V_MF8,
  PseudoVLSEG6E8_V_MF8_MASK,
  PseudoVLSEG7E16FF_V_M1,
  PseudoVLSEG7E16FF_V_M1_MASK,
  PseudoVLSEG7E16FF_V_MF2,
  PseudoVLSEG7E16FF_V_MF2_MASK,
  PseudoVLSEG7E16FF_V_MF4,
  PseudoVLSEG7E16FF_V_MF4_MASK,
  PseudoVLSEG7E16_V_M1,
  PseudoVLSEG7E16_V_M1_MASK,
  PseudoVLSEG7E16_V_MF2,
  PseudoVLSEG7E16_V_MF2_MASK,
  PseudoVLSEG7E16_V_MF4,
  PseudoVLSEG7E16_V_MF4_MASK,
  PseudoVLSEG7E32FF_V_M1,
  PseudoVLSEG7E32FF_V_M1_MASK,
  PseudoVLSEG7E32FF_V_MF2,
  PseudoVLSEG7E32FF_V_MF2_MASK,
  PseudoVLSEG7E32_V_M1,
  PseudoVLSEG7E32_V_M1_MASK,
  PseudoVLSEG7E32_V_MF2,
  PseudoVLSEG7E32_V_MF2_MASK,
  PseudoVLSEG7E64FF_V_M1,
  PseudoVLSEG7E64FF_V_M1_MASK,
  PseudoVLSEG7E64_V_M1,
  PseudoVLSEG7E64_V_M1_MASK,
  PseudoVLSEG7E8FF_V_M1,
  PseudoVLSEG7E8FF_V_M1_MASK,
  PseudoVLSEG7E8FF_V_MF2,
  PseudoVLSEG7E8FF_V_MF2_MASK,
  PseudoVLSEG7E8FF_V_MF4,
  PseudoVLSEG7E8FF_V_MF4_MASK,
  PseudoVLSEG7E8FF_V_MF8,
  PseudoVLSEG7E8FF_V_MF8_MASK,
  PseudoVLSEG7E8_V_M1,
  PseudoVLSEG7E8_V_M1_MASK,
  PseudoVLSEG7E8_V_MF2,
  PseudoVLSEG7E8_V_MF2_MASK,
  PseudoVLSEG7E8_V_MF4,
  PseudoVLSEG7E8_V_MF4_MASK,
  PseudoVLSEG7E8_V_MF8,
  PseudoVLSEG7E8_V_MF8_MASK,
  PseudoVLSEG8E16FF_V_M1,
  PseudoVLSEG8E16FF_V_M1_MASK,
  PseudoVLSEG8E16FF_V_MF2,
  PseudoVLSEG8E16FF_V_MF2_MASK,
  PseudoVLSEG8E16FF_V_MF4,
  PseudoVLSEG8E16FF_V_MF4_MASK,
  PseudoVLSEG8E16_V_M1,
  PseudoVLSEG8E16_V_M1_MASK,
  PseudoVLSEG8E16_V_MF2,
  PseudoVLSEG8E16_V_MF2_MASK,
  PseudoVLSEG8E16_V_MF4,
  PseudoVLSEG8E16_V_MF4_MASK,
  PseudoVLSEG8E32FF_V_M1,
  PseudoVLSEG8E32FF_V_M1_MASK,
  PseudoVLSEG8E32FF_V_MF2,
  PseudoVLSEG8E32FF_V_MF2_MASK,
  PseudoVLSEG8E32_V_M1,
  PseudoVLSEG8E32_V_M1_MASK,
  PseudoVLSEG8E32_V_MF2,
  PseudoVLSEG8E32_V_MF2_MASK,
  PseudoVLSEG8E64FF_V_M1,
  PseudoVLSEG8E64FF_V_M1_MASK,
  PseudoVLSEG8E64_V_M1,
  PseudoVLSEG8E64_V_M1_MASK,
  PseudoVLSEG8E8FF_V_M1,
  PseudoVLSEG8E8FF_V_M1_MASK,
  PseudoVLSEG8E8FF_V_MF2,
  PseudoVLSEG8E8FF_V_MF2_MASK,
  PseudoVLSEG8E8FF_V_MF4,
  PseudoVLSEG8E8FF_V_MF4_MASK,
  PseudoVLSEG8E8FF_V_MF8,
  PseudoVLSEG8E8FF_V_MF8_MASK,
  PseudoVLSEG8E8_V_M1,
  PseudoVLSEG8E8_V_M1_MASK,
  PseudoVLSEG8E8_V_MF2,
  PseudoVLSEG8E8_V_MF2_MASK,
  PseudoVLSEG8E8_V_MF4,
  PseudoVLSEG8E8_V_MF4_MASK,
  PseudoVLSEG8E8_V_MF8,
  PseudoVLSEG8E8_V_MF8_MASK,
  PseudoVLSSEG2E16_V_M1,
  PseudoVLSSEG2E16_V_M1_MASK,
  PseudoVLSSEG2E16_V_M2,
  PseudoVLSSEG2E16_V_M2_MASK,
  PseudoVLSSEG2E16_V_M4,
  PseudoVLSSEG2E16_V_M4_MASK,
  PseudoVLSSEG2E16_V_MF2,
  PseudoVLSSEG2E16_V_MF2_MASK,
  PseudoVLSSEG2E16_V_MF4,
  PseudoVLSSEG2E16_V_MF4_MASK,
  PseudoVLSSEG2E32_V_M1,
  PseudoVLSSEG2E32_V_M1_MASK,
  PseudoVLSSEG2E32_V_M2,
  PseudoVLSSEG2E32_V_M2_MASK,
  PseudoVLSSEG2E32_V_M4,
  PseudoVLSSEG2E32_V_M4_MASK,
  PseudoVLSSEG2E32_V_MF2,
  PseudoVLSSEG2E32_V_MF2_MASK,
  PseudoVLSSEG2E64_V_M1,
  PseudoVLSSEG2E64_V_M1_MASK,
  PseudoVLSSEG2E64_V_M2,
  PseudoVLSSEG2E64_V_M2_MASK,
  PseudoVLSSEG2E64_V_M4,
  PseudoVLSSEG2E64_V_M4_MASK,
  PseudoVLSSEG2E8_V_M1,
  PseudoVLSSEG2E8_V_M1_MASK,
  PseudoVLSSEG2E8_V_M2,
  PseudoVLSSEG2E8_V_M2_MASK,
  PseudoVLSSEG2E8_V_M4,
  PseudoVLSSEG2E8_V_M4_MASK,
  PseudoVLSSEG2E8_V_MF2,
  PseudoVLSSEG2E8_V_MF2_MASK,
  PseudoVLSSEG2E8_V_MF4,
  PseudoVLSSEG2E8_V_MF4_MASK,
  PseudoVLSSEG2E8_V_MF8,
  PseudoVLSSEG2E8_V_MF8_MASK,
  PseudoVLSSEG3E16_V_M1,
  PseudoVLSSEG3E16_V_M1_MASK,
  PseudoVLSSEG3E16_V_M2,
  PseudoVLSSEG3E16_V_M2_MASK,
  PseudoVLSSEG3E16_V_MF2,
  PseudoVLSSEG3E16_V_MF2_MASK,
  PseudoVLSSEG3E16_V_MF4,
  PseudoVLSSEG3E16_V_MF4_MASK,
  PseudoVLSSEG3E32_V_M1,
  PseudoVLSSEG3E32_V_M1_MASK,
  PseudoVLSSEG3E32_V_M2,
  PseudoVLSSEG3E32_V_M2_MASK,
  PseudoVLSSEG3E32_V_MF2,
  PseudoVLSSEG3E32_V_MF2_MASK,
  PseudoVLSSEG3E64_V_M1,
  PseudoVLSSEG3E64_V_M1_MASK,
  PseudoVLSSEG3E64_V_M2,
  PseudoVLSSEG3E64_V_M2_MASK,
  PseudoVLSSEG3E8_V_M1,
  PseudoVLSSEG3E8_V_M1_MASK,
  PseudoVLSSEG3E8_V_M2,
  PseudoVLSSEG3E8_V_M2_MASK,
  PseudoVLSSEG3E8_V_MF2,
  PseudoVLSSEG3E8_V_MF2_MASK,
  PseudoVLSSEG3E8_V_MF4,
  PseudoVLSSEG3E8_V_MF4_MASK,
  PseudoVLSSEG3E8_V_MF8,
  PseudoVLSSEG3E8_V_MF8_MASK,
  PseudoVLSSEG4E16_V_M1,
  PseudoVLSSEG4E16_V_M1_MASK,
  PseudoVLSSEG4E16_V_M2,
  PseudoVLSSEG4E16_V_M2_MASK,
  PseudoVLSSEG4E16_V_MF2,
  PseudoVLSSEG4E16_V_MF2_MASK,
  PseudoVLSSEG4E16_V_MF4,
  PseudoVLSSEG4E16_V_MF4_MASK,
  PseudoVLSSEG4E32_V_M1,
  PseudoVLSSEG4E32_V_M1_MASK,
  PseudoVLSSEG4E32_V_M2,
  PseudoVLSSEG4E32_V_M2_MASK,
  PseudoVLSSEG4E32_V_MF2,
  PseudoVLSSEG4E32_V_MF2_MASK,
  PseudoVLSSEG4E64_V_M1,
  PseudoVLSSEG4E64_V_M1_MASK,
  PseudoVLSSEG4E64_V_M2,
  PseudoVLSSEG4E64_V_M2_MASK,
  PseudoVLSSEG4E8_V_M1,
  PseudoVLSSEG4E8_V_M1_MASK,
  PseudoVLSSEG4E8_V_M2,
  PseudoVLSSEG4E8_V_M2_MASK,
  PseudoVLSSEG4E8_V_MF2,
  PseudoVLSSEG4E8_V_MF2_MASK,
  PseudoVLSSEG4E8_V_MF4,
  PseudoVLSSEG4E8_V_MF4_MASK,
  PseudoVLSSEG4E8_V_MF8,
  PseudoVLSSEG4E8_V_MF8_MASK,
  PseudoVLSSEG5E16_V_M1,
  PseudoVLSSEG5E16_V_M1_MASK,
  PseudoVLSSEG5E16_V_MF2,
  PseudoVLSSEG5E16_V_MF2_MASK,
  PseudoVLSSEG5E16_V_MF4,
  PseudoVLSSEG5E16_V_MF4_MASK,
  PseudoVLSSEG5E32_V_M1,
  PseudoVLSSEG5E32_V_M1_MASK,
  PseudoVLSSEG5E32_V_MF2,
  PseudoVLSSEG5E32_V_MF2_MASK,
  PseudoVLSSEG5E64_V_M1,
  PseudoVLSSEG5E64_V_M1_MASK,
  PseudoVLSSEG5E8_V_M1,
  PseudoVLSSEG5E8_V_M1_MASK,
  PseudoVLSSEG5E8_V_MF2,
  PseudoVLSSEG5E8_V_MF2_MASK,
  PseudoVLSSEG5E8_V_MF4,
  PseudoVLSSEG5E8_V_MF4_MASK,
  PseudoVLSSEG5E8_V_MF8,
  PseudoVLSSEG5E8_V_MF8_MASK,
  PseudoVLSSEG6E16_V_M1,
  PseudoVLSSEG6E16_V_M1_MASK,
  PseudoVLSSEG6E16_V_MF2,
  PseudoVLSSEG6E16_V_MF2_MASK,
  PseudoVLSSEG6E16_V_MF4,
  PseudoVLSSEG6E16_V_MF4_MASK,
  PseudoVLSSEG6E32_V_M1,
  PseudoVLSSEG6E32_V_M1_MASK,
  PseudoVLSSEG6E32_V_MF2,
  PseudoVLSSEG6E32_V_MF2_MASK,
  PseudoVLSSEG6E64_V_M1,
  PseudoVLSSEG6E64_V_M1_MASK,
  PseudoVLSSEG6E8_V_M1,
  PseudoVLSSEG6E8_V_M1_MASK,
  PseudoVLSSEG6E8_V_MF2,
  PseudoVLSSEG6E8_V_MF2_MASK,
  PseudoVLSSEG6E8_V_MF4,
  PseudoVLSSEG6E8_V_MF4_MASK,
  PseudoVLSSEG6E8_V_MF8,
  PseudoVLSSEG6E8_V_MF8_MASK,
  PseudoVLSSEG7E16_V_M1,
  PseudoVLSSEG7E16_V_M1_MASK,
  PseudoVLSSEG7E16_V_MF2,
  PseudoVLSSEG7E16_V_MF2_MASK,
  PseudoVLSSEG7E16_V_MF4,
  PseudoVLSSEG7E16_V_MF4_MASK,
  PseudoVLSSEG7E32_V_M1,
  PseudoVLSSEG7E32_V_M1_MASK,
  PseudoVLSSEG7E32_V_MF2,
  PseudoVLSSEG7E32_V_MF2_MASK,
  PseudoVLSSEG7E64_V_M1,
  PseudoVLSSEG7E64_V_M1_MASK,
  PseudoVLSSEG7E8_V_M1,
  PseudoVLSSEG7E8_V_M1_MASK,
  PseudoVLSSEG7E8_V_MF2,
  PseudoVLSSEG7E8_V_MF2_MASK,
  PseudoVLSSEG7E8_V_MF4,
  PseudoVLSSEG7E8_V_MF4_MASK,
  PseudoVLSSEG7E8_V_MF8,
  PseudoVLSSEG7E8_V_MF8_MASK,
  PseudoVLSSEG8E16_V_M1,
  PseudoVLSSEG8E16_V_M1_MASK,
  PseudoVLSSEG8E16_V_MF2,
  PseudoVLSSEG8E16_V_MF2_MASK,
  PseudoVLSSEG8E16_V_MF4,
  PseudoVLSSEG8E16_V_MF4_MASK,
  PseudoVLSSEG8E32_V_M1,
  PseudoVLSSEG8E32_V_M1_MASK,
  PseudoVLSSEG8E32_V_MF2,
  PseudoVLSSEG8E32_V_MF2_MASK,
  PseudoVLSSEG8E64_V_M1,
  PseudoVLSSEG8E64_V_M1_MASK,
  PseudoVLSSEG8E8_V_M1,
  PseudoVLSSEG8E8_V_M1_MASK,
  PseudoVLSSEG8E8_V_MF2,
  PseudoVLSSEG8E8_V_MF2_MASK,
  PseudoVLSSEG8E8_V_MF4,
  PseudoVLSSEG8E8_V_MF4_MASK,
  PseudoVLSSEG8E8_V_MF8,
  PseudoVLSSEG8E8_V_MF8_MASK,
  PseudoVLUXEI16_V_M1_M1,
  PseudoVLUXEI16_V_M1_M1_MASK,
  PseudoVLUXEI16_V_M1_M2,
  PseudoVLUXEI16_V_M1_M2_MASK,
  PseudoVLUXEI16_V_M1_M4,
  PseudoVLUXEI16_V_M1_M4_MASK,
  PseudoVLUXEI16_V_M1_MF2,
  PseudoVLUXEI16_V_M1_MF2_MASK,
  PseudoVLUXEI16_V_M2_M1,
  PseudoVLUXEI16_V_M2_M1_MASK,
  PseudoVLUXEI16_V_M2_M2,
  PseudoVLUXEI16_V_M2_M2_MASK,
  PseudoVLUXEI16_V_M2_M4,
  PseudoVLUXEI16_V_M2_M4_MASK,
  PseudoVLUXEI16_V_M2_M8,
  PseudoVLUXEI16_V_M2_M8_MASK,
  PseudoVLUXEI16_V_M4_M2,
  PseudoVLUXEI16_V_M4_M2_MASK,
  PseudoVLUXEI16_V_M4_M4,
  PseudoVLUXEI16_V_M4_M4_MASK,
  PseudoVLUXEI16_V_M4_M8,
  PseudoVLUXEI16_V_M4_M8_MASK,
  PseudoVLUXEI16_V_M8_M4,
  PseudoVLUXEI16_V_M8_M4_MASK,
  PseudoVLUXEI16_V_M8_M8,
  PseudoVLUXEI16_V_M8_M8_MASK,
  PseudoVLUXEI16_V_MF2_M1,
  PseudoVLUXEI16_V_MF2_M1_MASK,
  PseudoVLUXEI16_V_MF2_M2,
  PseudoVLUXEI16_V_MF2_M2_MASK,
  PseudoVLUXEI16_V_MF2_MF2,
  PseudoVLUXEI16_V_MF2_MF2_MASK,
  PseudoVLUXEI16_V_MF2_MF4,
  PseudoVLUXEI16_V_MF2_MF4_MASK,
  PseudoVLUXEI16_V_MF4_M1,
  PseudoVLUXEI16_V_MF4_M1_MASK,
  PseudoVLUXEI16_V_MF4_MF2,
  PseudoVLUXEI16_V_MF4_MF2_MASK,
  PseudoVLUXEI16_V_MF4_MF4,
  PseudoVLUXEI16_V_MF4_MF4_MASK,
  PseudoVLUXEI16_V_MF4_MF8,
  PseudoVLUXEI16_V_MF4_MF8_MASK,
  PseudoVLUXEI32_V_M1_M1,
  PseudoVLUXEI32_V_M1_M1_MASK,
  PseudoVLUXEI32_V_M1_M2,
  PseudoVLUXEI32_V_M1_M2_MASK,
  PseudoVLUXEI32_V_M1_MF2,
  PseudoVLUXEI32_V_M1_MF2_MASK,
  PseudoVLUXEI32_V_M1_MF4,
  PseudoVLUXEI32_V_M1_MF4_MASK,
  PseudoVLUXEI32_V_M2_M1,
  PseudoVLUXEI32_V_M2_M1_MASK,
  PseudoVLUXEI32_V_M2_M2,
  PseudoVLUXEI32_V_M2_M2_MASK,
  PseudoVLUXEI32_V_M2_M4,
  PseudoVLUXEI32_V_M2_M4_MASK,
  PseudoVLUXEI32_V_M2_MF2,
  PseudoVLUXEI32_V_M2_MF2_MASK,
  PseudoVLUXEI32_V_M4_M1,
  PseudoVLUXEI32_V_M4_M1_MASK,
  PseudoVLUXEI32_V_M4_M2,
  PseudoVLUXEI32_V_M4_M2_MASK,
  PseudoVLUXEI32_V_M4_M4,
  PseudoVLUXEI32_V_M4_M4_MASK,
  PseudoVLUXEI32_V_M4_M8,
  PseudoVLUXEI32_V_M4_M8_MASK,
  PseudoVLUXEI32_V_M8_M2,
  PseudoVLUXEI32_V_M8_M2_MASK,
  PseudoVLUXEI32_V_M8_M4,
  PseudoVLUXEI32_V_M8_M4_MASK,
  PseudoVLUXEI32_V_M8_M8,
  PseudoVLUXEI32_V_M8_M8_MASK,
  PseudoVLUXEI32_V_MF2_M1,
  PseudoVLUXEI32_V_MF2_M1_MASK,
  PseudoVLUXEI32_V_MF2_MF2,
  PseudoVLUXEI32_V_MF2_MF2_MASK,
  PseudoVLUXEI32_V_MF2_MF4,
  PseudoVLUXEI32_V_MF2_MF4_MASK,
  PseudoVLUXEI32_V_MF2_MF8,
  PseudoVLUXEI32_V_MF2_MF8_MASK,
  PseudoVLUXEI64_V_M1_M1,
  PseudoVLUXEI64_V_M1_M1_MASK,
  PseudoVLUXEI64_V_M1_MF2,
  PseudoVLUXEI64_V_M1_MF2_MASK,
  PseudoVLUXEI64_V_M1_MF4,
  PseudoVLUXEI64_V_M1_MF4_MASK,
  PseudoVLUXEI64_V_M1_MF8,
  PseudoVLUXEI64_V_M1_MF8_MASK,
  PseudoVLUXEI64_V_M2_M1,
  PseudoVLUXEI64_V_M2_M1_MASK,
  PseudoVLUXEI64_V_M2_M2,
  PseudoVLUXEI64_V_M2_M2_MASK,
  PseudoVLUXEI64_V_M2_MF2,
  PseudoVLUXEI64_V_M2_MF2_MASK,
  PseudoVLUXEI64_V_M2_MF4,
  PseudoVLUXEI64_V_M2_MF4_MASK,
  PseudoVLUXEI64_V_M4_M1,
  PseudoVLUXEI64_V_M4_M1_MASK,
  PseudoVLUXEI64_V_M4_M2,
  PseudoVLUXEI64_V_M4_M2_MASK,
  PseudoVLUXEI64_V_M4_M4,
  PseudoVLUXEI64_V_M4_M4_MASK,
  PseudoVLUXEI64_V_M4_MF2,
  PseudoVLUXEI64_V_M4_MF2_MASK,
  PseudoVLUXEI64_V_M8_M1,
  PseudoVLUXEI64_V_M8_M1_MASK,
  PseudoVLUXEI64_V_M8_M2,
  PseudoVLUXEI64_V_M8_M2_MASK,
  PseudoVLUXEI64_V_M8_M4,
  PseudoVLUXEI64_V_M8_M4_MASK,
  PseudoVLUXEI64_V_M8_M8,
  PseudoVLUXEI64_V_M8_M8_MASK,
  PseudoVLUXEI8_V_M1_M1,
  PseudoVLUXEI8_V_M1_M1_MASK,
  PseudoVLUXEI8_V_M1_M2,
  PseudoVLUXEI8_V_M1_M2_MASK,
  PseudoVLUXEI8_V_M1_M4,
  PseudoVLUXEI8_V_M1_M4_MASK,
  PseudoVLUXEI8_V_M1_M8,
  PseudoVLUXEI8_V_M1_M8_MASK,
  PseudoVLUXEI8_V_M2_M2,
  PseudoVLUXEI8_V_M2_M2_MASK,
  PseudoVLUXEI8_V_M2_M4,
  PseudoVLUXEI8_V_M2_M4_MASK,
  PseudoVLUXEI8_V_M2_M8,
  PseudoVLUXEI8_V_M2_M8_MASK,
  PseudoVLUXEI8_V_M4_M4,
  PseudoVLUXEI8_V_M4_M4_MASK,
  PseudoVLUXEI8_V_M4_M8,
  PseudoVLUXEI8_V_M4_M8_MASK,
  PseudoVLUXEI8_V_M8_M8,
  PseudoVLUXEI8_V_M8_M8_MASK,
  PseudoVLUXEI8_V_MF2_M1,
  PseudoVLUXEI8_V_MF2_M1_MASK,
  PseudoVLUXEI8_V_MF2_M2,
  PseudoVLUXEI8_V_MF2_M2_MASK,
  PseudoVLUXEI8_V_MF2_M4,
  PseudoVLUXEI8_V_MF2_M4_MASK,
  PseudoVLUXEI8_V_MF2_MF2,
  PseudoVLUXEI8_V_MF2_MF2_MASK,
  PseudoVLUXEI8_V_MF4_M1,
  PseudoVLUXEI8_V_MF4_M1_MASK,
  PseudoVLUXEI8_V_MF4_M2,
  PseudoVLUXEI8_V_MF4_M2_MASK,
  PseudoVLUXEI8_V_MF4_MF2,
  PseudoVLUXEI8_V_MF4_MF2_MASK,
  PseudoVLUXEI8_V_MF4_MF4,
  PseudoVLUXEI8_V_MF4_MF4_MASK,
  PseudoVLUXEI8_V_MF8_M1,
  PseudoVLUXEI8_V_MF8_M1_MASK,
  PseudoVLUXEI8_V_MF8_MF2,
  PseudoVLUXEI8_V_MF8_MF2_MASK,
  PseudoVLUXEI8_V_MF8_MF4,
  PseudoVLUXEI8_V_MF8_MF4_MASK,
  PseudoVLUXEI8_V_MF8_MF8,
  PseudoVLUXEI8_V_MF8_MF8_MASK,
  PseudoVLUXSEG2EI16_V_M1_M1,
  PseudoVLUXSEG2EI16_V_M1_M1_MASK,
  PseudoVLUXSEG2EI16_V_M1_M2,
  PseudoVLUXSEG2EI16_V_M1_M2_MASK,
  PseudoVLUXSEG2EI16_V_M1_M4,
  PseudoVLUXSEG2EI16_V_M1_M4_MASK,
  PseudoVLUXSEG2EI16_V_M1_MF2,
  PseudoVLUXSEG2EI16_V_M1_MF2_MASK,
  PseudoVLUXSEG2EI16_V_M2_M1,
  PseudoVLUXSEG2EI16_V_M2_M1_MASK,
  PseudoVLUXSEG2EI16_V_M2_M2,
  PseudoVLUXSEG2EI16_V_M2_M2_MASK,
  PseudoVLUXSEG2EI16_V_M2_M4,
  PseudoVLUXSEG2EI16_V_M2_M4_MASK,
  PseudoVLUXSEG2EI16_V_M4_M2,
  PseudoVLUXSEG2EI16_V_M4_M2_MASK,
  PseudoVLUXSEG2EI16_V_M4_M4,
  PseudoVLUXSEG2EI16_V_M4_M4_MASK,
  PseudoVLUXSEG2EI16_V_M8_M4,
  PseudoVLUXSEG2EI16_V_M8_M4_MASK,
  PseudoVLUXSEG2EI16_V_MF2_M1,
  PseudoVLUXSEG2EI16_V_MF2_M1_MASK,
  PseudoVLUXSEG2EI16_V_MF2_M2,
  PseudoVLUXSEG2EI16_V_MF2_M2_MASK,
  PseudoVLUXSEG2EI16_V_MF2_MF2,
  PseudoVLUXSEG2EI16_V_MF2_MF2_MASK,
  PseudoVLUXSEG2EI16_V_MF2_MF4,
  PseudoVLUXSEG2EI16_V_MF2_MF4_MASK,
  PseudoVLUXSEG2EI16_V_MF4_M1,
  PseudoVLUXSEG2EI16_V_MF4_M1_MASK,
  PseudoVLUXSEG2EI16_V_MF4_MF2,
  PseudoVLUXSEG2EI16_V_MF4_MF2_MASK,
  PseudoVLUXSEG2EI16_V_MF4_MF4,
  PseudoVLUXSEG2EI16_V_MF4_MF4_MASK,
  PseudoVLUXSEG2EI16_V_MF4_MF8,
  PseudoVLUXSEG2EI16_V_MF4_MF8_MASK,
  PseudoVLUXSEG2EI32_V_M1_M1,
  PseudoVLUXSEG2EI32_V_M1_M1_MASK,
  PseudoVLUXSEG2EI32_V_M1_M2,
  PseudoVLUXSEG2EI32_V_M1_M2_MASK,
  PseudoVLUXSEG2EI32_V_M1_MF2,
  PseudoVLUXSEG2EI32_V_M1_MF2_MASK,
  PseudoVLUXSEG2EI32_V_M1_MF4,
  PseudoVLUXSEG2EI32_V_M1_MF4_MASK,
  PseudoVLUXSEG2EI32_V_M2_M1,
  PseudoVLUXSEG2EI32_V_M2_M1_MASK,
  PseudoVLUXSEG2EI32_V_M2_M2,
  PseudoVLUXSEG2EI32_V_M2_M2_MASK,
  PseudoVLUXSEG2EI32_V_M2_M4,
  PseudoVLUXSEG2EI32_V_M2_M4_MASK,
  PseudoVLUXSEG2EI32_V_M2_MF2,
  PseudoVLUXSEG2EI32_V_M2_MF2_MASK,
  PseudoVLUXSEG2EI32_V_M4_M1,
  PseudoVLUXSEG2EI32_V_M4_M1_MASK,
  PseudoVLUXSEG2EI32_V_M4_M2,
  PseudoVLUXSEG2EI32_V_M4_M2_MASK,
  PseudoVLUXSEG2EI32_V_M4_M4,
  PseudoVLUXSEG2EI32_V_M4_M4_MASK,
  PseudoVLUXSEG2EI32_V_M8_M2,
  PseudoVLUXSEG2EI32_V_M8_M2_MASK,
  PseudoVLUXSEG2EI32_V_M8_M4,
  PseudoVLUXSEG2EI32_V_M8_M4_MASK,
  PseudoVLUXSEG2EI32_V_MF2_M1,
  PseudoVLUXSEG2EI32_V_MF2_M1_MASK,
  PseudoVLUXSEG2EI32_V_MF2_MF2,
  PseudoVLUXSEG2EI32_V_MF2_MF2_MASK,
  PseudoVLUXSEG2EI32_V_MF2_MF4,
  PseudoVLUXSEG2EI32_V_MF2_MF4_MASK,
  PseudoVLUXSEG2EI32_V_MF2_MF8,
  PseudoVLUXSEG2EI32_V_MF2_MF8_MASK,
  PseudoVLUXSEG2EI64_V_M1_M1,
  PseudoVLUXSEG2EI64_V_M1_M1_MASK,
  PseudoVLUXSEG2EI64_V_M1_MF2,
  PseudoVLUXSEG2EI64_V_M1_MF2_MASK,
  PseudoVLUXSEG2EI64_V_M1_MF4,
  PseudoVLUXSEG2EI64_V_M1_MF4_MASK,
  PseudoVLUXSEG2EI64_V_M1_MF8,
  PseudoVLUXSEG2EI64_V_M1_MF8_MASK,
  PseudoVLUXSEG2EI64_V_M2_M1,
  PseudoVLUXSEG2EI64_V_M2_M1_MASK,
  PseudoVLUXSEG2EI64_V_M2_M2,
  PseudoVLUXSEG2EI64_V_M2_M2_MASK,
  PseudoVLUXSEG2EI64_V_M2_MF2,
  PseudoVLUXSEG2EI64_V_M2_MF2_MASK,
  PseudoVLUXSEG2EI64_V_M2_MF4,
  PseudoVLUXSEG2EI64_V_M2_MF4_MASK,
  PseudoVLUXSEG2EI64_V_M4_M1,
  PseudoVLUXSEG2EI64_V_M4_M1_MASK,
  PseudoVLUXSEG2EI64_V_M4_M2,
  PseudoVLUXSEG2EI64_V_M4_M2_MASK,
  PseudoVLUXSEG2EI64_V_M4_M4,
  PseudoVLUXSEG2EI64_V_M4_M4_MASK,
  PseudoVLUXSEG2EI64_V_M4_MF2,
  PseudoVLUXSEG2EI64_V_M4_MF2_MASK,
  PseudoVLUXSEG2EI64_V_M8_M1,
  PseudoVLUXSEG2EI64_V_M8_M1_MASK,
  PseudoVLUXSEG2EI64_V_M8_M2,
  PseudoVLUXSEG2EI64_V_M8_M2_MASK,
  PseudoVLUXSEG2EI64_V_M8_M4,
  PseudoVLUXSEG2EI64_V_M8_M4_MASK,
  PseudoVLUXSEG2EI8_V_M1_M1,
  PseudoVLUXSEG2EI8_V_M1_M1_MASK,
  PseudoVLUXSEG2EI8_V_M1_M2,
  PseudoVLUXSEG2EI8_V_M1_M2_MASK,
  PseudoVLUXSEG2EI8_V_M1_M4,
  PseudoVLUXSEG2EI8_V_M1_M4_MASK,
  PseudoVLUXSEG2EI8_V_M2_M2,
  PseudoVLUXSEG2EI8_V_M2_M2_MASK,
  PseudoVLUXSEG2EI8_V_M2_M4,
  PseudoVLUXSEG2EI8_V_M2_M4_MASK,
  PseudoVLUXSEG2EI8_V_M4_M4,
  PseudoVLUXSEG2EI8_V_M4_M4_MASK,
  PseudoVLUXSEG2EI8_V_MF2_M1,
  PseudoVLUXSEG2EI8_V_MF2_M1_MASK,
  PseudoVLUXSEG2EI8_V_MF2_M2,
  PseudoVLUXSEG2EI8_V_MF2_M2_MASK,
  PseudoVLUXSEG2EI8_V_MF2_M4,
  PseudoVLUXSEG2EI8_V_MF2_M4_MASK,
  PseudoVLUXSEG2EI8_V_MF2_MF2,
  PseudoVLUXSEG2EI8_V_MF2_MF2_MASK,
  PseudoVLUXSEG2EI8_V_MF4_M1,
  PseudoVLUXSEG2EI8_V_MF4_M1_MASK,
  PseudoVLUXSEG2EI8_V_MF4_M2,
  PseudoVLUXSEG2EI8_V_MF4_M2_MASK,
  PseudoVLUXSEG2EI8_V_MF4_MF2,
  PseudoVLUXSEG2EI8_V_MF4_MF2_MASK,
  PseudoVLUXSEG2EI8_V_MF4_MF4,
  PseudoVLUXSEG2EI8_V_MF4_MF4_MASK,
  PseudoVLUXSEG2EI8_V_MF8_M1,
  PseudoVLUXSEG2EI8_V_MF8_M1_MASK,
  PseudoVLUXSEG2EI8_V_MF8_MF2,
  PseudoVLUXSEG2EI8_V_MF8_MF2_MASK,
  PseudoVLUXSEG2EI8_V_MF8_MF4,
  PseudoVLUXSEG2EI8_V_MF8_MF4_MASK,
  PseudoVLUXSEG2EI8_V_MF8_MF8,
  PseudoVLUXSEG2EI8_V_MF8_MF8_MASK,
  PseudoVLUXSEG3EI16_V_M1_M1,
  PseudoVLUXSEG3EI16_V_M1_M1_MASK,
  PseudoVLUXSEG3EI16_V_M1_M2,
  PseudoVLUXSEG3EI16_V_M1_M2_MASK,
  PseudoVLUXSEG3EI16_V_M1_MF2,
  PseudoVLUXSEG3EI16_V_M1_MF2_MASK,
  PseudoVLUXSEG3EI16_V_M2_M1,
  PseudoVLUXSEG3EI16_V_M2_M1_MASK,
  PseudoVLUXSEG3EI16_V_M2_M2,
  PseudoVLUXSEG3EI16_V_M2_M2_MASK,
  PseudoVLUXSEG3EI16_V_M4_M2,
  PseudoVLUXSEG3EI16_V_M4_M2_MASK,
  PseudoVLUXSEG3EI16_V_MF2_M1,
  PseudoVLUXSEG3EI16_V_MF2_M1_MASK,
  PseudoVLUXSEG3EI16_V_MF2_M2,
  PseudoVLUXSEG3EI16_V_MF2_M2_MASK,
  PseudoVLUXSEG3EI16_V_MF2_MF2,
  PseudoVLUXSEG3EI16_V_MF2_MF2_MASK,
  PseudoVLUXSEG3EI16_V_MF2_MF4,
  PseudoVLUXSEG3EI16_V_MF2_MF4_MASK,
  PseudoVLUXSEG3EI16_V_MF4_M1,
  PseudoVLUXSEG3EI16_V_MF4_M1_MASK,
  PseudoVLUXSEG3EI16_V_MF4_MF2,
  PseudoVLUXSEG3EI16_V_MF4_MF2_MASK,
  PseudoVLUXSEG3EI16_V_MF4_MF4,
  PseudoVLUXSEG3EI16_V_MF4_MF4_MASK,
  PseudoVLUXSEG3EI16_V_MF4_MF8,
  PseudoVLUXSEG3EI16_V_MF4_MF8_MASK,
  PseudoVLUXSEG3EI32_V_M1_M1,
  PseudoVLUXSEG3EI32_V_M1_M1_MASK,
  PseudoVLUXSEG3EI32_V_M1_M2,
  PseudoVLUXSEG3EI32_V_M1_M2_MASK,
  PseudoVLUXSEG3EI32_V_M1_MF2,
  PseudoVLUXSEG3EI32_V_M1_MF2_MASK,
  PseudoVLUXSEG3EI32_V_M1_MF4,
  PseudoVLUXSEG3EI32_V_M1_MF4_MASK,
  PseudoVLUXSEG3EI32_V_M2_M1,
  PseudoVLUXSEG3EI32_V_M2_M1_MASK,
  PseudoVLUXSEG3EI32_V_M2_M2,
  PseudoVLUXSEG3EI32_V_M2_M2_MASK,
  PseudoVLUXSEG3EI32_V_M2_MF2,
  PseudoVLUXSEG3EI32_V_M2_MF2_MASK,
  PseudoVLUXSEG3EI32_V_M4_M1,
  PseudoVLUXSEG3EI32_V_M4_M1_MASK,
  PseudoVLUXSEG3EI32_V_M4_M2,
  PseudoVLUXSEG3EI32_V_M4_M2_MASK,
  PseudoVLUXSEG3EI32_V_M8_M2,
  PseudoVLUXSEG3EI32_V_M8_M2_MASK,
  PseudoVLUXSEG3EI32_V_MF2_M1,
  PseudoVLUXSEG3EI32_V_MF2_M1_MASK,
  PseudoVLUXSEG3EI32_V_MF2_MF2,
  PseudoVLUXSEG3EI32_V_MF2_MF2_MASK,
  PseudoVLUXSEG3EI32_V_MF2_MF4,
  PseudoVLUXSEG3EI32_V_MF2_MF4_MASK,
  PseudoVLUXSEG3EI32_V_MF2_MF8,
  PseudoVLUXSEG3EI32_V_MF2_MF8_MASK,
  PseudoVLUXSEG3EI64_V_M1_M1,
  PseudoVLUXSEG3EI64_V_M1_M1_MASK,
  PseudoVLUXSEG3EI64_V_M1_MF2,
  PseudoVLUXSEG3EI64_V_M1_MF2_MASK,
  PseudoVLUXSEG3EI64_V_M1_MF4,
  PseudoVLUXSEG3EI64_V_M1_MF4_MASK,
  PseudoVLUXSEG3EI64_V_M1_MF8,
  PseudoVLUXSEG3EI64_V_M1_MF8_MASK,
  PseudoVLUXSEG3EI64_V_M2_M1,
  PseudoVLUXSEG3EI64_V_M2_M1_MASK,
  PseudoVLUXSEG3EI64_V_M2_M2,
  PseudoVLUXSEG3EI64_V_M2_M2_MASK,
  PseudoVLUXSEG3EI64_V_M2_MF2,
  PseudoVLUXSEG3EI64_V_M2_MF2_MASK,
  PseudoVLUXSEG3EI64_V_M2_MF4,
  PseudoVLUXSEG3EI64_V_M2_MF4_MASK,
  PseudoVLUXSEG3EI64_V_M4_M1,
  PseudoVLUXSEG3EI64_V_M4_M1_MASK,
  PseudoVLUXSEG3EI64_V_M4_M2,
  PseudoVLUXSEG3EI64_V_M4_M2_MASK,
  PseudoVLUXSEG3EI64_V_M4_MF2,
  PseudoVLUXSEG3EI64_V_M4_MF2_MASK,
  PseudoVLUXSEG3EI64_V_M8_M1,
  PseudoVLUXSEG3EI64_V_M8_M1_MASK,
  PseudoVLUXSEG3EI64_V_M8_M2,
  PseudoVLUXSEG3EI64_V_M8_M2_MASK,
  PseudoVLUXSEG3EI8_V_M1_M1,
  PseudoVLUXSEG3EI8_V_M1_M1_MASK,
  PseudoVLUXSEG3EI8_V_M1_M2,
  PseudoVLUXSEG3EI8_V_M1_M2_MASK,
  PseudoVLUXSEG3EI8_V_M2_M2,
  PseudoVLUXSEG3EI8_V_M2_M2_MASK,
  PseudoVLUXSEG3EI8_V_MF2_M1,
  PseudoVLUXSEG3EI8_V_MF2_M1_MASK,
  PseudoVLUXSEG3EI8_V_MF2_M2,
  PseudoVLUXSEG3EI8_V_MF2_M2_MASK,
  PseudoVLUXSEG3EI8_V_MF2_MF2,
  PseudoVLUXSEG3EI8_V_MF2_MF2_MASK,
  PseudoVLUXSEG3EI8_V_MF4_M1,
  PseudoVLUXSEG3EI8_V_MF4_M1_MASK,
  PseudoVLUXSEG3EI8_V_MF4_M2,
  PseudoVLUXSEG3EI8_V_MF4_M2_MASK,
  PseudoVLUXSEG3EI8_V_MF4_MF2,
  PseudoVLUXSEG3EI8_V_MF4_MF2_MASK,
  PseudoVLUXSEG3EI8_V_MF4_MF4,
  PseudoVLUXSEG3EI8_V_MF4_MF4_MASK,
  PseudoVLUXSEG3EI8_V_MF8_M1,
  PseudoVLUXSEG3EI8_V_MF8_M1_MASK,
  PseudoVLUXSEG3EI8_V_MF8_MF2,
  PseudoVLUXSEG3EI8_V_MF8_MF2_MASK,
  PseudoVLUXSEG3EI8_V_MF8_MF4,
  PseudoVLUXSEG3EI8_V_MF8_MF4_MASK,
  PseudoVLUXSEG3EI8_V_MF8_MF8,
  PseudoVLUXSEG3EI8_V_MF8_MF8_MASK,
  PseudoVLUXSEG4EI16_V_M1_M1,
  PseudoVLUXSEG4EI16_V_M1_M1_MASK,
  PseudoVLUXSEG4EI16_V_M1_M2,
  PseudoVLUXSEG4EI16_V_M1_M2_MASK,
  PseudoVLUXSEG4EI16_V_M1_MF2,
  PseudoVLUXSEG4EI16_V_M1_MF2_MASK,
  PseudoVLUXSEG4EI16_V_M2_M1,
  PseudoVLUXSEG4EI16_V_M2_M1_MASK,
  PseudoVLUXSEG4EI16_V_M2_M2,
  PseudoVLUXSEG4EI16_V_M2_M2_MASK,
  PseudoVLUXSEG4EI16_V_M4_M2,
  PseudoVLUXSEG4EI16_V_M4_M2_MASK,
  PseudoVLUXSEG4EI16_V_MF2_M1,
  PseudoVLUXSEG4EI16_V_MF2_M1_MASK,
  PseudoVLUXSEG4EI16_V_MF2_M2,
  PseudoVLUXSEG4EI16_V_MF2_M2_MASK,
  PseudoVLUXSEG4EI16_V_MF2_MF2,
  PseudoVLUXSEG4EI16_V_MF2_MF2_MASK,
  PseudoVLUXSEG4EI16_V_MF2_MF4,
  PseudoVLUXSEG4EI16_V_MF2_MF4_MASK,
  PseudoVLUXSEG4EI16_V_MF4_M1,
  PseudoVLUXSEG4EI16_V_MF4_M1_MASK,
  PseudoVLUXSEG4EI16_V_MF4_MF2,
  PseudoVLUXSEG4EI16_V_MF4_MF2_MASK,
  PseudoVLUXSEG4EI16_V_MF4_MF4,
  PseudoVLUXSEG4EI16_V_MF4_MF4_MASK,
  PseudoVLUXSEG4EI16_V_MF4_MF8,
  PseudoVLUXSEG4EI16_V_MF4_MF8_MASK,
  PseudoVLUXSEG4EI32_V_M1_M1,
  PseudoVLUXSEG4EI32_V_M1_M1_MASK,
  PseudoVLUXSEG4EI32_V_M1_M2,
  PseudoVLUXSEG4EI32_V_M1_M2_MASK,
  PseudoVLUXSEG4EI32_V_M1_MF2,
  PseudoVLUXSEG4EI32_V_M1_MF2_MASK,
  PseudoVLUXSEG4EI32_V_M1_MF4,
  PseudoVLUXSEG4EI32_V_M1_MF4_MASK,
  PseudoVLUXSEG4EI32_V_M2_M1,
  PseudoVLUXSEG4EI32_V_M2_M1_MASK,
  PseudoVLUXSEG4EI32_V_M2_M2,
  PseudoVLUXSEG4EI32_V_M2_M2_MASK,
  PseudoVLUXSEG4EI32_V_M2_MF2,
  PseudoVLUXSEG4EI32_V_M2_MF2_MASK,
  PseudoVLUXSEG4EI32_V_M4_M1,
  PseudoVLUXSEG4EI32_V_M4_M1_MASK,
  PseudoVLUXSEG4EI32_V_M4_M2,
  PseudoVLUXSEG4EI32_V_M4_M2_MASK,
  PseudoVLUXSEG4EI32_V_M8_M2,
  PseudoVLUXSEG4EI32_V_M8_M2_MASK,
  PseudoVLUXSEG4EI32_V_MF2_M1,
  PseudoVLUXSEG4EI32_V_MF2_M1_MASK,
  PseudoVLUXSEG4EI32_V_MF2_MF2,
  PseudoVLUXSEG4EI32_V_MF2_MF2_MASK,
  PseudoVLUXSEG4EI32_V_MF2_MF4,
  PseudoVLUXSEG4EI32_V_MF2_MF4_MASK,
  PseudoVLUXSEG4EI32_V_MF2_MF8,
  PseudoVLUXSEG4EI32_V_MF2_MF8_MASK,
  PseudoVLUXSEG4EI64_V_M1_M1,
  PseudoVLUXSEG4EI64_V_M1_M1_MASK,
  PseudoVLUXSEG4EI64_V_M1_MF2,
  PseudoVLUXSEG4EI64_V_M1_MF2_MASK,
  PseudoVLUXSEG4EI64_V_M1_MF4,
  PseudoVLUXSEG4EI64_V_M1_MF4_MASK,
  PseudoVLUXSEG4EI64_V_M1_MF8,
  PseudoVLUXSEG4EI64_V_M1_MF8_MASK,
  PseudoVLUXSEG4EI64_V_M2_M1,
  PseudoVLUXSEG4EI64_V_M2_M1_MASK,
  PseudoVLUXSEG4EI64_V_M2_M2,
  PseudoVLUXSEG4EI64_V_M2_M2_MASK,
  PseudoVLUXSEG4EI64_V_M2_MF2,
  PseudoVLUXSEG4EI64_V_M2_MF2_MASK,
  PseudoVLUXSEG4EI64_V_M2_MF4,
  PseudoVLUXSEG4EI64_V_M2_MF4_MASK,
  PseudoVLUXSEG4EI64_V_M4_M1,
  PseudoVLUXSEG4EI64_V_M4_M1_MASK,
  PseudoVLUXSEG4EI64_V_M4_M2,
  PseudoVLUXSEG4EI64_V_M4_M2_MASK,
  PseudoVLUXSEG4EI64_V_M4_MF2,
  PseudoVLUXSEG4EI64_V_M4_MF2_MASK,
  PseudoVLUXSEG4EI64_V_M8_M1,
  PseudoVLUXSEG4EI64_V_M8_M1_MASK,
  PseudoVLUXSEG4EI64_V_M8_M2,
  PseudoVLUXSEG4EI64_V_M8_M2_MASK,
  PseudoVLUXSEG4EI8_V_M1_M1,
  PseudoVLUXSEG4EI8_V_M1_M1_MASK,
  PseudoVLUXSEG4EI8_V_M1_M2,
  PseudoVLUXSEG4EI8_V_M1_M2_MASK,
  PseudoVLUXSEG4EI8_V_M2_M2,
  PseudoVLUXSEG4EI8_V_M2_M2_MASK,
  PseudoVLUXSEG4EI8_V_MF2_M1,
  PseudoVLUXSEG4EI8_V_MF2_M1_MASK,
  PseudoVLUXSEG4EI8_V_MF2_M2,
  PseudoVLUXSEG4EI8_V_MF2_M2_MASK,
  PseudoVLUXSEG4EI8_V_MF2_MF2,
  PseudoVLUXSEG4EI8_V_MF2_MF2_MASK,
  PseudoVLUXSEG4EI8_V_MF4_M1,
  PseudoVLUXSEG4EI8_V_MF4_M1_MASK,
  PseudoVLUXSEG4EI8_V_MF4_M2,
  PseudoVLUXSEG4EI8_V_MF4_M2_MASK,
  PseudoVLUXSEG4EI8_V_MF4_MF2,
  PseudoVLUXSEG4EI8_V_MF4_MF2_MASK,
  PseudoVLUXSEG4EI8_V_MF4_MF4,
  PseudoVLUXSEG4EI8_V_MF4_MF4_MASK,
  PseudoVLUXSEG4EI8_V_MF8_M1,
  PseudoVLUXSEG4EI8_V_MF8_M1_MASK,
  PseudoVLUXSEG4EI8_V_MF8_MF2,
  PseudoVLUXSEG4EI8_V_MF8_MF2_MASK,
  PseudoVLUXSEG4EI8_V_MF8_MF4,
  PseudoVLUXSEG4EI8_V_MF8_MF4_MASK,
  PseudoVLUXSEG4EI8_V_MF8_MF8,
  PseudoVLUXSEG4EI8_V_MF8_MF8_MASK,
  PseudoVLUXSEG5EI16_V_M1_M1,
  PseudoVLUXSEG5EI16_V_M1_M1_MASK,
  PseudoVLUXSEG5EI16_V_M1_MF2,
  PseudoVLUXSEG5EI16_V_M1_MF2_MASK,
  PseudoVLUXSEG5EI16_V_M2_M1,
  PseudoVLUXSEG5EI16_V_M2_M1_MASK,
  PseudoVLUXSEG5EI16_V_MF2_M1,
  PseudoVLUXSEG5EI16_V_MF2_M1_MASK,
  PseudoVLUXSEG5EI16_V_MF2_MF2,
  PseudoVLUXSEG5EI16_V_MF2_MF2_MASK,
  PseudoVLUXSEG5EI16_V_MF2_MF4,
  PseudoVLUXSEG5EI16_V_MF2_MF4_MASK,
  PseudoVLUXSEG5EI16_V_MF4_M1,
  PseudoVLUXSEG5EI16_V_MF4_M1_MASK,
  PseudoVLUXSEG5EI16_V_MF4_MF2,
  PseudoVLUXSEG5EI16_V_MF4_MF2_MASK,
  PseudoVLUXSEG5EI16_V_MF4_MF4,
  PseudoVLUXSEG5EI16_V_MF4_MF4_MASK,
  PseudoVLUXSEG5EI16_V_MF4_MF8,
  PseudoVLUXSEG5EI16_V_MF4_MF8_MASK,
  PseudoVLUXSEG5EI32_V_M1_M1,
  PseudoVLUXSEG5EI32_V_M1_M1_MASK,
  PseudoVLUXSEG5EI32_V_M1_MF2,
  PseudoVLUXSEG5EI32_V_M1_MF2_MASK,
  PseudoVLUXSEG5EI32_V_M1_MF4,
  PseudoVLUXSEG5EI32_V_M1_MF4_MASK,
  PseudoVLUXSEG5EI32_V_M2_M1,
  PseudoVLUXSEG5EI32_V_M2_M1_MASK,
  PseudoVLUXSEG5EI32_V_M2_MF2,
  PseudoVLUXSEG5EI32_V_M2_MF2_MASK,
  PseudoVLUXSEG5EI32_V_M4_M1,
  PseudoVLUXSEG5EI32_V_M4_M1_MASK,
  PseudoVLUXSEG5EI32_V_MF2_M1,
  PseudoVLUXSEG5EI32_V_MF2_M1_MASK,
  PseudoVLUXSEG5EI32_V_MF2_MF2,
  PseudoVLUXSEG5EI32_V_MF2_MF2_MASK,
  PseudoVLUXSEG5EI32_V_MF2_MF4,
  PseudoVLUXSEG5EI32_V_MF2_MF4_MASK,
  PseudoVLUXSEG5EI32_V_MF2_MF8,
  PseudoVLUXSEG5EI32_V_MF2_MF8_MASK,
  PseudoVLUXSEG5EI64_V_M1_M1,
  PseudoVLUXSEG5EI64_V_M1_M1_MASK,
  PseudoVLUXSEG5EI64_V_M1_MF2,
  PseudoVLUXSEG5EI64_V_M1_MF2_MASK,
  PseudoVLUXSEG5EI64_V_M1_MF4,
  PseudoVLUXSEG5EI64_V_M1_MF4_MASK,
  PseudoVLUXSEG5EI64_V_M1_MF8,
  PseudoVLUXSEG5EI64_V_M1_MF8_MASK,
  PseudoVLUXSEG5EI64_V_M2_M1,
  PseudoVLUXSEG5EI64_V_M2_M1_MASK,
  PseudoVLUXSEG5EI64_V_M2_MF2,
  PseudoVLUXSEG5EI64_V_M2_MF2_MASK,
  PseudoVLUXSEG5EI64_V_M2_MF4,
  PseudoVLUXSEG5EI64_V_M2_MF4_MASK,
  PseudoVLUXSEG5EI64_V_M4_M1,
  PseudoVLUXSEG5EI64_V_M4_M1_MASK,
  PseudoVLUXSEG5EI64_V_M4_MF2,
  PseudoVLUXSEG5EI64_V_M4_MF2_MASK,
  PseudoVLUXSEG5EI64_V_M8_M1,
  PseudoVLUXSEG5EI64_V_M8_M1_MASK,
  PseudoVLUXSEG5EI8_V_M1_M1,
  PseudoVLUXSEG5EI8_V_M1_M1_MASK,
  PseudoVLUXSEG5EI8_V_MF2_M1,
  PseudoVLUXSEG5EI8_V_MF2_M1_MASK,
  PseudoVLUXSEG5EI8_V_MF2_MF2,
  PseudoVLUXSEG5EI8_V_MF2_MF2_MASK,
  PseudoVLUXSEG5EI8_V_MF4_M1,
  PseudoVLUXSEG5EI8_V_MF4_M1_MASK,
  PseudoVLUXSEG5EI8_V_MF4_MF2,
  PseudoVLUXSEG5EI8_V_MF4_MF2_MASK,
  PseudoVLUXSEG5EI8_V_MF4_MF4,
  PseudoVLUXSEG5EI8_V_MF4_MF4_MASK,
  PseudoVLUXSEG5EI8_V_MF8_M1,
  PseudoVLUXSEG5EI8_V_MF8_M1_MASK,
  PseudoVLUXSEG5EI8_V_MF8_MF2,
  PseudoVLUXSEG5EI8_V_MF8_MF2_MASK,
  PseudoVLUXSEG5EI8_V_MF8_MF4,
  PseudoVLUXSEG5EI8_V_MF8_MF4_MASK,
  PseudoVLUXSEG5EI8_V_MF8_MF8,
  PseudoVLUXSEG5EI8_V_MF8_MF8_MASK,
  PseudoVLUXSEG6EI16_V_M1_M1,
  PseudoVLUXSEG6EI16_V_M1_M1_MASK,
  PseudoVLUXSEG6EI16_V_M1_MF2,
  PseudoVLUXSEG6EI16_V_M1_MF2_MASK,
  PseudoVLUXSEG6EI16_V_M2_M1,
  PseudoVLUXSEG6EI16_V_M2_M1_MASK,
  PseudoVLUXSEG6EI16_V_MF2_M1,
  PseudoVLUXSEG6EI16_V_MF2_M1_MASK,
  PseudoVLUXSEG6EI16_V_MF2_MF2,
  PseudoVLUXSEG6EI16_V_MF2_MF2_MASK,
  PseudoVLUXSEG6EI16_V_MF2_MF4,
  PseudoVLUXSEG6EI16_V_MF2_MF4_MASK,
  PseudoVLUXSEG6EI16_V_MF4_M1,
  PseudoVLUXSEG6EI16_V_MF4_M1_MASK,
  PseudoVLUXSEG6EI16_V_MF4_MF2,
  PseudoVLUXSEG6EI16_V_MF4_MF2_MASK,
  PseudoVLUXSEG6EI16_V_MF4_MF4,
  PseudoVLUXSEG6EI16_V_MF4_MF4_MASK,
  PseudoVLUXSEG6EI16_V_MF4_MF8,
  PseudoVLUXSEG6EI16_V_MF4_MF8_MASK,
  PseudoVLUXSEG6EI32_V_M1_M1,
  PseudoVLUXSEG6EI32_V_M1_M1_MASK,
  PseudoVLUXSEG6EI32_V_M1_MF2,
  PseudoVLUXSEG6EI32_V_M1_MF2_MASK,
  PseudoVLUXSEG6EI32_V_M1_MF4,
  PseudoVLUXSEG6EI32_V_M1_MF4_MASK,
  PseudoVLUXSEG6EI32_V_M2_M1,
  PseudoVLUXSEG6EI32_V_M2_M1_MASK,
  PseudoVLUXSEG6EI32_V_M2_MF2,
  PseudoVLUXSEG6EI32_V_M2_MF2_MASK,
  PseudoVLUXSEG6EI32_V_M4_M1,
  PseudoVLUXSEG6EI32_V_M4_M1_MASK,
  PseudoVLUXSEG6EI32_V_MF2_M1,
  PseudoVLUXSEG6EI32_V_MF2_M1_MASK,
  PseudoVLUXSEG6EI32_V_MF2_MF2,
  PseudoVLUXSEG6EI32_V_MF2_MF2_MASK,
  PseudoVLUXSEG6EI32_V_MF2_MF4,
  PseudoVLUXSEG6EI32_V_MF2_MF4_MASK,
  PseudoVLUXSEG6EI32_V_MF2_MF8,
  PseudoVLUXSEG6EI32_V_MF2_MF8_MASK,
  PseudoVLUXSEG6EI64_V_M1_M1,
  PseudoVLUXSEG6EI64_V_M1_M1_MASK,
  PseudoVLUXSEG6EI64_V_M1_MF2,
  PseudoVLUXSEG6EI64_V_M1_MF2_MASK,
  PseudoVLUXSEG6EI64_V_M1_MF4,
  PseudoVLUXSEG6EI64_V_M1_MF4_MASK,
  PseudoVLUXSEG6EI64_V_M1_MF8,
  PseudoVLUXSEG6EI64_V_M1_MF8_MASK,
  PseudoVLUXSEG6EI64_V_M2_M1,
  PseudoVLUXSEG6EI64_V_M2_M1_MASK,
  PseudoVLUXSEG6EI64_V_M2_MF2,
  PseudoVLUXSEG6EI64_V_M2_MF2_MASK,
  PseudoVLUXSEG6EI64_V_M2_MF4,
  PseudoVLUXSEG6EI64_V_M2_MF4_MASK,
  PseudoVLUXSEG6EI64_V_M4_M1,
  PseudoVLUXSEG6EI64_V_M4_M1_MASK,
  PseudoVLUXSEG6EI64_V_M4_MF2,
  PseudoVLUXSEG6EI64_V_M4_MF2_MASK,
  PseudoVLUXSEG6EI64_V_M8_M1,
  PseudoVLUXSEG6EI64_V_M8_M1_MASK,
  PseudoVLUXSEG6EI8_V_M1_M1,
  PseudoVLUXSEG6EI8_V_M1_M1_MASK,
  PseudoVLUXSEG6EI8_V_MF2_M1,
  PseudoVLUXSEG6EI8_V_MF2_M1_MASK,
  PseudoVLUXSEG6EI8_V_MF2_MF2,
  PseudoVLUXSEG6EI8_V_MF2_MF2_MASK,
  PseudoVLUXSEG6EI8_V_MF4_M1,
  PseudoVLUXSEG6EI8_V_MF4_M1_MASK,
  PseudoVLUXSEG6EI8_V_MF4_MF2,
  PseudoVLUXSEG6EI8_V_MF4_MF2_MASK,
  PseudoVLUXSEG6EI8_V_MF4_MF4,
  PseudoVLUXSEG6EI8_V_MF4_MF4_MASK,
  PseudoVLUXSEG6EI8_V_MF8_M1,
  PseudoVLUXSEG6EI8_V_MF8_M1_MASK,
  PseudoVLUXSEG6EI8_V_MF8_MF2,
  PseudoVLUXSEG6EI8_V_MF8_MF2_MASK,
  PseudoVLUXSEG6EI8_V_MF8_MF4,
  PseudoVLUXSEG6EI8_V_MF8_MF4_MASK,
  PseudoVLUXSEG6EI8_V_MF8_MF8,
  PseudoVLUXSEG6EI8_V_MF8_MF8_MASK,
  PseudoVLUXSEG7EI16_V_M1_M1,
  PseudoVLUXSEG7EI16_V_M1_M1_MASK,
  PseudoVLUXSEG7EI16_V_M1_MF2,
  PseudoVLUXSEG7EI16_V_M1_MF2_MASK,
  PseudoVLUXSEG7EI16_V_M2_M1,
  PseudoVLUXSEG7EI16_V_M2_M1_MASK,
  PseudoVLUXSEG7EI16_V_MF2_M1,
  PseudoVLUXSEG7EI16_V_MF2_M1_MASK,
  PseudoVLUXSEG7EI16_V_MF2_MF2,
  PseudoVLUXSEG7EI16_V_MF2_MF2_MASK,
  PseudoVLUXSEG7EI16_V_MF2_MF4,
  PseudoVLUXSEG7EI16_V_MF2_MF4_MASK,
  PseudoVLUXSEG7EI16_V_MF4_M1,
  PseudoVLUXSEG7EI16_V_MF4_M1_MASK,
  PseudoVLUXSEG7EI16_V_MF4_MF2,
  PseudoVLUXSEG7EI16_V_MF4_MF2_MASK,
  PseudoVLUXSEG7EI16_V_MF4_MF4,
  PseudoVLUXSEG7EI16_V_MF4_MF4_MASK,
  PseudoVLUXSEG7EI16_V_MF4_MF8,
  PseudoVLUXSEG7EI16_V_MF4_MF8_MASK,
  PseudoVLUXSEG7EI32_V_M1_M1,
  PseudoVLUXSEG7EI32_V_M1_M1_MASK,
  PseudoVLUXSEG7EI32_V_M1_MF2,
  PseudoVLUXSEG7EI32_V_M1_MF2_MASK,
  PseudoVLUXSEG7EI32_V_M1_MF4,
  PseudoVLUXSEG7EI32_V_M1_MF4_MASK,
  PseudoVLUXSEG7EI32_V_M2_M1,
  PseudoVLUXSEG7EI32_V_M2_M1_MASK,
  PseudoVLUXSEG7EI32_V_M2_MF2,
  PseudoVLUXSEG7EI32_V_M2_MF2_MASK,
  PseudoVLUXSEG7EI32_V_M4_M1,
  PseudoVLUXSEG7EI32_V_M4_M1_MASK,
  PseudoVLUXSEG7EI32_V_MF2_M1,
  PseudoVLUXSEG7EI32_V_MF2_M1_MASK,
  PseudoVLUXSEG7EI32_V_MF2_MF2,
  PseudoVLUXSEG7EI32_V_MF2_MF2_MASK,
  PseudoVLUXSEG7EI32_V_MF2_MF4,
  PseudoVLUXSEG7EI32_V_MF2_MF4_MASK,
  PseudoVLUXSEG7EI32_V_MF2_MF8,
  PseudoVLUXSEG7EI32_V_MF2_MF8_MASK,
  PseudoVLUXSEG7EI64_V_M1_M1,
  PseudoVLUXSEG7EI64_V_M1_M1_MASK,
  PseudoVLUXSEG7EI64_V_M1_MF2,
  PseudoVLUXSEG7EI64_V_M1_MF2_MASK,
  PseudoVLUXSEG7EI64_V_M1_MF4,
  PseudoVLUXSEG7EI64_V_M1_MF4_MASK,
  PseudoVLUXSEG7EI64_V_M1_MF8,
  PseudoVLUXSEG7EI64_V_M1_MF8_MASK,
  PseudoVLUXSEG7EI64_V_M2_M1,
  PseudoVLUXSEG7EI64_V_M2_M1_MASK,
  PseudoVLUXSEG7EI64_V_M2_MF2,
  PseudoVLUXSEG7EI64_V_M2_MF2_MASK,
  PseudoVLUXSEG7EI64_V_M2_MF4,
  PseudoVLUXSEG7EI64_V_M2_MF4_MASK,
  PseudoVLUXSEG7EI64_V_M4_M1,
  PseudoVLUXSEG7EI64_V_M4_M1_MASK,
  PseudoVLUXSEG7EI64_V_M4_MF2,
  PseudoVLUXSEG7EI64_V_M4_MF2_MASK,
  PseudoVLUXSEG7EI64_V_M8_M1,
  PseudoVLUXSEG7EI64_V_M8_M1_MASK,
  PseudoVLUXSEG7EI8_V_M1_M1,
  PseudoVLUXSEG7EI8_V_M1_M1_MASK,
  PseudoVLUXSEG7EI8_V_MF2_M1,
  PseudoVLUXSEG7EI8_V_MF2_M1_MASK,
  PseudoVLUXSEG7EI8_V_MF2_MF2,
  PseudoVLUXSEG7EI8_V_MF2_MF2_MASK,
  PseudoVLUXSEG7EI8_V_MF4_M1,
  PseudoVLUXSEG7EI8_V_MF4_M1_MASK,
  PseudoVLUXSEG7EI8_V_MF4_MF2,
  PseudoVLUXSEG7EI8_V_MF4_MF2_MASK,
  PseudoVLUXSEG7EI8_V_MF4_MF4,
  PseudoVLUXSEG7EI8_V_MF4_MF4_MASK,
  PseudoVLUXSEG7EI8_V_MF8_M1,
  PseudoVLUXSEG7EI8_V_MF8_M1_MASK,
  PseudoVLUXSEG7EI8_V_MF8_MF2,
  PseudoVLUXSEG7EI8_V_MF8_MF2_MASK,
  PseudoVLUXSEG7EI8_V_MF8_MF4,
  PseudoVLUXSEG7EI8_V_MF8_MF4_MASK,
  PseudoVLUXSEG7EI8_V_MF8_MF8,
  PseudoVLUXSEG7EI8_V_MF8_MF8_MASK,
  PseudoVLUXSEG8EI16_V_M1_M1,
  PseudoVLUXSEG8EI16_V_M1_M1_MASK,
  PseudoVLUXSEG8EI16_V_M1_MF2,
  PseudoVLUXSEG8EI16_V_M1_MF2_MASK,
  PseudoVLUXSEG8EI16_V_M2_M1,
  PseudoVLUXSEG8EI16_V_M2_M1_MASK,
  PseudoVLUXSEG8EI16_V_MF2_M1,
  PseudoVLUXSEG8EI16_V_MF2_M1_MASK,
  PseudoVLUXSEG8EI16_V_MF2_MF2,
  PseudoVLUXSEG8EI16_V_MF2_MF2_MASK,
  PseudoVLUXSEG8EI16_V_MF2_MF4,
  PseudoVLUXSEG8EI16_V_MF2_MF4_MASK,
  PseudoVLUXSEG8EI16_V_MF4_M1,
  PseudoVLUXSEG8EI16_V_MF4_M1_MASK,
  PseudoVLUXSEG8EI16_V_MF4_MF2,
  PseudoVLUXSEG8EI16_V_MF4_MF2_MASK,
  PseudoVLUXSEG8EI16_V_MF4_MF4,
  PseudoVLUXSEG8EI16_V_MF4_MF4_MASK,
  PseudoVLUXSEG8EI16_V_MF4_MF8,
  PseudoVLUXSEG8EI16_V_MF4_MF8_MASK,
  PseudoVLUXSEG8EI32_V_M1_M1,
  PseudoVLUXSEG8EI32_V_M1_M1_MASK,
  PseudoVLUXSEG8EI32_V_M1_MF2,
  PseudoVLUXSEG8EI32_V_M1_MF2_MASK,
  PseudoVLUXSEG8EI32_V_M1_MF4,
  PseudoVLUXSEG8EI32_V_M1_MF4_MASK,
  PseudoVLUXSEG8EI32_V_M2_M1,
  PseudoVLUXSEG8EI32_V_M2_M1_MASK,
  PseudoVLUXSEG8EI32_V_M2_MF2,
  PseudoVLUXSEG8EI32_V_M2_MF2_MASK,
  PseudoVLUXSEG8EI32_V_M4_M1,
  PseudoVLUXSEG8EI32_V_M4_M1_MASK,
  PseudoVLUXSEG8EI32_V_MF2_M1,
  PseudoVLUXSEG8EI32_V_MF2_M1_MASK,
  PseudoVLUXSEG8EI32_V_MF2_MF2,
  PseudoVLUXSEG8EI32_V_MF2_MF2_MASK,
  PseudoVLUXSEG8EI32_V_MF2_MF4,
  PseudoVLUXSEG8EI32_V_MF2_MF4_MASK,
  PseudoVLUXSEG8EI32_V_MF2_MF8,
  PseudoVLUXSEG8EI32_V_MF2_MF8_MASK,
  PseudoVLUXSEG8EI64_V_M1_M1,
  PseudoVLUXSEG8EI64_V_M1_M1_MASK,
  PseudoVLUXSEG8EI64_V_M1_MF2,
  PseudoVLUXSEG8EI64_V_M1_MF2_MASK,
  PseudoVLUXSEG8EI64_V_M1_MF4,
  PseudoVLUXSEG8EI64_V_M1_MF4_MASK,
  PseudoVLUXSEG8EI64_V_M1_MF8,
  PseudoVLUXSEG8EI64_V_M1_MF8_MASK,
  PseudoVLUXSEG8EI64_V_M2_M1,
  PseudoVLUXSEG8EI64_V_M2_M1_MASK,
  PseudoVLUXSEG8EI64_V_M2_MF2,
  PseudoVLUXSEG8EI64_V_M2_MF2_MASK,
  PseudoVLUXSEG8EI64_V_M2_MF4,
  PseudoVLUXSEG8EI64_V_M2_MF4_MASK,
  PseudoVLUXSEG8EI64_V_M4_M1,
  PseudoVLUXSEG8EI64_V_M4_M1_MASK,
  PseudoVLUXSEG8EI64_V_M4_MF2,
  PseudoVLUXSEG8EI64_V_M4_MF2_MASK,
  PseudoVLUXSEG8EI64_V_M8_M1,
  PseudoVLUXSEG8EI64_V_M8_M1_MASK,
  PseudoVLUXSEG8EI8_V_M1_M1,
  PseudoVLUXSEG8EI8_V_M1_M1_MASK,
  PseudoVLUXSEG8EI8_V_MF2_M1,
  PseudoVLUXSEG8EI8_V_MF2_M1_MASK,
  PseudoVLUXSEG8EI8_V_MF2_MF2,
  PseudoVLUXSEG8EI8_V_MF2_MF2_MASK,
  PseudoVLUXSEG8EI8_V_MF4_M1,
  PseudoVLUXSEG8EI8_V_MF4_M1_MASK,
  PseudoVLUXSEG8EI8_V_MF4_MF2,
  PseudoVLUXSEG8EI8_V_MF4_MF2_MASK,
  PseudoVLUXSEG8EI8_V_MF4_MF4,
  PseudoVLUXSEG8EI8_V_MF4_MF4_MASK,
  PseudoVLUXSEG8EI8_V_MF8_M1,
  PseudoVLUXSEG8EI8_V_MF8_M1_MASK,
  PseudoVLUXSEG8EI8_V_MF8_MF2,
  PseudoVLUXSEG8EI8_V_MF8_MF2_MASK,
  PseudoVLUXSEG8EI8_V_MF8_MF4,
  PseudoVLUXSEG8EI8_V_MF8_MF4_MASK,
  PseudoVLUXSEG8EI8_V_MF8_MF8,
  PseudoVLUXSEG8EI8_V_MF8_MF8_MASK,
  PseudoVMACC_VV_M1,
  PseudoVMACC_VV_M1_MASK,
  PseudoVMACC_VV_M2,
  PseudoVMACC_VV_M2_MASK,
  PseudoVMACC_VV_M4,
  PseudoVMACC_VV_M4_MASK,
  PseudoVMACC_VV_M8,
  PseudoVMACC_VV_M8_MASK,
  PseudoVMACC_VV_MF2,
  PseudoVMACC_VV_MF2_MASK,
  PseudoVMACC_VV_MF4,
  PseudoVMACC_VV_MF4_MASK,
  PseudoVMACC_VV_MF8,
  PseudoVMACC_VV_MF8_MASK,
  PseudoVMACC_VX_M1,
  PseudoVMACC_VX_M1_MASK,
  PseudoVMACC_VX_M2,
  PseudoVMACC_VX_M2_MASK,
  PseudoVMACC_VX_M4,
  PseudoVMACC_VX_M4_MASK,
  PseudoVMACC_VX_M8,
  PseudoVMACC_VX_M8_MASK,
  PseudoVMACC_VX_MF2,
  PseudoVMACC_VX_MF2_MASK,
  PseudoVMACC_VX_MF4,
  PseudoVMACC_VX_MF4_MASK,
  PseudoVMACC_VX_MF8,
  PseudoVMACC_VX_MF8_MASK,
  PseudoVMADC_VIM_M1,
  PseudoVMADC_VIM_M2,
  PseudoVMADC_VIM_M4,
  PseudoVMADC_VIM_M8,
  PseudoVMADC_VIM_MF2,
  PseudoVMADC_VIM_MF4,
  PseudoVMADC_VIM_MF8,
  PseudoVMADC_VI_M1,
  PseudoVMADC_VI_M2,
  PseudoVMADC_VI_M4,
  PseudoVMADC_VI_M8,
  PseudoVMADC_VI_MF2,
  PseudoVMADC_VI_MF4,
  PseudoVMADC_VI_MF8,
  PseudoVMADC_VVM_M1,
  PseudoVMADC_VVM_M2,
  PseudoVMADC_VVM_M4,
  PseudoVMADC_VVM_M8,
  PseudoVMADC_VVM_MF2,
  PseudoVMADC_VVM_MF4,
  PseudoVMADC_VVM_MF8,
  PseudoVMADC_VV_M1,
  PseudoVMADC_VV_M2,
  PseudoVMADC_VV_M4,
  PseudoVMADC_VV_M8,
  PseudoVMADC_VV_MF2,
  PseudoVMADC_VV_MF4,
  PseudoVMADC_VV_MF8,
  PseudoVMADC_VXM_M1,
  PseudoVMADC_VXM_M2,
  PseudoVMADC_VXM_M4,
  PseudoVMADC_VXM_M8,
  PseudoVMADC_VXM_MF2,
  PseudoVMADC_VXM_MF4,
  PseudoVMADC_VXM_MF8,
  PseudoVMADC_VX_M1,
  PseudoVMADC_VX_M2,
  PseudoVMADC_VX_M4,
  PseudoVMADC_VX_M8,
  PseudoVMADC_VX_MF2,
  PseudoVMADC_VX_MF4,
  PseudoVMADC_VX_MF8,
  PseudoVMADD_VV_M1,
  PseudoVMADD_VV_M1_MASK,
  PseudoVMADD_VV_M2,
  PseudoVMADD_VV_M2_MASK,
  PseudoVMADD_VV_M4,
  PseudoVMADD_VV_M4_MASK,
  PseudoVMADD_VV_M8,
  PseudoVMADD_VV_M8_MASK,
  PseudoVMADD_VV_MF2,
  PseudoVMADD_VV_MF2_MASK,
  PseudoVMADD_VV_MF4,
  PseudoVMADD_VV_MF4_MASK,
  PseudoVMADD_VV_MF8,
  PseudoVMADD_VV_MF8_MASK,
  PseudoVMADD_VX_M1,
  PseudoVMADD_VX_M1_MASK,
  PseudoVMADD_VX_M2,
  PseudoVMADD_VX_M2_MASK,
  PseudoVMADD_VX_M4,
  PseudoVMADD_VX_M4_MASK,
  PseudoVMADD_VX_M8,
  PseudoVMADD_VX_M8_MASK,
  PseudoVMADD_VX_MF2,
  PseudoVMADD_VX_MF2_MASK,
  PseudoVMADD_VX_MF4,
  PseudoVMADD_VX_MF4_MASK,
  PseudoVMADD_VX_MF8,
  PseudoVMADD_VX_MF8_MASK,
  PseudoVMANDN_MM_M1,
  PseudoVMANDN_MM_M2,
  PseudoVMANDN_MM_M4,
  PseudoVMANDN_MM_M8,
  PseudoVMANDN_MM_MF2,
  PseudoVMANDN_MM_MF4,
  PseudoVMANDN_MM_MF8,
  PseudoVMAND_MM_M1,
  PseudoVMAND_MM_M2,
  PseudoVMAND_MM_M4,
  PseudoVMAND_MM_M8,
  PseudoVMAND_MM_MF2,
  PseudoVMAND_MM_MF4,
  PseudoVMAND_MM_MF8,
  PseudoVMAXU_VV_M1,
  PseudoVMAXU_VV_M1_MASK,
  PseudoVMAXU_VV_M2,
  PseudoVMAXU_VV_M2_MASK,
  PseudoVMAXU_VV_M4,
  PseudoVMAXU_VV_M4_MASK,
  PseudoVMAXU_VV_M8,
  PseudoVMAXU_VV_M8_MASK,
  PseudoVMAXU_VV_MF2,
  PseudoVMAXU_VV_MF2_MASK,
  PseudoVMAXU_VV_MF4,
  PseudoVMAXU_VV_MF4_MASK,
  PseudoVMAXU_VV_MF8,
  PseudoVMAXU_VV_MF8_MASK,
  PseudoVMAXU_VX_M1,
  PseudoVMAXU_VX_M1_MASK,
  PseudoVMAXU_VX_M2,
  PseudoVMAXU_VX_M2_MASK,
  PseudoVMAXU_VX_M4,
  PseudoVMAXU_VX_M4_MASK,
  PseudoVMAXU_VX_M8,
  PseudoVMAXU_VX_M8_MASK,
  PseudoVMAXU_VX_MF2,
  PseudoVMAXU_VX_MF2_MASK,
  PseudoVMAXU_VX_MF4,
  PseudoVMAXU_VX_MF4_MASK,
  PseudoVMAXU_VX_MF8,
  PseudoVMAXU_VX_MF8_MASK,
  PseudoVMAX_VV_M1,
  PseudoVMAX_VV_M1_MASK,
  PseudoVMAX_VV_M2,
  PseudoVMAX_VV_M2_MASK,
  PseudoVMAX_VV_M4,
  PseudoVMAX_VV_M4_MASK,
  PseudoVMAX_VV_M8,
  PseudoVMAX_VV_M8_MASK,
  PseudoVMAX_VV_MF2,
  PseudoVMAX_VV_MF2_MASK,
  PseudoVMAX_VV_MF4,
  PseudoVMAX_VV_MF4_MASK,
  PseudoVMAX_VV_MF8,
  PseudoVMAX_VV_MF8_MASK,
  PseudoVMAX_VX_M1,
  PseudoVMAX_VX_M1_MASK,
  PseudoVMAX_VX_M2,
  PseudoVMAX_VX_M2_MASK,
  PseudoVMAX_VX_M4,
  PseudoVMAX_VX_M4_MASK,
  PseudoVMAX_VX_M8,
  PseudoVMAX_VX_M8_MASK,
  PseudoVMAX_VX_MF2,
  PseudoVMAX_VX_MF2_MASK,
  PseudoVMAX_VX_MF4,
  PseudoVMAX_VX_MF4_MASK,
  PseudoVMAX_VX_MF8,
  PseudoVMAX_VX_MF8_MASK,
  PseudoVMCLR_M_B1,
  PseudoVMCLR_M_B16,
  PseudoVMCLR_M_B2,
  PseudoVMCLR_M_B32,
  PseudoVMCLR_M_B4,
  PseudoVMCLR_M_B64,
  PseudoVMCLR_M_B8,
  PseudoVMERGE_VIM_M1,
  PseudoVMERGE_VIM_M2,
  PseudoVMERGE_VIM_M4,
  PseudoVMERGE_VIM_M8,
  PseudoVMERGE_VIM_MF2,
  PseudoVMERGE_VIM_MF4,
  PseudoVMERGE_VIM_MF8,
  PseudoVMERGE_VVM_M1,
  PseudoVMERGE_VVM_M2,
  PseudoVMERGE_VVM_M4,
  PseudoVMERGE_VVM_M8,
  PseudoVMERGE_VVM_MF2,
  PseudoVMERGE_VVM_MF4,
  PseudoVMERGE_VVM_MF8,
  PseudoVMERGE_VXM_M1,
  PseudoVMERGE_VXM_M2,
  PseudoVMERGE_VXM_M4,
  PseudoVMERGE_VXM_M8,
  PseudoVMERGE_VXM_MF2,
  PseudoVMERGE_VXM_MF4,
  PseudoVMERGE_VXM_MF8,
  PseudoVMFEQ_VFPR16_M1,
  PseudoVMFEQ_VFPR16_M1_MASK,
  PseudoVMFEQ_VFPR16_M2,
  PseudoVMFEQ_VFPR16_M2_MASK,
  PseudoVMFEQ_VFPR16_M4,
  PseudoVMFEQ_VFPR16_M4_MASK,
  PseudoVMFEQ_VFPR16_M8,
  PseudoVMFEQ_VFPR16_M8_MASK,
  PseudoVMFEQ_VFPR16_MF2,
  PseudoVMFEQ_VFPR16_MF2_MASK,
  PseudoVMFEQ_VFPR16_MF4,
  PseudoVMFEQ_VFPR16_MF4_MASK,
  PseudoVMFEQ_VFPR32_M1,
  PseudoVMFEQ_VFPR32_M1_MASK,
  PseudoVMFEQ_VFPR32_M2,
  PseudoVMFEQ_VFPR32_M2_MASK,
  PseudoVMFEQ_VFPR32_M4,
  PseudoVMFEQ_VFPR32_M4_MASK,
  PseudoVMFEQ_VFPR32_M8,
  PseudoVMFEQ_VFPR32_M8_MASK,
  PseudoVMFEQ_VFPR32_MF2,
  PseudoVMFEQ_VFPR32_MF2_MASK,
  PseudoVMFEQ_VFPR64_M1,
  PseudoVMFEQ_VFPR64_M1_MASK,
  PseudoVMFEQ_VFPR64_M2,
  PseudoVMFEQ_VFPR64_M2_MASK,
  PseudoVMFEQ_VFPR64_M4,
  PseudoVMFEQ_VFPR64_M4_MASK,
  PseudoVMFEQ_VFPR64_M8,
  PseudoVMFEQ_VFPR64_M8_MASK,
  PseudoVMFEQ_VV_M1,
  PseudoVMFEQ_VV_M1_MASK,
  PseudoVMFEQ_VV_M2,
  PseudoVMFEQ_VV_M2_MASK,
  PseudoVMFEQ_VV_M4,
  PseudoVMFEQ_VV_M4_MASK,
  PseudoVMFEQ_VV_M8,
  PseudoVMFEQ_VV_M8_MASK,
  PseudoVMFEQ_VV_MF2,
  PseudoVMFEQ_VV_MF2_MASK,
  PseudoVMFEQ_VV_MF4,
  PseudoVMFEQ_VV_MF4_MASK,
  PseudoVMFGE_VFPR16_M1,
  PseudoVMFGE_VFPR16_M1_MASK,
  PseudoVMFGE_VFPR16_M2,
  PseudoVMFGE_VFPR16_M2_MASK,
  PseudoVMFGE_VFPR16_M4,
  PseudoVMFGE_VFPR16_M4_MASK,
  PseudoVMFGE_VFPR16_M8,
  PseudoVMFGE_VFPR16_M8_MASK,
  PseudoVMFGE_VFPR16_MF2,
  PseudoVMFGE_VFPR16_MF2_MASK,
  PseudoVMFGE_VFPR16_MF4,
  PseudoVMFGE_VFPR16_MF4_MASK,
  PseudoVMFGE_VFPR32_M1,
  PseudoVMFGE_VFPR32_M1_MASK,
  PseudoVMFGE_VFPR32_M2,
  PseudoVMFGE_VFPR32_M2_MASK,
  PseudoVMFGE_VFPR32_M4,
  PseudoVMFGE_VFPR32_M4_MASK,
  PseudoVMFGE_VFPR32_M8,
  PseudoVMFGE_VFPR32_M8_MASK,
  PseudoVMFGE_VFPR32_MF2,
  PseudoVMFGE_VFPR32_MF2_MASK,
  PseudoVMFGE_VFPR64_M1,
  PseudoVMFGE_VFPR64_M1_MASK,
  PseudoVMFGE_VFPR64_M2,
  PseudoVMFGE_VFPR64_M2_MASK,
  PseudoVMFGE_VFPR64_M4,
  PseudoVMFGE_VFPR64_M4_MASK,
  PseudoVMFGE_VFPR64_M8,
  PseudoVMFGE_VFPR64_M8_MASK,
  PseudoVMFGT_VFPR16_M1,
  PseudoVMFGT_VFPR16_M1_MASK,
  PseudoVMFGT_VFPR16_M2,
  PseudoVMFGT_VFPR16_M2_MASK,
  PseudoVMFGT_VFPR16_M4,
  PseudoVMFGT_VFPR16_M4_MASK,
  PseudoVMFGT_VFPR16_M8,
  PseudoVMFGT_VFPR16_M8_MASK,
  PseudoVMFGT_VFPR16_MF2,
  PseudoVMFGT_VFPR16_MF2_MASK,
  PseudoVMFGT_VFPR16_MF4,
  PseudoVMFGT_VFPR16_MF4_MASK,
  PseudoVMFGT_VFPR32_M1,
  PseudoVMFGT_VFPR32_M1_MASK,
  PseudoVMFGT_VFPR32_M2,
  PseudoVMFGT_VFPR32_M2_MASK,
  PseudoVMFGT_VFPR32_M4,
  PseudoVMFGT_VFPR32_M4_MASK,
  PseudoVMFGT_VFPR32_M8,
  PseudoVMFGT_VFPR32_M8_MASK,
  PseudoVMFGT_VFPR32_MF2,
  PseudoVMFGT_VFPR32_MF2_MASK,
  PseudoVMFGT_VFPR64_M1,
  PseudoVMFGT_VFPR64_M1_MASK,
  PseudoVMFGT_VFPR64_M2,
  PseudoVMFGT_VFPR64_M2_MASK,
  PseudoVMFGT_VFPR64_M4,
  PseudoVMFGT_VFPR64_M4_MASK,
  PseudoVMFGT_VFPR64_M8,
  PseudoVMFGT_VFPR64_M8_MASK,
  PseudoVMFLE_VFPR16_M1,
  PseudoVMFLE_VFPR16_M1_MASK,
  PseudoVMFLE_VFPR16_M2,
  PseudoVMFLE_VFPR16_M2_MASK,
  PseudoVMFLE_VFPR16_M4,
  PseudoVMFLE_VFPR16_M4_MASK,
  PseudoVMFLE_VFPR16_M8,
  PseudoVMFLE_VFPR16_M8_MASK,
  PseudoVMFLE_VFPR16_MF2,
  PseudoVMFLE_VFPR16_MF2_MASK,
  PseudoVMFLE_VFPR16_MF4,
  PseudoVMFLE_VFPR16_MF4_MASK,
  PseudoVMFLE_VFPR32_M1,
  PseudoVMFLE_VFPR32_M1_MASK,
  PseudoVMFLE_VFPR32_M2,
  PseudoVMFLE_VFPR32_M2_MASK,
  PseudoVMFLE_VFPR32_M4,
  PseudoVMFLE_VFPR32_M4_MASK,
  PseudoVMFLE_VFPR32_M8,
  PseudoVMFLE_VFPR32_M8_MASK,
  PseudoVMFLE_VFPR32_MF2,
  PseudoVMFLE_VFPR32_MF2_MASK,
  PseudoVMFLE_VFPR64_M1,
  PseudoVMFLE_VFPR64_M1_MASK,
  PseudoVMFLE_VFPR64_M2,
  PseudoVMFLE_VFPR64_M2_MASK,
  PseudoVMFLE_VFPR64_M4,
  PseudoVMFLE_VFPR64_M4_MASK,
  PseudoVMFLE_VFPR64_M8,
  PseudoVMFLE_VFPR64_M8_MASK,
  PseudoVMFLE_VV_M1,
  PseudoVMFLE_VV_M1_MASK,
  PseudoVMFLE_VV_M2,
  PseudoVMFLE_VV_M2_MASK,
  PseudoVMFLE_VV_M4,
  PseudoVMFLE_VV_M4_MASK,
  PseudoVMFLE_VV_M8,
  PseudoVMFLE_VV_M8_MASK,
  PseudoVMFLE_VV_MF2,
  PseudoVMFLE_VV_MF2_MASK,
  PseudoVMFLE_VV_MF4,
  PseudoVMFLE_VV_MF4_MASK,
  PseudoVMFLT_VFPR16_M1,
  PseudoVMFLT_VFPR16_M1_MASK,
  PseudoVMFLT_VFPR16_M2,
  PseudoVMFLT_VFPR16_M2_MASK,
  PseudoVMFLT_VFPR16_M4,
  PseudoVMFLT_VFPR16_M4_MASK,
  PseudoVMFLT_VFPR16_M8,
  PseudoVMFLT_VFPR16_M8_MASK,
  PseudoVMFLT_VFPR16_MF2,
  PseudoVMFLT_VFPR16_MF2_MASK,
  PseudoVMFLT_VFPR16_MF4,
  PseudoVMFLT_VFPR16_MF4_MASK,
  PseudoVMFLT_VFPR32_M1,
  PseudoVMFLT_VFPR32_M1_MASK,
  PseudoVMFLT_VFPR32_M2,
  PseudoVMFLT_VFPR32_M2_MASK,
  PseudoVMFLT_VFPR32_M4,
  PseudoVMFLT_VFPR32_M4_MASK,
  PseudoVMFLT_VFPR32_M8,
  PseudoVMFLT_VFPR32_M8_MASK,
  PseudoVMFLT_VFPR32_MF2,
  PseudoVMFLT_VFPR32_MF2_MASK,
  PseudoVMFLT_VFPR64_M1,
  PseudoVMFLT_VFPR64_M1_MASK,
  PseudoVMFLT_VFPR64_M2,
  PseudoVMFLT_VFPR64_M2_MASK,
  PseudoVMFLT_VFPR64_M4,
  PseudoVMFLT_VFPR64_M4_MASK,
  PseudoVMFLT_VFPR64_M8,
  PseudoVMFLT_VFPR64_M8_MASK,
  PseudoVMFLT_VV_M1,
  PseudoVMFLT_VV_M1_MASK,
  PseudoVMFLT_VV_M2,
  PseudoVMFLT_VV_M2_MASK,
  PseudoVMFLT_VV_M4,
  PseudoVMFLT_VV_M4_MASK,
  PseudoVMFLT_VV_M8,
  PseudoVMFLT_VV_M8_MASK,
  PseudoVMFLT_VV_MF2,
  PseudoVMFLT_VV_MF2_MASK,
  PseudoVMFLT_VV_MF4,
  PseudoVMFLT_VV_MF4_MASK,
  PseudoVMFNE_VFPR16_M1,
  PseudoVMFNE_VFPR16_M1_MASK,
  PseudoVMFNE_VFPR16_M2,
  PseudoVMFNE_VFPR16_M2_MASK,
  PseudoVMFNE_VFPR16_M4,
  PseudoVMFNE_VFPR16_M4_MASK,
  PseudoVMFNE_VFPR16_M8,
  PseudoVMFNE_VFPR16_M8_MASK,
  PseudoVMFNE_VFPR16_MF2,
  PseudoVMFNE_VFPR16_MF2_MASK,
  PseudoVMFNE_VFPR16_MF4,
  PseudoVMFNE_VFPR16_MF4_MASK,
  PseudoVMFNE_VFPR32_M1,
  PseudoVMFNE_VFPR32_M1_MASK,
  PseudoVMFNE_VFPR32_M2,
  PseudoVMFNE_VFPR32_M2_MASK,
  PseudoVMFNE_VFPR32_M4,
  PseudoVMFNE_VFPR32_M4_MASK,
  PseudoVMFNE_VFPR32_M8,
  PseudoVMFNE_VFPR32_M8_MASK,
  PseudoVMFNE_VFPR32_MF2,
  PseudoVMFNE_VFPR32_MF2_MASK,
  PseudoVMFNE_VFPR64_M1,
  PseudoVMFNE_VFPR64_M1_MASK,
  PseudoVMFNE_VFPR64_M2,
  PseudoVMFNE_VFPR64_M2_MASK,
  PseudoVMFNE_VFPR64_M4,
  PseudoVMFNE_VFPR64_M4_MASK,
  PseudoVMFNE_VFPR64_M8,
  PseudoVMFNE_VFPR64_M8_MASK,
  PseudoVMFNE_VV_M1,
  PseudoVMFNE_VV_M1_MASK,
  PseudoVMFNE_VV_M2,
  PseudoVMFNE_VV_M2_MASK,
  PseudoVMFNE_VV_M4,
  PseudoVMFNE_VV_M4_MASK,
  PseudoVMFNE_VV_M8,
  PseudoVMFNE_VV_M8_MASK,
  PseudoVMFNE_VV_MF2,
  PseudoVMFNE_VV_MF2_MASK,
  PseudoVMFNE_VV_MF4,
  PseudoVMFNE_VV_MF4_MASK,
  PseudoVMINU_VV_M1,
  PseudoVMINU_VV_M1_MASK,
  PseudoVMINU_VV_M2,
  PseudoVMINU_VV_M2_MASK,
  PseudoVMINU_VV_M4,
  PseudoVMINU_VV_M4_MASK,
  PseudoVMINU_VV_M8,
  PseudoVMINU_VV_M8_MASK,
  PseudoVMINU_VV_MF2,
  PseudoVMINU_VV_MF2_MASK,
  PseudoVMINU_VV_MF4,
  PseudoVMINU_VV_MF4_MASK,
  PseudoVMINU_VV_MF8,
  PseudoVMINU_VV_MF8_MASK,
  PseudoVMINU_VX_M1,
  PseudoVMINU_VX_M1_MASK,
  PseudoVMINU_VX_M2,
  PseudoVMINU_VX_M2_MASK,
  PseudoVMINU_VX_M4,
  PseudoVMINU_VX_M4_MASK,
  PseudoVMINU_VX_M8,
  PseudoVMINU_VX_M8_MASK,
  PseudoVMINU_VX_MF2,
  PseudoVMINU_VX_MF2_MASK,
  PseudoVMINU_VX_MF4,
  PseudoVMINU_VX_MF4_MASK,
  PseudoVMINU_VX_MF8,
  PseudoVMINU_VX_MF8_MASK,
  PseudoVMIN_VV_M1,
  PseudoVMIN_VV_M1_MASK,
  PseudoVMIN_VV_M2,
  PseudoVMIN_VV_M2_MASK,
  PseudoVMIN_VV_M4,
  PseudoVMIN_VV_M4_MASK,
  PseudoVMIN_VV_M8,
  PseudoVMIN_VV_M8_MASK,
  PseudoVMIN_VV_MF2,
  PseudoVMIN_VV_MF2_MASK,
  PseudoVMIN_VV_MF4,
  PseudoVMIN_VV_MF4_MASK,
  PseudoVMIN_VV_MF8,
  PseudoVMIN_VV_MF8_MASK,
  PseudoVMIN_VX_M1,
  PseudoVMIN_VX_M1_MASK,
  PseudoVMIN_VX_M2,
  PseudoVMIN_VX_M2_MASK,
  PseudoVMIN_VX_M4,
  PseudoVMIN_VX_M4_MASK,
  PseudoVMIN_VX_M8,
  PseudoVMIN_VX_M8_MASK,
  PseudoVMIN_VX_MF2,
  PseudoVMIN_VX_MF2_MASK,
  PseudoVMIN_VX_MF4,
  PseudoVMIN_VX_MF4_MASK,
  PseudoVMIN_VX_MF8,
  PseudoVMIN_VX_MF8_MASK,
  PseudoVMNAND_MM_M1,
  PseudoVMNAND_MM_M2,
  PseudoVMNAND_MM_M4,
  PseudoVMNAND_MM_M8,
  PseudoVMNAND_MM_MF2,
  PseudoVMNAND_MM_MF4,
  PseudoVMNAND_MM_MF8,
  PseudoVMNOR_MM_M1,
  PseudoVMNOR_MM_M2,
  PseudoVMNOR_MM_M4,
  PseudoVMNOR_MM_M8,
  PseudoVMNOR_MM_MF2,
  PseudoVMNOR_MM_MF4,
  PseudoVMNOR_MM_MF8,
  PseudoVMORN_MM_M1,
  PseudoVMORN_MM_M2,
  PseudoVMORN_MM_M4,
  PseudoVMORN_MM_M8,
  PseudoVMORN_MM_MF2,
  PseudoVMORN_MM_MF4,
  PseudoVMORN_MM_MF8,
  PseudoVMOR_MM_M1,
  PseudoVMOR_MM_M2,
  PseudoVMOR_MM_M4,
  PseudoVMOR_MM_M8,
  PseudoVMOR_MM_MF2,
  PseudoVMOR_MM_MF4,
  PseudoVMOR_MM_MF8,
  PseudoVMSBC_VVM_M1,
  PseudoVMSBC_VVM_M2,
  PseudoVMSBC_VVM_M4,
  PseudoVMSBC_VVM_M8,
  PseudoVMSBC_VVM_MF2,
  PseudoVMSBC_VVM_MF4,
  PseudoVMSBC_VVM_MF8,
  PseudoVMSBC_VV_M1,
  PseudoVMSBC_VV_M2,
  PseudoVMSBC_VV_M4,
  PseudoVMSBC_VV_M8,
  PseudoVMSBC_VV_MF2,
  PseudoVMSBC_VV_MF4,
  PseudoVMSBC_VV_MF8,
  PseudoVMSBC_VXM_M1,
  PseudoVMSBC_VXM_M2,
  PseudoVMSBC_VXM_M4,
  PseudoVMSBC_VXM_M8,
  PseudoVMSBC_VXM_MF2,
  PseudoVMSBC_VXM_MF4,
  PseudoVMSBC_VXM_MF8,
  PseudoVMSBC_VX_M1,
  PseudoVMSBC_VX_M2,
  PseudoVMSBC_VX_M4,
  PseudoVMSBC_VX_M8,
  PseudoVMSBC_VX_MF2,
  PseudoVMSBC_VX_MF4,
  PseudoVMSBC_VX_MF8,
  PseudoVMSBF_M_B1,
  PseudoVMSBF_M_B16,
  PseudoVMSBF_M_B16_MASK,
  PseudoVMSBF_M_B1_MASK,
  PseudoVMSBF_M_B2,
  PseudoVMSBF_M_B2_MASK,
  PseudoVMSBF_M_B32,
  PseudoVMSBF_M_B32_MASK,
  PseudoVMSBF_M_B4,
  PseudoVMSBF_M_B4_MASK,
  PseudoVMSBF_M_B64,
  PseudoVMSBF_M_B64_MASK,
  PseudoVMSBF_M_B8,
  PseudoVMSBF_M_B8_MASK,
  PseudoVMSEQ_VI_M1,
  PseudoVMSEQ_VI_M1_MASK,
  PseudoVMSEQ_VI_M2,
  PseudoVMSEQ_VI_M2_MASK,
  PseudoVMSEQ_VI_M4,
  PseudoVMSEQ_VI_M4_MASK,
  PseudoVMSEQ_VI_M8,
  PseudoVMSEQ_VI_M8_MASK,
  PseudoVMSEQ_VI_MF2,
  PseudoVMSEQ_VI_MF2_MASK,
  PseudoVMSEQ_VI_MF4,
  PseudoVMSEQ_VI_MF4_MASK,
  PseudoVMSEQ_VI_MF8,
  PseudoVMSEQ_VI_MF8_MASK,
  PseudoVMSEQ_VV_M1,
  PseudoVMSEQ_VV_M1_MASK,
  PseudoVMSEQ_VV_M2,
  PseudoVMSEQ_VV_M2_MASK,
  PseudoVMSEQ_VV_M4,
  PseudoVMSEQ_VV_M4_MASK,
  PseudoVMSEQ_VV_M8,
  PseudoVMSEQ_VV_M8_MASK,
  PseudoVMSEQ_VV_MF2,
  PseudoVMSEQ_VV_MF2_MASK,
  PseudoVMSEQ_VV_MF4,
  PseudoVMSEQ_VV_MF4_MASK,
  PseudoVMSEQ_VV_MF8,
  PseudoVMSEQ_VV_MF8_MASK,
  PseudoVMSEQ_VX_M1,
  PseudoVMSEQ_VX_M1_MASK,
  PseudoVMSEQ_VX_M2,
  PseudoVMSEQ_VX_M2_MASK,
  PseudoVMSEQ_VX_M4,
  PseudoVMSEQ_VX_M4_MASK,
  PseudoVMSEQ_VX_M8,
  PseudoVMSEQ_VX_M8_MASK,
  PseudoVMSEQ_VX_MF2,
  PseudoVMSEQ_VX_MF2_MASK,
  PseudoVMSEQ_VX_MF4,
  PseudoVMSEQ_VX_MF4_MASK,
  PseudoVMSEQ_VX_MF8,
  PseudoVMSEQ_VX_MF8_MASK,
  PseudoVMSET_M_B1,
  PseudoVMSET_M_B16,
  PseudoVMSET_M_B2,
  PseudoVMSET_M_B32,
  PseudoVMSET_M_B4,
  PseudoVMSET_M_B64,
  PseudoVMSET_M_B8,
  PseudoVMSGEU_VI,
  PseudoVMSGEU_VX,
  PseudoVMSGEU_VX_M,
  PseudoVMSGEU_VX_M_T,
  PseudoVMSGE_VI,
  PseudoVMSGE_VX,
  PseudoVMSGE_VX_M,
  PseudoVMSGE_VX_M_T,
  PseudoVMSGTU_VI_M1,
  PseudoVMSGTU_VI_M1_MASK,
  PseudoVMSGTU_VI_M2,
  PseudoVMSGTU_VI_M2_MASK,
  PseudoVMSGTU_VI_M4,
  PseudoVMSGTU_VI_M4_MASK,
  PseudoVMSGTU_VI_M8,
  PseudoVMSGTU_VI_M8_MASK,
  PseudoVMSGTU_VI_MF2,
  PseudoVMSGTU_VI_MF2_MASK,
  PseudoVMSGTU_VI_MF4,
  PseudoVMSGTU_VI_MF4_MASK,
  PseudoVMSGTU_VI_MF8,
  PseudoVMSGTU_VI_MF8_MASK,
  PseudoVMSGTU_VX_M1,
  PseudoVMSGTU_VX_M1_MASK,
  PseudoVMSGTU_VX_M2,
  PseudoVMSGTU_VX_M2_MASK,
  PseudoVMSGTU_VX_M4,
  PseudoVMSGTU_VX_M4_MASK,
  PseudoVMSGTU_VX_M8,
  PseudoVMSGTU_VX_M8_MASK,
  PseudoVMSGTU_VX_MF2,
  PseudoVMSGTU_VX_MF2_MASK,
  PseudoVMSGTU_VX_MF4,
  PseudoVMSGTU_VX_MF4_MASK,
  PseudoVMSGTU_VX_MF8,
  PseudoVMSGTU_VX_MF8_MASK,
  PseudoVMSGT_VI_M1,
  PseudoVMSGT_VI_M1_MASK,
  PseudoVMSGT_VI_M2,
  PseudoVMSGT_VI_M2_MASK,
  PseudoVMSGT_VI_M4,
  PseudoVMSGT_VI_M4_MASK,
  PseudoVMSGT_VI_M8,
  PseudoVMSGT_VI_M8_MASK,
  PseudoVMSGT_VI_MF2,
  PseudoVMSGT_VI_MF2_MASK,
  PseudoVMSGT_VI_MF4,
  PseudoVMSGT_VI_MF4_MASK,
  PseudoVMSGT_VI_MF8,
  PseudoVMSGT_VI_MF8_MASK,
  PseudoVMSGT_VX_M1,
  PseudoVMSGT_VX_M1_MASK,
  PseudoVMSGT_VX_M2,
  PseudoVMSGT_VX_M2_MASK,
  PseudoVMSGT_VX_M4,
  PseudoVMSGT_VX_M4_MASK,
  PseudoVMSGT_VX_M8,
  PseudoVMSGT_VX_M8_MASK,
  PseudoVMSGT_VX_MF2,
  PseudoVMSGT_VX_MF2_MASK,
  PseudoVMSGT_VX_MF4,
  PseudoVMSGT_VX_MF4_MASK,
  PseudoVMSGT_VX_MF8,
  PseudoVMSGT_VX_MF8_MASK,
  PseudoVMSIF_M_B1,
  PseudoVMSIF_M_B16,
  PseudoVMSIF_M_B16_MASK,
  PseudoVMSIF_M_B1_MASK,
  PseudoVMSIF_M_B2,
  PseudoVMSIF_M_B2_MASK,
  PseudoVMSIF_M_B32,
  PseudoVMSIF_M_B32_MASK,
  PseudoVMSIF_M_B4,
  PseudoVMSIF_M_B4_MASK,
  PseudoVMSIF_M_B64,
  PseudoVMSIF_M_B64_MASK,
  PseudoVMSIF_M_B8,
  PseudoVMSIF_M_B8_MASK,
  PseudoVMSLEU_VI_M1,
  PseudoVMSLEU_VI_M1_MASK,
  PseudoVMSLEU_VI_M2,
  PseudoVMSLEU_VI_M2_MASK,
  PseudoVMSLEU_VI_M4,
  PseudoVMSLEU_VI_M4_MASK,
  PseudoVMSLEU_VI_M8,
  PseudoVMSLEU_VI_M8_MASK,
  PseudoVMSLEU_VI_MF2,
  PseudoVMSLEU_VI_MF2_MASK,
  PseudoVMSLEU_VI_MF4,
  PseudoVMSLEU_VI_MF4_MASK,
  PseudoVMSLEU_VI_MF8,
  PseudoVMSLEU_VI_MF8_MASK,
  PseudoVMSLEU_VV_M1,
  PseudoVMSLEU_VV_M1_MASK,
  PseudoVMSLEU_VV_M2,
  PseudoVMSLEU_VV_M2_MASK,
  PseudoVMSLEU_VV_M4,
  PseudoVMSLEU_VV_M4_MASK,
  PseudoVMSLEU_VV_M8,
  PseudoVMSLEU_VV_M8_MASK,
  PseudoVMSLEU_VV_MF2,
  PseudoVMSLEU_VV_MF2_MASK,
  PseudoVMSLEU_VV_MF4,
  PseudoVMSLEU_VV_MF4_MASK,
  PseudoVMSLEU_VV_MF8,
  PseudoVMSLEU_VV_MF8_MASK,
  PseudoVMSLEU_VX_M1,
  PseudoVMSLEU_VX_M1_MASK,
  PseudoVMSLEU_VX_M2,
  PseudoVMSLEU_VX_M2_MASK,
  PseudoVMSLEU_VX_M4,
  PseudoVMSLEU_VX_M4_MASK,
  PseudoVMSLEU_VX_M8,
  PseudoVMSLEU_VX_M8_MASK,
  PseudoVMSLEU_VX_MF2,
  PseudoVMSLEU_VX_MF2_MASK,
  PseudoVMSLEU_VX_MF4,
  PseudoVMSLEU_VX_MF4_MASK,
  PseudoVMSLEU_VX_MF8,
  PseudoVMSLEU_VX_MF8_MASK,
  PseudoVMSLE_VI_M1,
  PseudoVMSLE_VI_M1_MASK,
  PseudoVMSLE_VI_M2,
  PseudoVMSLE_VI_M2_MASK,
  PseudoVMSLE_VI_M4,
  PseudoVMSLE_VI_M4_MASK,
  PseudoVMSLE_VI_M8,
  PseudoVMSLE_VI_M8_MASK,
  PseudoVMSLE_VI_MF2,
  PseudoVMSLE_VI_MF2_MASK,
  PseudoVMSLE_VI_MF4,
  PseudoVMSLE_VI_MF4_MASK,
  PseudoVMSLE_VI_MF8,
  PseudoVMSLE_VI_MF8_MASK,
  PseudoVMSLE_VV_M1,
  PseudoVMSLE_VV_M1_MASK,
  PseudoVMSLE_VV_M2,
  PseudoVMSLE_VV_M2_MASK,
  PseudoVMSLE_VV_M4,
  PseudoVMSLE_VV_M4_MASK,
  PseudoVMSLE_VV_M8,
  PseudoVMSLE_VV_M8_MASK,
  PseudoVMSLE_VV_MF2,
  PseudoVMSLE_VV_MF2_MASK,
  PseudoVMSLE_VV_MF4,
  PseudoVMSLE_VV_MF4_MASK,
  PseudoVMSLE_VV_MF8,
  PseudoVMSLE_VV_MF8_MASK,
  PseudoVMSLE_VX_M1,
  PseudoVMSLE_VX_M1_MASK,
  PseudoVMSLE_VX_M2,
  PseudoVMSLE_VX_M2_MASK,
  PseudoVMSLE_VX_M4,
  PseudoVMSLE_VX_M4_MASK,
  PseudoVMSLE_VX_M8,
  PseudoVMSLE_VX_M8_MASK,
  PseudoVMSLE_VX_MF2,
  PseudoVMSLE_VX_MF2_MASK,
  PseudoVMSLE_VX_MF4,
  PseudoVMSLE_VX_MF4_MASK,
  PseudoVMSLE_VX_MF8,
  PseudoVMSLE_VX_MF8_MASK,
  PseudoVMSLTU_VI,
  PseudoVMSLTU_VV_M1,
  PseudoVMSLTU_VV_M1_MASK,
  PseudoVMSLTU_VV_M2,
  PseudoVMSLTU_VV_M2_MASK,
  PseudoVMSLTU_VV_M4,
  PseudoVMSLTU_VV_M4_MASK,
  PseudoVMSLTU_VV_M8,
  PseudoVMSLTU_VV_M8_MASK,
  PseudoVMSLTU_VV_MF2,
  PseudoVMSLTU_VV_MF2_MASK,
  PseudoVMSLTU_VV_MF4,
  PseudoVMSLTU_VV_MF4_MASK,
  PseudoVMSLTU_VV_MF8,
  PseudoVMSLTU_VV_MF8_MASK,
  PseudoVMSLTU_VX_M1,
  PseudoVMSLTU_VX_M1_MASK,
  PseudoVMSLTU_VX_M2,
  PseudoVMSLTU_VX_M2_MASK,
  PseudoVMSLTU_VX_M4,
  PseudoVMSLTU_VX_M4_MASK,
  PseudoVMSLTU_VX_M8,
  PseudoVMSLTU_VX_M8_MASK,
  PseudoVMSLTU_VX_MF2,
  PseudoVMSLTU_VX_MF2_MASK,
  PseudoVMSLTU_VX_MF4,
  PseudoVMSLTU_VX_MF4_MASK,
  PseudoVMSLTU_VX_MF8,
  PseudoVMSLTU_VX_MF8_MASK,
  PseudoVMSLT_VI,
  PseudoVMSLT_VV_M1,
  PseudoVMSLT_VV_M1_MASK,
  PseudoVMSLT_VV_M2,
  PseudoVMSLT_VV_M2_MASK,
  PseudoVMSLT_VV_M4,
  PseudoVMSLT_VV_M4_MASK,
  PseudoVMSLT_VV_M8,
  PseudoVMSLT_VV_M8_MASK,
  PseudoVMSLT_VV_MF2,
  PseudoVMSLT_VV_MF2_MASK,
  PseudoVMSLT_VV_MF4,
  PseudoVMSLT_VV_MF4_MASK,
  PseudoVMSLT_VV_MF8,
  PseudoVMSLT_VV_MF8_MASK,
  PseudoVMSLT_VX_M1,
  PseudoVMSLT_VX_M1_MASK,
  PseudoVMSLT_VX_M2,
  PseudoVMSLT_VX_M2_MASK,
  PseudoVMSLT_VX_M4,
  PseudoVMSLT_VX_M4_MASK,
  PseudoVMSLT_VX_M8,
  PseudoVMSLT_VX_M8_MASK,
  PseudoVMSLT_VX_MF2,
  PseudoVMSLT_VX_MF2_MASK,
  PseudoVMSLT_VX_MF4,
  PseudoVMSLT_VX_MF4_MASK,
  PseudoVMSLT_VX_MF8,
  PseudoVMSLT_VX_MF8_MASK,
  PseudoVMSNE_VI_M1,
  PseudoVMSNE_VI_M1_MASK,
  PseudoVMSNE_VI_M2,
  PseudoVMSNE_VI_M2_MASK,
  PseudoVMSNE_VI_M4,
  PseudoVMSNE_VI_M4_MASK,
  PseudoVMSNE_VI_M8,
  PseudoVMSNE_VI_M8_MASK,
  PseudoVMSNE_VI_MF2,
  PseudoVMSNE_VI_MF2_MASK,
  PseudoVMSNE_VI_MF4,
  PseudoVMSNE_VI_MF4_MASK,
  PseudoVMSNE_VI_MF8,
  PseudoVMSNE_VI_MF8_MASK,
  PseudoVMSNE_VV_M1,
  PseudoVMSNE_VV_M1_MASK,
  PseudoVMSNE_VV_M2,
  PseudoVMSNE_VV_M2_MASK,
  PseudoVMSNE_VV_M4,
  PseudoVMSNE_VV_M4_MASK,
  PseudoVMSNE_VV_M8,
  PseudoVMSNE_VV_M8_MASK,
  PseudoVMSNE_VV_MF2,
  PseudoVMSNE_VV_MF2_MASK,
  PseudoVMSNE_VV_MF4,
  PseudoVMSNE_VV_MF4_MASK,
  PseudoVMSNE_VV_MF8,
  PseudoVMSNE_VV_MF8_MASK,
  PseudoVMSNE_VX_M1,
  PseudoVMSNE_VX_M1_MASK,
  PseudoVMSNE_VX_M2,
  PseudoVMSNE_VX_M2_MASK,
  PseudoVMSNE_VX_M4,
  PseudoVMSNE_VX_M4_MASK,
  PseudoVMSNE_VX_M8,
  PseudoVMSNE_VX_M8_MASK,
  PseudoVMSNE_VX_MF2,
  PseudoVMSNE_VX_MF2_MASK,
  PseudoVMSNE_VX_MF4,
  PseudoVMSNE_VX_MF4_MASK,
  PseudoVMSNE_VX_MF8,
  PseudoVMSNE_VX_MF8_MASK,
  PseudoVMSOF_M_B1,
  PseudoVMSOF_M_B16,
  PseudoVMSOF_M_B16_MASK,
  PseudoVMSOF_M_B1_MASK,
  PseudoVMSOF_M_B2,
  PseudoVMSOF_M_B2_MASK,
  PseudoVMSOF_M_B32,
  PseudoVMSOF_M_B32_MASK,
  PseudoVMSOF_M_B4,
  PseudoVMSOF_M_B4_MASK,
  PseudoVMSOF_M_B64,
  PseudoVMSOF_M_B64_MASK,
  PseudoVMSOF_M_B8,
  PseudoVMSOF_M_B8_MASK,
  PseudoVMULHSU_VV_M1,
  PseudoVMULHSU_VV_M1_MASK,
  PseudoVMULHSU_VV_M2,
  PseudoVMULHSU_VV_M2_MASK,
  PseudoVMULHSU_VV_M4,
  PseudoVMULHSU_VV_M4_MASK,
  PseudoVMULHSU_VV_M8,
  PseudoVMULHSU_VV_M8_MASK,
  PseudoVMULHSU_VV_MF2,
  PseudoVMULHSU_VV_MF2_MASK,
  PseudoVMULHSU_VV_MF4,
  PseudoVMULHSU_VV_MF4_MASK,
  PseudoVMULHSU_VV_MF8,
  PseudoVMULHSU_VV_MF8_MASK,
  PseudoVMULHSU_VX_M1,
  PseudoVMULHSU_VX_M1_MASK,
  PseudoVMULHSU_VX_M2,
  PseudoVMULHSU_VX_M2_MASK,
  PseudoVMULHSU_VX_M4,
  PseudoVMULHSU_VX_M4_MASK,
  PseudoVMULHSU_VX_M8,
  PseudoVMULHSU_VX_M8_MASK,
  PseudoVMULHSU_VX_MF2,
  PseudoVMULHSU_VX_MF2_MASK,
  PseudoVMULHSU_VX_MF4,
  PseudoVMULHSU_VX_MF4_MASK,
  PseudoVMULHSU_VX_MF8,
  PseudoVMULHSU_VX_MF8_MASK,
  PseudoVMULHU_VV_M1,
  PseudoVMULHU_VV_M1_MASK,
  PseudoVMULHU_VV_M2,
  PseudoVMULHU_VV_M2_MASK,
  PseudoVMULHU_VV_M4,
  PseudoVMULHU_VV_M4_MASK,
  PseudoVMULHU_VV_M8,
  PseudoVMULHU_VV_M8_MASK,
  PseudoVMULHU_VV_MF2,
  PseudoVMULHU_VV_MF2_MASK,
  PseudoVMULHU_VV_MF4,
  PseudoVMULHU_VV_MF4_MASK,
  PseudoVMULHU_VV_MF8,
  PseudoVMULHU_VV_MF8_MASK,
  PseudoVMULHU_VX_M1,
  PseudoVMULHU_VX_M1_MASK,
  PseudoVMULHU_VX_M2,
  PseudoVMULHU_VX_M2_MASK,
  PseudoVMULHU_VX_M4,
  PseudoVMULHU_VX_M4_MASK,
  PseudoVMULHU_VX_M8,
  PseudoVMULHU_VX_M8_MASK,
  PseudoVMULHU_VX_MF2,
  PseudoVMULHU_VX_MF2_MASK,
  PseudoVMULHU_VX_MF4,
  PseudoVMULHU_VX_MF4_MASK,
  PseudoVMULHU_VX_MF8,
  PseudoVMULHU_VX_MF8_MASK,
  PseudoVMULH_VV_M1,
  PseudoVMULH_VV_M1_MASK,
  PseudoVMULH_VV_M2,
  PseudoVMULH_VV_M2_MASK,
  PseudoVMULH_VV_M4,
  PseudoVMULH_VV_M4_MASK,
  PseudoVMULH_VV_M8,
  PseudoVMULH_VV_M8_MASK,
  PseudoVMULH_VV_MF2,
  PseudoVMULH_VV_MF2_MASK,
  PseudoVMULH_VV_MF4,
  PseudoVMULH_VV_MF4_MASK,
  PseudoVMULH_VV_MF8,
  PseudoVMULH_VV_MF8_MASK,
  PseudoVMULH_VX_M1,
  PseudoVMULH_VX_M1_MASK,
  PseudoVMULH_VX_M2,
  PseudoVMULH_VX_M2_MASK,
  PseudoVMULH_VX_M4,
  PseudoVMULH_VX_M4_MASK,
  PseudoVMULH_VX_M8,
  PseudoVMULH_VX_M8_MASK,
  PseudoVMULH_VX_MF2,
  PseudoVMULH_VX_MF2_MASK,
  PseudoVMULH_VX_MF4,
  PseudoVMULH_VX_MF4_MASK,
  PseudoVMULH_VX_MF8,
  PseudoVMULH_VX_MF8_MASK,
  PseudoVMUL_VV_M1,
  PseudoVMUL_VV_M1_MASK,
  PseudoVMUL_VV_M2,
  PseudoVMUL_VV_M2_MASK,
  PseudoVMUL_VV_M4,
  PseudoVMUL_VV_M4_MASK,
  PseudoVMUL_VV_M8,
  PseudoVMUL_VV_M8_MASK,
  PseudoVMUL_VV_MF2,
  PseudoVMUL_VV_MF2_MASK,
  PseudoVMUL_VV_MF4,
  PseudoVMUL_VV_MF4_MASK,
  PseudoVMUL_VV_MF8,
  PseudoVMUL_VV_MF8_MASK,
  PseudoVMUL_VX_M1,
  PseudoVMUL_VX_M1_MASK,
  PseudoVMUL_VX_M2,
  PseudoVMUL_VX_M2_MASK,
  PseudoVMUL_VX_M4,
  PseudoVMUL_VX_M4_MASK,
  PseudoVMUL_VX_M8,
  PseudoVMUL_VX_M8_MASK,
  PseudoVMUL_VX_MF2,
  PseudoVMUL_VX_MF2_MASK,
  PseudoVMUL_VX_MF4,
  PseudoVMUL_VX_MF4_MASK,
  PseudoVMUL_VX_MF8,
  PseudoVMUL_VX_MF8_MASK,
  PseudoVMV_S_X,
  PseudoVMV_V_I_M1,
  PseudoVMV_V_I_M2,
  PseudoVMV_V_I_M4,
  PseudoVMV_V_I_M8,
  PseudoVMV_V_I_MF2,
  PseudoVMV_V_I_MF4,
  PseudoVMV_V_I_MF8,
  PseudoVMV_V_V_M1,
  PseudoVMV_V_V_M2,
  PseudoVMV_V_V_M4,
  PseudoVMV_V_V_M8,
  PseudoVMV_V_V_MF2,
  PseudoVMV_V_V_MF4,
  PseudoVMV_V_V_MF8,
  PseudoVMV_V_X_M1,
  PseudoVMV_V_X_M2,
  PseudoVMV_V_X_M4,
  PseudoVMV_V_X_M8,
  PseudoVMV_V_X_MF2,
  PseudoVMV_V_X_MF4,
  PseudoVMV_V_X_MF8,
  PseudoVMV_X_S,
  PseudoVMXNOR_MM_M1,
  PseudoVMXNOR_MM_M2,
  PseudoVMXNOR_MM_M4,
  PseudoVMXNOR_MM_M8,
  PseudoVMXNOR_MM_MF2,
  PseudoVMXNOR_MM_MF4,
  PseudoVMXNOR_MM_MF8,
  PseudoVMXOR_MM_M1,
  PseudoVMXOR_MM_M2,
  PseudoVMXOR_MM_M4,
  PseudoVMXOR_MM_M8,
  PseudoVMXOR_MM_MF2,
  PseudoVMXOR_MM_MF4,
  PseudoVMXOR_MM_MF8,
  PseudoVNCLIPU_WI_M1,
  PseudoVNCLIPU_WI_M1_MASK,
  PseudoVNCLIPU_WI_M2,
  PseudoVNCLIPU_WI_M2_MASK,
  PseudoVNCLIPU_WI_M4,
  PseudoVNCLIPU_WI_M4_MASK,
  PseudoVNCLIPU_WI_MF2,
  PseudoVNCLIPU_WI_MF2_MASK,
  PseudoVNCLIPU_WI_MF4,
  PseudoVNCLIPU_WI_MF4_MASK,
  PseudoVNCLIPU_WI_MF8,
  PseudoVNCLIPU_WI_MF8_MASK,
  PseudoVNCLIPU_WV_M1,
  PseudoVNCLIPU_WV_M1_MASK,
  PseudoVNCLIPU_WV_M2,
  PseudoVNCLIPU_WV_M2_MASK,
  PseudoVNCLIPU_WV_M4,
  PseudoVNCLIPU_WV_M4_MASK,
  PseudoVNCLIPU_WV_MF2,
  PseudoVNCLIPU_WV_MF2_MASK,
  PseudoVNCLIPU_WV_MF4,
  PseudoVNCLIPU_WV_MF4_MASK,
  PseudoVNCLIPU_WV_MF8,
  PseudoVNCLIPU_WV_MF8_MASK,
  PseudoVNCLIPU_WX_M1,
  PseudoVNCLIPU_WX_M1_MASK,
  PseudoVNCLIPU_WX_M2,
  PseudoVNCLIPU_WX_M2_MASK,
  PseudoVNCLIPU_WX_M4,
  PseudoVNCLIPU_WX_M4_MASK,
  PseudoVNCLIPU_WX_MF2,
  PseudoVNCLIPU_WX_MF2_MASK,
  PseudoVNCLIPU_WX_MF4,
  PseudoVNCLIPU_WX_MF4_MASK,
  PseudoVNCLIPU_WX_MF8,
  PseudoVNCLIPU_WX_MF8_MASK,
  PseudoVNCLIP_WI_M1,
  PseudoVNCLIP_WI_M1_MASK,
  PseudoVNCLIP_WI_M2,
  PseudoVNCLIP_WI_M2_MASK,
  PseudoVNCLIP_WI_M4,
  PseudoVNCLIP_WI_M4_MASK,
  PseudoVNCLIP_WI_MF2,
  PseudoVNCLIP_WI_MF2_MASK,
  PseudoVNCLIP_WI_MF4,
  PseudoVNCLIP_WI_MF4_MASK,
  PseudoVNCLIP_WI_MF8,
  PseudoVNCLIP_WI_MF8_MASK,
  PseudoVNCLIP_WV_M1,
  PseudoVNCLIP_WV_M1_MASK,
  PseudoVNCLIP_WV_M2,
  PseudoVNCLIP_WV_M2_MASK,
  PseudoVNCLIP_WV_M4,
  PseudoVNCLIP_WV_M4_MASK,
  PseudoVNCLIP_WV_MF2,
  PseudoVNCLIP_WV_MF2_MASK,
  PseudoVNCLIP_WV_MF4,
  PseudoVNCLIP_WV_MF4_MASK,
  PseudoVNCLIP_WV_MF8,
  PseudoVNCLIP_WV_MF8_MASK,
  PseudoVNCLIP_WX_M1,
  PseudoVNCLIP_WX_M1_MASK,
  PseudoVNCLIP_WX_M2,
  PseudoVNCLIP_WX_M2_MASK,
  PseudoVNCLIP_WX_M4,
  PseudoVNCLIP_WX_M4_MASK,
  PseudoVNCLIP_WX_MF2,
  PseudoVNCLIP_WX_MF2_MASK,
  PseudoVNCLIP_WX_MF4,
  PseudoVNCLIP_WX_MF4_MASK,
  PseudoVNCLIP_WX_MF8,
  PseudoVNCLIP_WX_MF8_MASK,
  PseudoVNMSAC_VV_M1,
  PseudoVNMSAC_VV_M1_MASK,
  PseudoVNMSAC_VV_M2,
  PseudoVNMSAC_VV_M2_MASK,
  PseudoVNMSAC_VV_M4,
  PseudoVNMSAC_VV_M4_MASK,
  PseudoVNMSAC_VV_M8,
  PseudoVNMSAC_VV_M8_MASK,
  PseudoVNMSAC_VV_MF2,
  PseudoVNMSAC_VV_MF2_MASK,
  PseudoVNMSAC_VV_MF4,
  PseudoVNMSAC_VV_MF4_MASK,
  PseudoVNMSAC_VV_MF8,
  PseudoVNMSAC_VV_MF8_MASK,
  PseudoVNMSAC_VX_M1,
  PseudoVNMSAC_VX_M1_MASK,
  PseudoVNMSAC_VX_M2,
  PseudoVNMSAC_VX_M2_MASK,
  PseudoVNMSAC_VX_M4,
  PseudoVNMSAC_VX_M4_MASK,
  PseudoVNMSAC_VX_M8,
  PseudoVNMSAC_VX_M8_MASK,
  PseudoVNMSAC_VX_MF2,
  PseudoVNMSAC_VX_MF2_MASK,
  PseudoVNMSAC_VX_MF4,
  PseudoVNMSAC_VX_MF4_MASK,
  PseudoVNMSAC_VX_MF8,
  PseudoVNMSAC_VX_MF8_MASK,
  PseudoVNMSUB_VV_M1,
  PseudoVNMSUB_VV_M1_MASK,
  PseudoVNMSUB_VV_M2,
  PseudoVNMSUB_VV_M2_MASK,
  PseudoVNMSUB_VV_M4,
  PseudoVNMSUB_VV_M4_MASK,
  PseudoVNMSUB_VV_M8,
  PseudoVNMSUB_VV_M8_MASK,
  PseudoVNMSUB_VV_MF2,
  PseudoVNMSUB_VV_MF2_MASK,
  PseudoVNMSUB_VV_MF4,
  PseudoVNMSUB_VV_MF4_MASK,
  PseudoVNMSUB_VV_MF8,
  PseudoVNMSUB_VV_MF8_MASK,
  PseudoVNMSUB_VX_M1,
  PseudoVNMSUB_VX_M1_MASK,
  PseudoVNMSUB_VX_M2,
  PseudoVNMSUB_VX_M2_MASK,
  PseudoVNMSUB_VX_M4,
  PseudoVNMSUB_VX_M4_MASK,
  PseudoVNMSUB_VX_M8,
  PseudoVNMSUB_VX_M8_MASK,
  PseudoVNMSUB_VX_MF2,
  PseudoVNMSUB_VX_MF2_MASK,
  PseudoVNMSUB_VX_MF4,
  PseudoVNMSUB_VX_MF4_MASK,
  PseudoVNMSUB_VX_MF8,
  PseudoVNMSUB_VX_MF8_MASK,
  PseudoVNSRA_WI_M1,
  PseudoVNSRA_WI_M1_MASK,
  PseudoVNSRA_WI_M2,
  PseudoVNSRA_WI_M2_MASK,
  PseudoVNSRA_WI_M4,
  PseudoVNSRA_WI_M4_MASK,
  PseudoVNSRA_WI_MF2,
  PseudoVNSRA_WI_MF2_MASK,
  PseudoVNSRA_WI_MF4,
  PseudoVNSRA_WI_MF4_MASK,
  PseudoVNSRA_WI_MF8,
  PseudoVNSRA_WI_MF8_MASK,
  PseudoVNSRA_WV_M1,
  PseudoVNSRA_WV_M1_MASK,
  PseudoVNSRA_WV_M2,
  PseudoVNSRA_WV_M2_MASK,
  PseudoVNSRA_WV_M4,
  PseudoVNSRA_WV_M4_MASK,
  PseudoVNSRA_WV_MF2,
  PseudoVNSRA_WV_MF2_MASK,
  PseudoVNSRA_WV_MF4,
  PseudoVNSRA_WV_MF4_MASK,
  PseudoVNSRA_WV_MF8,
  PseudoVNSRA_WV_MF8_MASK,
  PseudoVNSRA_WX_M1,
  PseudoVNSRA_WX_M1_MASK,
  PseudoVNSRA_WX_M2,
  PseudoVNSRA_WX_M2_MASK,
  PseudoVNSRA_WX_M4,
  PseudoVNSRA_WX_M4_MASK,
  PseudoVNSRA_WX_MF2,
  PseudoVNSRA_WX_MF2_MASK,
  PseudoVNSRA_WX_MF4,
  PseudoVNSRA_WX_MF4_MASK,
  PseudoVNSRA_WX_MF8,
  PseudoVNSRA_WX_MF8_MASK,
  PseudoVNSRL_WI_M1,
  PseudoVNSRL_WI_M1_MASK,
  PseudoVNSRL_WI_M2,
  PseudoVNSRL_WI_M2_MASK,
  PseudoVNSRL_WI_M4,
  PseudoVNSRL_WI_M4_MASK,
  PseudoVNSRL_WI_MF2,
  PseudoVNSRL_WI_MF2_MASK,
  PseudoVNSRL_WI_MF4,
  PseudoVNSRL_WI_MF4_MASK,
  PseudoVNSRL_WI_MF8,
  PseudoVNSRL_WI_MF8_MASK,
  PseudoVNSRL_WV_M1,
  PseudoVNSRL_WV_M1_MASK,
  PseudoVNSRL_WV_M2,
  PseudoVNSRL_WV_M2_MASK,
  PseudoVNSRL_WV_M4,
  PseudoVNSRL_WV_M4_MASK,
  PseudoVNSRL_WV_MF2,
  PseudoVNSRL_WV_MF2_MASK,
  PseudoVNSRL_WV_MF4,
  PseudoVNSRL_WV_MF4_MASK,
  PseudoVNSRL_WV_MF8,
  PseudoVNSRL_WV_MF8_MASK,
  PseudoVNSRL_WX_M1,
  PseudoVNSRL_WX_M1_MASK,
  PseudoVNSRL_WX_M2,
  PseudoVNSRL_WX_M2_MASK,
  PseudoVNSRL_WX_M4,
  PseudoVNSRL_WX_M4_MASK,
  PseudoVNSRL_WX_MF2,
  PseudoVNSRL_WX_MF2_MASK,
  PseudoVNSRL_WX_MF4,
  PseudoVNSRL_WX_MF4_MASK,
  PseudoVNSRL_WX_MF8,
  PseudoVNSRL_WX_MF8_MASK,
  PseudoVOR_VI_M1,
  PseudoVOR_VI_M1_MASK,
  PseudoVOR_VI_M2,
  PseudoVOR_VI_M2_MASK,
  PseudoVOR_VI_M4,
  PseudoVOR_VI_M4_MASK,
  PseudoVOR_VI_M8,
  PseudoVOR_VI_M8_MASK,
  PseudoVOR_VI_MF2,
  PseudoVOR_VI_MF2_MASK,
  PseudoVOR_VI_MF4,
  PseudoVOR_VI_MF4_MASK,
  PseudoVOR_VI_MF8,
  PseudoVOR_VI_MF8_MASK,
  PseudoVOR_VV_M1,
  PseudoVOR_VV_M1_MASK,
  PseudoVOR_VV_M2,
  PseudoVOR_VV_M2_MASK,
  PseudoVOR_VV_M4,
  PseudoVOR_VV_M4_MASK,
  PseudoVOR_VV_M8,
  PseudoVOR_VV_M8_MASK,
  PseudoVOR_VV_MF2,
  PseudoVOR_VV_MF2_MASK,
  PseudoVOR_VV_MF4,
  PseudoVOR_VV_MF4_MASK,
  PseudoVOR_VV_MF8,
  PseudoVOR_VV_MF8_MASK,
  PseudoVOR_VX_M1,
  PseudoVOR_VX_M1_MASK,
  PseudoVOR_VX_M2,
  PseudoVOR_VX_M2_MASK,
  PseudoVOR_VX_M4,
  PseudoVOR_VX_M4_MASK,
  PseudoVOR_VX_M8,
  PseudoVOR_VX_M8_MASK,
  PseudoVOR_VX_MF2,
  PseudoVOR_VX_MF2_MASK,
  PseudoVOR_VX_MF4,
  PseudoVOR_VX_MF4_MASK,
  PseudoVOR_VX_MF8,
  PseudoVOR_VX_MF8_MASK,
  PseudoVQMACCSU_2x8x2_M1,
  PseudoVQMACCSU_2x8x2_M2,
  PseudoVQMACCSU_2x8x2_M4,
  PseudoVQMACCSU_2x8x2_M8,
  PseudoVQMACCSU_4x8x4_M1,
  PseudoVQMACCSU_4x8x4_M2,
  PseudoVQMACCSU_4x8x4_M4,
  PseudoVQMACCSU_4x8x4_MF2,
  PseudoVQMACCUS_2x8x2_M1,
  PseudoVQMACCUS_2x8x2_M2,
  PseudoVQMACCUS_2x8x2_M4,
  PseudoVQMACCUS_2x8x2_M8,
  PseudoVQMACCUS_4x8x4_M1,
  PseudoVQMACCUS_4x8x4_M2,
  PseudoVQMACCUS_4x8x4_M4,
  PseudoVQMACCUS_4x8x4_MF2,
  PseudoVQMACCU_2x8x2_M1,
  PseudoVQMACCU_2x8x2_M2,
  PseudoVQMACCU_2x8x2_M4,
  PseudoVQMACCU_2x8x2_M8,
  PseudoVQMACCU_4x8x4_M1,
  PseudoVQMACCU_4x8x4_M2,
  PseudoVQMACCU_4x8x4_M4,
  PseudoVQMACCU_4x8x4_MF2,
  PseudoVQMACC_2x8x2_M1,
  PseudoVQMACC_2x8x2_M2,
  PseudoVQMACC_2x8x2_M4,
  PseudoVQMACC_2x8x2_M8,
  PseudoVQMACC_4x8x4_M1,
  PseudoVQMACC_4x8x4_M2,
  PseudoVQMACC_4x8x4_M4,
  PseudoVQMACC_4x8x4_MF2,
  PseudoVREDAND_VS_M1_E16,
  PseudoVREDAND_VS_M1_E16_MASK,
  PseudoVREDAND_VS_M1_E32,
  PseudoVREDAND_VS_M1_E32_MASK,
  PseudoVREDAND_VS_M1_E64,
  PseudoVREDAND_VS_M1_E64_MASK,
  PseudoVREDAND_VS_M1_E8,
  PseudoVREDAND_VS_M1_E8_MASK,
  PseudoVREDAND_VS_M2_E16,
  PseudoVREDAND_VS_M2_E16_MASK,
  PseudoVREDAND_VS_M2_E32,
  PseudoVREDAND_VS_M2_E32_MASK,
  PseudoVREDAND_VS_M2_E64,
  PseudoVREDAND_VS_M2_E64_MASK,
  PseudoVREDAND_VS_M2_E8,
  PseudoVREDAND_VS_M2_E8_MASK,
  PseudoVREDAND_VS_M4_E16,
  PseudoVREDAND_VS_M4_E16_MASK,
  PseudoVREDAND_VS_M4_E32,
  PseudoVREDAND_VS_M4_E32_MASK,
  PseudoVREDAND_VS_M4_E64,
  PseudoVREDAND_VS_M4_E64_MASK,
  PseudoVREDAND_VS_M4_E8,
  PseudoVREDAND_VS_M4_E8_MASK,
  PseudoVREDAND_VS_M8_E16,
  PseudoVREDAND_VS_M8_E16_MASK,
  PseudoVREDAND_VS_M8_E32,
  PseudoVREDAND_VS_M8_E32_MASK,
  PseudoVREDAND_VS_M8_E64,
  PseudoVREDAND_VS_M8_E64_MASK,
  PseudoVREDAND_VS_M8_E8,
  PseudoVREDAND_VS_M8_E8_MASK,
  PseudoVREDAND_VS_MF2_E16,
  PseudoVREDAND_VS_MF2_E16_MASK,
  PseudoVREDAND_VS_MF2_E32,
  PseudoVREDAND_VS_MF2_E32_MASK,
  PseudoVREDAND_VS_MF2_E8,
  PseudoVREDAND_VS_MF2_E8_MASK,
  PseudoVREDAND_VS_MF4_E16,
  PseudoVREDAND_VS_MF4_E16_MASK,
  PseudoVREDAND_VS_MF4_E8,
  PseudoVREDAND_VS_MF4_E8_MASK,
  PseudoVREDAND_VS_MF8_E8,
  PseudoVREDAND_VS_MF8_E8_MASK,
  PseudoVREDMAXU_VS_M1_E16,
  PseudoVREDMAXU_VS_M1_E16_MASK,
  PseudoVREDMAXU_VS_M1_E32,
  PseudoVREDMAXU_VS_M1_E32_MASK,
  PseudoVREDMAXU_VS_M1_E64,
  PseudoVREDMAXU_VS_M1_E64_MASK,
  PseudoVREDMAXU_VS_M1_E8,
  PseudoVREDMAXU_VS_M1_E8_MASK,
  PseudoVREDMAXU_VS_M2_E16,
  PseudoVREDMAXU_VS_M2_E16_MASK,
  PseudoVREDMAXU_VS_M2_E32,
  PseudoVREDMAXU_VS_M2_E32_MASK,
  PseudoVREDMAXU_VS_M2_E64,
  PseudoVREDMAXU_VS_M2_E64_MASK,
  PseudoVREDMAXU_VS_M2_E8,
  PseudoVREDMAXU_VS_M2_E8_MASK,
  PseudoVREDMAXU_VS_M4_E16,
  PseudoVREDMAXU_VS_M4_E16_MASK,
  PseudoVREDMAXU_VS_M4_E32,
  PseudoVREDMAXU_VS_M4_E32_MASK,
  PseudoVREDMAXU_VS_M4_E64,
  PseudoVREDMAXU_VS_M4_E64_MASK,
  PseudoVREDMAXU_VS_M4_E8,
  PseudoVREDMAXU_VS_M4_E8_MASK,
  PseudoVREDMAXU_VS_M8_E16,
  PseudoVREDMAXU_VS_M8_E16_MASK,
  PseudoVREDMAXU_VS_M8_E32,
  PseudoVREDMAXU_VS_M8_E32_MASK,
  PseudoVREDMAXU_VS_M8_E64,
  PseudoVREDMAXU_VS_M8_E64_MASK,
  PseudoVREDMAXU_VS_M8_E8,
  PseudoVREDMAXU_VS_M8_E8_MASK,
  PseudoVREDMAXU_VS_MF2_E16,
  PseudoVREDMAXU_VS_MF2_E16_MASK,
  PseudoVREDMAXU_VS_MF2_E32,
  PseudoVREDMAXU_VS_MF2_E32_MASK,
  PseudoVREDMAXU_VS_MF2_E8,
  PseudoVREDMAXU_VS_MF2_E8_MASK,
  PseudoVREDMAXU_VS_MF4_E16,
  PseudoVREDMAXU_VS_MF4_E16_MASK,
  PseudoVREDMAXU_VS_MF4_E8,
  PseudoVREDMAXU_VS_MF4_E8_MASK,
  PseudoVREDMAXU_VS_MF8_E8,
  PseudoVREDMAXU_VS_MF8_E8_MASK,
  PseudoVREDMAX_VS_M1_E16,
  PseudoVREDMAX_VS_M1_E16_MASK,
  PseudoVREDMAX_VS_M1_E32,
  PseudoVREDMAX_VS_M1_E32_MASK,
  PseudoVREDMAX_VS_M1_E64,
  PseudoVREDMAX_VS_M1_E64_MASK,
  PseudoVREDMAX_VS_M1_E8,
  PseudoVREDMAX_VS_M1_E8_MASK,
  PseudoVREDMAX_VS_M2_E16,
  PseudoVREDMAX_VS_M2_E16_MASK,
  PseudoVREDMAX_VS_M2_E32,
  PseudoVREDMAX_VS_M2_E32_MASK,
  PseudoVREDMAX_VS_M2_E64,
  PseudoVREDMAX_VS_M2_E64_MASK,
  PseudoVREDMAX_VS_M2_E8,
  PseudoVREDMAX_VS_M2_E8_MASK,
  PseudoVREDMAX_VS_M4_E16,
  PseudoVREDMAX_VS_M4_E16_MASK,
  PseudoVREDMAX_VS_M4_E32,
  PseudoVREDMAX_VS_M4_E32_MASK,
  PseudoVREDMAX_VS_M4_E64,
  PseudoVREDMAX_VS_M4_E64_MASK,
  PseudoVREDMAX_VS_M4_E8,
  PseudoVREDMAX_VS_M4_E8_MASK,
  PseudoVREDMAX_VS_M8_E16,
  PseudoVREDMAX_VS_M8_E16_MASK,
  PseudoVREDMAX_VS_M8_E32,
  PseudoVREDMAX_VS_M8_E32_MASK,
  PseudoVREDMAX_VS_M8_E64,
  PseudoVREDMAX_VS_M8_E64_MASK,
  PseudoVREDMAX_VS_M8_E8,
  PseudoVREDMAX_VS_M8_E8_MASK,
  PseudoVREDMAX_VS_MF2_E16,
  PseudoVREDMAX_VS_MF2_E16_MASK,
  PseudoVREDMAX_VS_MF2_E32,
  PseudoVREDMAX_VS_MF2_E32_MASK,
  PseudoVREDMAX_VS_MF2_E8,
  PseudoVREDMAX_VS_MF2_E8_MASK,
  PseudoVREDMAX_VS_MF4_E16,
  PseudoVREDMAX_VS_MF4_E16_MASK,
  PseudoVREDMAX_VS_MF4_E8,
  PseudoVREDMAX_VS_MF4_E8_MASK,
  PseudoVREDMAX_VS_MF8_E8,
  PseudoVREDMAX_VS_MF8_E8_MASK,
  PseudoVREDMINU_VS_M1_E16,
  PseudoVREDMINU_VS_M1_E16_MASK,
  PseudoVREDMINU_VS_M1_E32,
  PseudoVREDMINU_VS_M1_E32_MASK,
  PseudoVREDMINU_VS_M1_E64,
  PseudoVREDMINU_VS_M1_E64_MASK,
  PseudoVREDMINU_VS_M1_E8,
  PseudoVREDMINU_VS_M1_E8_MASK,
  PseudoVREDMINU_VS_M2_E16,
  PseudoVREDMINU_VS_M2_E16_MASK,
  PseudoVREDMINU_VS_M2_E32,
  PseudoVREDMINU_VS_M2_E32_MASK,
  PseudoVREDMINU_VS_M2_E64,
  PseudoVREDMINU_VS_M2_E64_MASK,
  PseudoVREDMINU_VS_M2_E8,
  PseudoVREDMINU_VS_M2_E8_MASK,
  PseudoVREDMINU_VS_M4_E16,
  PseudoVREDMINU_VS_M4_E16_MASK,
  PseudoVREDMINU_VS_M4_E32,
  PseudoVREDMINU_VS_M4_E32_MASK,
  PseudoVREDMINU_VS_M4_E64,
  PseudoVREDMINU_VS_M4_E64_MASK,
  PseudoVREDMINU_VS_M4_E8,
  PseudoVREDMINU_VS_M4_E8_MASK,
  PseudoVREDMINU_VS_M8_E16,
  PseudoVREDMINU_VS_M8_E16_MASK,
  PseudoVREDMINU_VS_M8_E32,
  PseudoVREDMINU_VS_M8_E32_MASK,
  PseudoVREDMINU_VS_M8_E64,
  PseudoVREDMINU_VS_M8_E64_MASK,
  PseudoVREDMINU_VS_M8_E8,
  PseudoVREDMINU_VS_M8_E8_MASK,
  PseudoVREDMINU_VS_MF2_E16,
  PseudoVREDMINU_VS_MF2_E16_MASK,
  PseudoVREDMINU_VS_MF2_E32,
  PseudoVREDMINU_VS_MF2_E32_MASK,
  PseudoVREDMINU_VS_MF2_E8,
  PseudoVREDMINU_VS_MF2_E8_MASK,
  PseudoVREDMINU_VS_MF4_E16,
  PseudoVREDMINU_VS_MF4_E16_MASK,
  PseudoVREDMINU_VS_MF4_E8,
  PseudoVREDMINU_VS_MF4_E8_MASK,
  PseudoVREDMINU_VS_MF8_E8,
  PseudoVREDMINU_VS_MF8_E8_MASK,
  PseudoVREDMIN_VS_M1_E16,
  PseudoVREDMIN_VS_M1_E16_MASK,
  PseudoVREDMIN_VS_M1_E32,
  PseudoVREDMIN_VS_M1_E32_MASK,
  PseudoVREDMIN_VS_M1_E64,
  PseudoVREDMIN_VS_M1_E64_MASK,
  PseudoVREDMIN_VS_M1_E8,
  PseudoVREDMIN_VS_M1_E8_MASK,
  PseudoVREDMIN_VS_M2_E16,
  PseudoVREDMIN_VS_M2_E16_MASK,
  PseudoVREDMIN_VS_M2_E32,
  PseudoVREDMIN_VS_M2_E32_MASK,
  PseudoVREDMIN_VS_M2_E64,
  PseudoVREDMIN_VS_M2_E64_MASK,
  PseudoVREDMIN_VS_M2_E8,
  PseudoVREDMIN_VS_M2_E8_MASK,
  PseudoVREDMIN_VS_M4_E16,
  PseudoVREDMIN_VS_M4_E16_MASK,
  PseudoVREDMIN_VS_M4_E32,
  PseudoVREDMIN_VS_M4_E32_MASK,
  PseudoVREDMIN_VS_M4_E64,
  PseudoVREDMIN_VS_M4_E64_MASK,
  PseudoVREDMIN_VS_M4_E8,
  PseudoVREDMIN_VS_M4_E8_MASK,
  PseudoVREDMIN_VS_M8_E16,
  PseudoVREDMIN_VS_M8_E16_MASK,
  PseudoVREDMIN_VS_M8_E32,
  PseudoVREDMIN_VS_M8_E32_MASK,
  PseudoVREDMIN_VS_M8_E64,
  PseudoVREDMIN_VS_M8_E64_MASK,
  PseudoVREDMIN_VS_M8_E8,
  PseudoVREDMIN_VS_M8_E8_MASK,
  PseudoVREDMIN_VS_MF2_E16,
  PseudoVREDMIN_VS_MF2_E16_MASK,
  PseudoVREDMIN_VS_MF2_E32,
  PseudoVREDMIN_VS_MF2_E32_MASK,
  PseudoVREDMIN_VS_MF2_E8,
  PseudoVREDMIN_VS_MF2_E8_MASK,
  PseudoVREDMIN_VS_MF4_E16,
  PseudoVREDMIN_VS_MF4_E16_MASK,
  PseudoVREDMIN_VS_MF4_E8,
  PseudoVREDMIN_VS_MF4_E8_MASK,
  PseudoVREDMIN_VS_MF8_E8,
  PseudoVREDMIN_VS_MF8_E8_MASK,
  PseudoVREDOR_VS_M1_E16,
  PseudoVREDOR_VS_M1_E16_MASK,
  PseudoVREDOR_VS_M1_E32,
  PseudoVREDOR_VS_M1_E32_MASK,
  PseudoVREDOR_VS_M1_E64,
  PseudoVREDOR_VS_M1_E64_MASK,
  PseudoVREDOR_VS_M1_E8,
  PseudoVREDOR_VS_M1_E8_MASK,
  PseudoVREDOR_VS_M2_E16,
  PseudoVREDOR_VS_M2_E16_MASK,
  PseudoVREDOR_VS_M2_E32,
  PseudoVREDOR_VS_M2_E32_MASK,
  PseudoVREDOR_VS_M2_E64,
  PseudoVREDOR_VS_M2_E64_MASK,
  PseudoVREDOR_VS_M2_E8,
  PseudoVREDOR_VS_M2_E8_MASK,
  PseudoVREDOR_VS_M4_E16,
  PseudoVREDOR_VS_M4_E16_MASK,
  PseudoVREDOR_VS_M4_E32,
  PseudoVREDOR_VS_M4_E32_MASK,
  PseudoVREDOR_VS_M4_E64,
  PseudoVREDOR_VS_M4_E64_MASK,
  PseudoVREDOR_VS_M4_E8,
  PseudoVREDOR_VS_M4_E8_MASK,
  PseudoVREDOR_VS_M8_E16,
  PseudoVREDOR_VS_M8_E16_MASK,
  PseudoVREDOR_VS_M8_E32,
  PseudoVREDOR_VS_M8_E32_MASK,
  PseudoVREDOR_VS_M8_E64,
  PseudoVREDOR_VS_M8_E64_MASK,
  PseudoVREDOR_VS_M8_E8,
  PseudoVREDOR_VS_M8_E8_MASK,
  PseudoVREDOR_VS_MF2_E16,
  PseudoVREDOR_VS_MF2_E16_MASK,
  PseudoVREDOR_VS_MF2_E32,
  PseudoVREDOR_VS_MF2_E32_MASK,
  PseudoVREDOR_VS_MF2_E8,
  PseudoVREDOR_VS_MF2_E8_MASK,
  PseudoVREDOR_VS_MF4_E16,
  PseudoVREDOR_VS_MF4_E16_MASK,
  PseudoVREDOR_VS_MF4_E8,
  PseudoVREDOR_VS_MF4_E8_MASK,
  PseudoVREDOR_VS_MF8_E8,
  PseudoVREDOR_VS_MF8_E8_MASK,
  PseudoVREDSUM_VS_M1_E16,
  PseudoVREDSUM_VS_M1_E16_MASK,
  PseudoVREDSUM_VS_M1_E32,
  PseudoVREDSUM_VS_M1_E32_MASK,
  PseudoVREDSUM_VS_M1_E64,
  PseudoVREDSUM_VS_M1_E64_MASK,
  PseudoVREDSUM_VS_M1_E8,
  PseudoVREDSUM_VS_M1_E8_MASK,
  PseudoVREDSUM_VS_M2_E16,
  PseudoVREDSUM_VS_M2_E16_MASK,
  PseudoVREDSUM_VS_M2_E32,
  PseudoVREDSUM_VS_M2_E32_MASK,
  PseudoVREDSUM_VS_M2_E64,
  PseudoVREDSUM_VS_M2_E64_MASK,
  PseudoVREDSUM_VS_M2_E8,
  PseudoVREDSUM_VS_M2_E8_MASK,
  PseudoVREDSUM_VS_M4_E16,
  PseudoVREDSUM_VS_M4_E16_MASK,
  PseudoVREDSUM_VS_M4_E32,
  PseudoVREDSUM_VS_M4_E32_MASK,
  PseudoVREDSUM_VS_M4_E64,
  PseudoVREDSUM_VS_M4_E64_MASK,
  PseudoVREDSUM_VS_M4_E8,
  PseudoVREDSUM_VS_M4_E8_MASK,
  PseudoVREDSUM_VS_M8_E16,
  PseudoVREDSUM_VS_M8_E16_MASK,
  PseudoVREDSUM_VS_M8_E32,
  PseudoVREDSUM_VS_M8_E32_MASK,
  PseudoVREDSUM_VS_M8_E64,
  PseudoVREDSUM_VS_M8_E64_MASK,
  PseudoVREDSUM_VS_M8_E8,
  PseudoVREDSUM_VS_M8_E8_MASK,
  PseudoVREDSUM_VS_MF2_E16,
  PseudoVREDSUM_VS_MF2_E16_MASK,
  PseudoVREDSUM_VS_MF2_E32,
  PseudoVREDSUM_VS_MF2_E32_MASK,
  PseudoVREDSUM_VS_MF2_E8,
  PseudoVREDSUM_VS_MF2_E8_MASK,
  PseudoVREDSUM_VS_MF4_E16,
  PseudoVREDSUM_VS_MF4_E16_MASK,
  PseudoVREDSUM_VS_MF4_E8,
  PseudoVREDSUM_VS_MF4_E8_MASK,
  PseudoVREDSUM_VS_MF8_E8,
  PseudoVREDSUM_VS_MF8_E8_MASK,
  PseudoVREDXOR_VS_M1_E16,
  PseudoVREDXOR_VS_M1_E16_MASK,
  PseudoVREDXOR_VS_M1_E32,
  PseudoVREDXOR_VS_M1_E32_MASK,
  PseudoVREDXOR_VS_M1_E64,
  PseudoVREDXOR_VS_M1_E64_MASK,
  PseudoVREDXOR_VS_M1_E8,
  PseudoVREDXOR_VS_M1_E8_MASK,
  PseudoVREDXOR_VS_M2_E16,
  PseudoVREDXOR_VS_M2_E16_MASK,
  PseudoVREDXOR_VS_M2_E32,
  PseudoVREDXOR_VS_M2_E32_MASK,
  PseudoVREDXOR_VS_M2_E64,
  PseudoVREDXOR_VS_M2_E64_MASK,
  PseudoVREDXOR_VS_M2_E8,
  PseudoVREDXOR_VS_M2_E8_MASK,
  PseudoVREDXOR_VS_M4_E16,
  PseudoVREDXOR_VS_M4_E16_MASK,
  PseudoVREDXOR_VS_M4_E32,
  PseudoVREDXOR_VS_M4_E32_MASK,
  PseudoVREDXOR_VS_M4_E64,
  PseudoVREDXOR_VS_M4_E64_MASK,
  PseudoVREDXOR_VS_M4_E8,
  PseudoVREDXOR_VS_M4_E8_MASK,
  PseudoVREDXOR_VS_M8_E16,
  PseudoVREDXOR_VS_M8_E16_MASK,
  PseudoVREDXOR_VS_M8_E32,
  PseudoVREDXOR_VS_M8_E32_MASK,
  PseudoVREDXOR_VS_M8_E64,
  PseudoVREDXOR_VS_M8_E64_MASK,
  PseudoVREDXOR_VS_M8_E8,
  PseudoVREDXOR_VS_M8_E8_MASK,
  PseudoVREDXOR_VS_MF2_E16,
  PseudoVREDXOR_VS_MF2_E16_MASK,
  PseudoVREDXOR_VS_MF2_E32,
  PseudoVREDXOR_VS_MF2_E32_MASK,
  PseudoVREDXOR_VS_MF2_E8,
  PseudoVREDXOR_VS_MF2_E8_MASK,
  PseudoVREDXOR_VS_MF4_E16,
  PseudoVREDXOR_VS_MF4_E16_MASK,
  PseudoVREDXOR_VS_MF4_E8,
  PseudoVREDXOR_VS_MF4_E8_MASK,
  PseudoVREDXOR_VS_MF8_E8,
  PseudoVREDXOR_VS_MF8_E8_MASK,
  PseudoVRELOAD2_M1,
  PseudoVRELOAD2_M2,
  PseudoVRELOAD2_M4,
  PseudoVRELOAD2_MF2,
  PseudoVRELOAD2_MF4,
  PseudoVRELOAD2_MF8,
  PseudoVRELOAD3_M1,
  PseudoVRELOAD3_M2,
  PseudoVRELOAD3_MF2,
  PseudoVRELOAD3_MF4,
  PseudoVRELOAD3_MF8,
  PseudoVRELOAD4_M1,
  PseudoVRELOAD4_M2,
  PseudoVRELOAD4_MF2,
  PseudoVRELOAD4_MF4,
  PseudoVRELOAD4_MF8,
  PseudoVRELOAD5_M1,
  PseudoVRELOAD5_MF2,
  PseudoVRELOAD5_MF4,
  PseudoVRELOAD5_MF8,
  PseudoVRELOAD6_M1,
  PseudoVRELOAD6_MF2,
  PseudoVRELOAD6_MF4,
  PseudoVRELOAD6_MF8,
  PseudoVRELOAD7_M1,
  PseudoVRELOAD7_MF2,
  PseudoVRELOAD7_MF4,
  PseudoVRELOAD7_MF8,
  PseudoVRELOAD8_M1,
  PseudoVRELOAD8_MF2,
  PseudoVRELOAD8_MF4,
  PseudoVRELOAD8_MF8,
  PseudoVREMU_VV_M1_E16,
  PseudoVREMU_VV_M1_E16_MASK,
  PseudoVREMU_VV_M1_E32,
  PseudoVREMU_VV_M1_E32_MASK,
  PseudoVREMU_VV_M1_E64,
  PseudoVREMU_VV_M1_E64_MASK,
  PseudoVREMU_VV_M1_E8,
  PseudoVREMU_VV_M1_E8_MASK,
  PseudoVREMU_VV_M2_E16,
  PseudoVREMU_VV_M2_E16_MASK,
  PseudoVREMU_VV_M2_E32,
  PseudoVREMU_VV_M2_E32_MASK,
  PseudoVREMU_VV_M2_E64,
  PseudoVREMU_VV_M2_E64_MASK,
  PseudoVREMU_VV_M2_E8,
  PseudoVREMU_VV_M2_E8_MASK,
  PseudoVREMU_VV_M4_E16,
  PseudoVREMU_VV_M4_E16_MASK,
  PseudoVREMU_VV_M4_E32,
  PseudoVREMU_VV_M4_E32_MASK,
  PseudoVREMU_VV_M4_E64,
  PseudoVREMU_VV_M4_E64_MASK,
  PseudoVREMU_VV_M4_E8,
  PseudoVREMU_VV_M4_E8_MASK,
  PseudoVREMU_VV_M8_E16,
  PseudoVREMU_VV_M8_E16_MASK,
  PseudoVREMU_VV_M8_E32,
  PseudoVREMU_VV_M8_E32_MASK,
  PseudoVREMU_VV_M8_E64,
  PseudoVREMU_VV_M8_E64_MASK,
  PseudoVREMU_VV_M8_E8,
  PseudoVREMU_VV_M8_E8_MASK,
  PseudoVREMU_VV_MF2_E16,
  PseudoVREMU_VV_MF2_E16_MASK,
  PseudoVREMU_VV_MF2_E32,
  PseudoVREMU_VV_MF2_E32_MASK,
  PseudoVREMU_VV_MF2_E8,
  PseudoVREMU_VV_MF2_E8_MASK,
  PseudoVREMU_VV_MF4_E16,
  PseudoVREMU_VV_MF4_E16_MASK,
  PseudoVREMU_VV_MF4_E8,
  PseudoVREMU_VV_MF4_E8_MASK,
  PseudoVREMU_VV_MF8_E8,
  PseudoVREMU_VV_MF8_E8_MASK,
  PseudoVREMU_VX_M1_E16,
  PseudoVREMU_VX_M1_E16_MASK,
  PseudoVREMU_VX_M1_E32,
  PseudoVREMU_VX_M1_E32_MASK,
  PseudoVREMU_VX_M1_E64,
  PseudoVREMU_VX_M1_E64_MASK,
  PseudoVREMU_VX_M1_E8,
  PseudoVREMU_VX_M1_E8_MASK,
  PseudoVREMU_VX_M2_E16,
  PseudoVREMU_VX_M2_E16_MASK,
  PseudoVREMU_VX_M2_E32,
  PseudoVREMU_VX_M2_E32_MASK,
  PseudoVREMU_VX_M2_E64,
  PseudoVREMU_VX_M2_E64_MASK,
  PseudoVREMU_VX_M2_E8,
  PseudoVREMU_VX_M2_E8_MASK,
  PseudoVREMU_VX_M4_E16,
  PseudoVREMU_VX_M4_E16_MASK,
  PseudoVREMU_VX_M4_E32,
  PseudoVREMU_VX_M4_E32_MASK,
  PseudoVREMU_VX_M4_E64,
  PseudoVREMU_VX_M4_E64_MASK,
  PseudoVREMU_VX_M4_E8,
  PseudoVREMU_VX_M4_E8_MASK,
  PseudoVREMU_VX_M8_E16,
  PseudoVREMU_VX_M8_E16_MASK,
  PseudoVREMU_VX_M8_E32,
  PseudoVREMU_VX_M8_E32_MASK,
  PseudoVREMU_VX_M8_E64,
  PseudoVREMU_VX_M8_E64_MASK,
  PseudoVREMU_VX_M8_E8,
  PseudoVREMU_VX_M8_E8_MASK,
  PseudoVREMU_VX_MF2_E16,
  PseudoVREMU_VX_MF2_E16_MASK,
  PseudoVREMU_VX_MF2_E32,
  PseudoVREMU_VX_MF2_E32_MASK,
  PseudoVREMU_VX_MF2_E8,
  PseudoVREMU_VX_MF2_E8_MASK,
  PseudoVREMU_VX_MF4_E16,
  PseudoVREMU_VX_MF4_E16_MASK,
  PseudoVREMU_VX_MF4_E8,
  PseudoVREMU_VX_MF4_E8_MASK,
  PseudoVREMU_VX_MF8_E8,
  PseudoVREMU_VX_MF8_E8_MASK,
  PseudoVREM_VV_M1_E16,
  PseudoVREM_VV_M1_E16_MASK,
  PseudoVREM_VV_M1_E32,
  PseudoVREM_VV_M1_E32_MASK,
  PseudoVREM_VV_M1_E64,
  PseudoVREM_VV_M1_E64_MASK,
  PseudoVREM_VV_M1_E8,
  PseudoVREM_VV_M1_E8_MASK,
  PseudoVREM_VV_M2_E16,
  PseudoVREM_VV_M2_E16_MASK,
  PseudoVREM_VV_M2_E32,
  PseudoVREM_VV_M2_E32_MASK,
  PseudoVREM_VV_M2_E64,
  PseudoVREM_VV_M2_E64_MASK,
  PseudoVREM_VV_M2_E8,
  PseudoVREM_VV_M2_E8_MASK,
  PseudoVREM_VV_M4_E16,
  PseudoVREM_VV_M4_E16_MASK,
  PseudoVREM_VV_M4_E32,
  PseudoVREM_VV_M4_E32_MASK,
  PseudoVREM_VV_M4_E64,
  PseudoVREM_VV_M4_E64_MASK,
  PseudoVREM_VV_M4_E8,
  PseudoVREM_VV_M4_E8_MASK,
  PseudoVREM_VV_M8_E16,
  PseudoVREM_VV_M8_E16_MASK,
  PseudoVREM_VV_M8_E32,
  PseudoVREM_VV_M8_E32_MASK,
  PseudoVREM_VV_M8_E64,
  PseudoVREM_VV_M8_E64_MASK,
  PseudoVREM_VV_M8_E8,
  PseudoVREM_VV_M8_E8_MASK,
  PseudoVREM_VV_MF2_E16,
  PseudoVREM_VV_MF2_E16_MASK,
  PseudoVREM_VV_MF2_E32,
  PseudoVREM_VV_MF2_E32_MASK,
  PseudoVREM_VV_MF2_E8,
  PseudoVREM_VV_MF2_E8_MASK,
  PseudoVREM_VV_MF4_E16,
  PseudoVREM_VV_MF4_E16_MASK,
  PseudoVREM_VV_MF4_E8,
  PseudoVREM_VV_MF4_E8_MASK,
  PseudoVREM_VV_MF8_E8,
  PseudoVREM_VV_MF8_E8_MASK,
  PseudoVREM_VX_M1_E16,
  PseudoVREM_VX_M1_E16_MASK,
  PseudoVREM_VX_M1_E32,
  PseudoVREM_VX_M1_E32_MASK,
  PseudoVREM_VX_M1_E64,
  PseudoVREM_VX_M1_E64_MASK,
  PseudoVREM_VX_M1_E8,
  PseudoVREM_VX_M1_E8_MASK,
  PseudoVREM_VX_M2_E16,
  PseudoVREM_VX_M2_E16_MASK,
  PseudoVREM_VX_M2_E32,
  PseudoVREM_VX_M2_E32_MASK,
  PseudoVREM_VX_M2_E64,
  PseudoVREM_VX_M2_E64_MASK,
  PseudoVREM_VX_M2_E8,
  PseudoVREM_VX_M2_E8_MASK,
  PseudoVREM_VX_M4_E16,
  PseudoVREM_VX_M4_E16_MASK,
  PseudoVREM_VX_M4_E32,
  PseudoVREM_VX_M4_E32_MASK,
  PseudoVREM_VX_M4_E64,
  PseudoVREM_VX_M4_E64_MASK,
  PseudoVREM_VX_M4_E8,
  PseudoVREM_VX_M4_E8_MASK,
  PseudoVREM_VX_M8_E16,
  PseudoVREM_VX_M8_E16_MASK,
  PseudoVREM_VX_M8_E32,
  PseudoVREM_VX_M8_E32_MASK,
  PseudoVREM_VX_M8_E64,
  PseudoVREM_VX_M8_E64_MASK,
  PseudoVREM_VX_M8_E8,
  PseudoVREM_VX_M8_E8_MASK,
  PseudoVREM_VX_MF2_E16,
  PseudoVREM_VX_MF2_E16_MASK,
  PseudoVREM_VX_MF2_E32,
  PseudoVREM_VX_MF2_E32_MASK,
  PseudoVREM_VX_MF2_E8,
  PseudoVREM_VX_MF2_E8_MASK,
  PseudoVREM_VX_MF4_E16,
  PseudoVREM_VX_MF4_E16_MASK,
  PseudoVREM_VX_MF4_E8,
  PseudoVREM_VX_MF4_E8_MASK,
  PseudoVREM_VX_MF8_E8,
  PseudoVREM_VX_MF8_E8_MASK,
  PseudoVREV8_V_M1,
  PseudoVREV8_V_M1_MASK,
  PseudoVREV8_V_M2,
  PseudoVREV8_V_M2_MASK,
  PseudoVREV8_V_M4,
  PseudoVREV8_V_M4_MASK,
  PseudoVREV8_V_M8,
  PseudoVREV8_V_M8_MASK,
  PseudoVREV8_V_MF2,
  PseudoVREV8_V_MF2_MASK,
  PseudoVREV8_V_MF4,
  PseudoVREV8_V_MF4_MASK,
  PseudoVREV8_V_MF8,
  PseudoVREV8_V_MF8_MASK,
  PseudoVRGATHEREI16_VV_M1_E16_M1,
  PseudoVRGATHEREI16_VV_M1_E16_M1_MASK,
  PseudoVRGATHEREI16_VV_M1_E16_M2,
  PseudoVRGATHEREI16_VV_M1_E16_M2_MASK,
  PseudoVRGATHEREI16_VV_M1_E16_MF2,
  PseudoVRGATHEREI16_VV_M1_E16_MF2_MASK,
  PseudoVRGATHEREI16_VV_M1_E16_MF4,
  PseudoVRGATHEREI16_VV_M1_E16_MF4_MASK,
  PseudoVRGATHEREI16_VV_M1_E32_M1,
  PseudoVRGATHEREI16_VV_M1_E32_M1_MASK,
  PseudoVRGATHEREI16_VV_M1_E32_M2,
  PseudoVRGATHEREI16_VV_M1_E32_M2_MASK,
  PseudoVRGATHEREI16_VV_M1_E32_MF2,
  PseudoVRGATHEREI16_VV_M1_E32_MF2_MASK,
  PseudoVRGATHEREI16_VV_M1_E32_MF4,
  PseudoVRGATHEREI16_VV_M1_E32_MF4_MASK,
  PseudoVRGATHEREI16_VV_M1_E64_M1,
  PseudoVRGATHEREI16_VV_M1_E64_M1_MASK,
  PseudoVRGATHEREI16_VV_M1_E64_M2,
  PseudoVRGATHEREI16_VV_M1_E64_M2_MASK,
  PseudoVRGATHEREI16_VV_M1_E64_MF2,
  PseudoVRGATHEREI16_VV_M1_E64_MF2_MASK,
  PseudoVRGATHEREI16_VV_M1_E64_MF4,
  PseudoVRGATHEREI16_VV_M1_E64_MF4_MASK,
  PseudoVRGATHEREI16_VV_M1_E8_M1,
  PseudoVRGATHEREI16_VV_M1_E8_M1_MASK,
  PseudoVRGATHEREI16_VV_M1_E8_M2,
  PseudoVRGATHEREI16_VV_M1_E8_M2_MASK,
  PseudoVRGATHEREI16_VV_M1_E8_MF2,
  PseudoVRGATHEREI16_VV_M1_E8_MF2_MASK,
  PseudoVRGATHEREI16_VV_M1_E8_MF4,
  PseudoVRGATHEREI16_VV_M1_E8_MF4_MASK,
  PseudoVRGATHEREI16_VV_M2_E16_M1,
  PseudoVRGATHEREI16_VV_M2_E16_M1_MASK,
  PseudoVRGATHEREI16_VV_M2_E16_M2,
  PseudoVRGATHEREI16_VV_M2_E16_M2_MASK,
  PseudoVRGATHEREI16_VV_M2_E16_M4,
  PseudoVRGATHEREI16_VV_M2_E16_M4_MASK,
  PseudoVRGATHEREI16_VV_M2_E16_MF2,
  PseudoVRGATHEREI16_VV_M2_E16_MF2_MASK,
  PseudoVRGATHEREI16_VV_M2_E32_M1,
  PseudoVRGATHEREI16_VV_M2_E32_M1_MASK,
  PseudoVRGATHEREI16_VV_M2_E32_M2,
  PseudoVRGATHEREI16_VV_M2_E32_M2_MASK,
  PseudoVRGATHEREI16_VV_M2_E32_M4,
  PseudoVRGATHEREI16_VV_M2_E32_M4_MASK,
  PseudoVRGATHEREI16_VV_M2_E32_MF2,
  PseudoVRGATHEREI16_VV_M2_E32_MF2_MASK,
  PseudoVRGATHEREI16_VV_M2_E64_M1,
  PseudoVRGATHEREI16_VV_M2_E64_M1_MASK,
  PseudoVRGATHEREI16_VV_M2_E64_M2,
  PseudoVRGATHEREI16_VV_M2_E64_M2_MASK,
  PseudoVRGATHEREI16_VV_M2_E64_M4,
  PseudoVRGATHEREI16_VV_M2_E64_M4_MASK,
  PseudoVRGATHEREI16_VV_M2_E64_MF2,
  PseudoVRGATHEREI16_VV_M2_E64_MF2_MASK,
  PseudoVRGATHEREI16_VV_M2_E8_M1,
  PseudoVRGATHEREI16_VV_M2_E8_M1_MASK,
  PseudoVRGATHEREI16_VV_M2_E8_M2,
  PseudoVRGATHEREI16_VV_M2_E8_M2_MASK,
  PseudoVRGATHEREI16_VV_M2_E8_M4,
  PseudoVRGATHEREI16_VV_M2_E8_M4_MASK,
  PseudoVRGATHEREI16_VV_M2_E8_MF2,
  PseudoVRGATHEREI16_VV_M2_E8_MF2_MASK,
  PseudoVRGATHEREI16_VV_M4_E16_M1,
  PseudoVRGATHEREI16_VV_M4_E16_M1_MASK,
  PseudoVRGATHEREI16_VV_M4_E16_M2,
  PseudoVRGATHEREI16_VV_M4_E16_M2_MASK,
  PseudoVRGATHEREI16_VV_M4_E16_M4,
  PseudoVRGATHEREI16_VV_M4_E16_M4_MASK,
  PseudoVRGATHEREI16_VV_M4_E16_M8,
  PseudoVRGATHEREI16_VV_M4_E16_M8_MASK,
  PseudoVRGATHEREI16_VV_M4_E32_M1,
  PseudoVRGATHEREI16_VV_M4_E32_M1_MASK,
  PseudoVRGATHEREI16_VV_M4_E32_M2,
  PseudoVRGATHEREI16_VV_M4_E32_M2_MASK,
  PseudoVRGATHEREI16_VV_M4_E32_M4,
  PseudoVRGATHEREI16_VV_M4_E32_M4_MASK,
  PseudoVRGATHEREI16_VV_M4_E32_M8,
  PseudoVRGATHEREI16_VV_M4_E32_M8_MASK,
  PseudoVRGATHEREI16_VV_M4_E64_M1,
  PseudoVRGATHEREI16_VV_M4_E64_M1_MASK,
  PseudoVRGATHEREI16_VV_M4_E64_M2,
  PseudoVRGATHEREI16_VV_M4_E64_M2_MASK,
  PseudoVRGATHEREI16_VV_M4_E64_M4,
  PseudoVRGATHEREI16_VV_M4_E64_M4_MASK,
  PseudoVRGATHEREI16_VV_M4_E64_M8,
  PseudoVRGATHEREI16_VV_M4_E64_M8_MASK,
  PseudoVRGATHEREI16_VV_M4_E8_M1,
  PseudoVRGATHEREI16_VV_M4_E8_M1_MASK,
  PseudoVRGATHEREI16_VV_M4_E8_M2,
  PseudoVRGATHEREI16_VV_M4_E8_M2_MASK,
  PseudoVRGATHEREI16_VV_M4_E8_M4,
  PseudoVRGATHEREI16_VV_M4_E8_M4_MASK,
  PseudoVRGATHEREI16_VV_M4_E8_M8,
  PseudoVRGATHEREI16_VV_M4_E8_M8_MASK,
  PseudoVRGATHEREI16_VV_M8_E16_M2,
  PseudoVRGATHEREI16_VV_M8_E16_M2_MASK,
  PseudoVRGATHEREI16_VV_M8_E16_M4,
  PseudoVRGATHEREI16_VV_M8_E16_M4_MASK,
  PseudoVRGATHEREI16_VV_M8_E16_M8,
  PseudoVRGATHEREI16_VV_M8_E16_M8_MASK,
  PseudoVRGATHEREI16_VV_M8_E32_M2,
  PseudoVRGATHEREI16_VV_M8_E32_M2_MASK,
  PseudoVRGATHEREI16_VV_M8_E32_M4,
  PseudoVRGATHEREI16_VV_M8_E32_M4_MASK,
  PseudoVRGATHEREI16_VV_M8_E32_M8,
  PseudoVRGATHEREI16_VV_M8_E32_M8_MASK,
  PseudoVRGATHEREI16_VV_M8_E64_M2,
  PseudoVRGATHEREI16_VV_M8_E64_M2_MASK,
  PseudoVRGATHEREI16_VV_M8_E64_M4,
  PseudoVRGATHEREI16_VV_M8_E64_M4_MASK,
  PseudoVRGATHEREI16_VV_M8_E64_M8,
  PseudoVRGATHEREI16_VV_M8_E64_M8_MASK,
  PseudoVRGATHEREI16_VV_M8_E8_M2,
  PseudoVRGATHEREI16_VV_M8_E8_M2_MASK,
  PseudoVRGATHEREI16_VV_M8_E8_M4,
  PseudoVRGATHEREI16_VV_M8_E8_M4_MASK,
  PseudoVRGATHEREI16_VV_M8_E8_M8,
  PseudoVRGATHEREI16_VV_M8_E8_M8_MASK,
  PseudoVRGATHEREI16_VV_MF2_E16_M1,
  PseudoVRGATHEREI16_VV_MF2_E16_M1_MASK,
  PseudoVRGATHEREI16_VV_MF2_E16_MF2,
  PseudoVRGATHEREI16_VV_MF2_E16_MF2_MASK,
  PseudoVRGATHEREI16_VV_MF2_E16_MF4,
  PseudoVRGATHEREI16_VV_MF2_E16_MF4_MASK,
  PseudoVRGATHEREI16_VV_MF2_E16_MF8,
  PseudoVRGATHEREI16_VV_MF2_E16_MF8_MASK,
  PseudoVRGATHEREI16_VV_MF2_E32_M1,
  PseudoVRGATHEREI16_VV_MF2_E32_M1_MASK,
  PseudoVRGATHEREI16_VV_MF2_E32_MF2,
  PseudoVRGATHEREI16_VV_MF2_E32_MF2_MASK,
  PseudoVRGATHEREI16_VV_MF2_E32_MF4,
  PseudoVRGATHEREI16_VV_MF2_E32_MF4_MASK,
  PseudoVRGATHEREI16_VV_MF2_E32_MF8,
  PseudoVRGATHEREI16_VV_MF2_E32_MF8_MASK,
  PseudoVRGATHEREI16_VV_MF2_E8_M1,
  PseudoVRGATHEREI16_VV_MF2_E8_M1_MASK,
  PseudoVRGATHEREI16_VV_MF2_E8_MF2,
  PseudoVRGATHEREI16_VV_MF2_E8_MF2_MASK,
  PseudoVRGATHEREI16_VV_MF2_E8_MF4,
  PseudoVRGATHEREI16_VV_MF2_E8_MF4_MASK,
  PseudoVRGATHEREI16_VV_MF2_E8_MF8,
  PseudoVRGATHEREI16_VV_MF2_E8_MF8_MASK,
  PseudoVRGATHEREI16_VV_MF4_E16_MF2,
  PseudoVRGATHEREI16_VV_MF4_E16_MF2_MASK,
  PseudoVRGATHEREI16_VV_MF4_E16_MF4,
  PseudoVRGATHEREI16_VV_MF4_E16_MF4_MASK,
  PseudoVRGATHEREI16_VV_MF4_E16_MF8,
  PseudoVRGATHEREI16_VV_MF4_E16_MF8_MASK,
  PseudoVRGATHEREI16_VV_MF4_E8_MF2,
  PseudoVRGATHEREI16_VV_MF4_E8_MF2_MASK,
  PseudoVRGATHEREI16_VV_MF4_E8_MF4,
  PseudoVRGATHEREI16_VV_MF4_E8_MF4_MASK,
  PseudoVRGATHEREI16_VV_MF4_E8_MF8,
  PseudoVRGATHEREI16_VV_MF4_E8_MF8_MASK,
  PseudoVRGATHEREI16_VV_MF8_E8_MF4,
  PseudoVRGATHEREI16_VV_MF8_E8_MF4_MASK,
  PseudoVRGATHEREI16_VV_MF8_E8_MF8,
  PseudoVRGATHEREI16_VV_MF8_E8_MF8_MASK,
  PseudoVRGATHER_VI_M1,
  PseudoVRGATHER_VI_M1_MASK,
  PseudoVRGATHER_VI_M2,
  PseudoVRGATHER_VI_M2_MASK,
  PseudoVRGATHER_VI_M4,
  PseudoVRGATHER_VI_M4_MASK,
  PseudoVRGATHER_VI_M8,
  PseudoVRGATHER_VI_M8_MASK,
  PseudoVRGATHER_VI_MF2,
  PseudoVRGATHER_VI_MF2_MASK,
  PseudoVRGATHER_VI_MF4,
  PseudoVRGATHER_VI_MF4_MASK,
  PseudoVRGATHER_VI_MF8,
  PseudoVRGATHER_VI_MF8_MASK,
  PseudoVRGATHER_VV_M1_E16,
  PseudoVRGATHER_VV_M1_E16_MASK,
  PseudoVRGATHER_VV_M1_E32,
  PseudoVRGATHER_VV_M1_E32_MASK,
  PseudoVRGATHER_VV_M1_E64,
  PseudoVRGATHER_VV_M1_E64_MASK,
  PseudoVRGATHER_VV_M1_E8,
  PseudoVRGATHER_VV_M1_E8_MASK,
  PseudoVRGATHER_VV_M2_E16,
  PseudoVRGATHER_VV_M2_E16_MASK,
  PseudoVRGATHER_VV_M2_E32,
  PseudoVRGATHER_VV_M2_E32_MASK,
  PseudoVRGATHER_VV_M2_E64,
  PseudoVRGATHER_VV_M2_E64_MASK,
  PseudoVRGATHER_VV_M2_E8,
  PseudoVRGATHER_VV_M2_E8_MASK,
  PseudoVRGATHER_VV_M4_E16,
  PseudoVRGATHER_VV_M4_E16_MASK,
  PseudoVRGATHER_VV_M4_E32,
  PseudoVRGATHER_VV_M4_E32_MASK,
  PseudoVRGATHER_VV_M4_E64,
  PseudoVRGATHER_VV_M4_E64_MASK,
  PseudoVRGATHER_VV_M4_E8,
  PseudoVRGATHER_VV_M4_E8_MASK,
  PseudoVRGATHER_VV_M8_E16,
  PseudoVRGATHER_VV_M8_E16_MASK,
  PseudoVRGATHER_VV_M8_E32,
  PseudoVRGATHER_VV_M8_E32_MASK,
  PseudoVRGATHER_VV_M8_E64,
  PseudoVRGATHER_VV_M8_E64_MASK,
  PseudoVRGATHER_VV_M8_E8,
  PseudoVRGATHER_VV_M8_E8_MASK,
  PseudoVRGATHER_VV_MF2_E16,
  PseudoVRGATHER_VV_MF2_E16_MASK,
  PseudoVRGATHER_VV_MF2_E32,
  PseudoVRGATHER_VV_MF2_E32_MASK,
  PseudoVRGATHER_VV_MF2_E8,
  PseudoVRGATHER_VV_MF2_E8_MASK,
  PseudoVRGATHER_VV_MF4_E16,
  PseudoVRGATHER_VV_MF4_E16_MASK,
  PseudoVRGATHER_VV_MF4_E8,
  PseudoVRGATHER_VV_MF4_E8_MASK,
  PseudoVRGATHER_VV_MF8_E8,
  PseudoVRGATHER_VV_MF8_E8_MASK,
  PseudoVRGATHER_VX_M1,
  PseudoVRGATHER_VX_M1_MASK,
  PseudoVRGATHER_VX_M2,
  PseudoVRGATHER_VX_M2_MASK,
  PseudoVRGATHER_VX_M4,
  PseudoVRGATHER_VX_M4_MASK,
  PseudoVRGATHER_VX_M8,
  PseudoVRGATHER_VX_M8_MASK,
  PseudoVRGATHER_VX_MF2,
  PseudoVRGATHER_VX_MF2_MASK,
  PseudoVRGATHER_VX_MF4,
  PseudoVRGATHER_VX_MF4_MASK,
  PseudoVRGATHER_VX_MF8,
  PseudoVRGATHER_VX_MF8_MASK,
  PseudoVROL_VV_M1,
  PseudoVROL_VV_M1_MASK,
  PseudoVROL_VV_M2,
  PseudoVROL_VV_M2_MASK,
  PseudoVROL_VV_M4,
  PseudoVROL_VV_M4_MASK,
  PseudoVROL_VV_M8,
  PseudoVROL_VV_M8_MASK,
  PseudoVROL_VV_MF2,
  PseudoVROL_VV_MF2_MASK,
  PseudoVROL_VV_MF4,
  PseudoVROL_VV_MF4_MASK,
  PseudoVROL_VV_MF8,
  PseudoVROL_VV_MF8_MASK,
  PseudoVROL_VX_M1,
  PseudoVROL_VX_M1_MASK,
  PseudoVROL_VX_M2,
  PseudoVROL_VX_M2_MASK,
  PseudoVROL_VX_M4,
  PseudoVROL_VX_M4_MASK,
  PseudoVROL_VX_M8,
  PseudoVROL_VX_M8_MASK,
  PseudoVROL_VX_MF2,
  PseudoVROL_VX_MF2_MASK,
  PseudoVROL_VX_MF4,
  PseudoVROL_VX_MF4_MASK,
  PseudoVROL_VX_MF8,
  PseudoVROL_VX_MF8_MASK,
  PseudoVROR_VI_M1,
  PseudoVROR_VI_M1_MASK,
  PseudoVROR_VI_M2,
  PseudoVROR_VI_M2_MASK,
  PseudoVROR_VI_M4,
  PseudoVROR_VI_M4_MASK,
  PseudoVROR_VI_M8,
  PseudoVROR_VI_M8_MASK,
  PseudoVROR_VI_MF2,
  PseudoVROR_VI_MF2_MASK,
  PseudoVROR_VI_MF4,
  PseudoVROR_VI_MF4_MASK,
  PseudoVROR_VI_MF8,
  PseudoVROR_VI_MF8_MASK,
  PseudoVROR_VV_M1,
  PseudoVROR_VV_M1_MASK,
  PseudoVROR_VV_M2,
  PseudoVROR_VV_M2_MASK,
  PseudoVROR_VV_M4,
  PseudoVROR_VV_M4_MASK,
  PseudoVROR_VV_M8,
  PseudoVROR_VV_M8_MASK,
  PseudoVROR_VV_MF2,
  PseudoVROR_VV_MF2_MASK,
  PseudoVROR_VV_MF4,
  PseudoVROR_VV_MF4_MASK,
  PseudoVROR_VV_MF8,
  PseudoVROR_VV_MF8_MASK,
  PseudoVROR_VX_M1,
  PseudoVROR_VX_M1_MASK,
  PseudoVROR_VX_M2,
  PseudoVROR_VX_M2_MASK,
  PseudoVROR_VX_M4,
  PseudoVROR_VX_M4_MASK,
  PseudoVROR_VX_M8,
  PseudoVROR_VX_M8_MASK,
  PseudoVROR_VX_MF2,
  PseudoVROR_VX_MF2_MASK,
  PseudoVROR_VX_MF4,
  PseudoVROR_VX_MF4_MASK,
  PseudoVROR_VX_MF8,
  PseudoVROR_VX_MF8_MASK,
  PseudoVRSUB_VI_M1,
  PseudoVRSUB_VI_M1_MASK,
  PseudoVRSUB_VI_M2,
  PseudoVRSUB_VI_M2_MASK,
  PseudoVRSUB_VI_M4,
  PseudoVRSUB_VI_M4_MASK,
  PseudoVRSUB_VI_M8,
  PseudoVRSUB_VI_M8_MASK,
  PseudoVRSUB_VI_MF2,
  PseudoVRSUB_VI_MF2_MASK,
  PseudoVRSUB_VI_MF4,
  PseudoVRSUB_VI_MF4_MASK,
  PseudoVRSUB_VI_MF8,
  PseudoVRSUB_VI_MF8_MASK,
  PseudoVRSUB_VX_M1,
  PseudoVRSUB_VX_M1_MASK,
  PseudoVRSUB_VX_M2,
  PseudoVRSUB_VX_M2_MASK,
  PseudoVRSUB_VX_M4,
  PseudoVRSUB_VX_M4_MASK,
  PseudoVRSUB_VX_M8,
  PseudoVRSUB_VX_M8_MASK,
  PseudoVRSUB_VX_MF2,
  PseudoVRSUB_VX_MF2_MASK,
  PseudoVRSUB_VX_MF4,
  PseudoVRSUB_VX_MF4_MASK,
  PseudoVRSUB_VX_MF8,
  PseudoVRSUB_VX_MF8_MASK,
  PseudoVSADDU_VI_M1,
  PseudoVSADDU_VI_M1_MASK,
  PseudoVSADDU_VI_M2,
  PseudoVSADDU_VI_M2_MASK,
  PseudoVSADDU_VI_M4,
  PseudoVSADDU_VI_M4_MASK,
  PseudoVSADDU_VI_M8,
  PseudoVSADDU_VI_M8_MASK,
  PseudoVSADDU_VI_MF2,
  PseudoVSADDU_VI_MF2_MASK,
  PseudoVSADDU_VI_MF4,
  PseudoVSADDU_VI_MF4_MASK,
  PseudoVSADDU_VI_MF8,
  PseudoVSADDU_VI_MF8_MASK,
  PseudoVSADDU_VV_M1,
  PseudoVSADDU_VV_M1_MASK,
  PseudoVSADDU_VV_M2,
  PseudoVSADDU_VV_M2_MASK,
  PseudoVSADDU_VV_M4,
  PseudoVSADDU_VV_M4_MASK,
  PseudoVSADDU_VV_M8,
  PseudoVSADDU_VV_M8_MASK,
  PseudoVSADDU_VV_MF2,
  PseudoVSADDU_VV_MF2_MASK,
  PseudoVSADDU_VV_MF4,
  PseudoVSADDU_VV_MF4_MASK,
  PseudoVSADDU_VV_MF8,
  PseudoVSADDU_VV_MF8_MASK,
  PseudoVSADDU_VX_M1,
  PseudoVSADDU_VX_M1_MASK,
  PseudoVSADDU_VX_M2,
  PseudoVSADDU_VX_M2_MASK,
  PseudoVSADDU_VX_M4,
  PseudoVSADDU_VX_M4_MASK,
  PseudoVSADDU_VX_M8,
  PseudoVSADDU_VX_M8_MASK,
  PseudoVSADDU_VX_MF2,
  PseudoVSADDU_VX_MF2_MASK,
  PseudoVSADDU_VX_MF4,
  PseudoVSADDU_VX_MF4_MASK,
  PseudoVSADDU_VX_MF8,
  PseudoVSADDU_VX_MF8_MASK,
  PseudoVSADD_VI_M1,
  PseudoVSADD_VI_M1_MASK,
  PseudoVSADD_VI_M2,
  PseudoVSADD_VI_M2_MASK,
  PseudoVSADD_VI_M4,
  PseudoVSADD_VI_M4_MASK,
  PseudoVSADD_VI_M8,
  PseudoVSADD_VI_M8_MASK,
  PseudoVSADD_VI_MF2,
  PseudoVSADD_VI_MF2_MASK,
  PseudoVSADD_VI_MF4,
  PseudoVSADD_VI_MF4_MASK,
  PseudoVSADD_VI_MF8,
  PseudoVSADD_VI_MF8_MASK,
  PseudoVSADD_VV_M1,
  PseudoVSADD_VV_M1_MASK,
  PseudoVSADD_VV_M2,
  PseudoVSADD_VV_M2_MASK,
  PseudoVSADD_VV_M4,
  PseudoVSADD_VV_M4_MASK,
  PseudoVSADD_VV_M8,
  PseudoVSADD_VV_M8_MASK,
  PseudoVSADD_VV_MF2,
  PseudoVSADD_VV_MF2_MASK,
  PseudoVSADD_VV_MF4,
  PseudoVSADD_VV_MF4_MASK,
  PseudoVSADD_VV_MF8,
  PseudoVSADD_VV_MF8_MASK,
  PseudoVSADD_VX_M1,
  PseudoVSADD_VX_M1_MASK,
  PseudoVSADD_VX_M2,
  PseudoVSADD_VX_M2_MASK,
  PseudoVSADD_VX_M4,
  PseudoVSADD_VX_M4_MASK,
  PseudoVSADD_VX_M8,
  PseudoVSADD_VX_M8_MASK,
  PseudoVSADD_VX_MF2,
  PseudoVSADD_VX_MF2_MASK,
  PseudoVSADD_VX_MF4,
  PseudoVSADD_VX_MF4_MASK,
  PseudoVSADD_VX_MF8,
  PseudoVSADD_VX_MF8_MASK,
  PseudoVSBC_VVM_M1,
  PseudoVSBC_VVM_M2,
  PseudoVSBC_VVM_M4,
  PseudoVSBC_VVM_M8,
  PseudoVSBC_VVM_MF2,
  PseudoVSBC_VVM_MF4,
  PseudoVSBC_VVM_MF8,
  PseudoVSBC_VXM_M1,
  PseudoVSBC_VXM_M2,
  PseudoVSBC_VXM_M4,
  PseudoVSBC_VXM_M8,
  PseudoVSBC_VXM_MF2,
  PseudoVSBC_VXM_MF4,
  PseudoVSBC_VXM_MF8,
  PseudoVSE16_V_M1,
  PseudoVSE16_V_M1_MASK,
  PseudoVSE16_V_M2,
  PseudoVSE16_V_M2_MASK,
  PseudoVSE16_V_M4,
  PseudoVSE16_V_M4_MASK,
  PseudoVSE16_V_M8,
  PseudoVSE16_V_M8_MASK,
  PseudoVSE16_V_MF2,
  PseudoVSE16_V_MF2_MASK,
  PseudoVSE16_V_MF4,
  PseudoVSE16_V_MF4_MASK,
  PseudoVSE32_V_M1,
  PseudoVSE32_V_M1_MASK,
  PseudoVSE32_V_M2,
  PseudoVSE32_V_M2_MASK,
  PseudoVSE32_V_M4,
  PseudoVSE32_V_M4_MASK,
  PseudoVSE32_V_M8,
  PseudoVSE32_V_M8_MASK,
  PseudoVSE32_V_MF2,
  PseudoVSE32_V_MF2_MASK,
  PseudoVSE64_V_M1,
  PseudoVSE64_V_M1_MASK,
  PseudoVSE64_V_M2,
  PseudoVSE64_V_M2_MASK,
  PseudoVSE64_V_M4,
  PseudoVSE64_V_M4_MASK,
  PseudoVSE64_V_M8,
  PseudoVSE64_V_M8_MASK,
  PseudoVSE8_V_M1,
  PseudoVSE8_V_M1_MASK,
  PseudoVSE8_V_M2,
  PseudoVSE8_V_M2_MASK,
  PseudoVSE8_V_M4,
  PseudoVSE8_V_M4_MASK,
  PseudoVSE8_V_M8,
  PseudoVSE8_V_M8_MASK,
  PseudoVSE8_V_MF2,
  PseudoVSE8_V_MF2_MASK,
  PseudoVSE8_V_MF4,
  PseudoVSE8_V_MF4_MASK,
  PseudoVSE8_V_MF8,
  PseudoVSE8_V_MF8_MASK,
  PseudoVSETIVLI,
  PseudoVSETVLI,
  PseudoVSETVLIX0,
  PseudoVSEXT_VF2_M1,
  PseudoVSEXT_VF2_M1_MASK,
  PseudoVSEXT_VF2_M2,
  PseudoVSEXT_VF2_M2_MASK,
  PseudoVSEXT_VF2_M4,
  PseudoVSEXT_VF2_M4_MASK,
  PseudoVSEXT_VF2_M8,
  PseudoVSEXT_VF2_M8_MASK,
  PseudoVSEXT_VF2_MF2,
  PseudoVSEXT_VF2_MF2_MASK,
  PseudoVSEXT_VF2_MF4,
  PseudoVSEXT_VF2_MF4_MASK,
  PseudoVSEXT_VF4_M1,
  PseudoVSEXT_VF4_M1_MASK,
  PseudoVSEXT_VF4_M2,
  PseudoVSEXT_VF4_M2_MASK,
  PseudoVSEXT_VF4_M4,
  PseudoVSEXT_VF4_M4_MASK,
  PseudoVSEXT_VF4_M8,
  PseudoVSEXT_VF4_M8_MASK,
  PseudoVSEXT_VF4_MF2,
  PseudoVSEXT_VF4_MF2_MASK,
  PseudoVSEXT_VF8_M1,
  PseudoVSEXT_VF8_M1_MASK,
  PseudoVSEXT_VF8_M2,
  PseudoVSEXT_VF8_M2_MASK,
  PseudoVSEXT_VF8_M4,
  PseudoVSEXT_VF8_M4_MASK,
  PseudoVSEXT_VF8_M8,
  PseudoVSEXT_VF8_M8_MASK,
  PseudoVSHA2CH_VV_M1,
  PseudoVSHA2CH_VV_M2,
  PseudoVSHA2CH_VV_M4,
  PseudoVSHA2CH_VV_M8,
  PseudoVSHA2CH_VV_MF2,
  PseudoVSHA2CL_VV_M1,
  PseudoVSHA2CL_VV_M2,
  PseudoVSHA2CL_VV_M4,
  PseudoVSHA2CL_VV_M8,
  PseudoVSHA2CL_VV_MF2,
  PseudoVSHA2MS_VV_M1,
  PseudoVSHA2MS_VV_M2,
  PseudoVSHA2MS_VV_M4,
  PseudoVSHA2MS_VV_M8,
  PseudoVSHA2MS_VV_MF2,
  PseudoVSLIDE1DOWN_VX_M1,
  PseudoVSLIDE1DOWN_VX_M1_MASK,
  PseudoVSLIDE1DOWN_VX_M2,
  PseudoVSLIDE1DOWN_VX_M2_MASK,
  PseudoVSLIDE1DOWN_VX_M4,
  PseudoVSLIDE1DOWN_VX_M4_MASK,
  PseudoVSLIDE1DOWN_VX_M8,
  PseudoVSLIDE1DOWN_VX_M8_MASK,
  PseudoVSLIDE1DOWN_VX_MF2,
  PseudoVSLIDE1DOWN_VX_MF2_MASK,
  PseudoVSLIDE1DOWN_VX_MF4,
  PseudoVSLIDE1DOWN_VX_MF4_MASK,
  PseudoVSLIDE1DOWN_VX_MF8,
  PseudoVSLIDE1DOWN_VX_MF8_MASK,
  PseudoVSLIDE1UP_VX_M1,
  PseudoVSLIDE1UP_VX_M1_MASK,
  PseudoVSLIDE1UP_VX_M2,
  PseudoVSLIDE1UP_VX_M2_MASK,
  PseudoVSLIDE1UP_VX_M4,
  PseudoVSLIDE1UP_VX_M4_MASK,
  PseudoVSLIDE1UP_VX_M8,
  PseudoVSLIDE1UP_VX_M8_MASK,
  PseudoVSLIDE1UP_VX_MF2,
  PseudoVSLIDE1UP_VX_MF2_MASK,
  PseudoVSLIDE1UP_VX_MF4,
  PseudoVSLIDE1UP_VX_MF4_MASK,
  PseudoVSLIDE1UP_VX_MF8,
  PseudoVSLIDE1UP_VX_MF8_MASK,
  PseudoVSLIDEDOWN_VI_M1,
  PseudoVSLIDEDOWN_VI_M1_MASK,
  PseudoVSLIDEDOWN_VI_M2,
  PseudoVSLIDEDOWN_VI_M2_MASK,
  PseudoVSLIDEDOWN_VI_M4,
  PseudoVSLIDEDOWN_VI_M4_MASK,
  PseudoVSLIDEDOWN_VI_M8,
  PseudoVSLIDEDOWN_VI_M8_MASK,
  PseudoVSLIDEDOWN_VI_MF2,
  PseudoVSLIDEDOWN_VI_MF2_MASK,
  PseudoVSLIDEDOWN_VI_MF4,
  PseudoVSLIDEDOWN_VI_MF4_MASK,
  PseudoVSLIDEDOWN_VI_MF8,
  PseudoVSLIDEDOWN_VI_MF8_MASK,
  PseudoVSLIDEDOWN_VX_M1,
  PseudoVSLIDEDOWN_VX_M1_MASK,
  PseudoVSLIDEDOWN_VX_M2,
  PseudoVSLIDEDOWN_VX_M2_MASK,
  PseudoVSLIDEDOWN_VX_M4,
  PseudoVSLIDEDOWN_VX_M4_MASK,
  PseudoVSLIDEDOWN_VX_M8,
  PseudoVSLIDEDOWN_VX_M8_MASK,
  PseudoVSLIDEDOWN_VX_MF2,
  PseudoVSLIDEDOWN_VX_MF2_MASK,
  PseudoVSLIDEDOWN_VX_MF4,
  PseudoVSLIDEDOWN_VX_MF4_MASK,
  PseudoVSLIDEDOWN_VX_MF8,
  PseudoVSLIDEDOWN_VX_MF8_MASK,
  PseudoVSLIDEUP_VI_M1,
  PseudoVSLIDEUP_VI_M1_MASK,
  PseudoVSLIDEUP_VI_M2,
  PseudoVSLIDEUP_VI_M2_MASK,
  PseudoVSLIDEUP_VI_M4,
  PseudoVSLIDEUP_VI_M4_MASK,
  PseudoVSLIDEUP_VI_M8,
  PseudoVSLIDEUP_VI_M8_MASK,
  PseudoVSLIDEUP_VI_MF2,
  PseudoVSLIDEUP_VI_MF2_MASK,
  PseudoVSLIDEUP_VI_MF4,
  PseudoVSLIDEUP_VI_MF4_MASK,
  PseudoVSLIDEUP_VI_MF8,
  PseudoVSLIDEUP_VI_MF8_MASK,
  PseudoVSLIDEUP_VX_M1,
  PseudoVSLIDEUP_VX_M1_MASK,
  PseudoVSLIDEUP_VX_M2,
  PseudoVSLIDEUP_VX_M2_MASK,
  PseudoVSLIDEUP_VX_M4,
  PseudoVSLIDEUP_VX_M4_MASK,
  PseudoVSLIDEUP_VX_M8,
  PseudoVSLIDEUP_VX_M8_MASK,
  PseudoVSLIDEUP_VX_MF2,
  PseudoVSLIDEUP_VX_MF2_MASK,
  PseudoVSLIDEUP_VX_MF4,
  PseudoVSLIDEUP_VX_MF4_MASK,
  PseudoVSLIDEUP_VX_MF8,
  PseudoVSLIDEUP_VX_MF8_MASK,
  PseudoVSLL_VI_M1,
  PseudoVSLL_VI_M1_MASK,
  PseudoVSLL_VI_M2,
  PseudoVSLL_VI_M2_MASK,
  PseudoVSLL_VI_M4,
  PseudoVSLL_VI_M4_MASK,
  PseudoVSLL_VI_M8,
  PseudoVSLL_VI_M8_MASK,
  PseudoVSLL_VI_MF2,
  PseudoVSLL_VI_MF2_MASK,
  PseudoVSLL_VI_MF4,
  PseudoVSLL_VI_MF4_MASK,
  PseudoVSLL_VI_MF8,
  PseudoVSLL_VI_MF8_MASK,
  PseudoVSLL_VV_M1,
  PseudoVSLL_VV_M1_MASK,
  PseudoVSLL_VV_M2,
  PseudoVSLL_VV_M2_MASK,
  PseudoVSLL_VV_M4,
  PseudoVSLL_VV_M4_MASK,
  PseudoVSLL_VV_M8,
  PseudoVSLL_VV_M8_MASK,
  PseudoVSLL_VV_MF2,
  PseudoVSLL_VV_MF2_MASK,
  PseudoVSLL_VV_MF4,
  PseudoVSLL_VV_MF4_MASK,
  PseudoVSLL_VV_MF8,
  PseudoVSLL_VV_MF8_MASK,
  PseudoVSLL_VX_M1,
  PseudoVSLL_VX_M1_MASK,
  PseudoVSLL_VX_M2,
  PseudoVSLL_VX_M2_MASK,
  PseudoVSLL_VX_M4,
  PseudoVSLL_VX_M4_MASK,
  PseudoVSLL_VX_M8,
  PseudoVSLL_VX_M8_MASK,
  PseudoVSLL_VX_MF2,
  PseudoVSLL_VX_MF2_MASK,
  PseudoVSLL_VX_MF4,
  PseudoVSLL_VX_MF4_MASK,
  PseudoVSLL_VX_MF8,
  PseudoVSLL_VX_MF8_MASK,
  PseudoVSM3C_VI_M1,
  PseudoVSM3C_VI_M2,
  PseudoVSM3C_VI_M4,
  PseudoVSM3C_VI_M8,
  PseudoVSM3C_VI_MF2,
  PseudoVSM3ME_VV_M1,
  PseudoVSM3ME_VV_M2,
  PseudoVSM3ME_VV_M4,
  PseudoVSM3ME_VV_M8,
  PseudoVSM3ME_VV_MF2,
  PseudoVSM4K_VI_M1,
  PseudoVSM4K_VI_M2,
  PseudoVSM4K_VI_M4,
  PseudoVSM4K_VI_M8,
  PseudoVSM4K_VI_MF2,
  PseudoVSM4R_VS_M1_M1,
  PseudoVSM4R_VS_M1_MF2,
  PseudoVSM4R_VS_M1_MF4,
  PseudoVSM4R_VS_M1_MF8,
  PseudoVSM4R_VS_M2_M1,
  PseudoVSM4R_VS_M2_M2,
  PseudoVSM4R_VS_M2_MF2,
  PseudoVSM4R_VS_M2_MF4,
  PseudoVSM4R_VS_M2_MF8,
  PseudoVSM4R_VS_M4_M1,
  PseudoVSM4R_VS_M4_M2,
  PseudoVSM4R_VS_M4_M4,
  PseudoVSM4R_VS_M4_MF2,
  PseudoVSM4R_VS_M4_MF4,
  PseudoVSM4R_VS_M4_MF8,
  PseudoVSM4R_VS_M8_M1,
  PseudoVSM4R_VS_M8_M2,
  PseudoVSM4R_VS_M8_M4,
  PseudoVSM4R_VS_M8_MF2,
  PseudoVSM4R_VS_M8_MF4,
  PseudoVSM4R_VS_M8_MF8,
  PseudoVSM4R_VS_MF2_MF2,
  PseudoVSM4R_VS_MF2_MF4,
  PseudoVSM4R_VS_MF2_MF8,
  PseudoVSM4R_VV_M1,
  PseudoVSM4R_VV_M2,
  PseudoVSM4R_VV_M4,
  PseudoVSM4R_VV_M8,
  PseudoVSM4R_VV_MF2,
  PseudoVSMUL_VV_M1,
  PseudoVSMUL_VV_M1_MASK,
  PseudoVSMUL_VV_M2,
  PseudoVSMUL_VV_M2_MASK,
  PseudoVSMUL_VV_M4,
  PseudoVSMUL_VV_M4_MASK,
  PseudoVSMUL_VV_M8,
  PseudoVSMUL_VV_M8_MASK,
  PseudoVSMUL_VV_MF2,
  PseudoVSMUL_VV_MF2_MASK,
  PseudoVSMUL_VV_MF4,
  PseudoVSMUL_VV_MF4_MASK,
  PseudoVSMUL_VV_MF8,
  PseudoVSMUL_VV_MF8_MASK,
  PseudoVSMUL_VX_M1,
  PseudoVSMUL_VX_M1_MASK,
  PseudoVSMUL_VX_M2,
  PseudoVSMUL_VX_M2_MASK,
  PseudoVSMUL_VX_M4,
  PseudoVSMUL_VX_M4_MASK,
  PseudoVSMUL_VX_M8,
  PseudoVSMUL_VX_M8_MASK,
  PseudoVSMUL_VX_MF2,
  PseudoVSMUL_VX_MF2_MASK,
  PseudoVSMUL_VX_MF4,
  PseudoVSMUL_VX_MF4_MASK,
  PseudoVSMUL_VX_MF8,
  PseudoVSMUL_VX_MF8_MASK,
  PseudoVSM_V_B1,
  PseudoVSM_V_B16,
  PseudoVSM_V_B2,
  PseudoVSM_V_B32,
  PseudoVSM_V_B4,
  PseudoVSM_V_B64,
  PseudoVSM_V_B8,
  PseudoVSOXEI16_V_M1_M1,
  PseudoVSOXEI16_V_M1_M1_MASK,
  PseudoVSOXEI16_V_M1_M2,
  PseudoVSOXEI16_V_M1_M2_MASK,
  PseudoVSOXEI16_V_M1_M4,
  PseudoVSOXEI16_V_M1_M4_MASK,
  PseudoVSOXEI16_V_M1_MF2,
  PseudoVSOXEI16_V_M1_MF2_MASK,
  PseudoVSOXEI16_V_M2_M1,
  PseudoVSOXEI16_V_M2_M1_MASK,
  PseudoVSOXEI16_V_M2_M2,
  PseudoVSOXEI16_V_M2_M2_MASK,
  PseudoVSOXEI16_V_M2_M4,
  PseudoVSOXEI16_V_M2_M4_MASK,
  PseudoVSOXEI16_V_M2_M8,
  PseudoVSOXEI16_V_M2_M8_MASK,
  PseudoVSOXEI16_V_M4_M2,
  PseudoVSOXEI16_V_M4_M2_MASK,
  PseudoVSOXEI16_V_M4_M4,
  PseudoVSOXEI16_V_M4_M4_MASK,
  PseudoVSOXEI16_V_M4_M8,
  PseudoVSOXEI16_V_M4_M8_MASK,
  PseudoVSOXEI16_V_M8_M4,
  PseudoVSOXEI16_V_M8_M4_MASK,
  PseudoVSOXEI16_V_M8_M8,
  PseudoVSOXEI16_V_M8_M8_MASK,
  PseudoVSOXEI16_V_MF2_M1,
  PseudoVSOXEI16_V_MF2_M1_MASK,
  PseudoVSOXEI16_V_MF2_M2,
  PseudoVSOXEI16_V_MF2_M2_MASK,
  PseudoVSOXEI16_V_MF2_MF2,
  PseudoVSOXEI16_V_MF2_MF2_MASK,
  PseudoVSOXEI16_V_MF2_MF4,
  PseudoVSOXEI16_V_MF2_MF4_MASK,
  PseudoVSOXEI16_V_MF4_M1,
  PseudoVSOXEI16_V_MF4_M1_MASK,
  PseudoVSOXEI16_V_MF4_MF2,
  PseudoVSOXEI16_V_MF4_MF2_MASK,
  PseudoVSOXEI16_V_MF4_MF4,
  PseudoVSOXEI16_V_MF4_MF4_MASK,
  PseudoVSOXEI16_V_MF4_MF8,
  PseudoVSOXEI16_V_MF4_MF8_MASK,
  PseudoVSOXEI32_V_M1_M1,
  PseudoVSOXEI32_V_M1_M1_MASK,
  PseudoVSOXEI32_V_M1_M2,
  PseudoVSOXEI32_V_M1_M2_MASK,
  PseudoVSOXEI32_V_M1_MF2,
  PseudoVSOXEI32_V_M1_MF2_MASK,
  PseudoVSOXEI32_V_M1_MF4,
  PseudoVSOXEI32_V_M1_MF4_MASK,
  PseudoVSOXEI32_V_M2_M1,
  PseudoVSOXEI32_V_M2_M1_MASK,
  PseudoVSOXEI32_V_M2_M2,
  PseudoVSOXEI32_V_M2_M2_MASK,
  PseudoVSOXEI32_V_M2_M4,
  PseudoVSOXEI32_V_M2_M4_MASK,
  PseudoVSOXEI32_V_M2_MF2,
  PseudoVSOXEI32_V_M2_MF2_MASK,
  PseudoVSOXEI32_V_M4_M1,
  PseudoVSOXEI32_V_M4_M1_MASK,
  PseudoVSOXEI32_V_M4_M2,
  PseudoVSOXEI32_V_M4_M2_MASK,
  PseudoVSOXEI32_V_M4_M4,
  PseudoVSOXEI32_V_M4_M4_MASK,
  PseudoVSOXEI32_V_M4_M8,
  PseudoVSOXEI32_V_M4_M8_MASK,
  PseudoVSOXEI32_V_M8_M2,
  PseudoVSOXEI32_V_M8_M2_MASK,
  PseudoVSOXEI32_V_M8_M4,
  PseudoVSOXEI32_V_M8_M4_MASK,
  PseudoVSOXEI32_V_M8_M8,
  PseudoVSOXEI32_V_M8_M8_MASK,
  PseudoVSOXEI32_V_MF2_M1,
  PseudoVSOXEI32_V_MF2_M1_MASK,
  PseudoVSOXEI32_V_MF2_MF2,
  PseudoVSOXEI32_V_MF2_MF2_MASK,
  PseudoVSOXEI32_V_MF2_MF4,
  PseudoVSOXEI32_V_MF2_MF4_MASK,
  PseudoVSOXEI32_V_MF2_MF8,
  PseudoVSOXEI32_V_MF2_MF8_MASK,
  PseudoVSOXEI64_V_M1_M1,
  PseudoVSOXEI64_V_M1_M1_MASK,
  PseudoVSOXEI64_V_M1_MF2,
  PseudoVSOXEI64_V_M1_MF2_MASK,
  PseudoVSOXEI64_V_M1_MF4,
  PseudoVSOXEI64_V_M1_MF4_MASK,
  PseudoVSOXEI64_V_M1_MF8,
  PseudoVSOXEI64_V_M1_MF8_MASK,
  PseudoVSOXEI64_V_M2_M1,
  PseudoVSOXEI64_V_M2_M1_MASK,
  PseudoVSOXEI64_V_M2_M2,
  PseudoVSOXEI64_V_M2_M2_MASK,
  PseudoVSOXEI64_V_M2_MF2,
  PseudoVSOXEI64_V_M2_MF2_MASK,
  PseudoVSOXEI64_V_M2_MF4,
  PseudoVSOXEI64_V_M2_MF4_MASK,
  PseudoVSOXEI64_V_M4_M1,
  PseudoVSOXEI64_V_M4_M1_MASK,
  PseudoVSOXEI64_V_M4_M2,
  PseudoVSOXEI64_V_M4_M2_MASK,
  PseudoVSOXEI64_V_M4_M4,
  PseudoVSOXEI64_V_M4_M4_MASK,
  PseudoVSOXEI64_V_M4_MF2,
  PseudoVSOXEI64_V_M4_MF2_MASK,
  PseudoVSOXEI64_V_M8_M1,
  PseudoVSOXEI64_V_M8_M1_MASK,
  PseudoVSOXEI64_V_M8_M2,
  PseudoVSOXEI64_V_M8_M2_MASK,
  PseudoVSOXEI64_V_M8_M4,
  PseudoVSOXEI64_V_M8_M4_MASK,
  PseudoVSOXEI64_V_M8_M8,
  PseudoVSOXEI64_V_M8_M8_MASK,
  PseudoVSOXEI8_V_M1_M1,
  PseudoVSOXEI8_V_M1_M1_MASK,
  PseudoVSOXEI8_V_M1_M2,
  PseudoVSOXEI8_V_M1_M2_MASK,
  PseudoVSOXEI8_V_M1_M4,
  PseudoVSOXEI8_V_M1_M4_MASK,
  PseudoVSOXEI8_V_M1_M8,
  PseudoVSOXEI8_V_M1_M8_MASK,
  PseudoVSOXEI8_V_M2_M2,
  PseudoVSOXEI8_V_M2_M2_MASK,
  PseudoVSOXEI8_V_M2_M4,
  PseudoVSOXEI8_V_M2_M4_MASK,
  PseudoVSOXEI8_V_M2_M8,
  PseudoVSOXEI8_V_M2_M8_MASK,
  PseudoVSOXEI8_V_M4_M4,
  PseudoVSOXEI8_V_M4_M4_MASK,
  PseudoVSOXEI8_V_M4_M8,
  PseudoVSOXEI8_V_M4_M8_MASK,
  PseudoVSOXEI8_V_M8_M8,
  PseudoVSOXEI8_V_M8_M8_MASK,
  PseudoVSOXEI8_V_MF2_M1,
  PseudoVSOXEI8_V_MF2_M1_MASK,
  PseudoVSOXEI8_V_MF2_M2,
  PseudoVSOXEI8_V_MF2_M2_MASK,
  PseudoVSOXEI8_V_MF2_M4,
  PseudoVSOXEI8_V_MF2_M4_MASK,
  PseudoVSOXEI8_V_MF2_MF2,
  PseudoVSOXEI8_V_MF2_MF2_MASK,
  PseudoVSOXEI8_V_MF4_M1,
  PseudoVSOXEI8_V_MF4_M1_MASK,
  PseudoVSOXEI8_V_MF4_M2,
  PseudoVSOXEI8_V_MF4_M2_MASK,
  PseudoVSOXEI8_V_MF4_MF2,
  PseudoVSOXEI8_V_MF4_MF2_MASK,
  PseudoVSOXEI8_V_MF4_MF4,
  PseudoVSOXEI8_V_MF4_MF4_MASK,
  PseudoVSOXEI8_V_MF8_M1,
  PseudoVSOXEI8_V_MF8_M1_MASK,
  PseudoVSOXEI8_V_MF8_MF2,
  PseudoVSOXEI8_V_MF8_MF2_MASK,
  PseudoVSOXEI8_V_MF8_MF4,
  PseudoVSOXEI8_V_MF8_MF4_MASK,
  PseudoVSOXEI8_V_MF8_MF8,
  PseudoVSOXEI8_V_MF8_MF8_MASK,
  PseudoVSOXSEG2EI16_V_M1_M1,
  PseudoVSOXSEG2EI16_V_M1_M1_MASK,
  PseudoVSOXSEG2EI16_V_M1_M2,
  PseudoVSOXSEG2EI16_V_M1_M2_MASK,
  PseudoVSOXSEG2EI16_V_M1_M4,
  PseudoVSOXSEG2EI16_V_M1_M4_MASK,
  PseudoVSOXSEG2EI16_V_M1_MF2,
  PseudoVSOXSEG2EI16_V_M1_MF2_MASK,
  PseudoVSOXSEG2EI16_V_M2_M1,
  PseudoVSOXSEG2EI16_V_M2_M1_MASK,
  PseudoVSOXSEG2EI16_V_M2_M2,
  PseudoVSOXSEG2EI16_V_M2_M2_MASK,
  PseudoVSOXSEG2EI16_V_M2_M4,
  PseudoVSOXSEG2EI16_V_M2_M4_MASK,
  PseudoVSOXSEG2EI16_V_M4_M2,
  PseudoVSOXSEG2EI16_V_M4_M2_MASK,
  PseudoVSOXSEG2EI16_V_M4_M4,
  PseudoVSOXSEG2EI16_V_M4_M4_MASK,
  PseudoVSOXSEG2EI16_V_M8_M4,
  PseudoVSOXSEG2EI16_V_M8_M4_MASK,
  PseudoVSOXSEG2EI16_V_MF2_M1,
  PseudoVSOXSEG2EI16_V_MF2_M1_MASK,
  PseudoVSOXSEG2EI16_V_MF2_M2,
  PseudoVSOXSEG2EI16_V_MF2_M2_MASK,
  PseudoVSOXSEG2EI16_V_MF2_MF2,
  PseudoVSOXSEG2EI16_V_MF2_MF2_MASK,
  PseudoVSOXSEG2EI16_V_MF2_MF4,
  PseudoVSOXSEG2EI16_V_MF2_MF4_MASK,
  PseudoVSOXSEG2EI16_V_MF4_M1,
  PseudoVSOXSEG2EI16_V_MF4_M1_MASK,
  PseudoVSOXSEG2EI16_V_MF4_MF2,
  PseudoVSOXSEG2EI16_V_MF4_MF2_MASK,
  PseudoVSOXSEG2EI16_V_MF4_MF4,
  PseudoVSOXSEG2EI16_V_MF4_MF4_MASK,
  PseudoVSOXSEG2EI16_V_MF4_MF8,
  PseudoVSOXSEG2EI16_V_MF4_MF8_MASK,
  PseudoVSOXSEG2EI32_V_M1_M1,
  PseudoVSOXSEG2EI32_V_M1_M1_MASK,
  PseudoVSOXSEG2EI32_V_M1_M2,
  PseudoVSOXSEG2EI32_V_M1_M2_MASK,
  PseudoVSOXSEG2EI32_V_M1_MF2,
  PseudoVSOXSEG2EI32_V_M1_MF2_MASK,
  PseudoVSOXSEG2EI32_V_M1_MF4,
  PseudoVSOXSEG2EI32_V_M1_MF4_MASK,
  PseudoVSOXSEG2EI32_V_M2_M1,
  PseudoVSOXSEG2EI32_V_M2_M1_MASK,
  PseudoVSOXSEG2EI32_V_M2_M2,
  PseudoVSOXSEG2EI32_V_M2_M2_MASK,
  PseudoVSOXSEG2EI32_V_M2_M4,
  PseudoVSOXSEG2EI32_V_M2_M4_MASK,
  PseudoVSOXSEG2EI32_V_M2_MF2,
  PseudoVSOXSEG2EI32_V_M2_MF2_MASK,
  PseudoVSOXSEG2EI32_V_M4_M1,
  PseudoVSOXSEG2EI32_V_M4_M1_MASK,
  PseudoVSOXSEG2EI32_V_M4_M2,
  PseudoVSOXSEG2EI32_V_M4_M2_MASK,
  PseudoVSOXSEG2EI32_V_M4_M4,
  PseudoVSOXSEG2EI32_V_M4_M4_MASK,
  PseudoVSOXSEG2EI32_V_M8_M2,
  PseudoVSOXSEG2EI32_V_M8_M2_MASK,
  PseudoVSOXSEG2EI32_V_M8_M4,
  PseudoVSOXSEG2EI32_V_M8_M4_MASK,
  PseudoVSOXSEG2EI32_V_MF2_M1,
  PseudoVSOXSEG2EI32_V_MF2_M1_MASK,
  PseudoVSOXSEG2EI32_V_MF2_MF2,
  PseudoVSOXSEG2EI32_V_MF2_MF2_MASK,
  PseudoVSOXSEG2EI32_V_MF2_MF4,
  PseudoVSOXSEG2EI32_V_MF2_MF4_MASK,
  PseudoVSOXSEG2EI32_V_MF2_MF8,
  PseudoVSOXSEG2EI32_V_MF2_MF8_MASK,
  PseudoVSOXSEG2EI64_V_M1_M1,
  PseudoVSOXSEG2EI64_V_M1_M1_MASK,
  PseudoVSOXSEG2EI64_V_M1_MF2,
  PseudoVSOXSEG2EI64_V_M1_MF2_MASK,
  PseudoVSOXSEG2EI64_V_M1_MF4,
  PseudoVSOXSEG2EI64_V_M1_MF4_MASK,
  PseudoVSOXSEG2EI64_V_M1_MF8,
  PseudoVSOXSEG2EI64_V_M1_MF8_MASK,
  PseudoVSOXSEG2EI64_V_M2_M1,
  PseudoVSOXSEG2EI64_V_M2_M1_MASK,
  PseudoVSOXSEG2EI64_V_M2_M2,
  PseudoVSOXSEG2EI64_V_M2_M2_MASK,
  PseudoVSOXSEG2EI64_V_M2_MF2,
  PseudoVSOXSEG2EI64_V_M2_MF2_MASK,
  PseudoVSOXSEG2EI64_V_M2_MF4,
  PseudoVSOXSEG2EI64_V_M2_MF4_MASK,
  PseudoVSOXSEG2EI64_V_M4_M1,
  PseudoVSOXSEG2EI64_V_M4_M1_MASK,
  PseudoVSOXSEG2EI64_V_M4_M2,
  PseudoVSOXSEG2EI64_V_M4_M2_MASK,
  PseudoVSOXSEG2EI64_V_M4_M4,
  PseudoVSOXSEG2EI64_V_M4_M4_MASK,
  PseudoVSOXSEG2EI64_V_M4_MF2,
  PseudoVSOXSEG2EI64_V_M4_MF2_MASK,
  PseudoVSOXSEG2EI64_V_M8_M1,
  PseudoVSOXSEG2EI64_V_M8_M1_MASK,
  PseudoVSOXSEG2EI64_V_M8_M2,
  PseudoVSOXSEG2EI64_V_M8_M2_MASK,
  PseudoVSOXSEG2EI64_V_M8_M4,
  PseudoVSOXSEG2EI64_V_M8_M4_MASK,
  PseudoVSOXSEG2EI8_V_M1_M1,
  PseudoVSOXSEG2EI8_V_M1_M1_MASK,
  PseudoVSOXSEG2EI8_V_M1_M2,
  PseudoVSOXSEG2EI8_V_M1_M2_MASK,
  PseudoVSOXSEG2EI8_V_M1_M4,
  PseudoVSOXSEG2EI8_V_M1_M4_MASK,
  PseudoVSOXSEG2EI8_V_M2_M2,
  PseudoVSOXSEG2EI8_V_M2_M2_MASK,
  PseudoVSOXSEG2EI8_V_M2_M4,
  PseudoVSOXSEG2EI8_V_M2_M4_MASK,
  PseudoVSOXSEG2EI8_V_M4_M4,
  PseudoVSOXSEG2EI8_V_M4_M4_MASK,
  PseudoVSOXSEG2EI8_V_MF2_M1,
  PseudoVSOXSEG2EI8_V_MF2_M1_MASK,
  PseudoVSOXSEG2EI8_V_MF2_M2,
  PseudoVSOXSEG2EI8_V_MF2_M2_MASK,
  PseudoVSOXSEG2EI8_V_MF2_M4,
  PseudoVSOXSEG2EI8_V_MF2_M4_MASK,
  PseudoVSOXSEG2EI8_V_MF2_MF2,
  PseudoVSOXSEG2EI8_V_MF2_MF2_MASK,
  PseudoVSOXSEG2EI8_V_MF4_M1,
  PseudoVSOXSEG2EI8_V_MF4_M1_MASK,
  PseudoVSOXSEG2EI8_V_MF4_M2,
  PseudoVSOXSEG2EI8_V_MF4_M2_MASK,
  PseudoVSOXSEG2EI8_V_MF4_MF2,
  PseudoVSOXSEG2EI8_V_MF4_MF2_MASK,
  PseudoVSOXSEG2EI8_V_MF4_MF4,
  PseudoVSOXSEG2EI8_V_MF4_MF4_MASK,
  PseudoVSOXSEG2EI8_V_MF8_M1,
  PseudoVSOXSEG2EI8_V_MF8_M1_MASK,
  PseudoVSOXSEG2EI8_V_MF8_MF2,
  PseudoVSOXSEG2EI8_V_MF8_MF2_MASK,
  PseudoVSOXSEG2EI8_V_MF8_MF4,
  PseudoVSOXSEG2EI8_V_MF8_MF4_MASK,
  PseudoVSOXSEG2EI8_V_MF8_MF8,
  PseudoVSOXSEG2EI8_V_MF8_MF8_MASK,
  PseudoVSOXSEG3EI16_V_M1_M1,
  PseudoVSOXSEG3EI16_V_M1_M1_MASK,
  PseudoVSOXSEG3EI16_V_M1_M2,
  PseudoVSOXSEG3EI16_V_M1_M2_MASK,
  PseudoVSOXSEG3EI16_V_M1_MF2,
  PseudoVSOXSEG3EI16_V_M1_MF2_MASK,
  PseudoVSOXSEG3EI16_V_M2_M1,
  PseudoVSOXSEG3EI16_V_M2_M1_MASK,
  PseudoVSOXSEG3EI16_V_M2_M2,
  PseudoVSOXSEG3EI16_V_M2_M2_MASK,
  PseudoVSOXSEG3EI16_V_M4_M2,
  PseudoVSOXSEG3EI16_V_M4_M2_MASK,
  PseudoVSOXSEG3EI16_V_MF2_M1,
  PseudoVSOXSEG3EI16_V_MF2_M1_MASK,
  PseudoVSOXSEG3EI16_V_MF2_M2,
  PseudoVSOXSEG3EI16_V_MF2_M2_MASK,
  PseudoVSOXSEG3EI16_V_MF2_MF2,
  PseudoVSOXSEG3EI16_V_MF2_MF2_MASK,
  PseudoVSOXSEG3EI16_V_MF2_MF4,
  PseudoVSOXSEG3EI16_V_MF2_MF4_MASK,
  PseudoVSOXSEG3EI16_V_MF4_M1,
  PseudoVSOXSEG3EI16_V_MF4_M1_MASK,
  PseudoVSOXSEG3EI16_V_MF4_MF2,
  PseudoVSOXSEG3EI16_V_MF4_MF2_MASK,
  PseudoVSOXSEG3EI16_V_MF4_MF4,
  PseudoVSOXSEG3EI16_V_MF4_MF4_MASK,
  PseudoVSOXSEG3EI16_V_MF4_MF8,
  PseudoVSOXSEG3EI16_V_MF4_MF8_MASK,
  PseudoVSOXSEG3EI32_V_M1_M1,
  PseudoVSOXSEG3EI32_V_M1_M1_MASK,
  PseudoVSOXSEG3EI32_V_M1_M2,
  PseudoVSOXSEG3EI32_V_M1_M2_MASK,
  PseudoVSOXSEG3EI32_V_M1_MF2,
  PseudoVSOXSEG3EI32_V_M1_MF2_MASK,
  PseudoVSOXSEG3EI32_V_M1_MF4,
  PseudoVSOXSEG3EI32_V_M1_MF4_MASK,
  PseudoVSOXSEG3EI32_V_M2_M1,
  PseudoVSOXSEG3EI32_V_M2_M1_MASK,
  PseudoVSOXSEG3EI32_V_M2_M2,
  PseudoVSOXSEG3EI32_V_M2_M2_MASK,
  PseudoVSOXSEG3EI32_V_M2_MF2,
  PseudoVSOXSEG3EI32_V_M2_MF2_MASK,
  PseudoVSOXSEG3EI32_V_M4_M1,
  PseudoVSOXSEG3EI32_V_M4_M1_MASK,
  PseudoVSOXSEG3EI32_V_M4_M2,
  PseudoVSOXSEG3EI32_V_M4_M2_MASK,
  PseudoVSOXSEG3EI32_V_M8_M2,
  PseudoVSOXSEG3EI32_V_M8_M2_MASK,
  PseudoVSOXSEG3EI32_V_MF2_M1,
  PseudoVSOXSEG3EI32_V_MF2_M1_MASK,
  PseudoVSOXSEG3EI32_V_MF2_MF2,
  PseudoVSOXSEG3EI32_V_MF2_MF2_MASK,
  PseudoVSOXSEG3EI32_V_MF2_MF4,
  PseudoVSOXSEG3EI32_V_MF2_MF4_MASK,
  PseudoVSOXSEG3EI32_V_MF2_MF8,
  PseudoVSOXSEG3EI32_V_MF2_MF8_MASK,
  PseudoVSOXSEG3EI64_V_M1_M1,
  PseudoVSOXSEG3EI64_V_M1_M1_MASK,
  PseudoVSOXSEG3EI64_V_M1_MF2,
  PseudoVSOXSEG3EI64_V_M1_MF2_MASK,
  PseudoVSOXSEG3EI64_V_M1_MF4,
  PseudoVSOXSEG3EI64_V_M1_MF4_MASK,
  PseudoVSOXSEG3EI64_V_M1_MF8,
  PseudoVSOXSEG3EI64_V_M1_MF8_MASK,
  PseudoVSOXSEG3EI64_V_M2_M1,
  PseudoVSOXSEG3EI64_V_M2_M1_MASK,
  PseudoVSOXSEG3EI64_V_M2_M2,
  PseudoVSOXSEG3EI64_V_M2_M2_MASK,
  PseudoVSOXSEG3EI64_V_M2_MF2,
  PseudoVSOXSEG3EI64_V_M2_MF2_MASK,
  PseudoVSOXSEG3EI64_V_M2_MF4,
  PseudoVSOXSEG3EI64_V_M2_MF4_MASK,
  PseudoVSOXSEG3EI64_V_M4_M1,
  PseudoVSOXSEG3EI64_V_M4_M1_MASK,
  PseudoVSOXSEG3EI64_V_M4_M2,
  PseudoVSOXSEG3EI64_V_M4_M2_MASK,
  PseudoVSOXSEG3EI64_V_M4_MF2,
  PseudoVSOXSEG3EI64_V_M4_MF2_MASK,
  PseudoVSOXSEG3EI64_V_M8_M1,
  PseudoVSOXSEG3EI64_V_M8_M1_MASK,
  PseudoVSOXSEG3EI64_V_M8_M2,
  PseudoVSOXSEG3EI64_V_M8_M2_MASK,
  PseudoVSOXSEG3EI8_V_M1_M1,
  PseudoVSOXSEG3EI8_V_M1_M1_MASK,
  PseudoVSOXSEG3EI8_V_M1_M2,
  PseudoVSOXSEG3EI8_V_M1_M2_MASK,
  PseudoVSOXSEG3EI8_V_M2_M2,
  PseudoVSOXSEG3EI8_V_M2_M2_MASK,
  PseudoVSOXSEG3EI8_V_MF2_M1,
  PseudoVSOXSEG3EI8_V_MF2_M1_MASK,
  PseudoVSOXSEG3EI8_V_MF2_M2,
  PseudoVSOXSEG3EI8_V_MF2_M2_MASK,
  PseudoVSOXSEG3EI8_V_MF2_MF2,
  PseudoVSOXSEG3EI8_V_MF2_MF2_MASK,
  PseudoVSOXSEG3EI8_V_MF4_M1,
  PseudoVSOXSEG3EI8_V_MF4_M1_MASK,
  PseudoVSOXSEG3EI8_V_MF4_M2,
  PseudoVSOXSEG3EI8_V_MF4_M2_MASK,
  PseudoVSOXSEG3EI8_V_MF4_MF2,
  PseudoVSOXSEG3EI8_V_MF4_MF2_MASK,
  PseudoVSOXSEG3EI8_V_MF4_MF4,
  PseudoVSOXSEG3EI8_V_MF4_MF4_MASK,
  PseudoVSOXSEG3EI8_V_MF8_M1,
  PseudoVSOXSEG3EI8_V_MF8_M1_MASK,
  PseudoVSOXSEG3EI8_V_MF8_MF2,
  PseudoVSOXSEG3EI8_V_MF8_MF2_MASK,
  PseudoVSOXSEG3EI8_V_MF8_MF4,
  PseudoVSOXSEG3EI8_V_MF8_MF4_MASK,
  PseudoVSOXSEG3EI8_V_MF8_MF8,
  PseudoVSOXSEG3EI8_V_MF8_MF8_MASK,
  PseudoVSOXSEG4EI16_V_M1_M1,
  PseudoVSOXSEG4EI16_V_M1_M1_MASK,
  PseudoVSOXSEG4EI16_V_M1_M2,
  PseudoVSOXSEG4EI16_V_M1_M2_MASK,
  PseudoVSOXSEG4EI16_V_M1_MF2,
  PseudoVSOXSEG4EI16_V_M1_MF2_MASK,
  PseudoVSOXSEG4EI16_V_M2_M1,
  PseudoVSOXSEG4EI16_V_M2_M1_MASK,
  PseudoVSOXSEG4EI16_V_M2_M2,
  PseudoVSOXSEG4EI16_V_M2_M2_MASK,
  PseudoVSOXSEG4EI16_V_M4_M2,
  PseudoVSOXSEG4EI16_V_M4_M2_MASK,
  PseudoVSOXSEG4EI16_V_MF2_M1,
  PseudoVSOXSEG4EI16_V_MF2_M1_MASK,
  PseudoVSOXSEG4EI16_V_MF2_M2,
  PseudoVSOXSEG4EI16_V_MF2_M2_MASK,
  PseudoVSOXSEG4EI16_V_MF2_MF2,
  PseudoVSOXSEG4EI16_V_MF2_MF2_MASK,
  PseudoVSOXSEG4EI16_V_MF2_MF4,
  PseudoVSOXSEG4EI16_V_MF2_MF4_MASK,
  PseudoVSOXSEG4EI16_V_MF4_M1,
  PseudoVSOXSEG4EI16_V_MF4_M1_MASK,
  PseudoVSOXSEG4EI16_V_MF4_MF2,
  PseudoVSOXSEG4EI16_V_MF4_MF2_MASK,
  PseudoVSOXSEG4EI16_V_MF4_MF4,
  PseudoVSOXSEG4EI16_V_MF4_MF4_MASK,
  PseudoVSOXSEG4EI16_V_MF4_MF8,
  PseudoVSOXSEG4EI16_V_MF4_MF8_MASK,
  PseudoVSOXSEG4EI32_V_M1_M1,
  PseudoVSOXSEG4EI32_V_M1_M1_MASK,
  PseudoVSOXSEG4EI32_V_M1_M2,
  PseudoVSOXSEG4EI32_V_M1_M2_MASK,
  PseudoVSOXSEG4EI32_V_M1_MF2,
  PseudoVSOXSEG4EI32_V_M1_MF2_MASK,
  PseudoVSOXSEG4EI32_V_M1_MF4,
  PseudoVSOXSEG4EI32_V_M1_MF4_MASK,
  PseudoVSOXSEG4EI32_V_M2_M1,
  PseudoVSOXSEG4EI32_V_M2_M1_MASK,
  PseudoVSOXSEG4EI32_V_M2_M2,
  PseudoVSOXSEG4EI32_V_M2_M2_MASK,
  PseudoVSOXSEG4EI32_V_M2_MF2,
  PseudoVSOXSEG4EI32_V_M2_MF2_MASK,
  PseudoVSOXSEG4EI32_V_M4_M1,
  PseudoVSOXSEG4EI32_V_M4_M1_MASK,
  PseudoVSOXSEG4EI32_V_M4_M2,
  PseudoVSOXSEG4EI32_V_M4_M2_MASK,
  PseudoVSOXSEG4EI32_V_M8_M2,
  PseudoVSOXSEG4EI32_V_M8_M2_MASK,
  PseudoVSOXSEG4EI32_V_MF2_M1,
  PseudoVSOXSEG4EI32_V_MF2_M1_MASK,
  PseudoVSOXSEG4EI32_V_MF2_MF2,
  PseudoVSOXSEG4EI32_V_MF2_MF2_MASK,
  PseudoVSOXSEG4EI32_V_MF2_MF4,
  PseudoVSOXSEG4EI32_V_MF2_MF4_MASK,
  PseudoVSOXSEG4EI32_V_MF2_MF8,
  PseudoVSOXSEG4EI32_V_MF2_MF8_MASK,
  PseudoVSOXSEG4EI64_V_M1_M1,
  PseudoVSOXSEG4EI64_V_M1_M1_MASK,
  PseudoVSOXSEG4EI64_V_M1_MF2,
  PseudoVSOXSEG4EI64_V_M1_MF2_MASK,
  PseudoVSOXSEG4EI64_V_M1_MF4,
  PseudoVSOXSEG4EI64_V_M1_MF4_MASK,
  PseudoVSOXSEG4EI64_V_M1_MF8,
  PseudoVSOXSEG4EI64_V_M1_MF8_MASK,
  PseudoVSOXSEG4EI64_V_M2_M1,
  PseudoVSOXSEG4EI64_V_M2_M1_MASK,
  PseudoVSOXSEG4EI64_V_M2_M2,
  PseudoVSOXSEG4EI64_V_M2_M2_MASK,
  PseudoVSOXSEG4EI64_V_M2_MF2,
  PseudoVSOXSEG4EI64_V_M2_MF2_MASK,
  PseudoVSOXSEG4EI64_V_M2_MF4,
  PseudoVSOXSEG4EI64_V_M2_MF4_MASK,
  PseudoVSOXSEG4EI64_V_M4_M1,
  PseudoVSOXSEG4EI64_V_M4_M1_MASK,
  PseudoVSOXSEG4EI64_V_M4_M2,
  PseudoVSOXSEG4EI64_V_M4_M2_MASK,
  PseudoVSOXSEG4EI64_V_M4_MF2,
  PseudoVSOXSEG4EI64_V_M4_MF2_MASK,
  PseudoVSOXSEG4EI64_V_M8_M1,
  PseudoVSOXSEG4EI64_V_M8_M1_MASK,
  PseudoVSOXSEG4EI64_V_M8_M2,
  PseudoVSOXSEG4EI64_V_M8_M2_MASK,
  PseudoVSOXSEG4EI8_V_M1_M1,
  PseudoVSOXSEG4EI8_V_M1_M1_MASK,
  PseudoVSOXSEG4EI8_V_M1_M2,
  PseudoVSOXSEG4EI8_V_M1_M2_MASK,
  PseudoVSOXSEG4EI8_V_M2_M2,
  PseudoVSOXSEG4EI8_V_M2_M2_MASK,
  PseudoVSOXSEG4EI8_V_MF2_M1,
  PseudoVSOXSEG4EI8_V_MF2_M1_MASK,
  PseudoVSOXSEG4EI8_V_MF2_M2,
  PseudoVSOXSEG4EI8_V_MF2_M2_MASK,
  PseudoVSOXSEG4EI8_V_MF2_MF2,
  PseudoVSOXSEG4EI8_V_MF2_MF2_MASK,
  PseudoVSOXSEG4EI8_V_MF4_M1,
  PseudoVSOXSEG4EI8_V_MF4_M1_MASK,
  PseudoVSOXSEG4EI8_V_MF4_M2,
  PseudoVSOXSEG4EI8_V_MF4_M2_MASK,
  PseudoVSOXSEG4EI8_V_MF4_MF2,
  PseudoVSOXSEG4EI8_V_MF4_MF2_MASK,
  PseudoVSOXSEG4EI8_V_MF4_MF4,
  PseudoVSOXSEG4EI8_V_MF4_MF4_MASK,
  PseudoVSOXSEG4EI8_V_MF8_M1,
  PseudoVSOXSEG4EI8_V_MF8_M1_MASK,
  PseudoVSOXSEG4EI8_V_MF8_MF2,
  PseudoVSOXSEG4EI8_V_MF8_MF2_MASK,
  PseudoVSOXSEG4EI8_V_MF8_MF4,
  PseudoVSOXSEG4EI8_V_MF8_MF4_MASK,
  PseudoVSOXSEG4EI8_V_MF8_MF8,
  PseudoVSOXSEG4EI8_V_MF8_MF8_MASK,
  PseudoVSOXSEG5EI16_V_M1_M1,
  PseudoVSOXSEG5EI16_V_M1_M1_MASK,
  PseudoVSOXSEG5EI16_V_M1_MF2,
  PseudoVSOXSEG5EI16_V_M1_MF2_MASK,
  PseudoVSOXSEG5EI16_V_M2_M1,
  PseudoVSOXSEG5EI16_V_M2_M1_MASK,
  PseudoVSOXSEG5EI16_V_MF2_M1,
  PseudoVSOXSEG5EI16_V_MF2_M1_MASK,
  PseudoVSOXSEG5EI16_V_MF2_MF2,
  PseudoVSOXSEG5EI16_V_MF2_MF2_MASK,
  PseudoVSOXSEG5EI16_V_MF2_MF4,
  PseudoVSOXSEG5EI16_V_MF2_MF4_MASK,
  PseudoVSOXSEG5EI16_V_MF4_M1,
  PseudoVSOXSEG5EI16_V_MF4_M1_MASK,
  PseudoVSOXSEG5EI16_V_MF4_MF2,
  PseudoVSOXSEG5EI16_V_MF4_MF2_MASK,
  PseudoVSOXSEG5EI16_V_MF4_MF4,
  PseudoVSOXSEG5EI16_V_MF4_MF4_MASK,
  PseudoVSOXSEG5EI16_V_MF4_MF8,
  PseudoVSOXSEG5EI16_V_MF4_MF8_MASK,
  PseudoVSOXSEG5EI32_V_M1_M1,
  PseudoVSOXSEG5EI32_V_M1_M1_MASK,
  PseudoVSOXSEG5EI32_V_M1_MF2,
  PseudoVSOXSEG5EI32_V_M1_MF2_MASK,
  PseudoVSOXSEG5EI32_V_M1_MF4,
  PseudoVSOXSEG5EI32_V_M1_MF4_MASK,
  PseudoVSOXSEG5EI32_V_M2_M1,
  PseudoVSOXSEG5EI32_V_M2_M1_MASK,
  PseudoVSOXSEG5EI32_V_M2_MF2,
  PseudoVSOXSEG5EI32_V_M2_MF2_MASK,
  PseudoVSOXSEG5EI32_V_M4_M1,
  PseudoVSOXSEG5EI32_V_M4_M1_MASK,
  PseudoVSOXSEG5EI32_V_MF2_M1,
  PseudoVSOXSEG5EI32_V_MF2_M1_MASK,
  PseudoVSOXSEG5EI32_V_MF2_MF2,
  PseudoVSOXSEG5EI32_V_MF2_MF2_MASK,
  PseudoVSOXSEG5EI32_V_MF2_MF4,
  PseudoVSOXSEG5EI32_V_MF2_MF4_MASK,
  PseudoVSOXSEG5EI32_V_MF2_MF8,
  PseudoVSOXSEG5EI32_V_MF2_MF8_MASK,
  PseudoVSOXSEG5EI64_V_M1_M1,
  PseudoVSOXSEG5EI64_V_M1_M1_MASK,
  PseudoVSOXSEG5EI64_V_M1_MF2,
  PseudoVSOXSEG5EI64_V_M1_MF2_MASK,
  PseudoVSOXSEG5EI64_V_M1_MF4,
  PseudoVSOXSEG5EI64_V_M1_MF4_MASK,
  PseudoVSOXSEG5EI64_V_M1_MF8,
  PseudoVSOXSEG5EI64_V_M1_MF8_MASK,
  PseudoVSOXSEG5EI64_V_M2_M1,
  PseudoVSOXSEG5EI64_V_M2_M1_MASK,
  PseudoVSOXSEG5EI64_V_M2_MF2,
  PseudoVSOXSEG5EI64_V_M2_MF2_MASK,
  PseudoVSOXSEG5EI64_V_M2_MF4,
  PseudoVSOXSEG5EI64_V_M2_MF4_MASK,
  PseudoVSOXSEG5EI64_V_M4_M1,
  PseudoVSOXSEG5EI64_V_M4_M1_MASK,
  PseudoVSOXSEG5EI64_V_M4_MF2,
  PseudoVSOXSEG5EI64_V_M4_MF2_MASK,
  PseudoVSOXSEG5EI64_V_M8_M1,
  PseudoVSOXSEG5EI64_V_M8_M1_MASK,
  PseudoVSOXSEG5EI8_V_M1_M1,
  PseudoVSOXSEG5EI8_V_M1_M1_MASK,
  PseudoVSOXSEG5EI8_V_MF2_M1,
  PseudoVSOXSEG5EI8_V_MF2_M1_MASK,
  PseudoVSOXSEG5EI8_V_MF2_MF2,
  PseudoVSOXSEG5EI8_V_MF2_MF2_MASK,
  PseudoVSOXSEG5EI8_V_MF4_M1,
  PseudoVSOXSEG5EI8_V_MF4_M1_MASK,
  PseudoVSOXSEG5EI8_V_MF4_MF2,
  PseudoVSOXSEG5EI8_V_MF4_MF2_MASK,
  PseudoVSOXSEG5EI8_V_MF4_MF4,
  PseudoVSOXSEG5EI8_V_MF4_MF4_MASK,
  PseudoVSOXSEG5EI8_V_MF8_M1,
  PseudoVSOXSEG5EI8_V_MF8_M1_MASK,
  PseudoVSOXSEG5EI8_V_MF8_MF2,
  PseudoVSOXSEG5EI8_V_MF8_MF2_MASK,
  PseudoVSOXSEG5EI8_V_MF8_MF4,
  PseudoVSOXSEG5EI8_V_MF8_MF4_MASK,
  PseudoVSOXSEG5EI8_V_MF8_MF8,
  PseudoVSOXSEG5EI8_V_MF8_MF8_MASK,
  PseudoVSOXSEG6EI16_V_M1_M1,
  PseudoVSOXSEG6EI16_V_M1_M1_MASK,
  PseudoVSOXSEG6EI16_V_M1_MF2,
  PseudoVSOXSEG6EI16_V_M1_MF2_MASK,
  PseudoVSOXSEG6EI16_V_M2_M1,
  PseudoVSOXSEG6EI16_V_M2_M1_MASK,
  PseudoVSOXSEG6EI16_V_MF2_M1,
  PseudoVSOXSEG6EI16_V_MF2_M1_MASK,
  PseudoVSOXSEG6EI16_V_MF2_MF2,
  PseudoVSOXSEG6EI16_V_MF2_MF2_MASK,
  PseudoVSOXSEG6EI16_V_MF2_MF4,
  PseudoVSOXSEG6EI16_V_MF2_MF4_MASK,
  PseudoVSOXSEG6EI16_V_MF4_M1,
  PseudoVSOXSEG6EI16_V_MF4_M1_MASK,
  PseudoVSOXSEG6EI16_V_MF4_MF2,
  PseudoVSOXSEG6EI16_V_MF4_MF2_MASK,
  PseudoVSOXSEG6EI16_V_MF4_MF4,
  PseudoVSOXSEG6EI16_V_MF4_MF4_MASK,
  PseudoVSOXSEG6EI16_V_MF4_MF8,
  PseudoVSOXSEG6EI16_V_MF4_MF8_MASK,
  PseudoVSOXSEG6EI32_V_M1_M1,
  PseudoVSOXSEG6EI32_V_M1_M1_MASK,
  PseudoVSOXSEG6EI32_V_M1_MF2,
  PseudoVSOXSEG6EI32_V_M1_MF2_MASK,
  PseudoVSOXSEG6EI32_V_M1_MF4,
  PseudoVSOXSEG6EI32_V_M1_MF4_MASK,
  PseudoVSOXSEG6EI32_V_M2_M1,
  PseudoVSOXSEG6EI32_V_M2_M1_MASK,
  PseudoVSOXSEG6EI32_V_M2_MF2,
  PseudoVSOXSEG6EI32_V_M2_MF2_MASK,
  PseudoVSOXSEG6EI32_V_M4_M1,
  PseudoVSOXSEG6EI32_V_M4_M1_MASK,
  PseudoVSOXSEG6EI32_V_MF2_M1,
  PseudoVSOXSEG6EI32_V_MF2_M1_MASK,
  PseudoVSOXSEG6EI32_V_MF2_MF2,
  PseudoVSOXSEG6EI32_V_MF2_MF2_MASK,
  PseudoVSOXSEG6EI32_V_MF2_MF4,
  PseudoVSOXSEG6EI32_V_MF2_MF4_MASK,
  PseudoVSOXSEG6EI32_V_MF2_MF8,
  PseudoVSOXSEG6EI32_V_MF2_MF8_MASK,
  PseudoVSOXSEG6EI64_V_M1_M1,
  PseudoVSOXSEG6EI64_V_M1_M1_MASK,
  PseudoVSOXSEG6EI64_V_M1_MF2,
  PseudoVSOXSEG6EI64_V_M1_MF2_MASK,
  PseudoVSOXSEG6EI64_V_M1_MF4,
  PseudoVSOXSEG6EI64_V_M1_MF4_MASK,
  PseudoVSOXSEG6EI64_V_M1_MF8,
  PseudoVSOXSEG6EI64_V_M1_MF8_MASK,
  PseudoVSOXSEG6EI64_V_M2_M1,
  PseudoVSOXSEG6EI64_V_M2_M1_MASK,
  PseudoVSOXSEG6EI64_V_M2_MF2,
  PseudoVSOXSEG6EI64_V_M2_MF2_MASK,
  PseudoVSOXSEG6EI64_V_M2_MF4,
  PseudoVSOXSEG6EI64_V_M2_MF4_MASK,
  PseudoVSOXSEG6EI64_V_M4_M1,
  PseudoVSOXSEG6EI64_V_M4_M1_MASK,
  PseudoVSOXSEG6EI64_V_M4_MF2,
  PseudoVSOXSEG6EI64_V_M4_MF2_MASK,
  PseudoVSOXSEG6EI64_V_M8_M1,
  PseudoVSOXSEG6EI64_V_M8_M1_MASK,
  PseudoVSOXSEG6EI8_V_M1_M1,
  PseudoVSOXSEG6EI8_V_M1_M1_MASK,
  PseudoVSOXSEG6EI8_V_MF2_M1,
  PseudoVSOXSEG6EI8_V_MF2_M1_MASK,
  PseudoVSOXSEG6EI8_V_MF2_MF2,
  PseudoVSOXSEG6EI8_V_MF2_MF2_MASK,
  PseudoVSOXSEG6EI8_V_MF4_M1,
  PseudoVSOXSEG6EI8_V_MF4_M1_MASK,
  PseudoVSOXSEG6EI8_V_MF4_MF2,
  PseudoVSOXSEG6EI8_V_MF4_MF2_MASK,
  PseudoVSOXSEG6EI8_V_MF4_MF4,
  PseudoVSOXSEG6EI8_V_MF4_MF4_MASK,
  PseudoVSOXSEG6EI8_V_MF8_M1,
  PseudoVSOXSEG6EI8_V_MF8_M1_MASK,
  PseudoVSOXSEG6EI8_V_MF8_MF2,
  PseudoVSOXSEG6EI8_V_MF8_MF2_MASK,
  PseudoVSOXSEG6EI8_V_MF8_MF4,
  PseudoVSOXSEG6EI8_V_MF8_MF4_MASK,
  PseudoVSOXSEG6EI8_V_MF8_MF8,
  PseudoVSOXSEG6EI8_V_MF8_MF8_MASK,
  PseudoVSOXSEG7EI16_V_M1_M1,
  PseudoVSOXSEG7EI16_V_M1_M1_MASK,
  PseudoVSOXSEG7EI16_V_M1_MF2,
  PseudoVSOXSEG7EI16_V_M1_MF2_MASK,
  PseudoVSOXSEG7EI16_V_M2_M1,
  PseudoVSOXSEG7EI16_V_M2_M1_MASK,
  PseudoVSOXSEG7EI16_V_MF2_M1,
  PseudoVSOXSEG7EI16_V_MF2_M1_MASK,
  PseudoVSOXSEG7EI16_V_MF2_MF2,
  PseudoVSOXSEG7EI16_V_MF2_MF2_MASK,
  PseudoVSOXSEG7EI16_V_MF2_MF4,
  PseudoVSOXSEG7EI16_V_MF2_MF4_MASK,
  PseudoVSOXSEG7EI16_V_MF4_M1,
  PseudoVSOXSEG7EI16_V_MF4_M1_MASK,
  PseudoVSOXSEG7EI16_V_MF4_MF2,
  PseudoVSOXSEG7EI16_V_MF4_MF2_MASK,
  PseudoVSOXSEG7EI16_V_MF4_MF4,
  PseudoVSOXSEG7EI16_V_MF4_MF4_MASK,
  PseudoVSOXSEG7EI16_V_MF4_MF8,
  PseudoVSOXSEG7EI16_V_MF4_MF8_MASK,
  PseudoVSOXSEG7EI32_V_M1_M1,
  PseudoVSOXSEG7EI32_V_M1_M1_MASK,
  PseudoVSOXSEG7EI32_V_M1_MF2,
  PseudoVSOXSEG7EI32_V_M1_MF2_MASK,
  PseudoVSOXSEG7EI32_V_M1_MF4,
  PseudoVSOXSEG7EI32_V_M1_MF4_MASK,
  PseudoVSOXSEG7EI32_V_M2_M1,
  PseudoVSOXSEG7EI32_V_M2_M1_MASK,
  PseudoVSOXSEG7EI32_V_M2_MF2,
  PseudoVSOXSEG7EI32_V_M2_MF2_MASK,
  PseudoVSOXSEG7EI32_V_M4_M1,
  PseudoVSOXSEG7EI32_V_M4_M1_MASK,
  PseudoVSOXSEG7EI32_V_MF2_M1,
  PseudoVSOXSEG7EI32_V_MF2_M1_MASK,
  PseudoVSOXSEG7EI32_V_MF2_MF2,
  PseudoVSOXSEG7EI32_V_MF2_MF2_MASK,
  PseudoVSOXSEG7EI32_V_MF2_MF4,
  PseudoVSOXSEG7EI32_V_MF2_MF4_MASK,
  PseudoVSOXSEG7EI32_V_MF2_MF8,
  PseudoVSOXSEG7EI32_V_MF2_MF8_MASK,
  PseudoVSOXSEG7EI64_V_M1_M1,
  PseudoVSOXSEG7EI64_V_M1_M1_MASK,
  PseudoVSOXSEG7EI64_V_M1_MF2,
  PseudoVSOXSEG7EI64_V_M1_MF2_MASK,
  PseudoVSOXSEG7EI64_V_M1_MF4,
  PseudoVSOXSEG7EI64_V_M1_MF4_MASK,
  PseudoVSOXSEG7EI64_V_M1_MF8,
  PseudoVSOXSEG7EI64_V_M1_MF8_MASK,
  PseudoVSOXSEG7EI64_V_M2_M1,
  PseudoVSOXSEG7EI64_V_M2_M1_MASK,
  PseudoVSOXSEG7EI64_V_M2_MF2,
  PseudoVSOXSEG7EI64_V_M2_MF2_MASK,
  PseudoVSOXSEG7EI64_V_M2_MF4,
  PseudoVSOXSEG7EI64_V_M2_MF4_MASK,
  PseudoVSOXSEG7EI64_V_M4_M1,
  PseudoVSOXSEG7EI64_V_M4_M1_MASK,
  PseudoVSOXSEG7EI64_V_M4_MF2,
  PseudoVSOXSEG7EI64_V_M4_MF2_MASK,
  PseudoVSOXSEG7EI64_V_M8_M1,
  PseudoVSOXSEG7EI64_V_M8_M1_MASK,
  PseudoVSOXSEG7EI8_V_M1_M1,
  PseudoVSOXSEG7EI8_V_M1_M1_MASK,
  PseudoVSOXSEG7EI8_V_MF2_M1,
  PseudoVSOXSEG7EI8_V_MF2_M1_MASK,
  PseudoVSOXSEG7EI8_V_MF2_MF2,
  PseudoVSOXSEG7EI8_V_MF2_MF2_MASK,
  PseudoVSOXSEG7EI8_V_MF4_M1,
  PseudoVSOXSEG7EI8_V_MF4_M1_MASK,
  PseudoVSOXSEG7EI8_V_MF4_MF2,
  PseudoVSOXSEG7EI8_V_MF4_MF2_MASK,
  PseudoVSOXSEG7EI8_V_MF4_MF4,
  PseudoVSOXSEG7EI8_V_MF4_MF4_MASK,
  PseudoVSOXSEG7EI8_V_MF8_M1,
  PseudoVSOXSEG7EI8_V_MF8_M1_MASK,
  PseudoVSOXSEG7EI8_V_MF8_MF2,
  PseudoVSOXSEG7EI8_V_MF8_MF2_MASK,
  PseudoVSOXSEG7EI8_V_MF8_MF4,
  PseudoVSOXSEG7EI8_V_MF8_MF4_MASK,
  PseudoVSOXSEG7EI8_V_MF8_MF8,
  PseudoVSOXSEG7EI8_V_MF8_MF8_MASK,
  PseudoVSOXSEG8EI16_V_M1_M1,
  PseudoVSOXSEG8EI16_V_M1_M1_MASK,
  PseudoVSOXSEG8EI16_V_M1_MF2,
  PseudoVSOXSEG8EI16_V_M1_MF2_MASK,
  PseudoVSOXSEG8EI16_V_M2_M1,
  PseudoVSOXSEG8EI16_V_M2_M1_MASK,
  PseudoVSOXSEG8EI16_V_MF2_M1,
  PseudoVSOXSEG8EI16_V_MF2_M1_MASK,
  PseudoVSOXSEG8EI16_V_MF2_MF2,
  PseudoVSOXSEG8EI16_V_MF2_MF2_MASK,
  PseudoVSOXSEG8EI16_V_MF2_MF4,
  PseudoVSOXSEG8EI16_V_MF2_MF4_MASK,
  PseudoVSOXSEG8EI16_V_MF4_M1,
  PseudoVSOXSEG8EI16_V_MF4_M1_MASK,
  PseudoVSOXSEG8EI16_V_MF4_MF2,
  PseudoVSOXSEG8EI16_V_MF4_MF2_MASK,
  PseudoVSOXSEG8EI16_V_MF4_MF4,
  PseudoVSOXSEG8EI16_V_MF4_MF4_MASK,
  PseudoVSOXSEG8EI16_V_MF4_MF8,
  PseudoVSOXSEG8EI16_V_MF4_MF8_MASK,
  PseudoVSOXSEG8EI32_V_M1_M1,
  PseudoVSOXSEG8EI32_V_M1_M1_MASK,
  PseudoVSOXSEG8EI32_V_M1_MF2,
  PseudoVSOXSEG8EI32_V_M1_MF2_MASK,
  PseudoVSOXSEG8EI32_V_M1_MF4,
  PseudoVSOXSEG8EI32_V_M1_MF4_MASK,
  PseudoVSOXSEG8EI32_V_M2_M1,
  PseudoVSOXSEG8EI32_V_M2_M1_MASK,
  PseudoVSOXSEG8EI32_V_M2_MF2,
  PseudoVSOXSEG8EI32_V_M2_MF2_MASK,
  PseudoVSOXSEG8EI32_V_M4_M1,
  PseudoVSOXSEG8EI32_V_M4_M1_MASK,
  PseudoVSOXSEG8EI32_V_MF2_M1,
  PseudoVSOXSEG8EI32_V_MF2_M1_MASK,
  PseudoVSOXSEG8EI32_V_MF2_MF2,
  PseudoVSOXSEG8EI32_V_MF2_MF2_MASK,
  PseudoVSOXSEG8EI32_V_MF2_MF4,
  PseudoVSOXSEG8EI32_V_MF2_MF4_MASK,
  PseudoVSOXSEG8EI32_V_MF2_MF8,
  PseudoVSOXSEG8EI32_V_MF2_MF8_MASK,
  PseudoVSOXSEG8EI64_V_M1_M1,
  PseudoVSOXSEG8EI64_V_M1_M1_MASK,
  PseudoVSOXSEG8EI64_V_M1_MF2,
  PseudoVSOXSEG8EI64_V_M1_MF2_MASK,
  PseudoVSOXSEG8EI64_V_M1_MF4,
  PseudoVSOXSEG8EI64_V_M1_MF4_MASK,
  PseudoVSOXSEG8EI64_V_M1_MF8,
  PseudoVSOXSEG8EI64_V_M1_MF8_MASK,
  PseudoVSOXSEG8EI64_V_M2_M1,
  PseudoVSOXSEG8EI64_V_M2_M1_MASK,
  PseudoVSOXSEG8EI64_V_M2_MF2,
  PseudoVSOXSEG8EI64_V_M2_MF2_MASK,
  PseudoVSOXSEG8EI64_V_M2_MF4,
  PseudoVSOXSEG8EI64_V_M2_MF4_MASK,
  PseudoVSOXSEG8EI64_V_M4_M1,
  PseudoVSOXSEG8EI64_V_M4_M1_MASK,
  PseudoVSOXSEG8EI64_V_M4_MF2,
  PseudoVSOXSEG8EI64_V_M4_MF2_MASK,
  PseudoVSOXSEG8EI64_V_M8_M1,
  PseudoVSOXSEG8EI64_V_M8_M1_MASK,
  PseudoVSOXSEG8EI8_V_M1_M1,
  PseudoVSOXSEG8EI8_V_M1_M1_MASK,
  PseudoVSOXSEG8EI8_V_MF2_M1,
  PseudoVSOXSEG8EI8_V_MF2_M1_MASK,
  PseudoVSOXSEG8EI8_V_MF2_MF2,
  PseudoVSOXSEG8EI8_V_MF2_MF2_MASK,
  PseudoVSOXSEG8EI8_V_MF4_M1,
  PseudoVSOXSEG8EI8_V_MF4_M1_MASK,
  PseudoVSOXSEG8EI8_V_MF4_MF2,
  PseudoVSOXSEG8EI8_V_MF4_MF2_MASK,
  PseudoVSOXSEG8EI8_V_MF4_MF4,
  PseudoVSOXSEG8EI8_V_MF4_MF4_MASK,
  PseudoVSOXSEG8EI8_V_MF8_M1,
  PseudoVSOXSEG8EI8_V_MF8_M1_MASK,
  PseudoVSOXSEG8EI8_V_MF8_MF2,
  PseudoVSOXSEG8EI8_V_MF8_MF2_MASK,
  PseudoVSOXSEG8EI8_V_MF8_MF4,
  PseudoVSOXSEG8EI8_V_MF8_MF4_MASK,
  PseudoVSOXSEG8EI8_V_MF8_MF8,
  PseudoVSOXSEG8EI8_V_MF8_MF8_MASK,
  PseudoVSPILL2_M1,
  PseudoVSPILL2_M2,
  PseudoVSPILL2_M4,
  PseudoVSPILL2_MF2,
  PseudoVSPILL2_MF4,
  PseudoVSPILL2_MF8,
  PseudoVSPILL3_M1,
  PseudoVSPILL3_M2,
  PseudoVSPILL3_MF2,
  PseudoVSPILL3_MF4,
  PseudoVSPILL3_MF8,
  PseudoVSPILL4_M1,
  PseudoVSPILL4_M2,
  PseudoVSPILL4_MF2,
  PseudoVSPILL4_MF4,
  PseudoVSPILL4_MF8,
  PseudoVSPILL5_M1,
  PseudoVSPILL5_MF2,
  PseudoVSPILL5_MF4,
  PseudoVSPILL5_MF8,
  PseudoVSPILL6_M1,
  PseudoVSPILL6_MF2,
  PseudoVSPILL6_MF4,
  PseudoVSPILL6_MF8,
  PseudoVSPILL7_M1,
  PseudoVSPILL7_MF2,
  PseudoVSPILL7_MF4,
  PseudoVSPILL7_MF8,
  PseudoVSPILL8_M1,
  PseudoVSPILL8_MF2,
  PseudoVSPILL8_MF4,
  PseudoVSPILL8_MF8,
  PseudoVSRA_VI_M1,
  PseudoVSRA_VI_M1_MASK,
  PseudoVSRA_VI_M2,
  PseudoVSRA_VI_M2_MASK,
  PseudoVSRA_VI_M4,
  PseudoVSRA_VI_M4_MASK,
  PseudoVSRA_VI_M8,
  PseudoVSRA_VI_M8_MASK,
  PseudoVSRA_VI_MF2,
  PseudoVSRA_VI_MF2_MASK,
  PseudoVSRA_VI_MF4,
  PseudoVSRA_VI_MF4_MASK,
  PseudoVSRA_VI_MF8,
  PseudoVSRA_VI_MF8_MASK,
  PseudoVSRA_VV_M1,
  PseudoVSRA_VV_M1_MASK,
  PseudoVSRA_VV_M2,
  PseudoVSRA_VV_M2_MASK,
  PseudoVSRA_VV_M4,
  PseudoVSRA_VV_M4_MASK,
  PseudoVSRA_VV_M8,
  PseudoVSRA_VV_M8_MASK,
  PseudoVSRA_VV_MF2,
  PseudoVSRA_VV_MF2_MASK,
  PseudoVSRA_VV_MF4,
  PseudoVSRA_VV_MF4_MASK,
  PseudoVSRA_VV_MF8,
  PseudoVSRA_VV_MF8_MASK,
  PseudoVSRA_VX_M1,
  PseudoVSRA_VX_M1_MASK,
  PseudoVSRA_VX_M2,
  PseudoVSRA_VX_M2_MASK,
  PseudoVSRA_VX_M4,
  PseudoVSRA_VX_M4_MASK,
  PseudoVSRA_VX_M8,
  PseudoVSRA_VX_M8_MASK,
  PseudoVSRA_VX_MF2,
  PseudoVSRA_VX_MF2_MASK,
  PseudoVSRA_VX_MF4,
  PseudoVSRA_VX_MF4_MASK,
  PseudoVSRA_VX_MF8,
  PseudoVSRA_VX_MF8_MASK,
  PseudoVSRL_VI_M1,
  PseudoVSRL_VI_M1_MASK,
  PseudoVSRL_VI_M2,
  PseudoVSRL_VI_M2_MASK,
  PseudoVSRL_VI_M4,
  PseudoVSRL_VI_M4_MASK,
  PseudoVSRL_VI_M8,
  PseudoVSRL_VI_M8_MASK,
  PseudoVSRL_VI_MF2,
  PseudoVSRL_VI_MF2_MASK,
  PseudoVSRL_VI_MF4,
  PseudoVSRL_VI_MF4_MASK,
  PseudoVSRL_VI_MF8,
  PseudoVSRL_VI_MF8_MASK,
  PseudoVSRL_VV_M1,
  PseudoVSRL_VV_M1_MASK,
  PseudoVSRL_VV_M2,
  PseudoVSRL_VV_M2_MASK,
  PseudoVSRL_VV_M4,
  PseudoVSRL_VV_M4_MASK,
  PseudoVSRL_VV_M8,
  PseudoVSRL_VV_M8_MASK,
  PseudoVSRL_VV_MF2,
  PseudoVSRL_VV_MF2_MASK,
  PseudoVSRL_VV_MF4,
  PseudoVSRL_VV_MF4_MASK,
  PseudoVSRL_VV_MF8,
  PseudoVSRL_VV_MF8_MASK,
  PseudoVSRL_VX_M1,
  PseudoVSRL_VX_M1_MASK,
  PseudoVSRL_VX_M2,
  PseudoVSRL_VX_M2_MASK,
  PseudoVSRL_VX_M4,
  PseudoVSRL_VX_M4_MASK,
  PseudoVSRL_VX_M8,
  PseudoVSRL_VX_M8_MASK,
  PseudoVSRL_VX_MF2,
  PseudoVSRL_VX_MF2_MASK,
  PseudoVSRL_VX_MF4,
  PseudoVSRL_VX_MF4_MASK,
  PseudoVSRL_VX_MF8,
  PseudoVSRL_VX_MF8_MASK,
  PseudoVSSE16_V_M1,
  PseudoVSSE16_V_M1_MASK,
  PseudoVSSE16_V_M2,
  PseudoVSSE16_V_M2_MASK,
  PseudoVSSE16_V_M4,
  PseudoVSSE16_V_M4_MASK,
  PseudoVSSE16_V_M8,
  PseudoVSSE16_V_M8_MASK,
  PseudoVSSE16_V_MF2,
  PseudoVSSE16_V_MF2_MASK,
  PseudoVSSE16_V_MF4,
  PseudoVSSE16_V_MF4_MASK,
  PseudoVSSE32_V_M1,
  PseudoVSSE32_V_M1_MASK,
  PseudoVSSE32_V_M2,
  PseudoVSSE32_V_M2_MASK,
  PseudoVSSE32_V_M4,
  PseudoVSSE32_V_M4_MASK,
  PseudoVSSE32_V_M8,
  PseudoVSSE32_V_M8_MASK,
  PseudoVSSE32_V_MF2,
  PseudoVSSE32_V_MF2_MASK,
  PseudoVSSE64_V_M1,
  PseudoVSSE64_V_M1_MASK,
  PseudoVSSE64_V_M2,
  PseudoVSSE64_V_M2_MASK,
  PseudoVSSE64_V_M4,
  PseudoVSSE64_V_M4_MASK,
  PseudoVSSE64_V_M8,
  PseudoVSSE64_V_M8_MASK,
  PseudoVSSE8_V_M1,
  PseudoVSSE8_V_M1_MASK,
  PseudoVSSE8_V_M2,
  PseudoVSSE8_V_M2_MASK,
  PseudoVSSE8_V_M4,
  PseudoVSSE8_V_M4_MASK,
  PseudoVSSE8_V_M8,
  PseudoVSSE8_V_M8_MASK,
  PseudoVSSE8_V_MF2,
  PseudoVSSE8_V_MF2_MASK,
  PseudoVSSE8_V_MF4,
  PseudoVSSE8_V_MF4_MASK,
  PseudoVSSE8_V_MF8,
  PseudoVSSE8_V_MF8_MASK,
  PseudoVSSEG2E16_V_M1,
  PseudoVSSEG2E16_V_M1_MASK,
  PseudoVSSEG2E16_V_M2,
  PseudoVSSEG2E16_V_M2_MASK,
  PseudoVSSEG2E16_V_M4,
  PseudoVSSEG2E16_V_M4_MASK,
  PseudoVSSEG2E16_V_MF2,
  PseudoVSSEG2E16_V_MF2_MASK,
  PseudoVSSEG2E16_V_MF4,
  PseudoVSSEG2E16_V_MF4_MASK,
  PseudoVSSEG2E32_V_M1,
  PseudoVSSEG2E32_V_M1_MASK,
  PseudoVSSEG2E32_V_M2,
  PseudoVSSEG2E32_V_M2_MASK,
  PseudoVSSEG2E32_V_M4,
  PseudoVSSEG2E32_V_M4_MASK,
  PseudoVSSEG2E32_V_MF2,
  PseudoVSSEG2E32_V_MF2_MASK,
  PseudoVSSEG2E64_V_M1,
  PseudoVSSEG2E64_V_M1_MASK,
  PseudoVSSEG2E64_V_M2,
  PseudoVSSEG2E64_V_M2_MASK,
  PseudoVSSEG2E64_V_M4,
  PseudoVSSEG2E64_V_M4_MASK,
  PseudoVSSEG2E8_V_M1,
  PseudoVSSEG2E8_V_M1_MASK,
  PseudoVSSEG2E8_V_M2,
  PseudoVSSEG2E8_V_M2_MASK,
  PseudoVSSEG2E8_V_M4,
  PseudoVSSEG2E8_V_M4_MASK,
  PseudoVSSEG2E8_V_MF2,
  PseudoVSSEG2E8_V_MF2_MASK,
  PseudoVSSEG2E8_V_MF4,
  PseudoVSSEG2E8_V_MF4_MASK,
  PseudoVSSEG2E8_V_MF8,
  PseudoVSSEG2E8_V_MF8_MASK,
  PseudoVSSEG3E16_V_M1,
  PseudoVSSEG3E16_V_M1_MASK,
  PseudoVSSEG3E16_V_M2,
  PseudoVSSEG3E16_V_M2_MASK,
  PseudoVSSEG3E16_V_MF2,
  PseudoVSSEG3E16_V_MF2_MASK,
  PseudoVSSEG3E16_V_MF4,
  PseudoVSSEG3E16_V_MF4_MASK,
  PseudoVSSEG3E32_V_M1,
  PseudoVSSEG3E32_V_M1_MASK,
  PseudoVSSEG3E32_V_M2,
  PseudoVSSEG3E32_V_M2_MASK,
  PseudoVSSEG3E32_V_MF2,
  PseudoVSSEG3E32_V_MF2_MASK,
  PseudoVSSEG3E64_V_M1,
  PseudoVSSEG3E64_V_M1_MASK,
  PseudoVSSEG3E64_V_M2,
  PseudoVSSEG3E64_V_M2_MASK,
  PseudoVSSEG3E8_V_M1,
  PseudoVSSEG3E8_V_M1_MASK,
  PseudoVSSEG3E8_V_M2,
  PseudoVSSEG3E8_V_M2_MASK,
  PseudoVSSEG3E8_V_MF2,
  PseudoVSSEG3E8_V_MF2_MASK,
  PseudoVSSEG3E8_V_MF4,
  PseudoVSSEG3E8_V_MF4_MASK,
  PseudoVSSEG3E8_V_MF8,
  PseudoVSSEG3E8_V_MF8_MASK,
  PseudoVSSEG4E16_V_M1,
  PseudoVSSEG4E16_V_M1_MASK,
  PseudoVSSEG4E16_V_M2,
  PseudoVSSEG4E16_V_M2_MASK,
  PseudoVSSEG4E16_V_MF2,
  PseudoVSSEG4E16_V_MF2_MASK,
  PseudoVSSEG4E16_V_MF4,
  PseudoVSSEG4E16_V_MF4_MASK,
  PseudoVSSEG4E32_V_M1,
  PseudoVSSEG4E32_V_M1_MASK,
  PseudoVSSEG4E32_V_M2,
  PseudoVSSEG4E32_V_M2_MASK,
  PseudoVSSEG4E32_V_MF2,
  PseudoVSSEG4E32_V_MF2_MASK,
  PseudoVSSEG4E64_V_M1,
  PseudoVSSEG4E64_V_M1_MASK,
  PseudoVSSEG4E64_V_M2,
  PseudoVSSEG4E64_V_M2_MASK,
  PseudoVSSEG4E8_V_M1,
  PseudoVSSEG4E8_V_M1_MASK,
  PseudoVSSEG4E8_V_M2,
  PseudoVSSEG4E8_V_M2_MASK,
  PseudoVSSEG4E8_V_MF2,
  PseudoVSSEG4E8_V_MF2_MASK,
  PseudoVSSEG4E8_V_MF4,
  PseudoVSSEG4E8_V_MF4_MASK,
  PseudoVSSEG4E8_V_MF8,
  PseudoVSSEG4E8_V_MF8_MASK,
  PseudoVSSEG5E16_V_M1,
  PseudoVSSEG5E16_V_M1_MASK,
  PseudoVSSEG5E16_V_MF2,
  PseudoVSSEG5E16_V_MF2_MASK,
  PseudoVSSEG5E16_V_MF4,
  PseudoVSSEG5E16_V_MF4_MASK,
  PseudoVSSEG5E32_V_M1,
  PseudoVSSEG5E32_V_M1_MASK,
  PseudoVSSEG5E32_V_MF2,
  PseudoVSSEG5E32_V_MF2_MASK,
  PseudoVSSEG5E64_V_M1,
  PseudoVSSEG5E64_V_M1_MASK,
  PseudoVSSEG5E8_V_M1,
  PseudoVSSEG5E8_V_M1_MASK,
  PseudoVSSEG5E8_V_MF2,
  PseudoVSSEG5E8_V_MF2_MASK,
  PseudoVSSEG5E8_V_MF4,
  PseudoVSSEG5E8_V_MF4_MASK,
  PseudoVSSEG5E8_V_MF8,
  PseudoVSSEG5E8_V_MF8_MASK,
  PseudoVSSEG6E16_V_M1,
  PseudoVSSEG6E16_V_M1_MASK,
  PseudoVSSEG6E16_V_MF2,
  PseudoVSSEG6E16_V_MF2_MASK,
  PseudoVSSEG6E16_V_MF4,
  PseudoVSSEG6E16_V_MF4_MASK,
  PseudoVSSEG6E32_V_M1,
  PseudoVSSEG6E32_V_M1_MASK,
  PseudoVSSEG6E32_V_MF2,
  PseudoVSSEG6E32_V_MF2_MASK,
  PseudoVSSEG6E64_V_M1,
  PseudoVSSEG6E64_V_M1_MASK,
  PseudoVSSEG6E8_V_M1,
  PseudoVSSEG6E8_V_M1_MASK,
  PseudoVSSEG6E8_V_MF2,
  PseudoVSSEG6E8_V_MF2_MASK,
  PseudoVSSEG6E8_V_MF4,
  PseudoVSSEG6E8_V_MF4_MASK,
  PseudoVSSEG6E8_V_MF8,
  PseudoVSSEG6E8_V_MF8_MASK,
  PseudoVSSEG7E16_V_M1,
  PseudoVSSEG7E16_V_M1_MASK,
  PseudoVSSEG7E16_V_MF2,
  PseudoVSSEG7E16_V_MF2_MASK,
  PseudoVSSEG7E16_V_MF4,
  PseudoVSSEG7E16_V_MF4_MASK,
  PseudoVSSEG7E32_V_M1,
  PseudoVSSEG7E32_V_M1_MASK,
  PseudoVSSEG7E32_V_MF2,
  PseudoVSSEG7E32_V_MF2_MASK,
  PseudoVSSEG7E64_V_M1,
  PseudoVSSEG7E64_V_M1_MASK,
  PseudoVSSEG7E8_V_M1,
  PseudoVSSEG7E8_V_M1_MASK,
  PseudoVSSEG7E8_V_MF2,
  PseudoVSSEG7E8_V_MF2_MASK,
  PseudoVSSEG7E8_V_MF4,
  PseudoVSSEG7E8_V_MF4_MASK,
  PseudoVSSEG7E8_V_MF8,
  PseudoVSSEG7E8_V_MF8_MASK,
  PseudoVSSEG8E16_V_M1,
  PseudoVSSEG8E16_V_M1_MASK,
  PseudoVSSEG8E16_V_MF2,
  PseudoVSSEG8E16_V_MF2_MASK,
  PseudoVSSEG8E16_V_MF4,
  PseudoVSSEG8E16_V_MF4_MASK,
  PseudoVSSEG8E32_V_M1,
  PseudoVSSEG8E32_V_M1_MASK,
  PseudoVSSEG8E32_V_MF2,
  PseudoVSSEG8E32_V_MF2_MASK,
  PseudoVSSEG8E64_V_M1,
  PseudoVSSEG8E64_V_M1_MASK,
  PseudoVSSEG8E8_V_M1,
  PseudoVSSEG8E8_V_M1_MASK,
  PseudoVSSEG8E8_V_MF2,
  PseudoVSSEG8E8_V_MF2_MASK,
  PseudoVSSEG8E8_V_MF4,
  PseudoVSSEG8E8_V_MF4_MASK,
  PseudoVSSEG8E8_V_MF8,
  PseudoVSSEG8E8_V_MF8_MASK,
  PseudoVSSRA_VI_M1,
  PseudoVSSRA_VI_M1_MASK,
  PseudoVSSRA_VI_M2,
  PseudoVSSRA_VI_M2_MASK,
  PseudoVSSRA_VI_M4,
  PseudoVSSRA_VI_M4_MASK,
  PseudoVSSRA_VI_M8,
  PseudoVSSRA_VI_M8_MASK,
  PseudoVSSRA_VI_MF2,
  PseudoVSSRA_VI_MF2_MASK,
  PseudoVSSRA_VI_MF4,
  PseudoVSSRA_VI_MF4_MASK,
  PseudoVSSRA_VI_MF8,
  PseudoVSSRA_VI_MF8_MASK,
  PseudoVSSRA_VV_M1,
  PseudoVSSRA_VV_M1_MASK,
  PseudoVSSRA_VV_M2,
  PseudoVSSRA_VV_M2_MASK,
  PseudoVSSRA_VV_M4,
  PseudoVSSRA_VV_M4_MASK,
  PseudoVSSRA_VV_M8,
  PseudoVSSRA_VV_M8_MASK,
  PseudoVSSRA_VV_MF2,
  PseudoVSSRA_VV_MF2_MASK,
  PseudoVSSRA_VV_MF4,
  PseudoVSSRA_VV_MF4_MASK,
  PseudoVSSRA_VV_MF8,
  PseudoVSSRA_VV_MF8_MASK,
  PseudoVSSRA_VX_M1,
  PseudoVSSRA_VX_M1_MASK,
  PseudoVSSRA_VX_M2,
  PseudoVSSRA_VX_M2_MASK,
  PseudoVSSRA_VX_M4,
  PseudoVSSRA_VX_M4_MASK,
  PseudoVSSRA_VX_M8,
  PseudoVSSRA_VX_M8_MASK,
  PseudoVSSRA_VX_MF2,
  PseudoVSSRA_VX_MF2_MASK,
  PseudoVSSRA_VX_MF4,
  PseudoVSSRA_VX_MF4_MASK,
  PseudoVSSRA_VX_MF8,
  PseudoVSSRA_VX_MF8_MASK,
  PseudoVSSRL_VI_M1,
  PseudoVSSRL_VI_M1_MASK,
  PseudoVSSRL_VI_M2,
  PseudoVSSRL_VI_M2_MASK,
  PseudoVSSRL_VI_M4,
  PseudoVSSRL_VI_M4_MASK,
  PseudoVSSRL_VI_M8,
  PseudoVSSRL_VI_M8_MASK,
  PseudoVSSRL_VI_MF2,
  PseudoVSSRL_VI_MF2_MASK,
  PseudoVSSRL_VI_MF4,
  PseudoVSSRL_VI_MF4_MASK,
  PseudoVSSRL_VI_MF8,
  PseudoVSSRL_VI_MF8_MASK,
  PseudoVSSRL_VV_M1,
  PseudoVSSRL_VV_M1_MASK,
  PseudoVSSRL_VV_M2,
  PseudoVSSRL_VV_M2_MASK,
  PseudoVSSRL_VV_M4,
  PseudoVSSRL_VV_M4_MASK,
  PseudoVSSRL_VV_M8,
  PseudoVSSRL_VV_M8_MASK,
  PseudoVSSRL_VV_MF2,
  PseudoVSSRL_VV_MF2_MASK,
  PseudoVSSRL_VV_MF4,
  PseudoVSSRL_VV_MF4_MASK,
  PseudoVSSRL_VV_MF8,
  PseudoVSSRL_VV_MF8_MASK,
  PseudoVSSRL_VX_M1,
  PseudoVSSRL_VX_M1_MASK,
  PseudoVSSRL_VX_M2,
  PseudoVSSRL_VX_M2_MASK,
  PseudoVSSRL_VX_M4,
  PseudoVSSRL_VX_M4_MASK,
  PseudoVSSRL_VX_M8,
  PseudoVSSRL_VX_M8_MASK,
  PseudoVSSRL_VX_MF2,
  PseudoVSSRL_VX_MF2_MASK,
  PseudoVSSRL_VX_MF4,
  PseudoVSSRL_VX_MF4_MASK,
  PseudoVSSRL_VX_MF8,
  PseudoVSSRL_VX_MF8_MASK,
  PseudoVSSSEG2E16_V_M1,
  PseudoVSSSEG2E16_V_M1_MASK,
  PseudoVSSSEG2E16_V_M2,
  PseudoVSSSEG2E16_V_M2_MASK,
  PseudoVSSSEG2E16_V_M4,
  PseudoVSSSEG2E16_V_M4_MASK,
  PseudoVSSSEG2E16_V_MF2,
  PseudoVSSSEG2E16_V_MF2_MASK,
  PseudoVSSSEG2E16_V_MF4,
  PseudoVSSSEG2E16_V_MF4_MASK,
  PseudoVSSSEG2E32_V_M1,
  PseudoVSSSEG2E32_V_M1_MASK,
  PseudoVSSSEG2E32_V_M2,
  PseudoVSSSEG2E32_V_M2_MASK,
  PseudoVSSSEG2E32_V_M4,
  PseudoVSSSEG2E32_V_M4_MASK,
  PseudoVSSSEG2E32_V_MF2,
  PseudoVSSSEG2E32_V_MF2_MASK,
  PseudoVSSSEG2E64_V_M1,
  PseudoVSSSEG2E64_V_M1_MASK,
  PseudoVSSSEG2E64_V_M2,
  PseudoVSSSEG2E64_V_M2_MASK,
  PseudoVSSSEG2E64_V_M4,
  PseudoVSSSEG2E64_V_M4_MASK,
  PseudoVSSSEG2E8_V_M1,
  PseudoVSSSEG2E8_V_M1_MASK,
  PseudoVSSSEG2E8_V_M2,
  PseudoVSSSEG2E8_V_M2_MASK,
  PseudoVSSSEG2E8_V_M4,
  PseudoVSSSEG2E8_V_M4_MASK,
  PseudoVSSSEG2E8_V_MF2,
  PseudoVSSSEG2E8_V_MF2_MASK,
  PseudoVSSSEG2E8_V_MF4,
  PseudoVSSSEG2E8_V_MF4_MASK,
  PseudoVSSSEG2E8_V_MF8,
  PseudoVSSSEG2E8_V_MF8_MASK,
  PseudoVSSSEG3E16_V_M1,
  PseudoVSSSEG3E16_V_M1_MASK,
  PseudoVSSSEG3E16_V_M2,
  PseudoVSSSEG3E16_V_M2_MASK,
  PseudoVSSSEG3E16_V_MF2,
  PseudoVSSSEG3E16_V_MF2_MASK,
  PseudoVSSSEG3E16_V_MF4,
  PseudoVSSSEG3E16_V_MF4_MASK,
  PseudoVSSSEG3E32_V_M1,
  PseudoVSSSEG3E32_V_M1_MASK,
  PseudoVSSSEG3E32_V_M2,
  PseudoVSSSEG3E32_V_M2_MASK,
  PseudoVSSSEG3E32_V_MF2,
  PseudoVSSSEG3E32_V_MF2_MASK,
  PseudoVSSSEG3E64_V_M1,
  PseudoVSSSEG3E64_V_M1_MASK,
  PseudoVSSSEG3E64_V_M2,
  PseudoVSSSEG3E64_V_M2_MASK,
  PseudoVSSSEG3E8_V_M1,
  PseudoVSSSEG3E8_V_M1_MASK,
  PseudoVSSSEG3E8_V_M2,
  PseudoVSSSEG3E8_V_M2_MASK,
  PseudoVSSSEG3E8_V_MF2,
  PseudoVSSSEG3E8_V_MF2_MASK,
  PseudoVSSSEG3E8_V_MF4,
  PseudoVSSSEG3E8_V_MF4_MASK,
  PseudoVSSSEG3E8_V_MF8,
  PseudoVSSSEG3E8_V_MF8_MASK,
  PseudoVSSSEG4E16_V_M1,
  PseudoVSSSEG4E16_V_M1_MASK,
  PseudoVSSSEG4E16_V_M2,
  PseudoVSSSEG4E16_V_M2_MASK,
  PseudoVSSSEG4E16_V_MF2,
  PseudoVSSSEG4E16_V_MF2_MASK,
  PseudoVSSSEG4E16_V_MF4,
  PseudoVSSSEG4E16_V_MF4_MASK,
  PseudoVSSSEG4E32_V_M1,
  PseudoVSSSEG4E32_V_M1_MASK,
  PseudoVSSSEG4E32_V_M2,
  PseudoVSSSEG4E32_V_M2_MASK,
  PseudoVSSSEG4E32_V_MF2,
  PseudoVSSSEG4E32_V_MF2_MASK,
  PseudoVSSSEG4E64_V_M1,
  PseudoVSSSEG4E64_V_M1_MASK,
  PseudoVSSSEG4E64_V_M2,
  PseudoVSSSEG4E64_V_M2_MASK,
  PseudoVSSSEG4E8_V_M1,
  PseudoVSSSEG4E8_V_M1_MASK,
  PseudoVSSSEG4E8_V_M2,
  PseudoVSSSEG4E8_V_M2_MASK,
  PseudoVSSSEG4E8_V_MF2,
  PseudoVSSSEG4E8_V_MF2_MASK,
  PseudoVSSSEG4E8_V_MF4,
  PseudoVSSSEG4E8_V_MF4_MASK,
  PseudoVSSSEG4E8_V_MF8,
  PseudoVSSSEG4E8_V_MF8_MASK,
  PseudoVSSSEG5E16_V_M1,
  PseudoVSSSEG5E16_V_M1_MASK,
  PseudoVSSSEG5E16_V_MF2,
  PseudoVSSSEG5E16_V_MF2_MASK,
  PseudoVSSSEG5E16_V_MF4,
  PseudoVSSSEG5E16_V_MF4_MASK,
  PseudoVSSSEG5E32_V_M1,
  PseudoVSSSEG5E32_V_M1_MASK,
  PseudoVSSSEG5E32_V_MF2,
  PseudoVSSSEG5E32_V_MF2_MASK,
  PseudoVSSSEG5E64_V_M1,
  PseudoVSSSEG5E64_V_M1_MASK,
  PseudoVSSSEG5E8_V_M1,
  PseudoVSSSEG5E8_V_M1_MASK,
  PseudoVSSSEG5E8_V_MF2,
  PseudoVSSSEG5E8_V_MF2_MASK,
  PseudoVSSSEG5E8_V_MF4,
  PseudoVSSSEG5E8_V_MF4_MASK,
  PseudoVSSSEG5E8_V_MF8,
  PseudoVSSSEG5E8_V_MF8_MASK,
  PseudoVSSSEG6E16_V_M1,
  PseudoVSSSEG6E16_V_M1_MASK,
  PseudoVSSSEG6E16_V_MF2,
  PseudoVSSSEG6E16_V_MF2_MASK,
  PseudoVSSSEG6E16_V_MF4,
  PseudoVSSSEG6E16_V_MF4_MASK,
  PseudoVSSSEG6E32_V_M1,
  PseudoVSSSEG6E32_V_M1_MASK,
  PseudoVSSSEG6E32_V_MF2,
  PseudoVSSSEG6E32_V_MF2_MASK,
  PseudoVSSSEG6E64_V_M1,
  PseudoVSSSEG6E64_V_M1_MASK,
  PseudoVSSSEG6E8_V_M1,
  PseudoVSSSEG6E8_V_M1_MASK,
  PseudoVSSSEG6E8_V_MF2,
  PseudoVSSSEG6E8_V_MF2_MASK,
  PseudoVSSSEG6E8_V_MF4,
  PseudoVSSSEG6E8_V_MF4_MASK,
  PseudoVSSSEG6E8_V_MF8,
  PseudoVSSSEG6E8_V_MF8_MASK,
  PseudoVSSSEG7E16_V_M1,
  PseudoVSSSEG7E16_V_M1_MASK,
  PseudoVSSSEG7E16_V_MF2,
  PseudoVSSSEG7E16_V_MF2_MASK,
  PseudoVSSSEG7E16_V_MF4,
  PseudoVSSSEG7E16_V_MF4_MASK,
  PseudoVSSSEG7E32_V_M1,
  PseudoVSSSEG7E32_V_M1_MASK,
  PseudoVSSSEG7E32_V_MF2,
  PseudoVSSSEG7E32_V_MF2_MASK,
  PseudoVSSSEG7E64_V_M1,
  PseudoVSSSEG7E64_V_M1_MASK,
  PseudoVSSSEG7E8_V_M1,
  PseudoVSSSEG7E8_V_M1_MASK,
  PseudoVSSSEG7E8_V_MF2,
  PseudoVSSSEG7E8_V_MF2_MASK,
  PseudoVSSSEG7E8_V_MF4,
  PseudoVSSSEG7E8_V_MF4_MASK,
  PseudoVSSSEG7E8_V_MF8,
  PseudoVSSSEG7E8_V_MF8_MASK,
  PseudoVSSSEG8E16_V_M1,
  PseudoVSSSEG8E16_V_M1_MASK,
  PseudoVSSSEG8E16_V_MF2,
  PseudoVSSSEG8E16_V_MF2_MASK,
  PseudoVSSSEG8E16_V_MF4,
  PseudoVSSSEG8E16_V_MF4_MASK,
  PseudoVSSSEG8E32_V_M1,
  PseudoVSSSEG8E32_V_M1_MASK,
  PseudoVSSSEG8E32_V_MF2,
  PseudoVSSSEG8E32_V_MF2_MASK,
  PseudoVSSSEG8E64_V_M1,
  PseudoVSSSEG8E64_V_M1_MASK,
  PseudoVSSSEG8E8_V_M1,
  PseudoVSSSEG8E8_V_M1_MASK,
  PseudoVSSSEG8E8_V_MF2,
  PseudoVSSSEG8E8_V_MF2_MASK,
  PseudoVSSSEG8E8_V_MF4,
  PseudoVSSSEG8E8_V_MF4_MASK,
  PseudoVSSSEG8E8_V_MF8,
  PseudoVSSSEG8E8_V_MF8_MASK,
  PseudoVSSUBU_VV_M1,
  PseudoVSSUBU_VV_M1_MASK,
  PseudoVSSUBU_VV_M2,
  PseudoVSSUBU_VV_M2_MASK,
  PseudoVSSUBU_VV_M4,
  PseudoVSSUBU_VV_M4_MASK,
  PseudoVSSUBU_VV_M8,
  PseudoVSSUBU_VV_M8_MASK,
  PseudoVSSUBU_VV_MF2,
  PseudoVSSUBU_VV_MF2_MASK,
  PseudoVSSUBU_VV_MF4,
  PseudoVSSUBU_VV_MF4_MASK,
  PseudoVSSUBU_VV_MF8,
  PseudoVSSUBU_VV_MF8_MASK,
  PseudoVSSUBU_VX_M1,
  PseudoVSSUBU_VX_M1_MASK,
  PseudoVSSUBU_VX_M2,
  PseudoVSSUBU_VX_M2_MASK,
  PseudoVSSUBU_VX_M4,
  PseudoVSSUBU_VX_M4_MASK,
  PseudoVSSUBU_VX_M8,
  PseudoVSSUBU_VX_M8_MASK,
  PseudoVSSUBU_VX_MF2,
  PseudoVSSUBU_VX_MF2_MASK,
  PseudoVSSUBU_VX_MF4,
  PseudoVSSUBU_VX_MF4_MASK,
  PseudoVSSUBU_VX_MF8,
  PseudoVSSUBU_VX_MF8_MASK,
  PseudoVSSUB_VV_M1,
  PseudoVSSUB_VV_M1_MASK,
  PseudoVSSUB_VV_M2,
  PseudoVSSUB_VV_M2_MASK,
  PseudoVSSUB_VV_M4,
  PseudoVSSUB_VV_M4_MASK,
  PseudoVSSUB_VV_M8,
  PseudoVSSUB_VV_M8_MASK,
  PseudoVSSUB_VV_MF2,
  PseudoVSSUB_VV_MF2_MASK,
  PseudoVSSUB_VV_MF4,
  PseudoVSSUB_VV_MF4_MASK,
  PseudoVSSUB_VV_MF8,
  PseudoVSSUB_VV_MF8_MASK,
  PseudoVSSUB_VX_M1,
  PseudoVSSUB_VX_M1_MASK,
  PseudoVSSUB_VX_M2,
  PseudoVSSUB_VX_M2_MASK,
  PseudoVSSUB_VX_M4,
  PseudoVSSUB_VX_M4_MASK,
  PseudoVSSUB_VX_M8,
  PseudoVSSUB_VX_M8_MASK,
  PseudoVSSUB_VX_MF2,
  PseudoVSSUB_VX_MF2_MASK,
  PseudoVSSUB_VX_MF4,
  PseudoVSSUB_VX_MF4_MASK,
  PseudoVSSUB_VX_MF8,
  PseudoVSSUB_VX_MF8_MASK,
  PseudoVSUB_VV_M1,
  PseudoVSUB_VV_M1_MASK,
  PseudoVSUB_VV_M2,
  PseudoVSUB_VV_M2_MASK,
  PseudoVSUB_VV_M4,
  PseudoVSUB_VV_M4_MASK,
  PseudoVSUB_VV_M8,
  PseudoVSUB_VV_M8_MASK,
  PseudoVSUB_VV_MF2,
  PseudoVSUB_VV_MF2_MASK,
  PseudoVSUB_VV_MF4,
  PseudoVSUB_VV_MF4_MASK,
  PseudoVSUB_VV_MF8,
  PseudoVSUB_VV_MF8_MASK,
  PseudoVSUB_VX_M1,
  PseudoVSUB_VX_M1_MASK,
  PseudoVSUB_VX_M2,
  PseudoVSUB_VX_M2_MASK,
  PseudoVSUB_VX_M4,
  PseudoVSUB_VX_M4_MASK,
  PseudoVSUB_VX_M8,
  PseudoVSUB_VX_M8_MASK,
  PseudoVSUB_VX_MF2,
  PseudoVSUB_VX_MF2_MASK,
  PseudoVSUB_VX_MF4,
  PseudoVSUB_VX_MF4_MASK,
  PseudoVSUB_VX_MF8,
  PseudoVSUB_VX_MF8_MASK,
  PseudoVSUXEI16_V_M1_M1,
  PseudoVSUXEI16_V_M1_M1_MASK,
  PseudoVSUXEI16_V_M1_M2,
  PseudoVSUXEI16_V_M1_M2_MASK,
  PseudoVSUXEI16_V_M1_M4,
  PseudoVSUXEI16_V_M1_M4_MASK,
  PseudoVSUXEI16_V_M1_MF2,
  PseudoVSUXEI16_V_M1_MF2_MASK,
  PseudoVSUXEI16_V_M2_M1,
  PseudoVSUXEI16_V_M2_M1_MASK,
  PseudoVSUXEI16_V_M2_M2,
  PseudoVSUXEI16_V_M2_M2_MASK,
  PseudoVSUXEI16_V_M2_M4,
  PseudoVSUXEI16_V_M2_M4_MASK,
  PseudoVSUXEI16_V_M2_M8,
  PseudoVSUXEI16_V_M2_M8_MASK,
  PseudoVSUXEI16_V_M4_M2,
  PseudoVSUXEI16_V_M4_M2_MASK,
  PseudoVSUXEI16_V_M4_M4,
  PseudoVSUXEI16_V_M4_M4_MASK,
  PseudoVSUXEI16_V_M4_M8,
  PseudoVSUXEI16_V_M4_M8_MASK,
  PseudoVSUXEI16_V_M8_M4,
  PseudoVSUXEI16_V_M8_M4_MASK,
  PseudoVSUXEI16_V_M8_M8,
  PseudoVSUXEI16_V_M8_M8_MASK,
  PseudoVSUXEI16_V_MF2_M1,
  PseudoVSUXEI16_V_MF2_M1_MASK,
  PseudoVSUXEI16_V_MF2_M2,
  PseudoVSUXEI16_V_MF2_M2_MASK,
  PseudoVSUXEI16_V_MF2_MF2,
  PseudoVSUXEI16_V_MF2_MF2_MASK,
  PseudoVSUXEI16_V_MF2_MF4,
  PseudoVSUXEI16_V_MF2_MF4_MASK,
  PseudoVSUXEI16_V_MF4_M1,
  PseudoVSUXEI16_V_MF4_M1_MASK,
  PseudoVSUXEI16_V_MF4_MF2,
  PseudoVSUXEI16_V_MF4_MF2_MASK,
  PseudoVSUXEI16_V_MF4_MF4,
  PseudoVSUXEI16_V_MF4_MF4_MASK,
  PseudoVSUXEI16_V_MF4_MF8,
  PseudoVSUXEI16_V_MF4_MF8_MASK,
  PseudoVSUXEI32_V_M1_M1,
  PseudoVSUXEI32_V_M1_M1_MASK,
  PseudoVSUXEI32_V_M1_M2,
  PseudoVSUXEI32_V_M1_M2_MASK,
  PseudoVSUXEI32_V_M1_MF2,
  PseudoVSUXEI32_V_M1_MF2_MASK,
  PseudoVSUXEI32_V_M1_MF4,
  PseudoVSUXEI32_V_M1_MF4_MASK,
  PseudoVSUXEI32_V_M2_M1,
  PseudoVSUXEI32_V_M2_M1_MASK,
  PseudoVSUXEI32_V_M2_M2,
  PseudoVSUXEI32_V_M2_M2_MASK,
  PseudoVSUXEI32_V_M2_M4,
  PseudoVSUXEI32_V_M2_M4_MASK,
  PseudoVSUXEI32_V_M2_MF2,
  PseudoVSUXEI32_V_M2_MF2_MASK,
  PseudoVSUXEI32_V_M4_M1,
  PseudoVSUXEI32_V_M4_M1_MASK,
  PseudoVSUXEI32_V_M4_M2,
  PseudoVSUXEI32_V_M4_M2_MASK,
  PseudoVSUXEI32_V_M4_M4,
  PseudoVSUXEI32_V_M4_M4_MASK,
  PseudoVSUXEI32_V_M4_M8,
  PseudoVSUXEI32_V_M4_M8_MASK,
  PseudoVSUXEI32_V_M8_M2,
  PseudoVSUXEI32_V_M8_M2_MASK,
  PseudoVSUXEI32_V_M8_M4,
  PseudoVSUXEI32_V_M8_M4_MASK,
  PseudoVSUXEI32_V_M8_M8,
  PseudoVSUXEI32_V_M8_M8_MASK,
  PseudoVSUXEI32_V_MF2_M1,
  PseudoVSUXEI32_V_MF2_M1_MASK,
  PseudoVSUXEI32_V_MF2_MF2,
  PseudoVSUXEI32_V_MF2_MF2_MASK,
  PseudoVSUXEI32_V_MF2_MF4,
  PseudoVSUXEI32_V_MF2_MF4_MASK,
  PseudoVSUXEI32_V_MF2_MF8,
  PseudoVSUXEI32_V_MF2_MF8_MASK,
  PseudoVSUXEI64_V_M1_M1,
  PseudoVSUXEI64_V_M1_M1_MASK,
  PseudoVSUXEI64_V_M1_MF2,
  PseudoVSUXEI64_V_M1_MF2_MASK,
  PseudoVSUXEI64_V_M1_MF4,
  PseudoVSUXEI64_V_M1_MF4_MASK,
  PseudoVSUXEI64_V_M1_MF8,
  PseudoVSUXEI64_V_M1_MF8_MASK,
  PseudoVSUXEI64_V_M2_M1,
  PseudoVSUXEI64_V_M2_M1_MASK,
  PseudoVSUXEI64_V_M2_M2,
  PseudoVSUXEI64_V_M2_M2_MASK,
  PseudoVSUXEI64_V_M2_MF2,
  PseudoVSUXEI64_V_M2_MF2_MASK,
  PseudoVSUXEI64_V_M2_MF4,
  PseudoVSUXEI64_V_M2_MF4_MASK,
  PseudoVSUXEI64_V_M4_M1,
  PseudoVSUXEI64_V_M4_M1_MASK,
  PseudoVSUXEI64_V_M4_M2,
  PseudoVSUXEI64_V_M4_M2_MASK,
  PseudoVSUXEI64_V_M4_M4,
  PseudoVSUXEI64_V_M4_M4_MASK,
  PseudoVSUXEI64_V_M4_MF2,
  PseudoVSUXEI64_V_M4_MF2_MASK,
  PseudoVSUXEI64_V_M8_M1,
  PseudoVSUXEI64_V_M8_M1_MASK,
  PseudoVSUXEI64_V_M8_M2,
  PseudoVSUXEI64_V_M8_M2_MASK,
  PseudoVSUXEI64_V_M8_M4,
  PseudoVSUXEI64_V_M8_M4_MASK,
  PseudoVSUXEI64_V_M8_M8,
  PseudoVSUXEI64_V_M8_M8_MASK,
  PseudoVSUXEI8_V_M1_M1,
  PseudoVSUXEI8_V_M1_M1_MASK,
  PseudoVSUXEI8_V_M1_M2,
  PseudoVSUXEI8_V_M1_M2_MASK,
  PseudoVSUXEI8_V_M1_M4,
  PseudoVSUXEI8_V_M1_M4_MASK,
  PseudoVSUXEI8_V_M1_M8,
  PseudoVSUXEI8_V_M1_M8_MASK,
  PseudoVSUXEI8_V_M2_M2,
  PseudoVSUXEI8_V_M2_M2_MASK,
  PseudoVSUXEI8_V_M2_M4,
  PseudoVSUXEI8_V_M2_M4_MASK,
  PseudoVSUXEI8_V_M2_M8,
  PseudoVSUXEI8_V_M2_M8_MASK,
  PseudoVSUXEI8_V_M4_M4,
  PseudoVSUXEI8_V_M4_M4_MASK,
  PseudoVSUXEI8_V_M4_M8,
  PseudoVSUXEI8_V_M4_M8_MASK,
  PseudoVSUXEI8_V_M8_M8,
  PseudoVSUXEI8_V_M8_M8_MASK,
  PseudoVSUXEI8_V_MF2_M1,
  PseudoVSUXEI8_V_MF2_M1_MASK,
  PseudoVSUXEI8_V_MF2_M2,
  PseudoVSUXEI8_V_MF2_M2_MASK,
  PseudoVSUXEI8_V_MF2_M4,
  PseudoVSUXEI8_V_MF2_M4_MASK,
  PseudoVSUXEI8_V_MF2_MF2,
  PseudoVSUXEI8_V_MF2_MF2_MASK,
  PseudoVSUXEI8_V_MF4_M1,
  PseudoVSUXEI8_V_MF4_M1_MASK,
  PseudoVSUXEI8_V_MF4_M2,
  PseudoVSUXEI8_V_MF4_M2_MASK,
  PseudoVSUXEI8_V_MF4_MF2,
  PseudoVSUXEI8_V_MF4_MF2_MASK,
  PseudoVSUXEI8_V_MF4_MF4,
  PseudoVSUXEI8_V_MF4_MF4_MASK,
  PseudoVSUXEI8_V_MF8_M1,
  PseudoVSUXEI8_V_MF8_M1_MASK,
  PseudoVSUXEI8_V_MF8_MF2,
  PseudoVSUXEI8_V_MF8_MF2_MASK,
  PseudoVSUXEI8_V_MF8_MF4,
  PseudoVSUXEI8_V_MF8_MF4_MASK,
  PseudoVSUXEI8_V_MF8_MF8,
  PseudoVSUXEI8_V_MF8_MF8_MASK,
  PseudoVSUXSEG2EI16_V_M1_M1,
  PseudoVSUXSEG2EI16_V_M1_M1_MASK,
  PseudoVSUXSEG2EI16_V_M1_M2,
  PseudoVSUXSEG2EI16_V_M1_M2_MASK,
  PseudoVSUXSEG2EI16_V_M1_M4,
  PseudoVSUXSEG2EI16_V_M1_M4_MASK,
  PseudoVSUXSEG2EI16_V_M1_MF2,
  PseudoVSUXSEG2EI16_V_M1_MF2_MASK,
  PseudoVSUXSEG2EI16_V_M2_M1,
  PseudoVSUXSEG2EI16_V_M2_M1_MASK,
  PseudoVSUXSEG2EI16_V_M2_M2,
  PseudoVSUXSEG2EI16_V_M2_M2_MASK,
  PseudoVSUXSEG2EI16_V_M2_M4,
  PseudoVSUXSEG2EI16_V_M2_M4_MASK,
  PseudoVSUXSEG2EI16_V_M4_M2,
  PseudoVSUXSEG2EI16_V_M4_M2_MASK,
  PseudoVSUXSEG2EI16_V_M4_M4,
  PseudoVSUXSEG2EI16_V_M4_M4_MASK,
  PseudoVSUXSEG2EI16_V_M8_M4,
  PseudoVSUXSEG2EI16_V_M8_M4_MASK,
  PseudoVSUXSEG2EI16_V_MF2_M1,
  PseudoVSUXSEG2EI16_V_MF2_M1_MASK,
  PseudoVSUXSEG2EI16_V_MF2_M2,
  PseudoVSUXSEG2EI16_V_MF2_M2_MASK,
  PseudoVSUXSEG2EI16_V_MF2_MF2,
  PseudoVSUXSEG2EI16_V_MF2_MF2_MASK,
  PseudoVSUXSEG2EI16_V_MF2_MF4,
  PseudoVSUXSEG2EI16_V_MF2_MF4_MASK,
  PseudoVSUXSEG2EI16_V_MF4_M1,
  PseudoVSUXSEG2EI16_V_MF4_M1_MASK,
  PseudoVSUXSEG2EI16_V_MF4_MF2,
  PseudoVSUXSEG2EI16_V_MF4_MF2_MASK,
  PseudoVSUXSEG2EI16_V_MF4_MF4,
  PseudoVSUXSEG2EI16_V_MF4_MF4_MASK,
  PseudoVSUXSEG2EI16_V_MF4_MF8,
  PseudoVSUXSEG2EI16_V_MF4_MF8_MASK,
  PseudoVSUXSEG2EI32_V_M1_M1,
  PseudoVSUXSEG2EI32_V_M1_M1_MASK,
  PseudoVSUXSEG2EI32_V_M1_M2,
  PseudoVSUXSEG2EI32_V_M1_M2_MASK,
  PseudoVSUXSEG2EI32_V_M1_MF2,
  PseudoVSUXSEG2EI32_V_M1_MF2_MASK,
  PseudoVSUXSEG2EI32_V_M1_MF4,
  PseudoVSUXSEG2EI32_V_M1_MF4_MASK,
  PseudoVSUXSEG2EI32_V_M2_M1,
  PseudoVSUXSEG2EI32_V_M2_M1_MASK,
  PseudoVSUXSEG2EI32_V_M2_M2,
  PseudoVSUXSEG2EI32_V_M2_M2_MASK,
  PseudoVSUXSEG2EI32_V_M2_M4,
  PseudoVSUXSEG2EI32_V_M2_M4_MASK,
  PseudoVSUXSEG2EI32_V_M2_MF2,
  PseudoVSUXSEG2EI32_V_M2_MF2_MASK,
  PseudoVSUXSEG2EI32_V_M4_M1,
  PseudoVSUXSEG2EI32_V_M4_M1_MASK,
  PseudoVSUXSEG2EI32_V_M4_M2,
  PseudoVSUXSEG2EI32_V_M4_M2_MASK,
  PseudoVSUXSEG2EI32_V_M4_M4,
  PseudoVSUXSEG2EI32_V_M4_M4_MASK,
  PseudoVSUXSEG2EI32_V_M8_M2,
  PseudoVSUXSEG2EI32_V_M8_M2_MASK,
  PseudoVSUXSEG2EI32_V_M8_M4,
  PseudoVSUXSEG2EI32_V_M8_M4_MASK,
  PseudoVSUXSEG2EI32_V_MF2_M1,
  PseudoVSUXSEG2EI32_V_MF2_M1_MASK,
  PseudoVSUXSEG2EI32_V_MF2_MF2,
  PseudoVSUXSEG2EI32_V_MF2_MF2_MASK,
  PseudoVSUXSEG2EI32_V_MF2_MF4,
  PseudoVSUXSEG2EI32_V_MF2_MF4_MASK,
  PseudoVSUXSEG2EI32_V_MF2_MF8,
  PseudoVSUXSEG2EI32_V_MF2_MF8_MASK,
  PseudoVSUXSEG2EI64_V_M1_M1,
  PseudoVSUXSEG2EI64_V_M1_M1_MASK,
  PseudoVSUXSEG2EI64_V_M1_MF2,
  PseudoVSUXSEG2EI64_V_M1_MF2_MASK,
  PseudoVSUXSEG2EI64_V_M1_MF4,
  PseudoVSUXSEG2EI64_V_M1_MF4_MASK,
  PseudoVSUXSEG2EI64_V_M1_MF8,
  PseudoVSUXSEG2EI64_V_M1_MF8_MASK,
  PseudoVSUXSEG2EI64_V_M2_M1,
  PseudoVSUXSEG2EI64_V_M2_M1_MASK,
  PseudoVSUXSEG2EI64_V_M2_M2,
  PseudoVSUXSEG2EI64_V_M2_M2_MASK,
  PseudoVSUXSEG2EI64_V_M2_MF2,
  PseudoVSUXSEG2EI64_V_M2_MF2_MASK,
  PseudoVSUXSEG2EI64_V_M2_MF4,
  PseudoVSUXSEG2EI64_V_M2_MF4_MASK,
  PseudoVSUXSEG2EI64_V_M4_M1,
  PseudoVSUXSEG2EI64_V_M4_M1_MASK,
  PseudoVSUXSEG2EI64_V_M4_M2,
  PseudoVSUXSEG2EI64_V_M4_M2_MASK,
  PseudoVSUXSEG2EI64_V_M4_M4,
  PseudoVSUXSEG2EI64_V_M4_M4_MASK,
  PseudoVSUXSEG2EI64_V_M4_MF2,
  PseudoVSUXSEG2EI64_V_M4_MF2_MASK,
  PseudoVSUXSEG2EI64_V_M8_M1,
  PseudoVSUXSEG2EI64_V_M8_M1_MASK,
  PseudoVSUXSEG2EI64_V_M8_M2,
  PseudoVSUXSEG2EI64_V_M8_M2_MASK,
  PseudoVSUXSEG2EI64_V_M8_M4,
  PseudoVSUXSEG2EI64_V_M8_M4_MASK,
  PseudoVSUXSEG2EI8_V_M1_M1,
  PseudoVSUXSEG2EI8_V_M1_M1_MASK,
  PseudoVSUXSEG2EI8_V_M1_M2,
  PseudoVSUXSEG2EI8_V_M1_M2_MASK,
  PseudoVSUXSEG2EI8_V_M1_M4,
  PseudoVSUXSEG2EI8_V_M1_M4_MASK,
  PseudoVSUXSEG2EI8_V_M2_M2,
  PseudoVSUXSEG2EI8_V_M2_M2_MASK,
  PseudoVSUXSEG2EI8_V_M2_M4,
  PseudoVSUXSEG2EI8_V_M2_M4_MASK,
  PseudoVSUXSEG2EI8_V_M4_M4,
  PseudoVSUXSEG2EI8_V_M4_M4_MASK,
  PseudoVSUXSEG2EI8_V_MF2_M1,
  PseudoVSUXSEG2EI8_V_MF2_M1_MASK,
  PseudoVSUXSEG2EI8_V_MF2_M2,
  PseudoVSUXSEG2EI8_V_MF2_M2_MASK,
  PseudoVSUXSEG2EI8_V_MF2_M4,
  PseudoVSUXSEG2EI8_V_MF2_M4_MASK,
  PseudoVSUXSEG2EI8_V_MF2_MF2,
  PseudoVSUXSEG2EI8_V_MF2_MF2_MASK,
  PseudoVSUXSEG2EI8_V_MF4_M1,
  PseudoVSUXSEG2EI8_V_MF4_M1_MASK,
  PseudoVSUXSEG2EI8_V_MF4_M2,
  PseudoVSUXSEG2EI8_V_MF4_M2_MASK,
  PseudoVSUXSEG2EI8_V_MF4_MF2,
  PseudoVSUXSEG2EI8_V_MF4_MF2_MASK,
  PseudoVSUXSEG2EI8_V_MF4_MF4,
  PseudoVSUXSEG2EI8_V_MF4_MF4_MASK,
  PseudoVSUXSEG2EI8_V_MF8_M1,
  PseudoVSUXSEG2EI8_V_MF8_M1_MASK,
  PseudoVSUXSEG2EI8_V_MF8_MF2,
  PseudoVSUXSEG2EI8_V_MF8_MF2_MASK,
  PseudoVSUXSEG2EI8_V_MF8_MF4,
  PseudoVSUXSEG2EI8_V_MF8_MF4_MASK,
  PseudoVSUXSEG2EI8_V_MF8_MF8,
  PseudoVSUXSEG2EI8_V_MF8_MF8_MASK,
  PseudoVSUXSEG3EI16_V_M1_M1,
  PseudoVSUXSEG3EI16_V_M1_M1_MASK,
  PseudoVSUXSEG3EI16_V_M1_M2,
  PseudoVSUXSEG3EI16_V_M1_M2_MASK,
  PseudoVSUXSEG3EI16_V_M1_MF2,
  PseudoVSUXSEG3EI16_V_M1_MF2_MASK,
  PseudoVSUXSEG3EI16_V_M2_M1,
  PseudoVSUXSEG3EI16_V_M2_M1_MASK,
  PseudoVSUXSEG3EI16_V_M2_M2,
  PseudoVSUXSEG3EI16_V_M2_M2_MASK,
  PseudoVSUXSEG3EI16_V_M4_M2,
  PseudoVSUXSEG3EI16_V_M4_M2_MASK,
  PseudoVSUXSEG3EI16_V_MF2_M1,
  PseudoVSUXSEG3EI16_V_MF2_M1_MASK,
  PseudoVSUXSEG3EI16_V_MF2_M2,
  PseudoVSUXSEG3EI16_V_MF2_M2_MASK,
  PseudoVSUXSEG3EI16_V_MF2_MF2,
  PseudoVSUXSEG3EI16_V_MF2_MF2_MASK,
  PseudoVSUXSEG3EI16_V_MF2_MF4,
  PseudoVSUXSEG3EI16_V_MF2_MF4_MASK,
  PseudoVSUXSEG3EI16_V_MF4_M1,
  PseudoVSUXSEG3EI16_V_MF4_M1_MASK,
  PseudoVSUXSEG3EI16_V_MF4_MF2,
  PseudoVSUXSEG3EI16_V_MF4_MF2_MASK,
  PseudoVSUXSEG3EI16_V_MF4_MF4,
  PseudoVSUXSEG3EI16_V_MF4_MF4_MASK,
  PseudoVSUXSEG3EI16_V_MF4_MF8,
  PseudoVSUXSEG3EI16_V_MF4_MF8_MASK,
  PseudoVSUXSEG3EI32_V_M1_M1,
  PseudoVSUXSEG3EI32_V_M1_M1_MASK,
  PseudoVSUXSEG3EI32_V_M1_M2,
  PseudoVSUXSEG3EI32_V_M1_M2_MASK,
  PseudoVSUXSEG3EI32_V_M1_MF2,
  PseudoVSUXSEG3EI32_V_M1_MF2_MASK,
  PseudoVSUXSEG3EI32_V_M1_MF4,
  PseudoVSUXSEG3EI32_V_M1_MF4_MASK,
  PseudoVSUXSEG3EI32_V_M2_M1,
  PseudoVSUXSEG3EI32_V_M2_M1_MASK,
  PseudoVSUXSEG3EI32_V_M2_M2,
  PseudoVSUXSEG3EI32_V_M2_M2_MASK,
  PseudoVSUXSEG3EI32_V_M2_MF2,
  PseudoVSUXSEG3EI32_V_M2_MF2_MASK,
  PseudoVSUXSEG3EI32_V_M4_M1,
  PseudoVSUXSEG3EI32_V_M4_M1_MASK,
  PseudoVSUXSEG3EI32_V_M4_M2,
  PseudoVSUXSEG3EI32_V_M4_M2_MASK,
  PseudoVSUXSEG3EI32_V_M8_M2,
  PseudoVSUXSEG3EI32_V_M8_M2_MASK,
  PseudoVSUXSEG3EI32_V_MF2_M1,
  PseudoVSUXSEG3EI32_V_MF2_M1_MASK,
  PseudoVSUXSEG3EI32_V_MF2_MF2,
  PseudoVSUXSEG3EI32_V_MF2_MF2_MASK,
  PseudoVSUXSEG3EI32_V_MF2_MF4,
  PseudoVSUXSEG3EI32_V_MF2_MF4_MASK,
  PseudoVSUXSEG3EI32_V_MF2_MF8,
  PseudoVSUXSEG3EI32_V_MF2_MF8_MASK,
  PseudoVSUXSEG3EI64_V_M1_M1,
  PseudoVSUXSEG3EI64_V_M1_M1_MASK,
  PseudoVSUXSEG3EI64_V_M1_MF2,
  PseudoVSUXSEG3EI64_V_M1_MF2_MASK,
  PseudoVSUXSEG3EI64_V_M1_MF4,
  PseudoVSUXSEG3EI64_V_M1_MF4_MASK,
  PseudoVSUXSEG3EI64_V_M1_MF8,
  PseudoVSUXSEG3EI64_V_M1_MF8_MASK,
  PseudoVSUXSEG3EI64_V_M2_M1,
  PseudoVSUXSEG3EI64_V_M2_M1_MASK,
  PseudoVSUXSEG3EI64_V_M2_M2,
  PseudoVSUXSEG3EI64_V_M2_M2_MASK,
  PseudoVSUXSEG3EI64_V_M2_MF2,
  PseudoVSUXSEG3EI64_V_M2_MF2_MASK,
  PseudoVSUXSEG3EI64_V_M2_MF4,
  PseudoVSUXSEG3EI64_V_M2_MF4_MASK,
  PseudoVSUXSEG3EI64_V_M4_M1,
  PseudoVSUXSEG3EI64_V_M4_M1_MASK,
  PseudoVSUXSEG3EI64_V_M4_M2,
  PseudoVSUXSEG3EI64_V_M4_M2_MASK,
  PseudoVSUXSEG3EI64_V_M4_MF2,
  PseudoVSUXSEG3EI64_V_M4_MF2_MASK,
  PseudoVSUXSEG3EI64_V_M8_M1,
  PseudoVSUXSEG3EI64_V_M8_M1_MASK,
  PseudoVSUXSEG3EI64_V_M8_M2,
  PseudoVSUXSEG3EI64_V_M8_M2_MASK,
  PseudoVSUXSEG3EI8_V_M1_M1,
  PseudoVSUXSEG3EI8_V_M1_M1_MASK,
  PseudoVSUXSEG3EI8_V_M1_M2,
  PseudoVSUXSEG3EI8_V_M1_M2_MASK,
  PseudoVSUXSEG3EI8_V_M2_M2,
  PseudoVSUXSEG3EI8_V_M2_M2_MASK,
  PseudoVSUXSEG3EI8_V_MF2_M1,
  PseudoVSUXSEG3EI8_V_MF2_M1_MASK,
  PseudoVSUXSEG3EI8_V_MF2_M2,
  PseudoVSUXSEG3EI8_V_MF2_M2_MASK,
  PseudoVSUXSEG3EI8_V_MF2_MF2,
  PseudoVSUXSEG3EI8_V_MF2_MF2_MASK,
  PseudoVSUXSEG3EI8_V_MF4_M1,
  PseudoVSUXSEG3EI8_V_MF4_M1_MASK,
  PseudoVSUXSEG3EI8_V_MF4_M2,
  PseudoVSUXSEG3EI8_V_MF4_M2_MASK,
  PseudoVSUXSEG3EI8_V_MF4_MF2,
  PseudoVSUXSEG3EI8_V_MF4_MF2_MASK,
  PseudoVSUXSEG3EI8_V_MF4_MF4,
  PseudoVSUXSEG3EI8_V_MF4_MF4_MASK,
  PseudoVSUXSEG3EI8_V_MF8_M1,
  PseudoVSUXSEG3EI8_V_MF8_M1_MASK,
  PseudoVSUXSEG3EI8_V_MF8_MF2,
  PseudoVSUXSEG3EI8_V_MF8_MF2_MASK,
  PseudoVSUXSEG3EI8_V_MF8_MF4,
  PseudoVSUXSEG3EI8_V_MF8_MF4_MASK,
  PseudoVSUXSEG3EI8_V_MF8_MF8,
  PseudoVSUXSEG3EI8_V_MF8_MF8_MASK,
  PseudoVSUXSEG4EI16_V_M1_M1,
  PseudoVSUXSEG4EI16_V_M1_M1_MASK,
  PseudoVSUXSEG4EI16_V_M1_M2,
  PseudoVSUXSEG4EI16_V_M1_M2_MASK,
  PseudoVSUXSEG4EI16_V_M1_MF2,
  PseudoVSUXSEG4EI16_V_M1_MF2_MASK,
  PseudoVSUXSEG4EI16_V_M2_M1,
  PseudoVSUXSEG4EI16_V_M2_M1_MASK,
  PseudoVSUXSEG4EI16_V_M2_M2,
  PseudoVSUXSEG4EI16_V_M2_M2_MASK,
  PseudoVSUXSEG4EI16_V_M4_M2,
  PseudoVSUXSEG4EI16_V_M4_M2_MASK,
  PseudoVSUXSEG4EI16_V_MF2_M1,
  PseudoVSUXSEG4EI16_V_MF2_M1_MASK,
  PseudoVSUXSEG4EI16_V_MF2_M2,
  PseudoVSUXSEG4EI16_V_MF2_M2_MASK,
  PseudoVSUXSEG4EI16_V_MF2_MF2,
  PseudoVSUXSEG4EI16_V_MF2_MF2_MASK,
  PseudoVSUXSEG4EI16_V_MF2_MF4,
  PseudoVSUXSEG4EI16_V_MF2_MF4_MASK,
  PseudoVSUXSEG4EI16_V_MF4_M1,
  PseudoVSUXSEG4EI16_V_MF4_M1_MASK,
  PseudoVSUXSEG4EI16_V_MF4_MF2,
  PseudoVSUXSEG4EI16_V_MF4_MF2_MASK,
  PseudoVSUXSEG4EI16_V_MF4_MF4,
  PseudoVSUXSEG4EI16_V_MF4_MF4_MASK,
  PseudoVSUXSEG4EI16_V_MF4_MF8,
  PseudoVSUXSEG4EI16_V_MF4_MF8_MASK,
  PseudoVSUXSEG4EI32_V_M1_M1,
  PseudoVSUXSEG4EI32_V_M1_M1_MASK,
  PseudoVSUXSEG4EI32_V_M1_M2,
  PseudoVSUXSEG4EI32_V_M1_M2_MASK,
  PseudoVSUXSEG4EI32_V_M1_MF2,
  PseudoVSUXSEG4EI32_V_M1_MF2_MASK,
  PseudoVSUXSEG4EI32_V_M1_MF4,
  PseudoVSUXSEG4EI32_V_M1_MF4_MASK,
  PseudoVSUXSEG4EI32_V_M2_M1,
  PseudoVSUXSEG4EI32_V_M2_M1_MASK,
  PseudoVSUXSEG4EI32_V_M2_M2,
  PseudoVSUXSEG4EI32_V_M2_M2_MASK,
  PseudoVSUXSEG4EI32_V_M2_MF2,
  PseudoVSUXSEG4EI32_V_M2_MF2_MASK,
  PseudoVSUXSEG4EI32_V_M4_M1,
  PseudoVSUXSEG4EI32_V_M4_M1_MASK,
  PseudoVSUXSEG4EI32_V_M4_M2,
  PseudoVSUXSEG4EI32_V_M4_M2_MASK,
  PseudoVSUXSEG4EI32_V_M8_M2,
  PseudoVSUXSEG4EI32_V_M8_M2_MASK,
  PseudoVSUXSEG4EI32_V_MF2_M1,
  PseudoVSUXSEG4EI32_V_MF2_M1_MASK,
  PseudoVSUXSEG4EI32_V_MF2_MF2,
  PseudoVSUXSEG4EI32_V_MF2_MF2_MASK,
  PseudoVSUXSEG4EI32_V_MF2_MF4,
  PseudoVSUXSEG4EI32_V_MF2_MF4_MASK,
  PseudoVSUXSEG4EI32_V_MF2_MF8,
  PseudoVSUXSEG4EI32_V_MF2_MF8_MASK,
  PseudoVSUXSEG4EI64_V_M1_M1,
  PseudoVSUXSEG4EI64_V_M1_M1_MASK,
  PseudoVSUXSEG4EI64_V_M1_MF2,
  PseudoVSUXSEG4EI64_V_M1_MF2_MASK,
  PseudoVSUXSEG4EI64_V_M1_MF4,
  PseudoVSUXSEG4EI64_V_M1_MF4_MASK,
  PseudoVSUXSEG4EI64_V_M1_MF8,
  PseudoVSUXSEG4EI64_V_M1_MF8_MASK,
  PseudoVSUXSEG4EI64_V_M2_M1,
  PseudoVSUXSEG4EI64_V_M2_M1_MASK,
  PseudoVSUXSEG4EI64_V_M2_M2,
  PseudoVSUXSEG4EI64_V_M2_M2_MASK,
  PseudoVSUXSEG4EI64_V_M2_MF2,
  PseudoVSUXSEG4EI64_V_M2_MF2_MASK,
  PseudoVSUXSEG4EI64_V_M2_MF4,
  PseudoVSUXSEG4EI64_V_M2_MF4_MASK,
  PseudoVSUXSEG4EI64_V_M4_M1,
  PseudoVSUXSEG4EI64_V_M4_M1_MASK,
  PseudoVSUXSEG4EI64_V_M4_M2,
  PseudoVSUXSEG4EI64_V_M4_M2_MASK,
  PseudoVSUXSEG4EI64_V_M4_MF2,
  PseudoVSUXSEG4EI64_V_M4_MF2_MASK,
  PseudoVSUXSEG4EI64_V_M8_M1,
  PseudoVSUXSEG4EI64_V_M8_M1_MASK,
  PseudoVSUXSEG4EI64_V_M8_M2,
  PseudoVSUXSEG4EI64_V_M8_M2_MASK,
  PseudoVSUXSEG4EI8_V_M1_M1,
  PseudoVSUXSEG4EI8_V_M1_M1_MASK,
  PseudoVSUXSEG4EI8_V_M1_M2,
  PseudoVSUXSEG4EI8_V_M1_M2_MASK,
  PseudoVSUXSEG4EI8_V_M2_M2,
  PseudoVSUXSEG4EI8_V_M2_M2_MASK,
  PseudoVSUXSEG4EI8_V_MF2_M1,
  PseudoVSUXSEG4EI8_V_MF2_M1_MASK,
  PseudoVSUXSEG4EI8_V_MF2_M2,
  PseudoVSUXSEG4EI8_V_MF2_M2_MASK,
  PseudoVSUXSEG4EI8_V_MF2_MF2,
  PseudoVSUXSEG4EI8_V_MF2_MF2_MASK,
  PseudoVSUXSEG4EI8_V_MF4_M1,
  PseudoVSUXSEG4EI8_V_MF4_M1_MASK,
  PseudoVSUXSEG4EI8_V_MF4_M2,
  PseudoVSUXSEG4EI8_V_MF4_M2_MASK,
  PseudoVSUXSEG4EI8_V_MF4_MF2,
  PseudoVSUXSEG4EI8_V_MF4_MF2_MASK,
  PseudoVSUXSEG4EI8_V_MF4_MF4,
  PseudoVSUXSEG4EI8_V_MF4_MF4_MASK,
  PseudoVSUXSEG4EI8_V_MF8_M1,
  PseudoVSUXSEG4EI8_V_MF8_M1_MASK,
  PseudoVSUXSEG4EI8_V_MF8_MF2,
  PseudoVSUXSEG4EI8_V_MF8_MF2_MASK,
  PseudoVSUXSEG4EI8_V_MF8_MF4,
  PseudoVSUXSEG4EI8_V_MF8_MF4_MASK,
  PseudoVSUXSEG4EI8_V_MF8_MF8,
  PseudoVSUXSEG4EI8_V_MF8_MF8_MASK,
  PseudoVSUXSEG5EI16_V_M1_M1,
  PseudoVSUXSEG5EI16_V_M1_M1_MASK,
  PseudoVSUXSEG5EI16_V_M1_MF2,
  PseudoVSUXSEG5EI16_V_M1_MF2_MASK,
  PseudoVSUXSEG5EI16_V_M2_M1,
  PseudoVSUXSEG5EI16_V_M2_M1_MASK,
  PseudoVSUXSEG5EI16_V_MF2_M1,
  PseudoVSUXSEG5EI16_V_MF2_M1_MASK,
  PseudoVSUXSEG5EI16_V_MF2_MF2,
  PseudoVSUXSEG5EI16_V_MF2_MF2_MASK,
  PseudoVSUXSEG5EI16_V_MF2_MF4,
  PseudoVSUXSEG5EI16_V_MF2_MF4_MASK,
  PseudoVSUXSEG5EI16_V_MF4_M1,
  PseudoVSUXSEG5EI16_V_MF4_M1_MASK,
  PseudoVSUXSEG5EI16_V_MF4_MF2,
  PseudoVSUXSEG5EI16_V_MF4_MF2_MASK,
  PseudoVSUXSEG5EI16_V_MF4_MF4,
  PseudoVSUXSEG5EI16_V_MF4_MF4_MASK,
  PseudoVSUXSEG5EI16_V_MF4_MF8,
  PseudoVSUXSEG5EI16_V_MF4_MF8_MASK,
  PseudoVSUXSEG5EI32_V_M1_M1,
  PseudoVSUXSEG5EI32_V_M1_M1_MASK,
  PseudoVSUXSEG5EI32_V_M1_MF2,
  PseudoVSUXSEG5EI32_V_M1_MF2_MASK,
  PseudoVSUXSEG5EI32_V_M1_MF4,
  PseudoVSUXSEG5EI32_V_M1_MF4_MASK,
  PseudoVSUXSEG5EI32_V_M2_M1,
  PseudoVSUXSEG5EI32_V_M2_M1_MASK,
  PseudoVSUXSEG5EI32_V_M2_MF2,
  PseudoVSUXSEG5EI32_V_M2_MF2_MASK,
  PseudoVSUXSEG5EI32_V_M4_M1,
  PseudoVSUXSEG5EI32_V_M4_M1_MASK,
  PseudoVSUXSEG5EI32_V_MF2_M1,
  PseudoVSUXSEG5EI32_V_MF2_M1_MASK,
  PseudoVSUXSEG5EI32_V_MF2_MF2,
  PseudoVSUXSEG5EI32_V_MF2_MF2_MASK,
  PseudoVSUXSEG5EI32_V_MF2_MF4,
  PseudoVSUXSEG5EI32_V_MF2_MF4_MASK,
  PseudoVSUXSEG5EI32_V_MF2_MF8,
  PseudoVSUXSEG5EI32_V_MF2_MF8_MASK,
  PseudoVSUXSEG5EI64_V_M1_M1,
  PseudoVSUXSEG5EI64_V_M1_M1_MASK,
  PseudoVSUXSEG5EI64_V_M1_MF2,
  PseudoVSUXSEG5EI64_V_M1_MF2_MASK,
  PseudoVSUXSEG5EI64_V_M1_MF4,
  PseudoVSUXSEG5EI64_V_M1_MF4_MASK,
  PseudoVSUXSEG5EI64_V_M1_MF8,
  PseudoVSUXSEG5EI64_V_M1_MF8_MASK,
  PseudoVSUXSEG5EI64_V_M2_M1,
  PseudoVSUXSEG5EI64_V_M2_M1_MASK,
  PseudoVSUXSEG5EI64_V_M2_MF2,
  PseudoVSUXSEG5EI64_V_M2_MF2_MASK,
  PseudoVSUXSEG5EI64_V_M2_MF4,
  PseudoVSUXSEG5EI64_V_M2_MF4_MASK,
  PseudoVSUXSEG5EI64_V_M4_M1,
  PseudoVSUXSEG5EI64_V_M4_M1_MASK,
  PseudoVSUXSEG5EI64_V_M4_MF2,
  PseudoVSUXSEG5EI64_V_M4_MF2_MASK,
  PseudoVSUXSEG5EI64_V_M8_M1,
  PseudoVSUXSEG5EI64_V_M8_M1_MASK,
  PseudoVSUXSEG5EI8_V_M1_M1,
  PseudoVSUXSEG5EI8_V_M1_M1_MASK,
  PseudoVSUXSEG5EI8_V_MF2_M1,
  PseudoVSUXSEG5EI8_V_MF2_M1_MASK,
  PseudoVSUXSEG5EI8_V_MF2_MF2,
  PseudoVSUXSEG5EI8_V_MF2_MF2_MASK,
  PseudoVSUXSEG5EI8_V_MF4_M1,
  PseudoVSUXSEG5EI8_V_MF4_M1_MASK,
  PseudoVSUXSEG5EI8_V_MF4_MF2,
  PseudoVSUXSEG5EI8_V_MF4_MF2_MASK,
  PseudoVSUXSEG5EI8_V_MF4_MF4,
  PseudoVSUXSEG5EI8_V_MF4_MF4_MASK,
  PseudoVSUXSEG5EI8_V_MF8_M1,
  PseudoVSUXSEG5EI8_V_MF8_M1_MASK,
  PseudoVSUXSEG5EI8_V_MF8_MF2,
  PseudoVSUXSEG5EI8_V_MF8_MF2_MASK,
  PseudoVSUXSEG5EI8_V_MF8_MF4,
  PseudoVSUXSEG5EI8_V_MF8_MF4_MASK,
  PseudoVSUXSEG5EI8_V_MF8_MF8,
  PseudoVSUXSEG5EI8_V_MF8_MF8_MASK,
  PseudoVSUXSEG6EI16_V_M1_M1,
  PseudoVSUXSEG6EI16_V_M1_M1_MASK,
  PseudoVSUXSEG6EI16_V_M1_MF2,
  PseudoVSUXSEG6EI16_V_M1_MF2_MASK,
  PseudoVSUXSEG6EI16_V_M2_M1,
  PseudoVSUXSEG6EI16_V_M2_M1_MASK,
  PseudoVSUXSEG6EI16_V_MF2_M1,
  PseudoVSUXSEG6EI16_V_MF2_M1_MASK,
  PseudoVSUXSEG6EI16_V_MF2_MF2,
  PseudoVSUXSEG6EI16_V_MF2_MF2_MASK,
  PseudoVSUXSEG6EI16_V_MF2_MF4,
  PseudoVSUXSEG6EI16_V_MF2_MF4_MASK,
  PseudoVSUXSEG6EI16_V_MF4_M1,
  PseudoVSUXSEG6EI16_V_MF4_M1_MASK,
  PseudoVSUXSEG6EI16_V_MF4_MF2,
  PseudoVSUXSEG6EI16_V_MF4_MF2_MASK,
  PseudoVSUXSEG6EI16_V_MF4_MF4,
  PseudoVSUXSEG6EI16_V_MF4_MF4_MASK,
  PseudoVSUXSEG6EI16_V_MF4_MF8,
  PseudoVSUXSEG6EI16_V_MF4_MF8_MASK,
  PseudoVSUXSEG6EI32_V_M1_M1,
  PseudoVSUXSEG6EI32_V_M1_M1_MASK,
  PseudoVSUXSEG6EI32_V_M1_MF2,
  PseudoVSUXSEG6EI32_V_M1_MF2_MASK,
  PseudoVSUXSEG6EI32_V_M1_MF4,
  PseudoVSUXSEG6EI32_V_M1_MF4_MASK,
  PseudoVSUXSEG6EI32_V_M2_M1,
  PseudoVSUXSEG6EI32_V_M2_M1_MASK,
  PseudoVSUXSEG6EI32_V_M2_MF2,
  PseudoVSUXSEG6EI32_V_M2_MF2_MASK,
  PseudoVSUXSEG6EI32_V_M4_M1,
  PseudoVSUXSEG6EI32_V_M4_M1_MASK,
  PseudoVSUXSEG6EI32_V_MF2_M1,
  PseudoVSUXSEG6EI32_V_MF2_M1_MASK,
  PseudoVSUXSEG6EI32_V_MF2_MF2,
  PseudoVSUXSEG6EI32_V_MF2_MF2_MASK,
  PseudoVSUXSEG6EI32_V_MF2_MF4,
  PseudoVSUXSEG6EI32_V_MF2_MF4_MASK,
  PseudoVSUXSEG6EI32_V_MF2_MF8,
  PseudoVSUXSEG6EI32_V_MF2_MF8_MASK,
  PseudoVSUXSEG6EI64_V_M1_M1,
  PseudoVSUXSEG6EI64_V_M1_M1_MASK,
  PseudoVSUXSEG6EI64_V_M1_MF2,
  PseudoVSUXSEG6EI64_V_M1_MF2_MASK,
  PseudoVSUXSEG6EI64_V_M1_MF4,
  PseudoVSUXSEG6EI64_V_M1_MF4_MASK,
  PseudoVSUXSEG6EI64_V_M1_MF8,
  PseudoVSUXSEG6EI64_V_M1_MF8_MASK,
  PseudoVSUXSEG6EI64_V_M2_M1,
  PseudoVSUXSEG6EI64_V_M2_M1_MASK,
  PseudoVSUXSEG6EI64_V_M2_MF2,
  PseudoVSUXSEG6EI64_V_M2_MF2_MASK,
  PseudoVSUXSEG6EI64_V_M2_MF4,
  PseudoVSUXSEG6EI64_V_M2_MF4_MASK,
  PseudoVSUXSEG6EI64_V_M4_M1,
  PseudoVSUXSEG6EI64_V_M4_M1_MASK,
  PseudoVSUXSEG6EI64_V_M4_MF2,
  PseudoVSUXSEG6EI64_V_M4_MF2_MASK,
  PseudoVSUXSEG6EI64_V_M8_M1,
  PseudoVSUXSEG6EI64_V_M8_M1_MASK,
  PseudoVSUXSEG6EI8_V_M1_M1,
  PseudoVSUXSEG6EI8_V_M1_M1_MASK,
  PseudoVSUXSEG6EI8_V_MF2_M1,
  PseudoVSUXSEG6EI8_V_MF2_M1_MASK,
  PseudoVSUXSEG6EI8_V_MF2_MF2,
  PseudoVSUXSEG6EI8_V_MF2_MF2_MASK,
  PseudoVSUXSEG6EI8_V_MF4_M1,
  PseudoVSUXSEG6EI8_V_MF4_M1_MASK,
  PseudoVSUXSEG6EI8_V_MF4_MF2,
  PseudoVSUXSEG6EI8_V_MF4_MF2_MASK,
  PseudoVSUXSEG6EI8_V_MF4_MF4,
  PseudoVSUXSEG6EI8_V_MF4_MF4_MASK,
  PseudoVSUXSEG6EI8_V_MF8_M1,
  PseudoVSUXSEG6EI8_V_MF8_M1_MASK,
  PseudoVSUXSEG6EI8_V_MF8_MF2,
  PseudoVSUXSEG6EI8_V_MF8_MF2_MASK,
  PseudoVSUXSEG6EI8_V_MF8_MF4,
  PseudoVSUXSEG6EI8_V_MF8_MF4_MASK,
  PseudoVSUXSEG6EI8_V_MF8_MF8,
  PseudoVSUXSEG6EI8_V_MF8_MF8_MASK,
  PseudoVSUXSEG7EI16_V_M1_M1,
  PseudoVSUXSEG7EI16_V_M1_M1_MASK,
  PseudoVSUXSEG7EI16_V_M1_MF2,
  PseudoVSUXSEG7EI16_V_M1_MF2_MASK,
  PseudoVSUXSEG7EI16_V_M2_M1,
  PseudoVSUXSEG7EI16_V_M2_M1_MASK,
  PseudoVSUXSEG7EI16_V_MF2_M1,
  PseudoVSUXSEG7EI16_V_MF2_M1_MASK,
  PseudoVSUXSEG7EI16_V_MF2_MF2,
  PseudoVSUXSEG7EI16_V_MF2_MF2_MASK,
  PseudoVSUXSEG7EI16_V_MF2_MF4,
  PseudoVSUXSEG7EI16_V_MF2_MF4_MASK,
  PseudoVSUXSEG7EI16_V_MF4_M1,
  PseudoVSUXSEG7EI16_V_MF4_M1_MASK,
  PseudoVSUXSEG7EI16_V_MF4_MF2,
  PseudoVSUXSEG7EI16_V_MF4_MF2_MASK,
  PseudoVSUXSEG7EI16_V_MF4_MF4,
  PseudoVSUXSEG7EI16_V_MF4_MF4_MASK,
  PseudoVSUXSEG7EI16_V_MF4_MF8,
  PseudoVSUXSEG7EI16_V_MF4_MF8_MASK,
  PseudoVSUXSEG7EI32_V_M1_M1,
  PseudoVSUXSEG7EI32_V_M1_M1_MASK,
  PseudoVSUXSEG7EI32_V_M1_MF2,
  PseudoVSUXSEG7EI32_V_M1_MF2_MASK,
  PseudoVSUXSEG7EI32_V_M1_MF4,
  PseudoVSUXSEG7EI32_V_M1_MF4_MASK,
  PseudoVSUXSEG7EI32_V_M2_M1,
  PseudoVSUXSEG7EI32_V_M2_M1_MASK,
  PseudoVSUXSEG7EI32_V_M2_MF2,
  PseudoVSUXSEG7EI32_V_M2_MF2_MASK,
  PseudoVSUXSEG7EI32_V_M4_M1,
  PseudoVSUXSEG7EI32_V_M4_M1_MASK,
  PseudoVSUXSEG7EI32_V_MF2_M1,
  PseudoVSUXSEG7EI32_V_MF2_M1_MASK,
  PseudoVSUXSEG7EI32_V_MF2_MF2,
  PseudoVSUXSEG7EI32_V_MF2_MF2_MASK,
  PseudoVSUXSEG7EI32_V_MF2_MF4,
  PseudoVSUXSEG7EI32_V_MF2_MF4_MASK,
  PseudoVSUXSEG7EI32_V_MF2_MF8,
  PseudoVSUXSEG7EI32_V_MF2_MF8_MASK,
  PseudoVSUXSEG7EI64_V_M1_M1,
  PseudoVSUXSEG7EI64_V_M1_M1_MASK,
  PseudoVSUXSEG7EI64_V_M1_MF2,
  PseudoVSUXSEG7EI64_V_M1_MF2_MASK,
  PseudoVSUXSEG7EI64_V_M1_MF4,
  PseudoVSUXSEG7EI64_V_M1_MF4_MASK,
  PseudoVSUXSEG7EI64_V_M1_MF8,
  PseudoVSUXSEG7EI64_V_M1_MF8_MASK,
  PseudoVSUXSEG7EI64_V_M2_M1,
  PseudoVSUXSEG7EI64_V_M2_M1_MASK,
  PseudoVSUXSEG7EI64_V_M2_MF2,
  PseudoVSUXSEG7EI64_V_M2_MF2_MASK,
  PseudoVSUXSEG7EI64_V_M2_MF4,
  PseudoVSUXSEG7EI64_V_M2_MF4_MASK,
  PseudoVSUXSEG7EI64_V_M4_M1,
  PseudoVSUXSEG7EI64_V_M4_M1_MASK,
  PseudoVSUXSEG7EI64_V_M4_MF2,
  PseudoVSUXSEG7EI64_V_M4_MF2_MASK,
  PseudoVSUXSEG7EI64_V_M8_M1,
  PseudoVSUXSEG7EI64_V_M8_M1_MASK,
  PseudoVSUXSEG7EI8_V_M1_M1,
  PseudoVSUXSEG7EI8_V_M1_M1_MASK,
  PseudoVSUXSEG7EI8_V_MF2_M1,
  PseudoVSUXSEG7EI8_V_MF2_M1_MASK,
  PseudoVSUXSEG7EI8_V_MF2_MF2,
  PseudoVSUXSEG7EI8_V_MF2_MF2_MASK,
  PseudoVSUXSEG7EI8_V_MF4_M1,
  PseudoVSUXSEG7EI8_V_MF4_M1_MASK,
  PseudoVSUXSEG7EI8_V_MF4_MF2,
  PseudoVSUXSEG7EI8_V_MF4_MF2_MASK,
  PseudoVSUXSEG7EI8_V_MF4_MF4,
  PseudoVSUXSEG7EI8_V_MF4_MF4_MASK,
  PseudoVSUXSEG7EI8_V_MF8_M1,
  PseudoVSUXSEG7EI8_V_MF8_M1_MASK,
  PseudoVSUXSEG7EI8_V_MF8_MF2,
  PseudoVSUXSEG7EI8_V_MF8_MF2_MASK,
  PseudoVSUXSEG7EI8_V_MF8_MF4,
  PseudoVSUXSEG7EI8_V_MF8_MF4_MASK,
  PseudoVSUXSEG7EI8_V_MF8_MF8,
  PseudoVSUXSEG7EI8_V_MF8_MF8_MASK,
  PseudoVSUXSEG8EI16_V_M1_M1,
  PseudoVSUXSEG8EI16_V_M1_M1_MASK,
  PseudoVSUXSEG8EI16_V_M1_MF2,
  PseudoVSUXSEG8EI16_V_M1_MF2_MASK,
  PseudoVSUXSEG8EI16_V_M2_M1,
  PseudoVSUXSEG8EI16_V_M2_M1_MASK,
  PseudoVSUXSEG8EI16_V_MF2_M1,
  PseudoVSUXSEG8EI16_V_MF2_M1_MASK,
  PseudoVSUXSEG8EI16_V_MF2_MF2,
  PseudoVSUXSEG8EI16_V_MF2_MF2_MASK,
  PseudoVSUXSEG8EI16_V_MF2_MF4,
  PseudoVSUXSEG8EI16_V_MF2_MF4_MASK,
  PseudoVSUXSEG8EI16_V_MF4_M1,
  PseudoVSUXSEG8EI16_V_MF4_M1_MASK,
  PseudoVSUXSEG8EI16_V_MF4_MF2,
  PseudoVSUXSEG8EI16_V_MF4_MF2_MASK,
  PseudoVSUXSEG8EI16_V_MF4_MF4,
  PseudoVSUXSEG8EI16_V_MF4_MF4_MASK,
  PseudoVSUXSEG8EI16_V_MF4_MF8,
  PseudoVSUXSEG8EI16_V_MF4_MF8_MASK,
  PseudoVSUXSEG8EI32_V_M1_M1,
  PseudoVSUXSEG8EI32_V_M1_M1_MASK,
  PseudoVSUXSEG8EI32_V_M1_MF2,
  PseudoVSUXSEG8EI32_V_M1_MF2_MASK,
  PseudoVSUXSEG8EI32_V_M1_MF4,
  PseudoVSUXSEG8EI32_V_M1_MF4_MASK,
  PseudoVSUXSEG8EI32_V_M2_M1,
  PseudoVSUXSEG8EI32_V_M2_M1_MASK,
  PseudoVSUXSEG8EI32_V_M2_MF2,
  PseudoVSUXSEG8EI32_V_M2_MF2_MASK,
  PseudoVSUXSEG8EI32_V_M4_M1,
  PseudoVSUXSEG8EI32_V_M4_M1_MASK,
  PseudoVSUXSEG8EI32_V_MF2_M1,
  PseudoVSUXSEG8EI32_V_MF2_M1_MASK,
  PseudoVSUXSEG8EI32_V_MF2_MF2,
  PseudoVSUXSEG8EI32_V_MF2_MF2_MASK,
  PseudoVSUXSEG8EI32_V_MF2_MF4,
  PseudoVSUXSEG8EI32_V_MF2_MF4_MASK,
  PseudoVSUXSEG8EI32_V_MF2_MF8,
  PseudoVSUXSEG8EI32_V_MF2_MF8_MASK,
  PseudoVSUXSEG8EI64_V_M1_M1,
  PseudoVSUXSEG8EI64_V_M1_M1_MASK,
  PseudoVSUXSEG8EI64_V_M1_MF2,
  PseudoVSUXSEG8EI64_V_M1_MF2_MASK,
  PseudoVSUXSEG8EI64_V_M1_MF4,
  PseudoVSUXSEG8EI64_V_M1_MF4_MASK,
  PseudoVSUXSEG8EI64_V_M1_MF8,
  PseudoVSUXSEG8EI64_V_M1_MF8_MASK,
  PseudoVSUXSEG8EI64_V_M2_M1,
  PseudoVSUXSEG8EI64_V_M2_M1_MASK,
  PseudoVSUXSEG8EI64_V_M2_MF2,
  PseudoVSUXSEG8EI64_V_M2_MF2_MASK,
  PseudoVSUXSEG8EI64_V_M2_MF4,
  PseudoVSUXSEG8EI64_V_M2_MF4_MASK,
  PseudoVSUXSEG8EI64_V_M4_M1,
  PseudoVSUXSEG8EI64_V_M4_M1_MASK,
  PseudoVSUXSEG8EI64_V_M4_MF2,
  PseudoVSUXSEG8EI64_V_M4_MF2_MASK,
  PseudoVSUXSEG8EI64_V_M8_M1,
  PseudoVSUXSEG8EI64_V_M8_M1_MASK,
  PseudoVSUXSEG8EI8_V_M1_M1,
  PseudoVSUXSEG8EI8_V_M1_M1_MASK,
  PseudoVSUXSEG8EI8_V_MF2_M1,
  PseudoVSUXSEG8EI8_V_MF2_M1_MASK,
  PseudoVSUXSEG8EI8_V_MF2_MF2,
  PseudoVSUXSEG8EI8_V_MF2_MF2_MASK,
  PseudoVSUXSEG8EI8_V_MF4_M1,
  PseudoVSUXSEG8EI8_V_MF4_M1_MASK,
  PseudoVSUXSEG8EI8_V_MF4_MF2,
  PseudoVSUXSEG8EI8_V_MF4_MF2_MASK,
  PseudoVSUXSEG8EI8_V_MF4_MF4,
  PseudoVSUXSEG8EI8_V_MF4_MF4_MASK,
  PseudoVSUXSEG8EI8_V_MF8_M1,
  PseudoVSUXSEG8EI8_V_MF8_M1_MASK,
  PseudoVSUXSEG8EI8_V_MF8_MF2,
  PseudoVSUXSEG8EI8_V_MF8_MF2_MASK,
  PseudoVSUXSEG8EI8_V_MF8_MF4,
  PseudoVSUXSEG8EI8_V_MF8_MF4_MASK,
  PseudoVSUXSEG8EI8_V_MF8_MF8,
  PseudoVSUXSEG8EI8_V_MF8_MF8_MASK,
  PseudoVWADDU_VV_M1,
  PseudoVWADDU_VV_M1_MASK,
  PseudoVWADDU_VV_M2,
  PseudoVWADDU_VV_M2_MASK,
  PseudoVWADDU_VV_M4,
  PseudoVWADDU_VV_M4_MASK,
  PseudoVWADDU_VV_MF2,
  PseudoVWADDU_VV_MF2_MASK,
  PseudoVWADDU_VV_MF4,
  PseudoVWADDU_VV_MF4_MASK,
  PseudoVWADDU_VV_MF8,
  PseudoVWADDU_VV_MF8_MASK,
  PseudoVWADDU_VX_M1,
  PseudoVWADDU_VX_M1_MASK,
  PseudoVWADDU_VX_M2,
  PseudoVWADDU_VX_M2_MASK,
  PseudoVWADDU_VX_M4,
  PseudoVWADDU_VX_M4_MASK,
  PseudoVWADDU_VX_MF2,
  PseudoVWADDU_VX_MF2_MASK,
  PseudoVWADDU_VX_MF4,
  PseudoVWADDU_VX_MF4_MASK,
  PseudoVWADDU_VX_MF8,
  PseudoVWADDU_VX_MF8_MASK,
  PseudoVWADDU_WV_M1,
  PseudoVWADDU_WV_M1_MASK,
  PseudoVWADDU_WV_M1_MASK_TIED,
  PseudoVWADDU_WV_M1_TIED,
  PseudoVWADDU_WV_M2,
  PseudoVWADDU_WV_M2_MASK,
  PseudoVWADDU_WV_M2_MASK_TIED,
  PseudoVWADDU_WV_M2_TIED,
  PseudoVWADDU_WV_M4,
  PseudoVWADDU_WV_M4_MASK,
  PseudoVWADDU_WV_M4_MASK_TIED,
  PseudoVWADDU_WV_M4_TIED,
  PseudoVWADDU_WV_MF2,
  PseudoVWADDU_WV_MF2_MASK,
  PseudoVWADDU_WV_MF2_MASK_TIED,
  PseudoVWADDU_WV_MF2_TIED,
  PseudoVWADDU_WV_MF4,
  PseudoVWADDU_WV_MF4_MASK,
  PseudoVWADDU_WV_MF4_MASK_TIED,
  PseudoVWADDU_WV_MF4_TIED,
  PseudoVWADDU_WV_MF8,
  PseudoVWADDU_WV_MF8_MASK,
  PseudoVWADDU_WV_MF8_MASK_TIED,
  PseudoVWADDU_WV_MF8_TIED,
  PseudoVWADDU_WX_M1,
  PseudoVWADDU_WX_M1_MASK,
  PseudoVWADDU_WX_M2,
  PseudoVWADDU_WX_M2_MASK,
  PseudoVWADDU_WX_M4,
  PseudoVWADDU_WX_M4_MASK,
  PseudoVWADDU_WX_MF2,
  PseudoVWADDU_WX_MF2_MASK,
  PseudoVWADDU_WX_MF4,
  PseudoVWADDU_WX_MF4_MASK,
  PseudoVWADDU_WX_MF8,
  PseudoVWADDU_WX_MF8_MASK,
  PseudoVWADD_VV_M1,
  PseudoVWADD_VV_M1_MASK,
  PseudoVWADD_VV_M2,
  PseudoVWADD_VV_M2_MASK,
  PseudoVWADD_VV_M4,
  PseudoVWADD_VV_M4_MASK,
  PseudoVWADD_VV_MF2,
  PseudoVWADD_VV_MF2_MASK,
  PseudoVWADD_VV_MF4,
  PseudoVWADD_VV_MF4_MASK,
  PseudoVWADD_VV_MF8,
  PseudoVWADD_VV_MF8_MASK,
  PseudoVWADD_VX_M1,
  PseudoVWADD_VX_M1_MASK,
  PseudoVWADD_VX_M2,
  PseudoVWADD_VX_M2_MASK,
  PseudoVWADD_VX_M4,
  PseudoVWADD_VX_M4_MASK,
  PseudoVWADD_VX_MF2,
  PseudoVWADD_VX_MF2_MASK,
  PseudoVWADD_VX_MF4,
  PseudoVWADD_VX_MF4_MASK,
  PseudoVWADD_VX_MF8,
  PseudoVWADD_VX_MF8_MASK,
  PseudoVWADD_WV_M1,
  PseudoVWADD_WV_M1_MASK,
  PseudoVWADD_WV_M1_MASK_TIED,
  PseudoVWADD_WV_M1_TIED,
  PseudoVWADD_WV_M2,
  PseudoVWADD_WV_M2_MASK,
  PseudoVWADD_WV_M2_MASK_TIED,
  PseudoVWADD_WV_M2_TIED,
  PseudoVWADD_WV_M4,
  PseudoVWADD_WV_M4_MASK,
  PseudoVWADD_WV_M4_MASK_TIED,
  PseudoVWADD_WV_M4_TIED,
  PseudoVWADD_WV_MF2,
  PseudoVWADD_WV_MF2_MASK,
  PseudoVWADD_WV_MF2_MASK_TIED,
  PseudoVWADD_WV_MF2_TIED,
  PseudoVWADD_WV_MF4,
  PseudoVWADD_WV_MF4_MASK,
  PseudoVWADD_WV_MF4_MASK_TIED,
  PseudoVWADD_WV_MF4_TIED,
  PseudoVWADD_WV_MF8,
  PseudoVWADD_WV_MF8_MASK,
  PseudoVWADD_WV_MF8_MASK_TIED,
  PseudoVWADD_WV_MF8_TIED,
  PseudoVWADD_WX_M1,
  PseudoVWADD_WX_M1_MASK,
  PseudoVWADD_WX_M2,
  PseudoVWADD_WX_M2_MASK,
  PseudoVWADD_WX_M4,
  PseudoVWADD_WX_M4_MASK,
  PseudoVWADD_WX_MF2,
  PseudoVWADD_WX_MF2_MASK,
  PseudoVWADD_WX_MF4,
  PseudoVWADD_WX_MF4_MASK,
  PseudoVWADD_WX_MF8,
  PseudoVWADD_WX_MF8_MASK,
  PseudoVWMACCSU_VV_M1,
  PseudoVWMACCSU_VV_M1_MASK,
  PseudoVWMACCSU_VV_M2,
  PseudoVWMACCSU_VV_M2_MASK,
  PseudoVWMACCSU_VV_M4,
  PseudoVWMACCSU_VV_M4_MASK,
  PseudoVWMACCSU_VV_MF2,
  PseudoVWMACCSU_VV_MF2_MASK,
  PseudoVWMACCSU_VV_MF4,
  PseudoVWMACCSU_VV_MF4_MASK,
  PseudoVWMACCSU_VV_MF8,
  PseudoVWMACCSU_VV_MF8_MASK,
  PseudoVWMACCSU_VX_M1,
  PseudoVWMACCSU_VX_M1_MASK,
  PseudoVWMACCSU_VX_M2,
  PseudoVWMACCSU_VX_M2_MASK,
  PseudoVWMACCSU_VX_M4,
  PseudoVWMACCSU_VX_M4_MASK,
  PseudoVWMACCSU_VX_MF2,
  PseudoVWMACCSU_VX_MF2_MASK,
  PseudoVWMACCSU_VX_MF4,
  PseudoVWMACCSU_VX_MF4_MASK,
  PseudoVWMACCSU_VX_MF8,
  PseudoVWMACCSU_VX_MF8_MASK,
  PseudoVWMACCUS_VX_M1,
  PseudoVWMACCUS_VX_M1_MASK,
  PseudoVWMACCUS_VX_M2,
  PseudoVWMACCUS_VX_M2_MASK,
  PseudoVWMACCUS_VX_M4,
  PseudoVWMACCUS_VX_M4_MASK,
  PseudoVWMACCUS_VX_MF2,
  PseudoVWMACCUS_VX_MF2_MASK,
  PseudoVWMACCUS_VX_MF4,
  PseudoVWMACCUS_VX_MF4_MASK,
  PseudoVWMACCUS_VX_MF8,
  PseudoVWMACCUS_VX_MF8_MASK,
  PseudoVWMACCU_VV_M1,
  PseudoVWMACCU_VV_M1_MASK,
  PseudoVWMACCU_VV_M2,
  PseudoVWMACCU_VV_M2_MASK,
  PseudoVWMACCU_VV_M4,
  PseudoVWMACCU_VV_M4_MASK,
  PseudoVWMACCU_VV_MF2,
  PseudoVWMACCU_VV_MF2_MASK,
  PseudoVWMACCU_VV_MF4,
  PseudoVWMACCU_VV_MF4_MASK,
  PseudoVWMACCU_VV_MF8,
  PseudoVWMACCU_VV_MF8_MASK,
  PseudoVWMACCU_VX_M1,
  PseudoVWMACCU_VX_M1_MASK,
  PseudoVWMACCU_VX_M2,
  PseudoVWMACCU_VX_M2_MASK,
  PseudoVWMACCU_VX_M4,
  PseudoVWMACCU_VX_M4_MASK,
  PseudoVWMACCU_VX_MF2,
  PseudoVWMACCU_VX_MF2_MASK,
  PseudoVWMACCU_VX_MF4,
  PseudoVWMACCU_VX_MF4_MASK,
  PseudoVWMACCU_VX_MF8,
  PseudoVWMACCU_VX_MF8_MASK,
  PseudoVWMACC_VV_M1,
  PseudoVWMACC_VV_M1_MASK,
  PseudoVWMACC_VV_M2,
  PseudoVWMACC_VV_M2_MASK,
  PseudoVWMACC_VV_M4,
  PseudoVWMACC_VV_M4_MASK,
  PseudoVWMACC_VV_MF2,
  PseudoVWMACC_VV_MF2_MASK,
  PseudoVWMACC_VV_MF4,
  PseudoVWMACC_VV_MF4_MASK,
  PseudoVWMACC_VV_MF8,
  PseudoVWMACC_VV_MF8_MASK,
  PseudoVWMACC_VX_M1,
  PseudoVWMACC_VX_M1_MASK,
  PseudoVWMACC_VX_M2,
  PseudoVWMACC_VX_M2_MASK,
  PseudoVWMACC_VX_M4,
  PseudoVWMACC_VX_M4_MASK,
  PseudoVWMACC_VX_MF2,
  PseudoVWMACC_VX_MF2_MASK,
  PseudoVWMACC_VX_MF4,
  PseudoVWMACC_VX_MF4_MASK,
  PseudoVWMACC_VX_MF8,
  PseudoVWMACC_VX_MF8_MASK,
  PseudoVWMULSU_VV_M1,
  PseudoVWMULSU_VV_M1_MASK,
  PseudoVWMULSU_VV_M2,
  PseudoVWMULSU_VV_M2_MASK,
  PseudoVWMULSU_VV_M4,
  PseudoVWMULSU_VV_M4_MASK,
  PseudoVWMULSU_VV_MF2,
  PseudoVWMULSU_VV_MF2_MASK,
  PseudoVWMULSU_VV_MF4,
  PseudoVWMULSU_VV_MF4_MASK,
  PseudoVWMULSU_VV_MF8,
  PseudoVWMULSU_VV_MF8_MASK,
  PseudoVWMULSU_VX_M1,
  PseudoVWMULSU_VX_M1_MASK,
  PseudoVWMULSU_VX_M2,
  PseudoVWMULSU_VX_M2_MASK,
  PseudoVWMULSU_VX_M4,
  PseudoVWMULSU_VX_M4_MASK,
  PseudoVWMULSU_VX_MF2,
  PseudoVWMULSU_VX_MF2_MASK,
  PseudoVWMULSU_VX_MF4,
  PseudoVWMULSU_VX_MF4_MASK,
  PseudoVWMULSU_VX_MF8,
  PseudoVWMULSU_VX_MF8_MASK,
  PseudoVWMULU_VV_M1,
  PseudoVWMULU_VV_M1_MASK,
  PseudoVWMULU_VV_M2,
  PseudoVWMULU_VV_M2_MASK,
  PseudoVWMULU_VV_M4,
  PseudoVWMULU_VV_M4_MASK,
  PseudoVWMULU_VV_MF2,
  PseudoVWMULU_VV_MF2_MASK,
  PseudoVWMULU_VV_MF4,
  PseudoVWMULU_VV_MF4_MASK,
  PseudoVWMULU_VV_MF8,
  PseudoVWMULU_VV_MF8_MASK,
  PseudoVWMULU_VX_M1,
  PseudoVWMULU_VX_M1_MASK,
  PseudoVWMULU_VX_M2,
  PseudoVWMULU_VX_M2_MASK,
  PseudoVWMULU_VX_M4,
  PseudoVWMULU_VX_M4_MASK,
  PseudoVWMULU_VX_MF2,
  PseudoVWMULU_VX_MF2_MASK,
  PseudoVWMULU_VX_MF4,
  PseudoVWMULU_VX_MF4_MASK,
  PseudoVWMULU_VX_MF8,
  PseudoVWMULU_VX_MF8_MASK,
  PseudoVWMUL_VV_M1,
  PseudoVWMUL_VV_M1_MASK,
  PseudoVWMUL_VV_M2,
  PseudoVWMUL_VV_M2_MASK,
  PseudoVWMUL_VV_M4,
  PseudoVWMUL_VV_M4_MASK,
  PseudoVWMUL_VV_MF2,
  PseudoVWMUL_VV_MF2_MASK,
  PseudoVWMUL_VV_MF4,
  PseudoVWMUL_VV_MF4_MASK,
  PseudoVWMUL_VV_MF8,
  PseudoVWMUL_VV_MF8_MASK,
  PseudoVWMUL_VX_M1,
  PseudoVWMUL_VX_M1_MASK,
  PseudoVWMUL_VX_M2,
  PseudoVWMUL_VX_M2_MASK,
  PseudoVWMUL_VX_M4,
  PseudoVWMUL_VX_M4_MASK,
  PseudoVWMUL_VX_MF2,
  PseudoVWMUL_VX_MF2_MASK,
  PseudoVWMUL_VX_MF4,
  PseudoVWMUL_VX_MF4_MASK,
  PseudoVWMUL_VX_MF8,
  PseudoVWMUL_VX_MF8_MASK,
  PseudoVWREDSUMU_VS_M1_E16,
  PseudoVWREDSUMU_VS_M1_E16_MASK,
  PseudoVWREDSUMU_VS_M1_E32,
  PseudoVWREDSUMU_VS_M1_E32_MASK,
  PseudoVWREDSUMU_VS_M1_E8,
  PseudoVWREDSUMU_VS_M1_E8_MASK,
  PseudoVWREDSUMU_VS_M2_E16,
  PseudoVWREDSUMU_VS_M2_E16_MASK,
  PseudoVWREDSUMU_VS_M2_E32,
  PseudoVWREDSUMU_VS_M2_E32_MASK,
  PseudoVWREDSUMU_VS_M2_E8,
  PseudoVWREDSUMU_VS_M2_E8_MASK,
  PseudoVWREDSUMU_VS_M4_E16,
  PseudoVWREDSUMU_VS_M4_E16_MASK,
  PseudoVWREDSUMU_VS_M4_E32,
  PseudoVWREDSUMU_VS_M4_E32_MASK,
  PseudoVWREDSUMU_VS_M4_E8,
  PseudoVWREDSUMU_VS_M4_E8_MASK,
  PseudoVWREDSUMU_VS_M8_E16,
  PseudoVWREDSUMU_VS_M8_E16_MASK,
  PseudoVWREDSUMU_VS_M8_E32,
  PseudoVWREDSUMU_VS_M8_E32_MASK,
  PseudoVWREDSUMU_VS_M8_E8,
  PseudoVWREDSUMU_VS_M8_E8_MASK,
  PseudoVWREDSUMU_VS_MF2_E16,
  PseudoVWREDSUMU_VS_MF2_E16_MASK,
  PseudoVWREDSUMU_VS_MF2_E32,
  PseudoVWREDSUMU_VS_MF2_E32_MASK,
  PseudoVWREDSUMU_VS_MF2_E8,
  PseudoVWREDSUMU_VS_MF2_E8_MASK,
  PseudoVWREDSUMU_VS_MF4_E16,
  PseudoVWREDSUMU_VS_MF4_E16_MASK,
  PseudoVWREDSUMU_VS_MF4_E8,
  PseudoVWREDSUMU_VS_MF4_E8_MASK,
  PseudoVWREDSUMU_VS_MF8_E8,
  PseudoVWREDSUMU_VS_MF8_E8_MASK,
  PseudoVWREDSUM_VS_M1_E16,
  PseudoVWREDSUM_VS_M1_E16_MASK,
  PseudoVWREDSUM_VS_M1_E32,
  PseudoVWREDSUM_VS_M1_E32_MASK,
  PseudoVWREDSUM_VS_M1_E8,
  PseudoVWREDSUM_VS_M1_E8_MASK,
  PseudoVWREDSUM_VS_M2_E16,
  PseudoVWREDSUM_VS_M2_E16_MASK,
  PseudoVWREDSUM_VS_M2_E32,
  PseudoVWREDSUM_VS_M2_E32_MASK,
  PseudoVWREDSUM_VS_M2_E8,
  PseudoVWREDSUM_VS_M2_E8_MASK,
  PseudoVWREDSUM_VS_M4_E16,
  PseudoVWREDSUM_VS_M4_E16_MASK,
  PseudoVWREDSUM_VS_M4_E32,
  PseudoVWREDSUM_VS_M4_E32_MASK,
  PseudoVWREDSUM_VS_M4_E8,
  PseudoVWREDSUM_VS_M4_E8_MASK,
  PseudoVWREDSUM_VS_M8_E16,
  PseudoVWREDSUM_VS_M8_E16_MASK,
  PseudoVWREDSUM_VS_M8_E32,
  PseudoVWREDSUM_VS_M8_E32_MASK,
  PseudoVWREDSUM_VS_M8_E8,
  PseudoVWREDSUM_VS_M8_E8_MASK,
  PseudoVWREDSUM_VS_MF2_E16,
  PseudoVWREDSUM_VS_MF2_E16_MASK,
  PseudoVWREDSUM_VS_MF2_E32,
  PseudoVWREDSUM_VS_MF2_E32_MASK,
  PseudoVWREDSUM_VS_MF2_E8,
  PseudoVWREDSUM_VS_MF2_E8_MASK,
  PseudoVWREDSUM_VS_MF4_E16,
  PseudoVWREDSUM_VS_MF4_E16_MASK,
  PseudoVWREDSUM_VS_MF4_E8,
  PseudoVWREDSUM_VS_MF4_E8_MASK,
  PseudoVWREDSUM_VS_MF8_E8,
  PseudoVWREDSUM_VS_MF8_E8_MASK,
  PseudoVWSLL_VI_M1,
  PseudoVWSLL_VI_M1_MASK,
  PseudoVWSLL_VI_M2,
  PseudoVWSLL_VI_M2_MASK,
  PseudoVWSLL_VI_M4,
  PseudoVWSLL_VI_M4_MASK,
  PseudoVWSLL_VI_MF2,
  PseudoVWSLL_VI_MF2_MASK,
  PseudoVWSLL_VI_MF4,
  PseudoVWSLL_VI_MF4_MASK,
  PseudoVWSLL_VI_MF8,
  PseudoVWSLL_VI_MF8_MASK,
  PseudoVWSLL_VV_M1,
  PseudoVWSLL_VV_M1_MASK,
  PseudoVWSLL_VV_M2,
  PseudoVWSLL_VV_M2_MASK,
  PseudoVWSLL_VV_M4,
  PseudoVWSLL_VV_M4_MASK,
  PseudoVWSLL_VV_MF2,
  PseudoVWSLL_VV_MF2_MASK,
  PseudoVWSLL_VV_MF4,
  PseudoVWSLL_VV_MF4_MASK,
  PseudoVWSLL_VV_MF8,
  PseudoVWSLL_VV_MF8_MASK,
  PseudoVWSLL_VX_M1,
  PseudoVWSLL_VX_M1_MASK,
  PseudoVWSLL_VX_M2,
  PseudoVWSLL_VX_M2_MASK,
  PseudoVWSLL_VX_M4,
  PseudoVWSLL_VX_M4_MASK,
  PseudoVWSLL_VX_MF2,
  PseudoVWSLL_VX_MF2_MASK,
  PseudoVWSLL_VX_MF4,
  PseudoVWSLL_VX_MF4_MASK,
  PseudoVWSLL_VX_MF8,
  PseudoVWSLL_VX_MF8_MASK,
  PseudoVWSUBU_VV_M1,
  PseudoVWSUBU_VV_M1_MASK,
  PseudoVWSUBU_VV_M2,
  PseudoVWSUBU_VV_M2_MASK,
  PseudoVWSUBU_VV_M4,
  PseudoVWSUBU_VV_M4_MASK,
  PseudoVWSUBU_VV_MF2,
  PseudoVWSUBU_VV_MF2_MASK,
  PseudoVWSUBU_VV_MF4,
  PseudoVWSUBU_VV_MF4_MASK,
  PseudoVWSUBU_VV_MF8,
  PseudoVWSUBU_VV_MF8_MASK,
  PseudoVWSUBU_VX_M1,
  PseudoVWSUBU_VX_M1_MASK,
  PseudoVWSUBU_VX_M2,
  PseudoVWSUBU_VX_M2_MASK,
  PseudoVWSUBU_VX_M4,
  PseudoVWSUBU_VX_M4_MASK,
  PseudoVWSUBU_VX_MF2,
  PseudoVWSUBU_VX_MF2_MASK,
  PseudoVWSUBU_VX_MF4,
  PseudoVWSUBU_VX_MF4_MASK,
  PseudoVWSUBU_VX_MF8,
  PseudoVWSUBU_VX_MF8_MASK,
  PseudoVWSUBU_WV_M1,
  PseudoVWSUBU_WV_M1_MASK,
  PseudoVWSUBU_WV_M1_MASK_TIED,
  PseudoVWSUBU_WV_M1_TIED,
  PseudoVWSUBU_WV_M2,
  PseudoVWSUBU_WV_M2_MASK,
  PseudoVWSUBU_WV_M2_MASK_TIED,
  PseudoVWSUBU_WV_M2_TIED,
  PseudoVWSUBU_WV_M4,
  PseudoVWSUBU_WV_M4_MASK,
  PseudoVWSUBU_WV_M4_MASK_TIED,
  PseudoVWSUBU_WV_M4_TIED,
  PseudoVWSUBU_WV_MF2,
  PseudoVWSUBU_WV_MF2_MASK,
  PseudoVWSUBU_WV_MF2_MASK_TIED,
  PseudoVWSUBU_WV_MF2_TIED,
  PseudoVWSUBU_WV_MF4,
  PseudoVWSUBU_WV_MF4_MASK,
  PseudoVWSUBU_WV_MF4_MASK_TIED,
  PseudoVWSUBU_WV_MF4_TIED,
  PseudoVWSUBU_WV_MF8,
  PseudoVWSUBU_WV_MF8_MASK,
  PseudoVWSUBU_WV_MF8_MASK_TIED,
  PseudoVWSUBU_WV_MF8_TIED,
  PseudoVWSUBU_WX_M1,
  PseudoVWSUBU_WX_M1_MASK,
  PseudoVWSUBU_WX_M2,
  PseudoVWSUBU_WX_M2_MASK,
  PseudoVWSUBU_WX_M4,
  PseudoVWSUBU_WX_M4_MASK,
  PseudoVWSUBU_WX_MF2,
  PseudoVWSUBU_WX_MF2_MASK,
  PseudoVWSUBU_WX_MF4,
  PseudoVWSUBU_WX_MF4_MASK,
  PseudoVWSUBU_WX_MF8,
  PseudoVWSUBU_WX_MF8_MASK,
  PseudoVWSUB_VV_M1,
  PseudoVWSUB_VV_M1_MASK,
  PseudoVWSUB_VV_M2,
  PseudoVWSUB_VV_M2_MASK,
  PseudoVWSUB_VV_M4,
  PseudoVWSUB_VV_M4_MASK,
  PseudoVWSUB_VV_MF2,
  PseudoVWSUB_VV_MF2_MASK,
  PseudoVWSUB_VV_MF4,
  PseudoVWSUB_VV_MF4_MASK,
  PseudoVWSUB_VV_MF8,
  PseudoVWSUB_VV_MF8_MASK,
  PseudoVWSUB_VX_M1,
  PseudoVWSUB_VX_M1_MASK,
  PseudoVWSUB_VX_M2,
  PseudoVWSUB_VX_M2_MASK,
  PseudoVWSUB_VX_M4,
  PseudoVWSUB_VX_M4_MASK,
  PseudoVWSUB_VX_MF2,
  PseudoVWSUB_VX_MF2_MASK,
  PseudoVWSUB_VX_MF4,
  PseudoVWSUB_VX_MF4_MASK,
  PseudoVWSUB_VX_MF8,
  PseudoVWSUB_VX_MF8_MASK,
  PseudoVWSUB_WV_M1,
  PseudoVWSUB_WV_M1_MASK,
  PseudoVWSUB_WV_M1_MASK_TIED,
  PseudoVWSUB_WV_M1_TIED,
  PseudoVWSUB_WV_M2,
  PseudoVWSUB_WV_M2_MASK,
  PseudoVWSUB_WV_M2_MASK_TIED,
  PseudoVWSUB_WV_M2_TIED,
  PseudoVWSUB_WV_M4,
  PseudoVWSUB_WV_M4_MASK,
  PseudoVWSUB_WV_M4_MASK_TIED,
  PseudoVWSUB_WV_M4_TIED,
  PseudoVWSUB_WV_MF2,
  PseudoVWSUB_WV_MF2_MASK,
  PseudoVWSUB_WV_MF2_MASK_TIED,
  PseudoVWSUB_WV_MF2_TIED,
  PseudoVWSUB_WV_MF4,
  PseudoVWSUB_WV_MF4_MASK,
  PseudoVWSUB_WV_MF4_MASK_TIED,
  PseudoVWSUB_WV_MF4_TIED,
  PseudoVWSUB_WV_MF8,
  PseudoVWSUB_WV_MF8_MASK,
  PseudoVWSUB_WV_MF8_MASK_TIED,
  PseudoVWSUB_WV_MF8_TIED,
  PseudoVWSUB_WX_M1,
  PseudoVWSUB_WX_M1_MASK,
  PseudoVWSUB_WX_M2,
  PseudoVWSUB_WX_M2_MASK,
  PseudoVWSUB_WX_M4,
  PseudoVWSUB_WX_M4_MASK,
  PseudoVWSUB_WX_MF2,
  PseudoVWSUB_WX_MF2_MASK,
  PseudoVWSUB_WX_MF4,
  PseudoVWSUB_WX_MF4_MASK,
  PseudoVWSUB_WX_MF8,
  PseudoVWSUB_WX_MF8_MASK,
  PseudoVXOR_VI_M1,
  PseudoVXOR_VI_M1_MASK,
  PseudoVXOR_VI_M2,
  PseudoVXOR_VI_M2_MASK,
  PseudoVXOR_VI_M4,
  PseudoVXOR_VI_M4_MASK,
  PseudoVXOR_VI_M8,
  PseudoVXOR_VI_M8_MASK,
  PseudoVXOR_VI_MF2,
  PseudoVXOR_VI_MF2_MASK,
  PseudoVXOR_VI_MF4,
  PseudoVXOR_VI_MF4_MASK,
  PseudoVXOR_VI_MF8,
  PseudoVXOR_VI_MF8_MASK,
  PseudoVXOR_VV_M1,
  PseudoVXOR_VV_M1_MASK,
  PseudoVXOR_VV_M2,
  PseudoVXOR_VV_M2_MASK,
  PseudoVXOR_VV_M4,
  PseudoVXOR_VV_M4_MASK,
  PseudoVXOR_VV_M8,
  PseudoVXOR_VV_M8_MASK,
  PseudoVXOR_VV_MF2,
  PseudoVXOR_VV_MF2_MASK,
  PseudoVXOR_VV_MF4,
  PseudoVXOR_VV_MF4_MASK,
  PseudoVXOR_VV_MF8,
  PseudoVXOR_VV_MF8_MASK,
  PseudoVXOR_VX_M1,
  PseudoVXOR_VX_M1_MASK,
  PseudoVXOR_VX_M2,
  PseudoVXOR_VX_M2_MASK,
  PseudoVXOR_VX_M4,
  PseudoVXOR_VX_M4_MASK,
  PseudoVXOR_VX_M8,
  PseudoVXOR_VX_M8_MASK,
  PseudoVXOR_VX_MF2,
  PseudoVXOR_VX_MF2_MASK,
  PseudoVXOR_VX_MF4,
  PseudoVXOR_VX_MF4_MASK,
  PseudoVXOR_VX_MF8,
  PseudoVXOR_VX_MF8_MASK,
  PseudoVZEXT_VF2_M1,
  PseudoVZEXT_VF2_M1_MASK,
  PseudoVZEXT_VF2_M2,
  PseudoVZEXT_VF2_M2_MASK,
  PseudoVZEXT_VF2_M4,
  PseudoVZEXT_VF2_M4_MASK,
  PseudoVZEXT_VF2_M8,
  PseudoVZEXT_VF2_M8_MASK,
  PseudoVZEXT_VF2_MF2,
  PseudoVZEXT_VF2_MF2_MASK,
  PseudoVZEXT_VF2_MF4,
  PseudoVZEXT_VF2_MF4_MASK,
  PseudoVZEXT_VF4_M1,
  PseudoVZEXT_VF4_M1_MASK,
  PseudoVZEXT_VF4_M2,
  PseudoVZEXT_VF4_M2_MASK,
  PseudoVZEXT_VF4_M4,
  PseudoVZEXT_VF4_M4_MASK,
  PseudoVZEXT_VF4_M8,
  PseudoVZEXT_VF4_M8_MASK,
  PseudoVZEXT_VF4_MF2,
  PseudoVZEXT_VF4_MF2_MASK,
  PseudoVZEXT_VF8_M1,
  PseudoVZEXT_VF8_M1_MASK,
  PseudoVZEXT_VF8_M2,
  PseudoVZEXT_VF8_M2_MASK,
  PseudoVZEXT_VF8_M4,
  PseudoVZEXT_VF8_M4_MASK,
  PseudoVZEXT_VF8_M8,
  PseudoVZEXT_VF8_M8_MASK,
  PseudoZEXT_H,
  PseudoZEXT_W,
  ReadCounterWide,
  ReadFFLAGS,
  ReadFRM,
  Select_FPR16INX_Using_CC_GPR,
  Select_FPR16_Using_CC_GPR,
  Select_FPR32INX_Using_CC_GPR,
  Select_FPR32_Using_CC_GPR,
  Select_FPR64IN32X_Using_CC_GPR,
  Select_FPR64INX_Using_CC_GPR,
  Select_FPR64_Using_CC_GPR,
  Select_GPR_Using_CC_GPR,
  Select_GPR_Using_CC_Imm,
  SplitF64Pseudo,
  SwapFRMImm,
  WriteFFLAGS,
  WriteFRM,
  WriteFRMImm,
  WriteVXRMImm,
  ADD,
  ADDI,
  ADDIW,
  ADDW,
  ADD_UW,
  AES32DSI,
  AES32DSMI,
  AES32ESI,
  AES32ESMI,
  AES64DS,
  AES64DSM,
  AES64ES,
  AES64ESM,
  AES64IM,
  AES64KS1I,
  AES64KS2,
  AMOADD_B,
  AMOADD_B_AQ,
  AMOADD_B_AQ_RL,
  AMOADD_B_RL,
  AMOADD_D,
  AMOADD_D_AQ,
  AMOADD_D_AQ_RL,
  AMOADD_D_RL,
  AMOADD_H,
  AMOADD_H_AQ,
  AMOADD_H_AQ_RL,
  AMOADD_H_RL,
  AMOADD_W,
  AMOADD_W_AQ,
  AMOADD_W_AQ_RL,
  AMOADD_W_RL,
  AMOAND_B,
  AMOAND_B_AQ,
  AMOAND_B_AQ_RL,
  AMOAND_B_RL,
  AMOAND_D,
  AMOAND_D_AQ,
  AMOAND_D_AQ_RL,
  AMOAND_D_RL,
  AMOAND_H,
  AMOAND_H_AQ,
  AMOAND_H_AQ_RL,
  AMOAND_H_RL,
  AMOAND_W,
  AMOAND_W_AQ,
  AMOAND_W_AQ_RL,
  AMOAND_W_RL,
  AMOCAS_B,
  AMOCAS_B_AQ,
  AMOCAS_B_AQ_RL,
  AMOCAS_B_RL,
  AMOCAS_D_RV32,
  AMOCAS_D_RV32_AQ,
  AMOCAS_D_RV32_AQ_RL,
  AMOCAS_D_RV32_RL,
  AMOCAS_D_RV64,
  AMOCAS_D_RV64_AQ,
  AMOCAS_D_RV64_AQ_RL,
  AMOCAS_D_RV64_RL,
  AMOCAS_H,
  AMOCAS_H_AQ,
  AMOCAS_H_AQ_RL,
  AMOCAS_H_RL,
  AMOCAS_Q,
  AMOCAS_Q_AQ,
  AMOCAS_Q_AQ_RL,
  AMOCAS_Q_RL,
  AMOCAS_W,
  AMOCAS_W_AQ,
  AMOCAS_W_AQ_RL,
  AMOCAS_W_RL,
  AMOMAXU_B,
  AMOMAXU_B_AQ,
  AMOMAXU_B_AQ_RL,
  AMOMAXU_B_RL,
  AMOMAXU_D,
  AMOMAXU_D_AQ,
  AMOMAXU_D_AQ_RL,
  AMOMAXU_D_RL,
  AMOMAXU_H,
  AMOMAXU_H_AQ,
  AMOMAXU_H_AQ_RL,
  AMOMAXU_H_RL,
  AMOMAXU_W,
  AMOMAXU_W_AQ,
  AMOMAXU_W_AQ_RL,
  AMOMAXU_W_RL,
  AMOMAX_B,
  AMOMAX_B_AQ,
  AMOMAX_B_AQ_RL,
  AMOMAX_B_RL,
  AMOMAX_D,
  AMOMAX_D_AQ,
  AMOMAX_D_AQ_RL,
  AMOMAX_D_RL,
  AMOMAX_H,
  AMOMAX_H_AQ,
  AMOMAX_H_AQ_RL,
  AMOMAX_H_RL,
  AMOMAX_W,
  AMOMAX_W_AQ,
  AMOMAX_W_AQ_RL,
  AMOMAX_W_RL,
  AMOMINU_B,
  AMOMINU_B_AQ,
  AMOMINU_B_AQ_RL,
  AMOMINU_B_RL,
  AMOMINU_D,
  AMOMINU_D_AQ,
  AMOMINU_D_AQ_RL,
  AMOMINU_D_RL,
  AMOMINU_H,
  AMOMINU_H_AQ,
  AMOMINU_H_AQ_RL,
  AMOMINU_H_RL,
  AMOMINU_W,
  AMOMINU_W_AQ,
  AMOMINU_W_AQ_RL,
  AMOMINU_W_RL,
  AMOMIN_B,
  AMOMIN_B_AQ,
  AMOMIN_B_AQ_RL,
  AMOMIN_B_RL,
  AMOMIN_D,
  AMOMIN_D_AQ,
  AMOMIN_D_AQ_RL,
  AMOMIN_D_RL,
  AMOMIN_H,
  AMOMIN_H_AQ,
  AMOMIN_H_AQ_RL,
  AMOMIN_H_RL,
  AMOMIN_W,
  AMOMIN_W_AQ,
  AMOMIN_W_AQ_RL,
  AMOMIN_W_RL,
  AMOOR_B,
  AMOOR_B_AQ,
  AMOOR_B_AQ_RL,
  AMOOR_B_RL,
  AMOOR_D,
  AMOOR_D_AQ,
  AMOOR_D_AQ_RL,
  AMOOR_D_RL,
  AMOOR_H,
  AMOOR_H_AQ,
  AMOOR_H_AQ_RL,
  AMOOR_H_RL,
  AMOOR_W,
  AMOOR_W_AQ,
  AMOOR_W_AQ_RL,
  AMOOR_W_RL,
  AMOSWAP_B,
  AMOSWAP_B_AQ,
  AMOSWAP_B_AQ_RL,
  AMOSWAP_B_RL,
  AMOSWAP_D,
  AMOSWAP_D_AQ,
  AMOSWAP_D_AQ_RL,
  AMOSWAP_D_RL,
  AMOSWAP_H,
  AMOSWAP_H_AQ,
  AMOSWAP_H_AQ_RL,
  AMOSWAP_H_RL,
  AMOSWAP_W,
  AMOSWAP_W_AQ,
  AMOSWAP_W_AQ_RL,
  AMOSWAP_W_RL,
  AMOXOR_B,
  AMOXOR_B_AQ,
  AMOXOR_B_AQ_RL,
  AMOXOR_B_RL,
  AMOXOR_D,
  AMOXOR_D_AQ,
  AMOXOR_D_AQ_RL,
  AMOXOR_D_RL,
  AMOXOR_H,
  AMOXOR_H_AQ,
  AMOXOR_H_AQ_RL,
  AMOXOR_H_RL,
  AMOXOR_W,
  AMOXOR_W_AQ,
  AMOXOR_W_AQ_RL,
  AMOXOR_W_RL,
  AND,
  ANDI,
  ANDN,
  AUIPC,
  BCLR,
  BCLRI,
  BEQ,
  BEXT,
  BEXTI,
  BGE,
  BGEU,
  BINV,
  BINVI,
  BLT,
  BLTU,
  BNE,
  BREV8,
  BSET,
  BSETI,
  CBO_CLEAN,
  CBO_FLUSH,
  CBO_INVAL,
  CBO_ZERO,
  CLMUL,
  CLMULH,
  CLMULR,
  CLZ,
  CLZW,
  CM_JALT,
  CM_JT,
  CM_MVA01S,
  CM_MVSA01,
  CM_POP,
  CM_POPRET,
  CM_POPRETZ,
  CM_PUSH,
  CPOP,
  CPOPW,
  CSRRC,
  CSRRCI,
  CSRRS,
  CSRRSI,
  CSRRW,
  CSRRWI,
  CTZ,
  CTZW,
  CV_ABS,
  CV_ABS_B,
  CV_ABS_H,
  CV_ADDN,
  CV_ADDNR,
  CV_ADDRN,
  CV_ADDRNR,
  CV_ADDUN,
  CV_ADDUNR,
  CV_ADDURN,
  CV_ADDURNR,
  CV_ADD_B,
  CV_ADD_DIV2,
  CV_ADD_DIV4,
  CV_ADD_DIV8,
  CV_ADD_H,
  CV_ADD_SCI_B,
  CV_ADD_SCI_H,
  CV_ADD_SC_B,
  CV_ADD_SC_H,
  CV_AND_B,
  CV_AND_H,
  CV_AND_SCI_B,
  CV_AND_SCI_H,
  CV_AND_SC_B,
  CV_AND_SC_H,
  CV_AVGU_B,
  CV_AVGU_H,
  CV_AVGU_SCI_B,
  CV_AVGU_SCI_H,
  CV_AVGU_SC_B,
  CV_AVGU_SC_H,
  CV_AVG_B,
  CV_AVG_H,
  CV_AVG_SCI_B,
  CV_AVG_SCI_H,
  CV_AVG_SC_B,
  CV_AVG_SC_H,
  CV_BCLR,
  CV_BCLRR,
  CV_BEQIMM,
  CV_BITREV,
  CV_BNEIMM,
  CV_BSET,
  CV_BSETR,
  CV_CLB,
  CV_CLIP,
  CV_CLIPR,
  CV_CLIPU,
  CV_CLIPUR,
  CV_CMPEQ_B,
  CV_CMPEQ_H,
  CV_CMPEQ_SCI_B,
  CV_CMPEQ_SCI_H,
  CV_CMPEQ_SC_B,
  CV_CMPEQ_SC_H,
  CV_CMPGEU_B,
  CV_CMPGEU_H,
  CV_CMPGEU_SCI_B,
  CV_CMPGEU_SCI_H,
  CV_CMPGEU_SC_B,
  CV_CMPGEU_SC_H,
  CV_CMPGE_B,
  CV_CMPGE_H,
  CV_CMPGE_SCI_B,
  CV_CMPGE_SCI_H,
  CV_CMPGE_SC_B,
  CV_CMPGE_SC_H,
  CV_CMPGTU_B,
  CV_CMPGTU_H,
  CV_CMPGTU_SCI_B,
  CV_CMPGTU_SCI_H,
  CV_CMPGTU_SC_B,
  CV_CMPGTU_SC_H,
  CV_CMPGT_B,
  CV_CMPGT_H,
  CV_CMPGT_SCI_B,
  CV_CMPGT_SCI_H,
  CV_CMPGT_SC_B,
  CV_CMPGT_SC_H,
  CV_CMPLEU_B,
  CV_CMPLEU_H,
  CV_CMPLEU_SCI_B,
  CV_CMPLEU_SCI_H,
  CV_CMPLEU_SC_B,
  CV_CMPLEU_SC_H,
  CV_CMPLE_B,
  CV_CMPLE_H,
  CV_CMPLE_SCI_B,
  CV_CMPLE_SCI_H,
  CV_CMPLE_SC_B,
  CV_CMPLE_SC_H,
  CV_CMPLTU_B,
  CV_CMPLTU_H,
  CV_CMPLTU_SCI_B,
  CV_CMPLTU_SCI_H,
  CV_CMPLTU_SC_B,
  CV_CMPLTU_SC_H,
  CV_CMPLT_B,
  CV_CMPLT_H,
  CV_CMPLT_SCI_B,
  CV_CMPLT_SCI_H,
  CV_CMPLT_SC_B,
  CV_CMPLT_SC_H,
  CV_CMPNE_B,
  CV_CMPNE_H,
  CV_CMPNE_SCI_B,
  CV_CMPNE_SCI_H,
  CV_CMPNE_SC_B,
  CV_CMPNE_SC_H,
  CV_CNT,
  CV_CPLXCONJ,
  CV_CPLXMUL_I,
  CV_CPLXMUL_I_DIV2,
  CV_CPLXMUL_I_DIV4,
  CV_CPLXMUL_I_DIV8,
  CV_CPLXMUL_R,
  CV_CPLXMUL_R_DIV2,
  CV_CPLXMUL_R_DIV4,
  CV_CPLXMUL_R_DIV8,
  CV_DOTSP_B,
  CV_DOTSP_H,
  CV_DOTSP_SCI_B,
  CV_DOTSP_SCI_H,
  CV_DOTSP_SC_B,
  CV_DOTSP_SC_H,
  CV_DOTUP_B,
  CV_DOTUP_H,
  CV_DOTUP_SCI_B,
  CV_DOTUP_SCI_H,
  CV_DOTUP_SC_B,
  CV_DOTUP_SC_H,
  CV_DOTUSP_B,
  CV_DOTUSP_H,
  CV_DOTUSP_SCI_B,
  CV_DOTUSP_SCI_H,
  CV_DOTUSP_SC_B,
  CV_DOTUSP_SC_H,
  CV_ELW,
  CV_EXTBS,
  CV_EXTBZ,
  CV_EXTHS,
  CV_EXTHZ,
  CV_EXTRACT,
  CV_EXTRACTR,
  CV_EXTRACTU,
  CV_EXTRACTUR,
  CV_EXTRACTU_B,
  CV_EXTRACTU_H,
  CV_EXTRACT_B,
  CV_EXTRACT_H,
  CV_FF1,
  CV_FL1,
  CV_INSERT,
  CV_INSERTR,
  CV_INSERT_B,
  CV_INSERT_H,
  CV_LBU_ri_inc,
  CV_LBU_rr,
  CV_LBU_rr_inc,
  CV_LB_ri_inc,
  CV_LB_rr,
  CV_LB_rr_inc,
  CV_LHU_ri_inc,
  CV_LHU_rr,
  CV_LHU_rr_inc,
  CV_LH_ri_inc,
  CV_LH_rr,
  CV_LH_rr_inc,
  CV_LW_ri_inc,
  CV_LW_rr,
  CV_LW_rr_inc,
  CV_MAC,
  CV_MACHHSN,
  CV_MACHHSRN,
  CV_MACHHUN,
  CV_MACHHURN,
  CV_MACSN,
  CV_MACSRN,
  CV_MACUN,
  CV_MACURN,
  CV_MAX,
  CV_MAXU,
  CV_MAXU_B,
  CV_MAXU_H,
  CV_MAXU_SCI_B,
  CV_MAXU_SCI_H,
  CV_MAXU_SC_B,
  CV_MAXU_SC_H,
  CV_MAX_B,
  CV_MAX_H,
  CV_MAX_SCI_B,
  CV_MAX_SCI_H,
  CV_MAX_SC_B,
  CV_MAX_SC_H,
  CV_MIN,
  CV_MINU,
  CV_MINU_B,
  CV_MINU_H,
  CV_MINU_SCI_B,
  CV_MINU_SCI_H,
  CV_MINU_SC_B,
  CV_MINU_SC_H,
  CV_MIN_B,
  CV_MIN_H,
  CV_MIN_SCI_B,
  CV_MIN_SCI_H,
  CV_MIN_SC_B,
  CV_MIN_SC_H,
  CV_MSU,
  CV_MULHHSN,
  CV_MULHHSRN,
  CV_MULHHUN,
  CV_MULHHURN,
  CV_MULSN,
  CV_MULSRN,
  CV_MULUN,
  CV_MULURN,
  CV_OR_B,
  CV_OR_H,
  CV_OR_SCI_B,
  CV_OR_SCI_H,
  CV_OR_SC_B,
  CV_OR_SC_H,
  CV_PACK,
  CV_PACKHI_B,
  CV_PACKLO_B,
  CV_PACK_H,
  CV_ROR,
  CV_SB_ri_inc,
  CV_SB_rr,
  CV_SB_rr_inc,
  CV_SDOTSP_B,
  CV_SDOTSP_H,
  CV_SDOTSP_SCI_B,
  CV_SDOTSP_SCI_H,
  CV_SDOTSP_SC_B,
  CV_SDOTSP_SC_H,
  CV_SDOTUP_B,
  CV_SDOTUP_H,
  CV_SDOTUP_SCI_B,
  CV_SDOTUP_SCI_H,
  CV_SDOTUP_SC_B,
  CV_SDOTUP_SC_H,
  CV_SDOTUSP_B,
  CV_SDOTUSP_H,
  CV_SDOTUSP_SCI_B,
  CV_SDOTUSP_SCI_H,
  CV_SDOTUSP_SC_B,
  CV_SDOTUSP_SC_H,
  CV_SHUFFLE2_B,
  CV_SHUFFLE2_H,
  CV_SHUFFLEI0_SCI_B,
  CV_SHUFFLEI1_SCI_B,
  CV_SHUFFLEI2_SCI_B,
  CV_SHUFFLEI3_SCI_B,
  CV_SHUFFLE_B,
  CV_SHUFFLE_H,
  CV_SHUFFLE_SCI_H,
  CV_SH_ri_inc,
  CV_SH_rr,
  CV_SH_rr_inc,
  CV_SLET,
  CV_SLETU,
  CV_SLL_B,
  CV_SLL_H,
  CV_SLL_SCI_B,
  CV_SLL_SCI_H,
  CV_SLL_SC_B,
  CV_SLL_SC_H,
  CV_SRA_B,
  CV_SRA_H,
  CV_SRA_SCI_B,
  CV_SRA_SCI_H,
  CV_SRA_SC_B,
  CV_SRA_SC_H,
  CV_SRL_B,
  CV_SRL_H,
  CV_SRL_SCI_B,
  CV_SRL_SCI_H,
  CV_SRL_SC_B,
  CV_SRL_SC_H,
  CV_SUBN,
  CV_SUBNR,
  CV_SUBRN,
  CV_SUBRNR,
  CV_SUBROTMJ,
  CV_SUBROTMJ_DIV2,
  CV_SUBROTMJ_DIV4,
  CV_SUBROTMJ_DIV8,
  CV_SUBUN,
  CV_SUBUNR,
  CV_SUBURN,
  CV_SUBURNR,
  CV_SUB_B,
  CV_SUB_DIV2,
  CV_SUB_DIV4,
  CV_SUB_DIV8,
  CV_SUB_H,
  CV_SUB_SCI_B,
  CV_SUB_SCI_H,
  CV_SUB_SC_B,
  CV_SUB_SC_H,
  CV_SW_ri_inc,
  CV_SW_rr,
  CV_SW_rr_inc,
  CV_XOR_B,
  CV_XOR_H,
  CV_XOR_SCI_B,
  CV_XOR_SCI_H,
  CV_XOR_SC_B,
  CV_XOR_SC_H,
  CZERO_EQZ,
  CZERO_NEZ,
  C_ADD,
  C_ADDI,
  C_ADDI16SP,
  C_ADDI4SPN,
  C_ADDIW,
  C_ADDI_HINT_IMM_ZERO,
  C_ADDI_NOP,
  C_ADDW,
  C_ADD_HINT,
  C_AND,
  C_ANDI,
  C_BEQZ,
  C_BNEZ,
  C_EBREAK,
  C_FLD,
  C_FLDSP,
  C_FLW,
  C_FLWSP,
  C_FSD,
  C_FSDSP,
  C_FSW,
  C_FSWSP,
  C_J,
  C_JAL,
  C_JALR,
  C_JR,
  C_LBU,
  C_LD,
  C_LDSP,
  C_LH,
  C_LHU,
  C_LI,
  C_LI_HINT,
  C_LUI,
  C_LUI_HINT,
  C_LW,
  C_LWSP,
  C_MOP1,
  C_MOP11,
  C_MOP13,
  C_MOP15,
  C_MOP3,
  C_MOP5,
  C_MOP7,
  C_MOP9,
  C_MUL,
  C_MV,
  C_MV_HINT,
  C_NOP,
  C_NOP_HINT,
  C_NOT,
  C_OR,
  C_SB,
  C_SD,
  C_SDSP,
  C_SEXT_B,
  C_SEXT_H,
  C_SH,
  C_SLLI,
  C_SLLI64_HINT,
  C_SLLI_HINT,
  C_SRAI,
  C_SRAI64_HINT,
  C_SRLI,
  C_SRLI64_HINT,
  C_SSPOPCHK,
  C_SSPUSH,
  C_SUB,
  C_SUBW,
  C_SW,
  C_SWSP,
  C_UNIMP,
  C_XOR,
  C_ZEXT_B,
  C_ZEXT_H,
  C_ZEXT_W,
  DIV,
  DIVU,
  DIVUW,
  DIVW,
  DRET,
  EBREAK,
  ECALL,
  FADD_D,
  FADD_D_IN32X,
  FADD_D_INX,
  FADD_H,
  FADD_H_INX,
  FADD_S,
  FADD_S_INX,
  FCLASS_D,
  FCLASS_D_IN32X,
  FCLASS_D_INX,
  FCLASS_H,
  FCLASS_H_INX,
  FCLASS_S,
  FCLASS_S_INX,
  FCVTMOD_W_D,
  FCVT_BF16_S,
  FCVT_D_H,
  FCVT_D_H_IN32X,
  FCVT_D_H_INX,
  FCVT_D_L,
  FCVT_D_LU,
  FCVT_D_LU_INX,
  FCVT_D_L_INX,
  FCVT_D_S,
  FCVT_D_S_IN32X,
  FCVT_D_S_INX,
  FCVT_D_W,
  FCVT_D_WU,
  FCVT_D_WU_IN32X,
  FCVT_D_WU_INX,
  FCVT_D_W_IN32X,
  FCVT_D_W_INX,
  FCVT_H_D,
  FCVT_H_D_IN32X,
  FCVT_H_D_INX,
  FCVT_H_L,
  FCVT_H_LU,
  FCVT_H_LU_INX,
  FCVT_H_L_INX,
  FCVT_H_S,
  FCVT_H_S_INX,
  FCVT_H_W,
  FCVT_H_WU,
  FCVT_H_WU_INX,
  FCVT_H_W_INX,
  FCVT_LU_D,
  FCVT_LU_D_INX,
  FCVT_LU_H,
  FCVT_LU_H_INX,
  FCVT_LU_S,
  FCVT_LU_S_INX,
  FCVT_L_D,
  FCVT_L_D_INX,
  FCVT_L_H,
  FCVT_L_H_INX,
  FCVT_L_S,
  FCVT_L_S_INX,
  FCVT_S_BF16,
  FCVT_S_D,
  FCVT_S_D_IN32X,
  FCVT_S_D_INX,
  FCVT_S_H,
  FCVT_S_H_INX,
  FCVT_S_L,
  FCVT_S_LU,
  FCVT_S_LU_INX,
  FCVT_S_L_INX,
  FCVT_S_W,
  FCVT_S_WU,
  FCVT_S_WU_INX,
  FCVT_S_W_INX,
  FCVT_WU_D,
  FCVT_WU_D_IN32X,
  FCVT_WU_D_INX,
  FCVT_WU_H,
  FCVT_WU_H_INX,
  FCVT_WU_S,
  FCVT_WU_S_INX,
  FCVT_W_D,
  FCVT_W_D_IN32X,
  FCVT_W_D_INX,
  FCVT_W_H,
  FCVT_W_H_INX,
  FCVT_W_S,
  FCVT_W_S_INX,
  FDIV_D,
  FDIV_D_IN32X,
  FDIV_D_INX,
  FDIV_H,
  FDIV_H_INX,
  FDIV_S,
  FDIV_S_INX,
  FENCE,
  FENCE_I,
  FENCE_TSO,
  FEQ_D,
  FEQ_D_IN32X,
  FEQ_D_INX,
  FEQ_H,
  FEQ_H_INX,
  FEQ_S,
  FEQ_S_INX,
  FLD,
  FLEQ_D,
  FLEQ_H,
  FLEQ_S,
  FLE_D,
  FLE_D_IN32X,
  FLE_D_INX,
  FLE_H,
  FLE_H_INX,
  FLE_S,
  FLE_S_INX,
  FLH,
  FLI_D,
  FLI_H,
  FLI_S,
  FLTQ_D,
  FLTQ_H,
  FLTQ_S,
  FLT_D,
  FLT_D_IN32X,
  FLT_D_INX,
  FLT_H,
  FLT_H_INX,
  FLT_S,
  FLT_S_INX,
  FLW,
  FMADD_D,
  FMADD_D_IN32X,
  FMADD_D_INX,
  FMADD_H,
  FMADD_H_INX,
  FMADD_S,
  FMADD_S_INX,
  FMAXM_D,
  FMAXM_H,
  FMAXM_S,
  FMAX_D,
  FMAX_D_IN32X,
  FMAX_D_INX,
  FMAX_H,
  FMAX_H_INX,
  FMAX_S,
  FMAX_S_INX,
  FMINM_D,
  FMINM_H,
  FMINM_S,
  FMIN_D,
  FMIN_D_IN32X,
  FMIN_D_INX,
  FMIN_H,
  FMIN_H_INX,
  FMIN_S,
  FMIN_S_INX,
  FMSUB_D,
  FMSUB_D_IN32X,
  FMSUB_D_INX,
  FMSUB_H,
  FMSUB_H_INX,
  FMSUB_S,
  FMSUB_S_INX,
  FMUL_D,
  FMUL_D_IN32X,
  FMUL_D_INX,
  FMUL_H,
  FMUL_H_INX,
  FMUL_S,
  FMUL_S_INX,
  FMVH_X_D,
  FMVP_D_X,
  FMV_D_X,
  FMV_H_X,
  FMV_W_X,
  FMV_X_D,
  FMV_X_H,
  FMV_X_W,
  FMV_X_W_FPR64,
  FNMADD_D,
  FNMADD_D_IN32X,
  FNMADD_D_INX,
  FNMADD_H,
  FNMADD_H_INX,
  FNMADD_S,
  FNMADD_S_INX,
  FNMSUB_D,
  FNMSUB_D_IN32X,
  FNMSUB_D_INX,
  FNMSUB_H,
  FNMSUB_H_INX,
  FNMSUB_S,
  FNMSUB_S_INX,
  FROUNDNX_D,
  FROUNDNX_H,
  FROUNDNX_S,
  FROUND_D,
  FROUND_H,
  FROUND_S,
  FSD,
  FSGNJN_D,
  FSGNJN_D_IN32X,
  FSGNJN_D_INX,
  FSGNJN_H,
  FSGNJN_H_INX,
  FSGNJN_S,
  FSGNJN_S_INX,
  FSGNJX_D,
  FSGNJX_D_IN32X,
  FSGNJX_D_INX,
  FSGNJX_H,
  FSGNJX_H_INX,
  FSGNJX_S,
  FSGNJX_S_INX,
  FSGNJ_D,
  FSGNJ_D_IN32X,
  FSGNJ_D_INX,
  FSGNJ_H,
  FSGNJ_H_INX,
  FSGNJ_S,
  FSGNJ_S_INX,
  FSH,
  FSQRT_D,
  FSQRT_D_IN32X,
  FSQRT_D_INX,
  FSQRT_H,
  FSQRT_H_INX,
  FSQRT_S,
  FSQRT_S_INX,
  FSUB_D,
  FSUB_D_IN32X,
  FSUB_D_INX,
  FSUB_H,
  FSUB_H_INX,
  FSUB_S,
  FSUB_S_INX,
  FSW,
  HFENCE_GVMA,
  HFENCE_VVMA,
  HINVAL_GVMA,
  HINVAL_VVMA,
  HLVX_HU,
  HLVX_WU,
  HLV_B,
  HLV_BU,
  HLV_D,
  HLV_H,
  HLV_HU,
  HLV_W,
  HLV_WU,
  HSV_B,
  HSV_D,
  HSV_H,
  HSV_W,
  Insn16,
  Insn32,
  InsnB,
  InsnCA,
  InsnCB,
  InsnCI,
  InsnCIW,
  InsnCJ,
  InsnCL,
  InsnCR,
  InsnCS,
  InsnCSS,
  InsnI,
  InsnI_Mem,
  InsnJ,
  InsnR,
  InsnR4,
  InsnS,
  InsnU,
  JAL,
  JALR,
  LB,
  LBU,
  LB_AQ,
  LB_AQ_RL,
  LD,
  LD_AQ,
  LD_AQ_RL,
  LH,
  LHU,
  LH_AQ,
  LH_AQ_RL,
  LR_D,
  LR_D_AQ,
  LR_D_AQ_RL,
  LR_D_RL,
  LR_W,
  LR_W_AQ,
  LR_W_AQ_RL,
  LR_W_RL,
  LUI,
  LW,
  LWU,
  LW_AQ,
  LW_AQ_RL,
  MAX,
  MAXU,
  MIN,
  MINU,
  MOPR0,
  MOPR1,
  MOPR10,
  MOPR11,
  MOPR12,
  MOPR13,
  MOPR14,
  MOPR15,
  MOPR16,
  MOPR17,
  MOPR18,
  MOPR19,
  MOPR2,
  MOPR20,
  MOPR21,
  MOPR22,
  MOPR23,
  MOPR24,
  MOPR25,
  MOPR26,
  MOPR27,
  MOPR28,
  MOPR29,
  MOPR3,
  MOPR30,
  MOPR31,
  MOPR4,
  MOPR5,
  MOPR6,
  MOPR7,
  MOPR8,
  MOPR9,
  MOPRR0,
  MOPRR1,
  MOPRR2,
  MOPRR3,
  MOPRR4,
  MOPRR5,
  MOPRR6,
  MOPRR7,
  MRET,
  MUL,
  MULH,
  MULHSU,
  MULHU,
  MULW,
  OR,
  ORC_B,
  ORI,
  ORN,
  PACK,
  PACKH,
  PACKW,
  PREFETCH_I,
  PREFETCH_R,
  PREFETCH_W,
  QK_C_LBU,
  QK_C_LBUSP,
  QK_C_LHU,
  QK_C_LHUSP,
  QK_C_SB,
  QK_C_SBSP,
  QK_C_SH,
  QK_C_SHSP,
  REM,
  REMU,
  REMUW,
  REMW,
  REV8_RV32,
  REV8_RV64,
  ROL,
  ROLW,
  ROR,
  RORI,
  RORIW,
  RORW,
  SB,
  SB_AQ_RL,
  SB_RL,
  SC_D,
  SC_D_AQ,
  SC_D_AQ_RL,
  SC_D_RL,
  SC_W,
  SC_W_AQ,
  SC_W_AQ_RL,
  SC_W_RL,
  SD,
  SD_AQ_RL,
  SD_RL,
  SEXT_B,
  SEXT_H,
  SFENCE_INVAL_IR,
  SFENCE_VMA,
  SFENCE_W_INVAL,
  SF_CDISCARD_D_L1,
  SF_CEASE,
  SF_CFLUSH_D_L1,
  SH,
  SH1ADD,
  SH1ADD_UW,
  SH2ADD,
  SH2ADD_UW,
  SH3ADD,
  SH3ADD_UW,
  SHA256SIG0,
  SHA256SIG1,
  SHA256SUM0,
  SHA256SUM1,
  SHA512SIG0,
  SHA512SIG0H,
  SHA512SIG0L,
  SHA512SIG1,
  SHA512SIG1H,
  SHA512SIG1L,
  SHA512SUM0,
  SHA512SUM0R,
  SHA512SUM1,
  SHA512SUM1R,
  SH_AQ_RL,
  SH_RL,
  SINVAL_VMA,
  SLL,
  SLLI,
  SLLIW,
  SLLI_UW,
  SLLW,
  SLT,
  SLTI,
  SLTIU,
  SLTU,
  SM3P0,
  SM3P1,
  SM4ED,
  SM4KS,
  SRA,
  SRAI,
  SRAIW,
  SRAW,
  SRET,
  SRL,
  SRLI,
  SRLIW,
  SRLW,
  SSAMOSWAP_D,
  SSAMOSWAP_D_AQ,
  SSAMOSWAP_D_AQ_RL,
  SSAMOSWAP_D_RL,
  SSAMOSWAP_W,
  SSAMOSWAP_W_AQ,
  SSAMOSWAP_W_AQ_RL,
  SSAMOSWAP_W_RL,
  SSPOPCHK,
  SSPUSH,
  SSRDP,
  SUB,
  SUBW,
  SW,
  SW_AQ_RL,
  SW_RL,
  THVdotVMAQASU_VV,
  THVdotVMAQASU_VX,
  THVdotVMAQAUS_VX,
  THVdotVMAQAU_VV,
  THVdotVMAQAU_VX,
  THVdotVMAQA_VV,
  THVdotVMAQA_VX,
  TH_ADDSL,
  TH_DCACHE_CALL,
  TH_DCACHE_CIALL,
  TH_DCACHE_CIPA,
  TH_DCACHE_CISW,
  TH_DCACHE_CIVA,
  TH_DCACHE_CPA,
  TH_DCACHE_CPAL1,
  TH_DCACHE_CSW,
  TH_DCACHE_CVA,
  TH_DCACHE_CVAL1,
  TH_DCACHE_IALL,
  TH_DCACHE_IPA,
  TH_DCACHE_ISW,
  TH_DCACHE_IVA,
  TH_EXT,
  TH_EXTU,
  TH_FF0,
  TH_FF1,
  TH_FLRD,
  TH_FLRW,
  TH_FLURD,
  TH_FLURW,
  TH_FSRD,
  TH_FSRW,
  TH_FSURD,
  TH_FSURW,
  TH_ICACHE_IALL,
  TH_ICACHE_IALLS,
  TH_ICACHE_IPA,
  TH_ICACHE_IVA,
  TH_L2CACHE_CALL,
  TH_L2CACHE_CIALL,
  TH_L2CACHE_IALL,
  TH_LBIA,
  TH_LBIB,
  TH_LBUIA,
  TH_LBUIB,
  TH_LDD,
  TH_LDIA,
  TH_LDIB,
  TH_LHIA,
  TH_LHIB,
  TH_LHUIA,
  TH_LHUIB,
  TH_LRB,
  TH_LRBU,
  TH_LRD,
  TH_LRH,
  TH_LRHU,
  TH_LRW,
  TH_LRWU,
  TH_LURB,
  TH_LURBU,
  TH_LURD,
  TH_LURH,
  TH_LURHU,
  TH_LURW,
  TH_LURWU,
  TH_LWD,
  TH_LWIA,
  TH_LWIB,
  TH_LWUD,
  TH_LWUIA,
  TH_LWUIB,
  TH_MULA,
  TH_MULAH,
  TH_MULAW,
  TH_MULS,
  TH_MULSH,
  TH_MULSW,
  TH_MVEQZ,
  TH_MVNEZ,
  TH_REV,
  TH_REVW,
  TH_SBIA,
  TH_SBIB,
  TH_SDD,
  TH_SDIA,
  TH_SDIB,
  TH_SFENCE_VMAS,
  TH_SHIA,
  TH_SHIB,
  TH_SRB,
  TH_SRD,
  TH_SRH,
  TH_SRRI,
  TH_SRRIW,
  TH_SRW,
  TH_SURB,
  TH_SURD,
  TH_SURH,
  TH_SURW,
  TH_SWD,
  TH_SWIA,
  TH_SWIB,
  TH_SYNC,
  TH_SYNC_I,
  TH_SYNC_IS,
  TH_SYNC_S,
  TH_TST,
  TH_TSTNBZ,
  UNIMP,
  UNZIP_RV32,
  VAADDU_VV,
  VAADDU_VX,
  VAADD_VV,
  VAADD_VX,
  VADC_VIM,
  VADC_VVM,
  VADC_VXM,
  VADD_VI,
  VADD_VV,
  VADD_VX,
  VAESDF_VS,
  VAESDF_VV,
  VAESDM_VS,
  VAESDM_VV,
  VAESEF_VS,
  VAESEF_VV,
  VAESEM_VS,
  VAESEM_VV,
  VAESKF1_VI,
  VAESKF2_VI,
  VAESZ_VS,
  VANDN_VV,
  VANDN_VX,
  VAND_VI,
  VAND_VV,
  VAND_VX,
  VASUBU_VV,
  VASUBU_VX,
  VASUB_VV,
  VASUB_VX,
  VBREV8_V,
  VBREV_V,
  VCLMULH_VV,
  VCLMULH_VX,
  VCLMUL_VV,
  VCLMUL_VX,
  VCLZ_V,
  VCOMPRESS_VM,
  VCPOP_M,
  VCPOP_V,
  VCTZ_V,
  VC_FV,
  VC_FVV,
  VC_FVW,
  VC_I,
  VC_IV,
  VC_IVV,
  VC_IVW,
  VC_VV,
  VC_VVV,
  VC_VVW,
  VC_V_FV,
  VC_V_FVV,
  VC_V_FVW,
  VC_V_I,
  VC_V_IV,
  VC_V_IVV,
  VC_V_IVW,
  VC_V_VV,
  VC_V_VVV,
  VC_V_VVW,
  VC_V_X,
  VC_V_XV,
  VC_V_XVV,
  VC_V_XVW,
  VC_X,
  VC_XV,
  VC_XVV,
  VC_XVW,
  VDIVU_VV,
  VDIVU_VX,
  VDIV_VV,
  VDIV_VX,
  VFADD_VF,
  VFADD_VV,
  VFCLASS_V,
  VFCVT_F_XU_V,
  VFCVT_F_X_V,
  VFCVT_RTZ_XU_F_V,
  VFCVT_RTZ_X_F_V,
  VFCVT_XU_F_V,
  VFCVT_X_F_V,
  VFDIV_VF,
  VFDIV_VV,
  VFIRST_M,
  VFMACC_VF,
  VFMACC_VV,
  VFMADD_VF,
  VFMADD_VV,
  VFMAX_VF,
  VFMAX_VV,
  VFMERGE_VFM,
  VFMIN_VF,
  VFMIN_VV,
  VFMSAC_VF,
  VFMSAC_VV,
  VFMSUB_VF,
  VFMSUB_VV,
  VFMUL_VF,
  VFMUL_VV,
  VFMV_F_S,
  VFMV_S_F,
  VFMV_V_F,
  VFNCVTBF16_F_F_W,
  VFNCVT_F_F_W,
  VFNCVT_F_XU_W,
  VFNCVT_F_X_W,
  VFNCVT_ROD_F_F_W,
  VFNCVT_RTZ_XU_F_W,
  VFNCVT_RTZ_X_F_W,
  VFNCVT_XU_F_W,
  VFNCVT_X_F_W,
  VFNMACC_VF,
  VFNMACC_VV,
  VFNMADD_VF,
  VFNMADD_VV,
  VFNMSAC_VF,
  VFNMSAC_VV,
  VFNMSUB_VF,
  VFNMSUB_VV,
  VFNRCLIP_XU_F_QF,
  VFNRCLIP_X_F_QF,
  VFRDIV_VF,
  VFREC7_V,
  VFREDMAX_VS,
  VFREDMIN_VS,
  VFREDOSUM_VS,
  VFREDUSUM_VS,
  VFRSQRT7_V,
  VFRSUB_VF,
  VFSGNJN_VF,
  VFSGNJN_VV,
  VFSGNJX_VF,
  VFSGNJX_VV,
  VFSGNJ_VF,
  VFSGNJ_VV,
  VFSLIDE1DOWN_VF,
  VFSLIDE1UP_VF,
  VFSQRT_V,
  VFSUB_VF,
  VFSUB_VV,
  VFWADD_VF,
  VFWADD_VV,
  VFWADD_WF,
  VFWADD_WV,
  VFWCVTBF16_F_F_V,
  VFWCVT_F_F_V,
  VFWCVT_F_XU_V,
  VFWCVT_F_X_V,
  VFWCVT_RTZ_XU_F_V,
  VFWCVT_RTZ_X_F_V,
  VFWCVT_XU_F_V,
  VFWCVT_X_F_V,
  VFWMACCBF16_VF,
  VFWMACCBF16_VV,
  VFWMACC_4x4x4,
  VFWMACC_VF,
  VFWMACC_VV,
  VFWMSAC_VF,
  VFWMSAC_VV,
  VFWMUL_VF,
  VFWMUL_VV,
  VFWNMACC_VF,
  VFWNMACC_VV,
  VFWNMSAC_VF,
  VFWNMSAC_VV,
  VFWREDOSUM_VS,
  VFWREDUSUM_VS,
  VFWSUB_VF,
  VFWSUB_VV,
  VFWSUB_WF,
  VFWSUB_WV,
  VGHSH_VV,
  VGMUL_VV,
  VID_V,
  VIOTA_M,
  VL1RE16_V,
  VL1RE32_V,
  VL1RE64_V,
  VL1RE8_V,
  VL2RE16_V,
  VL2RE32_V,
  VL2RE64_V,
  VL2RE8_V,
  VL4RE16_V,
  VL4RE32_V,
  VL4RE64_V,
  VL4RE8_V,
  VL8RE16_V,
  VL8RE32_V,
  VL8RE64_V,
  VL8RE8_V,
  VLE16FF_V,
  VLE16_V,
  VLE32FF_V,
  VLE32_V,
  VLE64FF_V,
  VLE64_V,
  VLE8FF_V,
  VLE8_V,
  VLM_V,
  VLOXEI16_V,
  VLOXEI32_V,
  VLOXEI64_V,
  VLOXEI8_V,
  VLOXSEG2EI16_V,
  VLOXSEG2EI32_V,
  VLOXSEG2EI64_V,
  VLOXSEG2EI8_V,
  VLOXSEG3EI16_V,
  VLOXSEG3EI32_V,
  VLOXSEG3EI64_V,
  VLOXSEG3EI8_V,
  VLOXSEG4EI16_V,
  VLOXSEG4EI32_V,
  VLOXSEG4EI64_V,
  VLOXSEG4EI8_V,
  VLOXSEG5EI16_V,
  VLOXSEG5EI32_V,
  VLOXSEG5EI64_V,
  VLOXSEG5EI8_V,
  VLOXSEG6EI16_V,
  VLOXSEG6EI32_V,
  VLOXSEG6EI64_V,
  VLOXSEG6EI8_V,
  VLOXSEG7EI16_V,
  VLOXSEG7EI32_V,
  VLOXSEG7EI64_V,
  VLOXSEG7EI8_V,
  VLOXSEG8EI16_V,
  VLOXSEG8EI32_V,
  VLOXSEG8EI64_V,
  VLOXSEG8EI8_V,
  VLSE16_V,
  VLSE32_V,
  VLSE64_V,
  VLSE8_V,
  VLSEG2E16FF_V,
  VLSEG2E16_V,
  VLSEG2E32FF_V,
  VLSEG2E32_V,
  VLSEG2E64FF_V,
  VLSEG2E64_V,
  VLSEG2E8FF_V,
  VLSEG2E8_V,
  VLSEG3E16FF_V,
  VLSEG3E16_V,
  VLSEG3E32FF_V,
  VLSEG3E32_V,
  VLSEG3E64FF_V,
  VLSEG3E64_V,
  VLSEG3E8FF_V,
  VLSEG3E8_V,
  VLSEG4E16FF_V,
  VLSEG4E16_V,
  VLSEG4E32FF_V,
  VLSEG4E32_V,
  VLSEG4E64FF_V,
  VLSEG4E64_V,
  VLSEG4E8FF_V,
  VLSEG4E8_V,
  VLSEG5E16FF_V,
  VLSEG5E16_V,
  VLSEG5E32FF_V,
  VLSEG5E32_V,
  VLSEG5E64FF_V,
  VLSEG5E64_V,
  VLSEG5E8FF_V,
  VLSEG5E8_V,
  VLSEG6E16FF_V,
  VLSEG6E16_V,
  VLSEG6E32FF_V,
  VLSEG6E32_V,
  VLSEG6E64FF_V,
  VLSEG6E64_V,
  VLSEG6E8FF_V,
  VLSEG6E8_V,
  VLSEG7E16FF_V,
  VLSEG7E16_V,
  VLSEG7E32FF_V,
  VLSEG7E32_V,
  VLSEG7E64FF_V,
  VLSEG7E64_V,
  VLSEG7E8FF_V,
  VLSEG7E8_V,
  VLSEG8E16FF_V,
  VLSEG8E16_V,
  VLSEG8E32FF_V,
  VLSEG8E32_V,
  VLSEG8E64FF_V,
  VLSEG8E64_V,
  VLSEG8E8FF_V,
  VLSEG8E8_V,
  VLSSEG2E16_V,
  VLSSEG2E32_V,
  VLSSEG2E64_V,
  VLSSEG2E8_V,
  VLSSEG3E16_V,
  VLSSEG3E32_V,
  VLSSEG3E64_V,
  VLSSEG3E8_V,
  VLSSEG4E16_V,
  VLSSEG4E32_V,
  VLSSEG4E64_V,
  VLSSEG4E8_V,
  VLSSEG5E16_V,
  VLSSEG5E32_V,
  VLSSEG5E64_V,
  VLSSEG5E8_V,
  VLSSEG6E16_V,
  VLSSEG6E32_V,
  VLSSEG6E64_V,
  VLSSEG6E8_V,
  VLSSEG7E16_V,
  VLSSEG7E32_V,
  VLSSEG7E64_V,
  VLSSEG7E8_V,
  VLSSEG8E16_V,
  VLSSEG8E32_V,
  VLSSEG8E64_V,
  VLSSEG8E8_V,
  VLUXEI16_V,
  VLUXEI32_V,
  VLUXEI64_V,
  VLUXEI8_V,
  VLUXSEG2EI16_V,
  VLUXSEG2EI32_V,
  VLUXSEG2EI64_V,
  VLUXSEG2EI8_V,
  VLUXSEG3EI16_V,
  VLUXSEG3EI32_V,
  VLUXSEG3EI64_V,
  VLUXSEG3EI8_V,
  VLUXSEG4EI16_V,
  VLUXSEG4EI32_V,
  VLUXSEG4EI64_V,
  VLUXSEG4EI8_V,
  VLUXSEG5EI16_V,
  VLUXSEG5EI32_V,
  VLUXSEG5EI64_V,
  VLUXSEG5EI8_V,
  VLUXSEG6EI16_V,
  VLUXSEG6EI32_V,
  VLUXSEG6EI64_V,
  VLUXSEG6EI8_V,
  VLUXSEG7EI16_V,
  VLUXSEG7EI32_V,
  VLUXSEG7EI64_V,
  VLUXSEG7EI8_V,
  VLUXSEG8EI16_V,
  VLUXSEG8EI32_V,
  VLUXSEG8EI64_V,
  VLUXSEG8EI8_V,
  VMACC_VV,
  VMACC_VX,
  VMADC_VI,
  VMADC_VIM,
  VMADC_VV,
  VMADC_VVM,
  VMADC_VX,
  VMADC_VXM,
  VMADD_VV,
  VMADD_VX,
  VMANDN_MM,
  VMAND_MM,
  VMAXU_VV,
  VMAXU_VX,
  VMAX_VV,
  VMAX_VX,
  VMERGE_VIM,
  VMERGE_VVM,
  VMERGE_VXM,
  VMFEQ_VF,
  VMFEQ_VV,
  VMFGE_VF,
  VMFGT_VF,
  VMFLE_VF,
  VMFLE_VV,
  VMFLT_VF,
  VMFLT_VV,
  VMFNE_VF,
  VMFNE_VV,
  VMINU_VV,
  VMINU_VX,
  VMIN_VV,
  VMIN_VX,
  VMNAND_MM,
  VMNOR_MM,
  VMORN_MM,
  VMOR_MM,
  VMSBC_VV,
  VMSBC_VVM,
  VMSBC_VX,
  VMSBC_VXM,
  VMSBF_M,
  VMSEQ_VI,
  VMSEQ_VV,
  VMSEQ_VX,
  VMSGTU_VI,
  VMSGTU_VX,
  VMSGT_VI,
  VMSGT_VX,
  VMSIF_M,
  VMSLEU_VI,
  VMSLEU_VV,
  VMSLEU_VX,
  VMSLE_VI,
  VMSLE_VV,
  VMSLE_VX,
  VMSLTU_VV,
  VMSLTU_VX,
  VMSLT_VV,
  VMSLT_VX,
  VMSNE_VI,
  VMSNE_VV,
  VMSNE_VX,
  VMSOF_M,
  VMULHSU_VV,
  VMULHSU_VX,
  VMULHU_VV,
  VMULHU_VX,
  VMULH_VV,
  VMULH_VX,
  VMUL_VV,
  VMUL_VX,
  VMV1R_V,
  VMV2R_V,
  VMV4R_V,
  VMV8R_V,
  VMV_S_X,
  VMV_V_I,
  VMV_V_V,
  VMV_V_X,
  VMV_X_S,
  VMXNOR_MM,
  VMXOR_MM,
  VNCLIPU_WI,
  VNCLIPU_WV,
  VNCLIPU_WX,
  VNCLIP_WI,
  VNCLIP_WV,
  VNCLIP_WX,
  VNMSAC_VV,
  VNMSAC_VX,
  VNMSUB_VV,
  VNMSUB_VX,
  VNSRA_WI,
  VNSRA_WV,
  VNSRA_WX,
  VNSRL_WI,
  VNSRL_WV,
  VNSRL_WX,
  VOR_VI,
  VOR_VV,
  VOR_VX,
  VQMACCSU_2x8x2,
  VQMACCSU_4x8x4,
  VQMACCUS_2x8x2,
  VQMACCUS_4x8x4,
  VQMACCU_2x8x2,
  VQMACCU_4x8x4,
  VQMACC_2x8x2,
  VQMACC_4x8x4,
  VREDAND_VS,
  VREDMAXU_VS,
  VREDMAX_VS,
  VREDMINU_VS,
  VREDMIN_VS,
  VREDOR_VS,
  VREDSUM_VS,
  VREDXOR_VS,
  VREMU_VV,
  VREMU_VX,
  VREM_VV,
  VREM_VX,
  VREV8_V,
  VRGATHEREI16_VV,
  VRGATHER_VI,
  VRGATHER_VV,
  VRGATHER_VX,
  VROL_VV,
  VROL_VX,
  VROR_VI,
  VROR_VV,
  VROR_VX,
  VRSUB_VI,
  VRSUB_VX,
  VS1R_V,
  VS2R_V,
  VS4R_V,
  VS8R_V,
  VSADDU_VI,
  VSADDU_VV,
  VSADDU_VX,
  VSADD_VI,
  VSADD_VV,
  VSADD_VX,
  VSBC_VVM,
  VSBC_VXM,
  VSE16_V,
  VSE32_V,
  VSE64_V,
  VSE8_V,
  VSETIVLI,
  VSETVL,
  VSETVLI,
  VSEXT_VF2,
  VSEXT_VF4,
  VSEXT_VF8,
  VSHA2CH_VV,
  VSHA2CL_VV,
  VSHA2MS_VV,
  VSLIDE1DOWN_VX,
  VSLIDE1UP_VX,
  VSLIDEDOWN_VI,
  VSLIDEDOWN_VX,
  VSLIDEUP_VI,
  VSLIDEUP_VX,
  VSLL_VI,
  VSLL_VV,
  VSLL_VX,
  VSM3C_VI,
  VSM3ME_VV,
  VSM4K_VI,
  VSM4R_VS,
  VSM4R_VV,
  VSMUL_VV,
  VSMUL_VX,
  VSM_V,
  VSOXEI16_V,
  VSOXEI32_V,
  VSOXEI64_V,
  VSOXEI8_V,
  VSOXSEG2EI16_V,
  VSOXSEG2EI32_V,
  VSOXSEG2EI64_V,
  VSOXSEG2EI8_V,
  VSOXSEG3EI16_V,
  VSOXSEG3EI32_V,
  VSOXSEG3EI64_V,
  VSOXSEG3EI8_V,
  VSOXSEG4EI16_V,
  VSOXSEG4EI32_V,
  VSOXSEG4EI64_V,
  VSOXSEG4EI8_V,
  VSOXSEG5EI16_V,
  VSOXSEG5EI32_V,
  VSOXSEG5EI64_V,
  VSOXSEG5EI8_V,
  VSOXSEG6EI16_V,
  VSOXSEG6EI32_V,
  VSOXSEG6EI64_V,
  VSOXSEG6EI8_V,
  VSOXSEG7EI16_V,
  VSOXSEG7EI32_V,
  VSOXSEG7EI64_V,
  VSOXSEG7EI8_V,
  VSOXSEG8EI16_V,
  VSOXSEG8EI32_V,
  VSOXSEG8EI64_V,
  VSOXSEG8EI8_V,
  VSRA_VI,
  VSRA_VV,
  VSRA_VX,
  VSRL_VI,
  VSRL_VV,
  VSRL_VX,
  VSSE16_V,
  VSSE32_V,
  VSSE64_V,
  VSSE8_V,
  VSSEG2E16_V,
  VSSEG2E32_V,
  VSSEG2E64_V,
  VSSEG2E8_V,
  VSSEG3E16_V,
  VSSEG3E32_V,
  VSSEG3E64_V,
  VSSEG3E8_V,
  VSSEG4E16_V,
  VSSEG4E32_V,
  VSSEG4E64_V,
  VSSEG4E8_V,
  VSSEG5E16_V,
  VSSEG5E32_V,
  VSSEG5E64_V,
  VSSEG5E8_V,
  VSSEG6E16_V,
  VSSEG6E32_V,
  VSSEG6E64_V,
  VSSEG6E8_V,
  VSSEG7E16_V,
  VSSEG7E32_V,
  VSSEG7E64_V,
  VSSEG7E8_V,
  VSSEG8E16_V,
  VSSEG8E32_V,
  VSSEG8E64_V,
  VSSEG8E8_V,
  VSSRA_VI,
  VSSRA_VV,
  VSSRA_VX,
  VSSRL_VI,
  VSSRL_VV,
  VSSRL_VX,
  VSSSEG2E16_V,
  VSSSEG2E32_V,
  VSSSEG2E64_V,
  VSSSEG2E8_V,
  VSSSEG3E16_V,
  VSSSEG3E32_V,
  VSSSEG3E64_V,
  VSSSEG3E8_V,
  VSSSEG4E16_V,
  VSSSEG4E32_V,
  VSSSEG4E64_V,
  VSSSEG4E8_V,
  VSSSEG5E16_V,
  VSSSEG5E32_V,
  VSSSEG5E64_V,
  VSSSEG5E8_V,
  VSSSEG6E16_V,
  VSSSEG6E32_V,
  VSSSEG6E64_V,
  VSSSEG6E8_V,
  VSSSEG7E16_V,
  VSSSEG7E32_V,
  VSSSEG7E64_V,
  VSSSEG7E8_V,
  VSSSEG8E16_V,
  VSSSEG8E32_V,
  VSSSEG8E64_V,
  VSSSEG8E8_V,
  VSSUBU_VV,
  VSSUBU_VX,
  VSSUB_VV,
  VSSUB_VX,
  VSUB_VV,
  VSUB_VX,
  VSUXEI16_V,
  VSUXEI32_V,
  VSUXEI64_V,
  VSUXEI8_V,
  VSUXSEG2EI16_V,
  VSUXSEG2EI32_V,
  VSUXSEG2EI64_V,
  VSUXSEG2EI8_V,
  VSUXSEG3EI16_V,
  VSUXSEG3EI32_V,
  VSUXSEG3EI64_V,
  VSUXSEG3EI8_V,
  VSUXSEG4EI16_V,
  VSUXSEG4EI32_V,
  VSUXSEG4EI64_V,
  VSUXSEG4EI8_V,
  VSUXSEG5EI16_V,
  VSUXSEG5EI32_V,
  VSUXSEG5EI64_V,
  VSUXSEG5EI8_V,
  VSUXSEG6EI16_V,
  VSUXSEG6EI32_V,
  VSUXSEG6EI64_V,
  VSUXSEG6EI8_V,
  VSUXSEG7EI16_V,
  VSUXSEG7EI32_V,
  VSUXSEG7EI64_V,
  VSUXSEG7EI8_V,
  VSUXSEG8EI16_V,
  VSUXSEG8EI32_V,
  VSUXSEG8EI64_V,
  VSUXSEG8EI8_V,
  VT_MASKC,
  VT_MASKCN,
  VWADDU_VV,
  VWADDU_VX,
  VWADDU_WV,
  VWADDU_WX,
  VWADD_VV,
  VWADD_VX,
  VWADD_WV,
  VWADD_WX,
  VWMACCSU_VV,
  VWMACCSU_VX,
  VWMACCUS_VX,
  VWMACCU_VV,
  VWMACCU_VX,
  VWMACC_VV,
  VWMACC_VX,
  VWMULSU_VV,
  VWMULSU_VX,
  VWMULU_VV,
  VWMULU_VX,
  VWMUL_VV,
  VWMUL_VX,
  VWREDSUMU_VS,
  VWREDSUM_VS,
  VWSLL_VI,
  VWSLL_VV,
  VWSLL_VX,
  VWSUBU_VV,
  VWSUBU_VX,
  VWSUBU_WV,
  VWSUBU_WX,
  VWSUB_VV,
  VWSUB_VX,
  VWSUB_WV,
  VWSUB_WX,
  VXOR_VI,
  VXOR_VV,
  VXOR_VX,
  VZEXT_VF2,
  VZEXT_VF4,
  VZEXT_VF8,
  WFI,
  WRS_NTO,
  WRS_STO,
  XNOR,
  XOR,
  XORI,
  XPERM4,
  XPERM8,
  ZEXT_H_RV32,
  ZEXT_H_RV64,
  ZIP_RV32,
  INSTRUCTION_LIST_END,
  UNKNOWN(u64),
}

impl From<u64> for Opcode {
    fn from(value: u64) -> Self {
        match value {
          0 => Opcode::PHI,
          1 => Opcode::INLINEASM,
          2 => Opcode::INLINEASM_BR,
          3 => Opcode::CFI_INSTRUCTION,
          4 => Opcode::EH_LABEL,
          5 => Opcode::GC_LABEL,
          6 => Opcode::ANNOTATION_LABEL,
          7 => Opcode::KILL,
          8 => Opcode::EXTRACT_SUBREG,
          9 => Opcode::INSERT_SUBREG,
          10 => Opcode::IMPLICIT_DEF,
          11 => Opcode::SUBREG_TO_REG,
          12 => Opcode::COPY_TO_REGCLASS,
          13 => Opcode::DBG_VALUE,
          14 => Opcode::DBG_VALUE_LIST,
          15 => Opcode::DBG_INSTR_REF,
          16 => Opcode::DBG_PHI,
          17 => Opcode::DBG_LABEL,
          18 => Opcode::REG_SEQUENCE,
          19 => Opcode::COPY,
          20 => Opcode::BUNDLE,
          21 => Opcode::LIFETIME_START,
          22 => Opcode::LIFETIME_END,
          23 => Opcode::PSEUDO_PROBE,
          24 => Opcode::ARITH_FENCE,
          25 => Opcode::STACKMAP,
          26 => Opcode::FENTRY_CALL,
          27 => Opcode::PATCHPOINT,
          28 => Opcode::LOAD_STACK_GUARD,
          29 => Opcode::PREALLOCATED_SETUP,
          30 => Opcode::PREALLOCATED_ARG,
          31 => Opcode::STATEPOINT,
          32 => Opcode::LOCAL_ESCAPE,
          33 => Opcode::FAULTING_OP,
          34 => Opcode::PATCHABLE_OP,
          35 => Opcode::PATCHABLE_FUNCTION_ENTER,
          36 => Opcode::PATCHABLE_RET,
          37 => Opcode::PATCHABLE_FUNCTION_EXIT,
          38 => Opcode::PATCHABLE_TAIL_CALL,
          39 => Opcode::PATCHABLE_EVENT_CALL,
          40 => Opcode::PATCHABLE_TYPED_EVENT_CALL,
          41 => Opcode::ICALL_BRANCH_FUNNEL,
          42 => Opcode::MEMBARRIER,
          43 => Opcode::JUMP_TABLE_DEBUG_INFO,
          44 => Opcode::CONVERGENCECTRL_ENTRY,
          45 => Opcode::CONVERGENCECTRL_ANCHOR,
          46 => Opcode::CONVERGENCECTRL_LOOP,
          47 => Opcode::CONVERGENCECTRL_GLUE,
          48 => Opcode::G_ASSERT_SEXT,
          49 => Opcode::G_ASSERT_ZEXT,
          50 => Opcode::G_ASSERT_ALIGN,
          51 => Opcode::G_ADD,
          52 => Opcode::G_SUB,
          53 => Opcode::G_MUL,
          54 => Opcode::G_SDIV,
          55 => Opcode::G_UDIV,
          56 => Opcode::G_SREM,
          57 => Opcode::G_UREM,
          58 => Opcode::G_SDIVREM,
          59 => Opcode::G_UDIVREM,
          60 => Opcode::G_AND,
          61 => Opcode::G_OR,
          62 => Opcode::G_XOR,
          63 => Opcode::G_IMPLICIT_DEF,
          64 => Opcode::G_PHI,
          65 => Opcode::G_FRAME_INDEX,
          66 => Opcode::G_GLOBAL_VALUE,
          67 => Opcode::G_PTRAUTH_GLOBAL_VALUE,
          68 => Opcode::G_CONSTANT_POOL,
          69 => Opcode::G_EXTRACT,
          70 => Opcode::G_UNMERGE_VALUES,
          71 => Opcode::G_INSERT,
          72 => Opcode::G_MERGE_VALUES,
          73 => Opcode::G_BUILD_VECTOR,
          74 => Opcode::G_BUILD_VECTOR_TRUNC,
          75 => Opcode::G_CONCAT_VECTORS,
          76 => Opcode::G_PTRTOINT,
          77 => Opcode::G_INTTOPTR,
          78 => Opcode::G_BITCAST,
          79 => Opcode::G_FREEZE,
          80 => Opcode::G_CONSTANT_FOLD_BARRIER,
          81 => Opcode::G_INTRINSIC_FPTRUNC_ROUND,
          82 => Opcode::G_INTRINSIC_TRUNC,
          83 => Opcode::G_INTRINSIC_ROUND,
          84 => Opcode::G_INTRINSIC_LRINT,
          85 => Opcode::G_INTRINSIC_LLRINT,
          86 => Opcode::G_INTRINSIC_ROUNDEVEN,
          87 => Opcode::G_READCYCLECOUNTER,
          88 => Opcode::G_READSTEADYCOUNTER,
          89 => Opcode::G_LOAD,
          90 => Opcode::G_SEXTLOAD,
          91 => Opcode::G_ZEXTLOAD,
          92 => Opcode::G_INDEXED_LOAD,
          93 => Opcode::G_INDEXED_SEXTLOAD,
          94 => Opcode::G_INDEXED_ZEXTLOAD,
          95 => Opcode::G_STORE,
          96 => Opcode::G_INDEXED_STORE,
          97 => Opcode::G_ATOMIC_CMPXCHG_WITH_SUCCESS,
          98 => Opcode::G_ATOMIC_CMPXCHG,
          99 => Opcode::G_ATOMICRMW_XCHG,
          100 => Opcode::G_ATOMICRMW_ADD,
          101 => Opcode::G_ATOMICRMW_SUB,
          102 => Opcode::G_ATOMICRMW_AND,
          103 => Opcode::G_ATOMICRMW_NAND,
          104 => Opcode::G_ATOMICRMW_OR,
          105 => Opcode::G_ATOMICRMW_XOR,
          106 => Opcode::G_ATOMICRMW_MAX,
          107 => Opcode::G_ATOMICRMW_MIN,
          108 => Opcode::G_ATOMICRMW_UMAX,
          109 => Opcode::G_ATOMICRMW_UMIN,
          110 => Opcode::G_ATOMICRMW_FADD,
          111 => Opcode::G_ATOMICRMW_FSUB,
          112 => Opcode::G_ATOMICRMW_FMAX,
          113 => Opcode::G_ATOMICRMW_FMIN,
          114 => Opcode::G_ATOMICRMW_UINC_WRAP,
          115 => Opcode::G_ATOMICRMW_UDEC_WRAP,
          116 => Opcode::G_FENCE,
          117 => Opcode::G_PREFETCH,
          118 => Opcode::G_BRCOND,
          119 => Opcode::G_BRINDIRECT,
          120 => Opcode::G_INVOKE_REGION_START,
          121 => Opcode::G_INTRINSIC,
          122 => Opcode::G_INTRINSIC_W_SIDE_EFFECTS,
          123 => Opcode::G_INTRINSIC_CONVERGENT,
          124 => Opcode::G_INTRINSIC_CONVERGENT_W_SIDE_EFFECTS,
          125 => Opcode::G_ANYEXT,
          126 => Opcode::G_TRUNC,
          127 => Opcode::G_CONSTANT,
          128 => Opcode::G_FCONSTANT,
          129 => Opcode::G_VASTART,
          130 => Opcode::G_VAARG,
          131 => Opcode::G_SEXT,
          132 => Opcode::G_SEXT_INREG,
          133 => Opcode::G_ZEXT,
          134 => Opcode::G_SHL,
          135 => Opcode::G_LSHR,
          136 => Opcode::G_ASHR,
          137 => Opcode::G_FSHL,
          138 => Opcode::G_FSHR,
          139 => Opcode::G_ROTR,
          140 => Opcode::G_ROTL,
          141 => Opcode::G_ICMP,
          142 => Opcode::G_FCMP,
          143 => Opcode::G_SCMP,
          144 => Opcode::G_UCMP,
          145 => Opcode::G_SELECT,
          146 => Opcode::G_UADDO,
          147 => Opcode::G_UADDE,
          148 => Opcode::G_USUBO,
          149 => Opcode::G_USUBE,
          150 => Opcode::G_SADDO,
          151 => Opcode::G_SADDE,
          152 => Opcode::G_SSUBO,
          153 => Opcode::G_SSUBE,
          154 => Opcode::G_UMULO,
          155 => Opcode::G_SMULO,
          156 => Opcode::G_UMULH,
          157 => Opcode::G_SMULH,
          158 => Opcode::G_UADDSAT,
          159 => Opcode::G_SADDSAT,
          160 => Opcode::G_USUBSAT,
          161 => Opcode::G_SSUBSAT,
          162 => Opcode::G_USHLSAT,
          163 => Opcode::G_SSHLSAT,
          164 => Opcode::G_SMULFIX,
          165 => Opcode::G_UMULFIX,
          166 => Opcode::G_SMULFIXSAT,
          167 => Opcode::G_UMULFIXSAT,
          168 => Opcode::G_SDIVFIX,
          169 => Opcode::G_UDIVFIX,
          170 => Opcode::G_SDIVFIXSAT,
          171 => Opcode::G_UDIVFIXSAT,
          172 => Opcode::G_FADD,
          173 => Opcode::G_FSUB,
          174 => Opcode::G_FMUL,
          175 => Opcode::G_FMA,
          176 => Opcode::G_FMAD,
          177 => Opcode::G_FDIV,
          178 => Opcode::G_FREM,
          179 => Opcode::G_FPOW,
          180 => Opcode::G_FPOWI,
          181 => Opcode::G_FEXP,
          182 => Opcode::G_FEXP2,
          183 => Opcode::G_FEXP10,
          184 => Opcode::G_FLOG,
          185 => Opcode::G_FLOG2,
          186 => Opcode::G_FLOG10,
          187 => Opcode::G_FLDEXP,
          188 => Opcode::G_FFREXP,
          189 => Opcode::G_FNEG,
          190 => Opcode::G_FPEXT,
          191 => Opcode::G_FPTRUNC,
          192 => Opcode::G_FPTOSI,
          193 => Opcode::G_FPTOUI,
          194 => Opcode::G_SITOFP,
          195 => Opcode::G_UITOFP,
          196 => Opcode::G_FABS,
          197 => Opcode::G_FCOPYSIGN,
          198 => Opcode::G_IS_FPCLASS,
          199 => Opcode::G_FCANONICALIZE,
          200 => Opcode::G_FMINNUM,
          201 => Opcode::G_FMAXNUM,
          202 => Opcode::G_FMINNUM_IEEE,
          203 => Opcode::G_FMAXNUM_IEEE,
          204 => Opcode::G_FMINIMUM,
          205 => Opcode::G_FMAXIMUM,
          206 => Opcode::G_GET_FPENV,
          207 => Opcode::G_SET_FPENV,
          208 => Opcode::G_RESET_FPENV,
          209 => Opcode::G_GET_FPMODE,
          210 => Opcode::G_SET_FPMODE,
          211 => Opcode::G_RESET_FPMODE,
          212 => Opcode::G_PTR_ADD,
          213 => Opcode::G_PTRMASK,
          214 => Opcode::G_SMIN,
          215 => Opcode::G_SMAX,
          216 => Opcode::G_UMIN,
          217 => Opcode::G_UMAX,
          218 => Opcode::G_ABS,
          219 => Opcode::G_LROUND,
          220 => Opcode::G_LLROUND,
          221 => Opcode::G_BR,
          222 => Opcode::G_BRJT,
          223 => Opcode::G_VSCALE,
          224 => Opcode::G_INSERT_SUBVECTOR,
          225 => Opcode::G_EXTRACT_SUBVECTOR,
          226 => Opcode::G_INSERT_VECTOR_ELT,
          227 => Opcode::G_EXTRACT_VECTOR_ELT,
          228 => Opcode::G_SHUFFLE_VECTOR,
          229 => Opcode::G_SPLAT_VECTOR,
          230 => Opcode::G_VECTOR_COMPRESS,
          231 => Opcode::G_CTTZ,
          232 => Opcode::G_CTTZ_ZERO_UNDEF,
          233 => Opcode::G_CTLZ,
          234 => Opcode::G_CTLZ_ZERO_UNDEF,
          235 => Opcode::G_CTPOP,
          236 => Opcode::G_BSWAP,
          237 => Opcode::G_BITREVERSE,
          238 => Opcode::G_FCEIL,
          239 => Opcode::G_FCOS,
          240 => Opcode::G_FSIN,
          241 => Opcode::G_FTAN,
          242 => Opcode::G_FACOS,
          243 => Opcode::G_FASIN,
          244 => Opcode::G_FATAN,
          245 => Opcode::G_FCOSH,
          246 => Opcode::G_FSINH,
          247 => Opcode::G_FTANH,
          248 => Opcode::G_FSQRT,
          249 => Opcode::G_FFLOOR,
          250 => Opcode::G_FRINT,
          251 => Opcode::G_FNEARBYINT,
          252 => Opcode::G_ADDRSPACE_CAST,
          253 => Opcode::G_BLOCK_ADDR,
          254 => Opcode::G_JUMP_TABLE,
          255 => Opcode::G_DYN_STACKALLOC,
          256 => Opcode::G_STACKSAVE,
          257 => Opcode::G_STACKRESTORE,
          258 => Opcode::G_STRICT_FADD,
          259 => Opcode::G_STRICT_FSUB,
          260 => Opcode::G_STRICT_FMUL,
          261 => Opcode::G_STRICT_FDIV,
          262 => Opcode::G_STRICT_FREM,
          263 => Opcode::G_STRICT_FMA,
          264 => Opcode::G_STRICT_FSQRT,
          265 => Opcode::G_STRICT_FLDEXP,
          266 => Opcode::G_READ_REGISTER,
          267 => Opcode::G_WRITE_REGISTER,
          268 => Opcode::G_MEMCPY,
          269 => Opcode::G_MEMCPY_INLINE,
          270 => Opcode::G_MEMMOVE,
          271 => Opcode::G_MEMSET,
          272 => Opcode::G_BZERO,
          273 => Opcode::G_TRAP,
          274 => Opcode::G_DEBUGTRAP,
          275 => Opcode::G_UBSANTRAP,
          276 => Opcode::G_VECREDUCE_SEQ_FADD,
          277 => Opcode::G_VECREDUCE_SEQ_FMUL,
          278 => Opcode::G_VECREDUCE_FADD,
          279 => Opcode::G_VECREDUCE_FMUL,
          280 => Opcode::G_VECREDUCE_FMAX,
          281 => Opcode::G_VECREDUCE_FMIN,
          282 => Opcode::G_VECREDUCE_FMAXIMUM,
          283 => Opcode::G_VECREDUCE_FMINIMUM,
          284 => Opcode::G_VECREDUCE_ADD,
          285 => Opcode::G_VECREDUCE_MUL,
          286 => Opcode::G_VECREDUCE_AND,
          287 => Opcode::G_VECREDUCE_OR,
          288 => Opcode::G_VECREDUCE_XOR,
          289 => Opcode::G_VECREDUCE_SMAX,
          290 => Opcode::G_VECREDUCE_SMIN,
          291 => Opcode::G_VECREDUCE_UMAX,
          292 => Opcode::G_VECREDUCE_UMIN,
          293 => Opcode::G_SBFX,
          294 => Opcode::G_UBFX,
          295 => Opcode::ADJCALLSTACKDOWN,
          296 => Opcode::ADJCALLSTACKUP,
          297 => Opcode::BuildPairF64Pseudo,
          298 => Opcode::G_FCLASS,
          299 => Opcode::G_READ_VLENB,
          300 => Opcode::G_SPLAT_VECTOR_SPLIT_I64_VL,
          301 => Opcode::G_VMCLR_VL,
          302 => Opcode::G_VMSET_VL,
          303 => Opcode::HWASAN_CHECK_MEMACCESS_SHORTGRANULES,
          304 => Opcode::KCFI_CHECK,
          305 => Opcode::PseudoAddTPRel,
          306 => Opcode::PseudoAtomicLoadNand32,
          307 => Opcode::PseudoAtomicLoadNand64,
          308 => Opcode::PseudoBR,
          309 => Opcode::PseudoBRIND,
          310 => Opcode::PseudoBRINDNonX7,
          311 => Opcode::PseudoBRINDX7,
          312 => Opcode::PseudoCALL,
          313 => Opcode::PseudoCALLIndirect,
          314 => Opcode::PseudoCALLIndirectNonX7,
          315 => Opcode::PseudoCALLReg,
          316 => Opcode::PseudoCCADD,
          317 => Opcode::PseudoCCADDI,
          318 => Opcode::PseudoCCADDIW,
          319 => Opcode::PseudoCCADDW,
          320 => Opcode::PseudoCCAND,
          321 => Opcode::PseudoCCANDI,
          322 => Opcode::PseudoCCANDN,
          323 => Opcode::PseudoCCMOVGPR,
          324 => Opcode::PseudoCCMOVGPRNoX0,
          325 => Opcode::PseudoCCOR,
          326 => Opcode::PseudoCCORI,
          327 => Opcode::PseudoCCORN,
          328 => Opcode::PseudoCCSLL,
          329 => Opcode::PseudoCCSLLI,
          330 => Opcode::PseudoCCSLLIW,
          331 => Opcode::PseudoCCSLLW,
          332 => Opcode::PseudoCCSRA,
          333 => Opcode::PseudoCCSRAI,
          334 => Opcode::PseudoCCSRAIW,
          335 => Opcode::PseudoCCSRAW,
          336 => Opcode::PseudoCCSRL,
          337 => Opcode::PseudoCCSRLI,
          338 => Opcode::PseudoCCSRLIW,
          339 => Opcode::PseudoCCSRLW,
          340 => Opcode::PseudoCCSUB,
          341 => Opcode::PseudoCCSUBW,
          342 => Opcode::PseudoCCXNOR,
          343 => Opcode::PseudoCCXOR,
          344 => Opcode::PseudoCCXORI,
          345 => Opcode::PseudoCmpXchg32,
          346 => Opcode::PseudoCmpXchg64,
          347 => Opcode::PseudoFLD,
          348 => Opcode::PseudoFLH,
          349 => Opcode::PseudoFLW,
          350 => Opcode::PseudoFROUND_D,
          351 => Opcode::PseudoFROUND_D_IN32X,
          352 => Opcode::PseudoFROUND_D_INX,
          353 => Opcode::PseudoFROUND_H,
          354 => Opcode::PseudoFROUND_H_INX,
          355 => Opcode::PseudoFROUND_S,
          356 => Opcode::PseudoFROUND_S_INX,
          357 => Opcode::PseudoFSD,
          358 => Opcode::PseudoFSH,
          359 => Opcode::PseudoFSW,
          360 => Opcode::PseudoJump,
          361 => Opcode::PseudoLA,
          362 => Opcode::PseudoLAImm,
          363 => Opcode::PseudoLA_TLSDESC,
          364 => Opcode::PseudoLA_TLS_GD,
          365 => Opcode::PseudoLA_TLS_IE,
          366 => Opcode::PseudoLB,
          367 => Opcode::PseudoLBU,
          368 => Opcode::PseudoLD,
          369 => Opcode::PseudoLGA,
          370 => Opcode::PseudoLH,
          371 => Opcode::PseudoLHU,
          372 => Opcode::PseudoLI,
          373 => Opcode::PseudoLLA,
          374 => Opcode::PseudoLLAImm,
          375 => Opcode::PseudoLW,
          376 => Opcode::PseudoLWU,
          377 => Opcode::PseudoLongBEQ,
          378 => Opcode::PseudoLongBGE,
          379 => Opcode::PseudoLongBGEU,
          380 => Opcode::PseudoLongBLT,
          381 => Opcode::PseudoLongBLTU,
          382 => Opcode::PseudoLongBNE,
          383 => Opcode::PseudoMaskedAtomicLoadAdd32,
          384 => Opcode::PseudoMaskedAtomicLoadMax32,
          385 => Opcode::PseudoMaskedAtomicLoadMin32,
          386 => Opcode::PseudoMaskedAtomicLoadNand32,
          387 => Opcode::PseudoMaskedAtomicLoadSub32,
          388 => Opcode::PseudoMaskedAtomicLoadUMax32,
          389 => Opcode::PseudoMaskedAtomicLoadUMin32,
          390 => Opcode::PseudoMaskedAtomicSwap32,
          391 => Opcode::PseudoMaskedCmpXchg32,
          392 => Opcode::PseudoMovAddr,
          393 => Opcode::PseudoMovImm,
          394 => Opcode::PseudoQuietFLE_D,
          395 => Opcode::PseudoQuietFLE_D_IN32X,
          396 => Opcode::PseudoQuietFLE_D_INX,
          397 => Opcode::PseudoQuietFLE_H,
          398 => Opcode::PseudoQuietFLE_H_INX,
          399 => Opcode::PseudoQuietFLE_S,
          400 => Opcode::PseudoQuietFLE_S_INX,
          401 => Opcode::PseudoQuietFLT_D,
          402 => Opcode::PseudoQuietFLT_D_IN32X,
          403 => Opcode::PseudoQuietFLT_D_INX,
          404 => Opcode::PseudoQuietFLT_H,
          405 => Opcode::PseudoQuietFLT_H_INX,
          406 => Opcode::PseudoQuietFLT_S,
          407 => Opcode::PseudoQuietFLT_S_INX,
          408 => Opcode::PseudoRET,
          409 => Opcode::PseudoRV32ZdinxLD,
          410 => Opcode::PseudoRV32ZdinxSD,
          411 => Opcode::PseudoRVVInitUndefM1,
          412 => Opcode::PseudoRVVInitUndefM2,
          413 => Opcode::PseudoRVVInitUndefM4,
          414 => Opcode::PseudoRVVInitUndefM8,
          415 => Opcode::PseudoReadVL,
          416 => Opcode::PseudoReadVLENB,
          417 => Opcode::PseudoSB,
          418 => Opcode::PseudoSD,
          419 => Opcode::PseudoSEXT_B,
          420 => Opcode::PseudoSEXT_H,
          421 => Opcode::PseudoSH,
          422 => Opcode::PseudoSW,
          423 => Opcode::PseudoTAIL,
          424 => Opcode::PseudoTAILIndirect,
          425 => Opcode::PseudoTAILIndirectNonX7,
          426 => Opcode::PseudoTHVdotVMAQASU_VV_M1,
          427 => Opcode::PseudoTHVdotVMAQASU_VV_M1_MASK,
          428 => Opcode::PseudoTHVdotVMAQASU_VV_M2,
          429 => Opcode::PseudoTHVdotVMAQASU_VV_M2_MASK,
          430 => Opcode::PseudoTHVdotVMAQASU_VV_M4,
          431 => Opcode::PseudoTHVdotVMAQASU_VV_M4_MASK,
          432 => Opcode::PseudoTHVdotVMAQASU_VV_M8,
          433 => Opcode::PseudoTHVdotVMAQASU_VV_M8_MASK,
          434 => Opcode::PseudoTHVdotVMAQASU_VV_MF2,
          435 => Opcode::PseudoTHVdotVMAQASU_VV_MF2_MASK,
          436 => Opcode::PseudoTHVdotVMAQASU_VX_M1,
          437 => Opcode::PseudoTHVdotVMAQASU_VX_M1_MASK,
          438 => Opcode::PseudoTHVdotVMAQASU_VX_M2,
          439 => Opcode::PseudoTHVdotVMAQASU_VX_M2_MASK,
          440 => Opcode::PseudoTHVdotVMAQASU_VX_M4,
          441 => Opcode::PseudoTHVdotVMAQASU_VX_M4_MASK,
          442 => Opcode::PseudoTHVdotVMAQASU_VX_M8,
          443 => Opcode::PseudoTHVdotVMAQASU_VX_M8_MASK,
          444 => Opcode::PseudoTHVdotVMAQASU_VX_MF2,
          445 => Opcode::PseudoTHVdotVMAQASU_VX_MF2_MASK,
          446 => Opcode::PseudoTHVdotVMAQAUS_VX_M1,
          447 => Opcode::PseudoTHVdotVMAQAUS_VX_M1_MASK,
          448 => Opcode::PseudoTHVdotVMAQAUS_VX_M2,
          449 => Opcode::PseudoTHVdotVMAQAUS_VX_M2_MASK,
          450 => Opcode::PseudoTHVdotVMAQAUS_VX_M4,
          451 => Opcode::PseudoTHVdotVMAQAUS_VX_M4_MASK,
          452 => Opcode::PseudoTHVdotVMAQAUS_VX_M8,
          453 => Opcode::PseudoTHVdotVMAQAUS_VX_M8_MASK,
          454 => Opcode::PseudoTHVdotVMAQAUS_VX_MF2,
          455 => Opcode::PseudoTHVdotVMAQAUS_VX_MF2_MASK,
          456 => Opcode::PseudoTHVdotVMAQAU_VV_M1,
          457 => Opcode::PseudoTHVdotVMAQAU_VV_M1_MASK,
          458 => Opcode::PseudoTHVdotVMAQAU_VV_M2,
          459 => Opcode::PseudoTHVdotVMAQAU_VV_M2_MASK,
          460 => Opcode::PseudoTHVdotVMAQAU_VV_M4,
          461 => Opcode::PseudoTHVdotVMAQAU_VV_M4_MASK,
          462 => Opcode::PseudoTHVdotVMAQAU_VV_M8,
          463 => Opcode::PseudoTHVdotVMAQAU_VV_M8_MASK,
          464 => Opcode::PseudoTHVdotVMAQAU_VV_MF2,
          465 => Opcode::PseudoTHVdotVMAQAU_VV_MF2_MASK,
          466 => Opcode::PseudoTHVdotVMAQAU_VX_M1,
          467 => Opcode::PseudoTHVdotVMAQAU_VX_M1_MASK,
          468 => Opcode::PseudoTHVdotVMAQAU_VX_M2,
          469 => Opcode::PseudoTHVdotVMAQAU_VX_M2_MASK,
          470 => Opcode::PseudoTHVdotVMAQAU_VX_M4,
          471 => Opcode::PseudoTHVdotVMAQAU_VX_M4_MASK,
          472 => Opcode::PseudoTHVdotVMAQAU_VX_M8,
          473 => Opcode::PseudoTHVdotVMAQAU_VX_M8_MASK,
          474 => Opcode::PseudoTHVdotVMAQAU_VX_MF2,
          475 => Opcode::PseudoTHVdotVMAQAU_VX_MF2_MASK,
          476 => Opcode::PseudoTHVdotVMAQA_VV_M1,
          477 => Opcode::PseudoTHVdotVMAQA_VV_M1_MASK,
          478 => Opcode::PseudoTHVdotVMAQA_VV_M2,
          479 => Opcode::PseudoTHVdotVMAQA_VV_M2_MASK,
          480 => Opcode::PseudoTHVdotVMAQA_VV_M4,
          481 => Opcode::PseudoTHVdotVMAQA_VV_M4_MASK,
          482 => Opcode::PseudoTHVdotVMAQA_VV_M8,
          483 => Opcode::PseudoTHVdotVMAQA_VV_M8_MASK,
          484 => Opcode::PseudoTHVdotVMAQA_VV_MF2,
          485 => Opcode::PseudoTHVdotVMAQA_VV_MF2_MASK,
          486 => Opcode::PseudoTHVdotVMAQA_VX_M1,
          487 => Opcode::PseudoTHVdotVMAQA_VX_M1_MASK,
          488 => Opcode::PseudoTHVdotVMAQA_VX_M2,
          489 => Opcode::PseudoTHVdotVMAQA_VX_M2_MASK,
          490 => Opcode::PseudoTHVdotVMAQA_VX_M4,
          491 => Opcode::PseudoTHVdotVMAQA_VX_M4_MASK,
          492 => Opcode::PseudoTHVdotVMAQA_VX_M8,
          493 => Opcode::PseudoTHVdotVMAQA_VX_M8_MASK,
          494 => Opcode::PseudoTHVdotVMAQA_VX_MF2,
          495 => Opcode::PseudoTHVdotVMAQA_VX_MF2_MASK,
          496 => Opcode::PseudoTLSDESCCall,
          497 => Opcode::PseudoVAADDU_VV_M1,
          498 => Opcode::PseudoVAADDU_VV_M1_MASK,
          499 => Opcode::PseudoVAADDU_VV_M2,
          500 => Opcode::PseudoVAADDU_VV_M2_MASK,
          501 => Opcode::PseudoVAADDU_VV_M4,
          502 => Opcode::PseudoVAADDU_VV_M4_MASK,
          503 => Opcode::PseudoVAADDU_VV_M8,
          504 => Opcode::PseudoVAADDU_VV_M8_MASK,
          505 => Opcode::PseudoVAADDU_VV_MF2,
          506 => Opcode::PseudoVAADDU_VV_MF2_MASK,
          507 => Opcode::PseudoVAADDU_VV_MF4,
          508 => Opcode::PseudoVAADDU_VV_MF4_MASK,
          509 => Opcode::PseudoVAADDU_VV_MF8,
          510 => Opcode::PseudoVAADDU_VV_MF8_MASK,
          511 => Opcode::PseudoVAADDU_VX_M1,
          512 => Opcode::PseudoVAADDU_VX_M1_MASK,
          513 => Opcode::PseudoVAADDU_VX_M2,
          514 => Opcode::PseudoVAADDU_VX_M2_MASK,
          515 => Opcode::PseudoVAADDU_VX_M4,
          516 => Opcode::PseudoVAADDU_VX_M4_MASK,
          517 => Opcode::PseudoVAADDU_VX_M8,
          518 => Opcode::PseudoVAADDU_VX_M8_MASK,
          519 => Opcode::PseudoVAADDU_VX_MF2,
          520 => Opcode::PseudoVAADDU_VX_MF2_MASK,
          521 => Opcode::PseudoVAADDU_VX_MF4,
          522 => Opcode::PseudoVAADDU_VX_MF4_MASK,
          523 => Opcode::PseudoVAADDU_VX_MF8,
          524 => Opcode::PseudoVAADDU_VX_MF8_MASK,
          525 => Opcode::PseudoVAADD_VV_M1,
          526 => Opcode::PseudoVAADD_VV_M1_MASK,
          527 => Opcode::PseudoVAADD_VV_M2,
          528 => Opcode::PseudoVAADD_VV_M2_MASK,
          529 => Opcode::PseudoVAADD_VV_M4,
          530 => Opcode::PseudoVAADD_VV_M4_MASK,
          531 => Opcode::PseudoVAADD_VV_M8,
          532 => Opcode::PseudoVAADD_VV_M8_MASK,
          533 => Opcode::PseudoVAADD_VV_MF2,
          534 => Opcode::PseudoVAADD_VV_MF2_MASK,
          535 => Opcode::PseudoVAADD_VV_MF4,
          536 => Opcode::PseudoVAADD_VV_MF4_MASK,
          537 => Opcode::PseudoVAADD_VV_MF8,
          538 => Opcode::PseudoVAADD_VV_MF8_MASK,
          539 => Opcode::PseudoVAADD_VX_M1,
          540 => Opcode::PseudoVAADD_VX_M1_MASK,
          541 => Opcode::PseudoVAADD_VX_M2,
          542 => Opcode::PseudoVAADD_VX_M2_MASK,
          543 => Opcode::PseudoVAADD_VX_M4,
          544 => Opcode::PseudoVAADD_VX_M4_MASK,
          545 => Opcode::PseudoVAADD_VX_M8,
          546 => Opcode::PseudoVAADD_VX_M8_MASK,
          547 => Opcode::PseudoVAADD_VX_MF2,
          548 => Opcode::PseudoVAADD_VX_MF2_MASK,
          549 => Opcode::PseudoVAADD_VX_MF4,
          550 => Opcode::PseudoVAADD_VX_MF4_MASK,
          551 => Opcode::PseudoVAADD_VX_MF8,
          552 => Opcode::PseudoVAADD_VX_MF8_MASK,
          553 => Opcode::PseudoVADC_VIM_M1,
          554 => Opcode::PseudoVADC_VIM_M2,
          555 => Opcode::PseudoVADC_VIM_M4,
          556 => Opcode::PseudoVADC_VIM_M8,
          557 => Opcode::PseudoVADC_VIM_MF2,
          558 => Opcode::PseudoVADC_VIM_MF4,
          559 => Opcode::PseudoVADC_VIM_MF8,
          560 => Opcode::PseudoVADC_VVM_M1,
          561 => Opcode::PseudoVADC_VVM_M2,
          562 => Opcode::PseudoVADC_VVM_M4,
          563 => Opcode::PseudoVADC_VVM_M8,
          564 => Opcode::PseudoVADC_VVM_MF2,
          565 => Opcode::PseudoVADC_VVM_MF4,
          566 => Opcode::PseudoVADC_VVM_MF8,
          567 => Opcode::PseudoVADC_VXM_M1,
          568 => Opcode::PseudoVADC_VXM_M2,
          569 => Opcode::PseudoVADC_VXM_M4,
          570 => Opcode::PseudoVADC_VXM_M8,
          571 => Opcode::PseudoVADC_VXM_MF2,
          572 => Opcode::PseudoVADC_VXM_MF4,
          573 => Opcode::PseudoVADC_VXM_MF8,
          574 => Opcode::PseudoVADD_VI_M1,
          575 => Opcode::PseudoVADD_VI_M1_MASK,
          576 => Opcode::PseudoVADD_VI_M2,
          577 => Opcode::PseudoVADD_VI_M2_MASK,
          578 => Opcode::PseudoVADD_VI_M4,
          579 => Opcode::PseudoVADD_VI_M4_MASK,
          580 => Opcode::PseudoVADD_VI_M8,
          581 => Opcode::PseudoVADD_VI_M8_MASK,
          582 => Opcode::PseudoVADD_VI_MF2,
          583 => Opcode::PseudoVADD_VI_MF2_MASK,
          584 => Opcode::PseudoVADD_VI_MF4,
          585 => Opcode::PseudoVADD_VI_MF4_MASK,
          586 => Opcode::PseudoVADD_VI_MF8,
          587 => Opcode::PseudoVADD_VI_MF8_MASK,
          588 => Opcode::PseudoVADD_VV_M1,
          589 => Opcode::PseudoVADD_VV_M1_MASK,
          590 => Opcode::PseudoVADD_VV_M2,
          591 => Opcode::PseudoVADD_VV_M2_MASK,
          592 => Opcode::PseudoVADD_VV_M4,
          593 => Opcode::PseudoVADD_VV_M4_MASK,
          594 => Opcode::PseudoVADD_VV_M8,
          595 => Opcode::PseudoVADD_VV_M8_MASK,
          596 => Opcode::PseudoVADD_VV_MF2,
          597 => Opcode::PseudoVADD_VV_MF2_MASK,
          598 => Opcode::PseudoVADD_VV_MF4,
          599 => Opcode::PseudoVADD_VV_MF4_MASK,
          600 => Opcode::PseudoVADD_VV_MF8,
          601 => Opcode::PseudoVADD_VV_MF8_MASK,
          602 => Opcode::PseudoVADD_VX_M1,
          603 => Opcode::PseudoVADD_VX_M1_MASK,
          604 => Opcode::PseudoVADD_VX_M2,
          605 => Opcode::PseudoVADD_VX_M2_MASK,
          606 => Opcode::PseudoVADD_VX_M4,
          607 => Opcode::PseudoVADD_VX_M4_MASK,
          608 => Opcode::PseudoVADD_VX_M8,
          609 => Opcode::PseudoVADD_VX_M8_MASK,
          610 => Opcode::PseudoVADD_VX_MF2,
          611 => Opcode::PseudoVADD_VX_MF2_MASK,
          612 => Opcode::PseudoVADD_VX_MF4,
          613 => Opcode::PseudoVADD_VX_MF4_MASK,
          614 => Opcode::PseudoVADD_VX_MF8,
          615 => Opcode::PseudoVADD_VX_MF8_MASK,
          616 => Opcode::PseudoVAESDF_VS_M1_M1,
          617 => Opcode::PseudoVAESDF_VS_M1_MF2,
          618 => Opcode::PseudoVAESDF_VS_M1_MF4,
          619 => Opcode::PseudoVAESDF_VS_M1_MF8,
          620 => Opcode::PseudoVAESDF_VS_M2_M1,
          621 => Opcode::PseudoVAESDF_VS_M2_M2,
          622 => Opcode::PseudoVAESDF_VS_M2_MF2,
          623 => Opcode::PseudoVAESDF_VS_M2_MF4,
          624 => Opcode::PseudoVAESDF_VS_M2_MF8,
          625 => Opcode::PseudoVAESDF_VS_M4_M1,
          626 => Opcode::PseudoVAESDF_VS_M4_M2,
          627 => Opcode::PseudoVAESDF_VS_M4_M4,
          628 => Opcode::PseudoVAESDF_VS_M4_MF2,
          629 => Opcode::PseudoVAESDF_VS_M4_MF4,
          630 => Opcode::PseudoVAESDF_VS_M4_MF8,
          631 => Opcode::PseudoVAESDF_VS_M8_M1,
          632 => Opcode::PseudoVAESDF_VS_M8_M2,
          633 => Opcode::PseudoVAESDF_VS_M8_M4,
          634 => Opcode::PseudoVAESDF_VS_M8_MF2,
          635 => Opcode::PseudoVAESDF_VS_M8_MF4,
          636 => Opcode::PseudoVAESDF_VS_M8_MF8,
          637 => Opcode::PseudoVAESDF_VS_MF2_MF2,
          638 => Opcode::PseudoVAESDF_VS_MF2_MF4,
          639 => Opcode::PseudoVAESDF_VS_MF2_MF8,
          640 => Opcode::PseudoVAESDF_VV_M1,
          641 => Opcode::PseudoVAESDF_VV_M2,
          642 => Opcode::PseudoVAESDF_VV_M4,
          643 => Opcode::PseudoVAESDF_VV_M8,
          644 => Opcode::PseudoVAESDF_VV_MF2,
          645 => Opcode::PseudoVAESDM_VS_M1_M1,
          646 => Opcode::PseudoVAESDM_VS_M1_MF2,
          647 => Opcode::PseudoVAESDM_VS_M1_MF4,
          648 => Opcode::PseudoVAESDM_VS_M1_MF8,
          649 => Opcode::PseudoVAESDM_VS_M2_M1,
          650 => Opcode::PseudoVAESDM_VS_M2_M2,
          651 => Opcode::PseudoVAESDM_VS_M2_MF2,
          652 => Opcode::PseudoVAESDM_VS_M2_MF4,
          653 => Opcode::PseudoVAESDM_VS_M2_MF8,
          654 => Opcode::PseudoVAESDM_VS_M4_M1,
          655 => Opcode::PseudoVAESDM_VS_M4_M2,
          656 => Opcode::PseudoVAESDM_VS_M4_M4,
          657 => Opcode::PseudoVAESDM_VS_M4_MF2,
          658 => Opcode::PseudoVAESDM_VS_M4_MF4,
          659 => Opcode::PseudoVAESDM_VS_M4_MF8,
          660 => Opcode::PseudoVAESDM_VS_M8_M1,
          661 => Opcode::PseudoVAESDM_VS_M8_M2,
          662 => Opcode::PseudoVAESDM_VS_M8_M4,
          663 => Opcode::PseudoVAESDM_VS_M8_MF2,
          664 => Opcode::PseudoVAESDM_VS_M8_MF4,
          665 => Opcode::PseudoVAESDM_VS_M8_MF8,
          666 => Opcode::PseudoVAESDM_VS_MF2_MF2,
          667 => Opcode::PseudoVAESDM_VS_MF2_MF4,
          668 => Opcode::PseudoVAESDM_VS_MF2_MF8,
          669 => Opcode::PseudoVAESDM_VV_M1,
          670 => Opcode::PseudoVAESDM_VV_M2,
          671 => Opcode::PseudoVAESDM_VV_M4,
          672 => Opcode::PseudoVAESDM_VV_M8,
          673 => Opcode::PseudoVAESDM_VV_MF2,
          674 => Opcode::PseudoVAESEF_VS_M1_M1,
          675 => Opcode::PseudoVAESEF_VS_M1_MF2,
          676 => Opcode::PseudoVAESEF_VS_M1_MF4,
          677 => Opcode::PseudoVAESEF_VS_M1_MF8,
          678 => Opcode::PseudoVAESEF_VS_M2_M1,
          679 => Opcode::PseudoVAESEF_VS_M2_M2,
          680 => Opcode::PseudoVAESEF_VS_M2_MF2,
          681 => Opcode::PseudoVAESEF_VS_M2_MF4,
          682 => Opcode::PseudoVAESEF_VS_M2_MF8,
          683 => Opcode::PseudoVAESEF_VS_M4_M1,
          684 => Opcode::PseudoVAESEF_VS_M4_M2,
          685 => Opcode::PseudoVAESEF_VS_M4_M4,
          686 => Opcode::PseudoVAESEF_VS_M4_MF2,
          687 => Opcode::PseudoVAESEF_VS_M4_MF4,
          688 => Opcode::PseudoVAESEF_VS_M4_MF8,
          689 => Opcode::PseudoVAESEF_VS_M8_M1,
          690 => Opcode::PseudoVAESEF_VS_M8_M2,
          691 => Opcode::PseudoVAESEF_VS_M8_M4,
          692 => Opcode::PseudoVAESEF_VS_M8_MF2,
          693 => Opcode::PseudoVAESEF_VS_M8_MF4,
          694 => Opcode::PseudoVAESEF_VS_M8_MF8,
          695 => Opcode::PseudoVAESEF_VS_MF2_MF2,
          696 => Opcode::PseudoVAESEF_VS_MF2_MF4,
          697 => Opcode::PseudoVAESEF_VS_MF2_MF8,
          698 => Opcode::PseudoVAESEF_VV_M1,
          699 => Opcode::PseudoVAESEF_VV_M2,
          700 => Opcode::PseudoVAESEF_VV_M4,
          701 => Opcode::PseudoVAESEF_VV_M8,
          702 => Opcode::PseudoVAESEF_VV_MF2,
          703 => Opcode::PseudoVAESEM_VS_M1_M1,
          704 => Opcode::PseudoVAESEM_VS_M1_MF2,
          705 => Opcode::PseudoVAESEM_VS_M1_MF4,
          706 => Opcode::PseudoVAESEM_VS_M1_MF8,
          707 => Opcode::PseudoVAESEM_VS_M2_M1,
          708 => Opcode::PseudoVAESEM_VS_M2_M2,
          709 => Opcode::PseudoVAESEM_VS_M2_MF2,
          710 => Opcode::PseudoVAESEM_VS_M2_MF4,
          711 => Opcode::PseudoVAESEM_VS_M2_MF8,
          712 => Opcode::PseudoVAESEM_VS_M4_M1,
          713 => Opcode::PseudoVAESEM_VS_M4_M2,
          714 => Opcode::PseudoVAESEM_VS_M4_M4,
          715 => Opcode::PseudoVAESEM_VS_M4_MF2,
          716 => Opcode::PseudoVAESEM_VS_M4_MF4,
          717 => Opcode::PseudoVAESEM_VS_M4_MF8,
          718 => Opcode::PseudoVAESEM_VS_M8_M1,
          719 => Opcode::PseudoVAESEM_VS_M8_M2,
          720 => Opcode::PseudoVAESEM_VS_M8_M4,
          721 => Opcode::PseudoVAESEM_VS_M8_MF2,
          722 => Opcode::PseudoVAESEM_VS_M8_MF4,
          723 => Opcode::PseudoVAESEM_VS_M8_MF8,
          724 => Opcode::PseudoVAESEM_VS_MF2_MF2,
          725 => Opcode::PseudoVAESEM_VS_MF2_MF4,
          726 => Opcode::PseudoVAESEM_VS_MF2_MF8,
          727 => Opcode::PseudoVAESEM_VV_M1,
          728 => Opcode::PseudoVAESEM_VV_M2,
          729 => Opcode::PseudoVAESEM_VV_M4,
          730 => Opcode::PseudoVAESEM_VV_M8,
          731 => Opcode::PseudoVAESEM_VV_MF2,
          732 => Opcode::PseudoVAESKF1_VI_M1,
          733 => Opcode::PseudoVAESKF1_VI_M2,
          734 => Opcode::PseudoVAESKF1_VI_M4,
          735 => Opcode::PseudoVAESKF1_VI_M8,
          736 => Opcode::PseudoVAESKF1_VI_MF2,
          737 => Opcode::PseudoVAESKF2_VI_M1,
          738 => Opcode::PseudoVAESKF2_VI_M2,
          739 => Opcode::PseudoVAESKF2_VI_M4,
          740 => Opcode::PseudoVAESKF2_VI_M8,
          741 => Opcode::PseudoVAESKF2_VI_MF2,
          742 => Opcode::PseudoVAESZ_VS_M1_M1,
          743 => Opcode::PseudoVAESZ_VS_M1_MF2,
          744 => Opcode::PseudoVAESZ_VS_M1_MF4,
          745 => Opcode::PseudoVAESZ_VS_M1_MF8,
          746 => Opcode::PseudoVAESZ_VS_M2_M1,
          747 => Opcode::PseudoVAESZ_VS_M2_M2,
          748 => Opcode::PseudoVAESZ_VS_M2_MF2,
          749 => Opcode::PseudoVAESZ_VS_M2_MF4,
          750 => Opcode::PseudoVAESZ_VS_M2_MF8,
          751 => Opcode::PseudoVAESZ_VS_M4_M1,
          752 => Opcode::PseudoVAESZ_VS_M4_M2,
          753 => Opcode::PseudoVAESZ_VS_M4_M4,
          754 => Opcode::PseudoVAESZ_VS_M4_MF2,
          755 => Opcode::PseudoVAESZ_VS_M4_MF4,
          756 => Opcode::PseudoVAESZ_VS_M4_MF8,
          757 => Opcode::PseudoVAESZ_VS_M8_M1,
          758 => Opcode::PseudoVAESZ_VS_M8_M2,
          759 => Opcode::PseudoVAESZ_VS_M8_M4,
          760 => Opcode::PseudoVAESZ_VS_M8_MF2,
          761 => Opcode::PseudoVAESZ_VS_M8_MF4,
          762 => Opcode::PseudoVAESZ_VS_M8_MF8,
          763 => Opcode::PseudoVAESZ_VS_MF2_MF2,
          764 => Opcode::PseudoVAESZ_VS_MF2_MF4,
          765 => Opcode::PseudoVAESZ_VS_MF2_MF8,
          766 => Opcode::PseudoVANDN_VV_M1,
          767 => Opcode::PseudoVANDN_VV_M1_MASK,
          768 => Opcode::PseudoVANDN_VV_M2,
          769 => Opcode::PseudoVANDN_VV_M2_MASK,
          770 => Opcode::PseudoVANDN_VV_M4,
          771 => Opcode::PseudoVANDN_VV_M4_MASK,
          772 => Opcode::PseudoVANDN_VV_M8,
          773 => Opcode::PseudoVANDN_VV_M8_MASK,
          774 => Opcode::PseudoVANDN_VV_MF2,
          775 => Opcode::PseudoVANDN_VV_MF2_MASK,
          776 => Opcode::PseudoVANDN_VV_MF4,
          777 => Opcode::PseudoVANDN_VV_MF4_MASK,
          778 => Opcode::PseudoVANDN_VV_MF8,
          779 => Opcode::PseudoVANDN_VV_MF8_MASK,
          780 => Opcode::PseudoVANDN_VX_M1,
          781 => Opcode::PseudoVANDN_VX_M1_MASK,
          782 => Opcode::PseudoVANDN_VX_M2,
          783 => Opcode::PseudoVANDN_VX_M2_MASK,
          784 => Opcode::PseudoVANDN_VX_M4,
          785 => Opcode::PseudoVANDN_VX_M4_MASK,
          786 => Opcode::PseudoVANDN_VX_M8,
          787 => Opcode::PseudoVANDN_VX_M8_MASK,
          788 => Opcode::PseudoVANDN_VX_MF2,
          789 => Opcode::PseudoVANDN_VX_MF2_MASK,
          790 => Opcode::PseudoVANDN_VX_MF4,
          791 => Opcode::PseudoVANDN_VX_MF4_MASK,
          792 => Opcode::PseudoVANDN_VX_MF8,
          793 => Opcode::PseudoVANDN_VX_MF8_MASK,
          794 => Opcode::PseudoVAND_VI_M1,
          795 => Opcode::PseudoVAND_VI_M1_MASK,
          796 => Opcode::PseudoVAND_VI_M2,
          797 => Opcode::PseudoVAND_VI_M2_MASK,
          798 => Opcode::PseudoVAND_VI_M4,
          799 => Opcode::PseudoVAND_VI_M4_MASK,
          800 => Opcode::PseudoVAND_VI_M8,
          801 => Opcode::PseudoVAND_VI_M8_MASK,
          802 => Opcode::PseudoVAND_VI_MF2,
          803 => Opcode::PseudoVAND_VI_MF2_MASK,
          804 => Opcode::PseudoVAND_VI_MF4,
          805 => Opcode::PseudoVAND_VI_MF4_MASK,
          806 => Opcode::PseudoVAND_VI_MF8,
          807 => Opcode::PseudoVAND_VI_MF8_MASK,
          808 => Opcode::PseudoVAND_VV_M1,
          809 => Opcode::PseudoVAND_VV_M1_MASK,
          810 => Opcode::PseudoVAND_VV_M2,
          811 => Opcode::PseudoVAND_VV_M2_MASK,
          812 => Opcode::PseudoVAND_VV_M4,
          813 => Opcode::PseudoVAND_VV_M4_MASK,
          814 => Opcode::PseudoVAND_VV_M8,
          815 => Opcode::PseudoVAND_VV_M8_MASK,
          816 => Opcode::PseudoVAND_VV_MF2,
          817 => Opcode::PseudoVAND_VV_MF2_MASK,
          818 => Opcode::PseudoVAND_VV_MF4,
          819 => Opcode::PseudoVAND_VV_MF4_MASK,
          820 => Opcode::PseudoVAND_VV_MF8,
          821 => Opcode::PseudoVAND_VV_MF8_MASK,
          822 => Opcode::PseudoVAND_VX_M1,
          823 => Opcode::PseudoVAND_VX_M1_MASK,
          824 => Opcode::PseudoVAND_VX_M2,
          825 => Opcode::PseudoVAND_VX_M2_MASK,
          826 => Opcode::PseudoVAND_VX_M4,
          827 => Opcode::PseudoVAND_VX_M4_MASK,
          828 => Opcode::PseudoVAND_VX_M8,
          829 => Opcode::PseudoVAND_VX_M8_MASK,
          830 => Opcode::PseudoVAND_VX_MF2,
          831 => Opcode::PseudoVAND_VX_MF2_MASK,
          832 => Opcode::PseudoVAND_VX_MF4,
          833 => Opcode::PseudoVAND_VX_MF4_MASK,
          834 => Opcode::PseudoVAND_VX_MF8,
          835 => Opcode::PseudoVAND_VX_MF8_MASK,
          836 => Opcode::PseudoVASUBU_VV_M1,
          837 => Opcode::PseudoVASUBU_VV_M1_MASK,
          838 => Opcode::PseudoVASUBU_VV_M2,
          839 => Opcode::PseudoVASUBU_VV_M2_MASK,
          840 => Opcode::PseudoVASUBU_VV_M4,
          841 => Opcode::PseudoVASUBU_VV_M4_MASK,
          842 => Opcode::PseudoVASUBU_VV_M8,
          843 => Opcode::PseudoVASUBU_VV_M8_MASK,
          844 => Opcode::PseudoVASUBU_VV_MF2,
          845 => Opcode::PseudoVASUBU_VV_MF2_MASK,
          846 => Opcode::PseudoVASUBU_VV_MF4,
          847 => Opcode::PseudoVASUBU_VV_MF4_MASK,
          848 => Opcode::PseudoVASUBU_VV_MF8,
          849 => Opcode::PseudoVASUBU_VV_MF8_MASK,
          850 => Opcode::PseudoVASUBU_VX_M1,
          851 => Opcode::PseudoVASUBU_VX_M1_MASK,
          852 => Opcode::PseudoVASUBU_VX_M2,
          853 => Opcode::PseudoVASUBU_VX_M2_MASK,
          854 => Opcode::PseudoVASUBU_VX_M4,
          855 => Opcode::PseudoVASUBU_VX_M4_MASK,
          856 => Opcode::PseudoVASUBU_VX_M8,
          857 => Opcode::PseudoVASUBU_VX_M8_MASK,
          858 => Opcode::PseudoVASUBU_VX_MF2,
          859 => Opcode::PseudoVASUBU_VX_MF2_MASK,
          860 => Opcode::PseudoVASUBU_VX_MF4,
          861 => Opcode::PseudoVASUBU_VX_MF4_MASK,
          862 => Opcode::PseudoVASUBU_VX_MF8,
          863 => Opcode::PseudoVASUBU_VX_MF8_MASK,
          864 => Opcode::PseudoVASUB_VV_M1,
          865 => Opcode::PseudoVASUB_VV_M1_MASK,
          866 => Opcode::PseudoVASUB_VV_M2,
          867 => Opcode::PseudoVASUB_VV_M2_MASK,
          868 => Opcode::PseudoVASUB_VV_M4,
          869 => Opcode::PseudoVASUB_VV_M4_MASK,
          870 => Opcode::PseudoVASUB_VV_M8,
          871 => Opcode::PseudoVASUB_VV_M8_MASK,
          872 => Opcode::PseudoVASUB_VV_MF2,
          873 => Opcode::PseudoVASUB_VV_MF2_MASK,
          874 => Opcode::PseudoVASUB_VV_MF4,
          875 => Opcode::PseudoVASUB_VV_MF4_MASK,
          876 => Opcode::PseudoVASUB_VV_MF8,
          877 => Opcode::PseudoVASUB_VV_MF8_MASK,
          878 => Opcode::PseudoVASUB_VX_M1,
          879 => Opcode::PseudoVASUB_VX_M1_MASK,
          880 => Opcode::PseudoVASUB_VX_M2,
          881 => Opcode::PseudoVASUB_VX_M2_MASK,
          882 => Opcode::PseudoVASUB_VX_M4,
          883 => Opcode::PseudoVASUB_VX_M4_MASK,
          884 => Opcode::PseudoVASUB_VX_M8,
          885 => Opcode::PseudoVASUB_VX_M8_MASK,
          886 => Opcode::PseudoVASUB_VX_MF2,
          887 => Opcode::PseudoVASUB_VX_MF2_MASK,
          888 => Opcode::PseudoVASUB_VX_MF4,
          889 => Opcode::PseudoVASUB_VX_MF4_MASK,
          890 => Opcode::PseudoVASUB_VX_MF8,
          891 => Opcode::PseudoVASUB_VX_MF8_MASK,
          892 => Opcode::PseudoVBREV8_V_M1,
          893 => Opcode::PseudoVBREV8_V_M1_MASK,
          894 => Opcode::PseudoVBREV8_V_M2,
          895 => Opcode::PseudoVBREV8_V_M2_MASK,
          896 => Opcode::PseudoVBREV8_V_M4,
          897 => Opcode::PseudoVBREV8_V_M4_MASK,
          898 => Opcode::PseudoVBREV8_V_M8,
          899 => Opcode::PseudoVBREV8_V_M8_MASK,
          900 => Opcode::PseudoVBREV8_V_MF2,
          901 => Opcode::PseudoVBREV8_V_MF2_MASK,
          902 => Opcode::PseudoVBREV8_V_MF4,
          903 => Opcode::PseudoVBREV8_V_MF4_MASK,
          904 => Opcode::PseudoVBREV8_V_MF8,
          905 => Opcode::PseudoVBREV8_V_MF8_MASK,
          906 => Opcode::PseudoVBREV_V_M1,
          907 => Opcode::PseudoVBREV_V_M1_MASK,
          908 => Opcode::PseudoVBREV_V_M2,
          909 => Opcode::PseudoVBREV_V_M2_MASK,
          910 => Opcode::PseudoVBREV_V_M4,
          911 => Opcode::PseudoVBREV_V_M4_MASK,
          912 => Opcode::PseudoVBREV_V_M8,
          913 => Opcode::PseudoVBREV_V_M8_MASK,
          914 => Opcode::PseudoVBREV_V_MF2,
          915 => Opcode::PseudoVBREV_V_MF2_MASK,
          916 => Opcode::PseudoVBREV_V_MF4,
          917 => Opcode::PseudoVBREV_V_MF4_MASK,
          918 => Opcode::PseudoVBREV_V_MF8,
          919 => Opcode::PseudoVBREV_V_MF8_MASK,
          920 => Opcode::PseudoVCLMULH_VV_M1,
          921 => Opcode::PseudoVCLMULH_VV_M1_MASK,
          922 => Opcode::PseudoVCLMULH_VV_M2,
          923 => Opcode::PseudoVCLMULH_VV_M2_MASK,
          924 => Opcode::PseudoVCLMULH_VV_M4,
          925 => Opcode::PseudoVCLMULH_VV_M4_MASK,
          926 => Opcode::PseudoVCLMULH_VV_M8,
          927 => Opcode::PseudoVCLMULH_VV_M8_MASK,
          928 => Opcode::PseudoVCLMULH_VV_MF2,
          929 => Opcode::PseudoVCLMULH_VV_MF2_MASK,
          930 => Opcode::PseudoVCLMULH_VV_MF4,
          931 => Opcode::PseudoVCLMULH_VV_MF4_MASK,
          932 => Opcode::PseudoVCLMULH_VV_MF8,
          933 => Opcode::PseudoVCLMULH_VV_MF8_MASK,
          934 => Opcode::PseudoVCLMULH_VX_M1,
          935 => Opcode::PseudoVCLMULH_VX_M1_MASK,
          936 => Opcode::PseudoVCLMULH_VX_M2,
          937 => Opcode::PseudoVCLMULH_VX_M2_MASK,
          938 => Opcode::PseudoVCLMULH_VX_M4,
          939 => Opcode::PseudoVCLMULH_VX_M4_MASK,
          940 => Opcode::PseudoVCLMULH_VX_M8,
          941 => Opcode::PseudoVCLMULH_VX_M8_MASK,
          942 => Opcode::PseudoVCLMULH_VX_MF2,
          943 => Opcode::PseudoVCLMULH_VX_MF2_MASK,
          944 => Opcode::PseudoVCLMULH_VX_MF4,
          945 => Opcode::PseudoVCLMULH_VX_MF4_MASK,
          946 => Opcode::PseudoVCLMULH_VX_MF8,
          947 => Opcode::PseudoVCLMULH_VX_MF8_MASK,
          948 => Opcode::PseudoVCLMUL_VV_M1,
          949 => Opcode::PseudoVCLMUL_VV_M1_MASK,
          950 => Opcode::PseudoVCLMUL_VV_M2,
          951 => Opcode::PseudoVCLMUL_VV_M2_MASK,
          952 => Opcode::PseudoVCLMUL_VV_M4,
          953 => Opcode::PseudoVCLMUL_VV_M4_MASK,
          954 => Opcode::PseudoVCLMUL_VV_M8,
          955 => Opcode::PseudoVCLMUL_VV_M8_MASK,
          956 => Opcode::PseudoVCLMUL_VV_MF2,
          957 => Opcode::PseudoVCLMUL_VV_MF2_MASK,
          958 => Opcode::PseudoVCLMUL_VV_MF4,
          959 => Opcode::PseudoVCLMUL_VV_MF4_MASK,
          960 => Opcode::PseudoVCLMUL_VV_MF8,
          961 => Opcode::PseudoVCLMUL_VV_MF8_MASK,
          962 => Opcode::PseudoVCLMUL_VX_M1,
          963 => Opcode::PseudoVCLMUL_VX_M1_MASK,
          964 => Opcode::PseudoVCLMUL_VX_M2,
          965 => Opcode::PseudoVCLMUL_VX_M2_MASK,
          966 => Opcode::PseudoVCLMUL_VX_M4,
          967 => Opcode::PseudoVCLMUL_VX_M4_MASK,
          968 => Opcode::PseudoVCLMUL_VX_M8,
          969 => Opcode::PseudoVCLMUL_VX_M8_MASK,
          970 => Opcode::PseudoVCLMUL_VX_MF2,
          971 => Opcode::PseudoVCLMUL_VX_MF2_MASK,
          972 => Opcode::PseudoVCLMUL_VX_MF4,
          973 => Opcode::PseudoVCLMUL_VX_MF4_MASK,
          974 => Opcode::PseudoVCLMUL_VX_MF8,
          975 => Opcode::PseudoVCLMUL_VX_MF8_MASK,
          976 => Opcode::PseudoVCLZ_V_M1,
          977 => Opcode::PseudoVCLZ_V_M1_MASK,
          978 => Opcode::PseudoVCLZ_V_M2,
          979 => Opcode::PseudoVCLZ_V_M2_MASK,
          980 => Opcode::PseudoVCLZ_V_M4,
          981 => Opcode::PseudoVCLZ_V_M4_MASK,
          982 => Opcode::PseudoVCLZ_V_M8,
          983 => Opcode::PseudoVCLZ_V_M8_MASK,
          984 => Opcode::PseudoVCLZ_V_MF2,
          985 => Opcode::PseudoVCLZ_V_MF2_MASK,
          986 => Opcode::PseudoVCLZ_V_MF4,
          987 => Opcode::PseudoVCLZ_V_MF4_MASK,
          988 => Opcode::PseudoVCLZ_V_MF8,
          989 => Opcode::PseudoVCLZ_V_MF8_MASK,
          990 => Opcode::PseudoVCOMPRESS_VM_M1_E16,
          991 => Opcode::PseudoVCOMPRESS_VM_M1_E32,
          992 => Opcode::PseudoVCOMPRESS_VM_M1_E64,
          993 => Opcode::PseudoVCOMPRESS_VM_M1_E8,
          994 => Opcode::PseudoVCOMPRESS_VM_M2_E16,
          995 => Opcode::PseudoVCOMPRESS_VM_M2_E32,
          996 => Opcode::PseudoVCOMPRESS_VM_M2_E64,
          997 => Opcode::PseudoVCOMPRESS_VM_M2_E8,
          998 => Opcode::PseudoVCOMPRESS_VM_M4_E16,
          999 => Opcode::PseudoVCOMPRESS_VM_M4_E32,
          1000 => Opcode::PseudoVCOMPRESS_VM_M4_E64,
          1001 => Opcode::PseudoVCOMPRESS_VM_M4_E8,
          1002 => Opcode::PseudoVCOMPRESS_VM_M8_E16,
          1003 => Opcode::PseudoVCOMPRESS_VM_M8_E32,
          1004 => Opcode::PseudoVCOMPRESS_VM_M8_E64,
          1005 => Opcode::PseudoVCOMPRESS_VM_M8_E8,
          1006 => Opcode::PseudoVCOMPRESS_VM_MF2_E16,
          1007 => Opcode::PseudoVCOMPRESS_VM_MF2_E32,
          1008 => Opcode::PseudoVCOMPRESS_VM_MF2_E8,
          1009 => Opcode::PseudoVCOMPRESS_VM_MF4_E16,
          1010 => Opcode::PseudoVCOMPRESS_VM_MF4_E8,
          1011 => Opcode::PseudoVCOMPRESS_VM_MF8_E8,
          1012 => Opcode::PseudoVCPOP_M_B1,
          1013 => Opcode::PseudoVCPOP_M_B16,
          1014 => Opcode::PseudoVCPOP_M_B16_MASK,
          1015 => Opcode::PseudoVCPOP_M_B1_MASK,
          1016 => Opcode::PseudoVCPOP_M_B2,
          1017 => Opcode::PseudoVCPOP_M_B2_MASK,
          1018 => Opcode::PseudoVCPOP_M_B32,
          1019 => Opcode::PseudoVCPOP_M_B32_MASK,
          1020 => Opcode::PseudoVCPOP_M_B4,
          1021 => Opcode::PseudoVCPOP_M_B4_MASK,
          1022 => Opcode::PseudoVCPOP_M_B64,
          1023 => Opcode::PseudoVCPOP_M_B64_MASK,
          1024 => Opcode::PseudoVCPOP_M_B8,
          1025 => Opcode::PseudoVCPOP_M_B8_MASK,
          1026 => Opcode::PseudoVCPOP_V_M1,
          1027 => Opcode::PseudoVCPOP_V_M1_MASK,
          1028 => Opcode::PseudoVCPOP_V_M2,
          1029 => Opcode::PseudoVCPOP_V_M2_MASK,
          1030 => Opcode::PseudoVCPOP_V_M4,
          1031 => Opcode::PseudoVCPOP_V_M4_MASK,
          1032 => Opcode::PseudoVCPOP_V_M8,
          1033 => Opcode::PseudoVCPOP_V_M8_MASK,
          1034 => Opcode::PseudoVCPOP_V_MF2,
          1035 => Opcode::PseudoVCPOP_V_MF2_MASK,
          1036 => Opcode::PseudoVCPOP_V_MF4,
          1037 => Opcode::PseudoVCPOP_V_MF4_MASK,
          1038 => Opcode::PseudoVCPOP_V_MF8,
          1039 => Opcode::PseudoVCPOP_V_MF8_MASK,
          1040 => Opcode::PseudoVCTZ_V_M1,
          1041 => Opcode::PseudoVCTZ_V_M1_MASK,
          1042 => Opcode::PseudoVCTZ_V_M2,
          1043 => Opcode::PseudoVCTZ_V_M2_MASK,
          1044 => Opcode::PseudoVCTZ_V_M4,
          1045 => Opcode::PseudoVCTZ_V_M4_MASK,
          1046 => Opcode::PseudoVCTZ_V_M8,
          1047 => Opcode::PseudoVCTZ_V_M8_MASK,
          1048 => Opcode::PseudoVCTZ_V_MF2,
          1049 => Opcode::PseudoVCTZ_V_MF2_MASK,
          1050 => Opcode::PseudoVCTZ_V_MF4,
          1051 => Opcode::PseudoVCTZ_V_MF4_MASK,
          1052 => Opcode::PseudoVCTZ_V_MF8,
          1053 => Opcode::PseudoVCTZ_V_MF8_MASK,
          1054 => Opcode::PseudoVC_FPR16VV_SE_M1,
          1055 => Opcode::PseudoVC_FPR16VV_SE_M2,
          1056 => Opcode::PseudoVC_FPR16VV_SE_M4,
          1057 => Opcode::PseudoVC_FPR16VV_SE_M8,
          1058 => Opcode::PseudoVC_FPR16VV_SE_MF2,
          1059 => Opcode::PseudoVC_FPR16VV_SE_MF4,
          1060 => Opcode::PseudoVC_FPR16VW_SE_M1,
          1061 => Opcode::PseudoVC_FPR16VW_SE_M2,
          1062 => Opcode::PseudoVC_FPR16VW_SE_M4,
          1063 => Opcode::PseudoVC_FPR16VW_SE_M8,
          1064 => Opcode::PseudoVC_FPR16VW_SE_MF2,
          1065 => Opcode::PseudoVC_FPR16VW_SE_MF4,
          1066 => Opcode::PseudoVC_FPR16V_SE_M1,
          1067 => Opcode::PseudoVC_FPR16V_SE_M2,
          1068 => Opcode::PseudoVC_FPR16V_SE_M4,
          1069 => Opcode::PseudoVC_FPR16V_SE_M8,
          1070 => Opcode::PseudoVC_FPR16V_SE_MF2,
          1071 => Opcode::PseudoVC_FPR16V_SE_MF4,
          1072 => Opcode::PseudoVC_FPR32VV_SE_M1,
          1073 => Opcode::PseudoVC_FPR32VV_SE_M2,
          1074 => Opcode::PseudoVC_FPR32VV_SE_M4,
          1075 => Opcode::PseudoVC_FPR32VV_SE_M8,
          1076 => Opcode::PseudoVC_FPR32VV_SE_MF2,
          1077 => Opcode::PseudoVC_FPR32VW_SE_M1,
          1078 => Opcode::PseudoVC_FPR32VW_SE_M2,
          1079 => Opcode::PseudoVC_FPR32VW_SE_M4,
          1080 => Opcode::PseudoVC_FPR32VW_SE_M8,
          1081 => Opcode::PseudoVC_FPR32VW_SE_MF2,
          1082 => Opcode::PseudoVC_FPR32V_SE_M1,
          1083 => Opcode::PseudoVC_FPR32V_SE_M2,
          1084 => Opcode::PseudoVC_FPR32V_SE_M4,
          1085 => Opcode::PseudoVC_FPR32V_SE_M8,
          1086 => Opcode::PseudoVC_FPR32V_SE_MF2,
          1087 => Opcode::PseudoVC_FPR64VV_SE_M1,
          1088 => Opcode::PseudoVC_FPR64VV_SE_M2,
          1089 => Opcode::PseudoVC_FPR64VV_SE_M4,
          1090 => Opcode::PseudoVC_FPR64VV_SE_M8,
          1091 => Opcode::PseudoVC_FPR64V_SE_M1,
          1092 => Opcode::PseudoVC_FPR64V_SE_M2,
          1093 => Opcode::PseudoVC_FPR64V_SE_M4,
          1094 => Opcode::PseudoVC_FPR64V_SE_M8,
          1095 => Opcode::PseudoVC_IVV_SE_M1,
          1096 => Opcode::PseudoVC_IVV_SE_M2,
          1097 => Opcode::PseudoVC_IVV_SE_M4,
          1098 => Opcode::PseudoVC_IVV_SE_M8,
          1099 => Opcode::PseudoVC_IVV_SE_MF2,
          1100 => Opcode::PseudoVC_IVV_SE_MF4,
          1101 => Opcode::PseudoVC_IVV_SE_MF8,
          1102 => Opcode::PseudoVC_IVW_SE_M1,
          1103 => Opcode::PseudoVC_IVW_SE_M2,
          1104 => Opcode::PseudoVC_IVW_SE_M4,
          1105 => Opcode::PseudoVC_IVW_SE_MF2,
          1106 => Opcode::PseudoVC_IVW_SE_MF4,
          1107 => Opcode::PseudoVC_IVW_SE_MF8,
          1108 => Opcode::PseudoVC_IV_SE_M1,
          1109 => Opcode::PseudoVC_IV_SE_M2,
          1110 => Opcode::PseudoVC_IV_SE_M4,
          1111 => Opcode::PseudoVC_IV_SE_M8,
          1112 => Opcode::PseudoVC_IV_SE_MF2,
          1113 => Opcode::PseudoVC_IV_SE_MF4,
          1114 => Opcode::PseudoVC_IV_SE_MF8,
          1115 => Opcode::PseudoVC_I_SE_M1,
          1116 => Opcode::PseudoVC_I_SE_M2,
          1117 => Opcode::PseudoVC_I_SE_M4,
          1118 => Opcode::PseudoVC_I_SE_M8,
          1119 => Opcode::PseudoVC_I_SE_MF2,
          1120 => Opcode::PseudoVC_I_SE_MF4,
          1121 => Opcode::PseudoVC_I_SE_MF8,
          1122 => Opcode::PseudoVC_VVV_SE_M1,
          1123 => Opcode::PseudoVC_VVV_SE_M2,
          1124 => Opcode::PseudoVC_VVV_SE_M4,
          1125 => Opcode::PseudoVC_VVV_SE_M8,
          1126 => Opcode::PseudoVC_VVV_SE_MF2,
          1127 => Opcode::PseudoVC_VVV_SE_MF4,
          1128 => Opcode::PseudoVC_VVV_SE_MF8,
          1129 => Opcode::PseudoVC_VVW_SE_M1,
          1130 => Opcode::PseudoVC_VVW_SE_M2,
          1131 => Opcode::PseudoVC_VVW_SE_M4,
          1132 => Opcode::PseudoVC_VVW_SE_MF2,
          1133 => Opcode::PseudoVC_VVW_SE_MF4,
          1134 => Opcode::PseudoVC_VVW_SE_MF8,
          1135 => Opcode::PseudoVC_VV_SE_M1,
          1136 => Opcode::PseudoVC_VV_SE_M2,
          1137 => Opcode::PseudoVC_VV_SE_M4,
          1138 => Opcode::PseudoVC_VV_SE_M8,
          1139 => Opcode::PseudoVC_VV_SE_MF2,
          1140 => Opcode::PseudoVC_VV_SE_MF4,
          1141 => Opcode::PseudoVC_VV_SE_MF8,
          1142 => Opcode::PseudoVC_V_FPR16VV_M1,
          1143 => Opcode::PseudoVC_V_FPR16VV_M2,
          1144 => Opcode::PseudoVC_V_FPR16VV_M4,
          1145 => Opcode::PseudoVC_V_FPR16VV_M8,
          1146 => Opcode::PseudoVC_V_FPR16VV_MF2,
          1147 => Opcode::PseudoVC_V_FPR16VV_MF4,
          1148 => Opcode::PseudoVC_V_FPR16VV_SE_M1,
          1149 => Opcode::PseudoVC_V_FPR16VV_SE_M2,
          1150 => Opcode::PseudoVC_V_FPR16VV_SE_M4,
          1151 => Opcode::PseudoVC_V_FPR16VV_SE_M8,
          1152 => Opcode::PseudoVC_V_FPR16VV_SE_MF2,
          1153 => Opcode::PseudoVC_V_FPR16VV_SE_MF4,
          1154 => Opcode::PseudoVC_V_FPR16VW_M1,
          1155 => Opcode::PseudoVC_V_FPR16VW_M2,
          1156 => Opcode::PseudoVC_V_FPR16VW_M4,
          1157 => Opcode::PseudoVC_V_FPR16VW_M8,
          1158 => Opcode::PseudoVC_V_FPR16VW_MF2,
          1159 => Opcode::PseudoVC_V_FPR16VW_MF4,
          1160 => Opcode::PseudoVC_V_FPR16VW_SE_M1,
          1161 => Opcode::PseudoVC_V_FPR16VW_SE_M2,
          1162 => Opcode::PseudoVC_V_FPR16VW_SE_M4,
          1163 => Opcode::PseudoVC_V_FPR16VW_SE_M8,
          1164 => Opcode::PseudoVC_V_FPR16VW_SE_MF2,
          1165 => Opcode::PseudoVC_V_FPR16VW_SE_MF4,
          1166 => Opcode::PseudoVC_V_FPR16V_M1,
          1167 => Opcode::PseudoVC_V_FPR16V_M2,
          1168 => Opcode::PseudoVC_V_FPR16V_M4,
          1169 => Opcode::PseudoVC_V_FPR16V_M8,
          1170 => Opcode::PseudoVC_V_FPR16V_MF2,
          1171 => Opcode::PseudoVC_V_FPR16V_MF4,
          1172 => Opcode::PseudoVC_V_FPR16V_SE_M1,
          1173 => Opcode::PseudoVC_V_FPR16V_SE_M2,
          1174 => Opcode::PseudoVC_V_FPR16V_SE_M4,
          1175 => Opcode::PseudoVC_V_FPR16V_SE_M8,
          1176 => Opcode::PseudoVC_V_FPR16V_SE_MF2,
          1177 => Opcode::PseudoVC_V_FPR16V_SE_MF4,
          1178 => Opcode::PseudoVC_V_FPR32VV_M1,
          1179 => Opcode::PseudoVC_V_FPR32VV_M2,
          1180 => Opcode::PseudoVC_V_FPR32VV_M4,
          1181 => Opcode::PseudoVC_V_FPR32VV_M8,
          1182 => Opcode::PseudoVC_V_FPR32VV_MF2,
          1183 => Opcode::PseudoVC_V_FPR32VV_SE_M1,
          1184 => Opcode::PseudoVC_V_FPR32VV_SE_M2,
          1185 => Opcode::PseudoVC_V_FPR32VV_SE_M4,
          1186 => Opcode::PseudoVC_V_FPR32VV_SE_M8,
          1187 => Opcode::PseudoVC_V_FPR32VV_SE_MF2,
          1188 => Opcode::PseudoVC_V_FPR32VW_M1,
          1189 => Opcode::PseudoVC_V_FPR32VW_M2,
          1190 => Opcode::PseudoVC_V_FPR32VW_M4,
          1191 => Opcode::PseudoVC_V_FPR32VW_M8,
          1192 => Opcode::PseudoVC_V_FPR32VW_MF2,
          1193 => Opcode::PseudoVC_V_FPR32VW_SE_M1,
          1194 => Opcode::PseudoVC_V_FPR32VW_SE_M2,
          1195 => Opcode::PseudoVC_V_FPR32VW_SE_M4,
          1196 => Opcode::PseudoVC_V_FPR32VW_SE_M8,
          1197 => Opcode::PseudoVC_V_FPR32VW_SE_MF2,
          1198 => Opcode::PseudoVC_V_FPR32V_M1,
          1199 => Opcode::PseudoVC_V_FPR32V_M2,
          1200 => Opcode::PseudoVC_V_FPR32V_M4,
          1201 => Opcode::PseudoVC_V_FPR32V_M8,
          1202 => Opcode::PseudoVC_V_FPR32V_MF2,
          1203 => Opcode::PseudoVC_V_FPR32V_SE_M1,
          1204 => Opcode::PseudoVC_V_FPR32V_SE_M2,
          1205 => Opcode::PseudoVC_V_FPR32V_SE_M4,
          1206 => Opcode::PseudoVC_V_FPR32V_SE_M8,
          1207 => Opcode::PseudoVC_V_FPR32V_SE_MF2,
          1208 => Opcode::PseudoVC_V_FPR64VV_M1,
          1209 => Opcode::PseudoVC_V_FPR64VV_M2,
          1210 => Opcode::PseudoVC_V_FPR64VV_M4,
          1211 => Opcode::PseudoVC_V_FPR64VV_M8,
          1212 => Opcode::PseudoVC_V_FPR64VV_SE_M1,
          1213 => Opcode::PseudoVC_V_FPR64VV_SE_M2,
          1214 => Opcode::PseudoVC_V_FPR64VV_SE_M4,
          1215 => Opcode::PseudoVC_V_FPR64VV_SE_M8,
          1216 => Opcode::PseudoVC_V_FPR64V_M1,
          1217 => Opcode::PseudoVC_V_FPR64V_M2,
          1218 => Opcode::PseudoVC_V_FPR64V_M4,
          1219 => Opcode::PseudoVC_V_FPR64V_M8,
          1220 => Opcode::PseudoVC_V_FPR64V_SE_M1,
          1221 => Opcode::PseudoVC_V_FPR64V_SE_M2,
          1222 => Opcode::PseudoVC_V_FPR64V_SE_M4,
          1223 => Opcode::PseudoVC_V_FPR64V_SE_M8,
          1224 => Opcode::PseudoVC_V_IVV_M1,
          1225 => Opcode::PseudoVC_V_IVV_M2,
          1226 => Opcode::PseudoVC_V_IVV_M4,
          1227 => Opcode::PseudoVC_V_IVV_M8,
          1228 => Opcode::PseudoVC_V_IVV_MF2,
          1229 => Opcode::PseudoVC_V_IVV_MF4,
          1230 => Opcode::PseudoVC_V_IVV_MF8,
          1231 => Opcode::PseudoVC_V_IVV_SE_M1,
          1232 => Opcode::PseudoVC_V_IVV_SE_M2,
          1233 => Opcode::PseudoVC_V_IVV_SE_M4,
          1234 => Opcode::PseudoVC_V_IVV_SE_M8,
          1235 => Opcode::PseudoVC_V_IVV_SE_MF2,
          1236 => Opcode::PseudoVC_V_IVV_SE_MF4,
          1237 => Opcode::PseudoVC_V_IVV_SE_MF8,
          1238 => Opcode::PseudoVC_V_IVW_M1,
          1239 => Opcode::PseudoVC_V_IVW_M2,
          1240 => Opcode::PseudoVC_V_IVW_M4,
          1241 => Opcode::PseudoVC_V_IVW_MF2,
          1242 => Opcode::PseudoVC_V_IVW_MF4,
          1243 => Opcode::PseudoVC_V_IVW_MF8,
          1244 => Opcode::PseudoVC_V_IVW_SE_M1,
          1245 => Opcode::PseudoVC_V_IVW_SE_M2,
          1246 => Opcode::PseudoVC_V_IVW_SE_M4,
          1247 => Opcode::PseudoVC_V_IVW_SE_MF2,
          1248 => Opcode::PseudoVC_V_IVW_SE_MF4,
          1249 => Opcode::PseudoVC_V_IVW_SE_MF8,
          1250 => Opcode::PseudoVC_V_IV_M1,
          1251 => Opcode::PseudoVC_V_IV_M2,
          1252 => Opcode::PseudoVC_V_IV_M4,
          1253 => Opcode::PseudoVC_V_IV_M8,
          1254 => Opcode::PseudoVC_V_IV_MF2,
          1255 => Opcode::PseudoVC_V_IV_MF4,
          1256 => Opcode::PseudoVC_V_IV_MF8,
          1257 => Opcode::PseudoVC_V_IV_SE_M1,
          1258 => Opcode::PseudoVC_V_IV_SE_M2,
          1259 => Opcode::PseudoVC_V_IV_SE_M4,
          1260 => Opcode::PseudoVC_V_IV_SE_M8,
          1261 => Opcode::PseudoVC_V_IV_SE_MF2,
          1262 => Opcode::PseudoVC_V_IV_SE_MF4,
          1263 => Opcode::PseudoVC_V_IV_SE_MF8,
          1264 => Opcode::PseudoVC_V_I_M1,
          1265 => Opcode::PseudoVC_V_I_M2,
          1266 => Opcode::PseudoVC_V_I_M4,
          1267 => Opcode::PseudoVC_V_I_M8,
          1268 => Opcode::PseudoVC_V_I_MF2,
          1269 => Opcode::PseudoVC_V_I_MF4,
          1270 => Opcode::PseudoVC_V_I_MF8,
          1271 => Opcode::PseudoVC_V_I_SE_M1,
          1272 => Opcode::PseudoVC_V_I_SE_M2,
          1273 => Opcode::PseudoVC_V_I_SE_M4,
          1274 => Opcode::PseudoVC_V_I_SE_M8,
          1275 => Opcode::PseudoVC_V_I_SE_MF2,
          1276 => Opcode::PseudoVC_V_I_SE_MF4,
          1277 => Opcode::PseudoVC_V_I_SE_MF8,
          1278 => Opcode::PseudoVC_V_VVV_M1,
          1279 => Opcode::PseudoVC_V_VVV_M2,
          1280 => Opcode::PseudoVC_V_VVV_M4,
          1281 => Opcode::PseudoVC_V_VVV_M8,
          1282 => Opcode::PseudoVC_V_VVV_MF2,
          1283 => Opcode::PseudoVC_V_VVV_MF4,
          1284 => Opcode::PseudoVC_V_VVV_MF8,
          1285 => Opcode::PseudoVC_V_VVV_SE_M1,
          1286 => Opcode::PseudoVC_V_VVV_SE_M2,
          1287 => Opcode::PseudoVC_V_VVV_SE_M4,
          1288 => Opcode::PseudoVC_V_VVV_SE_M8,
          1289 => Opcode::PseudoVC_V_VVV_SE_MF2,
          1290 => Opcode::PseudoVC_V_VVV_SE_MF4,
          1291 => Opcode::PseudoVC_V_VVV_SE_MF8,
          1292 => Opcode::PseudoVC_V_VVW_M1,
          1293 => Opcode::PseudoVC_V_VVW_M2,
          1294 => Opcode::PseudoVC_V_VVW_M4,
          1295 => Opcode::PseudoVC_V_VVW_MF2,
          1296 => Opcode::PseudoVC_V_VVW_MF4,
          1297 => Opcode::PseudoVC_V_VVW_MF8,
          1298 => Opcode::PseudoVC_V_VVW_SE_M1,
          1299 => Opcode::PseudoVC_V_VVW_SE_M2,
          1300 => Opcode::PseudoVC_V_VVW_SE_M4,
          1301 => Opcode::PseudoVC_V_VVW_SE_MF2,
          1302 => Opcode::PseudoVC_V_VVW_SE_MF4,
          1303 => Opcode::PseudoVC_V_VVW_SE_MF8,
          1304 => Opcode::PseudoVC_V_VV_M1,
          1305 => Opcode::PseudoVC_V_VV_M2,
          1306 => Opcode::PseudoVC_V_VV_M4,
          1307 => Opcode::PseudoVC_V_VV_M8,
          1308 => Opcode::PseudoVC_V_VV_MF2,
          1309 => Opcode::PseudoVC_V_VV_MF4,
          1310 => Opcode::PseudoVC_V_VV_MF8,
          1311 => Opcode::PseudoVC_V_VV_SE_M1,
          1312 => Opcode::PseudoVC_V_VV_SE_M2,
          1313 => Opcode::PseudoVC_V_VV_SE_M4,
          1314 => Opcode::PseudoVC_V_VV_SE_M8,
          1315 => Opcode::PseudoVC_V_VV_SE_MF2,
          1316 => Opcode::PseudoVC_V_VV_SE_MF4,
          1317 => Opcode::PseudoVC_V_VV_SE_MF8,
          1318 => Opcode::PseudoVC_V_XVV_M1,
          1319 => Opcode::PseudoVC_V_XVV_M2,
          1320 => Opcode::PseudoVC_V_XVV_M4,
          1321 => Opcode::PseudoVC_V_XVV_M8,
          1322 => Opcode::PseudoVC_V_XVV_MF2,
          1323 => Opcode::PseudoVC_V_XVV_MF4,
          1324 => Opcode::PseudoVC_V_XVV_MF8,
          1325 => Opcode::PseudoVC_V_XVV_SE_M1,
          1326 => Opcode::PseudoVC_V_XVV_SE_M2,
          1327 => Opcode::PseudoVC_V_XVV_SE_M4,
          1328 => Opcode::PseudoVC_V_XVV_SE_M8,
          1329 => Opcode::PseudoVC_V_XVV_SE_MF2,
          1330 => Opcode::PseudoVC_V_XVV_SE_MF4,
          1331 => Opcode::PseudoVC_V_XVV_SE_MF8,
          1332 => Opcode::PseudoVC_V_XVW_M1,
          1333 => Opcode::PseudoVC_V_XVW_M2,
          1334 => Opcode::PseudoVC_V_XVW_M4,
          1335 => Opcode::PseudoVC_V_XVW_MF2,
          1336 => Opcode::PseudoVC_V_XVW_MF4,
          1337 => Opcode::PseudoVC_V_XVW_MF8,
          1338 => Opcode::PseudoVC_V_XVW_SE_M1,
          1339 => Opcode::PseudoVC_V_XVW_SE_M2,
          1340 => Opcode::PseudoVC_V_XVW_SE_M4,
          1341 => Opcode::PseudoVC_V_XVW_SE_MF2,
          1342 => Opcode::PseudoVC_V_XVW_SE_MF4,
          1343 => Opcode::PseudoVC_V_XVW_SE_MF8,
          1344 => Opcode::PseudoVC_V_XV_M1,
          1345 => Opcode::PseudoVC_V_XV_M2,
          1346 => Opcode::PseudoVC_V_XV_M4,
          1347 => Opcode::PseudoVC_V_XV_M8,
          1348 => Opcode::PseudoVC_V_XV_MF2,
          1349 => Opcode::PseudoVC_V_XV_MF4,
          1350 => Opcode::PseudoVC_V_XV_MF8,
          1351 => Opcode::PseudoVC_V_XV_SE_M1,
          1352 => Opcode::PseudoVC_V_XV_SE_M2,
          1353 => Opcode::PseudoVC_V_XV_SE_M4,
          1354 => Opcode::PseudoVC_V_XV_SE_M8,
          1355 => Opcode::PseudoVC_V_XV_SE_MF2,
          1356 => Opcode::PseudoVC_V_XV_SE_MF4,
          1357 => Opcode::PseudoVC_V_XV_SE_MF8,
          1358 => Opcode::PseudoVC_V_X_M1,
          1359 => Opcode::PseudoVC_V_X_M2,
          1360 => Opcode::PseudoVC_V_X_M4,
          1361 => Opcode::PseudoVC_V_X_M8,
          1362 => Opcode::PseudoVC_V_X_MF2,
          1363 => Opcode::PseudoVC_V_X_MF4,
          1364 => Opcode::PseudoVC_V_X_MF8,
          1365 => Opcode::PseudoVC_V_X_SE_M1,
          1366 => Opcode::PseudoVC_V_X_SE_M2,
          1367 => Opcode::PseudoVC_V_X_SE_M4,
          1368 => Opcode::PseudoVC_V_X_SE_M8,
          1369 => Opcode::PseudoVC_V_X_SE_MF2,
          1370 => Opcode::PseudoVC_V_X_SE_MF4,
          1371 => Opcode::PseudoVC_V_X_SE_MF8,
          1372 => Opcode::PseudoVC_XVV_SE_M1,
          1373 => Opcode::PseudoVC_XVV_SE_M2,
          1374 => Opcode::PseudoVC_XVV_SE_M4,
          1375 => Opcode::PseudoVC_XVV_SE_M8,
          1376 => Opcode::PseudoVC_XVV_SE_MF2,
          1377 => Opcode::PseudoVC_XVV_SE_MF4,
          1378 => Opcode::PseudoVC_XVV_SE_MF8,
          1379 => Opcode::PseudoVC_XVW_SE_M1,
          1380 => Opcode::PseudoVC_XVW_SE_M2,
          1381 => Opcode::PseudoVC_XVW_SE_M4,
          1382 => Opcode::PseudoVC_XVW_SE_MF2,
          1383 => Opcode::PseudoVC_XVW_SE_MF4,
          1384 => Opcode::PseudoVC_XVW_SE_MF8,
          1385 => Opcode::PseudoVC_XV_SE_M1,
          1386 => Opcode::PseudoVC_XV_SE_M2,
          1387 => Opcode::PseudoVC_XV_SE_M4,
          1388 => Opcode::PseudoVC_XV_SE_M8,
          1389 => Opcode::PseudoVC_XV_SE_MF2,
          1390 => Opcode::PseudoVC_XV_SE_MF4,
          1391 => Opcode::PseudoVC_XV_SE_MF8,
          1392 => Opcode::PseudoVC_X_SE_M1,
          1393 => Opcode::PseudoVC_X_SE_M2,
          1394 => Opcode::PseudoVC_X_SE_M4,
          1395 => Opcode::PseudoVC_X_SE_M8,
          1396 => Opcode::PseudoVC_X_SE_MF2,
          1397 => Opcode::PseudoVC_X_SE_MF4,
          1398 => Opcode::PseudoVC_X_SE_MF8,
          1399 => Opcode::PseudoVDIVU_VV_M1_E16,
          1400 => Opcode::PseudoVDIVU_VV_M1_E16_MASK,
          1401 => Opcode::PseudoVDIVU_VV_M1_E32,
          1402 => Opcode::PseudoVDIVU_VV_M1_E32_MASK,
          1403 => Opcode::PseudoVDIVU_VV_M1_E64,
          1404 => Opcode::PseudoVDIVU_VV_M1_E64_MASK,
          1405 => Opcode::PseudoVDIVU_VV_M1_E8,
          1406 => Opcode::PseudoVDIVU_VV_M1_E8_MASK,
          1407 => Opcode::PseudoVDIVU_VV_M2_E16,
          1408 => Opcode::PseudoVDIVU_VV_M2_E16_MASK,
          1409 => Opcode::PseudoVDIVU_VV_M2_E32,
          1410 => Opcode::PseudoVDIVU_VV_M2_E32_MASK,
          1411 => Opcode::PseudoVDIVU_VV_M2_E64,
          1412 => Opcode::PseudoVDIVU_VV_M2_E64_MASK,
          1413 => Opcode::PseudoVDIVU_VV_M2_E8,
          1414 => Opcode::PseudoVDIVU_VV_M2_E8_MASK,
          1415 => Opcode::PseudoVDIVU_VV_M4_E16,
          1416 => Opcode::PseudoVDIVU_VV_M4_E16_MASK,
          1417 => Opcode::PseudoVDIVU_VV_M4_E32,
          1418 => Opcode::PseudoVDIVU_VV_M4_E32_MASK,
          1419 => Opcode::PseudoVDIVU_VV_M4_E64,
          1420 => Opcode::PseudoVDIVU_VV_M4_E64_MASK,
          1421 => Opcode::PseudoVDIVU_VV_M4_E8,
          1422 => Opcode::PseudoVDIVU_VV_M4_E8_MASK,
          1423 => Opcode::PseudoVDIVU_VV_M8_E16,
          1424 => Opcode::PseudoVDIVU_VV_M8_E16_MASK,
          1425 => Opcode::PseudoVDIVU_VV_M8_E32,
          1426 => Opcode::PseudoVDIVU_VV_M8_E32_MASK,
          1427 => Opcode::PseudoVDIVU_VV_M8_E64,
          1428 => Opcode::PseudoVDIVU_VV_M8_E64_MASK,
          1429 => Opcode::PseudoVDIVU_VV_M8_E8,
          1430 => Opcode::PseudoVDIVU_VV_M8_E8_MASK,
          1431 => Opcode::PseudoVDIVU_VV_MF2_E16,
          1432 => Opcode::PseudoVDIVU_VV_MF2_E16_MASK,
          1433 => Opcode::PseudoVDIVU_VV_MF2_E32,
          1434 => Opcode::PseudoVDIVU_VV_MF2_E32_MASK,
          1435 => Opcode::PseudoVDIVU_VV_MF2_E8,
          1436 => Opcode::PseudoVDIVU_VV_MF2_E8_MASK,
          1437 => Opcode::PseudoVDIVU_VV_MF4_E16,
          1438 => Opcode::PseudoVDIVU_VV_MF4_E16_MASK,
          1439 => Opcode::PseudoVDIVU_VV_MF4_E8,
          1440 => Opcode::PseudoVDIVU_VV_MF4_E8_MASK,
          1441 => Opcode::PseudoVDIVU_VV_MF8_E8,
          1442 => Opcode::PseudoVDIVU_VV_MF8_E8_MASK,
          1443 => Opcode::PseudoVDIVU_VX_M1_E16,
          1444 => Opcode::PseudoVDIVU_VX_M1_E16_MASK,
          1445 => Opcode::PseudoVDIVU_VX_M1_E32,
          1446 => Opcode::PseudoVDIVU_VX_M1_E32_MASK,
          1447 => Opcode::PseudoVDIVU_VX_M1_E64,
          1448 => Opcode::PseudoVDIVU_VX_M1_E64_MASK,
          1449 => Opcode::PseudoVDIVU_VX_M1_E8,
          1450 => Opcode::PseudoVDIVU_VX_M1_E8_MASK,
          1451 => Opcode::PseudoVDIVU_VX_M2_E16,
          1452 => Opcode::PseudoVDIVU_VX_M2_E16_MASK,
          1453 => Opcode::PseudoVDIVU_VX_M2_E32,
          1454 => Opcode::PseudoVDIVU_VX_M2_E32_MASK,
          1455 => Opcode::PseudoVDIVU_VX_M2_E64,
          1456 => Opcode::PseudoVDIVU_VX_M2_E64_MASK,
          1457 => Opcode::PseudoVDIVU_VX_M2_E8,
          1458 => Opcode::PseudoVDIVU_VX_M2_E8_MASK,
          1459 => Opcode::PseudoVDIVU_VX_M4_E16,
          1460 => Opcode::PseudoVDIVU_VX_M4_E16_MASK,
          1461 => Opcode::PseudoVDIVU_VX_M4_E32,
          1462 => Opcode::PseudoVDIVU_VX_M4_E32_MASK,
          1463 => Opcode::PseudoVDIVU_VX_M4_E64,
          1464 => Opcode::PseudoVDIVU_VX_M4_E64_MASK,
          1465 => Opcode::PseudoVDIVU_VX_M4_E8,
          1466 => Opcode::PseudoVDIVU_VX_M4_E8_MASK,
          1467 => Opcode::PseudoVDIVU_VX_M8_E16,
          1468 => Opcode::PseudoVDIVU_VX_M8_E16_MASK,
          1469 => Opcode::PseudoVDIVU_VX_M8_E32,
          1470 => Opcode::PseudoVDIVU_VX_M8_E32_MASK,
          1471 => Opcode::PseudoVDIVU_VX_M8_E64,
          1472 => Opcode::PseudoVDIVU_VX_M8_E64_MASK,
          1473 => Opcode::PseudoVDIVU_VX_M8_E8,
          1474 => Opcode::PseudoVDIVU_VX_M8_E8_MASK,
          1475 => Opcode::PseudoVDIVU_VX_MF2_E16,
          1476 => Opcode::PseudoVDIVU_VX_MF2_E16_MASK,
          1477 => Opcode::PseudoVDIVU_VX_MF2_E32,
          1478 => Opcode::PseudoVDIVU_VX_MF2_E32_MASK,
          1479 => Opcode::PseudoVDIVU_VX_MF2_E8,
          1480 => Opcode::PseudoVDIVU_VX_MF2_E8_MASK,
          1481 => Opcode::PseudoVDIVU_VX_MF4_E16,
          1482 => Opcode::PseudoVDIVU_VX_MF4_E16_MASK,
          1483 => Opcode::PseudoVDIVU_VX_MF4_E8,
          1484 => Opcode::PseudoVDIVU_VX_MF4_E8_MASK,
          1485 => Opcode::PseudoVDIVU_VX_MF8_E8,
          1486 => Opcode::PseudoVDIVU_VX_MF8_E8_MASK,
          1487 => Opcode::PseudoVDIV_VV_M1_E16,
          1488 => Opcode::PseudoVDIV_VV_M1_E16_MASK,
          1489 => Opcode::PseudoVDIV_VV_M1_E32,
          1490 => Opcode::PseudoVDIV_VV_M1_E32_MASK,
          1491 => Opcode::PseudoVDIV_VV_M1_E64,
          1492 => Opcode::PseudoVDIV_VV_M1_E64_MASK,
          1493 => Opcode::PseudoVDIV_VV_M1_E8,
          1494 => Opcode::PseudoVDIV_VV_M1_E8_MASK,
          1495 => Opcode::PseudoVDIV_VV_M2_E16,
          1496 => Opcode::PseudoVDIV_VV_M2_E16_MASK,
          1497 => Opcode::PseudoVDIV_VV_M2_E32,
          1498 => Opcode::PseudoVDIV_VV_M2_E32_MASK,
          1499 => Opcode::PseudoVDIV_VV_M2_E64,
          1500 => Opcode::PseudoVDIV_VV_M2_E64_MASK,
          1501 => Opcode::PseudoVDIV_VV_M2_E8,
          1502 => Opcode::PseudoVDIV_VV_M2_E8_MASK,
          1503 => Opcode::PseudoVDIV_VV_M4_E16,
          1504 => Opcode::PseudoVDIV_VV_M4_E16_MASK,
          1505 => Opcode::PseudoVDIV_VV_M4_E32,
          1506 => Opcode::PseudoVDIV_VV_M4_E32_MASK,
          1507 => Opcode::PseudoVDIV_VV_M4_E64,
          1508 => Opcode::PseudoVDIV_VV_M4_E64_MASK,
          1509 => Opcode::PseudoVDIV_VV_M4_E8,
          1510 => Opcode::PseudoVDIV_VV_M4_E8_MASK,
          1511 => Opcode::PseudoVDIV_VV_M8_E16,
          1512 => Opcode::PseudoVDIV_VV_M8_E16_MASK,
          1513 => Opcode::PseudoVDIV_VV_M8_E32,
          1514 => Opcode::PseudoVDIV_VV_M8_E32_MASK,
          1515 => Opcode::PseudoVDIV_VV_M8_E64,
          1516 => Opcode::PseudoVDIV_VV_M8_E64_MASK,
          1517 => Opcode::PseudoVDIV_VV_M8_E8,
          1518 => Opcode::PseudoVDIV_VV_M8_E8_MASK,
          1519 => Opcode::PseudoVDIV_VV_MF2_E16,
          1520 => Opcode::PseudoVDIV_VV_MF2_E16_MASK,
          1521 => Opcode::PseudoVDIV_VV_MF2_E32,
          1522 => Opcode::PseudoVDIV_VV_MF2_E32_MASK,
          1523 => Opcode::PseudoVDIV_VV_MF2_E8,
          1524 => Opcode::PseudoVDIV_VV_MF2_E8_MASK,
          1525 => Opcode::PseudoVDIV_VV_MF4_E16,
          1526 => Opcode::PseudoVDIV_VV_MF4_E16_MASK,
          1527 => Opcode::PseudoVDIV_VV_MF4_E8,
          1528 => Opcode::PseudoVDIV_VV_MF4_E8_MASK,
          1529 => Opcode::PseudoVDIV_VV_MF8_E8,
          1530 => Opcode::PseudoVDIV_VV_MF8_E8_MASK,
          1531 => Opcode::PseudoVDIV_VX_M1_E16,
          1532 => Opcode::PseudoVDIV_VX_M1_E16_MASK,
          1533 => Opcode::PseudoVDIV_VX_M1_E32,
          1534 => Opcode::PseudoVDIV_VX_M1_E32_MASK,
          1535 => Opcode::PseudoVDIV_VX_M1_E64,
          1536 => Opcode::PseudoVDIV_VX_M1_E64_MASK,
          1537 => Opcode::PseudoVDIV_VX_M1_E8,
          1538 => Opcode::PseudoVDIV_VX_M1_E8_MASK,
          1539 => Opcode::PseudoVDIV_VX_M2_E16,
          1540 => Opcode::PseudoVDIV_VX_M2_E16_MASK,
          1541 => Opcode::PseudoVDIV_VX_M2_E32,
          1542 => Opcode::PseudoVDIV_VX_M2_E32_MASK,
          1543 => Opcode::PseudoVDIV_VX_M2_E64,
          1544 => Opcode::PseudoVDIV_VX_M2_E64_MASK,
          1545 => Opcode::PseudoVDIV_VX_M2_E8,
          1546 => Opcode::PseudoVDIV_VX_M2_E8_MASK,
          1547 => Opcode::PseudoVDIV_VX_M4_E16,
          1548 => Opcode::PseudoVDIV_VX_M4_E16_MASK,
          1549 => Opcode::PseudoVDIV_VX_M4_E32,
          1550 => Opcode::PseudoVDIV_VX_M4_E32_MASK,
          1551 => Opcode::PseudoVDIV_VX_M4_E64,
          1552 => Opcode::PseudoVDIV_VX_M4_E64_MASK,
          1553 => Opcode::PseudoVDIV_VX_M4_E8,
          1554 => Opcode::PseudoVDIV_VX_M4_E8_MASK,
          1555 => Opcode::PseudoVDIV_VX_M8_E16,
          1556 => Opcode::PseudoVDIV_VX_M8_E16_MASK,
          1557 => Opcode::PseudoVDIV_VX_M8_E32,
          1558 => Opcode::PseudoVDIV_VX_M8_E32_MASK,
          1559 => Opcode::PseudoVDIV_VX_M8_E64,
          1560 => Opcode::PseudoVDIV_VX_M8_E64_MASK,
          1561 => Opcode::PseudoVDIV_VX_M8_E8,
          1562 => Opcode::PseudoVDIV_VX_M8_E8_MASK,
          1563 => Opcode::PseudoVDIV_VX_MF2_E16,
          1564 => Opcode::PseudoVDIV_VX_MF2_E16_MASK,
          1565 => Opcode::PseudoVDIV_VX_MF2_E32,
          1566 => Opcode::PseudoVDIV_VX_MF2_E32_MASK,
          1567 => Opcode::PseudoVDIV_VX_MF2_E8,
          1568 => Opcode::PseudoVDIV_VX_MF2_E8_MASK,
          1569 => Opcode::PseudoVDIV_VX_MF4_E16,
          1570 => Opcode::PseudoVDIV_VX_MF4_E16_MASK,
          1571 => Opcode::PseudoVDIV_VX_MF4_E8,
          1572 => Opcode::PseudoVDIV_VX_MF4_E8_MASK,
          1573 => Opcode::PseudoVDIV_VX_MF8_E8,
          1574 => Opcode::PseudoVDIV_VX_MF8_E8_MASK,
          1575 => Opcode::PseudoVFADD_VFPR16_M1_E16,
          1576 => Opcode::PseudoVFADD_VFPR16_M1_E16_MASK,
          1577 => Opcode::PseudoVFADD_VFPR16_M2_E16,
          1578 => Opcode::PseudoVFADD_VFPR16_M2_E16_MASK,
          1579 => Opcode::PseudoVFADD_VFPR16_M4_E16,
          1580 => Opcode::PseudoVFADD_VFPR16_M4_E16_MASK,
          1581 => Opcode::PseudoVFADD_VFPR16_M8_E16,
          1582 => Opcode::PseudoVFADD_VFPR16_M8_E16_MASK,
          1583 => Opcode::PseudoVFADD_VFPR16_MF2_E16,
          1584 => Opcode::PseudoVFADD_VFPR16_MF2_E16_MASK,
          1585 => Opcode::PseudoVFADD_VFPR16_MF4_E16,
          1586 => Opcode::PseudoVFADD_VFPR16_MF4_E16_MASK,
          1587 => Opcode::PseudoVFADD_VFPR32_M1_E32,
          1588 => Opcode::PseudoVFADD_VFPR32_M1_E32_MASK,
          1589 => Opcode::PseudoVFADD_VFPR32_M2_E32,
          1590 => Opcode::PseudoVFADD_VFPR32_M2_E32_MASK,
          1591 => Opcode::PseudoVFADD_VFPR32_M4_E32,
          1592 => Opcode::PseudoVFADD_VFPR32_M4_E32_MASK,
          1593 => Opcode::PseudoVFADD_VFPR32_M8_E32,
          1594 => Opcode::PseudoVFADD_VFPR32_M8_E32_MASK,
          1595 => Opcode::PseudoVFADD_VFPR32_MF2_E32,
          1596 => Opcode::PseudoVFADD_VFPR32_MF2_E32_MASK,
          1597 => Opcode::PseudoVFADD_VFPR64_M1_E64,
          1598 => Opcode::PseudoVFADD_VFPR64_M1_E64_MASK,
          1599 => Opcode::PseudoVFADD_VFPR64_M2_E64,
          1600 => Opcode::PseudoVFADD_VFPR64_M2_E64_MASK,
          1601 => Opcode::PseudoVFADD_VFPR64_M4_E64,
          1602 => Opcode::PseudoVFADD_VFPR64_M4_E64_MASK,
          1603 => Opcode::PseudoVFADD_VFPR64_M8_E64,
          1604 => Opcode::PseudoVFADD_VFPR64_M8_E64_MASK,
          1605 => Opcode::PseudoVFADD_VV_M1_E16,
          1606 => Opcode::PseudoVFADD_VV_M1_E16_MASK,
          1607 => Opcode::PseudoVFADD_VV_M1_E32,
          1608 => Opcode::PseudoVFADD_VV_M1_E32_MASK,
          1609 => Opcode::PseudoVFADD_VV_M1_E64,
          1610 => Opcode::PseudoVFADD_VV_M1_E64_MASK,
          1611 => Opcode::PseudoVFADD_VV_M2_E16,
          1612 => Opcode::PseudoVFADD_VV_M2_E16_MASK,
          1613 => Opcode::PseudoVFADD_VV_M2_E32,
          1614 => Opcode::PseudoVFADD_VV_M2_E32_MASK,
          1615 => Opcode::PseudoVFADD_VV_M2_E64,
          1616 => Opcode::PseudoVFADD_VV_M2_E64_MASK,
          1617 => Opcode::PseudoVFADD_VV_M4_E16,
          1618 => Opcode::PseudoVFADD_VV_M4_E16_MASK,
          1619 => Opcode::PseudoVFADD_VV_M4_E32,
          1620 => Opcode::PseudoVFADD_VV_M4_E32_MASK,
          1621 => Opcode::PseudoVFADD_VV_M4_E64,
          1622 => Opcode::PseudoVFADD_VV_M4_E64_MASK,
          1623 => Opcode::PseudoVFADD_VV_M8_E16,
          1624 => Opcode::PseudoVFADD_VV_M8_E16_MASK,
          1625 => Opcode::PseudoVFADD_VV_M8_E32,
          1626 => Opcode::PseudoVFADD_VV_M8_E32_MASK,
          1627 => Opcode::PseudoVFADD_VV_M8_E64,
          1628 => Opcode::PseudoVFADD_VV_M8_E64_MASK,
          1629 => Opcode::PseudoVFADD_VV_MF2_E16,
          1630 => Opcode::PseudoVFADD_VV_MF2_E16_MASK,
          1631 => Opcode::PseudoVFADD_VV_MF2_E32,
          1632 => Opcode::PseudoVFADD_VV_MF2_E32_MASK,
          1633 => Opcode::PseudoVFADD_VV_MF4_E16,
          1634 => Opcode::PseudoVFADD_VV_MF4_E16_MASK,
          1635 => Opcode::PseudoVFCLASS_V_M1,
          1636 => Opcode::PseudoVFCLASS_V_M1_MASK,
          1637 => Opcode::PseudoVFCLASS_V_M2,
          1638 => Opcode::PseudoVFCLASS_V_M2_MASK,
          1639 => Opcode::PseudoVFCLASS_V_M4,
          1640 => Opcode::PseudoVFCLASS_V_M4_MASK,
          1641 => Opcode::PseudoVFCLASS_V_M8,
          1642 => Opcode::PseudoVFCLASS_V_M8_MASK,
          1643 => Opcode::PseudoVFCLASS_V_MF2,
          1644 => Opcode::PseudoVFCLASS_V_MF2_MASK,
          1645 => Opcode::PseudoVFCLASS_V_MF4,
          1646 => Opcode::PseudoVFCLASS_V_MF4_MASK,
          1647 => Opcode::PseudoVFCVT_F_XU_V_M1_E16,
          1648 => Opcode::PseudoVFCVT_F_XU_V_M1_E16_MASK,
          1649 => Opcode::PseudoVFCVT_F_XU_V_M1_E32,
          1650 => Opcode::PseudoVFCVT_F_XU_V_M1_E32_MASK,
          1651 => Opcode::PseudoVFCVT_F_XU_V_M1_E64,
          1652 => Opcode::PseudoVFCVT_F_XU_V_M1_E64_MASK,
          1653 => Opcode::PseudoVFCVT_F_XU_V_M2_E16,
          1654 => Opcode::PseudoVFCVT_F_XU_V_M2_E16_MASK,
          1655 => Opcode::PseudoVFCVT_F_XU_V_M2_E32,
          1656 => Opcode::PseudoVFCVT_F_XU_V_M2_E32_MASK,
          1657 => Opcode::PseudoVFCVT_F_XU_V_M2_E64,
          1658 => Opcode::PseudoVFCVT_F_XU_V_M2_E64_MASK,
          1659 => Opcode::PseudoVFCVT_F_XU_V_M4_E16,
          1660 => Opcode::PseudoVFCVT_F_XU_V_M4_E16_MASK,
          1661 => Opcode::PseudoVFCVT_F_XU_V_M4_E32,
          1662 => Opcode::PseudoVFCVT_F_XU_V_M4_E32_MASK,
          1663 => Opcode::PseudoVFCVT_F_XU_V_M4_E64,
          1664 => Opcode::PseudoVFCVT_F_XU_V_M4_E64_MASK,
          1665 => Opcode::PseudoVFCVT_F_XU_V_M8_E16,
          1666 => Opcode::PseudoVFCVT_F_XU_V_M8_E16_MASK,
          1667 => Opcode::PseudoVFCVT_F_XU_V_M8_E32,
          1668 => Opcode::PseudoVFCVT_F_XU_V_M8_E32_MASK,
          1669 => Opcode::PseudoVFCVT_F_XU_V_M8_E64,
          1670 => Opcode::PseudoVFCVT_F_XU_V_M8_E64_MASK,
          1671 => Opcode::PseudoVFCVT_F_XU_V_MF2_E16,
          1672 => Opcode::PseudoVFCVT_F_XU_V_MF2_E16_MASK,
          1673 => Opcode::PseudoVFCVT_F_XU_V_MF2_E32,
          1674 => Opcode::PseudoVFCVT_F_XU_V_MF2_E32_MASK,
          1675 => Opcode::PseudoVFCVT_F_XU_V_MF4_E16,
          1676 => Opcode::PseudoVFCVT_F_XU_V_MF4_E16_MASK,
          1677 => Opcode::PseudoVFCVT_F_X_V_M1_E16,
          1678 => Opcode::PseudoVFCVT_F_X_V_M1_E16_MASK,
          1679 => Opcode::PseudoVFCVT_F_X_V_M1_E32,
          1680 => Opcode::PseudoVFCVT_F_X_V_M1_E32_MASK,
          1681 => Opcode::PseudoVFCVT_F_X_V_M1_E64,
          1682 => Opcode::PseudoVFCVT_F_X_V_M1_E64_MASK,
          1683 => Opcode::PseudoVFCVT_F_X_V_M2_E16,
          1684 => Opcode::PseudoVFCVT_F_X_V_M2_E16_MASK,
          1685 => Opcode::PseudoVFCVT_F_X_V_M2_E32,
          1686 => Opcode::PseudoVFCVT_F_X_V_M2_E32_MASK,
          1687 => Opcode::PseudoVFCVT_F_X_V_M2_E64,
          1688 => Opcode::PseudoVFCVT_F_X_V_M2_E64_MASK,
          1689 => Opcode::PseudoVFCVT_F_X_V_M4_E16,
          1690 => Opcode::PseudoVFCVT_F_X_V_M4_E16_MASK,
          1691 => Opcode::PseudoVFCVT_F_X_V_M4_E32,
          1692 => Opcode::PseudoVFCVT_F_X_V_M4_E32_MASK,
          1693 => Opcode::PseudoVFCVT_F_X_V_M4_E64,
          1694 => Opcode::PseudoVFCVT_F_X_V_M4_E64_MASK,
          1695 => Opcode::PseudoVFCVT_F_X_V_M8_E16,
          1696 => Opcode::PseudoVFCVT_F_X_V_M8_E16_MASK,
          1697 => Opcode::PseudoVFCVT_F_X_V_M8_E32,
          1698 => Opcode::PseudoVFCVT_F_X_V_M8_E32_MASK,
          1699 => Opcode::PseudoVFCVT_F_X_V_M8_E64,
          1700 => Opcode::PseudoVFCVT_F_X_V_M8_E64_MASK,
          1701 => Opcode::PseudoVFCVT_F_X_V_MF2_E16,
          1702 => Opcode::PseudoVFCVT_F_X_V_MF2_E16_MASK,
          1703 => Opcode::PseudoVFCVT_F_X_V_MF2_E32,
          1704 => Opcode::PseudoVFCVT_F_X_V_MF2_E32_MASK,
          1705 => Opcode::PseudoVFCVT_F_X_V_MF4_E16,
          1706 => Opcode::PseudoVFCVT_F_X_V_MF4_E16_MASK,
          1707 => Opcode::PseudoVFCVT_RM_F_XU_V_M1_E16,
          1708 => Opcode::PseudoVFCVT_RM_F_XU_V_M1_E16_MASK,
          1709 => Opcode::PseudoVFCVT_RM_F_XU_V_M1_E32,
          1710 => Opcode::PseudoVFCVT_RM_F_XU_V_M1_E32_MASK,
          1711 => Opcode::PseudoVFCVT_RM_F_XU_V_M1_E64,
          1712 => Opcode::PseudoVFCVT_RM_F_XU_V_M1_E64_MASK,
          1713 => Opcode::PseudoVFCVT_RM_F_XU_V_M2_E16,
          1714 => Opcode::PseudoVFCVT_RM_F_XU_V_M2_E16_MASK,
          1715 => Opcode::PseudoVFCVT_RM_F_XU_V_M2_E32,
          1716 => Opcode::PseudoVFCVT_RM_F_XU_V_M2_E32_MASK,
          1717 => Opcode::PseudoVFCVT_RM_F_XU_V_M2_E64,
          1718 => Opcode::PseudoVFCVT_RM_F_XU_V_M2_E64_MASK,
          1719 => Opcode::PseudoVFCVT_RM_F_XU_V_M4_E16,
          1720 => Opcode::PseudoVFCVT_RM_F_XU_V_M4_E16_MASK,
          1721 => Opcode::PseudoVFCVT_RM_F_XU_V_M4_E32,
          1722 => Opcode::PseudoVFCVT_RM_F_XU_V_M4_E32_MASK,
          1723 => Opcode::PseudoVFCVT_RM_F_XU_V_M4_E64,
          1724 => Opcode::PseudoVFCVT_RM_F_XU_V_M4_E64_MASK,
          1725 => Opcode::PseudoVFCVT_RM_F_XU_V_M8_E16,
          1726 => Opcode::PseudoVFCVT_RM_F_XU_V_M8_E16_MASK,
          1727 => Opcode::PseudoVFCVT_RM_F_XU_V_M8_E32,
          1728 => Opcode::PseudoVFCVT_RM_F_XU_V_M8_E32_MASK,
          1729 => Opcode::PseudoVFCVT_RM_F_XU_V_M8_E64,
          1730 => Opcode::PseudoVFCVT_RM_F_XU_V_M8_E64_MASK,
          1731 => Opcode::PseudoVFCVT_RM_F_XU_V_MF2_E16,
          1732 => Opcode::PseudoVFCVT_RM_F_XU_V_MF2_E16_MASK,
          1733 => Opcode::PseudoVFCVT_RM_F_XU_V_MF2_E32,
          1734 => Opcode::PseudoVFCVT_RM_F_XU_V_MF2_E32_MASK,
          1735 => Opcode::PseudoVFCVT_RM_F_XU_V_MF4_E16,
          1736 => Opcode::PseudoVFCVT_RM_F_XU_V_MF4_E16_MASK,
          1737 => Opcode::PseudoVFCVT_RM_F_X_V_M1_E16,
          1738 => Opcode::PseudoVFCVT_RM_F_X_V_M1_E16_MASK,
          1739 => Opcode::PseudoVFCVT_RM_F_X_V_M1_E32,
          1740 => Opcode::PseudoVFCVT_RM_F_X_V_M1_E32_MASK,
          1741 => Opcode::PseudoVFCVT_RM_F_X_V_M1_E64,
          1742 => Opcode::PseudoVFCVT_RM_F_X_V_M1_E64_MASK,
          1743 => Opcode::PseudoVFCVT_RM_F_X_V_M2_E16,
          1744 => Opcode::PseudoVFCVT_RM_F_X_V_M2_E16_MASK,
          1745 => Opcode::PseudoVFCVT_RM_F_X_V_M2_E32,
          1746 => Opcode::PseudoVFCVT_RM_F_X_V_M2_E32_MASK,
          1747 => Opcode::PseudoVFCVT_RM_F_X_V_M2_E64,
          1748 => Opcode::PseudoVFCVT_RM_F_X_V_M2_E64_MASK,
          1749 => Opcode::PseudoVFCVT_RM_F_X_V_M4_E16,
          1750 => Opcode::PseudoVFCVT_RM_F_X_V_M4_E16_MASK,
          1751 => Opcode::PseudoVFCVT_RM_F_X_V_M4_E32,
          1752 => Opcode::PseudoVFCVT_RM_F_X_V_M4_E32_MASK,
          1753 => Opcode::PseudoVFCVT_RM_F_X_V_M4_E64,
          1754 => Opcode::PseudoVFCVT_RM_F_X_V_M4_E64_MASK,
          1755 => Opcode::PseudoVFCVT_RM_F_X_V_M8_E16,
          1756 => Opcode::PseudoVFCVT_RM_F_X_V_M8_E16_MASK,
          1757 => Opcode::PseudoVFCVT_RM_F_X_V_M8_E32,
          1758 => Opcode::PseudoVFCVT_RM_F_X_V_M8_E32_MASK,
          1759 => Opcode::PseudoVFCVT_RM_F_X_V_M8_E64,
          1760 => Opcode::PseudoVFCVT_RM_F_X_V_M8_E64_MASK,
          1761 => Opcode::PseudoVFCVT_RM_F_X_V_MF2_E16,
          1762 => Opcode::PseudoVFCVT_RM_F_X_V_MF2_E16_MASK,
          1763 => Opcode::PseudoVFCVT_RM_F_X_V_MF2_E32,
          1764 => Opcode::PseudoVFCVT_RM_F_X_V_MF2_E32_MASK,
          1765 => Opcode::PseudoVFCVT_RM_F_X_V_MF4_E16,
          1766 => Opcode::PseudoVFCVT_RM_F_X_V_MF4_E16_MASK,
          1767 => Opcode::PseudoVFCVT_RM_XU_F_V_M1,
          1768 => Opcode::PseudoVFCVT_RM_XU_F_V_M1_MASK,
          1769 => Opcode::PseudoVFCVT_RM_XU_F_V_M2,
          1770 => Opcode::PseudoVFCVT_RM_XU_F_V_M2_MASK,
          1771 => Opcode::PseudoVFCVT_RM_XU_F_V_M4,
          1772 => Opcode::PseudoVFCVT_RM_XU_F_V_M4_MASK,
          1773 => Opcode::PseudoVFCVT_RM_XU_F_V_M8,
          1774 => Opcode::PseudoVFCVT_RM_XU_F_V_M8_MASK,
          1775 => Opcode::PseudoVFCVT_RM_XU_F_V_MF2,
          1776 => Opcode::PseudoVFCVT_RM_XU_F_V_MF2_MASK,
          1777 => Opcode::PseudoVFCVT_RM_XU_F_V_MF4,
          1778 => Opcode::PseudoVFCVT_RM_XU_F_V_MF4_MASK,
          1779 => Opcode::PseudoVFCVT_RM_X_F_V_M1,
          1780 => Opcode::PseudoVFCVT_RM_X_F_V_M1_MASK,
          1781 => Opcode::PseudoVFCVT_RM_X_F_V_M2,
          1782 => Opcode::PseudoVFCVT_RM_X_F_V_M2_MASK,
          1783 => Opcode::PseudoVFCVT_RM_X_F_V_M4,
          1784 => Opcode::PseudoVFCVT_RM_X_F_V_M4_MASK,
          1785 => Opcode::PseudoVFCVT_RM_X_F_V_M8,
          1786 => Opcode::PseudoVFCVT_RM_X_F_V_M8_MASK,
          1787 => Opcode::PseudoVFCVT_RM_X_F_V_MF2,
          1788 => Opcode::PseudoVFCVT_RM_X_F_V_MF2_MASK,
          1789 => Opcode::PseudoVFCVT_RM_X_F_V_MF4,
          1790 => Opcode::PseudoVFCVT_RM_X_F_V_MF4_MASK,
          1791 => Opcode::PseudoVFCVT_RTZ_XU_F_V_M1,
          1792 => Opcode::PseudoVFCVT_RTZ_XU_F_V_M1_MASK,
          1793 => Opcode::PseudoVFCVT_RTZ_XU_F_V_M2,
          1794 => Opcode::PseudoVFCVT_RTZ_XU_F_V_M2_MASK,
          1795 => Opcode::PseudoVFCVT_RTZ_XU_F_V_M4,
          1796 => Opcode::PseudoVFCVT_RTZ_XU_F_V_M4_MASK,
          1797 => Opcode::PseudoVFCVT_RTZ_XU_F_V_M8,
          1798 => Opcode::PseudoVFCVT_RTZ_XU_F_V_M8_MASK,
          1799 => Opcode::PseudoVFCVT_RTZ_XU_F_V_MF2,
          1800 => Opcode::PseudoVFCVT_RTZ_XU_F_V_MF2_MASK,
          1801 => Opcode::PseudoVFCVT_RTZ_XU_F_V_MF4,
          1802 => Opcode::PseudoVFCVT_RTZ_XU_F_V_MF4_MASK,
          1803 => Opcode::PseudoVFCVT_RTZ_X_F_V_M1,
          1804 => Opcode::PseudoVFCVT_RTZ_X_F_V_M1_MASK,
          1805 => Opcode::PseudoVFCVT_RTZ_X_F_V_M2,
          1806 => Opcode::PseudoVFCVT_RTZ_X_F_V_M2_MASK,
          1807 => Opcode::PseudoVFCVT_RTZ_X_F_V_M4,
          1808 => Opcode::PseudoVFCVT_RTZ_X_F_V_M4_MASK,
          1809 => Opcode::PseudoVFCVT_RTZ_X_F_V_M8,
          1810 => Opcode::PseudoVFCVT_RTZ_X_F_V_M8_MASK,
          1811 => Opcode::PseudoVFCVT_RTZ_X_F_V_MF2,
          1812 => Opcode::PseudoVFCVT_RTZ_X_F_V_MF2_MASK,
          1813 => Opcode::PseudoVFCVT_RTZ_X_F_V_MF4,
          1814 => Opcode::PseudoVFCVT_RTZ_X_F_V_MF4_MASK,
          1815 => Opcode::PseudoVFCVT_XU_F_V_M1,
          1816 => Opcode::PseudoVFCVT_XU_F_V_M1_MASK,
          1817 => Opcode::PseudoVFCVT_XU_F_V_M2,
          1818 => Opcode::PseudoVFCVT_XU_F_V_M2_MASK,
          1819 => Opcode::PseudoVFCVT_XU_F_V_M4,
          1820 => Opcode::PseudoVFCVT_XU_F_V_M4_MASK,
          1821 => Opcode::PseudoVFCVT_XU_F_V_M8,
          1822 => Opcode::PseudoVFCVT_XU_F_V_M8_MASK,
          1823 => Opcode::PseudoVFCVT_XU_F_V_MF2,
          1824 => Opcode::PseudoVFCVT_XU_F_V_MF2_MASK,
          1825 => Opcode::PseudoVFCVT_XU_F_V_MF4,
          1826 => Opcode::PseudoVFCVT_XU_F_V_MF4_MASK,
          1827 => Opcode::PseudoVFCVT_X_F_V_M1,
          1828 => Opcode::PseudoVFCVT_X_F_V_M1_MASK,
          1829 => Opcode::PseudoVFCVT_X_F_V_M2,
          1830 => Opcode::PseudoVFCVT_X_F_V_M2_MASK,
          1831 => Opcode::PseudoVFCVT_X_F_V_M4,
          1832 => Opcode::PseudoVFCVT_X_F_V_M4_MASK,
          1833 => Opcode::PseudoVFCVT_X_F_V_M8,
          1834 => Opcode::PseudoVFCVT_X_F_V_M8_MASK,
          1835 => Opcode::PseudoVFCVT_X_F_V_MF2,
          1836 => Opcode::PseudoVFCVT_X_F_V_MF2_MASK,
          1837 => Opcode::PseudoVFCVT_X_F_V_MF4,
          1838 => Opcode::PseudoVFCVT_X_F_V_MF4_MASK,
          1839 => Opcode::PseudoVFDIV_VFPR16_M1_E16,
          1840 => Opcode::PseudoVFDIV_VFPR16_M1_E16_MASK,
          1841 => Opcode::PseudoVFDIV_VFPR16_M2_E16,
          1842 => Opcode::PseudoVFDIV_VFPR16_M2_E16_MASK,
          1843 => Opcode::PseudoVFDIV_VFPR16_M4_E16,
          1844 => Opcode::PseudoVFDIV_VFPR16_M4_E16_MASK,
          1845 => Opcode::PseudoVFDIV_VFPR16_M8_E16,
          1846 => Opcode::PseudoVFDIV_VFPR16_M8_E16_MASK,
          1847 => Opcode::PseudoVFDIV_VFPR16_MF2_E16,
          1848 => Opcode::PseudoVFDIV_VFPR16_MF2_E16_MASK,
          1849 => Opcode::PseudoVFDIV_VFPR16_MF4_E16,
          1850 => Opcode::PseudoVFDIV_VFPR16_MF4_E16_MASK,
          1851 => Opcode::PseudoVFDIV_VFPR32_M1_E32,
          1852 => Opcode::PseudoVFDIV_VFPR32_M1_E32_MASK,
          1853 => Opcode::PseudoVFDIV_VFPR32_M2_E32,
          1854 => Opcode::PseudoVFDIV_VFPR32_M2_E32_MASK,
          1855 => Opcode::PseudoVFDIV_VFPR32_M4_E32,
          1856 => Opcode::PseudoVFDIV_VFPR32_M4_E32_MASK,
          1857 => Opcode::PseudoVFDIV_VFPR32_M8_E32,
          1858 => Opcode::PseudoVFDIV_VFPR32_M8_E32_MASK,
          1859 => Opcode::PseudoVFDIV_VFPR32_MF2_E32,
          1860 => Opcode::PseudoVFDIV_VFPR32_MF2_E32_MASK,
          1861 => Opcode::PseudoVFDIV_VFPR64_M1_E64,
          1862 => Opcode::PseudoVFDIV_VFPR64_M1_E64_MASK,
          1863 => Opcode::PseudoVFDIV_VFPR64_M2_E64,
          1864 => Opcode::PseudoVFDIV_VFPR64_M2_E64_MASK,
          1865 => Opcode::PseudoVFDIV_VFPR64_M4_E64,
          1866 => Opcode::PseudoVFDIV_VFPR64_M4_E64_MASK,
          1867 => Opcode::PseudoVFDIV_VFPR64_M8_E64,
          1868 => Opcode::PseudoVFDIV_VFPR64_M8_E64_MASK,
          1869 => Opcode::PseudoVFDIV_VV_M1_E16,
          1870 => Opcode::PseudoVFDIV_VV_M1_E16_MASK,
          1871 => Opcode::PseudoVFDIV_VV_M1_E32,
          1872 => Opcode::PseudoVFDIV_VV_M1_E32_MASK,
          1873 => Opcode::PseudoVFDIV_VV_M1_E64,
          1874 => Opcode::PseudoVFDIV_VV_M1_E64_MASK,
          1875 => Opcode::PseudoVFDIV_VV_M2_E16,
          1876 => Opcode::PseudoVFDIV_VV_M2_E16_MASK,
          1877 => Opcode::PseudoVFDIV_VV_M2_E32,
          1878 => Opcode::PseudoVFDIV_VV_M2_E32_MASK,
          1879 => Opcode::PseudoVFDIV_VV_M2_E64,
          1880 => Opcode::PseudoVFDIV_VV_M2_E64_MASK,
          1881 => Opcode::PseudoVFDIV_VV_M4_E16,
          1882 => Opcode::PseudoVFDIV_VV_M4_E16_MASK,
          1883 => Opcode::PseudoVFDIV_VV_M4_E32,
          1884 => Opcode::PseudoVFDIV_VV_M4_E32_MASK,
          1885 => Opcode::PseudoVFDIV_VV_M4_E64,
          1886 => Opcode::PseudoVFDIV_VV_M4_E64_MASK,
          1887 => Opcode::PseudoVFDIV_VV_M8_E16,
          1888 => Opcode::PseudoVFDIV_VV_M8_E16_MASK,
          1889 => Opcode::PseudoVFDIV_VV_M8_E32,
          1890 => Opcode::PseudoVFDIV_VV_M8_E32_MASK,
          1891 => Opcode::PseudoVFDIV_VV_M8_E64,
          1892 => Opcode::PseudoVFDIV_VV_M8_E64_MASK,
          1893 => Opcode::PseudoVFDIV_VV_MF2_E16,
          1894 => Opcode::PseudoVFDIV_VV_MF2_E16_MASK,
          1895 => Opcode::PseudoVFDIV_VV_MF2_E32,
          1896 => Opcode::PseudoVFDIV_VV_MF2_E32_MASK,
          1897 => Opcode::PseudoVFDIV_VV_MF4_E16,
          1898 => Opcode::PseudoVFDIV_VV_MF4_E16_MASK,
          1899 => Opcode::PseudoVFIRST_M_B1,
          1900 => Opcode::PseudoVFIRST_M_B16,
          1901 => Opcode::PseudoVFIRST_M_B16_MASK,
          1902 => Opcode::PseudoVFIRST_M_B1_MASK,
          1903 => Opcode::PseudoVFIRST_M_B2,
          1904 => Opcode::PseudoVFIRST_M_B2_MASK,
          1905 => Opcode::PseudoVFIRST_M_B32,
          1906 => Opcode::PseudoVFIRST_M_B32_MASK,
          1907 => Opcode::PseudoVFIRST_M_B4,
          1908 => Opcode::PseudoVFIRST_M_B4_MASK,
          1909 => Opcode::PseudoVFIRST_M_B64,
          1910 => Opcode::PseudoVFIRST_M_B64_MASK,
          1911 => Opcode::PseudoVFIRST_M_B8,
          1912 => Opcode::PseudoVFIRST_M_B8_MASK,
          1913 => Opcode::PseudoVFMACC_VFPR16_M1_E16,
          1914 => Opcode::PseudoVFMACC_VFPR16_M1_E16_MASK,
          1915 => Opcode::PseudoVFMACC_VFPR16_M2_E16,
          1916 => Opcode::PseudoVFMACC_VFPR16_M2_E16_MASK,
          1917 => Opcode::PseudoVFMACC_VFPR16_M4_E16,
          1918 => Opcode::PseudoVFMACC_VFPR16_M4_E16_MASK,
          1919 => Opcode::PseudoVFMACC_VFPR16_M8_E16,
          1920 => Opcode::PseudoVFMACC_VFPR16_M8_E16_MASK,
          1921 => Opcode::PseudoVFMACC_VFPR16_MF2_E16,
          1922 => Opcode::PseudoVFMACC_VFPR16_MF2_E16_MASK,
          1923 => Opcode::PseudoVFMACC_VFPR16_MF4_E16,
          1924 => Opcode::PseudoVFMACC_VFPR16_MF4_E16_MASK,
          1925 => Opcode::PseudoVFMACC_VFPR32_M1_E32,
          1926 => Opcode::PseudoVFMACC_VFPR32_M1_E32_MASK,
          1927 => Opcode::PseudoVFMACC_VFPR32_M2_E32,
          1928 => Opcode::PseudoVFMACC_VFPR32_M2_E32_MASK,
          1929 => Opcode::PseudoVFMACC_VFPR32_M4_E32,
          1930 => Opcode::PseudoVFMACC_VFPR32_M4_E32_MASK,
          1931 => Opcode::PseudoVFMACC_VFPR32_M8_E32,
          1932 => Opcode::PseudoVFMACC_VFPR32_M8_E32_MASK,
          1933 => Opcode::PseudoVFMACC_VFPR32_MF2_E32,
          1934 => Opcode::PseudoVFMACC_VFPR32_MF2_E32_MASK,
          1935 => Opcode::PseudoVFMACC_VFPR64_M1_E64,
          1936 => Opcode::PseudoVFMACC_VFPR64_M1_E64_MASK,
          1937 => Opcode::PseudoVFMACC_VFPR64_M2_E64,
          1938 => Opcode::PseudoVFMACC_VFPR64_M2_E64_MASK,
          1939 => Opcode::PseudoVFMACC_VFPR64_M4_E64,
          1940 => Opcode::PseudoVFMACC_VFPR64_M4_E64_MASK,
          1941 => Opcode::PseudoVFMACC_VFPR64_M8_E64,
          1942 => Opcode::PseudoVFMACC_VFPR64_M8_E64_MASK,
          1943 => Opcode::PseudoVFMACC_VV_M1_E16,
          1944 => Opcode::PseudoVFMACC_VV_M1_E16_MASK,
          1945 => Opcode::PseudoVFMACC_VV_M1_E32,
          1946 => Opcode::PseudoVFMACC_VV_M1_E32_MASK,
          1947 => Opcode::PseudoVFMACC_VV_M1_E64,
          1948 => Opcode::PseudoVFMACC_VV_M1_E64_MASK,
          1949 => Opcode::PseudoVFMACC_VV_M2_E16,
          1950 => Opcode::PseudoVFMACC_VV_M2_E16_MASK,
          1951 => Opcode::PseudoVFMACC_VV_M2_E32,
          1952 => Opcode::PseudoVFMACC_VV_M2_E32_MASK,
          1953 => Opcode::PseudoVFMACC_VV_M2_E64,
          1954 => Opcode::PseudoVFMACC_VV_M2_E64_MASK,
          1955 => Opcode::PseudoVFMACC_VV_M4_E16,
          1956 => Opcode::PseudoVFMACC_VV_M4_E16_MASK,
          1957 => Opcode::PseudoVFMACC_VV_M4_E32,
          1958 => Opcode::PseudoVFMACC_VV_M4_E32_MASK,
          1959 => Opcode::PseudoVFMACC_VV_M4_E64,
          1960 => Opcode::PseudoVFMACC_VV_M4_E64_MASK,
          1961 => Opcode::PseudoVFMACC_VV_M8_E16,
          1962 => Opcode::PseudoVFMACC_VV_M8_E16_MASK,
          1963 => Opcode::PseudoVFMACC_VV_M8_E32,
          1964 => Opcode::PseudoVFMACC_VV_M8_E32_MASK,
          1965 => Opcode::PseudoVFMACC_VV_M8_E64,
          1966 => Opcode::PseudoVFMACC_VV_M8_E64_MASK,
          1967 => Opcode::PseudoVFMACC_VV_MF2_E16,
          1968 => Opcode::PseudoVFMACC_VV_MF2_E16_MASK,
          1969 => Opcode::PseudoVFMACC_VV_MF2_E32,
          1970 => Opcode::PseudoVFMACC_VV_MF2_E32_MASK,
          1971 => Opcode::PseudoVFMACC_VV_MF4_E16,
          1972 => Opcode::PseudoVFMACC_VV_MF4_E16_MASK,
          1973 => Opcode::PseudoVFMADD_VFPR16_M1_E16,
          1974 => Opcode::PseudoVFMADD_VFPR16_M1_E16_MASK,
          1975 => Opcode::PseudoVFMADD_VFPR16_M2_E16,
          1976 => Opcode::PseudoVFMADD_VFPR16_M2_E16_MASK,
          1977 => Opcode::PseudoVFMADD_VFPR16_M4_E16,
          1978 => Opcode::PseudoVFMADD_VFPR16_M4_E16_MASK,
          1979 => Opcode::PseudoVFMADD_VFPR16_M8_E16,
          1980 => Opcode::PseudoVFMADD_VFPR16_M8_E16_MASK,
          1981 => Opcode::PseudoVFMADD_VFPR16_MF2_E16,
          1982 => Opcode::PseudoVFMADD_VFPR16_MF2_E16_MASK,
          1983 => Opcode::PseudoVFMADD_VFPR16_MF4_E16,
          1984 => Opcode::PseudoVFMADD_VFPR16_MF4_E16_MASK,
          1985 => Opcode::PseudoVFMADD_VFPR32_M1_E32,
          1986 => Opcode::PseudoVFMADD_VFPR32_M1_E32_MASK,
          1987 => Opcode::PseudoVFMADD_VFPR32_M2_E32,
          1988 => Opcode::PseudoVFMADD_VFPR32_M2_E32_MASK,
          1989 => Opcode::PseudoVFMADD_VFPR32_M4_E32,
          1990 => Opcode::PseudoVFMADD_VFPR32_M4_E32_MASK,
          1991 => Opcode::PseudoVFMADD_VFPR32_M8_E32,
          1992 => Opcode::PseudoVFMADD_VFPR32_M8_E32_MASK,
          1993 => Opcode::PseudoVFMADD_VFPR32_MF2_E32,
          1994 => Opcode::PseudoVFMADD_VFPR32_MF2_E32_MASK,
          1995 => Opcode::PseudoVFMADD_VFPR64_M1_E64,
          1996 => Opcode::PseudoVFMADD_VFPR64_M1_E64_MASK,
          1997 => Opcode::PseudoVFMADD_VFPR64_M2_E64,
          1998 => Opcode::PseudoVFMADD_VFPR64_M2_E64_MASK,
          1999 => Opcode::PseudoVFMADD_VFPR64_M4_E64,
          2000 => Opcode::PseudoVFMADD_VFPR64_M4_E64_MASK,
          2001 => Opcode::PseudoVFMADD_VFPR64_M8_E64,
          2002 => Opcode::PseudoVFMADD_VFPR64_M8_E64_MASK,
          2003 => Opcode::PseudoVFMADD_VV_M1_E16,
          2004 => Opcode::PseudoVFMADD_VV_M1_E16_MASK,
          2005 => Opcode::PseudoVFMADD_VV_M1_E32,
          2006 => Opcode::PseudoVFMADD_VV_M1_E32_MASK,
          2007 => Opcode::PseudoVFMADD_VV_M1_E64,
          2008 => Opcode::PseudoVFMADD_VV_M1_E64_MASK,
          2009 => Opcode::PseudoVFMADD_VV_M2_E16,
          2010 => Opcode::PseudoVFMADD_VV_M2_E16_MASK,
          2011 => Opcode::PseudoVFMADD_VV_M2_E32,
          2012 => Opcode::PseudoVFMADD_VV_M2_E32_MASK,
          2013 => Opcode::PseudoVFMADD_VV_M2_E64,
          2014 => Opcode::PseudoVFMADD_VV_M2_E64_MASK,
          2015 => Opcode::PseudoVFMADD_VV_M4_E16,
          2016 => Opcode::PseudoVFMADD_VV_M4_E16_MASK,
          2017 => Opcode::PseudoVFMADD_VV_M4_E32,
          2018 => Opcode::PseudoVFMADD_VV_M4_E32_MASK,
          2019 => Opcode::PseudoVFMADD_VV_M4_E64,
          2020 => Opcode::PseudoVFMADD_VV_M4_E64_MASK,
          2021 => Opcode::PseudoVFMADD_VV_M8_E16,
          2022 => Opcode::PseudoVFMADD_VV_M8_E16_MASK,
          2023 => Opcode::PseudoVFMADD_VV_M8_E32,
          2024 => Opcode::PseudoVFMADD_VV_M8_E32_MASK,
          2025 => Opcode::PseudoVFMADD_VV_M8_E64,
          2026 => Opcode::PseudoVFMADD_VV_M8_E64_MASK,
          2027 => Opcode::PseudoVFMADD_VV_MF2_E16,
          2028 => Opcode::PseudoVFMADD_VV_MF2_E16_MASK,
          2029 => Opcode::PseudoVFMADD_VV_MF2_E32,
          2030 => Opcode::PseudoVFMADD_VV_MF2_E32_MASK,
          2031 => Opcode::PseudoVFMADD_VV_MF4_E16,
          2032 => Opcode::PseudoVFMADD_VV_MF4_E16_MASK,
          2033 => Opcode::PseudoVFMAX_VFPR16_M1_E16,
          2034 => Opcode::PseudoVFMAX_VFPR16_M1_E16_MASK,
          2035 => Opcode::PseudoVFMAX_VFPR16_M2_E16,
          2036 => Opcode::PseudoVFMAX_VFPR16_M2_E16_MASK,
          2037 => Opcode::PseudoVFMAX_VFPR16_M4_E16,
          2038 => Opcode::PseudoVFMAX_VFPR16_M4_E16_MASK,
          2039 => Opcode::PseudoVFMAX_VFPR16_M8_E16,
          2040 => Opcode::PseudoVFMAX_VFPR16_M8_E16_MASK,
          2041 => Opcode::PseudoVFMAX_VFPR16_MF2_E16,
          2042 => Opcode::PseudoVFMAX_VFPR16_MF2_E16_MASK,
          2043 => Opcode::PseudoVFMAX_VFPR16_MF4_E16,
          2044 => Opcode::PseudoVFMAX_VFPR16_MF4_E16_MASK,
          2045 => Opcode::PseudoVFMAX_VFPR32_M1_E32,
          2046 => Opcode::PseudoVFMAX_VFPR32_M1_E32_MASK,
          2047 => Opcode::PseudoVFMAX_VFPR32_M2_E32,
          2048 => Opcode::PseudoVFMAX_VFPR32_M2_E32_MASK,
          2049 => Opcode::PseudoVFMAX_VFPR32_M4_E32,
          2050 => Opcode::PseudoVFMAX_VFPR32_M4_E32_MASK,
          2051 => Opcode::PseudoVFMAX_VFPR32_M8_E32,
          2052 => Opcode::PseudoVFMAX_VFPR32_M8_E32_MASK,
          2053 => Opcode::PseudoVFMAX_VFPR32_MF2_E32,
          2054 => Opcode::PseudoVFMAX_VFPR32_MF2_E32_MASK,
          2055 => Opcode::PseudoVFMAX_VFPR64_M1_E64,
          2056 => Opcode::PseudoVFMAX_VFPR64_M1_E64_MASK,
          2057 => Opcode::PseudoVFMAX_VFPR64_M2_E64,
          2058 => Opcode::PseudoVFMAX_VFPR64_M2_E64_MASK,
          2059 => Opcode::PseudoVFMAX_VFPR64_M4_E64,
          2060 => Opcode::PseudoVFMAX_VFPR64_M4_E64_MASK,
          2061 => Opcode::PseudoVFMAX_VFPR64_M8_E64,
          2062 => Opcode::PseudoVFMAX_VFPR64_M8_E64_MASK,
          2063 => Opcode::PseudoVFMAX_VV_M1_E16,
          2064 => Opcode::PseudoVFMAX_VV_M1_E16_MASK,
          2065 => Opcode::PseudoVFMAX_VV_M1_E32,
          2066 => Opcode::PseudoVFMAX_VV_M1_E32_MASK,
          2067 => Opcode::PseudoVFMAX_VV_M1_E64,
          2068 => Opcode::PseudoVFMAX_VV_M1_E64_MASK,
          2069 => Opcode::PseudoVFMAX_VV_M2_E16,
          2070 => Opcode::PseudoVFMAX_VV_M2_E16_MASK,
          2071 => Opcode::PseudoVFMAX_VV_M2_E32,
          2072 => Opcode::PseudoVFMAX_VV_M2_E32_MASK,
          2073 => Opcode::PseudoVFMAX_VV_M2_E64,
          2074 => Opcode::PseudoVFMAX_VV_M2_E64_MASK,
          2075 => Opcode::PseudoVFMAX_VV_M4_E16,
          2076 => Opcode::PseudoVFMAX_VV_M4_E16_MASK,
          2077 => Opcode::PseudoVFMAX_VV_M4_E32,
          2078 => Opcode::PseudoVFMAX_VV_M4_E32_MASK,
          2079 => Opcode::PseudoVFMAX_VV_M4_E64,
          2080 => Opcode::PseudoVFMAX_VV_M4_E64_MASK,
          2081 => Opcode::PseudoVFMAX_VV_M8_E16,
          2082 => Opcode::PseudoVFMAX_VV_M8_E16_MASK,
          2083 => Opcode::PseudoVFMAX_VV_M8_E32,
          2084 => Opcode::PseudoVFMAX_VV_M8_E32_MASK,
          2085 => Opcode::PseudoVFMAX_VV_M8_E64,
          2086 => Opcode::PseudoVFMAX_VV_M8_E64_MASK,
          2087 => Opcode::PseudoVFMAX_VV_MF2_E16,
          2088 => Opcode::PseudoVFMAX_VV_MF2_E16_MASK,
          2089 => Opcode::PseudoVFMAX_VV_MF2_E32,
          2090 => Opcode::PseudoVFMAX_VV_MF2_E32_MASK,
          2091 => Opcode::PseudoVFMAX_VV_MF4_E16,
          2092 => Opcode::PseudoVFMAX_VV_MF4_E16_MASK,
          2093 => Opcode::PseudoVFMERGE_VFPR16M_M1,
          2094 => Opcode::PseudoVFMERGE_VFPR16M_M2,
          2095 => Opcode::PseudoVFMERGE_VFPR16M_M4,
          2096 => Opcode::PseudoVFMERGE_VFPR16M_M8,
          2097 => Opcode::PseudoVFMERGE_VFPR16M_MF2,
          2098 => Opcode::PseudoVFMERGE_VFPR16M_MF4,
          2099 => Opcode::PseudoVFMERGE_VFPR32M_M1,
          2100 => Opcode::PseudoVFMERGE_VFPR32M_M2,
          2101 => Opcode::PseudoVFMERGE_VFPR32M_M4,
          2102 => Opcode::PseudoVFMERGE_VFPR32M_M8,
          2103 => Opcode::PseudoVFMERGE_VFPR32M_MF2,
          2104 => Opcode::PseudoVFMERGE_VFPR64M_M1,
          2105 => Opcode::PseudoVFMERGE_VFPR64M_M2,
          2106 => Opcode::PseudoVFMERGE_VFPR64M_M4,
          2107 => Opcode::PseudoVFMERGE_VFPR64M_M8,
          2108 => Opcode::PseudoVFMIN_VFPR16_M1_E16,
          2109 => Opcode::PseudoVFMIN_VFPR16_M1_E16_MASK,
          2110 => Opcode::PseudoVFMIN_VFPR16_M2_E16,
          2111 => Opcode::PseudoVFMIN_VFPR16_M2_E16_MASK,
          2112 => Opcode::PseudoVFMIN_VFPR16_M4_E16,
          2113 => Opcode::PseudoVFMIN_VFPR16_M4_E16_MASK,
          2114 => Opcode::PseudoVFMIN_VFPR16_M8_E16,
          2115 => Opcode::PseudoVFMIN_VFPR16_M8_E16_MASK,
          2116 => Opcode::PseudoVFMIN_VFPR16_MF2_E16,
          2117 => Opcode::PseudoVFMIN_VFPR16_MF2_E16_MASK,
          2118 => Opcode::PseudoVFMIN_VFPR16_MF4_E16,
          2119 => Opcode::PseudoVFMIN_VFPR16_MF4_E16_MASK,
          2120 => Opcode::PseudoVFMIN_VFPR32_M1_E32,
          2121 => Opcode::PseudoVFMIN_VFPR32_M1_E32_MASK,
          2122 => Opcode::PseudoVFMIN_VFPR32_M2_E32,
          2123 => Opcode::PseudoVFMIN_VFPR32_M2_E32_MASK,
          2124 => Opcode::PseudoVFMIN_VFPR32_M4_E32,
          2125 => Opcode::PseudoVFMIN_VFPR32_M4_E32_MASK,
          2126 => Opcode::PseudoVFMIN_VFPR32_M8_E32,
          2127 => Opcode::PseudoVFMIN_VFPR32_M8_E32_MASK,
          2128 => Opcode::PseudoVFMIN_VFPR32_MF2_E32,
          2129 => Opcode::PseudoVFMIN_VFPR32_MF2_E32_MASK,
          2130 => Opcode::PseudoVFMIN_VFPR64_M1_E64,
          2131 => Opcode::PseudoVFMIN_VFPR64_M1_E64_MASK,
          2132 => Opcode::PseudoVFMIN_VFPR64_M2_E64,
          2133 => Opcode::PseudoVFMIN_VFPR64_M2_E64_MASK,
          2134 => Opcode::PseudoVFMIN_VFPR64_M4_E64,
          2135 => Opcode::PseudoVFMIN_VFPR64_M4_E64_MASK,
          2136 => Opcode::PseudoVFMIN_VFPR64_M8_E64,
          2137 => Opcode::PseudoVFMIN_VFPR64_M8_E64_MASK,
          2138 => Opcode::PseudoVFMIN_VV_M1_E16,
          2139 => Opcode::PseudoVFMIN_VV_M1_E16_MASK,
          2140 => Opcode::PseudoVFMIN_VV_M1_E32,
          2141 => Opcode::PseudoVFMIN_VV_M1_E32_MASK,
          2142 => Opcode::PseudoVFMIN_VV_M1_E64,
          2143 => Opcode::PseudoVFMIN_VV_M1_E64_MASK,
          2144 => Opcode::PseudoVFMIN_VV_M2_E16,
          2145 => Opcode::PseudoVFMIN_VV_M2_E16_MASK,
          2146 => Opcode::PseudoVFMIN_VV_M2_E32,
          2147 => Opcode::PseudoVFMIN_VV_M2_E32_MASK,
          2148 => Opcode::PseudoVFMIN_VV_M2_E64,
          2149 => Opcode::PseudoVFMIN_VV_M2_E64_MASK,
          2150 => Opcode::PseudoVFMIN_VV_M4_E16,
          2151 => Opcode::PseudoVFMIN_VV_M4_E16_MASK,
          2152 => Opcode::PseudoVFMIN_VV_M4_E32,
          2153 => Opcode::PseudoVFMIN_VV_M4_E32_MASK,
          2154 => Opcode::PseudoVFMIN_VV_M4_E64,
          2155 => Opcode::PseudoVFMIN_VV_M4_E64_MASK,
          2156 => Opcode::PseudoVFMIN_VV_M8_E16,
          2157 => Opcode::PseudoVFMIN_VV_M8_E16_MASK,
          2158 => Opcode::PseudoVFMIN_VV_M8_E32,
          2159 => Opcode::PseudoVFMIN_VV_M8_E32_MASK,
          2160 => Opcode::PseudoVFMIN_VV_M8_E64,
          2161 => Opcode::PseudoVFMIN_VV_M8_E64_MASK,
          2162 => Opcode::PseudoVFMIN_VV_MF2_E16,
          2163 => Opcode::PseudoVFMIN_VV_MF2_E16_MASK,
          2164 => Opcode::PseudoVFMIN_VV_MF2_E32,
          2165 => Opcode::PseudoVFMIN_VV_MF2_E32_MASK,
          2166 => Opcode::PseudoVFMIN_VV_MF4_E16,
          2167 => Opcode::PseudoVFMIN_VV_MF4_E16_MASK,
          2168 => Opcode::PseudoVFMSAC_VFPR16_M1_E16,
          2169 => Opcode::PseudoVFMSAC_VFPR16_M1_E16_MASK,
          2170 => Opcode::PseudoVFMSAC_VFPR16_M2_E16,
          2171 => Opcode::PseudoVFMSAC_VFPR16_M2_E16_MASK,
          2172 => Opcode::PseudoVFMSAC_VFPR16_M4_E16,
          2173 => Opcode::PseudoVFMSAC_VFPR16_M4_E16_MASK,
          2174 => Opcode::PseudoVFMSAC_VFPR16_M8_E16,
          2175 => Opcode::PseudoVFMSAC_VFPR16_M8_E16_MASK,
          2176 => Opcode::PseudoVFMSAC_VFPR16_MF2_E16,
          2177 => Opcode::PseudoVFMSAC_VFPR16_MF2_E16_MASK,
          2178 => Opcode::PseudoVFMSAC_VFPR16_MF4_E16,
          2179 => Opcode::PseudoVFMSAC_VFPR16_MF4_E16_MASK,
          2180 => Opcode::PseudoVFMSAC_VFPR32_M1_E32,
          2181 => Opcode::PseudoVFMSAC_VFPR32_M1_E32_MASK,
          2182 => Opcode::PseudoVFMSAC_VFPR32_M2_E32,
          2183 => Opcode::PseudoVFMSAC_VFPR32_M2_E32_MASK,
          2184 => Opcode::PseudoVFMSAC_VFPR32_M4_E32,
          2185 => Opcode::PseudoVFMSAC_VFPR32_M4_E32_MASK,
          2186 => Opcode::PseudoVFMSAC_VFPR32_M8_E32,
          2187 => Opcode::PseudoVFMSAC_VFPR32_M8_E32_MASK,
          2188 => Opcode::PseudoVFMSAC_VFPR32_MF2_E32,
          2189 => Opcode::PseudoVFMSAC_VFPR32_MF2_E32_MASK,
          2190 => Opcode::PseudoVFMSAC_VFPR64_M1_E64,
          2191 => Opcode::PseudoVFMSAC_VFPR64_M1_E64_MASK,
          2192 => Opcode::PseudoVFMSAC_VFPR64_M2_E64,
          2193 => Opcode::PseudoVFMSAC_VFPR64_M2_E64_MASK,
          2194 => Opcode::PseudoVFMSAC_VFPR64_M4_E64,
          2195 => Opcode::PseudoVFMSAC_VFPR64_M4_E64_MASK,
          2196 => Opcode::PseudoVFMSAC_VFPR64_M8_E64,
          2197 => Opcode::PseudoVFMSAC_VFPR64_M8_E64_MASK,
          2198 => Opcode::PseudoVFMSAC_VV_M1_E16,
          2199 => Opcode::PseudoVFMSAC_VV_M1_E16_MASK,
          2200 => Opcode::PseudoVFMSAC_VV_M1_E32,
          2201 => Opcode::PseudoVFMSAC_VV_M1_E32_MASK,
          2202 => Opcode::PseudoVFMSAC_VV_M1_E64,
          2203 => Opcode::PseudoVFMSAC_VV_M1_E64_MASK,
          2204 => Opcode::PseudoVFMSAC_VV_M2_E16,
          2205 => Opcode::PseudoVFMSAC_VV_M2_E16_MASK,
          2206 => Opcode::PseudoVFMSAC_VV_M2_E32,
          2207 => Opcode::PseudoVFMSAC_VV_M2_E32_MASK,
          2208 => Opcode::PseudoVFMSAC_VV_M2_E64,
          2209 => Opcode::PseudoVFMSAC_VV_M2_E64_MASK,
          2210 => Opcode::PseudoVFMSAC_VV_M4_E16,
          2211 => Opcode::PseudoVFMSAC_VV_M4_E16_MASK,
          2212 => Opcode::PseudoVFMSAC_VV_M4_E32,
          2213 => Opcode::PseudoVFMSAC_VV_M4_E32_MASK,
          2214 => Opcode::PseudoVFMSAC_VV_M4_E64,
          2215 => Opcode::PseudoVFMSAC_VV_M4_E64_MASK,
          2216 => Opcode::PseudoVFMSAC_VV_M8_E16,
          2217 => Opcode::PseudoVFMSAC_VV_M8_E16_MASK,
          2218 => Opcode::PseudoVFMSAC_VV_M8_E32,
          2219 => Opcode::PseudoVFMSAC_VV_M8_E32_MASK,
          2220 => Opcode::PseudoVFMSAC_VV_M8_E64,
          2221 => Opcode::PseudoVFMSAC_VV_M8_E64_MASK,
          2222 => Opcode::PseudoVFMSAC_VV_MF2_E16,
          2223 => Opcode::PseudoVFMSAC_VV_MF2_E16_MASK,
          2224 => Opcode::PseudoVFMSAC_VV_MF2_E32,
          2225 => Opcode::PseudoVFMSAC_VV_MF2_E32_MASK,
          2226 => Opcode::PseudoVFMSAC_VV_MF4_E16,
          2227 => Opcode::PseudoVFMSAC_VV_MF4_E16_MASK,
          2228 => Opcode::PseudoVFMSUB_VFPR16_M1_E16,
          2229 => Opcode::PseudoVFMSUB_VFPR16_M1_E16_MASK,
          2230 => Opcode::PseudoVFMSUB_VFPR16_M2_E16,
          2231 => Opcode::PseudoVFMSUB_VFPR16_M2_E16_MASK,
          2232 => Opcode::PseudoVFMSUB_VFPR16_M4_E16,
          2233 => Opcode::PseudoVFMSUB_VFPR16_M4_E16_MASK,
          2234 => Opcode::PseudoVFMSUB_VFPR16_M8_E16,
          2235 => Opcode::PseudoVFMSUB_VFPR16_M8_E16_MASK,
          2236 => Opcode::PseudoVFMSUB_VFPR16_MF2_E16,
          2237 => Opcode::PseudoVFMSUB_VFPR16_MF2_E16_MASK,
          2238 => Opcode::PseudoVFMSUB_VFPR16_MF4_E16,
          2239 => Opcode::PseudoVFMSUB_VFPR16_MF4_E16_MASK,
          2240 => Opcode::PseudoVFMSUB_VFPR32_M1_E32,
          2241 => Opcode::PseudoVFMSUB_VFPR32_M1_E32_MASK,
          2242 => Opcode::PseudoVFMSUB_VFPR32_M2_E32,
          2243 => Opcode::PseudoVFMSUB_VFPR32_M2_E32_MASK,
          2244 => Opcode::PseudoVFMSUB_VFPR32_M4_E32,
          2245 => Opcode::PseudoVFMSUB_VFPR32_M4_E32_MASK,
          2246 => Opcode::PseudoVFMSUB_VFPR32_M8_E32,
          2247 => Opcode::PseudoVFMSUB_VFPR32_M8_E32_MASK,
          2248 => Opcode::PseudoVFMSUB_VFPR32_MF2_E32,
          2249 => Opcode::PseudoVFMSUB_VFPR32_MF2_E32_MASK,
          2250 => Opcode::PseudoVFMSUB_VFPR64_M1_E64,
          2251 => Opcode::PseudoVFMSUB_VFPR64_M1_E64_MASK,
          2252 => Opcode::PseudoVFMSUB_VFPR64_M2_E64,
          2253 => Opcode::PseudoVFMSUB_VFPR64_M2_E64_MASK,
          2254 => Opcode::PseudoVFMSUB_VFPR64_M4_E64,
          2255 => Opcode::PseudoVFMSUB_VFPR64_M4_E64_MASK,
          2256 => Opcode::PseudoVFMSUB_VFPR64_M8_E64,
          2257 => Opcode::PseudoVFMSUB_VFPR64_M8_E64_MASK,
          2258 => Opcode::PseudoVFMSUB_VV_M1_E16,
          2259 => Opcode::PseudoVFMSUB_VV_M1_E16_MASK,
          2260 => Opcode::PseudoVFMSUB_VV_M1_E32,
          2261 => Opcode::PseudoVFMSUB_VV_M1_E32_MASK,
          2262 => Opcode::PseudoVFMSUB_VV_M1_E64,
          2263 => Opcode::PseudoVFMSUB_VV_M1_E64_MASK,
          2264 => Opcode::PseudoVFMSUB_VV_M2_E16,
          2265 => Opcode::PseudoVFMSUB_VV_M2_E16_MASK,
          2266 => Opcode::PseudoVFMSUB_VV_M2_E32,
          2267 => Opcode::PseudoVFMSUB_VV_M2_E32_MASK,
          2268 => Opcode::PseudoVFMSUB_VV_M2_E64,
          2269 => Opcode::PseudoVFMSUB_VV_M2_E64_MASK,
          2270 => Opcode::PseudoVFMSUB_VV_M4_E16,
          2271 => Opcode::PseudoVFMSUB_VV_M4_E16_MASK,
          2272 => Opcode::PseudoVFMSUB_VV_M4_E32,
          2273 => Opcode::PseudoVFMSUB_VV_M4_E32_MASK,
          2274 => Opcode::PseudoVFMSUB_VV_M4_E64,
          2275 => Opcode::PseudoVFMSUB_VV_M4_E64_MASK,
          2276 => Opcode::PseudoVFMSUB_VV_M8_E16,
          2277 => Opcode::PseudoVFMSUB_VV_M8_E16_MASK,
          2278 => Opcode::PseudoVFMSUB_VV_M8_E32,
          2279 => Opcode::PseudoVFMSUB_VV_M8_E32_MASK,
          2280 => Opcode::PseudoVFMSUB_VV_M8_E64,
          2281 => Opcode::PseudoVFMSUB_VV_M8_E64_MASK,
          2282 => Opcode::PseudoVFMSUB_VV_MF2_E16,
          2283 => Opcode::PseudoVFMSUB_VV_MF2_E16_MASK,
          2284 => Opcode::PseudoVFMSUB_VV_MF2_E32,
          2285 => Opcode::PseudoVFMSUB_VV_MF2_E32_MASK,
          2286 => Opcode::PseudoVFMSUB_VV_MF4_E16,
          2287 => Opcode::PseudoVFMSUB_VV_MF4_E16_MASK,
          2288 => Opcode::PseudoVFMUL_VFPR16_M1_E16,
          2289 => Opcode::PseudoVFMUL_VFPR16_M1_E16_MASK,
          2290 => Opcode::PseudoVFMUL_VFPR16_M2_E16,
          2291 => Opcode::PseudoVFMUL_VFPR16_M2_E16_MASK,
          2292 => Opcode::PseudoVFMUL_VFPR16_M4_E16,
          2293 => Opcode::PseudoVFMUL_VFPR16_M4_E16_MASK,
          2294 => Opcode::PseudoVFMUL_VFPR16_M8_E16,
          2295 => Opcode::PseudoVFMUL_VFPR16_M8_E16_MASK,
          2296 => Opcode::PseudoVFMUL_VFPR16_MF2_E16,
          2297 => Opcode::PseudoVFMUL_VFPR16_MF2_E16_MASK,
          2298 => Opcode::PseudoVFMUL_VFPR16_MF4_E16,
          2299 => Opcode::PseudoVFMUL_VFPR16_MF4_E16_MASK,
          2300 => Opcode::PseudoVFMUL_VFPR32_M1_E32,
          2301 => Opcode::PseudoVFMUL_VFPR32_M1_E32_MASK,
          2302 => Opcode::PseudoVFMUL_VFPR32_M2_E32,
          2303 => Opcode::PseudoVFMUL_VFPR32_M2_E32_MASK,
          2304 => Opcode::PseudoVFMUL_VFPR32_M4_E32,
          2305 => Opcode::PseudoVFMUL_VFPR32_M4_E32_MASK,
          2306 => Opcode::PseudoVFMUL_VFPR32_M8_E32,
          2307 => Opcode::PseudoVFMUL_VFPR32_M8_E32_MASK,
          2308 => Opcode::PseudoVFMUL_VFPR32_MF2_E32,
          2309 => Opcode::PseudoVFMUL_VFPR32_MF2_E32_MASK,
          2310 => Opcode::PseudoVFMUL_VFPR64_M1_E64,
          2311 => Opcode::PseudoVFMUL_VFPR64_M1_E64_MASK,
          2312 => Opcode::PseudoVFMUL_VFPR64_M2_E64,
          2313 => Opcode::PseudoVFMUL_VFPR64_M2_E64_MASK,
          2314 => Opcode::PseudoVFMUL_VFPR64_M4_E64,
          2315 => Opcode::PseudoVFMUL_VFPR64_M4_E64_MASK,
          2316 => Opcode::PseudoVFMUL_VFPR64_M8_E64,
          2317 => Opcode::PseudoVFMUL_VFPR64_M8_E64_MASK,
          2318 => Opcode::PseudoVFMUL_VV_M1_E16,
          2319 => Opcode::PseudoVFMUL_VV_M1_E16_MASK,
          2320 => Opcode::PseudoVFMUL_VV_M1_E32,
          2321 => Opcode::PseudoVFMUL_VV_M1_E32_MASK,
          2322 => Opcode::PseudoVFMUL_VV_M1_E64,
          2323 => Opcode::PseudoVFMUL_VV_M1_E64_MASK,
          2324 => Opcode::PseudoVFMUL_VV_M2_E16,
          2325 => Opcode::PseudoVFMUL_VV_M2_E16_MASK,
          2326 => Opcode::PseudoVFMUL_VV_M2_E32,
          2327 => Opcode::PseudoVFMUL_VV_M2_E32_MASK,
          2328 => Opcode::PseudoVFMUL_VV_M2_E64,
          2329 => Opcode::PseudoVFMUL_VV_M2_E64_MASK,
          2330 => Opcode::PseudoVFMUL_VV_M4_E16,
          2331 => Opcode::PseudoVFMUL_VV_M4_E16_MASK,
          2332 => Opcode::PseudoVFMUL_VV_M4_E32,
          2333 => Opcode::PseudoVFMUL_VV_M4_E32_MASK,
          2334 => Opcode::PseudoVFMUL_VV_M4_E64,
          2335 => Opcode::PseudoVFMUL_VV_M4_E64_MASK,
          2336 => Opcode::PseudoVFMUL_VV_M8_E16,
          2337 => Opcode::PseudoVFMUL_VV_M8_E16_MASK,
          2338 => Opcode::PseudoVFMUL_VV_M8_E32,
          2339 => Opcode::PseudoVFMUL_VV_M8_E32_MASK,
          2340 => Opcode::PseudoVFMUL_VV_M8_E64,
          2341 => Opcode::PseudoVFMUL_VV_M8_E64_MASK,
          2342 => Opcode::PseudoVFMUL_VV_MF2_E16,
          2343 => Opcode::PseudoVFMUL_VV_MF2_E16_MASK,
          2344 => Opcode::PseudoVFMUL_VV_MF2_E32,
          2345 => Opcode::PseudoVFMUL_VV_MF2_E32_MASK,
          2346 => Opcode::PseudoVFMUL_VV_MF4_E16,
          2347 => Opcode::PseudoVFMUL_VV_MF4_E16_MASK,
          2348 => Opcode::PseudoVFMV_FPR16_S_M1,
          2349 => Opcode::PseudoVFMV_FPR16_S_M2,
          2350 => Opcode::PseudoVFMV_FPR16_S_M4,
          2351 => Opcode::PseudoVFMV_FPR16_S_M8,
          2352 => Opcode::PseudoVFMV_FPR16_S_MF2,
          2353 => Opcode::PseudoVFMV_FPR16_S_MF4,
          2354 => Opcode::PseudoVFMV_FPR32_S_M1,
          2355 => Opcode::PseudoVFMV_FPR32_S_M2,
          2356 => Opcode::PseudoVFMV_FPR32_S_M4,
          2357 => Opcode::PseudoVFMV_FPR32_S_M8,
          2358 => Opcode::PseudoVFMV_FPR32_S_MF2,
          2359 => Opcode::PseudoVFMV_FPR64_S_M1,
          2360 => Opcode::PseudoVFMV_FPR64_S_M2,
          2361 => Opcode::PseudoVFMV_FPR64_S_M4,
          2362 => Opcode::PseudoVFMV_FPR64_S_M8,
          2363 => Opcode::PseudoVFMV_S_FPR16_M1,
          2364 => Opcode::PseudoVFMV_S_FPR16_M2,
          2365 => Opcode::PseudoVFMV_S_FPR16_M4,
          2366 => Opcode::PseudoVFMV_S_FPR16_M8,
          2367 => Opcode::PseudoVFMV_S_FPR16_MF2,
          2368 => Opcode::PseudoVFMV_S_FPR16_MF4,
          2369 => Opcode::PseudoVFMV_S_FPR32_M1,
          2370 => Opcode::PseudoVFMV_S_FPR32_M2,
          2371 => Opcode::PseudoVFMV_S_FPR32_M4,
          2372 => Opcode::PseudoVFMV_S_FPR32_M8,
          2373 => Opcode::PseudoVFMV_S_FPR32_MF2,
          2374 => Opcode::PseudoVFMV_S_FPR64_M1,
          2375 => Opcode::PseudoVFMV_S_FPR64_M2,
          2376 => Opcode::PseudoVFMV_S_FPR64_M4,
          2377 => Opcode::PseudoVFMV_S_FPR64_M8,
          2378 => Opcode::PseudoVFMV_V_FPR16_M1,
          2379 => Opcode::PseudoVFMV_V_FPR16_M2,
          2380 => Opcode::PseudoVFMV_V_FPR16_M4,
          2381 => Opcode::PseudoVFMV_V_FPR16_M8,
          2382 => Opcode::PseudoVFMV_V_FPR16_MF2,
          2383 => Opcode::PseudoVFMV_V_FPR16_MF4,
          2384 => Opcode::PseudoVFMV_V_FPR32_M1,
          2385 => Opcode::PseudoVFMV_V_FPR32_M2,
          2386 => Opcode::PseudoVFMV_V_FPR32_M4,
          2387 => Opcode::PseudoVFMV_V_FPR32_M8,
          2388 => Opcode::PseudoVFMV_V_FPR32_MF2,
          2389 => Opcode::PseudoVFMV_V_FPR64_M1,
          2390 => Opcode::PseudoVFMV_V_FPR64_M2,
          2391 => Opcode::PseudoVFMV_V_FPR64_M4,
          2392 => Opcode::PseudoVFMV_V_FPR64_M8,
          2393 => Opcode::PseudoVFNCVTBF16_F_F_W_M1_E16,
          2394 => Opcode::PseudoVFNCVTBF16_F_F_W_M1_E16_MASK,
          2395 => Opcode::PseudoVFNCVTBF16_F_F_W_M1_E32,
          2396 => Opcode::PseudoVFNCVTBF16_F_F_W_M1_E32_MASK,
          2397 => Opcode::PseudoVFNCVTBF16_F_F_W_M2_E16,
          2398 => Opcode::PseudoVFNCVTBF16_F_F_W_M2_E16_MASK,
          2399 => Opcode::PseudoVFNCVTBF16_F_F_W_M2_E32,
          2400 => Opcode::PseudoVFNCVTBF16_F_F_W_M2_E32_MASK,
          2401 => Opcode::PseudoVFNCVTBF16_F_F_W_M4_E16,
          2402 => Opcode::PseudoVFNCVTBF16_F_F_W_M4_E16_MASK,
          2403 => Opcode::PseudoVFNCVTBF16_F_F_W_M4_E32,
          2404 => Opcode::PseudoVFNCVTBF16_F_F_W_M4_E32_MASK,
          2405 => Opcode::PseudoVFNCVTBF16_F_F_W_MF2_E16,
          2406 => Opcode::PseudoVFNCVTBF16_F_F_W_MF2_E16_MASK,
          2407 => Opcode::PseudoVFNCVTBF16_F_F_W_MF2_E32,
          2408 => Opcode::PseudoVFNCVTBF16_F_F_W_MF2_E32_MASK,
          2409 => Opcode::PseudoVFNCVTBF16_F_F_W_MF4_E16,
          2410 => Opcode::PseudoVFNCVTBF16_F_F_W_MF4_E16_MASK,
          2411 => Opcode::PseudoVFNCVT_F_F_W_M1_E16,
          2412 => Opcode::PseudoVFNCVT_F_F_W_M1_E16_MASK,
          2413 => Opcode::PseudoVFNCVT_F_F_W_M1_E32,
          2414 => Opcode::PseudoVFNCVT_F_F_W_M1_E32_MASK,
          2415 => Opcode::PseudoVFNCVT_F_F_W_M2_E16,
          2416 => Opcode::PseudoVFNCVT_F_F_W_M2_E16_MASK,
          2417 => Opcode::PseudoVFNCVT_F_F_W_M2_E32,
          2418 => Opcode::PseudoVFNCVT_F_F_W_M2_E32_MASK,
          2419 => Opcode::PseudoVFNCVT_F_F_W_M4_E16,
          2420 => Opcode::PseudoVFNCVT_F_F_W_M4_E16_MASK,
          2421 => Opcode::PseudoVFNCVT_F_F_W_M4_E32,
          2422 => Opcode::PseudoVFNCVT_F_F_W_M4_E32_MASK,
          2423 => Opcode::PseudoVFNCVT_F_F_W_MF2_E16,
          2424 => Opcode::PseudoVFNCVT_F_F_W_MF2_E16_MASK,
          2425 => Opcode::PseudoVFNCVT_F_F_W_MF2_E32,
          2426 => Opcode::PseudoVFNCVT_F_F_W_MF2_E32_MASK,
          2427 => Opcode::PseudoVFNCVT_F_F_W_MF4_E16,
          2428 => Opcode::PseudoVFNCVT_F_F_W_MF4_E16_MASK,
          2429 => Opcode::PseudoVFNCVT_F_XU_W_M1_E16,
          2430 => Opcode::PseudoVFNCVT_F_XU_W_M1_E16_MASK,
          2431 => Opcode::PseudoVFNCVT_F_XU_W_M1_E32,
          2432 => Opcode::PseudoVFNCVT_F_XU_W_M1_E32_MASK,
          2433 => Opcode::PseudoVFNCVT_F_XU_W_M2_E16,
          2434 => Opcode::PseudoVFNCVT_F_XU_W_M2_E16_MASK,
          2435 => Opcode::PseudoVFNCVT_F_XU_W_M2_E32,
          2436 => Opcode::PseudoVFNCVT_F_XU_W_M2_E32_MASK,
          2437 => Opcode::PseudoVFNCVT_F_XU_W_M4_E16,
          2438 => Opcode::PseudoVFNCVT_F_XU_W_M4_E16_MASK,
          2439 => Opcode::PseudoVFNCVT_F_XU_W_M4_E32,
          2440 => Opcode::PseudoVFNCVT_F_XU_W_M4_E32_MASK,
          2441 => Opcode::PseudoVFNCVT_F_XU_W_MF2_E16,
          2442 => Opcode::PseudoVFNCVT_F_XU_W_MF2_E16_MASK,
          2443 => Opcode::PseudoVFNCVT_F_XU_W_MF2_E32,
          2444 => Opcode::PseudoVFNCVT_F_XU_W_MF2_E32_MASK,
          2445 => Opcode::PseudoVFNCVT_F_XU_W_MF4_E16,
          2446 => Opcode::PseudoVFNCVT_F_XU_W_MF4_E16_MASK,
          2447 => Opcode::PseudoVFNCVT_F_X_W_M1_E16,
          2448 => Opcode::PseudoVFNCVT_F_X_W_M1_E16_MASK,
          2449 => Opcode::PseudoVFNCVT_F_X_W_M1_E32,
          2450 => Opcode::PseudoVFNCVT_F_X_W_M1_E32_MASK,
          2451 => Opcode::PseudoVFNCVT_F_X_W_M2_E16,
          2452 => Opcode::PseudoVFNCVT_F_X_W_M2_E16_MASK,
          2453 => Opcode::PseudoVFNCVT_F_X_W_M2_E32,
          2454 => Opcode::PseudoVFNCVT_F_X_W_M2_E32_MASK,
          2455 => Opcode::PseudoVFNCVT_F_X_W_M4_E16,
          2456 => Opcode::PseudoVFNCVT_F_X_W_M4_E16_MASK,
          2457 => Opcode::PseudoVFNCVT_F_X_W_M4_E32,
          2458 => Opcode::PseudoVFNCVT_F_X_W_M4_E32_MASK,
          2459 => Opcode::PseudoVFNCVT_F_X_W_MF2_E16,
          2460 => Opcode::PseudoVFNCVT_F_X_W_MF2_E16_MASK,
          2461 => Opcode::PseudoVFNCVT_F_X_W_MF2_E32,
          2462 => Opcode::PseudoVFNCVT_F_X_W_MF2_E32_MASK,
          2463 => Opcode::PseudoVFNCVT_F_X_W_MF4_E16,
          2464 => Opcode::PseudoVFNCVT_F_X_W_MF4_E16_MASK,
          2465 => Opcode::PseudoVFNCVT_RM_F_XU_W_M1_E16,
          2466 => Opcode::PseudoVFNCVT_RM_F_XU_W_M1_E16_MASK,
          2467 => Opcode::PseudoVFNCVT_RM_F_XU_W_M1_E32,
          2468 => Opcode::PseudoVFNCVT_RM_F_XU_W_M1_E32_MASK,
          2469 => Opcode::PseudoVFNCVT_RM_F_XU_W_M2_E16,
          2470 => Opcode::PseudoVFNCVT_RM_F_XU_W_M2_E16_MASK,
          2471 => Opcode::PseudoVFNCVT_RM_F_XU_W_M2_E32,
          2472 => Opcode::PseudoVFNCVT_RM_F_XU_W_M2_E32_MASK,
          2473 => Opcode::PseudoVFNCVT_RM_F_XU_W_M4_E16,
          2474 => Opcode::PseudoVFNCVT_RM_F_XU_W_M4_E16_MASK,
          2475 => Opcode::PseudoVFNCVT_RM_F_XU_W_M4_E32,
          2476 => Opcode::PseudoVFNCVT_RM_F_XU_W_M4_E32_MASK,
          2477 => Opcode::PseudoVFNCVT_RM_F_XU_W_MF2_E16,
          2478 => Opcode::PseudoVFNCVT_RM_F_XU_W_MF2_E16_MASK,
          2479 => Opcode::PseudoVFNCVT_RM_F_XU_W_MF2_E32,
          2480 => Opcode::PseudoVFNCVT_RM_F_XU_W_MF2_E32_MASK,
          2481 => Opcode::PseudoVFNCVT_RM_F_XU_W_MF4_E16,
          2482 => Opcode::PseudoVFNCVT_RM_F_XU_W_MF4_E16_MASK,
          2483 => Opcode::PseudoVFNCVT_RM_F_X_W_M1_E16,
          2484 => Opcode::PseudoVFNCVT_RM_F_X_W_M1_E16_MASK,
          2485 => Opcode::PseudoVFNCVT_RM_F_X_W_M1_E32,
          2486 => Opcode::PseudoVFNCVT_RM_F_X_W_M1_E32_MASK,
          2487 => Opcode::PseudoVFNCVT_RM_F_X_W_M2_E16,
          2488 => Opcode::PseudoVFNCVT_RM_F_X_W_M2_E16_MASK,
          2489 => Opcode::PseudoVFNCVT_RM_F_X_W_M2_E32,
          2490 => Opcode::PseudoVFNCVT_RM_F_X_W_M2_E32_MASK,
          2491 => Opcode::PseudoVFNCVT_RM_F_X_W_M4_E16,
          2492 => Opcode::PseudoVFNCVT_RM_F_X_W_M4_E16_MASK,
          2493 => Opcode::PseudoVFNCVT_RM_F_X_W_M4_E32,
          2494 => Opcode::PseudoVFNCVT_RM_F_X_W_M4_E32_MASK,
          2495 => Opcode::PseudoVFNCVT_RM_F_X_W_MF2_E16,
          2496 => Opcode::PseudoVFNCVT_RM_F_X_W_MF2_E16_MASK,
          2497 => Opcode::PseudoVFNCVT_RM_F_X_W_MF2_E32,
          2498 => Opcode::PseudoVFNCVT_RM_F_X_W_MF2_E32_MASK,
          2499 => Opcode::PseudoVFNCVT_RM_F_X_W_MF4_E16,
          2500 => Opcode::PseudoVFNCVT_RM_F_X_W_MF4_E16_MASK,
          2501 => Opcode::PseudoVFNCVT_RM_XU_F_W_M1,
          2502 => Opcode::PseudoVFNCVT_RM_XU_F_W_M1_MASK,
          2503 => Opcode::PseudoVFNCVT_RM_XU_F_W_M2,
          2504 => Opcode::PseudoVFNCVT_RM_XU_F_W_M2_MASK,
          2505 => Opcode::PseudoVFNCVT_RM_XU_F_W_M4,
          2506 => Opcode::PseudoVFNCVT_RM_XU_F_W_M4_MASK,
          2507 => Opcode::PseudoVFNCVT_RM_XU_F_W_MF2,
          2508 => Opcode::PseudoVFNCVT_RM_XU_F_W_MF2_MASK,
          2509 => Opcode::PseudoVFNCVT_RM_XU_F_W_MF4,
          2510 => Opcode::PseudoVFNCVT_RM_XU_F_W_MF4_MASK,
          2511 => Opcode::PseudoVFNCVT_RM_XU_F_W_MF8,
          2512 => Opcode::PseudoVFNCVT_RM_XU_F_W_MF8_MASK,
          2513 => Opcode::PseudoVFNCVT_RM_X_F_W_M1,
          2514 => Opcode::PseudoVFNCVT_RM_X_F_W_M1_MASK,
          2515 => Opcode::PseudoVFNCVT_RM_X_F_W_M2,
          2516 => Opcode::PseudoVFNCVT_RM_X_F_W_M2_MASK,
          2517 => Opcode::PseudoVFNCVT_RM_X_F_W_M4,
          2518 => Opcode::PseudoVFNCVT_RM_X_F_W_M4_MASK,
          2519 => Opcode::PseudoVFNCVT_RM_X_F_W_MF2,
          2520 => Opcode::PseudoVFNCVT_RM_X_F_W_MF2_MASK,
          2521 => Opcode::PseudoVFNCVT_RM_X_F_W_MF4,
          2522 => Opcode::PseudoVFNCVT_RM_X_F_W_MF4_MASK,
          2523 => Opcode::PseudoVFNCVT_RM_X_F_W_MF8,
          2524 => Opcode::PseudoVFNCVT_RM_X_F_W_MF8_MASK,
          2525 => Opcode::PseudoVFNCVT_ROD_F_F_W_M1_E16,
          2526 => Opcode::PseudoVFNCVT_ROD_F_F_W_M1_E16_MASK,
          2527 => Opcode::PseudoVFNCVT_ROD_F_F_W_M1_E32,
          2528 => Opcode::PseudoVFNCVT_ROD_F_F_W_M1_E32_MASK,
          2529 => Opcode::PseudoVFNCVT_ROD_F_F_W_M2_E16,
          2530 => Opcode::PseudoVFNCVT_ROD_F_F_W_M2_E16_MASK,
          2531 => Opcode::PseudoVFNCVT_ROD_F_F_W_M2_E32,
          2532 => Opcode::PseudoVFNCVT_ROD_F_F_W_M2_E32_MASK,
          2533 => Opcode::PseudoVFNCVT_ROD_F_F_W_M4_E16,
          2534 => Opcode::PseudoVFNCVT_ROD_F_F_W_M4_E16_MASK,
          2535 => Opcode::PseudoVFNCVT_ROD_F_F_W_M4_E32,
          2536 => Opcode::PseudoVFNCVT_ROD_F_F_W_M4_E32_MASK,
          2537 => Opcode::PseudoVFNCVT_ROD_F_F_W_MF2_E16,
          2538 => Opcode::PseudoVFNCVT_ROD_F_F_W_MF2_E16_MASK,
          2539 => Opcode::PseudoVFNCVT_ROD_F_F_W_MF2_E32,
          2540 => Opcode::PseudoVFNCVT_ROD_F_F_W_MF2_E32_MASK,
          2541 => Opcode::PseudoVFNCVT_ROD_F_F_W_MF4_E16,
          2542 => Opcode::PseudoVFNCVT_ROD_F_F_W_MF4_E16_MASK,
          2543 => Opcode::PseudoVFNCVT_RTZ_XU_F_W_M1,
          2544 => Opcode::PseudoVFNCVT_RTZ_XU_F_W_M1_MASK,
          2545 => Opcode::PseudoVFNCVT_RTZ_XU_F_W_M2,
          2546 => Opcode::PseudoVFNCVT_RTZ_XU_F_W_M2_MASK,
          2547 => Opcode::PseudoVFNCVT_RTZ_XU_F_W_M4,
          2548 => Opcode::PseudoVFNCVT_RTZ_XU_F_W_M4_MASK,
          2549 => Opcode::PseudoVFNCVT_RTZ_XU_F_W_MF2,
          2550 => Opcode::PseudoVFNCVT_RTZ_XU_F_W_MF2_MASK,
          2551 => Opcode::PseudoVFNCVT_RTZ_XU_F_W_MF4,
          2552 => Opcode::PseudoVFNCVT_RTZ_XU_F_W_MF4_MASK,
          2553 => Opcode::PseudoVFNCVT_RTZ_XU_F_W_MF8,
          2554 => Opcode::PseudoVFNCVT_RTZ_XU_F_W_MF8_MASK,
          2555 => Opcode::PseudoVFNCVT_RTZ_X_F_W_M1,
          2556 => Opcode::PseudoVFNCVT_RTZ_X_F_W_M1_MASK,
          2557 => Opcode::PseudoVFNCVT_RTZ_X_F_W_M2,
          2558 => Opcode::PseudoVFNCVT_RTZ_X_F_W_M2_MASK,
          2559 => Opcode::PseudoVFNCVT_RTZ_X_F_W_M4,
          2560 => Opcode::PseudoVFNCVT_RTZ_X_F_W_M4_MASK,
          2561 => Opcode::PseudoVFNCVT_RTZ_X_F_W_MF2,
          2562 => Opcode::PseudoVFNCVT_RTZ_X_F_W_MF2_MASK,
          2563 => Opcode::PseudoVFNCVT_RTZ_X_F_W_MF4,
          2564 => Opcode::PseudoVFNCVT_RTZ_X_F_W_MF4_MASK,
          2565 => Opcode::PseudoVFNCVT_RTZ_X_F_W_MF8,
          2566 => Opcode::PseudoVFNCVT_RTZ_X_F_W_MF8_MASK,
          2567 => Opcode::PseudoVFNCVT_XU_F_W_M1,
          2568 => Opcode::PseudoVFNCVT_XU_F_W_M1_MASK,
          2569 => Opcode::PseudoVFNCVT_XU_F_W_M2,
          2570 => Opcode::PseudoVFNCVT_XU_F_W_M2_MASK,
          2571 => Opcode::PseudoVFNCVT_XU_F_W_M4,
          2572 => Opcode::PseudoVFNCVT_XU_F_W_M4_MASK,
          2573 => Opcode::PseudoVFNCVT_XU_F_W_MF2,
          2574 => Opcode::PseudoVFNCVT_XU_F_W_MF2_MASK,
          2575 => Opcode::PseudoVFNCVT_XU_F_W_MF4,
          2576 => Opcode::PseudoVFNCVT_XU_F_W_MF4_MASK,
          2577 => Opcode::PseudoVFNCVT_XU_F_W_MF8,
          2578 => Opcode::PseudoVFNCVT_XU_F_W_MF8_MASK,
          2579 => Opcode::PseudoVFNCVT_X_F_W_M1,
          2580 => Opcode::PseudoVFNCVT_X_F_W_M1_MASK,
          2581 => Opcode::PseudoVFNCVT_X_F_W_M2,
          2582 => Opcode::PseudoVFNCVT_X_F_W_M2_MASK,
          2583 => Opcode::PseudoVFNCVT_X_F_W_M4,
          2584 => Opcode::PseudoVFNCVT_X_F_W_M4_MASK,
          2585 => Opcode::PseudoVFNCVT_X_F_W_MF2,
          2586 => Opcode::PseudoVFNCVT_X_F_W_MF2_MASK,
          2587 => Opcode::PseudoVFNCVT_X_F_W_MF4,
          2588 => Opcode::PseudoVFNCVT_X_F_W_MF4_MASK,
          2589 => Opcode::PseudoVFNCVT_X_F_W_MF8,
          2590 => Opcode::PseudoVFNCVT_X_F_W_MF8_MASK,
          2591 => Opcode::PseudoVFNMACC_VFPR16_M1_E16,
          2592 => Opcode::PseudoVFNMACC_VFPR16_M1_E16_MASK,
          2593 => Opcode::PseudoVFNMACC_VFPR16_M2_E16,
          2594 => Opcode::PseudoVFNMACC_VFPR16_M2_E16_MASK,
          2595 => Opcode::PseudoVFNMACC_VFPR16_M4_E16,
          2596 => Opcode::PseudoVFNMACC_VFPR16_M4_E16_MASK,
          2597 => Opcode::PseudoVFNMACC_VFPR16_M8_E16,
          2598 => Opcode::PseudoVFNMACC_VFPR16_M8_E16_MASK,
          2599 => Opcode::PseudoVFNMACC_VFPR16_MF2_E16,
          2600 => Opcode::PseudoVFNMACC_VFPR16_MF2_E16_MASK,
          2601 => Opcode::PseudoVFNMACC_VFPR16_MF4_E16,
          2602 => Opcode::PseudoVFNMACC_VFPR16_MF4_E16_MASK,
          2603 => Opcode::PseudoVFNMACC_VFPR32_M1_E32,
          2604 => Opcode::PseudoVFNMACC_VFPR32_M1_E32_MASK,
          2605 => Opcode::PseudoVFNMACC_VFPR32_M2_E32,
          2606 => Opcode::PseudoVFNMACC_VFPR32_M2_E32_MASK,
          2607 => Opcode::PseudoVFNMACC_VFPR32_M4_E32,
          2608 => Opcode::PseudoVFNMACC_VFPR32_M4_E32_MASK,
          2609 => Opcode::PseudoVFNMACC_VFPR32_M8_E32,
          2610 => Opcode::PseudoVFNMACC_VFPR32_M8_E32_MASK,
          2611 => Opcode::PseudoVFNMACC_VFPR32_MF2_E32,
          2612 => Opcode::PseudoVFNMACC_VFPR32_MF2_E32_MASK,
          2613 => Opcode::PseudoVFNMACC_VFPR64_M1_E64,
          2614 => Opcode::PseudoVFNMACC_VFPR64_M1_E64_MASK,
          2615 => Opcode::PseudoVFNMACC_VFPR64_M2_E64,
          2616 => Opcode::PseudoVFNMACC_VFPR64_M2_E64_MASK,
          2617 => Opcode::PseudoVFNMACC_VFPR64_M4_E64,
          2618 => Opcode::PseudoVFNMACC_VFPR64_M4_E64_MASK,
          2619 => Opcode::PseudoVFNMACC_VFPR64_M8_E64,
          2620 => Opcode::PseudoVFNMACC_VFPR64_M8_E64_MASK,
          2621 => Opcode::PseudoVFNMACC_VV_M1_E16,
          2622 => Opcode::PseudoVFNMACC_VV_M1_E16_MASK,
          2623 => Opcode::PseudoVFNMACC_VV_M1_E32,
          2624 => Opcode::PseudoVFNMACC_VV_M1_E32_MASK,
          2625 => Opcode::PseudoVFNMACC_VV_M1_E64,
          2626 => Opcode::PseudoVFNMACC_VV_M1_E64_MASK,
          2627 => Opcode::PseudoVFNMACC_VV_M2_E16,
          2628 => Opcode::PseudoVFNMACC_VV_M2_E16_MASK,
          2629 => Opcode::PseudoVFNMACC_VV_M2_E32,
          2630 => Opcode::PseudoVFNMACC_VV_M2_E32_MASK,
          2631 => Opcode::PseudoVFNMACC_VV_M2_E64,
          2632 => Opcode::PseudoVFNMACC_VV_M2_E64_MASK,
          2633 => Opcode::PseudoVFNMACC_VV_M4_E16,
          2634 => Opcode::PseudoVFNMACC_VV_M4_E16_MASK,
          2635 => Opcode::PseudoVFNMACC_VV_M4_E32,
          2636 => Opcode::PseudoVFNMACC_VV_M4_E32_MASK,
          2637 => Opcode::PseudoVFNMACC_VV_M4_E64,
          2638 => Opcode::PseudoVFNMACC_VV_M4_E64_MASK,
          2639 => Opcode::PseudoVFNMACC_VV_M8_E16,
          2640 => Opcode::PseudoVFNMACC_VV_M8_E16_MASK,
          2641 => Opcode::PseudoVFNMACC_VV_M8_E32,
          2642 => Opcode::PseudoVFNMACC_VV_M8_E32_MASK,
          2643 => Opcode::PseudoVFNMACC_VV_M8_E64,
          2644 => Opcode::PseudoVFNMACC_VV_M8_E64_MASK,
          2645 => Opcode::PseudoVFNMACC_VV_MF2_E16,
          2646 => Opcode::PseudoVFNMACC_VV_MF2_E16_MASK,
          2647 => Opcode::PseudoVFNMACC_VV_MF2_E32,
          2648 => Opcode::PseudoVFNMACC_VV_MF2_E32_MASK,
          2649 => Opcode::PseudoVFNMACC_VV_MF4_E16,
          2650 => Opcode::PseudoVFNMACC_VV_MF4_E16_MASK,
          2651 => Opcode::PseudoVFNMADD_VFPR16_M1_E16,
          2652 => Opcode::PseudoVFNMADD_VFPR16_M1_E16_MASK,
          2653 => Opcode::PseudoVFNMADD_VFPR16_M2_E16,
          2654 => Opcode::PseudoVFNMADD_VFPR16_M2_E16_MASK,
          2655 => Opcode::PseudoVFNMADD_VFPR16_M4_E16,
          2656 => Opcode::PseudoVFNMADD_VFPR16_M4_E16_MASK,
          2657 => Opcode::PseudoVFNMADD_VFPR16_M8_E16,
          2658 => Opcode::PseudoVFNMADD_VFPR16_M8_E16_MASK,
          2659 => Opcode::PseudoVFNMADD_VFPR16_MF2_E16,
          2660 => Opcode::PseudoVFNMADD_VFPR16_MF2_E16_MASK,
          2661 => Opcode::PseudoVFNMADD_VFPR16_MF4_E16,
          2662 => Opcode::PseudoVFNMADD_VFPR16_MF4_E16_MASK,
          2663 => Opcode::PseudoVFNMADD_VFPR32_M1_E32,
          2664 => Opcode::PseudoVFNMADD_VFPR32_M1_E32_MASK,
          2665 => Opcode::PseudoVFNMADD_VFPR32_M2_E32,
          2666 => Opcode::PseudoVFNMADD_VFPR32_M2_E32_MASK,
          2667 => Opcode::PseudoVFNMADD_VFPR32_M4_E32,
          2668 => Opcode::PseudoVFNMADD_VFPR32_M4_E32_MASK,
          2669 => Opcode::PseudoVFNMADD_VFPR32_M8_E32,
          2670 => Opcode::PseudoVFNMADD_VFPR32_M8_E32_MASK,
          2671 => Opcode::PseudoVFNMADD_VFPR32_MF2_E32,
          2672 => Opcode::PseudoVFNMADD_VFPR32_MF2_E32_MASK,
          2673 => Opcode::PseudoVFNMADD_VFPR64_M1_E64,
          2674 => Opcode::PseudoVFNMADD_VFPR64_M1_E64_MASK,
          2675 => Opcode::PseudoVFNMADD_VFPR64_M2_E64,
          2676 => Opcode::PseudoVFNMADD_VFPR64_M2_E64_MASK,
          2677 => Opcode::PseudoVFNMADD_VFPR64_M4_E64,
          2678 => Opcode::PseudoVFNMADD_VFPR64_M4_E64_MASK,
          2679 => Opcode::PseudoVFNMADD_VFPR64_M8_E64,
          2680 => Opcode::PseudoVFNMADD_VFPR64_M8_E64_MASK,
          2681 => Opcode::PseudoVFNMADD_VV_M1_E16,
          2682 => Opcode::PseudoVFNMADD_VV_M1_E16_MASK,
          2683 => Opcode::PseudoVFNMADD_VV_M1_E32,
          2684 => Opcode::PseudoVFNMADD_VV_M1_E32_MASK,
          2685 => Opcode::PseudoVFNMADD_VV_M1_E64,
          2686 => Opcode::PseudoVFNMADD_VV_M1_E64_MASK,
          2687 => Opcode::PseudoVFNMADD_VV_M2_E16,
          2688 => Opcode::PseudoVFNMADD_VV_M2_E16_MASK,
          2689 => Opcode::PseudoVFNMADD_VV_M2_E32,
          2690 => Opcode::PseudoVFNMADD_VV_M2_E32_MASK,
          2691 => Opcode::PseudoVFNMADD_VV_M2_E64,
          2692 => Opcode::PseudoVFNMADD_VV_M2_E64_MASK,
          2693 => Opcode::PseudoVFNMADD_VV_M4_E16,
          2694 => Opcode::PseudoVFNMADD_VV_M4_E16_MASK,
          2695 => Opcode::PseudoVFNMADD_VV_M4_E32,
          2696 => Opcode::PseudoVFNMADD_VV_M4_E32_MASK,
          2697 => Opcode::PseudoVFNMADD_VV_M4_E64,
          2698 => Opcode::PseudoVFNMADD_VV_M4_E64_MASK,
          2699 => Opcode::PseudoVFNMADD_VV_M8_E16,
          2700 => Opcode::PseudoVFNMADD_VV_M8_E16_MASK,
          2701 => Opcode::PseudoVFNMADD_VV_M8_E32,
          2702 => Opcode::PseudoVFNMADD_VV_M8_E32_MASK,
          2703 => Opcode::PseudoVFNMADD_VV_M8_E64,
          2704 => Opcode::PseudoVFNMADD_VV_M8_E64_MASK,
          2705 => Opcode::PseudoVFNMADD_VV_MF2_E16,
          2706 => Opcode::PseudoVFNMADD_VV_MF2_E16_MASK,
          2707 => Opcode::PseudoVFNMADD_VV_MF2_E32,
          2708 => Opcode::PseudoVFNMADD_VV_MF2_E32_MASK,
          2709 => Opcode::PseudoVFNMADD_VV_MF4_E16,
          2710 => Opcode::PseudoVFNMADD_VV_MF4_E16_MASK,
          2711 => Opcode::PseudoVFNMSAC_VFPR16_M1_E16,
          2712 => Opcode::PseudoVFNMSAC_VFPR16_M1_E16_MASK,
          2713 => Opcode::PseudoVFNMSAC_VFPR16_M2_E16,
          2714 => Opcode::PseudoVFNMSAC_VFPR16_M2_E16_MASK,
          2715 => Opcode::PseudoVFNMSAC_VFPR16_M4_E16,
          2716 => Opcode::PseudoVFNMSAC_VFPR16_M4_E16_MASK,
          2717 => Opcode::PseudoVFNMSAC_VFPR16_M8_E16,
          2718 => Opcode::PseudoVFNMSAC_VFPR16_M8_E16_MASK,
          2719 => Opcode::PseudoVFNMSAC_VFPR16_MF2_E16,
          2720 => Opcode::PseudoVFNMSAC_VFPR16_MF2_E16_MASK,
          2721 => Opcode::PseudoVFNMSAC_VFPR16_MF4_E16,
          2722 => Opcode::PseudoVFNMSAC_VFPR16_MF4_E16_MASK,
          2723 => Opcode::PseudoVFNMSAC_VFPR32_M1_E32,
          2724 => Opcode::PseudoVFNMSAC_VFPR32_M1_E32_MASK,
          2725 => Opcode::PseudoVFNMSAC_VFPR32_M2_E32,
          2726 => Opcode::PseudoVFNMSAC_VFPR32_M2_E32_MASK,
          2727 => Opcode::PseudoVFNMSAC_VFPR32_M4_E32,
          2728 => Opcode::PseudoVFNMSAC_VFPR32_M4_E32_MASK,
          2729 => Opcode::PseudoVFNMSAC_VFPR32_M8_E32,
          2730 => Opcode::PseudoVFNMSAC_VFPR32_M8_E32_MASK,
          2731 => Opcode::PseudoVFNMSAC_VFPR32_MF2_E32,
          2732 => Opcode::PseudoVFNMSAC_VFPR32_MF2_E32_MASK,
          2733 => Opcode::PseudoVFNMSAC_VFPR64_M1_E64,
          2734 => Opcode::PseudoVFNMSAC_VFPR64_M1_E64_MASK,
          2735 => Opcode::PseudoVFNMSAC_VFPR64_M2_E64,
          2736 => Opcode::PseudoVFNMSAC_VFPR64_M2_E64_MASK,
          2737 => Opcode::PseudoVFNMSAC_VFPR64_M4_E64,
          2738 => Opcode::PseudoVFNMSAC_VFPR64_M4_E64_MASK,
          2739 => Opcode::PseudoVFNMSAC_VFPR64_M8_E64,
          2740 => Opcode::PseudoVFNMSAC_VFPR64_M8_E64_MASK,
          2741 => Opcode::PseudoVFNMSAC_VV_M1_E16,
          2742 => Opcode::PseudoVFNMSAC_VV_M1_E16_MASK,
          2743 => Opcode::PseudoVFNMSAC_VV_M1_E32,
          2744 => Opcode::PseudoVFNMSAC_VV_M1_E32_MASK,
          2745 => Opcode::PseudoVFNMSAC_VV_M1_E64,
          2746 => Opcode::PseudoVFNMSAC_VV_M1_E64_MASK,
          2747 => Opcode::PseudoVFNMSAC_VV_M2_E16,
          2748 => Opcode::PseudoVFNMSAC_VV_M2_E16_MASK,
          2749 => Opcode::PseudoVFNMSAC_VV_M2_E32,
          2750 => Opcode::PseudoVFNMSAC_VV_M2_E32_MASK,
          2751 => Opcode::PseudoVFNMSAC_VV_M2_E64,
          2752 => Opcode::PseudoVFNMSAC_VV_M2_E64_MASK,
          2753 => Opcode::PseudoVFNMSAC_VV_M4_E16,
          2754 => Opcode::PseudoVFNMSAC_VV_M4_E16_MASK,
          2755 => Opcode::PseudoVFNMSAC_VV_M4_E32,
          2756 => Opcode::PseudoVFNMSAC_VV_M4_E32_MASK,
          2757 => Opcode::PseudoVFNMSAC_VV_M4_E64,
          2758 => Opcode::PseudoVFNMSAC_VV_M4_E64_MASK,
          2759 => Opcode::PseudoVFNMSAC_VV_M8_E16,
          2760 => Opcode::PseudoVFNMSAC_VV_M8_E16_MASK,
          2761 => Opcode::PseudoVFNMSAC_VV_M8_E32,
          2762 => Opcode::PseudoVFNMSAC_VV_M8_E32_MASK,
          2763 => Opcode::PseudoVFNMSAC_VV_M8_E64,
          2764 => Opcode::PseudoVFNMSAC_VV_M8_E64_MASK,
          2765 => Opcode::PseudoVFNMSAC_VV_MF2_E16,
          2766 => Opcode::PseudoVFNMSAC_VV_MF2_E16_MASK,
          2767 => Opcode::PseudoVFNMSAC_VV_MF2_E32,
          2768 => Opcode::PseudoVFNMSAC_VV_MF2_E32_MASK,
          2769 => Opcode::PseudoVFNMSAC_VV_MF4_E16,
          2770 => Opcode::PseudoVFNMSAC_VV_MF4_E16_MASK,
          2771 => Opcode::PseudoVFNMSUB_VFPR16_M1_E16,
          2772 => Opcode::PseudoVFNMSUB_VFPR16_M1_E16_MASK,
          2773 => Opcode::PseudoVFNMSUB_VFPR16_M2_E16,
          2774 => Opcode::PseudoVFNMSUB_VFPR16_M2_E16_MASK,
          2775 => Opcode::PseudoVFNMSUB_VFPR16_M4_E16,
          2776 => Opcode::PseudoVFNMSUB_VFPR16_M4_E16_MASK,
          2777 => Opcode::PseudoVFNMSUB_VFPR16_M8_E16,
          2778 => Opcode::PseudoVFNMSUB_VFPR16_M8_E16_MASK,
          2779 => Opcode::PseudoVFNMSUB_VFPR16_MF2_E16,
          2780 => Opcode::PseudoVFNMSUB_VFPR16_MF2_E16_MASK,
          2781 => Opcode::PseudoVFNMSUB_VFPR16_MF4_E16,
          2782 => Opcode::PseudoVFNMSUB_VFPR16_MF4_E16_MASK,
          2783 => Opcode::PseudoVFNMSUB_VFPR32_M1_E32,
          2784 => Opcode::PseudoVFNMSUB_VFPR32_M1_E32_MASK,
          2785 => Opcode::PseudoVFNMSUB_VFPR32_M2_E32,
          2786 => Opcode::PseudoVFNMSUB_VFPR32_M2_E32_MASK,
          2787 => Opcode::PseudoVFNMSUB_VFPR32_M4_E32,
          2788 => Opcode::PseudoVFNMSUB_VFPR32_M4_E32_MASK,
          2789 => Opcode::PseudoVFNMSUB_VFPR32_M8_E32,
          2790 => Opcode::PseudoVFNMSUB_VFPR32_M8_E32_MASK,
          2791 => Opcode::PseudoVFNMSUB_VFPR32_MF2_E32,
          2792 => Opcode::PseudoVFNMSUB_VFPR32_MF2_E32_MASK,
          2793 => Opcode::PseudoVFNMSUB_VFPR64_M1_E64,
          2794 => Opcode::PseudoVFNMSUB_VFPR64_M1_E64_MASK,
          2795 => Opcode::PseudoVFNMSUB_VFPR64_M2_E64,
          2796 => Opcode::PseudoVFNMSUB_VFPR64_M2_E64_MASK,
          2797 => Opcode::PseudoVFNMSUB_VFPR64_M4_E64,
          2798 => Opcode::PseudoVFNMSUB_VFPR64_M4_E64_MASK,
          2799 => Opcode::PseudoVFNMSUB_VFPR64_M8_E64,
          2800 => Opcode::PseudoVFNMSUB_VFPR64_M8_E64_MASK,
          2801 => Opcode::PseudoVFNMSUB_VV_M1_E16,
          2802 => Opcode::PseudoVFNMSUB_VV_M1_E16_MASK,
          2803 => Opcode::PseudoVFNMSUB_VV_M1_E32,
          2804 => Opcode::PseudoVFNMSUB_VV_M1_E32_MASK,
          2805 => Opcode::PseudoVFNMSUB_VV_M1_E64,
          2806 => Opcode::PseudoVFNMSUB_VV_M1_E64_MASK,
          2807 => Opcode::PseudoVFNMSUB_VV_M2_E16,
          2808 => Opcode::PseudoVFNMSUB_VV_M2_E16_MASK,
          2809 => Opcode::PseudoVFNMSUB_VV_M2_E32,
          2810 => Opcode::PseudoVFNMSUB_VV_M2_E32_MASK,
          2811 => Opcode::PseudoVFNMSUB_VV_M2_E64,
          2812 => Opcode::PseudoVFNMSUB_VV_M2_E64_MASK,
          2813 => Opcode::PseudoVFNMSUB_VV_M4_E16,
          2814 => Opcode::PseudoVFNMSUB_VV_M4_E16_MASK,
          2815 => Opcode::PseudoVFNMSUB_VV_M4_E32,
          2816 => Opcode::PseudoVFNMSUB_VV_M4_E32_MASK,
          2817 => Opcode::PseudoVFNMSUB_VV_M4_E64,
          2818 => Opcode::PseudoVFNMSUB_VV_M4_E64_MASK,
          2819 => Opcode::PseudoVFNMSUB_VV_M8_E16,
          2820 => Opcode::PseudoVFNMSUB_VV_M8_E16_MASK,
          2821 => Opcode::PseudoVFNMSUB_VV_M8_E32,
          2822 => Opcode::PseudoVFNMSUB_VV_M8_E32_MASK,
          2823 => Opcode::PseudoVFNMSUB_VV_M8_E64,
          2824 => Opcode::PseudoVFNMSUB_VV_M8_E64_MASK,
          2825 => Opcode::PseudoVFNMSUB_VV_MF2_E16,
          2826 => Opcode::PseudoVFNMSUB_VV_MF2_E16_MASK,
          2827 => Opcode::PseudoVFNMSUB_VV_MF2_E32,
          2828 => Opcode::PseudoVFNMSUB_VV_MF2_E32_MASK,
          2829 => Opcode::PseudoVFNMSUB_VV_MF4_E16,
          2830 => Opcode::PseudoVFNMSUB_VV_MF4_E16_MASK,
          2831 => Opcode::PseudoVFNRCLIP_XU_F_QF_M1,
          2832 => Opcode::PseudoVFNRCLIP_XU_F_QF_M1_MASK,
          2833 => Opcode::PseudoVFNRCLIP_XU_F_QF_M2,
          2834 => Opcode::PseudoVFNRCLIP_XU_F_QF_M2_MASK,
          2835 => Opcode::PseudoVFNRCLIP_XU_F_QF_MF2,
          2836 => Opcode::PseudoVFNRCLIP_XU_F_QF_MF2_MASK,
          2837 => Opcode::PseudoVFNRCLIP_XU_F_QF_MF4,
          2838 => Opcode::PseudoVFNRCLIP_XU_F_QF_MF4_MASK,
          2839 => Opcode::PseudoVFNRCLIP_XU_F_QF_MF8,
          2840 => Opcode::PseudoVFNRCLIP_XU_F_QF_MF8_MASK,
          2841 => Opcode::PseudoVFNRCLIP_X_F_QF_M1,
          2842 => Opcode::PseudoVFNRCLIP_X_F_QF_M1_MASK,
          2843 => Opcode::PseudoVFNRCLIP_X_F_QF_M2,
          2844 => Opcode::PseudoVFNRCLIP_X_F_QF_M2_MASK,
          2845 => Opcode::PseudoVFNRCLIP_X_F_QF_MF2,
          2846 => Opcode::PseudoVFNRCLIP_X_F_QF_MF2_MASK,
          2847 => Opcode::PseudoVFNRCLIP_X_F_QF_MF4,
          2848 => Opcode::PseudoVFNRCLIP_X_F_QF_MF4_MASK,
          2849 => Opcode::PseudoVFNRCLIP_X_F_QF_MF8,
          2850 => Opcode::PseudoVFNRCLIP_X_F_QF_MF8_MASK,
          2851 => Opcode::PseudoVFRDIV_VFPR16_M1_E16,
          2852 => Opcode::PseudoVFRDIV_VFPR16_M1_E16_MASK,
          2853 => Opcode::PseudoVFRDIV_VFPR16_M2_E16,
          2854 => Opcode::PseudoVFRDIV_VFPR16_M2_E16_MASK,
          2855 => Opcode::PseudoVFRDIV_VFPR16_M4_E16,
          2856 => Opcode::PseudoVFRDIV_VFPR16_M4_E16_MASK,
          2857 => Opcode::PseudoVFRDIV_VFPR16_M8_E16,
          2858 => Opcode::PseudoVFRDIV_VFPR16_M8_E16_MASK,
          2859 => Opcode::PseudoVFRDIV_VFPR16_MF2_E16,
          2860 => Opcode::PseudoVFRDIV_VFPR16_MF2_E16_MASK,
          2861 => Opcode::PseudoVFRDIV_VFPR16_MF4_E16,
          2862 => Opcode::PseudoVFRDIV_VFPR16_MF4_E16_MASK,
          2863 => Opcode::PseudoVFRDIV_VFPR32_M1_E32,
          2864 => Opcode::PseudoVFRDIV_VFPR32_M1_E32_MASK,
          2865 => Opcode::PseudoVFRDIV_VFPR32_M2_E32,
          2866 => Opcode::PseudoVFRDIV_VFPR32_M2_E32_MASK,
          2867 => Opcode::PseudoVFRDIV_VFPR32_M4_E32,
          2868 => Opcode::PseudoVFRDIV_VFPR32_M4_E32_MASK,
          2869 => Opcode::PseudoVFRDIV_VFPR32_M8_E32,
          2870 => Opcode::PseudoVFRDIV_VFPR32_M8_E32_MASK,
          2871 => Opcode::PseudoVFRDIV_VFPR32_MF2_E32,
          2872 => Opcode::PseudoVFRDIV_VFPR32_MF2_E32_MASK,
          2873 => Opcode::PseudoVFRDIV_VFPR64_M1_E64,
          2874 => Opcode::PseudoVFRDIV_VFPR64_M1_E64_MASK,
          2875 => Opcode::PseudoVFRDIV_VFPR64_M2_E64,
          2876 => Opcode::PseudoVFRDIV_VFPR64_M2_E64_MASK,
          2877 => Opcode::PseudoVFRDIV_VFPR64_M4_E64,
          2878 => Opcode::PseudoVFRDIV_VFPR64_M4_E64_MASK,
          2879 => Opcode::PseudoVFRDIV_VFPR64_M8_E64,
          2880 => Opcode::PseudoVFRDIV_VFPR64_M8_E64_MASK,
          2881 => Opcode::PseudoVFREC7_V_M1_E16,
          2882 => Opcode::PseudoVFREC7_V_M1_E16_MASK,
          2883 => Opcode::PseudoVFREC7_V_M1_E32,
          2884 => Opcode::PseudoVFREC7_V_M1_E32_MASK,
          2885 => Opcode::PseudoVFREC7_V_M1_E64,
          2886 => Opcode::PseudoVFREC7_V_M1_E64_MASK,
          2887 => Opcode::PseudoVFREC7_V_M2_E16,
          2888 => Opcode::PseudoVFREC7_V_M2_E16_MASK,
          2889 => Opcode::PseudoVFREC7_V_M2_E32,
          2890 => Opcode::PseudoVFREC7_V_M2_E32_MASK,
          2891 => Opcode::PseudoVFREC7_V_M2_E64,
          2892 => Opcode::PseudoVFREC7_V_M2_E64_MASK,
          2893 => Opcode::PseudoVFREC7_V_M4_E16,
          2894 => Opcode::PseudoVFREC7_V_M4_E16_MASK,
          2895 => Opcode::PseudoVFREC7_V_M4_E32,
          2896 => Opcode::PseudoVFREC7_V_M4_E32_MASK,
          2897 => Opcode::PseudoVFREC7_V_M4_E64,
          2898 => Opcode::PseudoVFREC7_V_M4_E64_MASK,
          2899 => Opcode::PseudoVFREC7_V_M8_E16,
          2900 => Opcode::PseudoVFREC7_V_M8_E16_MASK,
          2901 => Opcode::PseudoVFREC7_V_M8_E32,
          2902 => Opcode::PseudoVFREC7_V_M8_E32_MASK,
          2903 => Opcode::PseudoVFREC7_V_M8_E64,
          2904 => Opcode::PseudoVFREC7_V_M8_E64_MASK,
          2905 => Opcode::PseudoVFREC7_V_MF2_E16,
          2906 => Opcode::PseudoVFREC7_V_MF2_E16_MASK,
          2907 => Opcode::PseudoVFREC7_V_MF2_E32,
          2908 => Opcode::PseudoVFREC7_V_MF2_E32_MASK,
          2909 => Opcode::PseudoVFREC7_V_MF4_E16,
          2910 => Opcode::PseudoVFREC7_V_MF4_E16_MASK,
          2911 => Opcode::PseudoVFREDMAX_VS_M1_E16,
          2912 => Opcode::PseudoVFREDMAX_VS_M1_E16_MASK,
          2913 => Opcode::PseudoVFREDMAX_VS_M1_E32,
          2914 => Opcode::PseudoVFREDMAX_VS_M1_E32_MASK,
          2915 => Opcode::PseudoVFREDMAX_VS_M1_E64,
          2916 => Opcode::PseudoVFREDMAX_VS_M1_E64_MASK,
          2917 => Opcode::PseudoVFREDMAX_VS_M2_E16,
          2918 => Opcode::PseudoVFREDMAX_VS_M2_E16_MASK,
          2919 => Opcode::PseudoVFREDMAX_VS_M2_E32,
          2920 => Opcode::PseudoVFREDMAX_VS_M2_E32_MASK,
          2921 => Opcode::PseudoVFREDMAX_VS_M2_E64,
          2922 => Opcode::PseudoVFREDMAX_VS_M2_E64_MASK,
          2923 => Opcode::PseudoVFREDMAX_VS_M4_E16,
          2924 => Opcode::PseudoVFREDMAX_VS_M4_E16_MASK,
          2925 => Opcode::PseudoVFREDMAX_VS_M4_E32,
          2926 => Opcode::PseudoVFREDMAX_VS_M4_E32_MASK,
          2927 => Opcode::PseudoVFREDMAX_VS_M4_E64,
          2928 => Opcode::PseudoVFREDMAX_VS_M4_E64_MASK,
          2929 => Opcode::PseudoVFREDMAX_VS_M8_E16,
          2930 => Opcode::PseudoVFREDMAX_VS_M8_E16_MASK,
          2931 => Opcode::PseudoVFREDMAX_VS_M8_E32,
          2932 => Opcode::PseudoVFREDMAX_VS_M8_E32_MASK,
          2933 => Opcode::PseudoVFREDMAX_VS_M8_E64,
          2934 => Opcode::PseudoVFREDMAX_VS_M8_E64_MASK,
          2935 => Opcode::PseudoVFREDMAX_VS_MF2_E16,
          2936 => Opcode::PseudoVFREDMAX_VS_MF2_E16_MASK,
          2937 => Opcode::PseudoVFREDMAX_VS_MF2_E32,
          2938 => Opcode::PseudoVFREDMAX_VS_MF2_E32_MASK,
          2939 => Opcode::PseudoVFREDMAX_VS_MF4_E16,
          2940 => Opcode::PseudoVFREDMAX_VS_MF4_E16_MASK,
          2941 => Opcode::PseudoVFREDMIN_VS_M1_E16,
          2942 => Opcode::PseudoVFREDMIN_VS_M1_E16_MASK,
          2943 => Opcode::PseudoVFREDMIN_VS_M1_E32,
          2944 => Opcode::PseudoVFREDMIN_VS_M1_E32_MASK,
          2945 => Opcode::PseudoVFREDMIN_VS_M1_E64,
          2946 => Opcode::PseudoVFREDMIN_VS_M1_E64_MASK,
          2947 => Opcode::PseudoVFREDMIN_VS_M2_E16,
          2948 => Opcode::PseudoVFREDMIN_VS_M2_E16_MASK,
          2949 => Opcode::PseudoVFREDMIN_VS_M2_E32,
          2950 => Opcode::PseudoVFREDMIN_VS_M2_E32_MASK,
          2951 => Opcode::PseudoVFREDMIN_VS_M2_E64,
          2952 => Opcode::PseudoVFREDMIN_VS_M2_E64_MASK,
          2953 => Opcode::PseudoVFREDMIN_VS_M4_E16,
          2954 => Opcode::PseudoVFREDMIN_VS_M4_E16_MASK,
          2955 => Opcode::PseudoVFREDMIN_VS_M4_E32,
          2956 => Opcode::PseudoVFREDMIN_VS_M4_E32_MASK,
          2957 => Opcode::PseudoVFREDMIN_VS_M4_E64,
          2958 => Opcode::PseudoVFREDMIN_VS_M4_E64_MASK,
          2959 => Opcode::PseudoVFREDMIN_VS_M8_E16,
          2960 => Opcode::PseudoVFREDMIN_VS_M8_E16_MASK,
          2961 => Opcode::PseudoVFREDMIN_VS_M8_E32,
          2962 => Opcode::PseudoVFREDMIN_VS_M8_E32_MASK,
          2963 => Opcode::PseudoVFREDMIN_VS_M8_E64,
          2964 => Opcode::PseudoVFREDMIN_VS_M8_E64_MASK,
          2965 => Opcode::PseudoVFREDMIN_VS_MF2_E16,
          2966 => Opcode::PseudoVFREDMIN_VS_MF2_E16_MASK,
          2967 => Opcode::PseudoVFREDMIN_VS_MF2_E32,
          2968 => Opcode::PseudoVFREDMIN_VS_MF2_E32_MASK,
          2969 => Opcode::PseudoVFREDMIN_VS_MF4_E16,
          2970 => Opcode::PseudoVFREDMIN_VS_MF4_E16_MASK,
          2971 => Opcode::PseudoVFREDOSUM_VS_M1_E16,
          2972 => Opcode::PseudoVFREDOSUM_VS_M1_E16_MASK,
          2973 => Opcode::PseudoVFREDOSUM_VS_M1_E32,
          2974 => Opcode::PseudoVFREDOSUM_VS_M1_E32_MASK,
          2975 => Opcode::PseudoVFREDOSUM_VS_M1_E64,
          2976 => Opcode::PseudoVFREDOSUM_VS_M1_E64_MASK,
          2977 => Opcode::PseudoVFREDOSUM_VS_M2_E16,
          2978 => Opcode::PseudoVFREDOSUM_VS_M2_E16_MASK,
          2979 => Opcode::PseudoVFREDOSUM_VS_M2_E32,
          2980 => Opcode::PseudoVFREDOSUM_VS_M2_E32_MASK,
          2981 => Opcode::PseudoVFREDOSUM_VS_M2_E64,
          2982 => Opcode::PseudoVFREDOSUM_VS_M2_E64_MASK,
          2983 => Opcode::PseudoVFREDOSUM_VS_M4_E16,
          2984 => Opcode::PseudoVFREDOSUM_VS_M4_E16_MASK,
          2985 => Opcode::PseudoVFREDOSUM_VS_M4_E32,
          2986 => Opcode::PseudoVFREDOSUM_VS_M4_E32_MASK,
          2987 => Opcode::PseudoVFREDOSUM_VS_M4_E64,
          2988 => Opcode::PseudoVFREDOSUM_VS_M4_E64_MASK,
          2989 => Opcode::PseudoVFREDOSUM_VS_M8_E16,
          2990 => Opcode::PseudoVFREDOSUM_VS_M8_E16_MASK,
          2991 => Opcode::PseudoVFREDOSUM_VS_M8_E32,
          2992 => Opcode::PseudoVFREDOSUM_VS_M8_E32_MASK,
          2993 => Opcode::PseudoVFREDOSUM_VS_M8_E64,
          2994 => Opcode::PseudoVFREDOSUM_VS_M8_E64_MASK,
          2995 => Opcode::PseudoVFREDOSUM_VS_MF2_E16,
          2996 => Opcode::PseudoVFREDOSUM_VS_MF2_E16_MASK,
          2997 => Opcode::PseudoVFREDOSUM_VS_MF2_E32,
          2998 => Opcode::PseudoVFREDOSUM_VS_MF2_E32_MASK,
          2999 => Opcode::PseudoVFREDOSUM_VS_MF4_E16,
          3000 => Opcode::PseudoVFREDOSUM_VS_MF4_E16_MASK,
          3001 => Opcode::PseudoVFREDUSUM_VS_M1_E16,
          3002 => Opcode::PseudoVFREDUSUM_VS_M1_E16_MASK,
          3003 => Opcode::PseudoVFREDUSUM_VS_M1_E32,
          3004 => Opcode::PseudoVFREDUSUM_VS_M1_E32_MASK,
          3005 => Opcode::PseudoVFREDUSUM_VS_M1_E64,
          3006 => Opcode::PseudoVFREDUSUM_VS_M1_E64_MASK,
          3007 => Opcode::PseudoVFREDUSUM_VS_M2_E16,
          3008 => Opcode::PseudoVFREDUSUM_VS_M2_E16_MASK,
          3009 => Opcode::PseudoVFREDUSUM_VS_M2_E32,
          3010 => Opcode::PseudoVFREDUSUM_VS_M2_E32_MASK,
          3011 => Opcode::PseudoVFREDUSUM_VS_M2_E64,
          3012 => Opcode::PseudoVFREDUSUM_VS_M2_E64_MASK,
          3013 => Opcode::PseudoVFREDUSUM_VS_M4_E16,
          3014 => Opcode::PseudoVFREDUSUM_VS_M4_E16_MASK,
          3015 => Opcode::PseudoVFREDUSUM_VS_M4_E32,
          3016 => Opcode::PseudoVFREDUSUM_VS_M4_E32_MASK,
          3017 => Opcode::PseudoVFREDUSUM_VS_M4_E64,
          3018 => Opcode::PseudoVFREDUSUM_VS_M4_E64_MASK,
          3019 => Opcode::PseudoVFREDUSUM_VS_M8_E16,
          3020 => Opcode::PseudoVFREDUSUM_VS_M8_E16_MASK,
          3021 => Opcode::PseudoVFREDUSUM_VS_M8_E32,
          3022 => Opcode::PseudoVFREDUSUM_VS_M8_E32_MASK,
          3023 => Opcode::PseudoVFREDUSUM_VS_M8_E64,
          3024 => Opcode::PseudoVFREDUSUM_VS_M8_E64_MASK,
          3025 => Opcode::PseudoVFREDUSUM_VS_MF2_E16,
          3026 => Opcode::PseudoVFREDUSUM_VS_MF2_E16_MASK,
          3027 => Opcode::PseudoVFREDUSUM_VS_MF2_E32,
          3028 => Opcode::PseudoVFREDUSUM_VS_MF2_E32_MASK,
          3029 => Opcode::PseudoVFREDUSUM_VS_MF4_E16,
          3030 => Opcode::PseudoVFREDUSUM_VS_MF4_E16_MASK,
          3031 => Opcode::PseudoVFROUND_NOEXCEPT_V_M1_MASK,
          3032 => Opcode::PseudoVFROUND_NOEXCEPT_V_M2_MASK,
          3033 => Opcode::PseudoVFROUND_NOEXCEPT_V_M4_MASK,
          3034 => Opcode::PseudoVFROUND_NOEXCEPT_V_M8_MASK,
          3035 => Opcode::PseudoVFROUND_NOEXCEPT_V_MF2_MASK,
          3036 => Opcode::PseudoVFROUND_NOEXCEPT_V_MF4_MASK,
          3037 => Opcode::PseudoVFRSQRT7_V_M1_E16,
          3038 => Opcode::PseudoVFRSQRT7_V_M1_E16_MASK,
          3039 => Opcode::PseudoVFRSQRT7_V_M1_E32,
          3040 => Opcode::PseudoVFRSQRT7_V_M1_E32_MASK,
          3041 => Opcode::PseudoVFRSQRT7_V_M1_E64,
          3042 => Opcode::PseudoVFRSQRT7_V_M1_E64_MASK,
          3043 => Opcode::PseudoVFRSQRT7_V_M2_E16,
          3044 => Opcode::PseudoVFRSQRT7_V_M2_E16_MASK,
          3045 => Opcode::PseudoVFRSQRT7_V_M2_E32,
          3046 => Opcode::PseudoVFRSQRT7_V_M2_E32_MASK,
          3047 => Opcode::PseudoVFRSQRT7_V_M2_E64,
          3048 => Opcode::PseudoVFRSQRT7_V_M2_E64_MASK,
          3049 => Opcode::PseudoVFRSQRT7_V_M4_E16,
          3050 => Opcode::PseudoVFRSQRT7_V_M4_E16_MASK,
          3051 => Opcode::PseudoVFRSQRT7_V_M4_E32,
          3052 => Opcode::PseudoVFRSQRT7_V_M4_E32_MASK,
          3053 => Opcode::PseudoVFRSQRT7_V_M4_E64,
          3054 => Opcode::PseudoVFRSQRT7_V_M4_E64_MASK,
          3055 => Opcode::PseudoVFRSQRT7_V_M8_E16,
          3056 => Opcode::PseudoVFRSQRT7_V_M8_E16_MASK,
          3057 => Opcode::PseudoVFRSQRT7_V_M8_E32,
          3058 => Opcode::PseudoVFRSQRT7_V_M8_E32_MASK,
          3059 => Opcode::PseudoVFRSQRT7_V_M8_E64,
          3060 => Opcode::PseudoVFRSQRT7_V_M8_E64_MASK,
          3061 => Opcode::PseudoVFRSQRT7_V_MF2_E16,
          3062 => Opcode::PseudoVFRSQRT7_V_MF2_E16_MASK,
          3063 => Opcode::PseudoVFRSQRT7_V_MF2_E32,
          3064 => Opcode::PseudoVFRSQRT7_V_MF2_E32_MASK,
          3065 => Opcode::PseudoVFRSQRT7_V_MF4_E16,
          3066 => Opcode::PseudoVFRSQRT7_V_MF4_E16_MASK,
          3067 => Opcode::PseudoVFRSUB_VFPR16_M1_E16,
          3068 => Opcode::PseudoVFRSUB_VFPR16_M1_E16_MASK,
          3069 => Opcode::PseudoVFRSUB_VFPR16_M2_E16,
          3070 => Opcode::PseudoVFRSUB_VFPR16_M2_E16_MASK,
          3071 => Opcode::PseudoVFRSUB_VFPR16_M4_E16,
          3072 => Opcode::PseudoVFRSUB_VFPR16_M4_E16_MASK,
          3073 => Opcode::PseudoVFRSUB_VFPR16_M8_E16,
          3074 => Opcode::PseudoVFRSUB_VFPR16_M8_E16_MASK,
          3075 => Opcode::PseudoVFRSUB_VFPR16_MF2_E16,
          3076 => Opcode::PseudoVFRSUB_VFPR16_MF2_E16_MASK,
          3077 => Opcode::PseudoVFRSUB_VFPR16_MF4_E16,
          3078 => Opcode::PseudoVFRSUB_VFPR16_MF4_E16_MASK,
          3079 => Opcode::PseudoVFRSUB_VFPR32_M1_E32,
          3080 => Opcode::PseudoVFRSUB_VFPR32_M1_E32_MASK,
          3081 => Opcode::PseudoVFRSUB_VFPR32_M2_E32,
          3082 => Opcode::PseudoVFRSUB_VFPR32_M2_E32_MASK,
          3083 => Opcode::PseudoVFRSUB_VFPR32_M4_E32,
          3084 => Opcode::PseudoVFRSUB_VFPR32_M4_E32_MASK,
          3085 => Opcode::PseudoVFRSUB_VFPR32_M8_E32,
          3086 => Opcode::PseudoVFRSUB_VFPR32_M8_E32_MASK,
          3087 => Opcode::PseudoVFRSUB_VFPR32_MF2_E32,
          3088 => Opcode::PseudoVFRSUB_VFPR32_MF2_E32_MASK,
          3089 => Opcode::PseudoVFRSUB_VFPR64_M1_E64,
          3090 => Opcode::PseudoVFRSUB_VFPR64_M1_E64_MASK,
          3091 => Opcode::PseudoVFRSUB_VFPR64_M2_E64,
          3092 => Opcode::PseudoVFRSUB_VFPR64_M2_E64_MASK,
          3093 => Opcode::PseudoVFRSUB_VFPR64_M4_E64,
          3094 => Opcode::PseudoVFRSUB_VFPR64_M4_E64_MASK,
          3095 => Opcode::PseudoVFRSUB_VFPR64_M8_E64,
          3096 => Opcode::PseudoVFRSUB_VFPR64_M8_E64_MASK,
          3097 => Opcode::PseudoVFSGNJN_VFPR16_M1_E16,
          3098 => Opcode::PseudoVFSGNJN_VFPR16_M1_E16_MASK,
          3099 => Opcode::PseudoVFSGNJN_VFPR16_M2_E16,
          3100 => Opcode::PseudoVFSGNJN_VFPR16_M2_E16_MASK,
          3101 => Opcode::PseudoVFSGNJN_VFPR16_M4_E16,
          3102 => Opcode::PseudoVFSGNJN_VFPR16_M4_E16_MASK,
          3103 => Opcode::PseudoVFSGNJN_VFPR16_M8_E16,
          3104 => Opcode::PseudoVFSGNJN_VFPR16_M8_E16_MASK,
          3105 => Opcode::PseudoVFSGNJN_VFPR16_MF2_E16,
          3106 => Opcode::PseudoVFSGNJN_VFPR16_MF2_E16_MASK,
          3107 => Opcode::PseudoVFSGNJN_VFPR16_MF4_E16,
          3108 => Opcode::PseudoVFSGNJN_VFPR16_MF4_E16_MASK,
          3109 => Opcode::PseudoVFSGNJN_VFPR32_M1_E32,
          3110 => Opcode::PseudoVFSGNJN_VFPR32_M1_E32_MASK,
          3111 => Opcode::PseudoVFSGNJN_VFPR32_M2_E32,
          3112 => Opcode::PseudoVFSGNJN_VFPR32_M2_E32_MASK,
          3113 => Opcode::PseudoVFSGNJN_VFPR32_M4_E32,
          3114 => Opcode::PseudoVFSGNJN_VFPR32_M4_E32_MASK,
          3115 => Opcode::PseudoVFSGNJN_VFPR32_M8_E32,
          3116 => Opcode::PseudoVFSGNJN_VFPR32_M8_E32_MASK,
          3117 => Opcode::PseudoVFSGNJN_VFPR32_MF2_E32,
          3118 => Opcode::PseudoVFSGNJN_VFPR32_MF2_E32_MASK,
          3119 => Opcode::PseudoVFSGNJN_VFPR64_M1_E64,
          3120 => Opcode::PseudoVFSGNJN_VFPR64_M1_E64_MASK,
          3121 => Opcode::PseudoVFSGNJN_VFPR64_M2_E64,
          3122 => Opcode::PseudoVFSGNJN_VFPR64_M2_E64_MASK,
          3123 => Opcode::PseudoVFSGNJN_VFPR64_M4_E64,
          3124 => Opcode::PseudoVFSGNJN_VFPR64_M4_E64_MASK,
          3125 => Opcode::PseudoVFSGNJN_VFPR64_M8_E64,
          3126 => Opcode::PseudoVFSGNJN_VFPR64_M8_E64_MASK,
          3127 => Opcode::PseudoVFSGNJN_VV_M1_E16,
          3128 => Opcode::PseudoVFSGNJN_VV_M1_E16_MASK,
          3129 => Opcode::PseudoVFSGNJN_VV_M1_E32,
          3130 => Opcode::PseudoVFSGNJN_VV_M1_E32_MASK,
          3131 => Opcode::PseudoVFSGNJN_VV_M1_E64,
          3132 => Opcode::PseudoVFSGNJN_VV_M1_E64_MASK,
          3133 => Opcode::PseudoVFSGNJN_VV_M2_E16,
          3134 => Opcode::PseudoVFSGNJN_VV_M2_E16_MASK,
          3135 => Opcode::PseudoVFSGNJN_VV_M2_E32,
          3136 => Opcode::PseudoVFSGNJN_VV_M2_E32_MASK,
          3137 => Opcode::PseudoVFSGNJN_VV_M2_E64,
          3138 => Opcode::PseudoVFSGNJN_VV_M2_E64_MASK,
          3139 => Opcode::PseudoVFSGNJN_VV_M4_E16,
          3140 => Opcode::PseudoVFSGNJN_VV_M4_E16_MASK,
          3141 => Opcode::PseudoVFSGNJN_VV_M4_E32,
          3142 => Opcode::PseudoVFSGNJN_VV_M4_E32_MASK,
          3143 => Opcode::PseudoVFSGNJN_VV_M4_E64,
          3144 => Opcode::PseudoVFSGNJN_VV_M4_E64_MASK,
          3145 => Opcode::PseudoVFSGNJN_VV_M8_E16,
          3146 => Opcode::PseudoVFSGNJN_VV_M8_E16_MASK,
          3147 => Opcode::PseudoVFSGNJN_VV_M8_E32,
          3148 => Opcode::PseudoVFSGNJN_VV_M8_E32_MASK,
          3149 => Opcode::PseudoVFSGNJN_VV_M8_E64,
          3150 => Opcode::PseudoVFSGNJN_VV_M8_E64_MASK,
          3151 => Opcode::PseudoVFSGNJN_VV_MF2_E16,
          3152 => Opcode::PseudoVFSGNJN_VV_MF2_E16_MASK,
          3153 => Opcode::PseudoVFSGNJN_VV_MF2_E32,
          3154 => Opcode::PseudoVFSGNJN_VV_MF2_E32_MASK,
          3155 => Opcode::PseudoVFSGNJN_VV_MF4_E16,
          3156 => Opcode::PseudoVFSGNJN_VV_MF4_E16_MASK,
          3157 => Opcode::PseudoVFSGNJX_VFPR16_M1_E16,
          3158 => Opcode::PseudoVFSGNJX_VFPR16_M1_E16_MASK,
          3159 => Opcode::PseudoVFSGNJX_VFPR16_M2_E16,
          3160 => Opcode::PseudoVFSGNJX_VFPR16_M2_E16_MASK,
          3161 => Opcode::PseudoVFSGNJX_VFPR16_M4_E16,
          3162 => Opcode::PseudoVFSGNJX_VFPR16_M4_E16_MASK,
          3163 => Opcode::PseudoVFSGNJX_VFPR16_M8_E16,
          3164 => Opcode::PseudoVFSGNJX_VFPR16_M8_E16_MASK,
          3165 => Opcode::PseudoVFSGNJX_VFPR16_MF2_E16,
          3166 => Opcode::PseudoVFSGNJX_VFPR16_MF2_E16_MASK,
          3167 => Opcode::PseudoVFSGNJX_VFPR16_MF4_E16,
          3168 => Opcode::PseudoVFSGNJX_VFPR16_MF4_E16_MASK,
          3169 => Opcode::PseudoVFSGNJX_VFPR32_M1_E32,
          3170 => Opcode::PseudoVFSGNJX_VFPR32_M1_E32_MASK,
          3171 => Opcode::PseudoVFSGNJX_VFPR32_M2_E32,
          3172 => Opcode::PseudoVFSGNJX_VFPR32_M2_E32_MASK,
          3173 => Opcode::PseudoVFSGNJX_VFPR32_M4_E32,
          3174 => Opcode::PseudoVFSGNJX_VFPR32_M4_E32_MASK,
          3175 => Opcode::PseudoVFSGNJX_VFPR32_M8_E32,
          3176 => Opcode::PseudoVFSGNJX_VFPR32_M8_E32_MASK,
          3177 => Opcode::PseudoVFSGNJX_VFPR32_MF2_E32,
          3178 => Opcode::PseudoVFSGNJX_VFPR32_MF2_E32_MASK,
          3179 => Opcode::PseudoVFSGNJX_VFPR64_M1_E64,
          3180 => Opcode::PseudoVFSGNJX_VFPR64_M1_E64_MASK,
          3181 => Opcode::PseudoVFSGNJX_VFPR64_M2_E64,
          3182 => Opcode::PseudoVFSGNJX_VFPR64_M2_E64_MASK,
          3183 => Opcode::PseudoVFSGNJX_VFPR64_M4_E64,
          3184 => Opcode::PseudoVFSGNJX_VFPR64_M4_E64_MASK,
          3185 => Opcode::PseudoVFSGNJX_VFPR64_M8_E64,
          3186 => Opcode::PseudoVFSGNJX_VFPR64_M8_E64_MASK,
          3187 => Opcode::PseudoVFSGNJX_VV_M1_E16,
          3188 => Opcode::PseudoVFSGNJX_VV_M1_E16_MASK,
          3189 => Opcode::PseudoVFSGNJX_VV_M1_E32,
          3190 => Opcode::PseudoVFSGNJX_VV_M1_E32_MASK,
          3191 => Opcode::PseudoVFSGNJX_VV_M1_E64,
          3192 => Opcode::PseudoVFSGNJX_VV_M1_E64_MASK,
          3193 => Opcode::PseudoVFSGNJX_VV_M2_E16,
          3194 => Opcode::PseudoVFSGNJX_VV_M2_E16_MASK,
          3195 => Opcode::PseudoVFSGNJX_VV_M2_E32,
          3196 => Opcode::PseudoVFSGNJX_VV_M2_E32_MASK,
          3197 => Opcode::PseudoVFSGNJX_VV_M2_E64,
          3198 => Opcode::PseudoVFSGNJX_VV_M2_E64_MASK,
          3199 => Opcode::PseudoVFSGNJX_VV_M4_E16,
          3200 => Opcode::PseudoVFSGNJX_VV_M4_E16_MASK,
          3201 => Opcode::PseudoVFSGNJX_VV_M4_E32,
          3202 => Opcode::PseudoVFSGNJX_VV_M4_E32_MASK,
          3203 => Opcode::PseudoVFSGNJX_VV_M4_E64,
          3204 => Opcode::PseudoVFSGNJX_VV_M4_E64_MASK,
          3205 => Opcode::PseudoVFSGNJX_VV_M8_E16,
          3206 => Opcode::PseudoVFSGNJX_VV_M8_E16_MASK,
          3207 => Opcode::PseudoVFSGNJX_VV_M8_E32,
          3208 => Opcode::PseudoVFSGNJX_VV_M8_E32_MASK,
          3209 => Opcode::PseudoVFSGNJX_VV_M8_E64,
          3210 => Opcode::PseudoVFSGNJX_VV_M8_E64_MASK,
          3211 => Opcode::PseudoVFSGNJX_VV_MF2_E16,
          3212 => Opcode::PseudoVFSGNJX_VV_MF2_E16_MASK,
          3213 => Opcode::PseudoVFSGNJX_VV_MF2_E32,
          3214 => Opcode::PseudoVFSGNJX_VV_MF2_E32_MASK,
          3215 => Opcode::PseudoVFSGNJX_VV_MF4_E16,
          3216 => Opcode::PseudoVFSGNJX_VV_MF4_E16_MASK,
          3217 => Opcode::PseudoVFSGNJ_VFPR16_M1_E16,
          3218 => Opcode::PseudoVFSGNJ_VFPR16_M1_E16_MASK,
          3219 => Opcode::PseudoVFSGNJ_VFPR16_M2_E16,
          3220 => Opcode::PseudoVFSGNJ_VFPR16_M2_E16_MASK,
          3221 => Opcode::PseudoVFSGNJ_VFPR16_M4_E16,
          3222 => Opcode::PseudoVFSGNJ_VFPR16_M4_E16_MASK,
          3223 => Opcode::PseudoVFSGNJ_VFPR16_M8_E16,
          3224 => Opcode::PseudoVFSGNJ_VFPR16_M8_E16_MASK,
          3225 => Opcode::PseudoVFSGNJ_VFPR16_MF2_E16,
          3226 => Opcode::PseudoVFSGNJ_VFPR16_MF2_E16_MASK,
          3227 => Opcode::PseudoVFSGNJ_VFPR16_MF4_E16,
          3228 => Opcode::PseudoVFSGNJ_VFPR16_MF4_E16_MASK,
          3229 => Opcode::PseudoVFSGNJ_VFPR32_M1_E32,
          3230 => Opcode::PseudoVFSGNJ_VFPR32_M1_E32_MASK,
          3231 => Opcode::PseudoVFSGNJ_VFPR32_M2_E32,
          3232 => Opcode::PseudoVFSGNJ_VFPR32_M2_E32_MASK,
          3233 => Opcode::PseudoVFSGNJ_VFPR32_M4_E32,
          3234 => Opcode::PseudoVFSGNJ_VFPR32_M4_E32_MASK,
          3235 => Opcode::PseudoVFSGNJ_VFPR32_M8_E32,
          3236 => Opcode::PseudoVFSGNJ_VFPR32_M8_E32_MASK,
          3237 => Opcode::PseudoVFSGNJ_VFPR32_MF2_E32,
          3238 => Opcode::PseudoVFSGNJ_VFPR32_MF2_E32_MASK,
          3239 => Opcode::PseudoVFSGNJ_VFPR64_M1_E64,
          3240 => Opcode::PseudoVFSGNJ_VFPR64_M1_E64_MASK,
          3241 => Opcode::PseudoVFSGNJ_VFPR64_M2_E64,
          3242 => Opcode::PseudoVFSGNJ_VFPR64_M2_E64_MASK,
          3243 => Opcode::PseudoVFSGNJ_VFPR64_M4_E64,
          3244 => Opcode::PseudoVFSGNJ_VFPR64_M4_E64_MASK,
          3245 => Opcode::PseudoVFSGNJ_VFPR64_M8_E64,
          3246 => Opcode::PseudoVFSGNJ_VFPR64_M8_E64_MASK,
          3247 => Opcode::PseudoVFSGNJ_VV_M1_E16,
          3248 => Opcode::PseudoVFSGNJ_VV_M1_E16_MASK,
          3249 => Opcode::PseudoVFSGNJ_VV_M1_E32,
          3250 => Opcode::PseudoVFSGNJ_VV_M1_E32_MASK,
          3251 => Opcode::PseudoVFSGNJ_VV_M1_E64,
          3252 => Opcode::PseudoVFSGNJ_VV_M1_E64_MASK,
          3253 => Opcode::PseudoVFSGNJ_VV_M2_E16,
          3254 => Opcode::PseudoVFSGNJ_VV_M2_E16_MASK,
          3255 => Opcode::PseudoVFSGNJ_VV_M2_E32,
          3256 => Opcode::PseudoVFSGNJ_VV_M2_E32_MASK,
          3257 => Opcode::PseudoVFSGNJ_VV_M2_E64,
          3258 => Opcode::PseudoVFSGNJ_VV_M2_E64_MASK,
          3259 => Opcode::PseudoVFSGNJ_VV_M4_E16,
          3260 => Opcode::PseudoVFSGNJ_VV_M4_E16_MASK,
          3261 => Opcode::PseudoVFSGNJ_VV_M4_E32,
          3262 => Opcode::PseudoVFSGNJ_VV_M4_E32_MASK,
          3263 => Opcode::PseudoVFSGNJ_VV_M4_E64,
          3264 => Opcode::PseudoVFSGNJ_VV_M4_E64_MASK,
          3265 => Opcode::PseudoVFSGNJ_VV_M8_E16,
          3266 => Opcode::PseudoVFSGNJ_VV_M8_E16_MASK,
          3267 => Opcode::PseudoVFSGNJ_VV_M8_E32,
          3268 => Opcode::PseudoVFSGNJ_VV_M8_E32_MASK,
          3269 => Opcode::PseudoVFSGNJ_VV_M8_E64,
          3270 => Opcode::PseudoVFSGNJ_VV_M8_E64_MASK,
          3271 => Opcode::PseudoVFSGNJ_VV_MF2_E16,
          3272 => Opcode::PseudoVFSGNJ_VV_MF2_E16_MASK,
          3273 => Opcode::PseudoVFSGNJ_VV_MF2_E32,
          3274 => Opcode::PseudoVFSGNJ_VV_MF2_E32_MASK,
          3275 => Opcode::PseudoVFSGNJ_VV_MF4_E16,
          3276 => Opcode::PseudoVFSGNJ_VV_MF4_E16_MASK,
          3277 => Opcode::PseudoVFSLIDE1DOWN_VFPR16_M1,
          3278 => Opcode::PseudoVFSLIDE1DOWN_VFPR16_M1_MASK,
          3279 => Opcode::PseudoVFSLIDE1DOWN_VFPR16_M2,
          3280 => Opcode::PseudoVFSLIDE1DOWN_VFPR16_M2_MASK,
          3281 => Opcode::PseudoVFSLIDE1DOWN_VFPR16_M4,
          3282 => Opcode::PseudoVFSLIDE1DOWN_VFPR16_M4_MASK,
          3283 => Opcode::PseudoVFSLIDE1DOWN_VFPR16_M8,
          3284 => Opcode::PseudoVFSLIDE1DOWN_VFPR16_M8_MASK,
          3285 => Opcode::PseudoVFSLIDE1DOWN_VFPR16_MF2,
          3286 => Opcode::PseudoVFSLIDE1DOWN_VFPR16_MF2_MASK,
          3287 => Opcode::PseudoVFSLIDE1DOWN_VFPR16_MF4,
          3288 => Opcode::PseudoVFSLIDE1DOWN_VFPR16_MF4_MASK,
          3289 => Opcode::PseudoVFSLIDE1DOWN_VFPR32_M1,
          3290 => Opcode::PseudoVFSLIDE1DOWN_VFPR32_M1_MASK,
          3291 => Opcode::PseudoVFSLIDE1DOWN_VFPR32_M2,
          3292 => Opcode::PseudoVFSLIDE1DOWN_VFPR32_M2_MASK,
          3293 => Opcode::PseudoVFSLIDE1DOWN_VFPR32_M4,
          3294 => Opcode::PseudoVFSLIDE1DOWN_VFPR32_M4_MASK,
          3295 => Opcode::PseudoVFSLIDE1DOWN_VFPR32_M8,
          3296 => Opcode::PseudoVFSLIDE1DOWN_VFPR32_M8_MASK,
          3297 => Opcode::PseudoVFSLIDE1DOWN_VFPR32_MF2,
          3298 => Opcode::PseudoVFSLIDE1DOWN_VFPR32_MF2_MASK,
          3299 => Opcode::PseudoVFSLIDE1DOWN_VFPR64_M1,
          3300 => Opcode::PseudoVFSLIDE1DOWN_VFPR64_M1_MASK,
          3301 => Opcode::PseudoVFSLIDE1DOWN_VFPR64_M2,
          3302 => Opcode::PseudoVFSLIDE1DOWN_VFPR64_M2_MASK,
          3303 => Opcode::PseudoVFSLIDE1DOWN_VFPR64_M4,
          3304 => Opcode::PseudoVFSLIDE1DOWN_VFPR64_M4_MASK,
          3305 => Opcode::PseudoVFSLIDE1DOWN_VFPR64_M8,
          3306 => Opcode::PseudoVFSLIDE1DOWN_VFPR64_M8_MASK,
          3307 => Opcode::PseudoVFSLIDE1UP_VFPR16_M1,
          3308 => Opcode::PseudoVFSLIDE1UP_VFPR16_M1_MASK,
          3309 => Opcode::PseudoVFSLIDE1UP_VFPR16_M2,
          3310 => Opcode::PseudoVFSLIDE1UP_VFPR16_M2_MASK,
          3311 => Opcode::PseudoVFSLIDE1UP_VFPR16_M4,
          3312 => Opcode::PseudoVFSLIDE1UP_VFPR16_M4_MASK,
          3313 => Opcode::PseudoVFSLIDE1UP_VFPR16_M8,
          3314 => Opcode::PseudoVFSLIDE1UP_VFPR16_M8_MASK,
          3315 => Opcode::PseudoVFSLIDE1UP_VFPR16_MF2,
          3316 => Opcode::PseudoVFSLIDE1UP_VFPR16_MF2_MASK,
          3317 => Opcode::PseudoVFSLIDE1UP_VFPR16_MF4,
          3318 => Opcode::PseudoVFSLIDE1UP_VFPR16_MF4_MASK,
          3319 => Opcode::PseudoVFSLIDE1UP_VFPR32_M1,
          3320 => Opcode::PseudoVFSLIDE1UP_VFPR32_M1_MASK,
          3321 => Opcode::PseudoVFSLIDE1UP_VFPR32_M2,
          3322 => Opcode::PseudoVFSLIDE1UP_VFPR32_M2_MASK,
          3323 => Opcode::PseudoVFSLIDE1UP_VFPR32_M4,
          3324 => Opcode::PseudoVFSLIDE1UP_VFPR32_M4_MASK,
          3325 => Opcode::PseudoVFSLIDE1UP_VFPR32_M8,
          3326 => Opcode::PseudoVFSLIDE1UP_VFPR32_M8_MASK,
          3327 => Opcode::PseudoVFSLIDE1UP_VFPR32_MF2,
          3328 => Opcode::PseudoVFSLIDE1UP_VFPR32_MF2_MASK,
          3329 => Opcode::PseudoVFSLIDE1UP_VFPR64_M1,
          3330 => Opcode::PseudoVFSLIDE1UP_VFPR64_M1_MASK,
          3331 => Opcode::PseudoVFSLIDE1UP_VFPR64_M2,
          3332 => Opcode::PseudoVFSLIDE1UP_VFPR64_M2_MASK,
          3333 => Opcode::PseudoVFSLIDE1UP_VFPR64_M4,
          3334 => Opcode::PseudoVFSLIDE1UP_VFPR64_M4_MASK,
          3335 => Opcode::PseudoVFSLIDE1UP_VFPR64_M8,
          3336 => Opcode::PseudoVFSLIDE1UP_VFPR64_M8_MASK,
          3337 => Opcode::PseudoVFSQRT_V_M1_E16,
          3338 => Opcode::PseudoVFSQRT_V_M1_E16_MASK,
          3339 => Opcode::PseudoVFSQRT_V_M1_E32,
          3340 => Opcode::PseudoVFSQRT_V_M1_E32_MASK,
          3341 => Opcode::PseudoVFSQRT_V_M1_E64,
          3342 => Opcode::PseudoVFSQRT_V_M1_E64_MASK,
          3343 => Opcode::PseudoVFSQRT_V_M2_E16,
          3344 => Opcode::PseudoVFSQRT_V_M2_E16_MASK,
          3345 => Opcode::PseudoVFSQRT_V_M2_E32,
          3346 => Opcode::PseudoVFSQRT_V_M2_E32_MASK,
          3347 => Opcode::PseudoVFSQRT_V_M2_E64,
          3348 => Opcode::PseudoVFSQRT_V_M2_E64_MASK,
          3349 => Opcode::PseudoVFSQRT_V_M4_E16,
          3350 => Opcode::PseudoVFSQRT_V_M4_E16_MASK,
          3351 => Opcode::PseudoVFSQRT_V_M4_E32,
          3352 => Opcode::PseudoVFSQRT_V_M4_E32_MASK,
          3353 => Opcode::PseudoVFSQRT_V_M4_E64,
          3354 => Opcode::PseudoVFSQRT_V_M4_E64_MASK,
          3355 => Opcode::PseudoVFSQRT_V_M8_E16,
          3356 => Opcode::PseudoVFSQRT_V_M8_E16_MASK,
          3357 => Opcode::PseudoVFSQRT_V_M8_E32,
          3358 => Opcode::PseudoVFSQRT_V_M8_E32_MASK,
          3359 => Opcode::PseudoVFSQRT_V_M8_E64,
          3360 => Opcode::PseudoVFSQRT_V_M8_E64_MASK,
          3361 => Opcode::PseudoVFSQRT_V_MF2_E16,
          3362 => Opcode::PseudoVFSQRT_V_MF2_E16_MASK,
          3363 => Opcode::PseudoVFSQRT_V_MF2_E32,
          3364 => Opcode::PseudoVFSQRT_V_MF2_E32_MASK,
          3365 => Opcode::PseudoVFSQRT_V_MF4_E16,
          3366 => Opcode::PseudoVFSQRT_V_MF4_E16_MASK,
          3367 => Opcode::PseudoVFSUB_VFPR16_M1_E16,
          3368 => Opcode::PseudoVFSUB_VFPR16_M1_E16_MASK,
          3369 => Opcode::PseudoVFSUB_VFPR16_M2_E16,
          3370 => Opcode::PseudoVFSUB_VFPR16_M2_E16_MASK,
          3371 => Opcode::PseudoVFSUB_VFPR16_M4_E16,
          3372 => Opcode::PseudoVFSUB_VFPR16_M4_E16_MASK,
          3373 => Opcode::PseudoVFSUB_VFPR16_M8_E16,
          3374 => Opcode::PseudoVFSUB_VFPR16_M8_E16_MASK,
          3375 => Opcode::PseudoVFSUB_VFPR16_MF2_E16,
          3376 => Opcode::PseudoVFSUB_VFPR16_MF2_E16_MASK,
          3377 => Opcode::PseudoVFSUB_VFPR16_MF4_E16,
          3378 => Opcode::PseudoVFSUB_VFPR16_MF4_E16_MASK,
          3379 => Opcode::PseudoVFSUB_VFPR32_M1_E32,
          3380 => Opcode::PseudoVFSUB_VFPR32_M1_E32_MASK,
          3381 => Opcode::PseudoVFSUB_VFPR32_M2_E32,
          3382 => Opcode::PseudoVFSUB_VFPR32_M2_E32_MASK,
          3383 => Opcode::PseudoVFSUB_VFPR32_M4_E32,
          3384 => Opcode::PseudoVFSUB_VFPR32_M4_E32_MASK,
          3385 => Opcode::PseudoVFSUB_VFPR32_M8_E32,
          3386 => Opcode::PseudoVFSUB_VFPR32_M8_E32_MASK,
          3387 => Opcode::PseudoVFSUB_VFPR32_MF2_E32,
          3388 => Opcode::PseudoVFSUB_VFPR32_MF2_E32_MASK,
          3389 => Opcode::PseudoVFSUB_VFPR64_M1_E64,
          3390 => Opcode::PseudoVFSUB_VFPR64_M1_E64_MASK,
          3391 => Opcode::PseudoVFSUB_VFPR64_M2_E64,
          3392 => Opcode::PseudoVFSUB_VFPR64_M2_E64_MASK,
          3393 => Opcode::PseudoVFSUB_VFPR64_M4_E64,
          3394 => Opcode::PseudoVFSUB_VFPR64_M4_E64_MASK,
          3395 => Opcode::PseudoVFSUB_VFPR64_M8_E64,
          3396 => Opcode::PseudoVFSUB_VFPR64_M8_E64_MASK,
          3397 => Opcode::PseudoVFSUB_VV_M1_E16,
          3398 => Opcode::PseudoVFSUB_VV_M1_E16_MASK,
          3399 => Opcode::PseudoVFSUB_VV_M1_E32,
          3400 => Opcode::PseudoVFSUB_VV_M1_E32_MASK,
          3401 => Opcode::PseudoVFSUB_VV_M1_E64,
          3402 => Opcode::PseudoVFSUB_VV_M1_E64_MASK,
          3403 => Opcode::PseudoVFSUB_VV_M2_E16,
          3404 => Opcode::PseudoVFSUB_VV_M2_E16_MASK,
          3405 => Opcode::PseudoVFSUB_VV_M2_E32,
          3406 => Opcode::PseudoVFSUB_VV_M2_E32_MASK,
          3407 => Opcode::PseudoVFSUB_VV_M2_E64,
          3408 => Opcode::PseudoVFSUB_VV_M2_E64_MASK,
          3409 => Opcode::PseudoVFSUB_VV_M4_E16,
          3410 => Opcode::PseudoVFSUB_VV_M4_E16_MASK,
          3411 => Opcode::PseudoVFSUB_VV_M4_E32,
          3412 => Opcode::PseudoVFSUB_VV_M4_E32_MASK,
          3413 => Opcode::PseudoVFSUB_VV_M4_E64,
          3414 => Opcode::PseudoVFSUB_VV_M4_E64_MASK,
          3415 => Opcode::PseudoVFSUB_VV_M8_E16,
          3416 => Opcode::PseudoVFSUB_VV_M8_E16_MASK,
          3417 => Opcode::PseudoVFSUB_VV_M8_E32,
          3418 => Opcode::PseudoVFSUB_VV_M8_E32_MASK,
          3419 => Opcode::PseudoVFSUB_VV_M8_E64,
          3420 => Opcode::PseudoVFSUB_VV_M8_E64_MASK,
          3421 => Opcode::PseudoVFSUB_VV_MF2_E16,
          3422 => Opcode::PseudoVFSUB_VV_MF2_E16_MASK,
          3423 => Opcode::PseudoVFSUB_VV_MF2_E32,
          3424 => Opcode::PseudoVFSUB_VV_MF2_E32_MASK,
          3425 => Opcode::PseudoVFSUB_VV_MF4_E16,
          3426 => Opcode::PseudoVFSUB_VV_MF4_E16_MASK,
          3427 => Opcode::PseudoVFWADD_VFPR16_M1_E16,
          3428 => Opcode::PseudoVFWADD_VFPR16_M1_E16_MASK,
          3429 => Opcode::PseudoVFWADD_VFPR16_M2_E16,
          3430 => Opcode::PseudoVFWADD_VFPR16_M2_E16_MASK,
          3431 => Opcode::PseudoVFWADD_VFPR16_M4_E16,
          3432 => Opcode::PseudoVFWADD_VFPR16_M4_E16_MASK,
          3433 => Opcode::PseudoVFWADD_VFPR16_MF2_E16,
          3434 => Opcode::PseudoVFWADD_VFPR16_MF2_E16_MASK,
          3435 => Opcode::PseudoVFWADD_VFPR16_MF4_E16,
          3436 => Opcode::PseudoVFWADD_VFPR16_MF4_E16_MASK,
          3437 => Opcode::PseudoVFWADD_VFPR32_M1_E32,
          3438 => Opcode::PseudoVFWADD_VFPR32_M1_E32_MASK,
          3439 => Opcode::PseudoVFWADD_VFPR32_M2_E32,
          3440 => Opcode::PseudoVFWADD_VFPR32_M2_E32_MASK,
          3441 => Opcode::PseudoVFWADD_VFPR32_M4_E32,
          3442 => Opcode::PseudoVFWADD_VFPR32_M4_E32_MASK,
          3443 => Opcode::PseudoVFWADD_VFPR32_MF2_E32,
          3444 => Opcode::PseudoVFWADD_VFPR32_MF2_E32_MASK,
          3445 => Opcode::PseudoVFWADD_VV_M1_E16,
          3446 => Opcode::PseudoVFWADD_VV_M1_E16_MASK,
          3447 => Opcode::PseudoVFWADD_VV_M1_E32,
          3448 => Opcode::PseudoVFWADD_VV_M1_E32_MASK,
          3449 => Opcode::PseudoVFWADD_VV_M2_E16,
          3450 => Opcode::PseudoVFWADD_VV_M2_E16_MASK,
          3451 => Opcode::PseudoVFWADD_VV_M2_E32,
          3452 => Opcode::PseudoVFWADD_VV_M2_E32_MASK,
          3453 => Opcode::PseudoVFWADD_VV_M4_E16,
          3454 => Opcode::PseudoVFWADD_VV_M4_E16_MASK,
          3455 => Opcode::PseudoVFWADD_VV_M4_E32,
          3456 => Opcode::PseudoVFWADD_VV_M4_E32_MASK,
          3457 => Opcode::PseudoVFWADD_VV_MF2_E16,
          3458 => Opcode::PseudoVFWADD_VV_MF2_E16_MASK,
          3459 => Opcode::PseudoVFWADD_VV_MF2_E32,
          3460 => Opcode::PseudoVFWADD_VV_MF2_E32_MASK,
          3461 => Opcode::PseudoVFWADD_VV_MF4_E16,
          3462 => Opcode::PseudoVFWADD_VV_MF4_E16_MASK,
          3463 => Opcode::PseudoVFWADD_WFPR16_M1_E16,
          3464 => Opcode::PseudoVFWADD_WFPR16_M1_E16_MASK,
          3465 => Opcode::PseudoVFWADD_WFPR16_M2_E16,
          3466 => Opcode::PseudoVFWADD_WFPR16_M2_E16_MASK,
          3467 => Opcode::PseudoVFWADD_WFPR16_M4_E16,
          3468 => Opcode::PseudoVFWADD_WFPR16_M4_E16_MASK,
          3469 => Opcode::PseudoVFWADD_WFPR16_MF2_E16,
          3470 => Opcode::PseudoVFWADD_WFPR16_MF2_E16_MASK,
          3471 => Opcode::PseudoVFWADD_WFPR16_MF4_E16,
          3472 => Opcode::PseudoVFWADD_WFPR16_MF4_E16_MASK,
          3473 => Opcode::PseudoVFWADD_WFPR32_M1_E32,
          3474 => Opcode::PseudoVFWADD_WFPR32_M1_E32_MASK,
          3475 => Opcode::PseudoVFWADD_WFPR32_M2_E32,
          3476 => Opcode::PseudoVFWADD_WFPR32_M2_E32_MASK,
          3477 => Opcode::PseudoVFWADD_WFPR32_M4_E32,
          3478 => Opcode::PseudoVFWADD_WFPR32_M4_E32_MASK,
          3479 => Opcode::PseudoVFWADD_WFPR32_MF2_E32,
          3480 => Opcode::PseudoVFWADD_WFPR32_MF2_E32_MASK,
          3481 => Opcode::PseudoVFWADD_WV_M1_E16,
          3482 => Opcode::PseudoVFWADD_WV_M1_E16_MASK,
          3483 => Opcode::PseudoVFWADD_WV_M1_E16_MASK_TIED,
          3484 => Opcode::PseudoVFWADD_WV_M1_E16_TIED,
          3485 => Opcode::PseudoVFWADD_WV_M1_E32,
          3486 => Opcode::PseudoVFWADD_WV_M1_E32_MASK,
          3487 => Opcode::PseudoVFWADD_WV_M1_E32_MASK_TIED,
          3488 => Opcode::PseudoVFWADD_WV_M1_E32_TIED,
          3489 => Opcode::PseudoVFWADD_WV_M2_E16,
          3490 => Opcode::PseudoVFWADD_WV_M2_E16_MASK,
          3491 => Opcode::PseudoVFWADD_WV_M2_E16_MASK_TIED,
          3492 => Opcode::PseudoVFWADD_WV_M2_E16_TIED,
          3493 => Opcode::PseudoVFWADD_WV_M2_E32,
          3494 => Opcode::PseudoVFWADD_WV_M2_E32_MASK,
          3495 => Opcode::PseudoVFWADD_WV_M2_E32_MASK_TIED,
          3496 => Opcode::PseudoVFWADD_WV_M2_E32_TIED,
          3497 => Opcode::PseudoVFWADD_WV_M4_E16,
          3498 => Opcode::PseudoVFWADD_WV_M4_E16_MASK,
          3499 => Opcode::PseudoVFWADD_WV_M4_E16_MASK_TIED,
          3500 => Opcode::PseudoVFWADD_WV_M4_E16_TIED,
          3501 => Opcode::PseudoVFWADD_WV_M4_E32,
          3502 => Opcode::PseudoVFWADD_WV_M4_E32_MASK,
          3503 => Opcode::PseudoVFWADD_WV_M4_E32_MASK_TIED,
          3504 => Opcode::PseudoVFWADD_WV_M4_E32_TIED,
          3505 => Opcode::PseudoVFWADD_WV_MF2_E16,
          3506 => Opcode::PseudoVFWADD_WV_MF2_E16_MASK,
          3507 => Opcode::PseudoVFWADD_WV_MF2_E16_MASK_TIED,
          3508 => Opcode::PseudoVFWADD_WV_MF2_E16_TIED,
          3509 => Opcode::PseudoVFWADD_WV_MF2_E32,
          3510 => Opcode::PseudoVFWADD_WV_MF2_E32_MASK,
          3511 => Opcode::PseudoVFWADD_WV_MF2_E32_MASK_TIED,
          3512 => Opcode::PseudoVFWADD_WV_MF2_E32_TIED,
          3513 => Opcode::PseudoVFWADD_WV_MF4_E16,
          3514 => Opcode::PseudoVFWADD_WV_MF4_E16_MASK,
          3515 => Opcode::PseudoVFWADD_WV_MF4_E16_MASK_TIED,
          3516 => Opcode::PseudoVFWADD_WV_MF4_E16_TIED,
          3517 => Opcode::PseudoVFWCVTBF16_F_F_V_M1_E16,
          3518 => Opcode::PseudoVFWCVTBF16_F_F_V_M1_E16_MASK,
          3519 => Opcode::PseudoVFWCVTBF16_F_F_V_M1_E32,
          3520 => Opcode::PseudoVFWCVTBF16_F_F_V_M1_E32_MASK,
          3521 => Opcode::PseudoVFWCVTBF16_F_F_V_M2_E16,
          3522 => Opcode::PseudoVFWCVTBF16_F_F_V_M2_E16_MASK,
          3523 => Opcode::PseudoVFWCVTBF16_F_F_V_M2_E32,
          3524 => Opcode::PseudoVFWCVTBF16_F_F_V_M2_E32_MASK,
          3525 => Opcode::PseudoVFWCVTBF16_F_F_V_M4_E16,
          3526 => Opcode::PseudoVFWCVTBF16_F_F_V_M4_E16_MASK,
          3527 => Opcode::PseudoVFWCVTBF16_F_F_V_M4_E32,
          3528 => Opcode::PseudoVFWCVTBF16_F_F_V_M4_E32_MASK,
          3529 => Opcode::PseudoVFWCVTBF16_F_F_V_MF2_E16,
          3530 => Opcode::PseudoVFWCVTBF16_F_F_V_MF2_E16_MASK,
          3531 => Opcode::PseudoVFWCVTBF16_F_F_V_MF2_E32,
          3532 => Opcode::PseudoVFWCVTBF16_F_F_V_MF2_E32_MASK,
          3533 => Opcode::PseudoVFWCVTBF16_F_F_V_MF4_E16,
          3534 => Opcode::PseudoVFWCVTBF16_F_F_V_MF4_E16_MASK,
          3535 => Opcode::PseudoVFWCVT_F_F_V_M1_E16,
          3536 => Opcode::PseudoVFWCVT_F_F_V_M1_E16_MASK,
          3537 => Opcode::PseudoVFWCVT_F_F_V_M1_E32,
          3538 => Opcode::PseudoVFWCVT_F_F_V_M1_E32_MASK,
          3539 => Opcode::PseudoVFWCVT_F_F_V_M2_E16,
          3540 => Opcode::PseudoVFWCVT_F_F_V_M2_E16_MASK,
          3541 => Opcode::PseudoVFWCVT_F_F_V_M2_E32,
          3542 => Opcode::PseudoVFWCVT_F_F_V_M2_E32_MASK,
          3543 => Opcode::PseudoVFWCVT_F_F_V_M4_E16,
          3544 => Opcode::PseudoVFWCVT_F_F_V_M4_E16_MASK,
          3545 => Opcode::PseudoVFWCVT_F_F_V_M4_E32,
          3546 => Opcode::PseudoVFWCVT_F_F_V_M4_E32_MASK,
          3547 => Opcode::PseudoVFWCVT_F_F_V_MF2_E16,
          3548 => Opcode::PseudoVFWCVT_F_F_V_MF2_E16_MASK,
          3549 => Opcode::PseudoVFWCVT_F_F_V_MF2_E32,
          3550 => Opcode::PseudoVFWCVT_F_F_V_MF2_E32_MASK,
          3551 => Opcode::PseudoVFWCVT_F_F_V_MF4_E16,
          3552 => Opcode::PseudoVFWCVT_F_F_V_MF4_E16_MASK,
          3553 => Opcode::PseudoVFWCVT_F_XU_V_M1_E16,
          3554 => Opcode::PseudoVFWCVT_F_XU_V_M1_E16_MASK,
          3555 => Opcode::PseudoVFWCVT_F_XU_V_M1_E32,
          3556 => Opcode::PseudoVFWCVT_F_XU_V_M1_E32_MASK,
          3557 => Opcode::PseudoVFWCVT_F_XU_V_M1_E8,
          3558 => Opcode::PseudoVFWCVT_F_XU_V_M1_E8_MASK,
          3559 => Opcode::PseudoVFWCVT_F_XU_V_M2_E16,
          3560 => Opcode::PseudoVFWCVT_F_XU_V_M2_E16_MASK,
          3561 => Opcode::PseudoVFWCVT_F_XU_V_M2_E32,
          3562 => Opcode::PseudoVFWCVT_F_XU_V_M2_E32_MASK,
          3563 => Opcode::PseudoVFWCVT_F_XU_V_M2_E8,
          3564 => Opcode::PseudoVFWCVT_F_XU_V_M2_E8_MASK,
          3565 => Opcode::PseudoVFWCVT_F_XU_V_M4_E16,
          3566 => Opcode::PseudoVFWCVT_F_XU_V_M4_E16_MASK,
          3567 => Opcode::PseudoVFWCVT_F_XU_V_M4_E32,
          3568 => Opcode::PseudoVFWCVT_F_XU_V_M4_E32_MASK,
          3569 => Opcode::PseudoVFWCVT_F_XU_V_M4_E8,
          3570 => Opcode::PseudoVFWCVT_F_XU_V_M4_E8_MASK,
          3571 => Opcode::PseudoVFWCVT_F_XU_V_MF2_E16,
          3572 => Opcode::PseudoVFWCVT_F_XU_V_MF2_E16_MASK,
          3573 => Opcode::PseudoVFWCVT_F_XU_V_MF2_E32,
          3574 => Opcode::PseudoVFWCVT_F_XU_V_MF2_E32_MASK,
          3575 => Opcode::PseudoVFWCVT_F_XU_V_MF2_E8,
          3576 => Opcode::PseudoVFWCVT_F_XU_V_MF2_E8_MASK,
          3577 => Opcode::PseudoVFWCVT_F_XU_V_MF4_E16,
          3578 => Opcode::PseudoVFWCVT_F_XU_V_MF4_E16_MASK,
          3579 => Opcode::PseudoVFWCVT_F_XU_V_MF4_E8,
          3580 => Opcode::PseudoVFWCVT_F_XU_V_MF4_E8_MASK,
          3581 => Opcode::PseudoVFWCVT_F_XU_V_MF8_E8,
          3582 => Opcode::PseudoVFWCVT_F_XU_V_MF8_E8_MASK,
          3583 => Opcode::PseudoVFWCVT_F_X_V_M1_E16,
          3584 => Opcode::PseudoVFWCVT_F_X_V_M1_E16_MASK,
          3585 => Opcode::PseudoVFWCVT_F_X_V_M1_E32,
          3586 => Opcode::PseudoVFWCVT_F_X_V_M1_E32_MASK,
          3587 => Opcode::PseudoVFWCVT_F_X_V_M1_E8,
          3588 => Opcode::PseudoVFWCVT_F_X_V_M1_E8_MASK,
          3589 => Opcode::PseudoVFWCVT_F_X_V_M2_E16,
          3590 => Opcode::PseudoVFWCVT_F_X_V_M2_E16_MASK,
          3591 => Opcode::PseudoVFWCVT_F_X_V_M2_E32,
          3592 => Opcode::PseudoVFWCVT_F_X_V_M2_E32_MASK,
          3593 => Opcode::PseudoVFWCVT_F_X_V_M2_E8,
          3594 => Opcode::PseudoVFWCVT_F_X_V_M2_E8_MASK,
          3595 => Opcode::PseudoVFWCVT_F_X_V_M4_E16,
          3596 => Opcode::PseudoVFWCVT_F_X_V_M4_E16_MASK,
          3597 => Opcode::PseudoVFWCVT_F_X_V_M4_E32,
          3598 => Opcode::PseudoVFWCVT_F_X_V_M4_E32_MASK,
          3599 => Opcode::PseudoVFWCVT_F_X_V_M4_E8,
          3600 => Opcode::PseudoVFWCVT_F_X_V_M4_E8_MASK,
          3601 => Opcode::PseudoVFWCVT_F_X_V_MF2_E16,
          3602 => Opcode::PseudoVFWCVT_F_X_V_MF2_E16_MASK,
          3603 => Opcode::PseudoVFWCVT_F_X_V_MF2_E32,
          3604 => Opcode::PseudoVFWCVT_F_X_V_MF2_E32_MASK,
          3605 => Opcode::PseudoVFWCVT_F_X_V_MF2_E8,
          3606 => Opcode::PseudoVFWCVT_F_X_V_MF2_E8_MASK,
          3607 => Opcode::PseudoVFWCVT_F_X_V_MF4_E16,
          3608 => Opcode::PseudoVFWCVT_F_X_V_MF4_E16_MASK,
          3609 => Opcode::PseudoVFWCVT_F_X_V_MF4_E8,
          3610 => Opcode::PseudoVFWCVT_F_X_V_MF4_E8_MASK,
          3611 => Opcode::PseudoVFWCVT_F_X_V_MF8_E8,
          3612 => Opcode::PseudoVFWCVT_F_X_V_MF8_E8_MASK,
          3613 => Opcode::PseudoVFWCVT_RM_XU_F_V_M1,
          3614 => Opcode::PseudoVFWCVT_RM_XU_F_V_M1_MASK,
          3615 => Opcode::PseudoVFWCVT_RM_XU_F_V_M2,
          3616 => Opcode::PseudoVFWCVT_RM_XU_F_V_M2_MASK,
          3617 => Opcode::PseudoVFWCVT_RM_XU_F_V_M4,
          3618 => Opcode::PseudoVFWCVT_RM_XU_F_V_M4_MASK,
          3619 => Opcode::PseudoVFWCVT_RM_XU_F_V_MF2,
          3620 => Opcode::PseudoVFWCVT_RM_XU_F_V_MF2_MASK,
          3621 => Opcode::PseudoVFWCVT_RM_XU_F_V_MF4,
          3622 => Opcode::PseudoVFWCVT_RM_XU_F_V_MF4_MASK,
          3623 => Opcode::PseudoVFWCVT_RM_X_F_V_M1,
          3624 => Opcode::PseudoVFWCVT_RM_X_F_V_M1_MASK,
          3625 => Opcode::PseudoVFWCVT_RM_X_F_V_M2,
          3626 => Opcode::PseudoVFWCVT_RM_X_F_V_M2_MASK,
          3627 => Opcode::PseudoVFWCVT_RM_X_F_V_M4,
          3628 => Opcode::PseudoVFWCVT_RM_X_F_V_M4_MASK,
          3629 => Opcode::PseudoVFWCVT_RM_X_F_V_MF2,
          3630 => Opcode::PseudoVFWCVT_RM_X_F_V_MF2_MASK,
          3631 => Opcode::PseudoVFWCVT_RM_X_F_V_MF4,
          3632 => Opcode::PseudoVFWCVT_RM_X_F_V_MF4_MASK,
          3633 => Opcode::PseudoVFWCVT_RTZ_XU_F_V_M1,
          3634 => Opcode::PseudoVFWCVT_RTZ_XU_F_V_M1_MASK,
          3635 => Opcode::PseudoVFWCVT_RTZ_XU_F_V_M2,
          3636 => Opcode::PseudoVFWCVT_RTZ_XU_F_V_M2_MASK,
          3637 => Opcode::PseudoVFWCVT_RTZ_XU_F_V_M4,
          3638 => Opcode::PseudoVFWCVT_RTZ_XU_F_V_M4_MASK,
          3639 => Opcode::PseudoVFWCVT_RTZ_XU_F_V_MF2,
          3640 => Opcode::PseudoVFWCVT_RTZ_XU_F_V_MF2_MASK,
          3641 => Opcode::PseudoVFWCVT_RTZ_XU_F_V_MF4,
          3642 => Opcode::PseudoVFWCVT_RTZ_XU_F_V_MF4_MASK,
          3643 => Opcode::PseudoVFWCVT_RTZ_X_F_V_M1,
          3644 => Opcode::PseudoVFWCVT_RTZ_X_F_V_M1_MASK,
          3645 => Opcode::PseudoVFWCVT_RTZ_X_F_V_M2,
          3646 => Opcode::PseudoVFWCVT_RTZ_X_F_V_M2_MASK,
          3647 => Opcode::PseudoVFWCVT_RTZ_X_F_V_M4,
          3648 => Opcode::PseudoVFWCVT_RTZ_X_F_V_M4_MASK,
          3649 => Opcode::PseudoVFWCVT_RTZ_X_F_V_MF2,
          3650 => Opcode::PseudoVFWCVT_RTZ_X_F_V_MF2_MASK,
          3651 => Opcode::PseudoVFWCVT_RTZ_X_F_V_MF4,
          3652 => Opcode::PseudoVFWCVT_RTZ_X_F_V_MF4_MASK,
          3653 => Opcode::PseudoVFWCVT_XU_F_V_M1,
          3654 => Opcode::PseudoVFWCVT_XU_F_V_M1_MASK,
          3655 => Opcode::PseudoVFWCVT_XU_F_V_M2,
          3656 => Opcode::PseudoVFWCVT_XU_F_V_M2_MASK,
          3657 => Opcode::PseudoVFWCVT_XU_F_V_M4,
          3658 => Opcode::PseudoVFWCVT_XU_F_V_M4_MASK,
          3659 => Opcode::PseudoVFWCVT_XU_F_V_MF2,
          3660 => Opcode::PseudoVFWCVT_XU_F_V_MF2_MASK,
          3661 => Opcode::PseudoVFWCVT_XU_F_V_MF4,
          3662 => Opcode::PseudoVFWCVT_XU_F_V_MF4_MASK,
          3663 => Opcode::PseudoVFWCVT_X_F_V_M1,
          3664 => Opcode::PseudoVFWCVT_X_F_V_M1_MASK,
          3665 => Opcode::PseudoVFWCVT_X_F_V_M2,
          3666 => Opcode::PseudoVFWCVT_X_F_V_M2_MASK,
          3667 => Opcode::PseudoVFWCVT_X_F_V_M4,
          3668 => Opcode::PseudoVFWCVT_X_F_V_M4_MASK,
          3669 => Opcode::PseudoVFWCVT_X_F_V_MF2,
          3670 => Opcode::PseudoVFWCVT_X_F_V_MF2_MASK,
          3671 => Opcode::PseudoVFWCVT_X_F_V_MF4,
          3672 => Opcode::PseudoVFWCVT_X_F_V_MF4_MASK,
          3673 => Opcode::PseudoVFWMACCBF16_VFPR16_M1_E16,
          3674 => Opcode::PseudoVFWMACCBF16_VFPR16_M1_E16_MASK,
          3675 => Opcode::PseudoVFWMACCBF16_VFPR16_M2_E16,
          3676 => Opcode::PseudoVFWMACCBF16_VFPR16_M2_E16_MASK,
          3677 => Opcode::PseudoVFWMACCBF16_VFPR16_M4_E16,
          3678 => Opcode::PseudoVFWMACCBF16_VFPR16_M4_E16_MASK,
          3679 => Opcode::PseudoVFWMACCBF16_VFPR16_MF2_E16,
          3680 => Opcode::PseudoVFWMACCBF16_VFPR16_MF2_E16_MASK,
          3681 => Opcode::PseudoVFWMACCBF16_VFPR16_MF4_E16,
          3682 => Opcode::PseudoVFWMACCBF16_VFPR16_MF4_E16_MASK,
          3683 => Opcode::PseudoVFWMACCBF16_VV_M1_E16,
          3684 => Opcode::PseudoVFWMACCBF16_VV_M1_E16_MASK,
          3685 => Opcode::PseudoVFWMACCBF16_VV_M1_E32,
          3686 => Opcode::PseudoVFWMACCBF16_VV_M1_E32_MASK,
          3687 => Opcode::PseudoVFWMACCBF16_VV_M2_E16,
          3688 => Opcode::PseudoVFWMACCBF16_VV_M2_E16_MASK,
          3689 => Opcode::PseudoVFWMACCBF16_VV_M2_E32,
          3690 => Opcode::PseudoVFWMACCBF16_VV_M2_E32_MASK,
          3691 => Opcode::PseudoVFWMACCBF16_VV_M4_E16,
          3692 => Opcode::PseudoVFWMACCBF16_VV_M4_E16_MASK,
          3693 => Opcode::PseudoVFWMACCBF16_VV_M4_E32,
          3694 => Opcode::PseudoVFWMACCBF16_VV_M4_E32_MASK,
          3695 => Opcode::PseudoVFWMACCBF16_VV_MF2_E16,
          3696 => Opcode::PseudoVFWMACCBF16_VV_MF2_E16_MASK,
          3697 => Opcode::PseudoVFWMACCBF16_VV_MF2_E32,
          3698 => Opcode::PseudoVFWMACCBF16_VV_MF2_E32_MASK,
          3699 => Opcode::PseudoVFWMACCBF16_VV_MF4_E16,
          3700 => Opcode::PseudoVFWMACCBF16_VV_MF4_E16_MASK,
          3701 => Opcode::PseudoVFWMACC_4x4x4_M1,
          3702 => Opcode::PseudoVFWMACC_4x4x4_M2,
          3703 => Opcode::PseudoVFWMACC_4x4x4_M4,
          3704 => Opcode::PseudoVFWMACC_4x4x4_M8,
          3705 => Opcode::PseudoVFWMACC_4x4x4_MF2,
          3706 => Opcode::PseudoVFWMACC_4x4x4_MF4,
          3707 => Opcode::PseudoVFWMACC_VFPR16_M1_E16,
          3708 => Opcode::PseudoVFWMACC_VFPR16_M1_E16_MASK,
          3709 => Opcode::PseudoVFWMACC_VFPR16_M2_E16,
          3710 => Opcode::PseudoVFWMACC_VFPR16_M2_E16_MASK,
          3711 => Opcode::PseudoVFWMACC_VFPR16_M4_E16,
          3712 => Opcode::PseudoVFWMACC_VFPR16_M4_E16_MASK,
          3713 => Opcode::PseudoVFWMACC_VFPR16_MF2_E16,
          3714 => Opcode::PseudoVFWMACC_VFPR16_MF2_E16_MASK,
          3715 => Opcode::PseudoVFWMACC_VFPR16_MF4_E16,
          3716 => Opcode::PseudoVFWMACC_VFPR16_MF4_E16_MASK,
          3717 => Opcode::PseudoVFWMACC_VFPR32_M1_E32,
          3718 => Opcode::PseudoVFWMACC_VFPR32_M1_E32_MASK,
          3719 => Opcode::PseudoVFWMACC_VFPR32_M2_E32,
          3720 => Opcode::PseudoVFWMACC_VFPR32_M2_E32_MASK,
          3721 => Opcode::PseudoVFWMACC_VFPR32_M4_E32,
          3722 => Opcode::PseudoVFWMACC_VFPR32_M4_E32_MASK,
          3723 => Opcode::PseudoVFWMACC_VFPR32_MF2_E32,
          3724 => Opcode::PseudoVFWMACC_VFPR32_MF2_E32_MASK,
          3725 => Opcode::PseudoVFWMACC_VV_M1_E16,
          3726 => Opcode::PseudoVFWMACC_VV_M1_E16_MASK,
          3727 => Opcode::PseudoVFWMACC_VV_M1_E32,
          3728 => Opcode::PseudoVFWMACC_VV_M1_E32_MASK,
          3729 => Opcode::PseudoVFWMACC_VV_M2_E16,
          3730 => Opcode::PseudoVFWMACC_VV_M2_E16_MASK,
          3731 => Opcode::PseudoVFWMACC_VV_M2_E32,
          3732 => Opcode::PseudoVFWMACC_VV_M2_E32_MASK,
          3733 => Opcode::PseudoVFWMACC_VV_M4_E16,
          3734 => Opcode::PseudoVFWMACC_VV_M4_E16_MASK,
          3735 => Opcode::PseudoVFWMACC_VV_M4_E32,
          3736 => Opcode::PseudoVFWMACC_VV_M4_E32_MASK,
          3737 => Opcode::PseudoVFWMACC_VV_MF2_E16,
          3738 => Opcode::PseudoVFWMACC_VV_MF2_E16_MASK,
          3739 => Opcode::PseudoVFWMACC_VV_MF2_E32,
          3740 => Opcode::PseudoVFWMACC_VV_MF2_E32_MASK,
          3741 => Opcode::PseudoVFWMACC_VV_MF4_E16,
          3742 => Opcode::PseudoVFWMACC_VV_MF4_E16_MASK,
          3743 => Opcode::PseudoVFWMSAC_VFPR16_M1_E16,
          3744 => Opcode::PseudoVFWMSAC_VFPR16_M1_E16_MASK,
          3745 => Opcode::PseudoVFWMSAC_VFPR16_M2_E16,
          3746 => Opcode::PseudoVFWMSAC_VFPR16_M2_E16_MASK,
          3747 => Opcode::PseudoVFWMSAC_VFPR16_M4_E16,
          3748 => Opcode::PseudoVFWMSAC_VFPR16_M4_E16_MASK,
          3749 => Opcode::PseudoVFWMSAC_VFPR16_MF2_E16,
          3750 => Opcode::PseudoVFWMSAC_VFPR16_MF2_E16_MASK,
          3751 => Opcode::PseudoVFWMSAC_VFPR16_MF4_E16,
          3752 => Opcode::PseudoVFWMSAC_VFPR16_MF4_E16_MASK,
          3753 => Opcode::PseudoVFWMSAC_VFPR32_M1_E32,
          3754 => Opcode::PseudoVFWMSAC_VFPR32_M1_E32_MASK,
          3755 => Opcode::PseudoVFWMSAC_VFPR32_M2_E32,
          3756 => Opcode::PseudoVFWMSAC_VFPR32_M2_E32_MASK,
          3757 => Opcode::PseudoVFWMSAC_VFPR32_M4_E32,
          3758 => Opcode::PseudoVFWMSAC_VFPR32_M4_E32_MASK,
          3759 => Opcode::PseudoVFWMSAC_VFPR32_MF2_E32,
          3760 => Opcode::PseudoVFWMSAC_VFPR32_MF2_E32_MASK,
          3761 => Opcode::PseudoVFWMSAC_VV_M1_E16,
          3762 => Opcode::PseudoVFWMSAC_VV_M1_E16_MASK,
          3763 => Opcode::PseudoVFWMSAC_VV_M1_E32,
          3764 => Opcode::PseudoVFWMSAC_VV_M1_E32_MASK,
          3765 => Opcode::PseudoVFWMSAC_VV_M2_E16,
          3766 => Opcode::PseudoVFWMSAC_VV_M2_E16_MASK,
          3767 => Opcode::PseudoVFWMSAC_VV_M2_E32,
          3768 => Opcode::PseudoVFWMSAC_VV_M2_E32_MASK,
          3769 => Opcode::PseudoVFWMSAC_VV_M4_E16,
          3770 => Opcode::PseudoVFWMSAC_VV_M4_E16_MASK,
          3771 => Opcode::PseudoVFWMSAC_VV_M4_E32,
          3772 => Opcode::PseudoVFWMSAC_VV_M4_E32_MASK,
          3773 => Opcode::PseudoVFWMSAC_VV_MF2_E16,
          3774 => Opcode::PseudoVFWMSAC_VV_MF2_E16_MASK,
          3775 => Opcode::PseudoVFWMSAC_VV_MF2_E32,
          3776 => Opcode::PseudoVFWMSAC_VV_MF2_E32_MASK,
          3777 => Opcode::PseudoVFWMSAC_VV_MF4_E16,
          3778 => Opcode::PseudoVFWMSAC_VV_MF4_E16_MASK,
          3779 => Opcode::PseudoVFWMUL_VFPR16_M1_E16,
          3780 => Opcode::PseudoVFWMUL_VFPR16_M1_E16_MASK,
          3781 => Opcode::PseudoVFWMUL_VFPR16_M2_E16,
          3782 => Opcode::PseudoVFWMUL_VFPR16_M2_E16_MASK,
          3783 => Opcode::PseudoVFWMUL_VFPR16_M4_E16,
          3784 => Opcode::PseudoVFWMUL_VFPR16_M4_E16_MASK,
          3785 => Opcode::PseudoVFWMUL_VFPR16_MF2_E16,
          3786 => Opcode::PseudoVFWMUL_VFPR16_MF2_E16_MASK,
          3787 => Opcode::PseudoVFWMUL_VFPR16_MF4_E16,
          3788 => Opcode::PseudoVFWMUL_VFPR16_MF4_E16_MASK,
          3789 => Opcode::PseudoVFWMUL_VFPR32_M1_E32,
          3790 => Opcode::PseudoVFWMUL_VFPR32_M1_E32_MASK,
          3791 => Opcode::PseudoVFWMUL_VFPR32_M2_E32,
          3792 => Opcode::PseudoVFWMUL_VFPR32_M2_E32_MASK,
          3793 => Opcode::PseudoVFWMUL_VFPR32_M4_E32,
          3794 => Opcode::PseudoVFWMUL_VFPR32_M4_E32_MASK,
          3795 => Opcode::PseudoVFWMUL_VFPR32_MF2_E32,
          3796 => Opcode::PseudoVFWMUL_VFPR32_MF2_E32_MASK,
          3797 => Opcode::PseudoVFWMUL_VV_M1_E16,
          3798 => Opcode::PseudoVFWMUL_VV_M1_E16_MASK,
          3799 => Opcode::PseudoVFWMUL_VV_M1_E32,
          3800 => Opcode::PseudoVFWMUL_VV_M1_E32_MASK,
          3801 => Opcode::PseudoVFWMUL_VV_M2_E16,
          3802 => Opcode::PseudoVFWMUL_VV_M2_E16_MASK,
          3803 => Opcode::PseudoVFWMUL_VV_M2_E32,
          3804 => Opcode::PseudoVFWMUL_VV_M2_E32_MASK,
          3805 => Opcode::PseudoVFWMUL_VV_M4_E16,
          3806 => Opcode::PseudoVFWMUL_VV_M4_E16_MASK,
          3807 => Opcode::PseudoVFWMUL_VV_M4_E32,
          3808 => Opcode::PseudoVFWMUL_VV_M4_E32_MASK,
          3809 => Opcode::PseudoVFWMUL_VV_MF2_E16,
          3810 => Opcode::PseudoVFWMUL_VV_MF2_E16_MASK,
          3811 => Opcode::PseudoVFWMUL_VV_MF2_E32,
          3812 => Opcode::PseudoVFWMUL_VV_MF2_E32_MASK,
          3813 => Opcode::PseudoVFWMUL_VV_MF4_E16,
          3814 => Opcode::PseudoVFWMUL_VV_MF4_E16_MASK,
          3815 => Opcode::PseudoVFWNMACC_VFPR16_M1_E16,
          3816 => Opcode::PseudoVFWNMACC_VFPR16_M1_E16_MASK,
          3817 => Opcode::PseudoVFWNMACC_VFPR16_M2_E16,
          3818 => Opcode::PseudoVFWNMACC_VFPR16_M2_E16_MASK,
          3819 => Opcode::PseudoVFWNMACC_VFPR16_M4_E16,
          3820 => Opcode::PseudoVFWNMACC_VFPR16_M4_E16_MASK,
          3821 => Opcode::PseudoVFWNMACC_VFPR16_MF2_E16,
          3822 => Opcode::PseudoVFWNMACC_VFPR16_MF2_E16_MASK,
          3823 => Opcode::PseudoVFWNMACC_VFPR16_MF4_E16,
          3824 => Opcode::PseudoVFWNMACC_VFPR16_MF4_E16_MASK,
          3825 => Opcode::PseudoVFWNMACC_VFPR32_M1_E32,
          3826 => Opcode::PseudoVFWNMACC_VFPR32_M1_E32_MASK,
          3827 => Opcode::PseudoVFWNMACC_VFPR32_M2_E32,
          3828 => Opcode::PseudoVFWNMACC_VFPR32_M2_E32_MASK,
          3829 => Opcode::PseudoVFWNMACC_VFPR32_M4_E32,
          3830 => Opcode::PseudoVFWNMACC_VFPR32_M4_E32_MASK,
          3831 => Opcode::PseudoVFWNMACC_VFPR32_MF2_E32,
          3832 => Opcode::PseudoVFWNMACC_VFPR32_MF2_E32_MASK,
          3833 => Opcode::PseudoVFWNMACC_VV_M1_E16,
          3834 => Opcode::PseudoVFWNMACC_VV_M1_E16_MASK,
          3835 => Opcode::PseudoVFWNMACC_VV_M1_E32,
          3836 => Opcode::PseudoVFWNMACC_VV_M1_E32_MASK,
          3837 => Opcode::PseudoVFWNMACC_VV_M2_E16,
          3838 => Opcode::PseudoVFWNMACC_VV_M2_E16_MASK,
          3839 => Opcode::PseudoVFWNMACC_VV_M2_E32,
          3840 => Opcode::PseudoVFWNMACC_VV_M2_E32_MASK,
          3841 => Opcode::PseudoVFWNMACC_VV_M4_E16,
          3842 => Opcode::PseudoVFWNMACC_VV_M4_E16_MASK,
          3843 => Opcode::PseudoVFWNMACC_VV_M4_E32,
          3844 => Opcode::PseudoVFWNMACC_VV_M4_E32_MASK,
          3845 => Opcode::PseudoVFWNMACC_VV_MF2_E16,
          3846 => Opcode::PseudoVFWNMACC_VV_MF2_E16_MASK,
          3847 => Opcode::PseudoVFWNMACC_VV_MF2_E32,
          3848 => Opcode::PseudoVFWNMACC_VV_MF2_E32_MASK,
          3849 => Opcode::PseudoVFWNMACC_VV_MF4_E16,
          3850 => Opcode::PseudoVFWNMACC_VV_MF4_E16_MASK,
          3851 => Opcode::PseudoVFWNMSAC_VFPR16_M1_E16,
          3852 => Opcode::PseudoVFWNMSAC_VFPR16_M1_E16_MASK,
          3853 => Opcode::PseudoVFWNMSAC_VFPR16_M2_E16,
          3854 => Opcode::PseudoVFWNMSAC_VFPR16_M2_E16_MASK,
          3855 => Opcode::PseudoVFWNMSAC_VFPR16_M4_E16,
          3856 => Opcode::PseudoVFWNMSAC_VFPR16_M4_E16_MASK,
          3857 => Opcode::PseudoVFWNMSAC_VFPR16_MF2_E16,
          3858 => Opcode::PseudoVFWNMSAC_VFPR16_MF2_E16_MASK,
          3859 => Opcode::PseudoVFWNMSAC_VFPR16_MF4_E16,
          3860 => Opcode::PseudoVFWNMSAC_VFPR16_MF4_E16_MASK,
          3861 => Opcode::PseudoVFWNMSAC_VFPR32_M1_E32,
          3862 => Opcode::PseudoVFWNMSAC_VFPR32_M1_E32_MASK,
          3863 => Opcode::PseudoVFWNMSAC_VFPR32_M2_E32,
          3864 => Opcode::PseudoVFWNMSAC_VFPR32_M2_E32_MASK,
          3865 => Opcode::PseudoVFWNMSAC_VFPR32_M4_E32,
          3866 => Opcode::PseudoVFWNMSAC_VFPR32_M4_E32_MASK,
          3867 => Opcode::PseudoVFWNMSAC_VFPR32_MF2_E32,
          3868 => Opcode::PseudoVFWNMSAC_VFPR32_MF2_E32_MASK,
          3869 => Opcode::PseudoVFWNMSAC_VV_M1_E16,
          3870 => Opcode::PseudoVFWNMSAC_VV_M1_E16_MASK,
          3871 => Opcode::PseudoVFWNMSAC_VV_M1_E32,
          3872 => Opcode::PseudoVFWNMSAC_VV_M1_E32_MASK,
          3873 => Opcode::PseudoVFWNMSAC_VV_M2_E16,
          3874 => Opcode::PseudoVFWNMSAC_VV_M2_E16_MASK,
          3875 => Opcode::PseudoVFWNMSAC_VV_M2_E32,
          3876 => Opcode::PseudoVFWNMSAC_VV_M2_E32_MASK,
          3877 => Opcode::PseudoVFWNMSAC_VV_M4_E16,
          3878 => Opcode::PseudoVFWNMSAC_VV_M4_E16_MASK,
          3879 => Opcode::PseudoVFWNMSAC_VV_M4_E32,
          3880 => Opcode::PseudoVFWNMSAC_VV_M4_E32_MASK,
          3881 => Opcode::PseudoVFWNMSAC_VV_MF2_E16,
          3882 => Opcode::PseudoVFWNMSAC_VV_MF2_E16_MASK,
          3883 => Opcode::PseudoVFWNMSAC_VV_MF2_E32,
          3884 => Opcode::PseudoVFWNMSAC_VV_MF2_E32_MASK,
          3885 => Opcode::PseudoVFWNMSAC_VV_MF4_E16,
          3886 => Opcode::PseudoVFWNMSAC_VV_MF4_E16_MASK,
          3887 => Opcode::PseudoVFWREDOSUM_VS_M1_E16,
          3888 => Opcode::PseudoVFWREDOSUM_VS_M1_E16_MASK,
          3889 => Opcode::PseudoVFWREDOSUM_VS_M1_E32,
          3890 => Opcode::PseudoVFWREDOSUM_VS_M1_E32_MASK,
          3891 => Opcode::PseudoVFWREDOSUM_VS_M2_E16,
          3892 => Opcode::PseudoVFWREDOSUM_VS_M2_E16_MASK,
          3893 => Opcode::PseudoVFWREDOSUM_VS_M2_E32,
          3894 => Opcode::PseudoVFWREDOSUM_VS_M2_E32_MASK,
          3895 => Opcode::PseudoVFWREDOSUM_VS_M4_E16,
          3896 => Opcode::PseudoVFWREDOSUM_VS_M4_E16_MASK,
          3897 => Opcode::PseudoVFWREDOSUM_VS_M4_E32,
          3898 => Opcode::PseudoVFWREDOSUM_VS_M4_E32_MASK,
          3899 => Opcode::PseudoVFWREDOSUM_VS_M8_E16,
          3900 => Opcode::PseudoVFWREDOSUM_VS_M8_E16_MASK,
          3901 => Opcode::PseudoVFWREDOSUM_VS_M8_E32,
          3902 => Opcode::PseudoVFWREDOSUM_VS_M8_E32_MASK,
          3903 => Opcode::PseudoVFWREDOSUM_VS_MF2_E16,
          3904 => Opcode::PseudoVFWREDOSUM_VS_MF2_E16_MASK,
          3905 => Opcode::PseudoVFWREDOSUM_VS_MF2_E32,
          3906 => Opcode::PseudoVFWREDOSUM_VS_MF2_E32_MASK,
          3907 => Opcode::PseudoVFWREDOSUM_VS_MF4_E16,
          3908 => Opcode::PseudoVFWREDOSUM_VS_MF4_E16_MASK,
          3909 => Opcode::PseudoVFWREDUSUM_VS_M1_E16,
          3910 => Opcode::PseudoVFWREDUSUM_VS_M1_E16_MASK,
          3911 => Opcode::PseudoVFWREDUSUM_VS_M1_E32,
          3912 => Opcode::PseudoVFWREDUSUM_VS_M1_E32_MASK,
          3913 => Opcode::PseudoVFWREDUSUM_VS_M2_E16,
          3914 => Opcode::PseudoVFWREDUSUM_VS_M2_E16_MASK,
          3915 => Opcode::PseudoVFWREDUSUM_VS_M2_E32,
          3916 => Opcode::PseudoVFWREDUSUM_VS_M2_E32_MASK,
          3917 => Opcode::PseudoVFWREDUSUM_VS_M4_E16,
          3918 => Opcode::PseudoVFWREDUSUM_VS_M4_E16_MASK,
          3919 => Opcode::PseudoVFWREDUSUM_VS_M4_E32,
          3920 => Opcode::PseudoVFWREDUSUM_VS_M4_E32_MASK,
          3921 => Opcode::PseudoVFWREDUSUM_VS_M8_E16,
          3922 => Opcode::PseudoVFWREDUSUM_VS_M8_E16_MASK,
          3923 => Opcode::PseudoVFWREDUSUM_VS_M8_E32,
          3924 => Opcode::PseudoVFWREDUSUM_VS_M8_E32_MASK,
          3925 => Opcode::PseudoVFWREDUSUM_VS_MF2_E16,
          3926 => Opcode::PseudoVFWREDUSUM_VS_MF2_E16_MASK,
          3927 => Opcode::PseudoVFWREDUSUM_VS_MF2_E32,
          3928 => Opcode::PseudoVFWREDUSUM_VS_MF2_E32_MASK,
          3929 => Opcode::PseudoVFWREDUSUM_VS_MF4_E16,
          3930 => Opcode::PseudoVFWREDUSUM_VS_MF4_E16_MASK,
          3931 => Opcode::PseudoVFWSUB_VFPR16_M1_E16,
          3932 => Opcode::PseudoVFWSUB_VFPR16_M1_E16_MASK,
          3933 => Opcode::PseudoVFWSUB_VFPR16_M2_E16,
          3934 => Opcode::PseudoVFWSUB_VFPR16_M2_E16_MASK,
          3935 => Opcode::PseudoVFWSUB_VFPR16_M4_E16,
          3936 => Opcode::PseudoVFWSUB_VFPR16_M4_E16_MASK,
          3937 => Opcode::PseudoVFWSUB_VFPR16_MF2_E16,
          3938 => Opcode::PseudoVFWSUB_VFPR16_MF2_E16_MASK,
          3939 => Opcode::PseudoVFWSUB_VFPR16_MF4_E16,
          3940 => Opcode::PseudoVFWSUB_VFPR16_MF4_E16_MASK,
          3941 => Opcode::PseudoVFWSUB_VFPR32_M1_E32,
          3942 => Opcode::PseudoVFWSUB_VFPR32_M1_E32_MASK,
          3943 => Opcode::PseudoVFWSUB_VFPR32_M2_E32,
          3944 => Opcode::PseudoVFWSUB_VFPR32_M2_E32_MASK,
          3945 => Opcode::PseudoVFWSUB_VFPR32_M4_E32,
          3946 => Opcode::PseudoVFWSUB_VFPR32_M4_E32_MASK,
          3947 => Opcode::PseudoVFWSUB_VFPR32_MF2_E32,
          3948 => Opcode::PseudoVFWSUB_VFPR32_MF2_E32_MASK,
          3949 => Opcode::PseudoVFWSUB_VV_M1_E16,
          3950 => Opcode::PseudoVFWSUB_VV_M1_E16_MASK,
          3951 => Opcode::PseudoVFWSUB_VV_M1_E32,
          3952 => Opcode::PseudoVFWSUB_VV_M1_E32_MASK,
          3953 => Opcode::PseudoVFWSUB_VV_M2_E16,
          3954 => Opcode::PseudoVFWSUB_VV_M2_E16_MASK,
          3955 => Opcode::PseudoVFWSUB_VV_M2_E32,
          3956 => Opcode::PseudoVFWSUB_VV_M2_E32_MASK,
          3957 => Opcode::PseudoVFWSUB_VV_M4_E16,
          3958 => Opcode::PseudoVFWSUB_VV_M4_E16_MASK,
          3959 => Opcode::PseudoVFWSUB_VV_M4_E32,
          3960 => Opcode::PseudoVFWSUB_VV_M4_E32_MASK,
          3961 => Opcode::PseudoVFWSUB_VV_MF2_E16,
          3962 => Opcode::PseudoVFWSUB_VV_MF2_E16_MASK,
          3963 => Opcode::PseudoVFWSUB_VV_MF2_E32,
          3964 => Opcode::PseudoVFWSUB_VV_MF2_E32_MASK,
          3965 => Opcode::PseudoVFWSUB_VV_MF4_E16,
          3966 => Opcode::PseudoVFWSUB_VV_MF4_E16_MASK,
          3967 => Opcode::PseudoVFWSUB_WFPR16_M1_E16,
          3968 => Opcode::PseudoVFWSUB_WFPR16_M1_E16_MASK,
          3969 => Opcode::PseudoVFWSUB_WFPR16_M2_E16,
          3970 => Opcode::PseudoVFWSUB_WFPR16_M2_E16_MASK,
          3971 => Opcode::PseudoVFWSUB_WFPR16_M4_E16,
          3972 => Opcode::PseudoVFWSUB_WFPR16_M4_E16_MASK,
          3973 => Opcode::PseudoVFWSUB_WFPR16_MF2_E16,
          3974 => Opcode::PseudoVFWSUB_WFPR16_MF2_E16_MASK,
          3975 => Opcode::PseudoVFWSUB_WFPR16_MF4_E16,
          3976 => Opcode::PseudoVFWSUB_WFPR16_MF4_E16_MASK,
          3977 => Opcode::PseudoVFWSUB_WFPR32_M1_E32,
          3978 => Opcode::PseudoVFWSUB_WFPR32_M1_E32_MASK,
          3979 => Opcode::PseudoVFWSUB_WFPR32_M2_E32,
          3980 => Opcode::PseudoVFWSUB_WFPR32_M2_E32_MASK,
          3981 => Opcode::PseudoVFWSUB_WFPR32_M4_E32,
          3982 => Opcode::PseudoVFWSUB_WFPR32_M4_E32_MASK,
          3983 => Opcode::PseudoVFWSUB_WFPR32_MF2_E32,
          3984 => Opcode::PseudoVFWSUB_WFPR32_MF2_E32_MASK,
          3985 => Opcode::PseudoVFWSUB_WV_M1_E16,
          3986 => Opcode::PseudoVFWSUB_WV_M1_E16_MASK,
          3987 => Opcode::PseudoVFWSUB_WV_M1_E16_MASK_TIED,
          3988 => Opcode::PseudoVFWSUB_WV_M1_E16_TIED,
          3989 => Opcode::PseudoVFWSUB_WV_M1_E32,
          3990 => Opcode::PseudoVFWSUB_WV_M1_E32_MASK,
          3991 => Opcode::PseudoVFWSUB_WV_M1_E32_MASK_TIED,
          3992 => Opcode::PseudoVFWSUB_WV_M1_E32_TIED,
          3993 => Opcode::PseudoVFWSUB_WV_M2_E16,
          3994 => Opcode::PseudoVFWSUB_WV_M2_E16_MASK,
          3995 => Opcode::PseudoVFWSUB_WV_M2_E16_MASK_TIED,
          3996 => Opcode::PseudoVFWSUB_WV_M2_E16_TIED,
          3997 => Opcode::PseudoVFWSUB_WV_M2_E32,
          3998 => Opcode::PseudoVFWSUB_WV_M2_E32_MASK,
          3999 => Opcode::PseudoVFWSUB_WV_M2_E32_MASK_TIED,
          4000 => Opcode::PseudoVFWSUB_WV_M2_E32_TIED,
          4001 => Opcode::PseudoVFWSUB_WV_M4_E16,
          4002 => Opcode::PseudoVFWSUB_WV_M4_E16_MASK,
          4003 => Opcode::PseudoVFWSUB_WV_M4_E16_MASK_TIED,
          4004 => Opcode::PseudoVFWSUB_WV_M4_E16_TIED,
          4005 => Opcode::PseudoVFWSUB_WV_M4_E32,
          4006 => Opcode::PseudoVFWSUB_WV_M4_E32_MASK,
          4007 => Opcode::PseudoVFWSUB_WV_M4_E32_MASK_TIED,
          4008 => Opcode::PseudoVFWSUB_WV_M4_E32_TIED,
          4009 => Opcode::PseudoVFWSUB_WV_MF2_E16,
          4010 => Opcode::PseudoVFWSUB_WV_MF2_E16_MASK,
          4011 => Opcode::PseudoVFWSUB_WV_MF2_E16_MASK_TIED,
          4012 => Opcode::PseudoVFWSUB_WV_MF2_E16_TIED,
          4013 => Opcode::PseudoVFWSUB_WV_MF2_E32,
          4014 => Opcode::PseudoVFWSUB_WV_MF2_E32_MASK,
          4015 => Opcode::PseudoVFWSUB_WV_MF2_E32_MASK_TIED,
          4016 => Opcode::PseudoVFWSUB_WV_MF2_E32_TIED,
          4017 => Opcode::PseudoVFWSUB_WV_MF4_E16,
          4018 => Opcode::PseudoVFWSUB_WV_MF4_E16_MASK,
          4019 => Opcode::PseudoVFWSUB_WV_MF4_E16_MASK_TIED,
          4020 => Opcode::PseudoVFWSUB_WV_MF4_E16_TIED,
          4021 => Opcode::PseudoVGHSH_VV_M1,
          4022 => Opcode::PseudoVGHSH_VV_M2,
          4023 => Opcode::PseudoVGHSH_VV_M4,
          4024 => Opcode::PseudoVGHSH_VV_M8,
          4025 => Opcode::PseudoVGHSH_VV_MF2,
          4026 => Opcode::PseudoVGMUL_VV_M1,
          4027 => Opcode::PseudoVGMUL_VV_M2,
          4028 => Opcode::PseudoVGMUL_VV_M4,
          4029 => Opcode::PseudoVGMUL_VV_M8,
          4030 => Opcode::PseudoVGMUL_VV_MF2,
          4031 => Opcode::PseudoVID_V_M1,
          4032 => Opcode::PseudoVID_V_M1_MASK,
          4033 => Opcode::PseudoVID_V_M2,
          4034 => Opcode::PseudoVID_V_M2_MASK,
          4035 => Opcode::PseudoVID_V_M4,
          4036 => Opcode::PseudoVID_V_M4_MASK,
          4037 => Opcode::PseudoVID_V_M8,
          4038 => Opcode::PseudoVID_V_M8_MASK,
          4039 => Opcode::PseudoVID_V_MF2,
          4040 => Opcode::PseudoVID_V_MF2_MASK,
          4041 => Opcode::PseudoVID_V_MF4,
          4042 => Opcode::PseudoVID_V_MF4_MASK,
          4043 => Opcode::PseudoVID_V_MF8,
          4044 => Opcode::PseudoVID_V_MF8_MASK,
          4045 => Opcode::PseudoVIOTA_M_M1,
          4046 => Opcode::PseudoVIOTA_M_M1_MASK,
          4047 => Opcode::PseudoVIOTA_M_M2,
          4048 => Opcode::PseudoVIOTA_M_M2_MASK,
          4049 => Opcode::PseudoVIOTA_M_M4,
          4050 => Opcode::PseudoVIOTA_M_M4_MASK,
          4051 => Opcode::PseudoVIOTA_M_M8,
          4052 => Opcode::PseudoVIOTA_M_M8_MASK,
          4053 => Opcode::PseudoVIOTA_M_MF2,
          4054 => Opcode::PseudoVIOTA_M_MF2_MASK,
          4055 => Opcode::PseudoVIOTA_M_MF4,
          4056 => Opcode::PseudoVIOTA_M_MF4_MASK,
          4057 => Opcode::PseudoVIOTA_M_MF8,
          4058 => Opcode::PseudoVIOTA_M_MF8_MASK,
          4059 => Opcode::PseudoVLE16FF_V_M1,
          4060 => Opcode::PseudoVLE16FF_V_M1_MASK,
          4061 => Opcode::PseudoVLE16FF_V_M2,
          4062 => Opcode::PseudoVLE16FF_V_M2_MASK,
          4063 => Opcode::PseudoVLE16FF_V_M4,
          4064 => Opcode::PseudoVLE16FF_V_M4_MASK,
          4065 => Opcode::PseudoVLE16FF_V_M8,
          4066 => Opcode::PseudoVLE16FF_V_M8_MASK,
          4067 => Opcode::PseudoVLE16FF_V_MF2,
          4068 => Opcode::PseudoVLE16FF_V_MF2_MASK,
          4069 => Opcode::PseudoVLE16FF_V_MF4,
          4070 => Opcode::PseudoVLE16FF_V_MF4_MASK,
          4071 => Opcode::PseudoVLE16_V_M1,
          4072 => Opcode::PseudoVLE16_V_M1_MASK,
          4073 => Opcode::PseudoVLE16_V_M2,
          4074 => Opcode::PseudoVLE16_V_M2_MASK,
          4075 => Opcode::PseudoVLE16_V_M4,
          4076 => Opcode::PseudoVLE16_V_M4_MASK,
          4077 => Opcode::PseudoVLE16_V_M8,
          4078 => Opcode::PseudoVLE16_V_M8_MASK,
          4079 => Opcode::PseudoVLE16_V_MF2,
          4080 => Opcode::PseudoVLE16_V_MF2_MASK,
          4081 => Opcode::PseudoVLE16_V_MF4,
          4082 => Opcode::PseudoVLE16_V_MF4_MASK,
          4083 => Opcode::PseudoVLE32FF_V_M1,
          4084 => Opcode::PseudoVLE32FF_V_M1_MASK,
          4085 => Opcode::PseudoVLE32FF_V_M2,
          4086 => Opcode::PseudoVLE32FF_V_M2_MASK,
          4087 => Opcode::PseudoVLE32FF_V_M4,
          4088 => Opcode::PseudoVLE32FF_V_M4_MASK,
          4089 => Opcode::PseudoVLE32FF_V_M8,
          4090 => Opcode::PseudoVLE32FF_V_M8_MASK,
          4091 => Opcode::PseudoVLE32FF_V_MF2,
          4092 => Opcode::PseudoVLE32FF_V_MF2_MASK,
          4093 => Opcode::PseudoVLE32_V_M1,
          4094 => Opcode::PseudoVLE32_V_M1_MASK,
          4095 => Opcode::PseudoVLE32_V_M2,
          4096 => Opcode::PseudoVLE32_V_M2_MASK,
          4097 => Opcode::PseudoVLE32_V_M4,
          4098 => Opcode::PseudoVLE32_V_M4_MASK,
          4099 => Opcode::PseudoVLE32_V_M8,
          4100 => Opcode::PseudoVLE32_V_M8_MASK,
          4101 => Opcode::PseudoVLE32_V_MF2,
          4102 => Opcode::PseudoVLE32_V_MF2_MASK,
          4103 => Opcode::PseudoVLE64FF_V_M1,
          4104 => Opcode::PseudoVLE64FF_V_M1_MASK,
          4105 => Opcode::PseudoVLE64FF_V_M2,
          4106 => Opcode::PseudoVLE64FF_V_M2_MASK,
          4107 => Opcode::PseudoVLE64FF_V_M4,
          4108 => Opcode::PseudoVLE64FF_V_M4_MASK,
          4109 => Opcode::PseudoVLE64FF_V_M8,
          4110 => Opcode::PseudoVLE64FF_V_M8_MASK,
          4111 => Opcode::PseudoVLE64_V_M1,
          4112 => Opcode::PseudoVLE64_V_M1_MASK,
          4113 => Opcode::PseudoVLE64_V_M2,
          4114 => Opcode::PseudoVLE64_V_M2_MASK,
          4115 => Opcode::PseudoVLE64_V_M4,
          4116 => Opcode::PseudoVLE64_V_M4_MASK,
          4117 => Opcode::PseudoVLE64_V_M8,
          4118 => Opcode::PseudoVLE64_V_M8_MASK,
          4119 => Opcode::PseudoVLE8FF_V_M1,
          4120 => Opcode::PseudoVLE8FF_V_M1_MASK,
          4121 => Opcode::PseudoVLE8FF_V_M2,
          4122 => Opcode::PseudoVLE8FF_V_M2_MASK,
          4123 => Opcode::PseudoVLE8FF_V_M4,
          4124 => Opcode::PseudoVLE8FF_V_M4_MASK,
          4125 => Opcode::PseudoVLE8FF_V_M8,
          4126 => Opcode::PseudoVLE8FF_V_M8_MASK,
          4127 => Opcode::PseudoVLE8FF_V_MF2,
          4128 => Opcode::PseudoVLE8FF_V_MF2_MASK,
          4129 => Opcode::PseudoVLE8FF_V_MF4,
          4130 => Opcode::PseudoVLE8FF_V_MF4_MASK,
          4131 => Opcode::PseudoVLE8FF_V_MF8,
          4132 => Opcode::PseudoVLE8FF_V_MF8_MASK,
          4133 => Opcode::PseudoVLE8_V_M1,
          4134 => Opcode::PseudoVLE8_V_M1_MASK,
          4135 => Opcode::PseudoVLE8_V_M2,
          4136 => Opcode::PseudoVLE8_V_M2_MASK,
          4137 => Opcode::PseudoVLE8_V_M4,
          4138 => Opcode::PseudoVLE8_V_M4_MASK,
          4139 => Opcode::PseudoVLE8_V_M8,
          4140 => Opcode::PseudoVLE8_V_M8_MASK,
          4141 => Opcode::PseudoVLE8_V_MF2,
          4142 => Opcode::PseudoVLE8_V_MF2_MASK,
          4143 => Opcode::PseudoVLE8_V_MF4,
          4144 => Opcode::PseudoVLE8_V_MF4_MASK,
          4145 => Opcode::PseudoVLE8_V_MF8,
          4146 => Opcode::PseudoVLE8_V_MF8_MASK,
          4147 => Opcode::PseudoVLM_V_B1,
          4148 => Opcode::PseudoVLM_V_B16,
          4149 => Opcode::PseudoVLM_V_B2,
          4150 => Opcode::PseudoVLM_V_B32,
          4151 => Opcode::PseudoVLM_V_B4,
          4152 => Opcode::PseudoVLM_V_B64,
          4153 => Opcode::PseudoVLM_V_B8,
          4154 => Opcode::PseudoVLOXEI16_V_M1_M1,
          4155 => Opcode::PseudoVLOXEI16_V_M1_M1_MASK,
          4156 => Opcode::PseudoVLOXEI16_V_M1_M2,
          4157 => Opcode::PseudoVLOXEI16_V_M1_M2_MASK,
          4158 => Opcode::PseudoVLOXEI16_V_M1_M4,
          4159 => Opcode::PseudoVLOXEI16_V_M1_M4_MASK,
          4160 => Opcode::PseudoVLOXEI16_V_M1_MF2,
          4161 => Opcode::PseudoVLOXEI16_V_M1_MF2_MASK,
          4162 => Opcode::PseudoVLOXEI16_V_M2_M1,
          4163 => Opcode::PseudoVLOXEI16_V_M2_M1_MASK,
          4164 => Opcode::PseudoVLOXEI16_V_M2_M2,
          4165 => Opcode::PseudoVLOXEI16_V_M2_M2_MASK,
          4166 => Opcode::PseudoVLOXEI16_V_M2_M4,
          4167 => Opcode::PseudoVLOXEI16_V_M2_M4_MASK,
          4168 => Opcode::PseudoVLOXEI16_V_M2_M8,
          4169 => Opcode::PseudoVLOXEI16_V_M2_M8_MASK,
          4170 => Opcode::PseudoVLOXEI16_V_M4_M2,
          4171 => Opcode::PseudoVLOXEI16_V_M4_M2_MASK,
          4172 => Opcode::PseudoVLOXEI16_V_M4_M4,
          4173 => Opcode::PseudoVLOXEI16_V_M4_M4_MASK,
          4174 => Opcode::PseudoVLOXEI16_V_M4_M8,
          4175 => Opcode::PseudoVLOXEI16_V_M4_M8_MASK,
          4176 => Opcode::PseudoVLOXEI16_V_M8_M4,
          4177 => Opcode::PseudoVLOXEI16_V_M8_M4_MASK,
          4178 => Opcode::PseudoVLOXEI16_V_M8_M8,
          4179 => Opcode::PseudoVLOXEI16_V_M8_M8_MASK,
          4180 => Opcode::PseudoVLOXEI16_V_MF2_M1,
          4181 => Opcode::PseudoVLOXEI16_V_MF2_M1_MASK,
          4182 => Opcode::PseudoVLOXEI16_V_MF2_M2,
          4183 => Opcode::PseudoVLOXEI16_V_MF2_M2_MASK,
          4184 => Opcode::PseudoVLOXEI16_V_MF2_MF2,
          4185 => Opcode::PseudoVLOXEI16_V_MF2_MF2_MASK,
          4186 => Opcode::PseudoVLOXEI16_V_MF2_MF4,
          4187 => Opcode::PseudoVLOXEI16_V_MF2_MF4_MASK,
          4188 => Opcode::PseudoVLOXEI16_V_MF4_M1,
          4189 => Opcode::PseudoVLOXEI16_V_MF4_M1_MASK,
          4190 => Opcode::PseudoVLOXEI16_V_MF4_MF2,
          4191 => Opcode::PseudoVLOXEI16_V_MF4_MF2_MASK,
          4192 => Opcode::PseudoVLOXEI16_V_MF4_MF4,
          4193 => Opcode::PseudoVLOXEI16_V_MF4_MF4_MASK,
          4194 => Opcode::PseudoVLOXEI16_V_MF4_MF8,
          4195 => Opcode::PseudoVLOXEI16_V_MF4_MF8_MASK,
          4196 => Opcode::PseudoVLOXEI32_V_M1_M1,
          4197 => Opcode::PseudoVLOXEI32_V_M1_M1_MASK,
          4198 => Opcode::PseudoVLOXEI32_V_M1_M2,
          4199 => Opcode::PseudoVLOXEI32_V_M1_M2_MASK,
          4200 => Opcode::PseudoVLOXEI32_V_M1_MF2,
          4201 => Opcode::PseudoVLOXEI32_V_M1_MF2_MASK,
          4202 => Opcode::PseudoVLOXEI32_V_M1_MF4,
          4203 => Opcode::PseudoVLOXEI32_V_M1_MF4_MASK,
          4204 => Opcode::PseudoVLOXEI32_V_M2_M1,
          4205 => Opcode::PseudoVLOXEI32_V_M2_M1_MASK,
          4206 => Opcode::PseudoVLOXEI32_V_M2_M2,
          4207 => Opcode::PseudoVLOXEI32_V_M2_M2_MASK,
          4208 => Opcode::PseudoVLOXEI32_V_M2_M4,
          4209 => Opcode::PseudoVLOXEI32_V_M2_M4_MASK,
          4210 => Opcode::PseudoVLOXEI32_V_M2_MF2,
          4211 => Opcode::PseudoVLOXEI32_V_M2_MF2_MASK,
          4212 => Opcode::PseudoVLOXEI32_V_M4_M1,
          4213 => Opcode::PseudoVLOXEI32_V_M4_M1_MASK,
          4214 => Opcode::PseudoVLOXEI32_V_M4_M2,
          4215 => Opcode::PseudoVLOXEI32_V_M4_M2_MASK,
          4216 => Opcode::PseudoVLOXEI32_V_M4_M4,
          4217 => Opcode::PseudoVLOXEI32_V_M4_M4_MASK,
          4218 => Opcode::PseudoVLOXEI32_V_M4_M8,
          4219 => Opcode::PseudoVLOXEI32_V_M4_M8_MASK,
          4220 => Opcode::PseudoVLOXEI32_V_M8_M2,
          4221 => Opcode::PseudoVLOXEI32_V_M8_M2_MASK,
          4222 => Opcode::PseudoVLOXEI32_V_M8_M4,
          4223 => Opcode::PseudoVLOXEI32_V_M8_M4_MASK,
          4224 => Opcode::PseudoVLOXEI32_V_M8_M8,
          4225 => Opcode::PseudoVLOXEI32_V_M8_M8_MASK,
          4226 => Opcode::PseudoVLOXEI32_V_MF2_M1,
          4227 => Opcode::PseudoVLOXEI32_V_MF2_M1_MASK,
          4228 => Opcode::PseudoVLOXEI32_V_MF2_MF2,
          4229 => Opcode::PseudoVLOXEI32_V_MF2_MF2_MASK,
          4230 => Opcode::PseudoVLOXEI32_V_MF2_MF4,
          4231 => Opcode::PseudoVLOXEI32_V_MF2_MF4_MASK,
          4232 => Opcode::PseudoVLOXEI32_V_MF2_MF8,
          4233 => Opcode::PseudoVLOXEI32_V_MF2_MF8_MASK,
          4234 => Opcode::PseudoVLOXEI64_V_M1_M1,
          4235 => Opcode::PseudoVLOXEI64_V_M1_M1_MASK,
          4236 => Opcode::PseudoVLOXEI64_V_M1_MF2,
          4237 => Opcode::PseudoVLOXEI64_V_M1_MF2_MASK,
          4238 => Opcode::PseudoVLOXEI64_V_M1_MF4,
          4239 => Opcode::PseudoVLOXEI64_V_M1_MF4_MASK,
          4240 => Opcode::PseudoVLOXEI64_V_M1_MF8,
          4241 => Opcode::PseudoVLOXEI64_V_M1_MF8_MASK,
          4242 => Opcode::PseudoVLOXEI64_V_M2_M1,
          4243 => Opcode::PseudoVLOXEI64_V_M2_M1_MASK,
          4244 => Opcode::PseudoVLOXEI64_V_M2_M2,
          4245 => Opcode::PseudoVLOXEI64_V_M2_M2_MASK,
          4246 => Opcode::PseudoVLOXEI64_V_M2_MF2,
          4247 => Opcode::PseudoVLOXEI64_V_M2_MF2_MASK,
          4248 => Opcode::PseudoVLOXEI64_V_M2_MF4,
          4249 => Opcode::PseudoVLOXEI64_V_M2_MF4_MASK,
          4250 => Opcode::PseudoVLOXEI64_V_M4_M1,
          4251 => Opcode::PseudoVLOXEI64_V_M4_M1_MASK,
          4252 => Opcode::PseudoVLOXEI64_V_M4_M2,
          4253 => Opcode::PseudoVLOXEI64_V_M4_M2_MASK,
          4254 => Opcode::PseudoVLOXEI64_V_M4_M4,
          4255 => Opcode::PseudoVLOXEI64_V_M4_M4_MASK,
          4256 => Opcode::PseudoVLOXEI64_V_M4_MF2,
          4257 => Opcode::PseudoVLOXEI64_V_M4_MF2_MASK,
          4258 => Opcode::PseudoVLOXEI64_V_M8_M1,
          4259 => Opcode::PseudoVLOXEI64_V_M8_M1_MASK,
          4260 => Opcode::PseudoVLOXEI64_V_M8_M2,
          4261 => Opcode::PseudoVLOXEI64_V_M8_M2_MASK,
          4262 => Opcode::PseudoVLOXEI64_V_M8_M4,
          4263 => Opcode::PseudoVLOXEI64_V_M8_M4_MASK,
          4264 => Opcode::PseudoVLOXEI64_V_M8_M8,
          4265 => Opcode::PseudoVLOXEI64_V_M8_M8_MASK,
          4266 => Opcode::PseudoVLOXEI8_V_M1_M1,
          4267 => Opcode::PseudoVLOXEI8_V_M1_M1_MASK,
          4268 => Opcode::PseudoVLOXEI8_V_M1_M2,
          4269 => Opcode::PseudoVLOXEI8_V_M1_M2_MASK,
          4270 => Opcode::PseudoVLOXEI8_V_M1_M4,
          4271 => Opcode::PseudoVLOXEI8_V_M1_M4_MASK,
          4272 => Opcode::PseudoVLOXEI8_V_M1_M8,
          4273 => Opcode::PseudoVLOXEI8_V_M1_M8_MASK,
          4274 => Opcode::PseudoVLOXEI8_V_M2_M2,
          4275 => Opcode::PseudoVLOXEI8_V_M2_M2_MASK,
          4276 => Opcode::PseudoVLOXEI8_V_M2_M4,
          4277 => Opcode::PseudoVLOXEI8_V_M2_M4_MASK,
          4278 => Opcode::PseudoVLOXEI8_V_M2_M8,
          4279 => Opcode::PseudoVLOXEI8_V_M2_M8_MASK,
          4280 => Opcode::PseudoVLOXEI8_V_M4_M4,
          4281 => Opcode::PseudoVLOXEI8_V_M4_M4_MASK,
          4282 => Opcode::PseudoVLOXEI8_V_M4_M8,
          4283 => Opcode::PseudoVLOXEI8_V_M4_M8_MASK,
          4284 => Opcode::PseudoVLOXEI8_V_M8_M8,
          4285 => Opcode::PseudoVLOXEI8_V_M8_M8_MASK,
          4286 => Opcode::PseudoVLOXEI8_V_MF2_M1,
          4287 => Opcode::PseudoVLOXEI8_V_MF2_M1_MASK,
          4288 => Opcode::PseudoVLOXEI8_V_MF2_M2,
          4289 => Opcode::PseudoVLOXEI8_V_MF2_M2_MASK,
          4290 => Opcode::PseudoVLOXEI8_V_MF2_M4,
          4291 => Opcode::PseudoVLOXEI8_V_MF2_M4_MASK,
          4292 => Opcode::PseudoVLOXEI8_V_MF2_MF2,
          4293 => Opcode::PseudoVLOXEI8_V_MF2_MF2_MASK,
          4294 => Opcode::PseudoVLOXEI8_V_MF4_M1,
          4295 => Opcode::PseudoVLOXEI8_V_MF4_M1_MASK,
          4296 => Opcode::PseudoVLOXEI8_V_MF4_M2,
          4297 => Opcode::PseudoVLOXEI8_V_MF4_M2_MASK,
          4298 => Opcode::PseudoVLOXEI8_V_MF4_MF2,
          4299 => Opcode::PseudoVLOXEI8_V_MF4_MF2_MASK,
          4300 => Opcode::PseudoVLOXEI8_V_MF4_MF4,
          4301 => Opcode::PseudoVLOXEI8_V_MF4_MF4_MASK,
          4302 => Opcode::PseudoVLOXEI8_V_MF8_M1,
          4303 => Opcode::PseudoVLOXEI8_V_MF8_M1_MASK,
          4304 => Opcode::PseudoVLOXEI8_V_MF8_MF2,
          4305 => Opcode::PseudoVLOXEI8_V_MF8_MF2_MASK,
          4306 => Opcode::PseudoVLOXEI8_V_MF8_MF4,
          4307 => Opcode::PseudoVLOXEI8_V_MF8_MF4_MASK,
          4308 => Opcode::PseudoVLOXEI8_V_MF8_MF8,
          4309 => Opcode::PseudoVLOXEI8_V_MF8_MF8_MASK,
          4310 => Opcode::PseudoVLOXSEG2EI16_V_M1_M1,
          4311 => Opcode::PseudoVLOXSEG2EI16_V_M1_M1_MASK,
          4312 => Opcode::PseudoVLOXSEG2EI16_V_M1_M2,
          4313 => Opcode::PseudoVLOXSEG2EI16_V_M1_M2_MASK,
          4314 => Opcode::PseudoVLOXSEG2EI16_V_M1_M4,
          4315 => Opcode::PseudoVLOXSEG2EI16_V_M1_M4_MASK,
          4316 => Opcode::PseudoVLOXSEG2EI16_V_M1_MF2,
          4317 => Opcode::PseudoVLOXSEG2EI16_V_M1_MF2_MASK,
          4318 => Opcode::PseudoVLOXSEG2EI16_V_M2_M1,
          4319 => Opcode::PseudoVLOXSEG2EI16_V_M2_M1_MASK,
          4320 => Opcode::PseudoVLOXSEG2EI16_V_M2_M2,
          4321 => Opcode::PseudoVLOXSEG2EI16_V_M2_M2_MASK,
          4322 => Opcode::PseudoVLOXSEG2EI16_V_M2_M4,
          4323 => Opcode::PseudoVLOXSEG2EI16_V_M2_M4_MASK,
          4324 => Opcode::PseudoVLOXSEG2EI16_V_M4_M2,
          4325 => Opcode::PseudoVLOXSEG2EI16_V_M4_M2_MASK,
          4326 => Opcode::PseudoVLOXSEG2EI16_V_M4_M4,
          4327 => Opcode::PseudoVLOXSEG2EI16_V_M4_M4_MASK,
          4328 => Opcode::PseudoVLOXSEG2EI16_V_M8_M4,
          4329 => Opcode::PseudoVLOXSEG2EI16_V_M8_M4_MASK,
          4330 => Opcode::PseudoVLOXSEG2EI16_V_MF2_M1,
          4331 => Opcode::PseudoVLOXSEG2EI16_V_MF2_M1_MASK,
          4332 => Opcode::PseudoVLOXSEG2EI16_V_MF2_M2,
          4333 => Opcode::PseudoVLOXSEG2EI16_V_MF2_M2_MASK,
          4334 => Opcode::PseudoVLOXSEG2EI16_V_MF2_MF2,
          4335 => Opcode::PseudoVLOXSEG2EI16_V_MF2_MF2_MASK,
          4336 => Opcode::PseudoVLOXSEG2EI16_V_MF2_MF4,
          4337 => Opcode::PseudoVLOXSEG2EI16_V_MF2_MF4_MASK,
          4338 => Opcode::PseudoVLOXSEG2EI16_V_MF4_M1,
          4339 => Opcode::PseudoVLOXSEG2EI16_V_MF4_M1_MASK,
          4340 => Opcode::PseudoVLOXSEG2EI16_V_MF4_MF2,
          4341 => Opcode::PseudoVLOXSEG2EI16_V_MF4_MF2_MASK,
          4342 => Opcode::PseudoVLOXSEG2EI16_V_MF4_MF4,
          4343 => Opcode::PseudoVLOXSEG2EI16_V_MF4_MF4_MASK,
          4344 => Opcode::PseudoVLOXSEG2EI16_V_MF4_MF8,
          4345 => Opcode::PseudoVLOXSEG2EI16_V_MF4_MF8_MASK,
          4346 => Opcode::PseudoVLOXSEG2EI32_V_M1_M1,
          4347 => Opcode::PseudoVLOXSEG2EI32_V_M1_M1_MASK,
          4348 => Opcode::PseudoVLOXSEG2EI32_V_M1_M2,
          4349 => Opcode::PseudoVLOXSEG2EI32_V_M1_M2_MASK,
          4350 => Opcode::PseudoVLOXSEG2EI32_V_M1_MF2,
          4351 => Opcode::PseudoVLOXSEG2EI32_V_M1_MF2_MASK,
          4352 => Opcode::PseudoVLOXSEG2EI32_V_M1_MF4,
          4353 => Opcode::PseudoVLOXSEG2EI32_V_M1_MF4_MASK,
          4354 => Opcode::PseudoVLOXSEG2EI32_V_M2_M1,
          4355 => Opcode::PseudoVLOXSEG2EI32_V_M2_M1_MASK,
          4356 => Opcode::PseudoVLOXSEG2EI32_V_M2_M2,
          4357 => Opcode::PseudoVLOXSEG2EI32_V_M2_M2_MASK,
          4358 => Opcode::PseudoVLOXSEG2EI32_V_M2_M4,
          4359 => Opcode::PseudoVLOXSEG2EI32_V_M2_M4_MASK,
          4360 => Opcode::PseudoVLOXSEG2EI32_V_M2_MF2,
          4361 => Opcode::PseudoVLOXSEG2EI32_V_M2_MF2_MASK,
          4362 => Opcode::PseudoVLOXSEG2EI32_V_M4_M1,
          4363 => Opcode::PseudoVLOXSEG2EI32_V_M4_M1_MASK,
          4364 => Opcode::PseudoVLOXSEG2EI32_V_M4_M2,
          4365 => Opcode::PseudoVLOXSEG2EI32_V_M4_M2_MASK,
          4366 => Opcode::PseudoVLOXSEG2EI32_V_M4_M4,
          4367 => Opcode::PseudoVLOXSEG2EI32_V_M4_M4_MASK,
          4368 => Opcode::PseudoVLOXSEG2EI32_V_M8_M2,
          4369 => Opcode::PseudoVLOXSEG2EI32_V_M8_M2_MASK,
          4370 => Opcode::PseudoVLOXSEG2EI32_V_M8_M4,
          4371 => Opcode::PseudoVLOXSEG2EI32_V_M8_M4_MASK,
          4372 => Opcode::PseudoVLOXSEG2EI32_V_MF2_M1,
          4373 => Opcode::PseudoVLOXSEG2EI32_V_MF2_M1_MASK,
          4374 => Opcode::PseudoVLOXSEG2EI32_V_MF2_MF2,
          4375 => Opcode::PseudoVLOXSEG2EI32_V_MF2_MF2_MASK,
          4376 => Opcode::PseudoVLOXSEG2EI32_V_MF2_MF4,
          4377 => Opcode::PseudoVLOXSEG2EI32_V_MF2_MF4_MASK,
          4378 => Opcode::PseudoVLOXSEG2EI32_V_MF2_MF8,
          4379 => Opcode::PseudoVLOXSEG2EI32_V_MF2_MF8_MASK,
          4380 => Opcode::PseudoVLOXSEG2EI64_V_M1_M1,
          4381 => Opcode::PseudoVLOXSEG2EI64_V_M1_M1_MASK,
          4382 => Opcode::PseudoVLOXSEG2EI64_V_M1_MF2,
          4383 => Opcode::PseudoVLOXSEG2EI64_V_M1_MF2_MASK,
          4384 => Opcode::PseudoVLOXSEG2EI64_V_M1_MF4,
          4385 => Opcode::PseudoVLOXSEG2EI64_V_M1_MF4_MASK,
          4386 => Opcode::PseudoVLOXSEG2EI64_V_M1_MF8,
          4387 => Opcode::PseudoVLOXSEG2EI64_V_M1_MF8_MASK,
          4388 => Opcode::PseudoVLOXSEG2EI64_V_M2_M1,
          4389 => Opcode::PseudoVLOXSEG2EI64_V_M2_M1_MASK,
          4390 => Opcode::PseudoVLOXSEG2EI64_V_M2_M2,
          4391 => Opcode::PseudoVLOXSEG2EI64_V_M2_M2_MASK,
          4392 => Opcode::PseudoVLOXSEG2EI64_V_M2_MF2,
          4393 => Opcode::PseudoVLOXSEG2EI64_V_M2_MF2_MASK,
          4394 => Opcode::PseudoVLOXSEG2EI64_V_M2_MF4,
          4395 => Opcode::PseudoVLOXSEG2EI64_V_M2_MF4_MASK,
          4396 => Opcode::PseudoVLOXSEG2EI64_V_M4_M1,
          4397 => Opcode::PseudoVLOXSEG2EI64_V_M4_M1_MASK,
          4398 => Opcode::PseudoVLOXSEG2EI64_V_M4_M2,
          4399 => Opcode::PseudoVLOXSEG2EI64_V_M4_M2_MASK,
          4400 => Opcode::PseudoVLOXSEG2EI64_V_M4_M4,
          4401 => Opcode::PseudoVLOXSEG2EI64_V_M4_M4_MASK,
          4402 => Opcode::PseudoVLOXSEG2EI64_V_M4_MF2,
          4403 => Opcode::PseudoVLOXSEG2EI64_V_M4_MF2_MASK,
          4404 => Opcode::PseudoVLOXSEG2EI64_V_M8_M1,
          4405 => Opcode::PseudoVLOXSEG2EI64_V_M8_M1_MASK,
          4406 => Opcode::PseudoVLOXSEG2EI64_V_M8_M2,
          4407 => Opcode::PseudoVLOXSEG2EI64_V_M8_M2_MASK,
          4408 => Opcode::PseudoVLOXSEG2EI64_V_M8_M4,
          4409 => Opcode::PseudoVLOXSEG2EI64_V_M8_M4_MASK,
          4410 => Opcode::PseudoVLOXSEG2EI8_V_M1_M1,
          4411 => Opcode::PseudoVLOXSEG2EI8_V_M1_M1_MASK,
          4412 => Opcode::PseudoVLOXSEG2EI8_V_M1_M2,
          4413 => Opcode::PseudoVLOXSEG2EI8_V_M1_M2_MASK,
          4414 => Opcode::PseudoVLOXSEG2EI8_V_M1_M4,
          4415 => Opcode::PseudoVLOXSEG2EI8_V_M1_M4_MASK,
          4416 => Opcode::PseudoVLOXSEG2EI8_V_M2_M2,
          4417 => Opcode::PseudoVLOXSEG2EI8_V_M2_M2_MASK,
          4418 => Opcode::PseudoVLOXSEG2EI8_V_M2_M4,
          4419 => Opcode::PseudoVLOXSEG2EI8_V_M2_M4_MASK,
          4420 => Opcode::PseudoVLOXSEG2EI8_V_M4_M4,
          4421 => Opcode::PseudoVLOXSEG2EI8_V_M4_M4_MASK,
          4422 => Opcode::PseudoVLOXSEG2EI8_V_MF2_M1,
          4423 => Opcode::PseudoVLOXSEG2EI8_V_MF2_M1_MASK,
          4424 => Opcode::PseudoVLOXSEG2EI8_V_MF2_M2,
          4425 => Opcode::PseudoVLOXSEG2EI8_V_MF2_M2_MASK,
          4426 => Opcode::PseudoVLOXSEG2EI8_V_MF2_M4,
          4427 => Opcode::PseudoVLOXSEG2EI8_V_MF2_M4_MASK,
          4428 => Opcode::PseudoVLOXSEG2EI8_V_MF2_MF2,
          4429 => Opcode::PseudoVLOXSEG2EI8_V_MF2_MF2_MASK,
          4430 => Opcode::PseudoVLOXSEG2EI8_V_MF4_M1,
          4431 => Opcode::PseudoVLOXSEG2EI8_V_MF4_M1_MASK,
          4432 => Opcode::PseudoVLOXSEG2EI8_V_MF4_M2,
          4433 => Opcode::PseudoVLOXSEG2EI8_V_MF4_M2_MASK,
          4434 => Opcode::PseudoVLOXSEG2EI8_V_MF4_MF2,
          4435 => Opcode::PseudoVLOXSEG2EI8_V_MF4_MF2_MASK,
          4436 => Opcode::PseudoVLOXSEG2EI8_V_MF4_MF4,
          4437 => Opcode::PseudoVLOXSEG2EI8_V_MF4_MF4_MASK,
          4438 => Opcode::PseudoVLOXSEG2EI8_V_MF8_M1,
          4439 => Opcode::PseudoVLOXSEG2EI8_V_MF8_M1_MASK,
          4440 => Opcode::PseudoVLOXSEG2EI8_V_MF8_MF2,
          4441 => Opcode::PseudoVLOXSEG2EI8_V_MF8_MF2_MASK,
          4442 => Opcode::PseudoVLOXSEG2EI8_V_MF8_MF4,
          4443 => Opcode::PseudoVLOXSEG2EI8_V_MF8_MF4_MASK,
          4444 => Opcode::PseudoVLOXSEG2EI8_V_MF8_MF8,
          4445 => Opcode::PseudoVLOXSEG2EI8_V_MF8_MF8_MASK,
          4446 => Opcode::PseudoVLOXSEG3EI16_V_M1_M1,
          4447 => Opcode::PseudoVLOXSEG3EI16_V_M1_M1_MASK,
          4448 => Opcode::PseudoVLOXSEG3EI16_V_M1_M2,
          4449 => Opcode::PseudoVLOXSEG3EI16_V_M1_M2_MASK,
          4450 => Opcode::PseudoVLOXSEG3EI16_V_M1_MF2,
          4451 => Opcode::PseudoVLOXSEG3EI16_V_M1_MF2_MASK,
          4452 => Opcode::PseudoVLOXSEG3EI16_V_M2_M1,
          4453 => Opcode::PseudoVLOXSEG3EI16_V_M2_M1_MASK,
          4454 => Opcode::PseudoVLOXSEG3EI16_V_M2_M2,
          4455 => Opcode::PseudoVLOXSEG3EI16_V_M2_M2_MASK,
          4456 => Opcode::PseudoVLOXSEG3EI16_V_M4_M2,
          4457 => Opcode::PseudoVLOXSEG3EI16_V_M4_M2_MASK,
          4458 => Opcode::PseudoVLOXSEG3EI16_V_MF2_M1,
          4459 => Opcode::PseudoVLOXSEG3EI16_V_MF2_M1_MASK,
          4460 => Opcode::PseudoVLOXSEG3EI16_V_MF2_M2,
          4461 => Opcode::PseudoVLOXSEG3EI16_V_MF2_M2_MASK,
          4462 => Opcode::PseudoVLOXSEG3EI16_V_MF2_MF2,
          4463 => Opcode::PseudoVLOXSEG3EI16_V_MF2_MF2_MASK,
          4464 => Opcode::PseudoVLOXSEG3EI16_V_MF2_MF4,
          4465 => Opcode::PseudoVLOXSEG3EI16_V_MF2_MF4_MASK,
          4466 => Opcode::PseudoVLOXSEG3EI16_V_MF4_M1,
          4467 => Opcode::PseudoVLOXSEG3EI16_V_MF4_M1_MASK,
          4468 => Opcode::PseudoVLOXSEG3EI16_V_MF4_MF2,
          4469 => Opcode::PseudoVLOXSEG3EI16_V_MF4_MF2_MASK,
          4470 => Opcode::PseudoVLOXSEG3EI16_V_MF4_MF4,
          4471 => Opcode::PseudoVLOXSEG3EI16_V_MF4_MF4_MASK,
          4472 => Opcode::PseudoVLOXSEG3EI16_V_MF4_MF8,
          4473 => Opcode::PseudoVLOXSEG3EI16_V_MF4_MF8_MASK,
          4474 => Opcode::PseudoVLOXSEG3EI32_V_M1_M1,
          4475 => Opcode::PseudoVLOXSEG3EI32_V_M1_M1_MASK,
          4476 => Opcode::PseudoVLOXSEG3EI32_V_M1_M2,
          4477 => Opcode::PseudoVLOXSEG3EI32_V_M1_M2_MASK,
          4478 => Opcode::PseudoVLOXSEG3EI32_V_M1_MF2,
          4479 => Opcode::PseudoVLOXSEG3EI32_V_M1_MF2_MASK,
          4480 => Opcode::PseudoVLOXSEG3EI32_V_M1_MF4,
          4481 => Opcode::PseudoVLOXSEG3EI32_V_M1_MF4_MASK,
          4482 => Opcode::PseudoVLOXSEG3EI32_V_M2_M1,
          4483 => Opcode::PseudoVLOXSEG3EI32_V_M2_M1_MASK,
          4484 => Opcode::PseudoVLOXSEG3EI32_V_M2_M2,
          4485 => Opcode::PseudoVLOXSEG3EI32_V_M2_M2_MASK,
          4486 => Opcode::PseudoVLOXSEG3EI32_V_M2_MF2,
          4487 => Opcode::PseudoVLOXSEG3EI32_V_M2_MF2_MASK,
          4488 => Opcode::PseudoVLOXSEG3EI32_V_M4_M1,
          4489 => Opcode::PseudoVLOXSEG3EI32_V_M4_M1_MASK,
          4490 => Opcode::PseudoVLOXSEG3EI32_V_M4_M2,
          4491 => Opcode::PseudoVLOXSEG3EI32_V_M4_M2_MASK,
          4492 => Opcode::PseudoVLOXSEG3EI32_V_M8_M2,
          4493 => Opcode::PseudoVLOXSEG3EI32_V_M8_M2_MASK,
          4494 => Opcode::PseudoVLOXSEG3EI32_V_MF2_M1,
          4495 => Opcode::PseudoVLOXSEG3EI32_V_MF2_M1_MASK,
          4496 => Opcode::PseudoVLOXSEG3EI32_V_MF2_MF2,
          4497 => Opcode::PseudoVLOXSEG3EI32_V_MF2_MF2_MASK,
          4498 => Opcode::PseudoVLOXSEG3EI32_V_MF2_MF4,
          4499 => Opcode::PseudoVLOXSEG3EI32_V_MF2_MF4_MASK,
          4500 => Opcode::PseudoVLOXSEG3EI32_V_MF2_MF8,
          4501 => Opcode::PseudoVLOXSEG3EI32_V_MF2_MF8_MASK,
          4502 => Opcode::PseudoVLOXSEG3EI64_V_M1_M1,
          4503 => Opcode::PseudoVLOXSEG3EI64_V_M1_M1_MASK,
          4504 => Opcode::PseudoVLOXSEG3EI64_V_M1_MF2,
          4505 => Opcode::PseudoVLOXSEG3EI64_V_M1_MF2_MASK,
          4506 => Opcode::PseudoVLOXSEG3EI64_V_M1_MF4,
          4507 => Opcode::PseudoVLOXSEG3EI64_V_M1_MF4_MASK,
          4508 => Opcode::PseudoVLOXSEG3EI64_V_M1_MF8,
          4509 => Opcode::PseudoVLOXSEG3EI64_V_M1_MF8_MASK,
          4510 => Opcode::PseudoVLOXSEG3EI64_V_M2_M1,
          4511 => Opcode::PseudoVLOXSEG3EI64_V_M2_M1_MASK,
          4512 => Opcode::PseudoVLOXSEG3EI64_V_M2_M2,
          4513 => Opcode::PseudoVLOXSEG3EI64_V_M2_M2_MASK,
          4514 => Opcode::PseudoVLOXSEG3EI64_V_M2_MF2,
          4515 => Opcode::PseudoVLOXSEG3EI64_V_M2_MF2_MASK,
          4516 => Opcode::PseudoVLOXSEG3EI64_V_M2_MF4,
          4517 => Opcode::PseudoVLOXSEG3EI64_V_M2_MF4_MASK,
          4518 => Opcode::PseudoVLOXSEG3EI64_V_M4_M1,
          4519 => Opcode::PseudoVLOXSEG3EI64_V_M4_M1_MASK,
          4520 => Opcode::PseudoVLOXSEG3EI64_V_M4_M2,
          4521 => Opcode::PseudoVLOXSEG3EI64_V_M4_M2_MASK,
          4522 => Opcode::PseudoVLOXSEG3EI64_V_M4_MF2,
          4523 => Opcode::PseudoVLOXSEG3EI64_V_M4_MF2_MASK,
          4524 => Opcode::PseudoVLOXSEG3EI64_V_M8_M1,
          4525 => Opcode::PseudoVLOXSEG3EI64_V_M8_M1_MASK,
          4526 => Opcode::PseudoVLOXSEG3EI64_V_M8_M2,
          4527 => Opcode::PseudoVLOXSEG3EI64_V_M8_M2_MASK,
          4528 => Opcode::PseudoVLOXSEG3EI8_V_M1_M1,
          4529 => Opcode::PseudoVLOXSEG3EI8_V_M1_M1_MASK,
          4530 => Opcode::PseudoVLOXSEG3EI8_V_M1_M2,
          4531 => Opcode::PseudoVLOXSEG3EI8_V_M1_M2_MASK,
          4532 => Opcode::PseudoVLOXSEG3EI8_V_M2_M2,
          4533 => Opcode::PseudoVLOXSEG3EI8_V_M2_M2_MASK,
          4534 => Opcode::PseudoVLOXSEG3EI8_V_MF2_M1,
          4535 => Opcode::PseudoVLOXSEG3EI8_V_MF2_M1_MASK,
          4536 => Opcode::PseudoVLOXSEG3EI8_V_MF2_M2,
          4537 => Opcode::PseudoVLOXSEG3EI8_V_MF2_M2_MASK,
          4538 => Opcode::PseudoVLOXSEG3EI8_V_MF2_MF2,
          4539 => Opcode::PseudoVLOXSEG3EI8_V_MF2_MF2_MASK,
          4540 => Opcode::PseudoVLOXSEG3EI8_V_MF4_M1,
          4541 => Opcode::PseudoVLOXSEG3EI8_V_MF4_M1_MASK,
          4542 => Opcode::PseudoVLOXSEG3EI8_V_MF4_M2,
          4543 => Opcode::PseudoVLOXSEG3EI8_V_MF4_M2_MASK,
          4544 => Opcode::PseudoVLOXSEG3EI8_V_MF4_MF2,
          4545 => Opcode::PseudoVLOXSEG3EI8_V_MF4_MF2_MASK,
          4546 => Opcode::PseudoVLOXSEG3EI8_V_MF4_MF4,
          4547 => Opcode::PseudoVLOXSEG3EI8_V_MF4_MF4_MASK,
          4548 => Opcode::PseudoVLOXSEG3EI8_V_MF8_M1,
          4549 => Opcode::PseudoVLOXSEG3EI8_V_MF8_M1_MASK,
          4550 => Opcode::PseudoVLOXSEG3EI8_V_MF8_MF2,
          4551 => Opcode::PseudoVLOXSEG3EI8_V_MF8_MF2_MASK,
          4552 => Opcode::PseudoVLOXSEG3EI8_V_MF8_MF4,
          4553 => Opcode::PseudoVLOXSEG3EI8_V_MF8_MF4_MASK,
          4554 => Opcode::PseudoVLOXSEG3EI8_V_MF8_MF8,
          4555 => Opcode::PseudoVLOXSEG3EI8_V_MF8_MF8_MASK,
          4556 => Opcode::PseudoVLOXSEG4EI16_V_M1_M1,
          4557 => Opcode::PseudoVLOXSEG4EI16_V_M1_M1_MASK,
          4558 => Opcode::PseudoVLOXSEG4EI16_V_M1_M2,
          4559 => Opcode::PseudoVLOXSEG4EI16_V_M1_M2_MASK,
          4560 => Opcode::PseudoVLOXSEG4EI16_V_M1_MF2,
          4561 => Opcode::PseudoVLOXSEG4EI16_V_M1_MF2_MASK,
          4562 => Opcode::PseudoVLOXSEG4EI16_V_M2_M1,
          4563 => Opcode::PseudoVLOXSEG4EI16_V_M2_M1_MASK,
          4564 => Opcode::PseudoVLOXSEG4EI16_V_M2_M2,
          4565 => Opcode::PseudoVLOXSEG4EI16_V_M2_M2_MASK,
          4566 => Opcode::PseudoVLOXSEG4EI16_V_M4_M2,
          4567 => Opcode::PseudoVLOXSEG4EI16_V_M4_M2_MASK,
          4568 => Opcode::PseudoVLOXSEG4EI16_V_MF2_M1,
          4569 => Opcode::PseudoVLOXSEG4EI16_V_MF2_M1_MASK,
          4570 => Opcode::PseudoVLOXSEG4EI16_V_MF2_M2,
          4571 => Opcode::PseudoVLOXSEG4EI16_V_MF2_M2_MASK,
          4572 => Opcode::PseudoVLOXSEG4EI16_V_MF2_MF2,
          4573 => Opcode::PseudoVLOXSEG4EI16_V_MF2_MF2_MASK,
          4574 => Opcode::PseudoVLOXSEG4EI16_V_MF2_MF4,
          4575 => Opcode::PseudoVLOXSEG4EI16_V_MF2_MF4_MASK,
          4576 => Opcode::PseudoVLOXSEG4EI16_V_MF4_M1,
          4577 => Opcode::PseudoVLOXSEG4EI16_V_MF4_M1_MASK,
          4578 => Opcode::PseudoVLOXSEG4EI16_V_MF4_MF2,
          4579 => Opcode::PseudoVLOXSEG4EI16_V_MF4_MF2_MASK,
          4580 => Opcode::PseudoVLOXSEG4EI16_V_MF4_MF4,
          4581 => Opcode::PseudoVLOXSEG4EI16_V_MF4_MF4_MASK,
          4582 => Opcode::PseudoVLOXSEG4EI16_V_MF4_MF8,
          4583 => Opcode::PseudoVLOXSEG4EI16_V_MF4_MF8_MASK,
          4584 => Opcode::PseudoVLOXSEG4EI32_V_M1_M1,
          4585 => Opcode::PseudoVLOXSEG4EI32_V_M1_M1_MASK,
          4586 => Opcode::PseudoVLOXSEG4EI32_V_M1_M2,
          4587 => Opcode::PseudoVLOXSEG4EI32_V_M1_M2_MASK,
          4588 => Opcode::PseudoVLOXSEG4EI32_V_M1_MF2,
          4589 => Opcode::PseudoVLOXSEG4EI32_V_M1_MF2_MASK,
          4590 => Opcode::PseudoVLOXSEG4EI32_V_M1_MF4,
          4591 => Opcode::PseudoVLOXSEG4EI32_V_M1_MF4_MASK,
          4592 => Opcode::PseudoVLOXSEG4EI32_V_M2_M1,
          4593 => Opcode::PseudoVLOXSEG4EI32_V_M2_M1_MASK,
          4594 => Opcode::PseudoVLOXSEG4EI32_V_M2_M2,
          4595 => Opcode::PseudoVLOXSEG4EI32_V_M2_M2_MASK,
          4596 => Opcode::PseudoVLOXSEG4EI32_V_M2_MF2,
          4597 => Opcode::PseudoVLOXSEG4EI32_V_M2_MF2_MASK,
          4598 => Opcode::PseudoVLOXSEG4EI32_V_M4_M1,
          4599 => Opcode::PseudoVLOXSEG4EI32_V_M4_M1_MASK,
          4600 => Opcode::PseudoVLOXSEG4EI32_V_M4_M2,
          4601 => Opcode::PseudoVLOXSEG4EI32_V_M4_M2_MASK,
          4602 => Opcode::PseudoVLOXSEG4EI32_V_M8_M2,
          4603 => Opcode::PseudoVLOXSEG4EI32_V_M8_M2_MASK,
          4604 => Opcode::PseudoVLOXSEG4EI32_V_MF2_M1,
          4605 => Opcode::PseudoVLOXSEG4EI32_V_MF2_M1_MASK,
          4606 => Opcode::PseudoVLOXSEG4EI32_V_MF2_MF2,
          4607 => Opcode::PseudoVLOXSEG4EI32_V_MF2_MF2_MASK,
          4608 => Opcode::PseudoVLOXSEG4EI32_V_MF2_MF4,
          4609 => Opcode::PseudoVLOXSEG4EI32_V_MF2_MF4_MASK,
          4610 => Opcode::PseudoVLOXSEG4EI32_V_MF2_MF8,
          4611 => Opcode::PseudoVLOXSEG4EI32_V_MF2_MF8_MASK,
          4612 => Opcode::PseudoVLOXSEG4EI64_V_M1_M1,
          4613 => Opcode::PseudoVLOXSEG4EI64_V_M1_M1_MASK,
          4614 => Opcode::PseudoVLOXSEG4EI64_V_M1_MF2,
          4615 => Opcode::PseudoVLOXSEG4EI64_V_M1_MF2_MASK,
          4616 => Opcode::PseudoVLOXSEG4EI64_V_M1_MF4,
          4617 => Opcode::PseudoVLOXSEG4EI64_V_M1_MF4_MASK,
          4618 => Opcode::PseudoVLOXSEG4EI64_V_M1_MF8,
          4619 => Opcode::PseudoVLOXSEG4EI64_V_M1_MF8_MASK,
          4620 => Opcode::PseudoVLOXSEG4EI64_V_M2_M1,
          4621 => Opcode::PseudoVLOXSEG4EI64_V_M2_M1_MASK,
          4622 => Opcode::PseudoVLOXSEG4EI64_V_M2_M2,
          4623 => Opcode::PseudoVLOXSEG4EI64_V_M2_M2_MASK,
          4624 => Opcode::PseudoVLOXSEG4EI64_V_M2_MF2,
          4625 => Opcode::PseudoVLOXSEG4EI64_V_M2_MF2_MASK,
          4626 => Opcode::PseudoVLOXSEG4EI64_V_M2_MF4,
          4627 => Opcode::PseudoVLOXSEG4EI64_V_M2_MF4_MASK,
          4628 => Opcode::PseudoVLOXSEG4EI64_V_M4_M1,
          4629 => Opcode::PseudoVLOXSEG4EI64_V_M4_M1_MASK,
          4630 => Opcode::PseudoVLOXSEG4EI64_V_M4_M2,
          4631 => Opcode::PseudoVLOXSEG4EI64_V_M4_M2_MASK,
          4632 => Opcode::PseudoVLOXSEG4EI64_V_M4_MF2,
          4633 => Opcode::PseudoVLOXSEG4EI64_V_M4_MF2_MASK,
          4634 => Opcode::PseudoVLOXSEG4EI64_V_M8_M1,
          4635 => Opcode::PseudoVLOXSEG4EI64_V_M8_M1_MASK,
          4636 => Opcode::PseudoVLOXSEG4EI64_V_M8_M2,
          4637 => Opcode::PseudoVLOXSEG4EI64_V_M8_M2_MASK,
          4638 => Opcode::PseudoVLOXSEG4EI8_V_M1_M1,
          4639 => Opcode::PseudoVLOXSEG4EI8_V_M1_M1_MASK,
          4640 => Opcode::PseudoVLOXSEG4EI8_V_M1_M2,
          4641 => Opcode::PseudoVLOXSEG4EI8_V_M1_M2_MASK,
          4642 => Opcode::PseudoVLOXSEG4EI8_V_M2_M2,
          4643 => Opcode::PseudoVLOXSEG4EI8_V_M2_M2_MASK,
          4644 => Opcode::PseudoVLOXSEG4EI8_V_MF2_M1,
          4645 => Opcode::PseudoVLOXSEG4EI8_V_MF2_M1_MASK,
          4646 => Opcode::PseudoVLOXSEG4EI8_V_MF2_M2,
          4647 => Opcode::PseudoVLOXSEG4EI8_V_MF2_M2_MASK,
          4648 => Opcode::PseudoVLOXSEG4EI8_V_MF2_MF2,
          4649 => Opcode::PseudoVLOXSEG4EI8_V_MF2_MF2_MASK,
          4650 => Opcode::PseudoVLOXSEG4EI8_V_MF4_M1,
          4651 => Opcode::PseudoVLOXSEG4EI8_V_MF4_M1_MASK,
          4652 => Opcode::PseudoVLOXSEG4EI8_V_MF4_M2,
          4653 => Opcode::PseudoVLOXSEG4EI8_V_MF4_M2_MASK,
          4654 => Opcode::PseudoVLOXSEG4EI8_V_MF4_MF2,
          4655 => Opcode::PseudoVLOXSEG4EI8_V_MF4_MF2_MASK,
          4656 => Opcode::PseudoVLOXSEG4EI8_V_MF4_MF4,
          4657 => Opcode::PseudoVLOXSEG4EI8_V_MF4_MF4_MASK,
          4658 => Opcode::PseudoVLOXSEG4EI8_V_MF8_M1,
          4659 => Opcode::PseudoVLOXSEG4EI8_V_MF8_M1_MASK,
          4660 => Opcode::PseudoVLOXSEG4EI8_V_MF8_MF2,
          4661 => Opcode::PseudoVLOXSEG4EI8_V_MF8_MF2_MASK,
          4662 => Opcode::PseudoVLOXSEG4EI8_V_MF8_MF4,
          4663 => Opcode::PseudoVLOXSEG4EI8_V_MF8_MF4_MASK,
          4664 => Opcode::PseudoVLOXSEG4EI8_V_MF8_MF8,
          4665 => Opcode::PseudoVLOXSEG4EI8_V_MF8_MF8_MASK,
          4666 => Opcode::PseudoVLOXSEG5EI16_V_M1_M1,
          4667 => Opcode::PseudoVLOXSEG5EI16_V_M1_M1_MASK,
          4668 => Opcode::PseudoVLOXSEG5EI16_V_M1_MF2,
          4669 => Opcode::PseudoVLOXSEG5EI16_V_M1_MF2_MASK,
          4670 => Opcode::PseudoVLOXSEG5EI16_V_M2_M1,
          4671 => Opcode::PseudoVLOXSEG5EI16_V_M2_M1_MASK,
          4672 => Opcode::PseudoVLOXSEG5EI16_V_MF2_M1,
          4673 => Opcode::PseudoVLOXSEG5EI16_V_MF2_M1_MASK,
          4674 => Opcode::PseudoVLOXSEG5EI16_V_MF2_MF2,
          4675 => Opcode::PseudoVLOXSEG5EI16_V_MF2_MF2_MASK,
          4676 => Opcode::PseudoVLOXSEG5EI16_V_MF2_MF4,
          4677 => Opcode::PseudoVLOXSEG5EI16_V_MF2_MF4_MASK,
          4678 => Opcode::PseudoVLOXSEG5EI16_V_MF4_M1,
          4679 => Opcode::PseudoVLOXSEG5EI16_V_MF4_M1_MASK,
          4680 => Opcode::PseudoVLOXSEG5EI16_V_MF4_MF2,
          4681 => Opcode::PseudoVLOXSEG5EI16_V_MF4_MF2_MASK,
          4682 => Opcode::PseudoVLOXSEG5EI16_V_MF4_MF4,
          4683 => Opcode::PseudoVLOXSEG5EI16_V_MF4_MF4_MASK,
          4684 => Opcode::PseudoVLOXSEG5EI16_V_MF4_MF8,
          4685 => Opcode::PseudoVLOXSEG5EI16_V_MF4_MF8_MASK,
          4686 => Opcode::PseudoVLOXSEG5EI32_V_M1_M1,
          4687 => Opcode::PseudoVLOXSEG5EI32_V_M1_M1_MASK,
          4688 => Opcode::PseudoVLOXSEG5EI32_V_M1_MF2,
          4689 => Opcode::PseudoVLOXSEG5EI32_V_M1_MF2_MASK,
          4690 => Opcode::PseudoVLOXSEG5EI32_V_M1_MF4,
          4691 => Opcode::PseudoVLOXSEG5EI32_V_M1_MF4_MASK,
          4692 => Opcode::PseudoVLOXSEG5EI32_V_M2_M1,
          4693 => Opcode::PseudoVLOXSEG5EI32_V_M2_M1_MASK,
          4694 => Opcode::PseudoVLOXSEG5EI32_V_M2_MF2,
          4695 => Opcode::PseudoVLOXSEG5EI32_V_M2_MF2_MASK,
          4696 => Opcode::PseudoVLOXSEG5EI32_V_M4_M1,
          4697 => Opcode::PseudoVLOXSEG5EI32_V_M4_M1_MASK,
          4698 => Opcode::PseudoVLOXSEG5EI32_V_MF2_M1,
          4699 => Opcode::PseudoVLOXSEG5EI32_V_MF2_M1_MASK,
          4700 => Opcode::PseudoVLOXSEG5EI32_V_MF2_MF2,
          4701 => Opcode::PseudoVLOXSEG5EI32_V_MF2_MF2_MASK,
          4702 => Opcode::PseudoVLOXSEG5EI32_V_MF2_MF4,
          4703 => Opcode::PseudoVLOXSEG5EI32_V_MF2_MF4_MASK,
          4704 => Opcode::PseudoVLOXSEG5EI32_V_MF2_MF8,
          4705 => Opcode::PseudoVLOXSEG5EI32_V_MF2_MF8_MASK,
          4706 => Opcode::PseudoVLOXSEG5EI64_V_M1_M1,
          4707 => Opcode::PseudoVLOXSEG5EI64_V_M1_M1_MASK,
          4708 => Opcode::PseudoVLOXSEG5EI64_V_M1_MF2,
          4709 => Opcode::PseudoVLOXSEG5EI64_V_M1_MF2_MASK,
          4710 => Opcode::PseudoVLOXSEG5EI64_V_M1_MF4,
          4711 => Opcode::PseudoVLOXSEG5EI64_V_M1_MF4_MASK,
          4712 => Opcode::PseudoVLOXSEG5EI64_V_M1_MF8,
          4713 => Opcode::PseudoVLOXSEG5EI64_V_M1_MF8_MASK,
          4714 => Opcode::PseudoVLOXSEG5EI64_V_M2_M1,
          4715 => Opcode::PseudoVLOXSEG5EI64_V_M2_M1_MASK,
          4716 => Opcode::PseudoVLOXSEG5EI64_V_M2_MF2,
          4717 => Opcode::PseudoVLOXSEG5EI64_V_M2_MF2_MASK,
          4718 => Opcode::PseudoVLOXSEG5EI64_V_M2_MF4,
          4719 => Opcode::PseudoVLOXSEG5EI64_V_M2_MF4_MASK,
          4720 => Opcode::PseudoVLOXSEG5EI64_V_M4_M1,
          4721 => Opcode::PseudoVLOXSEG5EI64_V_M4_M1_MASK,
          4722 => Opcode::PseudoVLOXSEG5EI64_V_M4_MF2,
          4723 => Opcode::PseudoVLOXSEG5EI64_V_M4_MF2_MASK,
          4724 => Opcode::PseudoVLOXSEG5EI64_V_M8_M1,
          4725 => Opcode::PseudoVLOXSEG5EI64_V_M8_M1_MASK,
          4726 => Opcode::PseudoVLOXSEG5EI8_V_M1_M1,
          4727 => Opcode::PseudoVLOXSEG5EI8_V_M1_M1_MASK,
          4728 => Opcode::PseudoVLOXSEG5EI8_V_MF2_M1,
          4729 => Opcode::PseudoVLOXSEG5EI8_V_MF2_M1_MASK,
          4730 => Opcode::PseudoVLOXSEG5EI8_V_MF2_MF2,
          4731 => Opcode::PseudoVLOXSEG5EI8_V_MF2_MF2_MASK,
          4732 => Opcode::PseudoVLOXSEG5EI8_V_MF4_M1,
          4733 => Opcode::PseudoVLOXSEG5EI8_V_MF4_M1_MASK,
          4734 => Opcode::PseudoVLOXSEG5EI8_V_MF4_MF2,
          4735 => Opcode::PseudoVLOXSEG5EI8_V_MF4_MF2_MASK,
          4736 => Opcode::PseudoVLOXSEG5EI8_V_MF4_MF4,
          4737 => Opcode::PseudoVLOXSEG5EI8_V_MF4_MF4_MASK,
          4738 => Opcode::PseudoVLOXSEG5EI8_V_MF8_M1,
          4739 => Opcode::PseudoVLOXSEG5EI8_V_MF8_M1_MASK,
          4740 => Opcode::PseudoVLOXSEG5EI8_V_MF8_MF2,
          4741 => Opcode::PseudoVLOXSEG5EI8_V_MF8_MF2_MASK,
          4742 => Opcode::PseudoVLOXSEG5EI8_V_MF8_MF4,
          4743 => Opcode::PseudoVLOXSEG5EI8_V_MF8_MF4_MASK,
          4744 => Opcode::PseudoVLOXSEG5EI8_V_MF8_MF8,
          4745 => Opcode::PseudoVLOXSEG5EI8_V_MF8_MF8_MASK,
          4746 => Opcode::PseudoVLOXSEG6EI16_V_M1_M1,
          4747 => Opcode::PseudoVLOXSEG6EI16_V_M1_M1_MASK,
          4748 => Opcode::PseudoVLOXSEG6EI16_V_M1_MF2,
          4749 => Opcode::PseudoVLOXSEG6EI16_V_M1_MF2_MASK,
          4750 => Opcode::PseudoVLOXSEG6EI16_V_M2_M1,
          4751 => Opcode::PseudoVLOXSEG6EI16_V_M2_M1_MASK,
          4752 => Opcode::PseudoVLOXSEG6EI16_V_MF2_M1,
          4753 => Opcode::PseudoVLOXSEG6EI16_V_MF2_M1_MASK,
          4754 => Opcode::PseudoVLOXSEG6EI16_V_MF2_MF2,
          4755 => Opcode::PseudoVLOXSEG6EI16_V_MF2_MF2_MASK,
          4756 => Opcode::PseudoVLOXSEG6EI16_V_MF2_MF4,
          4757 => Opcode::PseudoVLOXSEG6EI16_V_MF2_MF4_MASK,
          4758 => Opcode::PseudoVLOXSEG6EI16_V_MF4_M1,
          4759 => Opcode::PseudoVLOXSEG6EI16_V_MF4_M1_MASK,
          4760 => Opcode::PseudoVLOXSEG6EI16_V_MF4_MF2,
          4761 => Opcode::PseudoVLOXSEG6EI16_V_MF4_MF2_MASK,
          4762 => Opcode::PseudoVLOXSEG6EI16_V_MF4_MF4,
          4763 => Opcode::PseudoVLOXSEG6EI16_V_MF4_MF4_MASK,
          4764 => Opcode::PseudoVLOXSEG6EI16_V_MF4_MF8,
          4765 => Opcode::PseudoVLOXSEG6EI16_V_MF4_MF8_MASK,
          4766 => Opcode::PseudoVLOXSEG6EI32_V_M1_M1,
          4767 => Opcode::PseudoVLOXSEG6EI32_V_M1_M1_MASK,
          4768 => Opcode::PseudoVLOXSEG6EI32_V_M1_MF2,
          4769 => Opcode::PseudoVLOXSEG6EI32_V_M1_MF2_MASK,
          4770 => Opcode::PseudoVLOXSEG6EI32_V_M1_MF4,
          4771 => Opcode::PseudoVLOXSEG6EI32_V_M1_MF4_MASK,
          4772 => Opcode::PseudoVLOXSEG6EI32_V_M2_M1,
          4773 => Opcode::PseudoVLOXSEG6EI32_V_M2_M1_MASK,
          4774 => Opcode::PseudoVLOXSEG6EI32_V_M2_MF2,
          4775 => Opcode::PseudoVLOXSEG6EI32_V_M2_MF2_MASK,
          4776 => Opcode::PseudoVLOXSEG6EI32_V_M4_M1,
          4777 => Opcode::PseudoVLOXSEG6EI32_V_M4_M1_MASK,
          4778 => Opcode::PseudoVLOXSEG6EI32_V_MF2_M1,
          4779 => Opcode::PseudoVLOXSEG6EI32_V_MF2_M1_MASK,
          4780 => Opcode::PseudoVLOXSEG6EI32_V_MF2_MF2,
          4781 => Opcode::PseudoVLOXSEG6EI32_V_MF2_MF2_MASK,
          4782 => Opcode::PseudoVLOXSEG6EI32_V_MF2_MF4,
          4783 => Opcode::PseudoVLOXSEG6EI32_V_MF2_MF4_MASK,
          4784 => Opcode::PseudoVLOXSEG6EI32_V_MF2_MF8,
          4785 => Opcode::PseudoVLOXSEG6EI32_V_MF2_MF8_MASK,
          4786 => Opcode::PseudoVLOXSEG6EI64_V_M1_M1,
          4787 => Opcode::PseudoVLOXSEG6EI64_V_M1_M1_MASK,
          4788 => Opcode::PseudoVLOXSEG6EI64_V_M1_MF2,
          4789 => Opcode::PseudoVLOXSEG6EI64_V_M1_MF2_MASK,
          4790 => Opcode::PseudoVLOXSEG6EI64_V_M1_MF4,
          4791 => Opcode::PseudoVLOXSEG6EI64_V_M1_MF4_MASK,
          4792 => Opcode::PseudoVLOXSEG6EI64_V_M1_MF8,
          4793 => Opcode::PseudoVLOXSEG6EI64_V_M1_MF8_MASK,
          4794 => Opcode::PseudoVLOXSEG6EI64_V_M2_M1,
          4795 => Opcode::PseudoVLOXSEG6EI64_V_M2_M1_MASK,
          4796 => Opcode::PseudoVLOXSEG6EI64_V_M2_MF2,
          4797 => Opcode::PseudoVLOXSEG6EI64_V_M2_MF2_MASK,
          4798 => Opcode::PseudoVLOXSEG6EI64_V_M2_MF4,
          4799 => Opcode::PseudoVLOXSEG6EI64_V_M2_MF4_MASK,
          4800 => Opcode::PseudoVLOXSEG6EI64_V_M4_M1,
          4801 => Opcode::PseudoVLOXSEG6EI64_V_M4_M1_MASK,
          4802 => Opcode::PseudoVLOXSEG6EI64_V_M4_MF2,
          4803 => Opcode::PseudoVLOXSEG6EI64_V_M4_MF2_MASK,
          4804 => Opcode::PseudoVLOXSEG6EI64_V_M8_M1,
          4805 => Opcode::PseudoVLOXSEG6EI64_V_M8_M1_MASK,
          4806 => Opcode::PseudoVLOXSEG6EI8_V_M1_M1,
          4807 => Opcode::PseudoVLOXSEG6EI8_V_M1_M1_MASK,
          4808 => Opcode::PseudoVLOXSEG6EI8_V_MF2_M1,
          4809 => Opcode::PseudoVLOXSEG6EI8_V_MF2_M1_MASK,
          4810 => Opcode::PseudoVLOXSEG6EI8_V_MF2_MF2,
          4811 => Opcode::PseudoVLOXSEG6EI8_V_MF2_MF2_MASK,
          4812 => Opcode::PseudoVLOXSEG6EI8_V_MF4_M1,
          4813 => Opcode::PseudoVLOXSEG6EI8_V_MF4_M1_MASK,
          4814 => Opcode::PseudoVLOXSEG6EI8_V_MF4_MF2,
          4815 => Opcode::PseudoVLOXSEG6EI8_V_MF4_MF2_MASK,
          4816 => Opcode::PseudoVLOXSEG6EI8_V_MF4_MF4,
          4817 => Opcode::PseudoVLOXSEG6EI8_V_MF4_MF4_MASK,
          4818 => Opcode::PseudoVLOXSEG6EI8_V_MF8_M1,
          4819 => Opcode::PseudoVLOXSEG6EI8_V_MF8_M1_MASK,
          4820 => Opcode::PseudoVLOXSEG6EI8_V_MF8_MF2,
          4821 => Opcode::PseudoVLOXSEG6EI8_V_MF8_MF2_MASK,
          4822 => Opcode::PseudoVLOXSEG6EI8_V_MF8_MF4,
          4823 => Opcode::PseudoVLOXSEG6EI8_V_MF8_MF4_MASK,
          4824 => Opcode::PseudoVLOXSEG6EI8_V_MF8_MF8,
          4825 => Opcode::PseudoVLOXSEG6EI8_V_MF8_MF8_MASK,
          4826 => Opcode::PseudoVLOXSEG7EI16_V_M1_M1,
          4827 => Opcode::PseudoVLOXSEG7EI16_V_M1_M1_MASK,
          4828 => Opcode::PseudoVLOXSEG7EI16_V_M1_MF2,
          4829 => Opcode::PseudoVLOXSEG7EI16_V_M1_MF2_MASK,
          4830 => Opcode::PseudoVLOXSEG7EI16_V_M2_M1,
          4831 => Opcode::PseudoVLOXSEG7EI16_V_M2_M1_MASK,
          4832 => Opcode::PseudoVLOXSEG7EI16_V_MF2_M1,
          4833 => Opcode::PseudoVLOXSEG7EI16_V_MF2_M1_MASK,
          4834 => Opcode::PseudoVLOXSEG7EI16_V_MF2_MF2,
          4835 => Opcode::PseudoVLOXSEG7EI16_V_MF2_MF2_MASK,
          4836 => Opcode::PseudoVLOXSEG7EI16_V_MF2_MF4,
          4837 => Opcode::PseudoVLOXSEG7EI16_V_MF2_MF4_MASK,
          4838 => Opcode::PseudoVLOXSEG7EI16_V_MF4_M1,
          4839 => Opcode::PseudoVLOXSEG7EI16_V_MF4_M1_MASK,
          4840 => Opcode::PseudoVLOXSEG7EI16_V_MF4_MF2,
          4841 => Opcode::PseudoVLOXSEG7EI16_V_MF4_MF2_MASK,
          4842 => Opcode::PseudoVLOXSEG7EI16_V_MF4_MF4,
          4843 => Opcode::PseudoVLOXSEG7EI16_V_MF4_MF4_MASK,
          4844 => Opcode::PseudoVLOXSEG7EI16_V_MF4_MF8,
          4845 => Opcode::PseudoVLOXSEG7EI16_V_MF4_MF8_MASK,
          4846 => Opcode::PseudoVLOXSEG7EI32_V_M1_M1,
          4847 => Opcode::PseudoVLOXSEG7EI32_V_M1_M1_MASK,
          4848 => Opcode::PseudoVLOXSEG7EI32_V_M1_MF2,
          4849 => Opcode::PseudoVLOXSEG7EI32_V_M1_MF2_MASK,
          4850 => Opcode::PseudoVLOXSEG7EI32_V_M1_MF4,
          4851 => Opcode::PseudoVLOXSEG7EI32_V_M1_MF4_MASK,
          4852 => Opcode::PseudoVLOXSEG7EI32_V_M2_M1,
          4853 => Opcode::PseudoVLOXSEG7EI32_V_M2_M1_MASK,
          4854 => Opcode::PseudoVLOXSEG7EI32_V_M2_MF2,
          4855 => Opcode::PseudoVLOXSEG7EI32_V_M2_MF2_MASK,
          4856 => Opcode::PseudoVLOXSEG7EI32_V_M4_M1,
          4857 => Opcode::PseudoVLOXSEG7EI32_V_M4_M1_MASK,
          4858 => Opcode::PseudoVLOXSEG7EI32_V_MF2_M1,
          4859 => Opcode::PseudoVLOXSEG7EI32_V_MF2_M1_MASK,
          4860 => Opcode::PseudoVLOXSEG7EI32_V_MF2_MF2,
          4861 => Opcode::PseudoVLOXSEG7EI32_V_MF2_MF2_MASK,
          4862 => Opcode::PseudoVLOXSEG7EI32_V_MF2_MF4,
          4863 => Opcode::PseudoVLOXSEG7EI32_V_MF2_MF4_MASK,
          4864 => Opcode::PseudoVLOXSEG7EI32_V_MF2_MF8,
          4865 => Opcode::PseudoVLOXSEG7EI32_V_MF2_MF8_MASK,
          4866 => Opcode::PseudoVLOXSEG7EI64_V_M1_M1,
          4867 => Opcode::PseudoVLOXSEG7EI64_V_M1_M1_MASK,
          4868 => Opcode::PseudoVLOXSEG7EI64_V_M1_MF2,
          4869 => Opcode::PseudoVLOXSEG7EI64_V_M1_MF2_MASK,
          4870 => Opcode::PseudoVLOXSEG7EI64_V_M1_MF4,
          4871 => Opcode::PseudoVLOXSEG7EI64_V_M1_MF4_MASK,
          4872 => Opcode::PseudoVLOXSEG7EI64_V_M1_MF8,
          4873 => Opcode::PseudoVLOXSEG7EI64_V_M1_MF8_MASK,
          4874 => Opcode::PseudoVLOXSEG7EI64_V_M2_M1,
          4875 => Opcode::PseudoVLOXSEG7EI64_V_M2_M1_MASK,
          4876 => Opcode::PseudoVLOXSEG7EI64_V_M2_MF2,
          4877 => Opcode::PseudoVLOXSEG7EI64_V_M2_MF2_MASK,
          4878 => Opcode::PseudoVLOXSEG7EI64_V_M2_MF4,
          4879 => Opcode::PseudoVLOXSEG7EI64_V_M2_MF4_MASK,
          4880 => Opcode::PseudoVLOXSEG7EI64_V_M4_M1,
          4881 => Opcode::PseudoVLOXSEG7EI64_V_M4_M1_MASK,
          4882 => Opcode::PseudoVLOXSEG7EI64_V_M4_MF2,
          4883 => Opcode::PseudoVLOXSEG7EI64_V_M4_MF2_MASK,
          4884 => Opcode::PseudoVLOXSEG7EI64_V_M8_M1,
          4885 => Opcode::PseudoVLOXSEG7EI64_V_M8_M1_MASK,
          4886 => Opcode::PseudoVLOXSEG7EI8_V_M1_M1,
          4887 => Opcode::PseudoVLOXSEG7EI8_V_M1_M1_MASK,
          4888 => Opcode::PseudoVLOXSEG7EI8_V_MF2_M1,
          4889 => Opcode::PseudoVLOXSEG7EI8_V_MF2_M1_MASK,
          4890 => Opcode::PseudoVLOXSEG7EI8_V_MF2_MF2,
          4891 => Opcode::PseudoVLOXSEG7EI8_V_MF2_MF2_MASK,
          4892 => Opcode::PseudoVLOXSEG7EI8_V_MF4_M1,
          4893 => Opcode::PseudoVLOXSEG7EI8_V_MF4_M1_MASK,
          4894 => Opcode::PseudoVLOXSEG7EI8_V_MF4_MF2,
          4895 => Opcode::PseudoVLOXSEG7EI8_V_MF4_MF2_MASK,
          4896 => Opcode::PseudoVLOXSEG7EI8_V_MF4_MF4,
          4897 => Opcode::PseudoVLOXSEG7EI8_V_MF4_MF4_MASK,
          4898 => Opcode::PseudoVLOXSEG7EI8_V_MF8_M1,
          4899 => Opcode::PseudoVLOXSEG7EI8_V_MF8_M1_MASK,
          4900 => Opcode::PseudoVLOXSEG7EI8_V_MF8_MF2,
          4901 => Opcode::PseudoVLOXSEG7EI8_V_MF8_MF2_MASK,
          4902 => Opcode::PseudoVLOXSEG7EI8_V_MF8_MF4,
          4903 => Opcode::PseudoVLOXSEG7EI8_V_MF8_MF4_MASK,
          4904 => Opcode::PseudoVLOXSEG7EI8_V_MF8_MF8,
          4905 => Opcode::PseudoVLOXSEG7EI8_V_MF8_MF8_MASK,
          4906 => Opcode::PseudoVLOXSEG8EI16_V_M1_M1,
          4907 => Opcode::PseudoVLOXSEG8EI16_V_M1_M1_MASK,
          4908 => Opcode::PseudoVLOXSEG8EI16_V_M1_MF2,
          4909 => Opcode::PseudoVLOXSEG8EI16_V_M1_MF2_MASK,
          4910 => Opcode::PseudoVLOXSEG8EI16_V_M2_M1,
          4911 => Opcode::PseudoVLOXSEG8EI16_V_M2_M1_MASK,
          4912 => Opcode::PseudoVLOXSEG8EI16_V_MF2_M1,
          4913 => Opcode::PseudoVLOXSEG8EI16_V_MF2_M1_MASK,
          4914 => Opcode::PseudoVLOXSEG8EI16_V_MF2_MF2,
          4915 => Opcode::PseudoVLOXSEG8EI16_V_MF2_MF2_MASK,
          4916 => Opcode::PseudoVLOXSEG8EI16_V_MF2_MF4,
          4917 => Opcode::PseudoVLOXSEG8EI16_V_MF2_MF4_MASK,
          4918 => Opcode::PseudoVLOXSEG8EI16_V_MF4_M1,
          4919 => Opcode::PseudoVLOXSEG8EI16_V_MF4_M1_MASK,
          4920 => Opcode::PseudoVLOXSEG8EI16_V_MF4_MF2,
          4921 => Opcode::PseudoVLOXSEG8EI16_V_MF4_MF2_MASK,
          4922 => Opcode::PseudoVLOXSEG8EI16_V_MF4_MF4,
          4923 => Opcode::PseudoVLOXSEG8EI16_V_MF4_MF4_MASK,
          4924 => Opcode::PseudoVLOXSEG8EI16_V_MF4_MF8,
          4925 => Opcode::PseudoVLOXSEG8EI16_V_MF4_MF8_MASK,
          4926 => Opcode::PseudoVLOXSEG8EI32_V_M1_M1,
          4927 => Opcode::PseudoVLOXSEG8EI32_V_M1_M1_MASK,
          4928 => Opcode::PseudoVLOXSEG8EI32_V_M1_MF2,
          4929 => Opcode::PseudoVLOXSEG8EI32_V_M1_MF2_MASK,
          4930 => Opcode::PseudoVLOXSEG8EI32_V_M1_MF4,
          4931 => Opcode::PseudoVLOXSEG8EI32_V_M1_MF4_MASK,
          4932 => Opcode::PseudoVLOXSEG8EI32_V_M2_M1,
          4933 => Opcode::PseudoVLOXSEG8EI32_V_M2_M1_MASK,
          4934 => Opcode::PseudoVLOXSEG8EI32_V_M2_MF2,
          4935 => Opcode::PseudoVLOXSEG8EI32_V_M2_MF2_MASK,
          4936 => Opcode::PseudoVLOXSEG8EI32_V_M4_M1,
          4937 => Opcode::PseudoVLOXSEG8EI32_V_M4_M1_MASK,
          4938 => Opcode::PseudoVLOXSEG8EI32_V_MF2_M1,
          4939 => Opcode::PseudoVLOXSEG8EI32_V_MF2_M1_MASK,
          4940 => Opcode::PseudoVLOXSEG8EI32_V_MF2_MF2,
          4941 => Opcode::PseudoVLOXSEG8EI32_V_MF2_MF2_MASK,
          4942 => Opcode::PseudoVLOXSEG8EI32_V_MF2_MF4,
          4943 => Opcode::PseudoVLOXSEG8EI32_V_MF2_MF4_MASK,
          4944 => Opcode::PseudoVLOXSEG8EI32_V_MF2_MF8,
          4945 => Opcode::PseudoVLOXSEG8EI32_V_MF2_MF8_MASK,
          4946 => Opcode::PseudoVLOXSEG8EI64_V_M1_M1,
          4947 => Opcode::PseudoVLOXSEG8EI64_V_M1_M1_MASK,
          4948 => Opcode::PseudoVLOXSEG8EI64_V_M1_MF2,
          4949 => Opcode::PseudoVLOXSEG8EI64_V_M1_MF2_MASK,
          4950 => Opcode::PseudoVLOXSEG8EI64_V_M1_MF4,
          4951 => Opcode::PseudoVLOXSEG8EI64_V_M1_MF4_MASK,
          4952 => Opcode::PseudoVLOXSEG8EI64_V_M1_MF8,
          4953 => Opcode::PseudoVLOXSEG8EI64_V_M1_MF8_MASK,
          4954 => Opcode::PseudoVLOXSEG8EI64_V_M2_M1,
          4955 => Opcode::PseudoVLOXSEG8EI64_V_M2_M1_MASK,
          4956 => Opcode::PseudoVLOXSEG8EI64_V_M2_MF2,
          4957 => Opcode::PseudoVLOXSEG8EI64_V_M2_MF2_MASK,
          4958 => Opcode::PseudoVLOXSEG8EI64_V_M2_MF4,
          4959 => Opcode::PseudoVLOXSEG8EI64_V_M2_MF4_MASK,
          4960 => Opcode::PseudoVLOXSEG8EI64_V_M4_M1,
          4961 => Opcode::PseudoVLOXSEG8EI64_V_M4_M1_MASK,
          4962 => Opcode::PseudoVLOXSEG8EI64_V_M4_MF2,
          4963 => Opcode::PseudoVLOXSEG8EI64_V_M4_MF2_MASK,
          4964 => Opcode::PseudoVLOXSEG8EI64_V_M8_M1,
          4965 => Opcode::PseudoVLOXSEG8EI64_V_M8_M1_MASK,
          4966 => Opcode::PseudoVLOXSEG8EI8_V_M1_M1,
          4967 => Opcode::PseudoVLOXSEG8EI8_V_M1_M1_MASK,
          4968 => Opcode::PseudoVLOXSEG8EI8_V_MF2_M1,
          4969 => Opcode::PseudoVLOXSEG8EI8_V_MF2_M1_MASK,
          4970 => Opcode::PseudoVLOXSEG8EI8_V_MF2_MF2,
          4971 => Opcode::PseudoVLOXSEG8EI8_V_MF2_MF2_MASK,
          4972 => Opcode::PseudoVLOXSEG8EI8_V_MF4_M1,
          4973 => Opcode::PseudoVLOXSEG8EI8_V_MF4_M1_MASK,
          4974 => Opcode::PseudoVLOXSEG8EI8_V_MF4_MF2,
          4975 => Opcode::PseudoVLOXSEG8EI8_V_MF4_MF2_MASK,
          4976 => Opcode::PseudoVLOXSEG8EI8_V_MF4_MF4,
          4977 => Opcode::PseudoVLOXSEG8EI8_V_MF4_MF4_MASK,
          4978 => Opcode::PseudoVLOXSEG8EI8_V_MF8_M1,
          4979 => Opcode::PseudoVLOXSEG8EI8_V_MF8_M1_MASK,
          4980 => Opcode::PseudoVLOXSEG8EI8_V_MF8_MF2,
          4981 => Opcode::PseudoVLOXSEG8EI8_V_MF8_MF2_MASK,
          4982 => Opcode::PseudoVLOXSEG8EI8_V_MF8_MF4,
          4983 => Opcode::PseudoVLOXSEG8EI8_V_MF8_MF4_MASK,
          4984 => Opcode::PseudoVLOXSEG8EI8_V_MF8_MF8,
          4985 => Opcode::PseudoVLOXSEG8EI8_V_MF8_MF8_MASK,
          4986 => Opcode::PseudoVLSE16_V_M1,
          4987 => Opcode::PseudoVLSE16_V_M1_MASK,
          4988 => Opcode::PseudoVLSE16_V_M2,
          4989 => Opcode::PseudoVLSE16_V_M2_MASK,
          4990 => Opcode::PseudoVLSE16_V_M4,
          4991 => Opcode::PseudoVLSE16_V_M4_MASK,
          4992 => Opcode::PseudoVLSE16_V_M8,
          4993 => Opcode::PseudoVLSE16_V_M8_MASK,
          4994 => Opcode::PseudoVLSE16_V_MF2,
          4995 => Opcode::PseudoVLSE16_V_MF2_MASK,
          4996 => Opcode::PseudoVLSE16_V_MF4,
          4997 => Opcode::PseudoVLSE16_V_MF4_MASK,
          4998 => Opcode::PseudoVLSE32_V_M1,
          4999 => Opcode::PseudoVLSE32_V_M1_MASK,
          5000 => Opcode::PseudoVLSE32_V_M2,
          5001 => Opcode::PseudoVLSE32_V_M2_MASK,
          5002 => Opcode::PseudoVLSE32_V_M4,
          5003 => Opcode::PseudoVLSE32_V_M4_MASK,
          5004 => Opcode::PseudoVLSE32_V_M8,
          5005 => Opcode::PseudoVLSE32_V_M8_MASK,
          5006 => Opcode::PseudoVLSE32_V_MF2,
          5007 => Opcode::PseudoVLSE32_V_MF2_MASK,
          5008 => Opcode::PseudoVLSE64_V_M1,
          5009 => Opcode::PseudoVLSE64_V_M1_MASK,
          5010 => Opcode::PseudoVLSE64_V_M2,
          5011 => Opcode::PseudoVLSE64_V_M2_MASK,
          5012 => Opcode::PseudoVLSE64_V_M4,
          5013 => Opcode::PseudoVLSE64_V_M4_MASK,
          5014 => Opcode::PseudoVLSE64_V_M8,
          5015 => Opcode::PseudoVLSE64_V_M8_MASK,
          5016 => Opcode::PseudoVLSE8_V_M1,
          5017 => Opcode::PseudoVLSE8_V_M1_MASK,
          5018 => Opcode::PseudoVLSE8_V_M2,
          5019 => Opcode::PseudoVLSE8_V_M2_MASK,
          5020 => Opcode::PseudoVLSE8_V_M4,
          5021 => Opcode::PseudoVLSE8_V_M4_MASK,
          5022 => Opcode::PseudoVLSE8_V_M8,
          5023 => Opcode::PseudoVLSE8_V_M8_MASK,
          5024 => Opcode::PseudoVLSE8_V_MF2,
          5025 => Opcode::PseudoVLSE8_V_MF2_MASK,
          5026 => Opcode::PseudoVLSE8_V_MF4,
          5027 => Opcode::PseudoVLSE8_V_MF4_MASK,
          5028 => Opcode::PseudoVLSE8_V_MF8,
          5029 => Opcode::PseudoVLSE8_V_MF8_MASK,
          5030 => Opcode::PseudoVLSEG2E16FF_V_M1,
          5031 => Opcode::PseudoVLSEG2E16FF_V_M1_MASK,
          5032 => Opcode::PseudoVLSEG2E16FF_V_M2,
          5033 => Opcode::PseudoVLSEG2E16FF_V_M2_MASK,
          5034 => Opcode::PseudoVLSEG2E16FF_V_M4,
          5035 => Opcode::PseudoVLSEG2E16FF_V_M4_MASK,
          5036 => Opcode::PseudoVLSEG2E16FF_V_MF2,
          5037 => Opcode::PseudoVLSEG2E16FF_V_MF2_MASK,
          5038 => Opcode::PseudoVLSEG2E16FF_V_MF4,
          5039 => Opcode::PseudoVLSEG2E16FF_V_MF4_MASK,
          5040 => Opcode::PseudoVLSEG2E16_V_M1,
          5041 => Opcode::PseudoVLSEG2E16_V_M1_MASK,
          5042 => Opcode::PseudoVLSEG2E16_V_M2,
          5043 => Opcode::PseudoVLSEG2E16_V_M2_MASK,
          5044 => Opcode::PseudoVLSEG2E16_V_M4,
          5045 => Opcode::PseudoVLSEG2E16_V_M4_MASK,
          5046 => Opcode::PseudoVLSEG2E16_V_MF2,
          5047 => Opcode::PseudoVLSEG2E16_V_MF2_MASK,
          5048 => Opcode::PseudoVLSEG2E16_V_MF4,
          5049 => Opcode::PseudoVLSEG2E16_V_MF4_MASK,
          5050 => Opcode::PseudoVLSEG2E32FF_V_M1,
          5051 => Opcode::PseudoVLSEG2E32FF_V_M1_MASK,
          5052 => Opcode::PseudoVLSEG2E32FF_V_M2,
          5053 => Opcode::PseudoVLSEG2E32FF_V_M2_MASK,
          5054 => Opcode::PseudoVLSEG2E32FF_V_M4,
          5055 => Opcode::PseudoVLSEG2E32FF_V_M4_MASK,
          5056 => Opcode::PseudoVLSEG2E32FF_V_MF2,
          5057 => Opcode::PseudoVLSEG2E32FF_V_MF2_MASK,
          5058 => Opcode::PseudoVLSEG2E32_V_M1,
          5059 => Opcode::PseudoVLSEG2E32_V_M1_MASK,
          5060 => Opcode::PseudoVLSEG2E32_V_M2,
          5061 => Opcode::PseudoVLSEG2E32_V_M2_MASK,
          5062 => Opcode::PseudoVLSEG2E32_V_M4,
          5063 => Opcode::PseudoVLSEG2E32_V_M4_MASK,
          5064 => Opcode::PseudoVLSEG2E32_V_MF2,
          5065 => Opcode::PseudoVLSEG2E32_V_MF2_MASK,
          5066 => Opcode::PseudoVLSEG2E64FF_V_M1,
          5067 => Opcode::PseudoVLSEG2E64FF_V_M1_MASK,
          5068 => Opcode::PseudoVLSEG2E64FF_V_M2,
          5069 => Opcode::PseudoVLSEG2E64FF_V_M2_MASK,
          5070 => Opcode::PseudoVLSEG2E64FF_V_M4,
          5071 => Opcode::PseudoVLSEG2E64FF_V_M4_MASK,
          5072 => Opcode::PseudoVLSEG2E64_V_M1,
          5073 => Opcode::PseudoVLSEG2E64_V_M1_MASK,
          5074 => Opcode::PseudoVLSEG2E64_V_M2,
          5075 => Opcode::PseudoVLSEG2E64_V_M2_MASK,
          5076 => Opcode::PseudoVLSEG2E64_V_M4,
          5077 => Opcode::PseudoVLSEG2E64_V_M4_MASK,
          5078 => Opcode::PseudoVLSEG2E8FF_V_M1,
          5079 => Opcode::PseudoVLSEG2E8FF_V_M1_MASK,
          5080 => Opcode::PseudoVLSEG2E8FF_V_M2,
          5081 => Opcode::PseudoVLSEG2E8FF_V_M2_MASK,
          5082 => Opcode::PseudoVLSEG2E8FF_V_M4,
          5083 => Opcode::PseudoVLSEG2E8FF_V_M4_MASK,
          5084 => Opcode::PseudoVLSEG2E8FF_V_MF2,
          5085 => Opcode::PseudoVLSEG2E8FF_V_MF2_MASK,
          5086 => Opcode::PseudoVLSEG2E8FF_V_MF4,
          5087 => Opcode::PseudoVLSEG2E8FF_V_MF4_MASK,
          5088 => Opcode::PseudoVLSEG2E8FF_V_MF8,
          5089 => Opcode::PseudoVLSEG2E8FF_V_MF8_MASK,
          5090 => Opcode::PseudoVLSEG2E8_V_M1,
          5091 => Opcode::PseudoVLSEG2E8_V_M1_MASK,
          5092 => Opcode::PseudoVLSEG2E8_V_M2,
          5093 => Opcode::PseudoVLSEG2E8_V_M2_MASK,
          5094 => Opcode::PseudoVLSEG2E8_V_M4,
          5095 => Opcode::PseudoVLSEG2E8_V_M4_MASK,
          5096 => Opcode::PseudoVLSEG2E8_V_MF2,
          5097 => Opcode::PseudoVLSEG2E8_V_MF2_MASK,
          5098 => Opcode::PseudoVLSEG2E8_V_MF4,
          5099 => Opcode::PseudoVLSEG2E8_V_MF4_MASK,
          5100 => Opcode::PseudoVLSEG2E8_V_MF8,
          5101 => Opcode::PseudoVLSEG2E8_V_MF8_MASK,
          5102 => Opcode::PseudoVLSEG3E16FF_V_M1,
          5103 => Opcode::PseudoVLSEG3E16FF_V_M1_MASK,
          5104 => Opcode::PseudoVLSEG3E16FF_V_M2,
          5105 => Opcode::PseudoVLSEG3E16FF_V_M2_MASK,
          5106 => Opcode::PseudoVLSEG3E16FF_V_MF2,
          5107 => Opcode::PseudoVLSEG3E16FF_V_MF2_MASK,
          5108 => Opcode::PseudoVLSEG3E16FF_V_MF4,
          5109 => Opcode::PseudoVLSEG3E16FF_V_MF4_MASK,
          5110 => Opcode::PseudoVLSEG3E16_V_M1,
          5111 => Opcode::PseudoVLSEG3E16_V_M1_MASK,
          5112 => Opcode::PseudoVLSEG3E16_V_M2,
          5113 => Opcode::PseudoVLSEG3E16_V_M2_MASK,
          5114 => Opcode::PseudoVLSEG3E16_V_MF2,
          5115 => Opcode::PseudoVLSEG3E16_V_MF2_MASK,
          5116 => Opcode::PseudoVLSEG3E16_V_MF4,
          5117 => Opcode::PseudoVLSEG3E16_V_MF4_MASK,
          5118 => Opcode::PseudoVLSEG3E32FF_V_M1,
          5119 => Opcode::PseudoVLSEG3E32FF_V_M1_MASK,
          5120 => Opcode::PseudoVLSEG3E32FF_V_M2,
          5121 => Opcode::PseudoVLSEG3E32FF_V_M2_MASK,
          5122 => Opcode::PseudoVLSEG3E32FF_V_MF2,
          5123 => Opcode::PseudoVLSEG3E32FF_V_MF2_MASK,
          5124 => Opcode::PseudoVLSEG3E32_V_M1,
          5125 => Opcode::PseudoVLSEG3E32_V_M1_MASK,
          5126 => Opcode::PseudoVLSEG3E32_V_M2,
          5127 => Opcode::PseudoVLSEG3E32_V_M2_MASK,
          5128 => Opcode::PseudoVLSEG3E32_V_MF2,
          5129 => Opcode::PseudoVLSEG3E32_V_MF2_MASK,
          5130 => Opcode::PseudoVLSEG3E64FF_V_M1,
          5131 => Opcode::PseudoVLSEG3E64FF_V_M1_MASK,
          5132 => Opcode::PseudoVLSEG3E64FF_V_M2,
          5133 => Opcode::PseudoVLSEG3E64FF_V_M2_MASK,
          5134 => Opcode::PseudoVLSEG3E64_V_M1,
          5135 => Opcode::PseudoVLSEG3E64_V_M1_MASK,
          5136 => Opcode::PseudoVLSEG3E64_V_M2,
          5137 => Opcode::PseudoVLSEG3E64_V_M2_MASK,
          5138 => Opcode::PseudoVLSEG3E8FF_V_M1,
          5139 => Opcode::PseudoVLSEG3E8FF_V_M1_MASK,
          5140 => Opcode::PseudoVLSEG3E8FF_V_M2,
          5141 => Opcode::PseudoVLSEG3E8FF_V_M2_MASK,
          5142 => Opcode::PseudoVLSEG3E8FF_V_MF2,
          5143 => Opcode::PseudoVLSEG3E8FF_V_MF2_MASK,
          5144 => Opcode::PseudoVLSEG3E8FF_V_MF4,
          5145 => Opcode::PseudoVLSEG3E8FF_V_MF4_MASK,
          5146 => Opcode::PseudoVLSEG3E8FF_V_MF8,
          5147 => Opcode::PseudoVLSEG3E8FF_V_MF8_MASK,
          5148 => Opcode::PseudoVLSEG3E8_V_M1,
          5149 => Opcode::PseudoVLSEG3E8_V_M1_MASK,
          5150 => Opcode::PseudoVLSEG3E8_V_M2,
          5151 => Opcode::PseudoVLSEG3E8_V_M2_MASK,
          5152 => Opcode::PseudoVLSEG3E8_V_MF2,
          5153 => Opcode::PseudoVLSEG3E8_V_MF2_MASK,
          5154 => Opcode::PseudoVLSEG3E8_V_MF4,
          5155 => Opcode::PseudoVLSEG3E8_V_MF4_MASK,
          5156 => Opcode::PseudoVLSEG3E8_V_MF8,
          5157 => Opcode::PseudoVLSEG3E8_V_MF8_MASK,
          5158 => Opcode::PseudoVLSEG4E16FF_V_M1,
          5159 => Opcode::PseudoVLSEG4E16FF_V_M1_MASK,
          5160 => Opcode::PseudoVLSEG4E16FF_V_M2,
          5161 => Opcode::PseudoVLSEG4E16FF_V_M2_MASK,
          5162 => Opcode::PseudoVLSEG4E16FF_V_MF2,
          5163 => Opcode::PseudoVLSEG4E16FF_V_MF2_MASK,
          5164 => Opcode::PseudoVLSEG4E16FF_V_MF4,
          5165 => Opcode::PseudoVLSEG4E16FF_V_MF4_MASK,
          5166 => Opcode::PseudoVLSEG4E16_V_M1,
          5167 => Opcode::PseudoVLSEG4E16_V_M1_MASK,
          5168 => Opcode::PseudoVLSEG4E16_V_M2,
          5169 => Opcode::PseudoVLSEG4E16_V_M2_MASK,
          5170 => Opcode::PseudoVLSEG4E16_V_MF2,
          5171 => Opcode::PseudoVLSEG4E16_V_MF2_MASK,
          5172 => Opcode::PseudoVLSEG4E16_V_MF4,
          5173 => Opcode::PseudoVLSEG4E16_V_MF4_MASK,
          5174 => Opcode::PseudoVLSEG4E32FF_V_M1,
          5175 => Opcode::PseudoVLSEG4E32FF_V_M1_MASK,
          5176 => Opcode::PseudoVLSEG4E32FF_V_M2,
          5177 => Opcode::PseudoVLSEG4E32FF_V_M2_MASK,
          5178 => Opcode::PseudoVLSEG4E32FF_V_MF2,
          5179 => Opcode::PseudoVLSEG4E32FF_V_MF2_MASK,
          5180 => Opcode::PseudoVLSEG4E32_V_M1,
          5181 => Opcode::PseudoVLSEG4E32_V_M1_MASK,
          5182 => Opcode::PseudoVLSEG4E32_V_M2,
          5183 => Opcode::PseudoVLSEG4E32_V_M2_MASK,
          5184 => Opcode::PseudoVLSEG4E32_V_MF2,
          5185 => Opcode::PseudoVLSEG4E32_V_MF2_MASK,
          5186 => Opcode::PseudoVLSEG4E64FF_V_M1,
          5187 => Opcode::PseudoVLSEG4E64FF_V_M1_MASK,
          5188 => Opcode::PseudoVLSEG4E64FF_V_M2,
          5189 => Opcode::PseudoVLSEG4E64FF_V_M2_MASK,
          5190 => Opcode::PseudoVLSEG4E64_V_M1,
          5191 => Opcode::PseudoVLSEG4E64_V_M1_MASK,
          5192 => Opcode::PseudoVLSEG4E64_V_M2,
          5193 => Opcode::PseudoVLSEG4E64_V_M2_MASK,
          5194 => Opcode::PseudoVLSEG4E8FF_V_M1,
          5195 => Opcode::PseudoVLSEG4E8FF_V_M1_MASK,
          5196 => Opcode::PseudoVLSEG4E8FF_V_M2,
          5197 => Opcode::PseudoVLSEG4E8FF_V_M2_MASK,
          5198 => Opcode::PseudoVLSEG4E8FF_V_MF2,
          5199 => Opcode::PseudoVLSEG4E8FF_V_MF2_MASK,
          5200 => Opcode::PseudoVLSEG4E8FF_V_MF4,
          5201 => Opcode::PseudoVLSEG4E8FF_V_MF4_MASK,
          5202 => Opcode::PseudoVLSEG4E8FF_V_MF8,
          5203 => Opcode::PseudoVLSEG4E8FF_V_MF8_MASK,
          5204 => Opcode::PseudoVLSEG4E8_V_M1,
          5205 => Opcode::PseudoVLSEG4E8_V_M1_MASK,
          5206 => Opcode::PseudoVLSEG4E8_V_M2,
          5207 => Opcode::PseudoVLSEG4E8_V_M2_MASK,
          5208 => Opcode::PseudoVLSEG4E8_V_MF2,
          5209 => Opcode::PseudoVLSEG4E8_V_MF2_MASK,
          5210 => Opcode::PseudoVLSEG4E8_V_MF4,
          5211 => Opcode::PseudoVLSEG4E8_V_MF4_MASK,
          5212 => Opcode::PseudoVLSEG4E8_V_MF8,
          5213 => Opcode::PseudoVLSEG4E8_V_MF8_MASK,
          5214 => Opcode::PseudoVLSEG5E16FF_V_M1,
          5215 => Opcode::PseudoVLSEG5E16FF_V_M1_MASK,
          5216 => Opcode::PseudoVLSEG5E16FF_V_MF2,
          5217 => Opcode::PseudoVLSEG5E16FF_V_MF2_MASK,
          5218 => Opcode::PseudoVLSEG5E16FF_V_MF4,
          5219 => Opcode::PseudoVLSEG5E16FF_V_MF4_MASK,
          5220 => Opcode::PseudoVLSEG5E16_V_M1,
          5221 => Opcode::PseudoVLSEG5E16_V_M1_MASK,
          5222 => Opcode::PseudoVLSEG5E16_V_MF2,
          5223 => Opcode::PseudoVLSEG5E16_V_MF2_MASK,
          5224 => Opcode::PseudoVLSEG5E16_V_MF4,
          5225 => Opcode::PseudoVLSEG5E16_V_MF4_MASK,
          5226 => Opcode::PseudoVLSEG5E32FF_V_M1,
          5227 => Opcode::PseudoVLSEG5E32FF_V_M1_MASK,
          5228 => Opcode::PseudoVLSEG5E32FF_V_MF2,
          5229 => Opcode::PseudoVLSEG5E32FF_V_MF2_MASK,
          5230 => Opcode::PseudoVLSEG5E32_V_M1,
          5231 => Opcode::PseudoVLSEG5E32_V_M1_MASK,
          5232 => Opcode::PseudoVLSEG5E32_V_MF2,
          5233 => Opcode::PseudoVLSEG5E32_V_MF2_MASK,
          5234 => Opcode::PseudoVLSEG5E64FF_V_M1,
          5235 => Opcode::PseudoVLSEG5E64FF_V_M1_MASK,
          5236 => Opcode::PseudoVLSEG5E64_V_M1,
          5237 => Opcode::PseudoVLSEG5E64_V_M1_MASK,
          5238 => Opcode::PseudoVLSEG5E8FF_V_M1,
          5239 => Opcode::PseudoVLSEG5E8FF_V_M1_MASK,
          5240 => Opcode::PseudoVLSEG5E8FF_V_MF2,
          5241 => Opcode::PseudoVLSEG5E8FF_V_MF2_MASK,
          5242 => Opcode::PseudoVLSEG5E8FF_V_MF4,
          5243 => Opcode::PseudoVLSEG5E8FF_V_MF4_MASK,
          5244 => Opcode::PseudoVLSEG5E8FF_V_MF8,
          5245 => Opcode::PseudoVLSEG5E8FF_V_MF8_MASK,
          5246 => Opcode::PseudoVLSEG5E8_V_M1,
          5247 => Opcode::PseudoVLSEG5E8_V_M1_MASK,
          5248 => Opcode::PseudoVLSEG5E8_V_MF2,
          5249 => Opcode::PseudoVLSEG5E8_V_MF2_MASK,
          5250 => Opcode::PseudoVLSEG5E8_V_MF4,
          5251 => Opcode::PseudoVLSEG5E8_V_MF4_MASK,
          5252 => Opcode::PseudoVLSEG5E8_V_MF8,
          5253 => Opcode::PseudoVLSEG5E8_V_MF8_MASK,
          5254 => Opcode::PseudoVLSEG6E16FF_V_M1,
          5255 => Opcode::PseudoVLSEG6E16FF_V_M1_MASK,
          5256 => Opcode::PseudoVLSEG6E16FF_V_MF2,
          5257 => Opcode::PseudoVLSEG6E16FF_V_MF2_MASK,
          5258 => Opcode::PseudoVLSEG6E16FF_V_MF4,
          5259 => Opcode::PseudoVLSEG6E16FF_V_MF4_MASK,
          5260 => Opcode::PseudoVLSEG6E16_V_M1,
          5261 => Opcode::PseudoVLSEG6E16_V_M1_MASK,
          5262 => Opcode::PseudoVLSEG6E16_V_MF2,
          5263 => Opcode::PseudoVLSEG6E16_V_MF2_MASK,
          5264 => Opcode::PseudoVLSEG6E16_V_MF4,
          5265 => Opcode::PseudoVLSEG6E16_V_MF4_MASK,
          5266 => Opcode::PseudoVLSEG6E32FF_V_M1,
          5267 => Opcode::PseudoVLSEG6E32FF_V_M1_MASK,
          5268 => Opcode::PseudoVLSEG6E32FF_V_MF2,
          5269 => Opcode::PseudoVLSEG6E32FF_V_MF2_MASK,
          5270 => Opcode::PseudoVLSEG6E32_V_M1,
          5271 => Opcode::PseudoVLSEG6E32_V_M1_MASK,
          5272 => Opcode::PseudoVLSEG6E32_V_MF2,
          5273 => Opcode::PseudoVLSEG6E32_V_MF2_MASK,
          5274 => Opcode::PseudoVLSEG6E64FF_V_M1,
          5275 => Opcode::PseudoVLSEG6E64FF_V_M1_MASK,
          5276 => Opcode::PseudoVLSEG6E64_V_M1,
          5277 => Opcode::PseudoVLSEG6E64_V_M1_MASK,
          5278 => Opcode::PseudoVLSEG6E8FF_V_M1,
          5279 => Opcode::PseudoVLSEG6E8FF_V_M1_MASK,
          5280 => Opcode::PseudoVLSEG6E8FF_V_MF2,
          5281 => Opcode::PseudoVLSEG6E8FF_V_MF2_MASK,
          5282 => Opcode::PseudoVLSEG6E8FF_V_MF4,
          5283 => Opcode::PseudoVLSEG6E8FF_V_MF4_MASK,
          5284 => Opcode::PseudoVLSEG6E8FF_V_MF8,
          5285 => Opcode::PseudoVLSEG6E8FF_V_MF8_MASK,
          5286 => Opcode::PseudoVLSEG6E8_V_M1,
          5287 => Opcode::PseudoVLSEG6E8_V_M1_MASK,
          5288 => Opcode::PseudoVLSEG6E8_V_MF2,
          5289 => Opcode::PseudoVLSEG6E8_V_MF2_MASK,
          5290 => Opcode::PseudoVLSEG6E8_V_MF4,
          5291 => Opcode::PseudoVLSEG6E8_V_MF4_MASK,
          5292 => Opcode::PseudoVLSEG6E8_V_MF8,
          5293 => Opcode::PseudoVLSEG6E8_V_MF8_MASK,
          5294 => Opcode::PseudoVLSEG7E16FF_V_M1,
          5295 => Opcode::PseudoVLSEG7E16FF_V_M1_MASK,
          5296 => Opcode::PseudoVLSEG7E16FF_V_MF2,
          5297 => Opcode::PseudoVLSEG7E16FF_V_MF2_MASK,
          5298 => Opcode::PseudoVLSEG7E16FF_V_MF4,
          5299 => Opcode::PseudoVLSEG7E16FF_V_MF4_MASK,
          5300 => Opcode::PseudoVLSEG7E16_V_M1,
          5301 => Opcode::PseudoVLSEG7E16_V_M1_MASK,
          5302 => Opcode::PseudoVLSEG7E16_V_MF2,
          5303 => Opcode::PseudoVLSEG7E16_V_MF2_MASK,
          5304 => Opcode::PseudoVLSEG7E16_V_MF4,
          5305 => Opcode::PseudoVLSEG7E16_V_MF4_MASK,
          5306 => Opcode::PseudoVLSEG7E32FF_V_M1,
          5307 => Opcode::PseudoVLSEG7E32FF_V_M1_MASK,
          5308 => Opcode::PseudoVLSEG7E32FF_V_MF2,
          5309 => Opcode::PseudoVLSEG7E32FF_V_MF2_MASK,
          5310 => Opcode::PseudoVLSEG7E32_V_M1,
          5311 => Opcode::PseudoVLSEG7E32_V_M1_MASK,
          5312 => Opcode::PseudoVLSEG7E32_V_MF2,
          5313 => Opcode::PseudoVLSEG7E32_V_MF2_MASK,
          5314 => Opcode::PseudoVLSEG7E64FF_V_M1,
          5315 => Opcode::PseudoVLSEG7E64FF_V_M1_MASK,
          5316 => Opcode::PseudoVLSEG7E64_V_M1,
          5317 => Opcode::PseudoVLSEG7E64_V_M1_MASK,
          5318 => Opcode::PseudoVLSEG7E8FF_V_M1,
          5319 => Opcode::PseudoVLSEG7E8FF_V_M1_MASK,
          5320 => Opcode::PseudoVLSEG7E8FF_V_MF2,
          5321 => Opcode::PseudoVLSEG7E8FF_V_MF2_MASK,
          5322 => Opcode::PseudoVLSEG7E8FF_V_MF4,
          5323 => Opcode::PseudoVLSEG7E8FF_V_MF4_MASK,
          5324 => Opcode::PseudoVLSEG7E8FF_V_MF8,
          5325 => Opcode::PseudoVLSEG7E8FF_V_MF8_MASK,
          5326 => Opcode::PseudoVLSEG7E8_V_M1,
          5327 => Opcode::PseudoVLSEG7E8_V_M1_MASK,
          5328 => Opcode::PseudoVLSEG7E8_V_MF2,
          5329 => Opcode::PseudoVLSEG7E8_V_MF2_MASK,
          5330 => Opcode::PseudoVLSEG7E8_V_MF4,
          5331 => Opcode::PseudoVLSEG7E8_V_MF4_MASK,
          5332 => Opcode::PseudoVLSEG7E8_V_MF8,
          5333 => Opcode::PseudoVLSEG7E8_V_MF8_MASK,
          5334 => Opcode::PseudoVLSEG8E16FF_V_M1,
          5335 => Opcode::PseudoVLSEG8E16FF_V_M1_MASK,
          5336 => Opcode::PseudoVLSEG8E16FF_V_MF2,
          5337 => Opcode::PseudoVLSEG8E16FF_V_MF2_MASK,
          5338 => Opcode::PseudoVLSEG8E16FF_V_MF4,
          5339 => Opcode::PseudoVLSEG8E16FF_V_MF4_MASK,
          5340 => Opcode::PseudoVLSEG8E16_V_M1,
          5341 => Opcode::PseudoVLSEG8E16_V_M1_MASK,
          5342 => Opcode::PseudoVLSEG8E16_V_MF2,
          5343 => Opcode::PseudoVLSEG8E16_V_MF2_MASK,
          5344 => Opcode::PseudoVLSEG8E16_V_MF4,
          5345 => Opcode::PseudoVLSEG8E16_V_MF4_MASK,
          5346 => Opcode::PseudoVLSEG8E32FF_V_M1,
          5347 => Opcode::PseudoVLSEG8E32FF_V_M1_MASK,
          5348 => Opcode::PseudoVLSEG8E32FF_V_MF2,
          5349 => Opcode::PseudoVLSEG8E32FF_V_MF2_MASK,
          5350 => Opcode::PseudoVLSEG8E32_V_M1,
          5351 => Opcode::PseudoVLSEG8E32_V_M1_MASK,
          5352 => Opcode::PseudoVLSEG8E32_V_MF2,
          5353 => Opcode::PseudoVLSEG8E32_V_MF2_MASK,
          5354 => Opcode::PseudoVLSEG8E64FF_V_M1,
          5355 => Opcode::PseudoVLSEG8E64FF_V_M1_MASK,
          5356 => Opcode::PseudoVLSEG8E64_V_M1,
          5357 => Opcode::PseudoVLSEG8E64_V_M1_MASK,
          5358 => Opcode::PseudoVLSEG8E8FF_V_M1,
          5359 => Opcode::PseudoVLSEG8E8FF_V_M1_MASK,
          5360 => Opcode::PseudoVLSEG8E8FF_V_MF2,
          5361 => Opcode::PseudoVLSEG8E8FF_V_MF2_MASK,
          5362 => Opcode::PseudoVLSEG8E8FF_V_MF4,
          5363 => Opcode::PseudoVLSEG8E8FF_V_MF4_MASK,
          5364 => Opcode::PseudoVLSEG8E8FF_V_MF8,
          5365 => Opcode::PseudoVLSEG8E8FF_V_MF8_MASK,
          5366 => Opcode::PseudoVLSEG8E8_V_M1,
          5367 => Opcode::PseudoVLSEG8E8_V_M1_MASK,
          5368 => Opcode::PseudoVLSEG8E8_V_MF2,
          5369 => Opcode::PseudoVLSEG8E8_V_MF2_MASK,
          5370 => Opcode::PseudoVLSEG8E8_V_MF4,
          5371 => Opcode::PseudoVLSEG8E8_V_MF4_MASK,
          5372 => Opcode::PseudoVLSEG8E8_V_MF8,
          5373 => Opcode::PseudoVLSEG8E8_V_MF8_MASK,
          5374 => Opcode::PseudoVLSSEG2E16_V_M1,
          5375 => Opcode::PseudoVLSSEG2E16_V_M1_MASK,
          5376 => Opcode::PseudoVLSSEG2E16_V_M2,
          5377 => Opcode::PseudoVLSSEG2E16_V_M2_MASK,
          5378 => Opcode::PseudoVLSSEG2E16_V_M4,
          5379 => Opcode::PseudoVLSSEG2E16_V_M4_MASK,
          5380 => Opcode::PseudoVLSSEG2E16_V_MF2,
          5381 => Opcode::PseudoVLSSEG2E16_V_MF2_MASK,
          5382 => Opcode::PseudoVLSSEG2E16_V_MF4,
          5383 => Opcode::PseudoVLSSEG2E16_V_MF4_MASK,
          5384 => Opcode::PseudoVLSSEG2E32_V_M1,
          5385 => Opcode::PseudoVLSSEG2E32_V_M1_MASK,
          5386 => Opcode::PseudoVLSSEG2E32_V_M2,
          5387 => Opcode::PseudoVLSSEG2E32_V_M2_MASK,
          5388 => Opcode::PseudoVLSSEG2E32_V_M4,
          5389 => Opcode::PseudoVLSSEG2E32_V_M4_MASK,
          5390 => Opcode::PseudoVLSSEG2E32_V_MF2,
          5391 => Opcode::PseudoVLSSEG2E32_V_MF2_MASK,
          5392 => Opcode::PseudoVLSSEG2E64_V_M1,
          5393 => Opcode::PseudoVLSSEG2E64_V_M1_MASK,
          5394 => Opcode::PseudoVLSSEG2E64_V_M2,
          5395 => Opcode::PseudoVLSSEG2E64_V_M2_MASK,
          5396 => Opcode::PseudoVLSSEG2E64_V_M4,
          5397 => Opcode::PseudoVLSSEG2E64_V_M4_MASK,
          5398 => Opcode::PseudoVLSSEG2E8_V_M1,
          5399 => Opcode::PseudoVLSSEG2E8_V_M1_MASK,
          5400 => Opcode::PseudoVLSSEG2E8_V_M2,
          5401 => Opcode::PseudoVLSSEG2E8_V_M2_MASK,
          5402 => Opcode::PseudoVLSSEG2E8_V_M4,
          5403 => Opcode::PseudoVLSSEG2E8_V_M4_MASK,
          5404 => Opcode::PseudoVLSSEG2E8_V_MF2,
          5405 => Opcode::PseudoVLSSEG2E8_V_MF2_MASK,
          5406 => Opcode::PseudoVLSSEG2E8_V_MF4,
          5407 => Opcode::PseudoVLSSEG2E8_V_MF4_MASK,
          5408 => Opcode::PseudoVLSSEG2E8_V_MF8,
          5409 => Opcode::PseudoVLSSEG2E8_V_MF8_MASK,
          5410 => Opcode::PseudoVLSSEG3E16_V_M1,
          5411 => Opcode::PseudoVLSSEG3E16_V_M1_MASK,
          5412 => Opcode::PseudoVLSSEG3E16_V_M2,
          5413 => Opcode::PseudoVLSSEG3E16_V_M2_MASK,
          5414 => Opcode::PseudoVLSSEG3E16_V_MF2,
          5415 => Opcode::PseudoVLSSEG3E16_V_MF2_MASK,
          5416 => Opcode::PseudoVLSSEG3E16_V_MF4,
          5417 => Opcode::PseudoVLSSEG3E16_V_MF4_MASK,
          5418 => Opcode::PseudoVLSSEG3E32_V_M1,
          5419 => Opcode::PseudoVLSSEG3E32_V_M1_MASK,
          5420 => Opcode::PseudoVLSSEG3E32_V_M2,
          5421 => Opcode::PseudoVLSSEG3E32_V_M2_MASK,
          5422 => Opcode::PseudoVLSSEG3E32_V_MF2,
          5423 => Opcode::PseudoVLSSEG3E32_V_MF2_MASK,
          5424 => Opcode::PseudoVLSSEG3E64_V_M1,
          5425 => Opcode::PseudoVLSSEG3E64_V_M1_MASK,
          5426 => Opcode::PseudoVLSSEG3E64_V_M2,
          5427 => Opcode::PseudoVLSSEG3E64_V_M2_MASK,
          5428 => Opcode::PseudoVLSSEG3E8_V_M1,
          5429 => Opcode::PseudoVLSSEG3E8_V_M1_MASK,
          5430 => Opcode::PseudoVLSSEG3E8_V_M2,
          5431 => Opcode::PseudoVLSSEG3E8_V_M2_MASK,
          5432 => Opcode::PseudoVLSSEG3E8_V_MF2,
          5433 => Opcode::PseudoVLSSEG3E8_V_MF2_MASK,
          5434 => Opcode::PseudoVLSSEG3E8_V_MF4,
          5435 => Opcode::PseudoVLSSEG3E8_V_MF4_MASK,
          5436 => Opcode::PseudoVLSSEG3E8_V_MF8,
          5437 => Opcode::PseudoVLSSEG3E8_V_MF8_MASK,
          5438 => Opcode::PseudoVLSSEG4E16_V_M1,
          5439 => Opcode::PseudoVLSSEG4E16_V_M1_MASK,
          5440 => Opcode::PseudoVLSSEG4E16_V_M2,
          5441 => Opcode::PseudoVLSSEG4E16_V_M2_MASK,
          5442 => Opcode::PseudoVLSSEG4E16_V_MF2,
          5443 => Opcode::PseudoVLSSEG4E16_V_MF2_MASK,
          5444 => Opcode::PseudoVLSSEG4E16_V_MF4,
          5445 => Opcode::PseudoVLSSEG4E16_V_MF4_MASK,
          5446 => Opcode::PseudoVLSSEG4E32_V_M1,
          5447 => Opcode::PseudoVLSSEG4E32_V_M1_MASK,
          5448 => Opcode::PseudoVLSSEG4E32_V_M2,
          5449 => Opcode::PseudoVLSSEG4E32_V_M2_MASK,
          5450 => Opcode::PseudoVLSSEG4E32_V_MF2,
          5451 => Opcode::PseudoVLSSEG4E32_V_MF2_MASK,
          5452 => Opcode::PseudoVLSSEG4E64_V_M1,
          5453 => Opcode::PseudoVLSSEG4E64_V_M1_MASK,
          5454 => Opcode::PseudoVLSSEG4E64_V_M2,
          5455 => Opcode::PseudoVLSSEG4E64_V_M2_MASK,
          5456 => Opcode::PseudoVLSSEG4E8_V_M1,
          5457 => Opcode::PseudoVLSSEG4E8_V_M1_MASK,
          5458 => Opcode::PseudoVLSSEG4E8_V_M2,
          5459 => Opcode::PseudoVLSSEG4E8_V_M2_MASK,
          5460 => Opcode::PseudoVLSSEG4E8_V_MF2,
          5461 => Opcode::PseudoVLSSEG4E8_V_MF2_MASK,
          5462 => Opcode::PseudoVLSSEG4E8_V_MF4,
          5463 => Opcode::PseudoVLSSEG4E8_V_MF4_MASK,
          5464 => Opcode::PseudoVLSSEG4E8_V_MF8,
          5465 => Opcode::PseudoVLSSEG4E8_V_MF8_MASK,
          5466 => Opcode::PseudoVLSSEG5E16_V_M1,
          5467 => Opcode::PseudoVLSSEG5E16_V_M1_MASK,
          5468 => Opcode::PseudoVLSSEG5E16_V_MF2,
          5469 => Opcode::PseudoVLSSEG5E16_V_MF2_MASK,
          5470 => Opcode::PseudoVLSSEG5E16_V_MF4,
          5471 => Opcode::PseudoVLSSEG5E16_V_MF4_MASK,
          5472 => Opcode::PseudoVLSSEG5E32_V_M1,
          5473 => Opcode::PseudoVLSSEG5E32_V_M1_MASK,
          5474 => Opcode::PseudoVLSSEG5E32_V_MF2,
          5475 => Opcode::PseudoVLSSEG5E32_V_MF2_MASK,
          5476 => Opcode::PseudoVLSSEG5E64_V_M1,
          5477 => Opcode::PseudoVLSSEG5E64_V_M1_MASK,
          5478 => Opcode::PseudoVLSSEG5E8_V_M1,
          5479 => Opcode::PseudoVLSSEG5E8_V_M1_MASK,
          5480 => Opcode::PseudoVLSSEG5E8_V_MF2,
          5481 => Opcode::PseudoVLSSEG5E8_V_MF2_MASK,
          5482 => Opcode::PseudoVLSSEG5E8_V_MF4,
          5483 => Opcode::PseudoVLSSEG5E8_V_MF4_MASK,
          5484 => Opcode::PseudoVLSSEG5E8_V_MF8,
          5485 => Opcode::PseudoVLSSEG5E8_V_MF8_MASK,
          5486 => Opcode::PseudoVLSSEG6E16_V_M1,
          5487 => Opcode::PseudoVLSSEG6E16_V_M1_MASK,
          5488 => Opcode::PseudoVLSSEG6E16_V_MF2,
          5489 => Opcode::PseudoVLSSEG6E16_V_MF2_MASK,
          5490 => Opcode::PseudoVLSSEG6E16_V_MF4,
          5491 => Opcode::PseudoVLSSEG6E16_V_MF4_MASK,
          5492 => Opcode::PseudoVLSSEG6E32_V_M1,
          5493 => Opcode::PseudoVLSSEG6E32_V_M1_MASK,
          5494 => Opcode::PseudoVLSSEG6E32_V_MF2,
          5495 => Opcode::PseudoVLSSEG6E32_V_MF2_MASK,
          5496 => Opcode::PseudoVLSSEG6E64_V_M1,
          5497 => Opcode::PseudoVLSSEG6E64_V_M1_MASK,
          5498 => Opcode::PseudoVLSSEG6E8_V_M1,
          5499 => Opcode::PseudoVLSSEG6E8_V_M1_MASK,
          5500 => Opcode::PseudoVLSSEG6E8_V_MF2,
          5501 => Opcode::PseudoVLSSEG6E8_V_MF2_MASK,
          5502 => Opcode::PseudoVLSSEG6E8_V_MF4,
          5503 => Opcode::PseudoVLSSEG6E8_V_MF4_MASK,
          5504 => Opcode::PseudoVLSSEG6E8_V_MF8,
          5505 => Opcode::PseudoVLSSEG6E8_V_MF8_MASK,
          5506 => Opcode::PseudoVLSSEG7E16_V_M1,
          5507 => Opcode::PseudoVLSSEG7E16_V_M1_MASK,
          5508 => Opcode::PseudoVLSSEG7E16_V_MF2,
          5509 => Opcode::PseudoVLSSEG7E16_V_MF2_MASK,
          5510 => Opcode::PseudoVLSSEG7E16_V_MF4,
          5511 => Opcode::PseudoVLSSEG7E16_V_MF4_MASK,
          5512 => Opcode::PseudoVLSSEG7E32_V_M1,
          5513 => Opcode::PseudoVLSSEG7E32_V_M1_MASK,
          5514 => Opcode::PseudoVLSSEG7E32_V_MF2,
          5515 => Opcode::PseudoVLSSEG7E32_V_MF2_MASK,
          5516 => Opcode::PseudoVLSSEG7E64_V_M1,
          5517 => Opcode::PseudoVLSSEG7E64_V_M1_MASK,
          5518 => Opcode::PseudoVLSSEG7E8_V_M1,
          5519 => Opcode::PseudoVLSSEG7E8_V_M1_MASK,
          5520 => Opcode::PseudoVLSSEG7E8_V_MF2,
          5521 => Opcode::PseudoVLSSEG7E8_V_MF2_MASK,
          5522 => Opcode::PseudoVLSSEG7E8_V_MF4,
          5523 => Opcode::PseudoVLSSEG7E8_V_MF4_MASK,
          5524 => Opcode::PseudoVLSSEG7E8_V_MF8,
          5525 => Opcode::PseudoVLSSEG7E8_V_MF8_MASK,
          5526 => Opcode::PseudoVLSSEG8E16_V_M1,
          5527 => Opcode::PseudoVLSSEG8E16_V_M1_MASK,
          5528 => Opcode::PseudoVLSSEG8E16_V_MF2,
          5529 => Opcode::PseudoVLSSEG8E16_V_MF2_MASK,
          5530 => Opcode::PseudoVLSSEG8E16_V_MF4,
          5531 => Opcode::PseudoVLSSEG8E16_V_MF4_MASK,
          5532 => Opcode::PseudoVLSSEG8E32_V_M1,
          5533 => Opcode::PseudoVLSSEG8E32_V_M1_MASK,
          5534 => Opcode::PseudoVLSSEG8E32_V_MF2,
          5535 => Opcode::PseudoVLSSEG8E32_V_MF2_MASK,
          5536 => Opcode::PseudoVLSSEG8E64_V_M1,
          5537 => Opcode::PseudoVLSSEG8E64_V_M1_MASK,
          5538 => Opcode::PseudoVLSSEG8E8_V_M1,
          5539 => Opcode::PseudoVLSSEG8E8_V_M1_MASK,
          5540 => Opcode::PseudoVLSSEG8E8_V_MF2,
          5541 => Opcode::PseudoVLSSEG8E8_V_MF2_MASK,
          5542 => Opcode::PseudoVLSSEG8E8_V_MF4,
          5543 => Opcode::PseudoVLSSEG8E8_V_MF4_MASK,
          5544 => Opcode::PseudoVLSSEG8E8_V_MF8,
          5545 => Opcode::PseudoVLSSEG8E8_V_MF8_MASK,
          5546 => Opcode::PseudoVLUXEI16_V_M1_M1,
          5547 => Opcode::PseudoVLUXEI16_V_M1_M1_MASK,
          5548 => Opcode::PseudoVLUXEI16_V_M1_M2,
          5549 => Opcode::PseudoVLUXEI16_V_M1_M2_MASK,
          5550 => Opcode::PseudoVLUXEI16_V_M1_M4,
          5551 => Opcode::PseudoVLUXEI16_V_M1_M4_MASK,
          5552 => Opcode::PseudoVLUXEI16_V_M1_MF2,
          5553 => Opcode::PseudoVLUXEI16_V_M1_MF2_MASK,
          5554 => Opcode::PseudoVLUXEI16_V_M2_M1,
          5555 => Opcode::PseudoVLUXEI16_V_M2_M1_MASK,
          5556 => Opcode::PseudoVLUXEI16_V_M2_M2,
          5557 => Opcode::PseudoVLUXEI16_V_M2_M2_MASK,
          5558 => Opcode::PseudoVLUXEI16_V_M2_M4,
          5559 => Opcode::PseudoVLUXEI16_V_M2_M4_MASK,
          5560 => Opcode::PseudoVLUXEI16_V_M2_M8,
          5561 => Opcode::PseudoVLUXEI16_V_M2_M8_MASK,
          5562 => Opcode::PseudoVLUXEI16_V_M4_M2,
          5563 => Opcode::PseudoVLUXEI16_V_M4_M2_MASK,
          5564 => Opcode::PseudoVLUXEI16_V_M4_M4,
          5565 => Opcode::PseudoVLUXEI16_V_M4_M4_MASK,
          5566 => Opcode::PseudoVLUXEI16_V_M4_M8,
          5567 => Opcode::PseudoVLUXEI16_V_M4_M8_MASK,
          5568 => Opcode::PseudoVLUXEI16_V_M8_M4,
          5569 => Opcode::PseudoVLUXEI16_V_M8_M4_MASK,
          5570 => Opcode::PseudoVLUXEI16_V_M8_M8,
          5571 => Opcode::PseudoVLUXEI16_V_M8_M8_MASK,
          5572 => Opcode::PseudoVLUXEI16_V_MF2_M1,
          5573 => Opcode::PseudoVLUXEI16_V_MF2_M1_MASK,
          5574 => Opcode::PseudoVLUXEI16_V_MF2_M2,
          5575 => Opcode::PseudoVLUXEI16_V_MF2_M2_MASK,
          5576 => Opcode::PseudoVLUXEI16_V_MF2_MF2,
          5577 => Opcode::PseudoVLUXEI16_V_MF2_MF2_MASK,
          5578 => Opcode::PseudoVLUXEI16_V_MF2_MF4,
          5579 => Opcode::PseudoVLUXEI16_V_MF2_MF4_MASK,
          5580 => Opcode::PseudoVLUXEI16_V_MF4_M1,
          5581 => Opcode::PseudoVLUXEI16_V_MF4_M1_MASK,
          5582 => Opcode::PseudoVLUXEI16_V_MF4_MF2,
          5583 => Opcode::PseudoVLUXEI16_V_MF4_MF2_MASK,
          5584 => Opcode::PseudoVLUXEI16_V_MF4_MF4,
          5585 => Opcode::PseudoVLUXEI16_V_MF4_MF4_MASK,
          5586 => Opcode::PseudoVLUXEI16_V_MF4_MF8,
          5587 => Opcode::PseudoVLUXEI16_V_MF4_MF8_MASK,
          5588 => Opcode::PseudoVLUXEI32_V_M1_M1,
          5589 => Opcode::PseudoVLUXEI32_V_M1_M1_MASK,
          5590 => Opcode::PseudoVLUXEI32_V_M1_M2,
          5591 => Opcode::PseudoVLUXEI32_V_M1_M2_MASK,
          5592 => Opcode::PseudoVLUXEI32_V_M1_MF2,
          5593 => Opcode::PseudoVLUXEI32_V_M1_MF2_MASK,
          5594 => Opcode::PseudoVLUXEI32_V_M1_MF4,
          5595 => Opcode::PseudoVLUXEI32_V_M1_MF4_MASK,
          5596 => Opcode::PseudoVLUXEI32_V_M2_M1,
          5597 => Opcode::PseudoVLUXEI32_V_M2_M1_MASK,
          5598 => Opcode::PseudoVLUXEI32_V_M2_M2,
          5599 => Opcode::PseudoVLUXEI32_V_M2_M2_MASK,
          5600 => Opcode::PseudoVLUXEI32_V_M2_M4,
          5601 => Opcode::PseudoVLUXEI32_V_M2_M4_MASK,
          5602 => Opcode::PseudoVLUXEI32_V_M2_MF2,
          5603 => Opcode::PseudoVLUXEI32_V_M2_MF2_MASK,
          5604 => Opcode::PseudoVLUXEI32_V_M4_M1,
          5605 => Opcode::PseudoVLUXEI32_V_M4_M1_MASK,
          5606 => Opcode::PseudoVLUXEI32_V_M4_M2,
          5607 => Opcode::PseudoVLUXEI32_V_M4_M2_MASK,
          5608 => Opcode::PseudoVLUXEI32_V_M4_M4,
          5609 => Opcode::PseudoVLUXEI32_V_M4_M4_MASK,
          5610 => Opcode::PseudoVLUXEI32_V_M4_M8,
          5611 => Opcode::PseudoVLUXEI32_V_M4_M8_MASK,
          5612 => Opcode::PseudoVLUXEI32_V_M8_M2,
          5613 => Opcode::PseudoVLUXEI32_V_M8_M2_MASK,
          5614 => Opcode::PseudoVLUXEI32_V_M8_M4,
          5615 => Opcode::PseudoVLUXEI32_V_M8_M4_MASK,
          5616 => Opcode::PseudoVLUXEI32_V_M8_M8,
          5617 => Opcode::PseudoVLUXEI32_V_M8_M8_MASK,
          5618 => Opcode::PseudoVLUXEI32_V_MF2_M1,
          5619 => Opcode::PseudoVLUXEI32_V_MF2_M1_MASK,
          5620 => Opcode::PseudoVLUXEI32_V_MF2_MF2,
          5621 => Opcode::PseudoVLUXEI32_V_MF2_MF2_MASK,
          5622 => Opcode::PseudoVLUXEI32_V_MF2_MF4,
          5623 => Opcode::PseudoVLUXEI32_V_MF2_MF4_MASK,
          5624 => Opcode::PseudoVLUXEI32_V_MF2_MF8,
          5625 => Opcode::PseudoVLUXEI32_V_MF2_MF8_MASK,
          5626 => Opcode::PseudoVLUXEI64_V_M1_M1,
          5627 => Opcode::PseudoVLUXEI64_V_M1_M1_MASK,
          5628 => Opcode::PseudoVLUXEI64_V_M1_MF2,
          5629 => Opcode::PseudoVLUXEI64_V_M1_MF2_MASK,
          5630 => Opcode::PseudoVLUXEI64_V_M1_MF4,
          5631 => Opcode::PseudoVLUXEI64_V_M1_MF4_MASK,
          5632 => Opcode::PseudoVLUXEI64_V_M1_MF8,
          5633 => Opcode::PseudoVLUXEI64_V_M1_MF8_MASK,
          5634 => Opcode::PseudoVLUXEI64_V_M2_M1,
          5635 => Opcode::PseudoVLUXEI64_V_M2_M1_MASK,
          5636 => Opcode::PseudoVLUXEI64_V_M2_M2,
          5637 => Opcode::PseudoVLUXEI64_V_M2_M2_MASK,
          5638 => Opcode::PseudoVLUXEI64_V_M2_MF2,
          5639 => Opcode::PseudoVLUXEI64_V_M2_MF2_MASK,
          5640 => Opcode::PseudoVLUXEI64_V_M2_MF4,
          5641 => Opcode::PseudoVLUXEI64_V_M2_MF4_MASK,
          5642 => Opcode::PseudoVLUXEI64_V_M4_M1,
          5643 => Opcode::PseudoVLUXEI64_V_M4_M1_MASK,
          5644 => Opcode::PseudoVLUXEI64_V_M4_M2,
          5645 => Opcode::PseudoVLUXEI64_V_M4_M2_MASK,
          5646 => Opcode::PseudoVLUXEI64_V_M4_M4,
          5647 => Opcode::PseudoVLUXEI64_V_M4_M4_MASK,
          5648 => Opcode::PseudoVLUXEI64_V_M4_MF2,
          5649 => Opcode::PseudoVLUXEI64_V_M4_MF2_MASK,
          5650 => Opcode::PseudoVLUXEI64_V_M8_M1,
          5651 => Opcode::PseudoVLUXEI64_V_M8_M1_MASK,
          5652 => Opcode::PseudoVLUXEI64_V_M8_M2,
          5653 => Opcode::PseudoVLUXEI64_V_M8_M2_MASK,
          5654 => Opcode::PseudoVLUXEI64_V_M8_M4,
          5655 => Opcode::PseudoVLUXEI64_V_M8_M4_MASK,
          5656 => Opcode::PseudoVLUXEI64_V_M8_M8,
          5657 => Opcode::PseudoVLUXEI64_V_M8_M8_MASK,
          5658 => Opcode::PseudoVLUXEI8_V_M1_M1,
          5659 => Opcode::PseudoVLUXEI8_V_M1_M1_MASK,
          5660 => Opcode::PseudoVLUXEI8_V_M1_M2,
          5661 => Opcode::PseudoVLUXEI8_V_M1_M2_MASK,
          5662 => Opcode::PseudoVLUXEI8_V_M1_M4,
          5663 => Opcode::PseudoVLUXEI8_V_M1_M4_MASK,
          5664 => Opcode::PseudoVLUXEI8_V_M1_M8,
          5665 => Opcode::PseudoVLUXEI8_V_M1_M8_MASK,
          5666 => Opcode::PseudoVLUXEI8_V_M2_M2,
          5667 => Opcode::PseudoVLUXEI8_V_M2_M2_MASK,
          5668 => Opcode::PseudoVLUXEI8_V_M2_M4,
          5669 => Opcode::PseudoVLUXEI8_V_M2_M4_MASK,
          5670 => Opcode::PseudoVLUXEI8_V_M2_M8,
          5671 => Opcode::PseudoVLUXEI8_V_M2_M8_MASK,
          5672 => Opcode::PseudoVLUXEI8_V_M4_M4,
          5673 => Opcode::PseudoVLUXEI8_V_M4_M4_MASK,
          5674 => Opcode::PseudoVLUXEI8_V_M4_M8,
          5675 => Opcode::PseudoVLUXEI8_V_M4_M8_MASK,
          5676 => Opcode::PseudoVLUXEI8_V_M8_M8,
          5677 => Opcode::PseudoVLUXEI8_V_M8_M8_MASK,
          5678 => Opcode::PseudoVLUXEI8_V_MF2_M1,
          5679 => Opcode::PseudoVLUXEI8_V_MF2_M1_MASK,
          5680 => Opcode::PseudoVLUXEI8_V_MF2_M2,
          5681 => Opcode::PseudoVLUXEI8_V_MF2_M2_MASK,
          5682 => Opcode::PseudoVLUXEI8_V_MF2_M4,
          5683 => Opcode::PseudoVLUXEI8_V_MF2_M4_MASK,
          5684 => Opcode::PseudoVLUXEI8_V_MF2_MF2,
          5685 => Opcode::PseudoVLUXEI8_V_MF2_MF2_MASK,
          5686 => Opcode::PseudoVLUXEI8_V_MF4_M1,
          5687 => Opcode::PseudoVLUXEI8_V_MF4_M1_MASK,
          5688 => Opcode::PseudoVLUXEI8_V_MF4_M2,
          5689 => Opcode::PseudoVLUXEI8_V_MF4_M2_MASK,
          5690 => Opcode::PseudoVLUXEI8_V_MF4_MF2,
          5691 => Opcode::PseudoVLUXEI8_V_MF4_MF2_MASK,
          5692 => Opcode::PseudoVLUXEI8_V_MF4_MF4,
          5693 => Opcode::PseudoVLUXEI8_V_MF4_MF4_MASK,
          5694 => Opcode::PseudoVLUXEI8_V_MF8_M1,
          5695 => Opcode::PseudoVLUXEI8_V_MF8_M1_MASK,
          5696 => Opcode::PseudoVLUXEI8_V_MF8_MF2,
          5697 => Opcode::PseudoVLUXEI8_V_MF8_MF2_MASK,
          5698 => Opcode::PseudoVLUXEI8_V_MF8_MF4,
          5699 => Opcode::PseudoVLUXEI8_V_MF8_MF4_MASK,
          5700 => Opcode::PseudoVLUXEI8_V_MF8_MF8,
          5701 => Opcode::PseudoVLUXEI8_V_MF8_MF8_MASK,
          5702 => Opcode::PseudoVLUXSEG2EI16_V_M1_M1,
          5703 => Opcode::PseudoVLUXSEG2EI16_V_M1_M1_MASK,
          5704 => Opcode::PseudoVLUXSEG2EI16_V_M1_M2,
          5705 => Opcode::PseudoVLUXSEG2EI16_V_M1_M2_MASK,
          5706 => Opcode::PseudoVLUXSEG2EI16_V_M1_M4,
          5707 => Opcode::PseudoVLUXSEG2EI16_V_M1_M4_MASK,
          5708 => Opcode::PseudoVLUXSEG2EI16_V_M1_MF2,
          5709 => Opcode::PseudoVLUXSEG2EI16_V_M1_MF2_MASK,
          5710 => Opcode::PseudoVLUXSEG2EI16_V_M2_M1,
          5711 => Opcode::PseudoVLUXSEG2EI16_V_M2_M1_MASK,
          5712 => Opcode::PseudoVLUXSEG2EI16_V_M2_M2,
          5713 => Opcode::PseudoVLUXSEG2EI16_V_M2_M2_MASK,
          5714 => Opcode::PseudoVLUXSEG2EI16_V_M2_M4,
          5715 => Opcode::PseudoVLUXSEG2EI16_V_M2_M4_MASK,
          5716 => Opcode::PseudoVLUXSEG2EI16_V_M4_M2,
          5717 => Opcode::PseudoVLUXSEG2EI16_V_M4_M2_MASK,
          5718 => Opcode::PseudoVLUXSEG2EI16_V_M4_M4,
          5719 => Opcode::PseudoVLUXSEG2EI16_V_M4_M4_MASK,
          5720 => Opcode::PseudoVLUXSEG2EI16_V_M8_M4,
          5721 => Opcode::PseudoVLUXSEG2EI16_V_M8_M4_MASK,
          5722 => Opcode::PseudoVLUXSEG2EI16_V_MF2_M1,
          5723 => Opcode::PseudoVLUXSEG2EI16_V_MF2_M1_MASK,
          5724 => Opcode::PseudoVLUXSEG2EI16_V_MF2_M2,
          5725 => Opcode::PseudoVLUXSEG2EI16_V_MF2_M2_MASK,
          5726 => Opcode::PseudoVLUXSEG2EI16_V_MF2_MF2,
          5727 => Opcode::PseudoVLUXSEG2EI16_V_MF2_MF2_MASK,
          5728 => Opcode::PseudoVLUXSEG2EI16_V_MF2_MF4,
          5729 => Opcode::PseudoVLUXSEG2EI16_V_MF2_MF4_MASK,
          5730 => Opcode::PseudoVLUXSEG2EI16_V_MF4_M1,
          5731 => Opcode::PseudoVLUXSEG2EI16_V_MF4_M1_MASK,
          5732 => Opcode::PseudoVLUXSEG2EI16_V_MF4_MF2,
          5733 => Opcode::PseudoVLUXSEG2EI16_V_MF4_MF2_MASK,
          5734 => Opcode::PseudoVLUXSEG2EI16_V_MF4_MF4,
          5735 => Opcode::PseudoVLUXSEG2EI16_V_MF4_MF4_MASK,
          5736 => Opcode::PseudoVLUXSEG2EI16_V_MF4_MF8,
          5737 => Opcode::PseudoVLUXSEG2EI16_V_MF4_MF8_MASK,
          5738 => Opcode::PseudoVLUXSEG2EI32_V_M1_M1,
          5739 => Opcode::PseudoVLUXSEG2EI32_V_M1_M1_MASK,
          5740 => Opcode::PseudoVLUXSEG2EI32_V_M1_M2,
          5741 => Opcode::PseudoVLUXSEG2EI32_V_M1_M2_MASK,
          5742 => Opcode::PseudoVLUXSEG2EI32_V_M1_MF2,
          5743 => Opcode::PseudoVLUXSEG2EI32_V_M1_MF2_MASK,
          5744 => Opcode::PseudoVLUXSEG2EI32_V_M1_MF4,
          5745 => Opcode::PseudoVLUXSEG2EI32_V_M1_MF4_MASK,
          5746 => Opcode::PseudoVLUXSEG2EI32_V_M2_M1,
          5747 => Opcode::PseudoVLUXSEG2EI32_V_M2_M1_MASK,
          5748 => Opcode::PseudoVLUXSEG2EI32_V_M2_M2,
          5749 => Opcode::PseudoVLUXSEG2EI32_V_M2_M2_MASK,
          5750 => Opcode::PseudoVLUXSEG2EI32_V_M2_M4,
          5751 => Opcode::PseudoVLUXSEG2EI32_V_M2_M4_MASK,
          5752 => Opcode::PseudoVLUXSEG2EI32_V_M2_MF2,
          5753 => Opcode::PseudoVLUXSEG2EI32_V_M2_MF2_MASK,
          5754 => Opcode::PseudoVLUXSEG2EI32_V_M4_M1,
          5755 => Opcode::PseudoVLUXSEG2EI32_V_M4_M1_MASK,
          5756 => Opcode::PseudoVLUXSEG2EI32_V_M4_M2,
          5757 => Opcode::PseudoVLUXSEG2EI32_V_M4_M2_MASK,
          5758 => Opcode::PseudoVLUXSEG2EI32_V_M4_M4,
          5759 => Opcode::PseudoVLUXSEG2EI32_V_M4_M4_MASK,
          5760 => Opcode::PseudoVLUXSEG2EI32_V_M8_M2,
          5761 => Opcode::PseudoVLUXSEG2EI32_V_M8_M2_MASK,
          5762 => Opcode::PseudoVLUXSEG2EI32_V_M8_M4,
          5763 => Opcode::PseudoVLUXSEG2EI32_V_M8_M4_MASK,
          5764 => Opcode::PseudoVLUXSEG2EI32_V_MF2_M1,
          5765 => Opcode::PseudoVLUXSEG2EI32_V_MF2_M1_MASK,
          5766 => Opcode::PseudoVLUXSEG2EI32_V_MF2_MF2,
          5767 => Opcode::PseudoVLUXSEG2EI32_V_MF2_MF2_MASK,
          5768 => Opcode::PseudoVLUXSEG2EI32_V_MF2_MF4,
          5769 => Opcode::PseudoVLUXSEG2EI32_V_MF2_MF4_MASK,
          5770 => Opcode::PseudoVLUXSEG2EI32_V_MF2_MF8,
          5771 => Opcode::PseudoVLUXSEG2EI32_V_MF2_MF8_MASK,
          5772 => Opcode::PseudoVLUXSEG2EI64_V_M1_M1,
          5773 => Opcode::PseudoVLUXSEG2EI64_V_M1_M1_MASK,
          5774 => Opcode::PseudoVLUXSEG2EI64_V_M1_MF2,
          5775 => Opcode::PseudoVLUXSEG2EI64_V_M1_MF2_MASK,
          5776 => Opcode::PseudoVLUXSEG2EI64_V_M1_MF4,
          5777 => Opcode::PseudoVLUXSEG2EI64_V_M1_MF4_MASK,
          5778 => Opcode::PseudoVLUXSEG2EI64_V_M1_MF8,
          5779 => Opcode::PseudoVLUXSEG2EI64_V_M1_MF8_MASK,
          5780 => Opcode::PseudoVLUXSEG2EI64_V_M2_M1,
          5781 => Opcode::PseudoVLUXSEG2EI64_V_M2_M1_MASK,
          5782 => Opcode::PseudoVLUXSEG2EI64_V_M2_M2,
          5783 => Opcode::PseudoVLUXSEG2EI64_V_M2_M2_MASK,
          5784 => Opcode::PseudoVLUXSEG2EI64_V_M2_MF2,
          5785 => Opcode::PseudoVLUXSEG2EI64_V_M2_MF2_MASK,
          5786 => Opcode::PseudoVLUXSEG2EI64_V_M2_MF4,
          5787 => Opcode::PseudoVLUXSEG2EI64_V_M2_MF4_MASK,
          5788 => Opcode::PseudoVLUXSEG2EI64_V_M4_M1,
          5789 => Opcode::PseudoVLUXSEG2EI64_V_M4_M1_MASK,
          5790 => Opcode::PseudoVLUXSEG2EI64_V_M4_M2,
          5791 => Opcode::PseudoVLUXSEG2EI64_V_M4_M2_MASK,
          5792 => Opcode::PseudoVLUXSEG2EI64_V_M4_M4,
          5793 => Opcode::PseudoVLUXSEG2EI64_V_M4_M4_MASK,
          5794 => Opcode::PseudoVLUXSEG2EI64_V_M4_MF2,
          5795 => Opcode::PseudoVLUXSEG2EI64_V_M4_MF2_MASK,
          5796 => Opcode::PseudoVLUXSEG2EI64_V_M8_M1,
          5797 => Opcode::PseudoVLUXSEG2EI64_V_M8_M1_MASK,
          5798 => Opcode::PseudoVLUXSEG2EI64_V_M8_M2,
          5799 => Opcode::PseudoVLUXSEG2EI64_V_M8_M2_MASK,
          5800 => Opcode::PseudoVLUXSEG2EI64_V_M8_M4,
          5801 => Opcode::PseudoVLUXSEG2EI64_V_M8_M4_MASK,
          5802 => Opcode::PseudoVLUXSEG2EI8_V_M1_M1,
          5803 => Opcode::PseudoVLUXSEG2EI8_V_M1_M1_MASK,
          5804 => Opcode::PseudoVLUXSEG2EI8_V_M1_M2,
          5805 => Opcode::PseudoVLUXSEG2EI8_V_M1_M2_MASK,
          5806 => Opcode::PseudoVLUXSEG2EI8_V_M1_M4,
          5807 => Opcode::PseudoVLUXSEG2EI8_V_M1_M4_MASK,
          5808 => Opcode::PseudoVLUXSEG2EI8_V_M2_M2,
          5809 => Opcode::PseudoVLUXSEG2EI8_V_M2_M2_MASK,
          5810 => Opcode::PseudoVLUXSEG2EI8_V_M2_M4,
          5811 => Opcode::PseudoVLUXSEG2EI8_V_M2_M4_MASK,
          5812 => Opcode::PseudoVLUXSEG2EI8_V_M4_M4,
          5813 => Opcode::PseudoVLUXSEG2EI8_V_M4_M4_MASK,
          5814 => Opcode::PseudoVLUXSEG2EI8_V_MF2_M1,
          5815 => Opcode::PseudoVLUXSEG2EI8_V_MF2_M1_MASK,
          5816 => Opcode::PseudoVLUXSEG2EI8_V_MF2_M2,
          5817 => Opcode::PseudoVLUXSEG2EI8_V_MF2_M2_MASK,
          5818 => Opcode::PseudoVLUXSEG2EI8_V_MF2_M4,
          5819 => Opcode::PseudoVLUXSEG2EI8_V_MF2_M4_MASK,
          5820 => Opcode::PseudoVLUXSEG2EI8_V_MF2_MF2,
          5821 => Opcode::PseudoVLUXSEG2EI8_V_MF2_MF2_MASK,
          5822 => Opcode::PseudoVLUXSEG2EI8_V_MF4_M1,
          5823 => Opcode::PseudoVLUXSEG2EI8_V_MF4_M1_MASK,
          5824 => Opcode::PseudoVLUXSEG2EI8_V_MF4_M2,
          5825 => Opcode::PseudoVLUXSEG2EI8_V_MF4_M2_MASK,
          5826 => Opcode::PseudoVLUXSEG2EI8_V_MF4_MF2,
          5827 => Opcode::PseudoVLUXSEG2EI8_V_MF4_MF2_MASK,
          5828 => Opcode::PseudoVLUXSEG2EI8_V_MF4_MF4,
          5829 => Opcode::PseudoVLUXSEG2EI8_V_MF4_MF4_MASK,
          5830 => Opcode::PseudoVLUXSEG2EI8_V_MF8_M1,
          5831 => Opcode::PseudoVLUXSEG2EI8_V_MF8_M1_MASK,
          5832 => Opcode::PseudoVLUXSEG2EI8_V_MF8_MF2,
          5833 => Opcode::PseudoVLUXSEG2EI8_V_MF8_MF2_MASK,
          5834 => Opcode::PseudoVLUXSEG2EI8_V_MF8_MF4,
          5835 => Opcode::PseudoVLUXSEG2EI8_V_MF8_MF4_MASK,
          5836 => Opcode::PseudoVLUXSEG2EI8_V_MF8_MF8,
          5837 => Opcode::PseudoVLUXSEG2EI8_V_MF8_MF8_MASK,
          5838 => Opcode::PseudoVLUXSEG3EI16_V_M1_M1,
          5839 => Opcode::PseudoVLUXSEG3EI16_V_M1_M1_MASK,
          5840 => Opcode::PseudoVLUXSEG3EI16_V_M1_M2,
          5841 => Opcode::PseudoVLUXSEG3EI16_V_M1_M2_MASK,
          5842 => Opcode::PseudoVLUXSEG3EI16_V_M1_MF2,
          5843 => Opcode::PseudoVLUXSEG3EI16_V_M1_MF2_MASK,
          5844 => Opcode::PseudoVLUXSEG3EI16_V_M2_M1,
          5845 => Opcode::PseudoVLUXSEG3EI16_V_M2_M1_MASK,
          5846 => Opcode::PseudoVLUXSEG3EI16_V_M2_M2,
          5847 => Opcode::PseudoVLUXSEG3EI16_V_M2_M2_MASK,
          5848 => Opcode::PseudoVLUXSEG3EI16_V_M4_M2,
          5849 => Opcode::PseudoVLUXSEG3EI16_V_M4_M2_MASK,
          5850 => Opcode::PseudoVLUXSEG3EI16_V_MF2_M1,
          5851 => Opcode::PseudoVLUXSEG3EI16_V_MF2_M1_MASK,
          5852 => Opcode::PseudoVLUXSEG3EI16_V_MF2_M2,
          5853 => Opcode::PseudoVLUXSEG3EI16_V_MF2_M2_MASK,
          5854 => Opcode::PseudoVLUXSEG3EI16_V_MF2_MF2,
          5855 => Opcode::PseudoVLUXSEG3EI16_V_MF2_MF2_MASK,
          5856 => Opcode::PseudoVLUXSEG3EI16_V_MF2_MF4,
          5857 => Opcode::PseudoVLUXSEG3EI16_V_MF2_MF4_MASK,
          5858 => Opcode::PseudoVLUXSEG3EI16_V_MF4_M1,
          5859 => Opcode::PseudoVLUXSEG3EI16_V_MF4_M1_MASK,
          5860 => Opcode::PseudoVLUXSEG3EI16_V_MF4_MF2,
          5861 => Opcode::PseudoVLUXSEG3EI16_V_MF4_MF2_MASK,
          5862 => Opcode::PseudoVLUXSEG3EI16_V_MF4_MF4,
          5863 => Opcode::PseudoVLUXSEG3EI16_V_MF4_MF4_MASK,
          5864 => Opcode::PseudoVLUXSEG3EI16_V_MF4_MF8,
          5865 => Opcode::PseudoVLUXSEG3EI16_V_MF4_MF8_MASK,
          5866 => Opcode::PseudoVLUXSEG3EI32_V_M1_M1,
          5867 => Opcode::PseudoVLUXSEG3EI32_V_M1_M1_MASK,
          5868 => Opcode::PseudoVLUXSEG3EI32_V_M1_M2,
          5869 => Opcode::PseudoVLUXSEG3EI32_V_M1_M2_MASK,
          5870 => Opcode::PseudoVLUXSEG3EI32_V_M1_MF2,
          5871 => Opcode::PseudoVLUXSEG3EI32_V_M1_MF2_MASK,
          5872 => Opcode::PseudoVLUXSEG3EI32_V_M1_MF4,
          5873 => Opcode::PseudoVLUXSEG3EI32_V_M1_MF4_MASK,
          5874 => Opcode::PseudoVLUXSEG3EI32_V_M2_M1,
          5875 => Opcode::PseudoVLUXSEG3EI32_V_M2_M1_MASK,
          5876 => Opcode::PseudoVLUXSEG3EI32_V_M2_M2,
          5877 => Opcode::PseudoVLUXSEG3EI32_V_M2_M2_MASK,
          5878 => Opcode::PseudoVLUXSEG3EI32_V_M2_MF2,
          5879 => Opcode::PseudoVLUXSEG3EI32_V_M2_MF2_MASK,
          5880 => Opcode::PseudoVLUXSEG3EI32_V_M4_M1,
          5881 => Opcode::PseudoVLUXSEG3EI32_V_M4_M1_MASK,
          5882 => Opcode::PseudoVLUXSEG3EI32_V_M4_M2,
          5883 => Opcode::PseudoVLUXSEG3EI32_V_M4_M2_MASK,
          5884 => Opcode::PseudoVLUXSEG3EI32_V_M8_M2,
          5885 => Opcode::PseudoVLUXSEG3EI32_V_M8_M2_MASK,
          5886 => Opcode::PseudoVLUXSEG3EI32_V_MF2_M1,
          5887 => Opcode::PseudoVLUXSEG3EI32_V_MF2_M1_MASK,
          5888 => Opcode::PseudoVLUXSEG3EI32_V_MF2_MF2,
          5889 => Opcode::PseudoVLUXSEG3EI32_V_MF2_MF2_MASK,
          5890 => Opcode::PseudoVLUXSEG3EI32_V_MF2_MF4,
          5891 => Opcode::PseudoVLUXSEG3EI32_V_MF2_MF4_MASK,
          5892 => Opcode::PseudoVLUXSEG3EI32_V_MF2_MF8,
          5893 => Opcode::PseudoVLUXSEG3EI32_V_MF2_MF8_MASK,
          5894 => Opcode::PseudoVLUXSEG3EI64_V_M1_M1,
          5895 => Opcode::PseudoVLUXSEG3EI64_V_M1_M1_MASK,
          5896 => Opcode::PseudoVLUXSEG3EI64_V_M1_MF2,
          5897 => Opcode::PseudoVLUXSEG3EI64_V_M1_MF2_MASK,
          5898 => Opcode::PseudoVLUXSEG3EI64_V_M1_MF4,
          5899 => Opcode::PseudoVLUXSEG3EI64_V_M1_MF4_MASK,
          5900 => Opcode::PseudoVLUXSEG3EI64_V_M1_MF8,
          5901 => Opcode::PseudoVLUXSEG3EI64_V_M1_MF8_MASK,
          5902 => Opcode::PseudoVLUXSEG3EI64_V_M2_M1,
          5903 => Opcode::PseudoVLUXSEG3EI64_V_M2_M1_MASK,
          5904 => Opcode::PseudoVLUXSEG3EI64_V_M2_M2,
          5905 => Opcode::PseudoVLUXSEG3EI64_V_M2_M2_MASK,
          5906 => Opcode::PseudoVLUXSEG3EI64_V_M2_MF2,
          5907 => Opcode::PseudoVLUXSEG3EI64_V_M2_MF2_MASK,
          5908 => Opcode::PseudoVLUXSEG3EI64_V_M2_MF4,
          5909 => Opcode::PseudoVLUXSEG3EI64_V_M2_MF4_MASK,
          5910 => Opcode::PseudoVLUXSEG3EI64_V_M4_M1,
          5911 => Opcode::PseudoVLUXSEG3EI64_V_M4_M1_MASK,
          5912 => Opcode::PseudoVLUXSEG3EI64_V_M4_M2,
          5913 => Opcode::PseudoVLUXSEG3EI64_V_M4_M2_MASK,
          5914 => Opcode::PseudoVLUXSEG3EI64_V_M4_MF2,
          5915 => Opcode::PseudoVLUXSEG3EI64_V_M4_MF2_MASK,
          5916 => Opcode::PseudoVLUXSEG3EI64_V_M8_M1,
          5917 => Opcode::PseudoVLUXSEG3EI64_V_M8_M1_MASK,
          5918 => Opcode::PseudoVLUXSEG3EI64_V_M8_M2,
          5919 => Opcode::PseudoVLUXSEG3EI64_V_M8_M2_MASK,
          5920 => Opcode::PseudoVLUXSEG3EI8_V_M1_M1,
          5921 => Opcode::PseudoVLUXSEG3EI8_V_M1_M1_MASK,
          5922 => Opcode::PseudoVLUXSEG3EI8_V_M1_M2,
          5923 => Opcode::PseudoVLUXSEG3EI8_V_M1_M2_MASK,
          5924 => Opcode::PseudoVLUXSEG3EI8_V_M2_M2,
          5925 => Opcode::PseudoVLUXSEG3EI8_V_M2_M2_MASK,
          5926 => Opcode::PseudoVLUXSEG3EI8_V_MF2_M1,
          5927 => Opcode::PseudoVLUXSEG3EI8_V_MF2_M1_MASK,
          5928 => Opcode::PseudoVLUXSEG3EI8_V_MF2_M2,
          5929 => Opcode::PseudoVLUXSEG3EI8_V_MF2_M2_MASK,
          5930 => Opcode::PseudoVLUXSEG3EI8_V_MF2_MF2,
          5931 => Opcode::PseudoVLUXSEG3EI8_V_MF2_MF2_MASK,
          5932 => Opcode::PseudoVLUXSEG3EI8_V_MF4_M1,
          5933 => Opcode::PseudoVLUXSEG3EI8_V_MF4_M1_MASK,
          5934 => Opcode::PseudoVLUXSEG3EI8_V_MF4_M2,
          5935 => Opcode::PseudoVLUXSEG3EI8_V_MF4_M2_MASK,
          5936 => Opcode::PseudoVLUXSEG3EI8_V_MF4_MF2,
          5937 => Opcode::PseudoVLUXSEG3EI8_V_MF4_MF2_MASK,
          5938 => Opcode::PseudoVLUXSEG3EI8_V_MF4_MF4,
          5939 => Opcode::PseudoVLUXSEG3EI8_V_MF4_MF4_MASK,
          5940 => Opcode::PseudoVLUXSEG3EI8_V_MF8_M1,
          5941 => Opcode::PseudoVLUXSEG3EI8_V_MF8_M1_MASK,
          5942 => Opcode::PseudoVLUXSEG3EI8_V_MF8_MF2,
          5943 => Opcode::PseudoVLUXSEG3EI8_V_MF8_MF2_MASK,
          5944 => Opcode::PseudoVLUXSEG3EI8_V_MF8_MF4,
          5945 => Opcode::PseudoVLUXSEG3EI8_V_MF8_MF4_MASK,
          5946 => Opcode::PseudoVLUXSEG3EI8_V_MF8_MF8,
          5947 => Opcode::PseudoVLUXSEG3EI8_V_MF8_MF8_MASK,
          5948 => Opcode::PseudoVLUXSEG4EI16_V_M1_M1,
          5949 => Opcode::PseudoVLUXSEG4EI16_V_M1_M1_MASK,
          5950 => Opcode::PseudoVLUXSEG4EI16_V_M1_M2,
          5951 => Opcode::PseudoVLUXSEG4EI16_V_M1_M2_MASK,
          5952 => Opcode::PseudoVLUXSEG4EI16_V_M1_MF2,
          5953 => Opcode::PseudoVLUXSEG4EI16_V_M1_MF2_MASK,
          5954 => Opcode::PseudoVLUXSEG4EI16_V_M2_M1,
          5955 => Opcode::PseudoVLUXSEG4EI16_V_M2_M1_MASK,
          5956 => Opcode::PseudoVLUXSEG4EI16_V_M2_M2,
          5957 => Opcode::PseudoVLUXSEG4EI16_V_M2_M2_MASK,
          5958 => Opcode::PseudoVLUXSEG4EI16_V_M4_M2,
          5959 => Opcode::PseudoVLUXSEG4EI16_V_M4_M2_MASK,
          5960 => Opcode::PseudoVLUXSEG4EI16_V_MF2_M1,
          5961 => Opcode::PseudoVLUXSEG4EI16_V_MF2_M1_MASK,
          5962 => Opcode::PseudoVLUXSEG4EI16_V_MF2_M2,
          5963 => Opcode::PseudoVLUXSEG4EI16_V_MF2_M2_MASK,
          5964 => Opcode::PseudoVLUXSEG4EI16_V_MF2_MF2,
          5965 => Opcode::PseudoVLUXSEG4EI16_V_MF2_MF2_MASK,
          5966 => Opcode::PseudoVLUXSEG4EI16_V_MF2_MF4,
          5967 => Opcode::PseudoVLUXSEG4EI16_V_MF2_MF4_MASK,
          5968 => Opcode::PseudoVLUXSEG4EI16_V_MF4_M1,
          5969 => Opcode::PseudoVLUXSEG4EI16_V_MF4_M1_MASK,
          5970 => Opcode::PseudoVLUXSEG4EI16_V_MF4_MF2,
          5971 => Opcode::PseudoVLUXSEG4EI16_V_MF4_MF2_MASK,
          5972 => Opcode::PseudoVLUXSEG4EI16_V_MF4_MF4,
          5973 => Opcode::PseudoVLUXSEG4EI16_V_MF4_MF4_MASK,
          5974 => Opcode::PseudoVLUXSEG4EI16_V_MF4_MF8,
          5975 => Opcode::PseudoVLUXSEG4EI16_V_MF4_MF8_MASK,
          5976 => Opcode::PseudoVLUXSEG4EI32_V_M1_M1,
          5977 => Opcode::PseudoVLUXSEG4EI32_V_M1_M1_MASK,
          5978 => Opcode::PseudoVLUXSEG4EI32_V_M1_M2,
          5979 => Opcode::PseudoVLUXSEG4EI32_V_M1_M2_MASK,
          5980 => Opcode::PseudoVLUXSEG4EI32_V_M1_MF2,
          5981 => Opcode::PseudoVLUXSEG4EI32_V_M1_MF2_MASK,
          5982 => Opcode::PseudoVLUXSEG4EI32_V_M1_MF4,
          5983 => Opcode::PseudoVLUXSEG4EI32_V_M1_MF4_MASK,
          5984 => Opcode::PseudoVLUXSEG4EI32_V_M2_M1,
          5985 => Opcode::PseudoVLUXSEG4EI32_V_M2_M1_MASK,
          5986 => Opcode::PseudoVLUXSEG4EI32_V_M2_M2,
          5987 => Opcode::PseudoVLUXSEG4EI32_V_M2_M2_MASK,
          5988 => Opcode::PseudoVLUXSEG4EI32_V_M2_MF2,
          5989 => Opcode::PseudoVLUXSEG4EI32_V_M2_MF2_MASK,
          5990 => Opcode::PseudoVLUXSEG4EI32_V_M4_M1,
          5991 => Opcode::PseudoVLUXSEG4EI32_V_M4_M1_MASK,
          5992 => Opcode::PseudoVLUXSEG4EI32_V_M4_M2,
          5993 => Opcode::PseudoVLUXSEG4EI32_V_M4_M2_MASK,
          5994 => Opcode::PseudoVLUXSEG4EI32_V_M8_M2,
          5995 => Opcode::PseudoVLUXSEG4EI32_V_M8_M2_MASK,
          5996 => Opcode::PseudoVLUXSEG4EI32_V_MF2_M1,
          5997 => Opcode::PseudoVLUXSEG4EI32_V_MF2_M1_MASK,
          5998 => Opcode::PseudoVLUXSEG4EI32_V_MF2_MF2,
          5999 => Opcode::PseudoVLUXSEG4EI32_V_MF2_MF2_MASK,
          6000 => Opcode::PseudoVLUXSEG4EI32_V_MF2_MF4,
          6001 => Opcode::PseudoVLUXSEG4EI32_V_MF2_MF4_MASK,
          6002 => Opcode::PseudoVLUXSEG4EI32_V_MF2_MF8,
          6003 => Opcode::PseudoVLUXSEG4EI32_V_MF2_MF8_MASK,
          6004 => Opcode::PseudoVLUXSEG4EI64_V_M1_M1,
          6005 => Opcode::PseudoVLUXSEG4EI64_V_M1_M1_MASK,
          6006 => Opcode::PseudoVLUXSEG4EI64_V_M1_MF2,
          6007 => Opcode::PseudoVLUXSEG4EI64_V_M1_MF2_MASK,
          6008 => Opcode::PseudoVLUXSEG4EI64_V_M1_MF4,
          6009 => Opcode::PseudoVLUXSEG4EI64_V_M1_MF4_MASK,
          6010 => Opcode::PseudoVLUXSEG4EI64_V_M1_MF8,
          6011 => Opcode::PseudoVLUXSEG4EI64_V_M1_MF8_MASK,
          6012 => Opcode::PseudoVLUXSEG4EI64_V_M2_M1,
          6013 => Opcode::PseudoVLUXSEG4EI64_V_M2_M1_MASK,
          6014 => Opcode::PseudoVLUXSEG4EI64_V_M2_M2,
          6015 => Opcode::PseudoVLUXSEG4EI64_V_M2_M2_MASK,
          6016 => Opcode::PseudoVLUXSEG4EI64_V_M2_MF2,
          6017 => Opcode::PseudoVLUXSEG4EI64_V_M2_MF2_MASK,
          6018 => Opcode::PseudoVLUXSEG4EI64_V_M2_MF4,
          6019 => Opcode::PseudoVLUXSEG4EI64_V_M2_MF4_MASK,
          6020 => Opcode::PseudoVLUXSEG4EI64_V_M4_M1,
          6021 => Opcode::PseudoVLUXSEG4EI64_V_M4_M1_MASK,
          6022 => Opcode::PseudoVLUXSEG4EI64_V_M4_M2,
          6023 => Opcode::PseudoVLUXSEG4EI64_V_M4_M2_MASK,
          6024 => Opcode::PseudoVLUXSEG4EI64_V_M4_MF2,
          6025 => Opcode::PseudoVLUXSEG4EI64_V_M4_MF2_MASK,
          6026 => Opcode::PseudoVLUXSEG4EI64_V_M8_M1,
          6027 => Opcode::PseudoVLUXSEG4EI64_V_M8_M1_MASK,
          6028 => Opcode::PseudoVLUXSEG4EI64_V_M8_M2,
          6029 => Opcode::PseudoVLUXSEG4EI64_V_M8_M2_MASK,
          6030 => Opcode::PseudoVLUXSEG4EI8_V_M1_M1,
          6031 => Opcode::PseudoVLUXSEG4EI8_V_M1_M1_MASK,
          6032 => Opcode::PseudoVLUXSEG4EI8_V_M1_M2,
          6033 => Opcode::PseudoVLUXSEG4EI8_V_M1_M2_MASK,
          6034 => Opcode::PseudoVLUXSEG4EI8_V_M2_M2,
          6035 => Opcode::PseudoVLUXSEG4EI8_V_M2_M2_MASK,
          6036 => Opcode::PseudoVLUXSEG4EI8_V_MF2_M1,
          6037 => Opcode::PseudoVLUXSEG4EI8_V_MF2_M1_MASK,
          6038 => Opcode::PseudoVLUXSEG4EI8_V_MF2_M2,
          6039 => Opcode::PseudoVLUXSEG4EI8_V_MF2_M2_MASK,
          6040 => Opcode::PseudoVLUXSEG4EI8_V_MF2_MF2,
          6041 => Opcode::PseudoVLUXSEG4EI8_V_MF2_MF2_MASK,
          6042 => Opcode::PseudoVLUXSEG4EI8_V_MF4_M1,
          6043 => Opcode::PseudoVLUXSEG4EI8_V_MF4_M1_MASK,
          6044 => Opcode::PseudoVLUXSEG4EI8_V_MF4_M2,
          6045 => Opcode::PseudoVLUXSEG4EI8_V_MF4_M2_MASK,
          6046 => Opcode::PseudoVLUXSEG4EI8_V_MF4_MF2,
          6047 => Opcode::PseudoVLUXSEG4EI8_V_MF4_MF2_MASK,
          6048 => Opcode::PseudoVLUXSEG4EI8_V_MF4_MF4,
          6049 => Opcode::PseudoVLUXSEG4EI8_V_MF4_MF4_MASK,
          6050 => Opcode::PseudoVLUXSEG4EI8_V_MF8_M1,
          6051 => Opcode::PseudoVLUXSEG4EI8_V_MF8_M1_MASK,
          6052 => Opcode::PseudoVLUXSEG4EI8_V_MF8_MF2,
          6053 => Opcode::PseudoVLUXSEG4EI8_V_MF8_MF2_MASK,
          6054 => Opcode::PseudoVLUXSEG4EI8_V_MF8_MF4,
          6055 => Opcode::PseudoVLUXSEG4EI8_V_MF8_MF4_MASK,
          6056 => Opcode::PseudoVLUXSEG4EI8_V_MF8_MF8,
          6057 => Opcode::PseudoVLUXSEG4EI8_V_MF8_MF8_MASK,
          6058 => Opcode::PseudoVLUXSEG5EI16_V_M1_M1,
          6059 => Opcode::PseudoVLUXSEG5EI16_V_M1_M1_MASK,
          6060 => Opcode::PseudoVLUXSEG5EI16_V_M1_MF2,
          6061 => Opcode::PseudoVLUXSEG5EI16_V_M1_MF2_MASK,
          6062 => Opcode::PseudoVLUXSEG5EI16_V_M2_M1,
          6063 => Opcode::PseudoVLUXSEG5EI16_V_M2_M1_MASK,
          6064 => Opcode::PseudoVLUXSEG5EI16_V_MF2_M1,
          6065 => Opcode::PseudoVLUXSEG5EI16_V_MF2_M1_MASK,
          6066 => Opcode::PseudoVLUXSEG5EI16_V_MF2_MF2,
          6067 => Opcode::PseudoVLUXSEG5EI16_V_MF2_MF2_MASK,
          6068 => Opcode::PseudoVLUXSEG5EI16_V_MF2_MF4,
          6069 => Opcode::PseudoVLUXSEG5EI16_V_MF2_MF4_MASK,
          6070 => Opcode::PseudoVLUXSEG5EI16_V_MF4_M1,
          6071 => Opcode::PseudoVLUXSEG5EI16_V_MF4_M1_MASK,
          6072 => Opcode::PseudoVLUXSEG5EI16_V_MF4_MF2,
          6073 => Opcode::PseudoVLUXSEG5EI16_V_MF4_MF2_MASK,
          6074 => Opcode::PseudoVLUXSEG5EI16_V_MF4_MF4,
          6075 => Opcode::PseudoVLUXSEG5EI16_V_MF4_MF4_MASK,
          6076 => Opcode::PseudoVLUXSEG5EI16_V_MF4_MF8,
          6077 => Opcode::PseudoVLUXSEG5EI16_V_MF4_MF8_MASK,
          6078 => Opcode::PseudoVLUXSEG5EI32_V_M1_M1,
          6079 => Opcode::PseudoVLUXSEG5EI32_V_M1_M1_MASK,
          6080 => Opcode::PseudoVLUXSEG5EI32_V_M1_MF2,
          6081 => Opcode::PseudoVLUXSEG5EI32_V_M1_MF2_MASK,
          6082 => Opcode::PseudoVLUXSEG5EI32_V_M1_MF4,
          6083 => Opcode::PseudoVLUXSEG5EI32_V_M1_MF4_MASK,
          6084 => Opcode::PseudoVLUXSEG5EI32_V_M2_M1,
          6085 => Opcode::PseudoVLUXSEG5EI32_V_M2_M1_MASK,
          6086 => Opcode::PseudoVLUXSEG5EI32_V_M2_MF2,
          6087 => Opcode::PseudoVLUXSEG5EI32_V_M2_MF2_MASK,
          6088 => Opcode::PseudoVLUXSEG5EI32_V_M4_M1,
          6089 => Opcode::PseudoVLUXSEG5EI32_V_M4_M1_MASK,
          6090 => Opcode::PseudoVLUXSEG5EI32_V_MF2_M1,
          6091 => Opcode::PseudoVLUXSEG5EI32_V_MF2_M1_MASK,
          6092 => Opcode::PseudoVLUXSEG5EI32_V_MF2_MF2,
          6093 => Opcode::PseudoVLUXSEG5EI32_V_MF2_MF2_MASK,
          6094 => Opcode::PseudoVLUXSEG5EI32_V_MF2_MF4,
          6095 => Opcode::PseudoVLUXSEG5EI32_V_MF2_MF4_MASK,
          6096 => Opcode::PseudoVLUXSEG5EI32_V_MF2_MF8,
          6097 => Opcode::PseudoVLUXSEG5EI32_V_MF2_MF8_MASK,
          6098 => Opcode::PseudoVLUXSEG5EI64_V_M1_M1,
          6099 => Opcode::PseudoVLUXSEG5EI64_V_M1_M1_MASK,
          6100 => Opcode::PseudoVLUXSEG5EI64_V_M1_MF2,
          6101 => Opcode::PseudoVLUXSEG5EI64_V_M1_MF2_MASK,
          6102 => Opcode::PseudoVLUXSEG5EI64_V_M1_MF4,
          6103 => Opcode::PseudoVLUXSEG5EI64_V_M1_MF4_MASK,
          6104 => Opcode::PseudoVLUXSEG5EI64_V_M1_MF8,
          6105 => Opcode::PseudoVLUXSEG5EI64_V_M1_MF8_MASK,
          6106 => Opcode::PseudoVLUXSEG5EI64_V_M2_M1,
          6107 => Opcode::PseudoVLUXSEG5EI64_V_M2_M1_MASK,
          6108 => Opcode::PseudoVLUXSEG5EI64_V_M2_MF2,
          6109 => Opcode::PseudoVLUXSEG5EI64_V_M2_MF2_MASK,
          6110 => Opcode::PseudoVLUXSEG5EI64_V_M2_MF4,
          6111 => Opcode::PseudoVLUXSEG5EI64_V_M2_MF4_MASK,
          6112 => Opcode::PseudoVLUXSEG5EI64_V_M4_M1,
          6113 => Opcode::PseudoVLUXSEG5EI64_V_M4_M1_MASK,
          6114 => Opcode::PseudoVLUXSEG5EI64_V_M4_MF2,
          6115 => Opcode::PseudoVLUXSEG5EI64_V_M4_MF2_MASK,
          6116 => Opcode::PseudoVLUXSEG5EI64_V_M8_M1,
          6117 => Opcode::PseudoVLUXSEG5EI64_V_M8_M1_MASK,
          6118 => Opcode::PseudoVLUXSEG5EI8_V_M1_M1,
          6119 => Opcode::PseudoVLUXSEG5EI8_V_M1_M1_MASK,
          6120 => Opcode::PseudoVLUXSEG5EI8_V_MF2_M1,
          6121 => Opcode::PseudoVLUXSEG5EI8_V_MF2_M1_MASK,
          6122 => Opcode::PseudoVLUXSEG5EI8_V_MF2_MF2,
          6123 => Opcode::PseudoVLUXSEG5EI8_V_MF2_MF2_MASK,
          6124 => Opcode::PseudoVLUXSEG5EI8_V_MF4_M1,
          6125 => Opcode::PseudoVLUXSEG5EI8_V_MF4_M1_MASK,
          6126 => Opcode::PseudoVLUXSEG5EI8_V_MF4_MF2,
          6127 => Opcode::PseudoVLUXSEG5EI8_V_MF4_MF2_MASK,
          6128 => Opcode::PseudoVLUXSEG5EI8_V_MF4_MF4,
          6129 => Opcode::PseudoVLUXSEG5EI8_V_MF4_MF4_MASK,
          6130 => Opcode::PseudoVLUXSEG5EI8_V_MF8_M1,
          6131 => Opcode::PseudoVLUXSEG5EI8_V_MF8_M1_MASK,
          6132 => Opcode::PseudoVLUXSEG5EI8_V_MF8_MF2,
          6133 => Opcode::PseudoVLUXSEG5EI8_V_MF8_MF2_MASK,
          6134 => Opcode::PseudoVLUXSEG5EI8_V_MF8_MF4,
          6135 => Opcode::PseudoVLUXSEG5EI8_V_MF8_MF4_MASK,
          6136 => Opcode::PseudoVLUXSEG5EI8_V_MF8_MF8,
          6137 => Opcode::PseudoVLUXSEG5EI8_V_MF8_MF8_MASK,
          6138 => Opcode::PseudoVLUXSEG6EI16_V_M1_M1,
          6139 => Opcode::PseudoVLUXSEG6EI16_V_M1_M1_MASK,
          6140 => Opcode::PseudoVLUXSEG6EI16_V_M1_MF2,
          6141 => Opcode::PseudoVLUXSEG6EI16_V_M1_MF2_MASK,
          6142 => Opcode::PseudoVLUXSEG6EI16_V_M2_M1,
          6143 => Opcode::PseudoVLUXSEG6EI16_V_M2_M1_MASK,
          6144 => Opcode::PseudoVLUXSEG6EI16_V_MF2_M1,
          6145 => Opcode::PseudoVLUXSEG6EI16_V_MF2_M1_MASK,
          6146 => Opcode::PseudoVLUXSEG6EI16_V_MF2_MF2,
          6147 => Opcode::PseudoVLUXSEG6EI16_V_MF2_MF2_MASK,
          6148 => Opcode::PseudoVLUXSEG6EI16_V_MF2_MF4,
          6149 => Opcode::PseudoVLUXSEG6EI16_V_MF2_MF4_MASK,
          6150 => Opcode::PseudoVLUXSEG6EI16_V_MF4_M1,
          6151 => Opcode::PseudoVLUXSEG6EI16_V_MF4_M1_MASK,
          6152 => Opcode::PseudoVLUXSEG6EI16_V_MF4_MF2,
          6153 => Opcode::PseudoVLUXSEG6EI16_V_MF4_MF2_MASK,
          6154 => Opcode::PseudoVLUXSEG6EI16_V_MF4_MF4,
          6155 => Opcode::PseudoVLUXSEG6EI16_V_MF4_MF4_MASK,
          6156 => Opcode::PseudoVLUXSEG6EI16_V_MF4_MF8,
          6157 => Opcode::PseudoVLUXSEG6EI16_V_MF4_MF8_MASK,
          6158 => Opcode::PseudoVLUXSEG6EI32_V_M1_M1,
          6159 => Opcode::PseudoVLUXSEG6EI32_V_M1_M1_MASK,
          6160 => Opcode::PseudoVLUXSEG6EI32_V_M1_MF2,
          6161 => Opcode::PseudoVLUXSEG6EI32_V_M1_MF2_MASK,
          6162 => Opcode::PseudoVLUXSEG6EI32_V_M1_MF4,
          6163 => Opcode::PseudoVLUXSEG6EI32_V_M1_MF4_MASK,
          6164 => Opcode::PseudoVLUXSEG6EI32_V_M2_M1,
          6165 => Opcode::PseudoVLUXSEG6EI32_V_M2_M1_MASK,
          6166 => Opcode::PseudoVLUXSEG6EI32_V_M2_MF2,
          6167 => Opcode::PseudoVLUXSEG6EI32_V_M2_MF2_MASK,
          6168 => Opcode::PseudoVLUXSEG6EI32_V_M4_M1,
          6169 => Opcode::PseudoVLUXSEG6EI32_V_M4_M1_MASK,
          6170 => Opcode::PseudoVLUXSEG6EI32_V_MF2_M1,
          6171 => Opcode::PseudoVLUXSEG6EI32_V_MF2_M1_MASK,
          6172 => Opcode::PseudoVLUXSEG6EI32_V_MF2_MF2,
          6173 => Opcode::PseudoVLUXSEG6EI32_V_MF2_MF2_MASK,
          6174 => Opcode::PseudoVLUXSEG6EI32_V_MF2_MF4,
          6175 => Opcode::PseudoVLUXSEG6EI32_V_MF2_MF4_MASK,
          6176 => Opcode::PseudoVLUXSEG6EI32_V_MF2_MF8,
          6177 => Opcode::PseudoVLUXSEG6EI32_V_MF2_MF8_MASK,
          6178 => Opcode::PseudoVLUXSEG6EI64_V_M1_M1,
          6179 => Opcode::PseudoVLUXSEG6EI64_V_M1_M1_MASK,
          6180 => Opcode::PseudoVLUXSEG6EI64_V_M1_MF2,
          6181 => Opcode::PseudoVLUXSEG6EI64_V_M1_MF2_MASK,
          6182 => Opcode::PseudoVLUXSEG6EI64_V_M1_MF4,
          6183 => Opcode::PseudoVLUXSEG6EI64_V_M1_MF4_MASK,
          6184 => Opcode::PseudoVLUXSEG6EI64_V_M1_MF8,
          6185 => Opcode::PseudoVLUXSEG6EI64_V_M1_MF8_MASK,
          6186 => Opcode::PseudoVLUXSEG6EI64_V_M2_M1,
          6187 => Opcode::PseudoVLUXSEG6EI64_V_M2_M1_MASK,
          6188 => Opcode::PseudoVLUXSEG6EI64_V_M2_MF2,
          6189 => Opcode::PseudoVLUXSEG6EI64_V_M2_MF2_MASK,
          6190 => Opcode::PseudoVLUXSEG6EI64_V_M2_MF4,
          6191 => Opcode::PseudoVLUXSEG6EI64_V_M2_MF4_MASK,
          6192 => Opcode::PseudoVLUXSEG6EI64_V_M4_M1,
          6193 => Opcode::PseudoVLUXSEG6EI64_V_M4_M1_MASK,
          6194 => Opcode::PseudoVLUXSEG6EI64_V_M4_MF2,
          6195 => Opcode::PseudoVLUXSEG6EI64_V_M4_MF2_MASK,
          6196 => Opcode::PseudoVLUXSEG6EI64_V_M8_M1,
          6197 => Opcode::PseudoVLUXSEG6EI64_V_M8_M1_MASK,
          6198 => Opcode::PseudoVLUXSEG6EI8_V_M1_M1,
          6199 => Opcode::PseudoVLUXSEG6EI8_V_M1_M1_MASK,
          6200 => Opcode::PseudoVLUXSEG6EI8_V_MF2_M1,
          6201 => Opcode::PseudoVLUXSEG6EI8_V_MF2_M1_MASK,
          6202 => Opcode::PseudoVLUXSEG6EI8_V_MF2_MF2,
          6203 => Opcode::PseudoVLUXSEG6EI8_V_MF2_MF2_MASK,
          6204 => Opcode::PseudoVLUXSEG6EI8_V_MF4_M1,
          6205 => Opcode::PseudoVLUXSEG6EI8_V_MF4_M1_MASK,
          6206 => Opcode::PseudoVLUXSEG6EI8_V_MF4_MF2,
          6207 => Opcode::PseudoVLUXSEG6EI8_V_MF4_MF2_MASK,
          6208 => Opcode::PseudoVLUXSEG6EI8_V_MF4_MF4,
          6209 => Opcode::PseudoVLUXSEG6EI8_V_MF4_MF4_MASK,
          6210 => Opcode::PseudoVLUXSEG6EI8_V_MF8_M1,
          6211 => Opcode::PseudoVLUXSEG6EI8_V_MF8_M1_MASK,
          6212 => Opcode::PseudoVLUXSEG6EI8_V_MF8_MF2,
          6213 => Opcode::PseudoVLUXSEG6EI8_V_MF8_MF2_MASK,
          6214 => Opcode::PseudoVLUXSEG6EI8_V_MF8_MF4,
          6215 => Opcode::PseudoVLUXSEG6EI8_V_MF8_MF4_MASK,
          6216 => Opcode::PseudoVLUXSEG6EI8_V_MF8_MF8,
          6217 => Opcode::PseudoVLUXSEG6EI8_V_MF8_MF8_MASK,
          6218 => Opcode::PseudoVLUXSEG7EI16_V_M1_M1,
          6219 => Opcode::PseudoVLUXSEG7EI16_V_M1_M1_MASK,
          6220 => Opcode::PseudoVLUXSEG7EI16_V_M1_MF2,
          6221 => Opcode::PseudoVLUXSEG7EI16_V_M1_MF2_MASK,
          6222 => Opcode::PseudoVLUXSEG7EI16_V_M2_M1,
          6223 => Opcode::PseudoVLUXSEG7EI16_V_M2_M1_MASK,
          6224 => Opcode::PseudoVLUXSEG7EI16_V_MF2_M1,
          6225 => Opcode::PseudoVLUXSEG7EI16_V_MF2_M1_MASK,
          6226 => Opcode::PseudoVLUXSEG7EI16_V_MF2_MF2,
          6227 => Opcode::PseudoVLUXSEG7EI16_V_MF2_MF2_MASK,
          6228 => Opcode::PseudoVLUXSEG7EI16_V_MF2_MF4,
          6229 => Opcode::PseudoVLUXSEG7EI16_V_MF2_MF4_MASK,
          6230 => Opcode::PseudoVLUXSEG7EI16_V_MF4_M1,
          6231 => Opcode::PseudoVLUXSEG7EI16_V_MF4_M1_MASK,
          6232 => Opcode::PseudoVLUXSEG7EI16_V_MF4_MF2,
          6233 => Opcode::PseudoVLUXSEG7EI16_V_MF4_MF2_MASK,
          6234 => Opcode::PseudoVLUXSEG7EI16_V_MF4_MF4,
          6235 => Opcode::PseudoVLUXSEG7EI16_V_MF4_MF4_MASK,
          6236 => Opcode::PseudoVLUXSEG7EI16_V_MF4_MF8,
          6237 => Opcode::PseudoVLUXSEG7EI16_V_MF4_MF8_MASK,
          6238 => Opcode::PseudoVLUXSEG7EI32_V_M1_M1,
          6239 => Opcode::PseudoVLUXSEG7EI32_V_M1_M1_MASK,
          6240 => Opcode::PseudoVLUXSEG7EI32_V_M1_MF2,
          6241 => Opcode::PseudoVLUXSEG7EI32_V_M1_MF2_MASK,
          6242 => Opcode::PseudoVLUXSEG7EI32_V_M1_MF4,
          6243 => Opcode::PseudoVLUXSEG7EI32_V_M1_MF4_MASK,
          6244 => Opcode::PseudoVLUXSEG7EI32_V_M2_M1,
          6245 => Opcode::PseudoVLUXSEG7EI32_V_M2_M1_MASK,
          6246 => Opcode::PseudoVLUXSEG7EI32_V_M2_MF2,
          6247 => Opcode::PseudoVLUXSEG7EI32_V_M2_MF2_MASK,
          6248 => Opcode::PseudoVLUXSEG7EI32_V_M4_M1,
          6249 => Opcode::PseudoVLUXSEG7EI32_V_M4_M1_MASK,
          6250 => Opcode::PseudoVLUXSEG7EI32_V_MF2_M1,
          6251 => Opcode::PseudoVLUXSEG7EI32_V_MF2_M1_MASK,
          6252 => Opcode::PseudoVLUXSEG7EI32_V_MF2_MF2,
          6253 => Opcode::PseudoVLUXSEG7EI32_V_MF2_MF2_MASK,
          6254 => Opcode::PseudoVLUXSEG7EI32_V_MF2_MF4,
          6255 => Opcode::PseudoVLUXSEG7EI32_V_MF2_MF4_MASK,
          6256 => Opcode::PseudoVLUXSEG7EI32_V_MF2_MF8,
          6257 => Opcode::PseudoVLUXSEG7EI32_V_MF2_MF8_MASK,
          6258 => Opcode::PseudoVLUXSEG7EI64_V_M1_M1,
          6259 => Opcode::PseudoVLUXSEG7EI64_V_M1_M1_MASK,
          6260 => Opcode::PseudoVLUXSEG7EI64_V_M1_MF2,
          6261 => Opcode::PseudoVLUXSEG7EI64_V_M1_MF2_MASK,
          6262 => Opcode::PseudoVLUXSEG7EI64_V_M1_MF4,
          6263 => Opcode::PseudoVLUXSEG7EI64_V_M1_MF4_MASK,
          6264 => Opcode::PseudoVLUXSEG7EI64_V_M1_MF8,
          6265 => Opcode::PseudoVLUXSEG7EI64_V_M1_MF8_MASK,
          6266 => Opcode::PseudoVLUXSEG7EI64_V_M2_M1,
          6267 => Opcode::PseudoVLUXSEG7EI64_V_M2_M1_MASK,
          6268 => Opcode::PseudoVLUXSEG7EI64_V_M2_MF2,
          6269 => Opcode::PseudoVLUXSEG7EI64_V_M2_MF2_MASK,
          6270 => Opcode::PseudoVLUXSEG7EI64_V_M2_MF4,
          6271 => Opcode::PseudoVLUXSEG7EI64_V_M2_MF4_MASK,
          6272 => Opcode::PseudoVLUXSEG7EI64_V_M4_M1,
          6273 => Opcode::PseudoVLUXSEG7EI64_V_M4_M1_MASK,
          6274 => Opcode::PseudoVLUXSEG7EI64_V_M4_MF2,
          6275 => Opcode::PseudoVLUXSEG7EI64_V_M4_MF2_MASK,
          6276 => Opcode::PseudoVLUXSEG7EI64_V_M8_M1,
          6277 => Opcode::PseudoVLUXSEG7EI64_V_M8_M1_MASK,
          6278 => Opcode::PseudoVLUXSEG7EI8_V_M1_M1,
          6279 => Opcode::PseudoVLUXSEG7EI8_V_M1_M1_MASK,
          6280 => Opcode::PseudoVLUXSEG7EI8_V_MF2_M1,
          6281 => Opcode::PseudoVLUXSEG7EI8_V_MF2_M1_MASK,
          6282 => Opcode::PseudoVLUXSEG7EI8_V_MF2_MF2,
          6283 => Opcode::PseudoVLUXSEG7EI8_V_MF2_MF2_MASK,
          6284 => Opcode::PseudoVLUXSEG7EI8_V_MF4_M1,
          6285 => Opcode::PseudoVLUXSEG7EI8_V_MF4_M1_MASK,
          6286 => Opcode::PseudoVLUXSEG7EI8_V_MF4_MF2,
          6287 => Opcode::PseudoVLUXSEG7EI8_V_MF4_MF2_MASK,
          6288 => Opcode::PseudoVLUXSEG7EI8_V_MF4_MF4,
          6289 => Opcode::PseudoVLUXSEG7EI8_V_MF4_MF4_MASK,
          6290 => Opcode::PseudoVLUXSEG7EI8_V_MF8_M1,
          6291 => Opcode::PseudoVLUXSEG7EI8_V_MF8_M1_MASK,
          6292 => Opcode::PseudoVLUXSEG7EI8_V_MF8_MF2,
          6293 => Opcode::PseudoVLUXSEG7EI8_V_MF8_MF2_MASK,
          6294 => Opcode::PseudoVLUXSEG7EI8_V_MF8_MF4,
          6295 => Opcode::PseudoVLUXSEG7EI8_V_MF8_MF4_MASK,
          6296 => Opcode::PseudoVLUXSEG7EI8_V_MF8_MF8,
          6297 => Opcode::PseudoVLUXSEG7EI8_V_MF8_MF8_MASK,
          6298 => Opcode::PseudoVLUXSEG8EI16_V_M1_M1,
          6299 => Opcode::PseudoVLUXSEG8EI16_V_M1_M1_MASK,
          6300 => Opcode::PseudoVLUXSEG8EI16_V_M1_MF2,
          6301 => Opcode::PseudoVLUXSEG8EI16_V_M1_MF2_MASK,
          6302 => Opcode::PseudoVLUXSEG8EI16_V_M2_M1,
          6303 => Opcode::PseudoVLUXSEG8EI16_V_M2_M1_MASK,
          6304 => Opcode::PseudoVLUXSEG8EI16_V_MF2_M1,
          6305 => Opcode::PseudoVLUXSEG8EI16_V_MF2_M1_MASK,
          6306 => Opcode::PseudoVLUXSEG8EI16_V_MF2_MF2,
          6307 => Opcode::PseudoVLUXSEG8EI16_V_MF2_MF2_MASK,
          6308 => Opcode::PseudoVLUXSEG8EI16_V_MF2_MF4,
          6309 => Opcode::PseudoVLUXSEG8EI16_V_MF2_MF4_MASK,
          6310 => Opcode::PseudoVLUXSEG8EI16_V_MF4_M1,
          6311 => Opcode::PseudoVLUXSEG8EI16_V_MF4_M1_MASK,
          6312 => Opcode::PseudoVLUXSEG8EI16_V_MF4_MF2,
          6313 => Opcode::PseudoVLUXSEG8EI16_V_MF4_MF2_MASK,
          6314 => Opcode::PseudoVLUXSEG8EI16_V_MF4_MF4,
          6315 => Opcode::PseudoVLUXSEG8EI16_V_MF4_MF4_MASK,
          6316 => Opcode::PseudoVLUXSEG8EI16_V_MF4_MF8,
          6317 => Opcode::PseudoVLUXSEG8EI16_V_MF4_MF8_MASK,
          6318 => Opcode::PseudoVLUXSEG8EI32_V_M1_M1,
          6319 => Opcode::PseudoVLUXSEG8EI32_V_M1_M1_MASK,
          6320 => Opcode::PseudoVLUXSEG8EI32_V_M1_MF2,
          6321 => Opcode::PseudoVLUXSEG8EI32_V_M1_MF2_MASK,
          6322 => Opcode::PseudoVLUXSEG8EI32_V_M1_MF4,
          6323 => Opcode::PseudoVLUXSEG8EI32_V_M1_MF4_MASK,
          6324 => Opcode::PseudoVLUXSEG8EI32_V_M2_M1,
          6325 => Opcode::PseudoVLUXSEG8EI32_V_M2_M1_MASK,
          6326 => Opcode::PseudoVLUXSEG8EI32_V_M2_MF2,
          6327 => Opcode::PseudoVLUXSEG8EI32_V_M2_MF2_MASK,
          6328 => Opcode::PseudoVLUXSEG8EI32_V_M4_M1,
          6329 => Opcode::PseudoVLUXSEG8EI32_V_M4_M1_MASK,
          6330 => Opcode::PseudoVLUXSEG8EI32_V_MF2_M1,
          6331 => Opcode::PseudoVLUXSEG8EI32_V_MF2_M1_MASK,
          6332 => Opcode::PseudoVLUXSEG8EI32_V_MF2_MF2,
          6333 => Opcode::PseudoVLUXSEG8EI32_V_MF2_MF2_MASK,
          6334 => Opcode::PseudoVLUXSEG8EI32_V_MF2_MF4,
          6335 => Opcode::PseudoVLUXSEG8EI32_V_MF2_MF4_MASK,
          6336 => Opcode::PseudoVLUXSEG8EI32_V_MF2_MF8,
          6337 => Opcode::PseudoVLUXSEG8EI32_V_MF2_MF8_MASK,
          6338 => Opcode::PseudoVLUXSEG8EI64_V_M1_M1,
          6339 => Opcode::PseudoVLUXSEG8EI64_V_M1_M1_MASK,
          6340 => Opcode::PseudoVLUXSEG8EI64_V_M1_MF2,
          6341 => Opcode::PseudoVLUXSEG8EI64_V_M1_MF2_MASK,
          6342 => Opcode::PseudoVLUXSEG8EI64_V_M1_MF4,
          6343 => Opcode::PseudoVLUXSEG8EI64_V_M1_MF4_MASK,
          6344 => Opcode::PseudoVLUXSEG8EI64_V_M1_MF8,
          6345 => Opcode::PseudoVLUXSEG8EI64_V_M1_MF8_MASK,
          6346 => Opcode::PseudoVLUXSEG8EI64_V_M2_M1,
          6347 => Opcode::PseudoVLUXSEG8EI64_V_M2_M1_MASK,
          6348 => Opcode::PseudoVLUXSEG8EI64_V_M2_MF2,
          6349 => Opcode::PseudoVLUXSEG8EI64_V_M2_MF2_MASK,
          6350 => Opcode::PseudoVLUXSEG8EI64_V_M2_MF4,
          6351 => Opcode::PseudoVLUXSEG8EI64_V_M2_MF4_MASK,
          6352 => Opcode::PseudoVLUXSEG8EI64_V_M4_M1,
          6353 => Opcode::PseudoVLUXSEG8EI64_V_M4_M1_MASK,
          6354 => Opcode::PseudoVLUXSEG8EI64_V_M4_MF2,
          6355 => Opcode::PseudoVLUXSEG8EI64_V_M4_MF2_MASK,
          6356 => Opcode::PseudoVLUXSEG8EI64_V_M8_M1,
          6357 => Opcode::PseudoVLUXSEG8EI64_V_M8_M1_MASK,
          6358 => Opcode::PseudoVLUXSEG8EI8_V_M1_M1,
          6359 => Opcode::PseudoVLUXSEG8EI8_V_M1_M1_MASK,
          6360 => Opcode::PseudoVLUXSEG8EI8_V_MF2_M1,
          6361 => Opcode::PseudoVLUXSEG8EI8_V_MF2_M1_MASK,
          6362 => Opcode::PseudoVLUXSEG8EI8_V_MF2_MF2,
          6363 => Opcode::PseudoVLUXSEG8EI8_V_MF2_MF2_MASK,
          6364 => Opcode::PseudoVLUXSEG8EI8_V_MF4_M1,
          6365 => Opcode::PseudoVLUXSEG8EI8_V_MF4_M1_MASK,
          6366 => Opcode::PseudoVLUXSEG8EI8_V_MF4_MF2,
          6367 => Opcode::PseudoVLUXSEG8EI8_V_MF4_MF2_MASK,
          6368 => Opcode::PseudoVLUXSEG8EI8_V_MF4_MF4,
          6369 => Opcode::PseudoVLUXSEG8EI8_V_MF4_MF4_MASK,
          6370 => Opcode::PseudoVLUXSEG8EI8_V_MF8_M1,
          6371 => Opcode::PseudoVLUXSEG8EI8_V_MF8_M1_MASK,
          6372 => Opcode::PseudoVLUXSEG8EI8_V_MF8_MF2,
          6373 => Opcode::PseudoVLUXSEG8EI8_V_MF8_MF2_MASK,
          6374 => Opcode::PseudoVLUXSEG8EI8_V_MF8_MF4,
          6375 => Opcode::PseudoVLUXSEG8EI8_V_MF8_MF4_MASK,
          6376 => Opcode::PseudoVLUXSEG8EI8_V_MF8_MF8,
          6377 => Opcode::PseudoVLUXSEG8EI8_V_MF8_MF8_MASK,
          6378 => Opcode::PseudoVMACC_VV_M1,
          6379 => Opcode::PseudoVMACC_VV_M1_MASK,
          6380 => Opcode::PseudoVMACC_VV_M2,
          6381 => Opcode::PseudoVMACC_VV_M2_MASK,
          6382 => Opcode::PseudoVMACC_VV_M4,
          6383 => Opcode::PseudoVMACC_VV_M4_MASK,
          6384 => Opcode::PseudoVMACC_VV_M8,
          6385 => Opcode::PseudoVMACC_VV_M8_MASK,
          6386 => Opcode::PseudoVMACC_VV_MF2,
          6387 => Opcode::PseudoVMACC_VV_MF2_MASK,
          6388 => Opcode::PseudoVMACC_VV_MF4,
          6389 => Opcode::PseudoVMACC_VV_MF4_MASK,
          6390 => Opcode::PseudoVMACC_VV_MF8,
          6391 => Opcode::PseudoVMACC_VV_MF8_MASK,
          6392 => Opcode::PseudoVMACC_VX_M1,
          6393 => Opcode::PseudoVMACC_VX_M1_MASK,
          6394 => Opcode::PseudoVMACC_VX_M2,
          6395 => Opcode::PseudoVMACC_VX_M2_MASK,
          6396 => Opcode::PseudoVMACC_VX_M4,
          6397 => Opcode::PseudoVMACC_VX_M4_MASK,
          6398 => Opcode::PseudoVMACC_VX_M8,
          6399 => Opcode::PseudoVMACC_VX_M8_MASK,
          6400 => Opcode::PseudoVMACC_VX_MF2,
          6401 => Opcode::PseudoVMACC_VX_MF2_MASK,
          6402 => Opcode::PseudoVMACC_VX_MF4,
          6403 => Opcode::PseudoVMACC_VX_MF4_MASK,
          6404 => Opcode::PseudoVMACC_VX_MF8,
          6405 => Opcode::PseudoVMACC_VX_MF8_MASK,
          6406 => Opcode::PseudoVMADC_VIM_M1,
          6407 => Opcode::PseudoVMADC_VIM_M2,
          6408 => Opcode::PseudoVMADC_VIM_M4,
          6409 => Opcode::PseudoVMADC_VIM_M8,
          6410 => Opcode::PseudoVMADC_VIM_MF2,
          6411 => Opcode::PseudoVMADC_VIM_MF4,
          6412 => Opcode::PseudoVMADC_VIM_MF8,
          6413 => Opcode::PseudoVMADC_VI_M1,
          6414 => Opcode::PseudoVMADC_VI_M2,
          6415 => Opcode::PseudoVMADC_VI_M4,
          6416 => Opcode::PseudoVMADC_VI_M8,
          6417 => Opcode::PseudoVMADC_VI_MF2,
          6418 => Opcode::PseudoVMADC_VI_MF4,
          6419 => Opcode::PseudoVMADC_VI_MF8,
          6420 => Opcode::PseudoVMADC_VVM_M1,
          6421 => Opcode::PseudoVMADC_VVM_M2,
          6422 => Opcode::PseudoVMADC_VVM_M4,
          6423 => Opcode::PseudoVMADC_VVM_M8,
          6424 => Opcode::PseudoVMADC_VVM_MF2,
          6425 => Opcode::PseudoVMADC_VVM_MF4,
          6426 => Opcode::PseudoVMADC_VVM_MF8,
          6427 => Opcode::PseudoVMADC_VV_M1,
          6428 => Opcode::PseudoVMADC_VV_M2,
          6429 => Opcode::PseudoVMADC_VV_M4,
          6430 => Opcode::PseudoVMADC_VV_M8,
          6431 => Opcode::PseudoVMADC_VV_MF2,
          6432 => Opcode::PseudoVMADC_VV_MF4,
          6433 => Opcode::PseudoVMADC_VV_MF8,
          6434 => Opcode::PseudoVMADC_VXM_M1,
          6435 => Opcode::PseudoVMADC_VXM_M2,
          6436 => Opcode::PseudoVMADC_VXM_M4,
          6437 => Opcode::PseudoVMADC_VXM_M8,
          6438 => Opcode::PseudoVMADC_VXM_MF2,
          6439 => Opcode::PseudoVMADC_VXM_MF4,
          6440 => Opcode::PseudoVMADC_VXM_MF8,
          6441 => Opcode::PseudoVMADC_VX_M1,
          6442 => Opcode::PseudoVMADC_VX_M2,
          6443 => Opcode::PseudoVMADC_VX_M4,
          6444 => Opcode::PseudoVMADC_VX_M8,
          6445 => Opcode::PseudoVMADC_VX_MF2,
          6446 => Opcode::PseudoVMADC_VX_MF4,
          6447 => Opcode::PseudoVMADC_VX_MF8,
          6448 => Opcode::PseudoVMADD_VV_M1,
          6449 => Opcode::PseudoVMADD_VV_M1_MASK,
          6450 => Opcode::PseudoVMADD_VV_M2,
          6451 => Opcode::PseudoVMADD_VV_M2_MASK,
          6452 => Opcode::PseudoVMADD_VV_M4,
          6453 => Opcode::PseudoVMADD_VV_M4_MASK,
          6454 => Opcode::PseudoVMADD_VV_M8,
          6455 => Opcode::PseudoVMADD_VV_M8_MASK,
          6456 => Opcode::PseudoVMADD_VV_MF2,
          6457 => Opcode::PseudoVMADD_VV_MF2_MASK,
          6458 => Opcode::PseudoVMADD_VV_MF4,
          6459 => Opcode::PseudoVMADD_VV_MF4_MASK,
          6460 => Opcode::PseudoVMADD_VV_MF8,
          6461 => Opcode::PseudoVMADD_VV_MF8_MASK,
          6462 => Opcode::PseudoVMADD_VX_M1,
          6463 => Opcode::PseudoVMADD_VX_M1_MASK,
          6464 => Opcode::PseudoVMADD_VX_M2,
          6465 => Opcode::PseudoVMADD_VX_M2_MASK,
          6466 => Opcode::PseudoVMADD_VX_M4,
          6467 => Opcode::PseudoVMADD_VX_M4_MASK,
          6468 => Opcode::PseudoVMADD_VX_M8,
          6469 => Opcode::PseudoVMADD_VX_M8_MASK,
          6470 => Opcode::PseudoVMADD_VX_MF2,
          6471 => Opcode::PseudoVMADD_VX_MF2_MASK,
          6472 => Opcode::PseudoVMADD_VX_MF4,
          6473 => Opcode::PseudoVMADD_VX_MF4_MASK,
          6474 => Opcode::PseudoVMADD_VX_MF8,
          6475 => Opcode::PseudoVMADD_VX_MF8_MASK,
          6476 => Opcode::PseudoVMANDN_MM_M1,
          6477 => Opcode::PseudoVMANDN_MM_M2,
          6478 => Opcode::PseudoVMANDN_MM_M4,
          6479 => Opcode::PseudoVMANDN_MM_M8,
          6480 => Opcode::PseudoVMANDN_MM_MF2,
          6481 => Opcode::PseudoVMANDN_MM_MF4,
          6482 => Opcode::PseudoVMANDN_MM_MF8,
          6483 => Opcode::PseudoVMAND_MM_M1,
          6484 => Opcode::PseudoVMAND_MM_M2,
          6485 => Opcode::PseudoVMAND_MM_M4,
          6486 => Opcode::PseudoVMAND_MM_M8,
          6487 => Opcode::PseudoVMAND_MM_MF2,
          6488 => Opcode::PseudoVMAND_MM_MF4,
          6489 => Opcode::PseudoVMAND_MM_MF8,
          6490 => Opcode::PseudoVMAXU_VV_M1,
          6491 => Opcode::PseudoVMAXU_VV_M1_MASK,
          6492 => Opcode::PseudoVMAXU_VV_M2,
          6493 => Opcode::PseudoVMAXU_VV_M2_MASK,
          6494 => Opcode::PseudoVMAXU_VV_M4,
          6495 => Opcode::PseudoVMAXU_VV_M4_MASK,
          6496 => Opcode::PseudoVMAXU_VV_M8,
          6497 => Opcode::PseudoVMAXU_VV_M8_MASK,
          6498 => Opcode::PseudoVMAXU_VV_MF2,
          6499 => Opcode::PseudoVMAXU_VV_MF2_MASK,
          6500 => Opcode::PseudoVMAXU_VV_MF4,
          6501 => Opcode::PseudoVMAXU_VV_MF4_MASK,
          6502 => Opcode::PseudoVMAXU_VV_MF8,
          6503 => Opcode::PseudoVMAXU_VV_MF8_MASK,
          6504 => Opcode::PseudoVMAXU_VX_M1,
          6505 => Opcode::PseudoVMAXU_VX_M1_MASK,
          6506 => Opcode::PseudoVMAXU_VX_M2,
          6507 => Opcode::PseudoVMAXU_VX_M2_MASK,
          6508 => Opcode::PseudoVMAXU_VX_M4,
          6509 => Opcode::PseudoVMAXU_VX_M4_MASK,
          6510 => Opcode::PseudoVMAXU_VX_M8,
          6511 => Opcode::PseudoVMAXU_VX_M8_MASK,
          6512 => Opcode::PseudoVMAXU_VX_MF2,
          6513 => Opcode::PseudoVMAXU_VX_MF2_MASK,
          6514 => Opcode::PseudoVMAXU_VX_MF4,
          6515 => Opcode::PseudoVMAXU_VX_MF4_MASK,
          6516 => Opcode::PseudoVMAXU_VX_MF8,
          6517 => Opcode::PseudoVMAXU_VX_MF8_MASK,
          6518 => Opcode::PseudoVMAX_VV_M1,
          6519 => Opcode::PseudoVMAX_VV_M1_MASK,
          6520 => Opcode::PseudoVMAX_VV_M2,
          6521 => Opcode::PseudoVMAX_VV_M2_MASK,
          6522 => Opcode::PseudoVMAX_VV_M4,
          6523 => Opcode::PseudoVMAX_VV_M4_MASK,
          6524 => Opcode::PseudoVMAX_VV_M8,
          6525 => Opcode::PseudoVMAX_VV_M8_MASK,
          6526 => Opcode::PseudoVMAX_VV_MF2,
          6527 => Opcode::PseudoVMAX_VV_MF2_MASK,
          6528 => Opcode::PseudoVMAX_VV_MF4,
          6529 => Opcode::PseudoVMAX_VV_MF4_MASK,
          6530 => Opcode::PseudoVMAX_VV_MF8,
          6531 => Opcode::PseudoVMAX_VV_MF8_MASK,
          6532 => Opcode::PseudoVMAX_VX_M1,
          6533 => Opcode::PseudoVMAX_VX_M1_MASK,
          6534 => Opcode::PseudoVMAX_VX_M2,
          6535 => Opcode::PseudoVMAX_VX_M2_MASK,
          6536 => Opcode::PseudoVMAX_VX_M4,
          6537 => Opcode::PseudoVMAX_VX_M4_MASK,
          6538 => Opcode::PseudoVMAX_VX_M8,
          6539 => Opcode::PseudoVMAX_VX_M8_MASK,
          6540 => Opcode::PseudoVMAX_VX_MF2,
          6541 => Opcode::PseudoVMAX_VX_MF2_MASK,
          6542 => Opcode::PseudoVMAX_VX_MF4,
          6543 => Opcode::PseudoVMAX_VX_MF4_MASK,
          6544 => Opcode::PseudoVMAX_VX_MF8,
          6545 => Opcode::PseudoVMAX_VX_MF8_MASK,
          6546 => Opcode::PseudoVMCLR_M_B1,
          6547 => Opcode::PseudoVMCLR_M_B16,
          6548 => Opcode::PseudoVMCLR_M_B2,
          6549 => Opcode::PseudoVMCLR_M_B32,
          6550 => Opcode::PseudoVMCLR_M_B4,
          6551 => Opcode::PseudoVMCLR_M_B64,
          6552 => Opcode::PseudoVMCLR_M_B8,
          6553 => Opcode::PseudoVMERGE_VIM_M1,
          6554 => Opcode::PseudoVMERGE_VIM_M2,
          6555 => Opcode::PseudoVMERGE_VIM_M4,
          6556 => Opcode::PseudoVMERGE_VIM_M8,
          6557 => Opcode::PseudoVMERGE_VIM_MF2,
          6558 => Opcode::PseudoVMERGE_VIM_MF4,
          6559 => Opcode::PseudoVMERGE_VIM_MF8,
          6560 => Opcode::PseudoVMERGE_VVM_M1,
          6561 => Opcode::PseudoVMERGE_VVM_M2,
          6562 => Opcode::PseudoVMERGE_VVM_M4,
          6563 => Opcode::PseudoVMERGE_VVM_M8,
          6564 => Opcode::PseudoVMERGE_VVM_MF2,
          6565 => Opcode::PseudoVMERGE_VVM_MF4,
          6566 => Opcode::PseudoVMERGE_VVM_MF8,
          6567 => Opcode::PseudoVMERGE_VXM_M1,
          6568 => Opcode::PseudoVMERGE_VXM_M2,
          6569 => Opcode::PseudoVMERGE_VXM_M4,
          6570 => Opcode::PseudoVMERGE_VXM_M8,
          6571 => Opcode::PseudoVMERGE_VXM_MF2,
          6572 => Opcode::PseudoVMERGE_VXM_MF4,
          6573 => Opcode::PseudoVMERGE_VXM_MF8,
          6574 => Opcode::PseudoVMFEQ_VFPR16_M1,
          6575 => Opcode::PseudoVMFEQ_VFPR16_M1_MASK,
          6576 => Opcode::PseudoVMFEQ_VFPR16_M2,
          6577 => Opcode::PseudoVMFEQ_VFPR16_M2_MASK,
          6578 => Opcode::PseudoVMFEQ_VFPR16_M4,
          6579 => Opcode::PseudoVMFEQ_VFPR16_M4_MASK,
          6580 => Opcode::PseudoVMFEQ_VFPR16_M8,
          6581 => Opcode::PseudoVMFEQ_VFPR16_M8_MASK,
          6582 => Opcode::PseudoVMFEQ_VFPR16_MF2,
          6583 => Opcode::PseudoVMFEQ_VFPR16_MF2_MASK,
          6584 => Opcode::PseudoVMFEQ_VFPR16_MF4,
          6585 => Opcode::PseudoVMFEQ_VFPR16_MF4_MASK,
          6586 => Opcode::PseudoVMFEQ_VFPR32_M1,
          6587 => Opcode::PseudoVMFEQ_VFPR32_M1_MASK,
          6588 => Opcode::PseudoVMFEQ_VFPR32_M2,
          6589 => Opcode::PseudoVMFEQ_VFPR32_M2_MASK,
          6590 => Opcode::PseudoVMFEQ_VFPR32_M4,
          6591 => Opcode::PseudoVMFEQ_VFPR32_M4_MASK,
          6592 => Opcode::PseudoVMFEQ_VFPR32_M8,
          6593 => Opcode::PseudoVMFEQ_VFPR32_M8_MASK,
          6594 => Opcode::PseudoVMFEQ_VFPR32_MF2,
          6595 => Opcode::PseudoVMFEQ_VFPR32_MF2_MASK,
          6596 => Opcode::PseudoVMFEQ_VFPR64_M1,
          6597 => Opcode::PseudoVMFEQ_VFPR64_M1_MASK,
          6598 => Opcode::PseudoVMFEQ_VFPR64_M2,
          6599 => Opcode::PseudoVMFEQ_VFPR64_M2_MASK,
          6600 => Opcode::PseudoVMFEQ_VFPR64_M4,
          6601 => Opcode::PseudoVMFEQ_VFPR64_M4_MASK,
          6602 => Opcode::PseudoVMFEQ_VFPR64_M8,
          6603 => Opcode::PseudoVMFEQ_VFPR64_M8_MASK,
          6604 => Opcode::PseudoVMFEQ_VV_M1,
          6605 => Opcode::PseudoVMFEQ_VV_M1_MASK,
          6606 => Opcode::PseudoVMFEQ_VV_M2,
          6607 => Opcode::PseudoVMFEQ_VV_M2_MASK,
          6608 => Opcode::PseudoVMFEQ_VV_M4,
          6609 => Opcode::PseudoVMFEQ_VV_M4_MASK,
          6610 => Opcode::PseudoVMFEQ_VV_M8,
          6611 => Opcode::PseudoVMFEQ_VV_M8_MASK,
          6612 => Opcode::PseudoVMFEQ_VV_MF2,
          6613 => Opcode::PseudoVMFEQ_VV_MF2_MASK,
          6614 => Opcode::PseudoVMFEQ_VV_MF4,
          6615 => Opcode::PseudoVMFEQ_VV_MF4_MASK,
          6616 => Opcode::PseudoVMFGE_VFPR16_M1,
          6617 => Opcode::PseudoVMFGE_VFPR16_M1_MASK,
          6618 => Opcode::PseudoVMFGE_VFPR16_M2,
          6619 => Opcode::PseudoVMFGE_VFPR16_M2_MASK,
          6620 => Opcode::PseudoVMFGE_VFPR16_M4,
          6621 => Opcode::PseudoVMFGE_VFPR16_M4_MASK,
          6622 => Opcode::PseudoVMFGE_VFPR16_M8,
          6623 => Opcode::PseudoVMFGE_VFPR16_M8_MASK,
          6624 => Opcode::PseudoVMFGE_VFPR16_MF2,
          6625 => Opcode::PseudoVMFGE_VFPR16_MF2_MASK,
          6626 => Opcode::PseudoVMFGE_VFPR16_MF4,
          6627 => Opcode::PseudoVMFGE_VFPR16_MF4_MASK,
          6628 => Opcode::PseudoVMFGE_VFPR32_M1,
          6629 => Opcode::PseudoVMFGE_VFPR32_M1_MASK,
          6630 => Opcode::PseudoVMFGE_VFPR32_M2,
          6631 => Opcode::PseudoVMFGE_VFPR32_M2_MASK,
          6632 => Opcode::PseudoVMFGE_VFPR32_M4,
          6633 => Opcode::PseudoVMFGE_VFPR32_M4_MASK,
          6634 => Opcode::PseudoVMFGE_VFPR32_M8,
          6635 => Opcode::PseudoVMFGE_VFPR32_M8_MASK,
          6636 => Opcode::PseudoVMFGE_VFPR32_MF2,
          6637 => Opcode::PseudoVMFGE_VFPR32_MF2_MASK,
          6638 => Opcode::PseudoVMFGE_VFPR64_M1,
          6639 => Opcode::PseudoVMFGE_VFPR64_M1_MASK,
          6640 => Opcode::PseudoVMFGE_VFPR64_M2,
          6641 => Opcode::PseudoVMFGE_VFPR64_M2_MASK,
          6642 => Opcode::PseudoVMFGE_VFPR64_M4,
          6643 => Opcode::PseudoVMFGE_VFPR64_M4_MASK,
          6644 => Opcode::PseudoVMFGE_VFPR64_M8,
          6645 => Opcode::PseudoVMFGE_VFPR64_M8_MASK,
          6646 => Opcode::PseudoVMFGT_VFPR16_M1,
          6647 => Opcode::PseudoVMFGT_VFPR16_M1_MASK,
          6648 => Opcode::PseudoVMFGT_VFPR16_M2,
          6649 => Opcode::PseudoVMFGT_VFPR16_M2_MASK,
          6650 => Opcode::PseudoVMFGT_VFPR16_M4,
          6651 => Opcode::PseudoVMFGT_VFPR16_M4_MASK,
          6652 => Opcode::PseudoVMFGT_VFPR16_M8,
          6653 => Opcode::PseudoVMFGT_VFPR16_M8_MASK,
          6654 => Opcode::PseudoVMFGT_VFPR16_MF2,
          6655 => Opcode::PseudoVMFGT_VFPR16_MF2_MASK,
          6656 => Opcode::PseudoVMFGT_VFPR16_MF4,
          6657 => Opcode::PseudoVMFGT_VFPR16_MF4_MASK,
          6658 => Opcode::PseudoVMFGT_VFPR32_M1,
          6659 => Opcode::PseudoVMFGT_VFPR32_M1_MASK,
          6660 => Opcode::PseudoVMFGT_VFPR32_M2,
          6661 => Opcode::PseudoVMFGT_VFPR32_M2_MASK,
          6662 => Opcode::PseudoVMFGT_VFPR32_M4,
          6663 => Opcode::PseudoVMFGT_VFPR32_M4_MASK,
          6664 => Opcode::PseudoVMFGT_VFPR32_M8,
          6665 => Opcode::PseudoVMFGT_VFPR32_M8_MASK,
          6666 => Opcode::PseudoVMFGT_VFPR32_MF2,
          6667 => Opcode::PseudoVMFGT_VFPR32_MF2_MASK,
          6668 => Opcode::PseudoVMFGT_VFPR64_M1,
          6669 => Opcode::PseudoVMFGT_VFPR64_M1_MASK,
          6670 => Opcode::PseudoVMFGT_VFPR64_M2,
          6671 => Opcode::PseudoVMFGT_VFPR64_M2_MASK,
          6672 => Opcode::PseudoVMFGT_VFPR64_M4,
          6673 => Opcode::PseudoVMFGT_VFPR64_M4_MASK,
          6674 => Opcode::PseudoVMFGT_VFPR64_M8,
          6675 => Opcode::PseudoVMFGT_VFPR64_M8_MASK,
          6676 => Opcode::PseudoVMFLE_VFPR16_M1,
          6677 => Opcode::PseudoVMFLE_VFPR16_M1_MASK,
          6678 => Opcode::PseudoVMFLE_VFPR16_M2,
          6679 => Opcode::PseudoVMFLE_VFPR16_M2_MASK,
          6680 => Opcode::PseudoVMFLE_VFPR16_M4,
          6681 => Opcode::PseudoVMFLE_VFPR16_M4_MASK,
          6682 => Opcode::PseudoVMFLE_VFPR16_M8,
          6683 => Opcode::PseudoVMFLE_VFPR16_M8_MASK,
          6684 => Opcode::PseudoVMFLE_VFPR16_MF2,
          6685 => Opcode::PseudoVMFLE_VFPR16_MF2_MASK,
          6686 => Opcode::PseudoVMFLE_VFPR16_MF4,
          6687 => Opcode::PseudoVMFLE_VFPR16_MF4_MASK,
          6688 => Opcode::PseudoVMFLE_VFPR32_M1,
          6689 => Opcode::PseudoVMFLE_VFPR32_M1_MASK,
          6690 => Opcode::PseudoVMFLE_VFPR32_M2,
          6691 => Opcode::PseudoVMFLE_VFPR32_M2_MASK,
          6692 => Opcode::PseudoVMFLE_VFPR32_M4,
          6693 => Opcode::PseudoVMFLE_VFPR32_M4_MASK,
          6694 => Opcode::PseudoVMFLE_VFPR32_M8,
          6695 => Opcode::PseudoVMFLE_VFPR32_M8_MASK,
          6696 => Opcode::PseudoVMFLE_VFPR32_MF2,
          6697 => Opcode::PseudoVMFLE_VFPR32_MF2_MASK,
          6698 => Opcode::PseudoVMFLE_VFPR64_M1,
          6699 => Opcode::PseudoVMFLE_VFPR64_M1_MASK,
          6700 => Opcode::PseudoVMFLE_VFPR64_M2,
          6701 => Opcode::PseudoVMFLE_VFPR64_M2_MASK,
          6702 => Opcode::PseudoVMFLE_VFPR64_M4,
          6703 => Opcode::PseudoVMFLE_VFPR64_M4_MASK,
          6704 => Opcode::PseudoVMFLE_VFPR64_M8,
          6705 => Opcode::PseudoVMFLE_VFPR64_M8_MASK,
          6706 => Opcode::PseudoVMFLE_VV_M1,
          6707 => Opcode::PseudoVMFLE_VV_M1_MASK,
          6708 => Opcode::PseudoVMFLE_VV_M2,
          6709 => Opcode::PseudoVMFLE_VV_M2_MASK,
          6710 => Opcode::PseudoVMFLE_VV_M4,
          6711 => Opcode::PseudoVMFLE_VV_M4_MASK,
          6712 => Opcode::PseudoVMFLE_VV_M8,
          6713 => Opcode::PseudoVMFLE_VV_M8_MASK,
          6714 => Opcode::PseudoVMFLE_VV_MF2,
          6715 => Opcode::PseudoVMFLE_VV_MF2_MASK,
          6716 => Opcode::PseudoVMFLE_VV_MF4,
          6717 => Opcode::PseudoVMFLE_VV_MF4_MASK,
          6718 => Opcode::PseudoVMFLT_VFPR16_M1,
          6719 => Opcode::PseudoVMFLT_VFPR16_M1_MASK,
          6720 => Opcode::PseudoVMFLT_VFPR16_M2,
          6721 => Opcode::PseudoVMFLT_VFPR16_M2_MASK,
          6722 => Opcode::PseudoVMFLT_VFPR16_M4,
          6723 => Opcode::PseudoVMFLT_VFPR16_M4_MASK,
          6724 => Opcode::PseudoVMFLT_VFPR16_M8,
          6725 => Opcode::PseudoVMFLT_VFPR16_M8_MASK,
          6726 => Opcode::PseudoVMFLT_VFPR16_MF2,
          6727 => Opcode::PseudoVMFLT_VFPR16_MF2_MASK,
          6728 => Opcode::PseudoVMFLT_VFPR16_MF4,
          6729 => Opcode::PseudoVMFLT_VFPR16_MF4_MASK,
          6730 => Opcode::PseudoVMFLT_VFPR32_M1,
          6731 => Opcode::PseudoVMFLT_VFPR32_M1_MASK,
          6732 => Opcode::PseudoVMFLT_VFPR32_M2,
          6733 => Opcode::PseudoVMFLT_VFPR32_M2_MASK,
          6734 => Opcode::PseudoVMFLT_VFPR32_M4,
          6735 => Opcode::PseudoVMFLT_VFPR32_M4_MASK,
          6736 => Opcode::PseudoVMFLT_VFPR32_M8,
          6737 => Opcode::PseudoVMFLT_VFPR32_M8_MASK,
          6738 => Opcode::PseudoVMFLT_VFPR32_MF2,
          6739 => Opcode::PseudoVMFLT_VFPR32_MF2_MASK,
          6740 => Opcode::PseudoVMFLT_VFPR64_M1,
          6741 => Opcode::PseudoVMFLT_VFPR64_M1_MASK,
          6742 => Opcode::PseudoVMFLT_VFPR64_M2,
          6743 => Opcode::PseudoVMFLT_VFPR64_M2_MASK,
          6744 => Opcode::PseudoVMFLT_VFPR64_M4,
          6745 => Opcode::PseudoVMFLT_VFPR64_M4_MASK,
          6746 => Opcode::PseudoVMFLT_VFPR64_M8,
          6747 => Opcode::PseudoVMFLT_VFPR64_M8_MASK,
          6748 => Opcode::PseudoVMFLT_VV_M1,
          6749 => Opcode::PseudoVMFLT_VV_M1_MASK,
          6750 => Opcode::PseudoVMFLT_VV_M2,
          6751 => Opcode::PseudoVMFLT_VV_M2_MASK,
          6752 => Opcode::PseudoVMFLT_VV_M4,
          6753 => Opcode::PseudoVMFLT_VV_M4_MASK,
          6754 => Opcode::PseudoVMFLT_VV_M8,
          6755 => Opcode::PseudoVMFLT_VV_M8_MASK,
          6756 => Opcode::PseudoVMFLT_VV_MF2,
          6757 => Opcode::PseudoVMFLT_VV_MF2_MASK,
          6758 => Opcode::PseudoVMFLT_VV_MF4,
          6759 => Opcode::PseudoVMFLT_VV_MF4_MASK,
          6760 => Opcode::PseudoVMFNE_VFPR16_M1,
          6761 => Opcode::PseudoVMFNE_VFPR16_M1_MASK,
          6762 => Opcode::PseudoVMFNE_VFPR16_M2,
          6763 => Opcode::PseudoVMFNE_VFPR16_M2_MASK,
          6764 => Opcode::PseudoVMFNE_VFPR16_M4,
          6765 => Opcode::PseudoVMFNE_VFPR16_M4_MASK,
          6766 => Opcode::PseudoVMFNE_VFPR16_M8,
          6767 => Opcode::PseudoVMFNE_VFPR16_M8_MASK,
          6768 => Opcode::PseudoVMFNE_VFPR16_MF2,
          6769 => Opcode::PseudoVMFNE_VFPR16_MF2_MASK,
          6770 => Opcode::PseudoVMFNE_VFPR16_MF4,
          6771 => Opcode::PseudoVMFNE_VFPR16_MF4_MASK,
          6772 => Opcode::PseudoVMFNE_VFPR32_M1,
          6773 => Opcode::PseudoVMFNE_VFPR32_M1_MASK,
          6774 => Opcode::PseudoVMFNE_VFPR32_M2,
          6775 => Opcode::PseudoVMFNE_VFPR32_M2_MASK,
          6776 => Opcode::PseudoVMFNE_VFPR32_M4,
          6777 => Opcode::PseudoVMFNE_VFPR32_M4_MASK,
          6778 => Opcode::PseudoVMFNE_VFPR32_M8,
          6779 => Opcode::PseudoVMFNE_VFPR32_M8_MASK,
          6780 => Opcode::PseudoVMFNE_VFPR32_MF2,
          6781 => Opcode::PseudoVMFNE_VFPR32_MF2_MASK,
          6782 => Opcode::PseudoVMFNE_VFPR64_M1,
          6783 => Opcode::PseudoVMFNE_VFPR64_M1_MASK,
          6784 => Opcode::PseudoVMFNE_VFPR64_M2,
          6785 => Opcode::PseudoVMFNE_VFPR64_M2_MASK,
          6786 => Opcode::PseudoVMFNE_VFPR64_M4,
          6787 => Opcode::PseudoVMFNE_VFPR64_M4_MASK,
          6788 => Opcode::PseudoVMFNE_VFPR64_M8,
          6789 => Opcode::PseudoVMFNE_VFPR64_M8_MASK,
          6790 => Opcode::PseudoVMFNE_VV_M1,
          6791 => Opcode::PseudoVMFNE_VV_M1_MASK,
          6792 => Opcode::PseudoVMFNE_VV_M2,
          6793 => Opcode::PseudoVMFNE_VV_M2_MASK,
          6794 => Opcode::PseudoVMFNE_VV_M4,
          6795 => Opcode::PseudoVMFNE_VV_M4_MASK,
          6796 => Opcode::PseudoVMFNE_VV_M8,
          6797 => Opcode::PseudoVMFNE_VV_M8_MASK,
          6798 => Opcode::PseudoVMFNE_VV_MF2,
          6799 => Opcode::PseudoVMFNE_VV_MF2_MASK,
          6800 => Opcode::PseudoVMFNE_VV_MF4,
          6801 => Opcode::PseudoVMFNE_VV_MF4_MASK,
          6802 => Opcode::PseudoVMINU_VV_M1,
          6803 => Opcode::PseudoVMINU_VV_M1_MASK,
          6804 => Opcode::PseudoVMINU_VV_M2,
          6805 => Opcode::PseudoVMINU_VV_M2_MASK,
          6806 => Opcode::PseudoVMINU_VV_M4,
          6807 => Opcode::PseudoVMINU_VV_M4_MASK,
          6808 => Opcode::PseudoVMINU_VV_M8,
          6809 => Opcode::PseudoVMINU_VV_M8_MASK,
          6810 => Opcode::PseudoVMINU_VV_MF2,
          6811 => Opcode::PseudoVMINU_VV_MF2_MASK,
          6812 => Opcode::PseudoVMINU_VV_MF4,
          6813 => Opcode::PseudoVMINU_VV_MF4_MASK,
          6814 => Opcode::PseudoVMINU_VV_MF8,
          6815 => Opcode::PseudoVMINU_VV_MF8_MASK,
          6816 => Opcode::PseudoVMINU_VX_M1,
          6817 => Opcode::PseudoVMINU_VX_M1_MASK,
          6818 => Opcode::PseudoVMINU_VX_M2,
          6819 => Opcode::PseudoVMINU_VX_M2_MASK,
          6820 => Opcode::PseudoVMINU_VX_M4,
          6821 => Opcode::PseudoVMINU_VX_M4_MASK,
          6822 => Opcode::PseudoVMINU_VX_M8,
          6823 => Opcode::PseudoVMINU_VX_M8_MASK,
          6824 => Opcode::PseudoVMINU_VX_MF2,
          6825 => Opcode::PseudoVMINU_VX_MF2_MASK,
          6826 => Opcode::PseudoVMINU_VX_MF4,
          6827 => Opcode::PseudoVMINU_VX_MF4_MASK,
          6828 => Opcode::PseudoVMINU_VX_MF8,
          6829 => Opcode::PseudoVMINU_VX_MF8_MASK,
          6830 => Opcode::PseudoVMIN_VV_M1,
          6831 => Opcode::PseudoVMIN_VV_M1_MASK,
          6832 => Opcode::PseudoVMIN_VV_M2,
          6833 => Opcode::PseudoVMIN_VV_M2_MASK,
          6834 => Opcode::PseudoVMIN_VV_M4,
          6835 => Opcode::PseudoVMIN_VV_M4_MASK,
          6836 => Opcode::PseudoVMIN_VV_M8,
          6837 => Opcode::PseudoVMIN_VV_M8_MASK,
          6838 => Opcode::PseudoVMIN_VV_MF2,
          6839 => Opcode::PseudoVMIN_VV_MF2_MASK,
          6840 => Opcode::PseudoVMIN_VV_MF4,
          6841 => Opcode::PseudoVMIN_VV_MF4_MASK,
          6842 => Opcode::PseudoVMIN_VV_MF8,
          6843 => Opcode::PseudoVMIN_VV_MF8_MASK,
          6844 => Opcode::PseudoVMIN_VX_M1,
          6845 => Opcode::PseudoVMIN_VX_M1_MASK,
          6846 => Opcode::PseudoVMIN_VX_M2,
          6847 => Opcode::PseudoVMIN_VX_M2_MASK,
          6848 => Opcode::PseudoVMIN_VX_M4,
          6849 => Opcode::PseudoVMIN_VX_M4_MASK,
          6850 => Opcode::PseudoVMIN_VX_M8,
          6851 => Opcode::PseudoVMIN_VX_M8_MASK,
          6852 => Opcode::PseudoVMIN_VX_MF2,
          6853 => Opcode::PseudoVMIN_VX_MF2_MASK,
          6854 => Opcode::PseudoVMIN_VX_MF4,
          6855 => Opcode::PseudoVMIN_VX_MF4_MASK,
          6856 => Opcode::PseudoVMIN_VX_MF8,
          6857 => Opcode::PseudoVMIN_VX_MF8_MASK,
          6858 => Opcode::PseudoVMNAND_MM_M1,
          6859 => Opcode::PseudoVMNAND_MM_M2,
          6860 => Opcode::PseudoVMNAND_MM_M4,
          6861 => Opcode::PseudoVMNAND_MM_M8,
          6862 => Opcode::PseudoVMNAND_MM_MF2,
          6863 => Opcode::PseudoVMNAND_MM_MF4,
          6864 => Opcode::PseudoVMNAND_MM_MF8,
          6865 => Opcode::PseudoVMNOR_MM_M1,
          6866 => Opcode::PseudoVMNOR_MM_M2,
          6867 => Opcode::PseudoVMNOR_MM_M4,
          6868 => Opcode::PseudoVMNOR_MM_M8,
          6869 => Opcode::PseudoVMNOR_MM_MF2,
          6870 => Opcode::PseudoVMNOR_MM_MF4,
          6871 => Opcode::PseudoVMNOR_MM_MF8,
          6872 => Opcode::PseudoVMORN_MM_M1,
          6873 => Opcode::PseudoVMORN_MM_M2,
          6874 => Opcode::PseudoVMORN_MM_M4,
          6875 => Opcode::PseudoVMORN_MM_M8,
          6876 => Opcode::PseudoVMORN_MM_MF2,
          6877 => Opcode::PseudoVMORN_MM_MF4,
          6878 => Opcode::PseudoVMORN_MM_MF8,
          6879 => Opcode::PseudoVMOR_MM_M1,
          6880 => Opcode::PseudoVMOR_MM_M2,
          6881 => Opcode::PseudoVMOR_MM_M4,
          6882 => Opcode::PseudoVMOR_MM_M8,
          6883 => Opcode::PseudoVMOR_MM_MF2,
          6884 => Opcode::PseudoVMOR_MM_MF4,
          6885 => Opcode::PseudoVMOR_MM_MF8,
          6886 => Opcode::PseudoVMSBC_VVM_M1,
          6887 => Opcode::PseudoVMSBC_VVM_M2,
          6888 => Opcode::PseudoVMSBC_VVM_M4,
          6889 => Opcode::PseudoVMSBC_VVM_M8,
          6890 => Opcode::PseudoVMSBC_VVM_MF2,
          6891 => Opcode::PseudoVMSBC_VVM_MF4,
          6892 => Opcode::PseudoVMSBC_VVM_MF8,
          6893 => Opcode::PseudoVMSBC_VV_M1,
          6894 => Opcode::PseudoVMSBC_VV_M2,
          6895 => Opcode::PseudoVMSBC_VV_M4,
          6896 => Opcode::PseudoVMSBC_VV_M8,
          6897 => Opcode::PseudoVMSBC_VV_MF2,
          6898 => Opcode::PseudoVMSBC_VV_MF4,
          6899 => Opcode::PseudoVMSBC_VV_MF8,
          6900 => Opcode::PseudoVMSBC_VXM_M1,
          6901 => Opcode::PseudoVMSBC_VXM_M2,
          6902 => Opcode::PseudoVMSBC_VXM_M4,
          6903 => Opcode::PseudoVMSBC_VXM_M8,
          6904 => Opcode::PseudoVMSBC_VXM_MF2,
          6905 => Opcode::PseudoVMSBC_VXM_MF4,
          6906 => Opcode::PseudoVMSBC_VXM_MF8,
          6907 => Opcode::PseudoVMSBC_VX_M1,
          6908 => Opcode::PseudoVMSBC_VX_M2,
          6909 => Opcode::PseudoVMSBC_VX_M4,
          6910 => Opcode::PseudoVMSBC_VX_M8,
          6911 => Opcode::PseudoVMSBC_VX_MF2,
          6912 => Opcode::PseudoVMSBC_VX_MF4,
          6913 => Opcode::PseudoVMSBC_VX_MF8,
          6914 => Opcode::PseudoVMSBF_M_B1,
          6915 => Opcode::PseudoVMSBF_M_B16,
          6916 => Opcode::PseudoVMSBF_M_B16_MASK,
          6917 => Opcode::PseudoVMSBF_M_B1_MASK,
          6918 => Opcode::PseudoVMSBF_M_B2,
          6919 => Opcode::PseudoVMSBF_M_B2_MASK,
          6920 => Opcode::PseudoVMSBF_M_B32,
          6921 => Opcode::PseudoVMSBF_M_B32_MASK,
          6922 => Opcode::PseudoVMSBF_M_B4,
          6923 => Opcode::PseudoVMSBF_M_B4_MASK,
          6924 => Opcode::PseudoVMSBF_M_B64,
          6925 => Opcode::PseudoVMSBF_M_B64_MASK,
          6926 => Opcode::PseudoVMSBF_M_B8,
          6927 => Opcode::PseudoVMSBF_M_B8_MASK,
          6928 => Opcode::PseudoVMSEQ_VI_M1,
          6929 => Opcode::PseudoVMSEQ_VI_M1_MASK,
          6930 => Opcode::PseudoVMSEQ_VI_M2,
          6931 => Opcode::PseudoVMSEQ_VI_M2_MASK,
          6932 => Opcode::PseudoVMSEQ_VI_M4,
          6933 => Opcode::PseudoVMSEQ_VI_M4_MASK,
          6934 => Opcode::PseudoVMSEQ_VI_M8,
          6935 => Opcode::PseudoVMSEQ_VI_M8_MASK,
          6936 => Opcode::PseudoVMSEQ_VI_MF2,
          6937 => Opcode::PseudoVMSEQ_VI_MF2_MASK,
          6938 => Opcode::PseudoVMSEQ_VI_MF4,
          6939 => Opcode::PseudoVMSEQ_VI_MF4_MASK,
          6940 => Opcode::PseudoVMSEQ_VI_MF8,
          6941 => Opcode::PseudoVMSEQ_VI_MF8_MASK,
          6942 => Opcode::PseudoVMSEQ_VV_M1,
          6943 => Opcode::PseudoVMSEQ_VV_M1_MASK,
          6944 => Opcode::PseudoVMSEQ_VV_M2,
          6945 => Opcode::PseudoVMSEQ_VV_M2_MASK,
          6946 => Opcode::PseudoVMSEQ_VV_M4,
          6947 => Opcode::PseudoVMSEQ_VV_M4_MASK,
          6948 => Opcode::PseudoVMSEQ_VV_M8,
          6949 => Opcode::PseudoVMSEQ_VV_M8_MASK,
          6950 => Opcode::PseudoVMSEQ_VV_MF2,
          6951 => Opcode::PseudoVMSEQ_VV_MF2_MASK,
          6952 => Opcode::PseudoVMSEQ_VV_MF4,
          6953 => Opcode::PseudoVMSEQ_VV_MF4_MASK,
          6954 => Opcode::PseudoVMSEQ_VV_MF8,
          6955 => Opcode::PseudoVMSEQ_VV_MF8_MASK,
          6956 => Opcode::PseudoVMSEQ_VX_M1,
          6957 => Opcode::PseudoVMSEQ_VX_M1_MASK,
          6958 => Opcode::PseudoVMSEQ_VX_M2,
          6959 => Opcode::PseudoVMSEQ_VX_M2_MASK,
          6960 => Opcode::PseudoVMSEQ_VX_M4,
          6961 => Opcode::PseudoVMSEQ_VX_M4_MASK,
          6962 => Opcode::PseudoVMSEQ_VX_M8,
          6963 => Opcode::PseudoVMSEQ_VX_M8_MASK,
          6964 => Opcode::PseudoVMSEQ_VX_MF2,
          6965 => Opcode::PseudoVMSEQ_VX_MF2_MASK,
          6966 => Opcode::PseudoVMSEQ_VX_MF4,
          6967 => Opcode::PseudoVMSEQ_VX_MF4_MASK,
          6968 => Opcode::PseudoVMSEQ_VX_MF8,
          6969 => Opcode::PseudoVMSEQ_VX_MF8_MASK,
          6970 => Opcode::PseudoVMSET_M_B1,
          6971 => Opcode::PseudoVMSET_M_B16,
          6972 => Opcode::PseudoVMSET_M_B2,
          6973 => Opcode::PseudoVMSET_M_B32,
          6974 => Opcode::PseudoVMSET_M_B4,
          6975 => Opcode::PseudoVMSET_M_B64,
          6976 => Opcode::PseudoVMSET_M_B8,
          6977 => Opcode::PseudoVMSGEU_VI,
          6978 => Opcode::PseudoVMSGEU_VX,
          6979 => Opcode::PseudoVMSGEU_VX_M,
          6980 => Opcode::PseudoVMSGEU_VX_M_T,
          6981 => Opcode::PseudoVMSGE_VI,
          6982 => Opcode::PseudoVMSGE_VX,
          6983 => Opcode::PseudoVMSGE_VX_M,
          6984 => Opcode::PseudoVMSGE_VX_M_T,
          6985 => Opcode::PseudoVMSGTU_VI_M1,
          6986 => Opcode::PseudoVMSGTU_VI_M1_MASK,
          6987 => Opcode::PseudoVMSGTU_VI_M2,
          6988 => Opcode::PseudoVMSGTU_VI_M2_MASK,
          6989 => Opcode::PseudoVMSGTU_VI_M4,
          6990 => Opcode::PseudoVMSGTU_VI_M4_MASK,
          6991 => Opcode::PseudoVMSGTU_VI_M8,
          6992 => Opcode::PseudoVMSGTU_VI_M8_MASK,
          6993 => Opcode::PseudoVMSGTU_VI_MF2,
          6994 => Opcode::PseudoVMSGTU_VI_MF2_MASK,
          6995 => Opcode::PseudoVMSGTU_VI_MF4,
          6996 => Opcode::PseudoVMSGTU_VI_MF4_MASK,
          6997 => Opcode::PseudoVMSGTU_VI_MF8,
          6998 => Opcode::PseudoVMSGTU_VI_MF8_MASK,
          6999 => Opcode::PseudoVMSGTU_VX_M1,
          7000 => Opcode::PseudoVMSGTU_VX_M1_MASK,
          7001 => Opcode::PseudoVMSGTU_VX_M2,
          7002 => Opcode::PseudoVMSGTU_VX_M2_MASK,
          7003 => Opcode::PseudoVMSGTU_VX_M4,
          7004 => Opcode::PseudoVMSGTU_VX_M4_MASK,
          7005 => Opcode::PseudoVMSGTU_VX_M8,
          7006 => Opcode::PseudoVMSGTU_VX_M8_MASK,
          7007 => Opcode::PseudoVMSGTU_VX_MF2,
          7008 => Opcode::PseudoVMSGTU_VX_MF2_MASK,
          7009 => Opcode::PseudoVMSGTU_VX_MF4,
          7010 => Opcode::PseudoVMSGTU_VX_MF4_MASK,
          7011 => Opcode::PseudoVMSGTU_VX_MF8,
          7012 => Opcode::PseudoVMSGTU_VX_MF8_MASK,
          7013 => Opcode::PseudoVMSGT_VI_M1,
          7014 => Opcode::PseudoVMSGT_VI_M1_MASK,
          7015 => Opcode::PseudoVMSGT_VI_M2,
          7016 => Opcode::PseudoVMSGT_VI_M2_MASK,
          7017 => Opcode::PseudoVMSGT_VI_M4,
          7018 => Opcode::PseudoVMSGT_VI_M4_MASK,
          7019 => Opcode::PseudoVMSGT_VI_M8,
          7020 => Opcode::PseudoVMSGT_VI_M8_MASK,
          7021 => Opcode::PseudoVMSGT_VI_MF2,
          7022 => Opcode::PseudoVMSGT_VI_MF2_MASK,
          7023 => Opcode::PseudoVMSGT_VI_MF4,
          7024 => Opcode::PseudoVMSGT_VI_MF4_MASK,
          7025 => Opcode::PseudoVMSGT_VI_MF8,
          7026 => Opcode::PseudoVMSGT_VI_MF8_MASK,
          7027 => Opcode::PseudoVMSGT_VX_M1,
          7028 => Opcode::PseudoVMSGT_VX_M1_MASK,
          7029 => Opcode::PseudoVMSGT_VX_M2,
          7030 => Opcode::PseudoVMSGT_VX_M2_MASK,
          7031 => Opcode::PseudoVMSGT_VX_M4,
          7032 => Opcode::PseudoVMSGT_VX_M4_MASK,
          7033 => Opcode::PseudoVMSGT_VX_M8,
          7034 => Opcode::PseudoVMSGT_VX_M8_MASK,
          7035 => Opcode::PseudoVMSGT_VX_MF2,
          7036 => Opcode::PseudoVMSGT_VX_MF2_MASK,
          7037 => Opcode::PseudoVMSGT_VX_MF4,
          7038 => Opcode::PseudoVMSGT_VX_MF4_MASK,
          7039 => Opcode::PseudoVMSGT_VX_MF8,
          7040 => Opcode::PseudoVMSGT_VX_MF8_MASK,
          7041 => Opcode::PseudoVMSIF_M_B1,
          7042 => Opcode::PseudoVMSIF_M_B16,
          7043 => Opcode::PseudoVMSIF_M_B16_MASK,
          7044 => Opcode::PseudoVMSIF_M_B1_MASK,
          7045 => Opcode::PseudoVMSIF_M_B2,
          7046 => Opcode::PseudoVMSIF_M_B2_MASK,
          7047 => Opcode::PseudoVMSIF_M_B32,
          7048 => Opcode::PseudoVMSIF_M_B32_MASK,
          7049 => Opcode::PseudoVMSIF_M_B4,
          7050 => Opcode::PseudoVMSIF_M_B4_MASK,
          7051 => Opcode::PseudoVMSIF_M_B64,
          7052 => Opcode::PseudoVMSIF_M_B64_MASK,
          7053 => Opcode::PseudoVMSIF_M_B8,
          7054 => Opcode::PseudoVMSIF_M_B8_MASK,
          7055 => Opcode::PseudoVMSLEU_VI_M1,
          7056 => Opcode::PseudoVMSLEU_VI_M1_MASK,
          7057 => Opcode::PseudoVMSLEU_VI_M2,
          7058 => Opcode::PseudoVMSLEU_VI_M2_MASK,
          7059 => Opcode::PseudoVMSLEU_VI_M4,
          7060 => Opcode::PseudoVMSLEU_VI_M4_MASK,
          7061 => Opcode::PseudoVMSLEU_VI_M8,
          7062 => Opcode::PseudoVMSLEU_VI_M8_MASK,
          7063 => Opcode::PseudoVMSLEU_VI_MF2,
          7064 => Opcode::PseudoVMSLEU_VI_MF2_MASK,
          7065 => Opcode::PseudoVMSLEU_VI_MF4,
          7066 => Opcode::PseudoVMSLEU_VI_MF4_MASK,
          7067 => Opcode::PseudoVMSLEU_VI_MF8,
          7068 => Opcode::PseudoVMSLEU_VI_MF8_MASK,
          7069 => Opcode::PseudoVMSLEU_VV_M1,
          7070 => Opcode::PseudoVMSLEU_VV_M1_MASK,
          7071 => Opcode::PseudoVMSLEU_VV_M2,
          7072 => Opcode::PseudoVMSLEU_VV_M2_MASK,
          7073 => Opcode::PseudoVMSLEU_VV_M4,
          7074 => Opcode::PseudoVMSLEU_VV_M4_MASK,
          7075 => Opcode::PseudoVMSLEU_VV_M8,
          7076 => Opcode::PseudoVMSLEU_VV_M8_MASK,
          7077 => Opcode::PseudoVMSLEU_VV_MF2,
          7078 => Opcode::PseudoVMSLEU_VV_MF2_MASK,
          7079 => Opcode::PseudoVMSLEU_VV_MF4,
          7080 => Opcode::PseudoVMSLEU_VV_MF4_MASK,
          7081 => Opcode::PseudoVMSLEU_VV_MF8,
          7082 => Opcode::PseudoVMSLEU_VV_MF8_MASK,
          7083 => Opcode::PseudoVMSLEU_VX_M1,
          7084 => Opcode::PseudoVMSLEU_VX_M1_MASK,
          7085 => Opcode::PseudoVMSLEU_VX_M2,
          7086 => Opcode::PseudoVMSLEU_VX_M2_MASK,
          7087 => Opcode::PseudoVMSLEU_VX_M4,
          7088 => Opcode::PseudoVMSLEU_VX_M4_MASK,
          7089 => Opcode::PseudoVMSLEU_VX_M8,
          7090 => Opcode::PseudoVMSLEU_VX_M8_MASK,
          7091 => Opcode::PseudoVMSLEU_VX_MF2,
          7092 => Opcode::PseudoVMSLEU_VX_MF2_MASK,
          7093 => Opcode::PseudoVMSLEU_VX_MF4,
          7094 => Opcode::PseudoVMSLEU_VX_MF4_MASK,
          7095 => Opcode::PseudoVMSLEU_VX_MF8,
          7096 => Opcode::PseudoVMSLEU_VX_MF8_MASK,
          7097 => Opcode::PseudoVMSLE_VI_M1,
          7098 => Opcode::PseudoVMSLE_VI_M1_MASK,
          7099 => Opcode::PseudoVMSLE_VI_M2,
          7100 => Opcode::PseudoVMSLE_VI_M2_MASK,
          7101 => Opcode::PseudoVMSLE_VI_M4,
          7102 => Opcode::PseudoVMSLE_VI_M4_MASK,
          7103 => Opcode::PseudoVMSLE_VI_M8,
          7104 => Opcode::PseudoVMSLE_VI_M8_MASK,
          7105 => Opcode::PseudoVMSLE_VI_MF2,
          7106 => Opcode::PseudoVMSLE_VI_MF2_MASK,
          7107 => Opcode::PseudoVMSLE_VI_MF4,
          7108 => Opcode::PseudoVMSLE_VI_MF4_MASK,
          7109 => Opcode::PseudoVMSLE_VI_MF8,
          7110 => Opcode::PseudoVMSLE_VI_MF8_MASK,
          7111 => Opcode::PseudoVMSLE_VV_M1,
          7112 => Opcode::PseudoVMSLE_VV_M1_MASK,
          7113 => Opcode::PseudoVMSLE_VV_M2,
          7114 => Opcode::PseudoVMSLE_VV_M2_MASK,
          7115 => Opcode::PseudoVMSLE_VV_M4,
          7116 => Opcode::PseudoVMSLE_VV_M4_MASK,
          7117 => Opcode::PseudoVMSLE_VV_M8,
          7118 => Opcode::PseudoVMSLE_VV_M8_MASK,
          7119 => Opcode::PseudoVMSLE_VV_MF2,
          7120 => Opcode::PseudoVMSLE_VV_MF2_MASK,
          7121 => Opcode::PseudoVMSLE_VV_MF4,
          7122 => Opcode::PseudoVMSLE_VV_MF4_MASK,
          7123 => Opcode::PseudoVMSLE_VV_MF8,
          7124 => Opcode::PseudoVMSLE_VV_MF8_MASK,
          7125 => Opcode::PseudoVMSLE_VX_M1,
          7126 => Opcode::PseudoVMSLE_VX_M1_MASK,
          7127 => Opcode::PseudoVMSLE_VX_M2,
          7128 => Opcode::PseudoVMSLE_VX_M2_MASK,
          7129 => Opcode::PseudoVMSLE_VX_M4,
          7130 => Opcode::PseudoVMSLE_VX_M4_MASK,
          7131 => Opcode::PseudoVMSLE_VX_M8,
          7132 => Opcode::PseudoVMSLE_VX_M8_MASK,
          7133 => Opcode::PseudoVMSLE_VX_MF2,
          7134 => Opcode::PseudoVMSLE_VX_MF2_MASK,
          7135 => Opcode::PseudoVMSLE_VX_MF4,
          7136 => Opcode::PseudoVMSLE_VX_MF4_MASK,
          7137 => Opcode::PseudoVMSLE_VX_MF8,
          7138 => Opcode::PseudoVMSLE_VX_MF8_MASK,
          7139 => Opcode::PseudoVMSLTU_VI,
          7140 => Opcode::PseudoVMSLTU_VV_M1,
          7141 => Opcode::PseudoVMSLTU_VV_M1_MASK,
          7142 => Opcode::PseudoVMSLTU_VV_M2,
          7143 => Opcode::PseudoVMSLTU_VV_M2_MASK,
          7144 => Opcode::PseudoVMSLTU_VV_M4,
          7145 => Opcode::PseudoVMSLTU_VV_M4_MASK,
          7146 => Opcode::PseudoVMSLTU_VV_M8,
          7147 => Opcode::PseudoVMSLTU_VV_M8_MASK,
          7148 => Opcode::PseudoVMSLTU_VV_MF2,
          7149 => Opcode::PseudoVMSLTU_VV_MF2_MASK,
          7150 => Opcode::PseudoVMSLTU_VV_MF4,
          7151 => Opcode::PseudoVMSLTU_VV_MF4_MASK,
          7152 => Opcode::PseudoVMSLTU_VV_MF8,
          7153 => Opcode::PseudoVMSLTU_VV_MF8_MASK,
          7154 => Opcode::PseudoVMSLTU_VX_M1,
          7155 => Opcode::PseudoVMSLTU_VX_M1_MASK,
          7156 => Opcode::PseudoVMSLTU_VX_M2,
          7157 => Opcode::PseudoVMSLTU_VX_M2_MASK,
          7158 => Opcode::PseudoVMSLTU_VX_M4,
          7159 => Opcode::PseudoVMSLTU_VX_M4_MASK,
          7160 => Opcode::PseudoVMSLTU_VX_M8,
          7161 => Opcode::PseudoVMSLTU_VX_M8_MASK,
          7162 => Opcode::PseudoVMSLTU_VX_MF2,
          7163 => Opcode::PseudoVMSLTU_VX_MF2_MASK,
          7164 => Opcode::PseudoVMSLTU_VX_MF4,
          7165 => Opcode::PseudoVMSLTU_VX_MF4_MASK,
          7166 => Opcode::PseudoVMSLTU_VX_MF8,
          7167 => Opcode::PseudoVMSLTU_VX_MF8_MASK,
          7168 => Opcode::PseudoVMSLT_VI,
          7169 => Opcode::PseudoVMSLT_VV_M1,
          7170 => Opcode::PseudoVMSLT_VV_M1_MASK,
          7171 => Opcode::PseudoVMSLT_VV_M2,
          7172 => Opcode::PseudoVMSLT_VV_M2_MASK,
          7173 => Opcode::PseudoVMSLT_VV_M4,
          7174 => Opcode::PseudoVMSLT_VV_M4_MASK,
          7175 => Opcode::PseudoVMSLT_VV_M8,
          7176 => Opcode::PseudoVMSLT_VV_M8_MASK,
          7177 => Opcode::PseudoVMSLT_VV_MF2,
          7178 => Opcode::PseudoVMSLT_VV_MF2_MASK,
          7179 => Opcode::PseudoVMSLT_VV_MF4,
          7180 => Opcode::PseudoVMSLT_VV_MF4_MASK,
          7181 => Opcode::PseudoVMSLT_VV_MF8,
          7182 => Opcode::PseudoVMSLT_VV_MF8_MASK,
          7183 => Opcode::PseudoVMSLT_VX_M1,
          7184 => Opcode::PseudoVMSLT_VX_M1_MASK,
          7185 => Opcode::PseudoVMSLT_VX_M2,
          7186 => Opcode::PseudoVMSLT_VX_M2_MASK,
          7187 => Opcode::PseudoVMSLT_VX_M4,
          7188 => Opcode::PseudoVMSLT_VX_M4_MASK,
          7189 => Opcode::PseudoVMSLT_VX_M8,
          7190 => Opcode::PseudoVMSLT_VX_M8_MASK,
          7191 => Opcode::PseudoVMSLT_VX_MF2,
          7192 => Opcode::PseudoVMSLT_VX_MF2_MASK,
          7193 => Opcode::PseudoVMSLT_VX_MF4,
          7194 => Opcode::PseudoVMSLT_VX_MF4_MASK,
          7195 => Opcode::PseudoVMSLT_VX_MF8,
          7196 => Opcode::PseudoVMSLT_VX_MF8_MASK,
          7197 => Opcode::PseudoVMSNE_VI_M1,
          7198 => Opcode::PseudoVMSNE_VI_M1_MASK,
          7199 => Opcode::PseudoVMSNE_VI_M2,
          7200 => Opcode::PseudoVMSNE_VI_M2_MASK,
          7201 => Opcode::PseudoVMSNE_VI_M4,
          7202 => Opcode::PseudoVMSNE_VI_M4_MASK,
          7203 => Opcode::PseudoVMSNE_VI_M8,
          7204 => Opcode::PseudoVMSNE_VI_M8_MASK,
          7205 => Opcode::PseudoVMSNE_VI_MF2,
          7206 => Opcode::PseudoVMSNE_VI_MF2_MASK,
          7207 => Opcode::PseudoVMSNE_VI_MF4,
          7208 => Opcode::PseudoVMSNE_VI_MF4_MASK,
          7209 => Opcode::PseudoVMSNE_VI_MF8,
          7210 => Opcode::PseudoVMSNE_VI_MF8_MASK,
          7211 => Opcode::PseudoVMSNE_VV_M1,
          7212 => Opcode::PseudoVMSNE_VV_M1_MASK,
          7213 => Opcode::PseudoVMSNE_VV_M2,
          7214 => Opcode::PseudoVMSNE_VV_M2_MASK,
          7215 => Opcode::PseudoVMSNE_VV_M4,
          7216 => Opcode::PseudoVMSNE_VV_M4_MASK,
          7217 => Opcode::PseudoVMSNE_VV_M8,
          7218 => Opcode::PseudoVMSNE_VV_M8_MASK,
          7219 => Opcode::PseudoVMSNE_VV_MF2,
          7220 => Opcode::PseudoVMSNE_VV_MF2_MASK,
          7221 => Opcode::PseudoVMSNE_VV_MF4,
          7222 => Opcode::PseudoVMSNE_VV_MF4_MASK,
          7223 => Opcode::PseudoVMSNE_VV_MF8,
          7224 => Opcode::PseudoVMSNE_VV_MF8_MASK,
          7225 => Opcode::PseudoVMSNE_VX_M1,
          7226 => Opcode::PseudoVMSNE_VX_M1_MASK,
          7227 => Opcode::PseudoVMSNE_VX_M2,
          7228 => Opcode::PseudoVMSNE_VX_M2_MASK,
          7229 => Opcode::PseudoVMSNE_VX_M4,
          7230 => Opcode::PseudoVMSNE_VX_M4_MASK,
          7231 => Opcode::PseudoVMSNE_VX_M8,
          7232 => Opcode::PseudoVMSNE_VX_M8_MASK,
          7233 => Opcode::PseudoVMSNE_VX_MF2,
          7234 => Opcode::PseudoVMSNE_VX_MF2_MASK,
          7235 => Opcode::PseudoVMSNE_VX_MF4,
          7236 => Opcode::PseudoVMSNE_VX_MF4_MASK,
          7237 => Opcode::PseudoVMSNE_VX_MF8,
          7238 => Opcode::PseudoVMSNE_VX_MF8_MASK,
          7239 => Opcode::PseudoVMSOF_M_B1,
          7240 => Opcode::PseudoVMSOF_M_B16,
          7241 => Opcode::PseudoVMSOF_M_B16_MASK,
          7242 => Opcode::PseudoVMSOF_M_B1_MASK,
          7243 => Opcode::PseudoVMSOF_M_B2,
          7244 => Opcode::PseudoVMSOF_M_B2_MASK,
          7245 => Opcode::PseudoVMSOF_M_B32,
          7246 => Opcode::PseudoVMSOF_M_B32_MASK,
          7247 => Opcode::PseudoVMSOF_M_B4,
          7248 => Opcode::PseudoVMSOF_M_B4_MASK,
          7249 => Opcode::PseudoVMSOF_M_B64,
          7250 => Opcode::PseudoVMSOF_M_B64_MASK,
          7251 => Opcode::PseudoVMSOF_M_B8,
          7252 => Opcode::PseudoVMSOF_M_B8_MASK,
          7253 => Opcode::PseudoVMULHSU_VV_M1,
          7254 => Opcode::PseudoVMULHSU_VV_M1_MASK,
          7255 => Opcode::PseudoVMULHSU_VV_M2,
          7256 => Opcode::PseudoVMULHSU_VV_M2_MASK,
          7257 => Opcode::PseudoVMULHSU_VV_M4,
          7258 => Opcode::PseudoVMULHSU_VV_M4_MASK,
          7259 => Opcode::PseudoVMULHSU_VV_M8,
          7260 => Opcode::PseudoVMULHSU_VV_M8_MASK,
          7261 => Opcode::PseudoVMULHSU_VV_MF2,
          7262 => Opcode::PseudoVMULHSU_VV_MF2_MASK,
          7263 => Opcode::PseudoVMULHSU_VV_MF4,
          7264 => Opcode::PseudoVMULHSU_VV_MF4_MASK,
          7265 => Opcode::PseudoVMULHSU_VV_MF8,
          7266 => Opcode::PseudoVMULHSU_VV_MF8_MASK,
          7267 => Opcode::PseudoVMULHSU_VX_M1,
          7268 => Opcode::PseudoVMULHSU_VX_M1_MASK,
          7269 => Opcode::PseudoVMULHSU_VX_M2,
          7270 => Opcode::PseudoVMULHSU_VX_M2_MASK,
          7271 => Opcode::PseudoVMULHSU_VX_M4,
          7272 => Opcode::PseudoVMULHSU_VX_M4_MASK,
          7273 => Opcode::PseudoVMULHSU_VX_M8,
          7274 => Opcode::PseudoVMULHSU_VX_M8_MASK,
          7275 => Opcode::PseudoVMULHSU_VX_MF2,
          7276 => Opcode::PseudoVMULHSU_VX_MF2_MASK,
          7277 => Opcode::PseudoVMULHSU_VX_MF4,
          7278 => Opcode::PseudoVMULHSU_VX_MF4_MASK,
          7279 => Opcode::PseudoVMULHSU_VX_MF8,
          7280 => Opcode::PseudoVMULHSU_VX_MF8_MASK,
          7281 => Opcode::PseudoVMULHU_VV_M1,
          7282 => Opcode::PseudoVMULHU_VV_M1_MASK,
          7283 => Opcode::PseudoVMULHU_VV_M2,
          7284 => Opcode::PseudoVMULHU_VV_M2_MASK,
          7285 => Opcode::PseudoVMULHU_VV_M4,
          7286 => Opcode::PseudoVMULHU_VV_M4_MASK,
          7287 => Opcode::PseudoVMULHU_VV_M8,
          7288 => Opcode::PseudoVMULHU_VV_M8_MASK,
          7289 => Opcode::PseudoVMULHU_VV_MF2,
          7290 => Opcode::PseudoVMULHU_VV_MF2_MASK,
          7291 => Opcode::PseudoVMULHU_VV_MF4,
          7292 => Opcode::PseudoVMULHU_VV_MF4_MASK,
          7293 => Opcode::PseudoVMULHU_VV_MF8,
          7294 => Opcode::PseudoVMULHU_VV_MF8_MASK,
          7295 => Opcode::PseudoVMULHU_VX_M1,
          7296 => Opcode::PseudoVMULHU_VX_M1_MASK,
          7297 => Opcode::PseudoVMULHU_VX_M2,
          7298 => Opcode::PseudoVMULHU_VX_M2_MASK,
          7299 => Opcode::PseudoVMULHU_VX_M4,
          7300 => Opcode::PseudoVMULHU_VX_M4_MASK,
          7301 => Opcode::PseudoVMULHU_VX_M8,
          7302 => Opcode::PseudoVMULHU_VX_M8_MASK,
          7303 => Opcode::PseudoVMULHU_VX_MF2,
          7304 => Opcode::PseudoVMULHU_VX_MF2_MASK,
          7305 => Opcode::PseudoVMULHU_VX_MF4,
          7306 => Opcode::PseudoVMULHU_VX_MF4_MASK,
          7307 => Opcode::PseudoVMULHU_VX_MF8,
          7308 => Opcode::PseudoVMULHU_VX_MF8_MASK,
          7309 => Opcode::PseudoVMULH_VV_M1,
          7310 => Opcode::PseudoVMULH_VV_M1_MASK,
          7311 => Opcode::PseudoVMULH_VV_M2,
          7312 => Opcode::PseudoVMULH_VV_M2_MASK,
          7313 => Opcode::PseudoVMULH_VV_M4,
          7314 => Opcode::PseudoVMULH_VV_M4_MASK,
          7315 => Opcode::PseudoVMULH_VV_M8,
          7316 => Opcode::PseudoVMULH_VV_M8_MASK,
          7317 => Opcode::PseudoVMULH_VV_MF2,
          7318 => Opcode::PseudoVMULH_VV_MF2_MASK,
          7319 => Opcode::PseudoVMULH_VV_MF4,
          7320 => Opcode::PseudoVMULH_VV_MF4_MASK,
          7321 => Opcode::PseudoVMULH_VV_MF8,
          7322 => Opcode::PseudoVMULH_VV_MF8_MASK,
          7323 => Opcode::PseudoVMULH_VX_M1,
          7324 => Opcode::PseudoVMULH_VX_M1_MASK,
          7325 => Opcode::PseudoVMULH_VX_M2,
          7326 => Opcode::PseudoVMULH_VX_M2_MASK,
          7327 => Opcode::PseudoVMULH_VX_M4,
          7328 => Opcode::PseudoVMULH_VX_M4_MASK,
          7329 => Opcode::PseudoVMULH_VX_M8,
          7330 => Opcode::PseudoVMULH_VX_M8_MASK,
          7331 => Opcode::PseudoVMULH_VX_MF2,
          7332 => Opcode::PseudoVMULH_VX_MF2_MASK,
          7333 => Opcode::PseudoVMULH_VX_MF4,
          7334 => Opcode::PseudoVMULH_VX_MF4_MASK,
          7335 => Opcode::PseudoVMULH_VX_MF8,
          7336 => Opcode::PseudoVMULH_VX_MF8_MASK,
          7337 => Opcode::PseudoVMUL_VV_M1,
          7338 => Opcode::PseudoVMUL_VV_M1_MASK,
          7339 => Opcode::PseudoVMUL_VV_M2,
          7340 => Opcode::PseudoVMUL_VV_M2_MASK,
          7341 => Opcode::PseudoVMUL_VV_M4,
          7342 => Opcode::PseudoVMUL_VV_M4_MASK,
          7343 => Opcode::PseudoVMUL_VV_M8,
          7344 => Opcode::PseudoVMUL_VV_M8_MASK,
          7345 => Opcode::PseudoVMUL_VV_MF2,
          7346 => Opcode::PseudoVMUL_VV_MF2_MASK,
          7347 => Opcode::PseudoVMUL_VV_MF4,
          7348 => Opcode::PseudoVMUL_VV_MF4_MASK,
          7349 => Opcode::PseudoVMUL_VV_MF8,
          7350 => Opcode::PseudoVMUL_VV_MF8_MASK,
          7351 => Opcode::PseudoVMUL_VX_M1,
          7352 => Opcode::PseudoVMUL_VX_M1_MASK,
          7353 => Opcode::PseudoVMUL_VX_M2,
          7354 => Opcode::PseudoVMUL_VX_M2_MASK,
          7355 => Opcode::PseudoVMUL_VX_M4,
          7356 => Opcode::PseudoVMUL_VX_M4_MASK,
          7357 => Opcode::PseudoVMUL_VX_M8,
          7358 => Opcode::PseudoVMUL_VX_M8_MASK,
          7359 => Opcode::PseudoVMUL_VX_MF2,
          7360 => Opcode::PseudoVMUL_VX_MF2_MASK,
          7361 => Opcode::PseudoVMUL_VX_MF4,
          7362 => Opcode::PseudoVMUL_VX_MF4_MASK,
          7363 => Opcode::PseudoVMUL_VX_MF8,
          7364 => Opcode::PseudoVMUL_VX_MF8_MASK,
          7365 => Opcode::PseudoVMV_S_X,
          7366 => Opcode::PseudoVMV_V_I_M1,
          7367 => Opcode::PseudoVMV_V_I_M2,
          7368 => Opcode::PseudoVMV_V_I_M4,
          7369 => Opcode::PseudoVMV_V_I_M8,
          7370 => Opcode::PseudoVMV_V_I_MF2,
          7371 => Opcode::PseudoVMV_V_I_MF4,
          7372 => Opcode::PseudoVMV_V_I_MF8,
          7373 => Opcode::PseudoVMV_V_V_M1,
          7374 => Opcode::PseudoVMV_V_V_M2,
          7375 => Opcode::PseudoVMV_V_V_M4,
          7376 => Opcode::PseudoVMV_V_V_M8,
          7377 => Opcode::PseudoVMV_V_V_MF2,
          7378 => Opcode::PseudoVMV_V_V_MF4,
          7379 => Opcode::PseudoVMV_V_V_MF8,
          7380 => Opcode::PseudoVMV_V_X_M1,
          7381 => Opcode::PseudoVMV_V_X_M2,
          7382 => Opcode::PseudoVMV_V_X_M4,
          7383 => Opcode::PseudoVMV_V_X_M8,
          7384 => Opcode::PseudoVMV_V_X_MF2,
          7385 => Opcode::PseudoVMV_V_X_MF4,
          7386 => Opcode::PseudoVMV_V_X_MF8,
          7387 => Opcode::PseudoVMV_X_S,
          7388 => Opcode::PseudoVMXNOR_MM_M1,
          7389 => Opcode::PseudoVMXNOR_MM_M2,
          7390 => Opcode::PseudoVMXNOR_MM_M4,
          7391 => Opcode::PseudoVMXNOR_MM_M8,
          7392 => Opcode::PseudoVMXNOR_MM_MF2,
          7393 => Opcode::PseudoVMXNOR_MM_MF4,
          7394 => Opcode::PseudoVMXNOR_MM_MF8,
          7395 => Opcode::PseudoVMXOR_MM_M1,
          7396 => Opcode::PseudoVMXOR_MM_M2,
          7397 => Opcode::PseudoVMXOR_MM_M4,
          7398 => Opcode::PseudoVMXOR_MM_M8,
          7399 => Opcode::PseudoVMXOR_MM_MF2,
          7400 => Opcode::PseudoVMXOR_MM_MF4,
          7401 => Opcode::PseudoVMXOR_MM_MF8,
          7402 => Opcode::PseudoVNCLIPU_WI_M1,
          7403 => Opcode::PseudoVNCLIPU_WI_M1_MASK,
          7404 => Opcode::PseudoVNCLIPU_WI_M2,
          7405 => Opcode::PseudoVNCLIPU_WI_M2_MASK,
          7406 => Opcode::PseudoVNCLIPU_WI_M4,
          7407 => Opcode::PseudoVNCLIPU_WI_M4_MASK,
          7408 => Opcode::PseudoVNCLIPU_WI_MF2,
          7409 => Opcode::PseudoVNCLIPU_WI_MF2_MASK,
          7410 => Opcode::PseudoVNCLIPU_WI_MF4,
          7411 => Opcode::PseudoVNCLIPU_WI_MF4_MASK,
          7412 => Opcode::PseudoVNCLIPU_WI_MF8,
          7413 => Opcode::PseudoVNCLIPU_WI_MF8_MASK,
          7414 => Opcode::PseudoVNCLIPU_WV_M1,
          7415 => Opcode::PseudoVNCLIPU_WV_M1_MASK,
          7416 => Opcode::PseudoVNCLIPU_WV_M2,
          7417 => Opcode::PseudoVNCLIPU_WV_M2_MASK,
          7418 => Opcode::PseudoVNCLIPU_WV_M4,
          7419 => Opcode::PseudoVNCLIPU_WV_M4_MASK,
          7420 => Opcode::PseudoVNCLIPU_WV_MF2,
          7421 => Opcode::PseudoVNCLIPU_WV_MF2_MASK,
          7422 => Opcode::PseudoVNCLIPU_WV_MF4,
          7423 => Opcode::PseudoVNCLIPU_WV_MF4_MASK,
          7424 => Opcode::PseudoVNCLIPU_WV_MF8,
          7425 => Opcode::PseudoVNCLIPU_WV_MF8_MASK,
          7426 => Opcode::PseudoVNCLIPU_WX_M1,
          7427 => Opcode::PseudoVNCLIPU_WX_M1_MASK,
          7428 => Opcode::PseudoVNCLIPU_WX_M2,
          7429 => Opcode::PseudoVNCLIPU_WX_M2_MASK,
          7430 => Opcode::PseudoVNCLIPU_WX_M4,
          7431 => Opcode::PseudoVNCLIPU_WX_M4_MASK,
          7432 => Opcode::PseudoVNCLIPU_WX_MF2,
          7433 => Opcode::PseudoVNCLIPU_WX_MF2_MASK,
          7434 => Opcode::PseudoVNCLIPU_WX_MF4,
          7435 => Opcode::PseudoVNCLIPU_WX_MF4_MASK,
          7436 => Opcode::PseudoVNCLIPU_WX_MF8,
          7437 => Opcode::PseudoVNCLIPU_WX_MF8_MASK,
          7438 => Opcode::PseudoVNCLIP_WI_M1,
          7439 => Opcode::PseudoVNCLIP_WI_M1_MASK,
          7440 => Opcode::PseudoVNCLIP_WI_M2,
          7441 => Opcode::PseudoVNCLIP_WI_M2_MASK,
          7442 => Opcode::PseudoVNCLIP_WI_M4,
          7443 => Opcode::PseudoVNCLIP_WI_M4_MASK,
          7444 => Opcode::PseudoVNCLIP_WI_MF2,
          7445 => Opcode::PseudoVNCLIP_WI_MF2_MASK,
          7446 => Opcode::PseudoVNCLIP_WI_MF4,
          7447 => Opcode::PseudoVNCLIP_WI_MF4_MASK,
          7448 => Opcode::PseudoVNCLIP_WI_MF8,
          7449 => Opcode::PseudoVNCLIP_WI_MF8_MASK,
          7450 => Opcode::PseudoVNCLIP_WV_M1,
          7451 => Opcode::PseudoVNCLIP_WV_M1_MASK,
          7452 => Opcode::PseudoVNCLIP_WV_M2,
          7453 => Opcode::PseudoVNCLIP_WV_M2_MASK,
          7454 => Opcode::PseudoVNCLIP_WV_M4,
          7455 => Opcode::PseudoVNCLIP_WV_M4_MASK,
          7456 => Opcode::PseudoVNCLIP_WV_MF2,
          7457 => Opcode::PseudoVNCLIP_WV_MF2_MASK,
          7458 => Opcode::PseudoVNCLIP_WV_MF4,
          7459 => Opcode::PseudoVNCLIP_WV_MF4_MASK,
          7460 => Opcode::PseudoVNCLIP_WV_MF8,
          7461 => Opcode::PseudoVNCLIP_WV_MF8_MASK,
          7462 => Opcode::PseudoVNCLIP_WX_M1,
          7463 => Opcode::PseudoVNCLIP_WX_M1_MASK,
          7464 => Opcode::PseudoVNCLIP_WX_M2,
          7465 => Opcode::PseudoVNCLIP_WX_M2_MASK,
          7466 => Opcode::PseudoVNCLIP_WX_M4,
          7467 => Opcode::PseudoVNCLIP_WX_M4_MASK,
          7468 => Opcode::PseudoVNCLIP_WX_MF2,
          7469 => Opcode::PseudoVNCLIP_WX_MF2_MASK,
          7470 => Opcode::PseudoVNCLIP_WX_MF4,
          7471 => Opcode::PseudoVNCLIP_WX_MF4_MASK,
          7472 => Opcode::PseudoVNCLIP_WX_MF8,
          7473 => Opcode::PseudoVNCLIP_WX_MF8_MASK,
          7474 => Opcode::PseudoVNMSAC_VV_M1,
          7475 => Opcode::PseudoVNMSAC_VV_M1_MASK,
          7476 => Opcode::PseudoVNMSAC_VV_M2,
          7477 => Opcode::PseudoVNMSAC_VV_M2_MASK,
          7478 => Opcode::PseudoVNMSAC_VV_M4,
          7479 => Opcode::PseudoVNMSAC_VV_M4_MASK,
          7480 => Opcode::PseudoVNMSAC_VV_M8,
          7481 => Opcode::PseudoVNMSAC_VV_M8_MASK,
          7482 => Opcode::PseudoVNMSAC_VV_MF2,
          7483 => Opcode::PseudoVNMSAC_VV_MF2_MASK,
          7484 => Opcode::PseudoVNMSAC_VV_MF4,
          7485 => Opcode::PseudoVNMSAC_VV_MF4_MASK,
          7486 => Opcode::PseudoVNMSAC_VV_MF8,
          7487 => Opcode::PseudoVNMSAC_VV_MF8_MASK,
          7488 => Opcode::PseudoVNMSAC_VX_M1,
          7489 => Opcode::PseudoVNMSAC_VX_M1_MASK,
          7490 => Opcode::PseudoVNMSAC_VX_M2,
          7491 => Opcode::PseudoVNMSAC_VX_M2_MASK,
          7492 => Opcode::PseudoVNMSAC_VX_M4,
          7493 => Opcode::PseudoVNMSAC_VX_M4_MASK,
          7494 => Opcode::PseudoVNMSAC_VX_M8,
          7495 => Opcode::PseudoVNMSAC_VX_M8_MASK,
          7496 => Opcode::PseudoVNMSAC_VX_MF2,
          7497 => Opcode::PseudoVNMSAC_VX_MF2_MASK,
          7498 => Opcode::PseudoVNMSAC_VX_MF4,
          7499 => Opcode::PseudoVNMSAC_VX_MF4_MASK,
          7500 => Opcode::PseudoVNMSAC_VX_MF8,
          7501 => Opcode::PseudoVNMSAC_VX_MF8_MASK,
          7502 => Opcode::PseudoVNMSUB_VV_M1,
          7503 => Opcode::PseudoVNMSUB_VV_M1_MASK,
          7504 => Opcode::PseudoVNMSUB_VV_M2,
          7505 => Opcode::PseudoVNMSUB_VV_M2_MASK,
          7506 => Opcode::PseudoVNMSUB_VV_M4,
          7507 => Opcode::PseudoVNMSUB_VV_M4_MASK,
          7508 => Opcode::PseudoVNMSUB_VV_M8,
          7509 => Opcode::PseudoVNMSUB_VV_M8_MASK,
          7510 => Opcode::PseudoVNMSUB_VV_MF2,
          7511 => Opcode::PseudoVNMSUB_VV_MF2_MASK,
          7512 => Opcode::PseudoVNMSUB_VV_MF4,
          7513 => Opcode::PseudoVNMSUB_VV_MF4_MASK,
          7514 => Opcode::PseudoVNMSUB_VV_MF8,
          7515 => Opcode::PseudoVNMSUB_VV_MF8_MASK,
          7516 => Opcode::PseudoVNMSUB_VX_M1,
          7517 => Opcode::PseudoVNMSUB_VX_M1_MASK,
          7518 => Opcode::PseudoVNMSUB_VX_M2,
          7519 => Opcode::PseudoVNMSUB_VX_M2_MASK,
          7520 => Opcode::PseudoVNMSUB_VX_M4,
          7521 => Opcode::PseudoVNMSUB_VX_M4_MASK,
          7522 => Opcode::PseudoVNMSUB_VX_M8,
          7523 => Opcode::PseudoVNMSUB_VX_M8_MASK,
          7524 => Opcode::PseudoVNMSUB_VX_MF2,
          7525 => Opcode::PseudoVNMSUB_VX_MF2_MASK,
          7526 => Opcode::PseudoVNMSUB_VX_MF4,
          7527 => Opcode::PseudoVNMSUB_VX_MF4_MASK,
          7528 => Opcode::PseudoVNMSUB_VX_MF8,
          7529 => Opcode::PseudoVNMSUB_VX_MF8_MASK,
          7530 => Opcode::PseudoVNSRA_WI_M1,
          7531 => Opcode::PseudoVNSRA_WI_M1_MASK,
          7532 => Opcode::PseudoVNSRA_WI_M2,
          7533 => Opcode::PseudoVNSRA_WI_M2_MASK,
          7534 => Opcode::PseudoVNSRA_WI_M4,
          7535 => Opcode::PseudoVNSRA_WI_M4_MASK,
          7536 => Opcode::PseudoVNSRA_WI_MF2,
          7537 => Opcode::PseudoVNSRA_WI_MF2_MASK,
          7538 => Opcode::PseudoVNSRA_WI_MF4,
          7539 => Opcode::PseudoVNSRA_WI_MF4_MASK,
          7540 => Opcode::PseudoVNSRA_WI_MF8,
          7541 => Opcode::PseudoVNSRA_WI_MF8_MASK,
          7542 => Opcode::PseudoVNSRA_WV_M1,
          7543 => Opcode::PseudoVNSRA_WV_M1_MASK,
          7544 => Opcode::PseudoVNSRA_WV_M2,
          7545 => Opcode::PseudoVNSRA_WV_M2_MASK,
          7546 => Opcode::PseudoVNSRA_WV_M4,
          7547 => Opcode::PseudoVNSRA_WV_M4_MASK,
          7548 => Opcode::PseudoVNSRA_WV_MF2,
          7549 => Opcode::PseudoVNSRA_WV_MF2_MASK,
          7550 => Opcode::PseudoVNSRA_WV_MF4,
          7551 => Opcode::PseudoVNSRA_WV_MF4_MASK,
          7552 => Opcode::PseudoVNSRA_WV_MF8,
          7553 => Opcode::PseudoVNSRA_WV_MF8_MASK,
          7554 => Opcode::PseudoVNSRA_WX_M1,
          7555 => Opcode::PseudoVNSRA_WX_M1_MASK,
          7556 => Opcode::PseudoVNSRA_WX_M2,
          7557 => Opcode::PseudoVNSRA_WX_M2_MASK,
          7558 => Opcode::PseudoVNSRA_WX_M4,
          7559 => Opcode::PseudoVNSRA_WX_M4_MASK,
          7560 => Opcode::PseudoVNSRA_WX_MF2,
          7561 => Opcode::PseudoVNSRA_WX_MF2_MASK,
          7562 => Opcode::PseudoVNSRA_WX_MF4,
          7563 => Opcode::PseudoVNSRA_WX_MF4_MASK,
          7564 => Opcode::PseudoVNSRA_WX_MF8,
          7565 => Opcode::PseudoVNSRA_WX_MF8_MASK,
          7566 => Opcode::PseudoVNSRL_WI_M1,
          7567 => Opcode::PseudoVNSRL_WI_M1_MASK,
          7568 => Opcode::PseudoVNSRL_WI_M2,
          7569 => Opcode::PseudoVNSRL_WI_M2_MASK,
          7570 => Opcode::PseudoVNSRL_WI_M4,
          7571 => Opcode::PseudoVNSRL_WI_M4_MASK,
          7572 => Opcode::PseudoVNSRL_WI_MF2,
          7573 => Opcode::PseudoVNSRL_WI_MF2_MASK,
          7574 => Opcode::PseudoVNSRL_WI_MF4,
          7575 => Opcode::PseudoVNSRL_WI_MF4_MASK,
          7576 => Opcode::PseudoVNSRL_WI_MF8,
          7577 => Opcode::PseudoVNSRL_WI_MF8_MASK,
          7578 => Opcode::PseudoVNSRL_WV_M1,
          7579 => Opcode::PseudoVNSRL_WV_M1_MASK,
          7580 => Opcode::PseudoVNSRL_WV_M2,
          7581 => Opcode::PseudoVNSRL_WV_M2_MASK,
          7582 => Opcode::PseudoVNSRL_WV_M4,
          7583 => Opcode::PseudoVNSRL_WV_M4_MASK,
          7584 => Opcode::PseudoVNSRL_WV_MF2,
          7585 => Opcode::PseudoVNSRL_WV_MF2_MASK,
          7586 => Opcode::PseudoVNSRL_WV_MF4,
          7587 => Opcode::PseudoVNSRL_WV_MF4_MASK,
          7588 => Opcode::PseudoVNSRL_WV_MF8,
          7589 => Opcode::PseudoVNSRL_WV_MF8_MASK,
          7590 => Opcode::PseudoVNSRL_WX_M1,
          7591 => Opcode::PseudoVNSRL_WX_M1_MASK,
          7592 => Opcode::PseudoVNSRL_WX_M2,
          7593 => Opcode::PseudoVNSRL_WX_M2_MASK,
          7594 => Opcode::PseudoVNSRL_WX_M4,
          7595 => Opcode::PseudoVNSRL_WX_M4_MASK,
          7596 => Opcode::PseudoVNSRL_WX_MF2,
          7597 => Opcode::PseudoVNSRL_WX_MF2_MASK,
          7598 => Opcode::PseudoVNSRL_WX_MF4,
          7599 => Opcode::PseudoVNSRL_WX_MF4_MASK,
          7600 => Opcode::PseudoVNSRL_WX_MF8,
          7601 => Opcode::PseudoVNSRL_WX_MF8_MASK,
          7602 => Opcode::PseudoVOR_VI_M1,
          7603 => Opcode::PseudoVOR_VI_M1_MASK,
          7604 => Opcode::PseudoVOR_VI_M2,
          7605 => Opcode::PseudoVOR_VI_M2_MASK,
          7606 => Opcode::PseudoVOR_VI_M4,
          7607 => Opcode::PseudoVOR_VI_M4_MASK,
          7608 => Opcode::PseudoVOR_VI_M8,
          7609 => Opcode::PseudoVOR_VI_M8_MASK,
          7610 => Opcode::PseudoVOR_VI_MF2,
          7611 => Opcode::PseudoVOR_VI_MF2_MASK,
          7612 => Opcode::PseudoVOR_VI_MF4,
          7613 => Opcode::PseudoVOR_VI_MF4_MASK,
          7614 => Opcode::PseudoVOR_VI_MF8,
          7615 => Opcode::PseudoVOR_VI_MF8_MASK,
          7616 => Opcode::PseudoVOR_VV_M1,
          7617 => Opcode::PseudoVOR_VV_M1_MASK,
          7618 => Opcode::PseudoVOR_VV_M2,
          7619 => Opcode::PseudoVOR_VV_M2_MASK,
          7620 => Opcode::PseudoVOR_VV_M4,
          7621 => Opcode::PseudoVOR_VV_M4_MASK,
          7622 => Opcode::PseudoVOR_VV_M8,
          7623 => Opcode::PseudoVOR_VV_M8_MASK,
          7624 => Opcode::PseudoVOR_VV_MF2,
          7625 => Opcode::PseudoVOR_VV_MF2_MASK,
          7626 => Opcode::PseudoVOR_VV_MF4,
          7627 => Opcode::PseudoVOR_VV_MF4_MASK,
          7628 => Opcode::PseudoVOR_VV_MF8,
          7629 => Opcode::PseudoVOR_VV_MF8_MASK,
          7630 => Opcode::PseudoVOR_VX_M1,
          7631 => Opcode::PseudoVOR_VX_M1_MASK,
          7632 => Opcode::PseudoVOR_VX_M2,
          7633 => Opcode::PseudoVOR_VX_M2_MASK,
          7634 => Opcode::PseudoVOR_VX_M4,
          7635 => Opcode::PseudoVOR_VX_M4_MASK,
          7636 => Opcode::PseudoVOR_VX_M8,
          7637 => Opcode::PseudoVOR_VX_M8_MASK,
          7638 => Opcode::PseudoVOR_VX_MF2,
          7639 => Opcode::PseudoVOR_VX_MF2_MASK,
          7640 => Opcode::PseudoVOR_VX_MF4,
          7641 => Opcode::PseudoVOR_VX_MF4_MASK,
          7642 => Opcode::PseudoVOR_VX_MF8,
          7643 => Opcode::PseudoVOR_VX_MF8_MASK,
          7644 => Opcode::PseudoVQMACCSU_2x8x2_M1,
          7645 => Opcode::PseudoVQMACCSU_2x8x2_M2,
          7646 => Opcode::PseudoVQMACCSU_2x8x2_M4,
          7647 => Opcode::PseudoVQMACCSU_2x8x2_M8,
          7648 => Opcode::PseudoVQMACCSU_4x8x4_M1,
          7649 => Opcode::PseudoVQMACCSU_4x8x4_M2,
          7650 => Opcode::PseudoVQMACCSU_4x8x4_M4,
          7651 => Opcode::PseudoVQMACCSU_4x8x4_MF2,
          7652 => Opcode::PseudoVQMACCUS_2x8x2_M1,
          7653 => Opcode::PseudoVQMACCUS_2x8x2_M2,
          7654 => Opcode::PseudoVQMACCUS_2x8x2_M4,
          7655 => Opcode::PseudoVQMACCUS_2x8x2_M8,
          7656 => Opcode::PseudoVQMACCUS_4x8x4_M1,
          7657 => Opcode::PseudoVQMACCUS_4x8x4_M2,
          7658 => Opcode::PseudoVQMACCUS_4x8x4_M4,
          7659 => Opcode::PseudoVQMACCUS_4x8x4_MF2,
          7660 => Opcode::PseudoVQMACCU_2x8x2_M1,
          7661 => Opcode::PseudoVQMACCU_2x8x2_M2,
          7662 => Opcode::PseudoVQMACCU_2x8x2_M4,
          7663 => Opcode::PseudoVQMACCU_2x8x2_M8,
          7664 => Opcode::PseudoVQMACCU_4x8x4_M1,
          7665 => Opcode::PseudoVQMACCU_4x8x4_M2,
          7666 => Opcode::PseudoVQMACCU_4x8x4_M4,
          7667 => Opcode::PseudoVQMACCU_4x8x4_MF2,
          7668 => Opcode::PseudoVQMACC_2x8x2_M1,
          7669 => Opcode::PseudoVQMACC_2x8x2_M2,
          7670 => Opcode::PseudoVQMACC_2x8x2_M4,
          7671 => Opcode::PseudoVQMACC_2x8x2_M8,
          7672 => Opcode::PseudoVQMACC_4x8x4_M1,
          7673 => Opcode::PseudoVQMACC_4x8x4_M2,
          7674 => Opcode::PseudoVQMACC_4x8x4_M4,
          7675 => Opcode::PseudoVQMACC_4x8x4_MF2,
          7676 => Opcode::PseudoVREDAND_VS_M1_E16,
          7677 => Opcode::PseudoVREDAND_VS_M1_E16_MASK,
          7678 => Opcode::PseudoVREDAND_VS_M1_E32,
          7679 => Opcode::PseudoVREDAND_VS_M1_E32_MASK,
          7680 => Opcode::PseudoVREDAND_VS_M1_E64,
          7681 => Opcode::PseudoVREDAND_VS_M1_E64_MASK,
          7682 => Opcode::PseudoVREDAND_VS_M1_E8,
          7683 => Opcode::PseudoVREDAND_VS_M1_E8_MASK,
          7684 => Opcode::PseudoVREDAND_VS_M2_E16,
          7685 => Opcode::PseudoVREDAND_VS_M2_E16_MASK,
          7686 => Opcode::PseudoVREDAND_VS_M2_E32,
          7687 => Opcode::PseudoVREDAND_VS_M2_E32_MASK,
          7688 => Opcode::PseudoVREDAND_VS_M2_E64,
          7689 => Opcode::PseudoVREDAND_VS_M2_E64_MASK,
          7690 => Opcode::PseudoVREDAND_VS_M2_E8,
          7691 => Opcode::PseudoVREDAND_VS_M2_E8_MASK,
          7692 => Opcode::PseudoVREDAND_VS_M4_E16,
          7693 => Opcode::PseudoVREDAND_VS_M4_E16_MASK,
          7694 => Opcode::PseudoVREDAND_VS_M4_E32,
          7695 => Opcode::PseudoVREDAND_VS_M4_E32_MASK,
          7696 => Opcode::PseudoVREDAND_VS_M4_E64,
          7697 => Opcode::PseudoVREDAND_VS_M4_E64_MASK,
          7698 => Opcode::PseudoVREDAND_VS_M4_E8,
          7699 => Opcode::PseudoVREDAND_VS_M4_E8_MASK,
          7700 => Opcode::PseudoVREDAND_VS_M8_E16,
          7701 => Opcode::PseudoVREDAND_VS_M8_E16_MASK,
          7702 => Opcode::PseudoVREDAND_VS_M8_E32,
          7703 => Opcode::PseudoVREDAND_VS_M8_E32_MASK,
          7704 => Opcode::PseudoVREDAND_VS_M8_E64,
          7705 => Opcode::PseudoVREDAND_VS_M8_E64_MASK,
          7706 => Opcode::PseudoVREDAND_VS_M8_E8,
          7707 => Opcode::PseudoVREDAND_VS_M8_E8_MASK,
          7708 => Opcode::PseudoVREDAND_VS_MF2_E16,
          7709 => Opcode::PseudoVREDAND_VS_MF2_E16_MASK,
          7710 => Opcode::PseudoVREDAND_VS_MF2_E32,
          7711 => Opcode::PseudoVREDAND_VS_MF2_E32_MASK,
          7712 => Opcode::PseudoVREDAND_VS_MF2_E8,
          7713 => Opcode::PseudoVREDAND_VS_MF2_E8_MASK,
          7714 => Opcode::PseudoVREDAND_VS_MF4_E16,
          7715 => Opcode::PseudoVREDAND_VS_MF4_E16_MASK,
          7716 => Opcode::PseudoVREDAND_VS_MF4_E8,
          7717 => Opcode::PseudoVREDAND_VS_MF4_E8_MASK,
          7718 => Opcode::PseudoVREDAND_VS_MF8_E8,
          7719 => Opcode::PseudoVREDAND_VS_MF8_E8_MASK,
          7720 => Opcode::PseudoVREDMAXU_VS_M1_E16,
          7721 => Opcode::PseudoVREDMAXU_VS_M1_E16_MASK,
          7722 => Opcode::PseudoVREDMAXU_VS_M1_E32,
          7723 => Opcode::PseudoVREDMAXU_VS_M1_E32_MASK,
          7724 => Opcode::PseudoVREDMAXU_VS_M1_E64,
          7725 => Opcode::PseudoVREDMAXU_VS_M1_E64_MASK,
          7726 => Opcode::PseudoVREDMAXU_VS_M1_E8,
          7727 => Opcode::PseudoVREDMAXU_VS_M1_E8_MASK,
          7728 => Opcode::PseudoVREDMAXU_VS_M2_E16,
          7729 => Opcode::PseudoVREDMAXU_VS_M2_E16_MASK,
          7730 => Opcode::PseudoVREDMAXU_VS_M2_E32,
          7731 => Opcode::PseudoVREDMAXU_VS_M2_E32_MASK,
          7732 => Opcode::PseudoVREDMAXU_VS_M2_E64,
          7733 => Opcode::PseudoVREDMAXU_VS_M2_E64_MASK,
          7734 => Opcode::PseudoVREDMAXU_VS_M2_E8,
          7735 => Opcode::PseudoVREDMAXU_VS_M2_E8_MASK,
          7736 => Opcode::PseudoVREDMAXU_VS_M4_E16,
          7737 => Opcode::PseudoVREDMAXU_VS_M4_E16_MASK,
          7738 => Opcode::PseudoVREDMAXU_VS_M4_E32,
          7739 => Opcode::PseudoVREDMAXU_VS_M4_E32_MASK,
          7740 => Opcode::PseudoVREDMAXU_VS_M4_E64,
          7741 => Opcode::PseudoVREDMAXU_VS_M4_E64_MASK,
          7742 => Opcode::PseudoVREDMAXU_VS_M4_E8,
          7743 => Opcode::PseudoVREDMAXU_VS_M4_E8_MASK,
          7744 => Opcode::PseudoVREDMAXU_VS_M8_E16,
          7745 => Opcode::PseudoVREDMAXU_VS_M8_E16_MASK,
          7746 => Opcode::PseudoVREDMAXU_VS_M8_E32,
          7747 => Opcode::PseudoVREDMAXU_VS_M8_E32_MASK,
          7748 => Opcode::PseudoVREDMAXU_VS_M8_E64,
          7749 => Opcode::PseudoVREDMAXU_VS_M8_E64_MASK,
          7750 => Opcode::PseudoVREDMAXU_VS_M8_E8,
          7751 => Opcode::PseudoVREDMAXU_VS_M8_E8_MASK,
          7752 => Opcode::PseudoVREDMAXU_VS_MF2_E16,
          7753 => Opcode::PseudoVREDMAXU_VS_MF2_E16_MASK,
          7754 => Opcode::PseudoVREDMAXU_VS_MF2_E32,
          7755 => Opcode::PseudoVREDMAXU_VS_MF2_E32_MASK,
          7756 => Opcode::PseudoVREDMAXU_VS_MF2_E8,
          7757 => Opcode::PseudoVREDMAXU_VS_MF2_E8_MASK,
          7758 => Opcode::PseudoVREDMAXU_VS_MF4_E16,
          7759 => Opcode::PseudoVREDMAXU_VS_MF4_E16_MASK,
          7760 => Opcode::PseudoVREDMAXU_VS_MF4_E8,
          7761 => Opcode::PseudoVREDMAXU_VS_MF4_E8_MASK,
          7762 => Opcode::PseudoVREDMAXU_VS_MF8_E8,
          7763 => Opcode::PseudoVREDMAXU_VS_MF8_E8_MASK,
          7764 => Opcode::PseudoVREDMAX_VS_M1_E16,
          7765 => Opcode::PseudoVREDMAX_VS_M1_E16_MASK,
          7766 => Opcode::PseudoVREDMAX_VS_M1_E32,
          7767 => Opcode::PseudoVREDMAX_VS_M1_E32_MASK,
          7768 => Opcode::PseudoVREDMAX_VS_M1_E64,
          7769 => Opcode::PseudoVREDMAX_VS_M1_E64_MASK,
          7770 => Opcode::PseudoVREDMAX_VS_M1_E8,
          7771 => Opcode::PseudoVREDMAX_VS_M1_E8_MASK,
          7772 => Opcode::PseudoVREDMAX_VS_M2_E16,
          7773 => Opcode::PseudoVREDMAX_VS_M2_E16_MASK,
          7774 => Opcode::PseudoVREDMAX_VS_M2_E32,
          7775 => Opcode::PseudoVREDMAX_VS_M2_E32_MASK,
          7776 => Opcode::PseudoVREDMAX_VS_M2_E64,
          7777 => Opcode::PseudoVREDMAX_VS_M2_E64_MASK,
          7778 => Opcode::PseudoVREDMAX_VS_M2_E8,
          7779 => Opcode::PseudoVREDMAX_VS_M2_E8_MASK,
          7780 => Opcode::PseudoVREDMAX_VS_M4_E16,
          7781 => Opcode::PseudoVREDMAX_VS_M4_E16_MASK,
          7782 => Opcode::PseudoVREDMAX_VS_M4_E32,
          7783 => Opcode::PseudoVREDMAX_VS_M4_E32_MASK,
          7784 => Opcode::PseudoVREDMAX_VS_M4_E64,
          7785 => Opcode::PseudoVREDMAX_VS_M4_E64_MASK,
          7786 => Opcode::PseudoVREDMAX_VS_M4_E8,
          7787 => Opcode::PseudoVREDMAX_VS_M4_E8_MASK,
          7788 => Opcode::PseudoVREDMAX_VS_M8_E16,
          7789 => Opcode::PseudoVREDMAX_VS_M8_E16_MASK,
          7790 => Opcode::PseudoVREDMAX_VS_M8_E32,
          7791 => Opcode::PseudoVREDMAX_VS_M8_E32_MASK,
          7792 => Opcode::PseudoVREDMAX_VS_M8_E64,
          7793 => Opcode::PseudoVREDMAX_VS_M8_E64_MASK,
          7794 => Opcode::PseudoVREDMAX_VS_M8_E8,
          7795 => Opcode::PseudoVREDMAX_VS_M8_E8_MASK,
          7796 => Opcode::PseudoVREDMAX_VS_MF2_E16,
          7797 => Opcode::PseudoVREDMAX_VS_MF2_E16_MASK,
          7798 => Opcode::PseudoVREDMAX_VS_MF2_E32,
          7799 => Opcode::PseudoVREDMAX_VS_MF2_E32_MASK,
          7800 => Opcode::PseudoVREDMAX_VS_MF2_E8,
          7801 => Opcode::PseudoVREDMAX_VS_MF2_E8_MASK,
          7802 => Opcode::PseudoVREDMAX_VS_MF4_E16,
          7803 => Opcode::PseudoVREDMAX_VS_MF4_E16_MASK,
          7804 => Opcode::PseudoVREDMAX_VS_MF4_E8,
          7805 => Opcode::PseudoVREDMAX_VS_MF4_E8_MASK,
          7806 => Opcode::PseudoVREDMAX_VS_MF8_E8,
          7807 => Opcode::PseudoVREDMAX_VS_MF8_E8_MASK,
          7808 => Opcode::PseudoVREDMINU_VS_M1_E16,
          7809 => Opcode::PseudoVREDMINU_VS_M1_E16_MASK,
          7810 => Opcode::PseudoVREDMINU_VS_M1_E32,
          7811 => Opcode::PseudoVREDMINU_VS_M1_E32_MASK,
          7812 => Opcode::PseudoVREDMINU_VS_M1_E64,
          7813 => Opcode::PseudoVREDMINU_VS_M1_E64_MASK,
          7814 => Opcode::PseudoVREDMINU_VS_M1_E8,
          7815 => Opcode::PseudoVREDMINU_VS_M1_E8_MASK,
          7816 => Opcode::PseudoVREDMINU_VS_M2_E16,
          7817 => Opcode::PseudoVREDMINU_VS_M2_E16_MASK,
          7818 => Opcode::PseudoVREDMINU_VS_M2_E32,
          7819 => Opcode::PseudoVREDMINU_VS_M2_E32_MASK,
          7820 => Opcode::PseudoVREDMINU_VS_M2_E64,
          7821 => Opcode::PseudoVREDMINU_VS_M2_E64_MASK,
          7822 => Opcode::PseudoVREDMINU_VS_M2_E8,
          7823 => Opcode::PseudoVREDMINU_VS_M2_E8_MASK,
          7824 => Opcode::PseudoVREDMINU_VS_M4_E16,
          7825 => Opcode::PseudoVREDMINU_VS_M4_E16_MASK,
          7826 => Opcode::PseudoVREDMINU_VS_M4_E32,
          7827 => Opcode::PseudoVREDMINU_VS_M4_E32_MASK,
          7828 => Opcode::PseudoVREDMINU_VS_M4_E64,
          7829 => Opcode::PseudoVREDMINU_VS_M4_E64_MASK,
          7830 => Opcode::PseudoVREDMINU_VS_M4_E8,
          7831 => Opcode::PseudoVREDMINU_VS_M4_E8_MASK,
          7832 => Opcode::PseudoVREDMINU_VS_M8_E16,
          7833 => Opcode::PseudoVREDMINU_VS_M8_E16_MASK,
          7834 => Opcode::PseudoVREDMINU_VS_M8_E32,
          7835 => Opcode::PseudoVREDMINU_VS_M8_E32_MASK,
          7836 => Opcode::PseudoVREDMINU_VS_M8_E64,
          7837 => Opcode::PseudoVREDMINU_VS_M8_E64_MASK,
          7838 => Opcode::PseudoVREDMINU_VS_M8_E8,
          7839 => Opcode::PseudoVREDMINU_VS_M8_E8_MASK,
          7840 => Opcode::PseudoVREDMINU_VS_MF2_E16,
          7841 => Opcode::PseudoVREDMINU_VS_MF2_E16_MASK,
          7842 => Opcode::PseudoVREDMINU_VS_MF2_E32,
          7843 => Opcode::PseudoVREDMINU_VS_MF2_E32_MASK,
          7844 => Opcode::PseudoVREDMINU_VS_MF2_E8,
          7845 => Opcode::PseudoVREDMINU_VS_MF2_E8_MASK,
          7846 => Opcode::PseudoVREDMINU_VS_MF4_E16,
          7847 => Opcode::PseudoVREDMINU_VS_MF4_E16_MASK,
          7848 => Opcode::PseudoVREDMINU_VS_MF4_E8,
          7849 => Opcode::PseudoVREDMINU_VS_MF4_E8_MASK,
          7850 => Opcode::PseudoVREDMINU_VS_MF8_E8,
          7851 => Opcode::PseudoVREDMINU_VS_MF8_E8_MASK,
          7852 => Opcode::PseudoVREDMIN_VS_M1_E16,
          7853 => Opcode::PseudoVREDMIN_VS_M1_E16_MASK,
          7854 => Opcode::PseudoVREDMIN_VS_M1_E32,
          7855 => Opcode::PseudoVREDMIN_VS_M1_E32_MASK,
          7856 => Opcode::PseudoVREDMIN_VS_M1_E64,
          7857 => Opcode::PseudoVREDMIN_VS_M1_E64_MASK,
          7858 => Opcode::PseudoVREDMIN_VS_M1_E8,
          7859 => Opcode::PseudoVREDMIN_VS_M1_E8_MASK,
          7860 => Opcode::PseudoVREDMIN_VS_M2_E16,
          7861 => Opcode::PseudoVREDMIN_VS_M2_E16_MASK,
          7862 => Opcode::PseudoVREDMIN_VS_M2_E32,
          7863 => Opcode::PseudoVREDMIN_VS_M2_E32_MASK,
          7864 => Opcode::PseudoVREDMIN_VS_M2_E64,
          7865 => Opcode::PseudoVREDMIN_VS_M2_E64_MASK,
          7866 => Opcode::PseudoVREDMIN_VS_M2_E8,
          7867 => Opcode::PseudoVREDMIN_VS_M2_E8_MASK,
          7868 => Opcode::PseudoVREDMIN_VS_M4_E16,
          7869 => Opcode::PseudoVREDMIN_VS_M4_E16_MASK,
          7870 => Opcode::PseudoVREDMIN_VS_M4_E32,
          7871 => Opcode::PseudoVREDMIN_VS_M4_E32_MASK,
          7872 => Opcode::PseudoVREDMIN_VS_M4_E64,
          7873 => Opcode::PseudoVREDMIN_VS_M4_E64_MASK,
          7874 => Opcode::PseudoVREDMIN_VS_M4_E8,
          7875 => Opcode::PseudoVREDMIN_VS_M4_E8_MASK,
          7876 => Opcode::PseudoVREDMIN_VS_M8_E16,
          7877 => Opcode::PseudoVREDMIN_VS_M8_E16_MASK,
          7878 => Opcode::PseudoVREDMIN_VS_M8_E32,
          7879 => Opcode::PseudoVREDMIN_VS_M8_E32_MASK,
          7880 => Opcode::PseudoVREDMIN_VS_M8_E64,
          7881 => Opcode::PseudoVREDMIN_VS_M8_E64_MASK,
          7882 => Opcode::PseudoVREDMIN_VS_M8_E8,
          7883 => Opcode::PseudoVREDMIN_VS_M8_E8_MASK,
          7884 => Opcode::PseudoVREDMIN_VS_MF2_E16,
          7885 => Opcode::PseudoVREDMIN_VS_MF2_E16_MASK,
          7886 => Opcode::PseudoVREDMIN_VS_MF2_E32,
          7887 => Opcode::PseudoVREDMIN_VS_MF2_E32_MASK,
          7888 => Opcode::PseudoVREDMIN_VS_MF2_E8,
          7889 => Opcode::PseudoVREDMIN_VS_MF2_E8_MASK,
          7890 => Opcode::PseudoVREDMIN_VS_MF4_E16,
          7891 => Opcode::PseudoVREDMIN_VS_MF4_E16_MASK,
          7892 => Opcode::PseudoVREDMIN_VS_MF4_E8,
          7893 => Opcode::PseudoVREDMIN_VS_MF4_E8_MASK,
          7894 => Opcode::PseudoVREDMIN_VS_MF8_E8,
          7895 => Opcode::PseudoVREDMIN_VS_MF8_E8_MASK,
          7896 => Opcode::PseudoVREDOR_VS_M1_E16,
          7897 => Opcode::PseudoVREDOR_VS_M1_E16_MASK,
          7898 => Opcode::PseudoVREDOR_VS_M1_E32,
          7899 => Opcode::PseudoVREDOR_VS_M1_E32_MASK,
          7900 => Opcode::PseudoVREDOR_VS_M1_E64,
          7901 => Opcode::PseudoVREDOR_VS_M1_E64_MASK,
          7902 => Opcode::PseudoVREDOR_VS_M1_E8,
          7903 => Opcode::PseudoVREDOR_VS_M1_E8_MASK,
          7904 => Opcode::PseudoVREDOR_VS_M2_E16,
          7905 => Opcode::PseudoVREDOR_VS_M2_E16_MASK,
          7906 => Opcode::PseudoVREDOR_VS_M2_E32,
          7907 => Opcode::PseudoVREDOR_VS_M2_E32_MASK,
          7908 => Opcode::PseudoVREDOR_VS_M2_E64,
          7909 => Opcode::PseudoVREDOR_VS_M2_E64_MASK,
          7910 => Opcode::PseudoVREDOR_VS_M2_E8,
          7911 => Opcode::PseudoVREDOR_VS_M2_E8_MASK,
          7912 => Opcode::PseudoVREDOR_VS_M4_E16,
          7913 => Opcode::PseudoVREDOR_VS_M4_E16_MASK,
          7914 => Opcode::PseudoVREDOR_VS_M4_E32,
          7915 => Opcode::PseudoVREDOR_VS_M4_E32_MASK,
          7916 => Opcode::PseudoVREDOR_VS_M4_E64,
          7917 => Opcode::PseudoVREDOR_VS_M4_E64_MASK,
          7918 => Opcode::PseudoVREDOR_VS_M4_E8,
          7919 => Opcode::PseudoVREDOR_VS_M4_E8_MASK,
          7920 => Opcode::PseudoVREDOR_VS_M8_E16,
          7921 => Opcode::PseudoVREDOR_VS_M8_E16_MASK,
          7922 => Opcode::PseudoVREDOR_VS_M8_E32,
          7923 => Opcode::PseudoVREDOR_VS_M8_E32_MASK,
          7924 => Opcode::PseudoVREDOR_VS_M8_E64,
          7925 => Opcode::PseudoVREDOR_VS_M8_E64_MASK,
          7926 => Opcode::PseudoVREDOR_VS_M8_E8,
          7927 => Opcode::PseudoVREDOR_VS_M8_E8_MASK,
          7928 => Opcode::PseudoVREDOR_VS_MF2_E16,
          7929 => Opcode::PseudoVREDOR_VS_MF2_E16_MASK,
          7930 => Opcode::PseudoVREDOR_VS_MF2_E32,
          7931 => Opcode::PseudoVREDOR_VS_MF2_E32_MASK,
          7932 => Opcode::PseudoVREDOR_VS_MF2_E8,
          7933 => Opcode::PseudoVREDOR_VS_MF2_E8_MASK,
          7934 => Opcode::PseudoVREDOR_VS_MF4_E16,
          7935 => Opcode::PseudoVREDOR_VS_MF4_E16_MASK,
          7936 => Opcode::PseudoVREDOR_VS_MF4_E8,
          7937 => Opcode::PseudoVREDOR_VS_MF4_E8_MASK,
          7938 => Opcode::PseudoVREDOR_VS_MF8_E8,
          7939 => Opcode::PseudoVREDOR_VS_MF8_E8_MASK,
          7940 => Opcode::PseudoVREDSUM_VS_M1_E16,
          7941 => Opcode::PseudoVREDSUM_VS_M1_E16_MASK,
          7942 => Opcode::PseudoVREDSUM_VS_M1_E32,
          7943 => Opcode::PseudoVREDSUM_VS_M1_E32_MASK,
          7944 => Opcode::PseudoVREDSUM_VS_M1_E64,
          7945 => Opcode::PseudoVREDSUM_VS_M1_E64_MASK,
          7946 => Opcode::PseudoVREDSUM_VS_M1_E8,
          7947 => Opcode::PseudoVREDSUM_VS_M1_E8_MASK,
          7948 => Opcode::PseudoVREDSUM_VS_M2_E16,
          7949 => Opcode::PseudoVREDSUM_VS_M2_E16_MASK,
          7950 => Opcode::PseudoVREDSUM_VS_M2_E32,
          7951 => Opcode::PseudoVREDSUM_VS_M2_E32_MASK,
          7952 => Opcode::PseudoVREDSUM_VS_M2_E64,
          7953 => Opcode::PseudoVREDSUM_VS_M2_E64_MASK,
          7954 => Opcode::PseudoVREDSUM_VS_M2_E8,
          7955 => Opcode::PseudoVREDSUM_VS_M2_E8_MASK,
          7956 => Opcode::PseudoVREDSUM_VS_M4_E16,
          7957 => Opcode::PseudoVREDSUM_VS_M4_E16_MASK,
          7958 => Opcode::PseudoVREDSUM_VS_M4_E32,
          7959 => Opcode::PseudoVREDSUM_VS_M4_E32_MASK,
          7960 => Opcode::PseudoVREDSUM_VS_M4_E64,
          7961 => Opcode::PseudoVREDSUM_VS_M4_E64_MASK,
          7962 => Opcode::PseudoVREDSUM_VS_M4_E8,
          7963 => Opcode::PseudoVREDSUM_VS_M4_E8_MASK,
          7964 => Opcode::PseudoVREDSUM_VS_M8_E16,
          7965 => Opcode::PseudoVREDSUM_VS_M8_E16_MASK,
          7966 => Opcode::PseudoVREDSUM_VS_M8_E32,
          7967 => Opcode::PseudoVREDSUM_VS_M8_E32_MASK,
          7968 => Opcode::PseudoVREDSUM_VS_M8_E64,
          7969 => Opcode::PseudoVREDSUM_VS_M8_E64_MASK,
          7970 => Opcode::PseudoVREDSUM_VS_M8_E8,
          7971 => Opcode::PseudoVREDSUM_VS_M8_E8_MASK,
          7972 => Opcode::PseudoVREDSUM_VS_MF2_E16,
          7973 => Opcode::PseudoVREDSUM_VS_MF2_E16_MASK,
          7974 => Opcode::PseudoVREDSUM_VS_MF2_E32,
          7975 => Opcode::PseudoVREDSUM_VS_MF2_E32_MASK,
          7976 => Opcode::PseudoVREDSUM_VS_MF2_E8,
          7977 => Opcode::PseudoVREDSUM_VS_MF2_E8_MASK,
          7978 => Opcode::PseudoVREDSUM_VS_MF4_E16,
          7979 => Opcode::PseudoVREDSUM_VS_MF4_E16_MASK,
          7980 => Opcode::PseudoVREDSUM_VS_MF4_E8,
          7981 => Opcode::PseudoVREDSUM_VS_MF4_E8_MASK,
          7982 => Opcode::PseudoVREDSUM_VS_MF8_E8,
          7983 => Opcode::PseudoVREDSUM_VS_MF8_E8_MASK,
          7984 => Opcode::PseudoVREDXOR_VS_M1_E16,
          7985 => Opcode::PseudoVREDXOR_VS_M1_E16_MASK,
          7986 => Opcode::PseudoVREDXOR_VS_M1_E32,
          7987 => Opcode::PseudoVREDXOR_VS_M1_E32_MASK,
          7988 => Opcode::PseudoVREDXOR_VS_M1_E64,
          7989 => Opcode::PseudoVREDXOR_VS_M1_E64_MASK,
          7990 => Opcode::PseudoVREDXOR_VS_M1_E8,
          7991 => Opcode::PseudoVREDXOR_VS_M1_E8_MASK,
          7992 => Opcode::PseudoVREDXOR_VS_M2_E16,
          7993 => Opcode::PseudoVREDXOR_VS_M2_E16_MASK,
          7994 => Opcode::PseudoVREDXOR_VS_M2_E32,
          7995 => Opcode::PseudoVREDXOR_VS_M2_E32_MASK,
          7996 => Opcode::PseudoVREDXOR_VS_M2_E64,
          7997 => Opcode::PseudoVREDXOR_VS_M2_E64_MASK,
          7998 => Opcode::PseudoVREDXOR_VS_M2_E8,
          7999 => Opcode::PseudoVREDXOR_VS_M2_E8_MASK,
          8000 => Opcode::PseudoVREDXOR_VS_M4_E16,
          8001 => Opcode::PseudoVREDXOR_VS_M4_E16_MASK,
          8002 => Opcode::PseudoVREDXOR_VS_M4_E32,
          8003 => Opcode::PseudoVREDXOR_VS_M4_E32_MASK,
          8004 => Opcode::PseudoVREDXOR_VS_M4_E64,
          8005 => Opcode::PseudoVREDXOR_VS_M4_E64_MASK,
          8006 => Opcode::PseudoVREDXOR_VS_M4_E8,
          8007 => Opcode::PseudoVREDXOR_VS_M4_E8_MASK,
          8008 => Opcode::PseudoVREDXOR_VS_M8_E16,
          8009 => Opcode::PseudoVREDXOR_VS_M8_E16_MASK,
          8010 => Opcode::PseudoVREDXOR_VS_M8_E32,
          8011 => Opcode::PseudoVREDXOR_VS_M8_E32_MASK,
          8012 => Opcode::PseudoVREDXOR_VS_M8_E64,
          8013 => Opcode::PseudoVREDXOR_VS_M8_E64_MASK,
          8014 => Opcode::PseudoVREDXOR_VS_M8_E8,
          8015 => Opcode::PseudoVREDXOR_VS_M8_E8_MASK,
          8016 => Opcode::PseudoVREDXOR_VS_MF2_E16,
          8017 => Opcode::PseudoVREDXOR_VS_MF2_E16_MASK,
          8018 => Opcode::PseudoVREDXOR_VS_MF2_E32,
          8019 => Opcode::PseudoVREDXOR_VS_MF2_E32_MASK,
          8020 => Opcode::PseudoVREDXOR_VS_MF2_E8,
          8021 => Opcode::PseudoVREDXOR_VS_MF2_E8_MASK,
          8022 => Opcode::PseudoVREDXOR_VS_MF4_E16,
          8023 => Opcode::PseudoVREDXOR_VS_MF4_E16_MASK,
          8024 => Opcode::PseudoVREDXOR_VS_MF4_E8,
          8025 => Opcode::PseudoVREDXOR_VS_MF4_E8_MASK,
          8026 => Opcode::PseudoVREDXOR_VS_MF8_E8,
          8027 => Opcode::PseudoVREDXOR_VS_MF8_E8_MASK,
          8028 => Opcode::PseudoVRELOAD2_M1,
          8029 => Opcode::PseudoVRELOAD2_M2,
          8030 => Opcode::PseudoVRELOAD2_M4,
          8031 => Opcode::PseudoVRELOAD2_MF2,
          8032 => Opcode::PseudoVRELOAD2_MF4,
          8033 => Opcode::PseudoVRELOAD2_MF8,
          8034 => Opcode::PseudoVRELOAD3_M1,
          8035 => Opcode::PseudoVRELOAD3_M2,
          8036 => Opcode::PseudoVRELOAD3_MF2,
          8037 => Opcode::PseudoVRELOAD3_MF4,
          8038 => Opcode::PseudoVRELOAD3_MF8,
          8039 => Opcode::PseudoVRELOAD4_M1,
          8040 => Opcode::PseudoVRELOAD4_M2,
          8041 => Opcode::PseudoVRELOAD4_MF2,
          8042 => Opcode::PseudoVRELOAD4_MF4,
          8043 => Opcode::PseudoVRELOAD4_MF8,
          8044 => Opcode::PseudoVRELOAD5_M1,
          8045 => Opcode::PseudoVRELOAD5_MF2,
          8046 => Opcode::PseudoVRELOAD5_MF4,
          8047 => Opcode::PseudoVRELOAD5_MF8,
          8048 => Opcode::PseudoVRELOAD6_M1,
          8049 => Opcode::PseudoVRELOAD6_MF2,
          8050 => Opcode::PseudoVRELOAD6_MF4,
          8051 => Opcode::PseudoVRELOAD6_MF8,
          8052 => Opcode::PseudoVRELOAD7_M1,
          8053 => Opcode::PseudoVRELOAD7_MF2,
          8054 => Opcode::PseudoVRELOAD7_MF4,
          8055 => Opcode::PseudoVRELOAD7_MF8,
          8056 => Opcode::PseudoVRELOAD8_M1,
          8057 => Opcode::PseudoVRELOAD8_MF2,
          8058 => Opcode::PseudoVRELOAD8_MF4,
          8059 => Opcode::PseudoVRELOAD8_MF8,
          8060 => Opcode::PseudoVREMU_VV_M1_E16,
          8061 => Opcode::PseudoVREMU_VV_M1_E16_MASK,
          8062 => Opcode::PseudoVREMU_VV_M1_E32,
          8063 => Opcode::PseudoVREMU_VV_M1_E32_MASK,
          8064 => Opcode::PseudoVREMU_VV_M1_E64,
          8065 => Opcode::PseudoVREMU_VV_M1_E64_MASK,
          8066 => Opcode::PseudoVREMU_VV_M1_E8,
          8067 => Opcode::PseudoVREMU_VV_M1_E8_MASK,
          8068 => Opcode::PseudoVREMU_VV_M2_E16,
          8069 => Opcode::PseudoVREMU_VV_M2_E16_MASK,
          8070 => Opcode::PseudoVREMU_VV_M2_E32,
          8071 => Opcode::PseudoVREMU_VV_M2_E32_MASK,
          8072 => Opcode::PseudoVREMU_VV_M2_E64,
          8073 => Opcode::PseudoVREMU_VV_M2_E64_MASK,
          8074 => Opcode::PseudoVREMU_VV_M2_E8,
          8075 => Opcode::PseudoVREMU_VV_M2_E8_MASK,
          8076 => Opcode::PseudoVREMU_VV_M4_E16,
          8077 => Opcode::PseudoVREMU_VV_M4_E16_MASK,
          8078 => Opcode::PseudoVREMU_VV_M4_E32,
          8079 => Opcode::PseudoVREMU_VV_M4_E32_MASK,
          8080 => Opcode::PseudoVREMU_VV_M4_E64,
          8081 => Opcode::PseudoVREMU_VV_M4_E64_MASK,
          8082 => Opcode::PseudoVREMU_VV_M4_E8,
          8083 => Opcode::PseudoVREMU_VV_M4_E8_MASK,
          8084 => Opcode::PseudoVREMU_VV_M8_E16,
          8085 => Opcode::PseudoVREMU_VV_M8_E16_MASK,
          8086 => Opcode::PseudoVREMU_VV_M8_E32,
          8087 => Opcode::PseudoVREMU_VV_M8_E32_MASK,
          8088 => Opcode::PseudoVREMU_VV_M8_E64,
          8089 => Opcode::PseudoVREMU_VV_M8_E64_MASK,
          8090 => Opcode::PseudoVREMU_VV_M8_E8,
          8091 => Opcode::PseudoVREMU_VV_M8_E8_MASK,
          8092 => Opcode::PseudoVREMU_VV_MF2_E16,
          8093 => Opcode::PseudoVREMU_VV_MF2_E16_MASK,
          8094 => Opcode::PseudoVREMU_VV_MF2_E32,
          8095 => Opcode::PseudoVREMU_VV_MF2_E32_MASK,
          8096 => Opcode::PseudoVREMU_VV_MF2_E8,
          8097 => Opcode::PseudoVREMU_VV_MF2_E8_MASK,
          8098 => Opcode::PseudoVREMU_VV_MF4_E16,
          8099 => Opcode::PseudoVREMU_VV_MF4_E16_MASK,
          8100 => Opcode::PseudoVREMU_VV_MF4_E8,
          8101 => Opcode::PseudoVREMU_VV_MF4_E8_MASK,
          8102 => Opcode::PseudoVREMU_VV_MF8_E8,
          8103 => Opcode::PseudoVREMU_VV_MF8_E8_MASK,
          8104 => Opcode::PseudoVREMU_VX_M1_E16,
          8105 => Opcode::PseudoVREMU_VX_M1_E16_MASK,
          8106 => Opcode::PseudoVREMU_VX_M1_E32,
          8107 => Opcode::PseudoVREMU_VX_M1_E32_MASK,
          8108 => Opcode::PseudoVREMU_VX_M1_E64,
          8109 => Opcode::PseudoVREMU_VX_M1_E64_MASK,
          8110 => Opcode::PseudoVREMU_VX_M1_E8,
          8111 => Opcode::PseudoVREMU_VX_M1_E8_MASK,
          8112 => Opcode::PseudoVREMU_VX_M2_E16,
          8113 => Opcode::PseudoVREMU_VX_M2_E16_MASK,
          8114 => Opcode::PseudoVREMU_VX_M2_E32,
          8115 => Opcode::PseudoVREMU_VX_M2_E32_MASK,
          8116 => Opcode::PseudoVREMU_VX_M2_E64,
          8117 => Opcode::PseudoVREMU_VX_M2_E64_MASK,
          8118 => Opcode::PseudoVREMU_VX_M2_E8,
          8119 => Opcode::PseudoVREMU_VX_M2_E8_MASK,
          8120 => Opcode::PseudoVREMU_VX_M4_E16,
          8121 => Opcode::PseudoVREMU_VX_M4_E16_MASK,
          8122 => Opcode::PseudoVREMU_VX_M4_E32,
          8123 => Opcode::PseudoVREMU_VX_M4_E32_MASK,
          8124 => Opcode::PseudoVREMU_VX_M4_E64,
          8125 => Opcode::PseudoVREMU_VX_M4_E64_MASK,
          8126 => Opcode::PseudoVREMU_VX_M4_E8,
          8127 => Opcode::PseudoVREMU_VX_M4_E8_MASK,
          8128 => Opcode::PseudoVREMU_VX_M8_E16,
          8129 => Opcode::PseudoVREMU_VX_M8_E16_MASK,
          8130 => Opcode::PseudoVREMU_VX_M8_E32,
          8131 => Opcode::PseudoVREMU_VX_M8_E32_MASK,
          8132 => Opcode::PseudoVREMU_VX_M8_E64,
          8133 => Opcode::PseudoVREMU_VX_M8_E64_MASK,
          8134 => Opcode::PseudoVREMU_VX_M8_E8,
          8135 => Opcode::PseudoVREMU_VX_M8_E8_MASK,
          8136 => Opcode::PseudoVREMU_VX_MF2_E16,
          8137 => Opcode::PseudoVREMU_VX_MF2_E16_MASK,
          8138 => Opcode::PseudoVREMU_VX_MF2_E32,
          8139 => Opcode::PseudoVREMU_VX_MF2_E32_MASK,
          8140 => Opcode::PseudoVREMU_VX_MF2_E8,
          8141 => Opcode::PseudoVREMU_VX_MF2_E8_MASK,
          8142 => Opcode::PseudoVREMU_VX_MF4_E16,
          8143 => Opcode::PseudoVREMU_VX_MF4_E16_MASK,
          8144 => Opcode::PseudoVREMU_VX_MF4_E8,
          8145 => Opcode::PseudoVREMU_VX_MF4_E8_MASK,
          8146 => Opcode::PseudoVREMU_VX_MF8_E8,
          8147 => Opcode::PseudoVREMU_VX_MF8_E8_MASK,
          8148 => Opcode::PseudoVREM_VV_M1_E16,
          8149 => Opcode::PseudoVREM_VV_M1_E16_MASK,
          8150 => Opcode::PseudoVREM_VV_M1_E32,
          8151 => Opcode::PseudoVREM_VV_M1_E32_MASK,
          8152 => Opcode::PseudoVREM_VV_M1_E64,
          8153 => Opcode::PseudoVREM_VV_M1_E64_MASK,
          8154 => Opcode::PseudoVREM_VV_M1_E8,
          8155 => Opcode::PseudoVREM_VV_M1_E8_MASK,
          8156 => Opcode::PseudoVREM_VV_M2_E16,
          8157 => Opcode::PseudoVREM_VV_M2_E16_MASK,
          8158 => Opcode::PseudoVREM_VV_M2_E32,
          8159 => Opcode::PseudoVREM_VV_M2_E32_MASK,
          8160 => Opcode::PseudoVREM_VV_M2_E64,
          8161 => Opcode::PseudoVREM_VV_M2_E64_MASK,
          8162 => Opcode::PseudoVREM_VV_M2_E8,
          8163 => Opcode::PseudoVREM_VV_M2_E8_MASK,
          8164 => Opcode::PseudoVREM_VV_M4_E16,
          8165 => Opcode::PseudoVREM_VV_M4_E16_MASK,
          8166 => Opcode::PseudoVREM_VV_M4_E32,
          8167 => Opcode::PseudoVREM_VV_M4_E32_MASK,
          8168 => Opcode::PseudoVREM_VV_M4_E64,
          8169 => Opcode::PseudoVREM_VV_M4_E64_MASK,
          8170 => Opcode::PseudoVREM_VV_M4_E8,
          8171 => Opcode::PseudoVREM_VV_M4_E8_MASK,
          8172 => Opcode::PseudoVREM_VV_M8_E16,
          8173 => Opcode::PseudoVREM_VV_M8_E16_MASK,
          8174 => Opcode::PseudoVREM_VV_M8_E32,
          8175 => Opcode::PseudoVREM_VV_M8_E32_MASK,
          8176 => Opcode::PseudoVREM_VV_M8_E64,
          8177 => Opcode::PseudoVREM_VV_M8_E64_MASK,
          8178 => Opcode::PseudoVREM_VV_M8_E8,
          8179 => Opcode::PseudoVREM_VV_M8_E8_MASK,
          8180 => Opcode::PseudoVREM_VV_MF2_E16,
          8181 => Opcode::PseudoVREM_VV_MF2_E16_MASK,
          8182 => Opcode::PseudoVREM_VV_MF2_E32,
          8183 => Opcode::PseudoVREM_VV_MF2_E32_MASK,
          8184 => Opcode::PseudoVREM_VV_MF2_E8,
          8185 => Opcode::PseudoVREM_VV_MF2_E8_MASK,
          8186 => Opcode::PseudoVREM_VV_MF4_E16,
          8187 => Opcode::PseudoVREM_VV_MF4_E16_MASK,
          8188 => Opcode::PseudoVREM_VV_MF4_E8,
          8189 => Opcode::PseudoVREM_VV_MF4_E8_MASK,
          8190 => Opcode::PseudoVREM_VV_MF8_E8,
          8191 => Opcode::PseudoVREM_VV_MF8_E8_MASK,
          8192 => Opcode::PseudoVREM_VX_M1_E16,
          8193 => Opcode::PseudoVREM_VX_M1_E16_MASK,
          8194 => Opcode::PseudoVREM_VX_M1_E32,
          8195 => Opcode::PseudoVREM_VX_M1_E32_MASK,
          8196 => Opcode::PseudoVREM_VX_M1_E64,
          8197 => Opcode::PseudoVREM_VX_M1_E64_MASK,
          8198 => Opcode::PseudoVREM_VX_M1_E8,
          8199 => Opcode::PseudoVREM_VX_M1_E8_MASK,
          8200 => Opcode::PseudoVREM_VX_M2_E16,
          8201 => Opcode::PseudoVREM_VX_M2_E16_MASK,
          8202 => Opcode::PseudoVREM_VX_M2_E32,
          8203 => Opcode::PseudoVREM_VX_M2_E32_MASK,
          8204 => Opcode::PseudoVREM_VX_M2_E64,
          8205 => Opcode::PseudoVREM_VX_M2_E64_MASK,
          8206 => Opcode::PseudoVREM_VX_M2_E8,
          8207 => Opcode::PseudoVREM_VX_M2_E8_MASK,
          8208 => Opcode::PseudoVREM_VX_M4_E16,
          8209 => Opcode::PseudoVREM_VX_M4_E16_MASK,
          8210 => Opcode::PseudoVREM_VX_M4_E32,
          8211 => Opcode::PseudoVREM_VX_M4_E32_MASK,
          8212 => Opcode::PseudoVREM_VX_M4_E64,
          8213 => Opcode::PseudoVREM_VX_M4_E64_MASK,
          8214 => Opcode::PseudoVREM_VX_M4_E8,
          8215 => Opcode::PseudoVREM_VX_M4_E8_MASK,
          8216 => Opcode::PseudoVREM_VX_M8_E16,
          8217 => Opcode::PseudoVREM_VX_M8_E16_MASK,
          8218 => Opcode::PseudoVREM_VX_M8_E32,
          8219 => Opcode::PseudoVREM_VX_M8_E32_MASK,
          8220 => Opcode::PseudoVREM_VX_M8_E64,
          8221 => Opcode::PseudoVREM_VX_M8_E64_MASK,
          8222 => Opcode::PseudoVREM_VX_M8_E8,
          8223 => Opcode::PseudoVREM_VX_M8_E8_MASK,
          8224 => Opcode::PseudoVREM_VX_MF2_E16,
          8225 => Opcode::PseudoVREM_VX_MF2_E16_MASK,
          8226 => Opcode::PseudoVREM_VX_MF2_E32,
          8227 => Opcode::PseudoVREM_VX_MF2_E32_MASK,
          8228 => Opcode::PseudoVREM_VX_MF2_E8,
          8229 => Opcode::PseudoVREM_VX_MF2_E8_MASK,
          8230 => Opcode::PseudoVREM_VX_MF4_E16,
          8231 => Opcode::PseudoVREM_VX_MF4_E16_MASK,
          8232 => Opcode::PseudoVREM_VX_MF4_E8,
          8233 => Opcode::PseudoVREM_VX_MF4_E8_MASK,
          8234 => Opcode::PseudoVREM_VX_MF8_E8,
          8235 => Opcode::PseudoVREM_VX_MF8_E8_MASK,
          8236 => Opcode::PseudoVREV8_V_M1,
          8237 => Opcode::PseudoVREV8_V_M1_MASK,
          8238 => Opcode::PseudoVREV8_V_M2,
          8239 => Opcode::PseudoVREV8_V_M2_MASK,
          8240 => Opcode::PseudoVREV8_V_M4,
          8241 => Opcode::PseudoVREV8_V_M4_MASK,
          8242 => Opcode::PseudoVREV8_V_M8,
          8243 => Opcode::PseudoVREV8_V_M8_MASK,
          8244 => Opcode::PseudoVREV8_V_MF2,
          8245 => Opcode::PseudoVREV8_V_MF2_MASK,
          8246 => Opcode::PseudoVREV8_V_MF4,
          8247 => Opcode::PseudoVREV8_V_MF4_MASK,
          8248 => Opcode::PseudoVREV8_V_MF8,
          8249 => Opcode::PseudoVREV8_V_MF8_MASK,
          8250 => Opcode::PseudoVRGATHEREI16_VV_M1_E16_M1,
          8251 => Opcode::PseudoVRGATHEREI16_VV_M1_E16_M1_MASK,
          8252 => Opcode::PseudoVRGATHEREI16_VV_M1_E16_M2,
          8253 => Opcode::PseudoVRGATHEREI16_VV_M1_E16_M2_MASK,
          8254 => Opcode::PseudoVRGATHEREI16_VV_M1_E16_MF2,
          8255 => Opcode::PseudoVRGATHEREI16_VV_M1_E16_MF2_MASK,
          8256 => Opcode::PseudoVRGATHEREI16_VV_M1_E16_MF4,
          8257 => Opcode::PseudoVRGATHEREI16_VV_M1_E16_MF4_MASK,
          8258 => Opcode::PseudoVRGATHEREI16_VV_M1_E32_M1,
          8259 => Opcode::PseudoVRGATHEREI16_VV_M1_E32_M1_MASK,
          8260 => Opcode::PseudoVRGATHEREI16_VV_M1_E32_M2,
          8261 => Opcode::PseudoVRGATHEREI16_VV_M1_E32_M2_MASK,
          8262 => Opcode::PseudoVRGATHEREI16_VV_M1_E32_MF2,
          8263 => Opcode::PseudoVRGATHEREI16_VV_M1_E32_MF2_MASK,
          8264 => Opcode::PseudoVRGATHEREI16_VV_M1_E32_MF4,
          8265 => Opcode::PseudoVRGATHEREI16_VV_M1_E32_MF4_MASK,
          8266 => Opcode::PseudoVRGATHEREI16_VV_M1_E64_M1,
          8267 => Opcode::PseudoVRGATHEREI16_VV_M1_E64_M1_MASK,
          8268 => Opcode::PseudoVRGATHEREI16_VV_M1_E64_M2,
          8269 => Opcode::PseudoVRGATHEREI16_VV_M1_E64_M2_MASK,
          8270 => Opcode::PseudoVRGATHEREI16_VV_M1_E64_MF2,
          8271 => Opcode::PseudoVRGATHEREI16_VV_M1_E64_MF2_MASK,
          8272 => Opcode::PseudoVRGATHEREI16_VV_M1_E64_MF4,
          8273 => Opcode::PseudoVRGATHEREI16_VV_M1_E64_MF4_MASK,
          8274 => Opcode::PseudoVRGATHEREI16_VV_M1_E8_M1,
          8275 => Opcode::PseudoVRGATHEREI16_VV_M1_E8_M1_MASK,
          8276 => Opcode::PseudoVRGATHEREI16_VV_M1_E8_M2,
          8277 => Opcode::PseudoVRGATHEREI16_VV_M1_E8_M2_MASK,
          8278 => Opcode::PseudoVRGATHEREI16_VV_M1_E8_MF2,
          8279 => Opcode::PseudoVRGATHEREI16_VV_M1_E8_MF2_MASK,
          8280 => Opcode::PseudoVRGATHEREI16_VV_M1_E8_MF4,
          8281 => Opcode::PseudoVRGATHEREI16_VV_M1_E8_MF4_MASK,
          8282 => Opcode::PseudoVRGATHEREI16_VV_M2_E16_M1,
          8283 => Opcode::PseudoVRGATHEREI16_VV_M2_E16_M1_MASK,
          8284 => Opcode::PseudoVRGATHEREI16_VV_M2_E16_M2,
          8285 => Opcode::PseudoVRGATHEREI16_VV_M2_E16_M2_MASK,
          8286 => Opcode::PseudoVRGATHEREI16_VV_M2_E16_M4,
          8287 => Opcode::PseudoVRGATHEREI16_VV_M2_E16_M4_MASK,
          8288 => Opcode::PseudoVRGATHEREI16_VV_M2_E16_MF2,
          8289 => Opcode::PseudoVRGATHEREI16_VV_M2_E16_MF2_MASK,
          8290 => Opcode::PseudoVRGATHEREI16_VV_M2_E32_M1,
          8291 => Opcode::PseudoVRGATHEREI16_VV_M2_E32_M1_MASK,
          8292 => Opcode::PseudoVRGATHEREI16_VV_M2_E32_M2,
          8293 => Opcode::PseudoVRGATHEREI16_VV_M2_E32_M2_MASK,
          8294 => Opcode::PseudoVRGATHEREI16_VV_M2_E32_M4,
          8295 => Opcode::PseudoVRGATHEREI16_VV_M2_E32_M4_MASK,
          8296 => Opcode::PseudoVRGATHEREI16_VV_M2_E32_MF2,
          8297 => Opcode::PseudoVRGATHEREI16_VV_M2_E32_MF2_MASK,
          8298 => Opcode::PseudoVRGATHEREI16_VV_M2_E64_M1,
          8299 => Opcode::PseudoVRGATHEREI16_VV_M2_E64_M1_MASK,
          8300 => Opcode::PseudoVRGATHEREI16_VV_M2_E64_M2,
          8301 => Opcode::PseudoVRGATHEREI16_VV_M2_E64_M2_MASK,
          8302 => Opcode::PseudoVRGATHEREI16_VV_M2_E64_M4,
          8303 => Opcode::PseudoVRGATHEREI16_VV_M2_E64_M4_MASK,
          8304 => Opcode::PseudoVRGATHEREI16_VV_M2_E64_MF2,
          8305 => Opcode::PseudoVRGATHEREI16_VV_M2_E64_MF2_MASK,
          8306 => Opcode::PseudoVRGATHEREI16_VV_M2_E8_M1,
          8307 => Opcode::PseudoVRGATHEREI16_VV_M2_E8_M1_MASK,
          8308 => Opcode::PseudoVRGATHEREI16_VV_M2_E8_M2,
          8309 => Opcode::PseudoVRGATHEREI16_VV_M2_E8_M2_MASK,
          8310 => Opcode::PseudoVRGATHEREI16_VV_M2_E8_M4,
          8311 => Opcode::PseudoVRGATHEREI16_VV_M2_E8_M4_MASK,
          8312 => Opcode::PseudoVRGATHEREI16_VV_M2_E8_MF2,
          8313 => Opcode::PseudoVRGATHEREI16_VV_M2_E8_MF2_MASK,
          8314 => Opcode::PseudoVRGATHEREI16_VV_M4_E16_M1,
          8315 => Opcode::PseudoVRGATHEREI16_VV_M4_E16_M1_MASK,
          8316 => Opcode::PseudoVRGATHEREI16_VV_M4_E16_M2,
          8317 => Opcode::PseudoVRGATHEREI16_VV_M4_E16_M2_MASK,
          8318 => Opcode::PseudoVRGATHEREI16_VV_M4_E16_M4,
          8319 => Opcode::PseudoVRGATHEREI16_VV_M4_E16_M4_MASK,
          8320 => Opcode::PseudoVRGATHEREI16_VV_M4_E16_M8,
          8321 => Opcode::PseudoVRGATHEREI16_VV_M4_E16_M8_MASK,
          8322 => Opcode::PseudoVRGATHEREI16_VV_M4_E32_M1,
          8323 => Opcode::PseudoVRGATHEREI16_VV_M4_E32_M1_MASK,
          8324 => Opcode::PseudoVRGATHEREI16_VV_M4_E32_M2,
          8325 => Opcode::PseudoVRGATHEREI16_VV_M4_E32_M2_MASK,
          8326 => Opcode::PseudoVRGATHEREI16_VV_M4_E32_M4,
          8327 => Opcode::PseudoVRGATHEREI16_VV_M4_E32_M4_MASK,
          8328 => Opcode::PseudoVRGATHEREI16_VV_M4_E32_M8,
          8329 => Opcode::PseudoVRGATHEREI16_VV_M4_E32_M8_MASK,
          8330 => Opcode::PseudoVRGATHEREI16_VV_M4_E64_M1,
          8331 => Opcode::PseudoVRGATHEREI16_VV_M4_E64_M1_MASK,
          8332 => Opcode::PseudoVRGATHEREI16_VV_M4_E64_M2,
          8333 => Opcode::PseudoVRGATHEREI16_VV_M4_E64_M2_MASK,
          8334 => Opcode::PseudoVRGATHEREI16_VV_M4_E64_M4,
          8335 => Opcode::PseudoVRGATHEREI16_VV_M4_E64_M4_MASK,
          8336 => Opcode::PseudoVRGATHEREI16_VV_M4_E64_M8,
          8337 => Opcode::PseudoVRGATHEREI16_VV_M4_E64_M8_MASK,
          8338 => Opcode::PseudoVRGATHEREI16_VV_M4_E8_M1,
          8339 => Opcode::PseudoVRGATHEREI16_VV_M4_E8_M1_MASK,
          8340 => Opcode::PseudoVRGATHEREI16_VV_M4_E8_M2,
          8341 => Opcode::PseudoVRGATHEREI16_VV_M4_E8_M2_MASK,
          8342 => Opcode::PseudoVRGATHEREI16_VV_M4_E8_M4,
          8343 => Opcode::PseudoVRGATHEREI16_VV_M4_E8_M4_MASK,
          8344 => Opcode::PseudoVRGATHEREI16_VV_M4_E8_M8,
          8345 => Opcode::PseudoVRGATHEREI16_VV_M4_E8_M8_MASK,
          8346 => Opcode::PseudoVRGATHEREI16_VV_M8_E16_M2,
          8347 => Opcode::PseudoVRGATHEREI16_VV_M8_E16_M2_MASK,
          8348 => Opcode::PseudoVRGATHEREI16_VV_M8_E16_M4,
          8349 => Opcode::PseudoVRGATHEREI16_VV_M8_E16_M4_MASK,
          8350 => Opcode::PseudoVRGATHEREI16_VV_M8_E16_M8,
          8351 => Opcode::PseudoVRGATHEREI16_VV_M8_E16_M8_MASK,
          8352 => Opcode::PseudoVRGATHEREI16_VV_M8_E32_M2,
          8353 => Opcode::PseudoVRGATHEREI16_VV_M8_E32_M2_MASK,
          8354 => Opcode::PseudoVRGATHEREI16_VV_M8_E32_M4,
          8355 => Opcode::PseudoVRGATHEREI16_VV_M8_E32_M4_MASK,
          8356 => Opcode::PseudoVRGATHEREI16_VV_M8_E32_M8,
          8357 => Opcode::PseudoVRGATHEREI16_VV_M8_E32_M8_MASK,
          8358 => Opcode::PseudoVRGATHEREI16_VV_M8_E64_M2,
          8359 => Opcode::PseudoVRGATHEREI16_VV_M8_E64_M2_MASK,
          8360 => Opcode::PseudoVRGATHEREI16_VV_M8_E64_M4,
          8361 => Opcode::PseudoVRGATHEREI16_VV_M8_E64_M4_MASK,
          8362 => Opcode::PseudoVRGATHEREI16_VV_M8_E64_M8,
          8363 => Opcode::PseudoVRGATHEREI16_VV_M8_E64_M8_MASK,
          8364 => Opcode::PseudoVRGATHEREI16_VV_M8_E8_M2,
          8365 => Opcode::PseudoVRGATHEREI16_VV_M8_E8_M2_MASK,
          8366 => Opcode::PseudoVRGATHEREI16_VV_M8_E8_M4,
          8367 => Opcode::PseudoVRGATHEREI16_VV_M8_E8_M4_MASK,
          8368 => Opcode::PseudoVRGATHEREI16_VV_M8_E8_M8,
          8369 => Opcode::PseudoVRGATHEREI16_VV_M8_E8_M8_MASK,
          8370 => Opcode::PseudoVRGATHEREI16_VV_MF2_E16_M1,
          8371 => Opcode::PseudoVRGATHEREI16_VV_MF2_E16_M1_MASK,
          8372 => Opcode::PseudoVRGATHEREI16_VV_MF2_E16_MF2,
          8373 => Opcode::PseudoVRGATHEREI16_VV_MF2_E16_MF2_MASK,
          8374 => Opcode::PseudoVRGATHEREI16_VV_MF2_E16_MF4,
          8375 => Opcode::PseudoVRGATHEREI16_VV_MF2_E16_MF4_MASK,
          8376 => Opcode::PseudoVRGATHEREI16_VV_MF2_E16_MF8,
          8377 => Opcode::PseudoVRGATHEREI16_VV_MF2_E16_MF8_MASK,
          8378 => Opcode::PseudoVRGATHEREI16_VV_MF2_E32_M1,
          8379 => Opcode::PseudoVRGATHEREI16_VV_MF2_E32_M1_MASK,
          8380 => Opcode::PseudoVRGATHEREI16_VV_MF2_E32_MF2,
          8381 => Opcode::PseudoVRGATHEREI16_VV_MF2_E32_MF2_MASK,
          8382 => Opcode::PseudoVRGATHEREI16_VV_MF2_E32_MF4,
          8383 => Opcode::PseudoVRGATHEREI16_VV_MF2_E32_MF4_MASK,
          8384 => Opcode::PseudoVRGATHEREI16_VV_MF2_E32_MF8,
          8385 => Opcode::PseudoVRGATHEREI16_VV_MF2_E32_MF8_MASK,
          8386 => Opcode::PseudoVRGATHEREI16_VV_MF2_E8_M1,
          8387 => Opcode::PseudoVRGATHEREI16_VV_MF2_E8_M1_MASK,
          8388 => Opcode::PseudoVRGATHEREI16_VV_MF2_E8_MF2,
          8389 => Opcode::PseudoVRGATHEREI16_VV_MF2_E8_MF2_MASK,
          8390 => Opcode::PseudoVRGATHEREI16_VV_MF2_E8_MF4,
          8391 => Opcode::PseudoVRGATHEREI16_VV_MF2_E8_MF4_MASK,
          8392 => Opcode::PseudoVRGATHEREI16_VV_MF2_E8_MF8,
          8393 => Opcode::PseudoVRGATHEREI16_VV_MF2_E8_MF8_MASK,
          8394 => Opcode::PseudoVRGATHEREI16_VV_MF4_E16_MF2,
          8395 => Opcode::PseudoVRGATHEREI16_VV_MF4_E16_MF2_MASK,
          8396 => Opcode::PseudoVRGATHEREI16_VV_MF4_E16_MF4,
          8397 => Opcode::PseudoVRGATHEREI16_VV_MF4_E16_MF4_MASK,
          8398 => Opcode::PseudoVRGATHEREI16_VV_MF4_E16_MF8,
          8399 => Opcode::PseudoVRGATHEREI16_VV_MF4_E16_MF8_MASK,
          8400 => Opcode::PseudoVRGATHEREI16_VV_MF4_E8_MF2,
          8401 => Opcode::PseudoVRGATHEREI16_VV_MF4_E8_MF2_MASK,
          8402 => Opcode::PseudoVRGATHEREI16_VV_MF4_E8_MF4,
          8403 => Opcode::PseudoVRGATHEREI16_VV_MF4_E8_MF4_MASK,
          8404 => Opcode::PseudoVRGATHEREI16_VV_MF4_E8_MF8,
          8405 => Opcode::PseudoVRGATHEREI16_VV_MF4_E8_MF8_MASK,
          8406 => Opcode::PseudoVRGATHEREI16_VV_MF8_E8_MF4,
          8407 => Opcode::PseudoVRGATHEREI16_VV_MF8_E8_MF4_MASK,
          8408 => Opcode::PseudoVRGATHEREI16_VV_MF8_E8_MF8,
          8409 => Opcode::PseudoVRGATHEREI16_VV_MF8_E8_MF8_MASK,
          8410 => Opcode::PseudoVRGATHER_VI_M1,
          8411 => Opcode::PseudoVRGATHER_VI_M1_MASK,
          8412 => Opcode::PseudoVRGATHER_VI_M2,
          8413 => Opcode::PseudoVRGATHER_VI_M2_MASK,
          8414 => Opcode::PseudoVRGATHER_VI_M4,
          8415 => Opcode::PseudoVRGATHER_VI_M4_MASK,
          8416 => Opcode::PseudoVRGATHER_VI_M8,
          8417 => Opcode::PseudoVRGATHER_VI_M8_MASK,
          8418 => Opcode::PseudoVRGATHER_VI_MF2,
          8419 => Opcode::PseudoVRGATHER_VI_MF2_MASK,
          8420 => Opcode::PseudoVRGATHER_VI_MF4,
          8421 => Opcode::PseudoVRGATHER_VI_MF4_MASK,
          8422 => Opcode::PseudoVRGATHER_VI_MF8,
          8423 => Opcode::PseudoVRGATHER_VI_MF8_MASK,
          8424 => Opcode::PseudoVRGATHER_VV_M1_E16,
          8425 => Opcode::PseudoVRGATHER_VV_M1_E16_MASK,
          8426 => Opcode::PseudoVRGATHER_VV_M1_E32,
          8427 => Opcode::PseudoVRGATHER_VV_M1_E32_MASK,
          8428 => Opcode::PseudoVRGATHER_VV_M1_E64,
          8429 => Opcode::PseudoVRGATHER_VV_M1_E64_MASK,
          8430 => Opcode::PseudoVRGATHER_VV_M1_E8,
          8431 => Opcode::PseudoVRGATHER_VV_M1_E8_MASK,
          8432 => Opcode::PseudoVRGATHER_VV_M2_E16,
          8433 => Opcode::PseudoVRGATHER_VV_M2_E16_MASK,
          8434 => Opcode::PseudoVRGATHER_VV_M2_E32,
          8435 => Opcode::PseudoVRGATHER_VV_M2_E32_MASK,
          8436 => Opcode::PseudoVRGATHER_VV_M2_E64,
          8437 => Opcode::PseudoVRGATHER_VV_M2_E64_MASK,
          8438 => Opcode::PseudoVRGATHER_VV_M2_E8,
          8439 => Opcode::PseudoVRGATHER_VV_M2_E8_MASK,
          8440 => Opcode::PseudoVRGATHER_VV_M4_E16,
          8441 => Opcode::PseudoVRGATHER_VV_M4_E16_MASK,
          8442 => Opcode::PseudoVRGATHER_VV_M4_E32,
          8443 => Opcode::PseudoVRGATHER_VV_M4_E32_MASK,
          8444 => Opcode::PseudoVRGATHER_VV_M4_E64,
          8445 => Opcode::PseudoVRGATHER_VV_M4_E64_MASK,
          8446 => Opcode::PseudoVRGATHER_VV_M4_E8,
          8447 => Opcode::PseudoVRGATHER_VV_M4_E8_MASK,
          8448 => Opcode::PseudoVRGATHER_VV_M8_E16,
          8449 => Opcode::PseudoVRGATHER_VV_M8_E16_MASK,
          8450 => Opcode::PseudoVRGATHER_VV_M8_E32,
          8451 => Opcode::PseudoVRGATHER_VV_M8_E32_MASK,
          8452 => Opcode::PseudoVRGATHER_VV_M8_E64,
          8453 => Opcode::PseudoVRGATHER_VV_M8_E64_MASK,
          8454 => Opcode::PseudoVRGATHER_VV_M8_E8,
          8455 => Opcode::PseudoVRGATHER_VV_M8_E8_MASK,
          8456 => Opcode::PseudoVRGATHER_VV_MF2_E16,
          8457 => Opcode::PseudoVRGATHER_VV_MF2_E16_MASK,
          8458 => Opcode::PseudoVRGATHER_VV_MF2_E32,
          8459 => Opcode::PseudoVRGATHER_VV_MF2_E32_MASK,
          8460 => Opcode::PseudoVRGATHER_VV_MF2_E8,
          8461 => Opcode::PseudoVRGATHER_VV_MF2_E8_MASK,
          8462 => Opcode::PseudoVRGATHER_VV_MF4_E16,
          8463 => Opcode::PseudoVRGATHER_VV_MF4_E16_MASK,
          8464 => Opcode::PseudoVRGATHER_VV_MF4_E8,
          8465 => Opcode::PseudoVRGATHER_VV_MF4_E8_MASK,
          8466 => Opcode::PseudoVRGATHER_VV_MF8_E8,
          8467 => Opcode::PseudoVRGATHER_VV_MF8_E8_MASK,
          8468 => Opcode::PseudoVRGATHER_VX_M1,
          8469 => Opcode::PseudoVRGATHER_VX_M1_MASK,
          8470 => Opcode::PseudoVRGATHER_VX_M2,
          8471 => Opcode::PseudoVRGATHER_VX_M2_MASK,
          8472 => Opcode::PseudoVRGATHER_VX_M4,
          8473 => Opcode::PseudoVRGATHER_VX_M4_MASK,
          8474 => Opcode::PseudoVRGATHER_VX_M8,
          8475 => Opcode::PseudoVRGATHER_VX_M8_MASK,
          8476 => Opcode::PseudoVRGATHER_VX_MF2,
          8477 => Opcode::PseudoVRGATHER_VX_MF2_MASK,
          8478 => Opcode::PseudoVRGATHER_VX_MF4,
          8479 => Opcode::PseudoVRGATHER_VX_MF4_MASK,
          8480 => Opcode::PseudoVRGATHER_VX_MF8,
          8481 => Opcode::PseudoVRGATHER_VX_MF8_MASK,
          8482 => Opcode::PseudoVROL_VV_M1,
          8483 => Opcode::PseudoVROL_VV_M1_MASK,
          8484 => Opcode::PseudoVROL_VV_M2,
          8485 => Opcode::PseudoVROL_VV_M2_MASK,
          8486 => Opcode::PseudoVROL_VV_M4,
          8487 => Opcode::PseudoVROL_VV_M4_MASK,
          8488 => Opcode::PseudoVROL_VV_M8,
          8489 => Opcode::PseudoVROL_VV_M8_MASK,
          8490 => Opcode::PseudoVROL_VV_MF2,
          8491 => Opcode::PseudoVROL_VV_MF2_MASK,
          8492 => Opcode::PseudoVROL_VV_MF4,
          8493 => Opcode::PseudoVROL_VV_MF4_MASK,
          8494 => Opcode::PseudoVROL_VV_MF8,
          8495 => Opcode::PseudoVROL_VV_MF8_MASK,
          8496 => Opcode::PseudoVROL_VX_M1,
          8497 => Opcode::PseudoVROL_VX_M1_MASK,
          8498 => Opcode::PseudoVROL_VX_M2,
          8499 => Opcode::PseudoVROL_VX_M2_MASK,
          8500 => Opcode::PseudoVROL_VX_M4,
          8501 => Opcode::PseudoVROL_VX_M4_MASK,
          8502 => Opcode::PseudoVROL_VX_M8,
          8503 => Opcode::PseudoVROL_VX_M8_MASK,
          8504 => Opcode::PseudoVROL_VX_MF2,
          8505 => Opcode::PseudoVROL_VX_MF2_MASK,
          8506 => Opcode::PseudoVROL_VX_MF4,
          8507 => Opcode::PseudoVROL_VX_MF4_MASK,
          8508 => Opcode::PseudoVROL_VX_MF8,
          8509 => Opcode::PseudoVROL_VX_MF8_MASK,
          8510 => Opcode::PseudoVROR_VI_M1,
          8511 => Opcode::PseudoVROR_VI_M1_MASK,
          8512 => Opcode::PseudoVROR_VI_M2,
          8513 => Opcode::PseudoVROR_VI_M2_MASK,
          8514 => Opcode::PseudoVROR_VI_M4,
          8515 => Opcode::PseudoVROR_VI_M4_MASK,
          8516 => Opcode::PseudoVROR_VI_M8,
          8517 => Opcode::PseudoVROR_VI_M8_MASK,
          8518 => Opcode::PseudoVROR_VI_MF2,
          8519 => Opcode::PseudoVROR_VI_MF2_MASK,
          8520 => Opcode::PseudoVROR_VI_MF4,
          8521 => Opcode::PseudoVROR_VI_MF4_MASK,
          8522 => Opcode::PseudoVROR_VI_MF8,
          8523 => Opcode::PseudoVROR_VI_MF8_MASK,
          8524 => Opcode::PseudoVROR_VV_M1,
          8525 => Opcode::PseudoVROR_VV_M1_MASK,
          8526 => Opcode::PseudoVROR_VV_M2,
          8527 => Opcode::PseudoVROR_VV_M2_MASK,
          8528 => Opcode::PseudoVROR_VV_M4,
          8529 => Opcode::PseudoVROR_VV_M4_MASK,
          8530 => Opcode::PseudoVROR_VV_M8,
          8531 => Opcode::PseudoVROR_VV_M8_MASK,
          8532 => Opcode::PseudoVROR_VV_MF2,
          8533 => Opcode::PseudoVROR_VV_MF2_MASK,
          8534 => Opcode::PseudoVROR_VV_MF4,
          8535 => Opcode::PseudoVROR_VV_MF4_MASK,
          8536 => Opcode::PseudoVROR_VV_MF8,
          8537 => Opcode::PseudoVROR_VV_MF8_MASK,
          8538 => Opcode::PseudoVROR_VX_M1,
          8539 => Opcode::PseudoVROR_VX_M1_MASK,
          8540 => Opcode::PseudoVROR_VX_M2,
          8541 => Opcode::PseudoVROR_VX_M2_MASK,
          8542 => Opcode::PseudoVROR_VX_M4,
          8543 => Opcode::PseudoVROR_VX_M4_MASK,
          8544 => Opcode::PseudoVROR_VX_M8,
          8545 => Opcode::PseudoVROR_VX_M8_MASK,
          8546 => Opcode::PseudoVROR_VX_MF2,
          8547 => Opcode::PseudoVROR_VX_MF2_MASK,
          8548 => Opcode::PseudoVROR_VX_MF4,
          8549 => Opcode::PseudoVROR_VX_MF4_MASK,
          8550 => Opcode::PseudoVROR_VX_MF8,
          8551 => Opcode::PseudoVROR_VX_MF8_MASK,
          8552 => Opcode::PseudoVRSUB_VI_M1,
          8553 => Opcode::PseudoVRSUB_VI_M1_MASK,
          8554 => Opcode::PseudoVRSUB_VI_M2,
          8555 => Opcode::PseudoVRSUB_VI_M2_MASK,
          8556 => Opcode::PseudoVRSUB_VI_M4,
          8557 => Opcode::PseudoVRSUB_VI_M4_MASK,
          8558 => Opcode::PseudoVRSUB_VI_M8,
          8559 => Opcode::PseudoVRSUB_VI_M8_MASK,
          8560 => Opcode::PseudoVRSUB_VI_MF2,
          8561 => Opcode::PseudoVRSUB_VI_MF2_MASK,
          8562 => Opcode::PseudoVRSUB_VI_MF4,
          8563 => Opcode::PseudoVRSUB_VI_MF4_MASK,
          8564 => Opcode::PseudoVRSUB_VI_MF8,
          8565 => Opcode::PseudoVRSUB_VI_MF8_MASK,
          8566 => Opcode::PseudoVRSUB_VX_M1,
          8567 => Opcode::PseudoVRSUB_VX_M1_MASK,
          8568 => Opcode::PseudoVRSUB_VX_M2,
          8569 => Opcode::PseudoVRSUB_VX_M2_MASK,
          8570 => Opcode::PseudoVRSUB_VX_M4,
          8571 => Opcode::PseudoVRSUB_VX_M4_MASK,
          8572 => Opcode::PseudoVRSUB_VX_M8,
          8573 => Opcode::PseudoVRSUB_VX_M8_MASK,
          8574 => Opcode::PseudoVRSUB_VX_MF2,
          8575 => Opcode::PseudoVRSUB_VX_MF2_MASK,
          8576 => Opcode::PseudoVRSUB_VX_MF4,
          8577 => Opcode::PseudoVRSUB_VX_MF4_MASK,
          8578 => Opcode::PseudoVRSUB_VX_MF8,
          8579 => Opcode::PseudoVRSUB_VX_MF8_MASK,
          8580 => Opcode::PseudoVSADDU_VI_M1,
          8581 => Opcode::PseudoVSADDU_VI_M1_MASK,
          8582 => Opcode::PseudoVSADDU_VI_M2,
          8583 => Opcode::PseudoVSADDU_VI_M2_MASK,
          8584 => Opcode::PseudoVSADDU_VI_M4,
          8585 => Opcode::PseudoVSADDU_VI_M4_MASK,
          8586 => Opcode::PseudoVSADDU_VI_M8,
          8587 => Opcode::PseudoVSADDU_VI_M8_MASK,
          8588 => Opcode::PseudoVSADDU_VI_MF2,
          8589 => Opcode::PseudoVSADDU_VI_MF2_MASK,
          8590 => Opcode::PseudoVSADDU_VI_MF4,
          8591 => Opcode::PseudoVSADDU_VI_MF4_MASK,
          8592 => Opcode::PseudoVSADDU_VI_MF8,
          8593 => Opcode::PseudoVSADDU_VI_MF8_MASK,
          8594 => Opcode::PseudoVSADDU_VV_M1,
          8595 => Opcode::PseudoVSADDU_VV_M1_MASK,
          8596 => Opcode::PseudoVSADDU_VV_M2,
          8597 => Opcode::PseudoVSADDU_VV_M2_MASK,
          8598 => Opcode::PseudoVSADDU_VV_M4,
          8599 => Opcode::PseudoVSADDU_VV_M4_MASK,
          8600 => Opcode::PseudoVSADDU_VV_M8,
          8601 => Opcode::PseudoVSADDU_VV_M8_MASK,
          8602 => Opcode::PseudoVSADDU_VV_MF2,
          8603 => Opcode::PseudoVSADDU_VV_MF2_MASK,
          8604 => Opcode::PseudoVSADDU_VV_MF4,
          8605 => Opcode::PseudoVSADDU_VV_MF4_MASK,
          8606 => Opcode::PseudoVSADDU_VV_MF8,
          8607 => Opcode::PseudoVSADDU_VV_MF8_MASK,
          8608 => Opcode::PseudoVSADDU_VX_M1,
          8609 => Opcode::PseudoVSADDU_VX_M1_MASK,
          8610 => Opcode::PseudoVSADDU_VX_M2,
          8611 => Opcode::PseudoVSADDU_VX_M2_MASK,
          8612 => Opcode::PseudoVSADDU_VX_M4,
          8613 => Opcode::PseudoVSADDU_VX_M4_MASK,
          8614 => Opcode::PseudoVSADDU_VX_M8,
          8615 => Opcode::PseudoVSADDU_VX_M8_MASK,
          8616 => Opcode::PseudoVSADDU_VX_MF2,
          8617 => Opcode::PseudoVSADDU_VX_MF2_MASK,
          8618 => Opcode::PseudoVSADDU_VX_MF4,
          8619 => Opcode::PseudoVSADDU_VX_MF4_MASK,
          8620 => Opcode::PseudoVSADDU_VX_MF8,
          8621 => Opcode::PseudoVSADDU_VX_MF8_MASK,
          8622 => Opcode::PseudoVSADD_VI_M1,
          8623 => Opcode::PseudoVSADD_VI_M1_MASK,
          8624 => Opcode::PseudoVSADD_VI_M2,
          8625 => Opcode::PseudoVSADD_VI_M2_MASK,
          8626 => Opcode::PseudoVSADD_VI_M4,
          8627 => Opcode::PseudoVSADD_VI_M4_MASK,
          8628 => Opcode::PseudoVSADD_VI_M8,
          8629 => Opcode::PseudoVSADD_VI_M8_MASK,
          8630 => Opcode::PseudoVSADD_VI_MF2,
          8631 => Opcode::PseudoVSADD_VI_MF2_MASK,
          8632 => Opcode::PseudoVSADD_VI_MF4,
          8633 => Opcode::PseudoVSADD_VI_MF4_MASK,
          8634 => Opcode::PseudoVSADD_VI_MF8,
          8635 => Opcode::PseudoVSADD_VI_MF8_MASK,
          8636 => Opcode::PseudoVSADD_VV_M1,
          8637 => Opcode::PseudoVSADD_VV_M1_MASK,
          8638 => Opcode::PseudoVSADD_VV_M2,
          8639 => Opcode::PseudoVSADD_VV_M2_MASK,
          8640 => Opcode::PseudoVSADD_VV_M4,
          8641 => Opcode::PseudoVSADD_VV_M4_MASK,
          8642 => Opcode::PseudoVSADD_VV_M8,
          8643 => Opcode::PseudoVSADD_VV_M8_MASK,
          8644 => Opcode::PseudoVSADD_VV_MF2,
          8645 => Opcode::PseudoVSADD_VV_MF2_MASK,
          8646 => Opcode::PseudoVSADD_VV_MF4,
          8647 => Opcode::PseudoVSADD_VV_MF4_MASK,
          8648 => Opcode::PseudoVSADD_VV_MF8,
          8649 => Opcode::PseudoVSADD_VV_MF8_MASK,
          8650 => Opcode::PseudoVSADD_VX_M1,
          8651 => Opcode::PseudoVSADD_VX_M1_MASK,
          8652 => Opcode::PseudoVSADD_VX_M2,
          8653 => Opcode::PseudoVSADD_VX_M2_MASK,
          8654 => Opcode::PseudoVSADD_VX_M4,
          8655 => Opcode::PseudoVSADD_VX_M4_MASK,
          8656 => Opcode::PseudoVSADD_VX_M8,
          8657 => Opcode::PseudoVSADD_VX_M8_MASK,
          8658 => Opcode::PseudoVSADD_VX_MF2,
          8659 => Opcode::PseudoVSADD_VX_MF2_MASK,
          8660 => Opcode::PseudoVSADD_VX_MF4,
          8661 => Opcode::PseudoVSADD_VX_MF4_MASK,
          8662 => Opcode::PseudoVSADD_VX_MF8,
          8663 => Opcode::PseudoVSADD_VX_MF8_MASK,
          8664 => Opcode::PseudoVSBC_VVM_M1,
          8665 => Opcode::PseudoVSBC_VVM_M2,
          8666 => Opcode::PseudoVSBC_VVM_M4,
          8667 => Opcode::PseudoVSBC_VVM_M8,
          8668 => Opcode::PseudoVSBC_VVM_MF2,
          8669 => Opcode::PseudoVSBC_VVM_MF4,
          8670 => Opcode::PseudoVSBC_VVM_MF8,
          8671 => Opcode::PseudoVSBC_VXM_M1,
          8672 => Opcode::PseudoVSBC_VXM_M2,
          8673 => Opcode::PseudoVSBC_VXM_M4,
          8674 => Opcode::PseudoVSBC_VXM_M8,
          8675 => Opcode::PseudoVSBC_VXM_MF2,
          8676 => Opcode::PseudoVSBC_VXM_MF4,
          8677 => Opcode::PseudoVSBC_VXM_MF8,
          8678 => Opcode::PseudoVSE16_V_M1,
          8679 => Opcode::PseudoVSE16_V_M1_MASK,
          8680 => Opcode::PseudoVSE16_V_M2,
          8681 => Opcode::PseudoVSE16_V_M2_MASK,
          8682 => Opcode::PseudoVSE16_V_M4,
          8683 => Opcode::PseudoVSE16_V_M4_MASK,
          8684 => Opcode::PseudoVSE16_V_M8,
          8685 => Opcode::PseudoVSE16_V_M8_MASK,
          8686 => Opcode::PseudoVSE16_V_MF2,
          8687 => Opcode::PseudoVSE16_V_MF2_MASK,
          8688 => Opcode::PseudoVSE16_V_MF4,
          8689 => Opcode::PseudoVSE16_V_MF4_MASK,
          8690 => Opcode::PseudoVSE32_V_M1,
          8691 => Opcode::PseudoVSE32_V_M1_MASK,
          8692 => Opcode::PseudoVSE32_V_M2,
          8693 => Opcode::PseudoVSE32_V_M2_MASK,
          8694 => Opcode::PseudoVSE32_V_M4,
          8695 => Opcode::PseudoVSE32_V_M4_MASK,
          8696 => Opcode::PseudoVSE32_V_M8,
          8697 => Opcode::PseudoVSE32_V_M8_MASK,
          8698 => Opcode::PseudoVSE32_V_MF2,
          8699 => Opcode::PseudoVSE32_V_MF2_MASK,
          8700 => Opcode::PseudoVSE64_V_M1,
          8701 => Opcode::PseudoVSE64_V_M1_MASK,
          8702 => Opcode::PseudoVSE64_V_M2,
          8703 => Opcode::PseudoVSE64_V_M2_MASK,
          8704 => Opcode::PseudoVSE64_V_M4,
          8705 => Opcode::PseudoVSE64_V_M4_MASK,
          8706 => Opcode::PseudoVSE64_V_M8,
          8707 => Opcode::PseudoVSE64_V_M8_MASK,
          8708 => Opcode::PseudoVSE8_V_M1,
          8709 => Opcode::PseudoVSE8_V_M1_MASK,
          8710 => Opcode::PseudoVSE8_V_M2,
          8711 => Opcode::PseudoVSE8_V_M2_MASK,
          8712 => Opcode::PseudoVSE8_V_M4,
          8713 => Opcode::PseudoVSE8_V_M4_MASK,
          8714 => Opcode::PseudoVSE8_V_M8,
          8715 => Opcode::PseudoVSE8_V_M8_MASK,
          8716 => Opcode::PseudoVSE8_V_MF2,
          8717 => Opcode::PseudoVSE8_V_MF2_MASK,
          8718 => Opcode::PseudoVSE8_V_MF4,
          8719 => Opcode::PseudoVSE8_V_MF4_MASK,
          8720 => Opcode::PseudoVSE8_V_MF8,
          8721 => Opcode::PseudoVSE8_V_MF8_MASK,
          8722 => Opcode::PseudoVSETIVLI,
          8723 => Opcode::PseudoVSETVLI,
          8724 => Opcode::PseudoVSETVLIX0,
          8725 => Opcode::PseudoVSEXT_VF2_M1,
          8726 => Opcode::PseudoVSEXT_VF2_M1_MASK,
          8727 => Opcode::PseudoVSEXT_VF2_M2,
          8728 => Opcode::PseudoVSEXT_VF2_M2_MASK,
          8729 => Opcode::PseudoVSEXT_VF2_M4,
          8730 => Opcode::PseudoVSEXT_VF2_M4_MASK,
          8731 => Opcode::PseudoVSEXT_VF2_M8,
          8732 => Opcode::PseudoVSEXT_VF2_M8_MASK,
          8733 => Opcode::PseudoVSEXT_VF2_MF2,
          8734 => Opcode::PseudoVSEXT_VF2_MF2_MASK,
          8735 => Opcode::PseudoVSEXT_VF2_MF4,
          8736 => Opcode::PseudoVSEXT_VF2_MF4_MASK,
          8737 => Opcode::PseudoVSEXT_VF4_M1,
          8738 => Opcode::PseudoVSEXT_VF4_M1_MASK,
          8739 => Opcode::PseudoVSEXT_VF4_M2,
          8740 => Opcode::PseudoVSEXT_VF4_M2_MASK,
          8741 => Opcode::PseudoVSEXT_VF4_M4,
          8742 => Opcode::PseudoVSEXT_VF4_M4_MASK,
          8743 => Opcode::PseudoVSEXT_VF4_M8,
          8744 => Opcode::PseudoVSEXT_VF4_M8_MASK,
          8745 => Opcode::PseudoVSEXT_VF4_MF2,
          8746 => Opcode::PseudoVSEXT_VF4_MF2_MASK,
          8747 => Opcode::PseudoVSEXT_VF8_M1,
          8748 => Opcode::PseudoVSEXT_VF8_M1_MASK,
          8749 => Opcode::PseudoVSEXT_VF8_M2,
          8750 => Opcode::PseudoVSEXT_VF8_M2_MASK,
          8751 => Opcode::PseudoVSEXT_VF8_M4,
          8752 => Opcode::PseudoVSEXT_VF8_M4_MASK,
          8753 => Opcode::PseudoVSEXT_VF8_M8,
          8754 => Opcode::PseudoVSEXT_VF8_M8_MASK,
          8755 => Opcode::PseudoVSHA2CH_VV_M1,
          8756 => Opcode::PseudoVSHA2CH_VV_M2,
          8757 => Opcode::PseudoVSHA2CH_VV_M4,
          8758 => Opcode::PseudoVSHA2CH_VV_M8,
          8759 => Opcode::PseudoVSHA2CH_VV_MF2,
          8760 => Opcode::PseudoVSHA2CL_VV_M1,
          8761 => Opcode::PseudoVSHA2CL_VV_M2,
          8762 => Opcode::PseudoVSHA2CL_VV_M4,
          8763 => Opcode::PseudoVSHA2CL_VV_M8,
          8764 => Opcode::PseudoVSHA2CL_VV_MF2,
          8765 => Opcode::PseudoVSHA2MS_VV_M1,
          8766 => Opcode::PseudoVSHA2MS_VV_M2,
          8767 => Opcode::PseudoVSHA2MS_VV_M4,
          8768 => Opcode::PseudoVSHA2MS_VV_M8,
          8769 => Opcode::PseudoVSHA2MS_VV_MF2,
          8770 => Opcode::PseudoVSLIDE1DOWN_VX_M1,
          8771 => Opcode::PseudoVSLIDE1DOWN_VX_M1_MASK,
          8772 => Opcode::PseudoVSLIDE1DOWN_VX_M2,
          8773 => Opcode::PseudoVSLIDE1DOWN_VX_M2_MASK,
          8774 => Opcode::PseudoVSLIDE1DOWN_VX_M4,
          8775 => Opcode::PseudoVSLIDE1DOWN_VX_M4_MASK,
          8776 => Opcode::PseudoVSLIDE1DOWN_VX_M8,
          8777 => Opcode::PseudoVSLIDE1DOWN_VX_M8_MASK,
          8778 => Opcode::PseudoVSLIDE1DOWN_VX_MF2,
          8779 => Opcode::PseudoVSLIDE1DOWN_VX_MF2_MASK,
          8780 => Opcode::PseudoVSLIDE1DOWN_VX_MF4,
          8781 => Opcode::PseudoVSLIDE1DOWN_VX_MF4_MASK,
          8782 => Opcode::PseudoVSLIDE1DOWN_VX_MF8,
          8783 => Opcode::PseudoVSLIDE1DOWN_VX_MF8_MASK,
          8784 => Opcode::PseudoVSLIDE1UP_VX_M1,
          8785 => Opcode::PseudoVSLIDE1UP_VX_M1_MASK,
          8786 => Opcode::PseudoVSLIDE1UP_VX_M2,
          8787 => Opcode::PseudoVSLIDE1UP_VX_M2_MASK,
          8788 => Opcode::PseudoVSLIDE1UP_VX_M4,
          8789 => Opcode::PseudoVSLIDE1UP_VX_M4_MASK,
          8790 => Opcode::PseudoVSLIDE1UP_VX_M8,
          8791 => Opcode::PseudoVSLIDE1UP_VX_M8_MASK,
          8792 => Opcode::PseudoVSLIDE1UP_VX_MF2,
          8793 => Opcode::PseudoVSLIDE1UP_VX_MF2_MASK,
          8794 => Opcode::PseudoVSLIDE1UP_VX_MF4,
          8795 => Opcode::PseudoVSLIDE1UP_VX_MF4_MASK,
          8796 => Opcode::PseudoVSLIDE1UP_VX_MF8,
          8797 => Opcode::PseudoVSLIDE1UP_VX_MF8_MASK,
          8798 => Opcode::PseudoVSLIDEDOWN_VI_M1,
          8799 => Opcode::PseudoVSLIDEDOWN_VI_M1_MASK,
          8800 => Opcode::PseudoVSLIDEDOWN_VI_M2,
          8801 => Opcode::PseudoVSLIDEDOWN_VI_M2_MASK,
          8802 => Opcode::PseudoVSLIDEDOWN_VI_M4,
          8803 => Opcode::PseudoVSLIDEDOWN_VI_M4_MASK,
          8804 => Opcode::PseudoVSLIDEDOWN_VI_M8,
          8805 => Opcode::PseudoVSLIDEDOWN_VI_M8_MASK,
          8806 => Opcode::PseudoVSLIDEDOWN_VI_MF2,
          8807 => Opcode::PseudoVSLIDEDOWN_VI_MF2_MASK,
          8808 => Opcode::PseudoVSLIDEDOWN_VI_MF4,
          8809 => Opcode::PseudoVSLIDEDOWN_VI_MF4_MASK,
          8810 => Opcode::PseudoVSLIDEDOWN_VI_MF8,
          8811 => Opcode::PseudoVSLIDEDOWN_VI_MF8_MASK,
          8812 => Opcode::PseudoVSLIDEDOWN_VX_M1,
          8813 => Opcode::PseudoVSLIDEDOWN_VX_M1_MASK,
          8814 => Opcode::PseudoVSLIDEDOWN_VX_M2,
          8815 => Opcode::PseudoVSLIDEDOWN_VX_M2_MASK,
          8816 => Opcode::PseudoVSLIDEDOWN_VX_M4,
          8817 => Opcode::PseudoVSLIDEDOWN_VX_M4_MASK,
          8818 => Opcode::PseudoVSLIDEDOWN_VX_M8,
          8819 => Opcode::PseudoVSLIDEDOWN_VX_M8_MASK,
          8820 => Opcode::PseudoVSLIDEDOWN_VX_MF2,
          8821 => Opcode::PseudoVSLIDEDOWN_VX_MF2_MASK,
          8822 => Opcode::PseudoVSLIDEDOWN_VX_MF4,
          8823 => Opcode::PseudoVSLIDEDOWN_VX_MF4_MASK,
          8824 => Opcode::PseudoVSLIDEDOWN_VX_MF8,
          8825 => Opcode::PseudoVSLIDEDOWN_VX_MF8_MASK,
          8826 => Opcode::PseudoVSLIDEUP_VI_M1,
          8827 => Opcode::PseudoVSLIDEUP_VI_M1_MASK,
          8828 => Opcode::PseudoVSLIDEUP_VI_M2,
          8829 => Opcode::PseudoVSLIDEUP_VI_M2_MASK,
          8830 => Opcode::PseudoVSLIDEUP_VI_M4,
          8831 => Opcode::PseudoVSLIDEUP_VI_M4_MASK,
          8832 => Opcode::PseudoVSLIDEUP_VI_M8,
          8833 => Opcode::PseudoVSLIDEUP_VI_M8_MASK,
          8834 => Opcode::PseudoVSLIDEUP_VI_MF2,
          8835 => Opcode::PseudoVSLIDEUP_VI_MF2_MASK,
          8836 => Opcode::PseudoVSLIDEUP_VI_MF4,
          8837 => Opcode::PseudoVSLIDEUP_VI_MF4_MASK,
          8838 => Opcode::PseudoVSLIDEUP_VI_MF8,
          8839 => Opcode::PseudoVSLIDEUP_VI_MF8_MASK,
          8840 => Opcode::PseudoVSLIDEUP_VX_M1,
          8841 => Opcode::PseudoVSLIDEUP_VX_M1_MASK,
          8842 => Opcode::PseudoVSLIDEUP_VX_M2,
          8843 => Opcode::PseudoVSLIDEUP_VX_M2_MASK,
          8844 => Opcode::PseudoVSLIDEUP_VX_M4,
          8845 => Opcode::PseudoVSLIDEUP_VX_M4_MASK,
          8846 => Opcode::PseudoVSLIDEUP_VX_M8,
          8847 => Opcode::PseudoVSLIDEUP_VX_M8_MASK,
          8848 => Opcode::PseudoVSLIDEUP_VX_MF2,
          8849 => Opcode::PseudoVSLIDEUP_VX_MF2_MASK,
          8850 => Opcode::PseudoVSLIDEUP_VX_MF4,
          8851 => Opcode::PseudoVSLIDEUP_VX_MF4_MASK,
          8852 => Opcode::PseudoVSLIDEUP_VX_MF8,
          8853 => Opcode::PseudoVSLIDEUP_VX_MF8_MASK,
          8854 => Opcode::PseudoVSLL_VI_M1,
          8855 => Opcode::PseudoVSLL_VI_M1_MASK,
          8856 => Opcode::PseudoVSLL_VI_M2,
          8857 => Opcode::PseudoVSLL_VI_M2_MASK,
          8858 => Opcode::PseudoVSLL_VI_M4,
          8859 => Opcode::PseudoVSLL_VI_M4_MASK,
          8860 => Opcode::PseudoVSLL_VI_M8,
          8861 => Opcode::PseudoVSLL_VI_M8_MASK,
          8862 => Opcode::PseudoVSLL_VI_MF2,
          8863 => Opcode::PseudoVSLL_VI_MF2_MASK,
          8864 => Opcode::PseudoVSLL_VI_MF4,
          8865 => Opcode::PseudoVSLL_VI_MF4_MASK,
          8866 => Opcode::PseudoVSLL_VI_MF8,
          8867 => Opcode::PseudoVSLL_VI_MF8_MASK,
          8868 => Opcode::PseudoVSLL_VV_M1,
          8869 => Opcode::PseudoVSLL_VV_M1_MASK,
          8870 => Opcode::PseudoVSLL_VV_M2,
          8871 => Opcode::PseudoVSLL_VV_M2_MASK,
          8872 => Opcode::PseudoVSLL_VV_M4,
          8873 => Opcode::PseudoVSLL_VV_M4_MASK,
          8874 => Opcode::PseudoVSLL_VV_M8,
          8875 => Opcode::PseudoVSLL_VV_M8_MASK,
          8876 => Opcode::PseudoVSLL_VV_MF2,
          8877 => Opcode::PseudoVSLL_VV_MF2_MASK,
          8878 => Opcode::PseudoVSLL_VV_MF4,
          8879 => Opcode::PseudoVSLL_VV_MF4_MASK,
          8880 => Opcode::PseudoVSLL_VV_MF8,
          8881 => Opcode::PseudoVSLL_VV_MF8_MASK,
          8882 => Opcode::PseudoVSLL_VX_M1,
          8883 => Opcode::PseudoVSLL_VX_M1_MASK,
          8884 => Opcode::PseudoVSLL_VX_M2,
          8885 => Opcode::PseudoVSLL_VX_M2_MASK,
          8886 => Opcode::PseudoVSLL_VX_M4,
          8887 => Opcode::PseudoVSLL_VX_M4_MASK,
          8888 => Opcode::PseudoVSLL_VX_M8,
          8889 => Opcode::PseudoVSLL_VX_M8_MASK,
          8890 => Opcode::PseudoVSLL_VX_MF2,
          8891 => Opcode::PseudoVSLL_VX_MF2_MASK,
          8892 => Opcode::PseudoVSLL_VX_MF4,
          8893 => Opcode::PseudoVSLL_VX_MF4_MASK,
          8894 => Opcode::PseudoVSLL_VX_MF8,
          8895 => Opcode::PseudoVSLL_VX_MF8_MASK,
          8896 => Opcode::PseudoVSM3C_VI_M1,
          8897 => Opcode::PseudoVSM3C_VI_M2,
          8898 => Opcode::PseudoVSM3C_VI_M4,
          8899 => Opcode::PseudoVSM3C_VI_M8,
          8900 => Opcode::PseudoVSM3C_VI_MF2,
          8901 => Opcode::PseudoVSM3ME_VV_M1,
          8902 => Opcode::PseudoVSM3ME_VV_M2,
          8903 => Opcode::PseudoVSM3ME_VV_M4,
          8904 => Opcode::PseudoVSM3ME_VV_M8,
          8905 => Opcode::PseudoVSM3ME_VV_MF2,
          8906 => Opcode::PseudoVSM4K_VI_M1,
          8907 => Opcode::PseudoVSM4K_VI_M2,
          8908 => Opcode::PseudoVSM4K_VI_M4,
          8909 => Opcode::PseudoVSM4K_VI_M8,
          8910 => Opcode::PseudoVSM4K_VI_MF2,
          8911 => Opcode::PseudoVSM4R_VS_M1_M1,
          8912 => Opcode::PseudoVSM4R_VS_M1_MF2,
          8913 => Opcode::PseudoVSM4R_VS_M1_MF4,
          8914 => Opcode::PseudoVSM4R_VS_M1_MF8,
          8915 => Opcode::PseudoVSM4R_VS_M2_M1,
          8916 => Opcode::PseudoVSM4R_VS_M2_M2,
          8917 => Opcode::PseudoVSM4R_VS_M2_MF2,
          8918 => Opcode::PseudoVSM4R_VS_M2_MF4,
          8919 => Opcode::PseudoVSM4R_VS_M2_MF8,
          8920 => Opcode::PseudoVSM4R_VS_M4_M1,
          8921 => Opcode::PseudoVSM4R_VS_M4_M2,
          8922 => Opcode::PseudoVSM4R_VS_M4_M4,
          8923 => Opcode::PseudoVSM4R_VS_M4_MF2,
          8924 => Opcode::PseudoVSM4R_VS_M4_MF4,
          8925 => Opcode::PseudoVSM4R_VS_M4_MF8,
          8926 => Opcode::PseudoVSM4R_VS_M8_M1,
          8927 => Opcode::PseudoVSM4R_VS_M8_M2,
          8928 => Opcode::PseudoVSM4R_VS_M8_M4,
          8929 => Opcode::PseudoVSM4R_VS_M8_MF2,
          8930 => Opcode::PseudoVSM4R_VS_M8_MF4,
          8931 => Opcode::PseudoVSM4R_VS_M8_MF8,
          8932 => Opcode::PseudoVSM4R_VS_MF2_MF2,
          8933 => Opcode::PseudoVSM4R_VS_MF2_MF4,
          8934 => Opcode::PseudoVSM4R_VS_MF2_MF8,
          8935 => Opcode::PseudoVSM4R_VV_M1,
          8936 => Opcode::PseudoVSM4R_VV_M2,
          8937 => Opcode::PseudoVSM4R_VV_M4,
          8938 => Opcode::PseudoVSM4R_VV_M8,
          8939 => Opcode::PseudoVSM4R_VV_MF2,
          8940 => Opcode::PseudoVSMUL_VV_M1,
          8941 => Opcode::PseudoVSMUL_VV_M1_MASK,
          8942 => Opcode::PseudoVSMUL_VV_M2,
          8943 => Opcode::PseudoVSMUL_VV_M2_MASK,
          8944 => Opcode::PseudoVSMUL_VV_M4,
          8945 => Opcode::PseudoVSMUL_VV_M4_MASK,
          8946 => Opcode::PseudoVSMUL_VV_M8,
          8947 => Opcode::PseudoVSMUL_VV_M8_MASK,
          8948 => Opcode::PseudoVSMUL_VV_MF2,
          8949 => Opcode::PseudoVSMUL_VV_MF2_MASK,
          8950 => Opcode::PseudoVSMUL_VV_MF4,
          8951 => Opcode::PseudoVSMUL_VV_MF4_MASK,
          8952 => Opcode::PseudoVSMUL_VV_MF8,
          8953 => Opcode::PseudoVSMUL_VV_MF8_MASK,
          8954 => Opcode::PseudoVSMUL_VX_M1,
          8955 => Opcode::PseudoVSMUL_VX_M1_MASK,
          8956 => Opcode::PseudoVSMUL_VX_M2,
          8957 => Opcode::PseudoVSMUL_VX_M2_MASK,
          8958 => Opcode::PseudoVSMUL_VX_M4,
          8959 => Opcode::PseudoVSMUL_VX_M4_MASK,
          8960 => Opcode::PseudoVSMUL_VX_M8,
          8961 => Opcode::PseudoVSMUL_VX_M8_MASK,
          8962 => Opcode::PseudoVSMUL_VX_MF2,
          8963 => Opcode::PseudoVSMUL_VX_MF2_MASK,
          8964 => Opcode::PseudoVSMUL_VX_MF4,
          8965 => Opcode::PseudoVSMUL_VX_MF4_MASK,
          8966 => Opcode::PseudoVSMUL_VX_MF8,
          8967 => Opcode::PseudoVSMUL_VX_MF8_MASK,
          8968 => Opcode::PseudoVSM_V_B1,
          8969 => Opcode::PseudoVSM_V_B16,
          8970 => Opcode::PseudoVSM_V_B2,
          8971 => Opcode::PseudoVSM_V_B32,
          8972 => Opcode::PseudoVSM_V_B4,
          8973 => Opcode::PseudoVSM_V_B64,
          8974 => Opcode::PseudoVSM_V_B8,
          8975 => Opcode::PseudoVSOXEI16_V_M1_M1,
          8976 => Opcode::PseudoVSOXEI16_V_M1_M1_MASK,
          8977 => Opcode::PseudoVSOXEI16_V_M1_M2,
          8978 => Opcode::PseudoVSOXEI16_V_M1_M2_MASK,
          8979 => Opcode::PseudoVSOXEI16_V_M1_M4,
          8980 => Opcode::PseudoVSOXEI16_V_M1_M4_MASK,
          8981 => Opcode::PseudoVSOXEI16_V_M1_MF2,
          8982 => Opcode::PseudoVSOXEI16_V_M1_MF2_MASK,
          8983 => Opcode::PseudoVSOXEI16_V_M2_M1,
          8984 => Opcode::PseudoVSOXEI16_V_M2_M1_MASK,
          8985 => Opcode::PseudoVSOXEI16_V_M2_M2,
          8986 => Opcode::PseudoVSOXEI16_V_M2_M2_MASK,
          8987 => Opcode::PseudoVSOXEI16_V_M2_M4,
          8988 => Opcode::PseudoVSOXEI16_V_M2_M4_MASK,
          8989 => Opcode::PseudoVSOXEI16_V_M2_M8,
          8990 => Opcode::PseudoVSOXEI16_V_M2_M8_MASK,
          8991 => Opcode::PseudoVSOXEI16_V_M4_M2,
          8992 => Opcode::PseudoVSOXEI16_V_M4_M2_MASK,
          8993 => Opcode::PseudoVSOXEI16_V_M4_M4,
          8994 => Opcode::PseudoVSOXEI16_V_M4_M4_MASK,
          8995 => Opcode::PseudoVSOXEI16_V_M4_M8,
          8996 => Opcode::PseudoVSOXEI16_V_M4_M8_MASK,
          8997 => Opcode::PseudoVSOXEI16_V_M8_M4,
          8998 => Opcode::PseudoVSOXEI16_V_M8_M4_MASK,
          8999 => Opcode::PseudoVSOXEI16_V_M8_M8,
          9000 => Opcode::PseudoVSOXEI16_V_M8_M8_MASK,
          9001 => Opcode::PseudoVSOXEI16_V_MF2_M1,
          9002 => Opcode::PseudoVSOXEI16_V_MF2_M1_MASK,
          9003 => Opcode::PseudoVSOXEI16_V_MF2_M2,
          9004 => Opcode::PseudoVSOXEI16_V_MF2_M2_MASK,
          9005 => Opcode::PseudoVSOXEI16_V_MF2_MF2,
          9006 => Opcode::PseudoVSOXEI16_V_MF2_MF2_MASK,
          9007 => Opcode::PseudoVSOXEI16_V_MF2_MF4,
          9008 => Opcode::PseudoVSOXEI16_V_MF2_MF4_MASK,
          9009 => Opcode::PseudoVSOXEI16_V_MF4_M1,
          9010 => Opcode::PseudoVSOXEI16_V_MF4_M1_MASK,
          9011 => Opcode::PseudoVSOXEI16_V_MF4_MF2,
          9012 => Opcode::PseudoVSOXEI16_V_MF4_MF2_MASK,
          9013 => Opcode::PseudoVSOXEI16_V_MF4_MF4,
          9014 => Opcode::PseudoVSOXEI16_V_MF4_MF4_MASK,
          9015 => Opcode::PseudoVSOXEI16_V_MF4_MF8,
          9016 => Opcode::PseudoVSOXEI16_V_MF4_MF8_MASK,
          9017 => Opcode::PseudoVSOXEI32_V_M1_M1,
          9018 => Opcode::PseudoVSOXEI32_V_M1_M1_MASK,
          9019 => Opcode::PseudoVSOXEI32_V_M1_M2,
          9020 => Opcode::PseudoVSOXEI32_V_M1_M2_MASK,
          9021 => Opcode::PseudoVSOXEI32_V_M1_MF2,
          9022 => Opcode::PseudoVSOXEI32_V_M1_MF2_MASK,
          9023 => Opcode::PseudoVSOXEI32_V_M1_MF4,
          9024 => Opcode::PseudoVSOXEI32_V_M1_MF4_MASK,
          9025 => Opcode::PseudoVSOXEI32_V_M2_M1,
          9026 => Opcode::PseudoVSOXEI32_V_M2_M1_MASK,
          9027 => Opcode::PseudoVSOXEI32_V_M2_M2,
          9028 => Opcode::PseudoVSOXEI32_V_M2_M2_MASK,
          9029 => Opcode::PseudoVSOXEI32_V_M2_M4,
          9030 => Opcode::PseudoVSOXEI32_V_M2_M4_MASK,
          9031 => Opcode::PseudoVSOXEI32_V_M2_MF2,
          9032 => Opcode::PseudoVSOXEI32_V_M2_MF2_MASK,
          9033 => Opcode::PseudoVSOXEI32_V_M4_M1,
          9034 => Opcode::PseudoVSOXEI32_V_M4_M1_MASK,
          9035 => Opcode::PseudoVSOXEI32_V_M4_M2,
          9036 => Opcode::PseudoVSOXEI32_V_M4_M2_MASK,
          9037 => Opcode::PseudoVSOXEI32_V_M4_M4,
          9038 => Opcode::PseudoVSOXEI32_V_M4_M4_MASK,
          9039 => Opcode::PseudoVSOXEI32_V_M4_M8,
          9040 => Opcode::PseudoVSOXEI32_V_M4_M8_MASK,
          9041 => Opcode::PseudoVSOXEI32_V_M8_M2,
          9042 => Opcode::PseudoVSOXEI32_V_M8_M2_MASK,
          9043 => Opcode::PseudoVSOXEI32_V_M8_M4,
          9044 => Opcode::PseudoVSOXEI32_V_M8_M4_MASK,
          9045 => Opcode::PseudoVSOXEI32_V_M8_M8,
          9046 => Opcode::PseudoVSOXEI32_V_M8_M8_MASK,
          9047 => Opcode::PseudoVSOXEI32_V_MF2_M1,
          9048 => Opcode::PseudoVSOXEI32_V_MF2_M1_MASK,
          9049 => Opcode::PseudoVSOXEI32_V_MF2_MF2,
          9050 => Opcode::PseudoVSOXEI32_V_MF2_MF2_MASK,
          9051 => Opcode::PseudoVSOXEI32_V_MF2_MF4,
          9052 => Opcode::PseudoVSOXEI32_V_MF2_MF4_MASK,
          9053 => Opcode::PseudoVSOXEI32_V_MF2_MF8,
          9054 => Opcode::PseudoVSOXEI32_V_MF2_MF8_MASK,
          9055 => Opcode::PseudoVSOXEI64_V_M1_M1,
          9056 => Opcode::PseudoVSOXEI64_V_M1_M1_MASK,
          9057 => Opcode::PseudoVSOXEI64_V_M1_MF2,
          9058 => Opcode::PseudoVSOXEI64_V_M1_MF2_MASK,
          9059 => Opcode::PseudoVSOXEI64_V_M1_MF4,
          9060 => Opcode::PseudoVSOXEI64_V_M1_MF4_MASK,
          9061 => Opcode::PseudoVSOXEI64_V_M1_MF8,
          9062 => Opcode::PseudoVSOXEI64_V_M1_MF8_MASK,
          9063 => Opcode::PseudoVSOXEI64_V_M2_M1,
          9064 => Opcode::PseudoVSOXEI64_V_M2_M1_MASK,
          9065 => Opcode::PseudoVSOXEI64_V_M2_M2,
          9066 => Opcode::PseudoVSOXEI64_V_M2_M2_MASK,
          9067 => Opcode::PseudoVSOXEI64_V_M2_MF2,
          9068 => Opcode::PseudoVSOXEI64_V_M2_MF2_MASK,
          9069 => Opcode::PseudoVSOXEI64_V_M2_MF4,
          9070 => Opcode::PseudoVSOXEI64_V_M2_MF4_MASK,
          9071 => Opcode::PseudoVSOXEI64_V_M4_M1,
          9072 => Opcode::PseudoVSOXEI64_V_M4_M1_MASK,
          9073 => Opcode::PseudoVSOXEI64_V_M4_M2,
          9074 => Opcode::PseudoVSOXEI64_V_M4_M2_MASK,
          9075 => Opcode::PseudoVSOXEI64_V_M4_M4,
          9076 => Opcode::PseudoVSOXEI64_V_M4_M4_MASK,
          9077 => Opcode::PseudoVSOXEI64_V_M4_MF2,
          9078 => Opcode::PseudoVSOXEI64_V_M4_MF2_MASK,
          9079 => Opcode::PseudoVSOXEI64_V_M8_M1,
          9080 => Opcode::PseudoVSOXEI64_V_M8_M1_MASK,
          9081 => Opcode::PseudoVSOXEI64_V_M8_M2,
          9082 => Opcode::PseudoVSOXEI64_V_M8_M2_MASK,
          9083 => Opcode::PseudoVSOXEI64_V_M8_M4,
          9084 => Opcode::PseudoVSOXEI64_V_M8_M4_MASK,
          9085 => Opcode::PseudoVSOXEI64_V_M8_M8,
          9086 => Opcode::PseudoVSOXEI64_V_M8_M8_MASK,
          9087 => Opcode::PseudoVSOXEI8_V_M1_M1,
          9088 => Opcode::PseudoVSOXEI8_V_M1_M1_MASK,
          9089 => Opcode::PseudoVSOXEI8_V_M1_M2,
          9090 => Opcode::PseudoVSOXEI8_V_M1_M2_MASK,
          9091 => Opcode::PseudoVSOXEI8_V_M1_M4,
          9092 => Opcode::PseudoVSOXEI8_V_M1_M4_MASK,
          9093 => Opcode::PseudoVSOXEI8_V_M1_M8,
          9094 => Opcode::PseudoVSOXEI8_V_M1_M8_MASK,
          9095 => Opcode::PseudoVSOXEI8_V_M2_M2,
          9096 => Opcode::PseudoVSOXEI8_V_M2_M2_MASK,
          9097 => Opcode::PseudoVSOXEI8_V_M2_M4,
          9098 => Opcode::PseudoVSOXEI8_V_M2_M4_MASK,
          9099 => Opcode::PseudoVSOXEI8_V_M2_M8,
          9100 => Opcode::PseudoVSOXEI8_V_M2_M8_MASK,
          9101 => Opcode::PseudoVSOXEI8_V_M4_M4,
          9102 => Opcode::PseudoVSOXEI8_V_M4_M4_MASK,
          9103 => Opcode::PseudoVSOXEI8_V_M4_M8,
          9104 => Opcode::PseudoVSOXEI8_V_M4_M8_MASK,
          9105 => Opcode::PseudoVSOXEI8_V_M8_M8,
          9106 => Opcode::PseudoVSOXEI8_V_M8_M8_MASK,
          9107 => Opcode::PseudoVSOXEI8_V_MF2_M1,
          9108 => Opcode::PseudoVSOXEI8_V_MF2_M1_MASK,
          9109 => Opcode::PseudoVSOXEI8_V_MF2_M2,
          9110 => Opcode::PseudoVSOXEI8_V_MF2_M2_MASK,
          9111 => Opcode::PseudoVSOXEI8_V_MF2_M4,
          9112 => Opcode::PseudoVSOXEI8_V_MF2_M4_MASK,
          9113 => Opcode::PseudoVSOXEI8_V_MF2_MF2,
          9114 => Opcode::PseudoVSOXEI8_V_MF2_MF2_MASK,
          9115 => Opcode::PseudoVSOXEI8_V_MF4_M1,
          9116 => Opcode::PseudoVSOXEI8_V_MF4_M1_MASK,
          9117 => Opcode::PseudoVSOXEI8_V_MF4_M2,
          9118 => Opcode::PseudoVSOXEI8_V_MF4_M2_MASK,
          9119 => Opcode::PseudoVSOXEI8_V_MF4_MF2,
          9120 => Opcode::PseudoVSOXEI8_V_MF4_MF2_MASK,
          9121 => Opcode::PseudoVSOXEI8_V_MF4_MF4,
          9122 => Opcode::PseudoVSOXEI8_V_MF4_MF4_MASK,
          9123 => Opcode::PseudoVSOXEI8_V_MF8_M1,
          9124 => Opcode::PseudoVSOXEI8_V_MF8_M1_MASK,
          9125 => Opcode::PseudoVSOXEI8_V_MF8_MF2,
          9126 => Opcode::PseudoVSOXEI8_V_MF8_MF2_MASK,
          9127 => Opcode::PseudoVSOXEI8_V_MF8_MF4,
          9128 => Opcode::PseudoVSOXEI8_V_MF8_MF4_MASK,
          9129 => Opcode::PseudoVSOXEI8_V_MF8_MF8,
          9130 => Opcode::PseudoVSOXEI8_V_MF8_MF8_MASK,
          9131 => Opcode::PseudoVSOXSEG2EI16_V_M1_M1,
          9132 => Opcode::PseudoVSOXSEG2EI16_V_M1_M1_MASK,
          9133 => Opcode::PseudoVSOXSEG2EI16_V_M1_M2,
          9134 => Opcode::PseudoVSOXSEG2EI16_V_M1_M2_MASK,
          9135 => Opcode::PseudoVSOXSEG2EI16_V_M1_M4,
          9136 => Opcode::PseudoVSOXSEG2EI16_V_M1_M4_MASK,
          9137 => Opcode::PseudoVSOXSEG2EI16_V_M1_MF2,
          9138 => Opcode::PseudoVSOXSEG2EI16_V_M1_MF2_MASK,
          9139 => Opcode::PseudoVSOXSEG2EI16_V_M2_M1,
          9140 => Opcode::PseudoVSOXSEG2EI16_V_M2_M1_MASK,
          9141 => Opcode::PseudoVSOXSEG2EI16_V_M2_M2,
          9142 => Opcode::PseudoVSOXSEG2EI16_V_M2_M2_MASK,
          9143 => Opcode::PseudoVSOXSEG2EI16_V_M2_M4,
          9144 => Opcode::PseudoVSOXSEG2EI16_V_M2_M4_MASK,
          9145 => Opcode::PseudoVSOXSEG2EI16_V_M4_M2,
          9146 => Opcode::PseudoVSOXSEG2EI16_V_M4_M2_MASK,
          9147 => Opcode::PseudoVSOXSEG2EI16_V_M4_M4,
          9148 => Opcode::PseudoVSOXSEG2EI16_V_M4_M4_MASK,
          9149 => Opcode::PseudoVSOXSEG2EI16_V_M8_M4,
          9150 => Opcode::PseudoVSOXSEG2EI16_V_M8_M4_MASK,
          9151 => Opcode::PseudoVSOXSEG2EI16_V_MF2_M1,
          9152 => Opcode::PseudoVSOXSEG2EI16_V_MF2_M1_MASK,
          9153 => Opcode::PseudoVSOXSEG2EI16_V_MF2_M2,
          9154 => Opcode::PseudoVSOXSEG2EI16_V_MF2_M2_MASK,
          9155 => Opcode::PseudoVSOXSEG2EI16_V_MF2_MF2,
          9156 => Opcode::PseudoVSOXSEG2EI16_V_MF2_MF2_MASK,
          9157 => Opcode::PseudoVSOXSEG2EI16_V_MF2_MF4,
          9158 => Opcode::PseudoVSOXSEG2EI16_V_MF2_MF4_MASK,
          9159 => Opcode::PseudoVSOXSEG2EI16_V_MF4_M1,
          9160 => Opcode::PseudoVSOXSEG2EI16_V_MF4_M1_MASK,
          9161 => Opcode::PseudoVSOXSEG2EI16_V_MF4_MF2,
          9162 => Opcode::PseudoVSOXSEG2EI16_V_MF4_MF2_MASK,
          9163 => Opcode::PseudoVSOXSEG2EI16_V_MF4_MF4,
          9164 => Opcode::PseudoVSOXSEG2EI16_V_MF4_MF4_MASK,
          9165 => Opcode::PseudoVSOXSEG2EI16_V_MF4_MF8,
          9166 => Opcode::PseudoVSOXSEG2EI16_V_MF4_MF8_MASK,
          9167 => Opcode::PseudoVSOXSEG2EI32_V_M1_M1,
          9168 => Opcode::PseudoVSOXSEG2EI32_V_M1_M1_MASK,
          9169 => Opcode::PseudoVSOXSEG2EI32_V_M1_M2,
          9170 => Opcode::PseudoVSOXSEG2EI32_V_M1_M2_MASK,
          9171 => Opcode::PseudoVSOXSEG2EI32_V_M1_MF2,
          9172 => Opcode::PseudoVSOXSEG2EI32_V_M1_MF2_MASK,
          9173 => Opcode::PseudoVSOXSEG2EI32_V_M1_MF4,
          9174 => Opcode::PseudoVSOXSEG2EI32_V_M1_MF4_MASK,
          9175 => Opcode::PseudoVSOXSEG2EI32_V_M2_M1,
          9176 => Opcode::PseudoVSOXSEG2EI32_V_M2_M1_MASK,
          9177 => Opcode::PseudoVSOXSEG2EI32_V_M2_M2,
          9178 => Opcode::PseudoVSOXSEG2EI32_V_M2_M2_MASK,
          9179 => Opcode::PseudoVSOXSEG2EI32_V_M2_M4,
          9180 => Opcode::PseudoVSOXSEG2EI32_V_M2_M4_MASK,
          9181 => Opcode::PseudoVSOXSEG2EI32_V_M2_MF2,
          9182 => Opcode::PseudoVSOXSEG2EI32_V_M2_MF2_MASK,
          9183 => Opcode::PseudoVSOXSEG2EI32_V_M4_M1,
          9184 => Opcode::PseudoVSOXSEG2EI32_V_M4_M1_MASK,
          9185 => Opcode::PseudoVSOXSEG2EI32_V_M4_M2,
          9186 => Opcode::PseudoVSOXSEG2EI32_V_M4_M2_MASK,
          9187 => Opcode::PseudoVSOXSEG2EI32_V_M4_M4,
          9188 => Opcode::PseudoVSOXSEG2EI32_V_M4_M4_MASK,
          9189 => Opcode::PseudoVSOXSEG2EI32_V_M8_M2,
          9190 => Opcode::PseudoVSOXSEG2EI32_V_M8_M2_MASK,
          9191 => Opcode::PseudoVSOXSEG2EI32_V_M8_M4,
          9192 => Opcode::PseudoVSOXSEG2EI32_V_M8_M4_MASK,
          9193 => Opcode::PseudoVSOXSEG2EI32_V_MF2_M1,
          9194 => Opcode::PseudoVSOXSEG2EI32_V_MF2_M1_MASK,
          9195 => Opcode::PseudoVSOXSEG2EI32_V_MF2_MF2,
          9196 => Opcode::PseudoVSOXSEG2EI32_V_MF2_MF2_MASK,
          9197 => Opcode::PseudoVSOXSEG2EI32_V_MF2_MF4,
          9198 => Opcode::PseudoVSOXSEG2EI32_V_MF2_MF4_MASK,
          9199 => Opcode::PseudoVSOXSEG2EI32_V_MF2_MF8,
          9200 => Opcode::PseudoVSOXSEG2EI32_V_MF2_MF8_MASK,
          9201 => Opcode::PseudoVSOXSEG2EI64_V_M1_M1,
          9202 => Opcode::PseudoVSOXSEG2EI64_V_M1_M1_MASK,
          9203 => Opcode::PseudoVSOXSEG2EI64_V_M1_MF2,
          9204 => Opcode::PseudoVSOXSEG2EI64_V_M1_MF2_MASK,
          9205 => Opcode::PseudoVSOXSEG2EI64_V_M1_MF4,
          9206 => Opcode::PseudoVSOXSEG2EI64_V_M1_MF4_MASK,
          9207 => Opcode::PseudoVSOXSEG2EI64_V_M1_MF8,
          9208 => Opcode::PseudoVSOXSEG2EI64_V_M1_MF8_MASK,
          9209 => Opcode::PseudoVSOXSEG2EI64_V_M2_M1,
          9210 => Opcode::PseudoVSOXSEG2EI64_V_M2_M1_MASK,
          9211 => Opcode::PseudoVSOXSEG2EI64_V_M2_M2,
          9212 => Opcode::PseudoVSOXSEG2EI64_V_M2_M2_MASK,
          9213 => Opcode::PseudoVSOXSEG2EI64_V_M2_MF2,
          9214 => Opcode::PseudoVSOXSEG2EI64_V_M2_MF2_MASK,
          9215 => Opcode::PseudoVSOXSEG2EI64_V_M2_MF4,
          9216 => Opcode::PseudoVSOXSEG2EI64_V_M2_MF4_MASK,
          9217 => Opcode::PseudoVSOXSEG2EI64_V_M4_M1,
          9218 => Opcode::PseudoVSOXSEG2EI64_V_M4_M1_MASK,
          9219 => Opcode::PseudoVSOXSEG2EI64_V_M4_M2,
          9220 => Opcode::PseudoVSOXSEG2EI64_V_M4_M2_MASK,
          9221 => Opcode::PseudoVSOXSEG2EI64_V_M4_M4,
          9222 => Opcode::PseudoVSOXSEG2EI64_V_M4_M4_MASK,
          9223 => Opcode::PseudoVSOXSEG2EI64_V_M4_MF2,
          9224 => Opcode::PseudoVSOXSEG2EI64_V_M4_MF2_MASK,
          9225 => Opcode::PseudoVSOXSEG2EI64_V_M8_M1,
          9226 => Opcode::PseudoVSOXSEG2EI64_V_M8_M1_MASK,
          9227 => Opcode::PseudoVSOXSEG2EI64_V_M8_M2,
          9228 => Opcode::PseudoVSOXSEG2EI64_V_M8_M2_MASK,
          9229 => Opcode::PseudoVSOXSEG2EI64_V_M8_M4,
          9230 => Opcode::PseudoVSOXSEG2EI64_V_M8_M4_MASK,
          9231 => Opcode::PseudoVSOXSEG2EI8_V_M1_M1,
          9232 => Opcode::PseudoVSOXSEG2EI8_V_M1_M1_MASK,
          9233 => Opcode::PseudoVSOXSEG2EI8_V_M1_M2,
          9234 => Opcode::PseudoVSOXSEG2EI8_V_M1_M2_MASK,
          9235 => Opcode::PseudoVSOXSEG2EI8_V_M1_M4,
          9236 => Opcode::PseudoVSOXSEG2EI8_V_M1_M4_MASK,
          9237 => Opcode::PseudoVSOXSEG2EI8_V_M2_M2,
          9238 => Opcode::PseudoVSOXSEG2EI8_V_M2_M2_MASK,
          9239 => Opcode::PseudoVSOXSEG2EI8_V_M2_M4,
          9240 => Opcode::PseudoVSOXSEG2EI8_V_M2_M4_MASK,
          9241 => Opcode::PseudoVSOXSEG2EI8_V_M4_M4,
          9242 => Opcode::PseudoVSOXSEG2EI8_V_M4_M4_MASK,
          9243 => Opcode::PseudoVSOXSEG2EI8_V_MF2_M1,
          9244 => Opcode::PseudoVSOXSEG2EI8_V_MF2_M1_MASK,
          9245 => Opcode::PseudoVSOXSEG2EI8_V_MF2_M2,
          9246 => Opcode::PseudoVSOXSEG2EI8_V_MF2_M2_MASK,
          9247 => Opcode::PseudoVSOXSEG2EI8_V_MF2_M4,
          9248 => Opcode::PseudoVSOXSEG2EI8_V_MF2_M4_MASK,
          9249 => Opcode::PseudoVSOXSEG2EI8_V_MF2_MF2,
          9250 => Opcode::PseudoVSOXSEG2EI8_V_MF2_MF2_MASK,
          9251 => Opcode::PseudoVSOXSEG2EI8_V_MF4_M1,
          9252 => Opcode::PseudoVSOXSEG2EI8_V_MF4_M1_MASK,
          9253 => Opcode::PseudoVSOXSEG2EI8_V_MF4_M2,
          9254 => Opcode::PseudoVSOXSEG2EI8_V_MF4_M2_MASK,
          9255 => Opcode::PseudoVSOXSEG2EI8_V_MF4_MF2,
          9256 => Opcode::PseudoVSOXSEG2EI8_V_MF4_MF2_MASK,
          9257 => Opcode::PseudoVSOXSEG2EI8_V_MF4_MF4,
          9258 => Opcode::PseudoVSOXSEG2EI8_V_MF4_MF4_MASK,
          9259 => Opcode::PseudoVSOXSEG2EI8_V_MF8_M1,
          9260 => Opcode::PseudoVSOXSEG2EI8_V_MF8_M1_MASK,
          9261 => Opcode::PseudoVSOXSEG2EI8_V_MF8_MF2,
          9262 => Opcode::PseudoVSOXSEG2EI8_V_MF8_MF2_MASK,
          9263 => Opcode::PseudoVSOXSEG2EI8_V_MF8_MF4,
          9264 => Opcode::PseudoVSOXSEG2EI8_V_MF8_MF4_MASK,
          9265 => Opcode::PseudoVSOXSEG2EI8_V_MF8_MF8,
          9266 => Opcode::PseudoVSOXSEG2EI8_V_MF8_MF8_MASK,
          9267 => Opcode::PseudoVSOXSEG3EI16_V_M1_M1,
          9268 => Opcode::PseudoVSOXSEG3EI16_V_M1_M1_MASK,
          9269 => Opcode::PseudoVSOXSEG3EI16_V_M1_M2,
          9270 => Opcode::PseudoVSOXSEG3EI16_V_M1_M2_MASK,
          9271 => Opcode::PseudoVSOXSEG3EI16_V_M1_MF2,
          9272 => Opcode::PseudoVSOXSEG3EI16_V_M1_MF2_MASK,
          9273 => Opcode::PseudoVSOXSEG3EI16_V_M2_M1,
          9274 => Opcode::PseudoVSOXSEG3EI16_V_M2_M1_MASK,
          9275 => Opcode::PseudoVSOXSEG3EI16_V_M2_M2,
          9276 => Opcode::PseudoVSOXSEG3EI16_V_M2_M2_MASK,
          9277 => Opcode::PseudoVSOXSEG3EI16_V_M4_M2,
          9278 => Opcode::PseudoVSOXSEG3EI16_V_M4_M2_MASK,
          9279 => Opcode::PseudoVSOXSEG3EI16_V_MF2_M1,
          9280 => Opcode::PseudoVSOXSEG3EI16_V_MF2_M1_MASK,
          9281 => Opcode::PseudoVSOXSEG3EI16_V_MF2_M2,
          9282 => Opcode::PseudoVSOXSEG3EI16_V_MF2_M2_MASK,
          9283 => Opcode::PseudoVSOXSEG3EI16_V_MF2_MF2,
          9284 => Opcode::PseudoVSOXSEG3EI16_V_MF2_MF2_MASK,
          9285 => Opcode::PseudoVSOXSEG3EI16_V_MF2_MF4,
          9286 => Opcode::PseudoVSOXSEG3EI16_V_MF2_MF4_MASK,
          9287 => Opcode::PseudoVSOXSEG3EI16_V_MF4_M1,
          9288 => Opcode::PseudoVSOXSEG3EI16_V_MF4_M1_MASK,
          9289 => Opcode::PseudoVSOXSEG3EI16_V_MF4_MF2,
          9290 => Opcode::PseudoVSOXSEG3EI16_V_MF4_MF2_MASK,
          9291 => Opcode::PseudoVSOXSEG3EI16_V_MF4_MF4,
          9292 => Opcode::PseudoVSOXSEG3EI16_V_MF4_MF4_MASK,
          9293 => Opcode::PseudoVSOXSEG3EI16_V_MF4_MF8,
          9294 => Opcode::PseudoVSOXSEG3EI16_V_MF4_MF8_MASK,
          9295 => Opcode::PseudoVSOXSEG3EI32_V_M1_M1,
          9296 => Opcode::PseudoVSOXSEG3EI32_V_M1_M1_MASK,
          9297 => Opcode::PseudoVSOXSEG3EI32_V_M1_M2,
          9298 => Opcode::PseudoVSOXSEG3EI32_V_M1_M2_MASK,
          9299 => Opcode::PseudoVSOXSEG3EI32_V_M1_MF2,
          9300 => Opcode::PseudoVSOXSEG3EI32_V_M1_MF2_MASK,
          9301 => Opcode::PseudoVSOXSEG3EI32_V_M1_MF4,
          9302 => Opcode::PseudoVSOXSEG3EI32_V_M1_MF4_MASK,
          9303 => Opcode::PseudoVSOXSEG3EI32_V_M2_M1,
          9304 => Opcode::PseudoVSOXSEG3EI32_V_M2_M1_MASK,
          9305 => Opcode::PseudoVSOXSEG3EI32_V_M2_M2,
          9306 => Opcode::PseudoVSOXSEG3EI32_V_M2_M2_MASK,
          9307 => Opcode::PseudoVSOXSEG3EI32_V_M2_MF2,
          9308 => Opcode::PseudoVSOXSEG3EI32_V_M2_MF2_MASK,
          9309 => Opcode::PseudoVSOXSEG3EI32_V_M4_M1,
          9310 => Opcode::PseudoVSOXSEG3EI32_V_M4_M1_MASK,
          9311 => Opcode::PseudoVSOXSEG3EI32_V_M4_M2,
          9312 => Opcode::PseudoVSOXSEG3EI32_V_M4_M2_MASK,
          9313 => Opcode::PseudoVSOXSEG3EI32_V_M8_M2,
          9314 => Opcode::PseudoVSOXSEG3EI32_V_M8_M2_MASK,
          9315 => Opcode::PseudoVSOXSEG3EI32_V_MF2_M1,
          9316 => Opcode::PseudoVSOXSEG3EI32_V_MF2_M1_MASK,
          9317 => Opcode::PseudoVSOXSEG3EI32_V_MF2_MF2,
          9318 => Opcode::PseudoVSOXSEG3EI32_V_MF2_MF2_MASK,
          9319 => Opcode::PseudoVSOXSEG3EI32_V_MF2_MF4,
          9320 => Opcode::PseudoVSOXSEG3EI32_V_MF2_MF4_MASK,
          9321 => Opcode::PseudoVSOXSEG3EI32_V_MF2_MF8,
          9322 => Opcode::PseudoVSOXSEG3EI32_V_MF2_MF8_MASK,
          9323 => Opcode::PseudoVSOXSEG3EI64_V_M1_M1,
          9324 => Opcode::PseudoVSOXSEG3EI64_V_M1_M1_MASK,
          9325 => Opcode::PseudoVSOXSEG3EI64_V_M1_MF2,
          9326 => Opcode::PseudoVSOXSEG3EI64_V_M1_MF2_MASK,
          9327 => Opcode::PseudoVSOXSEG3EI64_V_M1_MF4,
          9328 => Opcode::PseudoVSOXSEG3EI64_V_M1_MF4_MASK,
          9329 => Opcode::PseudoVSOXSEG3EI64_V_M1_MF8,
          9330 => Opcode::PseudoVSOXSEG3EI64_V_M1_MF8_MASK,
          9331 => Opcode::PseudoVSOXSEG3EI64_V_M2_M1,
          9332 => Opcode::PseudoVSOXSEG3EI64_V_M2_M1_MASK,
          9333 => Opcode::PseudoVSOXSEG3EI64_V_M2_M2,
          9334 => Opcode::PseudoVSOXSEG3EI64_V_M2_M2_MASK,
          9335 => Opcode::PseudoVSOXSEG3EI64_V_M2_MF2,
          9336 => Opcode::PseudoVSOXSEG3EI64_V_M2_MF2_MASK,
          9337 => Opcode::PseudoVSOXSEG3EI64_V_M2_MF4,
          9338 => Opcode::PseudoVSOXSEG3EI64_V_M2_MF4_MASK,
          9339 => Opcode::PseudoVSOXSEG3EI64_V_M4_M1,
          9340 => Opcode::PseudoVSOXSEG3EI64_V_M4_M1_MASK,
          9341 => Opcode::PseudoVSOXSEG3EI64_V_M4_M2,
          9342 => Opcode::PseudoVSOXSEG3EI64_V_M4_M2_MASK,
          9343 => Opcode::PseudoVSOXSEG3EI64_V_M4_MF2,
          9344 => Opcode::PseudoVSOXSEG3EI64_V_M4_MF2_MASK,
          9345 => Opcode::PseudoVSOXSEG3EI64_V_M8_M1,
          9346 => Opcode::PseudoVSOXSEG3EI64_V_M8_M1_MASK,
          9347 => Opcode::PseudoVSOXSEG3EI64_V_M8_M2,
          9348 => Opcode::PseudoVSOXSEG3EI64_V_M8_M2_MASK,
          9349 => Opcode::PseudoVSOXSEG3EI8_V_M1_M1,
          9350 => Opcode::PseudoVSOXSEG3EI8_V_M1_M1_MASK,
          9351 => Opcode::PseudoVSOXSEG3EI8_V_M1_M2,
          9352 => Opcode::PseudoVSOXSEG3EI8_V_M1_M2_MASK,
          9353 => Opcode::PseudoVSOXSEG3EI8_V_M2_M2,
          9354 => Opcode::PseudoVSOXSEG3EI8_V_M2_M2_MASK,
          9355 => Opcode::PseudoVSOXSEG3EI8_V_MF2_M1,
          9356 => Opcode::PseudoVSOXSEG3EI8_V_MF2_M1_MASK,
          9357 => Opcode::PseudoVSOXSEG3EI8_V_MF2_M2,
          9358 => Opcode::PseudoVSOXSEG3EI8_V_MF2_M2_MASK,
          9359 => Opcode::PseudoVSOXSEG3EI8_V_MF2_MF2,
          9360 => Opcode::PseudoVSOXSEG3EI8_V_MF2_MF2_MASK,
          9361 => Opcode::PseudoVSOXSEG3EI8_V_MF4_M1,
          9362 => Opcode::PseudoVSOXSEG3EI8_V_MF4_M1_MASK,
          9363 => Opcode::PseudoVSOXSEG3EI8_V_MF4_M2,
          9364 => Opcode::PseudoVSOXSEG3EI8_V_MF4_M2_MASK,
          9365 => Opcode::PseudoVSOXSEG3EI8_V_MF4_MF2,
          9366 => Opcode::PseudoVSOXSEG3EI8_V_MF4_MF2_MASK,
          9367 => Opcode::PseudoVSOXSEG3EI8_V_MF4_MF4,
          9368 => Opcode::PseudoVSOXSEG3EI8_V_MF4_MF4_MASK,
          9369 => Opcode::PseudoVSOXSEG3EI8_V_MF8_M1,
          9370 => Opcode::PseudoVSOXSEG3EI8_V_MF8_M1_MASK,
          9371 => Opcode::PseudoVSOXSEG3EI8_V_MF8_MF2,
          9372 => Opcode::PseudoVSOXSEG3EI8_V_MF8_MF2_MASK,
          9373 => Opcode::PseudoVSOXSEG3EI8_V_MF8_MF4,
          9374 => Opcode::PseudoVSOXSEG3EI8_V_MF8_MF4_MASK,
          9375 => Opcode::PseudoVSOXSEG3EI8_V_MF8_MF8,
          9376 => Opcode::PseudoVSOXSEG3EI8_V_MF8_MF8_MASK,
          9377 => Opcode::PseudoVSOXSEG4EI16_V_M1_M1,
          9378 => Opcode::PseudoVSOXSEG4EI16_V_M1_M1_MASK,
          9379 => Opcode::PseudoVSOXSEG4EI16_V_M1_M2,
          9380 => Opcode::PseudoVSOXSEG4EI16_V_M1_M2_MASK,
          9381 => Opcode::PseudoVSOXSEG4EI16_V_M1_MF2,
          9382 => Opcode::PseudoVSOXSEG4EI16_V_M1_MF2_MASK,
          9383 => Opcode::PseudoVSOXSEG4EI16_V_M2_M1,
          9384 => Opcode::PseudoVSOXSEG4EI16_V_M2_M1_MASK,
          9385 => Opcode::PseudoVSOXSEG4EI16_V_M2_M2,
          9386 => Opcode::PseudoVSOXSEG4EI16_V_M2_M2_MASK,
          9387 => Opcode::PseudoVSOXSEG4EI16_V_M4_M2,
          9388 => Opcode::PseudoVSOXSEG4EI16_V_M4_M2_MASK,
          9389 => Opcode::PseudoVSOXSEG4EI16_V_MF2_M1,
          9390 => Opcode::PseudoVSOXSEG4EI16_V_MF2_M1_MASK,
          9391 => Opcode::PseudoVSOXSEG4EI16_V_MF2_M2,
          9392 => Opcode::PseudoVSOXSEG4EI16_V_MF2_M2_MASK,
          9393 => Opcode::PseudoVSOXSEG4EI16_V_MF2_MF2,
          9394 => Opcode::PseudoVSOXSEG4EI16_V_MF2_MF2_MASK,
          9395 => Opcode::PseudoVSOXSEG4EI16_V_MF2_MF4,
          9396 => Opcode::PseudoVSOXSEG4EI16_V_MF2_MF4_MASK,
          9397 => Opcode::PseudoVSOXSEG4EI16_V_MF4_M1,
          9398 => Opcode::PseudoVSOXSEG4EI16_V_MF4_M1_MASK,
          9399 => Opcode::PseudoVSOXSEG4EI16_V_MF4_MF2,
          9400 => Opcode::PseudoVSOXSEG4EI16_V_MF4_MF2_MASK,
          9401 => Opcode::PseudoVSOXSEG4EI16_V_MF4_MF4,
          9402 => Opcode::PseudoVSOXSEG4EI16_V_MF4_MF4_MASK,
          9403 => Opcode::PseudoVSOXSEG4EI16_V_MF4_MF8,
          9404 => Opcode::PseudoVSOXSEG4EI16_V_MF4_MF8_MASK,
          9405 => Opcode::PseudoVSOXSEG4EI32_V_M1_M1,
          9406 => Opcode::PseudoVSOXSEG4EI32_V_M1_M1_MASK,
          9407 => Opcode::PseudoVSOXSEG4EI32_V_M1_M2,
          9408 => Opcode::PseudoVSOXSEG4EI32_V_M1_M2_MASK,
          9409 => Opcode::PseudoVSOXSEG4EI32_V_M1_MF2,
          9410 => Opcode::PseudoVSOXSEG4EI32_V_M1_MF2_MASK,
          9411 => Opcode::PseudoVSOXSEG4EI32_V_M1_MF4,
          9412 => Opcode::PseudoVSOXSEG4EI32_V_M1_MF4_MASK,
          9413 => Opcode::PseudoVSOXSEG4EI32_V_M2_M1,
          9414 => Opcode::PseudoVSOXSEG4EI32_V_M2_M1_MASK,
          9415 => Opcode::PseudoVSOXSEG4EI32_V_M2_M2,
          9416 => Opcode::PseudoVSOXSEG4EI32_V_M2_M2_MASK,
          9417 => Opcode::PseudoVSOXSEG4EI32_V_M2_MF2,
          9418 => Opcode::PseudoVSOXSEG4EI32_V_M2_MF2_MASK,
          9419 => Opcode::PseudoVSOXSEG4EI32_V_M4_M1,
          9420 => Opcode::PseudoVSOXSEG4EI32_V_M4_M1_MASK,
          9421 => Opcode::PseudoVSOXSEG4EI32_V_M4_M2,
          9422 => Opcode::PseudoVSOXSEG4EI32_V_M4_M2_MASK,
          9423 => Opcode::PseudoVSOXSEG4EI32_V_M8_M2,
          9424 => Opcode::PseudoVSOXSEG4EI32_V_M8_M2_MASK,
          9425 => Opcode::PseudoVSOXSEG4EI32_V_MF2_M1,
          9426 => Opcode::PseudoVSOXSEG4EI32_V_MF2_M1_MASK,
          9427 => Opcode::PseudoVSOXSEG4EI32_V_MF2_MF2,
          9428 => Opcode::PseudoVSOXSEG4EI32_V_MF2_MF2_MASK,
          9429 => Opcode::PseudoVSOXSEG4EI32_V_MF2_MF4,
          9430 => Opcode::PseudoVSOXSEG4EI32_V_MF2_MF4_MASK,
          9431 => Opcode::PseudoVSOXSEG4EI32_V_MF2_MF8,
          9432 => Opcode::PseudoVSOXSEG4EI32_V_MF2_MF8_MASK,
          9433 => Opcode::PseudoVSOXSEG4EI64_V_M1_M1,
          9434 => Opcode::PseudoVSOXSEG4EI64_V_M1_M1_MASK,
          9435 => Opcode::PseudoVSOXSEG4EI64_V_M1_MF2,
          9436 => Opcode::PseudoVSOXSEG4EI64_V_M1_MF2_MASK,
          9437 => Opcode::PseudoVSOXSEG4EI64_V_M1_MF4,
          9438 => Opcode::PseudoVSOXSEG4EI64_V_M1_MF4_MASK,
          9439 => Opcode::PseudoVSOXSEG4EI64_V_M1_MF8,
          9440 => Opcode::PseudoVSOXSEG4EI64_V_M1_MF8_MASK,
          9441 => Opcode::PseudoVSOXSEG4EI64_V_M2_M1,
          9442 => Opcode::PseudoVSOXSEG4EI64_V_M2_M1_MASK,
          9443 => Opcode::PseudoVSOXSEG4EI64_V_M2_M2,
          9444 => Opcode::PseudoVSOXSEG4EI64_V_M2_M2_MASK,
          9445 => Opcode::PseudoVSOXSEG4EI64_V_M2_MF2,
          9446 => Opcode::PseudoVSOXSEG4EI64_V_M2_MF2_MASK,
          9447 => Opcode::PseudoVSOXSEG4EI64_V_M2_MF4,
          9448 => Opcode::PseudoVSOXSEG4EI64_V_M2_MF4_MASK,
          9449 => Opcode::PseudoVSOXSEG4EI64_V_M4_M1,
          9450 => Opcode::PseudoVSOXSEG4EI64_V_M4_M1_MASK,
          9451 => Opcode::PseudoVSOXSEG4EI64_V_M4_M2,
          9452 => Opcode::PseudoVSOXSEG4EI64_V_M4_M2_MASK,
          9453 => Opcode::PseudoVSOXSEG4EI64_V_M4_MF2,
          9454 => Opcode::PseudoVSOXSEG4EI64_V_M4_MF2_MASK,
          9455 => Opcode::PseudoVSOXSEG4EI64_V_M8_M1,
          9456 => Opcode::PseudoVSOXSEG4EI64_V_M8_M1_MASK,
          9457 => Opcode::PseudoVSOXSEG4EI64_V_M8_M2,
          9458 => Opcode::PseudoVSOXSEG4EI64_V_M8_M2_MASK,
          9459 => Opcode::PseudoVSOXSEG4EI8_V_M1_M1,
          9460 => Opcode::PseudoVSOXSEG4EI8_V_M1_M1_MASK,
          9461 => Opcode::PseudoVSOXSEG4EI8_V_M1_M2,
          9462 => Opcode::PseudoVSOXSEG4EI8_V_M1_M2_MASK,
          9463 => Opcode::PseudoVSOXSEG4EI8_V_M2_M2,
          9464 => Opcode::PseudoVSOXSEG4EI8_V_M2_M2_MASK,
          9465 => Opcode::PseudoVSOXSEG4EI8_V_MF2_M1,
          9466 => Opcode::PseudoVSOXSEG4EI8_V_MF2_M1_MASK,
          9467 => Opcode::PseudoVSOXSEG4EI8_V_MF2_M2,
          9468 => Opcode::PseudoVSOXSEG4EI8_V_MF2_M2_MASK,
          9469 => Opcode::PseudoVSOXSEG4EI8_V_MF2_MF2,
          9470 => Opcode::PseudoVSOXSEG4EI8_V_MF2_MF2_MASK,
          9471 => Opcode::PseudoVSOXSEG4EI8_V_MF4_M1,
          9472 => Opcode::PseudoVSOXSEG4EI8_V_MF4_M1_MASK,
          9473 => Opcode::PseudoVSOXSEG4EI8_V_MF4_M2,
          9474 => Opcode::PseudoVSOXSEG4EI8_V_MF4_M2_MASK,
          9475 => Opcode::PseudoVSOXSEG4EI8_V_MF4_MF2,
          9476 => Opcode::PseudoVSOXSEG4EI8_V_MF4_MF2_MASK,
          9477 => Opcode::PseudoVSOXSEG4EI8_V_MF4_MF4,
          9478 => Opcode::PseudoVSOXSEG4EI8_V_MF4_MF4_MASK,
          9479 => Opcode::PseudoVSOXSEG4EI8_V_MF8_M1,
          9480 => Opcode::PseudoVSOXSEG4EI8_V_MF8_M1_MASK,
          9481 => Opcode::PseudoVSOXSEG4EI8_V_MF8_MF2,
          9482 => Opcode::PseudoVSOXSEG4EI8_V_MF8_MF2_MASK,
          9483 => Opcode::PseudoVSOXSEG4EI8_V_MF8_MF4,
          9484 => Opcode::PseudoVSOXSEG4EI8_V_MF8_MF4_MASK,
          9485 => Opcode::PseudoVSOXSEG4EI8_V_MF8_MF8,
          9486 => Opcode::PseudoVSOXSEG4EI8_V_MF8_MF8_MASK,
          9487 => Opcode::PseudoVSOXSEG5EI16_V_M1_M1,
          9488 => Opcode::PseudoVSOXSEG5EI16_V_M1_M1_MASK,
          9489 => Opcode::PseudoVSOXSEG5EI16_V_M1_MF2,
          9490 => Opcode::PseudoVSOXSEG5EI16_V_M1_MF2_MASK,
          9491 => Opcode::PseudoVSOXSEG5EI16_V_M2_M1,
          9492 => Opcode::PseudoVSOXSEG5EI16_V_M2_M1_MASK,
          9493 => Opcode::PseudoVSOXSEG5EI16_V_MF2_M1,
          9494 => Opcode::PseudoVSOXSEG5EI16_V_MF2_M1_MASK,
          9495 => Opcode::PseudoVSOXSEG5EI16_V_MF2_MF2,
          9496 => Opcode::PseudoVSOXSEG5EI16_V_MF2_MF2_MASK,
          9497 => Opcode::PseudoVSOXSEG5EI16_V_MF2_MF4,
          9498 => Opcode::PseudoVSOXSEG5EI16_V_MF2_MF4_MASK,
          9499 => Opcode::PseudoVSOXSEG5EI16_V_MF4_M1,
          9500 => Opcode::PseudoVSOXSEG5EI16_V_MF4_M1_MASK,
          9501 => Opcode::PseudoVSOXSEG5EI16_V_MF4_MF2,
          9502 => Opcode::PseudoVSOXSEG5EI16_V_MF4_MF2_MASK,
          9503 => Opcode::PseudoVSOXSEG5EI16_V_MF4_MF4,
          9504 => Opcode::PseudoVSOXSEG5EI16_V_MF4_MF4_MASK,
          9505 => Opcode::PseudoVSOXSEG5EI16_V_MF4_MF8,
          9506 => Opcode::PseudoVSOXSEG5EI16_V_MF4_MF8_MASK,
          9507 => Opcode::PseudoVSOXSEG5EI32_V_M1_M1,
          9508 => Opcode::PseudoVSOXSEG5EI32_V_M1_M1_MASK,
          9509 => Opcode::PseudoVSOXSEG5EI32_V_M1_MF2,
          9510 => Opcode::PseudoVSOXSEG5EI32_V_M1_MF2_MASK,
          9511 => Opcode::PseudoVSOXSEG5EI32_V_M1_MF4,
          9512 => Opcode::PseudoVSOXSEG5EI32_V_M1_MF4_MASK,
          9513 => Opcode::PseudoVSOXSEG5EI32_V_M2_M1,
          9514 => Opcode::PseudoVSOXSEG5EI32_V_M2_M1_MASK,
          9515 => Opcode::PseudoVSOXSEG5EI32_V_M2_MF2,
          9516 => Opcode::PseudoVSOXSEG5EI32_V_M2_MF2_MASK,
          9517 => Opcode::PseudoVSOXSEG5EI32_V_M4_M1,
          9518 => Opcode::PseudoVSOXSEG5EI32_V_M4_M1_MASK,
          9519 => Opcode::PseudoVSOXSEG5EI32_V_MF2_M1,
          9520 => Opcode::PseudoVSOXSEG5EI32_V_MF2_M1_MASK,
          9521 => Opcode::PseudoVSOXSEG5EI32_V_MF2_MF2,
          9522 => Opcode::PseudoVSOXSEG5EI32_V_MF2_MF2_MASK,
          9523 => Opcode::PseudoVSOXSEG5EI32_V_MF2_MF4,
          9524 => Opcode::PseudoVSOXSEG5EI32_V_MF2_MF4_MASK,
          9525 => Opcode::PseudoVSOXSEG5EI32_V_MF2_MF8,
          9526 => Opcode::PseudoVSOXSEG5EI32_V_MF2_MF8_MASK,
          9527 => Opcode::PseudoVSOXSEG5EI64_V_M1_M1,
          9528 => Opcode::PseudoVSOXSEG5EI64_V_M1_M1_MASK,
          9529 => Opcode::PseudoVSOXSEG5EI64_V_M1_MF2,
          9530 => Opcode::PseudoVSOXSEG5EI64_V_M1_MF2_MASK,
          9531 => Opcode::PseudoVSOXSEG5EI64_V_M1_MF4,
          9532 => Opcode::PseudoVSOXSEG5EI64_V_M1_MF4_MASK,
          9533 => Opcode::PseudoVSOXSEG5EI64_V_M1_MF8,
          9534 => Opcode::PseudoVSOXSEG5EI64_V_M1_MF8_MASK,
          9535 => Opcode::PseudoVSOXSEG5EI64_V_M2_M1,
          9536 => Opcode::PseudoVSOXSEG5EI64_V_M2_M1_MASK,
          9537 => Opcode::PseudoVSOXSEG5EI64_V_M2_MF2,
          9538 => Opcode::PseudoVSOXSEG5EI64_V_M2_MF2_MASK,
          9539 => Opcode::PseudoVSOXSEG5EI64_V_M2_MF4,
          9540 => Opcode::PseudoVSOXSEG5EI64_V_M2_MF4_MASK,
          9541 => Opcode::PseudoVSOXSEG5EI64_V_M4_M1,
          9542 => Opcode::PseudoVSOXSEG5EI64_V_M4_M1_MASK,
          9543 => Opcode::PseudoVSOXSEG5EI64_V_M4_MF2,
          9544 => Opcode::PseudoVSOXSEG5EI64_V_M4_MF2_MASK,
          9545 => Opcode::PseudoVSOXSEG5EI64_V_M8_M1,
          9546 => Opcode::PseudoVSOXSEG5EI64_V_M8_M1_MASK,
          9547 => Opcode::PseudoVSOXSEG5EI8_V_M1_M1,
          9548 => Opcode::PseudoVSOXSEG5EI8_V_M1_M1_MASK,
          9549 => Opcode::PseudoVSOXSEG5EI8_V_MF2_M1,
          9550 => Opcode::PseudoVSOXSEG5EI8_V_MF2_M1_MASK,
          9551 => Opcode::PseudoVSOXSEG5EI8_V_MF2_MF2,
          9552 => Opcode::PseudoVSOXSEG5EI8_V_MF2_MF2_MASK,
          9553 => Opcode::PseudoVSOXSEG5EI8_V_MF4_M1,
          9554 => Opcode::PseudoVSOXSEG5EI8_V_MF4_M1_MASK,
          9555 => Opcode::PseudoVSOXSEG5EI8_V_MF4_MF2,
          9556 => Opcode::PseudoVSOXSEG5EI8_V_MF4_MF2_MASK,
          9557 => Opcode::PseudoVSOXSEG5EI8_V_MF4_MF4,
          9558 => Opcode::PseudoVSOXSEG5EI8_V_MF4_MF4_MASK,
          9559 => Opcode::PseudoVSOXSEG5EI8_V_MF8_M1,
          9560 => Opcode::PseudoVSOXSEG5EI8_V_MF8_M1_MASK,
          9561 => Opcode::PseudoVSOXSEG5EI8_V_MF8_MF2,
          9562 => Opcode::PseudoVSOXSEG5EI8_V_MF8_MF2_MASK,
          9563 => Opcode::PseudoVSOXSEG5EI8_V_MF8_MF4,
          9564 => Opcode::PseudoVSOXSEG5EI8_V_MF8_MF4_MASK,
          9565 => Opcode::PseudoVSOXSEG5EI8_V_MF8_MF8,
          9566 => Opcode::PseudoVSOXSEG5EI8_V_MF8_MF8_MASK,
          9567 => Opcode::PseudoVSOXSEG6EI16_V_M1_M1,
          9568 => Opcode::PseudoVSOXSEG6EI16_V_M1_M1_MASK,
          9569 => Opcode::PseudoVSOXSEG6EI16_V_M1_MF2,
          9570 => Opcode::PseudoVSOXSEG6EI16_V_M1_MF2_MASK,
          9571 => Opcode::PseudoVSOXSEG6EI16_V_M2_M1,
          9572 => Opcode::PseudoVSOXSEG6EI16_V_M2_M1_MASK,
          9573 => Opcode::PseudoVSOXSEG6EI16_V_MF2_M1,
          9574 => Opcode::PseudoVSOXSEG6EI16_V_MF2_M1_MASK,
          9575 => Opcode::PseudoVSOXSEG6EI16_V_MF2_MF2,
          9576 => Opcode::PseudoVSOXSEG6EI16_V_MF2_MF2_MASK,
          9577 => Opcode::PseudoVSOXSEG6EI16_V_MF2_MF4,
          9578 => Opcode::PseudoVSOXSEG6EI16_V_MF2_MF4_MASK,
          9579 => Opcode::PseudoVSOXSEG6EI16_V_MF4_M1,
          9580 => Opcode::PseudoVSOXSEG6EI16_V_MF4_M1_MASK,
          9581 => Opcode::PseudoVSOXSEG6EI16_V_MF4_MF2,
          9582 => Opcode::PseudoVSOXSEG6EI16_V_MF4_MF2_MASK,
          9583 => Opcode::PseudoVSOXSEG6EI16_V_MF4_MF4,
          9584 => Opcode::PseudoVSOXSEG6EI16_V_MF4_MF4_MASK,
          9585 => Opcode::PseudoVSOXSEG6EI16_V_MF4_MF8,
          9586 => Opcode::PseudoVSOXSEG6EI16_V_MF4_MF8_MASK,
          9587 => Opcode::PseudoVSOXSEG6EI32_V_M1_M1,
          9588 => Opcode::PseudoVSOXSEG6EI32_V_M1_M1_MASK,
          9589 => Opcode::PseudoVSOXSEG6EI32_V_M1_MF2,
          9590 => Opcode::PseudoVSOXSEG6EI32_V_M1_MF2_MASK,
          9591 => Opcode::PseudoVSOXSEG6EI32_V_M1_MF4,
          9592 => Opcode::PseudoVSOXSEG6EI32_V_M1_MF4_MASK,
          9593 => Opcode::PseudoVSOXSEG6EI32_V_M2_M1,
          9594 => Opcode::PseudoVSOXSEG6EI32_V_M2_M1_MASK,
          9595 => Opcode::PseudoVSOXSEG6EI32_V_M2_MF2,
          9596 => Opcode::PseudoVSOXSEG6EI32_V_M2_MF2_MASK,
          9597 => Opcode::PseudoVSOXSEG6EI32_V_M4_M1,
          9598 => Opcode::PseudoVSOXSEG6EI32_V_M4_M1_MASK,
          9599 => Opcode::PseudoVSOXSEG6EI32_V_MF2_M1,
          9600 => Opcode::PseudoVSOXSEG6EI32_V_MF2_M1_MASK,
          9601 => Opcode::PseudoVSOXSEG6EI32_V_MF2_MF2,
          9602 => Opcode::PseudoVSOXSEG6EI32_V_MF2_MF2_MASK,
          9603 => Opcode::PseudoVSOXSEG6EI32_V_MF2_MF4,
          9604 => Opcode::PseudoVSOXSEG6EI32_V_MF2_MF4_MASK,
          9605 => Opcode::PseudoVSOXSEG6EI32_V_MF2_MF8,
          9606 => Opcode::PseudoVSOXSEG6EI32_V_MF2_MF8_MASK,
          9607 => Opcode::PseudoVSOXSEG6EI64_V_M1_M1,
          9608 => Opcode::PseudoVSOXSEG6EI64_V_M1_M1_MASK,
          9609 => Opcode::PseudoVSOXSEG6EI64_V_M1_MF2,
          9610 => Opcode::PseudoVSOXSEG6EI64_V_M1_MF2_MASK,
          9611 => Opcode::PseudoVSOXSEG6EI64_V_M1_MF4,
          9612 => Opcode::PseudoVSOXSEG6EI64_V_M1_MF4_MASK,
          9613 => Opcode::PseudoVSOXSEG6EI64_V_M1_MF8,
          9614 => Opcode::PseudoVSOXSEG6EI64_V_M1_MF8_MASK,
          9615 => Opcode::PseudoVSOXSEG6EI64_V_M2_M1,
          9616 => Opcode::PseudoVSOXSEG6EI64_V_M2_M1_MASK,
          9617 => Opcode::PseudoVSOXSEG6EI64_V_M2_MF2,
          9618 => Opcode::PseudoVSOXSEG6EI64_V_M2_MF2_MASK,
          9619 => Opcode::PseudoVSOXSEG6EI64_V_M2_MF4,
          9620 => Opcode::PseudoVSOXSEG6EI64_V_M2_MF4_MASK,
          9621 => Opcode::PseudoVSOXSEG6EI64_V_M4_M1,
          9622 => Opcode::PseudoVSOXSEG6EI64_V_M4_M1_MASK,
          9623 => Opcode::PseudoVSOXSEG6EI64_V_M4_MF2,
          9624 => Opcode::PseudoVSOXSEG6EI64_V_M4_MF2_MASK,
          9625 => Opcode::PseudoVSOXSEG6EI64_V_M8_M1,
          9626 => Opcode::PseudoVSOXSEG6EI64_V_M8_M1_MASK,
          9627 => Opcode::PseudoVSOXSEG6EI8_V_M1_M1,
          9628 => Opcode::PseudoVSOXSEG6EI8_V_M1_M1_MASK,
          9629 => Opcode::PseudoVSOXSEG6EI8_V_MF2_M1,
          9630 => Opcode::PseudoVSOXSEG6EI8_V_MF2_M1_MASK,
          9631 => Opcode::PseudoVSOXSEG6EI8_V_MF2_MF2,
          9632 => Opcode::PseudoVSOXSEG6EI8_V_MF2_MF2_MASK,
          9633 => Opcode::PseudoVSOXSEG6EI8_V_MF4_M1,
          9634 => Opcode::PseudoVSOXSEG6EI8_V_MF4_M1_MASK,
          9635 => Opcode::PseudoVSOXSEG6EI8_V_MF4_MF2,
          9636 => Opcode::PseudoVSOXSEG6EI8_V_MF4_MF2_MASK,
          9637 => Opcode::PseudoVSOXSEG6EI8_V_MF4_MF4,
          9638 => Opcode::PseudoVSOXSEG6EI8_V_MF4_MF4_MASK,
          9639 => Opcode::PseudoVSOXSEG6EI8_V_MF8_M1,
          9640 => Opcode::PseudoVSOXSEG6EI8_V_MF8_M1_MASK,
          9641 => Opcode::PseudoVSOXSEG6EI8_V_MF8_MF2,
          9642 => Opcode::PseudoVSOXSEG6EI8_V_MF8_MF2_MASK,
          9643 => Opcode::PseudoVSOXSEG6EI8_V_MF8_MF4,
          9644 => Opcode::PseudoVSOXSEG6EI8_V_MF8_MF4_MASK,
          9645 => Opcode::PseudoVSOXSEG6EI8_V_MF8_MF8,
          9646 => Opcode::PseudoVSOXSEG6EI8_V_MF8_MF8_MASK,
          9647 => Opcode::PseudoVSOXSEG7EI16_V_M1_M1,
          9648 => Opcode::PseudoVSOXSEG7EI16_V_M1_M1_MASK,
          9649 => Opcode::PseudoVSOXSEG7EI16_V_M1_MF2,
          9650 => Opcode::PseudoVSOXSEG7EI16_V_M1_MF2_MASK,
          9651 => Opcode::PseudoVSOXSEG7EI16_V_M2_M1,
          9652 => Opcode::PseudoVSOXSEG7EI16_V_M2_M1_MASK,
          9653 => Opcode::PseudoVSOXSEG7EI16_V_MF2_M1,
          9654 => Opcode::PseudoVSOXSEG7EI16_V_MF2_M1_MASK,
          9655 => Opcode::PseudoVSOXSEG7EI16_V_MF2_MF2,
          9656 => Opcode::PseudoVSOXSEG7EI16_V_MF2_MF2_MASK,
          9657 => Opcode::PseudoVSOXSEG7EI16_V_MF2_MF4,
          9658 => Opcode::PseudoVSOXSEG7EI16_V_MF2_MF4_MASK,
          9659 => Opcode::PseudoVSOXSEG7EI16_V_MF4_M1,
          9660 => Opcode::PseudoVSOXSEG7EI16_V_MF4_M1_MASK,
          9661 => Opcode::PseudoVSOXSEG7EI16_V_MF4_MF2,
          9662 => Opcode::PseudoVSOXSEG7EI16_V_MF4_MF2_MASK,
          9663 => Opcode::PseudoVSOXSEG7EI16_V_MF4_MF4,
          9664 => Opcode::PseudoVSOXSEG7EI16_V_MF4_MF4_MASK,
          9665 => Opcode::PseudoVSOXSEG7EI16_V_MF4_MF8,
          9666 => Opcode::PseudoVSOXSEG7EI16_V_MF4_MF8_MASK,
          9667 => Opcode::PseudoVSOXSEG7EI32_V_M1_M1,
          9668 => Opcode::PseudoVSOXSEG7EI32_V_M1_M1_MASK,
          9669 => Opcode::PseudoVSOXSEG7EI32_V_M1_MF2,
          9670 => Opcode::PseudoVSOXSEG7EI32_V_M1_MF2_MASK,
          9671 => Opcode::PseudoVSOXSEG7EI32_V_M1_MF4,
          9672 => Opcode::PseudoVSOXSEG7EI32_V_M1_MF4_MASK,
          9673 => Opcode::PseudoVSOXSEG7EI32_V_M2_M1,
          9674 => Opcode::PseudoVSOXSEG7EI32_V_M2_M1_MASK,
          9675 => Opcode::PseudoVSOXSEG7EI32_V_M2_MF2,
          9676 => Opcode::PseudoVSOXSEG7EI32_V_M2_MF2_MASK,
          9677 => Opcode::PseudoVSOXSEG7EI32_V_M4_M1,
          9678 => Opcode::PseudoVSOXSEG7EI32_V_M4_M1_MASK,
          9679 => Opcode::PseudoVSOXSEG7EI32_V_MF2_M1,
          9680 => Opcode::PseudoVSOXSEG7EI32_V_MF2_M1_MASK,
          9681 => Opcode::PseudoVSOXSEG7EI32_V_MF2_MF2,
          9682 => Opcode::PseudoVSOXSEG7EI32_V_MF2_MF2_MASK,
          9683 => Opcode::PseudoVSOXSEG7EI32_V_MF2_MF4,
          9684 => Opcode::PseudoVSOXSEG7EI32_V_MF2_MF4_MASK,
          9685 => Opcode::PseudoVSOXSEG7EI32_V_MF2_MF8,
          9686 => Opcode::PseudoVSOXSEG7EI32_V_MF2_MF8_MASK,
          9687 => Opcode::PseudoVSOXSEG7EI64_V_M1_M1,
          9688 => Opcode::PseudoVSOXSEG7EI64_V_M1_M1_MASK,
          9689 => Opcode::PseudoVSOXSEG7EI64_V_M1_MF2,
          9690 => Opcode::PseudoVSOXSEG7EI64_V_M1_MF2_MASK,
          9691 => Opcode::PseudoVSOXSEG7EI64_V_M1_MF4,
          9692 => Opcode::PseudoVSOXSEG7EI64_V_M1_MF4_MASK,
          9693 => Opcode::PseudoVSOXSEG7EI64_V_M1_MF8,
          9694 => Opcode::PseudoVSOXSEG7EI64_V_M1_MF8_MASK,
          9695 => Opcode::PseudoVSOXSEG7EI64_V_M2_M1,
          9696 => Opcode::PseudoVSOXSEG7EI64_V_M2_M1_MASK,
          9697 => Opcode::PseudoVSOXSEG7EI64_V_M2_MF2,
          9698 => Opcode::PseudoVSOXSEG7EI64_V_M2_MF2_MASK,
          9699 => Opcode::PseudoVSOXSEG7EI64_V_M2_MF4,
          9700 => Opcode::PseudoVSOXSEG7EI64_V_M2_MF4_MASK,
          9701 => Opcode::PseudoVSOXSEG7EI64_V_M4_M1,
          9702 => Opcode::PseudoVSOXSEG7EI64_V_M4_M1_MASK,
          9703 => Opcode::PseudoVSOXSEG7EI64_V_M4_MF2,
          9704 => Opcode::PseudoVSOXSEG7EI64_V_M4_MF2_MASK,
          9705 => Opcode::PseudoVSOXSEG7EI64_V_M8_M1,
          9706 => Opcode::PseudoVSOXSEG7EI64_V_M8_M1_MASK,
          9707 => Opcode::PseudoVSOXSEG7EI8_V_M1_M1,
          9708 => Opcode::PseudoVSOXSEG7EI8_V_M1_M1_MASK,
          9709 => Opcode::PseudoVSOXSEG7EI8_V_MF2_M1,
          9710 => Opcode::PseudoVSOXSEG7EI8_V_MF2_M1_MASK,
          9711 => Opcode::PseudoVSOXSEG7EI8_V_MF2_MF2,
          9712 => Opcode::PseudoVSOXSEG7EI8_V_MF2_MF2_MASK,
          9713 => Opcode::PseudoVSOXSEG7EI8_V_MF4_M1,
          9714 => Opcode::PseudoVSOXSEG7EI8_V_MF4_M1_MASK,
          9715 => Opcode::PseudoVSOXSEG7EI8_V_MF4_MF2,
          9716 => Opcode::PseudoVSOXSEG7EI8_V_MF4_MF2_MASK,
          9717 => Opcode::PseudoVSOXSEG7EI8_V_MF4_MF4,
          9718 => Opcode::PseudoVSOXSEG7EI8_V_MF4_MF4_MASK,
          9719 => Opcode::PseudoVSOXSEG7EI8_V_MF8_M1,
          9720 => Opcode::PseudoVSOXSEG7EI8_V_MF8_M1_MASK,
          9721 => Opcode::PseudoVSOXSEG7EI8_V_MF8_MF2,
          9722 => Opcode::PseudoVSOXSEG7EI8_V_MF8_MF2_MASK,
          9723 => Opcode::PseudoVSOXSEG7EI8_V_MF8_MF4,
          9724 => Opcode::PseudoVSOXSEG7EI8_V_MF8_MF4_MASK,
          9725 => Opcode::PseudoVSOXSEG7EI8_V_MF8_MF8,
          9726 => Opcode::PseudoVSOXSEG7EI8_V_MF8_MF8_MASK,
          9727 => Opcode::PseudoVSOXSEG8EI16_V_M1_M1,
          9728 => Opcode::PseudoVSOXSEG8EI16_V_M1_M1_MASK,
          9729 => Opcode::PseudoVSOXSEG8EI16_V_M1_MF2,
          9730 => Opcode::PseudoVSOXSEG8EI16_V_M1_MF2_MASK,
          9731 => Opcode::PseudoVSOXSEG8EI16_V_M2_M1,
          9732 => Opcode::PseudoVSOXSEG8EI16_V_M2_M1_MASK,
          9733 => Opcode::PseudoVSOXSEG8EI16_V_MF2_M1,
          9734 => Opcode::PseudoVSOXSEG8EI16_V_MF2_M1_MASK,
          9735 => Opcode::PseudoVSOXSEG8EI16_V_MF2_MF2,
          9736 => Opcode::PseudoVSOXSEG8EI16_V_MF2_MF2_MASK,
          9737 => Opcode::PseudoVSOXSEG8EI16_V_MF2_MF4,
          9738 => Opcode::PseudoVSOXSEG8EI16_V_MF2_MF4_MASK,
          9739 => Opcode::PseudoVSOXSEG8EI16_V_MF4_M1,
          9740 => Opcode::PseudoVSOXSEG8EI16_V_MF4_M1_MASK,
          9741 => Opcode::PseudoVSOXSEG8EI16_V_MF4_MF2,
          9742 => Opcode::PseudoVSOXSEG8EI16_V_MF4_MF2_MASK,
          9743 => Opcode::PseudoVSOXSEG8EI16_V_MF4_MF4,
          9744 => Opcode::PseudoVSOXSEG8EI16_V_MF4_MF4_MASK,
          9745 => Opcode::PseudoVSOXSEG8EI16_V_MF4_MF8,
          9746 => Opcode::PseudoVSOXSEG8EI16_V_MF4_MF8_MASK,
          9747 => Opcode::PseudoVSOXSEG8EI32_V_M1_M1,
          9748 => Opcode::PseudoVSOXSEG8EI32_V_M1_M1_MASK,
          9749 => Opcode::PseudoVSOXSEG8EI32_V_M1_MF2,
          9750 => Opcode::PseudoVSOXSEG8EI32_V_M1_MF2_MASK,
          9751 => Opcode::PseudoVSOXSEG8EI32_V_M1_MF4,
          9752 => Opcode::PseudoVSOXSEG8EI32_V_M1_MF4_MASK,
          9753 => Opcode::PseudoVSOXSEG8EI32_V_M2_M1,
          9754 => Opcode::PseudoVSOXSEG8EI32_V_M2_M1_MASK,
          9755 => Opcode::PseudoVSOXSEG8EI32_V_M2_MF2,
          9756 => Opcode::PseudoVSOXSEG8EI32_V_M2_MF2_MASK,
          9757 => Opcode::PseudoVSOXSEG8EI32_V_M4_M1,
          9758 => Opcode::PseudoVSOXSEG8EI32_V_M4_M1_MASK,
          9759 => Opcode::PseudoVSOXSEG8EI32_V_MF2_M1,
          9760 => Opcode::PseudoVSOXSEG8EI32_V_MF2_M1_MASK,
          9761 => Opcode::PseudoVSOXSEG8EI32_V_MF2_MF2,
          9762 => Opcode::PseudoVSOXSEG8EI32_V_MF2_MF2_MASK,
          9763 => Opcode::PseudoVSOXSEG8EI32_V_MF2_MF4,
          9764 => Opcode::PseudoVSOXSEG8EI32_V_MF2_MF4_MASK,
          9765 => Opcode::PseudoVSOXSEG8EI32_V_MF2_MF8,
          9766 => Opcode::PseudoVSOXSEG8EI32_V_MF2_MF8_MASK,
          9767 => Opcode::PseudoVSOXSEG8EI64_V_M1_M1,
          9768 => Opcode::PseudoVSOXSEG8EI64_V_M1_M1_MASK,
          9769 => Opcode::PseudoVSOXSEG8EI64_V_M1_MF2,
          9770 => Opcode::PseudoVSOXSEG8EI64_V_M1_MF2_MASK,
          9771 => Opcode::PseudoVSOXSEG8EI64_V_M1_MF4,
          9772 => Opcode::PseudoVSOXSEG8EI64_V_M1_MF4_MASK,
          9773 => Opcode::PseudoVSOXSEG8EI64_V_M1_MF8,
          9774 => Opcode::PseudoVSOXSEG8EI64_V_M1_MF8_MASK,
          9775 => Opcode::PseudoVSOXSEG8EI64_V_M2_M1,
          9776 => Opcode::PseudoVSOXSEG8EI64_V_M2_M1_MASK,
          9777 => Opcode::PseudoVSOXSEG8EI64_V_M2_MF2,
          9778 => Opcode::PseudoVSOXSEG8EI64_V_M2_MF2_MASK,
          9779 => Opcode::PseudoVSOXSEG8EI64_V_M2_MF4,
          9780 => Opcode::PseudoVSOXSEG8EI64_V_M2_MF4_MASK,
          9781 => Opcode::PseudoVSOXSEG8EI64_V_M4_M1,
          9782 => Opcode::PseudoVSOXSEG8EI64_V_M4_M1_MASK,
          9783 => Opcode::PseudoVSOXSEG8EI64_V_M4_MF2,
          9784 => Opcode::PseudoVSOXSEG8EI64_V_M4_MF2_MASK,
          9785 => Opcode::PseudoVSOXSEG8EI64_V_M8_M1,
          9786 => Opcode::PseudoVSOXSEG8EI64_V_M8_M1_MASK,
          9787 => Opcode::PseudoVSOXSEG8EI8_V_M1_M1,
          9788 => Opcode::PseudoVSOXSEG8EI8_V_M1_M1_MASK,
          9789 => Opcode::PseudoVSOXSEG8EI8_V_MF2_M1,
          9790 => Opcode::PseudoVSOXSEG8EI8_V_MF2_M1_MASK,
          9791 => Opcode::PseudoVSOXSEG8EI8_V_MF2_MF2,
          9792 => Opcode::PseudoVSOXSEG8EI8_V_MF2_MF2_MASK,
          9793 => Opcode::PseudoVSOXSEG8EI8_V_MF4_M1,
          9794 => Opcode::PseudoVSOXSEG8EI8_V_MF4_M1_MASK,
          9795 => Opcode::PseudoVSOXSEG8EI8_V_MF4_MF2,
          9796 => Opcode::PseudoVSOXSEG8EI8_V_MF4_MF2_MASK,
          9797 => Opcode::PseudoVSOXSEG8EI8_V_MF4_MF4,
          9798 => Opcode::PseudoVSOXSEG8EI8_V_MF4_MF4_MASK,
          9799 => Opcode::PseudoVSOXSEG8EI8_V_MF8_M1,
          9800 => Opcode::PseudoVSOXSEG8EI8_V_MF8_M1_MASK,
          9801 => Opcode::PseudoVSOXSEG8EI8_V_MF8_MF2,
          9802 => Opcode::PseudoVSOXSEG8EI8_V_MF8_MF2_MASK,
          9803 => Opcode::PseudoVSOXSEG8EI8_V_MF8_MF4,
          9804 => Opcode::PseudoVSOXSEG8EI8_V_MF8_MF4_MASK,
          9805 => Opcode::PseudoVSOXSEG8EI8_V_MF8_MF8,
          9806 => Opcode::PseudoVSOXSEG8EI8_V_MF8_MF8_MASK,
          9807 => Opcode::PseudoVSPILL2_M1,
          9808 => Opcode::PseudoVSPILL2_M2,
          9809 => Opcode::PseudoVSPILL2_M4,
          9810 => Opcode::PseudoVSPILL2_MF2,
          9811 => Opcode::PseudoVSPILL2_MF4,
          9812 => Opcode::PseudoVSPILL2_MF8,
          9813 => Opcode::PseudoVSPILL3_M1,
          9814 => Opcode::PseudoVSPILL3_M2,
          9815 => Opcode::PseudoVSPILL3_MF2,
          9816 => Opcode::PseudoVSPILL3_MF4,
          9817 => Opcode::PseudoVSPILL3_MF8,
          9818 => Opcode::PseudoVSPILL4_M1,
          9819 => Opcode::PseudoVSPILL4_M2,
          9820 => Opcode::PseudoVSPILL4_MF2,
          9821 => Opcode::PseudoVSPILL4_MF4,
          9822 => Opcode::PseudoVSPILL4_MF8,
          9823 => Opcode::PseudoVSPILL5_M1,
          9824 => Opcode::PseudoVSPILL5_MF2,
          9825 => Opcode::PseudoVSPILL5_MF4,
          9826 => Opcode::PseudoVSPILL5_MF8,
          9827 => Opcode::PseudoVSPILL6_M1,
          9828 => Opcode::PseudoVSPILL6_MF2,
          9829 => Opcode::PseudoVSPILL6_MF4,
          9830 => Opcode::PseudoVSPILL6_MF8,
          9831 => Opcode::PseudoVSPILL7_M1,
          9832 => Opcode::PseudoVSPILL7_MF2,
          9833 => Opcode::PseudoVSPILL7_MF4,
          9834 => Opcode::PseudoVSPILL7_MF8,
          9835 => Opcode::PseudoVSPILL8_M1,
          9836 => Opcode::PseudoVSPILL8_MF2,
          9837 => Opcode::PseudoVSPILL8_MF4,
          9838 => Opcode::PseudoVSPILL8_MF8,
          9839 => Opcode::PseudoVSRA_VI_M1,
          9840 => Opcode::PseudoVSRA_VI_M1_MASK,
          9841 => Opcode::PseudoVSRA_VI_M2,
          9842 => Opcode::PseudoVSRA_VI_M2_MASK,
          9843 => Opcode::PseudoVSRA_VI_M4,
          9844 => Opcode::PseudoVSRA_VI_M4_MASK,
          9845 => Opcode::PseudoVSRA_VI_M8,
          9846 => Opcode::PseudoVSRA_VI_M8_MASK,
          9847 => Opcode::PseudoVSRA_VI_MF2,
          9848 => Opcode::PseudoVSRA_VI_MF2_MASK,
          9849 => Opcode::PseudoVSRA_VI_MF4,
          9850 => Opcode::PseudoVSRA_VI_MF4_MASK,
          9851 => Opcode::PseudoVSRA_VI_MF8,
          9852 => Opcode::PseudoVSRA_VI_MF8_MASK,
          9853 => Opcode::PseudoVSRA_VV_M1,
          9854 => Opcode::PseudoVSRA_VV_M1_MASK,
          9855 => Opcode::PseudoVSRA_VV_M2,
          9856 => Opcode::PseudoVSRA_VV_M2_MASK,
          9857 => Opcode::PseudoVSRA_VV_M4,
          9858 => Opcode::PseudoVSRA_VV_M4_MASK,
          9859 => Opcode::PseudoVSRA_VV_M8,
          9860 => Opcode::PseudoVSRA_VV_M8_MASK,
          9861 => Opcode::PseudoVSRA_VV_MF2,
          9862 => Opcode::PseudoVSRA_VV_MF2_MASK,
          9863 => Opcode::PseudoVSRA_VV_MF4,
          9864 => Opcode::PseudoVSRA_VV_MF4_MASK,
          9865 => Opcode::PseudoVSRA_VV_MF8,
          9866 => Opcode::PseudoVSRA_VV_MF8_MASK,
          9867 => Opcode::PseudoVSRA_VX_M1,
          9868 => Opcode::PseudoVSRA_VX_M1_MASK,
          9869 => Opcode::PseudoVSRA_VX_M2,
          9870 => Opcode::PseudoVSRA_VX_M2_MASK,
          9871 => Opcode::PseudoVSRA_VX_M4,
          9872 => Opcode::PseudoVSRA_VX_M4_MASK,
          9873 => Opcode::PseudoVSRA_VX_M8,
          9874 => Opcode::PseudoVSRA_VX_M8_MASK,
          9875 => Opcode::PseudoVSRA_VX_MF2,
          9876 => Opcode::PseudoVSRA_VX_MF2_MASK,
          9877 => Opcode::PseudoVSRA_VX_MF4,
          9878 => Opcode::PseudoVSRA_VX_MF4_MASK,
          9879 => Opcode::PseudoVSRA_VX_MF8,
          9880 => Opcode::PseudoVSRA_VX_MF8_MASK,
          9881 => Opcode::PseudoVSRL_VI_M1,
          9882 => Opcode::PseudoVSRL_VI_M1_MASK,
          9883 => Opcode::PseudoVSRL_VI_M2,
          9884 => Opcode::PseudoVSRL_VI_M2_MASK,
          9885 => Opcode::PseudoVSRL_VI_M4,
          9886 => Opcode::PseudoVSRL_VI_M4_MASK,
          9887 => Opcode::PseudoVSRL_VI_M8,
          9888 => Opcode::PseudoVSRL_VI_M8_MASK,
          9889 => Opcode::PseudoVSRL_VI_MF2,
          9890 => Opcode::PseudoVSRL_VI_MF2_MASK,
          9891 => Opcode::PseudoVSRL_VI_MF4,
          9892 => Opcode::PseudoVSRL_VI_MF4_MASK,
          9893 => Opcode::PseudoVSRL_VI_MF8,
          9894 => Opcode::PseudoVSRL_VI_MF8_MASK,
          9895 => Opcode::PseudoVSRL_VV_M1,
          9896 => Opcode::PseudoVSRL_VV_M1_MASK,
          9897 => Opcode::PseudoVSRL_VV_M2,
          9898 => Opcode::PseudoVSRL_VV_M2_MASK,
          9899 => Opcode::PseudoVSRL_VV_M4,
          9900 => Opcode::PseudoVSRL_VV_M4_MASK,
          9901 => Opcode::PseudoVSRL_VV_M8,
          9902 => Opcode::PseudoVSRL_VV_M8_MASK,
          9903 => Opcode::PseudoVSRL_VV_MF2,
          9904 => Opcode::PseudoVSRL_VV_MF2_MASK,
          9905 => Opcode::PseudoVSRL_VV_MF4,
          9906 => Opcode::PseudoVSRL_VV_MF4_MASK,
          9907 => Opcode::PseudoVSRL_VV_MF8,
          9908 => Opcode::PseudoVSRL_VV_MF8_MASK,
          9909 => Opcode::PseudoVSRL_VX_M1,
          9910 => Opcode::PseudoVSRL_VX_M1_MASK,
          9911 => Opcode::PseudoVSRL_VX_M2,
          9912 => Opcode::PseudoVSRL_VX_M2_MASK,
          9913 => Opcode::PseudoVSRL_VX_M4,
          9914 => Opcode::PseudoVSRL_VX_M4_MASK,
          9915 => Opcode::PseudoVSRL_VX_M8,
          9916 => Opcode::PseudoVSRL_VX_M8_MASK,
          9917 => Opcode::PseudoVSRL_VX_MF2,
          9918 => Opcode::PseudoVSRL_VX_MF2_MASK,
          9919 => Opcode::PseudoVSRL_VX_MF4,
          9920 => Opcode::PseudoVSRL_VX_MF4_MASK,
          9921 => Opcode::PseudoVSRL_VX_MF8,
          9922 => Opcode::PseudoVSRL_VX_MF8_MASK,
          9923 => Opcode::PseudoVSSE16_V_M1,
          9924 => Opcode::PseudoVSSE16_V_M1_MASK,
          9925 => Opcode::PseudoVSSE16_V_M2,
          9926 => Opcode::PseudoVSSE16_V_M2_MASK,
          9927 => Opcode::PseudoVSSE16_V_M4,
          9928 => Opcode::PseudoVSSE16_V_M4_MASK,
          9929 => Opcode::PseudoVSSE16_V_M8,
          9930 => Opcode::PseudoVSSE16_V_M8_MASK,
          9931 => Opcode::PseudoVSSE16_V_MF2,
          9932 => Opcode::PseudoVSSE16_V_MF2_MASK,
          9933 => Opcode::PseudoVSSE16_V_MF4,
          9934 => Opcode::PseudoVSSE16_V_MF4_MASK,
          9935 => Opcode::PseudoVSSE32_V_M1,
          9936 => Opcode::PseudoVSSE32_V_M1_MASK,
          9937 => Opcode::PseudoVSSE32_V_M2,
          9938 => Opcode::PseudoVSSE32_V_M2_MASK,
          9939 => Opcode::PseudoVSSE32_V_M4,
          9940 => Opcode::PseudoVSSE32_V_M4_MASK,
          9941 => Opcode::PseudoVSSE32_V_M8,
          9942 => Opcode::PseudoVSSE32_V_M8_MASK,
          9943 => Opcode::PseudoVSSE32_V_MF2,
          9944 => Opcode::PseudoVSSE32_V_MF2_MASK,
          9945 => Opcode::PseudoVSSE64_V_M1,
          9946 => Opcode::PseudoVSSE64_V_M1_MASK,
          9947 => Opcode::PseudoVSSE64_V_M2,
          9948 => Opcode::PseudoVSSE64_V_M2_MASK,
          9949 => Opcode::PseudoVSSE64_V_M4,
          9950 => Opcode::PseudoVSSE64_V_M4_MASK,
          9951 => Opcode::PseudoVSSE64_V_M8,
          9952 => Opcode::PseudoVSSE64_V_M8_MASK,
          9953 => Opcode::PseudoVSSE8_V_M1,
          9954 => Opcode::PseudoVSSE8_V_M1_MASK,
          9955 => Opcode::PseudoVSSE8_V_M2,
          9956 => Opcode::PseudoVSSE8_V_M2_MASK,
          9957 => Opcode::PseudoVSSE8_V_M4,
          9958 => Opcode::PseudoVSSE8_V_M4_MASK,
          9959 => Opcode::PseudoVSSE8_V_M8,
          9960 => Opcode::PseudoVSSE8_V_M8_MASK,
          9961 => Opcode::PseudoVSSE8_V_MF2,
          9962 => Opcode::PseudoVSSE8_V_MF2_MASK,
          9963 => Opcode::PseudoVSSE8_V_MF4,
          9964 => Opcode::PseudoVSSE8_V_MF4_MASK,
          9965 => Opcode::PseudoVSSE8_V_MF8,
          9966 => Opcode::PseudoVSSE8_V_MF8_MASK,
          9967 => Opcode::PseudoVSSEG2E16_V_M1,
          9968 => Opcode::PseudoVSSEG2E16_V_M1_MASK,
          9969 => Opcode::PseudoVSSEG2E16_V_M2,
          9970 => Opcode::PseudoVSSEG2E16_V_M2_MASK,
          9971 => Opcode::PseudoVSSEG2E16_V_M4,
          9972 => Opcode::PseudoVSSEG2E16_V_M4_MASK,
          9973 => Opcode::PseudoVSSEG2E16_V_MF2,
          9974 => Opcode::PseudoVSSEG2E16_V_MF2_MASK,
          9975 => Opcode::PseudoVSSEG2E16_V_MF4,
          9976 => Opcode::PseudoVSSEG2E16_V_MF4_MASK,
          9977 => Opcode::PseudoVSSEG2E32_V_M1,
          9978 => Opcode::PseudoVSSEG2E32_V_M1_MASK,
          9979 => Opcode::PseudoVSSEG2E32_V_M2,
          9980 => Opcode::PseudoVSSEG2E32_V_M2_MASK,
          9981 => Opcode::PseudoVSSEG2E32_V_M4,
          9982 => Opcode::PseudoVSSEG2E32_V_M4_MASK,
          9983 => Opcode::PseudoVSSEG2E32_V_MF2,
          9984 => Opcode::PseudoVSSEG2E32_V_MF2_MASK,
          9985 => Opcode::PseudoVSSEG2E64_V_M1,
          9986 => Opcode::PseudoVSSEG2E64_V_M1_MASK,
          9987 => Opcode::PseudoVSSEG2E64_V_M2,
          9988 => Opcode::PseudoVSSEG2E64_V_M2_MASK,
          9989 => Opcode::PseudoVSSEG2E64_V_M4,
          9990 => Opcode::PseudoVSSEG2E64_V_M4_MASK,
          9991 => Opcode::PseudoVSSEG2E8_V_M1,
          9992 => Opcode::PseudoVSSEG2E8_V_M1_MASK,
          9993 => Opcode::PseudoVSSEG2E8_V_M2,
          9994 => Opcode::PseudoVSSEG2E8_V_M2_MASK,
          9995 => Opcode::PseudoVSSEG2E8_V_M4,
          9996 => Opcode::PseudoVSSEG2E8_V_M4_MASK,
          9997 => Opcode::PseudoVSSEG2E8_V_MF2,
          9998 => Opcode::PseudoVSSEG2E8_V_MF2_MASK,
          9999 => Opcode::PseudoVSSEG2E8_V_MF4,
          10000 => Opcode::PseudoVSSEG2E8_V_MF4_MASK,
          10001 => Opcode::PseudoVSSEG2E8_V_MF8,
          10002 => Opcode::PseudoVSSEG2E8_V_MF8_MASK,
          10003 => Opcode::PseudoVSSEG3E16_V_M1,
          10004 => Opcode::PseudoVSSEG3E16_V_M1_MASK,
          10005 => Opcode::PseudoVSSEG3E16_V_M2,
          10006 => Opcode::PseudoVSSEG3E16_V_M2_MASK,
          10007 => Opcode::PseudoVSSEG3E16_V_MF2,
          10008 => Opcode::PseudoVSSEG3E16_V_MF2_MASK,
          10009 => Opcode::PseudoVSSEG3E16_V_MF4,
          10010 => Opcode::PseudoVSSEG3E16_V_MF4_MASK,
          10011 => Opcode::PseudoVSSEG3E32_V_M1,
          10012 => Opcode::PseudoVSSEG3E32_V_M1_MASK,
          10013 => Opcode::PseudoVSSEG3E32_V_M2,
          10014 => Opcode::PseudoVSSEG3E32_V_M2_MASK,
          10015 => Opcode::PseudoVSSEG3E32_V_MF2,
          10016 => Opcode::PseudoVSSEG3E32_V_MF2_MASK,
          10017 => Opcode::PseudoVSSEG3E64_V_M1,
          10018 => Opcode::PseudoVSSEG3E64_V_M1_MASK,
          10019 => Opcode::PseudoVSSEG3E64_V_M2,
          10020 => Opcode::PseudoVSSEG3E64_V_M2_MASK,
          10021 => Opcode::PseudoVSSEG3E8_V_M1,
          10022 => Opcode::PseudoVSSEG3E8_V_M1_MASK,
          10023 => Opcode::PseudoVSSEG3E8_V_M2,
          10024 => Opcode::PseudoVSSEG3E8_V_M2_MASK,
          10025 => Opcode::PseudoVSSEG3E8_V_MF2,
          10026 => Opcode::PseudoVSSEG3E8_V_MF2_MASK,
          10027 => Opcode::PseudoVSSEG3E8_V_MF4,
          10028 => Opcode::PseudoVSSEG3E8_V_MF4_MASK,
          10029 => Opcode::PseudoVSSEG3E8_V_MF8,
          10030 => Opcode::PseudoVSSEG3E8_V_MF8_MASK,
          10031 => Opcode::PseudoVSSEG4E16_V_M1,
          10032 => Opcode::PseudoVSSEG4E16_V_M1_MASK,
          10033 => Opcode::PseudoVSSEG4E16_V_M2,
          10034 => Opcode::PseudoVSSEG4E16_V_M2_MASK,
          10035 => Opcode::PseudoVSSEG4E16_V_MF2,
          10036 => Opcode::PseudoVSSEG4E16_V_MF2_MASK,
          10037 => Opcode::PseudoVSSEG4E16_V_MF4,
          10038 => Opcode::PseudoVSSEG4E16_V_MF4_MASK,
          10039 => Opcode::PseudoVSSEG4E32_V_M1,
          10040 => Opcode::PseudoVSSEG4E32_V_M1_MASK,
          10041 => Opcode::PseudoVSSEG4E32_V_M2,
          10042 => Opcode::PseudoVSSEG4E32_V_M2_MASK,
          10043 => Opcode::PseudoVSSEG4E32_V_MF2,
          10044 => Opcode::PseudoVSSEG4E32_V_MF2_MASK,
          10045 => Opcode::PseudoVSSEG4E64_V_M1,
          10046 => Opcode::PseudoVSSEG4E64_V_M1_MASK,
          10047 => Opcode::PseudoVSSEG4E64_V_M2,
          10048 => Opcode::PseudoVSSEG4E64_V_M2_MASK,
          10049 => Opcode::PseudoVSSEG4E8_V_M1,
          10050 => Opcode::PseudoVSSEG4E8_V_M1_MASK,
          10051 => Opcode::PseudoVSSEG4E8_V_M2,
          10052 => Opcode::PseudoVSSEG4E8_V_M2_MASK,
          10053 => Opcode::PseudoVSSEG4E8_V_MF2,
          10054 => Opcode::PseudoVSSEG4E8_V_MF2_MASK,
          10055 => Opcode::PseudoVSSEG4E8_V_MF4,
          10056 => Opcode::PseudoVSSEG4E8_V_MF4_MASK,
          10057 => Opcode::PseudoVSSEG4E8_V_MF8,
          10058 => Opcode::PseudoVSSEG4E8_V_MF8_MASK,
          10059 => Opcode::PseudoVSSEG5E16_V_M1,
          10060 => Opcode::PseudoVSSEG5E16_V_M1_MASK,
          10061 => Opcode::PseudoVSSEG5E16_V_MF2,
          10062 => Opcode::PseudoVSSEG5E16_V_MF2_MASK,
          10063 => Opcode::PseudoVSSEG5E16_V_MF4,
          10064 => Opcode::PseudoVSSEG5E16_V_MF4_MASK,
          10065 => Opcode::PseudoVSSEG5E32_V_M1,
          10066 => Opcode::PseudoVSSEG5E32_V_M1_MASK,
          10067 => Opcode::PseudoVSSEG5E32_V_MF2,
          10068 => Opcode::PseudoVSSEG5E32_V_MF2_MASK,
          10069 => Opcode::PseudoVSSEG5E64_V_M1,
          10070 => Opcode::PseudoVSSEG5E64_V_M1_MASK,
          10071 => Opcode::PseudoVSSEG5E8_V_M1,
          10072 => Opcode::PseudoVSSEG5E8_V_M1_MASK,
          10073 => Opcode::PseudoVSSEG5E8_V_MF2,
          10074 => Opcode::PseudoVSSEG5E8_V_MF2_MASK,
          10075 => Opcode::PseudoVSSEG5E8_V_MF4,
          10076 => Opcode::PseudoVSSEG5E8_V_MF4_MASK,
          10077 => Opcode::PseudoVSSEG5E8_V_MF8,
          10078 => Opcode::PseudoVSSEG5E8_V_MF8_MASK,
          10079 => Opcode::PseudoVSSEG6E16_V_M1,
          10080 => Opcode::PseudoVSSEG6E16_V_M1_MASK,
          10081 => Opcode::PseudoVSSEG6E16_V_MF2,
          10082 => Opcode::PseudoVSSEG6E16_V_MF2_MASK,
          10083 => Opcode::PseudoVSSEG6E16_V_MF4,
          10084 => Opcode::PseudoVSSEG6E16_V_MF4_MASK,
          10085 => Opcode::PseudoVSSEG6E32_V_M1,
          10086 => Opcode::PseudoVSSEG6E32_V_M1_MASK,
          10087 => Opcode::PseudoVSSEG6E32_V_MF2,
          10088 => Opcode::PseudoVSSEG6E32_V_MF2_MASK,
          10089 => Opcode::PseudoVSSEG6E64_V_M1,
          10090 => Opcode::PseudoVSSEG6E64_V_M1_MASK,
          10091 => Opcode::PseudoVSSEG6E8_V_M1,
          10092 => Opcode::PseudoVSSEG6E8_V_M1_MASK,
          10093 => Opcode::PseudoVSSEG6E8_V_MF2,
          10094 => Opcode::PseudoVSSEG6E8_V_MF2_MASK,
          10095 => Opcode::PseudoVSSEG6E8_V_MF4,
          10096 => Opcode::PseudoVSSEG6E8_V_MF4_MASK,
          10097 => Opcode::PseudoVSSEG6E8_V_MF8,
          10098 => Opcode::PseudoVSSEG6E8_V_MF8_MASK,
          10099 => Opcode::PseudoVSSEG7E16_V_M1,
          10100 => Opcode::PseudoVSSEG7E16_V_M1_MASK,
          10101 => Opcode::PseudoVSSEG7E16_V_MF2,
          10102 => Opcode::PseudoVSSEG7E16_V_MF2_MASK,
          10103 => Opcode::PseudoVSSEG7E16_V_MF4,
          10104 => Opcode::PseudoVSSEG7E16_V_MF4_MASK,
          10105 => Opcode::PseudoVSSEG7E32_V_M1,
          10106 => Opcode::PseudoVSSEG7E32_V_M1_MASK,
          10107 => Opcode::PseudoVSSEG7E32_V_MF2,
          10108 => Opcode::PseudoVSSEG7E32_V_MF2_MASK,
          10109 => Opcode::PseudoVSSEG7E64_V_M1,
          10110 => Opcode::PseudoVSSEG7E64_V_M1_MASK,
          10111 => Opcode::PseudoVSSEG7E8_V_M1,
          10112 => Opcode::PseudoVSSEG7E8_V_M1_MASK,
          10113 => Opcode::PseudoVSSEG7E8_V_MF2,
          10114 => Opcode::PseudoVSSEG7E8_V_MF2_MASK,
          10115 => Opcode::PseudoVSSEG7E8_V_MF4,
          10116 => Opcode::PseudoVSSEG7E8_V_MF4_MASK,
          10117 => Opcode::PseudoVSSEG7E8_V_MF8,
          10118 => Opcode::PseudoVSSEG7E8_V_MF8_MASK,
          10119 => Opcode::PseudoVSSEG8E16_V_M1,
          10120 => Opcode::PseudoVSSEG8E16_V_M1_MASK,
          10121 => Opcode::PseudoVSSEG8E16_V_MF2,
          10122 => Opcode::PseudoVSSEG8E16_V_MF2_MASK,
          10123 => Opcode::PseudoVSSEG8E16_V_MF4,
          10124 => Opcode::PseudoVSSEG8E16_V_MF4_MASK,
          10125 => Opcode::PseudoVSSEG8E32_V_M1,
          10126 => Opcode::PseudoVSSEG8E32_V_M1_MASK,
          10127 => Opcode::PseudoVSSEG8E32_V_MF2,
          10128 => Opcode::PseudoVSSEG8E32_V_MF2_MASK,
          10129 => Opcode::PseudoVSSEG8E64_V_M1,
          10130 => Opcode::PseudoVSSEG8E64_V_M1_MASK,
          10131 => Opcode::PseudoVSSEG8E8_V_M1,
          10132 => Opcode::PseudoVSSEG8E8_V_M1_MASK,
          10133 => Opcode::PseudoVSSEG8E8_V_MF2,
          10134 => Opcode::PseudoVSSEG8E8_V_MF2_MASK,
          10135 => Opcode::PseudoVSSEG8E8_V_MF4,
          10136 => Opcode::PseudoVSSEG8E8_V_MF4_MASK,
          10137 => Opcode::PseudoVSSEG8E8_V_MF8,
          10138 => Opcode::PseudoVSSEG8E8_V_MF8_MASK,
          10139 => Opcode::PseudoVSSRA_VI_M1,
          10140 => Opcode::PseudoVSSRA_VI_M1_MASK,
          10141 => Opcode::PseudoVSSRA_VI_M2,
          10142 => Opcode::PseudoVSSRA_VI_M2_MASK,
          10143 => Opcode::PseudoVSSRA_VI_M4,
          10144 => Opcode::PseudoVSSRA_VI_M4_MASK,
          10145 => Opcode::PseudoVSSRA_VI_M8,
          10146 => Opcode::PseudoVSSRA_VI_M8_MASK,
          10147 => Opcode::PseudoVSSRA_VI_MF2,
          10148 => Opcode::PseudoVSSRA_VI_MF2_MASK,
          10149 => Opcode::PseudoVSSRA_VI_MF4,
          10150 => Opcode::PseudoVSSRA_VI_MF4_MASK,
          10151 => Opcode::PseudoVSSRA_VI_MF8,
          10152 => Opcode::PseudoVSSRA_VI_MF8_MASK,
          10153 => Opcode::PseudoVSSRA_VV_M1,
          10154 => Opcode::PseudoVSSRA_VV_M1_MASK,
          10155 => Opcode::PseudoVSSRA_VV_M2,
          10156 => Opcode::PseudoVSSRA_VV_M2_MASK,
          10157 => Opcode::PseudoVSSRA_VV_M4,
          10158 => Opcode::PseudoVSSRA_VV_M4_MASK,
          10159 => Opcode::PseudoVSSRA_VV_M8,
          10160 => Opcode::PseudoVSSRA_VV_M8_MASK,
          10161 => Opcode::PseudoVSSRA_VV_MF2,
          10162 => Opcode::PseudoVSSRA_VV_MF2_MASK,
          10163 => Opcode::PseudoVSSRA_VV_MF4,
          10164 => Opcode::PseudoVSSRA_VV_MF4_MASK,
          10165 => Opcode::PseudoVSSRA_VV_MF8,
          10166 => Opcode::PseudoVSSRA_VV_MF8_MASK,
          10167 => Opcode::PseudoVSSRA_VX_M1,
          10168 => Opcode::PseudoVSSRA_VX_M1_MASK,
          10169 => Opcode::PseudoVSSRA_VX_M2,
          10170 => Opcode::PseudoVSSRA_VX_M2_MASK,
          10171 => Opcode::PseudoVSSRA_VX_M4,
          10172 => Opcode::PseudoVSSRA_VX_M4_MASK,
          10173 => Opcode::PseudoVSSRA_VX_M8,
          10174 => Opcode::PseudoVSSRA_VX_M8_MASK,
          10175 => Opcode::PseudoVSSRA_VX_MF2,
          10176 => Opcode::PseudoVSSRA_VX_MF2_MASK,
          10177 => Opcode::PseudoVSSRA_VX_MF4,
          10178 => Opcode::PseudoVSSRA_VX_MF4_MASK,
          10179 => Opcode::PseudoVSSRA_VX_MF8,
          10180 => Opcode::PseudoVSSRA_VX_MF8_MASK,
          10181 => Opcode::PseudoVSSRL_VI_M1,
          10182 => Opcode::PseudoVSSRL_VI_M1_MASK,
          10183 => Opcode::PseudoVSSRL_VI_M2,
          10184 => Opcode::PseudoVSSRL_VI_M2_MASK,
          10185 => Opcode::PseudoVSSRL_VI_M4,
          10186 => Opcode::PseudoVSSRL_VI_M4_MASK,
          10187 => Opcode::PseudoVSSRL_VI_M8,
          10188 => Opcode::PseudoVSSRL_VI_M8_MASK,
          10189 => Opcode::PseudoVSSRL_VI_MF2,
          10190 => Opcode::PseudoVSSRL_VI_MF2_MASK,
          10191 => Opcode::PseudoVSSRL_VI_MF4,
          10192 => Opcode::PseudoVSSRL_VI_MF4_MASK,
          10193 => Opcode::PseudoVSSRL_VI_MF8,
          10194 => Opcode::PseudoVSSRL_VI_MF8_MASK,
          10195 => Opcode::PseudoVSSRL_VV_M1,
          10196 => Opcode::PseudoVSSRL_VV_M1_MASK,
          10197 => Opcode::PseudoVSSRL_VV_M2,
          10198 => Opcode::PseudoVSSRL_VV_M2_MASK,
          10199 => Opcode::PseudoVSSRL_VV_M4,
          10200 => Opcode::PseudoVSSRL_VV_M4_MASK,
          10201 => Opcode::PseudoVSSRL_VV_M8,
          10202 => Opcode::PseudoVSSRL_VV_M8_MASK,
          10203 => Opcode::PseudoVSSRL_VV_MF2,
          10204 => Opcode::PseudoVSSRL_VV_MF2_MASK,
          10205 => Opcode::PseudoVSSRL_VV_MF4,
          10206 => Opcode::PseudoVSSRL_VV_MF4_MASK,
          10207 => Opcode::PseudoVSSRL_VV_MF8,
          10208 => Opcode::PseudoVSSRL_VV_MF8_MASK,
          10209 => Opcode::PseudoVSSRL_VX_M1,
          10210 => Opcode::PseudoVSSRL_VX_M1_MASK,
          10211 => Opcode::PseudoVSSRL_VX_M2,
          10212 => Opcode::PseudoVSSRL_VX_M2_MASK,
          10213 => Opcode::PseudoVSSRL_VX_M4,
          10214 => Opcode::PseudoVSSRL_VX_M4_MASK,
          10215 => Opcode::PseudoVSSRL_VX_M8,
          10216 => Opcode::PseudoVSSRL_VX_M8_MASK,
          10217 => Opcode::PseudoVSSRL_VX_MF2,
          10218 => Opcode::PseudoVSSRL_VX_MF2_MASK,
          10219 => Opcode::PseudoVSSRL_VX_MF4,
          10220 => Opcode::PseudoVSSRL_VX_MF4_MASK,
          10221 => Opcode::PseudoVSSRL_VX_MF8,
          10222 => Opcode::PseudoVSSRL_VX_MF8_MASK,
          10223 => Opcode::PseudoVSSSEG2E16_V_M1,
          10224 => Opcode::PseudoVSSSEG2E16_V_M1_MASK,
          10225 => Opcode::PseudoVSSSEG2E16_V_M2,
          10226 => Opcode::PseudoVSSSEG2E16_V_M2_MASK,
          10227 => Opcode::PseudoVSSSEG2E16_V_M4,
          10228 => Opcode::PseudoVSSSEG2E16_V_M4_MASK,
          10229 => Opcode::PseudoVSSSEG2E16_V_MF2,
          10230 => Opcode::PseudoVSSSEG2E16_V_MF2_MASK,
          10231 => Opcode::PseudoVSSSEG2E16_V_MF4,
          10232 => Opcode::PseudoVSSSEG2E16_V_MF4_MASK,
          10233 => Opcode::PseudoVSSSEG2E32_V_M1,
          10234 => Opcode::PseudoVSSSEG2E32_V_M1_MASK,
          10235 => Opcode::PseudoVSSSEG2E32_V_M2,
          10236 => Opcode::PseudoVSSSEG2E32_V_M2_MASK,
          10237 => Opcode::PseudoVSSSEG2E32_V_M4,
          10238 => Opcode::PseudoVSSSEG2E32_V_M4_MASK,
          10239 => Opcode::PseudoVSSSEG2E32_V_MF2,
          10240 => Opcode::PseudoVSSSEG2E32_V_MF2_MASK,
          10241 => Opcode::PseudoVSSSEG2E64_V_M1,
          10242 => Opcode::PseudoVSSSEG2E64_V_M1_MASK,
          10243 => Opcode::PseudoVSSSEG2E64_V_M2,
          10244 => Opcode::PseudoVSSSEG2E64_V_M2_MASK,
          10245 => Opcode::PseudoVSSSEG2E64_V_M4,
          10246 => Opcode::PseudoVSSSEG2E64_V_M4_MASK,
          10247 => Opcode::PseudoVSSSEG2E8_V_M1,
          10248 => Opcode::PseudoVSSSEG2E8_V_M1_MASK,
          10249 => Opcode::PseudoVSSSEG2E8_V_M2,
          10250 => Opcode::PseudoVSSSEG2E8_V_M2_MASK,
          10251 => Opcode::PseudoVSSSEG2E8_V_M4,
          10252 => Opcode::PseudoVSSSEG2E8_V_M4_MASK,
          10253 => Opcode::PseudoVSSSEG2E8_V_MF2,
          10254 => Opcode::PseudoVSSSEG2E8_V_MF2_MASK,
          10255 => Opcode::PseudoVSSSEG2E8_V_MF4,
          10256 => Opcode::PseudoVSSSEG2E8_V_MF4_MASK,
          10257 => Opcode::PseudoVSSSEG2E8_V_MF8,
          10258 => Opcode::PseudoVSSSEG2E8_V_MF8_MASK,
          10259 => Opcode::PseudoVSSSEG3E16_V_M1,
          10260 => Opcode::PseudoVSSSEG3E16_V_M1_MASK,
          10261 => Opcode::PseudoVSSSEG3E16_V_M2,
          10262 => Opcode::PseudoVSSSEG3E16_V_M2_MASK,
          10263 => Opcode::PseudoVSSSEG3E16_V_MF2,
          10264 => Opcode::PseudoVSSSEG3E16_V_MF2_MASK,
          10265 => Opcode::PseudoVSSSEG3E16_V_MF4,
          10266 => Opcode::PseudoVSSSEG3E16_V_MF4_MASK,
          10267 => Opcode::PseudoVSSSEG3E32_V_M1,
          10268 => Opcode::PseudoVSSSEG3E32_V_M1_MASK,
          10269 => Opcode::PseudoVSSSEG3E32_V_M2,
          10270 => Opcode::PseudoVSSSEG3E32_V_M2_MASK,
          10271 => Opcode::PseudoVSSSEG3E32_V_MF2,
          10272 => Opcode::PseudoVSSSEG3E32_V_MF2_MASK,
          10273 => Opcode::PseudoVSSSEG3E64_V_M1,
          10274 => Opcode::PseudoVSSSEG3E64_V_M1_MASK,
          10275 => Opcode::PseudoVSSSEG3E64_V_M2,
          10276 => Opcode::PseudoVSSSEG3E64_V_M2_MASK,
          10277 => Opcode::PseudoVSSSEG3E8_V_M1,
          10278 => Opcode::PseudoVSSSEG3E8_V_M1_MASK,
          10279 => Opcode::PseudoVSSSEG3E8_V_M2,
          10280 => Opcode::PseudoVSSSEG3E8_V_M2_MASK,
          10281 => Opcode::PseudoVSSSEG3E8_V_MF2,
          10282 => Opcode::PseudoVSSSEG3E8_V_MF2_MASK,
          10283 => Opcode::PseudoVSSSEG3E8_V_MF4,
          10284 => Opcode::PseudoVSSSEG3E8_V_MF4_MASK,
          10285 => Opcode::PseudoVSSSEG3E8_V_MF8,
          10286 => Opcode::PseudoVSSSEG3E8_V_MF8_MASK,
          10287 => Opcode::PseudoVSSSEG4E16_V_M1,
          10288 => Opcode::PseudoVSSSEG4E16_V_M1_MASK,
          10289 => Opcode::PseudoVSSSEG4E16_V_M2,
          10290 => Opcode::PseudoVSSSEG4E16_V_M2_MASK,
          10291 => Opcode::PseudoVSSSEG4E16_V_MF2,
          10292 => Opcode::PseudoVSSSEG4E16_V_MF2_MASK,
          10293 => Opcode::PseudoVSSSEG4E16_V_MF4,
          10294 => Opcode::PseudoVSSSEG4E16_V_MF4_MASK,
          10295 => Opcode::PseudoVSSSEG4E32_V_M1,
          10296 => Opcode::PseudoVSSSEG4E32_V_M1_MASK,
          10297 => Opcode::PseudoVSSSEG4E32_V_M2,
          10298 => Opcode::PseudoVSSSEG4E32_V_M2_MASK,
          10299 => Opcode::PseudoVSSSEG4E32_V_MF2,
          10300 => Opcode::PseudoVSSSEG4E32_V_MF2_MASK,
          10301 => Opcode::PseudoVSSSEG4E64_V_M1,
          10302 => Opcode::PseudoVSSSEG4E64_V_M1_MASK,
          10303 => Opcode::PseudoVSSSEG4E64_V_M2,
          10304 => Opcode::PseudoVSSSEG4E64_V_M2_MASK,
          10305 => Opcode::PseudoVSSSEG4E8_V_M1,
          10306 => Opcode::PseudoVSSSEG4E8_V_M1_MASK,
          10307 => Opcode::PseudoVSSSEG4E8_V_M2,
          10308 => Opcode::PseudoVSSSEG4E8_V_M2_MASK,
          10309 => Opcode::PseudoVSSSEG4E8_V_MF2,
          10310 => Opcode::PseudoVSSSEG4E8_V_MF2_MASK,
          10311 => Opcode::PseudoVSSSEG4E8_V_MF4,
          10312 => Opcode::PseudoVSSSEG4E8_V_MF4_MASK,
          10313 => Opcode::PseudoVSSSEG4E8_V_MF8,
          10314 => Opcode::PseudoVSSSEG4E8_V_MF8_MASK,
          10315 => Opcode::PseudoVSSSEG5E16_V_M1,
          10316 => Opcode::PseudoVSSSEG5E16_V_M1_MASK,
          10317 => Opcode::PseudoVSSSEG5E16_V_MF2,
          10318 => Opcode::PseudoVSSSEG5E16_V_MF2_MASK,
          10319 => Opcode::PseudoVSSSEG5E16_V_MF4,
          10320 => Opcode::PseudoVSSSEG5E16_V_MF4_MASK,
          10321 => Opcode::PseudoVSSSEG5E32_V_M1,
          10322 => Opcode::PseudoVSSSEG5E32_V_M1_MASK,
          10323 => Opcode::PseudoVSSSEG5E32_V_MF2,
          10324 => Opcode::PseudoVSSSEG5E32_V_MF2_MASK,
          10325 => Opcode::PseudoVSSSEG5E64_V_M1,
          10326 => Opcode::PseudoVSSSEG5E64_V_M1_MASK,
          10327 => Opcode::PseudoVSSSEG5E8_V_M1,
          10328 => Opcode::PseudoVSSSEG5E8_V_M1_MASK,
          10329 => Opcode::PseudoVSSSEG5E8_V_MF2,
          10330 => Opcode::PseudoVSSSEG5E8_V_MF2_MASK,
          10331 => Opcode::PseudoVSSSEG5E8_V_MF4,
          10332 => Opcode::PseudoVSSSEG5E8_V_MF4_MASK,
          10333 => Opcode::PseudoVSSSEG5E8_V_MF8,
          10334 => Opcode::PseudoVSSSEG5E8_V_MF8_MASK,
          10335 => Opcode::PseudoVSSSEG6E16_V_M1,
          10336 => Opcode::PseudoVSSSEG6E16_V_M1_MASK,
          10337 => Opcode::PseudoVSSSEG6E16_V_MF2,
          10338 => Opcode::PseudoVSSSEG6E16_V_MF2_MASK,
          10339 => Opcode::PseudoVSSSEG6E16_V_MF4,
          10340 => Opcode::PseudoVSSSEG6E16_V_MF4_MASK,
          10341 => Opcode::PseudoVSSSEG6E32_V_M1,
          10342 => Opcode::PseudoVSSSEG6E32_V_M1_MASK,
          10343 => Opcode::PseudoVSSSEG6E32_V_MF2,
          10344 => Opcode::PseudoVSSSEG6E32_V_MF2_MASK,
          10345 => Opcode::PseudoVSSSEG6E64_V_M1,
          10346 => Opcode::PseudoVSSSEG6E64_V_M1_MASK,
          10347 => Opcode::PseudoVSSSEG6E8_V_M1,
          10348 => Opcode::PseudoVSSSEG6E8_V_M1_MASK,
          10349 => Opcode::PseudoVSSSEG6E8_V_MF2,
          10350 => Opcode::PseudoVSSSEG6E8_V_MF2_MASK,
          10351 => Opcode::PseudoVSSSEG6E8_V_MF4,
          10352 => Opcode::PseudoVSSSEG6E8_V_MF4_MASK,
          10353 => Opcode::PseudoVSSSEG6E8_V_MF8,
          10354 => Opcode::PseudoVSSSEG6E8_V_MF8_MASK,
          10355 => Opcode::PseudoVSSSEG7E16_V_M1,
          10356 => Opcode::PseudoVSSSEG7E16_V_M1_MASK,
          10357 => Opcode::PseudoVSSSEG7E16_V_MF2,
          10358 => Opcode::PseudoVSSSEG7E16_V_MF2_MASK,
          10359 => Opcode::PseudoVSSSEG7E16_V_MF4,
          10360 => Opcode::PseudoVSSSEG7E16_V_MF4_MASK,
          10361 => Opcode::PseudoVSSSEG7E32_V_M1,
          10362 => Opcode::PseudoVSSSEG7E32_V_M1_MASK,
          10363 => Opcode::PseudoVSSSEG7E32_V_MF2,
          10364 => Opcode::PseudoVSSSEG7E32_V_MF2_MASK,
          10365 => Opcode::PseudoVSSSEG7E64_V_M1,
          10366 => Opcode::PseudoVSSSEG7E64_V_M1_MASK,
          10367 => Opcode::PseudoVSSSEG7E8_V_M1,
          10368 => Opcode::PseudoVSSSEG7E8_V_M1_MASK,
          10369 => Opcode::PseudoVSSSEG7E8_V_MF2,
          10370 => Opcode::PseudoVSSSEG7E8_V_MF2_MASK,
          10371 => Opcode::PseudoVSSSEG7E8_V_MF4,
          10372 => Opcode::PseudoVSSSEG7E8_V_MF4_MASK,
          10373 => Opcode::PseudoVSSSEG7E8_V_MF8,
          10374 => Opcode::PseudoVSSSEG7E8_V_MF8_MASK,
          10375 => Opcode::PseudoVSSSEG8E16_V_M1,
          10376 => Opcode::PseudoVSSSEG8E16_V_M1_MASK,
          10377 => Opcode::PseudoVSSSEG8E16_V_MF2,
          10378 => Opcode::PseudoVSSSEG8E16_V_MF2_MASK,
          10379 => Opcode::PseudoVSSSEG8E16_V_MF4,
          10380 => Opcode::PseudoVSSSEG8E16_V_MF4_MASK,
          10381 => Opcode::PseudoVSSSEG8E32_V_M1,
          10382 => Opcode::PseudoVSSSEG8E32_V_M1_MASK,
          10383 => Opcode::PseudoVSSSEG8E32_V_MF2,
          10384 => Opcode::PseudoVSSSEG8E32_V_MF2_MASK,
          10385 => Opcode::PseudoVSSSEG8E64_V_M1,
          10386 => Opcode::PseudoVSSSEG8E64_V_M1_MASK,
          10387 => Opcode::PseudoVSSSEG8E8_V_M1,
          10388 => Opcode::PseudoVSSSEG8E8_V_M1_MASK,
          10389 => Opcode::PseudoVSSSEG8E8_V_MF2,
          10390 => Opcode::PseudoVSSSEG8E8_V_MF2_MASK,
          10391 => Opcode::PseudoVSSSEG8E8_V_MF4,
          10392 => Opcode::PseudoVSSSEG8E8_V_MF4_MASK,
          10393 => Opcode::PseudoVSSSEG8E8_V_MF8,
          10394 => Opcode::PseudoVSSSEG8E8_V_MF8_MASK,
          10395 => Opcode::PseudoVSSUBU_VV_M1,
          10396 => Opcode::PseudoVSSUBU_VV_M1_MASK,
          10397 => Opcode::PseudoVSSUBU_VV_M2,
          10398 => Opcode::PseudoVSSUBU_VV_M2_MASK,
          10399 => Opcode::PseudoVSSUBU_VV_M4,
          10400 => Opcode::PseudoVSSUBU_VV_M4_MASK,
          10401 => Opcode::PseudoVSSUBU_VV_M8,
          10402 => Opcode::PseudoVSSUBU_VV_M8_MASK,
          10403 => Opcode::PseudoVSSUBU_VV_MF2,
          10404 => Opcode::PseudoVSSUBU_VV_MF2_MASK,
          10405 => Opcode::PseudoVSSUBU_VV_MF4,
          10406 => Opcode::PseudoVSSUBU_VV_MF4_MASK,
          10407 => Opcode::PseudoVSSUBU_VV_MF8,
          10408 => Opcode::PseudoVSSUBU_VV_MF8_MASK,
          10409 => Opcode::PseudoVSSUBU_VX_M1,
          10410 => Opcode::PseudoVSSUBU_VX_M1_MASK,
          10411 => Opcode::PseudoVSSUBU_VX_M2,
          10412 => Opcode::PseudoVSSUBU_VX_M2_MASK,
          10413 => Opcode::PseudoVSSUBU_VX_M4,
          10414 => Opcode::PseudoVSSUBU_VX_M4_MASK,
          10415 => Opcode::PseudoVSSUBU_VX_M8,
          10416 => Opcode::PseudoVSSUBU_VX_M8_MASK,
          10417 => Opcode::PseudoVSSUBU_VX_MF2,
          10418 => Opcode::PseudoVSSUBU_VX_MF2_MASK,
          10419 => Opcode::PseudoVSSUBU_VX_MF4,
          10420 => Opcode::PseudoVSSUBU_VX_MF4_MASK,
          10421 => Opcode::PseudoVSSUBU_VX_MF8,
          10422 => Opcode::PseudoVSSUBU_VX_MF8_MASK,
          10423 => Opcode::PseudoVSSUB_VV_M1,
          10424 => Opcode::PseudoVSSUB_VV_M1_MASK,
          10425 => Opcode::PseudoVSSUB_VV_M2,
          10426 => Opcode::PseudoVSSUB_VV_M2_MASK,
          10427 => Opcode::PseudoVSSUB_VV_M4,
          10428 => Opcode::PseudoVSSUB_VV_M4_MASK,
          10429 => Opcode::PseudoVSSUB_VV_M8,
          10430 => Opcode::PseudoVSSUB_VV_M8_MASK,
          10431 => Opcode::PseudoVSSUB_VV_MF2,
          10432 => Opcode::PseudoVSSUB_VV_MF2_MASK,
          10433 => Opcode::PseudoVSSUB_VV_MF4,
          10434 => Opcode::PseudoVSSUB_VV_MF4_MASK,
          10435 => Opcode::PseudoVSSUB_VV_MF8,
          10436 => Opcode::PseudoVSSUB_VV_MF8_MASK,
          10437 => Opcode::PseudoVSSUB_VX_M1,
          10438 => Opcode::PseudoVSSUB_VX_M1_MASK,
          10439 => Opcode::PseudoVSSUB_VX_M2,
          10440 => Opcode::PseudoVSSUB_VX_M2_MASK,
          10441 => Opcode::PseudoVSSUB_VX_M4,
          10442 => Opcode::PseudoVSSUB_VX_M4_MASK,
          10443 => Opcode::PseudoVSSUB_VX_M8,
          10444 => Opcode::PseudoVSSUB_VX_M8_MASK,
          10445 => Opcode::PseudoVSSUB_VX_MF2,
          10446 => Opcode::PseudoVSSUB_VX_MF2_MASK,
          10447 => Opcode::PseudoVSSUB_VX_MF4,
          10448 => Opcode::PseudoVSSUB_VX_MF4_MASK,
          10449 => Opcode::PseudoVSSUB_VX_MF8,
          10450 => Opcode::PseudoVSSUB_VX_MF8_MASK,
          10451 => Opcode::PseudoVSUB_VV_M1,
          10452 => Opcode::PseudoVSUB_VV_M1_MASK,
          10453 => Opcode::PseudoVSUB_VV_M2,
          10454 => Opcode::PseudoVSUB_VV_M2_MASK,
          10455 => Opcode::PseudoVSUB_VV_M4,
          10456 => Opcode::PseudoVSUB_VV_M4_MASK,
          10457 => Opcode::PseudoVSUB_VV_M8,
          10458 => Opcode::PseudoVSUB_VV_M8_MASK,
          10459 => Opcode::PseudoVSUB_VV_MF2,
          10460 => Opcode::PseudoVSUB_VV_MF2_MASK,
          10461 => Opcode::PseudoVSUB_VV_MF4,
          10462 => Opcode::PseudoVSUB_VV_MF4_MASK,
          10463 => Opcode::PseudoVSUB_VV_MF8,
          10464 => Opcode::PseudoVSUB_VV_MF8_MASK,
          10465 => Opcode::PseudoVSUB_VX_M1,
          10466 => Opcode::PseudoVSUB_VX_M1_MASK,
          10467 => Opcode::PseudoVSUB_VX_M2,
          10468 => Opcode::PseudoVSUB_VX_M2_MASK,
          10469 => Opcode::PseudoVSUB_VX_M4,
          10470 => Opcode::PseudoVSUB_VX_M4_MASK,
          10471 => Opcode::PseudoVSUB_VX_M8,
          10472 => Opcode::PseudoVSUB_VX_M8_MASK,
          10473 => Opcode::PseudoVSUB_VX_MF2,
          10474 => Opcode::PseudoVSUB_VX_MF2_MASK,
          10475 => Opcode::PseudoVSUB_VX_MF4,
          10476 => Opcode::PseudoVSUB_VX_MF4_MASK,
          10477 => Opcode::PseudoVSUB_VX_MF8,
          10478 => Opcode::PseudoVSUB_VX_MF8_MASK,
          10479 => Opcode::PseudoVSUXEI16_V_M1_M1,
          10480 => Opcode::PseudoVSUXEI16_V_M1_M1_MASK,
          10481 => Opcode::PseudoVSUXEI16_V_M1_M2,
          10482 => Opcode::PseudoVSUXEI16_V_M1_M2_MASK,
          10483 => Opcode::PseudoVSUXEI16_V_M1_M4,
          10484 => Opcode::PseudoVSUXEI16_V_M1_M4_MASK,
          10485 => Opcode::PseudoVSUXEI16_V_M1_MF2,
          10486 => Opcode::PseudoVSUXEI16_V_M1_MF2_MASK,
          10487 => Opcode::PseudoVSUXEI16_V_M2_M1,
          10488 => Opcode::PseudoVSUXEI16_V_M2_M1_MASK,
          10489 => Opcode::PseudoVSUXEI16_V_M2_M2,
          10490 => Opcode::PseudoVSUXEI16_V_M2_M2_MASK,
          10491 => Opcode::PseudoVSUXEI16_V_M2_M4,
          10492 => Opcode::PseudoVSUXEI16_V_M2_M4_MASK,
          10493 => Opcode::PseudoVSUXEI16_V_M2_M8,
          10494 => Opcode::PseudoVSUXEI16_V_M2_M8_MASK,
          10495 => Opcode::PseudoVSUXEI16_V_M4_M2,
          10496 => Opcode::PseudoVSUXEI16_V_M4_M2_MASK,
          10497 => Opcode::PseudoVSUXEI16_V_M4_M4,
          10498 => Opcode::PseudoVSUXEI16_V_M4_M4_MASK,
          10499 => Opcode::PseudoVSUXEI16_V_M4_M8,
          10500 => Opcode::PseudoVSUXEI16_V_M4_M8_MASK,
          10501 => Opcode::PseudoVSUXEI16_V_M8_M4,
          10502 => Opcode::PseudoVSUXEI16_V_M8_M4_MASK,
          10503 => Opcode::PseudoVSUXEI16_V_M8_M8,
          10504 => Opcode::PseudoVSUXEI16_V_M8_M8_MASK,
          10505 => Opcode::PseudoVSUXEI16_V_MF2_M1,
          10506 => Opcode::PseudoVSUXEI16_V_MF2_M1_MASK,
          10507 => Opcode::PseudoVSUXEI16_V_MF2_M2,
          10508 => Opcode::PseudoVSUXEI16_V_MF2_M2_MASK,
          10509 => Opcode::PseudoVSUXEI16_V_MF2_MF2,
          10510 => Opcode::PseudoVSUXEI16_V_MF2_MF2_MASK,
          10511 => Opcode::PseudoVSUXEI16_V_MF2_MF4,
          10512 => Opcode::PseudoVSUXEI16_V_MF2_MF4_MASK,
          10513 => Opcode::PseudoVSUXEI16_V_MF4_M1,
          10514 => Opcode::PseudoVSUXEI16_V_MF4_M1_MASK,
          10515 => Opcode::PseudoVSUXEI16_V_MF4_MF2,
          10516 => Opcode::PseudoVSUXEI16_V_MF4_MF2_MASK,
          10517 => Opcode::PseudoVSUXEI16_V_MF4_MF4,
          10518 => Opcode::PseudoVSUXEI16_V_MF4_MF4_MASK,
          10519 => Opcode::PseudoVSUXEI16_V_MF4_MF8,
          10520 => Opcode::PseudoVSUXEI16_V_MF4_MF8_MASK,
          10521 => Opcode::PseudoVSUXEI32_V_M1_M1,
          10522 => Opcode::PseudoVSUXEI32_V_M1_M1_MASK,
          10523 => Opcode::PseudoVSUXEI32_V_M1_M2,
          10524 => Opcode::PseudoVSUXEI32_V_M1_M2_MASK,
          10525 => Opcode::PseudoVSUXEI32_V_M1_MF2,
          10526 => Opcode::PseudoVSUXEI32_V_M1_MF2_MASK,
          10527 => Opcode::PseudoVSUXEI32_V_M1_MF4,
          10528 => Opcode::PseudoVSUXEI32_V_M1_MF4_MASK,
          10529 => Opcode::PseudoVSUXEI32_V_M2_M1,
          10530 => Opcode::PseudoVSUXEI32_V_M2_M1_MASK,
          10531 => Opcode::PseudoVSUXEI32_V_M2_M2,
          10532 => Opcode::PseudoVSUXEI32_V_M2_M2_MASK,
          10533 => Opcode::PseudoVSUXEI32_V_M2_M4,
          10534 => Opcode::PseudoVSUXEI32_V_M2_M4_MASK,
          10535 => Opcode::PseudoVSUXEI32_V_M2_MF2,
          10536 => Opcode::PseudoVSUXEI32_V_M2_MF2_MASK,
          10537 => Opcode::PseudoVSUXEI32_V_M4_M1,
          10538 => Opcode::PseudoVSUXEI32_V_M4_M1_MASK,
          10539 => Opcode::PseudoVSUXEI32_V_M4_M2,
          10540 => Opcode::PseudoVSUXEI32_V_M4_M2_MASK,
          10541 => Opcode::PseudoVSUXEI32_V_M4_M4,
          10542 => Opcode::PseudoVSUXEI32_V_M4_M4_MASK,
          10543 => Opcode::PseudoVSUXEI32_V_M4_M8,
          10544 => Opcode::PseudoVSUXEI32_V_M4_M8_MASK,
          10545 => Opcode::PseudoVSUXEI32_V_M8_M2,
          10546 => Opcode::PseudoVSUXEI32_V_M8_M2_MASK,
          10547 => Opcode::PseudoVSUXEI32_V_M8_M4,
          10548 => Opcode::PseudoVSUXEI32_V_M8_M4_MASK,
          10549 => Opcode::PseudoVSUXEI32_V_M8_M8,
          10550 => Opcode::PseudoVSUXEI32_V_M8_M8_MASK,
          10551 => Opcode::PseudoVSUXEI32_V_MF2_M1,
          10552 => Opcode::PseudoVSUXEI32_V_MF2_M1_MASK,
          10553 => Opcode::PseudoVSUXEI32_V_MF2_MF2,
          10554 => Opcode::PseudoVSUXEI32_V_MF2_MF2_MASK,
          10555 => Opcode::PseudoVSUXEI32_V_MF2_MF4,
          10556 => Opcode::PseudoVSUXEI32_V_MF2_MF4_MASK,
          10557 => Opcode::PseudoVSUXEI32_V_MF2_MF8,
          10558 => Opcode::PseudoVSUXEI32_V_MF2_MF8_MASK,
          10559 => Opcode::PseudoVSUXEI64_V_M1_M1,
          10560 => Opcode::PseudoVSUXEI64_V_M1_M1_MASK,
          10561 => Opcode::PseudoVSUXEI64_V_M1_MF2,
          10562 => Opcode::PseudoVSUXEI64_V_M1_MF2_MASK,
          10563 => Opcode::PseudoVSUXEI64_V_M1_MF4,
          10564 => Opcode::PseudoVSUXEI64_V_M1_MF4_MASK,
          10565 => Opcode::PseudoVSUXEI64_V_M1_MF8,
          10566 => Opcode::PseudoVSUXEI64_V_M1_MF8_MASK,
          10567 => Opcode::PseudoVSUXEI64_V_M2_M1,
          10568 => Opcode::PseudoVSUXEI64_V_M2_M1_MASK,
          10569 => Opcode::PseudoVSUXEI64_V_M2_M2,
          10570 => Opcode::PseudoVSUXEI64_V_M2_M2_MASK,
          10571 => Opcode::PseudoVSUXEI64_V_M2_MF2,
          10572 => Opcode::PseudoVSUXEI64_V_M2_MF2_MASK,
          10573 => Opcode::PseudoVSUXEI64_V_M2_MF4,
          10574 => Opcode::PseudoVSUXEI64_V_M2_MF4_MASK,
          10575 => Opcode::PseudoVSUXEI64_V_M4_M1,
          10576 => Opcode::PseudoVSUXEI64_V_M4_M1_MASK,
          10577 => Opcode::PseudoVSUXEI64_V_M4_M2,
          10578 => Opcode::PseudoVSUXEI64_V_M4_M2_MASK,
          10579 => Opcode::PseudoVSUXEI64_V_M4_M4,
          10580 => Opcode::PseudoVSUXEI64_V_M4_M4_MASK,
          10581 => Opcode::PseudoVSUXEI64_V_M4_MF2,
          10582 => Opcode::PseudoVSUXEI64_V_M4_MF2_MASK,
          10583 => Opcode::PseudoVSUXEI64_V_M8_M1,
          10584 => Opcode::PseudoVSUXEI64_V_M8_M1_MASK,
          10585 => Opcode::PseudoVSUXEI64_V_M8_M2,
          10586 => Opcode::PseudoVSUXEI64_V_M8_M2_MASK,
          10587 => Opcode::PseudoVSUXEI64_V_M8_M4,
          10588 => Opcode::PseudoVSUXEI64_V_M8_M4_MASK,
          10589 => Opcode::PseudoVSUXEI64_V_M8_M8,
          10590 => Opcode::PseudoVSUXEI64_V_M8_M8_MASK,
          10591 => Opcode::PseudoVSUXEI8_V_M1_M1,
          10592 => Opcode::PseudoVSUXEI8_V_M1_M1_MASK,
          10593 => Opcode::PseudoVSUXEI8_V_M1_M2,
          10594 => Opcode::PseudoVSUXEI8_V_M1_M2_MASK,
          10595 => Opcode::PseudoVSUXEI8_V_M1_M4,
          10596 => Opcode::PseudoVSUXEI8_V_M1_M4_MASK,
          10597 => Opcode::PseudoVSUXEI8_V_M1_M8,
          10598 => Opcode::PseudoVSUXEI8_V_M1_M8_MASK,
          10599 => Opcode::PseudoVSUXEI8_V_M2_M2,
          10600 => Opcode::PseudoVSUXEI8_V_M2_M2_MASK,
          10601 => Opcode::PseudoVSUXEI8_V_M2_M4,
          10602 => Opcode::PseudoVSUXEI8_V_M2_M4_MASK,
          10603 => Opcode::PseudoVSUXEI8_V_M2_M8,
          10604 => Opcode::PseudoVSUXEI8_V_M2_M8_MASK,
          10605 => Opcode::PseudoVSUXEI8_V_M4_M4,
          10606 => Opcode::PseudoVSUXEI8_V_M4_M4_MASK,
          10607 => Opcode::PseudoVSUXEI8_V_M4_M8,
          10608 => Opcode::PseudoVSUXEI8_V_M4_M8_MASK,
          10609 => Opcode::PseudoVSUXEI8_V_M8_M8,
          10610 => Opcode::PseudoVSUXEI8_V_M8_M8_MASK,
          10611 => Opcode::PseudoVSUXEI8_V_MF2_M1,
          10612 => Opcode::PseudoVSUXEI8_V_MF2_M1_MASK,
          10613 => Opcode::PseudoVSUXEI8_V_MF2_M2,
          10614 => Opcode::PseudoVSUXEI8_V_MF2_M2_MASK,
          10615 => Opcode::PseudoVSUXEI8_V_MF2_M4,
          10616 => Opcode::PseudoVSUXEI8_V_MF2_M4_MASK,
          10617 => Opcode::PseudoVSUXEI8_V_MF2_MF2,
          10618 => Opcode::PseudoVSUXEI8_V_MF2_MF2_MASK,
          10619 => Opcode::PseudoVSUXEI8_V_MF4_M1,
          10620 => Opcode::PseudoVSUXEI8_V_MF4_M1_MASK,
          10621 => Opcode::PseudoVSUXEI8_V_MF4_M2,
          10622 => Opcode::PseudoVSUXEI8_V_MF4_M2_MASK,
          10623 => Opcode::PseudoVSUXEI8_V_MF4_MF2,
          10624 => Opcode::PseudoVSUXEI8_V_MF4_MF2_MASK,
          10625 => Opcode::PseudoVSUXEI8_V_MF4_MF4,
          10626 => Opcode::PseudoVSUXEI8_V_MF4_MF4_MASK,
          10627 => Opcode::PseudoVSUXEI8_V_MF8_M1,
          10628 => Opcode::PseudoVSUXEI8_V_MF8_M1_MASK,
          10629 => Opcode::PseudoVSUXEI8_V_MF8_MF2,
          10630 => Opcode::PseudoVSUXEI8_V_MF8_MF2_MASK,
          10631 => Opcode::PseudoVSUXEI8_V_MF8_MF4,
          10632 => Opcode::PseudoVSUXEI8_V_MF8_MF4_MASK,
          10633 => Opcode::PseudoVSUXEI8_V_MF8_MF8,
          10634 => Opcode::PseudoVSUXEI8_V_MF8_MF8_MASK,
          10635 => Opcode::PseudoVSUXSEG2EI16_V_M1_M1,
          10636 => Opcode::PseudoVSUXSEG2EI16_V_M1_M1_MASK,
          10637 => Opcode::PseudoVSUXSEG2EI16_V_M1_M2,
          10638 => Opcode::PseudoVSUXSEG2EI16_V_M1_M2_MASK,
          10639 => Opcode::PseudoVSUXSEG2EI16_V_M1_M4,
          10640 => Opcode::PseudoVSUXSEG2EI16_V_M1_M4_MASK,
          10641 => Opcode::PseudoVSUXSEG2EI16_V_M1_MF2,
          10642 => Opcode::PseudoVSUXSEG2EI16_V_M1_MF2_MASK,
          10643 => Opcode::PseudoVSUXSEG2EI16_V_M2_M1,
          10644 => Opcode::PseudoVSUXSEG2EI16_V_M2_M1_MASK,
          10645 => Opcode::PseudoVSUXSEG2EI16_V_M2_M2,
          10646 => Opcode::PseudoVSUXSEG2EI16_V_M2_M2_MASK,
          10647 => Opcode::PseudoVSUXSEG2EI16_V_M2_M4,
          10648 => Opcode::PseudoVSUXSEG2EI16_V_M2_M4_MASK,
          10649 => Opcode::PseudoVSUXSEG2EI16_V_M4_M2,
          10650 => Opcode::PseudoVSUXSEG2EI16_V_M4_M2_MASK,
          10651 => Opcode::PseudoVSUXSEG2EI16_V_M4_M4,
          10652 => Opcode::PseudoVSUXSEG2EI16_V_M4_M4_MASK,
          10653 => Opcode::PseudoVSUXSEG2EI16_V_M8_M4,
          10654 => Opcode::PseudoVSUXSEG2EI16_V_M8_M4_MASK,
          10655 => Opcode::PseudoVSUXSEG2EI16_V_MF2_M1,
          10656 => Opcode::PseudoVSUXSEG2EI16_V_MF2_M1_MASK,
          10657 => Opcode::PseudoVSUXSEG2EI16_V_MF2_M2,
          10658 => Opcode::PseudoVSUXSEG2EI16_V_MF2_M2_MASK,
          10659 => Opcode::PseudoVSUXSEG2EI16_V_MF2_MF2,
          10660 => Opcode::PseudoVSUXSEG2EI16_V_MF2_MF2_MASK,
          10661 => Opcode::PseudoVSUXSEG2EI16_V_MF2_MF4,
          10662 => Opcode::PseudoVSUXSEG2EI16_V_MF2_MF4_MASK,
          10663 => Opcode::PseudoVSUXSEG2EI16_V_MF4_M1,
          10664 => Opcode::PseudoVSUXSEG2EI16_V_MF4_M1_MASK,
          10665 => Opcode::PseudoVSUXSEG2EI16_V_MF4_MF2,
          10666 => Opcode::PseudoVSUXSEG2EI16_V_MF4_MF2_MASK,
          10667 => Opcode::PseudoVSUXSEG2EI16_V_MF4_MF4,
          10668 => Opcode::PseudoVSUXSEG2EI16_V_MF4_MF4_MASK,
          10669 => Opcode::PseudoVSUXSEG2EI16_V_MF4_MF8,
          10670 => Opcode::PseudoVSUXSEG2EI16_V_MF4_MF8_MASK,
          10671 => Opcode::PseudoVSUXSEG2EI32_V_M1_M1,
          10672 => Opcode::PseudoVSUXSEG2EI32_V_M1_M1_MASK,
          10673 => Opcode::PseudoVSUXSEG2EI32_V_M1_M2,
          10674 => Opcode::PseudoVSUXSEG2EI32_V_M1_M2_MASK,
          10675 => Opcode::PseudoVSUXSEG2EI32_V_M1_MF2,
          10676 => Opcode::PseudoVSUXSEG2EI32_V_M1_MF2_MASK,
          10677 => Opcode::PseudoVSUXSEG2EI32_V_M1_MF4,
          10678 => Opcode::PseudoVSUXSEG2EI32_V_M1_MF4_MASK,
          10679 => Opcode::PseudoVSUXSEG2EI32_V_M2_M1,
          10680 => Opcode::PseudoVSUXSEG2EI32_V_M2_M1_MASK,
          10681 => Opcode::PseudoVSUXSEG2EI32_V_M2_M2,
          10682 => Opcode::PseudoVSUXSEG2EI32_V_M2_M2_MASK,
          10683 => Opcode::PseudoVSUXSEG2EI32_V_M2_M4,
          10684 => Opcode::PseudoVSUXSEG2EI32_V_M2_M4_MASK,
          10685 => Opcode::PseudoVSUXSEG2EI32_V_M2_MF2,
          10686 => Opcode::PseudoVSUXSEG2EI32_V_M2_MF2_MASK,
          10687 => Opcode::PseudoVSUXSEG2EI32_V_M4_M1,
          10688 => Opcode::PseudoVSUXSEG2EI32_V_M4_M1_MASK,
          10689 => Opcode::PseudoVSUXSEG2EI32_V_M4_M2,
          10690 => Opcode::PseudoVSUXSEG2EI32_V_M4_M2_MASK,
          10691 => Opcode::PseudoVSUXSEG2EI32_V_M4_M4,
          10692 => Opcode::PseudoVSUXSEG2EI32_V_M4_M4_MASK,
          10693 => Opcode::PseudoVSUXSEG2EI32_V_M8_M2,
          10694 => Opcode::PseudoVSUXSEG2EI32_V_M8_M2_MASK,
          10695 => Opcode::PseudoVSUXSEG2EI32_V_M8_M4,
          10696 => Opcode::PseudoVSUXSEG2EI32_V_M8_M4_MASK,
          10697 => Opcode::PseudoVSUXSEG2EI32_V_MF2_M1,
          10698 => Opcode::PseudoVSUXSEG2EI32_V_MF2_M1_MASK,
          10699 => Opcode::PseudoVSUXSEG2EI32_V_MF2_MF2,
          10700 => Opcode::PseudoVSUXSEG2EI32_V_MF2_MF2_MASK,
          10701 => Opcode::PseudoVSUXSEG2EI32_V_MF2_MF4,
          10702 => Opcode::PseudoVSUXSEG2EI32_V_MF2_MF4_MASK,
          10703 => Opcode::PseudoVSUXSEG2EI32_V_MF2_MF8,
          10704 => Opcode::PseudoVSUXSEG2EI32_V_MF2_MF8_MASK,
          10705 => Opcode::PseudoVSUXSEG2EI64_V_M1_M1,
          10706 => Opcode::PseudoVSUXSEG2EI64_V_M1_M1_MASK,
          10707 => Opcode::PseudoVSUXSEG2EI64_V_M1_MF2,
          10708 => Opcode::PseudoVSUXSEG2EI64_V_M1_MF2_MASK,
          10709 => Opcode::PseudoVSUXSEG2EI64_V_M1_MF4,
          10710 => Opcode::PseudoVSUXSEG2EI64_V_M1_MF4_MASK,
          10711 => Opcode::PseudoVSUXSEG2EI64_V_M1_MF8,
          10712 => Opcode::PseudoVSUXSEG2EI64_V_M1_MF8_MASK,
          10713 => Opcode::PseudoVSUXSEG2EI64_V_M2_M1,
          10714 => Opcode::PseudoVSUXSEG2EI64_V_M2_M1_MASK,
          10715 => Opcode::PseudoVSUXSEG2EI64_V_M2_M2,
          10716 => Opcode::PseudoVSUXSEG2EI64_V_M2_M2_MASK,
          10717 => Opcode::PseudoVSUXSEG2EI64_V_M2_MF2,
          10718 => Opcode::PseudoVSUXSEG2EI64_V_M2_MF2_MASK,
          10719 => Opcode::PseudoVSUXSEG2EI64_V_M2_MF4,
          10720 => Opcode::PseudoVSUXSEG2EI64_V_M2_MF4_MASK,
          10721 => Opcode::PseudoVSUXSEG2EI64_V_M4_M1,
          10722 => Opcode::PseudoVSUXSEG2EI64_V_M4_M1_MASK,
          10723 => Opcode::PseudoVSUXSEG2EI64_V_M4_M2,
          10724 => Opcode::PseudoVSUXSEG2EI64_V_M4_M2_MASK,
          10725 => Opcode::PseudoVSUXSEG2EI64_V_M4_M4,
          10726 => Opcode::PseudoVSUXSEG2EI64_V_M4_M4_MASK,
          10727 => Opcode::PseudoVSUXSEG2EI64_V_M4_MF2,
          10728 => Opcode::PseudoVSUXSEG2EI64_V_M4_MF2_MASK,
          10729 => Opcode::PseudoVSUXSEG2EI64_V_M8_M1,
          10730 => Opcode::PseudoVSUXSEG2EI64_V_M8_M1_MASK,
          10731 => Opcode::PseudoVSUXSEG2EI64_V_M8_M2,
          10732 => Opcode::PseudoVSUXSEG2EI64_V_M8_M2_MASK,
          10733 => Opcode::PseudoVSUXSEG2EI64_V_M8_M4,
          10734 => Opcode::PseudoVSUXSEG2EI64_V_M8_M4_MASK,
          10735 => Opcode::PseudoVSUXSEG2EI8_V_M1_M1,
          10736 => Opcode::PseudoVSUXSEG2EI8_V_M1_M1_MASK,
          10737 => Opcode::PseudoVSUXSEG2EI8_V_M1_M2,
          10738 => Opcode::PseudoVSUXSEG2EI8_V_M1_M2_MASK,
          10739 => Opcode::PseudoVSUXSEG2EI8_V_M1_M4,
          10740 => Opcode::PseudoVSUXSEG2EI8_V_M1_M4_MASK,
          10741 => Opcode::PseudoVSUXSEG2EI8_V_M2_M2,
          10742 => Opcode::PseudoVSUXSEG2EI8_V_M2_M2_MASK,
          10743 => Opcode::PseudoVSUXSEG2EI8_V_M2_M4,
          10744 => Opcode::PseudoVSUXSEG2EI8_V_M2_M4_MASK,
          10745 => Opcode::PseudoVSUXSEG2EI8_V_M4_M4,
          10746 => Opcode::PseudoVSUXSEG2EI8_V_M4_M4_MASK,
          10747 => Opcode::PseudoVSUXSEG2EI8_V_MF2_M1,
          10748 => Opcode::PseudoVSUXSEG2EI8_V_MF2_M1_MASK,
          10749 => Opcode::PseudoVSUXSEG2EI8_V_MF2_M2,
          10750 => Opcode::PseudoVSUXSEG2EI8_V_MF2_M2_MASK,
          10751 => Opcode::PseudoVSUXSEG2EI8_V_MF2_M4,
          10752 => Opcode::PseudoVSUXSEG2EI8_V_MF2_M4_MASK,
          10753 => Opcode::PseudoVSUXSEG2EI8_V_MF2_MF2,
          10754 => Opcode::PseudoVSUXSEG2EI8_V_MF2_MF2_MASK,
          10755 => Opcode::PseudoVSUXSEG2EI8_V_MF4_M1,
          10756 => Opcode::PseudoVSUXSEG2EI8_V_MF4_M1_MASK,
          10757 => Opcode::PseudoVSUXSEG2EI8_V_MF4_M2,
          10758 => Opcode::PseudoVSUXSEG2EI8_V_MF4_M2_MASK,
          10759 => Opcode::PseudoVSUXSEG2EI8_V_MF4_MF2,
          10760 => Opcode::PseudoVSUXSEG2EI8_V_MF4_MF2_MASK,
          10761 => Opcode::PseudoVSUXSEG2EI8_V_MF4_MF4,
          10762 => Opcode::PseudoVSUXSEG2EI8_V_MF4_MF4_MASK,
          10763 => Opcode::PseudoVSUXSEG2EI8_V_MF8_M1,
          10764 => Opcode::PseudoVSUXSEG2EI8_V_MF8_M1_MASK,
          10765 => Opcode::PseudoVSUXSEG2EI8_V_MF8_MF2,
          10766 => Opcode::PseudoVSUXSEG2EI8_V_MF8_MF2_MASK,
          10767 => Opcode::PseudoVSUXSEG2EI8_V_MF8_MF4,
          10768 => Opcode::PseudoVSUXSEG2EI8_V_MF8_MF4_MASK,
          10769 => Opcode::PseudoVSUXSEG2EI8_V_MF8_MF8,
          10770 => Opcode::PseudoVSUXSEG2EI8_V_MF8_MF8_MASK,
          10771 => Opcode::PseudoVSUXSEG3EI16_V_M1_M1,
          10772 => Opcode::PseudoVSUXSEG3EI16_V_M1_M1_MASK,
          10773 => Opcode::PseudoVSUXSEG3EI16_V_M1_M2,
          10774 => Opcode::PseudoVSUXSEG3EI16_V_M1_M2_MASK,
          10775 => Opcode::PseudoVSUXSEG3EI16_V_M1_MF2,
          10776 => Opcode::PseudoVSUXSEG3EI16_V_M1_MF2_MASK,
          10777 => Opcode::PseudoVSUXSEG3EI16_V_M2_M1,
          10778 => Opcode::PseudoVSUXSEG3EI16_V_M2_M1_MASK,
          10779 => Opcode::PseudoVSUXSEG3EI16_V_M2_M2,
          10780 => Opcode::PseudoVSUXSEG3EI16_V_M2_M2_MASK,
          10781 => Opcode::PseudoVSUXSEG3EI16_V_M4_M2,
          10782 => Opcode::PseudoVSUXSEG3EI16_V_M4_M2_MASK,
          10783 => Opcode::PseudoVSUXSEG3EI16_V_MF2_M1,
          10784 => Opcode::PseudoVSUXSEG3EI16_V_MF2_M1_MASK,
          10785 => Opcode::PseudoVSUXSEG3EI16_V_MF2_M2,
          10786 => Opcode::PseudoVSUXSEG3EI16_V_MF2_M2_MASK,
          10787 => Opcode::PseudoVSUXSEG3EI16_V_MF2_MF2,
          10788 => Opcode::PseudoVSUXSEG3EI16_V_MF2_MF2_MASK,
          10789 => Opcode::PseudoVSUXSEG3EI16_V_MF2_MF4,
          10790 => Opcode::PseudoVSUXSEG3EI16_V_MF2_MF4_MASK,
          10791 => Opcode::PseudoVSUXSEG3EI16_V_MF4_M1,
          10792 => Opcode::PseudoVSUXSEG3EI16_V_MF4_M1_MASK,
          10793 => Opcode::PseudoVSUXSEG3EI16_V_MF4_MF2,
          10794 => Opcode::PseudoVSUXSEG3EI16_V_MF4_MF2_MASK,
          10795 => Opcode::PseudoVSUXSEG3EI16_V_MF4_MF4,
          10796 => Opcode::PseudoVSUXSEG3EI16_V_MF4_MF4_MASK,
          10797 => Opcode::PseudoVSUXSEG3EI16_V_MF4_MF8,
          10798 => Opcode::PseudoVSUXSEG3EI16_V_MF4_MF8_MASK,
          10799 => Opcode::PseudoVSUXSEG3EI32_V_M1_M1,
          10800 => Opcode::PseudoVSUXSEG3EI32_V_M1_M1_MASK,
          10801 => Opcode::PseudoVSUXSEG3EI32_V_M1_M2,
          10802 => Opcode::PseudoVSUXSEG3EI32_V_M1_M2_MASK,
          10803 => Opcode::PseudoVSUXSEG3EI32_V_M1_MF2,
          10804 => Opcode::PseudoVSUXSEG3EI32_V_M1_MF2_MASK,
          10805 => Opcode::PseudoVSUXSEG3EI32_V_M1_MF4,
          10806 => Opcode::PseudoVSUXSEG3EI32_V_M1_MF4_MASK,
          10807 => Opcode::PseudoVSUXSEG3EI32_V_M2_M1,
          10808 => Opcode::PseudoVSUXSEG3EI32_V_M2_M1_MASK,
          10809 => Opcode::PseudoVSUXSEG3EI32_V_M2_M2,
          10810 => Opcode::PseudoVSUXSEG3EI32_V_M2_M2_MASK,
          10811 => Opcode::PseudoVSUXSEG3EI32_V_M2_MF2,
          10812 => Opcode::PseudoVSUXSEG3EI32_V_M2_MF2_MASK,
          10813 => Opcode::PseudoVSUXSEG3EI32_V_M4_M1,
          10814 => Opcode::PseudoVSUXSEG3EI32_V_M4_M1_MASK,
          10815 => Opcode::PseudoVSUXSEG3EI32_V_M4_M2,
          10816 => Opcode::PseudoVSUXSEG3EI32_V_M4_M2_MASK,
          10817 => Opcode::PseudoVSUXSEG3EI32_V_M8_M2,
          10818 => Opcode::PseudoVSUXSEG3EI32_V_M8_M2_MASK,
          10819 => Opcode::PseudoVSUXSEG3EI32_V_MF2_M1,
          10820 => Opcode::PseudoVSUXSEG3EI32_V_MF2_M1_MASK,
          10821 => Opcode::PseudoVSUXSEG3EI32_V_MF2_MF2,
          10822 => Opcode::PseudoVSUXSEG3EI32_V_MF2_MF2_MASK,
          10823 => Opcode::PseudoVSUXSEG3EI32_V_MF2_MF4,
          10824 => Opcode::PseudoVSUXSEG3EI32_V_MF2_MF4_MASK,
          10825 => Opcode::PseudoVSUXSEG3EI32_V_MF2_MF8,
          10826 => Opcode::PseudoVSUXSEG3EI32_V_MF2_MF8_MASK,
          10827 => Opcode::PseudoVSUXSEG3EI64_V_M1_M1,
          10828 => Opcode::PseudoVSUXSEG3EI64_V_M1_M1_MASK,
          10829 => Opcode::PseudoVSUXSEG3EI64_V_M1_MF2,
          10830 => Opcode::PseudoVSUXSEG3EI64_V_M1_MF2_MASK,
          10831 => Opcode::PseudoVSUXSEG3EI64_V_M1_MF4,
          10832 => Opcode::PseudoVSUXSEG3EI64_V_M1_MF4_MASK,
          10833 => Opcode::PseudoVSUXSEG3EI64_V_M1_MF8,
          10834 => Opcode::PseudoVSUXSEG3EI64_V_M1_MF8_MASK,
          10835 => Opcode::PseudoVSUXSEG3EI64_V_M2_M1,
          10836 => Opcode::PseudoVSUXSEG3EI64_V_M2_M1_MASK,
          10837 => Opcode::PseudoVSUXSEG3EI64_V_M2_M2,
          10838 => Opcode::PseudoVSUXSEG3EI64_V_M2_M2_MASK,
          10839 => Opcode::PseudoVSUXSEG3EI64_V_M2_MF2,
          10840 => Opcode::PseudoVSUXSEG3EI64_V_M2_MF2_MASK,
          10841 => Opcode::PseudoVSUXSEG3EI64_V_M2_MF4,
          10842 => Opcode::PseudoVSUXSEG3EI64_V_M2_MF4_MASK,
          10843 => Opcode::PseudoVSUXSEG3EI64_V_M4_M1,
          10844 => Opcode::PseudoVSUXSEG3EI64_V_M4_M1_MASK,
          10845 => Opcode::PseudoVSUXSEG3EI64_V_M4_M2,
          10846 => Opcode::PseudoVSUXSEG3EI64_V_M4_M2_MASK,
          10847 => Opcode::PseudoVSUXSEG3EI64_V_M4_MF2,
          10848 => Opcode::PseudoVSUXSEG3EI64_V_M4_MF2_MASK,
          10849 => Opcode::PseudoVSUXSEG3EI64_V_M8_M1,
          10850 => Opcode::PseudoVSUXSEG3EI64_V_M8_M1_MASK,
          10851 => Opcode::PseudoVSUXSEG3EI64_V_M8_M2,
          10852 => Opcode::PseudoVSUXSEG3EI64_V_M8_M2_MASK,
          10853 => Opcode::PseudoVSUXSEG3EI8_V_M1_M1,
          10854 => Opcode::PseudoVSUXSEG3EI8_V_M1_M1_MASK,
          10855 => Opcode::PseudoVSUXSEG3EI8_V_M1_M2,
          10856 => Opcode::PseudoVSUXSEG3EI8_V_M1_M2_MASK,
          10857 => Opcode::PseudoVSUXSEG3EI8_V_M2_M2,
          10858 => Opcode::PseudoVSUXSEG3EI8_V_M2_M2_MASK,
          10859 => Opcode::PseudoVSUXSEG3EI8_V_MF2_M1,
          10860 => Opcode::PseudoVSUXSEG3EI8_V_MF2_M1_MASK,
          10861 => Opcode::PseudoVSUXSEG3EI8_V_MF2_M2,
          10862 => Opcode::PseudoVSUXSEG3EI8_V_MF2_M2_MASK,
          10863 => Opcode::PseudoVSUXSEG3EI8_V_MF2_MF2,
          10864 => Opcode::PseudoVSUXSEG3EI8_V_MF2_MF2_MASK,
          10865 => Opcode::PseudoVSUXSEG3EI8_V_MF4_M1,
          10866 => Opcode::PseudoVSUXSEG3EI8_V_MF4_M1_MASK,
          10867 => Opcode::PseudoVSUXSEG3EI8_V_MF4_M2,
          10868 => Opcode::PseudoVSUXSEG3EI8_V_MF4_M2_MASK,
          10869 => Opcode::PseudoVSUXSEG3EI8_V_MF4_MF2,
          10870 => Opcode::PseudoVSUXSEG3EI8_V_MF4_MF2_MASK,
          10871 => Opcode::PseudoVSUXSEG3EI8_V_MF4_MF4,
          10872 => Opcode::PseudoVSUXSEG3EI8_V_MF4_MF4_MASK,
          10873 => Opcode::PseudoVSUXSEG3EI8_V_MF8_M1,
          10874 => Opcode::PseudoVSUXSEG3EI8_V_MF8_M1_MASK,
          10875 => Opcode::PseudoVSUXSEG3EI8_V_MF8_MF2,
          10876 => Opcode::PseudoVSUXSEG3EI8_V_MF8_MF2_MASK,
          10877 => Opcode::PseudoVSUXSEG3EI8_V_MF8_MF4,
          10878 => Opcode::PseudoVSUXSEG3EI8_V_MF8_MF4_MASK,
          10879 => Opcode::PseudoVSUXSEG3EI8_V_MF8_MF8,
          10880 => Opcode::PseudoVSUXSEG3EI8_V_MF8_MF8_MASK,
          10881 => Opcode::PseudoVSUXSEG4EI16_V_M1_M1,
          10882 => Opcode::PseudoVSUXSEG4EI16_V_M1_M1_MASK,
          10883 => Opcode::PseudoVSUXSEG4EI16_V_M1_M2,
          10884 => Opcode::PseudoVSUXSEG4EI16_V_M1_M2_MASK,
          10885 => Opcode::PseudoVSUXSEG4EI16_V_M1_MF2,
          10886 => Opcode::PseudoVSUXSEG4EI16_V_M1_MF2_MASK,
          10887 => Opcode::PseudoVSUXSEG4EI16_V_M2_M1,
          10888 => Opcode::PseudoVSUXSEG4EI16_V_M2_M1_MASK,
          10889 => Opcode::PseudoVSUXSEG4EI16_V_M2_M2,
          10890 => Opcode::PseudoVSUXSEG4EI16_V_M2_M2_MASK,
          10891 => Opcode::PseudoVSUXSEG4EI16_V_M4_M2,
          10892 => Opcode::PseudoVSUXSEG4EI16_V_M4_M2_MASK,
          10893 => Opcode::PseudoVSUXSEG4EI16_V_MF2_M1,
          10894 => Opcode::PseudoVSUXSEG4EI16_V_MF2_M1_MASK,
          10895 => Opcode::PseudoVSUXSEG4EI16_V_MF2_M2,
          10896 => Opcode::PseudoVSUXSEG4EI16_V_MF2_M2_MASK,
          10897 => Opcode::PseudoVSUXSEG4EI16_V_MF2_MF2,
          10898 => Opcode::PseudoVSUXSEG4EI16_V_MF2_MF2_MASK,
          10899 => Opcode::PseudoVSUXSEG4EI16_V_MF2_MF4,
          10900 => Opcode::PseudoVSUXSEG4EI16_V_MF2_MF4_MASK,
          10901 => Opcode::PseudoVSUXSEG4EI16_V_MF4_M1,
          10902 => Opcode::PseudoVSUXSEG4EI16_V_MF4_M1_MASK,
          10903 => Opcode::PseudoVSUXSEG4EI16_V_MF4_MF2,
          10904 => Opcode::PseudoVSUXSEG4EI16_V_MF4_MF2_MASK,
          10905 => Opcode::PseudoVSUXSEG4EI16_V_MF4_MF4,
          10906 => Opcode::PseudoVSUXSEG4EI16_V_MF4_MF4_MASK,
          10907 => Opcode::PseudoVSUXSEG4EI16_V_MF4_MF8,
          10908 => Opcode::PseudoVSUXSEG4EI16_V_MF4_MF8_MASK,
          10909 => Opcode::PseudoVSUXSEG4EI32_V_M1_M1,
          10910 => Opcode::PseudoVSUXSEG4EI32_V_M1_M1_MASK,
          10911 => Opcode::PseudoVSUXSEG4EI32_V_M1_M2,
          10912 => Opcode::PseudoVSUXSEG4EI32_V_M1_M2_MASK,
          10913 => Opcode::PseudoVSUXSEG4EI32_V_M1_MF2,
          10914 => Opcode::PseudoVSUXSEG4EI32_V_M1_MF2_MASK,
          10915 => Opcode::PseudoVSUXSEG4EI32_V_M1_MF4,
          10916 => Opcode::PseudoVSUXSEG4EI32_V_M1_MF4_MASK,
          10917 => Opcode::PseudoVSUXSEG4EI32_V_M2_M1,
          10918 => Opcode::PseudoVSUXSEG4EI32_V_M2_M1_MASK,
          10919 => Opcode::PseudoVSUXSEG4EI32_V_M2_M2,
          10920 => Opcode::PseudoVSUXSEG4EI32_V_M2_M2_MASK,
          10921 => Opcode::PseudoVSUXSEG4EI32_V_M2_MF2,
          10922 => Opcode::PseudoVSUXSEG4EI32_V_M2_MF2_MASK,
          10923 => Opcode::PseudoVSUXSEG4EI32_V_M4_M1,
          10924 => Opcode::PseudoVSUXSEG4EI32_V_M4_M1_MASK,
          10925 => Opcode::PseudoVSUXSEG4EI32_V_M4_M2,
          10926 => Opcode::PseudoVSUXSEG4EI32_V_M4_M2_MASK,
          10927 => Opcode::PseudoVSUXSEG4EI32_V_M8_M2,
          10928 => Opcode::PseudoVSUXSEG4EI32_V_M8_M2_MASK,
          10929 => Opcode::PseudoVSUXSEG4EI32_V_MF2_M1,
          10930 => Opcode::PseudoVSUXSEG4EI32_V_MF2_M1_MASK,
          10931 => Opcode::PseudoVSUXSEG4EI32_V_MF2_MF2,
          10932 => Opcode::PseudoVSUXSEG4EI32_V_MF2_MF2_MASK,
          10933 => Opcode::PseudoVSUXSEG4EI32_V_MF2_MF4,
          10934 => Opcode::PseudoVSUXSEG4EI32_V_MF2_MF4_MASK,
          10935 => Opcode::PseudoVSUXSEG4EI32_V_MF2_MF8,
          10936 => Opcode::PseudoVSUXSEG4EI32_V_MF2_MF8_MASK,
          10937 => Opcode::PseudoVSUXSEG4EI64_V_M1_M1,
          10938 => Opcode::PseudoVSUXSEG4EI64_V_M1_M1_MASK,
          10939 => Opcode::PseudoVSUXSEG4EI64_V_M1_MF2,
          10940 => Opcode::PseudoVSUXSEG4EI64_V_M1_MF2_MASK,
          10941 => Opcode::PseudoVSUXSEG4EI64_V_M1_MF4,
          10942 => Opcode::PseudoVSUXSEG4EI64_V_M1_MF4_MASK,
          10943 => Opcode::PseudoVSUXSEG4EI64_V_M1_MF8,
          10944 => Opcode::PseudoVSUXSEG4EI64_V_M1_MF8_MASK,
          10945 => Opcode::PseudoVSUXSEG4EI64_V_M2_M1,
          10946 => Opcode::PseudoVSUXSEG4EI64_V_M2_M1_MASK,
          10947 => Opcode::PseudoVSUXSEG4EI64_V_M2_M2,
          10948 => Opcode::PseudoVSUXSEG4EI64_V_M2_M2_MASK,
          10949 => Opcode::PseudoVSUXSEG4EI64_V_M2_MF2,
          10950 => Opcode::PseudoVSUXSEG4EI64_V_M2_MF2_MASK,
          10951 => Opcode::PseudoVSUXSEG4EI64_V_M2_MF4,
          10952 => Opcode::PseudoVSUXSEG4EI64_V_M2_MF4_MASK,
          10953 => Opcode::PseudoVSUXSEG4EI64_V_M4_M1,
          10954 => Opcode::PseudoVSUXSEG4EI64_V_M4_M1_MASK,
          10955 => Opcode::PseudoVSUXSEG4EI64_V_M4_M2,
          10956 => Opcode::PseudoVSUXSEG4EI64_V_M4_M2_MASK,
          10957 => Opcode::PseudoVSUXSEG4EI64_V_M4_MF2,
          10958 => Opcode::PseudoVSUXSEG4EI64_V_M4_MF2_MASK,
          10959 => Opcode::PseudoVSUXSEG4EI64_V_M8_M1,
          10960 => Opcode::PseudoVSUXSEG4EI64_V_M8_M1_MASK,
          10961 => Opcode::PseudoVSUXSEG4EI64_V_M8_M2,
          10962 => Opcode::PseudoVSUXSEG4EI64_V_M8_M2_MASK,
          10963 => Opcode::PseudoVSUXSEG4EI8_V_M1_M1,
          10964 => Opcode::PseudoVSUXSEG4EI8_V_M1_M1_MASK,
          10965 => Opcode::PseudoVSUXSEG4EI8_V_M1_M2,
          10966 => Opcode::PseudoVSUXSEG4EI8_V_M1_M2_MASK,
          10967 => Opcode::PseudoVSUXSEG4EI8_V_M2_M2,
          10968 => Opcode::PseudoVSUXSEG4EI8_V_M2_M2_MASK,
          10969 => Opcode::PseudoVSUXSEG4EI8_V_MF2_M1,
          10970 => Opcode::PseudoVSUXSEG4EI8_V_MF2_M1_MASK,
          10971 => Opcode::PseudoVSUXSEG4EI8_V_MF2_M2,
          10972 => Opcode::PseudoVSUXSEG4EI8_V_MF2_M2_MASK,
          10973 => Opcode::PseudoVSUXSEG4EI8_V_MF2_MF2,
          10974 => Opcode::PseudoVSUXSEG4EI8_V_MF2_MF2_MASK,
          10975 => Opcode::PseudoVSUXSEG4EI8_V_MF4_M1,
          10976 => Opcode::PseudoVSUXSEG4EI8_V_MF4_M1_MASK,
          10977 => Opcode::PseudoVSUXSEG4EI8_V_MF4_M2,
          10978 => Opcode::PseudoVSUXSEG4EI8_V_MF4_M2_MASK,
          10979 => Opcode::PseudoVSUXSEG4EI8_V_MF4_MF2,
          10980 => Opcode::PseudoVSUXSEG4EI8_V_MF4_MF2_MASK,
          10981 => Opcode::PseudoVSUXSEG4EI8_V_MF4_MF4,
          10982 => Opcode::PseudoVSUXSEG4EI8_V_MF4_MF4_MASK,
          10983 => Opcode::PseudoVSUXSEG4EI8_V_MF8_M1,
          10984 => Opcode::PseudoVSUXSEG4EI8_V_MF8_M1_MASK,
          10985 => Opcode::PseudoVSUXSEG4EI8_V_MF8_MF2,
          10986 => Opcode::PseudoVSUXSEG4EI8_V_MF8_MF2_MASK,
          10987 => Opcode::PseudoVSUXSEG4EI8_V_MF8_MF4,
          10988 => Opcode::PseudoVSUXSEG4EI8_V_MF8_MF4_MASK,
          10989 => Opcode::PseudoVSUXSEG4EI8_V_MF8_MF8,
          10990 => Opcode::PseudoVSUXSEG4EI8_V_MF8_MF8_MASK,
          10991 => Opcode::PseudoVSUXSEG5EI16_V_M1_M1,
          10992 => Opcode::PseudoVSUXSEG5EI16_V_M1_M1_MASK,
          10993 => Opcode::PseudoVSUXSEG5EI16_V_M1_MF2,
          10994 => Opcode::PseudoVSUXSEG5EI16_V_M1_MF2_MASK,
          10995 => Opcode::PseudoVSUXSEG5EI16_V_M2_M1,
          10996 => Opcode::PseudoVSUXSEG5EI16_V_M2_M1_MASK,
          10997 => Opcode::PseudoVSUXSEG5EI16_V_MF2_M1,
          10998 => Opcode::PseudoVSUXSEG5EI16_V_MF2_M1_MASK,
          10999 => Opcode::PseudoVSUXSEG5EI16_V_MF2_MF2,
          11000 => Opcode::PseudoVSUXSEG5EI16_V_MF2_MF2_MASK,
          11001 => Opcode::PseudoVSUXSEG5EI16_V_MF2_MF4,
          11002 => Opcode::PseudoVSUXSEG5EI16_V_MF2_MF4_MASK,
          11003 => Opcode::PseudoVSUXSEG5EI16_V_MF4_M1,
          11004 => Opcode::PseudoVSUXSEG5EI16_V_MF4_M1_MASK,
          11005 => Opcode::PseudoVSUXSEG5EI16_V_MF4_MF2,
          11006 => Opcode::PseudoVSUXSEG5EI16_V_MF4_MF2_MASK,
          11007 => Opcode::PseudoVSUXSEG5EI16_V_MF4_MF4,
          11008 => Opcode::PseudoVSUXSEG5EI16_V_MF4_MF4_MASK,
          11009 => Opcode::PseudoVSUXSEG5EI16_V_MF4_MF8,
          11010 => Opcode::PseudoVSUXSEG5EI16_V_MF4_MF8_MASK,
          11011 => Opcode::PseudoVSUXSEG5EI32_V_M1_M1,
          11012 => Opcode::PseudoVSUXSEG5EI32_V_M1_M1_MASK,
          11013 => Opcode::PseudoVSUXSEG5EI32_V_M1_MF2,
          11014 => Opcode::PseudoVSUXSEG5EI32_V_M1_MF2_MASK,
          11015 => Opcode::PseudoVSUXSEG5EI32_V_M1_MF4,
          11016 => Opcode::PseudoVSUXSEG5EI32_V_M1_MF4_MASK,
          11017 => Opcode::PseudoVSUXSEG5EI32_V_M2_M1,
          11018 => Opcode::PseudoVSUXSEG5EI32_V_M2_M1_MASK,
          11019 => Opcode::PseudoVSUXSEG5EI32_V_M2_MF2,
          11020 => Opcode::PseudoVSUXSEG5EI32_V_M2_MF2_MASK,
          11021 => Opcode::PseudoVSUXSEG5EI32_V_M4_M1,
          11022 => Opcode::PseudoVSUXSEG5EI32_V_M4_M1_MASK,
          11023 => Opcode::PseudoVSUXSEG5EI32_V_MF2_M1,
          11024 => Opcode::PseudoVSUXSEG5EI32_V_MF2_M1_MASK,
          11025 => Opcode::PseudoVSUXSEG5EI32_V_MF2_MF2,
          11026 => Opcode::PseudoVSUXSEG5EI32_V_MF2_MF2_MASK,
          11027 => Opcode::PseudoVSUXSEG5EI32_V_MF2_MF4,
          11028 => Opcode::PseudoVSUXSEG5EI32_V_MF2_MF4_MASK,
          11029 => Opcode::PseudoVSUXSEG5EI32_V_MF2_MF8,
          11030 => Opcode::PseudoVSUXSEG5EI32_V_MF2_MF8_MASK,
          11031 => Opcode::PseudoVSUXSEG5EI64_V_M1_M1,
          11032 => Opcode::PseudoVSUXSEG5EI64_V_M1_M1_MASK,
          11033 => Opcode::PseudoVSUXSEG5EI64_V_M1_MF2,
          11034 => Opcode::PseudoVSUXSEG5EI64_V_M1_MF2_MASK,
          11035 => Opcode::PseudoVSUXSEG5EI64_V_M1_MF4,
          11036 => Opcode::PseudoVSUXSEG5EI64_V_M1_MF4_MASK,
          11037 => Opcode::PseudoVSUXSEG5EI64_V_M1_MF8,
          11038 => Opcode::PseudoVSUXSEG5EI64_V_M1_MF8_MASK,
          11039 => Opcode::PseudoVSUXSEG5EI64_V_M2_M1,
          11040 => Opcode::PseudoVSUXSEG5EI64_V_M2_M1_MASK,
          11041 => Opcode::PseudoVSUXSEG5EI64_V_M2_MF2,
          11042 => Opcode::PseudoVSUXSEG5EI64_V_M2_MF2_MASK,
          11043 => Opcode::PseudoVSUXSEG5EI64_V_M2_MF4,
          11044 => Opcode::PseudoVSUXSEG5EI64_V_M2_MF4_MASK,
          11045 => Opcode::PseudoVSUXSEG5EI64_V_M4_M1,
          11046 => Opcode::PseudoVSUXSEG5EI64_V_M4_M1_MASK,
          11047 => Opcode::PseudoVSUXSEG5EI64_V_M4_MF2,
          11048 => Opcode::PseudoVSUXSEG5EI64_V_M4_MF2_MASK,
          11049 => Opcode::PseudoVSUXSEG5EI64_V_M8_M1,
          11050 => Opcode::PseudoVSUXSEG5EI64_V_M8_M1_MASK,
          11051 => Opcode::PseudoVSUXSEG5EI8_V_M1_M1,
          11052 => Opcode::PseudoVSUXSEG5EI8_V_M1_M1_MASK,
          11053 => Opcode::PseudoVSUXSEG5EI8_V_MF2_M1,
          11054 => Opcode::PseudoVSUXSEG5EI8_V_MF2_M1_MASK,
          11055 => Opcode::PseudoVSUXSEG5EI8_V_MF2_MF2,
          11056 => Opcode::PseudoVSUXSEG5EI8_V_MF2_MF2_MASK,
          11057 => Opcode::PseudoVSUXSEG5EI8_V_MF4_M1,
          11058 => Opcode::PseudoVSUXSEG5EI8_V_MF4_M1_MASK,
          11059 => Opcode::PseudoVSUXSEG5EI8_V_MF4_MF2,
          11060 => Opcode::PseudoVSUXSEG5EI8_V_MF4_MF2_MASK,
          11061 => Opcode::PseudoVSUXSEG5EI8_V_MF4_MF4,
          11062 => Opcode::PseudoVSUXSEG5EI8_V_MF4_MF4_MASK,
          11063 => Opcode::PseudoVSUXSEG5EI8_V_MF8_M1,
          11064 => Opcode::PseudoVSUXSEG5EI8_V_MF8_M1_MASK,
          11065 => Opcode::PseudoVSUXSEG5EI8_V_MF8_MF2,
          11066 => Opcode::PseudoVSUXSEG5EI8_V_MF8_MF2_MASK,
          11067 => Opcode::PseudoVSUXSEG5EI8_V_MF8_MF4,
          11068 => Opcode::PseudoVSUXSEG5EI8_V_MF8_MF4_MASK,
          11069 => Opcode::PseudoVSUXSEG5EI8_V_MF8_MF8,
          11070 => Opcode::PseudoVSUXSEG5EI8_V_MF8_MF8_MASK,
          11071 => Opcode::PseudoVSUXSEG6EI16_V_M1_M1,
          11072 => Opcode::PseudoVSUXSEG6EI16_V_M1_M1_MASK,
          11073 => Opcode::PseudoVSUXSEG6EI16_V_M1_MF2,
          11074 => Opcode::PseudoVSUXSEG6EI16_V_M1_MF2_MASK,
          11075 => Opcode::PseudoVSUXSEG6EI16_V_M2_M1,
          11076 => Opcode::PseudoVSUXSEG6EI16_V_M2_M1_MASK,
          11077 => Opcode::PseudoVSUXSEG6EI16_V_MF2_M1,
          11078 => Opcode::PseudoVSUXSEG6EI16_V_MF2_M1_MASK,
          11079 => Opcode::PseudoVSUXSEG6EI16_V_MF2_MF2,
          11080 => Opcode::PseudoVSUXSEG6EI16_V_MF2_MF2_MASK,
          11081 => Opcode::PseudoVSUXSEG6EI16_V_MF2_MF4,
          11082 => Opcode::PseudoVSUXSEG6EI16_V_MF2_MF4_MASK,
          11083 => Opcode::PseudoVSUXSEG6EI16_V_MF4_M1,
          11084 => Opcode::PseudoVSUXSEG6EI16_V_MF4_M1_MASK,
          11085 => Opcode::PseudoVSUXSEG6EI16_V_MF4_MF2,
          11086 => Opcode::PseudoVSUXSEG6EI16_V_MF4_MF2_MASK,
          11087 => Opcode::PseudoVSUXSEG6EI16_V_MF4_MF4,
          11088 => Opcode::PseudoVSUXSEG6EI16_V_MF4_MF4_MASK,
          11089 => Opcode::PseudoVSUXSEG6EI16_V_MF4_MF8,
          11090 => Opcode::PseudoVSUXSEG6EI16_V_MF4_MF8_MASK,
          11091 => Opcode::PseudoVSUXSEG6EI32_V_M1_M1,
          11092 => Opcode::PseudoVSUXSEG6EI32_V_M1_M1_MASK,
          11093 => Opcode::PseudoVSUXSEG6EI32_V_M1_MF2,
          11094 => Opcode::PseudoVSUXSEG6EI32_V_M1_MF2_MASK,
          11095 => Opcode::PseudoVSUXSEG6EI32_V_M1_MF4,
          11096 => Opcode::PseudoVSUXSEG6EI32_V_M1_MF4_MASK,
          11097 => Opcode::PseudoVSUXSEG6EI32_V_M2_M1,
          11098 => Opcode::PseudoVSUXSEG6EI32_V_M2_M1_MASK,
          11099 => Opcode::PseudoVSUXSEG6EI32_V_M2_MF2,
          11100 => Opcode::PseudoVSUXSEG6EI32_V_M2_MF2_MASK,
          11101 => Opcode::PseudoVSUXSEG6EI32_V_M4_M1,
          11102 => Opcode::PseudoVSUXSEG6EI32_V_M4_M1_MASK,
          11103 => Opcode::PseudoVSUXSEG6EI32_V_MF2_M1,
          11104 => Opcode::PseudoVSUXSEG6EI32_V_MF2_M1_MASK,
          11105 => Opcode::PseudoVSUXSEG6EI32_V_MF2_MF2,
          11106 => Opcode::PseudoVSUXSEG6EI32_V_MF2_MF2_MASK,
          11107 => Opcode::PseudoVSUXSEG6EI32_V_MF2_MF4,
          11108 => Opcode::PseudoVSUXSEG6EI32_V_MF2_MF4_MASK,
          11109 => Opcode::PseudoVSUXSEG6EI32_V_MF2_MF8,
          11110 => Opcode::PseudoVSUXSEG6EI32_V_MF2_MF8_MASK,
          11111 => Opcode::PseudoVSUXSEG6EI64_V_M1_M1,
          11112 => Opcode::PseudoVSUXSEG6EI64_V_M1_M1_MASK,
          11113 => Opcode::PseudoVSUXSEG6EI64_V_M1_MF2,
          11114 => Opcode::PseudoVSUXSEG6EI64_V_M1_MF2_MASK,
          11115 => Opcode::PseudoVSUXSEG6EI64_V_M1_MF4,
          11116 => Opcode::PseudoVSUXSEG6EI64_V_M1_MF4_MASK,
          11117 => Opcode::PseudoVSUXSEG6EI64_V_M1_MF8,
          11118 => Opcode::PseudoVSUXSEG6EI64_V_M1_MF8_MASK,
          11119 => Opcode::PseudoVSUXSEG6EI64_V_M2_M1,
          11120 => Opcode::PseudoVSUXSEG6EI64_V_M2_M1_MASK,
          11121 => Opcode::PseudoVSUXSEG6EI64_V_M2_MF2,
          11122 => Opcode::PseudoVSUXSEG6EI64_V_M2_MF2_MASK,
          11123 => Opcode::PseudoVSUXSEG6EI64_V_M2_MF4,
          11124 => Opcode::PseudoVSUXSEG6EI64_V_M2_MF4_MASK,
          11125 => Opcode::PseudoVSUXSEG6EI64_V_M4_M1,
          11126 => Opcode::PseudoVSUXSEG6EI64_V_M4_M1_MASK,
          11127 => Opcode::PseudoVSUXSEG6EI64_V_M4_MF2,
          11128 => Opcode::PseudoVSUXSEG6EI64_V_M4_MF2_MASK,
          11129 => Opcode::PseudoVSUXSEG6EI64_V_M8_M1,
          11130 => Opcode::PseudoVSUXSEG6EI64_V_M8_M1_MASK,
          11131 => Opcode::PseudoVSUXSEG6EI8_V_M1_M1,
          11132 => Opcode::PseudoVSUXSEG6EI8_V_M1_M1_MASK,
          11133 => Opcode::PseudoVSUXSEG6EI8_V_MF2_M1,
          11134 => Opcode::PseudoVSUXSEG6EI8_V_MF2_M1_MASK,
          11135 => Opcode::PseudoVSUXSEG6EI8_V_MF2_MF2,
          11136 => Opcode::PseudoVSUXSEG6EI8_V_MF2_MF2_MASK,
          11137 => Opcode::PseudoVSUXSEG6EI8_V_MF4_M1,
          11138 => Opcode::PseudoVSUXSEG6EI8_V_MF4_M1_MASK,
          11139 => Opcode::PseudoVSUXSEG6EI8_V_MF4_MF2,
          11140 => Opcode::PseudoVSUXSEG6EI8_V_MF4_MF2_MASK,
          11141 => Opcode::PseudoVSUXSEG6EI8_V_MF4_MF4,
          11142 => Opcode::PseudoVSUXSEG6EI8_V_MF4_MF4_MASK,
          11143 => Opcode::PseudoVSUXSEG6EI8_V_MF8_M1,
          11144 => Opcode::PseudoVSUXSEG6EI8_V_MF8_M1_MASK,
          11145 => Opcode::PseudoVSUXSEG6EI8_V_MF8_MF2,
          11146 => Opcode::PseudoVSUXSEG6EI8_V_MF8_MF2_MASK,
          11147 => Opcode::PseudoVSUXSEG6EI8_V_MF8_MF4,
          11148 => Opcode::PseudoVSUXSEG6EI8_V_MF8_MF4_MASK,
          11149 => Opcode::PseudoVSUXSEG6EI8_V_MF8_MF8,
          11150 => Opcode::PseudoVSUXSEG6EI8_V_MF8_MF8_MASK,
          11151 => Opcode::PseudoVSUXSEG7EI16_V_M1_M1,
          11152 => Opcode::PseudoVSUXSEG7EI16_V_M1_M1_MASK,
          11153 => Opcode::PseudoVSUXSEG7EI16_V_M1_MF2,
          11154 => Opcode::PseudoVSUXSEG7EI16_V_M1_MF2_MASK,
          11155 => Opcode::PseudoVSUXSEG7EI16_V_M2_M1,
          11156 => Opcode::PseudoVSUXSEG7EI16_V_M2_M1_MASK,
          11157 => Opcode::PseudoVSUXSEG7EI16_V_MF2_M1,
          11158 => Opcode::PseudoVSUXSEG7EI16_V_MF2_M1_MASK,
          11159 => Opcode::PseudoVSUXSEG7EI16_V_MF2_MF2,
          11160 => Opcode::PseudoVSUXSEG7EI16_V_MF2_MF2_MASK,
          11161 => Opcode::PseudoVSUXSEG7EI16_V_MF2_MF4,
          11162 => Opcode::PseudoVSUXSEG7EI16_V_MF2_MF4_MASK,
          11163 => Opcode::PseudoVSUXSEG7EI16_V_MF4_M1,
          11164 => Opcode::PseudoVSUXSEG7EI16_V_MF4_M1_MASK,
          11165 => Opcode::PseudoVSUXSEG7EI16_V_MF4_MF2,
          11166 => Opcode::PseudoVSUXSEG7EI16_V_MF4_MF2_MASK,
          11167 => Opcode::PseudoVSUXSEG7EI16_V_MF4_MF4,
          11168 => Opcode::PseudoVSUXSEG7EI16_V_MF4_MF4_MASK,
          11169 => Opcode::PseudoVSUXSEG7EI16_V_MF4_MF8,
          11170 => Opcode::PseudoVSUXSEG7EI16_V_MF4_MF8_MASK,
          11171 => Opcode::PseudoVSUXSEG7EI32_V_M1_M1,
          11172 => Opcode::PseudoVSUXSEG7EI32_V_M1_M1_MASK,
          11173 => Opcode::PseudoVSUXSEG7EI32_V_M1_MF2,
          11174 => Opcode::PseudoVSUXSEG7EI32_V_M1_MF2_MASK,
          11175 => Opcode::PseudoVSUXSEG7EI32_V_M1_MF4,
          11176 => Opcode::PseudoVSUXSEG7EI32_V_M1_MF4_MASK,
          11177 => Opcode::PseudoVSUXSEG7EI32_V_M2_M1,
          11178 => Opcode::PseudoVSUXSEG7EI32_V_M2_M1_MASK,
          11179 => Opcode::PseudoVSUXSEG7EI32_V_M2_MF2,
          11180 => Opcode::PseudoVSUXSEG7EI32_V_M2_MF2_MASK,
          11181 => Opcode::PseudoVSUXSEG7EI32_V_M4_M1,
          11182 => Opcode::PseudoVSUXSEG7EI32_V_M4_M1_MASK,
          11183 => Opcode::PseudoVSUXSEG7EI32_V_MF2_M1,
          11184 => Opcode::PseudoVSUXSEG7EI32_V_MF2_M1_MASK,
          11185 => Opcode::PseudoVSUXSEG7EI32_V_MF2_MF2,
          11186 => Opcode::PseudoVSUXSEG7EI32_V_MF2_MF2_MASK,
          11187 => Opcode::PseudoVSUXSEG7EI32_V_MF2_MF4,
          11188 => Opcode::PseudoVSUXSEG7EI32_V_MF2_MF4_MASK,
          11189 => Opcode::PseudoVSUXSEG7EI32_V_MF2_MF8,
          11190 => Opcode::PseudoVSUXSEG7EI32_V_MF2_MF8_MASK,
          11191 => Opcode::PseudoVSUXSEG7EI64_V_M1_M1,
          11192 => Opcode::PseudoVSUXSEG7EI64_V_M1_M1_MASK,
          11193 => Opcode::PseudoVSUXSEG7EI64_V_M1_MF2,
          11194 => Opcode::PseudoVSUXSEG7EI64_V_M1_MF2_MASK,
          11195 => Opcode::PseudoVSUXSEG7EI64_V_M1_MF4,
          11196 => Opcode::PseudoVSUXSEG7EI64_V_M1_MF4_MASK,
          11197 => Opcode::PseudoVSUXSEG7EI64_V_M1_MF8,
          11198 => Opcode::PseudoVSUXSEG7EI64_V_M1_MF8_MASK,
          11199 => Opcode::PseudoVSUXSEG7EI64_V_M2_M1,
          11200 => Opcode::PseudoVSUXSEG7EI64_V_M2_M1_MASK,
          11201 => Opcode::PseudoVSUXSEG7EI64_V_M2_MF2,
          11202 => Opcode::PseudoVSUXSEG7EI64_V_M2_MF2_MASK,
          11203 => Opcode::PseudoVSUXSEG7EI64_V_M2_MF4,
          11204 => Opcode::PseudoVSUXSEG7EI64_V_M2_MF4_MASK,
          11205 => Opcode::PseudoVSUXSEG7EI64_V_M4_M1,
          11206 => Opcode::PseudoVSUXSEG7EI64_V_M4_M1_MASK,
          11207 => Opcode::PseudoVSUXSEG7EI64_V_M4_MF2,
          11208 => Opcode::PseudoVSUXSEG7EI64_V_M4_MF2_MASK,
          11209 => Opcode::PseudoVSUXSEG7EI64_V_M8_M1,
          11210 => Opcode::PseudoVSUXSEG7EI64_V_M8_M1_MASK,
          11211 => Opcode::PseudoVSUXSEG7EI8_V_M1_M1,
          11212 => Opcode::PseudoVSUXSEG7EI8_V_M1_M1_MASK,
          11213 => Opcode::PseudoVSUXSEG7EI8_V_MF2_M1,
          11214 => Opcode::PseudoVSUXSEG7EI8_V_MF2_M1_MASK,
          11215 => Opcode::PseudoVSUXSEG7EI8_V_MF2_MF2,
          11216 => Opcode::PseudoVSUXSEG7EI8_V_MF2_MF2_MASK,
          11217 => Opcode::PseudoVSUXSEG7EI8_V_MF4_M1,
          11218 => Opcode::PseudoVSUXSEG7EI8_V_MF4_M1_MASK,
          11219 => Opcode::PseudoVSUXSEG7EI8_V_MF4_MF2,
          11220 => Opcode::PseudoVSUXSEG7EI8_V_MF4_MF2_MASK,
          11221 => Opcode::PseudoVSUXSEG7EI8_V_MF4_MF4,
          11222 => Opcode::PseudoVSUXSEG7EI8_V_MF4_MF4_MASK,
          11223 => Opcode::PseudoVSUXSEG7EI8_V_MF8_M1,
          11224 => Opcode::PseudoVSUXSEG7EI8_V_MF8_M1_MASK,
          11225 => Opcode::PseudoVSUXSEG7EI8_V_MF8_MF2,
          11226 => Opcode::PseudoVSUXSEG7EI8_V_MF8_MF2_MASK,
          11227 => Opcode::PseudoVSUXSEG7EI8_V_MF8_MF4,
          11228 => Opcode::PseudoVSUXSEG7EI8_V_MF8_MF4_MASK,
          11229 => Opcode::PseudoVSUXSEG7EI8_V_MF8_MF8,
          11230 => Opcode::PseudoVSUXSEG7EI8_V_MF8_MF8_MASK,
          11231 => Opcode::PseudoVSUXSEG8EI16_V_M1_M1,
          11232 => Opcode::PseudoVSUXSEG8EI16_V_M1_M1_MASK,
          11233 => Opcode::PseudoVSUXSEG8EI16_V_M1_MF2,
          11234 => Opcode::PseudoVSUXSEG8EI16_V_M1_MF2_MASK,
          11235 => Opcode::PseudoVSUXSEG8EI16_V_M2_M1,
          11236 => Opcode::PseudoVSUXSEG8EI16_V_M2_M1_MASK,
          11237 => Opcode::PseudoVSUXSEG8EI16_V_MF2_M1,
          11238 => Opcode::PseudoVSUXSEG8EI16_V_MF2_M1_MASK,
          11239 => Opcode::PseudoVSUXSEG8EI16_V_MF2_MF2,
          11240 => Opcode::PseudoVSUXSEG8EI16_V_MF2_MF2_MASK,
          11241 => Opcode::PseudoVSUXSEG8EI16_V_MF2_MF4,
          11242 => Opcode::PseudoVSUXSEG8EI16_V_MF2_MF4_MASK,
          11243 => Opcode::PseudoVSUXSEG8EI16_V_MF4_M1,
          11244 => Opcode::PseudoVSUXSEG8EI16_V_MF4_M1_MASK,
          11245 => Opcode::PseudoVSUXSEG8EI16_V_MF4_MF2,
          11246 => Opcode::PseudoVSUXSEG8EI16_V_MF4_MF2_MASK,
          11247 => Opcode::PseudoVSUXSEG8EI16_V_MF4_MF4,
          11248 => Opcode::PseudoVSUXSEG8EI16_V_MF4_MF4_MASK,
          11249 => Opcode::PseudoVSUXSEG8EI16_V_MF4_MF8,
          11250 => Opcode::PseudoVSUXSEG8EI16_V_MF4_MF8_MASK,
          11251 => Opcode::PseudoVSUXSEG8EI32_V_M1_M1,
          11252 => Opcode::PseudoVSUXSEG8EI32_V_M1_M1_MASK,
          11253 => Opcode::PseudoVSUXSEG8EI32_V_M1_MF2,
          11254 => Opcode::PseudoVSUXSEG8EI32_V_M1_MF2_MASK,
          11255 => Opcode::PseudoVSUXSEG8EI32_V_M1_MF4,
          11256 => Opcode::PseudoVSUXSEG8EI32_V_M1_MF4_MASK,
          11257 => Opcode::PseudoVSUXSEG8EI32_V_M2_M1,
          11258 => Opcode::PseudoVSUXSEG8EI32_V_M2_M1_MASK,
          11259 => Opcode::PseudoVSUXSEG8EI32_V_M2_MF2,
          11260 => Opcode::PseudoVSUXSEG8EI32_V_M2_MF2_MASK,
          11261 => Opcode::PseudoVSUXSEG8EI32_V_M4_M1,
          11262 => Opcode::PseudoVSUXSEG8EI32_V_M4_M1_MASK,
          11263 => Opcode::PseudoVSUXSEG8EI32_V_MF2_M1,
          11264 => Opcode::PseudoVSUXSEG8EI32_V_MF2_M1_MASK,
          11265 => Opcode::PseudoVSUXSEG8EI32_V_MF2_MF2,
          11266 => Opcode::PseudoVSUXSEG8EI32_V_MF2_MF2_MASK,
          11267 => Opcode::PseudoVSUXSEG8EI32_V_MF2_MF4,
          11268 => Opcode::PseudoVSUXSEG8EI32_V_MF2_MF4_MASK,
          11269 => Opcode::PseudoVSUXSEG8EI32_V_MF2_MF8,
          11270 => Opcode::PseudoVSUXSEG8EI32_V_MF2_MF8_MASK,
          11271 => Opcode::PseudoVSUXSEG8EI64_V_M1_M1,
          11272 => Opcode::PseudoVSUXSEG8EI64_V_M1_M1_MASK,
          11273 => Opcode::PseudoVSUXSEG8EI64_V_M1_MF2,
          11274 => Opcode::PseudoVSUXSEG8EI64_V_M1_MF2_MASK,
          11275 => Opcode::PseudoVSUXSEG8EI64_V_M1_MF4,
          11276 => Opcode::PseudoVSUXSEG8EI64_V_M1_MF4_MASK,
          11277 => Opcode::PseudoVSUXSEG8EI64_V_M1_MF8,
          11278 => Opcode::PseudoVSUXSEG8EI64_V_M1_MF8_MASK,
          11279 => Opcode::PseudoVSUXSEG8EI64_V_M2_M1,
          11280 => Opcode::PseudoVSUXSEG8EI64_V_M2_M1_MASK,
          11281 => Opcode::PseudoVSUXSEG8EI64_V_M2_MF2,
          11282 => Opcode::PseudoVSUXSEG8EI64_V_M2_MF2_MASK,
          11283 => Opcode::PseudoVSUXSEG8EI64_V_M2_MF4,
          11284 => Opcode::PseudoVSUXSEG8EI64_V_M2_MF4_MASK,
          11285 => Opcode::PseudoVSUXSEG8EI64_V_M4_M1,
          11286 => Opcode::PseudoVSUXSEG8EI64_V_M4_M1_MASK,
          11287 => Opcode::PseudoVSUXSEG8EI64_V_M4_MF2,
          11288 => Opcode::PseudoVSUXSEG8EI64_V_M4_MF2_MASK,
          11289 => Opcode::PseudoVSUXSEG8EI64_V_M8_M1,
          11290 => Opcode::PseudoVSUXSEG8EI64_V_M8_M1_MASK,
          11291 => Opcode::PseudoVSUXSEG8EI8_V_M1_M1,
          11292 => Opcode::PseudoVSUXSEG8EI8_V_M1_M1_MASK,
          11293 => Opcode::PseudoVSUXSEG8EI8_V_MF2_M1,
          11294 => Opcode::PseudoVSUXSEG8EI8_V_MF2_M1_MASK,
          11295 => Opcode::PseudoVSUXSEG8EI8_V_MF2_MF2,
          11296 => Opcode::PseudoVSUXSEG8EI8_V_MF2_MF2_MASK,
          11297 => Opcode::PseudoVSUXSEG8EI8_V_MF4_M1,
          11298 => Opcode::PseudoVSUXSEG8EI8_V_MF4_M1_MASK,
          11299 => Opcode::PseudoVSUXSEG8EI8_V_MF4_MF2,
          11300 => Opcode::PseudoVSUXSEG8EI8_V_MF4_MF2_MASK,
          11301 => Opcode::PseudoVSUXSEG8EI8_V_MF4_MF4,
          11302 => Opcode::PseudoVSUXSEG8EI8_V_MF4_MF4_MASK,
          11303 => Opcode::PseudoVSUXSEG8EI8_V_MF8_M1,
          11304 => Opcode::PseudoVSUXSEG8EI8_V_MF8_M1_MASK,
          11305 => Opcode::PseudoVSUXSEG8EI8_V_MF8_MF2,
          11306 => Opcode::PseudoVSUXSEG8EI8_V_MF8_MF2_MASK,
          11307 => Opcode::PseudoVSUXSEG8EI8_V_MF8_MF4,
          11308 => Opcode::PseudoVSUXSEG8EI8_V_MF8_MF4_MASK,
          11309 => Opcode::PseudoVSUXSEG8EI8_V_MF8_MF8,
          11310 => Opcode::PseudoVSUXSEG8EI8_V_MF8_MF8_MASK,
          11311 => Opcode::PseudoVWADDU_VV_M1,
          11312 => Opcode::PseudoVWADDU_VV_M1_MASK,
          11313 => Opcode::PseudoVWADDU_VV_M2,
          11314 => Opcode::PseudoVWADDU_VV_M2_MASK,
          11315 => Opcode::PseudoVWADDU_VV_M4,
          11316 => Opcode::PseudoVWADDU_VV_M4_MASK,
          11317 => Opcode::PseudoVWADDU_VV_MF2,
          11318 => Opcode::PseudoVWADDU_VV_MF2_MASK,
          11319 => Opcode::PseudoVWADDU_VV_MF4,
          11320 => Opcode::PseudoVWADDU_VV_MF4_MASK,
          11321 => Opcode::PseudoVWADDU_VV_MF8,
          11322 => Opcode::PseudoVWADDU_VV_MF8_MASK,
          11323 => Opcode::PseudoVWADDU_VX_M1,
          11324 => Opcode::PseudoVWADDU_VX_M1_MASK,
          11325 => Opcode::PseudoVWADDU_VX_M2,
          11326 => Opcode::PseudoVWADDU_VX_M2_MASK,
          11327 => Opcode::PseudoVWADDU_VX_M4,
          11328 => Opcode::PseudoVWADDU_VX_M4_MASK,
          11329 => Opcode::PseudoVWADDU_VX_MF2,
          11330 => Opcode::PseudoVWADDU_VX_MF2_MASK,
          11331 => Opcode::PseudoVWADDU_VX_MF4,
          11332 => Opcode::PseudoVWADDU_VX_MF4_MASK,
          11333 => Opcode::PseudoVWADDU_VX_MF8,
          11334 => Opcode::PseudoVWADDU_VX_MF8_MASK,
          11335 => Opcode::PseudoVWADDU_WV_M1,
          11336 => Opcode::PseudoVWADDU_WV_M1_MASK,
          11337 => Opcode::PseudoVWADDU_WV_M1_MASK_TIED,
          11338 => Opcode::PseudoVWADDU_WV_M1_TIED,
          11339 => Opcode::PseudoVWADDU_WV_M2,
          11340 => Opcode::PseudoVWADDU_WV_M2_MASK,
          11341 => Opcode::PseudoVWADDU_WV_M2_MASK_TIED,
          11342 => Opcode::PseudoVWADDU_WV_M2_TIED,
          11343 => Opcode::PseudoVWADDU_WV_M4,
          11344 => Opcode::PseudoVWADDU_WV_M4_MASK,
          11345 => Opcode::PseudoVWADDU_WV_M4_MASK_TIED,
          11346 => Opcode::PseudoVWADDU_WV_M4_TIED,
          11347 => Opcode::PseudoVWADDU_WV_MF2,
          11348 => Opcode::PseudoVWADDU_WV_MF2_MASK,
          11349 => Opcode::PseudoVWADDU_WV_MF2_MASK_TIED,
          11350 => Opcode::PseudoVWADDU_WV_MF2_TIED,
          11351 => Opcode::PseudoVWADDU_WV_MF4,
          11352 => Opcode::PseudoVWADDU_WV_MF4_MASK,
          11353 => Opcode::PseudoVWADDU_WV_MF4_MASK_TIED,
          11354 => Opcode::PseudoVWADDU_WV_MF4_TIED,
          11355 => Opcode::PseudoVWADDU_WV_MF8,
          11356 => Opcode::PseudoVWADDU_WV_MF8_MASK,
          11357 => Opcode::PseudoVWADDU_WV_MF8_MASK_TIED,
          11358 => Opcode::PseudoVWADDU_WV_MF8_TIED,
          11359 => Opcode::PseudoVWADDU_WX_M1,
          11360 => Opcode::PseudoVWADDU_WX_M1_MASK,
          11361 => Opcode::PseudoVWADDU_WX_M2,
          11362 => Opcode::PseudoVWADDU_WX_M2_MASK,
          11363 => Opcode::PseudoVWADDU_WX_M4,
          11364 => Opcode::PseudoVWADDU_WX_M4_MASK,
          11365 => Opcode::PseudoVWADDU_WX_MF2,
          11366 => Opcode::PseudoVWADDU_WX_MF2_MASK,
          11367 => Opcode::PseudoVWADDU_WX_MF4,
          11368 => Opcode::PseudoVWADDU_WX_MF4_MASK,
          11369 => Opcode::PseudoVWADDU_WX_MF8,
          11370 => Opcode::PseudoVWADDU_WX_MF8_MASK,
          11371 => Opcode::PseudoVWADD_VV_M1,
          11372 => Opcode::PseudoVWADD_VV_M1_MASK,
          11373 => Opcode::PseudoVWADD_VV_M2,
          11374 => Opcode::PseudoVWADD_VV_M2_MASK,
          11375 => Opcode::PseudoVWADD_VV_M4,
          11376 => Opcode::PseudoVWADD_VV_M4_MASK,
          11377 => Opcode::PseudoVWADD_VV_MF2,
          11378 => Opcode::PseudoVWADD_VV_MF2_MASK,
          11379 => Opcode::PseudoVWADD_VV_MF4,
          11380 => Opcode::PseudoVWADD_VV_MF4_MASK,
          11381 => Opcode::PseudoVWADD_VV_MF8,
          11382 => Opcode::PseudoVWADD_VV_MF8_MASK,
          11383 => Opcode::PseudoVWADD_VX_M1,
          11384 => Opcode::PseudoVWADD_VX_M1_MASK,
          11385 => Opcode::PseudoVWADD_VX_M2,
          11386 => Opcode::PseudoVWADD_VX_M2_MASK,
          11387 => Opcode::PseudoVWADD_VX_M4,
          11388 => Opcode::PseudoVWADD_VX_M4_MASK,
          11389 => Opcode::PseudoVWADD_VX_MF2,
          11390 => Opcode::PseudoVWADD_VX_MF2_MASK,
          11391 => Opcode::PseudoVWADD_VX_MF4,
          11392 => Opcode::PseudoVWADD_VX_MF4_MASK,
          11393 => Opcode::PseudoVWADD_VX_MF8,
          11394 => Opcode::PseudoVWADD_VX_MF8_MASK,
          11395 => Opcode::PseudoVWADD_WV_M1,
          11396 => Opcode::PseudoVWADD_WV_M1_MASK,
          11397 => Opcode::PseudoVWADD_WV_M1_MASK_TIED,
          11398 => Opcode::PseudoVWADD_WV_M1_TIED,
          11399 => Opcode::PseudoVWADD_WV_M2,
          11400 => Opcode::PseudoVWADD_WV_M2_MASK,
          11401 => Opcode::PseudoVWADD_WV_M2_MASK_TIED,
          11402 => Opcode::PseudoVWADD_WV_M2_TIED,
          11403 => Opcode::PseudoVWADD_WV_M4,
          11404 => Opcode::PseudoVWADD_WV_M4_MASK,
          11405 => Opcode::PseudoVWADD_WV_M4_MASK_TIED,
          11406 => Opcode::PseudoVWADD_WV_M4_TIED,
          11407 => Opcode::PseudoVWADD_WV_MF2,
          11408 => Opcode::PseudoVWADD_WV_MF2_MASK,
          11409 => Opcode::PseudoVWADD_WV_MF2_MASK_TIED,
          11410 => Opcode::PseudoVWADD_WV_MF2_TIED,
          11411 => Opcode::PseudoVWADD_WV_MF4,
          11412 => Opcode::PseudoVWADD_WV_MF4_MASK,
          11413 => Opcode::PseudoVWADD_WV_MF4_MASK_TIED,
          11414 => Opcode::PseudoVWADD_WV_MF4_TIED,
          11415 => Opcode::PseudoVWADD_WV_MF8,
          11416 => Opcode::PseudoVWADD_WV_MF8_MASK,
          11417 => Opcode::PseudoVWADD_WV_MF8_MASK_TIED,
          11418 => Opcode::PseudoVWADD_WV_MF8_TIED,
          11419 => Opcode::PseudoVWADD_WX_M1,
          11420 => Opcode::PseudoVWADD_WX_M1_MASK,
          11421 => Opcode::PseudoVWADD_WX_M2,
          11422 => Opcode::PseudoVWADD_WX_M2_MASK,
          11423 => Opcode::PseudoVWADD_WX_M4,
          11424 => Opcode::PseudoVWADD_WX_M4_MASK,
          11425 => Opcode::PseudoVWADD_WX_MF2,
          11426 => Opcode::PseudoVWADD_WX_MF2_MASK,
          11427 => Opcode::PseudoVWADD_WX_MF4,
          11428 => Opcode::PseudoVWADD_WX_MF4_MASK,
          11429 => Opcode::PseudoVWADD_WX_MF8,
          11430 => Opcode::PseudoVWADD_WX_MF8_MASK,
          11431 => Opcode::PseudoVWMACCSU_VV_M1,
          11432 => Opcode::PseudoVWMACCSU_VV_M1_MASK,
          11433 => Opcode::PseudoVWMACCSU_VV_M2,
          11434 => Opcode::PseudoVWMACCSU_VV_M2_MASK,
          11435 => Opcode::PseudoVWMACCSU_VV_M4,
          11436 => Opcode::PseudoVWMACCSU_VV_M4_MASK,
          11437 => Opcode::PseudoVWMACCSU_VV_MF2,
          11438 => Opcode::PseudoVWMACCSU_VV_MF2_MASK,
          11439 => Opcode::PseudoVWMACCSU_VV_MF4,
          11440 => Opcode::PseudoVWMACCSU_VV_MF4_MASK,
          11441 => Opcode::PseudoVWMACCSU_VV_MF8,
          11442 => Opcode::PseudoVWMACCSU_VV_MF8_MASK,
          11443 => Opcode::PseudoVWMACCSU_VX_M1,
          11444 => Opcode::PseudoVWMACCSU_VX_M1_MASK,
          11445 => Opcode::PseudoVWMACCSU_VX_M2,
          11446 => Opcode::PseudoVWMACCSU_VX_M2_MASK,
          11447 => Opcode::PseudoVWMACCSU_VX_M4,
          11448 => Opcode::PseudoVWMACCSU_VX_M4_MASK,
          11449 => Opcode::PseudoVWMACCSU_VX_MF2,
          11450 => Opcode::PseudoVWMACCSU_VX_MF2_MASK,
          11451 => Opcode::PseudoVWMACCSU_VX_MF4,
          11452 => Opcode::PseudoVWMACCSU_VX_MF4_MASK,
          11453 => Opcode::PseudoVWMACCSU_VX_MF8,
          11454 => Opcode::PseudoVWMACCSU_VX_MF8_MASK,
          11455 => Opcode::PseudoVWMACCUS_VX_M1,
          11456 => Opcode::PseudoVWMACCUS_VX_M1_MASK,
          11457 => Opcode::PseudoVWMACCUS_VX_M2,
          11458 => Opcode::PseudoVWMACCUS_VX_M2_MASK,
          11459 => Opcode::PseudoVWMACCUS_VX_M4,
          11460 => Opcode::PseudoVWMACCUS_VX_M4_MASK,
          11461 => Opcode::PseudoVWMACCUS_VX_MF2,
          11462 => Opcode::PseudoVWMACCUS_VX_MF2_MASK,
          11463 => Opcode::PseudoVWMACCUS_VX_MF4,
          11464 => Opcode::PseudoVWMACCUS_VX_MF4_MASK,
          11465 => Opcode::PseudoVWMACCUS_VX_MF8,
          11466 => Opcode::PseudoVWMACCUS_VX_MF8_MASK,
          11467 => Opcode::PseudoVWMACCU_VV_M1,
          11468 => Opcode::PseudoVWMACCU_VV_M1_MASK,
          11469 => Opcode::PseudoVWMACCU_VV_M2,
          11470 => Opcode::PseudoVWMACCU_VV_M2_MASK,
          11471 => Opcode::PseudoVWMACCU_VV_M4,
          11472 => Opcode::PseudoVWMACCU_VV_M4_MASK,
          11473 => Opcode::PseudoVWMACCU_VV_MF2,
          11474 => Opcode::PseudoVWMACCU_VV_MF2_MASK,
          11475 => Opcode::PseudoVWMACCU_VV_MF4,
          11476 => Opcode::PseudoVWMACCU_VV_MF4_MASK,
          11477 => Opcode::PseudoVWMACCU_VV_MF8,
          11478 => Opcode::PseudoVWMACCU_VV_MF8_MASK,
          11479 => Opcode::PseudoVWMACCU_VX_M1,
          11480 => Opcode::PseudoVWMACCU_VX_M1_MASK,
          11481 => Opcode::PseudoVWMACCU_VX_M2,
          11482 => Opcode::PseudoVWMACCU_VX_M2_MASK,
          11483 => Opcode::PseudoVWMACCU_VX_M4,
          11484 => Opcode::PseudoVWMACCU_VX_M4_MASK,
          11485 => Opcode::PseudoVWMACCU_VX_MF2,
          11486 => Opcode::PseudoVWMACCU_VX_MF2_MASK,
          11487 => Opcode::PseudoVWMACCU_VX_MF4,
          11488 => Opcode::PseudoVWMACCU_VX_MF4_MASK,
          11489 => Opcode::PseudoVWMACCU_VX_MF8,
          11490 => Opcode::PseudoVWMACCU_VX_MF8_MASK,
          11491 => Opcode::PseudoVWMACC_VV_M1,
          11492 => Opcode::PseudoVWMACC_VV_M1_MASK,
          11493 => Opcode::PseudoVWMACC_VV_M2,
          11494 => Opcode::PseudoVWMACC_VV_M2_MASK,
          11495 => Opcode::PseudoVWMACC_VV_M4,
          11496 => Opcode::PseudoVWMACC_VV_M4_MASK,
          11497 => Opcode::PseudoVWMACC_VV_MF2,
          11498 => Opcode::PseudoVWMACC_VV_MF2_MASK,
          11499 => Opcode::PseudoVWMACC_VV_MF4,
          11500 => Opcode::PseudoVWMACC_VV_MF4_MASK,
          11501 => Opcode::PseudoVWMACC_VV_MF8,
          11502 => Opcode::PseudoVWMACC_VV_MF8_MASK,
          11503 => Opcode::PseudoVWMACC_VX_M1,
          11504 => Opcode::PseudoVWMACC_VX_M1_MASK,
          11505 => Opcode::PseudoVWMACC_VX_M2,
          11506 => Opcode::PseudoVWMACC_VX_M2_MASK,
          11507 => Opcode::PseudoVWMACC_VX_M4,
          11508 => Opcode::PseudoVWMACC_VX_M4_MASK,
          11509 => Opcode::PseudoVWMACC_VX_MF2,
          11510 => Opcode::PseudoVWMACC_VX_MF2_MASK,
          11511 => Opcode::PseudoVWMACC_VX_MF4,
          11512 => Opcode::PseudoVWMACC_VX_MF4_MASK,
          11513 => Opcode::PseudoVWMACC_VX_MF8,
          11514 => Opcode::PseudoVWMACC_VX_MF8_MASK,
          11515 => Opcode::PseudoVWMULSU_VV_M1,
          11516 => Opcode::PseudoVWMULSU_VV_M1_MASK,
          11517 => Opcode::PseudoVWMULSU_VV_M2,
          11518 => Opcode::PseudoVWMULSU_VV_M2_MASK,
          11519 => Opcode::PseudoVWMULSU_VV_M4,
          11520 => Opcode::PseudoVWMULSU_VV_M4_MASK,
          11521 => Opcode::PseudoVWMULSU_VV_MF2,
          11522 => Opcode::PseudoVWMULSU_VV_MF2_MASK,
          11523 => Opcode::PseudoVWMULSU_VV_MF4,
          11524 => Opcode::PseudoVWMULSU_VV_MF4_MASK,
          11525 => Opcode::PseudoVWMULSU_VV_MF8,
          11526 => Opcode::PseudoVWMULSU_VV_MF8_MASK,
          11527 => Opcode::PseudoVWMULSU_VX_M1,
          11528 => Opcode::PseudoVWMULSU_VX_M1_MASK,
          11529 => Opcode::PseudoVWMULSU_VX_M2,
          11530 => Opcode::PseudoVWMULSU_VX_M2_MASK,
          11531 => Opcode::PseudoVWMULSU_VX_M4,
          11532 => Opcode::PseudoVWMULSU_VX_M4_MASK,
          11533 => Opcode::PseudoVWMULSU_VX_MF2,
          11534 => Opcode::PseudoVWMULSU_VX_MF2_MASK,
          11535 => Opcode::PseudoVWMULSU_VX_MF4,
          11536 => Opcode::PseudoVWMULSU_VX_MF4_MASK,
          11537 => Opcode::PseudoVWMULSU_VX_MF8,
          11538 => Opcode::PseudoVWMULSU_VX_MF8_MASK,
          11539 => Opcode::PseudoVWMULU_VV_M1,
          11540 => Opcode::PseudoVWMULU_VV_M1_MASK,
          11541 => Opcode::PseudoVWMULU_VV_M2,
          11542 => Opcode::PseudoVWMULU_VV_M2_MASK,
          11543 => Opcode::PseudoVWMULU_VV_M4,
          11544 => Opcode::PseudoVWMULU_VV_M4_MASK,
          11545 => Opcode::PseudoVWMULU_VV_MF2,
          11546 => Opcode::PseudoVWMULU_VV_MF2_MASK,
          11547 => Opcode::PseudoVWMULU_VV_MF4,
          11548 => Opcode::PseudoVWMULU_VV_MF4_MASK,
          11549 => Opcode::PseudoVWMULU_VV_MF8,
          11550 => Opcode::PseudoVWMULU_VV_MF8_MASK,
          11551 => Opcode::PseudoVWMULU_VX_M1,
          11552 => Opcode::PseudoVWMULU_VX_M1_MASK,
          11553 => Opcode::PseudoVWMULU_VX_M2,
          11554 => Opcode::PseudoVWMULU_VX_M2_MASK,
          11555 => Opcode::PseudoVWMULU_VX_M4,
          11556 => Opcode::PseudoVWMULU_VX_M4_MASK,
          11557 => Opcode::PseudoVWMULU_VX_MF2,
          11558 => Opcode::PseudoVWMULU_VX_MF2_MASK,
          11559 => Opcode::PseudoVWMULU_VX_MF4,
          11560 => Opcode::PseudoVWMULU_VX_MF4_MASK,
          11561 => Opcode::PseudoVWMULU_VX_MF8,
          11562 => Opcode::PseudoVWMULU_VX_MF8_MASK,
          11563 => Opcode::PseudoVWMUL_VV_M1,
          11564 => Opcode::PseudoVWMUL_VV_M1_MASK,
          11565 => Opcode::PseudoVWMUL_VV_M2,
          11566 => Opcode::PseudoVWMUL_VV_M2_MASK,
          11567 => Opcode::PseudoVWMUL_VV_M4,
          11568 => Opcode::PseudoVWMUL_VV_M4_MASK,
          11569 => Opcode::PseudoVWMUL_VV_MF2,
          11570 => Opcode::PseudoVWMUL_VV_MF2_MASK,
          11571 => Opcode::PseudoVWMUL_VV_MF4,
          11572 => Opcode::PseudoVWMUL_VV_MF4_MASK,
          11573 => Opcode::PseudoVWMUL_VV_MF8,
          11574 => Opcode::PseudoVWMUL_VV_MF8_MASK,
          11575 => Opcode::PseudoVWMUL_VX_M1,
          11576 => Opcode::PseudoVWMUL_VX_M1_MASK,
          11577 => Opcode::PseudoVWMUL_VX_M2,
          11578 => Opcode::PseudoVWMUL_VX_M2_MASK,
          11579 => Opcode::PseudoVWMUL_VX_M4,
          11580 => Opcode::PseudoVWMUL_VX_M4_MASK,
          11581 => Opcode::PseudoVWMUL_VX_MF2,
          11582 => Opcode::PseudoVWMUL_VX_MF2_MASK,
          11583 => Opcode::PseudoVWMUL_VX_MF4,
          11584 => Opcode::PseudoVWMUL_VX_MF4_MASK,
          11585 => Opcode::PseudoVWMUL_VX_MF8,
          11586 => Opcode::PseudoVWMUL_VX_MF8_MASK,
          11587 => Opcode::PseudoVWREDSUMU_VS_M1_E16,
          11588 => Opcode::PseudoVWREDSUMU_VS_M1_E16_MASK,
          11589 => Opcode::PseudoVWREDSUMU_VS_M1_E32,
          11590 => Opcode::PseudoVWREDSUMU_VS_M1_E32_MASK,
          11591 => Opcode::PseudoVWREDSUMU_VS_M1_E8,
          11592 => Opcode::PseudoVWREDSUMU_VS_M1_E8_MASK,
          11593 => Opcode::PseudoVWREDSUMU_VS_M2_E16,
          11594 => Opcode::PseudoVWREDSUMU_VS_M2_E16_MASK,
          11595 => Opcode::PseudoVWREDSUMU_VS_M2_E32,
          11596 => Opcode::PseudoVWREDSUMU_VS_M2_E32_MASK,
          11597 => Opcode::PseudoVWREDSUMU_VS_M2_E8,
          11598 => Opcode::PseudoVWREDSUMU_VS_M2_E8_MASK,
          11599 => Opcode::PseudoVWREDSUMU_VS_M4_E16,
          11600 => Opcode::PseudoVWREDSUMU_VS_M4_E16_MASK,
          11601 => Opcode::PseudoVWREDSUMU_VS_M4_E32,
          11602 => Opcode::PseudoVWREDSUMU_VS_M4_E32_MASK,
          11603 => Opcode::PseudoVWREDSUMU_VS_M4_E8,
          11604 => Opcode::PseudoVWREDSUMU_VS_M4_E8_MASK,
          11605 => Opcode::PseudoVWREDSUMU_VS_M8_E16,
          11606 => Opcode::PseudoVWREDSUMU_VS_M8_E16_MASK,
          11607 => Opcode::PseudoVWREDSUMU_VS_M8_E32,
          11608 => Opcode::PseudoVWREDSUMU_VS_M8_E32_MASK,
          11609 => Opcode::PseudoVWREDSUMU_VS_M8_E8,
          11610 => Opcode::PseudoVWREDSUMU_VS_M8_E8_MASK,
          11611 => Opcode::PseudoVWREDSUMU_VS_MF2_E16,
          11612 => Opcode::PseudoVWREDSUMU_VS_MF2_E16_MASK,
          11613 => Opcode::PseudoVWREDSUMU_VS_MF2_E32,
          11614 => Opcode::PseudoVWREDSUMU_VS_MF2_E32_MASK,
          11615 => Opcode::PseudoVWREDSUMU_VS_MF2_E8,
          11616 => Opcode::PseudoVWREDSUMU_VS_MF2_E8_MASK,
          11617 => Opcode::PseudoVWREDSUMU_VS_MF4_E16,
          11618 => Opcode::PseudoVWREDSUMU_VS_MF4_E16_MASK,
          11619 => Opcode::PseudoVWREDSUMU_VS_MF4_E8,
          11620 => Opcode::PseudoVWREDSUMU_VS_MF4_E8_MASK,
          11621 => Opcode::PseudoVWREDSUMU_VS_MF8_E8,
          11622 => Opcode::PseudoVWREDSUMU_VS_MF8_E8_MASK,
          11623 => Opcode::PseudoVWREDSUM_VS_M1_E16,
          11624 => Opcode::PseudoVWREDSUM_VS_M1_E16_MASK,
          11625 => Opcode::PseudoVWREDSUM_VS_M1_E32,
          11626 => Opcode::PseudoVWREDSUM_VS_M1_E32_MASK,
          11627 => Opcode::PseudoVWREDSUM_VS_M1_E8,
          11628 => Opcode::PseudoVWREDSUM_VS_M1_E8_MASK,
          11629 => Opcode::PseudoVWREDSUM_VS_M2_E16,
          11630 => Opcode::PseudoVWREDSUM_VS_M2_E16_MASK,
          11631 => Opcode::PseudoVWREDSUM_VS_M2_E32,
          11632 => Opcode::PseudoVWREDSUM_VS_M2_E32_MASK,
          11633 => Opcode::PseudoVWREDSUM_VS_M2_E8,
          11634 => Opcode::PseudoVWREDSUM_VS_M2_E8_MASK,
          11635 => Opcode::PseudoVWREDSUM_VS_M4_E16,
          11636 => Opcode::PseudoVWREDSUM_VS_M4_E16_MASK,
          11637 => Opcode::PseudoVWREDSUM_VS_M4_E32,
          11638 => Opcode::PseudoVWREDSUM_VS_M4_E32_MASK,
          11639 => Opcode::PseudoVWREDSUM_VS_M4_E8,
          11640 => Opcode::PseudoVWREDSUM_VS_M4_E8_MASK,
          11641 => Opcode::PseudoVWREDSUM_VS_M8_E16,
          11642 => Opcode::PseudoVWREDSUM_VS_M8_E16_MASK,
          11643 => Opcode::PseudoVWREDSUM_VS_M8_E32,
          11644 => Opcode::PseudoVWREDSUM_VS_M8_E32_MASK,
          11645 => Opcode::PseudoVWREDSUM_VS_M8_E8,
          11646 => Opcode::PseudoVWREDSUM_VS_M8_E8_MASK,
          11647 => Opcode::PseudoVWREDSUM_VS_MF2_E16,
          11648 => Opcode::PseudoVWREDSUM_VS_MF2_E16_MASK,
          11649 => Opcode::PseudoVWREDSUM_VS_MF2_E32,
          11650 => Opcode::PseudoVWREDSUM_VS_MF2_E32_MASK,
          11651 => Opcode::PseudoVWREDSUM_VS_MF2_E8,
          11652 => Opcode::PseudoVWREDSUM_VS_MF2_E8_MASK,
          11653 => Opcode::PseudoVWREDSUM_VS_MF4_E16,
          11654 => Opcode::PseudoVWREDSUM_VS_MF4_E16_MASK,
          11655 => Opcode::PseudoVWREDSUM_VS_MF4_E8,
          11656 => Opcode::PseudoVWREDSUM_VS_MF4_E8_MASK,
          11657 => Opcode::PseudoVWREDSUM_VS_MF8_E8,
          11658 => Opcode::PseudoVWREDSUM_VS_MF8_E8_MASK,
          11659 => Opcode::PseudoVWSLL_VI_M1,
          11660 => Opcode::PseudoVWSLL_VI_M1_MASK,
          11661 => Opcode::PseudoVWSLL_VI_M2,
          11662 => Opcode::PseudoVWSLL_VI_M2_MASK,
          11663 => Opcode::PseudoVWSLL_VI_M4,
          11664 => Opcode::PseudoVWSLL_VI_M4_MASK,
          11665 => Opcode::PseudoVWSLL_VI_MF2,
          11666 => Opcode::PseudoVWSLL_VI_MF2_MASK,
          11667 => Opcode::PseudoVWSLL_VI_MF4,
          11668 => Opcode::PseudoVWSLL_VI_MF4_MASK,
          11669 => Opcode::PseudoVWSLL_VI_MF8,
          11670 => Opcode::PseudoVWSLL_VI_MF8_MASK,
          11671 => Opcode::PseudoVWSLL_VV_M1,
          11672 => Opcode::PseudoVWSLL_VV_M1_MASK,
          11673 => Opcode::PseudoVWSLL_VV_M2,
          11674 => Opcode::PseudoVWSLL_VV_M2_MASK,
          11675 => Opcode::PseudoVWSLL_VV_M4,
          11676 => Opcode::PseudoVWSLL_VV_M4_MASK,
          11677 => Opcode::PseudoVWSLL_VV_MF2,
          11678 => Opcode::PseudoVWSLL_VV_MF2_MASK,
          11679 => Opcode::PseudoVWSLL_VV_MF4,
          11680 => Opcode::PseudoVWSLL_VV_MF4_MASK,
          11681 => Opcode::PseudoVWSLL_VV_MF8,
          11682 => Opcode::PseudoVWSLL_VV_MF8_MASK,
          11683 => Opcode::PseudoVWSLL_VX_M1,
          11684 => Opcode::PseudoVWSLL_VX_M1_MASK,
          11685 => Opcode::PseudoVWSLL_VX_M2,
          11686 => Opcode::PseudoVWSLL_VX_M2_MASK,
          11687 => Opcode::PseudoVWSLL_VX_M4,
          11688 => Opcode::PseudoVWSLL_VX_M4_MASK,
          11689 => Opcode::PseudoVWSLL_VX_MF2,
          11690 => Opcode::PseudoVWSLL_VX_MF2_MASK,
          11691 => Opcode::PseudoVWSLL_VX_MF4,
          11692 => Opcode::PseudoVWSLL_VX_MF4_MASK,
          11693 => Opcode::PseudoVWSLL_VX_MF8,
          11694 => Opcode::PseudoVWSLL_VX_MF8_MASK,
          11695 => Opcode::PseudoVWSUBU_VV_M1,
          11696 => Opcode::PseudoVWSUBU_VV_M1_MASK,
          11697 => Opcode::PseudoVWSUBU_VV_M2,
          11698 => Opcode::PseudoVWSUBU_VV_M2_MASK,
          11699 => Opcode::PseudoVWSUBU_VV_M4,
          11700 => Opcode::PseudoVWSUBU_VV_M4_MASK,
          11701 => Opcode::PseudoVWSUBU_VV_MF2,
          11702 => Opcode::PseudoVWSUBU_VV_MF2_MASK,
          11703 => Opcode::PseudoVWSUBU_VV_MF4,
          11704 => Opcode::PseudoVWSUBU_VV_MF4_MASK,
          11705 => Opcode::PseudoVWSUBU_VV_MF8,
          11706 => Opcode::PseudoVWSUBU_VV_MF8_MASK,
          11707 => Opcode::PseudoVWSUBU_VX_M1,
          11708 => Opcode::PseudoVWSUBU_VX_M1_MASK,
          11709 => Opcode::PseudoVWSUBU_VX_M2,
          11710 => Opcode::PseudoVWSUBU_VX_M2_MASK,
          11711 => Opcode::PseudoVWSUBU_VX_M4,
          11712 => Opcode::PseudoVWSUBU_VX_M4_MASK,
          11713 => Opcode::PseudoVWSUBU_VX_MF2,
          11714 => Opcode::PseudoVWSUBU_VX_MF2_MASK,
          11715 => Opcode::PseudoVWSUBU_VX_MF4,
          11716 => Opcode::PseudoVWSUBU_VX_MF4_MASK,
          11717 => Opcode::PseudoVWSUBU_VX_MF8,
          11718 => Opcode::PseudoVWSUBU_VX_MF8_MASK,
          11719 => Opcode::PseudoVWSUBU_WV_M1,
          11720 => Opcode::PseudoVWSUBU_WV_M1_MASK,
          11721 => Opcode::PseudoVWSUBU_WV_M1_MASK_TIED,
          11722 => Opcode::PseudoVWSUBU_WV_M1_TIED,
          11723 => Opcode::PseudoVWSUBU_WV_M2,
          11724 => Opcode::PseudoVWSUBU_WV_M2_MASK,
          11725 => Opcode::PseudoVWSUBU_WV_M2_MASK_TIED,
          11726 => Opcode::PseudoVWSUBU_WV_M2_TIED,
          11727 => Opcode::PseudoVWSUBU_WV_M4,
          11728 => Opcode::PseudoVWSUBU_WV_M4_MASK,
          11729 => Opcode::PseudoVWSUBU_WV_M4_MASK_TIED,
          11730 => Opcode::PseudoVWSUBU_WV_M4_TIED,
          11731 => Opcode::PseudoVWSUBU_WV_MF2,
          11732 => Opcode::PseudoVWSUBU_WV_MF2_MASK,
          11733 => Opcode::PseudoVWSUBU_WV_MF2_MASK_TIED,
          11734 => Opcode::PseudoVWSUBU_WV_MF2_TIED,
          11735 => Opcode::PseudoVWSUBU_WV_MF4,
          11736 => Opcode::PseudoVWSUBU_WV_MF4_MASK,
          11737 => Opcode::PseudoVWSUBU_WV_MF4_MASK_TIED,
          11738 => Opcode::PseudoVWSUBU_WV_MF4_TIED,
          11739 => Opcode::PseudoVWSUBU_WV_MF8,
          11740 => Opcode::PseudoVWSUBU_WV_MF8_MASK,
          11741 => Opcode::PseudoVWSUBU_WV_MF8_MASK_TIED,
          11742 => Opcode::PseudoVWSUBU_WV_MF8_TIED,
          11743 => Opcode::PseudoVWSUBU_WX_M1,
          11744 => Opcode::PseudoVWSUBU_WX_M1_MASK,
          11745 => Opcode::PseudoVWSUBU_WX_M2,
          11746 => Opcode::PseudoVWSUBU_WX_M2_MASK,
          11747 => Opcode::PseudoVWSUBU_WX_M4,
          11748 => Opcode::PseudoVWSUBU_WX_M4_MASK,
          11749 => Opcode::PseudoVWSUBU_WX_MF2,
          11750 => Opcode::PseudoVWSUBU_WX_MF2_MASK,
          11751 => Opcode::PseudoVWSUBU_WX_MF4,
          11752 => Opcode::PseudoVWSUBU_WX_MF4_MASK,
          11753 => Opcode::PseudoVWSUBU_WX_MF8,
          11754 => Opcode::PseudoVWSUBU_WX_MF8_MASK,
          11755 => Opcode::PseudoVWSUB_VV_M1,
          11756 => Opcode::PseudoVWSUB_VV_M1_MASK,
          11757 => Opcode::PseudoVWSUB_VV_M2,
          11758 => Opcode::PseudoVWSUB_VV_M2_MASK,
          11759 => Opcode::PseudoVWSUB_VV_M4,
          11760 => Opcode::PseudoVWSUB_VV_M4_MASK,
          11761 => Opcode::PseudoVWSUB_VV_MF2,
          11762 => Opcode::PseudoVWSUB_VV_MF2_MASK,
          11763 => Opcode::PseudoVWSUB_VV_MF4,
          11764 => Opcode::PseudoVWSUB_VV_MF4_MASK,
          11765 => Opcode::PseudoVWSUB_VV_MF8,
          11766 => Opcode::PseudoVWSUB_VV_MF8_MASK,
          11767 => Opcode::PseudoVWSUB_VX_M1,
          11768 => Opcode::PseudoVWSUB_VX_M1_MASK,
          11769 => Opcode::PseudoVWSUB_VX_M2,
          11770 => Opcode::PseudoVWSUB_VX_M2_MASK,
          11771 => Opcode::PseudoVWSUB_VX_M4,
          11772 => Opcode::PseudoVWSUB_VX_M4_MASK,
          11773 => Opcode::PseudoVWSUB_VX_MF2,
          11774 => Opcode::PseudoVWSUB_VX_MF2_MASK,
          11775 => Opcode::PseudoVWSUB_VX_MF4,
          11776 => Opcode::PseudoVWSUB_VX_MF4_MASK,
          11777 => Opcode::PseudoVWSUB_VX_MF8,
          11778 => Opcode::PseudoVWSUB_VX_MF8_MASK,
          11779 => Opcode::PseudoVWSUB_WV_M1,
          11780 => Opcode::PseudoVWSUB_WV_M1_MASK,
          11781 => Opcode::PseudoVWSUB_WV_M1_MASK_TIED,
          11782 => Opcode::PseudoVWSUB_WV_M1_TIED,
          11783 => Opcode::PseudoVWSUB_WV_M2,
          11784 => Opcode::PseudoVWSUB_WV_M2_MASK,
          11785 => Opcode::PseudoVWSUB_WV_M2_MASK_TIED,
          11786 => Opcode::PseudoVWSUB_WV_M2_TIED,
          11787 => Opcode::PseudoVWSUB_WV_M4,
          11788 => Opcode::PseudoVWSUB_WV_M4_MASK,
          11789 => Opcode::PseudoVWSUB_WV_M4_MASK_TIED,
          11790 => Opcode::PseudoVWSUB_WV_M4_TIED,
          11791 => Opcode::PseudoVWSUB_WV_MF2,
          11792 => Opcode::PseudoVWSUB_WV_MF2_MASK,
          11793 => Opcode::PseudoVWSUB_WV_MF2_MASK_TIED,
          11794 => Opcode::PseudoVWSUB_WV_MF2_TIED,
          11795 => Opcode::PseudoVWSUB_WV_MF4,
          11796 => Opcode::PseudoVWSUB_WV_MF4_MASK,
          11797 => Opcode::PseudoVWSUB_WV_MF4_MASK_TIED,
          11798 => Opcode::PseudoVWSUB_WV_MF4_TIED,
          11799 => Opcode::PseudoVWSUB_WV_MF8,
          11800 => Opcode::PseudoVWSUB_WV_MF8_MASK,
          11801 => Opcode::PseudoVWSUB_WV_MF8_MASK_TIED,
          11802 => Opcode::PseudoVWSUB_WV_MF8_TIED,
          11803 => Opcode::PseudoVWSUB_WX_M1,
          11804 => Opcode::PseudoVWSUB_WX_M1_MASK,
          11805 => Opcode::PseudoVWSUB_WX_M2,
          11806 => Opcode::PseudoVWSUB_WX_M2_MASK,
          11807 => Opcode::PseudoVWSUB_WX_M4,
          11808 => Opcode::PseudoVWSUB_WX_M4_MASK,
          11809 => Opcode::PseudoVWSUB_WX_MF2,
          11810 => Opcode::PseudoVWSUB_WX_MF2_MASK,
          11811 => Opcode::PseudoVWSUB_WX_MF4,
          11812 => Opcode::PseudoVWSUB_WX_MF4_MASK,
          11813 => Opcode::PseudoVWSUB_WX_MF8,
          11814 => Opcode::PseudoVWSUB_WX_MF8_MASK,
          11815 => Opcode::PseudoVXOR_VI_M1,
          11816 => Opcode::PseudoVXOR_VI_M1_MASK,
          11817 => Opcode::PseudoVXOR_VI_M2,
          11818 => Opcode::PseudoVXOR_VI_M2_MASK,
          11819 => Opcode::PseudoVXOR_VI_M4,
          11820 => Opcode::PseudoVXOR_VI_M4_MASK,
          11821 => Opcode::PseudoVXOR_VI_M8,
          11822 => Opcode::PseudoVXOR_VI_M8_MASK,
          11823 => Opcode::PseudoVXOR_VI_MF2,
          11824 => Opcode::PseudoVXOR_VI_MF2_MASK,
          11825 => Opcode::PseudoVXOR_VI_MF4,
          11826 => Opcode::PseudoVXOR_VI_MF4_MASK,
          11827 => Opcode::PseudoVXOR_VI_MF8,
          11828 => Opcode::PseudoVXOR_VI_MF8_MASK,
          11829 => Opcode::PseudoVXOR_VV_M1,
          11830 => Opcode::PseudoVXOR_VV_M1_MASK,
          11831 => Opcode::PseudoVXOR_VV_M2,
          11832 => Opcode::PseudoVXOR_VV_M2_MASK,
          11833 => Opcode::PseudoVXOR_VV_M4,
          11834 => Opcode::PseudoVXOR_VV_M4_MASK,
          11835 => Opcode::PseudoVXOR_VV_M8,
          11836 => Opcode::PseudoVXOR_VV_M8_MASK,
          11837 => Opcode::PseudoVXOR_VV_MF2,
          11838 => Opcode::PseudoVXOR_VV_MF2_MASK,
          11839 => Opcode::PseudoVXOR_VV_MF4,
          11840 => Opcode::PseudoVXOR_VV_MF4_MASK,
          11841 => Opcode::PseudoVXOR_VV_MF8,
          11842 => Opcode::PseudoVXOR_VV_MF8_MASK,
          11843 => Opcode::PseudoVXOR_VX_M1,
          11844 => Opcode::PseudoVXOR_VX_M1_MASK,
          11845 => Opcode::PseudoVXOR_VX_M2,
          11846 => Opcode::PseudoVXOR_VX_M2_MASK,
          11847 => Opcode::PseudoVXOR_VX_M4,
          11848 => Opcode::PseudoVXOR_VX_M4_MASK,
          11849 => Opcode::PseudoVXOR_VX_M8,
          11850 => Opcode::PseudoVXOR_VX_M8_MASK,
          11851 => Opcode::PseudoVXOR_VX_MF2,
          11852 => Opcode::PseudoVXOR_VX_MF2_MASK,
          11853 => Opcode::PseudoVXOR_VX_MF4,
          11854 => Opcode::PseudoVXOR_VX_MF4_MASK,
          11855 => Opcode::PseudoVXOR_VX_MF8,
          11856 => Opcode::PseudoVXOR_VX_MF8_MASK,
          11857 => Opcode::PseudoVZEXT_VF2_M1,
          11858 => Opcode::PseudoVZEXT_VF2_M1_MASK,
          11859 => Opcode::PseudoVZEXT_VF2_M2,
          11860 => Opcode::PseudoVZEXT_VF2_M2_MASK,
          11861 => Opcode::PseudoVZEXT_VF2_M4,
          11862 => Opcode::PseudoVZEXT_VF2_M4_MASK,
          11863 => Opcode::PseudoVZEXT_VF2_M8,
          11864 => Opcode::PseudoVZEXT_VF2_M8_MASK,
          11865 => Opcode::PseudoVZEXT_VF2_MF2,
          11866 => Opcode::PseudoVZEXT_VF2_MF2_MASK,
          11867 => Opcode::PseudoVZEXT_VF2_MF4,
          11868 => Opcode::PseudoVZEXT_VF2_MF4_MASK,
          11869 => Opcode::PseudoVZEXT_VF4_M1,
          11870 => Opcode::PseudoVZEXT_VF4_M1_MASK,
          11871 => Opcode::PseudoVZEXT_VF4_M2,
          11872 => Opcode::PseudoVZEXT_VF4_M2_MASK,
          11873 => Opcode::PseudoVZEXT_VF4_M4,
          11874 => Opcode::PseudoVZEXT_VF4_M4_MASK,
          11875 => Opcode::PseudoVZEXT_VF4_M8,
          11876 => Opcode::PseudoVZEXT_VF4_M8_MASK,
          11877 => Opcode::PseudoVZEXT_VF4_MF2,
          11878 => Opcode::PseudoVZEXT_VF4_MF2_MASK,
          11879 => Opcode::PseudoVZEXT_VF8_M1,
          11880 => Opcode::PseudoVZEXT_VF8_M1_MASK,
          11881 => Opcode::PseudoVZEXT_VF8_M2,
          11882 => Opcode::PseudoVZEXT_VF8_M2_MASK,
          11883 => Opcode::PseudoVZEXT_VF8_M4,
          11884 => Opcode::PseudoVZEXT_VF8_M4_MASK,
          11885 => Opcode::PseudoVZEXT_VF8_M8,
          11886 => Opcode::PseudoVZEXT_VF8_M8_MASK,
          11887 => Opcode::PseudoZEXT_H,
          11888 => Opcode::PseudoZEXT_W,
          11889 => Opcode::ReadCounterWide,
          11890 => Opcode::ReadFFLAGS,
          11891 => Opcode::ReadFRM,
          11892 => Opcode::Select_FPR16INX_Using_CC_GPR,
          11893 => Opcode::Select_FPR16_Using_CC_GPR,
          11894 => Opcode::Select_FPR32INX_Using_CC_GPR,
          11895 => Opcode::Select_FPR32_Using_CC_GPR,
          11896 => Opcode::Select_FPR64IN32X_Using_CC_GPR,
          11897 => Opcode::Select_FPR64INX_Using_CC_GPR,
          11898 => Opcode::Select_FPR64_Using_CC_GPR,
          11899 => Opcode::Select_GPR_Using_CC_GPR,
          11900 => Opcode::Select_GPR_Using_CC_Imm,
          11901 => Opcode::SplitF64Pseudo,
          11902 => Opcode::SwapFRMImm,
          11903 => Opcode::WriteFFLAGS,
          11904 => Opcode::WriteFRM,
          11905 => Opcode::WriteFRMImm,
          11906 => Opcode::WriteVXRMImm,
          11907 => Opcode::ADD,
          11908 => Opcode::ADDI,
          11909 => Opcode::ADDIW,
          11910 => Opcode::ADDW,
          11911 => Opcode::ADD_UW,
          11912 => Opcode::AES32DSI,
          11913 => Opcode::AES32DSMI,
          11914 => Opcode::AES32ESI,
          11915 => Opcode::AES32ESMI,
          11916 => Opcode::AES64DS,
          11917 => Opcode::AES64DSM,
          11918 => Opcode::AES64ES,
          11919 => Opcode::AES64ESM,
          11920 => Opcode::AES64IM,
          11921 => Opcode::AES64KS1I,
          11922 => Opcode::AES64KS2,
          11923 => Opcode::AMOADD_B,
          11924 => Opcode::AMOADD_B_AQ,
          11925 => Opcode::AMOADD_B_AQ_RL,
          11926 => Opcode::AMOADD_B_RL,
          11927 => Opcode::AMOADD_D,
          11928 => Opcode::AMOADD_D_AQ,
          11929 => Opcode::AMOADD_D_AQ_RL,
          11930 => Opcode::AMOADD_D_RL,
          11931 => Opcode::AMOADD_H,
          11932 => Opcode::AMOADD_H_AQ,
          11933 => Opcode::AMOADD_H_AQ_RL,
          11934 => Opcode::AMOADD_H_RL,
          11935 => Opcode::AMOADD_W,
          11936 => Opcode::AMOADD_W_AQ,
          11937 => Opcode::AMOADD_W_AQ_RL,
          11938 => Opcode::AMOADD_W_RL,
          11939 => Opcode::AMOAND_B,
          11940 => Opcode::AMOAND_B_AQ,
          11941 => Opcode::AMOAND_B_AQ_RL,
          11942 => Opcode::AMOAND_B_RL,
          11943 => Opcode::AMOAND_D,
          11944 => Opcode::AMOAND_D_AQ,
          11945 => Opcode::AMOAND_D_AQ_RL,
          11946 => Opcode::AMOAND_D_RL,
          11947 => Opcode::AMOAND_H,
          11948 => Opcode::AMOAND_H_AQ,
          11949 => Opcode::AMOAND_H_AQ_RL,
          11950 => Opcode::AMOAND_H_RL,
          11951 => Opcode::AMOAND_W,
          11952 => Opcode::AMOAND_W_AQ,
          11953 => Opcode::AMOAND_W_AQ_RL,
          11954 => Opcode::AMOAND_W_RL,
          11955 => Opcode::AMOCAS_B,
          11956 => Opcode::AMOCAS_B_AQ,
          11957 => Opcode::AMOCAS_B_AQ_RL,
          11958 => Opcode::AMOCAS_B_RL,
          11959 => Opcode::AMOCAS_D_RV32,
          11960 => Opcode::AMOCAS_D_RV32_AQ,
          11961 => Opcode::AMOCAS_D_RV32_AQ_RL,
          11962 => Opcode::AMOCAS_D_RV32_RL,
          11963 => Opcode::AMOCAS_D_RV64,
          11964 => Opcode::AMOCAS_D_RV64_AQ,
          11965 => Opcode::AMOCAS_D_RV64_AQ_RL,
          11966 => Opcode::AMOCAS_D_RV64_RL,
          11967 => Opcode::AMOCAS_H,
          11968 => Opcode::AMOCAS_H_AQ,
          11969 => Opcode::AMOCAS_H_AQ_RL,
          11970 => Opcode::AMOCAS_H_RL,
          11971 => Opcode::AMOCAS_Q,
          11972 => Opcode::AMOCAS_Q_AQ,
          11973 => Opcode::AMOCAS_Q_AQ_RL,
          11974 => Opcode::AMOCAS_Q_RL,
          11975 => Opcode::AMOCAS_W,
          11976 => Opcode::AMOCAS_W_AQ,
          11977 => Opcode::AMOCAS_W_AQ_RL,
          11978 => Opcode::AMOCAS_W_RL,
          11979 => Opcode::AMOMAXU_B,
          11980 => Opcode::AMOMAXU_B_AQ,
          11981 => Opcode::AMOMAXU_B_AQ_RL,
          11982 => Opcode::AMOMAXU_B_RL,
          11983 => Opcode::AMOMAXU_D,
          11984 => Opcode::AMOMAXU_D_AQ,
          11985 => Opcode::AMOMAXU_D_AQ_RL,
          11986 => Opcode::AMOMAXU_D_RL,
          11987 => Opcode::AMOMAXU_H,
          11988 => Opcode::AMOMAXU_H_AQ,
          11989 => Opcode::AMOMAXU_H_AQ_RL,
          11990 => Opcode::AMOMAXU_H_RL,
          11991 => Opcode::AMOMAXU_W,
          11992 => Opcode::AMOMAXU_W_AQ,
          11993 => Opcode::AMOMAXU_W_AQ_RL,
          11994 => Opcode::AMOMAXU_W_RL,
          11995 => Opcode::AMOMAX_B,
          11996 => Opcode::AMOMAX_B_AQ,
          11997 => Opcode::AMOMAX_B_AQ_RL,
          11998 => Opcode::AMOMAX_B_RL,
          11999 => Opcode::AMOMAX_D,
          12000 => Opcode::AMOMAX_D_AQ,
          12001 => Opcode::AMOMAX_D_AQ_RL,
          12002 => Opcode::AMOMAX_D_RL,
          12003 => Opcode::AMOMAX_H,
          12004 => Opcode::AMOMAX_H_AQ,
          12005 => Opcode::AMOMAX_H_AQ_RL,
          12006 => Opcode::AMOMAX_H_RL,
          12007 => Opcode::AMOMAX_W,
          12008 => Opcode::AMOMAX_W_AQ,
          12009 => Opcode::AMOMAX_W_AQ_RL,
          12010 => Opcode::AMOMAX_W_RL,
          12011 => Opcode::AMOMINU_B,
          12012 => Opcode::AMOMINU_B_AQ,
          12013 => Opcode::AMOMINU_B_AQ_RL,
          12014 => Opcode::AMOMINU_B_RL,
          12015 => Opcode::AMOMINU_D,
          12016 => Opcode::AMOMINU_D_AQ,
          12017 => Opcode::AMOMINU_D_AQ_RL,
          12018 => Opcode::AMOMINU_D_RL,
          12019 => Opcode::AMOMINU_H,
          12020 => Opcode::AMOMINU_H_AQ,
          12021 => Opcode::AMOMINU_H_AQ_RL,
          12022 => Opcode::AMOMINU_H_RL,
          12023 => Opcode::AMOMINU_W,
          12024 => Opcode::AMOMINU_W_AQ,
          12025 => Opcode::AMOMINU_W_AQ_RL,
          12026 => Opcode::AMOMINU_W_RL,
          12027 => Opcode::AMOMIN_B,
          12028 => Opcode::AMOMIN_B_AQ,
          12029 => Opcode::AMOMIN_B_AQ_RL,
          12030 => Opcode::AMOMIN_B_RL,
          12031 => Opcode::AMOMIN_D,
          12032 => Opcode::AMOMIN_D_AQ,
          12033 => Opcode::AMOMIN_D_AQ_RL,
          12034 => Opcode::AMOMIN_D_RL,
          12035 => Opcode::AMOMIN_H,
          12036 => Opcode::AMOMIN_H_AQ,
          12037 => Opcode::AMOMIN_H_AQ_RL,
          12038 => Opcode::AMOMIN_H_RL,
          12039 => Opcode::AMOMIN_W,
          12040 => Opcode::AMOMIN_W_AQ,
          12041 => Opcode::AMOMIN_W_AQ_RL,
          12042 => Opcode::AMOMIN_W_RL,
          12043 => Opcode::AMOOR_B,
          12044 => Opcode::AMOOR_B_AQ,
          12045 => Opcode::AMOOR_B_AQ_RL,
          12046 => Opcode::AMOOR_B_RL,
          12047 => Opcode::AMOOR_D,
          12048 => Opcode::AMOOR_D_AQ,
          12049 => Opcode::AMOOR_D_AQ_RL,
          12050 => Opcode::AMOOR_D_RL,
          12051 => Opcode::AMOOR_H,
          12052 => Opcode::AMOOR_H_AQ,
          12053 => Opcode::AMOOR_H_AQ_RL,
          12054 => Opcode::AMOOR_H_RL,
          12055 => Opcode::AMOOR_W,
          12056 => Opcode::AMOOR_W_AQ,
          12057 => Opcode::AMOOR_W_AQ_RL,
          12058 => Opcode::AMOOR_W_RL,
          12059 => Opcode::AMOSWAP_B,
          12060 => Opcode::AMOSWAP_B_AQ,
          12061 => Opcode::AMOSWAP_B_AQ_RL,
          12062 => Opcode::AMOSWAP_B_RL,
          12063 => Opcode::AMOSWAP_D,
          12064 => Opcode::AMOSWAP_D_AQ,
          12065 => Opcode::AMOSWAP_D_AQ_RL,
          12066 => Opcode::AMOSWAP_D_RL,
          12067 => Opcode::AMOSWAP_H,
          12068 => Opcode::AMOSWAP_H_AQ,
          12069 => Opcode::AMOSWAP_H_AQ_RL,
          12070 => Opcode::AMOSWAP_H_RL,
          12071 => Opcode::AMOSWAP_W,
          12072 => Opcode::AMOSWAP_W_AQ,
          12073 => Opcode::AMOSWAP_W_AQ_RL,
          12074 => Opcode::AMOSWAP_W_RL,
          12075 => Opcode::AMOXOR_B,
          12076 => Opcode::AMOXOR_B_AQ,
          12077 => Opcode::AMOXOR_B_AQ_RL,
          12078 => Opcode::AMOXOR_B_RL,
          12079 => Opcode::AMOXOR_D,
          12080 => Opcode::AMOXOR_D_AQ,
          12081 => Opcode::AMOXOR_D_AQ_RL,
          12082 => Opcode::AMOXOR_D_RL,
          12083 => Opcode::AMOXOR_H,
          12084 => Opcode::AMOXOR_H_AQ,
          12085 => Opcode::AMOXOR_H_AQ_RL,
          12086 => Opcode::AMOXOR_H_RL,
          12087 => Opcode::AMOXOR_W,
          12088 => Opcode::AMOXOR_W_AQ,
          12089 => Opcode::AMOXOR_W_AQ_RL,
          12090 => Opcode::AMOXOR_W_RL,
          12091 => Opcode::AND,
          12092 => Opcode::ANDI,
          12093 => Opcode::ANDN,
          12094 => Opcode::AUIPC,
          12095 => Opcode::BCLR,
          12096 => Opcode::BCLRI,
          12097 => Opcode::BEQ,
          12098 => Opcode::BEXT,
          12099 => Opcode::BEXTI,
          12100 => Opcode::BGE,
          12101 => Opcode::BGEU,
          12102 => Opcode::BINV,
          12103 => Opcode::BINVI,
          12104 => Opcode::BLT,
          12105 => Opcode::BLTU,
          12106 => Opcode::BNE,
          12107 => Opcode::BREV8,
          12108 => Opcode::BSET,
          12109 => Opcode::BSETI,
          12110 => Opcode::CBO_CLEAN,
          12111 => Opcode::CBO_FLUSH,
          12112 => Opcode::CBO_INVAL,
          12113 => Opcode::CBO_ZERO,
          12114 => Opcode::CLMUL,
          12115 => Opcode::CLMULH,
          12116 => Opcode::CLMULR,
          12117 => Opcode::CLZ,
          12118 => Opcode::CLZW,
          12119 => Opcode::CM_JALT,
          12120 => Opcode::CM_JT,
          12121 => Opcode::CM_MVA01S,
          12122 => Opcode::CM_MVSA01,
          12123 => Opcode::CM_POP,
          12124 => Opcode::CM_POPRET,
          12125 => Opcode::CM_POPRETZ,
          12126 => Opcode::CM_PUSH,
          12127 => Opcode::CPOP,
          12128 => Opcode::CPOPW,
          12129 => Opcode::CSRRC,
          12130 => Opcode::CSRRCI,
          12131 => Opcode::CSRRS,
          12132 => Opcode::CSRRSI,
          12133 => Opcode::CSRRW,
          12134 => Opcode::CSRRWI,
          12135 => Opcode::CTZ,
          12136 => Opcode::CTZW,
          12137 => Opcode::CV_ABS,
          12138 => Opcode::CV_ABS_B,
          12139 => Opcode::CV_ABS_H,
          12140 => Opcode::CV_ADDN,
          12141 => Opcode::CV_ADDNR,
          12142 => Opcode::CV_ADDRN,
          12143 => Opcode::CV_ADDRNR,
          12144 => Opcode::CV_ADDUN,
          12145 => Opcode::CV_ADDUNR,
          12146 => Opcode::CV_ADDURN,
          12147 => Opcode::CV_ADDURNR,
          12148 => Opcode::CV_ADD_B,
          12149 => Opcode::CV_ADD_DIV2,
          12150 => Opcode::CV_ADD_DIV4,
          12151 => Opcode::CV_ADD_DIV8,
          12152 => Opcode::CV_ADD_H,
          12153 => Opcode::CV_ADD_SCI_B,
          12154 => Opcode::CV_ADD_SCI_H,
          12155 => Opcode::CV_ADD_SC_B,
          12156 => Opcode::CV_ADD_SC_H,
          12157 => Opcode::CV_AND_B,
          12158 => Opcode::CV_AND_H,
          12159 => Opcode::CV_AND_SCI_B,
          12160 => Opcode::CV_AND_SCI_H,
          12161 => Opcode::CV_AND_SC_B,
          12162 => Opcode::CV_AND_SC_H,
          12163 => Opcode::CV_AVGU_B,
          12164 => Opcode::CV_AVGU_H,
          12165 => Opcode::CV_AVGU_SCI_B,
          12166 => Opcode::CV_AVGU_SCI_H,
          12167 => Opcode::CV_AVGU_SC_B,
          12168 => Opcode::CV_AVGU_SC_H,
          12169 => Opcode::CV_AVG_B,
          12170 => Opcode::CV_AVG_H,
          12171 => Opcode::CV_AVG_SCI_B,
          12172 => Opcode::CV_AVG_SCI_H,
          12173 => Opcode::CV_AVG_SC_B,
          12174 => Opcode::CV_AVG_SC_H,
          12175 => Opcode::CV_BCLR,
          12176 => Opcode::CV_BCLRR,
          12177 => Opcode::CV_BEQIMM,
          12178 => Opcode::CV_BITREV,
          12179 => Opcode::CV_BNEIMM,
          12180 => Opcode::CV_BSET,
          12181 => Opcode::CV_BSETR,
          12182 => Opcode::CV_CLB,
          12183 => Opcode::CV_CLIP,
          12184 => Opcode::CV_CLIPR,
          12185 => Opcode::CV_CLIPU,
          12186 => Opcode::CV_CLIPUR,
          12187 => Opcode::CV_CMPEQ_B,
          12188 => Opcode::CV_CMPEQ_H,
          12189 => Opcode::CV_CMPEQ_SCI_B,
          12190 => Opcode::CV_CMPEQ_SCI_H,
          12191 => Opcode::CV_CMPEQ_SC_B,
          12192 => Opcode::CV_CMPEQ_SC_H,
          12193 => Opcode::CV_CMPGEU_B,
          12194 => Opcode::CV_CMPGEU_H,
          12195 => Opcode::CV_CMPGEU_SCI_B,
          12196 => Opcode::CV_CMPGEU_SCI_H,
          12197 => Opcode::CV_CMPGEU_SC_B,
          12198 => Opcode::CV_CMPGEU_SC_H,
          12199 => Opcode::CV_CMPGE_B,
          12200 => Opcode::CV_CMPGE_H,
          12201 => Opcode::CV_CMPGE_SCI_B,
          12202