/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.popupmenu;

import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import com.jsql.view.swing.text.JTextAreaPlaceholderConsole;
import com.jsql.view.swing.text.JTextPanePlaceholderConsole;
import com.jsql.view.swing.util.I18nViewUtil;
import java.awt.ComponentOrientation;
import java.awt.MouseInfo;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JPopupMenuComponent
extends JPopupMenu {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final JTextComponent component;

    public JPopupMenuComponent(JTextComponent component) {
        this.component = component;
        JMenuItem copyItem = new JMenuItem(component.getActionMap().get("copy-to-clipboard"));
        copyItem.setAccelerator(KeyStroke.getKeyStroke(67, 128));
        copyItem.setMnemonic('C');
        copyItem.setText(I18nUtil.valueByKey("CONTEXT_MENU_COPY"));
        I18nViewUtil.addComponentForKey("CONTEXT_MENU_COPY", copyItem);
        JMenuItem selectAllItem = new JMenuItem(component.getActionMap().get("select-all"));
        selectAllItem.setAccelerator(KeyStroke.getKeyStroke(65, 128));
        selectAllItem.setMnemonic('A');
        selectAllItem.setText(I18nUtil.valueByKey("CONTEXT_MENU_SELECT_ALL"));
        I18nViewUtil.addComponentForKey("CONTEXT_MENU_SELECT_ALL", selectAllItem);
        this.setLightWeightPopupEnabled(false);
        this.add(copyItem);
        this.addSeparator();
        this.add(selectAllItem);
        if (component instanceof JTextAreaPlaceholderConsole || component instanceof JTextPanePlaceholderConsole) {
            JMenuItem clearItem = new JMenuItem();
            clearItem.setAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JPopupMenuComponent.this.component.setText(null);
                }
            });
            clearItem.setText(I18nUtil.valueByKey("CONTEXT_MENU_CLEAR"));
            I18nViewUtil.addComponentForKey("CONTEXT_MENU_CLEAR", clearItem);
            clearItem.setAccelerator(KeyStroke.getKeyStroke(69, 128));
            clearItem.setMnemonic('E');
            this.addSeparator();
            this.add(clearItem);
        }
        this.addPopupMenuListener(new PopupMenuOrientedListener());
    }

    private class PopupMenuOrientedListener
    implements PopupMenuListener {
        private PopupMenuOrientedListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent event) {
            try {
                JPopupMenuComponent.this.setLocation(MouseInfo.getPointerInfo().getLocation());
                JPopupMenuComponent.this.setLocation(ComponentOrientation.RIGHT_TO_LEFT.equals(ComponentOrientation.getOrientation(I18nUtil.getCurrentLocale())) ? MouseInfo.getPointerInfo().getLocation().x - JPopupMenuComponent.this.getWidth() : MouseInfo.getPointerInfo().getLocation().x, MouseInfo.getPointerInfo().getLocation().y);
            }
            catch (NullPointerException e) {
                LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
            }
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }
}

