/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.injection.strategy.blind.callable;

import com.jsql.model.InjectionModel;
import com.jsql.model.injection.strategy.blind.AbstractInjectionBit;
import com.jsql.model.injection.strategy.blind.InjectionTime;
import com.jsql.model.injection.strategy.blind.callable.AbstractCallableBit;
import java.util.Calendar;
import java.util.Date;

public class CallableTime
extends AbstractCallableBit<CallableTime> {
    private final Calendar calendarOnStart = Calendar.getInstance();
    private final Calendar calendarOnEnd = Calendar.getInstance();
    private long diffSeconds;
    private final InjectionModel injectionModel;
    private final InjectionTime injectionTime;
    private final String metadataInjectionProcess;

    public CallableTime(String sqlQuery, InjectionModel injectionModel, InjectionTime injectionTime, AbstractInjectionBit.BlindOperator blindMode, String metadataInjectionProcess) {
        this.injectionModel = injectionModel;
        this.injectionTime = injectionTime;
        this.metadataInjectionProcess = metadataInjectionProcess;
        this.booleanUrl = this.injectionModel.getMediatorVendor().getVendor().instance().sqlTestTimeWithOperator(sqlQuery, blindMode);
    }

    public CallableTime(String sqlQuery, int indexChar, int bit, InjectionModel injectionModel, InjectionTime injectionTime, AbstractInjectionBit.BlindOperator blindMode, String metadataInjectionProcess) {
        this(sqlQuery, injectionModel, injectionTime, blindMode, metadataInjectionProcess);
        this.booleanUrl = this.injectionModel.getMediatorVendor().getVendor().instance().sqlTimeBit(sqlQuery, indexChar, bit, blindMode);
        this.currentIndex = indexChar;
        this.currentBit = bit;
    }

    @Override
    public boolean isTrue() {
        return this.diffSeconds < (long)this.injectionTime.getSleepTime();
    }

    @Override
    public CallableTime call() {
        this.calendarOnStart.setTime(new Date());
        this.injectionTime.callUrl(this.booleanUrl, this.metadataInjectionProcess, this);
        this.calendarOnEnd.setTime(new Date());
        long timeInMillisOnStart = this.calendarOnStart.getTimeInMillis();
        long timeInMillisOnEnd = this.calendarOnEnd.getTimeInMillis();
        long diff = timeInMillisOnEnd - timeInMillisOnStart;
        this.diffSeconds = diff / 1000L;
        return this;
    }
}

