/*
 * Decompiled with CFR 0.152.
 */
package com.aspect.snoop.ui.choose.process;

import com.aspect.snoop.ui.choose.process.ClasspathEntry;
import com.aspect.snoop.ui.choose.process.Util;
import java.awt.Color;
import java.awt.Component;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.Modifier;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class ClasspathTreeCellRenderer
extends DefaultTreeCellRenderer {
    private Icon openIcon = Util.createImageIcon("/gfx/open.gif");
    private Icon closedIcon = Util.createImageIcon("/gfx/close.gif");
    private Icon leafIcon = Util.createImageIcon("/gfx/leaf.gif");
    private Icon jarIcon = Util.createImageIcon("/gfx/jar.gif");
    private Icon classIcon = Util.createImageIcon("/gfx/class.gif");
    private Icon class2Icon = Util.createImageIcon("/gfx/class2.gif");
    private Icon methodPublicIcon = Util.createImageIcon("/gfx/methpub_obj.gif");
    private Icon methodDefaultIcon = Util.createImageIcon("/gfx/methdef_obj.gif");
    private Icon methodProtectedIcon = Util.createImageIcon("/gfx/methpro_obj.gif");
    private Icon methodPrivateIcon = Util.createImageIcon("/gfx/methpri_obj.gif");
    private Color gray2 = new Color(0x666666);

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object val, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, val, sel, expanded, leaf, row, hasFocus);
        if (val == null) {
            return this;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)val;
        Object value = node.getUserObject();
        if (value instanceof CtMethod) {
            CtMethod method = (CtMethod)value;
            if (Modifier.isPublic((int)method.getModifiers())) {
                this.setIcon(this.methodPublicIcon);
            } else if (Modifier.isProtected((int)method.getModifiers())) {
                this.setIcon(this.methodProtectedIcon);
            } else if (Modifier.isPrivate((int)method.getModifiers())) {
                this.setIcon(this.methodPrivateIcon);
            } else {
                this.setIcon(this.methodDefaultIcon);
            }
            this.setText(method.getLongName());
        } else if (value instanceof CtClass) {
            CtClass clazz = (CtClass)value;
            this.setIcon(this.classIcon);
            this.setText(clazz.getName());
        } else if (value instanceof ClasspathEntry) {
            ClasspathEntry entry = (ClasspathEntry)value;
            this.setIcon(this.jarIcon);
            this.setText(entry.getStringEntry());
        } else {
            this.setIcon(this.leafIcon);
        }
        return this;
    }
}

