/*
 * Decompiled with CFR 0.152.
 */
package com.aspect.snoop.agent.manager;

import com.aspect.snoop.util.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import javassist.ClassPath;

public class SmartURLClassPath
implements ClassPath {
    protected URL url;
    private Map<String, Integer> classesResponsibleFor;

    public SmartURLClassPath(URL url) {
        this.url = url;
        this.classesResponsibleFor = new HashMap<String, Integer>();
    }

    public void addClass(String className) {
        this.classesResponsibleFor.put(className, 1);
    }

    public String toString() {
        return this.url.toString();
    }

    public InputStream openClassfile(String classname) {
        if (this.classesResponsibleFor.get(classname) == null) {
            return null;
        }
        try {
            return this.openClassfile0(classname);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private InputStream openClassfile0(String classname) throws IOException {
        return this.fetchClass(this.getURL(classname));
    }

    private URL getURL(String classname) throws MalformedURLException {
        URL finalUrl;
        if (this.url.getPath().endsWith(".jar") || this.url.getPath().endsWith(".zip")) {
            String finalPath = this.url.getPath() + "!" + "/" + classname.replace('.', '/') + ".class";
            URL tmp = new URL(this.url.getProtocol(), this.url.getHost(), this.url.getPort(), finalPath);
            String s = "jar:" + tmp.toString();
            finalUrl = new URL(s);
        } else {
            String finalPath = this.url.getPath() + classname.replace('.', '/') + ".class";
            finalUrl = new URL(this.url.getProtocol(), this.url.getHost(), this.url.getPort(), finalPath);
        }
        return finalUrl;
    }

    public InputStream fetchClass(URL url) throws IOException {
        return url.openStream();
    }

    public URL find(String classname) {
        if (this.classesResponsibleFor.get(classname) == null) {
            return null;
        }
        try {
            InputStream is = this.openClassfile0(classname);
            if (is != null) {
                is.close();
                return this.getURL(classname);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesFromURL(URL url) throws IOException {
        byte[] b;
        URLConnection con = url.openConnection();
        int size = con.getContentLength();
        InputStream s = con.getInputStream();
        try {
            if (size <= 0) {
                b = IOUtil.getBytesFromStream(s);
            } else {
                int n;
                b = new byte[size];
                int len = 0;
                do {
                    if ((n = s.read(b, len, size - len)) >= 0) continue;
                    throw new IOException("the stream was closed: " + url.toString());
                } while ((len += n) < size);
            }
        }
        finally {
            s.close();
        }
        return b;
    }
}

