; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

[Setup]
; NOTE: The value of AppId uniquely identifies this application.
; Do not use the same AppId value in installers for other applications.
; (To generate a new GUID, click Tools | Generate GUID inside the IDE.)
AppID={{95BFE5C6-C019-4CA9-A971-4D12F05AEBDC}
AppName=Gravit (64bit)
AppVersion=0.5.0
AppVerName=Gravit 0.5.0 (64bit)
AppPublisher=Gravit Development Team
AppPublisherURL=http://gravit.slowchop.com/
AppSupportURL=http://gravit.slowchop.com/
AppUpdatesURL=http://gravit.slowchop.com/
DefaultDirName={pf64}\Gravit
DefaultGroupName=Gravit
AllowNoIcons=true
LicenseFile=.\files\COPYING
InfoAfterFile=.\files\README.txt
OutputDir=.\
OutputBaseFilename=setup-gravit-0.5.0-64bit
Compression=lzma/Max
SolidCompression=true
WizardSmallImageFile=.\SmallImage.bmp
WizardImageFile=.\Image.bmp
ShowLanguageDialog=no
; minimum windows version: Windows XP x64 edition
MinVersion=,5.2.3790
; "ArchitecturesAllowed=x64" specifies that Setup cannot run on
; anything but x64.
ArchitecturesAllowed=x64
; "ArchitecturesInstallIn64BitMode=x64" requests that the install be
; done in "64-bit mode" on x64, meaning it should use the native
; 64-bit Program Files directory and the 64-bit view of the registry.
ArchitecturesInstallIn64BitMode=x64
SetupIconFile=.\files\gravit.ico
SourceDir=.\

[Languages]
Name: "english"; MessagesFile: "compiler:Default.isl"

[Components]
Name: "gravit"; Description: "Gravit"; Types: full compact custom; Flags: fixed
Name: "screensaver"; Description: "Gravit Screensaver"; Types: full custom

[Tasks]
Name: "quicklaunchicon"; Description: "{cm:CreateQuickLaunchIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Flags: unchecked
Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Flags: unchecked

[Files]
Source: ".\64bit\gravit.exe"; DestDir: "{app}"; Flags: ignoreversion
Source: ".\64bit\gravit.exe"; DestDir: "{sys}"; DestName: "gravit.scr"; Flags: ignoreversion; Components: screensaver
Source: ".\files\cfg\*.cfg"; DestDir: "{app}\cfg"; Flags: ignoreversion; Permissions: users-modify
Source: ".\files\COPYING"; DestDir: "{app}"; Flags: ignoreversion
Source: ".\files\data\*"; DestDir: "{app}\data"; Flags: ignoreversion recursesubdirs
Source: ".\64bit\*.DLL"; DestDir: "{app}"; Flags: ignoreversion
Source: ".\64bit\*.DLL"; DestDir: "{sys}"; Flags: sharedfile; Components: screensaver
Source: ".\files\spawn\*"; DestDir: "{app}\spawn"; Flags: ignoreversion; Permissions: users-modify
Source: ".\files\stderr.txt"; DestDir: "{app}"; Flags: ignoreversion onlyifdoesntexist; Permissions: users-modify
Source: ".\files\stdout.txt"; DestDir: "{app}"; Flags: ignoreversion onlyifdoesntexist; Permissions: users-modify
; NOTE: Don't use "Flags: ignoreversion" on any shared system files
; include Microsoft VC 2008 SP1 Redistributable Package for x64
Source: ".\vc_redist\vcredist_x64.exe"; DestDir: "{tmp}"; Flags: ignoreversion overwritereadonly; Permissions: everyone-full

[Dirs]
Name: "{app}\cfg"; Permissions: users-modify; 
Name: "{app}\spawn"; Permissions: users-modify; 
Name: "{app}\save"; Flags: setntfscompression; Permissions: users-modify; 
Name: "{app}\screenshots"; Permissions: users-modify; 

[INI]
Filename: "{app}\gravit.url"; Section: "InternetShortcut"; Key: "URL"; String: "http://gravit.slowchop.com"

[Registry]
; register software setting for gravit
Root: "HKLM"; Subkey: "Software\Gravit"; Flags: uninsdeletekeyifempty
Root: "HKLM"; Subkey: "Software\Gravit"; ValueType: string; ValueName: "path"; ValueData: "{app}"; Flags: uninsdeletekey
Root: "HKCU"; Subkey: "Software\Gravit"; Flags: uninsdeletekeyifempty
Root: "HKCU"; Subkey: "Software\Gravit"; ValueType: string; ValueName: "path"; ValueData: "{app}"; Flags: uninsdeletekey
; register application path
Root: "HKLM"; Subkey: "SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\gravit.exe"; ValueType: string; ValueData: "{app}\gravit.exe"; Flags: uninsdeletekey
Root: "HKLM"; Subkey: "SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\gravit.exe"; ValueType: string; ValueName: "Path"; ValueData: "{app}"; Flags: uninsdeletekey
; register screensaver dll search path
Root: "HKLM"; Subkey: "SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\gravit.scr"; ValueType: string; ValueData: "{sys}\gravit.scr"; Flags: uninsdeletekey; Components: screensaver
Root: "HKLM"; Subkey: "SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\gravit.scr"; ValueType: string; ValueName: "Path"; ValueData: "{app}"; Flags: uninsdeletekey; Components: screensaver

[Icons]
Name: "{group}\Gravit"; Filename: "{app}\gravit.exe"; WorkingDir: "{app}"
Name: "{group}\Gravit (Compatible Mode)"; Filename: "{app}\gravit.exe"; WorkingDir: "{app}"; Parameters: "particlerendermode 0"
Name: "{group}\Activate Gravit Screen Saver"; Filename: "{app}\gravit.exe"; WorkingDir: "{app}"; Parameters: "installscreensaver quit"; Components: screensaver
Name: "{group}\Configure\Customise Gravit (gravit.cfg)"; Filename: "{win}\notepad.exe"; Parameters: "{app}\cfg\gravit.cfg"
Name: "{group}\Configure\Customise Screen Saver (screensaver.cfg)"; Filename: "{win}\notepad.exe"; Parameters: "{app}\cfg\screensaver.cfg"; Components: screensaver
Name: "{group}\Visit Gravit on the Internet"; Filename: "{app}\gravit.url"
Name: "{group}\{cm:UninstallProgram,Gravit}"; Filename: "{uninstallexe}"
Name: "{userdesktop}\Gravit"; Filename: "{app}\gravit.exe"; WorkingDir: "{app}"; Tasks: desktopicon
Name: "{userappdata}\Microsoft\Internet Explorer\Quick Launch\Gravit"; Filename: "{app}\gravit.exe"; WorkingDir: "{app}"; Tasks: quicklaunchicon

[Run]
; install vcredist_x64.exe
Filename: "{tmp}\vcredist_x64.exe"; Parameters: "/q:a /c:""vcredist_x64.exe /q:a /c:""""msiexec /i vcredist.msi /qn"""" """; Flags: waituntilterminated; StatusMsg: "Installing MS Visual C++ 2008 SP1 Redistributable Package (x64) ..."
; post-install tasks
Filename: "{win}\notepad.exe"; Parameters: "{app}\cfg\gravit.cfg"; Flags: nowait postinstall skipifsilent; Description: "Modify gravit.cfg (Recommended)"
;Filename: "{app}\gravit.exe"; Parameters: "installscreensaver quit"; Flags: nowait postinstall skipifsilent; Description: "Activate Gravit Screensaver"; Components: screensaver
Filename: "{app}\gravit.exe"; Flags: nowait postinstall unchecked skipifsilent; Description: "{cm:LaunchProgram,Gravit}"

[UninstallDelete]
Type: files; Name: "{app}\gravit.url"
