// Code generated by smithy-go-codegen DO NOT EDIT.

package kendra

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/kendra/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Fetches the queries that are suggested to your users.
//
// GetQuerySuggestions is currently not supported in the Amazon Web Services
// GovCloud (US-West) region.
func (c *Client) GetQuerySuggestions(ctx context.Context, params *GetQuerySuggestionsInput, optFns ...func(*Options)) (*GetQuerySuggestionsOutput, error) {
	if params == nil {
		params = &GetQuerySuggestionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetQuerySuggestions", params, optFns, c.addOperationGetQuerySuggestionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetQuerySuggestionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetQuerySuggestionsInput struct {

	// The identifier of the index you want to get query suggestions from.
	//
	// This member is required.
	IndexId *string

	// The text of a user's query to generate query suggestions.
	//
	// A query is suggested if the query prefix matches what a user starts to type as
	// their query.
	//
	// Amazon Kendra does not show any suggestions if a user types fewer than two
	// characters or more than 60 characters. A query must also have at least one
	// search result and contain at least one word of more than four characters.
	//
	// This member is required.
	QueryText *string

	// Configuration information for the document fields/attributes that you want to
	// base query suggestions on.
	AttributeSuggestionsConfig *types.AttributeSuggestionsGetConfig

	// The maximum number of query suggestions you want to show to your users.
	MaxSuggestionsCount *int32

	// The suggestions type to base query suggestions on. The suggestion types are
	// query history or document fields/attributes. You can set one type or the other.
	//
	// If you set query history as your suggestions type, Amazon Kendra suggests
	// queries relevant to your users based on popular queries in the query history.
	//
	// If you set document fields/attributes as your suggestions type, Amazon Kendra
	// suggests queries relevant to your users based on the contents of document
	// fields.
	SuggestionTypes []types.SuggestionType

	noSmithyDocumentSerde
}

type GetQuerySuggestionsOutput struct {

	// The identifier for a list of query suggestions for an index.
	QuerySuggestionsId *string

	// A list of query suggestions for an index.
	Suggestions []types.Suggestion

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetQuerySuggestionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetQuerySuggestions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetQuerySuggestions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetQuerySuggestions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetQuerySuggestionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetQuerySuggestions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetQuerySuggestions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetQuerySuggestions",
	}
}
