// Code generated by smithy-go-codegen DO NOT EDIT.

package kafka

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/kafka/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates a new MSK VPC connection.
func (c *Client) CreateVpcConnection(ctx context.Context, params *CreateVpcConnectionInput, optFns ...func(*Options)) (*CreateVpcConnectionOutput, error) {
	if params == nil {
		params = &CreateVpcConnectionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateVpcConnection", params, optFns, c.addOperationCreateVpcConnectionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateVpcConnectionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateVpcConnectionInput struct {

	// The authentication type of VPC connection.
	//
	// This member is required.
	Authentication *string

	// The list of client subnets.
	//
	// This member is required.
	ClientSubnets []string

	// The list of security groups.
	//
	// This member is required.
	SecurityGroups []string

	// The cluster Amazon Resource Name (ARN) for the VPC connection.
	//
	// This member is required.
	TargetClusterArn *string

	// The VPC ID of VPC connection.
	//
	// This member is required.
	VpcId *string

	// A map of tags for the VPC connection.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateVpcConnectionOutput struct {

	// The authentication type of VPC connection.
	Authentication *string

	// The list of client subnets.
	ClientSubnets []string

	// The creation time of VPC connection.
	CreationTime *time.Time

	// The list of security groups.
	SecurityGroups []string

	// The State of Vpc Connection.
	State types.VpcConnectionState

	// A map of tags for the VPC connection.
	Tags map[string]string

	// The VPC connection ARN.
	VpcConnectionArn *string

	// The VPC ID of the VPC connection.
	VpcId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateVpcConnectionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateVpcConnection{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateVpcConnection{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateVpcConnection"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpCreateVpcConnectionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateVpcConnection(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateVpcConnection(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateVpcConnection",
	}
}
