// Code generated by smithy-go-codegen DO NOT EDIT.

package cleanrooms

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cleanrooms/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves multiple analysis rule schemas.
func (c *Client) BatchGetSchemaAnalysisRule(ctx context.Context, params *BatchGetSchemaAnalysisRuleInput, optFns ...func(*Options)) (*BatchGetSchemaAnalysisRuleOutput, error) {
	if params == nil {
		params = &BatchGetSchemaAnalysisRuleInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "BatchGetSchemaAnalysisRule", params, optFns, c.addOperationBatchGetSchemaAnalysisRuleMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*BatchGetSchemaAnalysisRuleOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type BatchGetSchemaAnalysisRuleInput struct {

	// The unique identifier of the collaboration that contains the schema analysis
	// rule.
	//
	// This member is required.
	CollaborationIdentifier *string

	// The information that's necessary to retrieve a schema analysis rule.
	//
	// This member is required.
	SchemaAnalysisRuleRequests []types.SchemaAnalysisRuleRequest

	noSmithyDocumentSerde
}

type BatchGetSchemaAnalysisRuleOutput struct {

	// The retrieved list of analysis rules.
	//
	// This member is required.
	AnalysisRules []types.AnalysisRule

	// Error reasons for schemas that could not be retrieved. One error is returned
	// for every schema that could not be retrieved.
	//
	// This member is required.
	Errors []types.BatchGetSchemaAnalysisRuleError

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationBatchGetSchemaAnalysisRuleMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpBatchGetSchemaAnalysisRule{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpBatchGetSchemaAnalysisRule{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "BatchGetSchemaAnalysisRule"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpBatchGetSchemaAnalysisRuleValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opBatchGetSchemaAnalysisRule(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opBatchGetSchemaAnalysisRule(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "BatchGetSchemaAnalysisRule",
	}
}
