// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockruntime

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockruntime/document"
	"github.com/aws/aws-sdk-go-v2/service/bedrockruntime/types"
	"github.com/aws/smithy-go/middleware"
	smithysync "github.com/aws/smithy-go/sync"
	"sync"
)

// Sends messages to the specified Amazon Bedrock model and returns the response
// in a stream. ConverseStream provides a consistent API that works with all
// Amazon Bedrock models that support messages. This allows you to write code once
// and use it with different models. Should a model have unique inference
// parameters, you can also pass those unique parameters to the model.
//
// To find out if a model supports streaming, call [GetFoundationModel] and check the
// responseStreamingSupported field in the response.
//
// For information about the Converse API, see Use the Converse API in the Amazon
// Bedrock User Guide. To use a guardrail, see Use a guardrail with the Converse
// API in the Amazon Bedrock User Guide. To use a tool with a model, see Tool use
// (Function calling) in the Amazon Bedrock User Guide
//
// For example code, see Conversation streaming example in the Amazon Bedrock User
// Guide.
//
// This operation requires permission for the bedrock:InvokeModelWithResponseStream
// action.
//
// [GetFoundationModel]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetFoundationModel.html
func (c *Client) ConverseStream(ctx context.Context, params *ConverseStreamInput, optFns ...func(*Options)) (*ConverseStreamOutput, error) {
	if params == nil {
		params = &ConverseStreamInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ConverseStream", params, optFns, c.addOperationConverseStreamMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ConverseStreamOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ConverseStreamInput struct {

	// The messages that you want to send to the model.
	//
	// This member is required.
	Messages []types.Message

	// The ID for the model.
	//
	// The modelId to provide depends on the type of model that you use:
	//
	//   - If you use a base model, specify the model ID or its ARN. For a list of
	//   model IDs for base models, see [Amazon Bedrock base model IDs (on-demand throughput)]in the Amazon Bedrock User Guide.
	//
	//   - If you use a provisioned model, specify the ARN of the Provisioned
	//   Throughput. For more information, see [Run inference using a Provisioned Throughput]in the Amazon Bedrock User Guide.
	//
	//   - If you use a custom model, first purchase Provisioned Throughput for it.
	//   Then specify the ARN of the resulting provisioned model. For more information,
	//   see [Use a custom model in Amazon Bedrock]in the Amazon Bedrock User Guide.
	//
	// [Run inference using a Provisioned Throughput]: https://docs.aws.amazon.com/bedrock/latest/userguide/prov-thru-use.html
	// [Use a custom model in Amazon Bedrock]: https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-use.html
	// [Amazon Bedrock base model IDs (on-demand throughput)]: https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#model-ids-arns
	//
	// This member is required.
	ModelId *string

	// Additional inference parameters that the model supports, beyond the base set of
	// inference parameters that ConverseStream supports in the inferenceConfig field.
	AdditionalModelRequestFields document.Interface

	// Additional model parameters field paths to return in the response.
	// ConverseStream returns the requested fields as a JSON Pointer object in the
	// additionalModelResponseFields field. The following is example JSON for
	// additionalModelResponseFieldPaths .
	//
	//     [ "/stop_sequence" ]
	//
	// For information about the JSON Pointer syntax, see the [Internet Engineering Task Force (IETF)] documentation.
	//
	// ConverseStream rejects an empty JSON Pointer or incorrectly structured JSON
	// Pointer with a 400 error code. if the JSON Pointer is valid, but the requested
	// field is not in the model response, it is ignored by ConverseStream .
	//
	// [Internet Engineering Task Force (IETF)]: https://datatracker.ietf.org/doc/html/rfc6901
	AdditionalModelResponseFieldPaths []string

	// Configuration information for a guardrail that you want to use in the request.
	GuardrailConfig *types.GuardrailStreamConfiguration

	// Inference parameters to pass to the model. ConverseStream supports a base set
	// of inference parameters. If you need to pass additional parameters that the
	// model supports, use the additionalModelRequestFields request field.
	InferenceConfig *types.InferenceConfiguration

	// A system prompt to send to the model.
	System []types.SystemContentBlock

	// Configuration information for the tools that the model can use when generating
	// a response.
	//
	// This field is only supported by Anthropic Claude 3 models.
	ToolConfig *types.ToolConfiguration

	noSmithyDocumentSerde
}

type ConverseStreamOutput struct {
	eventStream *ConverseStreamEventStream

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

// GetStream returns the type to interact with the event stream.
func (o *ConverseStreamOutput) GetStream() *ConverseStreamEventStream {
	return o.eventStream
}

func (c *Client) addOperationConverseStreamMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpConverseStream{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpConverseStream{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ConverseStream"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addEventStreamConverseStreamMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpConverseStreamValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opConverseStream(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opConverseStream(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ConverseStream",
	}
}

// ConverseStreamEventStream provides the event stream handling for the ConverseStream operation.
//
// For testing and mocking the event stream this type should be initialized via
// the NewConverseStreamEventStream constructor function. Using the functional options
// to pass in nested mock behavior.
type ConverseStreamEventStream struct {
	// ConverseStreamOutputReader is the EventStream reader for the
	// ConverseStreamOutput events. This value is automatically set by the SDK when the
	// API call is made Use this member when unit testing your code with the SDK to
	// mock out the EventStream Reader.
	//
	// Must not be nil.
	Reader ConverseStreamOutputReader

	done      chan struct{}
	closeOnce sync.Once
	err       *smithysync.OnceErr
}

// NewConverseStreamEventStream initializes an ConverseStreamEventStream.
// This function should only be used for testing and mocking the ConverseStreamEventStream
// stream within your application.
//
// The Reader member must be set before reading events from the stream.
func NewConverseStreamEventStream(optFns ...func(*ConverseStreamEventStream)) *ConverseStreamEventStream {
	es := &ConverseStreamEventStream{
		done: make(chan struct{}),
		err:  smithysync.NewOnceErr(),
	}
	for _, fn := range optFns {
		fn(es)
	}
	return es
}

// Events returns a channel to read events from.
func (es *ConverseStreamEventStream) Events() <-chan types.ConverseStreamOutput {
	return es.Reader.Events()
}

// Close closes the stream. This will also cause the stream to be closed.
// Close must be called when done using the stream API. Not calling Close
// may result in resource leaks.
//
// Will close the underlying EventStream writer and reader, and no more events can be
// sent or received.
func (es *ConverseStreamEventStream) Close() error {
	es.closeOnce.Do(es.safeClose)
	return es.Err()
}

func (es *ConverseStreamEventStream) safeClose() {
	close(es.done)

	es.Reader.Close()
}

// Err returns any error that occurred while reading or writing EventStream Events
// from the service API's response. Returns nil if there were no errors.
func (es *ConverseStreamEventStream) Err() error {
	if err := es.err.Err(); err != nil {
		return err
	}

	if err := es.Reader.Err(); err != nil {
		return err
	}

	return nil
}

func (es *ConverseStreamEventStream) waitStreamClose() {
	type errorSet interface {
		ErrorSet() <-chan struct{}
	}

	var outputErrCh <-chan struct{}
	if v, ok := es.Reader.(errorSet); ok {
		outputErrCh = v.ErrorSet()
	}
	var outputClosedCh <-chan struct{}
	if v, ok := es.Reader.(interface{ Closed() <-chan struct{} }); ok {
		outputClosedCh = v.Closed()
	}

	select {
	case <-es.done:
	case <-outputErrCh:
		es.err.SetError(es.Reader.Err())
		es.Close()

	case <-outputClosedCh:
		if err := es.Reader.Err(); err != nil {
			es.err.SetError(es.Reader.Err())
		}
		es.Close()

	}
}
