//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmanagedapplications

// Application - Information about managed application.
type Application struct {
	// REQUIRED; The kind of the managed application. Allowed values are MarketPlace and ServiceCatalog.
	Kind *string `json:"kind,omitempty"`

	// REQUIRED; The managed application properties.
	Properties *ApplicationProperties `json:"properties,omitempty"`

	// The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`

	// Resource location
	Location *string `json:"location,omitempty"`

	// ID of the resource that manages this resource.
	ManagedBy *string `json:"managedBy,omitempty"`

	// The plan information.
	Plan *Plan `json:"plan,omitempty"`

	// The SKU of the resource.
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicationArtifact - Managed application artifact.
type ApplicationArtifact struct {
	// The managed application artifact name.
	Name *string `json:"name,omitempty"`

	// The managed application artifact type.
	Type *ApplicationArtifactType `json:"type,omitempty"`

	// The managed application artifact blob uri.
	URI *string `json:"uri,omitempty"`
}

// ApplicationClientListOperationsOptions contains the optional parameters for the ApplicationClient.ListOperations method.
type ApplicationClientListOperationsOptions struct {
	// placeholder for future optional parameters
}

// ApplicationDefinition - Information about managed application definition.
type ApplicationDefinition struct {
	// REQUIRED; The managed application definition properties.
	Properties *ApplicationDefinitionProperties `json:"properties,omitempty"`

	// The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`

	// Resource location
	Location *string `json:"location,omitempty"`

	// ID of the resource that manages this resource.
	ManagedBy *string `json:"managedBy,omitempty"`

	// The SKU of the resource.
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicationDefinitionListResult - List of managed application definitions.
type ApplicationDefinitionListResult struct {
	// The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// The array of managed application definitions.
	Value []*ApplicationDefinition `json:"value,omitempty"`
}

// ApplicationDefinitionProperties - The managed application definition properties.
type ApplicationDefinitionProperties struct {
	// REQUIRED; The managed application provider authorizations.
	Authorizations []*ApplicationProviderAuthorization `json:"authorizations,omitempty"`

	// REQUIRED; The managed application lock level.
	LockLevel *ApplicationLockLevel `json:"lockLevel,omitempty"`

	// The collection of managed application artifacts. The portal will use the files specified as artifacts to construct the
	// user experience of creating a managed application from a managed application
	// definition.
	Artifacts []*ApplicationArtifact `json:"artifacts,omitempty"`

	// The createUiDefinition json for the backing template with Microsoft.Solutions/applications resource. It can be a JObject
	// or well-formed JSON string.
	CreateUIDefinition interface{} `json:"createUiDefinition,omitempty"`

	// The managed application definition description.
	Description *string `json:"description,omitempty"`

	// The managed application definition display name.
	DisplayName *string `json:"displayName,omitempty"`

	// A value indicating whether the package is enabled or not.
	IsEnabled *string `json:"isEnabled,omitempty"`

	// The inline main template json which has resources to be provisioned. It can be a JObject or well-formed JSON string.
	MainTemplate interface{} `json:"mainTemplate,omitempty"`

	// The managed application definition package file Uri. Use this element
	PackageFileURI *string `json:"packageFileUri,omitempty"`
}

// ApplicationDefinitionsClientBeginCreateOrUpdateByIDOptions contains the optional parameters for the ApplicationDefinitionsClient.BeginCreateOrUpdateByID
// method.
type ApplicationDefinitionsClientBeginCreateOrUpdateByIDOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ApplicationDefinitionsClientBeginCreateOrUpdateOptions contains the optional parameters for the ApplicationDefinitionsClient.BeginCreateOrUpdate
// method.
type ApplicationDefinitionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ApplicationDefinitionsClientBeginDeleteByIDOptions contains the optional parameters for the ApplicationDefinitionsClient.BeginDeleteByID
// method.
type ApplicationDefinitionsClientBeginDeleteByIDOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ApplicationDefinitionsClientBeginDeleteOptions contains the optional parameters for the ApplicationDefinitionsClient.BeginDelete
// method.
type ApplicationDefinitionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ApplicationDefinitionsClientGetByIDOptions contains the optional parameters for the ApplicationDefinitionsClient.GetByID
// method.
type ApplicationDefinitionsClientGetByIDOptions struct {
	// placeholder for future optional parameters
}

// ApplicationDefinitionsClientGetOptions contains the optional parameters for the ApplicationDefinitionsClient.Get method.
type ApplicationDefinitionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ApplicationDefinitionsClientListByResourceGroupOptions contains the optional parameters for the ApplicationDefinitionsClient.ListByResourceGroup
// method.
type ApplicationDefinitionsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ApplicationListResult - List of managed applications.
type ApplicationListResult struct {
	// The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// The array of managed applications.
	Value []*Application `json:"value,omitempty"`
}

// ApplicationPatchable - Information about managed application.
type ApplicationPatchable struct {
	// The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`

	// The kind of the managed application. Allowed values are MarketPlace and ServiceCatalog.
	Kind *string `json:"kind,omitempty"`

	// Resource location
	Location *string `json:"location,omitempty"`

	// ID of the resource that manages this resource.
	ManagedBy *string `json:"managedBy,omitempty"`

	// The plan information.
	Plan *PlanPatchable `json:"plan,omitempty"`

	// The managed application properties.
	Properties *ApplicationPropertiesPatchable `json:"properties,omitempty"`

	// The SKU of the resource.
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicationProperties - The managed application properties.
type ApplicationProperties struct {
	// REQUIRED; The managed resource group Id.
	ManagedResourceGroupID *string `json:"managedResourceGroupId,omitempty"`

	// The fully qualified path of managed application definition Id.
	ApplicationDefinitionID *string `json:"applicationDefinitionId,omitempty"`

	// Name and value pairs that define the managed application parameters. It can be a JObject or a well formed JSON string.
	Parameters interface{} `json:"parameters,omitempty"`

	// READ-ONLY; Name and value pairs that define the managed application outputs.
	Outputs interface{} `json:"outputs,omitempty" azure:"ro"`

	// READ-ONLY; The managed application provisioning state.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ApplicationPropertiesPatchable - The managed application properties.
type ApplicationPropertiesPatchable struct {
	// The fully qualified path of managed application definition Id.
	ApplicationDefinitionID *string `json:"applicationDefinitionId,omitempty"`

	// The managed resource group Id.
	ManagedResourceGroupID *string `json:"managedResourceGroupId,omitempty"`

	// Name and value pairs that define the managed application parameters. It can be a JObject or a well formed JSON string.
	Parameters interface{} `json:"parameters,omitempty"`

	// READ-ONLY; Name and value pairs that define the managed application outputs.
	Outputs interface{} `json:"outputs,omitempty" azure:"ro"`

	// READ-ONLY; The managed application provisioning state.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ApplicationProviderAuthorization - The managed application provider authorization.
type ApplicationProviderAuthorization struct {
	// REQUIRED; The provider's principal identifier. This is the identity that the provider will use to call ARM to manage the
	// managed application resources.
	PrincipalID *string `json:"principalId,omitempty"`

	// REQUIRED; The provider's role definition identifier. This role will define all the permissions that the provider must have
	// on the managed application's container resource group. This role definition cannot have
	// permission to delete the resource group.
	RoleDefinitionID *string `json:"roleDefinitionId,omitempty"`
}

// ApplicationsClientBeginCreateOrUpdateByIDOptions contains the optional parameters for the ApplicationsClient.BeginCreateOrUpdateByID
// method.
type ApplicationsClientBeginCreateOrUpdateByIDOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ApplicationsClientBeginCreateOrUpdateOptions contains the optional parameters for the ApplicationsClient.BeginCreateOrUpdate
// method.
type ApplicationsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ApplicationsClientBeginDeleteByIDOptions contains the optional parameters for the ApplicationsClient.BeginDeleteByID method.
type ApplicationsClientBeginDeleteByIDOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ApplicationsClientBeginDeleteOptions contains the optional parameters for the ApplicationsClient.BeginDelete method.
type ApplicationsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ApplicationsClientGetByIDOptions contains the optional parameters for the ApplicationsClient.GetByID method.
type ApplicationsClientGetByIDOptions struct {
	// placeholder for future optional parameters
}

// ApplicationsClientGetOptions contains the optional parameters for the ApplicationsClient.Get method.
type ApplicationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ApplicationsClientListByResourceGroupOptions contains the optional parameters for the ApplicationsClient.ListByResourceGroup
// method.
type ApplicationsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ApplicationsClientListBySubscriptionOptions contains the optional parameters for the ApplicationsClient.ListBySubscription
// method.
type ApplicationsClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// ApplicationsClientUpdateByIDOptions contains the optional parameters for the ApplicationsClient.UpdateByID method.
type ApplicationsClientUpdateByIDOptions struct {
	// Parameters supplied to update an existing managed application.
	Parameters *Application
}

// ApplicationsClientUpdateOptions contains the optional parameters for the ApplicationsClient.Update method.
type ApplicationsClientUpdateOptions struct {
	// Parameters supplied to update an existing managed application.
	Parameters *ApplicationPatchable
}

// ErrorResponse - Error response indicates managed application is not able to process the incoming request. The reason is
// provided in the error message.
type ErrorResponse struct {
	// Error code.
	ErrorCode *string `json:"errorCode,omitempty"`

	// Error message indicating why the operation failed.
	ErrorMessage *string `json:"errorMessage,omitempty"`

	// Http status code.
	HTTPStatus *string `json:"httpStatus,omitempty"`
}

// GenericResource - Resource information.
type GenericResource struct {
	// The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`

	// Resource location
	Location *string `json:"location,omitempty"`

	// ID of the resource that manages this resource.
	ManagedBy *string `json:"managedBy,omitempty"`

	// The SKU of the resource.
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Identity for the resource.
type Identity struct {
	// The identity type.
	Type *string `json:"type,omitempty"`

	// READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// Operation - Microsoft.Solutions operation
type Operation struct {
	// The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`

	// Service provider: Microsoft.Solutions
	Provider *string `json:"provider,omitempty"`

	// Resource on which the operation is performed: Application, JitRequest, etc.
	Resource *string `json:"resource,omitempty"`
}

// OperationListResult - Result of the request to list Microsoft.Solutions operations. It contains a list of operations and
// a URL link to get the next set of results.
type OperationListResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// List of Microsoft.Solutions operations.
	Value []*Operation `json:"value,omitempty"`
}

// Plan for the managed application.
type Plan struct {
	// REQUIRED; The plan name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The product code.
	Product *string `json:"product,omitempty"`

	// REQUIRED; The publisher ID.
	Publisher *string `json:"publisher,omitempty"`

	// REQUIRED; The plan's version.
	Version *string `json:"version,omitempty"`

	// The promotion code.
	PromotionCode *string `json:"promotionCode,omitempty"`
}

// PlanPatchable - Plan for the managed application.
type PlanPatchable struct {
	// The plan name.
	Name *string `json:"name,omitempty"`

	// The product code.
	Product *string `json:"product,omitempty"`

	// The promotion code.
	PromotionCode *string `json:"promotionCode,omitempty"`

	// The publisher ID.
	Publisher *string `json:"publisher,omitempty"`

	// The plan's version.
	Version *string `json:"version,omitempty"`
}

// Resource information.
type Resource struct {
	// Resource location
	Location *string `json:"location,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SKU for the resource.
type SKU struct {
	// REQUIRED; The SKU name.
	Name *string `json:"name,omitempty"`

	// The SKU capacity.
	Capacity *int32 `json:"capacity,omitempty"`

	// The SKU family.
	Family *string `json:"family,omitempty"`

	// The SKU model.
	Model *string `json:"model,omitempty"`

	// The SKU size.
	Size *string `json:"size,omitempty"`

	// The SKU tier.
	Tier *string `json:"tier,omitempty"`
}
