//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armcognitiveservices

import "time"

// APIKeys - The access keys for the cognitive services account.
type APIKeys struct {
	// Gets the value of key 1.
	Key1 *string `json:"key1,omitempty"`

	// Gets the value of key 2.
	Key2 *string `json:"key2,omitempty"`
}

// APIProperties - The api properties for special APIs.
type APIProperties struct {
	// (Metrics Advisor Only) The Azure AD Client Id (Application Id).
	AADClientID *string `json:"aadClientId,omitempty"`

	// (Metrics Advisor Only) The Azure AD Tenant Id.
	AADTenantID *string `json:"aadTenantId,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// (Personalization Only) The flag to enable statistics of Bing Search.
	EventHubConnectionString *string `json:"eventHubConnectionString,omitempty"`

	// (QnAMaker Only) The Azure Search endpoint id of QnAMaker.
	QnaAzureSearchEndpointID *string `json:"qnaAzureSearchEndpointId,omitempty"`

	// (QnAMaker Only) The Azure Search endpoint key of QnAMaker.
	QnaAzureSearchEndpointKey *string `json:"qnaAzureSearchEndpointKey,omitempty"`

	// (QnAMaker Only) The runtime endpoint of QnAMaker.
	QnaRuntimeEndpoint *string `json:"qnaRuntimeEndpoint,omitempty"`

	// (Bing Search Only) The flag to enable statistics of Bing Search.
	StatisticsEnabled *bool `json:"statisticsEnabled,omitempty"`

	// (Personalization Only) The storage account connection string.
	StorageAccountConnectionString *string `json:"storageAccountConnectionString,omitempty"`

	// (Metrics Advisor Only) The super user of Metrics Advisor.
	SuperUser *string `json:"superUser,omitempty"`

	// (Metrics Advisor Only) The website name of Metrics Advisor.
	WebsiteName *string `json:"websiteName,omitempty"`
}

// Account - Cognitive Services account is an Azure resource representing the provisioned account, it's type, location and
// SKU.
type Account struct {
	// Identity for the resource.
	Identity *Identity `json:"identity,omitempty"`

	// The Kind of the resource.
	Kind *string `json:"kind,omitempty"`

	// The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Properties of Cognitive Services account.
	Properties *AccountProperties `json:"properties,omitempty"`

	// The resource model definition representing SKU
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AccountListResult - The list of cognitive services accounts operation response.
type AccountListResult struct {
	// The link used to get the next page of accounts.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; Gets the list of Cognitive Services accounts and their properties.
	Value []*Account `json:"value,omitempty" azure:"ro"`
}

// AccountModel - Cognitive Services account Model.
type AccountModel struct {
	// Base Model Identifier.
	BaseModel *DeploymentModel `json:"baseModel,omitempty"`

	// The capabilities.
	Capabilities map[string]*string `json:"capabilities,omitempty"`

	// Cognitive Services account ModelDeprecationInfo.
	Deprecation *ModelDeprecationInfo `json:"deprecation,omitempty"`

	// Deployment model format.
	Format *string `json:"format,omitempty"`

	// The max capacity.
	MaxCapacity *int32 `json:"maxCapacity,omitempty"`

	// Deployment model name.
	Name *string `json:"name,omitempty"`

	// Deployment model version.
	Version *string `json:"version,omitempty"`

	// READ-ONLY; The call rate limit Cognitive Services account.
	CallRateLimit *CallRateLimit `json:"callRateLimit,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`
}

// AccountModelListResult - The list of cognitive services accounts operation response.
type AccountModelListResult struct {
	// The link used to get the next page of Model.
	NextLink *string `json:"nextLink,omitempty"`

	// Gets the list of Cognitive Services accounts Model and their properties.
	Value []*AccountModel `json:"value,omitempty"`
}

// AccountProperties - Properties of Cognitive Services account.
type AccountProperties struct {
	// The api properties for special APIs.
	APIProperties   *APIProperties `json:"apiProperties,omitempty"`
	AllowedFqdnList []*string      `json:"allowedFqdnList,omitempty"`

	// Optional subdomain name used for token-based authentication.
	CustomSubDomainName *string `json:"customSubDomainName,omitempty"`
	DisableLocalAuth    *bool   `json:"disableLocalAuth,omitempty"`

	// The flag to enable dynamic throttling.
	DynamicThrottlingEnabled *bool `json:"dynamicThrottlingEnabled,omitempty"`

	// The encryption properties for this resource.
	Encryption *Encryption `json:"encryption,omitempty"`

	// Resource migration token.
	MigrationToken *string `json:"migrationToken,omitempty"`

	// A collection of rules governing the accessibility from specific network locations.
	NetworkACLs *NetworkRuleSet `json:"networkAcls,omitempty"`

	// Whether or not public endpoint access is allowed for this account.
	PublicNetworkAccess           *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
	Restore                       *bool                `json:"restore,omitempty"`
	RestrictOutboundNetworkAccess *bool                `json:"restrictOutboundNetworkAccess,omitempty"`

	// The storage accounts for this resource.
	UserOwnedStorage []*UserOwnedStorage `json:"userOwnedStorage,omitempty"`

	// READ-ONLY; The call rate limit Cognitive Services account.
	CallRateLimit *CallRateLimit `json:"callRateLimit,omitempty" azure:"ro"`

	// READ-ONLY; Gets the capabilities of the cognitive services account. Each item indicates the capability of a specific feature.
	// The values are read-only and for reference only.
	Capabilities []*SKUCapability `json:"capabilities,omitempty" azure:"ro"`

	// READ-ONLY; Gets the date of cognitive services account creation.
	DateCreated *string `json:"dateCreated,omitempty" azure:"ro"`

	// READ-ONLY; The deletion date, only available for deleted account.
	DeletionDate *string `json:"deletionDate,omitempty" azure:"ro"`

	// READ-ONLY; Endpoint of the created account.
	Endpoint *string `json:"endpoint,omitempty" azure:"ro"`

	// READ-ONLY; Dictionary of
	Endpoints map[string]*string `json:"endpoints,omitempty" azure:"ro"`

	// READ-ONLY; The internal identifier (deprecated, do not use this property).
	InternalID *string `json:"internalId,omitempty" azure:"ro"`

	// READ-ONLY; If the resource is migrated from an existing key.
	IsMigrated *bool `json:"isMigrated,omitempty" azure:"ro"`

	// READ-ONLY; The private endpoint connection associated with the Cognitive Services account.
	PrivateEndpointConnections []*PrivateEndpointConnection `json:"privateEndpointConnections,omitempty" azure:"ro"`

	// READ-ONLY; Gets the status of the cognitive services account at the time the operation was called.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY
	QuotaLimit *QuotaLimit `json:"quotaLimit,omitempty" azure:"ro"`

	// READ-ONLY; Sku change info of account.
	SKUChangeInfo *SKUChangeInfo `json:"skuChangeInfo,omitempty" azure:"ro"`

	// READ-ONLY; The scheduled purge date, only available for deleted account.
	ScheduledPurgeDate *string `json:"scheduledPurgeDate,omitempty" azure:"ro"`
}

// AccountSKU - Cognitive Services resource type and SKU.
type AccountSKU struct {
	// Resource Namespace and Type
	ResourceType *string `json:"resourceType,omitempty"`

	// The SKU of Cognitive Services account.
	SKU *SKU `json:"sku,omitempty"`
}

// AccountSKUListResult - The list of cognitive services accounts operation response.
type AccountSKUListResult struct {
	// Gets the list of Cognitive Services accounts and their properties.
	Value []*AccountSKU `json:"value,omitempty"`
}

// AccountsClientBeginCreateOptions contains the optional parameters for the AccountsClient.BeginCreate method.
type AccountsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AccountsClientBeginDeleteOptions contains the optional parameters for the AccountsClient.BeginDelete method.
type AccountsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AccountsClientBeginUpdateOptions contains the optional parameters for the AccountsClient.BeginUpdate method.
type AccountsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AccountsClientGetOptions contains the optional parameters for the AccountsClient.Get method.
type AccountsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientListByResourceGroupOptions contains the optional parameters for the AccountsClient.ListByResourceGroup method.
type AccountsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientListKeysOptions contains the optional parameters for the AccountsClient.ListKeys method.
type AccountsClientListKeysOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientListModelsOptions contains the optional parameters for the AccountsClient.ListModels method.
type AccountsClientListModelsOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientListOptions contains the optional parameters for the AccountsClient.List method.
type AccountsClientListOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientListSKUsOptions contains the optional parameters for the AccountsClient.ListSKUs method.
type AccountsClientListSKUsOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientListUsagesOptions contains the optional parameters for the AccountsClient.ListUsages method.
type AccountsClientListUsagesOptions struct {
	// An OData filter expression that describes a subset of usages to return. The supported parameter is name.value (name of
	// the metric, can have an or of multiple names).
	Filter *string
}

// AccountsClientRegenerateKeyOptions contains the optional parameters for the AccountsClient.RegenerateKey method.
type AccountsClientRegenerateKeyOptions struct {
	// placeholder for future optional parameters
}

// AzureEntityResource - The resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CallRateLimit - The call rate limit Cognitive Services account.
type CallRateLimit struct {
	// The count value of Call Rate Limit.
	Count *float32 `json:"count,omitempty"`

	// The renewal period in seconds of Call Rate Limit.
	RenewalPeriod *float32          `json:"renewalPeriod,omitempty"`
	Rules         []*ThrottlingRule `json:"rules,omitempty"`
}

// CheckDomainAvailabilityParameter - Check Domain availability parameter.
type CheckDomainAvailabilityParameter struct {
	// REQUIRED; The subdomain name to use.
	SubdomainName *string `json:"subdomainName,omitempty"`

	// REQUIRED; The Type of the resource.
	Type *string `json:"type,omitempty"`

	// The Kind of the resource.
	Kind *string `json:"kind,omitempty"`
}

// CheckSKUAvailabilityParameter - Check SKU availability parameter.
type CheckSKUAvailabilityParameter struct {
	// REQUIRED; The Kind of the resource.
	Kind *string `json:"kind,omitempty"`

	// REQUIRED; The SKU of the resource.
	SKUs []*string `json:"skus,omitempty"`

	// REQUIRED; The Type of the resource.
	Type *string `json:"type,omitempty"`
}

// CommitmentCost - Cognitive Services account commitment cost.
type CommitmentCost struct {
	// Commitment meter Id.
	CommitmentMeterID *string `json:"commitmentMeterId,omitempty"`

	// Overage meter Id.
	OverageMeterID *string `json:"overageMeterId,omitempty"`
}

// CommitmentPeriod - Cognitive Services account commitment period.
type CommitmentPeriod struct {
	// Commitment period commitment count.
	Count *int32 `json:"count,omitempty"`

	// Commitment period commitment tier.
	Tier *string `json:"tier,omitempty"`

	// READ-ONLY; Commitment period end date.
	EndDate *string `json:"endDate,omitempty" azure:"ro"`

	// READ-ONLY; Cognitive Services account commitment quota.
	Quota *CommitmentQuota `json:"quota,omitempty" azure:"ro"`

	// READ-ONLY; Commitment period start date.
	StartDate *string `json:"startDate,omitempty" azure:"ro"`
}

// CommitmentPlan - Cognitive Services account commitment plan.
type CommitmentPlan struct {
	// Properties of Cognitive Services account commitment plan.
	Properties *CommitmentPlanProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CommitmentPlanListResult - The list of cognitive services accounts operation response.
type CommitmentPlanListResult struct {
	// The link used to get the next page of CommitmentPlan.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; Gets the list of Cognitive Services accounts CommitmentPlan and their properties.
	Value []*CommitmentPlan `json:"value,omitempty" azure:"ro"`
}

// CommitmentPlanProperties - Properties of Cognitive Services account commitment plan.
type CommitmentPlanProperties struct {
	// AutoRenew commitment plan.
	AutoRenew *bool `json:"autoRenew,omitempty"`

	// Cognitive Services account commitment period.
	Current *CommitmentPeriod `json:"current,omitempty"`

	// Account hosting model.
	HostingModel *HostingModel `json:"hostingModel,omitempty"`

	// Cognitive Services account commitment period.
	Next *CommitmentPeriod `json:"next,omitempty"`

	// Commitment plan type.
	PlanType *string `json:"planType,omitempty"`

	// READ-ONLY; Cognitive Services account commitment period.
	Last *CommitmentPeriod `json:"last,omitempty" azure:"ro"`
}

// CommitmentPlansClientBeginDeleteOptions contains the optional parameters for the CommitmentPlansClient.BeginDelete method.
type CommitmentPlansClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CommitmentPlansClientCreateOrUpdateOptions contains the optional parameters for the CommitmentPlansClient.CreateOrUpdate
// method.
type CommitmentPlansClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// CommitmentPlansClientGetOptions contains the optional parameters for the CommitmentPlansClient.Get method.
type CommitmentPlansClientGetOptions struct {
	// placeholder for future optional parameters
}

// CommitmentPlansClientListOptions contains the optional parameters for the CommitmentPlansClient.List method.
type CommitmentPlansClientListOptions struct {
	// placeholder for future optional parameters
}

// CommitmentQuota - Cognitive Services account commitment quota.
type CommitmentQuota struct {
	// Commitment quota quantity.
	Quantity *int64 `json:"quantity,omitempty"`

	// Commitment quota unit.
	Unit *string `json:"unit,omitempty"`
}

// CommitmentTier - Cognitive Services account commitment tier.
type CommitmentTier struct {
	// Cognitive Services account commitment cost.
	Cost *CommitmentCost `json:"cost,omitempty"`

	// Account hosting model.
	HostingModel *HostingModel `json:"hostingModel,omitempty"`

	// The Kind of the resource.
	Kind *string `json:"kind,omitempty"`

	// Commitment period commitment max count.
	MaxCount *int32 `json:"maxCount,omitempty"`

	// Commitment plan type.
	PlanType *string `json:"planType,omitempty"`

	// Cognitive Services account commitment quota.
	Quota *CommitmentQuota `json:"quota,omitempty"`

	// The name of the SKU. Ex - P3. It is typically a letter+number code
	SKUName *string `json:"skuName,omitempty"`

	// Commitment period commitment tier.
	Tier *string `json:"tier,omitempty"`
}

// CommitmentTierListResult - The list of cognitive services accounts operation response.
type CommitmentTierListResult struct {
	// The link used to get the next page of CommitmentTier.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; Gets the list of Cognitive Services accounts CommitmentTier and their properties.
	Value []*CommitmentTier `json:"value,omitempty" azure:"ro"`
}

// CommitmentTiersClientListOptions contains the optional parameters for the CommitmentTiersClient.List method.
type CommitmentTiersClientListOptions struct {
	// placeholder for future optional parameters
}

// DeletedAccountsClientBeginPurgeOptions contains the optional parameters for the DeletedAccountsClient.BeginPurge method.
type DeletedAccountsClientBeginPurgeOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DeletedAccountsClientGetOptions contains the optional parameters for the DeletedAccountsClient.Get method.
type DeletedAccountsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DeletedAccountsClientListOptions contains the optional parameters for the DeletedAccountsClient.List method.
type DeletedAccountsClientListOptions struct {
	// placeholder for future optional parameters
}

// Deployment - Cognitive Services account deployment.
type Deployment struct {
	// Properties of Cognitive Services account deployment.
	Properties *DeploymentProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DeploymentListResult - The list of cognitive services accounts operation response.
type DeploymentListResult struct {
	// The link used to get the next page of Deployment.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; Gets the list of Cognitive Services accounts Deployment and their properties.
	Value []*Deployment `json:"value,omitempty" azure:"ro"`
}

// DeploymentModel - Properties of Cognitive Services account deployment model.
type DeploymentModel struct {
	// Deployment model format.
	Format *string `json:"format,omitempty"`

	// Deployment model name.
	Name *string `json:"name,omitempty"`

	// Deployment model version.
	Version *string `json:"version,omitempty"`

	// READ-ONLY; The call rate limit Cognitive Services account.
	CallRateLimit *CallRateLimit `json:"callRateLimit,omitempty" azure:"ro"`
}

// DeploymentProperties - Properties of Cognitive Services account deployment.
type DeploymentProperties struct {
	// Properties of Cognitive Services account deployment model.
	Model *DeploymentModel `json:"model,omitempty"`

	// The name of RAI policy.
	RaiPolicyName *string `json:"raiPolicyName,omitempty"`

	// Properties of Cognitive Services account deployment model.
	ScaleSettings *DeploymentScaleSettings `json:"scaleSettings,omitempty"`

	// READ-ONLY; The call rate limit Cognitive Services account.
	CallRateLimit *CallRateLimit `json:"callRateLimit,omitempty" azure:"ro"`

	// READ-ONLY; The capabilities.
	Capabilities map[string]*string `json:"capabilities,omitempty" azure:"ro"`

	// READ-ONLY; Gets the status of the resource at the time the operation was called.
	ProvisioningState *DeploymentProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// DeploymentScaleSettings - Properties of Cognitive Services account deployment model.
type DeploymentScaleSettings struct {
	// Deployment capacity.
	Capacity *int32 `json:"capacity,omitempty"`

	// Deployment scale type.
	ScaleType *DeploymentScaleType `json:"scaleType,omitempty"`

	// READ-ONLY; Deployment active capacity. This value might be different from capacity if customer recently updated capacity.
	ActiveCapacity *int32 `json:"activeCapacity,omitempty" azure:"ro"`
}

// DeploymentsClientBeginCreateOrUpdateOptions contains the optional parameters for the DeploymentsClient.BeginCreateOrUpdate
// method.
type DeploymentsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DeploymentsClientBeginDeleteOptions contains the optional parameters for the DeploymentsClient.BeginDelete method.
type DeploymentsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DeploymentsClientGetOptions contains the optional parameters for the DeploymentsClient.Get method.
type DeploymentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientListOptions contains the optional parameters for the DeploymentsClient.List method.
type DeploymentsClientListOptions struct {
	// placeholder for future optional parameters
}

// DomainAvailability - Domain availability.
type DomainAvailability struct {
	// Indicates the given SKU is available or not.
	IsSubdomainAvailable *bool `json:"isSubdomainAvailable,omitempty"`

	// The Kind of the resource.
	Kind *string `json:"kind,omitempty"`

	// Reason why the SKU is not available.
	Reason *string `json:"reason,omitempty"`

	// The subdomain name to use.
	SubdomainName *string `json:"subdomainName,omitempty"`

	// The Type of the resource.
	Type *string `json:"type,omitempty"`
}

// Encryption - Properties to configure Encryption
type Encryption struct {
	// Enumerates the possible value of keySource for Encryption
	KeySource *KeySource `json:"keySource,omitempty"`

	// Properties of KeyVault
	KeyVaultProperties *KeyVaultProperties `json:"keyVaultProperties,omitempty"`
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorDetail `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// IPRule - A rule governing the accessibility from a specific ip address or ip range.
type IPRule struct {
	// REQUIRED; An IPv4 address range in CIDR notation, such as '124.56.78.91' (simple IP address) or '124.56.78.0/24' (all addresses
	// that start with 124.56.78).
	Value *string `json:"value,omitempty"`
}

// Identity for the resource.
type Identity struct {
	// The identity type.
	Type *ResourceIdentityType `json:"type,omitempty"`

	// The list of user assigned identities associated with the resource. The user identity dictionary key references will be
	// ARM resource ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}
	UserAssignedIdentities map[string]*UserAssignedIdentity `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// KeyVaultProperties - Properties to configure keyVault Properties
type KeyVaultProperties struct {
	IdentityClientID *string `json:"identityClientId,omitempty"`

	// Name of the Key from KeyVault
	KeyName *string `json:"keyName,omitempty"`

	// Uri of KeyVault
	KeyVaultURI *string `json:"keyVaultUri,omitempty"`

	// Version of the Key from KeyVault
	KeyVersion *string `json:"keyVersion,omitempty"`
}

// ManagementClientCheckDomainAvailabilityOptions contains the optional parameters for the ManagementClient.CheckDomainAvailability
// method.
type ManagementClientCheckDomainAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// ManagementClientCheckSKUAvailabilityOptions contains the optional parameters for the ManagementClient.CheckSKUAvailability
// method.
type ManagementClientCheckSKUAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// MetricName - A metric name.
type MetricName struct {
	// The friendly name of the metric.
	LocalizedValue *string `json:"localizedValue,omitempty"`

	// The name of the metric.
	Value *string `json:"value,omitempty"`
}

// ModelDeprecationInfo - Cognitive Services account ModelDeprecationInfo.
type ModelDeprecationInfo struct {
	// The datetime of deprecation of the fineTune Model.
	FineTune *string `json:"fineTune,omitempty"`

	// The datetime of deprecation of the inference Model.
	Inference *string `json:"inference,omitempty"`
}

// NetworkRuleSet - A set of rules governing the network accessibility.
type NetworkRuleSet struct {
	// The default action when no rule from ipRules and from virtualNetworkRules match. This is only used after the bypass property
	// has been evaluated.
	DefaultAction *NetworkRuleAction `json:"defaultAction,omitempty"`

	// The list of IP address rules.
	IPRules []*IPRule `json:"ipRules,omitempty"`

	// The list of virtual network rules.
	VirtualNetworkRules []*VirtualNetworkRule `json:"virtualNetworkRules,omitempty"`
}

// Operation - Details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Localized display information for this particular operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
	ActionType *ActionType `json:"actionType,omitempty" azure:"ro"`

	// READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane
	// operations.
	IsDataAction *bool `json:"isDataAction,omitempty" azure:"ro"`

	// READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write",
	// "Microsoft.Compute/virtualMachines/capture/action"
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
	// value is "user,system"
	Origin *Origin `json:"origin,omitempty" azure:"ro"`
}

// OperationDisplay - Localized display information for this particular operation.
type OperationDisplay struct {
	// READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual
	// Machine", "Restart Virtual Machine".
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft
	// Compute".
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job
	// Schedule Collections".
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationListResult - A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to
// get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of operations supported by the resource provider
	Value []*Operation `json:"value,omitempty" azure:"ro"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpoint - The Private Endpoint resource.
type PrivateEndpoint struct {
	// READ-ONLY; The ARM identifier for Private Endpoint
	ID *string `json:"id,omitempty" azure:"ro"`
}

// PrivateEndpointConnection - The Private Endpoint Connection resource.
type PrivateEndpointConnection struct {
	// The location of the private endpoint connection
	Location *string `json:"location,omitempty"`

	// Resource properties.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionListResult - A list of private endpoint connections
type PrivateEndpointConnectionListResult struct {
	// Array of private endpoint connections
	Value []*PrivateEndpointConnection `json:"value,omitempty"`
}

// PrivateEndpointConnectionProperties - Properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionProperties struct {
	// REQUIRED; A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`

	// The private link resource group ids.
	GroupIDs []*string `json:"groupIds,omitempty"`

	// The resource of private end point.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`

	// READ-ONLY; The provisioning state of the private endpoint connection resource.
	ProvisioningState *PrivateEndpointConnectionProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionsClientBeginCreateOrUpdateOptions contains the optional parameters for the PrivateEndpointConnectionsClient.BeginCreateOrUpdate
// method.
type PrivateEndpointConnectionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsClientBeginDeleteOptions contains the optional parameters for the PrivateEndpointConnectionsClient.BeginDelete
// method.
type PrivateEndpointConnectionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsClientGetOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Get
// method.
type PrivateEndpointConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientListOptions contains the optional parameters for the PrivateEndpointConnectionsClient.List
// method.
type PrivateEndpointConnectionsClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// Resource properties.
	Properties *PrivateLinkResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// Array of private link resources
	Value []*PrivateLinkResource `json:"value,omitempty"`
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// The private link resource Private link DNS zone name.
	RequiredZoneNames []*string `json:"requiredZoneNames,omitempty"`

	// READ-ONLY; The private link resource display name.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty" azure:"ro"`

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string `json:"requiredMembers,omitempty" azure:"ro"`
}

// PrivateLinkResourcesClientListOptions contains the optional parameters for the PrivateLinkResourcesClient.List method.
type PrivateLinkResourcesClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer
// and provider.
type PrivateLinkServiceConnectionState struct {
	// A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string `json:"actionsRequired,omitempty"`

	// The reason for approval/rejection of the connection.
	Description *string `json:"description,omitempty"`

	// Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
	Status *PrivateEndpointServiceConnectionStatus `json:"status,omitempty"`
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

type QuotaLimit struct {
	Count         *float32          `json:"count,omitempty"`
	RenewalPeriod *float32          `json:"renewalPeriod,omitempty"`
	Rules         []*ThrottlingRule `json:"rules,omitempty"`
}

// RegenerateKeyParameters - Regenerate key parameters.
type RegenerateKeyParameters struct {
	// REQUIRED; key name to generate (Key1|Key2)
	KeyName *KeyName `json:"keyName,omitempty"`
}

type RequestMatchPattern struct {
	Method *string `json:"method,omitempty"`
	Path   *string `json:"path,omitempty"`
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceSKU - Describes an available Cognitive Services SKU.
type ResourceSKU struct {
	// The Kind of resources that are supported in this SKU.
	Kind *string `json:"kind,omitempty"`

	// The set of locations that the SKU is available.
	Locations []*string `json:"locations,omitempty"`

	// The name of SKU.
	Name *string `json:"name,omitempty"`

	// The type of resource the SKU applies to.
	ResourceType *string `json:"resourceType,omitempty"`

	// The restrictions because of which SKU cannot be used. This is empty if there are no restrictions.
	Restrictions []*ResourceSKURestrictions `json:"restrictions,omitempty"`

	// Specifies the tier of Cognitive Services account.
	Tier *string `json:"tier,omitempty"`
}

// ResourceSKUListResult - The Get Skus operation response.
type ResourceSKUListResult struct {
	// REQUIRED; The list of skus available for the subscription.
	Value []*ResourceSKU `json:"value,omitempty"`

	// The uri to fetch the next page of Skus.
	NextLink *string `json:"nextLink,omitempty"`
}

type ResourceSKURestrictionInfo struct {
	// Locations where the SKU is restricted
	Locations []*string `json:"locations,omitempty"`

	// List of availability zones where the SKU is restricted.
	Zones []*string `json:"zones,omitempty"`
}

// ResourceSKURestrictions - Describes restrictions of a SKU.
type ResourceSKURestrictions struct {
	// The reason for restriction.
	ReasonCode *ResourceSKURestrictionsReasonCode `json:"reasonCode,omitempty"`

	// The information about the restriction where the SKU cannot be used.
	RestrictionInfo *ResourceSKURestrictionInfo `json:"restrictionInfo,omitempty"`

	// The type of restrictions.
	Type *ResourceSKURestrictionsType `json:"type,omitempty"`

	// The value of restrictions. If the restriction type is set to location. This would be different locations where the SKU
	// is restricted.
	Values []*string `json:"values,omitempty"`
}

// ResourceSKUsClientListOptions contains the optional parameters for the ResourceSKUsClient.List method.
type ResourceSKUsClientListOptions struct {
	// placeholder for future optional parameters
}

// SKU - The resource model definition representing SKU
type SKU struct {
	// REQUIRED; The name of the SKU. Ex - P3. It is typically a letter+number code
	Name *string `json:"name,omitempty"`

	// If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the
	// resource this may be omitted.
	Capacity *int32 `json:"capacity,omitempty"`

	// If the service has different generations of hardware, for the same SKU, then that can be captured here.
	Family *string `json:"family,omitempty"`

	// The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
	Size *string `json:"size,omitempty"`

	// This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required
	// on a PUT.
	Tier *SKUTier `json:"tier,omitempty"`
}

// SKUAvailability - SKU availability.
type SKUAvailability struct {
	// The Kind of the resource.
	Kind *string `json:"kind,omitempty"`

	// Additional error message.
	Message *string `json:"message,omitempty"`

	// Reason why the SKU is not available.
	Reason *string `json:"reason,omitempty"`

	// Indicates the given SKU is available or not.
	SKUAvailable *bool `json:"skuAvailable,omitempty"`

	// The SKU of Cognitive Services account.
	SKUName *string `json:"skuName,omitempty"`

	// The Type of the resource.
	Type *string `json:"type,omitempty"`
}

// SKUAvailabilityListResult - Check SKU availability result list.
type SKUAvailabilityListResult struct {
	// Check SKU availability result list.
	Value []*SKUAvailability `json:"value,omitempty"`
}

// SKUCapability - SkuCapability indicates the capability of a certain feature.
type SKUCapability struct {
	// The name of the SkuCapability.
	Name *string `json:"name,omitempty"`

	// The value of the SkuCapability.
	Value *string `json:"value,omitempty"`
}

// SKUChangeInfo - Sku change info of account.
type SKUChangeInfo struct {
	// Gets the count of downgrades.
	CountOfDowngrades *float32 `json:"countOfDowngrades,omitempty"`

	// Gets the count of upgrades after downgrades.
	CountOfUpgradesAfterDowngrades *float32 `json:"countOfUpgradesAfterDowngrades,omitempty"`

	// Gets the last change date.
	LastChangeDate *string `json:"lastChangeDate,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

type ThrottlingRule struct {
	Count                    *float32               `json:"count,omitempty"`
	DynamicThrottlingEnabled *bool                  `json:"dynamicThrottlingEnabled,omitempty"`
	Key                      *string                `json:"key,omitempty"`
	MatchPatterns            []*RequestMatchPattern `json:"matchPatterns,omitempty"`
	MinCount                 *float32               `json:"minCount,omitempty"`
	RenewalPeriod            *float32               `json:"renewalPeriod,omitempty"`
}

// Usage - The usage data for a usage request.
type Usage struct {
	// Current value for this metric.
	CurrentValue *float64 `json:"currentValue,omitempty"`

	// Maximum value for this metric.
	Limit *float64 `json:"limit,omitempty"`

	// The name information for the metric.
	Name *MetricName `json:"name,omitempty"`

	// Next reset time for current quota.
	NextResetTime *string `json:"nextResetTime,omitempty"`

	// The quota period used to summarize the usage values.
	QuotaPeriod *string `json:"quotaPeriod,omitempty"`

	// Cognitive Services account quota usage status.
	Status *QuotaUsageStatus `json:"status,omitempty"`

	// The unit of the metric.
	Unit *UnitType `json:"unit,omitempty"`
}

// UsageListResult - The response to a list usage request.
type UsageListResult struct {
	// The list of usages for Cognitive Service account.
	Value []*Usage `json:"value,omitempty"`
}

// UserAssignedIdentity - User-assigned managed identity.
type UserAssignedIdentity struct {
	// READ-ONLY; Client App Id associated with this identity.
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; Azure Active Directory principal ID associated with this Identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`
}

// UserOwnedStorage - The user owned storage for Cognitive Services account.
type UserOwnedStorage struct {
	IdentityClientID *string `json:"identityClientId,omitempty"`

	// Full resource id of a Microsoft.Storage resource.
	ResourceID *string `json:"resourceId,omitempty"`
}

// VirtualNetworkRule - A rule governing the accessibility from a specific virtual network.
type VirtualNetworkRule struct {
	// REQUIRED; Full resource id of a vnet subnet, such as '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1'.
	ID *string `json:"id,omitempty"`

	// Ignore missing vnet service endpoint or not.
	IgnoreMissingVnetServiceEndpoint *bool `json:"ignoreMissingVnetServiceEndpoint,omitempty"`

	// Gets the state of virtual network rule.
	State *string `json:"state,omitempty"`
}
