%{
#include "ghmm/sequence.h"
#include "ghmm/obsolete.h"
%}

/*==========================================================================
  ===== discrete sequences ================================================= */
typedef struct ghmm_dseq {
  /** sequence array. sequence[i] [j] = j-th symbol of i-th seq.
   */
  int **seq;

  /** matrix of state ids, can be used to save the viterbi path during sequence generation.
      ATTENTION: is NOT allocated by ghmm_dseq_calloc  */
  int **states;

  /** array of sequence length */
  int *seq_len;
  /** array of state path lengths */
  int *states_len;

#ifdef GHMM_OBSOLETE
  /**  array of sequence labels */
  long *seq_label;
#endif /* GHMM_OBSOLETE */
  /**  array of sequence IDs*/
  double *seq_id;
  /** positiv! sequence weights.  default is 1 = no weight */
  double *seq_w;
  /** total number of sequences */
  long seq_number;
  /** reserved space for sequences is always >= seq_number */
  long capacity;
  /** sum of sequence weights */
  double total_w;

  /** matrix of state labels corresponding to seq */
  int **state_labels;
  /** number of labels for each sequence */
  int *state_labels_len;

  /** flags internal */
  unsigned int flags;
} ghmm_dseq;

extern int ghmm_dseq_free(ghmm_dseq **sq);
extern ghmm_dseq* ghmm_dseq_calloc(long number);

%extend ghmm_dseq {
%apply SWIGTYPE* DISOWN {ghmm_dseq* seq};
        ghmm_dseq(ghmm_dseq* seq) { return seq; }
%clear ghmm_dseq* seq;
        ghmm_dseq(long number) { return ghmm_dseq_calloc(number); }
        ghmm_dseq(const char *filename, ghmm_alphabet *alphabet)
        {
            return ghmm_dseq_open_fasta(filename, alphabet);
        }
        ghmm_dseq(int* seq, int length) {
            ghmm_dseq* self = ghmm_dseq_calloc(1);
            self->seq[0] = seq;
            self->seq_len[0] = length;
            return self;
        }
        ghmm_dseq(int** seqs, int* lengths, int number) {
            ghmm_dseq* self = ghmm_dseq_calloc(number);
            free(self->seq);
            free(self->seq_len);
            self->seq = seqs;
            self->seq_len = lengths;
            return self;
        }
        ~ghmm_dseq() { ghmm_dseq_free(&self); }

        void init_labels(int* label, int length) {
            self->state_labels = malloc(sizeof(int*));
            self->state_labels_len = malloc(sizeof(int));
            self->state_labels[0] = label;
            self->state_labels_len[0] = length;
        }
        void init_labels(int** labels, int* lengths) {
            self->state_labels = labels;
            self->state_labels_len = lengths;
        }

        int calloc_state_labels(); 

        ghmm_dseq* get_singlesequence(int index);

%apply SWIGTYPE* DISOWN {ghmm_dseq* self};
        int subseq_free();
%clear ghmm_dseq* self;

        int max_symbol();

        int add(ghmm_dseq *source);

        int check(int max_symb);

        void clean();

        int* getSequence(int index) { return self->seq[index]; }
        void setSequence(int seqno, int *O) { self->seq[seqno] = O; }
        int getSymbol(int seqno, int index) { return self->seq[seqno][index]; }
        void setSymbol(int seqno, int index, int value) { self->seq[seqno][index] = value; }

        int  getLength(int i) { return self->seq_len[i]; }
        void setLength(int i, int len) { self->seq_len[i] = len; }

        double getWeight(int i) { return self->seq_w[i]; }
        void   setWeight(int i, double w) { self->seq_w[i] = w; }

        int* getLabels(int index) {
            if (self->state_labels) return self->state_labels[index];
            else return NULL;
        }
        void setLabels(int index, int* labels) {
            if (self->state_labels) self->state_labels[index] = labels;
        }

        int  getLabelsLength(int i) { return self->state_labels_len[i]; }
        void setLabelsLength(int i, int len) { self->state_labels_len[i] = len; }

        void copyStateLabel(int index, ghmm_dseq *target, int no)
            {
                int length = self->state_labels_len[index];
                target->state_labels_len[no] = length;
                target->state_labels[no]= malloc(self->state_labels_len[index] * sizeof(int));
                memcpy(target->state_labels[no], self->state_labels[index], length);
            }

        void write(char* filename)
            {
                FILE* file;
                file = fopen(filename, "at");
                if (file)
                {
                        ghmm_dseq_print(self, file);
                        fclose(file);
                }
                else
                        PyErr_SetString(PyExc_TypeError,"Expecting a sequence");
            }
}

// ignore the input value for int array to python list conversion
%typemap(in, numinputs=0) int *seq_arrays (int temp) {
    $1 = &temp;
}
// convert array of ints to python list
%typemap(argout) (int *seq_arrays) {
    int i;
    PyObject *obj;
    Py_XDECREF($result);   /* Blow away any previous result */
    if (result) {
        $result = PyList_New(*$1);
        for (i=0; i<*$1; i++) {
            obj = SWIG_NewPointerObj(result[i], SWIGTYPE_p_ghmm_dseq, SWIG_POINTER_NEW);
            PyList_SetItem($result, i, obj);
        }
        free(result);
    }
    else {
        PyErr_SetString(PyExc_ValueError,"got a null pointer");
        return NULL;
    }
}

#ifdef GHMM_OBSOLETE
extern ghmm_dseq **ghmm_dseq_read(const char *filename, int *seq_arrays);
#endif /* GHMM_OBSOLETE */

REFERENCE_ARRAY(ghmm_dseq, dseq_ptr)
