# GUAVA, chapter 5
#
# DO NOT EDIT THIS FILE - EDIT EXAMPLES IN THE SOURCE INSTEAD!
#
# This file has been generated by AutoDoc. It contains examples extracted from
# the package documentation. Each example is preceded by a comment which gives
# the name of a GAPDoc XML file and a line range from which the example were
# taken. Note that the XML file in turn may have been generated by AutoDoc
# from some other input.
#
gap> START_TEST("guava05.tst");

# doc/guava.xml:4513-4521
gap> M := Z(3)^0 * [ [1, 0, 1, 1], [2, 2, 0, 0], [0, 1, 2, 2] ];;
gap> C := ElementsCode( M, "example code", GF(3) );
a (4,3,1..4)2 example code over GF(3)
gap> MinimumDistance( C );
4
gap> AsSSortedList( C );
[ [ 0 1 2 2 ], [ 1 0 1 1 ], [ 2 2 0 0 ] ]

# doc/guava.xml:4582-4595
gap> H4 := [[1,1,1,1],[1,-1,1,-1],[1,1,-1,-1],[1,-1,-1,1]];;
gap> HadamardCode( H4, 1 );
a (3,4,2)1 Hadamard code of order 4 over GF(2)
gap> HadamardCode( H4, 2 );
a (3,8,1)0 Hadamard code of order 4 over GF(2)
gap> HadamardCode( H4 );
a (4,8,2)1 Hadamard code of order 4 over GF(2)
gap> H4 := [[1,1,1,1],[1,-1,1,-1],[1,1,-1,-1],[1,-1,-1,1]];;
gap> C := HadamardCode( 4 );
a (4,8,2)1 Hadamard code of order 4 over GF(2)
gap> C = HadamardCode( H4 );
true

# doc/guava.xml:4632-4645
gap> H6 := [[0,1,1,1,1,1],[1,0,1,-1,-1,1],[1,1,0,1,-1,-1],
> [1,-1,1,0,1,-1],[1,-1,-1,1,0,1],[1,1,-1,-1,1,0]];;
gap> C1 := ConferenceCode( H6 );
a (5,12,2)1..4 conference code over GF(2)
gap> IsLinearCode( C1 );
false
gap> C2 := ConferenceCode( 5 );
a (5,12,2)1..4 conference code over GF(2)
gap> AsSSortedList( C2 );
[ [ 0 0 0 0 0 ], [ 0 0 1 1 1 ], [ 0 1 0 1 1 ], [ 0 1 1 0 1 ], [ 0 1 1 1 0 ], 
  [ 1 0 0 1 1 ], [ 1 0 1 0 1 ], [ 1 0 1 1 0 ], [ 1 1 0 0 1 ], [ 1 1 0 1 0 ], 
  [ 1 1 1 0 0 ], [ 1 1 1 1 1 ] ]

# doc/guava.xml:4677-4692
gap> C1 := MOLSCode( 6, 5 );
a (6,25,5)3..4 code generated by 4 MOLS of order 5 over GF(5)
gap> mols := List( [1 .. WordLength(C1) - 2 ], function( nr )
>       local ls, el;
>       ls := NullMat( Size(LeftActingDomain(C1)), Size(LeftActingDomain(C1)) );
>       for el in VectorCodeword( AsSSortedList( C1 ) ) do
>          ls[IntFFE(el[1])+1][IntFFE(el[2])+1] := el[nr + 2];
>       od;
>       return ls;
>    end );;
gap> AreMOLS( mols );
true
gap> C2 := MOLSCode( 11 );
a (4,121,3)2 code generated by 2 MOLS of order 11 over GF(11)

# doc/guava.xml:4720-4729
gap> C1 := RandomCode( 6, 10, GF(8) );
a (6,10,1..6)4..6 random unrestricted code over GF(8)
gap> MinimumDistance(C1);
2
gap> C2 := RandomCode( 6, 10, GF(8) );
a (6,10,1..6)4..6 random unrestricted code over GF(8)
gap> C1 = C2;
false

# doc/guava.xml:4746-4751
gap> C := NordstromRobinsonCode();
a (16,256,6)4 Nordstrom-Robinson code over GF(2)
gap> OptimalityCode( C );
0

# doc/guava.xml:4778-4786
gap> C1 := GreedyCode( Tuples( AsSSortedList( GF(2) ), 5 ), 3, GF(2) );
a (5,4,3..5)2 Greedy code, user defined basis over GF(2)
gap> C2 := GreedyCode( Permuted( Tuples( AsSSortedList( GF(2) ), 5 ),
>                         (1,4) ), 3, GF(2) );
a (5,4,3..5)2 Greedy code, user defined basis over GF(2)
gap> C1 = C2;
false

# doc/guava.xml:4818-4824
gap> C := LexiCode( 4, 3, GF(5) );
a (4,17,3..4)2..4 lexicode over GF(5)
gap> B := [ [Z(2)^0, 0*Z(2), 0*Z(2)], [Z(2)^0, Z(2)^0, 0*Z(2)] ];;
gap> C := LexiCode( B, 2, GF(2) );
a linear [3,1,2]1..2 lexicode over GF(2)

# doc/guava.xml:4884-4893
gap> G := Z(3)^0 * [[1,0,1,2,0],[0,1,2,1,1],[0,0,1,2,1]];;
gap> C1 := GeneratorMatCode( G, GF(3) );
a linear [5,3,1..2]1..2 code defined by generator matrix over GF(3)
gap> C2 := GeneratorMatCode( IdentityMat( 5, GF(2) ), GF(2) );
a linear [5,5,1]0 code defined by generator matrix over GF(2)
gap> GeneratorMatCode( List( AsSSortedList( NordstromRobinsonCode() ),
> x -> VectorCodeword( x ) ), GF( 2 ) ); # This is the smallest linear code that contains the N-R code 
a linear [16,11,1..4]2 code defined by generator matrix over GF(2)

# doc/guava.xml:4932-4942
gap> G := Z(3)^0 * [[1,0,1,2,0],[0,1,2,1,1],[0,0,1,2,1]];;
gap> C1 := CheckMatCode( G, GF(3) );
a linear [5,2,1..2]2..3 code defined by check matrix over GF(3)
gap> CheckMat(C1);
[ [ Z(3)^0, 0*Z(3), Z(3)^0, Z(3), 0*Z(3) ], 
  [ 0*Z(3), Z(3)^0, Z(3), Z(3)^0, Z(3)^0 ], 
  [ 0*Z(3), 0*Z(3), Z(3)^0, Z(3), Z(3)^0 ] ]
gap> C2 := CheckMatCode( IdentityMat( 5, GF(2) ), GF(2) );
a cyclic [5,0,5]5 code defined by check matrix over GF(2)

# doc/guava.xml:4970-4975
gap> C1 := HammingCode( 4, GF(2) );
a linear [15,11,3]1 Hamming (4,2) code over GF(2)
gap> C2 := HammingCode( 3, GF(9) );
a linear [91,88,3]1 Hamming (3,9) code over GF(9)

# doc/guava.xml:5001-5004
gap> ReedMullerCode( 1, 3 );
a linear [8,4,4]2 Reed-Muller (1,3) code over GF(2)

# doc/guava.xml:5038-5043
gap> Y := [ 1, 1, 1, 1, 1, 1, 1];; a := PrimitiveUnityRoot( 2, 7 );;
gap> alpha := List( [0..6], i -> a^i );;
gap> C := AlternantCode( 2, Y, alpha, GF(8) );
a linear [7,3,3..4]3..4 alternant code over GF(8)

# doc/guava.xml:5085-5106
gap> x:=Indeterminate(GF(8),"x");
x
gap> L:=Elements(GF(8));
[ 0*Z(2), Z(2)^0, Z(2^3), Z(2^3)^2, Z(2^3)^3, Z(2^3)^4, Z(2^3)^5, Z(2^3)^6 ]
gap> g:=x^2+x+1;
x^2+x+Z(2)^0
gap> C:=GoppaCode(g,L);
a linear [8,2,5]3 classical Goppa code over GF(2)
gap> xx := Indeterminate( GF(2), "xx" );; 
gap> gg := xx^2 + xx + 1;; L := AsSSortedList( GF(8) );;
gap> C1 := GoppaCode( gg, L );
a linear [8,2,5]3 classical Goppa code over GF(2)
gap> y := Indeterminate( GF(2), "y" );; 
gap> h := y^2 + y + 1;;
gap> C2 := GoppaCode( h, 8 );
a linear [8,2,5]3 classical Goppa code over GF(2)
gap> C1=C2;
true
gap> C=C1;
true

# doc/guava.xml:5155-5160
gap> a := Filtered( AsSSortedList( GF(2^6) ), e -> e in GF(2^3) );;
gap> w := [ Z(2^6) ];; z := List( [1..8], e -> 1 );;
gap> C := GeneralizedSrivastavaCode( a, w, z, 1, GF(64) );
a linear [8,2,2..5]3..4 generalized Srivastava code over GF(2)

# doc/guava.xml:5199-5206
gap> a := AsSSortedList( GF(11) ){[2..8]};;
gap> w := AsSSortedList( GF(11) ){[9..10]};;
gap> C := SrivastavaCode( a, w, 2, GF(11) );
a linear [7,5,3]2 Srivastava code over GF(11)
gap> IsMDSCode( C );     # Always true if F is a prime field 
true

# doc/guava.xml:5234-5240
gap> C := CordaroWagnerCode( 11 );
a linear [11,2,7]5 Cordaro-Wagner code over GF(2)
gap> AsSSortedList(C);                 
[ [ 0 0 0 0 0 0 0 0 0 0 0 ], [ 0 0 0 0 1 1 1 1 1 1 1 ], 
  [ 1 1 1 1 0 0 0 1 1 1 1 ], [ 1 1 1 1 1 1 1 0 0 0 0 ] ]

# doc/guava.xml:5291-5312
gap> G:=AbelianGroup([5,5] );
<pc group of size 25 with 2 generators>
gap> FpfAutomorphismGroupsMaxSize( G );
[ 24, 2 ]
gap> L:=FpfAutomorphismGroupsCyclic( [5,5], 3 );
[ [ [ f1, f2 ] -> [ f1*f2^2, f1*f2^3 ] ], 
  <pc group of size 25 with 2 generators> ]
gap> D := DesignFromFerreroPair( L[2], Group(L[1][1]), "*" );
<a 2 - ( 25, 3, 2 ) nearring generated design>
gap> M:=IncidenceMat( D );; Length(M); Length(TransposedMat(M));
25
200
gap> C1:=GeneratorMatCode(M*Z(2),GF(2));
a linear [200,25,1..24]62..100 code defined by generator matrix over GF(2)
gap> MinimumDistance(C1);
24
gap> C2:=FerreroDesignCode( [5,5],3);
a linear [200,25,1..24]62..100 code defined by generator matrix over GF(2)
gap> C1=C2;
true

# doc/guava.xml:5349-5354
gap> C := RandomLinearCode( 15, 4, GF(3) );
a  [15,4,?] randomly generated code over GF(3)
gap> Display(C);
a linear [15,4,1..6]6..10 random linear code over GF(3)

# doc/guava.xml:5419-5489
gap> C1 := BestKnownLinearCode( 23, 12, GF(2) );
a linear [23,12,7]3 punctured code
gap> C1 = BinaryGolayCode();  # it's constructed differently
false
gap> C1 := BestKnownLinearCode( 23, 12, GF(2) );
a linear [23,12,7]3 punctured code
gap> G1 := MutableCopyMat(GeneratorMat(C1));;
gap> PutStandardForm(G1);
()
gap> Display(G1);
 1 . . . . . . . . . . . 1 . 1 . 1 1 1 . . . 1
 . 1 . . . . . . . . . . 1 1 1 1 1 . . 1 . . .
 . . 1 . . . . . . . . . 1 1 . 1 . . 1 . 1 . 1
 . . . 1 . . . . . . . . 1 1 . . . 1 1 1 . 1 .
 . . . . 1 . . . . . . . 1 1 . . 1 1 . 1 1 . 1
 . . . . . 1 . . . . . . . 1 1 . . 1 1 . 1 1 1
 . . . . . . 1 . . . . . . . 1 1 . . 1 1 . 1 1
 . . . . . . . 1 . . . . 1 . 1 1 . 1 1 1 1 . .
 . . . . . . . . 1 . . . . 1 . 1 1 . 1 1 1 1 .
 . . . . . . . . . 1 . . . . 1 . 1 1 . 1 1 1 .
 . . . . . . . . . . 1 . 1 . 1 1 1 . . . 1 1 1
 . . . . . . . . . . . 1 . 1 . 1 1 1 . . . 1 1
gap> C2 := BinaryGolayCode();
a cyclic [23,12,7]3 binary Golay code over GF(2)
gap> G2 := MutableCopyMat(GeneratorMat(C2));;
gap> PutStandardForm(G2);
()
gap> Display(G2); ## Despite their generator matrices are different, they are equivalent codes, see below.
 1 . . . . . . . . . . . 1 . 1 . 1 1 1 . . . 1
 . 1 . . . . . . . . . . 1 1 1 1 1 . . 1 . . 1
 . . 1 . . . . . . . . . 1 1 . 1 . . 1 . 1 . 1
 . . . 1 . . . . . . . . 1 1 . . . 1 1 1 . 1 1
 . . . . 1 . . . . . . . 1 1 . . 1 1 . 1 1 . .
 . . . . . 1 . . . . . . . 1 1 . . 1 1 . 1 1 .
 . . . . . . 1 . . . . . . . 1 1 . . 1 1 . 1 1
 . . . . . . . 1 . . . . 1 . 1 1 . 1 1 1 1 . .
 . . . . . . . . 1 . . . . 1 . 1 1 . 1 1 1 1 .
 . . . . . . . . . 1 . . . . 1 . 1 1 . 1 1 1 1
 . . . . . . . . . . 1 . 1 . 1 1 1 . . . 1 1 .
 . . . . . . . . . . . 1 . 1 . 1 1 1 . . . 1 1
gap> IsEquivalent(C1,C2);
true
gap> CodeIsomorphism(C1,C2);
(4,14,6,12,5)(7,17,18,11,19)(8,22,13,21,16)(10,23,15,20)
gap> Display( BestKnownLinearCode( 81, 77, GF(4) ) );
a linear [81,77,3]2..3 shortened code of
a linear [85,81,3]1 Hamming (4,4) code over GF(4)
gap> C:=BestKnownLinearCode(174,72);
a linear [174,72,31..36]26..87 code defined by generator matrix over GF(2)
gap> bounds := BoundsMinimumDistance( 81, 77, GF(4) );
rec( 
  construction := 
    [ <Operation "ShortenedCode">, 
      [ [ <Operation "HammingCode">, [ 4, 4 ] ], [ 1, 2, 3, 4 ] ] ], k := 77, 
  lowerBound := 3, 
  lowerBoundExplanation := [ "Lb(81,77)=3, by shortening of:", 
      "Lb(85,81)=3, reference: Ham" ], n := 81, q := 4, 
  references := 
    rec( 
      Ham := [ "%T this reference is unknown, for more info", 
          "%T contact A.E. Brouwer (aeb@cwi.nl)" ], 
      cap := [ "%T this reference is unknown, for more info", 
          "%T contact A.E. Brouwer (aeb@cwi.nl)" ] ), upperBound := 3, 
  upperBoundExplanation := [ "Ub(81,77)=3, by considering shortening to:", 
      "Ub(18,14)=3, reference: cap" ] )
gap> C := BestKnownLinearCode( bounds );
a linear [81,77,3]2..3 shortened code
gap> C = BestKnownLinearCode(81, 77, GF(4) );
true

# doc/guava.xml:5626-5638
gap> GabidulinCode( 4, Z(4)^0, Z(4)^1 );
a linear [19,12,3]2 Gabidulin code (m=4) over GF(2)
gap> EnlargedGabidulinCode( 4, Z(4)^0, Z(4)^1, Z(16)^11 );
a linear [26,18,3]2 enlarged Gabidulin code (m=4) over GF(2)
gap> DavydovCode( 6, 3, Z(8)^1, Z(8)^5 );
a linear [13,7,4]2 Davydov code (r=6, v=3) over GF(2)
gap> TombakCode( 5, Z(32)^6, Z(16)^14, Z(16)^10, Z(4)^0, Z(4)^1 );
a linear [57,47,4]2 Tombak code (m=5) over GF(2)
gap> EnlargedTombakCode( 6, Z(32)^6, Z(16)^14, Z(16)^10,
> Z(4)^0, Z(4)^0, Z(32)^23 );
a linear [89,78,4]2 enlarged Tombak code (m=6) over GF(2)

# doc/guava.xml:5683-5692
gap> C:=BinaryGolayCode();
a cyclic [23,12,7]3 binary Golay code over GF(2)
gap> ExtendedBinaryGolayCode() = ExtendedCode(BinaryGolayCode());
true
gap> IsPerfectCode(C);
true
gap> IsCyclicCode(C);
true

# doc/guava.xml:5712-5723
gap> C := ExtendedBinaryGolayCode();
a linear [24,12,8]4 extended binary Golay code over GF(2)
gap> IsSelfDualCode(C);
true
gap> P := PuncturedCode(C);
a linear [23,12,7]3 punctured code
gap> P = BinaryGolayCode();
true
gap> IsCyclicCode(C);
false

# doc/guava.xml:5751-5758
gap> C:=TernaryGolayCode();
a cyclic [11,6,5]2 ternary Golay code over GF(3)
gap> ExtendedTernaryGolayCode() = ExtendedCode(TernaryGolayCode());
true
gap> IsCyclicCode(C);
true

# doc/guava.xml:5778-5789
gap> C := ExtendedTernaryGolayCode();
a linear [12,6,6]3 extended ternary Golay code over GF(3)
gap> IsSelfDualCode(C);
true
gap> P := PuncturedCode(C);
a linear [11,6,5]2 punctured code
gap> P = TernaryGolayCode();
true
gap> IsCyclicCode(C);
false

# doc/guava.xml:5840-5852
gap> C := BinaryGolayCode();
a cyclic [23,12,7]3 binary Golay code over GF(2)
gap> Set(NamesOfComponents(C));
[ "Dimension", "GeneratorMat", "GeneratorPol", 
  "GeneratorsOfLeftOperatorAdditiveGroup", "LeftActingDomain", 
  "MinimumWeightOfGenerators", "Redundancy", "Size", "SpecialDecoder", 
  "UpperBoundOptimalMinimumDistance", "WeightDistribution", "WordLength", 
  "boundsCoveringRadius", "lowerBoundMinimumDistance", "name", 
  "upperBoundMinimumDistance" ]
gap> C!.GeneratorPol;
x^11+x^10+x^6+x^5+x^4+x^2+Z(2)^0

# doc/guava.xml:5892-5903
gap> x:= Indeterminate( GF(2), "x" );; P:= x^2+1;
x^2+Z(2)^0
gap> C1 := GeneratorPolCode(P, 7, GF(2));
a cyclic [7,6,1..2]1 code defined by generator polynomial over GF(2)
gap> GeneratorPol( C1 );
x+Z(2)^0
gap> C2 := GeneratorPolCode( x+1, 7, GF(2)); 
a cyclic [7,6,1..2]1 code defined by generator polynomial over GF(2)
gap> GeneratorPol( C2 );
x+Z(2)^0

# doc/guava.xml:5931-5940
gap>  x := Indeterminate( GF(3), "x" );; P:= x^2+2;
x^2-Z(3)^0
gap> H := CheckPolCode(P, 7, GF(3));
a cyclic [7,1,7]4 code defined by check polynomial over GF(3)
gap> CheckPol(H);
x-Z(3)^0
gap> Gcd(P, X(GF(3))^7-1);
x-Z(3)^0

# doc/guava.xml:5978-5997
gap> a := PrimitiveUnityRoot( 3, 14 );
Z(3^6)^52
gap> C1 := RootsCode( 14, [ a^0, a, a^3 ] );
a cyclic [14,7,3..6]3..7 code defined by roots over GF(3)
gap> MinimumDistance( C1 );
4
gap> b := PrimitiveUnityRoot( 2, 15 );
Z(2^4)
gap> C2 := RootsCode( 15, [ b, b^2, b^3, b^4 ] );
a cyclic [15,7,5]3..5 code defined by roots over GF(2)
gap> C2 = BCHCode( 15, 5, GF(2) );
true
gap> C3 := RootsCode( 4, [ 1, 2 ], 5 );
a cyclic [4,2,2..3]2 code defined by roots over GF(5)
gap> RootsOfCode( C3 );
[ Z(5), Z(5)^2 ]
gap> C3 = ReedSolomonCode( 4, 3 );
true

# doc/guava.xml:6069-6080
gap> C1 := BCHCode( 15, 3, 5, GF(2) );
a cyclic [15,5,7]5 BCH code, delta=7, b=1 over GF(2)
gap> DesignedDistance( C1 );
7
gap> C2 := BCHCode( 23, 2, GF(2) );
a cyclic [23,12,5..7]3 BCH code, delta=5, b=1 over GF(2)
gap> DesignedDistance( C2 );       
5
gap> MinimumDistance(C2);
7

# doc/guava.xml:6113-6124
gap> C1 := ReedSolomonCode( 3, 2 );
a cyclic [3,2,2]1 Reed-Solomon code over GF(4)
gap> IsCyclicCode(C1);
true
gap> C2 := ReedSolomonCode( 4, 3 );
a cyclic [4,2,3]2 Reed-Solomon code over GF(5)
gap> RootsOfCode( C2 );
[ Z(5), Z(5)^2 ]
gap> IsMDSCode(C2);
true

# doc/guava.xml:6149-6154
gap> C := ExtendedReedSolomonCode(17, 13);
a linear [17,5,13]9..12 extended Reed Solomon code over GF(17)
gap> IsMDSCode(C);
true

# doc/guava.xml:6175-6193
gap> C1 := QRCode( 7, GF(2) );
a cyclic [7,4,3]1 quadratic residue code over GF(2)
gap> IsEquivalent( C1, HammingCode( 3, GF(2) ) );
true
gap> IsCyclicCode(C1);
true
gap> IsCyclicCode(HammingCode( 3, GF(2) ));
false
gap> C2 := QRCode( 11, GF(3) );
a cyclic [11,6,4..5]2 quadratic residue code over GF(3)
gap> C2 = TernaryGolayCode();
true
gap> Q1 := QRCode( 7, GF(2));
a cyclic [7,4,3]1 quadratic residue code over GF(2)
gap> P1:=AutomorphismGroup(Q1); IdGroup(P1);
Group([ (1,2)(5,7), (2,3)(4,7), (2,4)(5,6), (3,5)(6,7), (3,7)(5,6) ])
[ 168, 42 ]

# doc/guava.xml:6236-6264
gap> C1 := QQRCode( 7);
a linear [14,7,1..4]3..5 code defined by generator matrix over GF(2)
gap> G1:=GeneratorMat(C1);;
gap> Display(G1);
 . 1 1 . 1 . . . . . 1 . 1 1
 . . 1 1 . 1 . 1 . . . 1 . 1
 . . . 1 1 . 1 1 1 . . . 1 .
 1 . . . 1 1 . . 1 1 . . . 1
 . 1 . . . 1 1 1 . 1 1 . . .
 1 . 1 . . . 1 . 1 . 1 1 . .
 1 1 . 1 . . . . . 1 . 1 1 .
gap> Display(C1!.DoublyCirculant);
 . 1 1 . 1 . . . . . 1 . 1 1
 . . 1 1 . 1 . 1 . . . 1 . 1
 . . . 1 1 . 1 1 1 . . . 1 .
 1 . . . 1 1 . . 1 1 . . . 1
 . 1 . . . 1 1 1 . 1 1 . . .
 1 . 1 . . . 1 . 1 . 1 1 . .
 1 1 . 1 . . . . . 1 . 1 1 .
gap> MinimumDistance(C1);
4
gap> C2 := QQRCode( 29); MinimumDistance(C2);
a linear [58,28,1..14]8..29 code defined by generator matrix over GF(2)
12
gap> Aut2:=AutomorphismGroup(C2); IdGroup(Aut2);
<permutation group of size 812 with 4 generators>
[ 812, 7 ]

# doc/guava.xml:6320-6329
gap> x:= Indeterminate( GF(2), "x" );; G:= x^3+x^2+1;
x^3+x^2+Z(2)^0
gap> Factors( G );
[ x^3+x^2+Z(2)^0 ]
gap> C := FireCode( G, 3 );
a cyclic [35,27,1..4]2..6 3 burst error correcting fire code over GF(2)
gap> MinimumDistance( C );     # Still it can correct bursts of length 3 
4

# doc/guava.xml:6348-6351
gap> C := WholeSpaceCode( 5, GF(3) );
a cyclic [5,5,1]0 whole space code over GF(3)

# doc/guava.xml:6368-6373
gap> C := NullCode( 5, GF(3) );
a cyclic [5,0,5]5 nullcode over GF(3)
gap> AsSSortedList( C );
[ [ 0 0 0 0 0 ] ]

# doc/guava.xml:6390-6399
gap> C := RepetitionCode( 3, GF(5) );
a cyclic [3,1,3]2 repetition code over GF(5)
gap> AsSSortedList( C );
[ [ 0 0 0 ], [ 1 1 1 ], [ 2 2 2 ], [ 4 4 4 ], [ 3 3 3 ] ]
gap> IsPerfectCode( C );
false
gap> IsMDSCode( C );
true

# doc/guava.xml:6418-6424
gap> CyclicCodes(3,GF(3));
[ a cyclic [3,3,1]0 enumerated code over GF(3), 
  a cyclic [3,2,1..2]1 enumerated code over GF(3), 
  a cyclic [3,1,3]2 enumerated code over GF(3), 
  a cyclic [3,0,3]3 enumerated code over GF(3) ]

# doc/guava.xml:6439-6457
gap> NrCyclicCodes( 23, GF(2) );
8
gap> codelist := CyclicCodes( 23, GF(2) );
[ a cyclic [23,23,1]0 enumerated code over GF(2), 
  a cyclic [23,22,1..2]1 enumerated code over GF(2), 
  a cyclic [23,11,1..8]4..7 enumerated code over GF(2), 
  a cyclic [23,0,23]23 enumerated code over GF(2), 
  a cyclic [23,11,1..8]4..7 enumerated code over GF(2), 
  a cyclic [23,12,1..7]3 enumerated code over GF(2), 
  a cyclic [23,1,23]11 enumerated code over GF(2), 
  a cyclic [23,12,1..7]3 enumerated code over GF(2) ]
gap> BinaryGolayCode() in codelist;
true
gap> RepetitionCode( 23, GF(2) ) in codelist;
true
gap> CordaroWagnerCode( 23 ) in codelist;     # This code is not cyclic 
false

# doc/guava.xml:6486-6535
gap> #
gap> # This example show the case for k = s
gap> #
gap> L1 := PolyCodeword( Codeword("10000000000", GF(4)) );
Z(2)^0
gap> L2 := PolyCodeword( Codeword("12223201000", GF(4)) );
x^7+Z(2^2)*x^5+Z(2^2)^2*x^4+Z(2^2)*x^3+Z(2^2)*x^2+Z(2^2)*x+Z(2)^0
gap> L3 := PolyCodeword( Codeword("31111220110", GF(4)) );
x^9+x^8+Z(2^2)*x^6+Z(2^2)*x^5+x^4+x^3+x^2+x+Z(2^2)^2
gap> L4 := PolyCodeword( Codeword("13320333010", GF(4)) );
x^9+Z(2^2)^2*x^7+Z(2^2)^2*x^6+Z(2^2)^2*x^5+Z(2^2)*x^3+Z(2^2)^2*x^2+Z(2^2)^2*x+\
Z(2)^0
gap> L5 := PolyCodeword( Codeword("20102211100", GF(4)) );
x^8+x^7+x^6+Z(2^2)*x^5+Z(2^2)*x^4+x^2+Z(2^2)
gap> C := QuasiCyclicCode( [L1, L2, L3, L4, L5], 11, GF(4) );
a linear [55,11,1..32]24..41 quasi-cyclic code over GF(4)
gap> MinimumDistance(C);
29
gap> Display(C);
a linear [55,11,29]24..41 quasi-cyclic code over GF(4)
gap> #
gap> # This example show the case for k < s
gap> #
gap> L1 := PolyCodeword( Codeword("02212201220120211002000",GF(3)) );
-x^19+x^16+x^15-x^14-x^12+x^11-x^9-x^8+x^7-x^5-x^4+x^3-x^2-x
gap> L2 := PolyCodeword( Codeword("00221100200120220001110",GF(3)) );
x^21+x^20+x^19-x^15-x^14-x^12+x^11-x^8+x^5+x^4-x^3-x^2
gap> L3 := PolyCodeword( Codeword("22021011202221111020021",GF(3)) );
x^22-x^21-x^18+x^16+x^15+x^14+x^13-x^12-x^11-x^10-x^8+x^7+x^6+x^4-x^3-x-Z(3)^0
gap> C := QuasiCyclicCode( [L1, L2, L3], 23, GF(3) );
a linear [69,12,1..37]27..46 quasi-cyclic code over GF(3)
gap> MinimumDistance(C);
34
gap> Display(C);
a linear [69,12,34]27..46 quasi-cyclic code over GF(3)
gap> #
gap> # This example show the binary case using octal representation
gap> #
gap> L1 := 001;;   # 0 000 001
gap> L2 := 013;;   # 0 001 011
gap> L3 := 015;;   # 0 001 101
gap> L4 := 077;;   # 0 111 111
gap> C := QuasiCyclicCode( [L1, L2, L3, L4], 7 );
a linear [28,7,1..12]8..14 quasi-cyclic code over GF(2)
gap> MinimumDistance(C);
12
gap> Display(C);
a linear [28,7,12]8..14 quasi-cyclic code over GF(2)

# doc/guava.xml:6582-6595
gap> C:=CyclicMDSCode(2,6,24);
a cyclic [65,24,42]31..41 MDS code over GF(64)
gap> IsMDSCode(C);
true
gap> C:=CyclicMDSCode(5,3,77);
a cyclic [126,77,50]35..49 MDS code over GF(125)
gap> IsMDSCode(C);
true
gap> C:=CyclicMDSCode(3,3,25);
a cyclic [28,25,4]2..3 MDS code over GF(27)
gap> GeneratorPol(C);
x^3+Z(3^3)^7*x^2+Z(3^3)^20*x-Z(3)^0

# doc/guava.xml:6635-6670
gap> ax:=PolyCodeword(Codeword("1200200", GF(3)));
-x^4-x+Z(3)^0
gap> bx:=PolyCodeword(Codeword("2020221", GF(3)));
x^6-x^5-x^4-x^2-Z(3)^0
gap> C:=FourNegacirculantSelfDualCode(ax, bx, 14);;
gap> MinimumDistance(C);;
gap> CoveringRadius(C);;
gap> IsSelfDualCode(C);
true
gap> Display(C);
a linear [28,14,9]7 four-negacirculant self-dual code over GF(3)
gap> Display( GeneratorMat(C) );
 1 . . . . . . . . . . . . . 1 2 . . 2 . . 2 . 2 . 2 2 1
 . 1 . . . . . . . . . . . . . 1 2 . . 2 . 2 2 . 2 . 2 2
 . . 1 . . . . . . . . . . . . . 1 2 . . 2 1 2 2 . 2 . 2
 . . . 1 . . . . . . . . . . 1 . . 1 2 . . 1 1 2 2 . 2 .
 . . . . 1 . . . . . . . . . . 1 . . 1 2 . . 1 1 2 2 . 2
 . . . . . 1 . . . . . . . . . . 1 . . 1 2 1 . 1 1 2 2 .
 . . . . . . 1 . . . . . . . 1 . . 1 . . 1 . 1 . 1 1 2 2
 . . . . . . . 1 . . . . . . 1 1 2 2 . 2 . 1 . . 1 . . 1
 . . . . . . . . 1 . . . . . . 1 1 2 2 . 2 2 1 . . 1 . .
 . . . . . . . . . 1 . . . . 1 . 1 1 2 2 . . 2 1 . . 1 .
 . . . . . . . . . . 1 . . . . 1 . 1 1 2 2 . . 2 1 . . 1
 . . . . . . . . . . . 1 . . 1 . 1 . 1 1 2 2 . . 2 1 . .
 . . . . . . . . . . . . 1 . 1 1 . 1 . 1 1 . 2 . . 2 1 .
 . . . . . . . . . . . . . 1 2 1 1 . 1 . 1 . . 2 . . 2 1
gap> ax:=PolyCodeword(Codeword("013131000", GF(7)));
x_1^5+Z(7)*x_1^4+x_1^3+Z(7)*x_1^2+x_1
gap> bx:=PolyCodeword(Codeword("425435030", GF(7)));
Z(7)*x_1^7+Z(7)^5*x_1^5+Z(7)*x_1^4+Z(7)^4*x_1^3+Z(7)^5*x_1^2+Z(7)^2*x_1+Z(7)^4
gap> C:=FourNegacirculantSelfDualCodeNC(ax, bx, 18);
a linear [36,18,1..13]0..36 four-negacirculant self-dual code over GF(7)
gap> IsSelfDualCode(C);
true

# doc/guava.xml:6826-6841
gap> R:=PolynomialRing(GF(11),["t"]);
GF(11)[t]
gap> P:=List([1,3,4,5,7],i->Z(11)^i);
[ Z(11), Z(11)^3, Z(11)^4, Z(11)^5, Z(11)^7 ]
gap> C:=GeneralizedReedSolomonCode(P,3,R);
a linear [5,3,1..3]2  generalized Reed-Solomon code over GF(11)
gap> MinimumDistance(C);
3
gap> V:=[Z(11)^0,Z(11)^0,Z(11)^0,Z(11)^0,Z(11)];
[ Z(11)^0, Z(11)^0, Z(11)^0, Z(11)^0, Z(11) ]
gap> C:=GeneralizedReedSolomonCode(P,3,R,V);
a linear [5,3,1..3]2  weighted generalized Reed-Solomon code over GF(11)
gap> MinimumDistance(C);
3

# doc/guava.xml:6882-6891
gap> Pts:=ToricPoints(2,GF(5));
[ [ Z(5)^0, Z(5)^0 ], [ Z(5)^0, Z(5) ], [ Z(5)^0, Z(5)^2 ], 
  [ Z(5)^0, Z(5)^3 ], [ Z(5), Z(5)^0 ], [ Z(5), Z(5) ], [ Z(5), Z(5)^2 ], 
  [ Z(5), Z(5)^3 ], [ Z(5)^2, Z(5)^0 ], [ Z(5)^2, Z(5) ], [ Z(5)^2, Z(5)^2 ], 
  [ Z(5)^2, Z(5)^3 ], [ Z(5)^3, Z(5)^0 ], [ Z(5)^3, Z(5) ], 
  [ Z(5)^3, Z(5)^2 ], [ Z(5)^3, Z(5)^3 ] ]
gap> C:=GeneralizedReedMullerCode(Pts,2,GF(5));
a linear [16,6,1..11]6..10  generalized Reed-Muller code over GF(5)

# doc/guava.xml:6905-6912
gap> ToricPoints(2,GF(5));
[ [ Z(5)^0, Z(5)^0 ], [ Z(5)^0, Z(5) ], [ Z(5)^0, Z(5)^2 ], 
  [ Z(5)^0, Z(5)^3 ], [ Z(5), Z(5)^0 ], [ Z(5), Z(5) ], [ Z(5), Z(5)^2 ], 
  [ Z(5), Z(5)^3 ], [ Z(5)^2, Z(5)^0 ], [ Z(5)^2, Z(5) ], [ Z(5)^2, Z(5)^2 ], 
  [ Z(5)^2, Z(5)^3 ], [ Z(5)^3, Z(5)^0 ], [ Z(5)^3, Z(5) ], 
  [ Z(5)^3, Z(5)^2 ], [ Z(5)^3, Z(5)^3 ] ]

# doc/guava.xml:6940-6947
gap> C:=ToricCode([[1,0],[3,4]],GF(3));
a linear [4,1,4]2  toric code over GF(3)
gap> Display(GeneratorMat(C));
 1 1 2 2
gap> Elements(C);
[ [ 0 0 0 0 ], [ 1 1 2 2 ], [ 2 2 1 1 ] ]

# doc/guava.xml:7004-7033
gap> F:=GF(11);;
gap> R2:=PolynomialRing(F,2);
GF(11)[t,x_2]
gap> vars:=IndeterminatesOfPolynomialRing(R2);;
gap> x:=vars[1];; y:=vars[2];;
gap> poly:=y;; crvP1:=AffineCurve(poly,R2);
rec( polynomial := x_2, ring := GF(11)[t,x_2] )
gap> degree_crv:=DegreeMultivariatePolynomial(poly,R2);
1
gap> poly:=y^2-x*(x^2-1);; ell_crv:=AffineCurve(poly,R2);
rec( polynomial := -t^3+x_2^2+t, ring := GF(11)[t,x_2] )
gap> degree_crv:=DegreeMultivariatePolynomial(poly,R2);
3
gap> poly:=x^2+y^2-1;; circle:=AffineCurve(poly,R2);
rec( polynomial := t^2+x_2^2-Z(11)^0, ring := GF(11)[t,x_2] )
gap> degree_crv:=DegreeMultivariatePolynomial(poly,R2);
2
gap> q:=3;;
gap> F:=GF(q^2);;
gap> R:=PolynomialRing(F,2);;
gap> vars:=IndeterminatesOfPolynomialRing(R);
[ x, x_2 ]
gap> x:=vars[1];
x
gap> y:=vars[2];
x_2
gap> crv:=AffineCurve(y^q+y-x^(q+1),R);
rec( polynomial := -x^4+x_2^3+x_2, ring := GF(3^2)[x,x_2] )

# doc/guava.xml:7071-7082
gap> F:=GF(11);;
gap> R := PolynomialRing(F,["x","y"]);
GF(11)[x,y]
gap> indets := IndeterminatesOfPolynomialRing(R);;
gap> x:=indets[1];; y:=indets[2];;
gap> P:=AffinePointsOnCurve(y^2-x^11+x,R,F);
[ [ Z(11)^9, 0*Z(11) ], [ Z(11)^8, 0*Z(11) ], [ Z(11)^7, 0*Z(11) ], 
  [ Z(11)^6, 0*Z(11) ], [ Z(11)^5, 0*Z(11) ], [ Z(11)^4, 0*Z(11) ], 
  [ Z(11)^3, 0*Z(11) ], [ Z(11)^2, 0*Z(11) ], [ Z(11), 0*Z(11) ], 
  [ Z(11)^0, 0*Z(11) ], [ 0*Z(11), 0*Z(11) ] ]

# doc/guava.xml:7104-7117
gap> q:=4;;
gap> F:=GF(q^2);;
gap> a:=Indeterminate(F, "a");;
gap> R1:=PolynomialRing(F,[a]);;
gap> var1:=IndeterminatesOfPolynomialRing(R1);;
gap> b:=Indeterminate(F, "b");;
gap> R2:=PolynomialRing(F,[a,b]);;
gap> var2:=IndeterminatesOfPolynomialRing(R2);;
gap> crv:=AffineCurve(b^q+b-a^(q+1),R2);
rec( polynomial := a^5+b^4+b, ring := GF(2^4)[a,b] )
gap> GenusCurve(crv);
6

# doc/guava.xml:7134-7173
gap> R:= PolynomialRing( GF(43), 3 );;
gap> vars:= IndeterminatesOfPolynomialRing(R);;
gap> x:= vars[1];; y:= vars[2];; z:= vars[3];;
gap> zz:=Z(43)^6;
Z(43)^6
gap> zzz:=Z(43);
Z(43)
gap> rho1:=zz^0*[[zz^4,0,0],[0,zz^2,0],[0,0,zz]];
[ [ Z(43)^24, 0*Z(43), 0*Z(43) ], [ 0*Z(43), Z(43)^12, 0*Z(43) ], 
  [ 0*Z(43), 0*Z(43), Z(43)^6 ] ]
gap> rho2:=zz^0*[[0,1,0],[0,0,1],[1,0,0]];
[ [ 0*Z(43), Z(43)^0, 0*Z(43) ], [ 0*Z(43), 0*Z(43), Z(43)^0 ], 
  [ Z(43)^0, 0*Z(43), 0*Z(43) ] ]
gap> rho3:=(-1)*[[(zz-zz^6 )/zzz^7,( zz^2-zz^5 )/ zzz^7, ( zz^4-zz^3 )/ zzz^7],
>             [( zz^2-zz^5 )/ zzz^7, ( zz^4-zz^3 )/ zzz^7, ( zz-zz^6 )/ zzz^7],
>             [( zz^4-zz^3 )/ zzz^7, ( zz-zz^6 )/ zzz^7, ( zz^2-zz^5 )/ zzz^7]];
[ [ Z(43)^9, Z(43)^28, Z(43)^12 ], [ Z(43)^28, Z(43)^12, Z(43)^9 ], 
  [ Z(43)^12, Z(43)^9, Z(43)^28 ] ]
gap> G:=Group([rho1,rho2,rho3]);; #PSL(2,7)
gap> Size(G);
168
gap> P:=[1,0,0]*zzz^0;
[ Z(43)^0, 0*Z(43), 0*Z(43) ]
gap> O:=GOrbitPoint(G,P);
[ [ Z(43)^0, 0*Z(43), 0*Z(43) ], [ 0*Z(43), Z(43)^0, 0*Z(43) ], 
[ 0*Z(43), 0*Z(43), Z(43)^0 ], [ Z(43)^0, Z(43)^39, Z(43)^16 ], 
[ Z(43)^0, Z(43)^33, Z(43)^28 ], [ Z(43)^0, Z(43)^27, Z(43)^40 ],
[ Z(43)^0, Z(43)^21, Z(43)^10 ], [ Z(43)^0, Z(43)^15, Z(43)^22 ], 
[ Z(43)^0, Z(43)^9, Z(43)^34 ], [ Z(43)^0, Z(43)^3, Z(43)^4 ], 
[ Z(43)^3, Z(43)^22, Z(43)^6 ], [ Z(43)^3, Z(43)^16, Z(43)^18 ],
[ Z(43)^3, Z(43)^10, Z(43)^30 ], [ Z(43)^3, Z(43)^4, Z(43)^0 ], 
[ Z(43)^3, Z(43)^40, Z(43)^12 ], [ Z(43)^3, Z(43)^34, Z(43)^24 ], 
[ Z(43)^3, Z(43)^28, Z(43)^36 ], [ Z(43)^4, Z(43)^30, Z(43)^27 ],
[ Z(43)^4, Z(43)^24, Z(43)^39 ], [ Z(43)^4, Z(43)^18, Z(43)^9 ], 
[ Z(43)^4, Z(43)^12, Z(43)^21 ], [ Z(43)^4, Z(43)^6, Z(43)^33 ], 
[ Z(43)^4, Z(43)^0, Z(43)^3 ], [ Z(43)^4, Z(43)^36, Z(43)^15 ] ]
gap> Length(O);
24

# doc/guava.xml:7218-7239
gap> q:=5;
5
gap> F:=GF(q);
GF(5)
gap> R:=PolynomialRing(F,2);;
gap> vars:=IndeterminatesOfPolynomialRing(R);
[ x, x_2 ]
gap> x:=vars[1];
x
gap> y:=vars[2];
x_2
gap> crv:=AffineCurve(y^3-x^3-x-1,R);
rec( polynomial := -x^3+x_2^3-x-Z(5)^0, ring := GF(5)[x,x_2] )
gap> Pts:=AffinePointsOnCurve(crv!.polynomial,R,F);;
gap> supp:=[Pts[1],Pts[2]];
[ [ 0*Z(5), Z(5)^0 ], [ Z(5)^0, Z(5) ] ]
gap> D:=DivisorOnAffineCurve([1,-1],supp,crv);
rec( coeffs := [ 1, -1 ], 
  curve := rec( polynomial := -x^3+x_2^3-x-Z(5)^0, ring := GF(5)[x,x_2] ), 
  support := [ [ Z(5)^0, Z(5)^0 ], [ Z(5)^0, Z(5) ] ] )

# doc/guava.xml:7342-7401
gap> F:=GF(11);
GF(11)
gap> R1:=PolynomialRing(F,["a"]);;
gap> var1:=IndeterminatesOfPolynomialRing(R1);; a:=var1[1];;
gap> b:=X(F,"b",var1);
b
gap> var2:=Concatenation(var1,[b]);
[ a, b ]
gap> R2:=PolynomialRing(F,var2);
GF(11)[a,b]
gap> crvP1:=AffineCurve(b,R2);
rec( polynomial := b, ring := GF(11)[a,b] )
gap> div1:=DivisorOnAffineCurve([1,2,3,4],[Z(11)^2,Z(11)^3,Z(11)^7,Z(11)],crvP1);
rec( coeffs := [ 1, 2, 3, 4 ], 
  curve := rec( polynomial := b, ring := GF(11)[a,b] ), 
  support := [ Z(11)^2, Z(11)^3, Z(11)^7, Z(11) ] )
gap> DivisorDegree(div1);
10
gap> div2:=DivisorOnAffineCurve([1,2,3,4],[Z(11),Z(11)^2,Z(11)^3,Z(11)^4],crvP1);
rec( coeffs := [ 1, 2, 3, 4 ], 
  curve := rec( polynomial := b, ring := GF(11)[a,b] ), 
  support := [ Z(11), Z(11)^2, Z(11)^3, Z(11)^4 ] )
gap> DivisorDegree(div2);
10
gap> div3:=DivisorAddition(div1,div2);
rec( coeffs := [ 5, 3, 5, 4, 3 ], 
  curve := rec( polynomial := b, ring := GF(11)[a,b] ), 
  support := [ Z(11), Z(11)^2, Z(11)^3, Z(11)^4, Z(11)^7 ] )
gap> DivisorDegree(div3);
20
gap> DivisorIsEffective(div1);
true
gap> DivisorIsEffective(div2);
true
gap> ndiv1:=DivisorNegate(div1);
rec( coeffs := [ -1, -2, -3, -4 ], 
  curve := rec( polynomial := b, ring := GF(11)[a,b] ), 
  support := [ Z(11)^2, Z(11)^3, Z(11)^7, Z(11) ] )
gap> zdiv:=DivisorAddition(div1,ndiv1);
rec( coeffs := [ 0, 0, 0, 0 ], 
  curve := rec( polynomial := b, ring := GF(11)[a,b] ), 
  support := [ Z(11), Z(11)^2, Z(11)^3, Z(11)^7 ] )
gap> DivisorIsZero(zdiv);
true
gap> div_gcd:=DivisorGCD(div1,div2);
rec( coeffs := [ 1, 1, 2, 0, 0 ], 
  curve := rec( polynomial := b, ring := GF(11)[a,b] ), 
  support := [ Z(11), Z(11)^2, Z(11)^3, Z(11)^4, Z(11)^7 ] )
gap> div_lcm:=DivisorLCM(div1,div2);
rec( coeffs := [ 4, 2, 3, 4, 3 ], 
  curve := rec( polynomial := b, ring := GF(11)[a,b] ), 
  support := [ Z(11), Z(11)^2, Z(11)^3, Z(11)^4, Z(11)^7 ] )
gap> DivisorDegree(div_gcd);
4
gap> DivisorDegree(div_lcm);
16
gap> DivisorEqual(div3,DivisorAddition(div_gcd,div_lcm));
true

# doc/guava.xml:7468-7504

gap> F:=GF(11);
GF(11)
gap> R1:=PolynomialRing(F,["a"]);;
gap> var1:=IndeterminatesOfPolynomialRing(R1);; a:=var1[1];;
gap> b:=X(F,"b",var1);
b
gap> var2:=Concatenation(var1,[b]);
[ a, b ]
gap> R2:=PolynomialRing(F,var2);
GF(11)[a,b]
gap> pt:=Z(11);
Z(11)
gap> f:=RiemannRochSpaceBasisFunctionP1(pt,2,R2);
(Z(11)^0)/(a^2+Z(11)^7*a+Z(11)^2)
gap> Df:=DivisorOfRationalFunctionP1(f,R2);
rec( coeffs := [ -2 ], curve := rec( polynomial := a, ring := GF(11)[a,b] ), 
  support := [ Z(11) ] )
gap> Df.support;
[ Z(11) ]
gap> F:=GF(11);;
gap> R:=PolynomialRing(F,2);;
gap> vars:=IndeterminatesOfPolynomialRing(R);;
gap> a:=vars[1];;
gap> b:=vars[2];;
gap> f:=(a^4+Z(11)^6*a^3-a^2+Z(11)^7*a+Z(11)^0)/(a^4+Z(11)*a^2+Z(11)^7*a+Z(11));;
gap> divf:=DivisorOfRationalFunctionP1(f,R);
rec( coeffs := [ 3, 1 ], curve := rec( polynomial := t, ring := GF(11)[t,x] ),
  support := [ Z(11), Z(11)^7 ] )
gap> denf:=DenominatorOfRationalFunction(f); RootsOfUPol(denf);
t^4+Z(11)*t^2+Z(11)^7*t+Z(11)
[  ]
gap> numf:=NumeratorOfRationalFunction(f); RootsOfUPol(numf);
t^4+Z(11)^6*t^3-t^2+Z(11)^7*t+Z(11)^0
[ Z(11)^7, Z(11), Z(11), Z(11) ]

# doc/guava.xml:7544-7590
gap> F:=GF(11);
GF(11)
gap> R1:=PolynomialRing(F,["a"]);;
gap> var1:=IndeterminatesOfPolynomialRing(R1);; a:=var1[1];;
gap> b:=X(F,"b",var1);
b
gap> var2:=Concatenation(var1,[b]);
[ a, b ]
gap> R2:=PolynomialRing(F,var2);
GF(11)[a,b]
gap> crvP1:=AffineCurve(b,R2);
rec( polynomial := b, ring := GF(11)[a,b] )
gap> D:=DivisorOnAffineCurve([1,2,3,4],[Z(11)^2,Z(11)^3,Z(11)^7,Z(11)],crvP1);
rec( coeffs := [ 1, 2, 3, 4 ], 
  curve := rec( polynomial := b, ring := GF(11)[a,b] ), 
  support := [ Z(11)^2, Z(11)^3, Z(11)^7, Z(11) ] )
gap> B:=RiemannRochSpaceBasisP1(D);
[ (Z(11)^0)/(a+Z(11)^7), (Z(11)^0)/(a+Z(11)^8), 
  (Z(11)^0)/(a^2+Z(11)^9*a+Z(11)^6), (Z(11)^0)/(a+Z(11)^2), 
  (Z(11)^0)/(a^2+Z(11)^3*a+Z(11)^4), (Z(11)^0)/(a^3+a^2+Z(11)^2*a+Z(11)^6), 
  (Z(11)^0)/(a+Z(11)^6), (Z(11)^0)/(a^2+Z(11)^7*a+Z(11)^2), 
  (Z(11)^0)/(a^3+Z(11)^4*a^2+a+Z(11)^8), 
  (Z(11)^0)/(a^4+Z(11)^8*a^3+Z(11)*a^2+a+Z(11)^4), Z(11)^0 ]
gap> DivisorOfRationalFunctionP1(B[1],R2).support;
[  ]
gap> DivisorOfRationalFunctionP1(B[2],R2).support;
[ Z(11)^2 ]
gap> DivisorOfRationalFunctionP1(B[3],R2).support;
[ Z(11)^3 ]
gap> DivisorOfRationalFunctionP1(B[4],R2).support;
[ Z(11)^3 ]
gap> DivisorOfRationalFunctionP1(B[5],R2).support;
[ Z(11)^7 ]
gap> DivisorOfRationalFunctionP1(B[6],R2).support;
[ Z(11)^7 ]
gap> DivisorOfRationalFunctionP1(B[7],R2).support;
[ Z(11)^7 ]
gap> DivisorOfRationalFunctionP1(B[8],R2).support;
[ Z(11) ]
gap> DivisorOfRationalFunctionP1(B[9],R2).support;
[ Z(11) ]
gap> DivisorOfRationalFunctionP1(B[10],R2).support;
[ Z(11) ]
gap> DivisorOfRationalFunctionP1(B[11],R2).support;
[ Z(11) ]

# doc/guava.xml:7671-7704
gap> F:=GF(11);
GF(11)
gap> R1:=PolynomialRing(F,["a"]);;
gap> var1:=IndeterminatesOfPolynomialRing(R1);; a:=var1[1];;
gap> b:=X(F,"b",var1);
b
gap> var2:=Concatenation(var1,[b]);
[ a, b ]
gap> R2:=PolynomialRing(F,var2);
GF(11)[a,b]
gap> crvP1:=AffineCurve(b,R2);
rec( polynomial := b, ring := GF(11)[a,b] )
gap> D:=DivisorOnAffineCurve([1,2,3,4],[Z(11)^2,Z(11)^3,Z(11)^7,Z(11)],crvP1);
rec( coeffs := [ 1, 2, 3, 4 ], 
  curve := rec( polynomial := b, ring := GF(11)[a,b] ), 
  support := [ Z(11)^2, Z(11)^3, Z(11)^7, Z(11) ] )
gap> A:=Z(11)^0*[[1,2],[1,4]];
[ [ Z(11)^0, Z(11) ], [ Z(11)^0, Z(11)^2 ] ]
gap> ActionMoebiusTransformationOnDivisorDefinedP1(A,D);
false
gap> A:=Z(11)^0*[[1,2],[3,4]];
[ [ Z(11)^0, Z(11) ], [ Z(11)^8, Z(11)^2 ] ]
gap> ActionMoebiusTransformationOnDivisorDefinedP1(A,D);
true
gap> ActionMoebiusTransformationOnDivisorP1(A,D);
rec( coeffs := [ 1, 2, 3, 4 ], 
  curve := rec( polynomial := b, ring := GF(11)[a,b] ), 
  support := [ Z(11)^5, Z(11)^6, Z(11)^8, Z(11)^7 ] )
gap> f:=MoebiusTransformation(A,R1);
(a+Z(11))/(Z(11)^8*a+Z(11)^2)
gap> ActionMoebiusTransformationOnFunction(A,f,R1);
-Z(11)^0+Z(11)^3*a^-1

# doc/guava.xml:7738-7758
gap> F:=GF(11);
GF(11)
gap> R1:=PolynomialRing(F,["a"]);;
gap> var1:=IndeterminatesOfPolynomialRing(R1);; a:=var1[1];;
gap> b:=X(F,"b",var1);
b
gap> var2:=Concatenation(var1,[b]);
[ a, b ]
gap> R2:=PolynomialRing(F,var2);
GF(11)[a,b]
gap> crvP1:=AffineCurve(b,R2);
rec( polynomial := b, ring := GF(11)[a,b] )
gap> D:=DivisorOnAffineCurve([1,2,3,4],[Z(11)^2,Z(11)^3,Z(11)^7,Z(11)],crvP1);
rec( coeffs := [ 1, 2, 3, 4 ], 
  curve := rec( polynomial := b, ring := GF(11)[a,b] ), 
  support := [ Z(11)^2, Z(11)^3, Z(11)^7, Z(11) ] )
gap> agp:=DivisorAutomorphismGroupP1(D);; #time; #Uncomment the call to "time;"" to see performance data
gap> IdGroup(agp);
[ 10, 2 ]

# doc/guava.xml:7799-7840
gap> F:=GF(11);
GF(11)
gap> R1:=PolynomialRing(F,["a"]);;
gap> var1:=IndeterminatesOfPolynomialRing(R1);; a:=var1[1];;
gap> b:=X(F,"b",var1);
b
gap> var2:=Concatenation(var1,[b]);
[ a, b ]
gap> R2:=PolynomialRing(F,var2);
GF(11)[a,b]
gap> crvP1:=AffineCurve(b,R2);
rec( polynomial := b, ring := GF(11)[a,b] )
gap> D:=DivisorOnAffineCurve([1,1,1,4],[Z(11)^2,Z(11)^3,Z(11)^7,Z(11)],crvP1);
rec( coeffs := [ 1, 1, 1, 4 ], 
  curve := rec( polynomial := b, ring := GF(11)[a,b] ), 
  support := [ Z(11)^2, Z(11)^3, Z(11)^7, Z(11) ] )
gap> agp:=DivisorAutomorphismGroupP1(D);; #time; #Uncomment the call to "time;"" to see performance data
gap> IdGroup(agp);
[ 20, 5 ]
gap> g:=Random(agp);
[ [ Z(11)^4, Z(11)^9 ], [ Z(11)^0, Z(11)^9 ] ]
gap> rho:=MatrixRepresentationOnRiemannRochSpaceP1(g,D);
[ [ Z(11)^0, 0*Z(11), 0*Z(11), 0*Z(11), 0*Z(11), 0*Z(11), 0*Z(11), 0*Z(11) ], 
[ Z(11)^0, 0*Z(11), 0*Z(11), Z(11), 0*Z(11), 0*Z(11), 0*Z(11), 0*Z(11) ],
  [ Z(11)^7, 0*Z(11), Z(11)^5, 0*Z(11), 0*Z(11), 0*Z(11), 0*Z(11), 0*Z(11) ], 
[ Z(11)^4, Z(11)^9, 0*Z(11), 0*Z(11), 0*Z(11), 0*Z(11), 0*Z(11), 0*Z(11) ],
  [ Z(11)^2, 0*Z(11), 0*Z(11), 0*Z(11), Z(11)^5, 0*Z(11), 0*Z(11), 0*Z(11) ], 
[ Z(11)^4, 0*Z(11), 0*Z(11), 0*Z(11), Z(11)^8, Z(11)^0, 0*Z(11), 0*Z(11) ],
  [ Z(11)^6, 0*Z(11), 0*Z(11), 0*Z(11), Z(11)^7, Z(11)^0, Z(11)^5, 0*Z(11) ], 
[ Z(11)^8, 0*Z(11), 0*Z(11), 0*Z(11), Z(11)^3, Z(11)^3, Z(11)^9, Z(11)^0 ] ]
gap> Display(rho);
  1  .  .  .  .  .  .  .
  1  .  .  2  .  .  .  .
  7  . 10  .  .  .  .  .
  5  6  .  .  .  .  .  .
  4  .  .  . 10  .  .  .
  5  .  .  .  3  1  .  .
  9  .  .  .  7  1 10  .
  3  .  .  .  8  8  6  1


# doc/guava.xml:7931-7952
gap> F:=GF(11);;
gap> R2:=PolynomialRing(F,2);;
gap> vars:=IndeterminatesOfPolynomialRing(R2);;
gap> a:=vars[1];;b:=vars[2];;
gap> cdiv:=[ 1, 2, -1, -2 ];
[ 1, 2, -1, -2 ]
gap> sdiv:=[ Z(11)^2, Z(11)^3, Z(11)^6, Z(11)^9 ];
[ Z(11)^2, Z(11)^3, Z(11)^6, Z(11)^9 ]
gap> crv:=rec(polynomial:=b,ring:=R2);
rec( polynomial := x, ring := GF(11)[t,x] )
gap> div:=DivisorOnAffineCurve(cdiv,sdiv,crv);
rec( coeffs := [ 1, 2, -1, -2 ], 
  curve := rec( polynomial := x, ring := GF(11)[t,x] ), 
  support := [ Z(11)^2, Z(11)^3, Z(11)^6, Z(11)^9 ] )
gap> pts:=Difference(Elements(GF(11)),div.support);
[ 0*Z(11), Z(11)^0, Z(11), Z(11)^4, Z(11)^5, Z(11)^7, Z(11)^8 ]
gap> C:=GoppaCodeClassical(div,pts);
a linear [7,2,1..6]4..5 code defined by generator matrix over GF(11)
gap> MinimumDistance(C);
6

# doc/guava.xml:8011-8042
gap> q:=4;;
gap> F:=GF(q^2);;
gap> R:=PolynomialRing(F,2);;
gap> vars:=IndeterminatesOfPolynomialRing(R);;
gap> x:=vars[1];;
gap> y:=vars[2];;
gap> crv:=AffineCurve(y^q+y-x^(q+1),R);
rec( polynomial := x^5+xx^4+xx, ring := GF(2^4)[x,xx] )
gap> L:=[ x^0, x, x^2*y^-1 ];
[ Z(2)^0, x, x^2/xx ]
gap> Pts:=AffinePointsOnCurve(crv.polynomial,crv.ring,F);;
gap> C1:=EvaluationBivariateCode(Pts,L,crv); #time; #Uncomment the call to "time;"" to see performance data


 Automatically removed the following 'bad' points (either a pole or not on the\
 curve):
[ [ 0*Z(2), 0*Z(2) ] ]

a linear [63,3,1..60]51..59  evaluation code over GF(16)
gap> P:=Difference(Pts,[[ 0*Z(2^4)^0, 0*Z(2)^0 ]]);;
gap> C2:=EvaluationBivariateCodeNC(P,L,crv); #time; #Uncomment the call to "time;"" to see performance data
a linear [63,3,1..60]51..59  evaluation code over GF(16)
gap> C3:=EvaluationCode(P,L,R); #time; #Uncomment the call to "time;"" to see performance data
a linear [63,3,1..56]51..59  evaluation code over GF(16)
gap> MinimumDistance(C1);
56
gap> MinimumDistance(C2);
56
gap> MinimumDistance(C3);
56

# doc/guava.xml:8254-8281
gap> C := QCLDPCCodeFromGroup(7,2,3);
a linear [21,8,1..6]5..10 low-density parity-check code over GF(2)
gap> MinimumWeight(C);
6
gap> # The quasi-cyclic structure is obvious from the check matrix
gap> Display( CheckMat(C) );
 1 . . . . . . . 1 . . . . . . . . 1 . . .
 . 1 . . . . . . . 1 . . . . . . . . 1 . .
 . . 1 . . . . . . . 1 . . . . . . . . 1 .
 . . . 1 . . . . . . . 1 . . . . . . . . 1
 . . . . 1 . . . . . . . 1 . 1 . . . . . .
 . . . . . 1 . . . . . . . 1 . 1 . . . . .
 . . . . . . 1 1 . . . . . . . . 1 . . . .
 . . . . . 1 . . . . . 1 . . . . 1 . . . .
 . . . . . . 1 . . . . . 1 . . . . 1 . . .
 1 . . . . . . . . . . . . 1 . . . . 1 . .
 . 1 . . . . . 1 . . . . . . . . . . . 1 .
 . . 1 . . . . . 1 . . . . . . . . . . . 1
 . . . 1 . . . . . 1 . . . . 1 . . . . . .
 . . . . 1 . . . . . 1 . . . . 1 . . . . .
gap> # This is the famous [155,64,20] quasi-cyclic LDPC codes
gap> C := QCLDPCCodeFromGroup(31,3,5);
a linear [155,64,1..24]24..77 low-density parity-check code over GF(2)
gap> # An example using non prime m, it may take a while to construct this code
gap> C := QCLDPCCodeFromGroup(356,4,8);
a linear [2848,1436,1..120]312..1412 low-density parity-check code over GF(2)

#
gap> STOP_TEST("guava05.tst", 1);
