from dojo.models import Finding


class DeepfenceThreatmapperVulnerability:
    def get_findings(self, row, headers, test):
        description = ""
        cve_attack_vector = row[headers["cve_attack_vector"]]
        cve_caused_by_package = row[headers["cve_caused_by_package"]]
        cve_container_image = row[headers["cve_container_image"]]
        cve_container_image_id = row[headers["cve_container_image_id"]]
        cve_description = row[headers["cve_description"]]
        cve_fixed_in = row[headers["cve_fixed_in"]]
        cve_id = row[headers["cve_id"]]
        cve_link = row[headers["cve_link"]]
        cve_severity = row[headers["cve_severity"]]
        cve_overall_score = row[headers["cve_overall_score"]]
        cve_type = row[headers["cve_type"]]
        host_name = row[headers["host_name"]]
        cloud_account_id = row[headers["cloud_account_id"]]
        masked = row[headers["masked"]]
        description += "**cve_attack_vector:** " + str(cve_attack_vector) + "\n"
        description += "**cve_caused_by_package:** " + str(cve_caused_by_package) + "\n"
        description += "**cve_container_image:** " + str(cve_container_image) + "\n"
        description += "**cve_container_image_id:** " + str(cve_container_image_id) + "\n"
        description += "**cve_description:** " + str(cve_description) + "\n"
        description += "**cve_severity:** " + str(cve_severity) + "\n"
        description += "**cve_overall_score:** " + str(cve_overall_score) + "\n"
        description += "**cve_type:** " + str(cve_type) + "\n"
        description += "**host_name:** " + str(host_name) + "\n"
        description += "**cloud_account_id:** " + str(cloud_account_id) + "\n"
        description += "**masked:** " + str(masked) + "\n"
        finding = Finding(
            title="Threatmapper_Vuln_Report-" + cve_id,
            description=description,
            component_name=cve_caused_by_package,
            severity=self.severity(cve_severity),
            static_finding=False,
            dynamic_finding=True,
            mitigation=cve_fixed_in,
            references=cve_link,
            cve=cve_id,
            test=test,
        )
        return finding

    def severity(self, input):
        if input is None:
            return "Info"
        else:
            return input.capitalize()
