#ifndef __GENPROF_H__
#define __GENPROF_H__

/*
 Copyright (c) 2006-2010 Trevor Williams

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with this program;
 if not, write to the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*!
 \file    genprof.h
 \author  Trevor Williams  (phase1geo@gmail.com)
 \date    12/10/2007
*/

#include "defines.h"

#define NUM_PROFILES 1063

#ifdef DEBUG
#define UNREGISTERED 0
#define ARC_FIND_FROM_STATE 1
#define ARC_FIND_TO_STATE 2
#define ARC_FIND_ARC 3
#define ARC_FIND_ARC_BY_EXCLUSION_ID 4
#define ARC_CREATE 5
#define ARC_ADD 6
#define ARC_STATE_HITS 7
#define ARC_TRANSITION_HITS 8
#define ARC_TRANSITION_EXCLUDED 9
#define ARC_GET_STATS 10
#define ARC_DB_WRITE 11
#define ARC_DB_READ 12
#define ARC_DB_MERGE 13
#define ARC_MERGE 14
#define ARC_GET_STATES 15
#define ARC_GET_TRANSITIONS 16
#define ARC_ARE_ANY_EXCLUDED 17
#define ARC_DEALLOC 18
#define ASSERTION_PARSE 19
#define ASSERTION_PARSE_ATTR 20
#define ASSERTION_GET_STATS 21
#define ASSERTION_DISPLAY_INSTANCE_SUMMARY 22
#define ASSERTION_INSTANCE_SUMMARY 23
#define ASSERTION_DISPLAY_FUNIT_SUMMARY 24
#define ASSERTION_FUNIT_SUMMARY 25
#define ASSERTION_DISPLAY_VERBOSE 26
#define ASSERTION_INSTANCE_VERBOSE 27
#define ASSERTION_FUNIT_VERBOSE 28
#define ASSERTION_REPORT 29
#define ASSERTION_GET_FUNIT_SUMMARY 30
#define ASSERTION_COLLECT 31
#define ASSERTION_GET_COVERAGE 32
#define ATTRIBUTE_CREATE 33
#define ATTRIBUTE_PARSE 34
#define ATTRIBUTE_DEALLOC 35
#define BIND_ADD 36
#define BIND_APPEND_FSM_EXPR 37
#define BIND_REMOVE 38
#define BIND_FIND_SIG_NAME 39
#define BIND_PARAM 40
#define BIND_SIGNAL 41
#define BIND_TASK_FUNCTION_PORTS 42
#define BIND_TASK_FUNCTION_NAMEDBLOCK 43
#define BIND_PERFORM 44
#define BIND_DEALLOC 45
#define CODEGEN_CREATE_EXPR_HELPER 46
#define CODEGEN_CREATE_EXPR 47
#define CODEGEN_GEN_EXPR 48
#define COMBINATION_CALC_DEPTH 49
#define COMBINATION_DOES_MULTI_EXP_NEED_UL 50
#define COMBINATION_MULTI_EXPR_CALC 51
#define COMBINATION_IS_EXPR_MULTI_NODE 52
#define COMBINATION_GET_TREE_STATS 53
#define COMBINATION_RESET_COUNTED_EXPRS 54
#define COMBINATION_RESET_COUNTED_EXPR_TREE 55
#define COMBINATION_GET_STATS 56
#define COMBINATION_GET_FUNIT_SUMMARY 57
#define COMBINATION_GET_INST_SUMMARY 58
#define COMBINATION_DISPLAY_INSTANCE_SUMMARY 59
#define COMBINATION_INSTANCE_SUMMARY 60
#define COMBINATION_DISPLAY_FUNIT_SUMMARY 61
#define COMBINATION_FUNIT_SUMMARY 62
#define COMBINATION_DRAW_LINE 63
#define COMBINATION_DRAW_CENTERED_LINE 64
#define COMBINATION_PARENTHESIZE 65
#define COMBINATION_UNDERLINE_TREE 66
#define COMBINATION_PREP_LINE 67
#define COMBINATION_UNDERLINE 68
#define COMBINATION_UNARY 69
#define COMBINATION_EVENT 70
#define COMBINATION_TWO_VARS 71
#define COMBINATION_MULTI_VAR_EXPRS 72
#define COMBINATION_MULTI_EXPR_OUTPUT_LENGTH 73
#define COMBINATION_MULTI_EXPR_OUTPUT 74
#define COMBINATION_MULTI_VARS 75
#define COMBINATION_GET_MISSED_EXPR 76
#define COMBINATION_LIST_MISSED 77
#define COMBINATION_OUTPUT_EXPR 78
#define COMBINATION_DISPLAY_VERBOSE 79
#define COMBINATION_INSTANCE_VERBOSE 80
#define COMBINATION_FUNIT_VERBOSE 81
#define COMBINATION_COLLECT 82
#define COMBINATION_GET_EXCLUDE_LIST 83
#define COMBINATION_GET_EXPRESSION 84
#define COMBINATION_GET_COVERAGE 85
#define COMBINATION_REPORT 86
#define DB_CREATE 87
#define DB_CLOSE 88
#define DB_CHECK_FOR_TOP_MODULE 89
#define DB_WRITE 90
#define DB_READ 91
#define DB_MERGE_INSTANCE_TREES 92
#define DB_SCALE_TO_PRECISION 93
#define DB_CREATE_UNNAMED_SCOPE 94
#define DB_IS_UNNAMED_SCOPE 95
#define DB_SET_TIMESCALE 96
#define DB_GET_CURR_FUNIT 97
#define DB_GET_EXCLUSION_ID_SIZE 98
#define DB_GEN_EXCLUSION_ID 99
#define DB_ADD_FILE_VERSION 100
#define DB_OUTPUT_DUMPVARS 101
#define DB_ADD_INSTANCE 102
#define DB_ADD_MODULE 103
#define DB_END_MODULE 104
#define DB_ADD_FUNCTION_TASK_NAMEDBLOCK 105
#define DB_END_FUNCTION_TASK_NAMEDBLOCK 106
#define DB_ADD_DECLARED_PARAM 107
#define DB_ADD_OVERRIDE_PARAM 108
#define DB_ADD_VECTOR_PARAM 109
#define DB_ADD_DEFPARAM 110
#define DB_ADD_SIGNAL 111
#define DB_ADD_ENUM 112
#define DB_END_ENUM_LIST 113
#define DB_ADD_TYPEDEF 114
#define DB_FIND_SIGNAL 115
#define DB_ADD_GEN_ITEM_BLOCK 116
#define DB_FIND_GEN_ITEM 117
#define DB_FIND_TYPEDEF 118
#define DB_GET_CURR_GEN_BLOCK 119
#define DB_CURR_SIGNAL_COUNT 120
#define DB_CREATE_EXPRESSION 121
#define DB_BIND_EXPR_TREE 122
#define DB_CREATE_EXPR_FROM_STATIC 123
#define DB_ADD_EXPRESSION 124
#define DB_CREATE_SENSITIVITY_LIST 125
#define DB_PARALLELIZE_STATEMENT 126
#define DB_CREATE_STATEMENT 127
#define DB_ADD_STATEMENT 128
#define DB_REMOVE_STATEMENT_FROM_CURRENT_FUNIT 129
#define DB_REMOVE_STATEMENT 130
#define DB_CONNECT_STATEMENT_TRUE 131
#define DB_CONNECT_STATEMENT_FALSE 132
#define DB_GEN_ITEM_CONNECT_TRUE 133
#define DB_GEN_ITEM_CONNECT_FALSE 134
#define DB_GEN_ITEM_CONNECT 135
#define DB_STATEMENT_CONNECT 136
#define DB_CREATE_ATTR_PARAM 137
#define DB_PARSE_ATTRIBUTE 138
#define DB_REMOVE_STMT_BLKS_CALLING_STATEMENT 139
#define DB_GEN_CURR_INST_SCOPE 140
#define DB_SYNC_CURR_INSTANCE 141
#define DB_SET_VCD_SCOPE 142
#define DB_VCD_UPSCOPE 143
#define DB_ASSIGN_SYMBOL 144
#define DB_SET_SYMBOL_CHAR 145
#define DB_SET_SYMBOL_STRING 146
#define DB_DO_TIMESTEP 147
#define DB_CHECK_DUMPFILE_SCOPES 148
#define ENUMERATE_ADD_ITEM 149
#define ENUMERATE_END_LIST 150
#define ENUMERATE_RESOLVE 151
#define ENUMERATE_DEALLOC 152
#define ENUMERATE_DEALLOC_LIST 153
#define EXCLUDE_EXPR_ASSIGN_AND_RECALC 154
#define EXCLUDE_SIG_ASSIGN_AND_RECALC 155
#define EXCLUDE_ARC_ASSIGN_AND_RECALC 156
#define EXCLUDE_ADD_EXCLUDE_REASON 157
#define EXCLUDE_REMOVE_EXCLUDE_REASON 158
#define EXCLUDE_IS_LINE_EXCLUDED 159
#define EXCLUDE_SET_LINE_EXCLUDE 160
#define EXCLUDE_IS_TOGGLE_EXCLUDED 161
#define EXCLUDE_SET_TOGGLE_EXCLUDE 162
#define EXCLUDE_IS_COMB_EXCLUDED 163
#define EXCLUDE_SET_COMB_EXCLUDE 164
#define EXCLUDE_IS_FSM_EXCLUDED 165
#define EXCLUDE_SET_FSM_EXCLUDE 166
#define EXCLUDE_IS_ASSERT_EXCLUDED 167
#define EXCLUDE_SET_ASSERT_EXCLUDE 168
#define EXCLUDE_FIND_EXCLUDE_REASON 169
#define EXCLUDE_DB_WRITE 170
#define EXCLUDE_DB_READ 171
#define EXCLUDE_RESOLVE_REASON 172
#define EXCLUDE_DB_MERGE 173
#define EXCLUDE_MERGE 174
#define EXCLUDE_FIND_SIGNAL 175
#define EXCLUDE_FIND_EXPRESSION 176
#define EXCLUDE_FIND_FSM_ARC 177
#define EXCLUDE_FORMAT_REASON 178
#define EXCLUDED_GET_MESSAGE 179
#define EXCLUDE_HANDLE_EXCLUDE_REASON 180
#define EXCLUDE_PRINT_EXCLUSION 181
#define EXCLUDE_LINE_FROM_ID 182
#define EXCLUDE_TOGGLE_FROM_ID 183
#define EXCLUDE_MEMORY_FROM_ID 184
#define EXCLUDE_EXPR_FROM_ID 185
#define EXCLUDE_FSM_FROM_ID 186
#define EXCLUDE_ASSERT_FROM_ID 187
#define EXCLUDE_APPLY_EXCLUSIONS 188
#define COMMAND_EXCLUDE 189
#define EXPRESSION_CREATE_TMP_VECS 190
#define EXPRESSION_CREATE_NBA 191
#define EXPRESSION_IS_NBA_LHS 192
#define EXPRESSION_CREATE_VALUE 193
#define EXPRESSION_CREATE 194
#define EXPRESSION_SET_VALUE 195
#define EXPRESSION_SET_SIGNED 196
#define EXPRESSION_RESIZE 197
#define EXPRESSION_GET_ID 198
#define EXPRESSION_GET_FIRST_LINE_EXPR 199
#define EXPRESSION_GET_LAST_LINE_EXPR 200
#define EXPRESSION_GET_CURR_DIMENSION 201
#define EXPRESSION_FIND_RHS_SIGS 202
#define EXPRESSION_FIND_PARAMS 203
#define EXPRESSION_FIND_ULINE_ID 204
#define EXPRESSION_FIND_EXPR 205
#define EXPRESSION_CONTAINS_EXPR_CALLING_STMT 206
#define EXPRESSION_GET_ROOT_STATEMENT 207
#define EXPRESSION_ASSIGN_EXPR_IDS 208
#define EXPRESSION_DB_WRITE 209
#define EXPRESSION_DB_WRITE_TREE 210
#define EXPRESSION_DB_READ 211
#define EXPRESSION_DB_MERGE 212
#define EXPRESSION_MERGE 213
#define EXPRESSION_STRING_OP 214
#define EXPRESSION_STRING 215
#define EXPRESSION_OP_FUNC__XOR 216
#define EXPRESSION_OP_FUNC__XOR_A 217
#define EXPRESSION_OP_FUNC__MULTIPLY 218
#define EXPRESSION_OP_FUNC__MULTIPLY_A 219
#define EXPRESSION_OP_FUNC__DIVIDE 220
#define EXPRESSION_OP_FUNC__DIVIDE_A 221
#define EXPRESSION_OP_FUNC__MOD 222
#define EXPRESSION_OP_FUNC__MOD_A 223
#define EXPRESSION_OP_FUNC__ADD 224
#define EXPRESSION_OP_FUNC__ADD_A 225
#define EXPRESSION_OP_FUNC__SUBTRACT 226
#define EXPRESSION_OP_FUNC__SUB_A 227
#define EXPRESSION_OP_FUNC__AND 228
#define EXPRESSION_OP_FUNC__AND_A 229
#define EXPRESSION_OP_FUNC__OR 230
#define EXPRESSION_OP_FUNC__OR_A 231
#define EXPRESSION_OP_FUNC__NAND 232
#define EXPRESSION_OP_FUNC__NOR 233
#define EXPRESSION_OP_FUNC__NXOR 234
#define EXPRESSION_OP_FUNC__LT 235
#define EXPRESSION_OP_FUNC__GT 236
#define EXPRESSION_OP_FUNC__LSHIFT 237
#define EXPRESSION_OP_FUNC__LSHIFT_A 238
#define EXPRESSION_OP_FUNC__RSHIFT 239
#define EXPRESSION_OP_FUNC__RSHIFT_A 240
#define EXPRESSION_OP_FUNC__ARSHIFT 241
#define EXPRESSION_OP_FUNC__ARSHIFT_A 242
#define EXPRESSION_OP_FUNC__TIME 243
#define EXPRESSION_OP_FUNC__REALTIME 244
#define EXPRESSION_OP_FUNC__RANDOM 245
#define EXPRESSION_OP_FUNC__SASSIGN 246
#define EXPRESSION_OP_FUNC__SRANDOM 247
#define EXPRESSION_OP_FUNC__URANDOM 248
#define EXPRESSION_OP_FUNC__URANDOM_RANGE 249
#define EXPRESSION_OP_FUNC__REALTOBITS 250
#define EXPRESSION_OP_FUNC__BITSTOREAL 251
#define EXPRESSION_OP_FUNC__SHORTREALTOBITS 252
#define EXPRESSION_OP_FUNC__BITSTOSHORTREAL 253
#define EXPRESSION_OP_FUNC__ITOR 254
#define EXPRESSION_OP_FUNC__RTOI 255
#define EXPRESSION_OP_FUNC__TEST_PLUSARGS 256
#define EXPRESSION_OP_FUNC__VALUE_PLUSARGS 257
#define EXPRESSION_OP_FUNC__SIGNED 258
#define EXPRESSION_OP_FUNC__UNSIGNED 259
#define EXPRESSION_OP_FUNC__CLOG2 260
#define EXPRESSION_OP_FUNC__EQ 261
#define EXPRESSION_OP_FUNC__CEQ 262
#define EXPRESSION_OP_FUNC__LE 263
#define EXPRESSION_OP_FUNC__GE 264
#define EXPRESSION_OP_FUNC__NE 265
#define EXPRESSION_OP_FUNC__CNE 266
#define EXPRESSION_OP_FUNC__LOR 267
#define EXPRESSION_OP_FUNC__LAND 268
#define EXPRESSION_OP_FUNC__COND 269
#define EXPRESSION_OP_FUNC__COND_SEL 270
#define EXPRESSION_OP_FUNC__UINV 271
#define EXPRESSION_OP_FUNC__UAND 272
#define EXPRESSION_OP_FUNC__UNOT 273
#define EXPRESSION_OP_FUNC__UOR 274
#define EXPRESSION_OP_FUNC__UXOR 275
#define EXPRESSION_OP_FUNC__UNAND 276
#define EXPRESSION_OP_FUNC__UNOR 277
#define EXPRESSION_OP_FUNC__UNXOR 278
#define EXPRESSION_OP_FUNC__NULL 279
#define EXPRESSION_OP_FUNC__SIG 280
#define EXPRESSION_OP_FUNC__SBIT 281
#define EXPRESSION_OP_FUNC__MBIT 282
#define EXPRESSION_OP_FUNC__EXPAND 283
#define EXPRESSION_OP_FUNC__LIST 284
#define EXPRESSION_OP_FUNC__CONCAT 285
#define EXPRESSION_OP_FUNC__PEDGE 286
#define EXPRESSION_OP_FUNC__NEDGE 287
#define EXPRESSION_OP_FUNC__AEDGE 288
#define EXPRESSION_OP_FUNC__EOR 289
#define EXPRESSION_OP_FUNC__SLIST 290
#define EXPRESSION_OP_FUNC__DELAY 291
#define EXPRESSION_OP_FUNC__TRIGGER 292
#define EXPRESSION_OP_FUNC__CASE 293
#define EXPRESSION_OP_FUNC__CASEX 294
#define EXPRESSION_OP_FUNC__CASEZ 295
#define EXPRESSION_OP_FUNC__DEFAULT 296
#define EXPRESSION_OP_FUNC__BASSIGN 297
#define EXPRESSION_OP_FUNC__FUNC_CALL 298
#define EXPRESSION_OP_FUNC__TASK_CALL 299
#define EXPRESSION_OP_FUNC__NB_CALL 300
#define EXPRESSION_OP_FUNC__FORK 301
#define EXPRESSION_OP_FUNC__JOIN 302
#define EXPRESSION_OP_FUNC__DISABLE 303
#define EXPRESSION_OP_FUNC__REPEAT 304
#define EXPRESSION_OP_FUNC__EXPONENT 305
#define EXPRESSION_OP_FUNC__PASSIGN 306
#define EXPRESSION_OP_FUNC__MBIT_POS 307
#define EXPRESSION_OP_FUNC__MBIT_NEG 308
#define EXPRESSION_OP_FUNC__NEGATE 309
#define EXPRESSION_OP_FUNC__IINC 310
#define EXPRESSION_OP_FUNC__PINC 311
#define EXPRESSION_OP_FUNC__IDEC 312
#define EXPRESSION_OP_FUNC__PDEC 313
#define EXPRESSION_OP_FUNC__DLY_ASSIGN 314
#define EXPRESSION_OP_FUNC__DLY_OP 315
#define EXPRESSION_OP_FUNC__REPEAT_DLY 316
#define EXPRESSION_OP_FUNC__DIM 317
#define EXPRESSION_OP_FUNC__WAIT 318
#define EXPRESSION_OP_FUNC__FINISH 319
#define EXPRESSION_OP_FUNC__STOP 320
#define EXPRESSION_OPERATE 321
#define EXPRESSION_OPERATE_RECURSIVELY 322
#define EXPRESSION_IS_STATIC_ONLY_HELPER 323
#define EXPRESSION_IS_ASSIGNED 324
#define EXPRESSION_IS_BIT_SELECT 325
#define EXPRESSION_IS_LAST_SELECT 326
#define EXPRESSION_IS_IN_RASSIGN 327
#define EXPRESSION_SET_ASSIGNED 328
#define EXPRESSION_SET_CHANGED 329
#define EXPRESSION_ASSIGN 330
#define EXPRESSION_DEALLOC 331
#define FSM_CREATE 332
#define FSM_ADD_ARC 333
#define FSM_CREATE_TABLES 334
#define FSM_DB_WRITE 335
#define FSM_DB_READ 336
#define FSM_DB_MERGE 337
#define FSM_MERGE 338
#define FSM_TABLE_SET 339
#define FSM_GET_STATS 340
#define FSM_GET_FUNIT_SUMMARY 341
#define FSM_GET_INST_SUMMARY 342
#define FSM_GATHER_SIGNALS 343
#define FSM_COLLECT 344
#define FSM_GET_COVERAGE 345
#define FSM_DISPLAY_INSTANCE_SUMMARY 346
#define FSM_INSTANCE_SUMMARY 347
#define FSM_DISPLAY_FUNIT_SUMMARY 348
#define FSM_FUNIT_SUMMARY 349
#define FSM_DISPLAY_STATE_VERBOSE 350
#define FSM_DISPLAY_ARC_VERBOSE 351
#define FSM_DISPLAY_VERBOSE 352
#define FSM_INSTANCE_VERBOSE 353
#define FSM_FUNIT_VERBOSE 354
#define FSM_REPORT 355
#define FSM_DEALLOC 356
#define FSM_ARG_PARSE_STATE 357
#define FSM_ARG_PARSE 358
#define FSM_ARG_PARSE_VALUE 359
#define FSM_ARG_PARSE_TRANS 360
#define FSM_ARG_PARSE_ATTR 361
#define FSM_VAR_ADD 362
#define FSM_VAR_IS_OUTPUT_STATE 363
#define FSM_VAR_BIND_EXPR 364
#define FSM_VAR_ADD_EXPR 365
#define FSM_VAR_BIND_STMT 366
#define FSM_VAR_BIND_ADD 367
#define FSM_VAR_STMT_ADD 368
#define FSM_VAR_BIND 369
#define FSM_VAR_DEALLOC 370
#define FSM_VAR_REMOVE 371
#define FSM_VAR_CLEANUP 372
#define FST_READER_PROCESS_HIER 373
#define FST_CALLBACK 374
#define FST_PARSE 375
#define FUNC_ITER_DISPLAY 376
#define FUNC_ITER_SORT 377
#define FUNC_ITER_COUNT_STMT_ITERS 378
#define FUNC_ITER_ADD_STMT_LINKS 379
#define FUNC_ITER_ADD_SIG_LINKS 380
#define FUNC_ITER_INIT 381
#define FUNC_ITER_GET_NEXT_STATEMENT 382
#define FUNC_ITER_GET_NEXT_SIGNAL 383
#define FUNC_ITER_DEALLOC 384
#define FUNIT_INIT 385
#define FUNIT_CREATE 386
#define FUNIT_GET_CURR_MODULE 387
#define FUNIT_GET_CURR_MODULE_SAFE 388
#define FUNIT_GET_CURR_FUNCTION 389
#define FUNIT_GET_CURR_TASK 390
#define FUNIT_GET_PORT_COUNT 391
#define FUNIT_FIND_PARAM 392
#define FUNIT_FIND_SIGNAL 393
#define FUNIT_REMOVE_STMT_BLKS_CALLING_STMT 394
#define FUNIT_GEN_TASK_FUNCTION_NAMEDBLOCK_NAME 395
#define FUNIT_SIZE_ELEMENTS 396
#define FUNIT_DB_WRITE 397
#define FUNIT_DB_READ 398
#define FUNIT_VERSION_DB_READ 399
#define FUNIT_DB_INST_MERGE 400
#define FUNIT_DB_MOD_MERGE 401
#define FUNIT_MERGE 402
#define FUNIT_FLATTEN_NAME 403
#define FUNIT_FIND_BY_ID 404
#define FUNIT_IS_TOP_MODULE 405
#define FUNIT_IS_UNNAMED 406
#define FUNIT_IS_UNNAMED_CHILD_OF 407
#define FUNIT_IS_CHILD_OF 408
#define FUNIT_DISPLAY_SIGNALS 409
#define FUNIT_DISPLAY_EXPRESSIONS 410
#define STATEMENT_ADD_THREAD 411
#define FUNIT_PUSH_THREADS 412
#define STATEMENT_DELETE_THREAD 413
#define FUNIT_OUTPUT_DUMPVARS 414
#define FUNIT_IS_ONE_SIGNAL_ASSIGNED 415
#define FUNIT_CLEAN 416
#define FUNIT_DEALLOC 417
#define GEN_ITEM_STRINGIFY 418
#define GEN_ITEM_DISPLAY 419
#define GEN_ITEM_DISPLAY_BLOCK_HELPER 420
#define GEN_ITEM_DISPLAY_BLOCK 421
#define GEN_ITEM_COMPARE 422
#define GEN_ITEM_FIND 423
#define GEN_ITEM_REMOVE_IF_CONTAINS_EXPR_CALLING_STMT 424
#define GEN_ITEM_GET_GENVAR 425
#define GEN_ITEM_VARNAME_CONTAINS_GENVAR 426
#define GEN_ITEM_CALC_SIGNAL_NAME 427
#define GEN_ITEM_CREATE_EXPR 428
#define GEN_ITEM_CREATE_SIG 429
#define GEN_ITEM_CREATE_STMT 430
#define GEN_ITEM_CREATE_INST 431
#define GEN_ITEM_CREATE_TFN 432
#define GEN_ITEM_CREATE_BIND 433
#define GEN_ITEM_RESIZE_STMTS_AND_SIGS 434
#define GEN_ITEM_ASSIGN_IDS 435
#define GEN_ITEM_DB_WRITE 436
#define GEN_ITEM_DB_WRITE_EXPR_TREE 437
#define GEN_ITEM_CONNECT 438
#define GEN_ITEM_RESOLVE 439
#define GEN_ITEM_BIND 440
#define GENERATE_RESOLVE_INST 441
#define GENERATE_REMOVE_STMT_HELPER 442
#define GENERATE_REMOVE_STMT 443
#define GEN_ITEM_DEALLOC 444
#define SCORE_ADD_ARGS 445
#define INFO_SET_VECTOR_ELEM_SIZE 446
#define INFO_DB_WRITE 447
#define INFO_DB_READ 448
#define ARGS_DB_READ 449
#define MESSAGE_DB_READ 450
#define MERGED_CDD_DB_READ 451
#define INFO_DEALLOC 452
#define INSTANCE_DISPLAY_TREE_HELPER 453
#define INSTANCE_DISPLAY_TREE 454
#define INSTANCE_CREATE 455
#define INSTANCE_GEN_SCOPE 456
#define INSTANCE_COMPARE 457
#define INSTANCE_FIND_SCOPE 458
#define INSTANCE_FIND_BY_FUNIT 459
#define INSTANCE_FIND_BY_FUNIT_NAME_IF_ONE_HELPER 460
#define INSTANCE_FIND_BY_FUNIT_NAME_IF_ONE 461
#define INSTANCE_FIND_SIGNAL_BY_EXCLUSION_ID 462
#define INSTANCE_FIND_EXPRESSION_BY_EXCLUSION_ID 463
#define INSTANCE_FIND_FSM_ARC_INDEX_BY_EXCLUSION_ID 464
#define INSTANCE_ADD_CHILD 465
#define INSTANCE_COPY_HELPER 466
#define INSTANCE_COPY 467
#define INSTANCE_PARSE_ADD 468
#define INSTANCE_RESOLVE_INST 469
#define INSTANCE_RESOLVE_HELPER 470
#define INSTANCE_RESOLVE 471
#define INSTANCE_READ_ADD 472
#define INSTANCE_MERGE 473
#define INSTANCE_GET_LEADING_HIERARCHY 474
#define INSTANCE_MARK_LHIER_DIFFS 475
#define INSTANCE_MERGE_TWO_TREES 476
#define INSTANCE_DB_WRITE 477
#define INSTANCE_ONLY_DB_READ 478
#define INSTANCE_ONLY_DB_MERGE 479
#define INSTANCE_REMOVE_STMT_BLKS_CALLING_STMT 480
#define INSTANCE_REMOVE_PARMS_WITH_EXPR 481
#define INSTANCE_DEALLOC_SINGLE 482
#define INSTANCE_OUTPUT_DUMPVARS 483
#define INSTANCE_DEALLOC_TREE 484
#define INSTANCE_DEALLOC 485
#define LEXER_KEYWORD_1995_CODE 486
#define LEXER_KEYWORD_2001_CODE 487
#define LEXER_KEYWORD_SV_CODE 488
#define LEXER_KEYWORD_SYS_1995_CODE 489
#define LEXER_KEYWORD_SYS_2001_CODE 490
#define LEXER_KEYWORD_SYS_SV_CODE 491
#define LEXER_CSTRING_A 492
#define LEXER_KEYWORD_A 493
#define LEXER_ESCAPED_NAME 494
#define LEXER_SYSTEM_CALL 495
#define LINE_DIRECTIVE 496
#define LINE_DIRECTIVE2 497
#define PROCESS_TIMESCALE_TOKEN 498
#define PROCESS_TIMESCALE 499
#define LEXER_YYWRAP 500
#define RESET_LEXER 501
#define CHECK_FOR_PRAGMA 502
#define LINE_GET_STATS 503
#define LINE_COLLECT 504
#define LINE_GET_FUNIT_SUMMARY 505
#define LINE_GET_INST_SUMMARY 506
#define LINE_DISPLAY_INSTANCE_SUMMARY 507
#define LINE_INSTANCE_SUMMARY 508
#define LINE_DISPLAY_FUNIT_SUMMARY 509
#define LINE_FUNIT_SUMMARY 510
#define LINE_DISPLAY_VERBOSE 511
#define LINE_INSTANCE_VERBOSE 512
#define LINE_FUNIT_VERBOSE 513
#define LINE_REPORT 514
#define STR_LINK_ADD 515
#define STMT_LINK_ADD_HEAD 516
#define EXP_LINK_ADD 517
#define SIG_LINK_ADD 518
#define FSM_LINK_ADD 519
#define FUNIT_LINK_ADD 520
#define GITEM_LINK_ADD 521
#define INST_LINK_ADD 522
#define STR_LINK_FIND 523
#define STMT_LINK_FIND 524
#define STMT_LINK_FIND_BY_POS 525
#define EXP_LINK_FIND 526
#define EXP_LINK_FIND_BY_POS 527
#define SIG_LINK_FIND 528
#define FSM_LINK_FIND 529
#define FSM_LINK_FIND_BY_POS 530
#define FUNIT_LINK_FIND 531
#define GITEM_LINK_FIND 532
#define INST_LINK_FIND_BY_SCOPE 533
#define INST_LINK_FIND_BY_FUNIT 534
#define STR_LINK_REMOVE 535
#define EXP_LINK_REMOVE 536
#define GITEM_LINK_REMOVE 537
#define FUNIT_LINK_REMOVE 538
#define STR_LINK_DELETE_LIST 539
#define STMT_LINK_UNLINK 540
#define STMT_LINK_DELETE_LIST 541
#define EXP_LINK_DELETE_LIST 542
#define SIG_LINK_DELETE_LIST 543
#define FSM_LINK_DELETE_LIST 544
#define FUNIT_LINK_DELETE_LIST 545
#define GITEM_LINK_DELETE_LIST 546
#define INST_LINK_DELETE_LIST 547
#define VCDID 548
#define VCD_CALLBACK 549
#define LXT_PARSE 550
#define LXT2_RD_EXPAND_INTEGER_TO_BITS 551
#define LXT2_RD_EXPAND_BITS_TO_INTEGER 552
#define LXT2_RD_ITER_RADIX 553
#define LXT2_RD_ITER_RADIX0 554
#define LXT2_RD_BUILD_RADIX 555
#define LXT2_RD_REGENERATE_PROCESS_MASK 556
#define LXT2_RD_PROCESS_BLOCK 557
#define LXT2_RD_INIT 558
#define LXT2_RD_CLOSE 559
#define LXT2_RD_GET_FACNAME 560
#define LXT2_RD_ITER_BLOCKS 561
#define LXT2_RD_LIMIT_TIME_RANGE 562
#define LXT2_RD_UNLIMIT_TIME_RANGE 563
#define MEMORY_GET_STAT 564
#define MEMORY_GET_STATS 565
#define MEMORY_GET_FUNIT_SUMMARY 566
#define MEMORY_GET_INST_SUMMARY 567
#define MEMORY_CREATE_PDIM_BIT_ARRAY 568
#define MEMORY_GET_MEM_COVERAGE 569
#define MEMORY_GET_COVERAGE 570
#define MEMORY_COLLECT 571
#define MEMORY_DISPLAY_TOGGLE_INSTANCE_SUMMARY 572
#define MEMORY_TOGGLE_INSTANCE_SUMMARY 573
#define MEMORY_DISPLAY_AE_INSTANCE_SUMMARY 574
#define MEMORY_AE_INSTANCE_SUMMARY 575
#define MEMORY_DISPLAY_TOGGLE_FUNIT_SUMMARY 576
#define MEMORY_TOGGLE_FUNIT_SUMMARY 577
#define MEMORY_DISPLAY_AE_FUNIT_SUMMARY 578
#define MEMORY_AE_FUNIT_SUMMARY 579
#define MEMORY_DISPLAY_MEMORY 580
#define MEMORY_DISPLAY_VERBOSE 581
#define MEMORY_INSTANCE_VERBOSE 582
#define MEMORY_FUNIT_VERBOSE 583
#define MEMORY_REPORT 584
#define MERGE_CHECK 585
#define COMMAND_MERGE 586
#define OBFUSCATE_SET_MODE 587
#define OBFUSCATE_NAME 588
#define OBFUSCATE_DEALLOC 589
#define OVL_IS_ASSERTION_NAME 590
#define OVL_IS_ASSERTION_MODULE 591
#define OVL_IS_COVERAGE_POINT 592
#define OVL_ADD_ASSERTIONS_TO_NO_SCORE_LIST 593
#define OVL_GET_FUNIT_STATS 594
#define OVL_GET_COVERAGE_POINT 595
#define OVL_DISPLAY_VERBOSE 596
#define OVL_COLLECT 597
#define OVL_GET_COVERAGE 598
#define MOD_PARM_FIND 599
#define MOD_PARM_FIND_EXPR_AND_REMOVE 600
#define MOD_PARM_ADD 601
#define INST_PARM_FIND 602
#define INST_PARM_ADD 603
#define INST_PARM_ADD_GENVAR 604
#define INST_PARM_BIND 605
#define DEFPARAM_ADD 606
#define DEFPARAM_DEALLOC 607
#define PARAM_FIND_AND_SET_EXPR_VALUE 608
#define PARAM_SET_SIG_SIZE 609
#define PARAM_SIZE_FUNCTION 610
#define PARAM_EXPR_EVAL 611
#define PARAM_HAS_OVERRIDE 612
#define PARAM_HAS_DEFPARAM 613
#define PARAM_RESOLVE_DECLARED 614
#define PARAM_RESOLVE_OVERRIDE 615
#define PARAM_RESOLVE_INST 616
#define PARAM_RESOLVE 617
#define PARAM_DB_WRITE 618
#define MOD_PARM_DEALLOC 619
#define INST_PARM_DEALLOC 620
#define PARSE_READLINE 621
#define PARSE_DESIGN 622
#define PARSE_AND_SCORE_DUMPFILE 623
#define PARSER_PORT_DECLARATION_A 624
#define PARSER_PORT_DECLARATION_B 625
#define PARSER_PORT_DECLARATION_C 626
#define PARSER_STATIC_EXPR_PRIMARY_A 627
#define PARSER_STATIC_EXPR_PRIMARY_B 628
#define PARSER_EXPRESSION_LIST_A 629
#define PARSER_EXPRESSION_LIST_B 630
#define PARSER_EXPRESSION_LIST_C 631
#define PARSER_EXPRESSION_LIST_D 632
#define PARSER_IDENTIFIER_A 633
#define PARSER_GENERATE_CASE_ITEM_A 634
#define PARSER_GENERATE_CASE_ITEM_B 635
#define PARSER_GENERATE_CASE_ITEM_C 636
#define PARSER_STATEMENT_BEGIN_A 637
#define PARSER_STATEMENT_FORK_A 638
#define PARSER_STATEMENT_FOR_A 639
#define PARSER_CASE_ITEM_A 640
#define PARSER_CASE_ITEM_B 641
#define PARSER_CASE_ITEM_C 642
#define PARSER_DELAY_VALUE_A 643
#define PARSER_DELAY_VALUE_B 644
#define PARSER_PARAMETER_VALUE_BYNAME_A 645
#define PARSER_GATE_INSTANCE_A 646
#define PARSER_GATE_INSTANCE_B 647
#define PARSER_GATE_INSTANCE_C 648
#define PARSER_GATE_INSTANCE_D 649
#define PARSER_LIST_OF_NAMES_A 650
#define PARSER_LIST_OF_NAMES_B 651
#define VLERROR 652
#define VLWARN 653
#define PARSER_DEALLOC_SIG_RANGE 654
#define PARSER_COPY_CURR_RANGE 655
#define PARSER_COPY_RANGE_TO_CURR_RANGE 656
#define PARSER_EXPLICITLY_SET_CURR_RANGE 657
#define PARSER_IMPLICITLY_SET_CURR_RANGE 658
#define PARSER_CHECK_GENERATION 659
#define PARSER_HANDLE_CASE_STATEMENT 660
#define PARSER_HANDLE_CASE_STATEMENT_LIST 661
#define PARSER_HANDLE_GENERATE_CASE_STATEMENT 662
#define PARSER_HANDLE_GENERATE_CASE_STATEMENT_LIST 663
#define PERF_GEN_STATS 664
#define PERF_OUTPUT_MOD_STATS 665
#define PERF_OUTPUT_INST_REPORT_HELPER 666
#define PERF_OUTPUT_INST_REPORT 667
#define DEF_LOOKUP 668
#define IS_DEFINED 669
#define DEF_MATCH 670
#define DEF_START 671
#define DEFINE_MACRO 672
#define DO_DEFINE 673
#define DEF_IS_DONE 674
#define DEF_FINISH 675
#define DEF_UNDEFINE 676
#define INCLUDE_FILENAME 677
#define DO_INCLUDE 678
#define YYWRAP 679
#define RESET_PPLEXER 680
#define RACE_BLK_CREATE 681
#define RACE_FIND_HEAD_STATEMENT_CONTAINING_STATEMENT_HELPER 682
#define RACE_FIND_HEAD_STATEMENT_CONTAINING_STATEMENT 683
#define RACE_GET_HEAD_STATEMENT 684
#define RACE_FIND_HEAD_STATEMENT 685
#define RACE_CALC_STMT_BLK_TYPE 686
#define RACE_CALC_EXPR_ASSIGNMENT 687
#define RACE_CALC_ASSIGNMENTS 688
#define RACE_HANDLE_RACE_CONDITION 689
#define RACE_CHECK_ASSIGNMENT_TYPES 690
#define RACE_CHECK_ONE_BLOCK_ASSIGNMENT 691
#define RACE_CHECK_RACE_COUNT 692
#define RACE_CHECK_MODULES 693
#define RACE_DB_WRITE 694
#define RACE_DB_READ 695
#define RACE_GET_STATS 696
#define RACE_REPORT_SUMMARY 697
#define RACE_REPORT_VERBOSE 698
#define RACE_REPORT 699
#define RACE_COLLECT_LINES 700
#define RACE_BLK_DELETE_LIST 701
#define RANK_CREATE_COMP_CDD_COV 702
#define RANK_DEALLOC_COMP_CDD_COV 703
#define RANK_CHECK_INDEX 704
#define RANK_GATHER_SIGNAL_COV 705
#define RANK_GATHER_COMB_COV 706
#define RANK_GATHER_EXPRESSION_COV 707
#define RANK_GATHER_FSM_COV 708
#define RANK_CALC_NUM_CPS 709
#define RANK_GATHER_COMP_CDD_COV 710
#define RANK_READ_CDD 711
#define RANK_SELECTED_CDD_COV 712
#define RANK_PERFORM_WEIGHTED_SELECTION 713
#define RANK_PERFORM_GREEDY_SORT 714
#define RANK_COUNT_CPS 715
#define RANK_PERFORM 716
#define RANK_OUTPUT 717
#define COMMAND_RANK 718
#define REENTRANT_COUNT_AFU_BITS 719
#define REENTRANT_STORE_DATA_BITS 720
#define REENTRANT_RESTORE_DATA_BITS 721
#define REENTRANT_CREATE 722
#define REENTRANT_DEALLOC 723
#define REPORT_PARSE_METRICS 724
#define REPORT_PARSE_ARGS 725
#define REPORT_GATHER_INSTANCE_STATS 726
#define REPORT_GATHER_FUNIT_STATS 727
#define REPORT_PRINT_HEADER 728
#define REPORT_GENERATE 729
#define REPORT_READ_CDD_AND_READY 730
#define REPORT_CLOSE_CDD 731
#define REPORT_SAVE_CDD 732
#define REPORT_FORMAT_EXCLUSION_REASON 733
#define REPORT_OUTPUT_EXCLUSION_REASON 734
#define COMMAND_REPORT 735
#define SCOPE_FIND_FUNIT_FROM_SCOPE 736
#define SCOPE_FIND_PARAM 737
#define SCOPE_FIND_SIGNAL 738
#define SCOPE_FIND_TASK_FUNCTION_NAMEDBLOCK 739
#define SCOPE_GET_PARENT_FUNIT 740
#define SCOPE_GET_PARENT_MODULE 741
#define SCORE_GENERATE_TOP_VPI_MODULE 742
#define SCORE_GENERATE_TOP_DUMPVARS_MODULE 743
#define SCORE_GENERATE_PLI_TAB_FILE 744
#define SCORE_PARSE_DEFINE 745
#define SCORE_PARSE_ARGS 746
#define COMMAND_SCORE 747
#define SEARCH_INIT 748
#define SEARCH_ADD_INCLUDE_PATH 749
#define SEARCH_ADD_DIRECTORY_PATH 750
#define SEARCH_ADD_FILE 751
#define SEARCH_ADD_NO_SCORE_FUNIT 752
#define SEARCH_ADD_EXTENSIONS 753
#define SEARCH_FREE_LISTS 754
#define SIM_CURRENT_THREAD 755
#define SIM_THREAD_POP_HEAD 756
#define SIM_THREAD_INSERT_INTO_DELAY_QUEUE 757
#define SIM_THREAD_PUSH 758
#define SIM_EXPR_CHANGED 759
#define SIM_CREATE_THREAD 760
#define SIM_ADD_THREAD 761
#define SIM_KILL_THREAD 762
#define SIM_KILL_THREAD_WITH_FUNIT 763
#define SIM_ADD_STATICS 764
#define SIM_EXPRESSION 765
#define SIM_THREAD 766
#define SIM_SIMULATE 767
#define SIM_INITIALIZE 768
#define SIM_STOP 769
#define SIM_FINISH 770
#define SIM_ADD_NONBLOCK_ASSIGN 771
#define SIM_PERFORM_NBA 772
#define SIM_DEALLOC 773
#define STATISTIC_CREATE 774
#define STATISTIC_IS_EMPTY 775
#define STATISTIC_DEALLOC 776
#define STATEMENT_CREATE 777
#define STATEMENT_QUEUE_ADD 778
#define STATEMENT_QUEUE_COMPARE 779
#define STATEMENT_SIZE_ELEMENTS 780
#define STATEMENT_DB_WRITE 781
#define STATEMENT_DB_WRITE_TREE 782
#define STATEMENT_DB_WRITE_EXPR_TREE 783
#define STATEMENT_DB_READ 784
#define STATEMENT_ASSIGN_EXPR_IDS 785
#define STATEMENT_CONNECT 786
#define STATEMENT_GET_LAST_LINE_HELPER 787
#define STATEMENT_GET_LAST_LINE 788
#define STATEMENT_FIND_RHS_SIGS 789
#define STATEMENT_FIND_STATEMENT 790
#define STATEMENT_CONTAINS_EXPR_CALLING_STMT 791
#define STATEMENT_DEALLOC_RECURSIVE 792
#define STATEMENT_DEALLOC 793
#define STATIC_EXPR_GEN_UNARY 794
#define STATIC_EXPR_GEN 795
#define STATIC_EXPR_CALC_LSB_AND_WIDTH_PRE 796
#define STATIC_EXPR_CALC_LSB_AND_WIDTH_POST 797
#define STATIC_EXPR_DEALLOC 798
#define STMT_BLK_ADD_TO_REMOVE_LIST 799
#define STMT_BLK_REMOVE 800
#define STMT_BLK_SPECIFY_REMOVAL_REASON 801
#define STRUCT_UNION_LENGTH 802
#define STRUCT_UNION_ADD_MEMBER 803
#define STRUCT_UNION_ADD_MEMBER_VOID 804
#define STRUCT_UNION_ADD_MEMBER_SIG 805
#define STRUCT_UNION_ADD_MEMBER_TYPEDEF 806
#define STRUCT_UNION_ADD_MEMBER_ENUM 807
#define STRUCT_UNION_ADD_MEMBER_STRUCT_UNION 808
#define STRUCT_UNION_CREATE 809
#define STRUCT_UNION_MEMBER_DEALLOC 810
#define STRUCT_UNION_DEALLOC 811
#define STRUCT_UNION_DEALLOC_LIST 812
#define SYMTABLE_ADD_SYM_SIG 813
#define SYMTABLE_INIT 814
#define SYMTABLE_CREATE 815
#define SYMTABLE_ADD 816
#define SYMTABLE_SET_VALUE 817
#define SYMTABLE_ASSIGN 818
#define SYMTABLE_DEALLOC 819
#define SYS_TASK_UNIFORM 820
#define SYS_TASK_RTL_DIST_UNIFORM 821
#define SYS_TASK_SRANDOM 822
#define SYS_TASK_RANDOM 823
#define SYS_TASK_URANDOM 824
#define SYS_TASK_URANDOM_RANGE 825
#define SYS_TASK_REALTOBITS 826
#define SYS_TASK_BITSTOREAL 827
#define SYS_TASK_SHORTREALTOBITS 828
#define SYS_TASK_BITSTOSHORTREAL 829
#define SYS_TASK_ITOR 830
#define SYS_TASK_RTOI 831
#define SYS_TASK_STORE_PLUSARGS 832
#define SYS_TASK_TEST_PLUSARG 833
#define SYS_TASK_VALUE_PLUSARGS 834
#define SYS_TASK_DEALLOC 835
#define TCL_FUNC_GET_RACE_REASON_MSGS 836
#define TCL_FUNC_GET_FUNIT_LIST 837
#define TCL_FUNC_GET_INSTANCES 838
#define TCL_FUNC_GET_INSTANCE_LIST 839
#define TCL_FUNC_IS_FUNIT 840
#define TCL_FUNC_GET_FUNIT 841
#define TCL_FUNC_GET_INST 842
#define TCL_FUNC_GET_FUNIT_NAME 843
#define TCL_FUNC_GET_FILENAME 844
#define TCL_FUNC_INST_SCOPE 845
#define TCL_FUNC_GET_FUNIT_START_AND_END 846
#define TCL_FUNC_COLLECT_UNCOVERED_LINES 847
#define TCL_FUNC_COLLECT_COVERED_LINES 848
#define TCL_FUNC_COLLECT_RACE_LINES 849
#define TCL_FUNC_COLLECT_UNCOVERED_TOGGLES 850
#define TCL_FUNC_COLLECT_COVERED_TOGGLES 851
#define TCL_FUNC_COLLECT_UNCOVERED_MEMORIES 852
#define TCL_FUNC_COLLECT_COVERED_MEMORIES 853
#define TCL_FUNC_GET_TOGGLE_COVERAGE 854
#define TCL_FUNC_GET_MEMORY_COVERAGE 855
#define TCL_FUNC_COLLECT_UNCOVERED_COMBS 856
#define TCL_FUNC_COLLECT_COVERED_COMBS 857
#define TCL_FUNC_GET_COMB_EXPRESSION 858
#define TCL_FUNC_GET_COMB_COVERAGE 859
#define TCL_FUNC_COLLECT_UNCOVERED_FSMS 860
#define TCL_FUNC_COLLECT_COVERED_FSMS 861
#define TCL_FUNC_GET_FSM_COVERAGE 862
#define TCL_FUNC_COLLECT_UNCOVERED_ASSERTIONS 863
#define TCL_FUNC_COLLECT_COVERED_ASSERTIONS 864
#define TCL_FUNC_GET_ASSERT_COVERAGE 865
#define TCL_FUNC_OPEN_CDD 866
#define TCL_FUNC_CLOSE_CDD 867
#define TCL_FUNC_SAVE_CDD 868
#define TCL_FUNC_MERGE_CDD 869
#define TCL_FUNC_GET_LINE_SUMMARY 870
#define TCL_FUNC_GET_TOGGLE_SUMMARY 871
#define TCL_FUNC_GET_MEMORY_SUMMARY 872
#define TCL_FUNC_GET_COMB_SUMMARY 873
#define TCL_FUNC_GET_FSM_SUMMARY 874
#define TCL_FUNC_GET_ASSERT_SUMMARY 875
#define TCL_FUNC_PREPROCESS_VERILOG 876
#define TCL_FUNC_GET_SCORE_PATH 877
#define TCL_FUNC_GET_INCLUDE_PATHNAME 878
#define TCL_FUNC_GET_GENERATION 879
#define TCL_FUNC_SET_LINE_EXCLUDE 880
#define TCL_FUNC_SET_TOGGLE_EXCLUDE 881
#define TCL_FUNC_SET_MEMORY_EXCLUDE 882
#define TCL_FUNC_SET_COMB_EXCLUDE 883
#define TCL_FUNC_FSM_EXCLUDE 884
#define TCL_FUNC_SET_ASSERT_EXCLUDE 885
#define TCL_FUNC_GENERATE_REPORT 886
#define TCL_FUNC_INITIALIZE 887
#define TOGGLE_GET_STATS 888
#define TOGGLE_COLLECT 889
#define TOGGLE_GET_COVERAGE 890
#define TOGGLE_GET_FUNIT_SUMMARY 891
#define TOGGLE_GET_INST_SUMMARY 892
#define TOGGLE_DISPLAY_INSTANCE_SUMMARY 893
#define TOGGLE_INSTANCE_SUMMARY 894
#define TOGGLE_DISPLAY_FUNIT_SUMMARY 895
#define TOGGLE_FUNIT_SUMMARY 896
#define TOGGLE_DISPLAY_VERBOSE 897
#define TOGGLE_INSTANCE_VERBOSE 898
#define TOGGLE_FUNIT_VERBOSE 899
#define TOGGLE_REPORT 900
#define TREE_ADD 901
#define TREE_FIND 902
#define TREE_REMOVE 903
#define TREE_DEALLOC 904
#define CHECK_OPTION_VALUE 905
#define IS_VARIABLE 906
#define IS_FUNC_UNIT 907
#define IS_LEGAL_FILENAME 908
#define GET_BASENAME 909
#define GET_DIRNAME 910
#define GET_ABSOLUTE_PATH 911
#define GET_RELATIVE_PATH 912
#define DIRECTORY_EXISTS 913
#define DIRECTORY_LOAD 914
#define FILE_EXISTS 915
#define UTIL_READLINE 916
#define GET_QUOTED_STRING 917
#define SUBSTITUTE_ENV_VARS 918
#define SCOPE_EXTRACT_FRONT 919
#define SCOPE_EXTRACT_BACK 920
#define SCOPE_EXTRACT_SCOPE 921
#define SCOPE_GEN_PRINTABLE 922
#define SCOPE_COMPARE 923
#define SCOPE_LOCAL 924
#define CONVERT_FILE_TO_MODULE 925
#define GET_NEXT_VFILE 926
#define GEN_SPACE 927
#define REMOVE_UNDERSCORES 928
#define GET_FUNIT_TYPE 929
#define CALC_MISS_PERCENT 930
#define READ_COMMAND_FILE 931
#define VCD_PARSE_DEF_IGNORE 932
#define VCD_PARSE_DEF_VAR 933
#define VCD_PARSE_DEF_SCOPE 934
#define VCD_PARSE_DEF 935
#define VCD_PARSE_SIM_VECTOR 936
#define VCD_PARSE_SIM_REAL 937
#define VCD_PARSE_SIM_IGNORE 938
#define VCD_PARSE_SIM 939
#define VCD_PARSE 940
#define VECTOR_INIT 941
#define VECTOR_INT_R64 942
#define VECTOR_INT_R32 943
#define VECTOR_CREATE 944
#define VECTOR_COPY 945
#define VECTOR_COPY_RANGE 946
#define VECTOR_CLONE 947
#define VECTOR_DB_WRITE 948
#define VECTOR_DB_READ 949
#define VECTOR_DB_MERGE 950
#define VECTOR_MERGE 951
#define VECTOR_GET_EVAL_A 952
#define VECTOR_GET_EVAL_B 953
#define VECTOR_GET_EVAL_C 954
#define VECTOR_GET_EVAL_D 955
#define VECTOR_GET_EVAL_AB_COUNT 956
#define VECTOR_GET_EVAL_ABC_COUNT 957
#define VECTOR_GET_EVAL_ABCD_COUNT 958
#define VECTOR_GET_TOGGLE01_ULONG 959
#define VECTOR_GET_TOGGLE10_ULONG 960
#define VECTOR_DISPLAY_TOGGLE01_ULONG 961
#define VECTOR_DISPLAY_TOGGLE10_ULONG 962
#define VECTOR_TOGGLE_COUNT 963
#define VECTOR_MEM_RW_COUNT 964
#define VECTOR_SET_ASSIGNED 965
#define VECTOR_SET_COVERAGE_AND_ASSIGN 966
#define VECTOR_GET_SIGN_EXTEND_VECTOR_ULONG 967
#define VECTOR_SIGN_EXTEND_ULONG 968
#define VECTOR_LSHIFT_ULONG 969
#define VECTOR_RSHIFT_ULONG 970
#define VECTOR_SET_VALUE 971
#define VECTOR_PART_SELECT_PULL 972
#define VECTOR_PART_SELECT_PUSH 973
#define VECTOR_SET_UNARY_EVALS 974
#define VECTOR_SET_AND_COMB_EVALS 975
#define VECTOR_SET_OR_COMB_EVALS 976
#define VECTOR_SET_OTHER_COMB_EVALS 977
#define VECTOR_IS_UKNOWN 978
#define VECTOR_IS_NOT_ZERO 979
#define VECTOR_SET_TO_X 980
#define VECTOR_TO_INT 981
#define VECTOR_TO_UINT64 982
#define VECTOR_TO_REAL64 983
#define VECTOR_TO_SIM_TIME 984
#define VECTOR_FROM_INT 985
#define VECTOR_FROM_UINT64 986
#define VECTOR_FROM_REAL64 987
#define VECTOR_SET_STATIC 988
#define VECTOR_TO_STRING 989
#define VECTOR_FROM_STRING_FIXED 990
#define VECTOR_FROM_STRING 991
#define VECTOR_VCD_ASSIGN 992
#define VECTOR_BITWISE_AND_OP 993
#define VECTOR_BITWISE_NAND_OP 994
#define VECTOR_BITWISE_OR_OP 995
#define VECTOR_BITWISE_NOR_OP 996
#define VECTOR_BITWISE_XOR_OP 997
#define VECTOR_BITWISE_NXOR_OP 998
#define VECTOR_OP_LT 999
#define VECTOR_OP_LE 1000
#define VECTOR_OP_GT 1001
#define VECTOR_OP_GE 1002
#define VECTOR_OP_EQ 1003
#define VECTOR_CEQ_ULONG 1004
#define VECTOR_OP_CEQ 1005
#define VECTOR_OP_CXEQ 1006
#define VECTOR_OP_CZEQ 1007
#define VECTOR_OP_NE 1008
#define VECTOR_OP_CNE 1009
#define VECTOR_OP_LOR 1010
#define VECTOR_OP_LAND 1011
#define VECTOR_OP_LSHIFT 1012
#define VECTOR_OP_RSHIFT 1013
#define VECTOR_OP_ARSHIFT 1014
#define VECTOR_OP_ADD 1015
#define VECTOR_OP_NEGATE 1016
#define VECTOR_OP_SUBTRACT 1017
#define VECTOR_OP_MULTIPLY 1018
#define VECTOR_OP_DIVIDE 1019
#define VECTOR_OP_MODULUS 1020
#define VECTOR_OP_INC 1021
#define VECTOR_OP_DEC 1022
#define VECTOR_UNARY_INV 1023
#define VECTOR_UNARY_AND 1024
#define VECTOR_UNARY_NAND 1025
#define VECTOR_UNARY_OR 1026
#define VECTOR_UNARY_NOR 1027
#define VECTOR_UNARY_XOR 1028
#define VECTOR_UNARY_NXOR 1029
#define VECTOR_UNARY_NOT 1030
#define VECTOR_OP_EXPAND 1031
#define VECTOR_OP_LIST 1032
#define VECTOR_OP_CLOG2 1033
#define VECTOR_DEALLOC_VALUE 1034
#define VECTOR_DEALLOC 1035
#define SYM_VALUE_STORE 1036
#define ADD_SYM_VALUES_TO_SIM 1037
#define COVERED_VALUE_CHANGE_BIN 1038
#define COVERED_VALUE_CHANGE_REAL 1039
#define COVERED_END_OF_SIM 1040
#define COVERED_CB_ERROR_HANDLER 1041
#define GEN_NEXT_SYMBOL 1042
#define COVERED_CREATE_VALUE_CHANGE_CB 1043
#define COVERED_PARSE_TASK_FUNC 1044
#define COVERED_PARSE_SIGNALS 1045
#define COVERED_PARSE_INSTANCE 1046
#define COVERED_SIM_CALLTF 1047
#define VSIGNAL_INIT 1048
#define VSIGNAL_CREATE 1049
#define VSIGNAL_CREATE_VEC 1050
#define VSIGNAL_DUPLICATE 1051
#define VSIGNAL_DB_WRITE 1052
#define VSIGNAL_DB_READ 1053
#define VSIGNAL_DB_MERGE 1054
#define VSIGNAL_MERGE 1055
#define VSIGNAL_PROPAGATE 1056
#define VSIGNAL_VCD_ASSIGN 1057
#define VSIGNAL_ADD_EXPRESSION 1058
#define VSIGNAL_FROM_STRING 1059
#define VSIGNAL_CALC_WIDTH_FOR_EXPR 1060
#define VSIGNAL_CALC_LSB_FOR_EXPR 1061
#define VSIGNAL_DEALLOC 1062

extern profiler profiles[NUM_PROFILES];
#endif

extern unsigned int profile_index;

#endif

