
    // by memorybridge/beginptr.f
inline char *MemoryAccess::beginPtr()
{
    return d_data;
}

    // by X
inline size_t MemoryAccess::blockBegin() const
{
    return d_blockBegin;
}

    // by X
inline size_t MemoryAccess::blockEnd() const
{
    return d_blockEnd;
}

    // by memorybridge/endptr.f
inline char *MemoryAccess::endPtr()
{
    return d_data + d_blockSize;
}

    // by memorybridge/endreadptr.f
inline char *MemoryAccess::endReadPtr(size_t offset)
{
    return d_data + std::min(d_blockEnd, d_writtenUntil) - offset;
}

    // by X
inline int MemoryAccess::id() const
{
    return d_id;
}

    // by X
inline size_t MemoryAccess::maxEnd() const
{
    return d_maxEnd;
}

    // by memorybridge/offsetptr.f
inline char *MemoryAccess::offsetPtr(size_t offset)
{
    return d_data + offset - d_blockBegin;
}

    // by memorybridge/lastwritten.f
inline size_t MemoryAccess::writtenUntil() const
{
    return d_writtenUntil;
}

    // by memorybridge/lastwritten.f
inline void MemoryAccess::writtenUntil(size_t offset)
{
    d_writtenUntil = std::max(d_writtenUntil, offset);
}

    // by memorybridge/read.f
inline size_t MemoryAccess::read(char *src, size_t len, size_t offset)
{
    return io(src, len, &memRead, offset);
}



