/*
 * Decompiled with CFR 0.152.
 */
package sleep.parser;

import java.util.LinkedList;
import sleep.parser.Token;

public class StringIterator {
    protected int position = 0;
    protected int lineNo;
    protected char[] text;
    protected String texts;
    protected int begin = 0;
    protected LinkedList mark1 = new LinkedList();
    protected LinkedList mark2 = new LinkedList();

    public StringIterator(String string) {
        this(string, 0);
    }

    public String toString() {
        return this.texts;
    }

    public StringIterator(String string, int n) {
        this.texts = string;
        this.text = string.toCharArray();
        this.lineNo = n;
    }

    public boolean hasNext() {
        return this.position < this.text.length;
    }

    public boolean hasNext(int n) {
        return this.position + n - 1 < this.text.length;
    }

    public int getLineNumber() {
        return this.lineNo;
    }

    public Token getErrorToken() {
        return new Token(this.getEntireLine(), this.getLineNumber(), this.getLineMarker());
    }

    public String getEntireLine() {
        int n;
        for (n = this.position; n < this.text.length && this.text[n] != '\n'; ++n) {
        }
        return this.texts.substring(this.begin, n);
    }

    public int getLineMarker() {
        return this.position - this.begin;
    }

    public boolean isNextString(String string) {
        return this.position + string.length() <= this.text.length && this.texts.substring(this.position, this.position + string.length()).equals(string);
    }

    public boolean isNextChar(char c) {
        return this.hasNext() && this.text[this.position] == c;
    }

    public char peek() {
        return this.hasNext() ? this.text[this.position] : (char)'\u0000';
    }

    public void skip(int n) {
        this.position += n;
    }

    public String next(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.next());
        }
        return stringBuffer.toString();
    }

    public char next() {
        char c = this.text[this.position];
        if (this.position > 0 && this.text[this.position - 1] == '\n') {
            ++this.lineNo;
            this.begin = this.position;
        }
        ++this.position;
        return c;
    }

    public void mark() {
        this.mark1.add(0, new Integer(this.position));
        this.mark2.add(0, new Integer(this.lineNo));
    }

    public String reset() {
        Integer n = (Integer)this.mark1.removeFirst();
        Integer n2 = (Integer)this.mark2.removeFirst();
        return this.texts.substring(n, this.position);
    }

    public static void main(String[] stringArray) {
        StringIterator stringIterator = new StringIterator(stringArray[0]);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringIterator.hasNext()) {
            char c = stringIterator.next();
            stringBuffer.append(c);
            if (c != '\n') continue;
            System.out.print(stringIterator.getLineNumber() + ": " + stringBuffer.toString());
            stringBuffer = new StringBuffer();
        }
    }
}

